/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.components;

import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.view.ProfilingView;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingMainComponent;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.ByteArrayWrapper;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.view.components.HeapAggregatesView;
import com.jetbrains.nodejs.run.profile.heap.view.components.HeapViewCreatorPartner;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapBiggestObjectsView;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapContainmentView;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapTreeTable;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8MainTreeNavigator;
import java.awt.Component;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8HeapComponentPartner
implements HeapViewCreatorPartner<V8HeapTreeTable> {
    private final V8CachingReader myReader;
    @Nls
    private final String myName;
    private V8ProfilingMainComponent.MyController myController;
    private V8MainTreeNavigator myMainTreeNavigator;

    public V8HeapComponentPartner(V8CachingReader reader, @Nls String name) {
        this.myReader = reader;
        this.myName = name;
    }

    @Override
    public JComponent wrapWithStandardActions(ProfilingView<V8HeapTreeTable> view, AnAction closeAction) {
        Component[] components;
        DefaultActionGroup group = new DefaultActionGroup();
        view.addActions(group);
        ContextHelpAction helpAction = new ContextHelpAction("reference.tool.window.v8.heap");
        group.add((AnAction)helpAction);
        JComponent component = view.getMainComponent();
        for (Component component1 : components = component.getComponents()) {
            helpAction.registerCustomShortcutSet(CommonShortcuts.getContextHelp(), (JComponent)component1);
        }
        group.add(closeAction);
        return V8Utils.wrapWithActions(view.getMainComponent(), group);
    }

    @Override
    public void addViews(Project project, List<ProfilingView<V8HeapTreeTable>> list, Disposable disposable) {
        final V8HeapContainmentView containmentView = new V8HeapContainmentView(project, this.myReader, this.myName, disposable);
        final V8MainTreeNavigator navigator = containmentView.getTableWithRetainers().getMainTreeNavigator();
        list.add(containmentView);
        this.myMainTreeNavigator = new V8MainTreeNavigator(){

            @Override
            public boolean navigateTo(@NotNull TreePath path) {
                if (path == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (navigator.navigateTo(path)) {
                    V8HeapComponentPartner.this.myController.showTab(containmentView.getName());
                    return true;
                }
                return false;
            }

            @Override
            public boolean navigateTo(@NotNull V8HeapEntry node, @Nullable V8HeapEdge edgeToNode) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (navigator.navigateTo(node, edgeToNode)) {
                    V8HeapComponentPartner.this.myController.showTab(containmentView.getName());
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "node";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/nodejs/run/profile/heap/view/components/V8HeapComponentPartner$1";
                objectArray[2] = "navigateTo";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        list.add(new V8HeapBiggestObjectsView(project, this.myReader, this.myMainTreeNavigator, disposable));
        list.add(new HeapAggregatesView(project, this.myReader, this.myMainTreeNavigator, disposable));
    }

    @Override
    @Nullable
    public V8MainTreeNavigator getNavigator() {
        return this.myMainTreeNavigator;
    }

    @Override
    public void reportInvolvedSnapshots(@NotNull Consumer<ByteArrayWrapper> digestConsumer) {
        if (digestConsumer == null) {
            V8HeapComponentPartner.$$$reportNull$$$0(0);
        }
        digestConsumer.consume((Object)this.myReader.getDigest());
    }

    @Override
    public String errorCreated() {
        return null;
    }

    @Override
    public void announceController(V8ProfilingMainComponent.MyController controller) {
        this.myController = controller;
    }

    @Override
    public void close() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.myReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "digestConsumer", "com/jetbrains/nodejs/run/profile/heap/view/components/V8HeapComponentPartner", "reportInvolvedSnapshots"));
    }
}

