/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.util;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.fileChooser.ex.FileTextFieldImpl;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import java.io.File;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RelativePathUIUtil {
    public static TextFieldWithBrowseButton createRelativePathTextFieldAndTrackBaseDirChanges(@NotNull Project project, final @NotNull FileChooserDescriptor descriptor, @NotNull Document baseDirDocument) {
        if (project == null) {
            RelativePathUIUtil.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            RelativePathUIUtil.$$$reportNull$$$0(1);
        }
        if (baseDirDocument == null) {
            RelativePathUIUtil.$$$reportNull$$$0(2);
        }
        final Ref doneRef = Ref.create((Object)false);
        RelativePathTextField relativePathTextField = new RelativePathTextField();
        TextFieldWithBrowseButton relativePath = new TextFieldWithBrowseButton(relativePathTextField){

            protected void installPathCompletion(FileChooserDescriptor fileChooserDescriptor) {
                if (!((Boolean)doneRef.get()).booleanValue()) {
                    super.installPathCompletion(descriptor);
                    doneRef.set((Object)true);
                }
            }
        };
        RelativePathUIUtil.trackBaseDirChanges(relativePath, baseDirDocument);
        return relativePath;
    }

    private static void trackBaseDirChanges(final @NotNull TextFieldWithBrowseButton textFieldWithBrowseButton, final @NotNull Document baseDirDocument) {
        if (textFieldWithBrowseButton == null) {
            RelativePathUIUtil.$$$reportNull$$$0(3);
        }
        if (baseDirDocument == null) {
            RelativePathUIUtil.$$$reportNull$$$0(4);
        }
        final Ref oldBaseDirRef = Ref.create((Object)RelativePathUIUtil.getText(baseDirDocument));
        RelativePathUIUtil.updatePathCompletion(textFieldWithBrowseButton, RelativePathUIUtil.getText(baseDirDocument));
        baseDirDocument.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                String newText;
                String oldText;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!(oldText = StringUtil.notNullize((String)((String)oldBaseDirRef.get()))).equals(newText = StringUtil.notNullize((String)RelativePathUIUtil.getText(baseDirDocument)))) {
                    RelativePathUIUtil.updatePathCompletion(textFieldWithBrowseButton, newText);
                    oldBaseDirRef.set((Object)newText);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/nodejs/util/RelativePathUIUtil$2", "textChanged"));
            }
        });
    }

    @NotNull
    private static String getText(@NotNull Document document) {
        String string;
        if (document == null) {
            RelativePathUIUtil.$$$reportNull$$$0(5);
        }
        try {
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException e) {
            return "";
        }
        if (string == null) {
            RelativePathUIUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static void updatePathCompletion(@NotNull TextFieldWithBrowseButton textFieldWithBrowseButton, @NotNull String baseDirPath) {
        FileTextFieldImpl fileTextField;
        FileLookup.Finder finder;
        if (textFieldWithBrowseButton == null) {
            RelativePathUIUtil.$$$reportNull$$$0(7);
        }
        if (baseDirPath == null) {
            RelativePathUIUtil.$$$reportNull$$$0(8);
        }
        JTextField textField = textFieldWithBrowseButton.getTextField();
        File baseDir = new File(baseDirPath);
        if (textField instanceof RelativePathTextField) {
            RelativePathTextField relativePathTextField = (RelativePathTextField)textField;
            relativePathTextField.setBaseDir(baseDir);
        }
        if ((finder = (fileTextField = (FileTextFieldImpl)textField.getClientProperty("fileTextField")).getFinder()) instanceof LocalFsFinder) {
            LocalFsFinder localFsFinder = (LocalFsFinder)finder;
            localFsFinder.setBaseDir(baseDir);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirDocument";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textFieldWithBrowseButton";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/util/RelativePathUIUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/util/RelativePathUIUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRelativePathTextFieldAndTrackBaseDirChanges";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "trackBaseDirChanges";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updatePathCompletion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    private static final class RelativePathTextField
    extends JTextField {
        private File myBaseDir;

        private RelativePathTextField() {
            super(10);
        }

        private void setBaseDir(@NotNull File baseDir) {
            if (baseDir == null) {
                RelativePathTextField.$$$reportNull$$$0(0);
            }
            this.myBaseDir = baseDir;
        }

        @Override
        public void setText(String text) {
            String refinedText = this.refineText(text);
            super.setText(refinedText);
        }

        @NotNull
        private String refineText(@Nullable String path) {
            String relativePath;
            boolean inside;
            if (path == null || path.trim().isEmpty()) {
                String string = StringUtil.notNullize((String)path);
                if (string == null) {
                    RelativePathTextField.$$$reportNull$$$0(1);
                }
                return string;
            }
            File file = new File(path);
            if (file.isAbsolute() && this.myBaseDir != null && this.myBaseDir.isDirectory() && (inside = FileUtil.isAncestor((File)this.myBaseDir, (File)file, (boolean)true)) && (relativePath = FileUtil.getRelativePath((File)this.myBaseDir, (File)file)) != null) {
                String string = relativePath;
                if (string == null) {
                    RelativePathTextField.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = path;
            if (string == null) {
                RelativePathTextField.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseDir";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/nodejs/util/RelativePathUIUtil$RelativePathTextField";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/nodejs/util/RelativePathUIUtil$RelativePathTextField";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "refineText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setBaseDir";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

