/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.find;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.editor.find.NotebookUsagesContributor;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c1\n\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J9\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b2\u001c\u0010\u0015\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0016j\u0002`\u00172\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u000eH\u00d6\u0001R>\u0010\u0004\u001a2\u0012\u0004\u0012\u00020\u0006\u0012(\u0012&\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b0\u0007j\u0002`\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/find/NotebookUsagesContributorFactory;", "Lcom/intellij/kotlin/jupyter/core/editor/find/NotebookUsagesContributor;", "<init>", "()V", "searchPatternSolutions", "", "Lcom/intellij/kotlin/jupyter/core/editor/find/NotebookUsagesContributorFactory$SearchPattern;", "Lkotlin/Function3;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/psi/PsiElement;", "", "", "Lcom/intellij/kotlin/jupyter/core/editor/find/UsageSearchSupplier;", "DATAFRAME_PREFIX", "", "isFromDataFrameLibInternals", "element", "extractNotebookFileFromScope", "scope", "Lcom/intellij/psi/search/SearchScope;", "invokeElementUsagesContributor", "targetElementInfo", "Lkotlin/Triple;", "Lcom/intellij/kotlin/jupyter/core/editor/find/TargetElementInfo;", "(Lkotlin/Triple;Lcom/intellij/psi/search/SearchScope;)[Lcom/intellij/psi/PsiElement;", "equals", "other", "", "hashCode", "", "toString", "SearchPattern", "intellij.kotlin.jupyter.core"})
@ApiStatus.Experimental
public final class NotebookUsagesContributorFactory
extends NotebookUsagesContributor {
    @NotNull
    public static final NotebookUsagesContributorFactory INSTANCE = new NotebookUsagesContributorFactory();
    @NotNull
    private static final Map<SearchPattern, Function3<VirtualFile, PsiElement, Boolean, PsiElement[]>> searchPatternSolutions;
    @NotNull
    public static final String DATAFRAME_PREFIX = ".kotlinx.dataframe.";

    private NotebookUsagesContributorFactory() {
        super(null);
    }

    private final boolean isFromDataFrameLibInternals(PsiElement element) {
        boolean bl;
        String string = element.getText();
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            bl = StringsKt.contains$default((CharSequence)it, (CharSequence)DATAFRAME_PREFIX, (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)it, (CharSequence)".kotlinx.dataframe.DataFrame", (boolean)false, (int)2, null);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final VirtualFile extractNotebookFileFromScope(PsiElement element, SearchScope scope) {
        Object object;
        VirtualFile scopeFile;
        Object[] objectArray = scope instanceof LocalSearchScope ? (Object[])scope : null;
        VirtualFile virtualFile = objectArray != null && (objectArray = objectArray.getVirtualFiles()) != null ? (VirtualFile)ArraysKt.firstOrNull((Object[])objectArray) : (scopeFile = null);
        if (scopeFile instanceof VirtualFileWindow) {
            object = ((VirtualFileWindow)scopeFile).getDelegate();
        } else if (element.getContainingFile().getVirtualFile() instanceof VirtualFileWindow) {
            VirtualFile virtualFile2 = element.getContainingFile().getVirtualFile();
            VirtualFileWindow virtualFileWindow = virtualFile2 instanceof VirtualFileWindow ? (VirtualFileWindow)virtualFile2 : null;
            object = virtualFileWindow != null ? virtualFileWindow.getDelegate() : null;
        } else {
            void var3_3;
            object = var3_3;
        }
        return object;
    }

    @Nullable
    public final PsiElement[] invokeElementUsagesContributor(@NotNull Triple<? extends PsiElement, Boolean, Boolean> targetElementInfo, @NotNull SearchScope scope) {
        Intrinsics.checkNotNullParameter(targetElementInfo, (String)"targetElementInfo");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        PsiElement element = (PsiElement)targetElementInfo.component1();
        boolean isFromCompiledCellClass = (Boolean)targetElementInfo.component2();
        boolean isFromByteCode = (Boolean)targetElementInfo.component3();
        VirtualFile virtualFile = this.extractNotebookFileFromScope(element, scope);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile notebookFile = virtualFile;
        if (!BackedNotebookVirtualFile.Companion.isBacked(notebookFile) || !IsKotlinNotebookKt.isKotlinNotebook(notebookFile)) {
            return null;
        }
        boolean isFromDSLibs = this.isFromDataFrameLibInternals(element);
        SearchPattern properKey = isFromDSLibs || isFromByteCode ? SearchPattern.ProvidedLibrariesOrJVMDeclaration : (isFromCompiledCellClass ? SearchPattern.CompiledCellClass : SearchPattern.Sources);
        Function3<VirtualFile, PsiElement, Boolean, PsiElement[]> function3 = searchPatternSolutions.get((Object)properKey);
        return function3 != null ? (PsiElement[])function3.invoke((Object)notebookFile, (Object)element, (Object)isFromDSLibs) : null;
    }

    @NotNull
    public String toString() {
        return "NotebookUsagesContributorFactory";
    }

    public int hashCode() {
        return 803729595;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NotebookUsagesContributorFactory)) {
            return false;
        }
        NotebookUsagesContributorFactory cfr_ignored_0 = (NotebookUsagesContributorFactory)other;
        return true;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)SearchPattern.Sources), (Object)new Function3<VirtualFile, PsiElement, Boolean, PsiElement[]>((Object)INSTANCE){

            public final PsiElement[] invoke(VirtualFile p0, PsiElement p1, boolean p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((NotebookUsagesContributorFactory)this.receiver).searchInSourcesScope(p0, p1, p2);
            }
        }), TuplesKt.to((Object)((Object)SearchPattern.CompiledCellClass), (Object)new Function3<VirtualFile, PsiElement, Boolean, PsiElement[]>((Object)INSTANCE){

            public final PsiElement[] invoke(VirtualFile p0, PsiElement p1, boolean p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((NotebookUsagesContributorFactory)this.receiver).searchWithCompiledCellScope(p0, p1, p2);
            }
        }), TuplesKt.to((Object)((Object)SearchPattern.ProvidedLibrariesOrJVMDeclaration), (Object)new Function3<VirtualFile, PsiElement, Boolean, PsiElement[]>((Object)INSTANCE){

            public final PsiElement[] invoke(VirtualFile p0, PsiElement p1, boolean p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((NotebookUsagesContributorFactory)this.receiver).searchProvidedLibrariesUsagesInNotebook(p0, p1, p2);
            }
        })};
        searchPatternSolutions = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/find/NotebookUsagesContributorFactory$SearchPattern;", "", "<init>", "(Ljava/lang/String;I)V", "Sources", "CompiledCellClass", "ProvidedLibrariesOrJVMDeclaration", "intellij.kotlin.jupyter.core"})
    public static final class SearchPattern
    extends Enum<SearchPattern> {
        public static final /* enum */ SearchPattern Sources = new SearchPattern();
        public static final /* enum */ SearchPattern CompiledCellClass = new SearchPattern();
        public static final /* enum */ SearchPattern ProvidedLibrariesOrJVMDeclaration = new SearchPattern();
        private static final /* synthetic */ SearchPattern[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SearchPattern[] values() {
            return (SearchPattern[])$VALUES.clone();
        }

        public static SearchPattern valueOf(String value) {
            return Enum.valueOf(SearchPattern.class, value);
        }

        @NotNull
        public static EnumEntries<SearchPattern> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = searchPatternArray = new SearchPattern[]{SearchPattern.Sources, SearchPattern.CompiledCellClass, SearchPattern.ProvidedLibrariesOrJVMDeclaration};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

