/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.util;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.helper.NotebookLanguageMatcher;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.kotlin.jupyter.core.scriptingSupport.JupyterCompilerService;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0015\u001a\u00020\t*\u0004\u0018\u00010\u0016H\u0000\u001a\u0010\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001\u001a\n\u0010\u001c\u001a\u00020\t*\u00020\u001d\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0002\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0004\u0010\u0005\"\u0017\u0010\b\u001a\u00020\t*\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\"\u0015\u0010\b\u001a\u00020\t*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\r\"\u0015\u0010\b\u001a\u00020\t*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000f\"\u0015\u0010\b\u001a\u00020\t*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0011\"\u0015\u0010\u0012\u001a\u00020\t*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\"\u0015\u0010\u0017\u001a\u00020\t*\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"\u0015\u0010\u0019\u001a\u00020\t*\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018\u00a8\u0006\u001e"}, d2={"DEFAULT_KOTLIN_KERNEL_NAME", "", "kotlinMatcher", "Lcom/intellij/jupyter/core/jupyter/helper/NotebookLanguageMatcher;", "getKotlinMatcher", "()Lcom/intellij/jupyter/core/jupyter/helper/NotebookLanguageMatcher;", "kotlinMatcher$delegate", "Lkotlin/Lazy;", "isKotlinNotebook", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)Z", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "(Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)Z", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)Z", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "(Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;)Z", "isInsideKotlinNotebook", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)Z", "isInsideKotlinNotebookFile", "Lcom/intellij/psi/PsiElement;", "isInsideKotlinNotebookCodeCell", "(Lcom/intellij/psi/PsiElement;)Z", "isKotlinNotebookCodeCell", "isKotlinKernelName", "kernelName", "isKotlinNotebookSession", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;", "intellij.kotlin.jupyter.core"})
public final class IsKotlinNotebookKt {
    @NotNull
    public static final String DEFAULT_KOTLIN_KERNEL_NAME = "kotlin";
    @NotNull
    private static final Lazy kotlinMatcher$delegate = LazyKt.lazy(IsKotlinNotebookKt::kotlinMatcher_delegate$lambda$0);

    private static final NotebookLanguageMatcher getKotlinMatcher() {
        Lazy lazy = kotlinMatcher$delegate;
        return (NotebookLanguageMatcher)lazy.getValue();
    }

    public static final boolean isKotlinNotebook(@Nullable VirtualFile $this$isKotlinNotebook) {
        return IsKotlinNotebookKt.getKotlinMatcher().matches($this$isKotlinNotebook);
    }

    public static final boolean isKotlinNotebook(@NotNull BackedNotebookVirtualFile $this$isKotlinNotebook) {
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinNotebook, (String)"<this>");
        return IsKotlinNotebookKt.getKotlinMatcher().matches($this$isKotlinNotebook);
    }

    public static final boolean isKotlinNotebook(@NotNull Editor $this$isKotlinNotebook) {
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinNotebook, (String)"<this>");
        return IsKotlinNotebookKt.getKotlinMatcher().matches($this$isKotlinNotebook);
    }

    public static final boolean isKotlinNotebook(@NotNull JupyterNotebook $this$isKotlinNotebook) {
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinNotebook, (String)"<this>");
        return IsKotlinNotebookKt.getKotlinMatcher().matches($this$isKotlinNotebook);
    }

    public static final boolean isInsideKotlinNotebook(@NotNull KtFile $this$isInsideKotlinNotebook) {
        Intrinsics.checkNotNullParameter((Object)$this$isInsideKotlinNotebook, (String)"<this>");
        VirtualFile virtualFile = $this$isInsideKotlinNotebook.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile vFile = virtualFile;
        if (!(vFile instanceof VirtualFileWindow)) {
            return false;
        }
        return IsKotlinNotebookKt.isKotlinNotebook(((VirtualFileWindow)vFile).getDelegate());
    }

    public static final boolean isInsideKotlinNotebookFile(@Nullable PsiElement $this$isInsideKotlinNotebookFile) {
        VirtualFile virtualFile;
        VirtualFile containingFile;
        PsiElement psiElement = $this$isInsideKotlinNotebookFile;
        VirtualFile virtualFile2 = psiElement != null && (psiElement = psiElement.getContainingFile()) != null ? psiElement.getVirtualFile() : (containingFile = null);
        if (containingFile instanceof VirtualFileWindow) {
            virtualFile = ((VirtualFileWindow)containingFile).getDelegate();
        } else {
            virtualFile = containingFile;
            if (virtualFile == null) {
                virtualFile = null;
            }
        }
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile3 = virtualFile;
        return IsKotlinNotebookKt.isKotlinNotebook(virtualFile3);
    }

    public static final boolean isInsideKotlinNotebookCodeCell(@NotNull PsiElement $this$isInsideKotlinNotebookCodeCell) {
        Intrinsics.checkNotNullParameter((Object)$this$isInsideKotlinNotebookCodeCell, (String)"<this>");
        PsiFile psiFile = $this$isInsideKotlinNotebookCodeCell.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        return IsKotlinNotebookKt.isKotlinNotebookCodeCell((PsiElement)psiFile);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKotlinNotebookCodeCell(@NotNull PsiElement $this$isKotlinNotebookCodeCell) {
        VirtualFile myVirtualFile;
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinNotebookCodeCell, (String)"<this>");
        if (!($this$isKotlinNotebookCodeCell instanceof KtFile)) return false;
        if (!((KtFile)$this$isKotlinNotebookCodeCell).isScript()) {
            return false;
        }
        VirtualFile virtualFile = ((KtFile)$this$isKotlinNotebookCodeCell).getVirtualFile();
        if (virtualFile == null) {
            virtualFile = ((KtFile)$this$isKotlinNotebookCodeCell).getOriginalFile().getVirtualFile();
        }
        if ((myVirtualFile = virtualFile) != null && !(myVirtualFile instanceof VirtualFileWindow)) {
            if (!(myVirtualFile instanceof LightVirtualFile)) return false;
        }
        String string = ((KtFile)$this$isKotlinNotebookCodeCell).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Project project = ((KtFile)$this$isKotlinNotebookCodeCell).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!StringsKt.endsWith$default((String)string, (String)JupyterCompilerService.Companion.getInstance(project).getFileSuffix(), (boolean)false, (int)2, null)) return false;
        return true;
    }

    public static final boolean isKotlinKernelName(@Nullable String kernelName) {
        String string = kernelName;
        return Intrinsics.areEqual((Object)(string != null ? CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)string) : null), (Object)DEFAULT_KOTLIN_KERNEL_NAME);
    }

    public static final boolean isKotlinNotebookSession(@NotNull JupyterNotebookSession $this$isKotlinNotebookSession) {
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinNotebookSession, (String)"<this>");
        return IsKotlinNotebookKt.isKotlinKernelName($this$isKotlinNotebookSession.getKernelName());
    }

    private static final NotebookLanguageMatcher kotlinMatcher_delegate$lambda$0() {
        KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinLanguage, (String)"INSTANCE");
        return new NotebookLanguageMatcher((Language)kotlinLanguage);
    }
}

