/*
 * Decompiled with CFR 0.152.
 */
package jupyter.kotlin;

import java.io.File;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007J\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J\u001a\u0010\u0004\u001a\u00020\u00052\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\u0004\u001a\u00020\u00052\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\u0004\u001a\u00020\u00052\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\u0004\u001a\u00020\u00052\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u00020\u00052\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000b\u001a\u00020\u0007J\"\u0010\n\u001a\u00020\u00052\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tJ\"\u0010\n\u001a\u00020\u00052\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J\u001a\u0010\n\u001a\u00020\u00052\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u000b\u001a\u00020\u0007J\"\u0010\n\u001a\u00020\u00052\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tJ\"\u0010\n\u001a\u00020\u00052\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0002J$\u0010\u0012\u001a\u00020\u00052\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J$\u0010\u0012\u001a\u00020\u00052\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Ljupyter/kotlin/Native;", "", "<init>", "()V", "load", "", "filename", "", "file", "Ljava/io/File;", "loadLibrary", "name", "path", "kClass", "Lkotlin/reflect/KClass;", "javaClass", "Ljava/lang/Class;", "toAbsolutePath", "load0", "isAbsolute", "", "lib"})
public final class Native {
    @NotNull
    public static final Native INSTANCE = new Native();

    private Native() {
    }

    public final void load(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        System.load(filename);
    }

    public final void load(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        System.load(file.getAbsolutePath());
    }

    public final void loadLibrary(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        System.loadLibrary(name);
    }

    public final void loadLibrary(@NotNull String name, @NotNull File path2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.load(this.toAbsolutePath(name, path2));
    }

    public final void loadLibrary(@NotNull String name, @NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.loadLibrary(name, new File(path2));
    }

    public final void load(@NotNull KClass<?> kClass, @NotNull String filename) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.load0(kClass, filename, true);
    }

    public final void load(@NotNull KClass<?> kClass, @NotNull File file) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        this.load0(kClass, string, true);
    }

    public final void load(@NotNull Class<?> javaClass, @NotNull String filename) {
        Intrinsics.checkNotNullParameter(javaClass, (String)"javaClass");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.load0(javaClass, filename, true);
    }

    public final void load(@NotNull Class<?> javaClass, @NotNull File file) {
        Intrinsics.checkNotNullParameter(javaClass, (String)"javaClass");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        this.load0(javaClass, string, true);
    }

    public final void loadLibrary(@NotNull KClass<?> kClass, @NotNull String name) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.load0(kClass, name, false);
    }

    public final void loadLibrary(@NotNull KClass<?> kClass, @NotNull String name, @NotNull File path2) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String string = this.toAbsolutePath(name, path2).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        this.load0(kClass, string, true);
    }

    public final void loadLibrary(@NotNull KClass<?> kClass, @NotNull String name, @NotNull String path2) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.loadLibrary(kClass, name, new File(path2));
    }

    public final void loadLibrary(@NotNull Class<?> javaClass, @NotNull String name) {
        Intrinsics.checkNotNullParameter(javaClass, (String)"javaClass");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.load0(javaClass, name, false);
    }

    public final void loadLibrary(@NotNull Class<?> javaClass, @NotNull String name, @NotNull File path2) {
        Intrinsics.checkNotNullParameter(javaClass, (String)"javaClass");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String string = this.toAbsolutePath(name, path2).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        this.load0(javaClass, string, true);
    }

    public final void loadLibrary(@NotNull Class<?> javaClass, @NotNull String name, @NotNull String path2) {
        Intrinsics.checkNotNullParameter(javaClass, (String)"javaClass");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.loadLibrary(javaClass, name, new File(path2));
    }

    private final File toAbsolutePath(String name, File path2) {
        String relativeFilename = System.mapLibraryName(name);
        Intrinsics.checkNotNull((Object)relativeFilename);
        return FilesKt.resolve((File)path2, (String)relativeFilename);
    }

    private final void load0(KClass<?> kClass, String name, boolean isAbsolute) {
        this.load0(JvmClassMappingKt.getJavaClass(kClass), name, isAbsolute);
    }

    private final void load0(Class<?> javaClass, String name, boolean isAbsolute) {
        Class<ClassLoader> clazz = ClassLoader.class;
        Object[] objectArray = new Class[]{Class.class, String.class, Boolean.TYPE};
        Method method = clazz.getDeclaredMethod("loadLibrary", (Class<?>[])objectArray);
        method.setAccessible(true);
        objectArray = new Object[]{javaClass, name, isAbsolute};
        method.invoke(null, objectArray);
    }
}

