/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.util;

import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.libraries.VariablesSubstitutionAware;
import org.jetbrains.kotlinx.jupyter.util.FlagAcceptanceRule;
import org.jetbrains.kotlinx.jupyter.util.LibraryProcessingKt;
import org.jetbrains.kotlinx.jupyter.util.PatternNameAcceptanceRuleSerializer;

@Serializable(with=PatternNameAcceptanceRuleSerializer.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00192\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u00012\b\u0012\u0004\u0012\u00020\u00000\u0004:\u0001\u0019B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u0014\u001a\u00020\u00062\n\u0010\u0015\u001a\u00060\u0002j\u0002`\u0003H\u0016J\u001c\u0010\u0016\u001a\u00020\u00002\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0018H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlinx/jupyter/util/PatternNameAcceptanceRule;", "Lorg/jetbrains/kotlinx/jupyter/util/FlagAcceptanceRule;", "", "Lorg/jetbrains/kotlinx/jupyter/api/TypeName;", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/VariablesSubstitutionAware;", "acceptsFlag", "", "pattern", "<init>", "(ZLjava/lang/String;)V", "getAcceptsFlag", "()Z", "getPattern", "()Ljava/lang/String;", "regex", "Lkotlin/text/Regex;", "getRegex", "()Lkotlin/text/Regex;", "regex$delegate", "Lkotlin/Lazy;", "appliesTo", "obj", "replaceVariables", "mapping", "", "Companion", "api"})
public final class PatternNameAcceptanceRule
implements FlagAcceptanceRule<String>,
VariablesSubstitutionAware<PatternNameAcceptanceRule> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean acceptsFlag;
    @NotNull
    private final String pattern;
    @NotNull
    private final Lazy regex$delegate;

    public PatternNameAcceptanceRule(boolean acceptsFlag, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.acceptsFlag = acceptsFlag;
        this.pattern = pattern;
        this.regex$delegate = LazyKt.lazy(() -> PatternNameAcceptanceRule.regex_delegate$lambda$0(this));
    }

    @Override
    public boolean getAcceptsFlag() {
        return this.acceptsFlag;
    }

    @NotNull
    public final String getPattern() {
        return this.pattern;
    }

    private final Regex getRegex() {
        Lazy lazy = this.regex$delegate;
        return (Regex)lazy.getValue();
    }

    @Override
    public boolean appliesTo(@NotNull String obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return this.getRegex().matches((CharSequence)obj);
    }

    @Override
    @NotNull
    public PatternNameAcceptanceRule replaceVariables(@NotNull Map<String, String> mapping) {
        Intrinsics.checkNotNullParameter(mapping, (String)"mapping");
        String newPattern = LibraryProcessingKt.replaceVariables(this.pattern, mapping);
        if (Intrinsics.areEqual((Object)this.pattern, (Object)newPattern)) {
            return this;
        }
        return new PatternNameAcceptanceRule(this.getAcceptsFlag(), newPattern);
    }

    private static final Regex regex_delegate$lambda$0(PatternNameAcceptanceRule this$0) {
        CharSequence charSequence;
        StringBuilder $this$regex_delegate_u24lambda_u240_u240 = charSequence = new StringBuilder();
        boolean bl = false;
        block6: for (int i = 0; i < this$0.pattern.length(); ++i) {
            char c = this$0.pattern.charAt(i);
            Character nextC = StringsKt.getOrNull((CharSequence)this$0.pattern, (int)(i + 1));
            switch (c) {
                case '.': {
                    Comparable<StringBuilder> comparable = $this$regex_delegate_u24lambda_u240_u240.append("\\.");
                    continue block6;
                }
                case '*': {
                    Comparable<StringBuilder> comparable;
                    Character c2 = nextC;
                    char c3 = '*';
                    if (c2 != null && c2.charValue() == c3) {
                        $this$regex_delegate_u24lambda_u240_u240.append(".*");
                        comparable = ++i;
                        continue block6;
                    }
                    comparable = $this$regex_delegate_u24lambda_u240_u240.append("[^.]*");
                    continue block6;
                }
                case '?': {
                    Comparable<StringBuilder> comparable = $this$regex_delegate_u24lambda_u240_u240.append(".?");
                    continue block6;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    $this$regex_delegate_u24lambda_u240_u240.append('\\');
                    Comparable<StringBuilder> comparable = $this$regex_delegate_u24lambda_u240_u240.append(c);
                    continue block6;
                }
                default: {
                    Comparable<StringBuilder> comparable = $this$regex_delegate_u24lambda_u240_u240.append(c);
                }
            }
        }
        charSequence = charSequence.toString();
        return new Regex((String)charSequence);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlinx/jupyter/util/PatternNameAcceptanceRule$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/jetbrains/kotlinx/jupyter/util/PatternNameAcceptanceRule;", "api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<PatternNameAcceptanceRule> serializer() {
            return PatternNameAcceptanceRuleSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

