/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.psi.PsiClass;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.Direction;
import com.intellij.spring.contexts.model.ModelTraverse;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.ExplicitRedefinitionAwareBeansCollector;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringModelSearchers {
    @NotNull
    public static List<SpringBeanPointer<?>> findBeans(@NotNull CommonSpringModel model, @NotNull SpringModelSearchParameters.BeanClass parameters) {
        if (model == null) {
            SpringModelSearchers.$$$reportNull$$$0(0);
        }
        if (parameters == null) {
            SpringModelSearchers.$$$reportNull$$$0(1);
        }
        if (!parameters.canSearch()) {
            List<SpringBeanPointer<?>> list = Collections.emptyList();
            if (list == null) {
                SpringModelSearchers.$$$reportNull$$$0(2);
            }
            return list;
        }
        ExplicitRedefinitionAwareBeansCollector processor = new ExplicitRedefinitionAwareBeansCollector();
        ModelTraverse.traverseModel(model, true, m -> m.traverseByClass(parameters, processor));
        List<SpringBeanPointer<?>> list = List.copyOf(processor.getResult());
        if (list == null) {
            SpringModelSearchers.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public static SpringBeanPointer<?> findBean(@NotNull CommonSpringModel model, @NotNull String beanName) {
        if (model == null) {
            SpringModelSearchers.$$$reportNull$$$0(4);
        }
        if (beanName == null) {
            SpringModelSearchers.$$$reportNull$$$0(5);
        }
        CommonProcessors.FindFirstProcessor findFirstProcessor = new CommonProcessors.FindFirstProcessor();
        SpringModelSearchParameters.BeanName parameters = SpringModelSearchParameters.byName(beanName);
        ModelTraverse.traverseModel(model, true, m -> m.traverseByName(parameters, (Processor<? super SpringBeanPointer<?>>)findFirstProcessor));
        return (SpringBeanPointer)findFirstProcessor.getFoundValue();
    }

    @NotNull
    public static Collection<SpringBeanPointer<?>> findBeans(@NotNull CommonSpringModel model, @NotNull String beanName) {
        if (model == null) {
            SpringModelSearchers.$$$reportNull$$$0(6);
        }
        if (beanName == null) {
            SpringModelSearchers.$$$reportNull$$$0(7);
        }
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        SpringModelSearchParameters.BeanName parameters = SpringModelSearchParameters.byName(beanName);
        ModelTraverse.traverseModel(model, true, m -> m.traverseByName(parameters, (Processor<? super SpringBeanPointer<?>>)collectProcessor));
        Collection collection = collectProcessor.getResults();
        if (collection == null) {
            SpringModelSearchers.$$$reportNull$$$0(8);
        }
        return collection;
    }

    public static boolean doesBeanExist(@NotNull CommonSpringModel model, @NotNull SpringModelSearchParameters.BeanClass parameters) {
        if (model == null) {
            SpringModelSearchers.$$$reportNull$$$0(9);
        }
        if (parameters == null) {
            SpringModelSearchers.$$$reportNull$$$0(10);
        }
        return SpringModelSearchers.containsBean(model, parameters);
    }

    public static boolean doesBeanExist(@NotNull CommonSpringModel model, @NotNull PsiClass beanClass) {
        if (model == null) {
            SpringModelSearchers.$$$reportNull$$$0(11);
        }
        if (beanClass == null) {
            SpringModelSearchers.$$$reportNull$$$0(12);
        }
        return SpringModelSearchers.containsBean(model, SpringModelSearchParameters.byClass(beanClass).withInheritors().effectiveBeanTypes());
    }

    private static boolean containsBean(@NotNull CommonSpringModel model, @NotNull SpringModelSearchParameters.BeanClass parameters) {
        if (model == null) {
            SpringModelSearchers.$$$reportNull$$$0(13);
        }
        if (parameters == null) {
            SpringModelSearchers.$$$reportNull$$$0(14);
        }
        if (!parameters.canSearch()) {
            return false;
        }
        DoesBeanExistTraverse processor = new DoesBeanExistTraverse(parameters);
        ModelTraverse.traverseModelBreadthFirst(model, processor);
        return processor.isFound();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/utils/SpringModelSearchers";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/utils/SpringModelSearchers";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findBeans";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findBeans";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findBean";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doesBeanExist";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "containsBean";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 8 -> new IllegalStateException(string);
        };
    }

    private static class DoesBeanExistTraverse
    extends CommonProcessors.FindFirstProcessor<SpringBeanPointer<?>>
    implements Function<CommonSpringModel, Direction> {
        @NotNull
        private final SpringModelSearchParameters.BeanClass parameters;

        private DoesBeanExistTraverse(@NotNull SpringModelSearchParameters.BeanClass parameters) {
            if (parameters == null) {
                DoesBeanExistTraverse.$$$reportNull$$$0(0);
            }
            this.parameters = parameters;
        }

        @Override
        public Direction apply(CommonSpringModel model) {
            return model.traverseByClass(this.parameters, (Processor<? super SpringBeanPointer<?>>)this);
        }

        public String toString() {
            return "DoesBeanExistTraverse{" + String.valueOf(this.parameters) + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/model/utils/SpringModelSearchers$DoesBeanExistTraverse", "<init>"));
        }
    }
}

