/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.analysis;

import com.intellij.platform.ml.MLApiPlatform;
import com.intellij.platform.ml.environment.Environment;
import com.intellij.platform.ml.logs.MLSessionLogger;
import com.intellij.platform.ml.logs.schema.EventPair;
import com.intellij.platform.ml.session.AnalysedTierData;
import com.intellij.platform.ml.session.SessionTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0001 B-\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u001c\u001a\f0\u001dR\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u001e\u001a\u00020\u001aJ\b\u0010\u001f\u001a\u00020\u0014H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0012\u001a\"\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0013j\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/platform/ml/analysis/PatchingLogger;", "P", "", "baseMLSessionLogger", "Lcom/intellij/platform/ml/logs/MLSessionLogger;", "apiPlatform", "Lcom/intellij/platform/ml/MLApiPlatform;", "permanentSessionEnvironment", "Lcom/intellij/platform/ml/environment/Environment;", "permanentCallParameters", "<init>", "(Lcom/intellij/platform/ml/logs/MLSessionLogger;Lcom/intellij/platform/ml/MLApiPlatform;Lcom/intellij/platform/ml/environment/Environment;Lcom/intellij/platform/ml/environment/Environment;)V", "partialSessionLogs", "", "", "Lcom/intellij/platform/ml/logs/schema/EventPair;", "logLock", "Ljava/util/concurrent/locks/ReentrantLock;", "structure", "Lcom/intellij/platform/ml/session/SessionTree$RootContainer;", "", "Lcom/intellij/platform/ml/session/AnalysedTierData;", "Lcom/intellij/platform/ml/session/AnalysedRootContainer;", "flushStoppers", "", "alreadyAcquiredLastPatch", "", "isAlreadyLogged", "acquirePatchLogger", "Lcom/intellij/platform/ml/analysis/PatchingLogger$MLSessionPatchLogger;", "isLastPatch", "removeStopper", "MLSessionPatchLogger", "intellij.platform.ml"})
final class PatchingLogger<P> {
    @NotNull
    private final MLSessionLogger<P> baseMLSessionLogger;
    @NotNull
    private final MLApiPlatform apiPlatform;
    @NotNull
    private final Environment permanentSessionEnvironment;
    @NotNull
    private final Environment permanentCallParameters;
    @NotNull
    private final List<List<EventPair<?>>> partialSessionLogs;
    @NotNull
    private final ReentrantLock logLock;
    @Nullable
    private SessionTree.RootContainer<Unit, AnalysedTierData, P> structure;
    private int flushStoppers;
    private boolean alreadyAcquiredLastPatch;
    private boolean isAlreadyLogged;

    public PatchingLogger(@NotNull MLSessionLogger<P> baseMLSessionLogger, @NotNull MLApiPlatform apiPlatform, @NotNull Environment permanentSessionEnvironment, @NotNull Environment permanentCallParameters) {
        Intrinsics.checkNotNullParameter(baseMLSessionLogger, (String)"baseMLSessionLogger");
        Intrinsics.checkNotNullParameter((Object)apiPlatform, (String)"apiPlatform");
        Intrinsics.checkNotNullParameter((Object)permanentSessionEnvironment, (String)"permanentSessionEnvironment");
        Intrinsics.checkNotNullParameter((Object)permanentCallParameters, (String)"permanentCallParameters");
        this.baseMLSessionLogger = baseMLSessionLogger;
        this.apiPlatform = apiPlatform;
        this.permanentSessionEnvironment = permanentSessionEnvironment;
        this.permanentCallParameters = permanentCallParameters;
        this.partialSessionLogs = new ArrayList();
        this.logLock = new ReentrantLock();
        this.flushStoppers = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final MLSessionPatchLogger acquirePatchLogger(boolean isLastPatch) {
        Lock lock = this.logLock;
        lock.lock();
        try {
            boolean bl = false;
            if (isLastPatch) {
                if (!(!this.alreadyAcquiredLastPatch)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                this.alreadyAcquiredLastPatch = true;
            }
            ++this.flushStoppers;
            MLSessionPatchLogger mLSessionPatchLogger = new MLSessionPatchLogger((Function0<Unit>)((Function0)() -> PatchingLogger.acquirePatchLogger$lambda$0$0(this, isLastPatch)));
            return mLSessionPatchLogger;
        }
        finally {
            lock.unlock();
        }
    }

    private final void removeStopper() {
        --this.flushStoppers;
        if (this.flushStoppers == 0) {
            boolean bl;
            boolean bl2 = bl = !this.isAlreadyLogged;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.isAlreadyLogged = true;
            this.baseMLSessionLogger.logComponents(this.apiPlatform, this.permanentSessionEnvironment, this.permanentCallParameters, CollectionsKt.flatten((Iterable)this.partialSessionLogs), this.structure);
        }
    }

    private static final Unit acquirePatchLogger$lambda$0$0(PatchingLogger this$0, boolean $isLastPatch) {
        this$0.removeStopper();
        if ($isLastPatch) {
            this$0.removeStopper();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\t\u001a\u00020\u00042\u0010\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bJ*\u0010\r\u001a\u00020\u00042\"\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00028\u00000\u000fj\b\u0012\u0004\u0012\u00028\u0000`\u0011R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/ml/analysis/PatchingLogger$MLSessionPatchLogger;", "", "onAfterPatchLogged", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/platform/ml/analysis/PatchingLogger;Lkotlin/jvm/functions/Function0;)V", "patchAlreadyLogged", "", "logSession", "session", "", "Lcom/intellij/platform/ml/logs/schema/EventPair;", "logStructure", "structure", "Lcom/intellij/platform/ml/session/SessionTree$RootContainer;", "Lcom/intellij/platform/ml/session/AnalysedTierData;", "Lcom/intellij/platform/ml/session/AnalysedRootContainer;", "intellij.platform.ml"})
    public final class MLSessionPatchLogger {
        @NotNull
        private final Function0<Unit> onAfterPatchLogged;
        private boolean patchAlreadyLogged;

        public MLSessionPatchLogger(Function0<Unit> onAfterPatchLogged) {
            Intrinsics.checkNotNullParameter(onAfterPatchLogged, (String)"onAfterPatchLogged");
            this.onAfterPatchLogged = onAfterPatchLogged;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void logSession(@NotNull List<? extends EventPair<?>> session) {
            Intrinsics.checkNotNullParameter(session, (String)"session");
            Lock lock = PatchingLogger.this.logLock;
            PatchingLogger patchingLogger = PatchingLogger.this;
            lock.lock();
            try {
                boolean bl = false;
                if (!(!this.patchAlreadyLogged)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                ((Collection)patchingLogger.partialSessionLogs).add(session);
                this.patchAlreadyLogged = true;
                this.onAfterPatchLogged.invoke();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void logStructure(@NotNull SessionTree.RootContainer<Unit, AnalysedTierData, P> structure) {
            Intrinsics.checkNotNullParameter(structure, (String)"structure");
            Lock lock = PatchingLogger.this.logLock;
            PatchingLogger patchingLogger = PatchingLogger.this;
            lock.lock();
            try {
                boolean bl = false;
                if (!(!this.patchAlreadyLogged)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                patchingLogger.structure = structure;
                this.patchAlreadyLogged = true;
                this.onAfterPatchLogged.invoke();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
    }
}

