/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0004\u0018\u0000 **\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0003*+,BI\b\u0016\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005\u0012\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0005J\u0019\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u0019\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u001b\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dJ\u0019\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001d2\u0006\u0010\u001e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001fJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u001dJ\u0019\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u001d2\u0006\u0010\u001e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\"J\"\u0010$\u001a\b\u0012\u0004\u0012\u0002H&0%\"\u0004\b\u0001\u0010&2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H&0\"H\u0002J\"\u0010(\u001a\b\u0012\u0004\u0012\u0002H&0)\"\u0004\b\u0001\u0010&2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H&0\"H\u0002R\u0015\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006-"}, d2={"Lcom/intellij/database/util/tree/AbstractTree;", "N", "", "root", "parentFunction", "Lkotlin/Function1;", "childrenFunction", "", "<init>", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getRoot", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getParentFunction", "()Lkotlin/jvm/functions/Function1;", "getChildrenFunction", "withParent", "withChildren", "pathFromRoot", "", "node", "(Ljava/lang/Object;)Ljava/util/List;", "pathToRoot", "nodeIsAncestor", "", "ancestor", "descendant", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "traverseDepthFirst", "", "fromNode", "(Ljava/lang/Object;)Ljava/util/Iterator;", "traverseBreadthFirst", "filterTopNodes", "", "nodes", "createApplicableMutableEmptyCollection", "", "T", "originalCollection", "createApplicableMutableEmptySet", "", "Companion", "DFSIterator", "BFSIterator", "intellij.database.util"})
@SourceDebugExtension(value={"SMAP\nAbstractTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractTree.kt\ncom/intellij/database/util/tree/AbstractTree\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,310:1\n1761#2,3:311\n*S KotlinDebug\n*F\n+ 1 AbstractTree.kt\ncom/intellij/database/util/tree/AbstractTree\n*L\n263#1:311,3\n*E\n"})
public final class AbstractTree<N> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final N root;
    @NotNull
    private final Function1<N, N> parentFunction;
    @NotNull
    private final Function1<N, Iterable<N>> childrenFunction;

    @Nullable
    public final N getRoot() {
        return this.root;
    }

    @NotNull
    public final Function1<N, N> getParentFunction() {
        return this.parentFunction;
    }

    @NotNull
    public final Function1<N, Iterable<N>> getChildrenFunction() {
        return this.childrenFunction;
    }

    public AbstractTree(@Nullable N root, @NotNull Function1<? super N, ? extends N> parentFunction, @NotNull Function1<? super N, ? extends Iterable<? extends N>> childrenFunction) {
        Intrinsics.checkNotNullParameter(parentFunction, (String)"parentFunction");
        Intrinsics.checkNotNullParameter(childrenFunction, (String)"childrenFunction");
        this.root = root;
        this.parentFunction = parentFunction;
        this.childrenFunction = childrenFunction;
    }

    public /* synthetic */ AbstractTree(Object object, Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            object = null;
        }
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 4) != 0) {
            function12 = AbstractTree::_init_$lambda$0;
        }
        this(object, function1, function12);
    }

    @NotNull
    public final AbstractTree<N> withParent(@NotNull Function1<? super N, ? extends N> parentFunction) {
        Intrinsics.checkNotNullParameter(parentFunction, (String)"parentFunction");
        return new AbstractTree<N>(this.root, parentFunction, this.childrenFunction);
    }

    @NotNull
    public final AbstractTree<N> withChildren(@NotNull Function1<? super N, ? extends Iterable<? extends N>> childrenFunction) {
        Intrinsics.checkNotNullParameter(childrenFunction, (String)"childrenFunction");
        return new AbstractTree<N>(this.root, this.parentFunction, childrenFunction);
    }

    @NotNull
    public final List<N> pathFromRoot(@NotNull N node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        List path = this.pathToRoot(node);
        return path.size() == 1 ? path : CollectionsKt.reversed((Iterable)path);
    }

    @NotNull
    public final List<N> pathToRoot(@NotNull N node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        ArrayList<N> path = new ArrayList<N>();
        Object x = node;
        while (x != null) {
            path.add(x);
            x = this.parentFunction.invoke(x);
        }
        return path.size() == 1 ? CollectionsKt.listOf(node) : (List)path;
    }

    public final boolean nodeIsAncestor(@NotNull N ancestor, @NotNull N descendant) {
        Intrinsics.checkNotNullParameter(ancestor, (String)"ancestor");
        Intrinsics.checkNotNullParameter(descendant, (String)"descendant");
        Object p = this.parentFunction.invoke(descendant);
        while (p != null) {
            if (Intrinsics.areEqual((Object)p, ancestor)) {
                return true;
            }
            p = this.parentFunction.invoke(p);
        }
        return false;
    }

    @NotNull
    public final Iterator<N> traverseDepthFirst() {
        return this.root != null ? this.traverseDepthFirst(this.root) : CollectionsKt.emptyList().iterator();
    }

    @NotNull
    public final Iterator<N> traverseDepthFirst(@NotNull N fromNode) {
        Intrinsics.checkNotNullParameter(fromNode, (String)"fromNode");
        return new DFSIterator(fromNode);
    }

    @NotNull
    public final Iterator<N> traverseBreadthFirst() {
        return this.root != null ? this.traverseBreadthFirst(this.root) : CollectionsKt.emptyList().iterator();
    }

    @NotNull
    public final Iterator<N> traverseBreadthFirst(@NotNull N fromNode) {
        Intrinsics.checkNotNullParameter(fromNode, (String)"fromNode");
        return new BFSIterator(fromNode);
    }

    @NotNull
    public final Collection<N> filterTopNodes(@NotNull Collection<? extends N> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        if (nodes.size() < 2) {
            return nodes;
        }
        Set<N> ancestors = this.createApplicableMutableEmptySet(nodes);
        Collection<N> result = this.createApplicableMutableEmptyCollection(nodes);
        for (N node : nodes) {
            boolean bl;
            List<N> path;
            block9: {
                path = this.pathToRoot(node);
                if (path.size() == 1) {
                    result.clear();
                    result.add(node);
                    break;
                }
                if (ancestors.isEmpty()) {
                    ancestors.addAll((Collection)path);
                    result.add(node);
                    continue;
                }
                Set pathSet = CollectionsKt.toSet((Iterable)path);
                Iterable $this$any$iv = result;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv;
                        Object p0 = element$iv = iterator.next();
                        boolean bl2 = false;
                        if (!pathSet.contains(p0)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            if (ancestors.contains(node)) {
                boolean removed = false;
                boolean replaced = false;
                Iterator<N> iterator = result.iterator();
                while (iterator.hasNext()) {
                    N theNode = iterator.next();
                    if (!this.nodeIsAncestor(node, theNode)) continue;
                    iterator.remove();
                    removed = true;
                    if (replaced || !TypeIntrinsics.isMutableListIterator(iterator)) continue;
                    ((ListIterator)iterator).add(node);
                    replaced = true;
                }
                if (!removed || replaced) continue;
                result.add(node);
                continue;
            }
            ancestors.addAll((Collection)path);
            result.add(node);
        }
        return result.size() < nodes.size() ? result : nodes;
    }

    private final <T> Collection<T> createApplicableMutableEmptyCollection(Collection<? extends T> originalCollection) {
        if (originalCollection instanceof Set) {
            return this.createApplicableMutableEmptySet(originalCollection);
        }
        return new ArrayList(originalCollection.size());
    }

    private final <T> Set<T> createApplicableMutableEmptySet(Collection<? extends T> originalCollection) {
        if (originalCollection instanceof SortedSet) {
            Comparator comparator = ((SortedSet)originalCollection).comparator();
            return comparator != null ? (Set)new TreeSet(comparator) : (Set)new TreeSet();
        }
        return new HashSet(originalCollection.size());
    }

    private static final Set _init_$lambda$0(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SetsKt.emptySet();
    }

    @JvmStatic
    @NotNull
    public static final <N> AbstractTree<N> treeWithRoot(@Nullable N root) {
        return Companion.treeWithRoot(root);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004J\t\u0010\n\u001a\u00020\u000bH\u0096\u0002J\u000e\u0010\f\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0002\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/util/tree/AbstractTree$BFSIterator;", "", "root", "<init>", "(Lcom/intellij/database/util/tree/AbstractTree;Ljava/lang/Object;)V", "getRoot", "()Ljava/lang/Object;", "Ljava/lang/Object;", "queue", "Lkotlin/collections/ArrayDeque;", "hasNext", "", "next", "intellij.database.util"})
    private final class BFSIterator
    implements Iterator<N>,
    KMappedMarker {
        @NotNull
        private final N root;
        @NotNull
        private final ArrayDeque<N> queue;

        public BFSIterator(N root) {
            Intrinsics.checkNotNullParameter(root, (String)"root");
            this.root = root;
            this.queue = new ArrayDeque();
            this.queue.add(this.root);
        }

        @NotNull
        public final N getRoot() {
            return this.root;
        }

        @Override
        public boolean hasNext() {
            return !((Collection)this.queue).isEmpty();
        }

        @Override
        @NotNull
        public N next() {
            Object node = this.queue.removeFirst();
            CollectionsKt.addAll((Collection)((Collection)this.queue), (Iterable)((Iterable)AbstractTree.this.getChildrenFunction().invoke(node)));
            return node;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0001\u0010\u0006*\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u0001H\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/util/tree/AbstractTree$Companion;", "", "<init>", "()V", "treeWithRoot", "Lcom/intellij/database/util/tree/AbstractTree;", "N", "root", "(Ljava/lang/Object;)Lcom/intellij/database/util/tree/AbstractTree;", "intellij.database.util"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <N> AbstractTree<N> treeWithRoot(@Nullable N root) {
            return new AbstractTree(root, null, null, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0002J\t\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\u000e\u0010\u0010\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0002\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\b\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/util/tree/AbstractTree$DFSIterator;", "", "root", "<init>", "(Lcom/intellij/database/util/tree/AbstractTree;Ljava/lang/Object;)V", "getRoot", "()Ljava/lang/Object;", "Ljava/lang/Object;", "currNode", "currIterator", "stack", "Lkotlin/collections/ArrayDeque;", "processNext", "", "hasNext", "", "next", "intellij.database.util"})
    private final class DFSIterator
    implements Iterator<N>,
    KMappedMarker {
        @NotNull
        private final N root;
        @Nullable
        private N currNode;
        @Nullable
        private Iterator<? extends N> currIterator;
        @NotNull
        private final ArrayDeque<Iterator<N>> stack;

        public DFSIterator(N root) {
            Intrinsics.checkNotNullParameter(root, (String)"root");
            this.root = root;
            this.currNode = this.root;
            this.stack = new ArrayDeque();
        }

        @NotNull
        public final N getRoot() {
            return this.root;
        }

        private final void processNext() {
            Object n = this.currNode;
            if (n == null) {
                return;
            }
            Object theNode = n;
            Iterator currIterator = this.currIterator;
            Iterable newChildrenIterable = (Iterable)AbstractTree.this.getChildrenFunction().invoke(theNode);
            Iterator newChildrenIterator = newChildrenIterable.iterator();
            if (newChildrenIterator.hasNext()) {
                if (currIterator != null) {
                    this.stack.addLast(currIterator);
                }
                this.currNode = newChildrenIterator.next();
                this.currIterator = newChildrenIterator;
            } else if (currIterator != null && currIterator.hasNext()) {
                this.currNode = currIterator.next();
            } else {
                this.currNode = null;
                while (!((Collection)this.stack).isEmpty()) {
                    Iterator lastIterator = (Iterator)this.stack.removeLast();
                    if (!lastIterator.hasNext()) continue;
                    this.currNode = lastIterator.next();
                    this.currIterator = lastIterator;
                    break;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.currNode != null;
        }

        @Override
        @NotNull
        public N next() {
            Object n = this.currNode;
            if (n == null) {
                throw new NoSuchElementException("No more elements");
            }
            Object node = n;
            this.processNext();
            return node;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

