/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.server;

import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.execution.wsl.WslPath;
import com.intellij.javaee.appServers.run.configuration.CommonModel;
import com.intellij.javaee.appServers.run.localRun.ExecutableObject;
import com.intellij.javaee.appServers.run.localRun.ScriptHelper;
import com.intellij.javaee.oss.jboss.config.JBossBindingConfig;
import com.intellij.javaee.oss.jboss.server.JBossLocalModel;
import com.intellij.javaee.oss.jboss.version.JBossContributionsProvider;
import com.intellij.javaee.oss.jboss.version.JBossVersion6Handler;
import com.intellij.javaee.oss.jboss.version.JBossVersion7Handler;
import com.intellij.javaee.oss.jboss.version.JBossVersionContribution;
import com.intellij.javaee.oss.server.JavaeeParameters;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.oss.server.JavaeeStartupPolicy;
import com.intellij.javaee.oss.server.WslStartupExecutable;
import com.intellij.javaee.oss.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JBossStartupPolicy
extends JavaeeStartupPolicy<JBossLocalModel> {
    private static final Logger LOG = Logger.getInstance(JBossStartupPolicy.class);
    private final JBossContributionsProvider<StartupPolicyContribution> myContributionsProvider = new JBossContributionsProvider<StartupPolicyContribution>(StartupPolicyContribution.class);

    JBossStartupPolicy() {
        this.myContributionsProvider.add(JBossVersion6Handler.ID, new StartupPolicyContribution(){

            @Override
            public void getStartupParameters(JavaeeParameters params, JBossLocalModel model) {
                params.add(new File(JBossStartupPolicy.getScriptDir(model), JBossStartupPolicy.getStartupScript()));
                params.add(new String[]{"-c", model.SERVER});
                String bindingSetName = model.BINDING_SET_NAME;
                if (!StringUtil.isEmpty((String)bindingSetName) && !StringUtil.notNullize((String)bindingSetName).equals(JBossBindingConfig.getCurrentBindingSetName(model))) {
                    params.add(new String[]{"-Djboss.service.binding.set=" + bindingSetName});
                }
            }

            @Override
            public void getShutdownParameters(JavaeeParameters params, JBossLocalModel model) {
                params.add(new File(JBossStartupPolicy.getScriptDir(model), JBossStartupPolicy.getShutdownScript()));
                Version version = new Version(model.getVersion());
                int port = model.getShutdownPort();
                params.add(new String[]{"-s", version.getMajor() >= 6 ? "service:jmx:rmi:///jndi/rmi://localhost:" + port + "/jmxrmi" : "jnp://localhost:" + port});
                params.add(new String[]{"-u", model.USERNAME});
                params.add(new String[]{"-p", model.PASSWORD});
                params.add(new String[]{"-S"});
            }

            @Override
            public ExecutableObject getDefaultShutdownScript(ProgramRunner runner, CommonModel commonModel) {
                ScriptHelper scriptHelper = JBossStartupPolicy.super.createShutdownScriptHelper(runner);
                LOG.assertTrue(scriptHelper != null);
                return scriptHelper.getDefaultScript(commonModel);
            }
        });
        this.myContributionsProvider.add(JBossVersion7Handler.ID, new StartupPolicyContribution(this){

            @Override
            public void getStartupParameters(JavaeeParameters params, JBossLocalModel model) {
                params.add(JBossStartupPolicy.getStartupScriptFile(model, SystemInfo.isWindows));
            }

            @Override
            public void getShutdownParameters(JavaeeParameters params, JBossLocalModel model) {
            }

            @Override
            public ExecutableObject getDefaultShutdownScript(ProgramRunner runner, CommonModel commonModel) {
                return null;
            }
        });
    }

    @NotNull
    private static File getStartupScriptFile(JBossLocalModel model, boolean isWindows) {
        return new File(JBossStartupPolicy.getScriptDir(model), JBossStartupPolicy.getStartupScript7(model.isDomain(), isWindows));
    }

    @Nullable
    protected ExecutableObject getDefaultStartupScript(JBossLocalModel serverModel, boolean debug) {
        if (WslPath.isWslUncPath((String)serverModel.getHome())) {
            File scriptFile = JBossStartupPolicy.getStartupScriptFile(serverModel, false);
            return new WslStartupExecutable(scriptFile, "", List.of(), serverModel.getCommonModel().getProject(), "");
        }
        return super.getDefaultStartupScript((JavaeeServerModel)serverModel, debug);
    }

    protected void getStartupParameters(JavaeeParameters params, JBossLocalModel model, boolean debug) {
        model.getContribution(this.myContributionsProvider).getStartupParameters(params, model);
    }

    protected void getShutdownParameters(JavaeeParameters params, JBossLocalModel model, boolean debug) {
        model.getContribution(this.myContributionsProvider).getShutdownParameters(params, model);
    }

    public ScriptHelper createShutdownScriptHelper(final ProgramRunner runner) {
        return new ScriptHelper(){

            public ExecutableObject getDefaultScript(CommonModel commonModel) {
                JBossLocalModel serverModel = (JBossLocalModel)commonModel.getServerModel();
                return serverModel.getContribution(JBossStartupPolicy.this.myContributionsProvider).getDefaultShutdownScript(runner, commonModel);
            }
        };
    }

    @Nullable
    protected List<EnvironmentVariable> getEnvironmentVariables(JBossLocalModel model) {
        Version version;
        ArrayList<EnvironmentVariable> result = new ArrayList<EnvironmentVariable>();
        String jrePath = model.getJrePath();
        if (jrePath != null) {
            result.add(new EnvironmentVariable("JAVA_HOME", jrePath, true));
        }
        if (SystemInfo.isWindows) {
            result.add(new EnvironmentVariable("NOPAUSE", "yes", false));
        } else if (SystemInfo.isMac && (version = new Version(model.getVersion())).getMajor() == 7 && version.getMinor() >= 1) {
            result.add(new EnvironmentVariable("PRESERVE_JAVA_OPTS", "true", true));
        }
        return result;
    }

    @NonNls
    private static File getScriptDir(JBossLocalModel model) {
        return new File(model.getHome(), "bin");
    }

    @NonNls
    private static String getStartupScript() {
        return "run" + JBossStartupPolicy.getScriptExtension();
    }

    @NonNls
    private static String getShutdownScript() {
        return "shutdown" + JBossStartupPolicy.getScriptExtension();
    }

    @NonNls
    private static String getStartupScript7(boolean isDomain, boolean isWindows) {
        return (isDomain ? "domain" : "standalone") + JBossStartupPolicy.getScriptExtension(isWindows);
    }

    private static String getScriptExtension(boolean isWindows) {
        return isWindows ? ".bat" : ".sh";
    }

    private static String getScriptExtension() {
        return JBossStartupPolicy.getScriptExtension(SystemInfo.isWindows);
    }

    private static interface StartupPolicyContribution
    extends JBossVersionContribution {
        public void getStartupParameters(JavaeeParameters var1, JBossLocalModel var2);

        public void getShutdownParameters(JavaeeParameters var1, JBossLocalModel var2);

        public ExecutableObject getDefaultShutdownScript(ProgramRunner var1, CommonModel var2);
    }
}

