/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.k1.debug.evaluation;

import com.intellij.debugger.engine.JavaDebuggerCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.kotlin.jupyter.core.util.UtilKt;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterLanguage;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilder;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinK1CodeFragmentFactory;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.impl.JupyterSourceImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J$\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/kotlin/jupyter/k1/debug/evaluation/KotlinNotebookCodeFragmentFactory;", "Lcom/intellij/debugger/engine/JavaDebuggerCodeFragmentFactory;", "<init>", "()V", "ktCodeFragmentFactory", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinK1CodeFragmentFactory;", "ktEvaluator", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluatorBuilder;", "createPsiCodeFragmentImpl", "Lcom/intellij/psi/JavaCodeFragment;", "item", "Lcom/intellij/debugger/engine/evaluation/TextWithImports;", "context", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "createPresentationPsiCodeFragmentImpl", "isContextAccepted", "", "contextElement", "getFileType", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "getEvaluatorBuilder", "Lcom/intellij/debugger/engine/evaluation/expression/EvaluatorBuilder;", "intellij.kotlin.jupyter.k1"})
public final class KotlinNotebookCodeFragmentFactory
extends JavaDebuggerCodeFragmentFactory {
    @NotNull
    private final KotlinK1CodeFragmentFactory ktCodeFragmentFactory = new KotlinK1CodeFragmentFactory();
    @NotNull
    private final KotlinEvaluatorBuilder ktEvaluator = KotlinEvaluatorBuilder.INSTANCE;

    @Nullable
    protected JavaCodeFragment createPsiCodeFragmentImpl(@NotNull TextWithImports item, @Nullable PsiElement context, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.createPresentationPsiCodeFragment(item, context, project);
    }

    @Nullable
    protected JavaCodeFragment createPresentationPsiCodeFragmentImpl(@NotNull TextWithImports item, @Nullable PsiElement context, @NotNull Project project) {
        JupyterPsiCell cellAsParent;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (context == null) {
            return null;
        }
        InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance((Project)project);
        PsiElement psiElement = context.getParent().getParent();
        JupyterPsiCell jupyterPsiCell = cellAsParent = psiElement instanceof JupyterPsiCell ? (JupyterPsiCell)psiElement : null;
        if (!(context.getContext() instanceof JupyterSourceImpl) || cellAsParent == null) {
            return this.ktCodeFragmentFactory.createPresentationPsiCodeFragment(item, context, project);
        }
        PsiLanguageInjectionHost psiLanguageInjectionHost = (PsiLanguageInjectionHost)cellAsParent;
        Intrinsics.checkNotNull((Object)injectedManager);
        KtFile injectedElement = (KtFile)CollectionsKt.firstOrNull((List)UtilKt.getInjectedKtFiles((PsiLanguageInjectionHost)psiLanguageInjectionHost, (InjectedLanguageManager)injectedManager));
        VirtualFile virtualFile = context.getContainingFile().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        BackedNotebookVirtualFile backedNotebook = UtilKt.toBackedNotebookFile((VirtualFile)virtualFile);
        if (injectedElement == null || backedNotebook == null) {
            return this.ktCodeFragmentFactory.createPresentationPsiCodeFragment(item, null, project);
        }
        int cellOffset = cellAsParent.getTextOffset();
        PsiElement newContext = injectedElement.findElementAt(cellOffset + 1);
        return this.ktCodeFragmentFactory.createPresentationPsiCodeFragment(item, newContext, project);
    }

    public boolean isContextAccepted(@Nullable PsiElement contextElement) {
        PsiElement psiElement = contextElement;
        return psiElement != null && (psiElement = psiElement.getContainingFile()) != null && (psiElement = psiElement.getVirtualFile()) != null ? IsKotlinNotebookKt.isKotlinNotebook((VirtualFile)psiElement) : false;
    }

    @NotNull
    public LanguageFileType getFileType() {
        LanguageFileType languageFileType = JupyterLanguage.INSTANCE.getAssociatedFileType();
        Intrinsics.checkNotNull((Object)languageFileType);
        return languageFileType;
    }

    @NotNull
    public EvaluatorBuilder getEvaluatorBuilder() {
        return (EvaluatorBuilder)this.ktEvaluator;
    }
}

