/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.markdown.frontend.split;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreviewProviderKt;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rdclient.fileEditors.FrontendTextFileEditor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.editor.EditorUtilKt;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtilsKt;
import org.intellij.plugins.markdown.ui.preview.MarkdownEditorWithPreview;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditorProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0006H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/markdown/frontend/split/FrontendMarkdownSplitEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "textEditor", "Lcom/jetbrains/rdclient/fileEditors/FrontendTextFileEditor;", "textEditorTypeId", "", "<init>", "(Lcom/jetbrains/rdclient/fileEditors/FrontendTextFileEditor;Ljava/lang/String;)V", "previewEditorProvider", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditorProvider;", "editorTypeId", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getEditorTypeId", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "intellij.markdown.frontend.split"})
final class FrontendMarkdownSplitEditorProvider
implements FileEditorProvider,
DumbAware {
    @NotNull
    private final FrontendTextFileEditor textEditor;
    @NotNull
    private final MarkdownPreviewFileEditorProvider previewEditorProvider;
    @NotNull
    private final String editorTypeId;

    public FrontendMarkdownSplitEditorProvider(@NotNull FrontendTextFileEditor textEditor2, @NotNull String textEditorTypeId) {
        Intrinsics.checkNotNullParameter((Object)textEditor2, (String)"textEditor");
        Intrinsics.checkNotNullParameter((Object)textEditorTypeId, (String)"textEditorTypeId");
        this.textEditor = textEditor2;
        this.previewEditorProvider = new MarkdownPreviewFileEditorProvider();
        this.editorTypeId = TextEditorWithPreviewProviderKt.createSplitEditorProviderTypeId((String)textEditorTypeId, (String)this.previewEditorProvider.getEditorTypeId());
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.previewEditorProvider.accept(project, file)) {
            return false;
        }
        return MarkdownLanguageUtilsKt.hasMarkdownType((VirtualFile)file) || EditorUtilKt.isMarkdownScratchFile((Project)project, (VirtualFile)file);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileEditor preview2 = this.previewEditorProvider.createEditor(project, file);
        if (!(preview2 instanceof MarkdownPreviewFileEditor)) {
            throw new IllegalStateException("Check failed.");
        }
        return (FileEditor)new MarkdownEditorWithPreview((TextEditor)this.textEditor, (MarkdownPreviewFileEditor)preview2, project);
    }

    @NotNull
    public String getEditorTypeId() {
        return this.editorTypeId;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }
}

