/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.logical;

import com.intellij.ide.structureView.logical.ContainerElementsProvider;
import com.intellij.jam.JamService;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.jam.stereotype.SpringController;
import com.intellij.spring.model.logical.SpringBeanLogicalModel;
import com.intellij.spring.mvc.SpringControllerUtils;
import com.intellij.spring.mvc.logical.EndpointHandler;
import com.intellij.spring.mvc.logical.SpringControllerEndpointLogicalModel;
import com.intellij.spring.mvc.model.jam.RequestMapping;
import com.intellij.spring.mvc.navigation.requests.rest.UrlPathContextUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/spring/mvc/logical/SpringControllerEndpointsProvider;", "Lcom/intellij/ide/structureView/logical/ContainerElementsProvider;", "Lcom/intellij/spring/model/logical/SpringBeanLogicalModel;", "Lcom/intellij/spring/mvc/logical/SpringControllerEndpointLogicalModel;", "<init>", "()V", "isApplicable", "", "parent", "getElements", "", "getEndpointHandlers", "Lcom/intellij/spring/mvc/logical/EndpointHandler;", "beanClass", "Lcom/intellij/psi/PsiClass;", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nSpringControllerEndpointsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringControllerEndpointsProvider.kt\ncom/intellij/spring/mvc/logical/SpringControllerEndpointsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1563#2:86\n1634#2,3:87\n*S KotlinDebug\n*F\n+ 1 SpringControllerEndpointsProvider.kt\ncom/intellij/spring/mvc/logical/SpringControllerEndpointsProvider\n*L\n31#1:86\n31#1:87,3\n*E\n"})
public final class SpringControllerEndpointsProvider
implements ContainerElementsProvider<SpringBeanLogicalModel, SpringControllerEndpointLogicalModel> {
    public boolean isApplicable(@NotNull SpringBeanLogicalModel parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return parent.getSpringBean() instanceof SpringController;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<SpringControllerEndpointLogicalModel> getElements(@NotNull SpringBeanLogicalModel parent) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        CommonSpringBean commonSpringBean = parent.getSpringBean();
        SpringController springController = commonSpringBean instanceof SpringController ? (SpringController)commonSpringBean : null;
        if (springController == null) {
            return CollectionsKt.emptyList();
        }
        SpringController controller = springController;
        PsiType psiType = controller.getBeanType();
        PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        if (psiClassType == null || (psiClassType = psiClassType.resolve()) == null) {
            return CollectionsKt.emptyList();
        }
        PsiClassType beanClass = psiClassType;
        Iterable $this$map$iv = this.getEndpointHandlers((PsiClass)beanClass);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            EndpointHandler endpointHandler = (EndpointHandler)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String url = endpointHandler.component1();
            PsiMethod handlerMethod = endpointHandler.component2();
            UrlPathContext urlPathContext = endpointHandler.component3();
            collection.add(new SpringControllerEndpointLogicalModel(url, handlerMethod, urlPathContext));
        }
        return (List)destination$iv$iv;
    }

    private final List<EndpointHandler> getEndpointHandlers(PsiClass beanClass) {
        JamService jamService = JamService.getJamService((Project)beanClass.getProject());
        SortedMap handlers = MapsKt.sortedMapOf((Pair[])new Pair[0]);
        PsiMethod[] psiMethodArray = beanClass.getAllMethods();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getAllMethods(...)");
        for (PsiMethod psiMethod : psiMethodArray) {
            RequestMapping.Method requestMapping;
            if (!SpringControllerUtils.isRequestHandler(psiMethod)) continue;
            Project project = psiMethod.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Intrinsics.checkNotNull((Object)psiMethod);
            if (UrlPathContextUtilsKt.findUrlPathContext(project, psiMethod) == null || (RequestMapping.Method)jamService.getJamElement(RequestMapping.METHOD_JAM_KEY, (PsiElement)psiMethod) == null) continue;
            for (String url : requestMapping.getUrls()) {
                UrlPathContext urlPathContext;
                List list = (List)handlers.get(url);
                if (list == null) {
                    list = new ArrayList();
                }
                List urlHandlers = list;
                Intrinsics.checkNotNull((Object)url);
                urlHandlers.add(new EndpointHandler(url, psiMethod, urlPathContext));
                ((Map)handlers).put(url, urlHandlers);
            }
        }
        Collection collection = handlers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.flatten((Iterable)collection);
    }
}

