/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.publisher;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.cloudclient.QDCloudResponse;
import org.jetbrains.qodana.publisher.PublisherParsingException;
import org.jetbrains.qodana.publisher.schemas.UploadedReport;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0004\u0002\u0003\u0004\u0005\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/qodana/publisher/PublishResult;", "", "Error", "ParsingError", "ServerError", "Success", "Lorg/jetbrains/qodana/publisher/PublishResult$Error;", "Lorg/jetbrains/qodana/publisher/PublishResult$Success;", "publisher"})
public interface PublishResult {

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001R\u0016\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0002\u000b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/qodana/publisher/PublishResult$Error;", "Lorg/jetbrains/qodana/publisher/PublishResult;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getException", "()Ljava/lang/Exception;", "message", "", "getMessage", "()Ljava/lang/String;", "Lorg/jetbrains/qodana/publisher/PublishResult$ParsingError;", "Lorg/jetbrains/qodana/publisher/PublishResult$ServerError;", "publisher"})
    public static interface Error
    extends PublishResult {
        @NotNull
        public String getMessage();

        @NotNull
        public Exception getException();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/qodana/publisher/PublishResult$ParsingError;", "Lorg/jetbrains/qodana/publisher/PublishResult$Error;", "exception", "Lorg/jetbrains/qodana/publisher/PublisherParsingException;", "(Lorg/jetbrains/qodana/publisher/PublisherParsingException;)V", "getException", "()Lorg/jetbrains/qodana/publisher/PublisherParsingException;", "message", "", "getMessage", "()Ljava/lang/String;", "publisher"})
    public static final class ParsingError
    implements Error {
        @NotNull
        private final PublisherParsingException exception;

        public ParsingError(@NotNull PublisherParsingException exception) {
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            this.exception = exception;
        }

        @Override
        @NotNull
        public PublisherParsingException getException() {
            return this.exception;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.getException().getMessage();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/qodana/publisher/PublishResult$ServerError;", "Lorg/jetbrains/qodana/publisher/PublishResult$Error;", "error", "Lorg/jetbrains/qodana/cloudclient/QDCloudResponse$Error;", "(Lorg/jetbrains/qodana/cloudclient/QDCloudResponse$Error;)V", "getError", "()Lorg/jetbrains/qodana/cloudclient/QDCloudResponse$Error;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getException", "()Ljava/lang/Exception;", "message", "", "getMessage", "()Ljava/lang/String;", "publisher"})
    public static final class ServerError
    implements Error {
        @NotNull
        private final QDCloudResponse.Error error;

        public ServerError(@NotNull QDCloudResponse.Error error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            this.error = error;
        }

        @NotNull
        public final QDCloudResponse.Error getError() {
            return this.error;
        }

        @Override
        @NotNull
        public String getMessage() {
            Object object;
            QDCloudResponse.Error error = this.error;
            if (error instanceof QDCloudResponse.Error.Offline) {
                object = "Failed to connect to Qodana Cloud";
            } else if (error instanceof QDCloudResponse.Error.ResponseFailure) {
                Integer responseCode = ((QDCloudResponse.Error.ResponseFailure)this.error).getResponseCode();
                object = responseCode != null ? "Response code: " + responseCode + ", " + ((QDCloudResponse.Error.ResponseFailure)this.error).getErrorMessage() : ((QDCloudResponse.Error.ResponseFailure)this.error).getErrorMessage();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return object;
        }

        @Override
        @NotNull
        public Exception getException() {
            return (Exception)this.error.getException();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/qodana/publisher/PublishResult$Success;", "Lorg/jetbrains/qodana/publisher/PublishResult;", "uploadedReport", "Lorg/jetbrains/qodana/publisher/schemas/UploadedReport;", "(Lorg/jetbrains/qodana/publisher/schemas/UploadedReport;)V", "getUploadedReport", "()Lorg/jetbrains/qodana/publisher/schemas/UploadedReport;", "publisher"})
    public static final class Success
    implements PublishResult {
        @NotNull
        private final UploadedReport uploadedReport;

        public Success(@NotNull UploadedReport uploadedReport) {
            Intrinsics.checkNotNullParameter((Object)uploadedReport, (String)"uploadedReport");
            this.uploadedReport = uploadedReport;
        }

        @NotNull
        public final UploadedReport getUploadedReport() {
            return this.uploadedReport;
        }
    }
}

