/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor;

import com.intellij.notebooks.jupyter.core.jupyter.CellType;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LineNumberConverter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/core/editor/JupyterLineNumberConverterSetter;", "", "<init>", "()V", "setConverterToEditor", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "createLineNumberConverter", "Lcom/intellij/openapi/editor/LineNumberConverter;", "intellij.jupyter.core"})
public final class JupyterLineNumberConverterSetter {
    @NotNull
    public static final JupyterLineNumberConverterSetter INSTANCE = new JupyterLineNumberConverterSetter();

    private JupyterLineNumberConverterSetter() {
    }

    public final void setConverterToEditor(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        editor.getGutter().setLineNumberConverter(this.createLineNumberConverter());
    }

    private final LineNumberConverter createLineNumberConverter() {
        return new LineNumberConverter(){

            public Integer convert(Editor editor, int lineNumber) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                int trueLineNumber = lineNumber - 1;
                NotebookCellLines notebookCellLines = NotebookCellLines.Companion.get(editor);
                NotebookCellLines.Interval interval = (NotebookCellLines.Interval)notebookCellLines.intervalsIterator(trueLineNumber).next();
                if (interval.getType() != CellType.CODE && !NotebookUtil.INSTANCE.isDiffKind(editor)) {
                    return null;
                }
                int adjustedLineNumber = lineNumber - interval.getLines().getFirst() - 1;
                return adjustedLineNumber < 1 ? null : Integer.valueOf(adjustedLineNumber);
            }

            public Integer getMaxLineNumber(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                return editor.getDocument().getLineCount();
            }
        };
    }
}

