/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.executor;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.executor.JupyterExecutionManager;
import com.intellij.jupyter.core.executor.info.JupyterExecutionStateImpl;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\bf\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH&J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0003H&J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011H&J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013H&R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0015\u00c0\u0006\u0001"}, d2={"Lcom/intellij/jupyter/core/executor/JupyterExecutionState;", "", "lastExecutingCell", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "getLastExecutingCell", "()Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "lastExecutingStatus", "Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "getLastExecutingStatus", "()Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "hasOutput", "", "cellPointer", "session", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;", "getProgressStatus", "cellOrdinal", "", "getQueued", "", "Companion", "intellij.jupyter.core"})
public interface JupyterExecutionState {
    @NotNull
    public static final Companion Companion = com.intellij.jupyter.core.executor.JupyterExecutionState$Companion.$$INSTANCE;

    @Nullable
    public NotebookIntervalPointer getLastExecutingCell();

    @Nullable
    public ProgressStatus getLastExecutingStatus();

    public boolean hasOutput(@NotNull NotebookIntervalPointer var1, @NotNull JupyterNotebookSession var2);

    @Nullable
    public ProgressStatus getProgressStatus(@NotNull NotebookIntervalPointer var1);

    @Nullable
    public ProgressStatus getProgressStatus(int var1);

    @NotNull
    public List<NotebookIntervalPointer> getQueued();

    @JvmStatic
    @NotNull
    public static JupyterExecutionState getInstance(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookVirtualFile2) {
        return Companion.getInstance(project, notebookVirtualFile2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0007J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\u0004\u0018\u00010\u0006*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000b\u001a\u0004\u0018\u00010\u0006*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lcom/intellij/jupyter/core/executor/JupyterExecutionState$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/jupyter/core/executor/JupyterExecutionState;", "install", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "jupyterExecutionState", "Lcom/intellij/openapi/editor/Editor;", "getJupyterExecutionState", "(Lcom/intellij/openapi/editor/Editor;)Lcom/intellij/jupyter/core/executor/JupyterExecutionState;", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "(Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)Lcom/intellij/jupyter/core/executor/JupyterExecutionState;", "getInstance", "project", "Lcom/intellij/openapi/project/Project;", "notebookVirtualFile", "hasOutputInCurrentSession", "", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterExecutionState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterExecutionState.kt\ncom/intellij/jupyter/core/executor/JupyterExecutionState$Companion\n+ 2 UserDataHolderEx.kt\ncom/intellij/openapi/util/UserDataHolderExKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n11#2:87\n12#2:89\n1#3:88\n*S KotlinDebug\n*F\n+ 1 JupyterExecutionState.kt\ncom/intellij/jupyter/core/executor/JupyterExecutionState$Companion\n*L\n56#1:87\n56#1:89\n56#1:88\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Key<JupyterExecutionState> KEY;

        private Companion() {
        }

        public final void install(@NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)editor);
            if (backedNotebookVirtualFile == null) {
                return;
            }
            BackedNotebookVirtualFile notebookVirtualFile2 = backedNotebookVirtualFile;
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            this.getInstance(project2, notebookVirtualFile2);
        }

        @Nullable
        public final JupyterExecutionState getJupyterExecutionState(@NotNull Editor $this$jupyterExecutionState) {
            Intrinsics.checkNotNullParameter((Object)$this$jupyterExecutionState, (String)"<this>");
            BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull($this$jupyterExecutionState);
            return backedNotebookVirtualFile != null ? this.getJupyterExecutionState(backedNotebookVirtualFile) : null;
        }

        @Nullable
        public final JupyterExecutionState getJupyterExecutionState(@NotNull BackedNotebookVirtualFile $this$jupyterExecutionState) {
            Intrinsics.checkNotNullParameter((Object)$this$jupyterExecutionState, (String)"<this>");
            return (JupyterExecutionState)$this$jupyterExecutionState.getFile().getUserData(KEY);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final JupyterExecutionState getInstance(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookVirtualFile2) {
            Object object;
            void $this$getOrCreateUserData$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)notebookVirtualFile2, (String)"notebookVirtualFile");
            UserDataHolderEx userDataHolderEx = (UserDataHolderEx)notebookVirtualFile2.getFile();
            Key<JupyterExecutionState> key$iv = KEY;
            boolean $i$f$getOrCreateUserData = false;
            Object object2 = $this$getOrCreateUserData$iv.getUserData(key$iv);
            if (object2 != null) {
                Object it$iv = object2;
                boolean bl = false;
                object = it$iv;
            } else {
                Key<JupyterExecutionState> key = key$iv;
                void var11_9 = $this$getOrCreateUserData$iv;
                boolean bl = false;
                Disposable disposable = notebookVirtualFile2.getFileDisposable();
                if (disposable == null) {
                    throw new IllegalStateException("File disposable should be not null".toString());
                }
                Disposable fileDisposable = disposable;
                JupyterExecutionStateImpl created = new JupyterExecutionStateImpl(project, notebookVirtualFile2);
                Disposer.register((Disposable)fileDisposable, (Disposable)((Disposable)created));
                Disposer.register((Disposable)fileDisposable, () -> Companion.getInstance$lambda$0$0(notebookVirtualFile2));
                JupyterExecutionState jupyterExecutionState = created;
                Object object3 = var11_9.putUserDataIfAbsent(key, (Object)jupyterExecutionState);
                object = object3;
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"putUserDataIfAbsent(...)");
            }
            return (JupyterExecutionState)object;
        }

        public final boolean hasOutputInCurrentSession(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookVirtualFile2, @NotNull NotebookIntervalPointer cellPointer) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)notebookVirtualFile2, (String)"notebookVirtualFile");
            Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
            if (project.isDisposed()) {
                return false;
            }
            JupyterNotebookSession jupyterNotebookSession = JupyterExecutionManager.Companion.getInstance(project, notebookVirtualFile2).getSession();
            if (jupyterNotebookSession == null) {
                return false;
            }
            JupyterNotebookSession session = jupyterNotebookSession;
            return this.getInstance(project, notebookVirtualFile2).hasOutput(cellPointer, session);
        }

        public final boolean hasOutputInCurrentSession(@NotNull Editor editor, @NotNull NotebookIntervalPointer cellPointer) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
            Project project = editor.getProject();
            if (project == null) {
                return false;
            }
            Project project2 = project;
            BackedNotebookVirtualFile backedNotebookVirtualFile = (BackedNotebookVirtualFile)ActionsKt.runReadAction(() -> Companion.hasOutputInCurrentSession$lambda$0(editor));
            if (backedNotebookVirtualFile == null) {
                return false;
            }
            BackedNotebookVirtualFile notebookVirtualFile2 = backedNotebookVirtualFile;
            return this.hasOutputInCurrentSession(project2, notebookVirtualFile2, cellPointer);
        }

        private static final void getInstance$lambda$0$0(BackedNotebookVirtualFile $notebookVirtualFile) {
            RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)$notebookVirtualFile.getFile()), KEY);
        }

        private static final BackedNotebookVirtualFile hasOutputInCurrentSession$lambda$0(Editor $editor) {
            return JupyterEditorExtensionsKt.getNotebookFileOrNull($editor);
        }

        static {
            $$INSTANCE = new Companion();
            Key key = Key.create((String)JupyterExecutionState.class.getName());
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
            KEY = key;
        }
    }
}

