/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.actions;

import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditorProvider;
import com.intellij.jupyter.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001aP\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00032\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"createFileFromTemplateWithProperties", "Lcom/intellij/psi/PsiFile;", "name", "", "template", "Lcom/intellij/ide/fileTemplates/FileTemplate;", "dir", "Lcom/intellij/psi/PsiDirectory;", "defaultTemplateProperty", "templateValues", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "openFile", "", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\ncreateNotebook.kt\nKotlin\n*S Kotlin\n*F\n+ 1 createNotebook.kt\ncom/intellij/jupyter/core/jupyter/actions/CreateNotebookKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,59:1\n216#2,2:60\n*S KotlinDebug\n*F\n+ 1 createNotebook.kt\ncom/intellij/jupyter/core/jupyter/actions/CreateNotebookKt\n*L\n33#1:60,2\n*E\n"})
public final class CreateNotebookKt {
    @Nullable
    public static final PsiFile createFileFromTemplateWithProperties(@NotNull String name, @NotNull FileTemplate template, @NotNull PsiDirectory dir, @Nullable String defaultTemplateProperty, @NotNull Map<String, String> templateValues, @NotNull Logger logger, boolean openFile) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(templateValues, (String)"templateValues");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        CreateFileAction.MkDirs mkdirs = new CreateFileAction.MkDirs(name, dir);
        String string = mkdirs.newName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newName");
        String actualFileName = string;
        PsiDirectory psiDirectory = mkdirs.directory;
        Intrinsics.checkNotNullExpressionValue((Object)psiDirectory, (String)"directory");
        PsiDirectory actualDir = psiDirectory;
        Project project = actualDir.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        try {
            Properties properties = FileTemplateManager.getInstance((Project)actualDir.getProject()).getDefaultProperties();
            Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getDefaultProperties(...)");
            Properties properties2 = properties;
            Map<String, String> $this$forEach$iv = templateValues;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl = false;
                String key = entry.getKey();
                String value = entry.getValue();
                ((Map)properties2).put(key, value);
            }
            PsiFile psiFile = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)actualFileName, (Properties)properties2, (PsiDirectory)actualDir).getContainingFile();
            SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)project2).createSmartPsiElementPointer((PsiElement)psiFile);
            Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createSmartPsiElementPointer(...)");
            SmartPsiElementPointer pointer = smartPsiElementPointer;
            VirtualFile virtualFile = psiFile.getVirtualFile();
            virtualFile.putUserData(FileEditorProvider.KEY, (Object)new JupyterFileEditorProvider());
            if (virtualFile != null) {
                if (openFile && !(virtualFile instanceof JupyterRemoteVirtualFile)) {
                    FileEditorManager.getInstance((Project)project2).openFile(virtualFile, true);
                }
                if (defaultTemplateProperty != null) {
                    PropertiesComponent.getInstance((Project)project2).setValue(defaultTemplateProperty, template.getName());
                }
                if (virtualFile instanceof JupyterRemoteVirtualFile) {
                    return null;
                }
                return (PsiFile)pointer.getElement();
            }
        }
        catch (IncorrectOperationException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return null;
    }

    public static /* synthetic */ PsiFile createFileFromTemplateWithProperties$default(String string, FileTemplate fileTemplate, PsiDirectory psiDirectory, String string2, Map map, Logger logger, boolean bl, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl = true;
        }
        return CreateNotebookKt.createFileFromTemplateWithProperties(string, fileTemplate, psiDirectory, string2, map, logger, bl);
    }
}

