/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.execution.notebook;

import com.intellij.jupyter.core.jupyter.JupyterRemoteBundle;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterKernelSpec;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014J\u0006\u0010\u000f\u001a\u00020\u0006R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/execution/notebook/JupyterKernelChooser;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "kernels", "", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterKernelSpec;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "getKernels", "()Ljava/util/List;", "selectedKernel", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "createCenterPanel", "Ljavax/swing/JComponent;", "getSelectedKernel", "intellij.jupyter.core"})
public final class JupyterKernelChooser
extends DialogWrapper {
    @NotNull
    private final List<JupyterKernelSpec> kernels;
    @NotNull
    private final AtomicProperty<JupyterKernelSpec> selectedKernel;

    public JupyterKernelChooser(@NotNull Project project, @NotNull List<? extends JupyterKernelSpec> kernels) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(kernels, (String)"kernels");
        super(project);
        this.kernels = kernels;
        this.selectedKernel = new AtomicProperty(CollectionsKt.first(this.kernels));
        this.setTitle(JupyterRemoteBundle.message("change.jupyter.kernel.dialog.choose.title", new Object[0]));
        this.init();
    }

    @NotNull
    public final List<JupyterKernelSpec> getKernels() {
        return this.kernels;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> JupyterKernelChooser.createCenterPanel$lambda$0(this, arg_0));
    }

    @NotNull
    public final JupyterKernelSpec getSelectedKernel() {
        return (JupyterKernelSpec)this.selectedKernel.get();
    }

    private static final Unit createCenterPanel$lambda$0(JupyterKernelChooser this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row(JupyterRemoteBundle.message("change.jupyter.kernel.dialog.choose.label", new Object[0]), arg_0 -> JupyterKernelChooser.createCenterPanel$lambda$0$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0(JupyterKernelChooser this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ComboBoxKt.bindItem((Cell)$this$row.comboBox((Collection)this$0.kernels, (ListCellRenderer)new SimpleListCellRenderer<JupyterKernelSpec>(){

            public void customize(JList<? extends JupyterKernelSpec> list, JupyterKernelSpec value, int index, boolean selected, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(list, (String)"list");
                JupyterKernelSpec jupyterKernelSpec = value;
                this.setText(jupyterKernelSpec != null ? jupyterKernelSpec.getDisplayName() : null);
            }
        }), (ObservableMutableProperty)((ObservableMutableProperty)this$0.selectedKernel));
        return Unit.INSTANCE;
    }
}

