const container = document.getElementById("{CONTAINER_NAME}")
const errorContainer = document.getElementById('error_container')

const originalFetch = window.fetch

window.fetch = function errorFetch(...args) {
  return originalFetch(...args)
    .then(res => {
      if (res.headers.has("Show-Ide-Error")) {
        container.remove()
        res.text().then(html => {
          document.body.innerHTML = html
        })
      }
      return res
    })
}

window.onerror = function (message, url, line, col, errorObj) {
  // when scripts were not downloaded, then render this error also as custom
  container.remove()
  renderCustomError(message)
}

async function renderCustomError(text) {
  fetch("{ERROR_HTML_PAGE_URL}").then(templateResponse => {
    return templateResponse.text().then(htmlTemplate => {
      return htmlTemplate.replace("{ERROR}", text)
    })
  }).then(html => {
    document.body.innerHTML = html
  })
}