"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Info = void 0;
var react_1 = __importDefault(require("react"));
var components_1 = require("../../components");
var contexts_1 = require("../../contexts");
var constants_1 = require("../../constants");
var Info = function () {
    var _a, _b, _c, _d, _e, _f, _g;
    var asyncapi = (0, contexts_1.useSpec)();
    var info = asyncapi.info();
    if (!info) {
        return null;
    }
    var specId = asyncapi.info().id();
    var externalDocs = asyncapi.info().externalDocs();
    var license = info.license();
    var termsOfService = info.termsOfService();
    var defaultContentType = asyncapi.defaultContentType();
    var contact = info.contact();
    var extensions = info.extensions();
    var showInfoList = (_c = (_b = (_a = license !== null && license !== void 0 ? license : termsOfService) !== null && _a !== void 0 ? _a : defaultContentType) !== null && _b !== void 0 ? _b : contact) !== null && _c !== void 0 ? _c : externalDocs;
    return (react_1.default.createElement("div", { className: "panel-item" },
        react_1.default.createElement("div", { className: "panel-item--center px-8 text-left", id: "introduction" },
            react_1.default.createElement("div", { className: "text-4xl" },
                info.title(),
                "\u00A0",
                info.version()),
            showInfoList && (react_1.default.createElement("ul", { className: "flex flex-wrap mt-2 leading-normal" },
                license && (react_1.default.createElement("li", { className: "inline-block mt-2 mr-2" }, license.url() ? (react_1.default.createElement(components_1.Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: (_d = license.url()) !== null && _d !== void 0 ? _d : '' },
                    react_1.default.createElement("span", null, license.name()))) : (react_1.default.createElement("strong", { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 no-underline text-xs uppercase rounded px-3 py-1" }, license.name())))),
                termsOfService && (react_1.default.createElement("li", { className: "inline-block mt-2 mr-2" },
                    react_1.default.createElement(components_1.Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: termsOfService },
                        react_1.default.createElement("span", null, constants_1.TERMS_OF_SERVICE_TEXT)))),
                defaultContentType && (react_1.default.createElement("li", { className: "inline-block mt-2 mr-2" },
                    react_1.default.createElement(components_1.Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: "".concat(constants_1.CONTENT_TYPES_SITE, "/").concat(defaultContentType) },
                        react_1.default.createElement("span", null, defaultContentType)))),
                externalDocs && (react_1.default.createElement("li", { className: "inline-block mt-2 mr-2" },
                    react_1.default.createElement(components_1.Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: externalDocs.url(), title: (_e = externalDocs.description()) !== null && _e !== void 0 ? _e : undefined },
                        react_1.default.createElement("span", null, constants_1.EXTERAL_DOCUMENTATION_TEXT)))),
                contact && (react_1.default.createElement(react_1.default.Fragment, null,
                    contact.url() && (react_1.default.createElement("li", { className: "inline-block mt-2 mr-2" },
                        react_1.default.createElement(components_1.Href, { className: "border border-solid border-purple-300 hover:bg-purple-300 hover:text-purple-600 text-purple-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: (_f = contact.url()) !== null && _f !== void 0 ? _f : '' },
                            react_1.default.createElement("span", null, (_g = contact.name()) !== null && _g !== void 0 ? _g : constants_1.URL_SUPPORT_TEXT)))),
                    contact.email() && (react_1.default.createElement("li", { className: "inline-block mt-2 mr-2" },
                        react_1.default.createElement(components_1.Href, { className: "border border-solid border-purple-300 hover:bg-purple-300 hover:text-purple-600 text-purple-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: "mailto:".concat(contact.email()) },
                            react_1.default.createElement("span", null, contact.email())))))),
                specId && (react_1.default.createElement("li", { className: "inline-block mt-2 mr-2" },
                    react_1.default.createElement("strong", { className: "border border-solid border-blue-300 hover:bg-blue-300 hover:text-blue-600 text-blue-500 no-underline text-xs uppercase rounded px-3 py-1" },
                        "ID: ",
                        specId))))),
            info.hasDescription() && (react_1.default.createElement("div", { className: "mt-4" },
                react_1.default.createElement(components_1.Markdown, null, info.description()))),
            asyncapi.info().tags().length > 0 && (react_1.default.createElement("div", { className: "mt-4" },
                react_1.default.createElement(components_1.Tags, { tags: asyncapi.info().tags() }))),
            extensions.length > 0 && (react_1.default.createElement("div", { className: "mt-4" },
                react_1.default.createElement(components_1.Extensions, { name: "Info Extensions", item: info })))),
        react_1.default.createElement("div", { className: "panel-item--right" })));
};
exports.Info = Info;
//# sourceMappingURL=Info.js.map