/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;

public class ModuleParallelDeployHelper {
    public static final int DEFAULT_DEPLOYMENT_THREADS = 3;

    public void deployArtifacts(ArtifactoryBuildInfoClient client, Map<String, Set<DeployDetails>> deployableArtifactsByModule, int publishForkCount) {
        if (publishForkCount <= 1) {
            deployableArtifactsByModule.forEach((module, deployableArtifacts) -> this.deploy(client, (Set<DeployDetails>)deployableArtifacts, null));
        } else {
            try {
                ExecutorService executor = Executors.newFixedThreadPool(publishForkCount);
                CompletableFuture<Void> allDeployments = CompletableFuture.allOf((CompletableFuture[])deployableArtifactsByModule.values().stream().map(deployDetails -> CompletableFuture.runAsync(() -> this.deploy(client, (Set<DeployDetails>)deployDetails, "[" + Thread.currentThread().getName() + "]"), executor)).toArray(CompletableFuture[]::new));
                allDeployments.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void deploy(ArtifactoryBuildInfoClient client, Set<DeployDetails> deployableArtifacts, String logPrefix) {
        deployableArtifacts.forEach(artifact -> {
            try {
                client.deployArtifact((DeployDetails)artifact, logPrefix);
            }
            catch (IOException e) {
                throw new RuntimeException("Error occurred while publishing artifact to Artifactory: " + artifact.getFile() + ".\n Skipping deployment of remaining artifacts (if any) and build info.", e);
            }
        });
    }
}

