#ifndef __VMLINUX_H__
#define __VMLINUX_H__

#ifndef BPF_NO_PRESERVE_ACCESS_INDEX
#pragma clang attribute push (__attribute__((preserve_access_index)), apply_to = record)
#endif

#ifndef __ksym
#define __ksym __attribute__((section(".ksyms")))
#endif

#ifndef __weak
#define __weak __attribute__((weak))
#endif

#ifndef __bpf_fastcall
#if __has_attribute(bpf_fastcall)
#define __bpf_fastcall __attribute__((bpf_fastcall))
#else
#define __bpf_fastcall
#endif
#endif

enum {
	ACOMP_WALK_SLEEP = 1,
	ACOMP_WALK_SRC_LINEAR = 2,
	ACOMP_WALK_DST_LINEAR = 4,
};

enum {
	ACPI_BATTERY_ALARM_PRESENT = 0,
	ACPI_BATTERY_XINFO_PRESENT = 1,
	ACPI_BATTERY_QUIRK_PERCENTAGE_CAPACITY = 2,
	ACPI_BATTERY_QUIRK_THINKPAD_MAH = 3,
	ACPI_BATTERY_QUIRK_DEGRADED_FULL_CHARGE = 4,
};

enum {
	ACPI_BUTTON_LID_INIT_IGNORE = 0,
	ACPI_BUTTON_LID_INIT_OPEN = 1,
	ACPI_BUTTON_LID_INIT_METHOD = 2,
	ACPI_BUTTON_LID_INIT_DISABLED = 3,
};

enum {
	ACPI_GENL_ATTR_UNSPEC = 0,
	ACPI_GENL_ATTR_EVENT = 1,
	__ACPI_GENL_ATTR_MAX = 2,
};

enum {
	ACPI_GENL_CMD_UNSPEC = 0,
	ACPI_GENL_CMD_EVENT = 1,
	__ACPI_GENL_CMD_MAX = 2,
};

enum {
	ACPI_REFCLASS_LOCAL = 0,
	ACPI_REFCLASS_ARG = 1,
	ACPI_REFCLASS_REFOF = 2,
	ACPI_REFCLASS_INDEX = 3,
	ACPI_REFCLASS_TABLE = 4,
	ACPI_REFCLASS_NAME = 5,
	ACPI_REFCLASS_DEBUG = 6,
	ACPI_REFCLASS_MAX = 6,
};

enum {
	ACPI_RSC_INITGET = 0,
	ACPI_RSC_INITSET = 1,
	ACPI_RSC_FLAGINIT = 2,
	ACPI_RSC_1BITFLAG = 3,
	ACPI_RSC_2BITFLAG = 4,
	ACPI_RSC_3BITFLAG = 5,
	ACPI_RSC_6BITFLAG = 6,
	ACPI_RSC_ADDRESS = 7,
	ACPI_RSC_BITMASK = 8,
	ACPI_RSC_BITMASK16 = 9,
	ACPI_RSC_COUNT = 10,
	ACPI_RSC_COUNT16 = 11,
	ACPI_RSC_COUNT_GPIO_PIN = 12,
	ACPI_RSC_COUNT_GPIO_RES = 13,
	ACPI_RSC_COUNT_GPIO_VEN = 14,
	ACPI_RSC_COUNT_SERIAL_RES = 15,
	ACPI_RSC_COUNT_SERIAL_VEN = 16,
	ACPI_RSC_DATA8 = 17,
	ACPI_RSC_EXIT_EQ = 18,
	ACPI_RSC_EXIT_LE = 19,
	ACPI_RSC_EXIT_NE = 20,
	ACPI_RSC_LENGTH = 21,
	ACPI_RSC_MOVE_GPIO_PIN = 22,
	ACPI_RSC_MOVE_GPIO_RES = 23,
	ACPI_RSC_MOVE_SERIAL_RES = 24,
	ACPI_RSC_MOVE_SERIAL_VEN = 25,
	ACPI_RSC_MOVE8 = 26,
	ACPI_RSC_MOVE16 = 27,
	ACPI_RSC_MOVE32 = 28,
	ACPI_RSC_MOVE64 = 29,
	ACPI_RSC_SET8 = 30,
	ACPI_RSC_SOURCE = 31,
	ACPI_RSC_SOURCEX = 32,
};

enum {
	ACTION_FAIL = 0,
	ACTION_REPREP = 1,
	ACTION_DELAYED_REPREP = 2,
	ACTION_RETRY = 3,
	ACTION_DELAYED_RETRY = 4,
};

enum {
	AFFINITY = 0,
	AFFINITY_LIST = 1,
	EFFECTIVE = 2,
	EFFECTIVE_LIST = 3,
};

enum {
	AHCI_MAX_PORTS = 32,
	AHCI_MAX_SG = 168,
	AHCI_DMA_BOUNDARY = 4294967295,
	AHCI_MAX_CMDS = 32,
	AHCI_CMD_SZ = 32,
	AHCI_CMD_SLOT_SZ = 1024,
	AHCI_RX_FIS_SZ = 256,
	AHCI_CMD_TBL_CDB = 64,
	AHCI_CMD_TBL_HDR_SZ = 128,
	AHCI_CMD_TBL_SZ = 2816,
	AHCI_CMD_TBL_AR_SZ = 90112,
	AHCI_PORT_PRIV_DMA_SZ = 91392,
	AHCI_PORT_PRIV_FBS_DMA_SZ = 95232,
	AHCI_IRQ_ON_SG = 2147483648,
	AHCI_CMD_ATAPI = 32,
	AHCI_CMD_WRITE = 64,
	AHCI_CMD_PREFETCH = 128,
	AHCI_CMD_RESET = 256,
	AHCI_CMD_CLR_BUSY = 1024,
	RX_FIS_PIO_SETUP = 32,
	RX_FIS_D2H_REG = 64,
	RX_FIS_SDB = 88,
	RX_FIS_UNK = 96,
	HOST_CAP = 0,
	HOST_CTL = 4,
	HOST_IRQ_STAT = 8,
	HOST_PORTS_IMPL = 12,
	HOST_VERSION = 16,
	HOST_EM_LOC = 28,
	HOST_EM_CTL = 32,
	HOST_CAP2 = 36,
	HOST_RESET = 1,
	HOST_IRQ_EN = 2,
	HOST_MRSM = 4,
	HOST_AHCI_EN = 2147483648,
	HOST_CAP_SXS = 32,
	HOST_CAP_EMS = 64,
	HOST_CAP_CCC = 128,
	HOST_CAP_PART = 8192,
	HOST_CAP_SSC = 16384,
	HOST_CAP_PIO_MULTI = 32768,
	HOST_CAP_FBS = 65536,
	HOST_CAP_PMP = 131072,
	HOST_CAP_ONLY = 262144,
	HOST_CAP_CLO = 16777216,
	HOST_CAP_LED = 33554432,
	HOST_CAP_ALPM = 67108864,
	HOST_CAP_SSS = 134217728,
	HOST_CAP_MPS = 268435456,
	HOST_CAP_SNTF = 536870912,
	HOST_CAP_NCQ = 1073741824,
	HOST_CAP_64 = 2147483648,
	HOST_CAP2_BOH = 1,
	HOST_CAP2_NVMHCI = 2,
	HOST_CAP2_APST = 4,
	HOST_CAP2_SDS = 8,
	HOST_CAP2_SADM = 16,
	HOST_CAP2_DESO = 32,
	PORT_LST_ADDR = 0,
	PORT_LST_ADDR_HI = 4,
	PORT_FIS_ADDR = 8,
	PORT_FIS_ADDR_HI = 12,
	PORT_IRQ_STAT = 16,
	PORT_IRQ_MASK = 20,
	PORT_CMD = 24,
	PORT_TFDATA = 32,
	PORT_SIG = 36,
	PORT_CMD_ISSUE = 56,
	PORT_SCR_STAT = 40,
	PORT_SCR_CTL = 44,
	PORT_SCR_ERR = 48,
	PORT_SCR_ACT = 52,
	PORT_SCR_NTF = 60,
	PORT_FBS = 64,
	PORT_DEVSLP = 68,
	PORT_IRQ_COLD_PRES = 2147483648,
	PORT_IRQ_TF_ERR = 1073741824,
	PORT_IRQ_HBUS_ERR = 536870912,
	PORT_IRQ_HBUS_DATA_ERR = 268435456,
	PORT_IRQ_IF_ERR = 134217728,
	PORT_IRQ_IF_NONFATAL = 67108864,
	PORT_IRQ_OVERFLOW = 16777216,
	PORT_IRQ_BAD_PMP = 8388608,
	PORT_IRQ_PHYRDY = 4194304,
	PORT_IRQ_DMPS = 128,
	PORT_IRQ_CONNECT = 64,
	PORT_IRQ_SG_DONE = 32,
	PORT_IRQ_UNK_FIS = 16,
	PORT_IRQ_SDB_FIS = 8,
	PORT_IRQ_DMAS_FIS = 4,
	PORT_IRQ_PIOS_FIS = 2,
	PORT_IRQ_D2H_REG_FIS = 1,
	PORT_IRQ_FREEZE = 683671632,
	PORT_IRQ_ERROR = 2025848912,
	DEF_PORT_IRQ = 2025848959,
	PORT_CMD_ASP = 134217728,
	PORT_CMD_ALPE = 67108864,
	PORT_CMD_ATAPI = 16777216,
	PORT_CMD_FBSCP = 4194304,
	PORT_CMD_ESP = 2097152,
	PORT_CMD_CPD = 1048576,
	PORT_CMD_MPSP = 524288,
	PORT_CMD_HPCP = 262144,
	PORT_CMD_PMP = 131072,
	PORT_CMD_LIST_ON = 32768,
	PORT_CMD_FIS_ON = 16384,
	PORT_CMD_FIS_RX = 16,
	PORT_CMD_CLO = 8,
	PORT_CMD_POWER_ON = 4,
	PORT_CMD_SPIN_UP = 2,
	PORT_CMD_START = 1,
	PORT_CMD_ICC_MASK = 4026531840,
	PORT_CMD_ICC_ACTIVE = 268435456,
	PORT_CMD_ICC_PARTIAL = 536870912,
	PORT_CMD_ICC_SLUMBER = 1610612736,
	PORT_CMD_CAP = 8126464,
	PORT_FBS_DWE_OFFSET = 16,
	PORT_FBS_ADO_OFFSET = 12,
	PORT_FBS_DEV_OFFSET = 8,
	PORT_FBS_DEV_MASK = 3840,
	PORT_FBS_SDE = 4,
	PORT_FBS_DEC = 2,
	PORT_FBS_EN = 1,
	PORT_DEVSLP_DM_OFFSET = 25,
	PORT_DEVSLP_DM_MASK = 503316480,
	PORT_DEVSLP_DITO_OFFSET = 15,
	PORT_DEVSLP_MDAT_OFFSET = 10,
	PORT_DEVSLP_DETO_OFFSET = 2,
	PORT_DEVSLP_DSP = 2,
	PORT_DEVSLP_ADSE = 1,
	AHCI_HFLAG_NO_NCQ = 1,
	AHCI_HFLAG_IGN_IRQ_IF_ERR = 2,
	AHCI_HFLAG_IGN_SERR_INTERNAL = 4,
	AHCI_HFLAG_32BIT_ONLY = 8,
	AHCI_HFLAG_MV_PATA = 16,
	AHCI_HFLAG_NO_MSI = 32,
	AHCI_HFLAG_NO_PMP = 64,
	AHCI_HFLAG_SECT255 = 256,
	AHCI_HFLAG_YES_NCQ = 512,
	AHCI_HFLAG_NO_SUSPEND = 1024,
	AHCI_HFLAG_SRST_TOUT_IS_OFFLINE = 2048,
	AHCI_HFLAG_NO_SNTF = 4096,
	AHCI_HFLAG_NO_FPDMA_AA = 8192,
	AHCI_HFLAG_YES_FBS = 16384,
	AHCI_HFLAG_DELAY_ENGINE = 32768,
	AHCI_HFLAG_NO_DEVSLP = 131072,
	AHCI_HFLAG_NO_FBS = 262144,
	AHCI_HFLAG_MULTI_MSI = 1048576,
	AHCI_HFLAG_WAKE_BEFORE_STOP = 4194304,
	AHCI_HFLAG_YES_ALPM = 8388608,
	AHCI_HFLAG_NO_WRITE_TO_RO = 16777216,
	AHCI_HFLAG_SUSPEND_PHYS = 33554432,
	AHCI_HFLAG_NO_SXS = 67108864,
	AHCI_HFLAG_43BIT_ONLY = 134217728,
	AHCI_HFLAG_INTEL_PCS_QUIRK = 268435456,
	AHCI_HFLAG_ATAPI_DMA_QUIRK = 536870912,
	AHCI_FLAG_COMMON = 393346,
	ICH_MAP = 144,
	PCS_6 = 146,
	PCS_7 = 148,
	EM_MAX_SLOTS = 15,
	EM_MAX_RETRY = 5,
	EM_CTL_RST = 512,
	EM_CTL_TM = 256,
	EM_CTL_MR = 1,
	EM_CTL_ALHD = 67108864,
	EM_CTL_XMT = 33554432,
	EM_CTL_SMB = 16777216,
	EM_CTL_SGPIO = 524288,
	EM_CTL_SES = 262144,
	EM_CTL_SAFTE = 131072,
	EM_CTL_LED = 65536,
	EM_MSG_TYPE_LED = 1,
	EM_MSG_TYPE_SAFTE = 2,
	EM_MSG_TYPE_SES2 = 4,
	EM_MSG_TYPE_SGPIO = 8,
};

enum {
	AHCI_PCI_BAR_STA2X11 = 0,
	AHCI_PCI_BAR_CAVIUM = 0,
	AHCI_PCI_BAR_LOONGSON = 0,
	AHCI_PCI_BAR_ENMOTUS = 2,
	AHCI_PCI_BAR_CAVIUM_GEN5 = 4,
	AHCI_PCI_BAR_STANDARD = 5,
};

enum {
	ALE_ENT_VID_MEMBER_LIST = 0,
	ALE_ENT_VID_UNREG_MCAST_MSK = 1,
	ALE_ENT_VID_REG_MCAST_MSK = 2,
	ALE_ENT_VID_FORCE_UNTAGGED_MSK = 3,
	ALE_ENT_VID_UNREG_MCAST_IDX = 4,
	ALE_ENT_VID_REG_MCAST_IDX = 5,
	ALE_ENT_VID_LAST = 6,
};

enum {
	AM62A7_EFUSE_M_MPU_OPP = 13,
	AM62A7_EFUSE_N_MPU_OPP = 14,
	AM62A7_EFUSE_O_MPU_OPP = 15,
	AM62A7_EFUSE_P_MPU_OPP = 16,
	AM62A7_EFUSE_Q_MPU_OPP = 17,
	AM62A7_EFUSE_R_MPU_OPP = 18,
	AM62A7_EFUSE_S_MPU_OPP = 19,
	AM62A7_EFUSE_V_MPU_OPP = 20,
	AM62A7_EFUSE_U_MPU_OPP = 21,
	AM62A7_EFUSE_T_MPU_OPP = 22,
};

enum {
	AM65_CPSW_REGDUMP_MOD_NUSS = 1,
	AM65_CPSW_REGDUMP_MOD_RGMII_STATUS = 2,
	AM65_CPSW_REGDUMP_MOD_MDIO = 3,
	AM65_CPSW_REGDUMP_MOD_CPSW = 4,
	AM65_CPSW_REGDUMP_MOD_CPSW_P0 = 5,
	AM65_CPSW_REGDUMP_MOD_CPSW_P1 = 6,
	AM65_CPSW_REGDUMP_MOD_CPSW_CPTS = 7,
	AM65_CPSW_REGDUMP_MOD_CPSW_ALE = 8,
	AM65_CPSW_REGDUMP_MOD_CPSW_ALE_TBL = 9,
	AM65_CPSW_REGDUMP_MOD_LAST = 10,
};

enum {
	AML_FIELD_ACCESS_ANY = 0,
	AML_FIELD_ACCESS_BYTE = 1,
	AML_FIELD_ACCESS_WORD = 2,
	AML_FIELD_ACCESS_DWORD = 3,
	AML_FIELD_ACCESS_QWORD = 4,
	AML_FIELD_ACCESS_BUFFER = 5,
};

enum {
	AML_FIELD_ATTRIB_QUICK = 2,
	AML_FIELD_ATTRIB_SEND_RECEIVE = 4,
	AML_FIELD_ATTRIB_BYTE = 6,
	AML_FIELD_ATTRIB_WORD = 8,
	AML_FIELD_ATTRIB_BLOCK = 10,
	AML_FIELD_ATTRIB_BYTES = 11,
	AML_FIELD_ATTRIB_PROCESS_CALL = 12,
	AML_FIELD_ATTRIB_BLOCK_PROCESS_CALL = 13,
	AML_FIELD_ATTRIB_RAW_BYTES = 14,
	AML_FIELD_ATTRIB_RAW_PROCESS_BYTES = 15,
};

enum {
	AML_FIELD_UPDATE_PRESERVE = 0,
	AML_FIELD_UPDATE_WRITE_AS_ONES = 32,
	AML_FIELD_UPDATE_WRITE_AS_ZEROS = 64,
};

enum {
	APPLE_RTKIT_EP_MGMT = 0,
	APPLE_RTKIT_EP_CRASHLOG = 1,
	APPLE_RTKIT_EP_SYSLOG = 2,
	APPLE_RTKIT_EP_DEBUG = 3,
	APPLE_RTKIT_EP_IOREPORT = 4,
	APPLE_RTKIT_EP_OSLOG = 8,
};

enum {
	APPLE_RTKIT_MGMT_HELLO = 1,
	APPLE_RTKIT_MGMT_HELLO_REPLY = 2,
	APPLE_RTKIT_MGMT_STARTEP = 5,
	APPLE_RTKIT_MGMT_SET_IOP_PWR_STATE = 6,
	APPLE_RTKIT_MGMT_SET_IOP_PWR_STATE_ACK = 7,
	APPLE_RTKIT_MGMT_EPMAP = 8,
	APPLE_RTKIT_MGMT_EPMAP_REPLY = 8,
	APPLE_RTKIT_MGMT_SET_AP_PWR_STATE = 11,
	APPLE_RTKIT_MGMT_SET_AP_PWR_STATE_ACK = 11,
};

enum {
	APPLE_RTKIT_PWR_STATE_OFF = 0,
	APPLE_RTKIT_PWR_STATE_SLEEP = 1,
	APPLE_RTKIT_PWR_STATE_IDLE = 513,
	APPLE_RTKIT_PWR_STATE_QUIESCED = 16,
	APPLE_RTKIT_PWR_STATE_ON = 32,
	APPLE_RTKIT_PWR_STATE_INIT = 544,
};

enum {
	ARB_TIMER = 0,
	ARB_BP_CAP_CLR = 1,
	ARB_BP_CAP_HI_ADDR = 2,
	ARB_BP_CAP_ADDR = 3,
	ARB_BP_CAP_STATUS = 4,
	ARB_BP_CAP_MASTER = 5,
	ARB_ERR_CAP_CLR = 6,
	ARB_ERR_CAP_HI_ADDR = 7,
	ARB_ERR_CAP_ADDR = 8,
	ARB_ERR_CAP_STATUS = 9,
	ARB_ERR_CAP_MASTER = 10,
};

enum {
	ASCII_NULL = 0,
	ASCII_BELL = 7,
	ASCII_BACKSPACE = 8,
	ASCII_IGNORE_FIRST = 8,
	ASCII_HTAB = 9,
	ASCII_LINEFEED = 10,
	ASCII_VTAB = 11,
	ASCII_FORMFEED = 12,
	ASCII_CAR_RET = 13,
	ASCII_IGNORE_LAST = 13,
	ASCII_SHIFTOUT = 14,
	ASCII_SHIFTIN = 15,
	ASCII_CANCEL = 24,
	ASCII_SUBSTITUTE = 26,
	ASCII_ESCAPE = 27,
	ASCII_CSI_IGNORE_FIRST = 32,
	ASCII_CSI_IGNORE_LAST = 63,
	ASCII_DEL = 127,
	ASCII_EXT_CSI = 155,
};

enum {
	ASSUME_PERFECT = 255,
	ASSUME_VALID_DTB = 1,
	ASSUME_VALID_INPUT = 2,
	ASSUME_LATEST = 4,
	ASSUME_NO_ROLLBACK = 8,
	ASSUME_LIBFDT_ORDER = 16,
	ASSUME_LIBFDT_FLAWLESS = 32,
};

enum {
	ATA_EH_SPDN_NCQ_OFF = 1,
	ATA_EH_SPDN_SPEED_DOWN = 2,
	ATA_EH_SPDN_FALLBACK_TO_PIO = 4,
	ATA_EH_SPDN_KEEP_ERRORS = 8,
	ATA_EFLAG_IS_IO = 1,
	ATA_EFLAG_DUBIOUS_XFER = 2,
	ATA_EFLAG_OLD_ER = -2147483648,
	ATA_ECAT_NONE = 0,
	ATA_ECAT_ATA_BUS = 1,
	ATA_ECAT_TOUT_HSM = 2,
	ATA_ECAT_UNK_DEV = 3,
	ATA_ECAT_DUBIOUS_NONE = 4,
	ATA_ECAT_DUBIOUS_ATA_BUS = 5,
	ATA_ECAT_DUBIOUS_TOUT_HSM = 6,
	ATA_ECAT_DUBIOUS_UNK_DEV = 7,
	ATA_ECAT_NR = 8,
	ATA_EH_CMD_DFL_TIMEOUT = 5000,
	ATA_EH_RESET_COOL_DOWN = 5000,
	ATA_EH_PRERESET_TIMEOUT = 10000,
	ATA_EH_FASTDRAIN_INTERVAL = 3000,
	ATA_EH_UA_TRIES = 5,
	ATA_EH_PROBE_TRIAL_INTERVAL = 60000,
	ATA_EH_PROBE_TRIALS = 2,
};

enum {
	ATA_MAX_DEVICES = 2,
	ATA_MAX_PRD = 256,
	ATA_SECT_SIZE = 512,
	ATA_MAX_SECTORS_128 = 128,
	ATA_MAX_SECTORS = 256,
	ATA_MAX_SECTORS_1024 = 1024,
	ATA_MAX_SECTORS_LBA48 = 65535,
	ATA_MAX_SECTORS_TAPE = 65535,
	ATA_MAX_TRIM_RNUM = 64,
	ATA_ID_WORDS = 256,
	ATA_ID_CONFIG = 0,
	ATA_ID_CYLS = 1,
	ATA_ID_HEADS = 3,
	ATA_ID_SECTORS = 6,
	ATA_ID_SERNO = 10,
	ATA_ID_BUF_SIZE = 21,
	ATA_ID_FW_REV = 23,
	ATA_ID_PROD = 27,
	ATA_ID_MAX_MULTSECT = 47,
	ATA_ID_DWORD_IO = 48,
	ATA_ID_TRUSTED = 48,
	ATA_ID_CAPABILITY = 49,
	ATA_ID_OLD_PIO_MODES = 51,
	ATA_ID_OLD_DMA_MODES = 52,
	ATA_ID_FIELD_VALID = 53,
	ATA_ID_CUR_CYLS = 54,
	ATA_ID_CUR_HEADS = 55,
	ATA_ID_CUR_SECTORS = 56,
	ATA_ID_MULTSECT = 59,
	ATA_ID_LBA_CAPACITY = 60,
	ATA_ID_SWDMA_MODES = 62,
	ATA_ID_MWDMA_MODES = 63,
	ATA_ID_PIO_MODES = 64,
	ATA_ID_EIDE_DMA_MIN = 65,
	ATA_ID_EIDE_DMA_TIME = 66,
	ATA_ID_EIDE_PIO = 67,
	ATA_ID_EIDE_PIO_IORDY = 68,
	ATA_ID_ADDITIONAL_SUPP = 69,
	ATA_ID_QUEUE_DEPTH = 75,
	ATA_ID_SATA_CAPABILITY = 76,
	ATA_ID_SATA_CAPABILITY_2 = 77,
	ATA_ID_FEATURE_SUPP = 78,
	ATA_ID_MAJOR_VER = 80,
	ATA_ID_COMMAND_SET_1 = 82,
	ATA_ID_COMMAND_SET_2 = 83,
	ATA_ID_CFSSE = 84,
	ATA_ID_CFS_ENABLE_1 = 85,
	ATA_ID_CFS_ENABLE_2 = 86,
	ATA_ID_CSF_DEFAULT = 87,
	ATA_ID_UDMA_MODES = 88,
	ATA_ID_HW_CONFIG = 93,
	ATA_ID_SPG = 98,
	ATA_ID_LBA_CAPACITY_2 = 100,
	ATA_ID_SECTOR_SIZE = 106,
	ATA_ID_WWN = 108,
	ATA_ID_LOGICAL_SECTOR_SIZE = 117,
	ATA_ID_COMMAND_SET_3 = 119,
	ATA_ID_COMMAND_SET_4 = 120,
	ATA_ID_LAST_LUN = 126,
	ATA_ID_DLF = 128,
	ATA_ID_CSFO = 129,
	ATA_ID_CFA_POWER = 160,
	ATA_ID_CFA_KEY_MGMT = 162,
	ATA_ID_CFA_MODES = 163,
	ATA_ID_DATA_SET_MGMT = 169,
	ATA_ID_SCT_CMD_XPORT = 206,
	ATA_ID_ROT_SPEED = 217,
	ATA_ID_PIO4 = 2,
	ATA_ID_SERNO_LEN = 20,
	ATA_ID_FW_REV_LEN = 8,
	ATA_ID_PROD_LEN = 40,
	ATA_ID_WWN_LEN = 8,
	ATA_PCI_CTL_OFS = 2,
	ATA_PIO0 = 1,
	ATA_PIO1 = 3,
	ATA_PIO2 = 7,
	ATA_PIO3 = 15,
	ATA_PIO4 = 31,
	ATA_PIO5 = 63,
	ATA_PIO6 = 127,
	ATA_PIO4_ONLY = 16,
	ATA_SWDMA0 = 1,
	ATA_SWDMA1 = 3,
	ATA_SWDMA2 = 7,
	ATA_SWDMA2_ONLY = 4,
	ATA_MWDMA0 = 1,
	ATA_MWDMA1 = 3,
	ATA_MWDMA2 = 7,
	ATA_MWDMA3 = 15,
	ATA_MWDMA4 = 31,
	ATA_MWDMA12_ONLY = 6,
	ATA_MWDMA2_ONLY = 4,
	ATA_UDMA0 = 1,
	ATA_UDMA1 = 3,
	ATA_UDMA2 = 7,
	ATA_UDMA3 = 15,
	ATA_UDMA4 = 31,
	ATA_UDMA5 = 63,
	ATA_UDMA6 = 127,
	ATA_UDMA7 = 255,
	ATA_UDMA24_ONLY = 20,
	ATA_UDMA_MASK_40C = 7,
	ATA_PRD_SZ = 8,
	ATA_PRD_TBL_SZ = 2048,
	ATA_PRD_EOT = -2147483648,
	ATA_DMA_TABLE_OFS = 4,
	ATA_DMA_STATUS = 2,
	ATA_DMA_CMD = 0,
	ATA_DMA_WR = 8,
	ATA_DMA_START = 1,
	ATA_DMA_INTR = 4,
	ATA_DMA_ERR = 2,
	ATA_DMA_ACTIVE = 1,
	ATA_HOB = 128,
	ATA_NIEN = 2,
	ATA_LBA = 64,
	ATA_DEV1 = 16,
	ATA_DEVICE_OBS = 160,
	ATA_DEVCTL_OBS = 8,
	ATA_BUSY = 128,
	ATA_DRDY = 64,
	ATA_DF = 32,
	ATA_DSC = 16,
	ATA_DRQ = 8,
	ATA_CORR = 4,
	ATA_SENSE = 2,
	ATA_ERR = 1,
	ATA_SRST = 4,
	ATA_ICRC = 128,
	ATA_BBK = 128,
	ATA_UNC = 64,
	ATA_MC = 32,
	ATA_IDNF = 16,
	ATA_MCR = 8,
	ATA_ABORTED = 4,
	ATA_TRK0NF = 2,
	ATA_AMNF = 1,
	ATAPI_LFS = 240,
	ATAPI_EOM = 2,
	ATAPI_ILI = 1,
	ATAPI_IO = 2,
	ATAPI_COD = 1,
	ATA_REG_DATA = 0,
	ATA_REG_ERR = 1,
	ATA_REG_NSECT = 2,
	ATA_REG_LBAL = 3,
	ATA_REG_LBAM = 4,
	ATA_REG_LBAH = 5,
	ATA_REG_DEVICE = 6,
	ATA_REG_STATUS = 7,
	ATA_REG_FEATURE = 1,
	ATA_REG_CMD = 7,
	ATA_REG_BYTEL = 4,
	ATA_REG_BYTEH = 5,
	ATA_REG_DEVSEL = 6,
	ATA_REG_IRQ = 2,
	ATA_CMD_DEV_RESET = 8,
	ATA_CMD_CHK_POWER = 229,
	ATA_CMD_STANDBY = 226,
	ATA_CMD_IDLE = 227,
	ATA_CMD_EDD = 144,
	ATA_CMD_DOWNLOAD_MICRO = 146,
	ATA_CMD_DOWNLOAD_MICRO_DMA = 147,
	ATA_CMD_NOP = 0,
	ATA_CMD_FLUSH = 231,
	ATA_CMD_FLUSH_EXT = 234,
	ATA_CMD_ID_ATA = 236,
	ATA_CMD_ID_ATAPI = 161,
	ATA_CMD_SERVICE = 162,
	ATA_CMD_READ = 200,
	ATA_CMD_READ_EXT = 37,
	ATA_CMD_READ_QUEUED = 38,
	ATA_CMD_READ_STREAM_EXT = 43,
	ATA_CMD_READ_STREAM_DMA_EXT = 42,
	ATA_CMD_WRITE = 202,
	ATA_CMD_WRITE_EXT = 53,
	ATA_CMD_WRITE_QUEUED = 54,
	ATA_CMD_WRITE_STREAM_EXT = 59,
	ATA_CMD_WRITE_STREAM_DMA_EXT = 58,
	ATA_CMD_WRITE_FUA_EXT = 61,
	ATA_CMD_WRITE_QUEUED_FUA_EXT = 62,
	ATA_CMD_FPDMA_READ = 96,
	ATA_CMD_FPDMA_WRITE = 97,
	ATA_CMD_NCQ_NON_DATA = 99,
	ATA_CMD_FPDMA_SEND = 100,
	ATA_CMD_FPDMA_RECV = 101,
	ATA_CMD_PIO_READ = 32,
	ATA_CMD_PIO_READ_EXT = 36,
	ATA_CMD_PIO_WRITE = 48,
	ATA_CMD_PIO_WRITE_EXT = 52,
	ATA_CMD_READ_MULTI = 196,
	ATA_CMD_READ_MULTI_EXT = 41,
	ATA_CMD_WRITE_MULTI = 197,
	ATA_CMD_WRITE_MULTI_EXT = 57,
	ATA_CMD_WRITE_MULTI_FUA_EXT = 206,
	ATA_CMD_SET_FEATURES = 239,
	ATA_CMD_SET_MULTI = 198,
	ATA_CMD_PACKET = 160,
	ATA_CMD_VERIFY = 64,
	ATA_CMD_VERIFY_EXT = 66,
	ATA_CMD_WRITE_UNCORR_EXT = 69,
	ATA_CMD_STANDBYNOW1 = 224,
	ATA_CMD_IDLEIMMEDIATE = 225,
	ATA_CMD_SLEEP = 230,
	ATA_CMD_INIT_DEV_PARAMS = 145,
	ATA_CMD_READ_NATIVE_MAX = 248,
	ATA_CMD_READ_NATIVE_MAX_EXT = 39,
	ATA_CMD_SET_MAX = 249,
	ATA_CMD_SET_MAX_EXT = 55,
	ATA_CMD_READ_LOG_EXT = 47,
	ATA_CMD_WRITE_LOG_EXT = 63,
	ATA_CMD_READ_LOG_DMA_EXT = 71,
	ATA_CMD_WRITE_LOG_DMA_EXT = 87,
	ATA_CMD_TRUSTED_NONDATA = 91,
	ATA_CMD_TRUSTED_RCV = 92,
	ATA_CMD_TRUSTED_RCV_DMA = 93,
	ATA_CMD_TRUSTED_SND = 94,
	ATA_CMD_TRUSTED_SND_DMA = 95,
	ATA_CMD_PMP_READ = 228,
	ATA_CMD_PMP_READ_DMA = 233,
	ATA_CMD_PMP_WRITE = 232,
	ATA_CMD_PMP_WRITE_DMA = 235,
	ATA_CMD_CONF_OVERLAY = 177,
	ATA_CMD_SEC_SET_PASS = 241,
	ATA_CMD_SEC_UNLOCK = 242,
	ATA_CMD_SEC_ERASE_PREP = 243,
	ATA_CMD_SEC_ERASE_UNIT = 244,
	ATA_CMD_SEC_FREEZE_LOCK = 245,
	ATA_CMD_SEC_DISABLE_PASS = 246,
	ATA_CMD_CONFIG_STREAM = 81,
	ATA_CMD_SMART = 176,
	ATA_CMD_MEDIA_LOCK = 222,
	ATA_CMD_MEDIA_UNLOCK = 223,
	ATA_CMD_DSM = 6,
	ATA_CMD_CHK_MED_CRD_TYP = 209,
	ATA_CMD_CFA_REQ_EXT_ERR = 3,
	ATA_CMD_CFA_WRITE_NE = 56,
	ATA_CMD_CFA_TRANS_SECT = 135,
	ATA_CMD_CFA_ERASE = 192,
	ATA_CMD_CFA_WRITE_MULT_NE = 205,
	ATA_CMD_REQ_SENSE_DATA = 11,
	ATA_CMD_SANITIZE_DEVICE = 180,
	ATA_CMD_ZAC_MGMT_IN = 74,
	ATA_CMD_ZAC_MGMT_OUT = 159,
	ATA_CMD_RESTORE = 16,
	ATA_SUBCMD_FPDMA_RECV_RD_LOG_DMA_EXT = 1,
	ATA_SUBCMD_FPDMA_RECV_ZAC_MGMT_IN = 2,
	ATA_SUBCMD_FPDMA_SEND_DSM = 0,
	ATA_SUBCMD_FPDMA_SEND_WR_LOG_DMA_EXT = 2,
	ATA_SUBCMD_NCQ_NON_DATA_ABORT_QUEUE = 0,
	ATA_SUBCMD_NCQ_NON_DATA_SET_FEATURES = 5,
	ATA_SUBCMD_NCQ_NON_DATA_ZERO_EXT = 6,
	ATA_SUBCMD_NCQ_NON_DATA_ZAC_MGMT_OUT = 7,
	ATA_SUBCMD_ZAC_MGMT_IN_REPORT_ZONES = 0,
	ATA_SUBCMD_ZAC_MGMT_OUT_CLOSE_ZONE = 1,
	ATA_SUBCMD_ZAC_MGMT_OUT_FINISH_ZONE = 2,
	ATA_SUBCMD_ZAC_MGMT_OUT_OPEN_ZONE = 3,
	ATA_SUBCMD_ZAC_MGMT_OUT_RESET_WRITE_POINTER = 4,
	ATA_LOG_DIRECTORY = 0,
	ATA_LOG_SATA_NCQ = 16,
	ATA_LOG_NCQ_NON_DATA = 18,
	ATA_LOG_NCQ_SEND_RECV = 19,
	ATA_LOG_CDL = 24,
	ATA_LOG_CDL_SIZE = 512,
	ATA_LOG_IDENTIFY_DEVICE = 48,
	ATA_LOG_SENSE_NCQ = 15,
	ATA_LOG_SENSE_NCQ_SIZE = 1024,
	ATA_LOG_CONCURRENT_POSITIONING_RANGES = 71,
	ATA_LOG_SUPPORTED_CAPABILITIES = 3,
	ATA_LOG_CURRENT_SETTINGS = 4,
	ATA_LOG_SECURITY = 6,
	ATA_LOG_SATA_SETTINGS = 8,
	ATA_LOG_ZONED_INFORMATION = 9,
	ATA_LOG_DEVSLP_OFFSET = 48,
	ATA_LOG_DEVSLP_SIZE = 8,
	ATA_LOG_DEVSLP_MDAT = 0,
	ATA_LOG_DEVSLP_MDAT_MASK = 31,
	ATA_LOG_DEVSLP_DETO = 1,
	ATA_LOG_DEVSLP_VALID = 7,
	ATA_LOG_DEVSLP_VALID_MASK = 128,
	ATA_LOG_NCQ_PRIO_OFFSET = 9,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_DSM = 1,
	ATA_LOG_NCQ_SEND_RECV_DSM_OFFSET = 4,
	ATA_LOG_NCQ_SEND_RECV_DSM_TRIM = 1,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_OFFSET = 8,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_OFFSET = 12,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OFFSET = 16,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OUT_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_IN_SUPPORTED = 2,
	ATA_LOG_NCQ_SEND_RECV_SIZE = 20,
	ATA_LOG_NCQ_NON_DATA_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_NCQ = 1,
	ATA_LOG_NCQ_NON_DATA_ABORT_ALL = 2,
	ATA_LOG_NCQ_NON_DATA_ABORT_STREAMING = 4,
	ATA_LOG_NCQ_NON_DATA_ABORT_NON_STREAMING = 8,
	ATA_LOG_NCQ_NON_DATA_ABORT_SELECTED = 16,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OFFSET = 28,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OUT = 1,
	ATA_LOG_NCQ_NON_DATA_SIZE = 64,
	ATA_CMD_READ_LONG = 34,
	ATA_CMD_READ_LONG_ONCE = 35,
	ATA_CMD_WRITE_LONG = 50,
	ATA_CMD_WRITE_LONG_ONCE = 51,
	SETFEATURES_XFER = 3,
	XFER_UDMA_7 = 71,
	XFER_UDMA_6 = 70,
	XFER_UDMA_5 = 69,
	XFER_UDMA_4 = 68,
	XFER_UDMA_3 = 67,
	XFER_UDMA_2 = 66,
	XFER_UDMA_1 = 65,
	XFER_UDMA_0 = 64,
	XFER_MW_DMA_4 = 36,
	XFER_MW_DMA_3 = 35,
	XFER_MW_DMA_2 = 34,
	XFER_MW_DMA_1 = 33,
	XFER_MW_DMA_0 = 32,
	XFER_SW_DMA_2 = 18,
	XFER_SW_DMA_1 = 17,
	XFER_SW_DMA_0 = 16,
	XFER_PIO_6 = 14,
	XFER_PIO_5 = 13,
	XFER_PIO_4 = 12,
	XFER_PIO_3 = 11,
	XFER_PIO_2 = 10,
	XFER_PIO_1 = 9,
	XFER_PIO_0 = 8,
	XFER_PIO_SLOW = 0,
	SETFEATURES_WC_ON = 2,
	SETFEATURES_WC_OFF = 130,
	SETFEATURES_RA_ON = 170,
	SETFEATURES_RA_OFF = 85,
	SETFEATURES_AAM_ON = 66,
	SETFEATURES_AAM_OFF = 194,
	SETFEATURES_SPINUP = 7,
	SETFEATURES_SPINUP_TIMEOUT = 30000,
	SETFEATURES_SATA_ENABLE = 16,
	SETFEATURES_SATA_DISABLE = 144,
	SETFEATURES_CDL = 13,
	SATA_FPDMA_OFFSET = 1,
	SATA_FPDMA_AA = 2,
	SATA_DIPM = 3,
	SATA_FPDMA_IN_ORDER = 4,
	SATA_AN = 5,
	SATA_SSP = 6,
	SATA_DEVSLP = 9,
	SETFEATURE_SENSE_DATA = 195,
	SETFEATURE_SENSE_DATA_SUCC_NCQ = 196,
	ATA_SET_MAX_ADDR = 0,
	ATA_SET_MAX_PASSWD = 1,
	ATA_SET_MAX_LOCK = 2,
	ATA_SET_MAX_UNLOCK = 3,
	ATA_SET_MAX_FREEZE_LOCK = 4,
	ATA_SET_MAX_PASSWD_DMA = 5,
	ATA_SET_MAX_UNLOCK_DMA = 6,
	ATA_DCO_RESTORE = 192,
	ATA_DCO_FREEZE_LOCK = 193,
	ATA_DCO_IDENTIFY = 194,
	ATA_DCO_SET = 195,
	ATA_SMART_ENABLE = 216,
	ATA_SMART_READ_VALUES = 208,
	ATA_SMART_READ_THRESHOLDS = 209,
	ATA_DSM_TRIM = 1,
	ATA_SMART_LBAM_PASS = 79,
	ATA_SMART_LBAH_PASS = 194,
	ATAPI_PKT_DMA = 1,
	ATAPI_DMADIR = 4,
	ATAPI_CDB_LEN = 16,
	SATA_PMP_MAX_PORTS = 15,
	SATA_PMP_CTRL_PORT = 15,
	SATA_PMP_GSCR_DWORDS = 128,
	SATA_PMP_GSCR_PROD_ID = 0,
	SATA_PMP_GSCR_REV = 1,
	SATA_PMP_GSCR_PORT_INFO = 2,
	SATA_PMP_GSCR_ERROR = 32,
	SATA_PMP_GSCR_ERROR_EN = 33,
	SATA_PMP_GSCR_FEAT = 64,
	SATA_PMP_GSCR_FEAT_EN = 96,
	SATA_PMP_PSCR_STATUS = 0,
	SATA_PMP_PSCR_ERROR = 1,
	SATA_PMP_PSCR_CONTROL = 2,
	SATA_PMP_FEAT_BIST = 1,
	SATA_PMP_FEAT_PMREQ = 2,
	SATA_PMP_FEAT_DYNSSC = 4,
	SATA_PMP_FEAT_NOTIFY = 8,
	ATA_CBL_NONE = 0,
	ATA_CBL_PATA40 = 1,
	ATA_CBL_PATA80 = 2,
	ATA_CBL_PATA40_SHORT = 3,
	ATA_CBL_PATA_UNK = 4,
	ATA_CBL_PATA_IGN = 5,
	ATA_CBL_SATA = 6,
	SCR_STATUS = 0,
	SCR_ERROR = 1,
	SCR_CONTROL = 2,
	SCR_ACTIVE = 3,
	SCR_NOTIFICATION = 4,
	SERR_DATA_RECOVERED = 1,
	SERR_COMM_RECOVERED = 2,
	SERR_DATA = 256,
	SERR_PERSISTENT = 512,
	SERR_PROTOCOL = 1024,
	SERR_INTERNAL = 2048,
	SERR_PHYRDY_CHG = 65536,
	SERR_PHY_INT_ERR = 131072,
	SERR_COMM_WAKE = 262144,
	SERR_10B_8B_ERR = 524288,
	SERR_DISPARITY = 1048576,
	SERR_CRC = 2097152,
	SERR_HANDSHAKE = 4194304,
	SERR_LINK_SEQ_ERR = 8388608,
	SERR_TRANS_ST_ERROR = 16777216,
	SERR_UNRECOG_FIS = 33554432,
	SERR_DEV_XCHG = 67108864,
};

enum {
	ATA_READID_POSTRESET = 1,
	ATA_DNXFER_PIO = 0,
	ATA_DNXFER_DMA = 1,
	ATA_DNXFER_40C = 2,
	ATA_DNXFER_FORCE_PIO = 3,
	ATA_DNXFER_FORCE_PIO0 = 4,
	ATA_DNXFER_QUIET = -2147483648,
};

enum {
	AT_PKT_END = -1,
	BEYOND_PKT_END = -2,
};

enum {
	AUTOFS_DEV_IOCTL_VERSION_CMD = 113,
	AUTOFS_DEV_IOCTL_PROTOVER_CMD = 114,
	AUTOFS_DEV_IOCTL_PROTOSUBVER_CMD = 115,
	AUTOFS_DEV_IOCTL_OPENMOUNT_CMD = 116,
	AUTOFS_DEV_IOCTL_CLOSEMOUNT_CMD = 117,
	AUTOFS_DEV_IOCTL_READY_CMD = 118,
	AUTOFS_DEV_IOCTL_FAIL_CMD = 119,
	AUTOFS_DEV_IOCTL_SETPIPEFD_CMD = 120,
	AUTOFS_DEV_IOCTL_CATATONIC_CMD = 121,
	AUTOFS_DEV_IOCTL_TIMEOUT_CMD = 122,
	AUTOFS_DEV_IOCTL_REQUESTER_CMD = 123,
	AUTOFS_DEV_IOCTL_EXPIRE_CMD = 124,
	AUTOFS_DEV_IOCTL_ASKUMOUNT_CMD = 125,
	AUTOFS_DEV_IOCTL_ISMOUNTPOINT_CMD = 126,
};

enum {
	AUTOFS_IOC_EXPIRE_MULTI_CMD = 102,
	AUTOFS_IOC_PROTOSUBVER_CMD = 103,
	AUTOFS_IOC_ASKUMOUNT_CMD = 112,
};

enum {
	AUTOFS_IOC_READY_CMD = 96,
	AUTOFS_IOC_FAIL_CMD = 97,
	AUTOFS_IOC_CATATONIC_CMD = 98,
	AUTOFS_IOC_PROTOVER_CMD = 99,
	AUTOFS_IOC_SETTIMEOUT_CMD = 100,
	AUTOFS_IOC_EXPIRE_CMD = 101,
};

enum {
	AX25_VALUES_IPDEFMODE = 0,
	AX25_VALUES_AXDEFMODE = 1,
	AX25_VALUES_BACKOFF = 2,
	AX25_VALUES_CONMODE = 3,
	AX25_VALUES_WINDOW = 4,
	AX25_VALUES_EWINDOW = 5,
	AX25_VALUES_T1 = 6,
	AX25_VALUES_T2 = 7,
	AX25_VALUES_T3 = 8,
	AX25_VALUES_IDLE = 9,
	AX25_VALUES_N2 = 10,
	AX25_VALUES_PACLEN = 11,
	AX25_VALUES_PROTOCOL = 12,
	AX25_MAX_VALUES = 13,
};

enum {
	AXP15060_DCDC1 = 0,
	AXP15060_DCDC2 = 1,
	AXP15060_DCDC3 = 2,
	AXP15060_DCDC4 = 3,
	AXP15060_DCDC5 = 4,
	AXP15060_DCDC6 = 5,
	AXP15060_ALDO1 = 6,
	AXP15060_ALDO2 = 7,
	AXP15060_ALDO3 = 8,
	AXP15060_ALDO4 = 9,
	AXP15060_ALDO5 = 10,
	AXP15060_BLDO1 = 11,
	AXP15060_BLDO2 = 12,
	AXP15060_BLDO3 = 13,
	AXP15060_BLDO4 = 14,
	AXP15060_BLDO5 = 15,
	AXP15060_CLDO1 = 16,
	AXP15060_CLDO2 = 17,
	AXP15060_CLDO3 = 18,
	AXP15060_CLDO4 = 19,
	AXP15060_CPUSLDO = 20,
	AXP15060_SW = 21,
	AXP15060_RTC_LDO = 22,
	AXP15060_REG_ID_MAX = 23,
};

enum {
	AXP152_IRQ_LDO0IN_CONNECT = 1,
	AXP152_IRQ_LDO0IN_REMOVAL = 2,
	AXP152_IRQ_ALDO0IN_CONNECT = 3,
	AXP152_IRQ_ALDO0IN_REMOVAL = 4,
	AXP152_IRQ_DCDC1_V_LOW = 5,
	AXP152_IRQ_DCDC2_V_LOW = 6,
	AXP152_IRQ_DCDC3_V_LOW = 7,
	AXP152_IRQ_DCDC4_V_LOW = 8,
	AXP152_IRQ_PEK_SHORT = 9,
	AXP152_IRQ_PEK_LONG = 10,
	AXP152_IRQ_TIMER = 11,
	AXP152_IRQ_PEK_FAL_EDGE = 12,
	AXP152_IRQ_PEK_RIS_EDGE = 13,
	AXP152_IRQ_GPIO3_INPUT = 14,
	AXP152_IRQ_GPIO2_INPUT = 15,
	AXP152_IRQ_GPIO1_INPUT = 16,
	AXP152_IRQ_GPIO0_INPUT = 17,
};

enum {
	AXP20X_IRQ_ACIN_OVER_V = 1,
	AXP20X_IRQ_ACIN_PLUGIN = 2,
	AXP20X_IRQ_ACIN_REMOVAL = 3,
	AXP20X_IRQ_VBUS_OVER_V = 4,
	AXP20X_IRQ_VBUS_PLUGIN = 5,
	AXP20X_IRQ_VBUS_REMOVAL = 6,
	AXP20X_IRQ_VBUS_V_LOW = 7,
	AXP20X_IRQ_BATT_PLUGIN = 8,
	AXP20X_IRQ_BATT_REMOVAL = 9,
	AXP20X_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP20X_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP20X_IRQ_CHARG = 12,
	AXP20X_IRQ_CHARG_DONE = 13,
	AXP20X_IRQ_BATT_TEMP_HIGH = 14,
	AXP20X_IRQ_BATT_TEMP_LOW = 15,
	AXP20X_IRQ_DIE_TEMP_HIGH = 16,
	AXP20X_IRQ_CHARG_I_LOW = 17,
	AXP20X_IRQ_DCDC1_V_LONG = 18,
	AXP20X_IRQ_DCDC2_V_LONG = 19,
	AXP20X_IRQ_DCDC3_V_LONG = 20,
	AXP20X_IRQ_PEK_SHORT = 22,
	AXP20X_IRQ_PEK_LONG = 23,
	AXP20X_IRQ_N_OE_PWR_ON = 24,
	AXP20X_IRQ_N_OE_PWR_OFF = 25,
	AXP20X_IRQ_VBUS_VALID = 26,
	AXP20X_IRQ_VBUS_NOT_VALID = 27,
	AXP20X_IRQ_VBUS_SESS_VALID = 28,
	AXP20X_IRQ_VBUS_SESS_END = 29,
	AXP20X_IRQ_LOW_PWR_LVL1 = 30,
	AXP20X_IRQ_LOW_PWR_LVL2 = 31,
	AXP20X_IRQ_TIMER = 32,
	AXP20X_IRQ_PEK_FAL_EDGE = 33,
	AXP20X_IRQ_PEK_RIS_EDGE = 34,
	AXP20X_IRQ_GPIO3_INPUT = 35,
	AXP20X_IRQ_GPIO2_INPUT = 36,
	AXP20X_IRQ_GPIO1_INPUT = 37,
	AXP20X_IRQ_GPIO0_INPUT = 38,
};

enum {
	AXP20X_LDO1 = 0,
	AXP20X_LDO2 = 1,
	AXP20X_LDO3 = 2,
	AXP20X_LDO4 = 3,
	AXP20X_LDO5 = 4,
	AXP20X_DCDC2 = 5,
	AXP20X_DCDC3 = 6,
	AXP20X_REG_ID_MAX = 7,
};

enum {
	AXP22X_DCDC1 = 0,
	AXP22X_DCDC2 = 1,
	AXP22X_DCDC3 = 2,
	AXP22X_DCDC4 = 3,
	AXP22X_DCDC5 = 4,
	AXP22X_DC1SW = 5,
	AXP22X_DC5LDO = 6,
	AXP22X_ALDO1 = 7,
	AXP22X_ALDO2 = 8,
	AXP22X_ALDO3 = 9,
	AXP22X_ELDO1 = 10,
	AXP22X_ELDO2 = 11,
	AXP22X_ELDO3 = 12,
	AXP22X_DLDO1 = 13,
	AXP22X_DLDO2 = 14,
	AXP22X_DLDO3 = 15,
	AXP22X_DLDO4 = 16,
	AXP22X_RTC_LDO = 17,
	AXP22X_LDO_IO0 = 18,
	AXP22X_LDO_IO1 = 19,
	AXP22X_REG_ID_MAX = 20,
};

enum {
	AXP313A_DCDC1 = 0,
	AXP313A_DCDC2 = 1,
	AXP313A_DCDC3 = 2,
	AXP313A_ALDO1 = 3,
	AXP313A_DLDO1 = 4,
	AXP313A_RTC_LDO = 5,
	AXP313A_REG_ID_MAX = 6,
};

enum {
	AXP717_DCDC1 = 0,
	AXP717_DCDC2 = 1,
	AXP717_DCDC3 = 2,
	AXP717_DCDC4 = 3,
	AXP717_ALDO1 = 4,
	AXP717_ALDO2 = 5,
	AXP717_ALDO3 = 6,
	AXP717_ALDO4 = 7,
	AXP717_BLDO1 = 8,
	AXP717_BLDO2 = 9,
	AXP717_BLDO3 = 10,
	AXP717_BLDO4 = 11,
	AXP717_CLDO1 = 12,
	AXP717_CLDO2 = 13,
	AXP717_CLDO3 = 14,
	AXP717_CLDO4 = 15,
	AXP717_CPUSLDO = 16,
	AXP717_BOOST = 17,
	AXP717_REG_ID_MAX = 18,
};

enum {
	AXP803_DCDC1 = 0,
	AXP803_DCDC2 = 1,
	AXP803_DCDC3 = 2,
	AXP803_DCDC4 = 3,
	AXP803_DCDC5 = 4,
	AXP803_DCDC6 = 5,
	AXP803_DC1SW = 6,
	AXP803_ALDO1 = 7,
	AXP803_ALDO2 = 8,
	AXP803_ALDO3 = 9,
	AXP803_DLDO1 = 10,
	AXP803_DLDO2 = 11,
	AXP803_DLDO3 = 12,
	AXP803_DLDO4 = 13,
	AXP803_ELDO1 = 14,
	AXP803_ELDO2 = 15,
	AXP803_ELDO3 = 16,
	AXP803_FLDO1 = 17,
	AXP803_FLDO2 = 18,
	AXP803_RTC_LDO = 19,
	AXP803_LDO_IO0 = 20,
	AXP803_LDO_IO1 = 21,
	AXP803_REG_ID_MAX = 22,
};

enum {
	AXP806_DCDCA = 0,
	AXP806_DCDCB = 1,
	AXP806_DCDCC = 2,
	AXP806_DCDCD = 3,
	AXP806_DCDCE = 4,
	AXP806_ALDO1 = 5,
	AXP806_ALDO2 = 6,
	AXP806_ALDO3 = 7,
	AXP806_BLDO1 = 8,
	AXP806_BLDO2 = 9,
	AXP806_BLDO3 = 10,
	AXP806_BLDO4 = 11,
	AXP806_CLDO1 = 12,
	AXP806_CLDO2 = 13,
	AXP806_CLDO3 = 14,
	AXP806_SW = 15,
	AXP806_REG_ID_MAX = 16,
};

enum {
	AXP809_DCDC1 = 0,
	AXP809_DCDC2 = 1,
	AXP809_DCDC3 = 2,
	AXP809_DCDC4 = 3,
	AXP809_DCDC5 = 4,
	AXP809_DC1SW = 5,
	AXP809_DC5LDO = 6,
	AXP809_ALDO1 = 7,
	AXP809_ALDO2 = 8,
	AXP809_ALDO3 = 9,
	AXP809_ELDO1 = 10,
	AXP809_ELDO2 = 11,
	AXP809_ELDO3 = 12,
	AXP809_DLDO1 = 13,
	AXP809_DLDO2 = 14,
	AXP809_RTC_LDO = 15,
	AXP809_LDO_IO0 = 16,
	AXP809_LDO_IO1 = 17,
	AXP809_SW = 18,
	AXP809_REG_ID_MAX = 19,
};

enum {
	AXP813_DCDC1 = 0,
	AXP813_DCDC2 = 1,
	AXP813_DCDC3 = 2,
	AXP813_DCDC4 = 3,
	AXP813_DCDC5 = 4,
	AXP813_DCDC6 = 5,
	AXP813_DCDC7 = 6,
	AXP813_ALDO1 = 7,
	AXP813_ALDO2 = 8,
	AXP813_ALDO3 = 9,
	AXP813_DLDO1 = 10,
	AXP813_DLDO2 = 11,
	AXP813_DLDO3 = 12,
	AXP813_DLDO4 = 13,
	AXP813_ELDO1 = 14,
	AXP813_ELDO2 = 15,
	AXP813_ELDO3 = 16,
	AXP813_FLDO1 = 17,
	AXP813_FLDO2 = 18,
	AXP813_FLDO3 = 19,
	AXP813_RTC_LDO = 20,
	AXP813_LDO_IO0 = 21,
	AXP813_LDO_IO1 = 22,
	AXP813_SW = 23,
	AXP813_REG_ID_MAX = 24,
};

enum {
	Audit_equal = 0,
	Audit_not_equal = 1,
	Audit_bitmask = 2,
	Audit_bittest = 3,
	Audit_lt = 4,
	Audit_gt = 5,
	Audit_le = 6,
	Audit_ge = 7,
	Audit_bad = 8,
};

enum {
	B28_DPT_INI = 3584,
	B28_DPT_VAL = 3588,
	B28_DPT_CTRL = 3592,
	B28_DPT_TST = 3594,
};

enum {
	B28_Y2_SMB_CONFIG = 3648,
	B28_Y2_SMB_CSD_REG = 3652,
	B28_Y2_ASF_IRQ_V_BASE = 3680,
	B28_Y2_ASF_STAT_CMD = 3688,
	B28_Y2_ASF_HOST_COM = 3692,
	B28_Y2_DATA_REG_1 = 3696,
	B28_Y2_DATA_REG_2 = 3700,
	B28_Y2_DATA_REG_3 = 3704,
	B28_Y2_DATA_REG_4 = 3708,
};

enum {
	B6_EXT_REG = 768,
	B7_CFG_SPC = 896,
	B8_RQ1_REGS = 1024,
	B8_RQ2_REGS = 1152,
	B8_TS1_REGS = 1536,
	B8_TA1_REGS = 1664,
	B8_TS2_REGS = 1792,
	B8_TA2_REGS = 1920,
	B16_RAM_REGS = 2048,
};

enum {
	B8_Q_REGS = 1024,
	Q_D = 0,
	Q_VLAN = 32,
	Q_DONE = 36,
	Q_AC_L = 40,
	Q_AC_H = 44,
	Q_BC = 48,
	Q_CSR = 52,
	Q_TEST = 56,
	Q_WM = 64,
	Q_AL = 66,
	Q_RSP = 68,
	Q_RSL = 70,
	Q_RP = 72,
	Q_RL = 74,
	Q_WP = 76,
	Q_WSP = 77,
	Q_WL = 78,
	Q_WSL = 79,
};

enum {
	BASE_GMAC_1 = 10240,
	BASE_GMAC_2 = 14336,
};

enum {
	BD71837_REG_BUCK3_CTRL = 7,
	BD71837_REG_BUCK4_CTRL = 8,
	BD71837_REG_BUCK3_VOLT_RUN = 18,
	BD71837_REG_BUCK4_VOLT_RUN = 19,
	BD71837_REG_LDO7_VOLT = 30,
};

enum {
	BD718XX_BUCK1 = 0,
	BD718XX_BUCK2 = 1,
	BD718XX_BUCK3 = 2,
	BD718XX_BUCK4 = 3,
	BD718XX_BUCK5 = 4,
	BD718XX_BUCK6 = 5,
	BD718XX_BUCK7 = 6,
	BD718XX_BUCK8 = 7,
	BD718XX_LDO1 = 8,
	BD718XX_LDO2 = 9,
	BD718XX_LDO3 = 10,
	BD718XX_LDO4 = 11,
	BD718XX_LDO5 = 12,
	BD718XX_LDO6 = 13,
	BD718XX_LDO7 = 14,
	BD718XX_REGULATOR_AMOUNT = 15,
};

enum {
	BD718XX_INT_STBY_REQ = 0,
	BD718XX_INT_ON_REQ = 1,
	BD718XX_INT_WDOG = 2,
	BD718XX_INT_PWRBTN = 3,
	BD718XX_INT_PWRBTN_L = 4,
	BD718XX_INT_PWRBTN_S = 5,
	BD718XX_INT_SWRST = 6,
};

enum {
	BD718XX_REG_REV = 0,
	BD718XX_REG_SWRESET = 1,
	BD718XX_REG_I2C_DEV = 2,
	BD718XX_REG_PWRCTRL0 = 3,
	BD718XX_REG_PWRCTRL1 = 4,
	BD718XX_REG_BUCK1_CTRL = 5,
	BD718XX_REG_BUCK2_CTRL = 6,
	BD718XX_REG_1ST_NODVS_BUCK_CTRL = 9,
	BD718XX_REG_2ND_NODVS_BUCK_CTRL = 10,
	BD718XX_REG_3RD_NODVS_BUCK_CTRL = 11,
	BD718XX_REG_4TH_NODVS_BUCK_CTRL = 12,
	BD718XX_REG_BUCK1_VOLT_RUN = 13,
	BD718XX_REG_BUCK1_VOLT_IDLE = 14,
	BD718XX_REG_BUCK1_VOLT_SUSP = 15,
	BD718XX_REG_BUCK2_VOLT_RUN = 16,
	BD718XX_REG_BUCK2_VOLT_IDLE = 17,
	BD718XX_REG_1ST_NODVS_BUCK_VOLT = 20,
	BD718XX_REG_2ND_NODVS_BUCK_VOLT = 21,
	BD718XX_REG_3RD_NODVS_BUCK_VOLT = 22,
	BD718XX_REG_4TH_NODVS_BUCK_VOLT = 23,
	BD718XX_REG_LDO1_VOLT = 24,
	BD718XX_REG_LDO2_VOLT = 25,
	BD718XX_REG_LDO3_VOLT = 26,
	BD718XX_REG_LDO4_VOLT = 27,
	BD718XX_REG_LDO5_VOLT = 28,
	BD718XX_REG_LDO6_VOLT = 29,
	BD718XX_REG_TRANS_COND0 = 31,
	BD718XX_REG_TRANS_COND1 = 32,
	BD718XX_REG_VRFAULTEN = 33,
	BD718XX_REG_MVRFLTMASK0 = 34,
	BD718XX_REG_MVRFLTMASK1 = 35,
	BD718XX_REG_MVRFLTMASK2 = 36,
	BD718XX_REG_RCVCFG = 37,
	BD718XX_REG_RCVNUM = 38,
	BD718XX_REG_PWRONCONFIG0 = 39,
	BD718XX_REG_PWRONCONFIG1 = 40,
	BD718XX_REG_RESETSRC = 41,
	BD718XX_REG_MIRQ = 42,
	BD718XX_REG_IRQ = 43,
	BD718XX_REG_IN_MON = 44,
	BD718XX_REG_POW_STATE = 45,
	BD718XX_REG_OUT32K = 46,
	BD718XX_REG_REGLOCK = 47,
	BD718XX_REG_OTPVER = 255,
	BD718XX_MAX_REGISTER = 256,
};

enum {
	BIAS = 2147483648,
};

enum {
	BIOSET_NEED_BVECS = 1,
	BIOSET_NEED_RESCUER = 2,
	BIOSET_PERCPU_CACHE = 4,
};

enum {
	BIO_PAGE_PINNED = 0,
	BIO_CLONED = 1,
	BIO_QUIET = 2,
	BIO_CHAIN = 3,
	BIO_REFFED = 4,
	BIO_BPS_THROTTLED = 5,
	BIO_TRACE_COMPLETION = 6,
	BIO_CGROUP_ACCT = 7,
	BIO_QOS_THROTTLED = 8,
	BIO_TG_BPS_THROTTLED = 8,
	BIO_QOS_MERGED = 9,
	BIO_REMAPPED = 10,
	BIO_ZONE_WRITE_PLUGGING = 11,
	BIO_EMULATES_ZONE_APPEND = 12,
	BIO_FLAG_LAST = 13,
};

enum {
	BLINK_42MS = 0,
	BLINK_84MS = 1,
	BLINK_170MS = 2,
	BLINK_340MS = 3,
	BLINK_670MS = 4,
};

enum {
	BLK_MQ_F_TAG_QUEUE_SHARED = 2,
	BLK_MQ_F_STACKING = 4,
	BLK_MQ_F_TAG_HCTX_SHARED = 8,
	BLK_MQ_F_BLOCKING = 16,
	BLK_MQ_F_TAG_RR = 32,
	BLK_MQ_F_NO_SCHED_BY_DEFAULT = 64,
	BLK_MQ_F_MAX = 128,
};

enum {
	BLK_MQ_NO_TAG = 4294967295,
	BLK_MQ_TAG_MIN = 1,
	BLK_MQ_TAG_MAX = 4294967294,
};

enum {
	BLK_MQ_REQ_NOWAIT = 1,
	BLK_MQ_REQ_RESERVED = 2,
	BLK_MQ_REQ_PM = 4,
};

enum {
	BLK_MQ_S_STOPPED = 0,
	BLK_MQ_S_TAG_ACTIVE = 1,
	BLK_MQ_S_SCHED_RESTART = 2,
	BLK_MQ_S_INACTIVE = 3,
	BLK_MQ_S_MAX = 4,
};

enum {
	BLK_MQ_UNIQUE_TAG_BITS = 16,
	BLK_MQ_UNIQUE_TAG_MASK = 65535,
};

enum {
	BLOCK_BITMAP = 0,
	INODE_BITMAP = 1,
	INODE_TABLE = 2,
	GROUP_TABLE_COUNT = 3,
};

enum {
	BMC_NPCM7XX = 0,
	BMC_NPCM8XX = 1,
};

enum {
	BMU_IDLE = -2147483648,
	BMU_RX_TCP_PKT = 1073741824,
	BMU_RX_IP_PKT = 536870912,
	BMU_ENA_RX_RSS_HASH = 32768,
	BMU_DIS_RX_RSS_HASH = 16384,
	BMU_ENA_RX_CHKSUM = 8192,
	BMU_DIS_RX_CHKSUM = 4096,
	BMU_CLR_IRQ_PAR = 2048,
	BMU_CLR_IRQ_TCP = 2048,
	BMU_CLR_IRQ_CHK = 1024,
	BMU_STOP = 512,
	BMU_START = 256,
	BMU_FIFO_OP_ON = 128,
	BMU_FIFO_OP_OFF = 64,
	BMU_FIFO_ENA = 32,
	BMU_FIFO_RST = 16,
	BMU_OP_ON = 8,
	BMU_OP_OFF = 4,
	BMU_RST_CLR = 2,
	BMU_RST_SET = 1,
	BMU_CLR_RESET = 22,
	BMU_OPER_INIT = 3368,
	BMU_WM_DEFAULT = 1536,
	BMU_WM_PEX = 128,
};

enum {
	BOOST_ILMIN_75MA = 0,
	BOOST_ILMIN_100MA = 1,
	BOOST_ILMIN_125MA = 2,
	BOOST_ILMIN_150MA = 3,
	BOOST_ILMIN_175MA = 4,
	BOOST_ILMIN_200MA = 5,
	BOOST_ILMIN_225MA = 6,
	BOOST_ILMIN_250MA = 7,
};

enum {
	BPF_ADJ_ROOM_ENCAP_L2_MASK = 255,
	BPF_ADJ_ROOM_ENCAP_L2_SHIFT = 56,
};

enum {
	BPF_ANY = 0,
	BPF_NOEXIST = 1,
	BPF_EXIST = 2,
	BPF_F_LOCK = 4,
};

enum {
	BPF_CSUM_LEVEL_QUERY = 0,
	BPF_CSUM_LEVEL_INC = 1,
	BPF_CSUM_LEVEL_DEC = 2,
	BPF_CSUM_LEVEL_RESET = 3,
};

enum {
	BPF_FIB_LKUP_RET_SUCCESS = 0,
	BPF_FIB_LKUP_RET_BLACKHOLE = 1,
	BPF_FIB_LKUP_RET_UNREACHABLE = 2,
	BPF_FIB_LKUP_RET_PROHIBIT = 3,
	BPF_FIB_LKUP_RET_NOT_FWDED = 4,
	BPF_FIB_LKUP_RET_FWD_DISABLED = 5,
	BPF_FIB_LKUP_RET_UNSUPP_LWT = 6,
	BPF_FIB_LKUP_RET_NO_NEIGH = 7,
	BPF_FIB_LKUP_RET_FRAG_NEEDED = 8,
	BPF_FIB_LKUP_RET_NO_SRC_ADDR = 9,
};

enum {
	BPF_FIB_LOOKUP_DIRECT = 1,
	BPF_FIB_LOOKUP_OUTPUT = 2,
	BPF_FIB_LOOKUP_SKIP_NEIGH = 4,
	BPF_FIB_LOOKUP_TBID = 8,
	BPF_FIB_LOOKUP_SRC = 16,
	BPF_FIB_LOOKUP_MARK = 32,
};

enum {
	BPF_FLOW_DISSECTOR_F_PARSE_1ST_FRAG = 1,
	BPF_FLOW_DISSECTOR_F_STOP_AT_FLOW_LABEL = 2,
	BPF_FLOW_DISSECTOR_F_STOP_AT_ENCAP = 4,
};

enum {
	BPF_F_ADJ_ROOM_FIXED_GSO = 1,
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV4 = 2,
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV6 = 4,
	BPF_F_ADJ_ROOM_ENCAP_L4_GRE = 8,
	BPF_F_ADJ_ROOM_ENCAP_L4_UDP = 16,
	BPF_F_ADJ_ROOM_NO_CSUM_RESET = 32,
	BPF_F_ADJ_ROOM_ENCAP_L2_ETH = 64,
	BPF_F_ADJ_ROOM_DECAP_L3_IPV4 = 128,
	BPF_F_ADJ_ROOM_DECAP_L3_IPV6 = 256,
};

enum {
	BPF_F_GET_BRANCH_RECORDS_SIZE = 1,
};

enum {
	BPF_F_HDR_FIELD_MASK = 15,
};

enum {
	BPF_F_INDEX_MASK = 4294967295ULL,
	BPF_F_CURRENT_CPU = 4294967295ULL,
	BPF_F_CTXLEN_MASK = 4503595332403200ULL,
};

enum {
	BPF_F_INGRESS = 1,
	BPF_F_BROADCAST = 8,
	BPF_F_EXCLUDE_INGRESS = 16,
};

enum {
	BPF_F_NEIGH = 65536,
	BPF_F_PEER = 131072,
	BPF_F_NEXTHOP = 262144,
};

enum {
	BPF_F_NO_PREALLOC = 1,
	BPF_F_NO_COMMON_LRU = 2,
	BPF_F_NUMA_NODE = 4,
	BPF_F_RDONLY = 8,
	BPF_F_WRONLY = 16,
	BPF_F_STACK_BUILD_ID = 32,
	BPF_F_ZERO_SEED = 64,
	BPF_F_RDONLY_PROG = 128,
	BPF_F_WRONLY_PROG = 256,
	BPF_F_CLONE = 512,
	BPF_F_MMAPABLE = 1024,
	BPF_F_PRESERVE_ELEMS = 2048,
	BPF_F_INNER_MAP = 4096,
	BPF_F_LINK = 8192,
	BPF_F_PATH_FD = 16384,
	BPF_F_VTYPE_BTF_OBJ_FD = 32768,
	BPF_F_TOKEN_FD = 65536,
	BPF_F_SEGV_ON_FAULT = 131072,
	BPF_F_NO_USER_CONV = 262144,
};

enum {
	BPF_F_PSEUDO_HDR = 16,
	BPF_F_MARK_MANGLED_0 = 32,
	BPF_F_MARK_ENFORCE = 64,
	BPF_F_IPV6 = 128,
};

enum {
	BPF_F_RECOMPUTE_CSUM = 1,
	BPF_F_INVALIDATE_HASH = 2,
};

enum {
	BPF_F_SKIP_FIELD_MASK = 255,
	BPF_F_USER_STACK = 256,
	BPF_F_FAST_STACK_CMP = 512,
	BPF_F_REUSE_STACKID = 1024,
	BPF_F_USER_BUILD_ID = 2048,
};

enum {
	BPF_F_SYSCTL_BASE_NAME = 1,
};

enum {
	BPF_F_TIMER_ABS = 1,
	BPF_F_TIMER_CPU_PIN = 2,
};

enum {
	BPF_F_TUNINFO_FLAGS = 16,
};

enum {
	BPF_F_TUNINFO_IPV6 = 1,
};

enum {
	BPF_F_UPROBE_MULTI_RETURN = 1,
};

enum {
	BPF_F_ZERO_CSUM_TX = 2,
	BPF_F_DONT_FRAGMENT = 4,
	BPF_F_SEQ_NUMBER = 8,
	BPF_F_NO_TUNNEL_KEY = 16,
};

enum {
	BPF_LOAD_HDR_OPT_TCP_SYN = 1,
};

enum {
	BPF_LOCAL_STORAGE_GET_F_CREATE = 1,
	BPF_SK_STORAGE_GET_F_CREATE = 1,
};

enum {
	BPF_MAX_LOOPS = 8388608,
	BPF_MAX_TIMED_LOOPS = 65535,
};

enum {
	BPF_MAX_TRAMP_LINKS = 38,
};

enum {
	BPF_RB_AVAIL_DATA = 0,
	BPF_RB_RING_SIZE = 1,
	BPF_RB_CONS_POS = 2,
	BPF_RB_PROD_POS = 3,
};

enum {
	BPF_RB_NO_WAKEUP = 1,
	BPF_RB_FORCE_WAKEUP = 2,
};

enum {
	BPF_REG_0 = 0,
	BPF_REG_1 = 1,
	BPF_REG_2 = 2,
	BPF_REG_3 = 3,
	BPF_REG_4 = 4,
	BPF_REG_5 = 5,
	BPF_REG_6 = 6,
	BPF_REG_7 = 7,
	BPF_REG_8 = 8,
	BPF_REG_9 = 9,
	BPF_REG_10 = 10,
	__MAX_BPF_REG = 11,
};

enum {
	BPF_RINGBUF_BUSY_BIT = 2147483648,
	BPF_RINGBUF_DISCARD_BIT = 1073741824,
	BPF_RINGBUF_HDR_SZ = 8,
};

enum {
	BPF_SKB_TSTAMP_UNSPEC = 0,
	BPF_SKB_TSTAMP_DELIVERY_MONO = 1,
	BPF_SKB_CLOCK_REALTIME = 0,
	BPF_SKB_CLOCK_MONOTONIC = 1,
	BPF_SKB_CLOCK_TAI = 2,
};

enum {
	BPF_SK_LOOKUP_F_REPLACE = 1,
	BPF_SK_LOOKUP_F_NO_REUSEPORT = 2,
};

enum {
	BPF_SOCK_OPS_RTO_CB_FLAG = 1,
	BPF_SOCK_OPS_RETRANS_CB_FLAG = 2,
	BPF_SOCK_OPS_STATE_CB_FLAG = 4,
	BPF_SOCK_OPS_RTT_CB_FLAG = 8,
	BPF_SOCK_OPS_PARSE_ALL_HDR_OPT_CB_FLAG = 16,
	BPF_SOCK_OPS_PARSE_UNKNOWN_HDR_OPT_CB_FLAG = 32,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB_FLAG = 64,
	BPF_SOCK_OPS_ALL_CB_FLAGS = 127,
};

enum {
	BPF_SOCK_OPS_VOID = 0,
	BPF_SOCK_OPS_TIMEOUT_INIT = 1,
	BPF_SOCK_OPS_RWND_INIT = 2,
	BPF_SOCK_OPS_TCP_CONNECT_CB = 3,
	BPF_SOCK_OPS_ACTIVE_ESTABLISHED_CB = 4,
	BPF_SOCK_OPS_PASSIVE_ESTABLISHED_CB = 5,
	BPF_SOCK_OPS_NEEDS_ECN = 6,
	BPF_SOCK_OPS_BASE_RTT = 7,
	BPF_SOCK_OPS_RTO_CB = 8,
	BPF_SOCK_OPS_RETRANS_CB = 9,
	BPF_SOCK_OPS_STATE_CB = 10,
	BPF_SOCK_OPS_TCP_LISTEN_CB = 11,
	BPF_SOCK_OPS_RTT_CB = 12,
	BPF_SOCK_OPS_PARSE_HDR_OPT_CB = 13,
	BPF_SOCK_OPS_HDR_OPT_LEN_CB = 14,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB = 15,
	BPF_SOCK_OPS_TSTAMP_SCHED_CB = 16,
	BPF_SOCK_OPS_TSTAMP_SND_SW_CB = 17,
	BPF_SOCK_OPS_TSTAMP_SND_HW_CB = 18,
	BPF_SOCK_OPS_TSTAMP_ACK_CB = 19,
	BPF_SOCK_OPS_TSTAMP_SENDMSG_CB = 20,
};

enum {
	BPF_TASK_ITER_ALL_PROCS = 0,
	BPF_TASK_ITER_ALL_THREADS = 1,
	BPF_TASK_ITER_PROC_THREADS = 2,
};

enum {
	BPF_TCP_ESTABLISHED = 1,
	BPF_TCP_SYN_SENT = 2,
	BPF_TCP_SYN_RECV = 3,
	BPF_TCP_FIN_WAIT1 = 4,
	BPF_TCP_FIN_WAIT2 = 5,
	BPF_TCP_TIME_WAIT = 6,
	BPF_TCP_CLOSE = 7,
	BPF_TCP_CLOSE_WAIT = 8,
	BPF_TCP_LAST_ACK = 9,
	BPF_TCP_LISTEN = 10,
	BPF_TCP_CLOSING = 11,
	BPF_TCP_NEW_SYN_RECV = 12,
	BPF_TCP_BOUND_INACTIVE = 13,
	BPF_TCP_MAX_STATES = 14,
};

enum {
	BPF_WRITE_HDR_TCP_CURRENT_MSS = 1,
	BPF_WRITE_HDR_TCP_SYNACK_COOKIE = 2,
};

enum {
	BR_MCAST_DIR_RX = 0,
	BR_MCAST_DIR_TX = 1,
	BR_MCAST_DIR_SIZE = 2,
};

enum {
	BTF_FIELDS_MAX = 11,
};

enum {
	BTF_FIELD_IGNORE = 0,
	BTF_FIELD_FOUND = 1,
};

enum {
	BTF_F_COMPACT = 1,
	BTF_F_NONAME = 2,
	BTF_F_PTR_RAW = 4,
	BTF_F_ZERO = 8,
};

enum {
	BTF_KFUNC_SET_MAX_CNT = 256,
	BTF_DTOR_KFUNC_MAX_CNT = 256,
	BTF_KFUNC_FILTER_MAX_CNT = 16,
};

enum {
	BTF_KIND_UNKN = 0,
	BTF_KIND_INT = 1,
	BTF_KIND_PTR = 2,
	BTF_KIND_ARRAY = 3,
	BTF_KIND_STRUCT = 4,
	BTF_KIND_UNION = 5,
	BTF_KIND_ENUM = 6,
	BTF_KIND_FWD = 7,
	BTF_KIND_TYPEDEF = 8,
	BTF_KIND_VOLATILE = 9,
	BTF_KIND_CONST = 10,
	BTF_KIND_RESTRICT = 11,
	BTF_KIND_FUNC = 12,
	BTF_KIND_FUNC_PROTO = 13,
	BTF_KIND_VAR = 14,
	BTF_KIND_DATASEC = 15,
	BTF_KIND_FLOAT = 16,
	BTF_KIND_DECL_TAG = 17,
	BTF_KIND_TYPE_TAG = 18,
	BTF_KIND_ENUM64 = 19,
	NR_BTF_KINDS = 20,
	BTF_KIND_MAX = 19,
};

enum {
	BTF_MODULE_F_LIVE = 1,
};

enum {
	BTF_SOCK_TYPE_INET = 0,
	BTF_SOCK_TYPE_INET_CONN = 1,
	BTF_SOCK_TYPE_INET_REQ = 2,
	BTF_SOCK_TYPE_INET_TW = 3,
	BTF_SOCK_TYPE_REQ = 4,
	BTF_SOCK_TYPE_SOCK = 5,
	BTF_SOCK_TYPE_SOCK_COMMON = 6,
	BTF_SOCK_TYPE_TCP = 7,
	BTF_SOCK_TYPE_TCP_REQ = 8,
	BTF_SOCK_TYPE_TCP_TW = 9,
	BTF_SOCK_TYPE_TCP6 = 10,
	BTF_SOCK_TYPE_UDP = 11,
	BTF_SOCK_TYPE_UDP6 = 12,
	BTF_SOCK_TYPE_UNIX = 13,
	BTF_SOCK_TYPE_MPTCP = 14,
	BTF_SOCK_TYPE_SOCKET = 15,
	MAX_BTF_SOCK_TYPE = 16,
};

enum {
	BTF_TRACING_TYPE_TASK = 0,
	BTF_TRACING_TYPE_FILE = 1,
	BTF_TRACING_TYPE_VMA = 2,
	MAX_BTF_TRACING_TYPE = 3,
};

enum {
	BTF_VAR_STATIC = 0,
	BTF_VAR_GLOBAL_ALLOCATED = 1,
	BTF_VAR_GLOBAL_EXTERN = 2,
};

enum {
	BUCK_ILMIN_50MA = 0,
	BUCK_ILMIN_100MA = 1,
	BUCK_ILMIN_150MA = 2,
	BUCK_ILMIN_200MA = 3,
	BUCK_ILMIN_250MA = 4,
	BUCK_ILMIN_300MA = 5,
	BUCK_ILMIN_350MA = 6,
	BUCK_ILMIN_400MA = 7,
};

enum {
	CACHE_VALID = 0,
	CACHE_NEGATIVE = 1,
	CACHE_PENDING = 2,
	CACHE_CLEANED = 3,
};

enum {
	CAP_HWCAP = 1,
	CAP_COMPAT_HWCAP = 2,
	CAP_COMPAT_HWCAP2 = 3,
};

enum {
	CBF_XO_INDEX = 0,
	CBF_PLL_INDEX = 1,
	CBF_DIV_INDEX = 2,
	CBF_APCS_AUX_INDEX = 3,
};

enum {
	CFG_CHIP_R_MSK = 240,
	CFG_DIS_M2_CLK = 2,
	CFG_SNG_MAC = 1,
};

enum {
	CFG_LED_MODE_MSK = 28,
	CFG_LINK_2_AVAIL = 2,
	CFG_LINK_1_AVAIL = 1,
};

enum {
	CFG_PRE_INIT = 0,
	CFG_POST_INIT = 1,
	CFG_PRE_PWR_HS = 2,
	CFG_POST_PWR_HS = 3,
	CFG_TAG_MAX = 4,
};

enum {
	CFTYPE_ONLY_ON_ROOT = 1,
	CFTYPE_NOT_ON_ROOT = 2,
	CFTYPE_NS_DELEGATABLE = 4,
	CFTYPE_NO_PREFIX = 8,
	CFTYPE_WORLD_WRITABLE = 16,
	CFTYPE_DEBUG = 32,
	__CFTYPE_ONLY_ON_DFL = 65536,
	__CFTYPE_NOT_ON_DFL = 131072,
	__CFTYPE_ADDED = 262144,
};

enum {
	CGROUPSTATS_CMD_ATTR_UNSPEC = 0,
	CGROUPSTATS_CMD_ATTR_FD = 1,
	__CGROUPSTATS_CMD_ATTR_MAX = 2,
};

enum {
	CGROUPSTATS_CMD_UNSPEC = 3,
	CGROUPSTATS_CMD_GET = 4,
	CGROUPSTATS_CMD_NEW = 5,
	__CGROUPSTATS_CMD_MAX = 6,
};

enum {
	CGROUPSTATS_TYPE_UNSPEC = 0,
	CGROUPSTATS_TYPE_CGROUP_STATS = 1,
	__CGROUPSTATS_TYPE_MAX = 2,
};

enum {
	CGRP_NOTIFY_ON_RELEASE = 0,
	CGRP_CPUSET_CLONE_CHILDREN = 1,
	CGRP_FREEZE = 2,
	CGRP_FROZEN = 3,
};

enum {
	CGRP_ROOT_NOPREFIX = 2,
	CGRP_ROOT_XATTR = 4,
	CGRP_ROOT_NS_DELEGATE = 8,
	CGRP_ROOT_FAVOR_DYNMODS = 16,
	CGRP_ROOT_CPUSET_V2_MODE = 65536,
	CGRP_ROOT_MEMORY_LOCAL_EVENTS = 131072,
	CGRP_ROOT_MEMORY_RECURSIVE_PROT = 262144,
	CGRP_ROOT_MEMORY_HUGETLB_ACCOUNTING = 524288,
	CGRP_ROOT_PIDS_LOCAL_EVENTS = 1048576,
};

enum {
	CHIP_ID_YUKON_XL = 179,
	CHIP_ID_YUKON_EC_U = 180,
	CHIP_ID_YUKON_EX = 181,
	CHIP_ID_YUKON_EC = 182,
	CHIP_ID_YUKON_FE = 183,
	CHIP_ID_YUKON_FE_P = 184,
	CHIP_ID_YUKON_SUPR = 185,
	CHIP_ID_YUKON_UL_2 = 186,
	CHIP_ID_YUKON_OPT = 188,
	CHIP_ID_YUKON_PRM = 189,
	CHIP_ID_YUKON_OP_2 = 190,
};

enum {
	CLK_ALPHA_PLL_TYPE_DEFAULT = 0,
	CLK_ALPHA_PLL_TYPE_HUAYRA = 1,
	CLK_ALPHA_PLL_TYPE_HUAYRA_APSS = 2,
	CLK_ALPHA_PLL_TYPE_HUAYRA_2290 = 3,
	CLK_ALPHA_PLL_TYPE_BRAMMO = 4,
	CLK_ALPHA_PLL_TYPE_FABIA = 5,
	CLK_ALPHA_PLL_TYPE_TRION = 6,
	CLK_ALPHA_PLL_TYPE_LUCID = 6,
	CLK_ALPHA_PLL_TYPE_AGERA = 7,
	CLK_ALPHA_PLL_TYPE_ZONDA = 8,
	CLK_ALPHA_PLL_TYPE_REGERA = 8,
	CLK_ALPHA_PLL_TYPE_ZONDA_OLE = 9,
	CLK_ALPHA_PLL_TYPE_LUCID_EVO = 10,
	CLK_ALPHA_PLL_TYPE_LUCID_OLE = 11,
	CLK_ALPHA_PLL_TYPE_PONGO_ELU = 12,
	CLK_ALPHA_PLL_TYPE_TAYCAN_ELU = 13,
	CLK_ALPHA_PLL_TYPE_RIVIAN_EVO = 14,
	CLK_ALPHA_PLL_TYPE_DEFAULT_EVO = 15,
	CLK_ALPHA_PLL_TYPE_BRAMMO_EVO = 16,
	CLK_ALPHA_PLL_TYPE_STROMER = 17,
	CLK_ALPHA_PLL_TYPE_STROMER_PLUS = 18,
	CLK_ALPHA_PLL_TYPE_NSS_HUAYRA = 19,
	CLK_ALPHA_PLL_TYPE_MAX = 20,
};

enum {
	CLK_QSPI_APB = 0,
	CLK_QSPI_AHB = 1,
	CLK_QSPI_NUM = 2,
};

enum {
	CMD_CLK_GET_RATE = 1,
	CMD_CLK_SET_RATE = 2,
	CMD_CLK_ROUND_RATE = 3,
	CMD_CLK_GET_PARENT = 4,
	CMD_CLK_SET_PARENT = 5,
	CMD_CLK_IS_ENABLED = 6,
	CMD_CLK_ENABLE = 7,
	CMD_CLK_DISABLE = 8,
	CMD_CLK_PROPERTIES = 9,
	CMD_CLK_POSSIBLE_PARENTS = 10,
	CMD_CLK_NUM_POSSIBLE_PARENTS = 11,
	CMD_CLK_GET_POSSIBLE_PARENT = 12,
	CMD_CLK_RESET_REFCOUNTS = 13,
	CMD_CLK_GET_ALL_INFO = 14,
	CMD_CLK_GET_MAX_CLK_ID = 15,
	CMD_CLK_GET_FMAX_AT_VMIN = 16,
	CMD_CLK_MAX = 17,
};

enum {
	CMD_I2C_XFER = 1,
};

enum {
	CMIS_MODULE_LOW_PWR = 1,
	CMIS_MODULE_READY = 3,
};

enum {
	CP110_CLK_TYPE_CORE = 0,
	CP110_CLK_TYPE_GATABLE = 1,
};

enum {
	CPER_SEV_RECOVERABLE = 0,
	CPER_SEV_FATAL = 1,
	CPER_SEV_CORRECTED = 2,
	CPER_SEV_INFORMATIONAL = 3,
};

enum {
	CPORT_IDLE = 0,
	CPORT_CONNECTED = 1,
};

enum {
	CPSW_ALE_F_STATUS_REG = 1,
	CPSW_ALE_F_HW_AUTOAGING = 2,
	CPSW_ALE_F_COUNT = 3,
};

enum {
	CPSW_SL_CTL_FULLDUPLEX = 1,
	CPSW_SL_CTL_LOOPBACK = 2,
	CPSW_SL_CTL_MTEST = 4,
	CPSW_SL_CTL_RX_FLOW_EN = 8,
	CPSW_SL_CTL_TX_FLOW_EN = 16,
	CPSW_SL_CTL_GMII_EN = 32,
	CPSW_SL_CTL_TX_PACE = 64,
	CPSW_SL_CTL_GIG = 128,
	CPSW_SL_CTL_XGIG = 256,
	CPSW_SL_CTL_TX_SHORT_GAP_EN = 1024,
	CPSW_SL_CTL_CMD_IDLE = 2048,
	CPSW_SL_CTL_CRC_TYPE = 4096,
	CPSW_SL_CTL_XGMII_EN = 8192,
	CPSW_SL_CTL_IFCTL_A = 32768,
	CPSW_SL_CTL_IFCTL_B = 65536,
	CPSW_SL_CTL_GIG_FORCE = 131072,
	CPSW_SL_CTL_EXT_EN = 262144,
	CPSW_SL_CTL_EXT_EN_RX_FLO = 524288,
	CPSW_SL_CTL_EXT_EN_TX_FLO = 1048576,
	CPSW_SL_CTL_TX_SG_LIM_EN = 2097152,
	CPSW_SL_CTL_RX_CEF_EN = 4194304,
	CPSW_SL_CTL_RX_CSF_EN = 8388608,
	CPSW_SL_CTL_RX_CMF_EN = 16777216,
	CPSW_SL_CTL_EXT_EN_XGIG = 33554432,
	CPSW_SL_CTL_FUNCS_COUNT = 33554433,
};

enum {
	CPU_WDOG = 3656,
	CPU_CNTR = 3660,
	CPU_TIM = 3664,
	CPU_AHB_ADDR = 3668,
	CPU_AHB_WDATA = 3672,
	CPU_AHB_RDATA = 3676,
	HCU_MAP_BASE = 3680,
	CPU_AHB_CTRL = 3684,
	HCU_CCSR = 3688,
	HCU_HCSR = 3692,
};

enum {
	CRNG_EMPTY = 0,
	CRNG_EARLY = 1,
	CRNG_READY = 2,
};

enum {
	CRNG_RESEED_START_INTERVAL = 250,
	CRNG_RESEED_INTERVAL = 15000,
};

enum {
	CROS_EC_SENSOR_LAST_TS = 0,
	CROS_EC_SENSOR_NEW_TS = 1,
	CROS_EC_SENSOR_ALL_TS = 2,
};

enum {
	CRYPTOA_UNSPEC = 0,
	CRYPTOA_ALG = 1,
	CRYPTOA_TYPE = 2,
	__CRYPTOA_MAX = 3,
};

enum {
	CRYPTO_MSG_ALG_REQUEST = 0,
	CRYPTO_MSG_ALG_REGISTER = 1,
	CRYPTO_MSG_ALG_LOADED = 2,
};

enum {
	CRYPTO_MSG_BASE = 16,
	CRYPTO_MSG_NEWALG = 16,
	CRYPTO_MSG_DELALG = 17,
	CRYPTO_MSG_UPDATEALG = 18,
	CRYPTO_MSG_GETALG = 19,
	CRYPTO_MSG_DELRNG = 20,
	CRYPTO_MSG_GETSTAT = 21,
	__CRYPTO_MSG_MAX = 22,
};

enum {
	CSD_FLAG_LOCK = 1,
	IRQ_WORK_PENDING = 1,
	IRQ_WORK_BUSY = 2,
	IRQ_WORK_LAZY = 4,
	IRQ_WORK_HARD_IRQ = 8,
	IRQ_WORK_CLAIMED = 3,
	CSD_TYPE_ASYNC = 0,
	CSD_TYPE_SYNC = 16,
	CSD_TYPE_IRQ_WORK = 32,
	CSD_TYPE_TTWU = 48,
	CSD_FLAG_TYPE_MASK = 240,
};

enum {
	CSI_DEC_hl_CURSOR_KEYS = 1,
	CSI_DEC_hl_132_COLUMNS = 3,
	CSI_DEC_hl_REVERSE_VIDEO = 5,
	CSI_DEC_hl_ORIGIN_MODE = 6,
	CSI_DEC_hl_AUTOWRAP = 7,
	CSI_DEC_hl_AUTOREPEAT = 8,
	CSI_DEC_hl_MOUSE_X10 = 9,
	CSI_DEC_hl_SHOW_CURSOR = 25,
	CSI_DEC_hl_MOUSE_VT200 = 1000,
	CSI_DEC_hl_BRACKETED_PASTE = 2004,
};

enum {
	CSI_K_CURSOR_TO_LINEEND = 0,
	CSI_K_LINESTART_TO_CURSOR = 1,
	CSI_K_LINE = 2,
};

enum {
	CSI_hl_DISPLAY_CTRL = 3,
	CSI_hl_INSERT = 4,
	CSI_hl_AUTO_NL = 20,
};

enum {
	CSI_m_DEFAULT = 0,
	CSI_m_BOLD = 1,
	CSI_m_HALF_BRIGHT = 2,
	CSI_m_ITALIC = 3,
	CSI_m_UNDERLINE = 4,
	CSI_m_BLINK = 5,
	CSI_m_REVERSE = 7,
	CSI_m_PRI_FONT = 10,
	CSI_m_ALT_FONT1 = 11,
	CSI_m_ALT_FONT2 = 12,
	CSI_m_DOUBLE_UNDERLINE = 21,
	CSI_m_NORMAL_INTENSITY = 22,
	CSI_m_NO_ITALIC = 23,
	CSI_m_NO_UNDERLINE = 24,
	CSI_m_NO_BLINK = 25,
	CSI_m_NO_REVERSE = 27,
	CSI_m_FG_COLOR_BEG = 30,
	CSI_m_FG_COLOR_END = 37,
	CSI_m_FG_COLOR = 38,
	CSI_m_DEFAULT_FG_COLOR = 39,
	CSI_m_BG_COLOR_BEG = 40,
	CSI_m_BG_COLOR_END = 47,
	CSI_m_BG_COLOR = 48,
	CSI_m_DEFAULT_BG_COLOR = 49,
	CSI_m_BRIGHT_FG_COLOR_BEG = 90,
	CSI_m_BRIGHT_FG_COLOR_END = 97,
	CSI_m_BRIGHT_FG_COLOR_OFF = 60,
	CSI_m_BRIGHT_BG_COLOR_BEG = 100,
	CSI_m_BRIGHT_BG_COLOR_END = 107,
	CSI_m_BRIGHT_BG_COLOR_OFF = 60,
};

enum {
	CSS_NO_REF = 1,
	CSS_ONLINE = 2,
	CSS_RELEASED = 4,
	CSS_VISIBLE = 8,
	CSS_DYING = 16,
};

enum {
	CTRL_ATTR_MCAST_GRP_UNSPEC = 0,
	CTRL_ATTR_MCAST_GRP_NAME = 1,
	CTRL_ATTR_MCAST_GRP_ID = 2,
	__CTRL_ATTR_MCAST_GRP_MAX = 3,
};

enum {
	CTRL_ATTR_OP_UNSPEC = 0,
	CTRL_ATTR_OP_ID = 1,
	CTRL_ATTR_OP_FLAGS = 2,
	__CTRL_ATTR_OP_MAX = 3,
};

enum {
	CTRL_ATTR_POLICY_UNSPEC = 0,
	CTRL_ATTR_POLICY_DO = 1,
	CTRL_ATTR_POLICY_DUMP = 2,
	__CTRL_ATTR_POLICY_DUMP_MAX = 3,
	CTRL_ATTR_POLICY_DUMP_MAX = 2,
};

enum {
	CTRL_ATTR_UNSPEC = 0,
	CTRL_ATTR_FAMILY_ID = 1,
	CTRL_ATTR_FAMILY_NAME = 2,
	CTRL_ATTR_VERSION = 3,
	CTRL_ATTR_HDRSIZE = 4,
	CTRL_ATTR_MAXATTR = 5,
	CTRL_ATTR_OPS = 6,
	CTRL_ATTR_MCAST_GROUPS = 7,
	CTRL_ATTR_POLICY = 8,
	CTRL_ATTR_OP_POLICY = 9,
	CTRL_ATTR_OP = 10,
	__CTRL_ATTR_MAX = 11,
};

enum {
	CTRL_CMD_UNSPEC = 0,
	CTRL_CMD_NEWFAMILY = 1,
	CTRL_CMD_DELFAMILY = 2,
	CTRL_CMD_GETFAMILY = 3,
	CTRL_CMD_NEWOPS = 4,
	CTRL_CMD_DELOPS = 5,
	CTRL_CMD_GETOPS = 6,
	CTRL_CMD_NEWMCAST_GRP = 7,
	CTRL_CMD_DELMCAST_GRP = 8,
	CTRL_CMD_GETMCAST_GRP = 9,
	CTRL_CMD_GETPOLICY = 10,
	__CTRL_CMD_MAX = 11,
};

enum {
	DD_DIR_COUNT = 2,
};

enum {
	DD_PRIO_COUNT = 3,
};

enum {
	DEVLINK_ATTR_STATS_RX_PACKETS = 0,
	DEVLINK_ATTR_STATS_RX_BYTES = 1,
	DEVLINK_ATTR_STATS_RX_DROPPED = 2,
	__DEVLINK_ATTR_STATS_MAX = 3,
	DEVLINK_ATTR_STATS_MAX = 2,
};

enum {
	DEVLINK_ATTR_TRAP_METADATA_TYPE_IN_PORT = 0,
	DEVLINK_ATTR_TRAP_METADATA_TYPE_FA_COOKIE = 1,
};

enum {
	DEV_ID = 0,
	PEER_DEV_ID = 1,
	PEER_CPORT_ID = 0,
	TRAFFIC_CLASS = 0,
};

enum {
	DIO_LOCKING = 1,
	DIO_SKIP_HOLES = 2,
};

enum {
	DIO_SHOULD_DIRTY = 1,
	DIO_IS_SYNC = 2,
};

enum {
	DIR_OFFSET_FIRST = 2,
	DIR_OFFSET_EOD = 2147483647,
};

enum {
	DIR_OFFSET_MIN = 3,
	DIR_OFFSET_MAX = 2147483646,
};

enum {
	DISCOVERED = 16,
	EXPLORED = 32,
	FALLTHROUGH = 1,
	BRANCH = 2,
};

enum {
	DISK_EVENT_FLAG_POLL = 1,
	DISK_EVENT_FLAG_UEVENT = 2,
	DISK_EVENT_FLAG_BLOCK_ON_EXCL_WRITE = 4,
};

enum {
	DISK_EVENT_MEDIA_CHANGE = 1,
	DISK_EVENT_EJECT_REQUEST = 2,
};

enum {
	DMA_TX_ERR_BASE = 0,
	DMA_RX_ERR_BASE = 256,
	TRANS_TX_FAIL_BASE = 512,
	TRANS_RX_FAIL_BASE = 768,
	DMA_TX_DIF_CRC_ERR = 0,
	DMA_TX_DIF_APP_ERR = 1,
	DMA_TX_DIF_RPP_ERR = 2,
	DMA_TX_AXI_BUS_ERR = 3,
	DMA_TX_DATA_SGL_OVERFLOW_ERR = 4,
	DMA_TX_DIF_SGL_OVERFLOW_ERR = 5,
	DMA_TX_UNEXP_XFER_RDY_ERR = 6,
	DMA_TX_XFER_RDY_OFFSET_ERR = 7,
	DMA_TX_DATA_UNDERFLOW_ERR = 8,
	DMA_TX_XFER_RDY_LENGTH_OVERFLOW_ERR = 9,
	DMA_RX_BUFFER_ECC_ERR = 256,
	DMA_RX_DIF_CRC_ERR = 257,
	DMA_RX_DIF_APP_ERR = 258,
	DMA_RX_DIF_RPP_ERR = 259,
	DMA_RX_RESP_BUFFER_OVERFLOW_ERR = 260,
	DMA_RX_AXI_BUS_ERR = 261,
	DMA_RX_DATA_SGL_OVERFLOW_ERR = 262,
	DMA_RX_DIF_SGL_OVERFLOW_ERR = 263,
	DMA_RX_DATA_OFFSET_ERR = 264,
	DMA_RX_UNEXP_RX_DATA_ERR = 265,
	DMA_RX_DATA_OVERFLOW_ERR = 266,
	DMA_RX_DATA_UNDERFLOW_ERR = 267,
	DMA_RX_UNEXP_RETRANS_RESP_ERR = 268,
	TRANS_TX_RSVD0_ERR = 512,
	TRANS_TX_PHY_NOT_ENABLE_ERR = 513,
	TRANS_TX_OPEN_REJCT_WRONG_DEST_ERR = 514,
	TRANS_TX_OPEN_REJCT_ZONE_VIOLATION_ERR = 515,
	TRANS_TX_OPEN_REJCT_BY_OTHER_ERR = 516,
	TRANS_TX_RSVD1_ERR = 517,
	TRANS_TX_OPEN_REJCT_AIP_TIMEOUT_ERR = 518,
	TRANS_TX_OPEN_REJCT_STP_BUSY_ERR = 519,
	TRANS_TX_OPEN_REJCT_PROTOCOL_NOT_SUPPORT_ERR = 520,
	TRANS_TX_OPEN_REJCT_RATE_NOT_SUPPORT_ERR = 521,
	TRANS_TX_OPEN_REJCT_BAD_DEST_ERR = 522,
	TRANS_TX_OPEN_BREAK_RECEIVE_ERR = 523,
	TRANS_TX_LOW_PHY_POWER_ERR = 524,
	TRANS_TX_OPEN_REJCT_PATHWAY_BLOCKED_ERR = 525,
	TRANS_TX_OPEN_TIMEOUT_ERR = 526,
	TRANS_TX_OPEN_REJCT_NO_DEST_ERR = 527,
	TRANS_TX_OPEN_RETRY_ERR = 528,
	TRANS_TX_RSVD2_ERR = 529,
	TRANS_TX_BREAK_TIMEOUT_ERR = 530,
	TRANS_TX_BREAK_REQUEST_ERR = 531,
	TRANS_TX_BREAK_RECEIVE_ERR = 532,
	TRANS_TX_CLOSE_TIMEOUT_ERR = 533,
	TRANS_TX_CLOSE_NORMAL_ERR = 534,
	TRANS_TX_CLOSE_PHYRESET_ERR = 535,
	TRANS_TX_WITH_CLOSE_DWS_TIMEOUT_ERR = 536,
	TRANS_TX_WITH_CLOSE_COMINIT_ERR = 537,
	TRANS_TX_NAK_RECEIVE_ERR = 538,
	TRANS_TX_ACK_NAK_TIMEOUT_ERR = 539,
	TRANS_TX_CREDIT_TIMEOUT_ERR = 540,
	TRANS_TX_IPTT_CONFLICT_ERR = 541,
	TRANS_TX_TXFRM_TYPE_ERR = 542,
	TRANS_TX_TXSMP_LENGTH_ERR = 543,
	TRANS_RX_FRAME_CRC_ERR = 768,
	TRANS_RX_FRAME_DONE_ERR = 769,
	TRANS_RX_FRAME_ERRPRM_ERR = 770,
	TRANS_RX_FRAME_NO_CREDIT_ERR = 771,
	TRANS_RX_RSVD0_ERR = 772,
	TRANS_RX_FRAME_OVERRUN_ERR = 773,
	TRANS_RX_FRAME_NO_EOF_ERR = 774,
	TRANS_RX_LINK_BUF_OVERRUN_ERR = 775,
	TRANS_RX_BREAK_TIMEOUT_ERR = 776,
	TRANS_RX_BREAK_REQUEST_ERR = 777,
	TRANS_RX_BREAK_RECEIVE_ERR = 778,
	TRANS_RX_CLOSE_TIMEOUT_ERR = 779,
	TRANS_RX_CLOSE_NORMAL_ERR = 780,
	TRANS_RX_CLOSE_PHYRESET_ERR = 781,
	TRANS_RX_WITH_CLOSE_DWS_TIMEOUT_ERR = 782,
	TRANS_RX_WITH_CLOSE_COMINIT_ERR = 783,
	TRANS_RX_DATA_LENGTH0_ERR = 784,
	TRANS_RX_BAD_HASH_ERR = 785,
	TRANS_RX_XRDY_ZERO_ERR = 786,
	TRANS_RX_SSP_FRAME_LEN_ERR = 787,
	TRANS_RX_TRANS_RX_RSVD1_ERR = 788,
	TRANS_RX_NO_BALANCE_ERR = 789,
	TRANS_RX_TRANS_RX_RSVD2_ERR = 790,
	TRANS_RX_TRANS_RX_RSVD3_ERR = 791,
	TRANS_RX_BAD_FRAME_TYPE_ERR = 792,
	TRANS_RX_SMP_FRAME_LEN_ERR = 793,
	TRANS_RX_SMP_RESP_TIMEOUT_ERR = 794,
};

enum {
	DMI_QUIRK_RESET_SD_SIGNAL_VOLT_ON_SUSP = 1,
	DMI_QUIRK_SD_NO_WRITE_PROTECT = 2,
	DMI_QUIRK_SD_CD_ACTIVE_HIGH = 4,
	DMI_QUIRK_SD_CD_ENABLE_PULL_UP = 8,
};

enum {
	DONE_EXPLORING = 0,
	KEEP_EXPLORING = 1,
};

enum {
	DOWN = 0,
	UP = 1,
};

enum {
	DP83867_PORT_MIRROING_KEEP = 0,
	DP83867_PORT_MIRROING_EN = 1,
	DP83867_PORT_MIRROING_DIS = 2,
};

enum {
	DPT_START = 2,
	DPT_STOP = 1,
};

enum {
	DQF_INFO_DIRTY_B = 17,
};

enum {
	DQF_ROOT_SQUASH_B = 0,
	DQF_SYS_FILE_B = 16,
	DQF_PRIVATE = 17,
};

enum {
	DQST_LOOKUPS = 0,
	DQST_DROPS = 1,
	DQST_READS = 2,
	DQST_WRITES = 3,
	DQST_CACHE_HITS = 4,
	DQST_ALLOC_DQUOTS = 5,
	DQST_FREE_DQUOTS = 6,
	DQST_SYNCS = 7,
	_DQST_DQSTAT_LAST = 8,
};

enum {
	DRV_FIXED = 0,
	DRV_GRP0 = 1,
	DRV_GRP1 = 2,
	DRV_GRP2 = 3,
	DRV_GRP3 = 4,
	DRV_GRP4 = 5,
	DRV_GRP_MAX = 6,
};

enum {
	DSM_FUNC_ERR_HANDLE_MSI = 0,
};

enum {
	DT_BI_TCXO = 0,
	DT_SLEEP_CLK = 1,
	DT_UFS_PHY_RX_SYMBOL_0_CLK = 2,
	DT_UFS_PHY_RX_SYMBOL_1_CLK = 3,
	DT_UFS_PHY_TX_SYMBOL_0_CLK = 4,
	DT_UFS_CARD_RX_SYMBOL_0_CLK = 5,
	DT_UFS_CARD_RX_SYMBOL_1_CLK = 6,
	DT_UFS_CARD_TX_SYMBOL_0_CLK = 7,
	DT_USB3_PHY_WRAPPER_GCC_USB30_PRIM_PIPE_CLK = 8,
	DT_USB3_PHY_WRAPPER_GCC_USB30_SEC_PIPE_CLK = 9,
	DT_PCIE_0_PIPE_CLK = 10,
	DT_PCIE_1_PIPE_CLK = 11,
	DT_PCIE_PHY_AUX_CLK = 12,
	DT_RXC0_REF_CLK = 13,
	DT_RXC1_REF_CLK = 14,
};

enum {
	DT_BI_TCXO___2 = 0,
	DT_SLEEP_CLK___2 = 1,
	DT_PCIE_0_PIPE_CLK___2 = 2,
	DT_PCIE_1_PIPE_CLK___2 = 3,
	DT_PCIE_PHY_AUX_CLK___2 = 4,
	DT_RXC0_REF_CLK___2 = 5,
	DT_UFS_PHY_RX_SYMBOL_0_CLK___2 = 6,
	DT_UFS_PHY_RX_SYMBOL_1_CLK___2 = 7,
	DT_UFS_PHY_TX_SYMBOL_0_CLK___2 = 8,
	DT_USB3_PHY_WRAPPER_GCC_USB30_PRIM_PIPE_CLK___2 = 9,
};

enum {
	DT_BI_TCXO___3 = 0,
	DT_SLEEP_CLK___3 = 1,
	DT_EMAC0_SGMIIPHY_MAC_RCLK = 2,
	DT_EMAC0_SGMIIPHY_MAC_TCLK = 3,
	DT_EMAC0_SGMIIPHY_RCLK = 4,
	DT_EMAC0_SGMIIPHY_TCLK = 5,
	DT_EMAC1_SGMIIPHY_MAC_RCLK = 6,
	DT_EMAC1_SGMIIPHY_MAC_TCLK = 7,
	DT_EMAC1_SGMIIPHY_RCLK = 8,
	DT_EMAC1_SGMIIPHY_TCLK = 9,
	DT_PCIE20_PHY_AUX_CLK = 10,
	DT_PCIE_1_PIPE_CLK___3 = 11,
	DT_PCIE_2_PIPE_CLK = 12,
	DT_PCIE_PIPE_CLK = 13,
	DT_USB3_PHY_WRAPPER_GCC_USB30_PIPE_CLK = 14,
};

enum {
	DT_BI_TCXO___4 = 0,
	DT_SLEEP_CLK___4 = 1,
	DT_PCIE_0_PIPE = 2,
	DT_PCIE_1_PIPE = 3,
	DT_PCIE_1_PHY_AUX = 4,
	DT_UFS_PHY_RX_SYMBOL_0 = 5,
	DT_UFS_PHY_RX_SYMBOL_1 = 6,
	DT_UFS_PHY_TX_SYMBOL_0 = 7,
	DT_USB3_PHY_WRAPPER_GCC_USB30_PIPE = 8,
};

enum {
	DT_BI_TCXO___5 = 0,
	DT_SLEEP_CLK___5 = 1,
	DT_UFS_PHY_RX_SYMBOL_0_CLK___3 = 2,
	DT_UFS_PHY_RX_SYMBOL_1_CLK___3 = 3,
	DT_UFS_PHY_TX_SYMBOL_0_CLK___3 = 4,
	DT_UFS_CARD_RX_SYMBOL_0_CLK___2 = 5,
	DT_UFS_CARD_RX_SYMBOL_1_CLK___2 = 6,
	DT_UFS_CARD_TX_SYMBOL_0_CLK___2 = 7,
	DT_USB3_PHY_WRAPPER_GCC_USB30_PIPE_CLK___2 = 8,
	DT_GCC_USB4_PHY_PIPEGMUX_CLK_SRC = 9,
	DT_GCC_USB4_PHY_DP_GMUX_CLK_SRC = 10,
	DT_GCC_USB4_PHY_SYS_PIPEGMUX_CLK_SRC = 11,
	DT_USB4_PHY_GCC_USB4_PCIE_PIPE_CLK = 12,
	DT_USB4_PHY_GCC_USB4RTR_MAX_PIPE_CLK = 13,
	DT_QUSB4PHY_GCC_USB4_RX0_CLK = 14,
	DT_QUSB4PHY_GCC_USB4_RX1_CLK = 15,
	DT_USB3_UNI_PHY_SEC_GCC_USB30_PIPE_CLK = 16,
	DT_GCC_USB4_1_PHY_PIPEGMUX_CLK_SRC = 17,
	DT_GCC_USB4_1_PHY_DP_GMUX_CLK_SRC = 18,
	DT_GCC_USB4_1_PHY_SYS_PIPEGMUX_CLK_SRC = 19,
	DT_USB4_1_PHY_GCC_USB4_PCIE_PIPE_CLK = 20,
	DT_USB4_1_PHY_GCC_USB4RTR_MAX_PIPE_CLK = 21,
	DT_QUSB4PHY_1_GCC_USB4_RX0_CLK = 22,
	DT_QUSB4PHY_1_GCC_USB4_RX1_CLK = 23,
	DT_USB3_UNI_PHY_MP_GCC_USB30_PIPE_0_CLK = 24,
	DT_USB3_UNI_PHY_MP_GCC_USB30_PIPE_1_CLK = 25,
	DT_PCIE_2A_PIPE_CLK = 26,
	DT_PCIE_2B_PIPE_CLK = 27,
	DT_PCIE_3A_PIPE_CLK = 28,
	DT_PCIE_3B_PIPE_CLK = 29,
	DT_PCIE_4_PIPE_CLK = 30,
	DT_RXC0_REF_CLK___3 = 31,
	DT_RXC1_REF_CLK___2 = 32,
};

enum {
	DT_BI_TCXO___6 = 0,
	DT_BI_TCXO_AO = 1,
	DT_SLEEP_CLK___6 = 2,
	DT_PCIE_0_PIPE_CLK___3 = 3,
	DT_UFS_PHY_RX_SYMBOL_0_CLK___4 = 4,
	DT_UFS_PHY_RX_SYMBOL_1_CLK___4 = 5,
	DT_UFS_PHY_TX_SYMBOL_0_CLK___4 = 6,
	DT_USB3_PHY_WRAPPER_GCC_USB30_PIPE_CLK___3 = 7,
};

enum {
	DT_BI_TCXO___7 = 0,
	DT_BI_TCXO_AO___2 = 1,
	DT_SLEEP_CLK___7 = 2,
	DT_PCIE_0_PIPE___2 = 3,
	DT_PCIE_1_PIPE___2 = 4,
	DT_PCIE_1_PHY_AUX___2 = 5,
	DT_UFS_PHY_RX_SYMBOL_0___2 = 6,
	DT_UFS_PHY_RX_SYMBOL_1___2 = 7,
	DT_UFS_PHY_TX_SYMBOL_0___2 = 8,
	DT_USB3_PHY_WRAPPER_GCC_USB30_PIPE___2 = 9,
};

enum {
	DT_BI_TCXO___8 = 0,
	DT_SLEEP_CLK___8 = 1,
	DT_PCIE_0_PIPE_CLK___4 = 2,
	DT_UFS_PHY_RX_SYMBOL_0_CLK___5 = 3,
	DT_UFS_PHY_RX_SYMBOL_1_CLK___5 = 4,
	DT_UFS_PHY_TX_SYMBOL_0_CLK___5 = 5,
	DT_USB3_PHY_WRAPPER_GCC_USB30_PIPE_CLK___4 = 6,
};

enum {
	DT_BI_TCXO___9 = 0,
	DT_BI_TCXO_AO___3 = 1,
	DT_SLEEP_CLK___9 = 2,
};

enum {
	DT_BI_TCXO___10 = 0,
	DT_SLEEP_CLK___10 = 1,
	DT_PCIE_3_PIPE = 2,
	DT_PCIE_4_PIPE = 3,
	DT_PCIE_5_PIPE = 4,
	DT_PCIE_6A_PIPE = 5,
	DT_PCIE_6B_PIPE = 6,
	DT_USB3_PHY_0_WRAPPER_GCC_USB30_PIPE = 7,
	DT_USB3_PHY_1_WRAPPER_GCC_USB30_PIPE = 8,
	DT_USB3_PHY_2_WRAPPER_GCC_USB30_PIPE = 9,
};

enum {
	DT_BI_TCXO_PAD = 0,
};

enum {
	DT_TCXO_IDX = 0,
	DT_SLEEP_CLK_IDX = 1,
	DT_PCIE_0_PIPE_CLK_IDX = 2,
	DT_PCIE_0_PHY_AUX_CLK_IDX = 3,
	DT_USB3_PHY_WRAPPER_PIPE_CLK_IDX = 4,
};

enum {
	DT_XO = 0,
	DT_APCS_AUX = 1,
};

enum {
	DT_XO___2 = 0,
	DT_SLEEP_CLK___11 = 1,
	DT_PCIE20_PHY0_PIPE_CLK = 2,
	DT_PCIE20_PHY1_PIPE_CLK = 3,
	DT_USB3_PHY0_CC_PIPE_CLK = 4,
	DT_GEPHY_RX_CLK = 5,
	DT_GEPHY_TX_CLK = 6,
	DT_UNIPHY_RX_CLK = 7,
	DT_UNIPHY_TX_CLK = 8,
};

enum {
	DT_XO___3 = 0,
	DT_SLEEP_CLK___12 = 1,
	DT_PCIE30_PHY0_PIPE_CLK = 2,
	DT_PCIE30_PHY1_PIPE_CLK = 3,
	DT_PCIE30_PHY2_PIPE_CLK = 4,
	DT_PCIE30_PHY3_PIPE_CLK = 5,
	DT_USB_PCIE_WRAPPER_PIPE_CLK = 6,
};

enum {
	DT_XO___4 = 0,
	DT_SLEEP_CLK___13 = 1,
	DT_PCIE_0_PIPE_CLK___5 = 2,
	DT_DSI0_PHY_PLL_OUT_DSICLK = 3,
	DT_DSI0_PHY_PLL_OUT_BYTECLK = 4,
	DT_HDMI_PHY_PLL_CLK = 5,
};

enum {
	DT_XO___5 = 0,
	DT_SLEEP_CLK___14 = 1,
	DT_BIAS_PLL_UBI_NC_CLK = 2,
	DT_PCIE30_PHY0_PIPE_CLK___2 = 3,
	DT_PCIE30_PHY1_PIPE_CLK___2 = 4,
	DT_PCIE30_PHY2_PIPE_CLK___2 = 5,
	DT_PCIE30_PHY3_PIPE_CLK___2 = 6,
	DT_USB3PHY_0_CC_PIPE_CLK = 7,
};

enum {
	DT_XO___6 = 0,
	DT_SLEEP_CLK___15 = 1,
	DT_PCIE_2LANE_PHY_PIPE_CLK = 2,
	DT_PCIE_2LANE_PHY_PIPE_CLK_X1 = 3,
	DT_USB_PCIE_WRAPPER_PIPE_CLK___2 = 4,
};

enum {
	DUMP_PREFIX_NONE = 0,
	DUMP_PREFIX_ADDRESS = 1,
	DUMP_PREFIX_OFFSET = 2,
};

enum {
	EC_MSG_TX_HEADER_BYTES = 3,
	EC_MSG_TX_TRAILER_BYTES = 1,
	EC_MSG_TX_PROTO_BYTES = 4,
	EC_MSG_RX_PROTO_BYTES = 3,
	EC_PROTO2_MSG_BYTES = 256,
	EC_MAX_MSG_BYTES = 65536,
};

enum {
	EDSR = 0,
	EDMR = 1,
	EDTRR = 2,
	EDRRR = 3,
	EESR = 4,
	EESIPR = 5,
	TDLAR = 6,
	TDFAR = 7,
	TDFXR = 8,
	TDFFR = 9,
	RDLAR = 10,
	RDFAR = 11,
	RDFXR = 12,
	RDFFR = 13,
	TRSCER = 14,
	RMFCR = 15,
	TFTR = 16,
	FDR = 17,
	RMCR = 18,
	EDOCR = 19,
	TFUCR = 20,
	RFOCR = 21,
	RMIIMODE = 22,
	FCFTR = 23,
	RPADIR = 24,
	TRIMD = 25,
	RBWAR = 26,
	TBRAR = 27,
	ECMR = 28,
	ECSR = 29,
	ECSIPR = 30,
	PIR = 31,
	PSR = 32,
	RDMLR = 33,
	PIPR = 34,
	RFLR = 35,
	IPGR = 36,
	APR = 37,
	MPR = 38,
	PFTCR = 39,
	PFRCR = 40,
	RFCR = 41,
	RFCF = 42,
	TPAUSER = 43,
	TPAUSECR = 44,
	BCFR = 45,
	BCFRR = 46,
	GECMR = 47,
	BCULR = 48,
	MAHR = 49,
	MALR = 50,
	TROCR = 51,
	CDCR = 52,
	LCCR = 53,
	CNDCR = 54,
	CEFCR = 55,
	FRECR = 56,
	TSFRCR = 57,
	TLFRCR = 58,
	CERCR = 59,
	CEECR = 60,
	MAFCR = 61,
	RTRATE = 62,
	CSMR = 63,
	RMII_MII = 64,
	ARSTR = 65,
	TSU_CTRST = 66,
	TSU_FWEN0 = 67,
	TSU_FWEN1 = 68,
	TSU_FCM = 69,
	TSU_BSYSL0 = 70,
	TSU_BSYSL1 = 71,
	TSU_PRISL0 = 72,
	TSU_PRISL1 = 73,
	TSU_FWSL0 = 74,
	TSU_FWSL1 = 75,
	TSU_FWSLC = 76,
	TSU_QTAG0 = 77,
	TSU_QTAG1 = 78,
	TSU_QTAGM0 = 79,
	TSU_QTAGM1 = 80,
	TSU_FWSR = 81,
	TSU_FWINMK = 82,
	TSU_ADQT0 = 83,
	TSU_ADQT1 = 84,
	TSU_VTAG0 = 85,
	TSU_VTAG1 = 86,
	TSU_ADSBSY = 87,
	TSU_TEN = 88,
	TSU_POST1 = 89,
	TSU_POST2 = 90,
	TSU_POST3 = 91,
	TSU_POST4 = 92,
	TSU_ADRH0 = 93,
	TXNLCR0 = 94,
	TXALCR0 = 95,
	RXNLCR0 = 96,
	RXALCR0 = 97,
	FWNLCR0 = 98,
	FWALCR0 = 99,
	TXNLCR1 = 100,
	TXALCR1 = 101,
	RXNLCR1 = 102,
	RXALCR1 = 103,
	FWNLCR1 = 104,
	FWALCR1 = 105,
	SH_ETH_MAX_REGISTER_OFFSET = 106,
};

enum {
	EPecma = 0,
	EPdec = 1,
	EPeq = 2,
	EPgt = 3,
	EPlt = 4,
};

enum {
	ERASE = 0,
	WERASE = 1,
	KILL = 2,
};

enum {
	ES_WRITTEN_B = 0,
	ES_UNWRITTEN_B = 1,
	ES_DELAYED_B = 2,
	ES_HOLE_B = 3,
	ES_REFERENCED_B = 4,
	ES_FLAGS = 5,
};

enum {
	ETHTOOL_A_BITSET_BITS_UNSPEC = 0,
	ETHTOOL_A_BITSET_BITS_BIT = 1,
	__ETHTOOL_A_BITSET_BITS_CNT = 2,
	ETHTOOL_A_BITSET_BITS_MAX = 1,
};

enum {
	ETHTOOL_A_BITSET_BIT_UNSPEC = 0,
	ETHTOOL_A_BITSET_BIT_INDEX = 1,
	ETHTOOL_A_BITSET_BIT_NAME = 2,
	ETHTOOL_A_BITSET_BIT_VALUE = 3,
	__ETHTOOL_A_BITSET_BIT_CNT = 4,
	ETHTOOL_A_BITSET_BIT_MAX = 3,
};

enum {
	ETHTOOL_A_BITSET_UNSPEC = 0,
	ETHTOOL_A_BITSET_NOMASK = 1,
	ETHTOOL_A_BITSET_SIZE = 2,
	ETHTOOL_A_BITSET_BITS = 3,
	ETHTOOL_A_BITSET_VALUE = 4,
	ETHTOOL_A_BITSET_MASK = 5,
	__ETHTOOL_A_BITSET_CNT = 6,
	ETHTOOL_A_BITSET_MAX = 5,
};

enum {
	ETHTOOL_A_C33_PSE_PW_LIMIT_UNSPEC = 0,
	ETHTOOL_A_C33_PSE_PW_LIMIT_MIN = 1,
	ETHTOOL_A_C33_PSE_PW_LIMIT_MAX = 2,
	__ETHTOOL_A_C33_PSE_PW_LIMIT_CNT = 3,
	__ETHTOOL_A_C33_PSE_PW_LIMIT_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_AMPLITUDE_UNSPEC = 0,
	ETHTOOL_A_CABLE_AMPLITUDE_PAIR = 1,
	ETHTOOL_A_CABLE_AMPLITUDE_mV = 2,
	__ETHTOOL_A_CABLE_AMPLITUDE_CNT = 3,
	ETHTOOL_A_CABLE_AMPLITUDE_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_FAULT_LENGTH_UNSPEC = 0,
	ETHTOOL_A_CABLE_FAULT_LENGTH_PAIR = 1,
	ETHTOOL_A_CABLE_FAULT_LENGTH_CM = 2,
	ETHTOOL_A_CABLE_FAULT_LENGTH_SRC = 3,
	__ETHTOOL_A_CABLE_FAULT_LENGTH_CNT = 4,
	ETHTOOL_A_CABLE_FAULT_LENGTH_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_INF_SRC_UNSPEC = 0,
	ETHTOOL_A_CABLE_INF_SRC_TDR = 1,
	ETHTOOL_A_CABLE_INF_SRC_ALCD = 2,
};

enum {
	ETHTOOL_A_CABLE_NEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_NEST_RESULT = 1,
	ETHTOOL_A_CABLE_NEST_FAULT_LENGTH = 2,
	__ETHTOOL_A_CABLE_NEST_CNT = 3,
	ETHTOOL_A_CABLE_NEST_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_PAIR_A = 0,
	ETHTOOL_A_CABLE_PAIR_B = 1,
	ETHTOOL_A_CABLE_PAIR_C = 2,
	ETHTOOL_A_CABLE_PAIR_D = 3,
};

enum {
	ETHTOOL_A_CABLE_PULSE_UNSPEC = 0,
	ETHTOOL_A_CABLE_PULSE_mV = 1,
	__ETHTOOL_A_CABLE_PULSE_CNT = 2,
	ETHTOOL_A_CABLE_PULSE_MAX = 1,
};

enum {
	ETHTOOL_A_CABLE_RESULT_CODE_UNSPEC = 0,
	ETHTOOL_A_CABLE_RESULT_CODE_OK = 1,
	ETHTOOL_A_CABLE_RESULT_CODE_OPEN = 2,
	ETHTOOL_A_CABLE_RESULT_CODE_SAME_SHORT = 3,
	ETHTOOL_A_CABLE_RESULT_CODE_CROSS_SHORT = 4,
	ETHTOOL_A_CABLE_RESULT_CODE_IMPEDANCE_MISMATCH = 5,
	ETHTOOL_A_CABLE_RESULT_CODE_NOISE = 6,
	ETHTOOL_A_CABLE_RESULT_CODE_RESOLUTION_NOT_POSSIBLE = 7,
};

enum {
	ETHTOOL_A_CABLE_RESULT_UNSPEC = 0,
	ETHTOOL_A_CABLE_RESULT_PAIR = 1,
	ETHTOOL_A_CABLE_RESULT_CODE = 2,
	ETHTOOL_A_CABLE_RESULT_SRC = 3,
	__ETHTOOL_A_CABLE_RESULT_CNT = 4,
	ETHTOOL_A_CABLE_RESULT_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_STEP_UNSPEC = 0,
	ETHTOOL_A_CABLE_STEP_FIRST_DISTANCE = 1,
	ETHTOOL_A_CABLE_STEP_LAST_DISTANCE = 2,
	ETHTOOL_A_CABLE_STEP_STEP_DISTANCE = 3,
	__ETHTOOL_A_CABLE_STEP_CNT = 4,
	ETHTOOL_A_CABLE_STEP_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TDR_NEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TDR_NEST_STEP = 1,
	ETHTOOL_A_CABLE_TDR_NEST_AMPLITUDE = 2,
	ETHTOOL_A_CABLE_TDR_NEST_PULSE = 3,
	__ETHTOOL_A_CABLE_TDR_NEST_CNT = 4,
	ETHTOOL_A_CABLE_TDR_NEST_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_STARTED = 1,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_COMPLETED = 2,
};

enum {
	ETHTOOL_A_CABLE_TEST_NTF_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_NTF_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS = 2,
	ETHTOOL_A_CABLE_TEST_NTF_NEST = 3,
	__ETHTOOL_A_CABLE_TEST_NTF_CNT = 4,
	ETHTOOL_A_CABLE_TEST_NTF_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_CFG_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_FIRST = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_LAST = 2,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_STEP = 3,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_PAIR = 4,
	__ETHTOOL_A_CABLE_TEST_TDR_CFG_CNT = 5,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_MAX = 4,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG = 2,
	__ETHTOOL_A_CABLE_TEST_TDR_CNT = 3,
	ETHTOOL_A_CABLE_TEST_TDR_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_TEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_HEADER = 1,
	__ETHTOOL_A_CABLE_TEST_CNT = 2,
	ETHTOOL_A_CABLE_TEST_MAX = 1,
};

enum {
	ETHTOOL_A_CHANNELS_UNSPEC = 0,
	ETHTOOL_A_CHANNELS_HEADER = 1,
	ETHTOOL_A_CHANNELS_RX_MAX = 2,
	ETHTOOL_A_CHANNELS_TX_MAX = 3,
	ETHTOOL_A_CHANNELS_OTHER_MAX = 4,
	ETHTOOL_A_CHANNELS_COMBINED_MAX = 5,
	ETHTOOL_A_CHANNELS_RX_COUNT = 6,
	ETHTOOL_A_CHANNELS_TX_COUNT = 7,
	ETHTOOL_A_CHANNELS_OTHER_COUNT = 8,
	ETHTOOL_A_CHANNELS_COMBINED_COUNT = 9,
	__ETHTOOL_A_CHANNELS_CNT = 10,
	ETHTOOL_A_CHANNELS_MAX = 9,
};

enum {
	ETHTOOL_A_COALESCE_UNSPEC = 0,
	ETHTOOL_A_COALESCE_HEADER = 1,
	ETHTOOL_A_COALESCE_RX_USECS = 2,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES = 3,
	ETHTOOL_A_COALESCE_RX_USECS_IRQ = 4,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_IRQ = 5,
	ETHTOOL_A_COALESCE_TX_USECS = 6,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES = 7,
	ETHTOOL_A_COALESCE_TX_USECS_IRQ = 8,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_IRQ = 9,
	ETHTOOL_A_COALESCE_STATS_BLOCK_USECS = 10,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_RX = 11,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_TX = 12,
	ETHTOOL_A_COALESCE_PKT_RATE_LOW = 13,
	ETHTOOL_A_COALESCE_RX_USECS_LOW = 14,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_LOW = 15,
	ETHTOOL_A_COALESCE_TX_USECS_LOW = 16,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_LOW = 17,
	ETHTOOL_A_COALESCE_PKT_RATE_HIGH = 18,
	ETHTOOL_A_COALESCE_RX_USECS_HIGH = 19,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_HIGH = 20,
	ETHTOOL_A_COALESCE_TX_USECS_HIGH = 21,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_HIGH = 22,
	ETHTOOL_A_COALESCE_RATE_SAMPLE_INTERVAL = 23,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_TX = 24,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_RX = 25,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_BYTES = 26,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_FRAMES = 27,
	ETHTOOL_A_COALESCE_TX_AGGR_TIME_USECS = 28,
	ETHTOOL_A_COALESCE_RX_PROFILE = 29,
	ETHTOOL_A_COALESCE_TX_PROFILE = 30,
	__ETHTOOL_A_COALESCE_CNT = 31,
	ETHTOOL_A_COALESCE_MAX = 30,
};

enum {
	ETHTOOL_A_DEBUG_UNSPEC = 0,
	ETHTOOL_A_DEBUG_HEADER = 1,
	ETHTOOL_A_DEBUG_MSGMASK = 2,
	__ETHTOOL_A_DEBUG_CNT = 3,
	ETHTOOL_A_DEBUG_MAX = 2,
};

enum {
	ETHTOOL_A_EEE_UNSPEC = 0,
	ETHTOOL_A_EEE_HEADER = 1,
	ETHTOOL_A_EEE_MODES_OURS = 2,
	ETHTOOL_A_EEE_MODES_PEER = 3,
	ETHTOOL_A_EEE_ACTIVE = 4,
	ETHTOOL_A_EEE_ENABLED = 5,
	ETHTOOL_A_EEE_TX_LPI_ENABLED = 6,
	ETHTOOL_A_EEE_TX_LPI_TIMER = 7,
	__ETHTOOL_A_EEE_CNT = 8,
	ETHTOOL_A_EEE_MAX = 7,
};

enum {
	ETHTOOL_A_FEATURES_UNSPEC = 0,
	ETHTOOL_A_FEATURES_HEADER = 1,
	ETHTOOL_A_FEATURES_HW = 2,
	ETHTOOL_A_FEATURES_WANTED = 3,
	ETHTOOL_A_FEATURES_ACTIVE = 4,
	ETHTOOL_A_FEATURES_NOCHANGE = 5,
	__ETHTOOL_A_FEATURES_CNT = 6,
	ETHTOOL_A_FEATURES_MAX = 5,
};

enum {
	ETHTOOL_A_FEC_STAT_UNSPEC = 0,
	ETHTOOL_A_FEC_STAT_PAD = 1,
	ETHTOOL_A_FEC_STAT_CORRECTED = 2,
	ETHTOOL_A_FEC_STAT_UNCORR = 3,
	ETHTOOL_A_FEC_STAT_CORR_BITS = 4,
	__ETHTOOL_A_FEC_STAT_CNT = 5,
	ETHTOOL_A_FEC_STAT_MAX = 4,
};

enum {
	ETHTOOL_A_FEC_UNSPEC = 0,
	ETHTOOL_A_FEC_HEADER = 1,
	ETHTOOL_A_FEC_MODES = 2,
	ETHTOOL_A_FEC_AUTO = 3,
	ETHTOOL_A_FEC_ACTIVE = 4,
	ETHTOOL_A_FEC_STATS = 5,
	__ETHTOOL_A_FEC_CNT = 6,
	ETHTOOL_A_FEC_MAX = 5,
};

enum {
	ETHTOOL_A_HEADER_UNSPEC = 0,
	ETHTOOL_A_HEADER_DEV_INDEX = 1,
	ETHTOOL_A_HEADER_DEV_NAME = 2,
	ETHTOOL_A_HEADER_FLAGS = 3,
	ETHTOOL_A_HEADER_PHY_INDEX = 4,
	__ETHTOOL_A_HEADER_CNT = 5,
	ETHTOOL_A_HEADER_MAX = 4,
};

enum {
	ETHTOOL_A_IRQ_MODERATION_UNSPEC = 0,
	ETHTOOL_A_IRQ_MODERATION_USEC = 1,
	ETHTOOL_A_IRQ_MODERATION_PKTS = 2,
	ETHTOOL_A_IRQ_MODERATION_COMPS = 3,
	__ETHTOOL_A_IRQ_MODERATION_CNT = 4,
	ETHTOOL_A_IRQ_MODERATION_MAX = 3,
};

enum {
	ETHTOOL_A_LINKINFO_UNSPEC = 0,
	ETHTOOL_A_LINKINFO_HEADER = 1,
	ETHTOOL_A_LINKINFO_PORT = 2,
	ETHTOOL_A_LINKINFO_PHYADDR = 3,
	ETHTOOL_A_LINKINFO_TP_MDIX = 4,
	ETHTOOL_A_LINKINFO_TP_MDIX_CTRL = 5,
	ETHTOOL_A_LINKINFO_TRANSCEIVER = 6,
	__ETHTOOL_A_LINKINFO_CNT = 7,
	ETHTOOL_A_LINKINFO_MAX = 6,
};

enum {
	ETHTOOL_A_LINKMODES_UNSPEC = 0,
	ETHTOOL_A_LINKMODES_HEADER = 1,
	ETHTOOL_A_LINKMODES_AUTONEG = 2,
	ETHTOOL_A_LINKMODES_OURS = 3,
	ETHTOOL_A_LINKMODES_PEER = 4,
	ETHTOOL_A_LINKMODES_SPEED = 5,
	ETHTOOL_A_LINKMODES_DUPLEX = 6,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_CFG = 7,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_STATE = 8,
	ETHTOOL_A_LINKMODES_LANES = 9,
	ETHTOOL_A_LINKMODES_RATE_MATCHING = 10,
	__ETHTOOL_A_LINKMODES_CNT = 11,
	ETHTOOL_A_LINKMODES_MAX = 10,
};

enum {
	ETHTOOL_A_LINKSTATE_UNSPEC = 0,
	ETHTOOL_A_LINKSTATE_HEADER = 1,
	ETHTOOL_A_LINKSTATE_LINK = 2,
	ETHTOOL_A_LINKSTATE_SQI = 3,
	ETHTOOL_A_LINKSTATE_SQI_MAX = 4,
	ETHTOOL_A_LINKSTATE_EXT_STATE = 5,
	ETHTOOL_A_LINKSTATE_EXT_SUBSTATE = 6,
	ETHTOOL_A_LINKSTATE_EXT_DOWN_CNT = 7,
	__ETHTOOL_A_LINKSTATE_CNT = 8,
	ETHTOOL_A_LINKSTATE_MAX = 7,
};

enum {
	ETHTOOL_A_MM_STAT_UNSPEC = 0,
	ETHTOOL_A_MM_STAT_PAD = 1,
	ETHTOOL_A_MM_STAT_REASSEMBLY_ERRORS = 2,
	ETHTOOL_A_MM_STAT_SMD_ERRORS = 3,
	ETHTOOL_A_MM_STAT_REASSEMBLY_OK = 4,
	ETHTOOL_A_MM_STAT_RX_FRAG_COUNT = 5,
	ETHTOOL_A_MM_STAT_TX_FRAG_COUNT = 6,
	ETHTOOL_A_MM_STAT_HOLD_COUNT = 7,
	__ETHTOOL_A_MM_STAT_CNT = 8,
	ETHTOOL_A_MM_STAT_MAX = 7,
};

enum {
	ETHTOOL_A_MM_UNSPEC = 0,
	ETHTOOL_A_MM_HEADER = 1,
	ETHTOOL_A_MM_PMAC_ENABLED = 2,
	ETHTOOL_A_MM_TX_ENABLED = 3,
	ETHTOOL_A_MM_TX_ACTIVE = 4,
	ETHTOOL_A_MM_TX_MIN_FRAG_SIZE = 5,
	ETHTOOL_A_MM_RX_MIN_FRAG_SIZE = 6,
	ETHTOOL_A_MM_VERIFY_ENABLED = 7,
	ETHTOOL_A_MM_VERIFY_STATUS = 8,
	ETHTOOL_A_MM_VERIFY_TIME = 9,
	ETHTOOL_A_MM_MAX_VERIFY_TIME = 10,
	ETHTOOL_A_MM_STATS = 11,
	__ETHTOOL_A_MM_CNT = 12,
	ETHTOOL_A_MM_MAX = 11,
};

enum {
	ETHTOOL_A_MODULE_EEPROM_UNSPEC = 0,
	ETHTOOL_A_MODULE_EEPROM_HEADER = 1,
	ETHTOOL_A_MODULE_EEPROM_OFFSET = 2,
	ETHTOOL_A_MODULE_EEPROM_LENGTH = 3,
	ETHTOOL_A_MODULE_EEPROM_PAGE = 4,
	ETHTOOL_A_MODULE_EEPROM_BANK = 5,
	ETHTOOL_A_MODULE_EEPROM_I2C_ADDRESS = 6,
	ETHTOOL_A_MODULE_EEPROM_DATA = 7,
	__ETHTOOL_A_MODULE_EEPROM_CNT = 8,
	ETHTOOL_A_MODULE_EEPROM_MAX = 7,
};

enum {
	ETHTOOL_A_MODULE_FW_FLASH_UNSPEC = 0,
	ETHTOOL_A_MODULE_FW_FLASH_HEADER = 1,
	ETHTOOL_A_MODULE_FW_FLASH_FILE_NAME = 2,
	ETHTOOL_A_MODULE_FW_FLASH_PASSWORD = 3,
	ETHTOOL_A_MODULE_FW_FLASH_STATUS = 4,
	ETHTOOL_A_MODULE_FW_FLASH_STATUS_MSG = 5,
	ETHTOOL_A_MODULE_FW_FLASH_DONE = 6,
	ETHTOOL_A_MODULE_FW_FLASH_TOTAL = 7,
	__ETHTOOL_A_MODULE_FW_FLASH_CNT = 8,
	ETHTOOL_A_MODULE_FW_FLASH_MAX = 7,
};

enum {
	ETHTOOL_A_MODULE_UNSPEC = 0,
	ETHTOOL_A_MODULE_HEADER = 1,
	ETHTOOL_A_MODULE_POWER_MODE_POLICY = 2,
	ETHTOOL_A_MODULE_POWER_MODE = 3,
	__ETHTOOL_A_MODULE_CNT = 4,
	ETHTOOL_A_MODULE_MAX = 3,
};

enum {
	ETHTOOL_A_PAUSE_STAT_UNSPEC = 0,
	ETHTOOL_A_PAUSE_STAT_PAD = 1,
	ETHTOOL_A_PAUSE_STAT_TX_FRAMES = 2,
	ETHTOOL_A_PAUSE_STAT_RX_FRAMES = 3,
	__ETHTOOL_A_PAUSE_STAT_CNT = 4,
	ETHTOOL_A_PAUSE_STAT_MAX = 3,
};

enum {
	ETHTOOL_A_PAUSE_UNSPEC = 0,
	ETHTOOL_A_PAUSE_HEADER = 1,
	ETHTOOL_A_PAUSE_AUTONEG = 2,
	ETHTOOL_A_PAUSE_RX = 3,
	ETHTOOL_A_PAUSE_TX = 4,
	ETHTOOL_A_PAUSE_STATS = 5,
	ETHTOOL_A_PAUSE_STATS_SRC = 6,
	__ETHTOOL_A_PAUSE_CNT = 7,
	ETHTOOL_A_PAUSE_MAX = 6,
};

enum {
	ETHTOOL_A_PHC_VCLOCKS_UNSPEC = 0,
	ETHTOOL_A_PHC_VCLOCKS_HEADER = 1,
	ETHTOOL_A_PHC_VCLOCKS_NUM = 2,
	ETHTOOL_A_PHC_VCLOCKS_INDEX = 3,
	__ETHTOOL_A_PHC_VCLOCKS_CNT = 4,
	ETHTOOL_A_PHC_VCLOCKS_MAX = 3,
};

enum {
	ETHTOOL_A_PHY_UNSPEC = 0,
	ETHTOOL_A_PHY_HEADER = 1,
	ETHTOOL_A_PHY_INDEX = 2,
	ETHTOOL_A_PHY_DRVNAME = 3,
	ETHTOOL_A_PHY_NAME = 4,
	ETHTOOL_A_PHY_UPSTREAM_TYPE = 5,
	ETHTOOL_A_PHY_UPSTREAM_INDEX = 6,
	ETHTOOL_A_PHY_UPSTREAM_SFP_NAME = 7,
	ETHTOOL_A_PHY_DOWNSTREAM_SFP_NAME = 8,
	__ETHTOOL_A_PHY_CNT = 9,
	ETHTOOL_A_PHY_MAX = 8,
};

enum {
	ETHTOOL_A_PLCA_UNSPEC = 0,
	ETHTOOL_A_PLCA_HEADER = 1,
	ETHTOOL_A_PLCA_VERSION = 2,
	ETHTOOL_A_PLCA_ENABLED = 3,
	ETHTOOL_A_PLCA_STATUS = 4,
	ETHTOOL_A_PLCA_NODE_CNT = 5,
	ETHTOOL_A_PLCA_NODE_ID = 6,
	ETHTOOL_A_PLCA_TO_TMR = 7,
	ETHTOOL_A_PLCA_BURST_CNT = 8,
	ETHTOOL_A_PLCA_BURST_TMR = 9,
	__ETHTOOL_A_PLCA_CNT = 10,
	ETHTOOL_A_PLCA_MAX = 9,
};

enum {
	ETHTOOL_A_PRIVFLAGS_UNSPEC = 0,
	ETHTOOL_A_PRIVFLAGS_HEADER = 1,
	ETHTOOL_A_PRIVFLAGS_FLAGS = 2,
	__ETHTOOL_A_PRIVFLAGS_CNT = 3,
	ETHTOOL_A_PRIVFLAGS_MAX = 2,
};

enum {
	ETHTOOL_A_PROFILE_UNSPEC = 0,
	ETHTOOL_A_PROFILE_IRQ_MODERATION = 1,
	__ETHTOOL_A_PROFILE_CNT = 2,
	ETHTOOL_A_PROFILE_MAX = 1,
};

enum {
	ETHTOOL_A_PSE_UNSPEC = 0,
	ETHTOOL_A_PSE_HEADER = 1,
	ETHTOOL_A_PODL_PSE_ADMIN_STATE = 2,
	ETHTOOL_A_PODL_PSE_ADMIN_CONTROL = 3,
	ETHTOOL_A_PODL_PSE_PW_D_STATUS = 4,
	ETHTOOL_A_C33_PSE_ADMIN_STATE = 5,
	ETHTOOL_A_C33_PSE_ADMIN_CONTROL = 6,
	ETHTOOL_A_C33_PSE_PW_D_STATUS = 7,
	ETHTOOL_A_C33_PSE_PW_CLASS = 8,
	ETHTOOL_A_C33_PSE_ACTUAL_PW = 9,
	ETHTOOL_A_C33_PSE_EXT_STATE = 10,
	ETHTOOL_A_C33_PSE_EXT_SUBSTATE = 11,
	ETHTOOL_A_C33_PSE_AVAIL_PW_LIMIT = 12,
	ETHTOOL_A_C33_PSE_PW_LIMIT_RANGES = 13,
	__ETHTOOL_A_PSE_CNT = 14,
	ETHTOOL_A_PSE_MAX = 13,
};

enum {
	ETHTOOL_A_RINGS_UNSPEC = 0,
	ETHTOOL_A_RINGS_HEADER = 1,
	ETHTOOL_A_RINGS_RX_MAX = 2,
	ETHTOOL_A_RINGS_RX_MINI_MAX = 3,
	ETHTOOL_A_RINGS_RX_JUMBO_MAX = 4,
	ETHTOOL_A_RINGS_TX_MAX = 5,
	ETHTOOL_A_RINGS_RX = 6,
	ETHTOOL_A_RINGS_RX_MINI = 7,
	ETHTOOL_A_RINGS_RX_JUMBO = 8,
	ETHTOOL_A_RINGS_TX = 9,
	ETHTOOL_A_RINGS_RX_BUF_LEN = 10,
	ETHTOOL_A_RINGS_TCP_DATA_SPLIT = 11,
	ETHTOOL_A_RINGS_CQE_SIZE = 12,
	ETHTOOL_A_RINGS_TX_PUSH = 13,
	ETHTOOL_A_RINGS_RX_PUSH = 14,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN = 15,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN_MAX = 16,
	ETHTOOL_A_RINGS_HDS_THRESH = 17,
	ETHTOOL_A_RINGS_HDS_THRESH_MAX = 18,
	__ETHTOOL_A_RINGS_CNT = 19,
	ETHTOOL_A_RINGS_MAX = 18,
};

enum {
	ETHTOOL_A_RSS_UNSPEC = 0,
	ETHTOOL_A_RSS_HEADER = 1,
	ETHTOOL_A_RSS_CONTEXT = 2,
	ETHTOOL_A_RSS_HFUNC = 3,
	ETHTOOL_A_RSS_INDIR = 4,
	ETHTOOL_A_RSS_HKEY = 5,
	ETHTOOL_A_RSS_INPUT_XFRM = 6,
	ETHTOOL_A_RSS_START_CONTEXT = 7,
	__ETHTOOL_A_RSS_CNT = 8,
	ETHTOOL_A_RSS_MAX = 7,
};

enum {
	ETHTOOL_A_STATS_ETH_CTRL_3_TX = 0,
	ETHTOOL_A_STATS_ETH_CTRL_4_RX = 1,
	ETHTOOL_A_STATS_ETH_CTRL_5_RX_UNSUP = 2,
	__ETHTOOL_A_STATS_ETH_CTRL_CNT = 3,
	ETHTOOL_A_STATS_ETH_CTRL_MAX = 2,
};

enum {
	ETHTOOL_A_STATS_ETH_MAC_2_TX_PKT = 0,
	ETHTOOL_A_STATS_ETH_MAC_3_SINGLE_COL = 1,
	ETHTOOL_A_STATS_ETH_MAC_4_MULTI_COL = 2,
	ETHTOOL_A_STATS_ETH_MAC_5_RX_PKT = 3,
	ETHTOOL_A_STATS_ETH_MAC_6_FCS_ERR = 4,
	ETHTOOL_A_STATS_ETH_MAC_7_ALIGN_ERR = 5,
	ETHTOOL_A_STATS_ETH_MAC_8_TX_BYTES = 6,
	ETHTOOL_A_STATS_ETH_MAC_9_TX_DEFER = 7,
	ETHTOOL_A_STATS_ETH_MAC_10_LATE_COL = 8,
	ETHTOOL_A_STATS_ETH_MAC_11_XS_COL = 9,
	ETHTOOL_A_STATS_ETH_MAC_12_TX_INT_ERR = 10,
	ETHTOOL_A_STATS_ETH_MAC_13_CS_ERR = 11,
	ETHTOOL_A_STATS_ETH_MAC_14_RX_BYTES = 12,
	ETHTOOL_A_STATS_ETH_MAC_15_RX_INT_ERR = 13,
	ETHTOOL_A_STATS_ETH_MAC_18_TX_MCAST = 14,
	ETHTOOL_A_STATS_ETH_MAC_19_TX_BCAST = 15,
	ETHTOOL_A_STATS_ETH_MAC_20_XS_DEFER = 16,
	ETHTOOL_A_STATS_ETH_MAC_21_RX_MCAST = 17,
	ETHTOOL_A_STATS_ETH_MAC_22_RX_BCAST = 18,
	ETHTOOL_A_STATS_ETH_MAC_23_IR_LEN_ERR = 19,
	ETHTOOL_A_STATS_ETH_MAC_24_OOR_LEN = 20,
	ETHTOOL_A_STATS_ETH_MAC_25_TOO_LONG_ERR = 21,
	__ETHTOOL_A_STATS_ETH_MAC_CNT = 22,
	ETHTOOL_A_STATS_ETH_MAC_MAX = 21,
};

enum {
	ETHTOOL_A_STATS_ETH_PHY_5_SYM_ERR = 0,
	__ETHTOOL_A_STATS_ETH_PHY_CNT = 1,
	ETHTOOL_A_STATS_ETH_PHY_MAX = 0,
};

enum {
	ETHTOOL_A_STATS_GRP_UNSPEC = 0,
	ETHTOOL_A_STATS_GRP_PAD = 1,
	ETHTOOL_A_STATS_GRP_ID = 2,
	ETHTOOL_A_STATS_GRP_SS_ID = 3,
	ETHTOOL_A_STATS_GRP_STAT = 4,
	ETHTOOL_A_STATS_GRP_HIST_RX = 5,
	ETHTOOL_A_STATS_GRP_HIST_TX = 6,
	ETHTOOL_A_STATS_GRP_HIST_BKT_LOW = 7,
	ETHTOOL_A_STATS_GRP_HIST_BKT_HI = 8,
	ETHTOOL_A_STATS_GRP_HIST_VAL = 9,
	__ETHTOOL_A_STATS_GRP_CNT = 10,
	ETHTOOL_A_STATS_GRP_MAX = 9,
};

enum {
	ETHTOOL_A_STATS_PHY_RX_PKTS = 0,
	ETHTOOL_A_STATS_PHY_RX_BYTES = 1,
	ETHTOOL_A_STATS_PHY_RX_ERRORS = 2,
	ETHTOOL_A_STATS_PHY_TX_PKTS = 3,
	ETHTOOL_A_STATS_PHY_TX_BYTES = 4,
	ETHTOOL_A_STATS_PHY_TX_ERRORS = 5,
	__ETHTOOL_A_STATS_PHY_CNT = 6,
	ETHTOOL_A_STATS_PHY_MAX = 5,
};

enum {
	ETHTOOL_A_STATS_RMON_UNDERSIZE = 0,
	ETHTOOL_A_STATS_RMON_OVERSIZE = 1,
	ETHTOOL_A_STATS_RMON_FRAG = 2,
	ETHTOOL_A_STATS_RMON_JABBER = 3,
	__ETHTOOL_A_STATS_RMON_CNT = 4,
	ETHTOOL_A_STATS_RMON_MAX = 3,
};

enum {
	ETHTOOL_A_STATS_UNSPEC = 0,
	ETHTOOL_A_STATS_PAD = 1,
	ETHTOOL_A_STATS_HEADER = 2,
	ETHTOOL_A_STATS_GROUPS = 3,
	ETHTOOL_A_STATS_GRP = 4,
	ETHTOOL_A_STATS_SRC = 5,
	__ETHTOOL_A_STATS_CNT = 6,
	ETHTOOL_A_STATS_MAX = 5,
};

enum {
	ETHTOOL_A_STRINGSETS_UNSPEC = 0,
	ETHTOOL_A_STRINGSETS_STRINGSET = 1,
	__ETHTOOL_A_STRINGSETS_CNT = 2,
	ETHTOOL_A_STRINGSETS_MAX = 1,
};

enum {
	ETHTOOL_A_STRINGSET_UNSPEC = 0,
	ETHTOOL_A_STRINGSET_ID = 1,
	ETHTOOL_A_STRINGSET_COUNT = 2,
	ETHTOOL_A_STRINGSET_STRINGS = 3,
	__ETHTOOL_A_STRINGSET_CNT = 4,
	ETHTOOL_A_STRINGSET_MAX = 3,
};

enum {
	ETHTOOL_A_STRINGS_UNSPEC = 0,
	ETHTOOL_A_STRINGS_STRING = 1,
	__ETHTOOL_A_STRINGS_CNT = 2,
	ETHTOOL_A_STRINGS_MAX = 1,
};

enum {
	ETHTOOL_A_STRING_UNSPEC = 0,
	ETHTOOL_A_STRING_INDEX = 1,
	ETHTOOL_A_STRING_VALUE = 2,
	__ETHTOOL_A_STRING_CNT = 3,
	ETHTOOL_A_STRING_MAX = 2,
};

enum {
	ETHTOOL_A_STRSET_UNSPEC = 0,
	ETHTOOL_A_STRSET_HEADER = 1,
	ETHTOOL_A_STRSET_STRINGSETS = 2,
	ETHTOOL_A_STRSET_COUNTS_ONLY = 3,
	__ETHTOOL_A_STRSET_CNT = 4,
	ETHTOOL_A_STRSET_MAX = 3,
};

enum {
	ETHTOOL_A_TSCONFIG_UNSPEC = 0,
	ETHTOOL_A_TSCONFIG_HEADER = 1,
	ETHTOOL_A_TSCONFIG_HWTSTAMP_PROVIDER = 2,
	ETHTOOL_A_TSCONFIG_TX_TYPES = 3,
	ETHTOOL_A_TSCONFIG_RX_FILTERS = 4,
	ETHTOOL_A_TSCONFIG_HWTSTAMP_FLAGS = 5,
	__ETHTOOL_A_TSCONFIG_CNT = 6,
	ETHTOOL_A_TSCONFIG_MAX = 5,
};

enum {
	ETHTOOL_A_TSINFO_UNSPEC = 0,
	ETHTOOL_A_TSINFO_HEADER = 1,
	ETHTOOL_A_TSINFO_TIMESTAMPING = 2,
	ETHTOOL_A_TSINFO_TX_TYPES = 3,
	ETHTOOL_A_TSINFO_RX_FILTERS = 4,
	ETHTOOL_A_TSINFO_PHC_INDEX = 5,
	ETHTOOL_A_TSINFO_STATS = 6,
	ETHTOOL_A_TSINFO_HWTSTAMP_PROVIDER = 7,
	ETHTOOL_A_TSINFO_HWTSTAMP_SOURCE = 8,
	ETHTOOL_A_TSINFO_HWTSTAMP_PHYINDEX = 9,
	__ETHTOOL_A_TSINFO_CNT = 10,
	ETHTOOL_A_TSINFO_MAX = 9,
};

enum {
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_UNSPEC = 0,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_INDEX = 1,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_QUALIFIER = 2,
	__ETHTOOL_A_TS_HWTSTAMP_PROVIDER_CNT = 3,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_MAX = 2,
};

enum {
	ETHTOOL_A_TS_STAT_UNSPEC = 0,
	ETHTOOL_A_TS_STAT_TX_PKTS = 1,
	ETHTOOL_A_TS_STAT_TX_LOST = 2,
	ETHTOOL_A_TS_STAT_TX_ERR = 3,
	ETHTOOL_A_TS_STAT_TX_ONESTEP_PKTS_UNCONFIRMED = 4,
	__ETHTOOL_A_TS_STAT_CNT = 5,
	ETHTOOL_A_TS_STAT_MAX = 4,
};

enum {
	ETHTOOL_A_TUNNEL_INFO_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_INFO_HEADER = 1,
	ETHTOOL_A_TUNNEL_INFO_UDP_PORTS = 2,
	__ETHTOOL_A_TUNNEL_INFO_CNT = 3,
	ETHTOOL_A_TUNNEL_INFO_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_ENTRY_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_PORT = 1,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_TYPE = 2,
	__ETHTOOL_A_TUNNEL_UDP_ENTRY_CNT = 3,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_TABLE_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_TABLE_SIZE = 1,
	ETHTOOL_A_TUNNEL_UDP_TABLE_TYPES = 2,
	ETHTOOL_A_TUNNEL_UDP_TABLE_ENTRY = 3,
	__ETHTOOL_A_TUNNEL_UDP_TABLE_CNT = 4,
	ETHTOOL_A_TUNNEL_UDP_TABLE_MAX = 3,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_TABLE = 1,
	__ETHTOOL_A_TUNNEL_UDP_CNT = 2,
	ETHTOOL_A_TUNNEL_UDP_MAX = 1,
};

enum {
	ETHTOOL_A_WOL_UNSPEC = 0,
	ETHTOOL_A_WOL_HEADER = 1,
	ETHTOOL_A_WOL_MODES = 2,
	ETHTOOL_A_WOL_SOPASS = 3,
	__ETHTOOL_A_WOL_CNT = 4,
	ETHTOOL_A_WOL_MAX = 3,
};

enum {
	ETHTOOL_MSG_KERNEL_NONE = 0,
	ETHTOOL_MSG_STRSET_GET_REPLY = 1,
	ETHTOOL_MSG_LINKINFO_GET_REPLY = 2,
	ETHTOOL_MSG_LINKINFO_NTF = 3,
	ETHTOOL_MSG_LINKMODES_GET_REPLY = 4,
	ETHTOOL_MSG_LINKMODES_NTF = 5,
	ETHTOOL_MSG_LINKSTATE_GET_REPLY = 6,
	ETHTOOL_MSG_DEBUG_GET_REPLY = 7,
	ETHTOOL_MSG_DEBUG_NTF = 8,
	ETHTOOL_MSG_WOL_GET_REPLY = 9,
	ETHTOOL_MSG_WOL_NTF = 10,
	ETHTOOL_MSG_FEATURES_GET_REPLY = 11,
	ETHTOOL_MSG_FEATURES_SET_REPLY = 12,
	ETHTOOL_MSG_FEATURES_NTF = 13,
	ETHTOOL_MSG_PRIVFLAGS_GET_REPLY = 14,
	ETHTOOL_MSG_PRIVFLAGS_NTF = 15,
	ETHTOOL_MSG_RINGS_GET_REPLY = 16,
	ETHTOOL_MSG_RINGS_NTF = 17,
	ETHTOOL_MSG_CHANNELS_GET_REPLY = 18,
	ETHTOOL_MSG_CHANNELS_NTF = 19,
	ETHTOOL_MSG_COALESCE_GET_REPLY = 20,
	ETHTOOL_MSG_COALESCE_NTF = 21,
	ETHTOOL_MSG_PAUSE_GET_REPLY = 22,
	ETHTOOL_MSG_PAUSE_NTF = 23,
	ETHTOOL_MSG_EEE_GET_REPLY = 24,
	ETHTOOL_MSG_EEE_NTF = 25,
	ETHTOOL_MSG_TSINFO_GET_REPLY = 26,
	ETHTOOL_MSG_CABLE_TEST_NTF = 27,
	ETHTOOL_MSG_CABLE_TEST_TDR_NTF = 28,
	ETHTOOL_MSG_TUNNEL_INFO_GET_REPLY = 29,
	ETHTOOL_MSG_FEC_GET_REPLY = 30,
	ETHTOOL_MSG_FEC_NTF = 31,
	ETHTOOL_MSG_MODULE_EEPROM_GET_REPLY = 32,
	ETHTOOL_MSG_STATS_GET_REPLY = 33,
	ETHTOOL_MSG_PHC_VCLOCKS_GET_REPLY = 34,
	ETHTOOL_MSG_MODULE_GET_REPLY = 35,
	ETHTOOL_MSG_MODULE_NTF = 36,
	ETHTOOL_MSG_PSE_GET_REPLY = 37,
	ETHTOOL_MSG_RSS_GET_REPLY = 38,
	ETHTOOL_MSG_PLCA_GET_CFG_REPLY = 39,
	ETHTOOL_MSG_PLCA_GET_STATUS_REPLY = 40,
	ETHTOOL_MSG_PLCA_NTF = 41,
	ETHTOOL_MSG_MM_GET_REPLY = 42,
	ETHTOOL_MSG_MM_NTF = 43,
	ETHTOOL_MSG_MODULE_FW_FLASH_NTF = 44,
	ETHTOOL_MSG_PHY_GET_REPLY = 45,
	ETHTOOL_MSG_PHY_NTF = 46,
	ETHTOOL_MSG_TSCONFIG_GET_REPLY = 47,
	ETHTOOL_MSG_TSCONFIG_SET_REPLY = 48,
	__ETHTOOL_MSG_KERNEL_CNT = 49,
	ETHTOOL_MSG_KERNEL_MAX = 48,
};

enum {
	ETHTOOL_MSG_USER_NONE = 0,
	ETHTOOL_MSG_STRSET_GET = 1,
	ETHTOOL_MSG_LINKINFO_GET = 2,
	ETHTOOL_MSG_LINKINFO_SET = 3,
	ETHTOOL_MSG_LINKMODES_GET = 4,
	ETHTOOL_MSG_LINKMODES_SET = 5,
	ETHTOOL_MSG_LINKSTATE_GET = 6,
	ETHTOOL_MSG_DEBUG_GET = 7,
	ETHTOOL_MSG_DEBUG_SET = 8,
	ETHTOOL_MSG_WOL_GET = 9,
	ETHTOOL_MSG_WOL_SET = 10,
	ETHTOOL_MSG_FEATURES_GET = 11,
	ETHTOOL_MSG_FEATURES_SET = 12,
	ETHTOOL_MSG_PRIVFLAGS_GET = 13,
	ETHTOOL_MSG_PRIVFLAGS_SET = 14,
	ETHTOOL_MSG_RINGS_GET = 15,
	ETHTOOL_MSG_RINGS_SET = 16,
	ETHTOOL_MSG_CHANNELS_GET = 17,
	ETHTOOL_MSG_CHANNELS_SET = 18,
	ETHTOOL_MSG_COALESCE_GET = 19,
	ETHTOOL_MSG_COALESCE_SET = 20,
	ETHTOOL_MSG_PAUSE_GET = 21,
	ETHTOOL_MSG_PAUSE_SET = 22,
	ETHTOOL_MSG_EEE_GET = 23,
	ETHTOOL_MSG_EEE_SET = 24,
	ETHTOOL_MSG_TSINFO_GET = 25,
	ETHTOOL_MSG_CABLE_TEST_ACT = 26,
	ETHTOOL_MSG_CABLE_TEST_TDR_ACT = 27,
	ETHTOOL_MSG_TUNNEL_INFO_GET = 28,
	ETHTOOL_MSG_FEC_GET = 29,
	ETHTOOL_MSG_FEC_SET = 30,
	ETHTOOL_MSG_MODULE_EEPROM_GET = 31,
	ETHTOOL_MSG_STATS_GET = 32,
	ETHTOOL_MSG_PHC_VCLOCKS_GET = 33,
	ETHTOOL_MSG_MODULE_GET = 34,
	ETHTOOL_MSG_MODULE_SET = 35,
	ETHTOOL_MSG_PSE_GET = 36,
	ETHTOOL_MSG_PSE_SET = 37,
	ETHTOOL_MSG_RSS_GET = 38,
	ETHTOOL_MSG_PLCA_GET_CFG = 39,
	ETHTOOL_MSG_PLCA_SET_CFG = 40,
	ETHTOOL_MSG_PLCA_GET_STATUS = 41,
	ETHTOOL_MSG_MM_GET = 42,
	ETHTOOL_MSG_MM_SET = 43,
	ETHTOOL_MSG_MODULE_FW_FLASH_ACT = 44,
	ETHTOOL_MSG_PHY_GET = 45,
	ETHTOOL_MSG_TSCONFIG_GET = 46,
	ETHTOOL_MSG_TSCONFIG_SET = 47,
	__ETHTOOL_MSG_USER_CNT = 48,
	ETHTOOL_MSG_USER_MAX = 47,
};

enum {
	ETHTOOL_STATS_ETH_PHY = 0,
	ETHTOOL_STATS_ETH_MAC = 1,
	ETHTOOL_STATS_ETH_CTRL = 2,
	ETHTOOL_STATS_RMON = 3,
	ETHTOOL_STATS_PHY = 4,
	__ETHTOOL_STATS_CNT = 5,
};

enum {
	ETHTOOL_STAT_EEE_WAKEUP = 0,
	ETHTOOL_STAT_SKB_ALLOC_ERR = 1,
	ETHTOOL_STAT_REFILL_ERR = 2,
	ETHTOOL_XDP_REDIRECT = 3,
	ETHTOOL_XDP_PASS = 4,
	ETHTOOL_XDP_DROP = 5,
	ETHTOOL_XDP_TX = 6,
	ETHTOOL_XDP_TX_ERR = 7,
	ETHTOOL_XDP_XMIT = 8,
	ETHTOOL_XDP_XMIT_ERR = 9,
	ETHTOOL_MAX_STATS = 10,
};

enum {
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN = 0,
	ETHTOOL_UDP_TUNNEL_TYPE_GENEVE = 1,
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN_GPE = 2,
	__ETHTOOL_UDP_TUNNEL_TYPE_CNT = 3,
	ETHTOOL_UDP_TUNNEL_TYPE_MAX = 2,
};

enum {
	ETHTOOL_XDP_REDIRECT___2 = 0,
	ETHTOOL_XDP_PASS___2 = 1,
	ETHTOOL_XDP_DROP___2 = 2,
	ETHTOOL_XDP_TX___2 = 3,
	ETHTOOL_XDP_TX_ERR___2 = 4,
	ETHTOOL_XDP_XMIT___2 = 5,
	ETHTOOL_XDP_XMIT_ERR___2 = 6,
};

enum {
	ETH_RSS_HASH_TOP_BIT = 0,
	ETH_RSS_HASH_XOR_BIT = 1,
	ETH_RSS_HASH_CRC32_BIT = 2,
	ETH_RSS_HASH_FUNCS_COUNT = 3,
};

enum {
	EVENTFS_SAVE_MODE = 65536,
	EVENTFS_SAVE_UID = 131072,
	EVENTFS_SAVE_GID = 262144,
};

enum {
	EVENT_CMD_COMPLETE = 0,
	EVENT_XFER_COMPLETE = 1,
	EVENT_DATA_COMPLETE = 2,
	EVENT_DATA_ERROR = 3,
};

enum {
	EVENT_FILE_FL_ENABLED = 1,
	EVENT_FILE_FL_RECORDED_CMD = 2,
	EVENT_FILE_FL_RECORDED_TGID = 4,
	EVENT_FILE_FL_FILTERED = 8,
	EVENT_FILE_FL_NO_SET_FILTER = 16,
	EVENT_FILE_FL_SOFT_MODE = 32,
	EVENT_FILE_FL_SOFT_DISABLED = 64,
	EVENT_FILE_FL_TRIGGER_MODE = 128,
	EVENT_FILE_FL_TRIGGER_COND = 256,
	EVENT_FILE_FL_PID_FILTER = 512,
	EVENT_FILE_FL_WAS_ENABLED = 1024,
	EVENT_FILE_FL_FREED = 2048,
};

enum {
	EVENT_FILE_FL_ENABLED_BIT = 0,
	EVENT_FILE_FL_RECORDED_CMD_BIT = 1,
	EVENT_FILE_FL_RECORDED_TGID_BIT = 2,
	EVENT_FILE_FL_FILTERED_BIT = 3,
	EVENT_FILE_FL_NO_SET_FILTER_BIT = 4,
	EVENT_FILE_FL_SOFT_MODE_BIT = 5,
	EVENT_FILE_FL_SOFT_DISABLED_BIT = 6,
	EVENT_FILE_FL_TRIGGER_MODE_BIT = 7,
	EVENT_FILE_FL_TRIGGER_COND_BIT = 8,
	EVENT_FILE_FL_PID_FILTER_BIT = 9,
	EVENT_FILE_FL_WAS_ENABLED_BIT = 10,
	EVENT_FILE_FL_FREED_BIT = 11,
};

enum {
	EVENT_TRIGGER_FL_PROBE = 1,
};

enum {
	EXT4_FC_REASON_XATTR = 0,
	EXT4_FC_REASON_CROSS_RENAME = 1,
	EXT4_FC_REASON_JOURNAL_FLAG_CHANGE = 2,
	EXT4_FC_REASON_NOMEM = 3,
	EXT4_FC_REASON_SWAP_BOOT = 4,
	EXT4_FC_REASON_RESIZE = 5,
	EXT4_FC_REASON_RENAME_DIR = 6,
	EXT4_FC_REASON_FALLOC_RANGE = 7,
	EXT4_FC_REASON_INODE_JOURNAL_DATA = 8,
	EXT4_FC_REASON_ENCRYPTED_FILENAME = 9,
	EXT4_FC_REASON_MAX = 10,
};

enum {
	EXT4_FC_STATUS_OK = 0,
	EXT4_FC_STATUS_INELIGIBLE = 1,
	EXT4_FC_STATUS_SKIPPED = 2,
	EXT4_FC_STATUS_FAILED = 3,
};

enum {
	EXT4_FLAGS_RESIZING = 0,
	EXT4_FLAGS_SHUTDOWN = 1,
	EXT4_FLAGS_BDEV_IS_DAX = 2,
	EXT4_FLAGS_EMERGENCY_RO = 3,
};

enum {
	EXT4_INODE_SECRM = 0,
	EXT4_INODE_UNRM = 1,
	EXT4_INODE_COMPR = 2,
	EXT4_INODE_SYNC = 3,
	EXT4_INODE_IMMUTABLE = 4,
	EXT4_INODE_APPEND = 5,
	EXT4_INODE_NODUMP = 6,
	EXT4_INODE_NOATIME = 7,
	EXT4_INODE_DIRTY = 8,
	EXT4_INODE_COMPRBLK = 9,
	EXT4_INODE_NOCOMPR = 10,
	EXT4_INODE_ENCRYPT = 11,
	EXT4_INODE_INDEX = 12,
	EXT4_INODE_IMAGIC = 13,
	EXT4_INODE_JOURNAL_DATA = 14,
	EXT4_INODE_NOTAIL = 15,
	EXT4_INODE_DIRSYNC = 16,
	EXT4_INODE_TOPDIR = 17,
	EXT4_INODE_HUGE_FILE = 18,
	EXT4_INODE_EXTENTS = 19,
	EXT4_INODE_VERITY = 20,
	EXT4_INODE_EA_INODE = 21,
	EXT4_INODE_DAX = 25,
	EXT4_INODE_INLINE_DATA = 28,
	EXT4_INODE_PROJINHERIT = 29,
	EXT4_INODE_CASEFOLD = 30,
	EXT4_INODE_RESERVED = 31,
};

enum {
	EXT4_MF_MNTDIR_SAMPLED = 0,
	EXT4_MF_FC_INELIGIBLE = 1,
	EXT4_MF_JOURNAL_DESTROY = 2,
};

enum {
	EXT4_STATE_NEW = 0,
	EXT4_STATE_XATTR = 1,
	EXT4_STATE_NO_EXPAND = 2,
	EXT4_STATE_DA_ALLOC_CLOSE = 3,
	EXT4_STATE_EXT_MIGRATE = 4,
	EXT4_STATE_NEWENTRY = 5,
	EXT4_STATE_MAY_INLINE_DATA = 6,
	EXT4_STATE_EXT_PRECACHED = 7,
	EXT4_STATE_LUSTRE_EA_INODE = 8,
	EXT4_STATE_VERITY_IN_PROGRESS = 9,
	EXT4_STATE_FC_COMMITTING = 10,
	EXT4_STATE_FC_FLUSHING_DATA = 11,
	EXT4_STATE_ORPHAN_FILE = 12,
};

enum {
	FAN53526_CHIP_ID_01 = 1,
};

enum {
	FAN53526_CHIP_REV_08 = 8,
};

enum {
	FAN53555_CHIP_ID_00 = 0,
	FAN53555_CHIP_ID_01 = 1,
	FAN53555_CHIP_ID_02 = 2,
	FAN53555_CHIP_ID_03 = 3,
	FAN53555_CHIP_ID_04 = 4,
	FAN53555_CHIP_ID_05 = 5,
	FAN53555_CHIP_ID_08 = 8,
};

enum {
	FAN53555_CHIP_REV_00 = 3,
	FAN53555_CHIP_REV_13 = 15,
};

enum {
	FAN53555_VSEL_ID_0 = 0,
	FAN53555_VSEL_ID_1 = 1,
};

enum {
	FAN_EVENT_INIT = 0,
	FAN_EVENT_REPORTED = 1,
	FAN_EVENT_ANSWERED = 2,
	FAN_EVENT_CANCELED = 3,
};

enum {
	FATTR4_CLONE_BLKSIZE = 77,
	FATTR4_SPACE_FREED = 78,
	FATTR4_CHANGE_ATTR_TYPE = 79,
	FATTR4_SEC_LABEL = 80,
};

enum {
	FATTR4_DIR_NOTIF_DELAY = 56,
	FATTR4_DIRENT_NOTIF_DELAY = 57,
	FATTR4_DACL = 58,
	FATTR4_SACL = 59,
	FATTR4_CHANGE_POLICY = 60,
	FATTR4_FS_STATUS = 61,
	FATTR4_FS_LAYOUT_TYPES = 62,
	FATTR4_LAYOUT_HINT = 63,
	FATTR4_LAYOUT_TYPES = 64,
	FATTR4_LAYOUT_BLKSIZE = 65,
	FATTR4_LAYOUT_ALIGNMENT = 66,
	FATTR4_FS_LOCATIONS_INFO = 67,
	FATTR4_MDSTHRESHOLD = 68,
	FATTR4_RETENTION_GET = 69,
	FATTR4_RETENTION_SET = 70,
	FATTR4_RETENTEVT_GET = 71,
	FATTR4_RETENTEVT_SET = 72,
	FATTR4_RETENTION_HOLD = 73,
	FATTR4_MODE_SET_MASKED = 74,
	FATTR4_SUPPATTR_EXCLCREAT = 75,
	FATTR4_FS_CHARSET_CAP = 76,
};

enum {
	FATTR4_MODE_UMASK = 81,
};

enum {
	FATTR4_OPEN_ARGUMENTS = 86,
};

enum {
	FATTR4_SUPPORTED_ATTRS = 0,
	FATTR4_TYPE = 1,
	FATTR4_FH_EXPIRE_TYPE = 2,
	FATTR4_CHANGE = 3,
	FATTR4_SIZE = 4,
	FATTR4_LINK_SUPPORT = 5,
	FATTR4_SYMLINK_SUPPORT = 6,
	FATTR4_NAMED_ATTR = 7,
	FATTR4_FSID = 8,
	FATTR4_UNIQUE_HANDLES = 9,
	FATTR4_LEASE_TIME = 10,
	FATTR4_RDATTR_ERROR = 11,
	FATTR4_ACL = 12,
	FATTR4_ACLSUPPORT = 13,
	FATTR4_ARCHIVE = 14,
	FATTR4_CANSETTIME = 15,
	FATTR4_CASE_INSENSITIVE = 16,
	FATTR4_CASE_PRESERVING = 17,
	FATTR4_CHOWN_RESTRICTED = 18,
	FATTR4_FILEHANDLE = 19,
	FATTR4_FILEID = 20,
	FATTR4_FILES_AVAIL = 21,
	FATTR4_FILES_FREE = 22,
	FATTR4_FILES_TOTAL = 23,
	FATTR4_FS_LOCATIONS = 24,
	FATTR4_HIDDEN = 25,
	FATTR4_HOMOGENEOUS = 26,
	FATTR4_MAXFILESIZE = 27,
	FATTR4_MAXLINK = 28,
	FATTR4_MAXNAME = 29,
	FATTR4_MAXREAD = 30,
	FATTR4_MAXWRITE = 31,
	FATTR4_MIMETYPE = 32,
	FATTR4_MODE = 33,
	FATTR4_NO_TRUNC = 34,
	FATTR4_NUMLINKS = 35,
	FATTR4_OWNER = 36,
	FATTR4_OWNER_GROUP = 37,
	FATTR4_QUOTA_AVAIL_HARD = 38,
	FATTR4_QUOTA_AVAIL_SOFT = 39,
	FATTR4_QUOTA_USED = 40,
	FATTR4_RAWDEV = 41,
	FATTR4_SPACE_AVAIL = 42,
	FATTR4_SPACE_FREE = 43,
	FATTR4_SPACE_TOTAL = 44,
	FATTR4_SPACE_USED = 45,
	FATTR4_SYSTEM = 46,
	FATTR4_TIME_ACCESS = 47,
	FATTR4_TIME_ACCESS_SET = 48,
	FATTR4_TIME_BACKUP = 49,
	FATTR4_TIME_CREATE = 50,
	FATTR4_TIME_DELTA = 51,
	FATTR4_TIME_METADATA = 52,
	FATTR4_TIME_MODIFY = 53,
	FATTR4_TIME_MODIFY_SET = 54,
	FATTR4_MOUNTED_ON_FILEID = 55,
};

enum {
	FATTR4_TIME_DELEG_ACCESS = 84,
};

enum {
	FATTR4_TIME_DELEG_MODIFY = 85,
};

enum {
	FATTR4_XATTR_SUPPORT = 82,
};

enum {
	FBCON_LOGO_CANSHOW = -1,
	FBCON_LOGO_DRAW = -2,
	FBCON_LOGO_DONTSHOW = -3,
};

enum {
	FB_BLANK_UNBLANK = 0,
	FB_BLANK_NORMAL = 1,
	FB_BLANK_VSYNC_SUSPEND = 2,
	FB_BLANK_HSYNC_SUSPEND = 3,
	FB_BLANK_POWERDOWN = 4,
};

enum {
	FILEID_HIGH_OFF = 0,
	FILEID_LOW_OFF = 1,
	FILE_I_TYPE_OFF = 2,
	EMBED_FH_OFF = 3,
};

enum {
	FILTER_OTHER = 0,
	FILTER_STATIC_STRING = 1,
	FILTER_DYN_STRING = 2,
	FILTER_RDYN_STRING = 3,
	FILTER_PTR_STRING = 4,
	FILTER_TRACE_FN = 5,
	FILTER_CPUMASK = 6,
	FILTER_COMM = 7,
	FILTER_CPU = 8,
	FILTER_STACKTRACE = 9,
};

enum {
	FILT_ERR_NONE = 0,
	FILT_ERR_INVALID_OP = 1,
	FILT_ERR_TOO_MANY_OPEN = 2,
	FILT_ERR_TOO_MANY_CLOSE = 3,
	FILT_ERR_MISSING_QUOTE = 4,
	FILT_ERR_MISSING_BRACE_OPEN = 5,
	FILT_ERR_MISSING_BRACE_CLOSE = 6,
	FILT_ERR_OPERAND_TOO_LONG = 7,
	FILT_ERR_EXPECT_STRING = 8,
	FILT_ERR_EXPECT_DIGIT = 9,
	FILT_ERR_ILLEGAL_FIELD_OP = 10,
	FILT_ERR_FIELD_NOT_FOUND = 11,
	FILT_ERR_ILLEGAL_INTVAL = 12,
	FILT_ERR_BAD_SUBSYS_FILTER = 13,
	FILT_ERR_TOO_MANY_PREDS = 14,
	FILT_ERR_INVALID_FILTER = 15,
	FILT_ERR_INVALID_CPULIST = 16,
	FILT_ERR_IP_FIELD_ONLY = 17,
	FILT_ERR_INVALID_VALUE = 18,
	FILT_ERR_NO_FUNCTION = 19,
	FILT_ERR_ERRNO = 20,
	FILT_ERR_NO_FILTER = 21,
};

enum {
	FOLL_TOUCH = 65536,
	FOLL_TRIED = 131072,
	FOLL_REMOTE = 262144,
	FOLL_PIN = 524288,
	FOLL_FAST_ONLY = 1048576,
	FOLL_UNLOCKABLE = 2097152,
	FOLL_MADV_POPULATE = 4194304,
};

enum {
	FOLL_WRITE = 1,
	FOLL_GET = 2,
	FOLL_DUMP = 4,
	FOLL_FORCE = 8,
	FOLL_NOWAIT = 16,
	FOLL_NOFAULT = 32,
	FOLL_HWPOISON = 64,
	FOLL_ANON = 128,
	FOLL_LONGTERM = 256,
	FOLL_SPLIT_PMD = 512,
	FOLL_PCI_P2PDMA = 1024,
	FOLL_INTERRUPTIBLE = 2048,
	FOLL_HONOR_NUMA_FAULT = 4096,
};

enum {
	FORMAT_HEADER = 1,
	FORMAT_FIELD_SEPERATOR = 2,
	FORMAT_PRINTFMT = 3,
};

enum {
	FUTEX_STATE_OK = 0,
	FUTEX_STATE_EXITING = 1,
	FUTEX_STATE_DEAD = 2,
};

enum {
	F_TX_CHK_AUTO_OFF = -2147483648,
	F_TX_CHK_AUTO_ON = 1073741824,
	F_M_RX_RAM_DIS = 16777216,
};

enum {
	GENHD_FL_REMOVABLE = 1,
	GENHD_FL_HIDDEN = 2,
	GENHD_FL_NO_PART = 4,
};

enum {
	GHES_SEV_NO = 0,
	GHES_SEV_CORRECTED = 1,
	GHES_SEV_RECOVERABLE = 2,
	GHES_SEV_PANIC = 3,
};

enum {
	GLB_GPIO_CLK_DEB_ENA = -2147483648,
	GLB_GPIO_CLK_DBG_MSK = 1006632960,
	GLB_GPIO_INT_RST_D3_DIS = 32768,
	GLB_GPIO_LED_PAD_SPEED_UP = 16384,
	GLB_GPIO_STAT_RACE_DIS = 8192,
	GLB_GPIO_TEST_SEL_MSK = 6144,
	GLB_GPIO_TEST_SEL_BASE = 2048,
	GLB_GPIO_RAND_ENA = 1024,
	GLB_GPIO_RAND_BIT_1 = 512,
};

enum {
	GMAC_CTRL = 3840,
	GPHY_CTRL = 3844,
	GMAC_IRQ_SRC = 3848,
	GMAC_IRQ_MSK = 3852,
	GMAC_LINK_CTRL = 3856,
	WOL_CTRL_STAT = 3872,
	WOL_MATCH_CTL = 3874,
	WOL_MATCH_RES = 3875,
	WOL_MAC_ADDR = 3876,
	WOL_PATT_RPTR = 3884,
	WOL_PATT_LEN_LO = 3888,
	WOL_PATT_LEN_HI = 3892,
	WOL_PATT_CNT_0 = 3896,
	WOL_PATT_CNT_4 = 3900,
};

enum {
	GMAC_TI_ST_VAL = 3604,
	GMAC_TI_ST_CTRL = 3608,
	GMAC_TI_ST_TST = 3610,
};

enum {
	GMC_SET_RST = 32768,
	GMC_SEC_RST_OFF = 16384,
	GMC_BYP_MACSECRX_ON = 8192,
	GMC_BYP_MACSECRX_OFF = 4096,
	GMC_BYP_MACSECTX_ON = 2048,
	GMC_BYP_MACSECTX_OFF = 1024,
	GMC_BYP_RETR_ON = 512,
	GMC_BYP_RETR_OFF = 256,
	GMC_H_BURST_ON = 128,
	GMC_H_BURST_OFF = 64,
	GMC_F_LOOPB_ON = 32,
	GMC_F_LOOPB_OFF = 16,
	GMC_PAUSE_ON = 8,
	GMC_PAUSE_OFF = 4,
	GMC_RST_CLR = 2,
	GMC_RST_SET = 1,
};

enum {
	GMLC_RST_CLR = 2,
	GMLC_RST_SET = 1,
};

enum {
	GMR_FS_LEN = 2147418112,
	GMR_FS_VLAN = 8192,
	GMR_FS_JABBER = 4096,
	GMR_FS_UN_SIZE = 2048,
	GMR_FS_MC = 1024,
	GMR_FS_BC = 512,
	GMR_FS_RX_OK = 256,
	GMR_FS_GOOD_FC = 128,
	GMR_FS_BAD_FC = 64,
	GMR_FS_MII_ERR = 32,
	GMR_FS_LONG_ERR = 16,
	GMR_FS_FRAGMENT = 8,
	GMR_FS_CRC_ERR = 2,
	GMR_FS_RX_FF_OV = 1,
	GMR_FS_ANY_ERR = 6267,
};

enum {
	GMT_ST_START = 4,
	GMT_ST_STOP = 2,
	GMT_ST_CLR_IRQ = 1,
};

enum {
	GM_GPCR_PROM_ENA = 16384,
	GM_GPCR_FC_TX_DIS = 8192,
	GM_GPCR_TX_ENA = 4096,
	GM_GPCR_RX_ENA = 2048,
	GM_GPCR_BURST_ENA = 1024,
	GM_GPCR_LOOP_ENA = 512,
	GM_GPCR_PART_ENA = 256,
	GM_GPCR_GIGS_ENA = 128,
	GM_GPCR_FL_PASS = 64,
	GM_GPCR_DUP_FULL = 32,
	GM_GPCR_FC_RX_DIS = 16,
	GM_GPCR_SPEED_100 = 8,
	GM_GPCR_AU_DUP_DIS = 4,
	GM_GPCR_AU_FCT_DIS = 2,
	GM_GPCR_AU_SPD_DIS = 1,
};

enum {
	GM_GP_STAT = 0,
	GM_GP_CTRL = 4,
	GM_TX_CTRL = 8,
	GM_RX_CTRL = 12,
	GM_TX_FLOW_CTRL = 16,
	GM_TX_PARAM = 20,
	GM_SERIAL_MODE = 24,
	GM_SRC_ADDR_1L = 28,
	GM_SRC_ADDR_1M = 32,
	GM_SRC_ADDR_1H = 36,
	GM_SRC_ADDR_2L = 40,
	GM_SRC_ADDR_2M = 44,
	GM_SRC_ADDR_2H = 48,
	GM_MC_ADDR_H1 = 52,
	GM_MC_ADDR_H2 = 56,
	GM_MC_ADDR_H3 = 60,
	GM_MC_ADDR_H4 = 64,
	GM_TX_IRQ_SRC = 68,
	GM_RX_IRQ_SRC = 72,
	GM_TR_IRQ_SRC = 76,
	GM_TX_IRQ_MSK = 80,
	GM_RX_IRQ_MSK = 84,
	GM_TR_IRQ_MSK = 88,
	GM_SMI_CTRL = 128,
	GM_SMI_DATA = 132,
	GM_PHY_ADDR = 136,
	GM_MIB_CNT_BASE = 256,
	GM_MIB_CNT_END = 604,
};

enum {
	GM_IS_TX_CO_OV = 32,
	GM_IS_RX_CO_OV = 16,
	GM_IS_TX_FF_UR = 8,
	GM_IS_TX_COMPL = 4,
	GM_IS_RX_FF_OR = 2,
	GM_IS_RX_COMPL = 1,
};

enum {
	GM_PAR_MIB_CLR = 32,
	GM_PAR_MIB_TST = 16,
};

enum {
	GM_RXCR_UCF_ENA = 32768,
	GM_RXCR_MCF_ENA = 16384,
	GM_RXCR_CRC_DIS = 8192,
	GM_RXCR_PASS_FC = 4096,
};

enum {
	GM_RXF_UC_OK = 256,
	GM_RXF_BC_OK = 264,
	GM_RXF_MPAUSE = 272,
	GM_RXF_MC_OK = 280,
	GM_RXF_FCS_ERR = 288,
	GM_RXO_OK_LO = 304,
	GM_RXO_OK_HI = 312,
	GM_RXO_ERR_LO = 320,
	GM_RXO_ERR_HI = 328,
	GM_RXF_SHT = 336,
	GM_RXE_FRAG = 344,
	GM_RXF_64B = 352,
	GM_RXF_127B = 360,
	GM_RXF_255B = 368,
	GM_RXF_511B = 376,
	GM_RXF_1023B = 384,
	GM_RXF_1518B = 392,
	GM_RXF_MAX_SZ = 400,
	GM_RXF_LNG_ERR = 408,
	GM_RXF_JAB_PKT = 416,
	GM_RXE_FIFO_OV = 432,
	GM_TXF_UC_OK = 448,
	GM_TXF_BC_OK = 456,
	GM_TXF_MPAUSE = 464,
	GM_TXF_MC_OK = 472,
	GM_TXO_OK_LO = 480,
	GM_TXO_OK_HI = 488,
	GM_TXF_64B = 496,
	GM_TXF_127B = 504,
	GM_TXF_255B = 512,
	GM_TXF_511B = 520,
	GM_TXF_1023B = 528,
	GM_TXF_1518B = 536,
	GM_TXF_MAX_SZ = 544,
	GM_TXF_COL = 560,
	GM_TXF_LAT_COL = 568,
	GM_TXF_ABO_COL = 576,
	GM_TXF_MUL_COL = 584,
	GM_TXF_SNG_COL = 592,
	GM_TXE_FIFO_UR = 600,
};

enum {
	GM_SMI_CT_PHY_A_MSK = 63488,
	GM_SMI_CT_REG_A_MSK = 1984,
	GM_SMI_CT_OP_RD = 32,
	GM_SMI_CT_RD_VAL = 16,
	GM_SMI_CT_BUSY = 8,
};

enum {
	GM_SMOD_DATABL_MSK = 63488,
	GM_SMOD_LIMIT_4 = 1024,
	GM_SMOD_VLAN_ENA = 512,
	GM_SMOD_JUMBO_ENA = 256,
	GM_NEW_FLOW_CTRL = 64,
	GM_SMOD_IPG_MSK = 31,
};

enum {
	GM_TXCR_FORCE_JAM = 32768,
	GM_TXCR_CRC_DIS = 16384,
	GM_TXCR_PAD_DIS = 8192,
	GM_TXCR_COL_THR_MSK = 7168,
};

enum {
	GM_TXPA_JAMLEN_MSK = 49152,
	GM_TXPA_JAMIPG_MSK = 15872,
	GM_TXPA_JAMDAT_MSK = 496,
	GM_TXPA_BO_LIM_MSK = 15,
	TX_JAM_LEN_DEF = 3,
	TX_JAM_IPG_DEF = 11,
	TX_IPG_JAM_DEF = 28,
	TX_BOF_LIM_DEF = 4,
};

enum {
	GPC_TX_PAUSE = 1073741824,
	GPC_RX_PAUSE = 536870912,
	GPC_SPEED = 402653184,
	GPC_LINK = 67108864,
	GPC_DUPLEX = 33554432,
	GPC_CLOCK = 16777216,
	GPC_PDOWN = 8388608,
	GPC_TSTMODE = 4194304,
	GPC_REG18 = 2097152,
	GPC_REG12SEL = 1572864,
	GPC_REG18SEL = 393216,
	GPC_SPILOCK = 65536,
	GPC_LEDMUX = 49152,
	GPC_INTPOL = 8192,
	GPC_DETECT = 4096,
	GPC_1000HD = 2048,
	GPC_SLAVE = 1024,
	GPC_PAUSE = 512,
	GPC_LEDCTL = 192,
	GPC_RST_CLR = 2,
	GPC_RST_SET = 1,
};

enum {
	GPIO_BASE = 0,
	IOCFG_RT_BASE = 1,
	IOCFG_RB_BASE = 2,
	IOCFG_LT_BASE = 3,
	IOCFG_LB_BASE = 4,
	IOCFG_TR_BASE = 5,
	IOCFG_TL_BASE = 6,
};

enum {
	GP_IDLE = 0,
	GP_ENTER = 1,
	GP_PASSED = 2,
	GP_EXIT = 3,
	GP_REPLAY = 4,
};

enum {
	GP_LAST = 174,
	PIN_DCUTCK_LPDCLK = 175,
	PIN_DCUTDI_LPDI = 176,
	PIN_DCUTMS = 177,
	PIN_DCUTRST_N = 178,
	PIN_DU_DOTCLKIN = 179,
	PIN_EXTALR = 180,
	PIN_FSCLKST = 181,
	PIN_FSCLKST_N = 182,
	PIN_PRESETOUT_N = 183,
	PIN_VDDQ_AVB = 184,
	PIN_VDDQ_GE = 185,
};

enum {
	GP_LAST___2 = 209,
	PIN_ASEBRK = 210,
	PIN_AVB_MDC = 211,
	PIN_AVB_MDIO = 212,
	PIN_AVB_TD0 = 213,
	PIN_AVB_TD1 = 214,
	PIN_AVB_TD2 = 215,
	PIN_AVB_TD3 = 216,
	PIN_AVB_TXC = 217,
	PIN_AVB_TX_CTL = 218,
	PIN_FSCLKST_N___2 = 219,
	PIN_MLB_REF = 220,
	PIN_PRESETOUT_N___2 = 221,
	PIN_TCK = 222,
	PIN_TDI = 223,
	PIN_TMS = 224,
	PIN_TRST_N = 225,
	PIN_VDDQ_AVB0 = 226,
};

enum {
	GP_LAST___3 = 227,
	PIN_ASEBRK___2 = 228,
	PIN_AVB_MDIO___2 = 229,
	PIN_AVB_RD0 = 230,
	PIN_AVB_RD1 = 231,
	PIN_AVB_RD2 = 232,
	PIN_AVB_RD3 = 233,
	PIN_AVB_RXC = 234,
	PIN_AVB_RX_CTL = 235,
	PIN_AVB_TD0___2 = 236,
	PIN_AVB_TD1___2 = 237,
	PIN_AVB_TD2___2 = 238,
	PIN_AVB_TD3___2 = 239,
	PIN_AVB_TXC___2 = 240,
	PIN_AVB_TXCREFCLK = 241,
	PIN_AVB_TX_CTL___2 = 242,
	PIN_DU_DOTCLKIN0 = 243,
	PIN_DU_DOTCLKIN1 = 244,
	PIN_DU_DOTCLKIN2 = 245,
	PIN_EXTALR___2 = 246,
	PIN_FSCLKST___2 = 247,
	PIN_MLB_REF___2 = 248,
	PIN_PRESETOUT_N___3 = 249,
	PIN_QSPI0_IO2 = 250,
	PIN_QSPI0_IO3 = 251,
	PIN_QSPI0_MISO_IO1 = 252,
	PIN_QSPI0_MOSI_IO0 = 253,
	PIN_QSPI0_SPCLK = 254,
	PIN_QSPI0_SSL = 255,
	PIN_QSPI1_IO2 = 256,
	PIN_QSPI1_IO3 = 257,
	PIN_QSPI1_MISO_IO1 = 258,
	PIN_QSPI1_MOSI_IO0 = 259,
	PIN_QSPI1_SPCLK = 260,
	PIN_QSPI1_SSL = 261,
	PIN_PRESET_N = 262,
	PIN_RPC_INT_N = 263,
	PIN_RPC_RESET_N = 264,
	PIN_RPC_WP_N = 265,
	PIN_TCK___2 = 266,
	PIN_TDI___2 = 267,
	PIN_TDO = 268,
	PIN_TMS___2 = 269,
	PIN_TRST_N___2 = 270,
};

enum {
	GP_LAST___4 = 244,
	PIN_VDDQ_AVB0___2 = 245,
	PIN_VDDQ_AVB1 = 246,
	PIN_VDDQ_AVB2 = 247,
};

enum {
	GP_LAST___5 = 227,
	PIN_ASEBRK___3 = 228,
	PIN_AVB_MDIO___3 = 229,
	PIN_AVB_RD0___2 = 230,
	PIN_AVB_RD1___2 = 231,
	PIN_AVB_RD2___2 = 232,
	PIN_AVB_RD3___2 = 233,
	PIN_AVB_RXC___2 = 234,
	PIN_AVB_RX_CTL___2 = 235,
	PIN_AVB_TD0___3 = 236,
	PIN_AVB_TD1___3 = 237,
	PIN_AVB_TD2___3 = 238,
	PIN_AVB_TD3___3 = 239,
	PIN_AVB_TXC___3 = 240,
	PIN_AVB_TXCREFCLK___2 = 241,
	PIN_AVB_TX_CTL___3 = 242,
	PIN_DU_DOTCLKIN0___2 = 243,
	PIN_DU_DOTCLKIN1___2 = 244,
	PIN_DU_DOTCLKIN2___2 = 245,
	PIN_DU_DOTCLKIN3 = 246,
	PIN_EXTALR___3 = 247,
	PIN_FSCLKST_N___3 = 248,
	PIN_MLB_REF___3 = 249,
	PIN_PRESETOUT_N___4 = 250,
	PIN_QSPI0_IO2___2 = 251,
	PIN_QSPI0_IO3___2 = 252,
	PIN_QSPI0_MISO_IO1___2 = 253,
	PIN_QSPI0_MOSI_IO0___2 = 254,
	PIN_QSPI0_SPCLK___2 = 255,
	PIN_QSPI0_SSL___2 = 256,
	PIN_QSPI1_IO2___2 = 257,
	PIN_QSPI1_IO3___2 = 258,
	PIN_QSPI1_MISO_IO1___2 = 259,
	PIN_QSPI1_MOSI_IO0___2 = 260,
	PIN_QSPI1_SPCLK___2 = 261,
	PIN_QSPI1_SSL___2 = 262,
	PIN_RPC_INT_N___2 = 263,
	PIN_RPC_RESET_N___2 = 264,
	PIN_RPC_WP_N___2 = 265,
	PIN_TCK___3 = 266,
	PIN_TDI___3 = 267,
	PIN_TDO___2 = 268,
	PIN_TMS___3 = 269,
	PIN_TRST_N___3 = 270,
};

enum {
	GP_LAST___6 = 269,
	PIN_VDDQ_AVB0___3 = 270,
	PIN_VDDQ_AVB1___2 = 271,
	PIN_VDDQ_AVB2___2 = 272,
	PIN_VDDQ_TSN0 = 273,
};

enum {
	GP_LAST___7 = 227,
	PIN_ASEBRK___4 = 228,
	PIN_AVB_MDIO___4 = 229,
	PIN_AVB_RD0___3 = 230,
	PIN_AVB_RD1___3 = 231,
	PIN_AVB_RD2___3 = 232,
	PIN_AVB_RD3___3 = 233,
	PIN_AVB_RXC___3 = 234,
	PIN_AVB_RX_CTL___3 = 235,
	PIN_AVB_TD0___4 = 236,
	PIN_AVB_TD1___4 = 237,
	PIN_AVB_TD2___4 = 238,
	PIN_AVB_TD3___4 = 239,
	PIN_AVB_TXC___4 = 240,
	PIN_AVB_TXCREFCLK___3 = 241,
	PIN_AVB_TX_CTL___4 = 242,
	PIN_DU_DOTCLKIN0___3 = 243,
	PIN_DU_DOTCLKIN1___3 = 244,
	PIN_DU_DOTCLKIN3___2 = 245,
	PIN_EXTALR___4 = 246,
	PIN_FSCLKST___3 = 247,
	PIN_MLB_REF___4 = 248,
	PIN_PRESETOUT_N___5 = 249,
	PIN_QSPI0_IO2___3 = 250,
	PIN_QSPI0_IO3___3 = 251,
	PIN_QSPI0_MISO_IO1___3 = 252,
	PIN_QSPI0_MOSI_IO0___3 = 253,
	PIN_QSPI0_SPCLK___3 = 254,
	PIN_QSPI0_SSL___3 = 255,
	PIN_QSPI1_IO2___3 = 256,
	PIN_QSPI1_IO3___3 = 257,
	PIN_QSPI1_MISO_IO1___3 = 258,
	PIN_QSPI1_MOSI_IO0___3 = 259,
	PIN_QSPI1_SPCLK___3 = 260,
	PIN_QSPI1_SSL___3 = 261,
	PIN_RPC_INT_N___3 = 262,
	PIN_RPC_RESET_N___3 = 263,
	PIN_RPC_WP_N___3 = 264,
	PIN_TCK___4 = 265,
	PIN_TDI___4 = 266,
	PIN_TDO___3 = 267,
	PIN_TMS___4 = 268,
	PIN_TRST_N___4 = 269,
};

enum {
	GP_LAST___8 = 205,
	PIN_DU_DOTCLKIN0___4 = 206,
	PIN_FSCLKST_N___4 = 207,
	PIN_MLB_REF___5 = 208,
	PIN_PRESETOUT_N___6 = 209,
	PIN_TCK___5 = 210,
	PIN_TDI___5 = 211,
	PIN_TMS___5 = 212,
	PIN_TRST_N___5 = 213,
	PIN_VDDQ_AVB0___4 = 214,
};

enum {
	GP_LAST___9 = 174,
	PIN_DU_DOTCLKIN___2 = 175,
	PIN_EXTALR___5 = 176,
	PIN_FSCLKST_N___5 = 177,
	PIN_PRESETOUT_N___7 = 178,
	PIN_TCK___6 = 179,
	PIN_TDI___6 = 180,
	PIN_TMS___6 = 181,
	PIN_TRST_N___6 = 182,
	PIN_VDDQ_AVB0___5 = 183,
};

enum {
	GSSX_NULL = 0,
	GSSX_INDICATE_MECHS = 1,
	GSSX_GET_CALL_CONTEXT = 2,
	GSSX_IMPORT_AND_CANON_NAME = 3,
	GSSX_EXPORT_CRED = 4,
	GSSX_IMPORT_CRED = 5,
	GSSX_ACQUIRE_CRED = 6,
	GSSX_STORE_CRED = 7,
	GSSX_INIT_SEC_CONTEXT = 8,
	GSSX_ACCEPT_SEC_CONTEXT = 9,
	GSSX_RELEASE_HANDLE = 10,
	GSSX_GET_MIC = 11,
	GSSX_VERIFY = 12,
	GSSX_WRAP = 13,
	GSSX_UNWRAP = 14,
	GSSX_WRAP_SIZE_LIMIT = 15,
};

enum {
	HANDSHAKE_A_ACCEPT_SOCKFD = 1,
	HANDSHAKE_A_ACCEPT_HANDLER_CLASS = 2,
	HANDSHAKE_A_ACCEPT_MESSAGE_TYPE = 3,
	HANDSHAKE_A_ACCEPT_TIMEOUT = 4,
	HANDSHAKE_A_ACCEPT_AUTH_MODE = 5,
	HANDSHAKE_A_ACCEPT_PEER_IDENTITY = 6,
	HANDSHAKE_A_ACCEPT_CERTIFICATE = 7,
	HANDSHAKE_A_ACCEPT_PEERNAME = 8,
	__HANDSHAKE_A_ACCEPT_MAX = 9,
	HANDSHAKE_A_ACCEPT_MAX = 8,
};

enum {
	HANDSHAKE_A_DONE_STATUS = 1,
	HANDSHAKE_A_DONE_SOCKFD = 2,
	HANDSHAKE_A_DONE_REMOTE_AUTH = 3,
	__HANDSHAKE_A_DONE_MAX = 4,
	HANDSHAKE_A_DONE_MAX = 3,
};

enum {
	HANDSHAKE_A_X509_CERT = 1,
	HANDSHAKE_A_X509_PRIVKEY = 2,
	__HANDSHAKE_A_X509_MAX = 3,
	HANDSHAKE_A_X509_MAX = 2,
};

enum {
	HANDSHAKE_CMD_READY = 1,
	HANDSHAKE_CMD_ACCEPT = 2,
	HANDSHAKE_CMD_DONE = 3,
	__HANDSHAKE_CMD_MAX = 4,
	HANDSHAKE_CMD_MAX = 3,
};

enum {
	HANDSHAKE_NLGRP_NONE = 0,
	HANDSHAKE_NLGRP_TLSHD = 1,
};

enum {
	HASH_SIZE = 128,
};

enum {
	HASH_TCP_IPV6_EX_CTRL = 32,
	HASH_IPV6_EX_CTRL = 16,
	HASH_TCP_IPV6_CTRL = 8,
	HASH_IPV6_CTRL = 4,
	HASH_TCP_IPV4_CTRL = 2,
	HASH_IPV4_CTRL = 1,
	HASH_ALL = 63,
};

enum {
	HAS_READ = 1,
	HAS_WRITE = 2,
	HAS_LSEEK = 4,
	HAS_POLL = 8,
	HAS_IOCTL = 16,
};

enum {
	HCU_CCSR_SMBALERT_MONITOR = 134217728,
	HCU_CCSR_CPU_SLEEP = 67108864,
	HCU_CCSR_CS_TO = 33554432,
	HCU_CCSR_WDOG = 16777216,
	HCU_CCSR_CLR_IRQ_HOST = 131072,
	HCU_CCSR_SET_IRQ_HCU = 65536,
	HCU_CCSR_AHB_RST = 512,
	HCU_CCSR_CPU_RST_MODE = 256,
	HCU_CCSR_SET_SYNC_CPU = 32,
	HCU_CCSR_CPU_CLK_DIVIDE_MSK = 24,
	HCU_CCSR_CPU_CLK_DIVIDE_BASE = 8,
	HCU_CCSR_OS_PRSNT = 4,
	HCU_CCSR_UC_STATE_MSK = 3,
	HCU_CCSR_UC_STATE_BASE = 1,
	HCU_CCSR_ASF_RESET = 0,
	HCU_CCSR_ASF_HALTED = 2,
	HCU_CCSR_ASF_RUNNING = 1,
};

enum {
	HIBERNATION_INVALID = 0,
	HIBERNATION_PLATFORM = 1,
	HIBERNATION_SHUTDOWN = 2,
	HIBERNATION_REBOOT = 3,
	HIBERNATION_SUSPEND = 4,
	HIBERNATION_TEST_RESUME = 5,
	__HIBERNATION_AFTER_LAST = 6,
};

enum {
	HISI_SAS_BIST_CODE_MODE_PRBS7 = 0,
	HISI_SAS_BIST_CODE_MODE_PRBS23 = 1,
	HISI_SAS_BIST_CODE_MODE_PRBS31 = 2,
	HISI_SAS_BIST_CODE_MODE_JTPAT = 3,
	HISI_SAS_BIST_CODE_MODE_CJTPAT = 4,
	HISI_SAS_BIST_CODE_MODE_SCRAMBED_0 = 5,
	HISI_SAS_BIST_CODE_MODE_TRAIN = 6,
	HISI_SAS_BIST_CODE_MODE_TRAIN_DONE = 7,
	HISI_SAS_BIST_CODE_MODE_HFTP = 8,
	HISI_SAS_BIST_CODE_MODE_MFTP = 9,
	HISI_SAS_BIST_CODE_MODE_LFTP = 10,
	HISI_SAS_BIST_CODE_MODE_FIXED_DATA = 11,
};

enum {
	HISI_SAS_BIST_LOOPBACK_MODE_DIGITAL = 0,
	HISI_SAS_BIST_LOOPBACK_MODE_SERDES = 1,
	HISI_SAS_BIST_LOOPBACK_MODE_REMOTE = 2,
};

enum {
	HISI_SAS_PHY_BCAST_ACK = 0,
	HISI_SAS_PHY_SL_PHY_ENABLED = 1,
	HISI_SAS_PHY_INT_ABNORMAL = 2,
	HISI_SAS_PHY_INT_NR = 3,
};

enum {
	HISI_SAS_PHY_PHY_UPDOWN = 0,
	HISI_SAS_PHY_CHNL_INT = 1,
	HISI_SAS_PHY_INT_NR___2 = 2,
};

enum {
	HI_SOFTIRQ = 0,
	TIMER_SOFTIRQ = 1,
	NET_TX_SOFTIRQ = 2,
	NET_RX_SOFTIRQ = 3,
	BLOCK_SOFTIRQ = 4,
	IRQ_POLL_SOFTIRQ = 5,
	TASKLET_SOFTIRQ = 6,
	SCHED_SOFTIRQ = 7,
	HRTIMER_SOFTIRQ = 8,
	RCU_SOFTIRQ = 9,
	NR_SOFTIRQS = 10,
};

enum {
	HP_THREAD_NONE = 0,
	HP_THREAD_ACTIVE = 1,
	HP_THREAD_PARKED = 2,
};

enum {
	HSE = 0,
	HSI = 1,
	MSI = 2,
	LSE = 3,
	LSI = 4,
	HSE_DIV2 = 5,
	ICN_HS_MCU = 6,
	ICN_LS_MCU = 7,
	ICN_SDMMC = 8,
	ICN_DDR = 9,
	ICN_DISPLAY = 10,
	ICN_HSL = 11,
	ICN_NIC = 12,
	ICN_VID = 13,
	FLEXGEN_07 = 14,
	FLEXGEN_08 = 15,
	FLEXGEN_09 = 16,
	FLEXGEN_10 = 17,
	FLEXGEN_11 = 18,
	FLEXGEN_12 = 19,
	FLEXGEN_13 = 20,
	FLEXGEN_14 = 21,
	FLEXGEN_15 = 22,
	FLEXGEN_16 = 23,
	FLEXGEN_17 = 24,
	FLEXGEN_18 = 25,
	FLEXGEN_19 = 26,
	FLEXGEN_20 = 27,
	FLEXGEN_21 = 28,
	FLEXGEN_22 = 29,
	FLEXGEN_23 = 30,
	FLEXGEN_24 = 31,
	FLEXGEN_25 = 32,
	FLEXGEN_26 = 33,
	FLEXGEN_27 = 34,
	FLEXGEN_28 = 35,
	FLEXGEN_29 = 36,
	FLEXGEN_30 = 37,
	FLEXGEN_31 = 38,
	FLEXGEN_32 = 39,
	FLEXGEN_33 = 40,
	FLEXGEN_34 = 41,
	FLEXGEN_35 = 42,
	FLEXGEN_36 = 43,
	FLEXGEN_37 = 44,
	FLEXGEN_38 = 45,
	FLEXGEN_39 = 46,
	FLEXGEN_40 = 47,
	FLEXGEN_41 = 48,
	FLEXGEN_42 = 49,
	FLEXGEN_43 = 50,
	FLEXGEN_44 = 51,
	FLEXGEN_45 = 52,
	FLEXGEN_46 = 53,
	FLEXGEN_47 = 54,
	FLEXGEN_48 = 55,
	FLEXGEN_49 = 56,
	FLEXGEN_50 = 57,
	FLEXGEN_51 = 58,
	FLEXGEN_52 = 59,
	FLEXGEN_53 = 60,
	FLEXGEN_54 = 61,
	FLEXGEN_55 = 62,
	FLEXGEN_56 = 63,
	FLEXGEN_57 = 64,
	FLEXGEN_58 = 65,
	FLEXGEN_59 = 66,
	FLEXGEN_60 = 67,
	FLEXGEN_61 = 68,
	FLEXGEN_62 = 69,
	FLEXGEN_63 = 70,
	ICN_APB1 = 71,
	ICN_APB2 = 72,
	ICN_APB3 = 73,
	ICN_APB4 = 74,
	ICN_APBDBG = 75,
	TIMG1 = 76,
	TIMG2 = 77,
	PLL3 = 78,
	DSI_TXBYTE = 79,
};

enum {
	HTE_TS_REGISTERED = 0,
	HTE_TS_REQ = 1,
	HTE_TS_DISABLE = 2,
	HTE_TS_QUEUE_WK = 3,
};

enum {
	HUF_flags_bmi2 = 1,
	HUF_flags_optimalDepth = 2,
	HUF_flags_preferRepeat = 4,
	HUF_flags_suspectUncompressible = 8,
	HUF_flags_disableAsm = 16,
	HUF_flags_disableFast = 32,
};

enum {
	HUGETLB_SHMFS_INODE = 1,
	HUGETLB_ANONHUGE_INODE = 2,
};

enum {
	HW_BREAKPOINT_EMPTY = 0,
	HW_BREAKPOINT_R = 1,
	HW_BREAKPOINT_W = 2,
	HW_BREAKPOINT_RW = 3,
	HW_BREAKPOINT_X = 4,
	HW_BREAKPOINT_INVALID = 7,
};

enum {
	HW_BREAKPOINT_LEN_1 = 1,
	HW_BREAKPOINT_LEN_2 = 2,
	HW_BREAKPOINT_LEN_3 = 3,
	HW_BREAKPOINT_LEN_4 = 4,
	HW_BREAKPOINT_LEN_5 = 5,
	HW_BREAKPOINT_LEN_6 = 6,
	HW_BREAKPOINT_LEN_7 = 7,
	HW_BREAKPOINT_LEN_8 = 8,
};

enum {
	HW_OWNER = 128,
	OP_TCPWRITE = 17,
	OP_TCPSTART = 18,
	OP_TCPINIT = 20,
	OP_TCPLCK = 24,
	OP_TCPCHKSUM = 18,
	OP_TCPIS = 22,
	OP_TCPLW = 25,
	OP_TCPLSW = 27,
	OP_TCPLISW = 31,
	OP_ADDR64 = 33,
	OP_VLAN = 34,
	OP_ADDR64VLAN = 35,
	OP_LRGLEN = 36,
	OP_LRGLENVLAN = 38,
	OP_MSS = 40,
	OP_MSSVLAN = 42,
	OP_BUFFER = 64,
	OP_PACKET = 65,
	OP_LARGESEND = 67,
	OP_LSOV2 = 69,
	OP_RXSTAT = 96,
	OP_RXTIMESTAMP = 97,
	OP_RXVLAN = 98,
	OP_RXCHKS = 100,
	OP_RXCHKSVLAN = 102,
	OP_RXTIMEVLAN = 99,
	OP_RSS_HASH = 101,
	OP_TXINDEXLE = 104,
	OP_MACSEC = 108,
	OP_PUTIDX = 112,
};

enum {
	ICMP6_MIB_NUM = 0,
	ICMP6_MIB_INMSGS = 1,
	ICMP6_MIB_INERRORS = 2,
	ICMP6_MIB_OUTMSGS = 3,
	ICMP6_MIB_OUTERRORS = 4,
	ICMP6_MIB_CSUMERRORS = 5,
	ICMP6_MIB_RATELIMITHOST = 6,
	__ICMP6_MIB_MAX = 7,
};

enum {
	ICMP_MIB_NUM = 0,
	ICMP_MIB_INMSGS = 1,
	ICMP_MIB_INERRORS = 2,
	ICMP_MIB_INDESTUNREACHS = 3,
	ICMP_MIB_INTIMEEXCDS = 4,
	ICMP_MIB_INPARMPROBS = 5,
	ICMP_MIB_INSRCQUENCHS = 6,
	ICMP_MIB_INREDIRECTS = 7,
	ICMP_MIB_INECHOS = 8,
	ICMP_MIB_INECHOREPS = 9,
	ICMP_MIB_INTIMESTAMPS = 10,
	ICMP_MIB_INTIMESTAMPREPS = 11,
	ICMP_MIB_INADDRMASKS = 12,
	ICMP_MIB_INADDRMASKREPS = 13,
	ICMP_MIB_OUTMSGS = 14,
	ICMP_MIB_OUTERRORS = 15,
	ICMP_MIB_OUTDESTUNREACHS = 16,
	ICMP_MIB_OUTTIMEEXCDS = 17,
	ICMP_MIB_OUTPARMPROBS = 18,
	ICMP_MIB_OUTSRCQUENCHS = 19,
	ICMP_MIB_OUTREDIRECTS = 20,
	ICMP_MIB_OUTECHOS = 21,
	ICMP_MIB_OUTECHOREPS = 22,
	ICMP_MIB_OUTTIMESTAMPS = 23,
	ICMP_MIB_OUTTIMESTAMPREPS = 24,
	ICMP_MIB_OUTADDRMASKS = 25,
	ICMP_MIB_OUTADDRMASKREPS = 26,
	ICMP_MIB_CSUMERRORS = 27,
	ICMP_MIB_RATELIMITGLOBAL = 28,
	ICMP_MIB_RATELIMITHOST = 29,
	__ICMP_MIB_MAX = 30,
};

enum {
	ICQ_EXITED = 4,
	ICQ_DESTROYED = 8,
};

enum {
	IDX_MODULE_ID = 0,
	IDX_ST_OPS_COMMON_VALUE_ID = 1,
};

enum {
	IFA_UNSPEC = 0,
	IFA_ADDRESS = 1,
	IFA_LOCAL = 2,
	IFA_LABEL = 3,
	IFA_BROADCAST = 4,
	IFA_ANYCAST = 5,
	IFA_CACHEINFO = 6,
	IFA_MULTICAST = 7,
	IFA_FLAGS = 8,
	IFA_RT_PRIORITY = 9,
	IFA_TARGET_NETNSID = 10,
	IFA_PROTO = 11,
	__IFA_MAX = 12,
};

enum {
	IFLA_BRIDGE_FLAGS = 0,
	IFLA_BRIDGE_MODE = 1,
	IFLA_BRIDGE_VLAN_INFO = 2,
	IFLA_BRIDGE_VLAN_TUNNEL_INFO = 3,
	IFLA_BRIDGE_MRP = 4,
	IFLA_BRIDGE_CFM = 5,
	IFLA_BRIDGE_MST = 6,
	__IFLA_BRIDGE_MAX = 7,
};

enum {
	IFLA_BRPORT_UNSPEC = 0,
	IFLA_BRPORT_STATE = 1,
	IFLA_BRPORT_PRIORITY = 2,
	IFLA_BRPORT_COST = 3,
	IFLA_BRPORT_MODE = 4,
	IFLA_BRPORT_GUARD = 5,
	IFLA_BRPORT_PROTECT = 6,
	IFLA_BRPORT_FAST_LEAVE = 7,
	IFLA_BRPORT_LEARNING = 8,
	IFLA_BRPORT_UNICAST_FLOOD = 9,
	IFLA_BRPORT_PROXYARP = 10,
	IFLA_BRPORT_LEARNING_SYNC = 11,
	IFLA_BRPORT_PROXYARP_WIFI = 12,
	IFLA_BRPORT_ROOT_ID = 13,
	IFLA_BRPORT_BRIDGE_ID = 14,
	IFLA_BRPORT_DESIGNATED_PORT = 15,
	IFLA_BRPORT_DESIGNATED_COST = 16,
	IFLA_BRPORT_ID = 17,
	IFLA_BRPORT_NO = 18,
	IFLA_BRPORT_TOPOLOGY_CHANGE_ACK = 19,
	IFLA_BRPORT_CONFIG_PENDING = 20,
	IFLA_BRPORT_MESSAGE_AGE_TIMER = 21,
	IFLA_BRPORT_FORWARD_DELAY_TIMER = 22,
	IFLA_BRPORT_HOLD_TIMER = 23,
	IFLA_BRPORT_FLUSH = 24,
	IFLA_BRPORT_MULTICAST_ROUTER = 25,
	IFLA_BRPORT_PAD = 26,
	IFLA_BRPORT_MCAST_FLOOD = 27,
	IFLA_BRPORT_MCAST_TO_UCAST = 28,
	IFLA_BRPORT_VLAN_TUNNEL = 29,
	IFLA_BRPORT_BCAST_FLOOD = 30,
	IFLA_BRPORT_GROUP_FWD_MASK = 31,
	IFLA_BRPORT_NEIGH_SUPPRESS = 32,
	IFLA_BRPORT_ISOLATED = 33,
	IFLA_BRPORT_BACKUP_PORT = 34,
	IFLA_BRPORT_MRP_RING_OPEN = 35,
	IFLA_BRPORT_MRP_IN_OPEN = 36,
	IFLA_BRPORT_MCAST_EHT_HOSTS_LIMIT = 37,
	IFLA_BRPORT_MCAST_EHT_HOSTS_CNT = 38,
	IFLA_BRPORT_LOCKED = 39,
	IFLA_BRPORT_MAB = 40,
	IFLA_BRPORT_MCAST_N_GROUPS = 41,
	IFLA_BRPORT_MCAST_MAX_GROUPS = 42,
	IFLA_BRPORT_NEIGH_VLAN_SUPPRESS = 43,
	IFLA_BRPORT_BACKUP_NHID = 44,
	__IFLA_BRPORT_MAX = 45,
};

enum {
	IFLA_EVENT_NONE = 0,
	IFLA_EVENT_REBOOT = 1,
	IFLA_EVENT_FEATURES = 2,
	IFLA_EVENT_BONDING_FAILOVER = 3,
	IFLA_EVENT_NOTIFY_PEERS = 4,
	IFLA_EVENT_IGMP_RESEND = 5,
	IFLA_EVENT_BONDING_OPTIONS = 6,
};

enum {
	IFLA_INET_UNSPEC = 0,
	IFLA_INET_CONF = 1,
	__IFLA_INET_MAX = 2,
};

enum {
	IFLA_INFO_UNSPEC = 0,
	IFLA_INFO_KIND = 1,
	IFLA_INFO_DATA = 2,
	IFLA_INFO_XSTATS = 3,
	IFLA_INFO_SLAVE_KIND = 4,
	IFLA_INFO_SLAVE_DATA = 5,
	__IFLA_INFO_MAX = 6,
};

enum {
	IFLA_IPTUN_UNSPEC = 0,
	IFLA_IPTUN_LINK = 1,
	IFLA_IPTUN_LOCAL = 2,
	IFLA_IPTUN_REMOTE = 3,
	IFLA_IPTUN_TTL = 4,
	IFLA_IPTUN_TOS = 5,
	IFLA_IPTUN_ENCAP_LIMIT = 6,
	IFLA_IPTUN_FLOWINFO = 7,
	IFLA_IPTUN_FLAGS = 8,
	IFLA_IPTUN_PROTO = 9,
	IFLA_IPTUN_PMTUDISC = 10,
	IFLA_IPTUN_6RD_PREFIX = 11,
	IFLA_IPTUN_6RD_RELAY_PREFIX = 12,
	IFLA_IPTUN_6RD_PREFIXLEN = 13,
	IFLA_IPTUN_6RD_RELAY_PREFIXLEN = 14,
	IFLA_IPTUN_ENCAP_TYPE = 15,
	IFLA_IPTUN_ENCAP_FLAGS = 16,
	IFLA_IPTUN_ENCAP_SPORT = 17,
	IFLA_IPTUN_ENCAP_DPORT = 18,
	IFLA_IPTUN_COLLECT_METADATA = 19,
	IFLA_IPTUN_FWMARK = 20,
	__IFLA_IPTUN_MAX = 21,
};

enum {
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_REQUEST = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_USED = 2,
	__IFLA_OFFLOAD_XSTATS_HW_S_INFO_MAX = 3,
};

enum {
	IFLA_OFFLOAD_XSTATS_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_CPU_HIT = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO = 2,
	IFLA_OFFLOAD_XSTATS_L3_STATS = 3,
	__IFLA_OFFLOAD_XSTATS_MAX = 4,
};

enum {
	IFLA_PORT_UNSPEC = 0,
	IFLA_PORT_VF = 1,
	IFLA_PORT_PROFILE = 2,
	IFLA_PORT_VSI_TYPE = 3,
	IFLA_PORT_INSTANCE_UUID = 4,
	IFLA_PORT_HOST_UUID = 5,
	IFLA_PORT_REQUEST = 6,
	IFLA_PORT_RESPONSE = 7,
	__IFLA_PORT_MAX = 8,
};

enum {
	IFLA_PROTO_DOWN_REASON_UNSPEC = 0,
	IFLA_PROTO_DOWN_REASON_MASK = 1,
	IFLA_PROTO_DOWN_REASON_VALUE = 2,
	__IFLA_PROTO_DOWN_REASON_CNT = 3,
	IFLA_PROTO_DOWN_REASON_MAX = 2,
};

enum {
	IFLA_STATS_GETSET_UNSPEC = 0,
	IFLA_STATS_GET_FILTERS = 1,
	IFLA_STATS_SET_OFFLOAD_XSTATS_L3_STATS = 2,
	__IFLA_STATS_GETSET_MAX = 3,
};

enum {
	IFLA_STATS_UNSPEC = 0,
	IFLA_STATS_LINK_64 = 1,
	IFLA_STATS_LINK_XSTATS = 2,
	IFLA_STATS_LINK_XSTATS_SLAVE = 3,
	IFLA_STATS_LINK_OFFLOAD_XSTATS = 4,
	IFLA_STATS_AF_SPEC = 5,
	__IFLA_STATS_MAX = 6,
};

enum {
	IFLA_TUN_UNSPEC = 0,
	IFLA_TUN_OWNER = 1,
	IFLA_TUN_GROUP = 2,
	IFLA_TUN_TYPE = 3,
	IFLA_TUN_PI = 4,
	IFLA_TUN_VNET_HDR = 5,
	IFLA_TUN_PERSIST = 6,
	IFLA_TUN_MULTI_QUEUE = 7,
	IFLA_TUN_NUM_QUEUES = 8,
	IFLA_TUN_NUM_DISABLED_QUEUES = 9,
	__IFLA_TUN_MAX = 10,
};

enum {
	IFLA_UNSPEC = 0,
	IFLA_ADDRESS = 1,
	IFLA_BROADCAST = 2,
	IFLA_IFNAME = 3,
	IFLA_MTU = 4,
	IFLA_LINK = 5,
	IFLA_QDISC = 6,
	IFLA_STATS = 7,
	IFLA_COST = 8,
	IFLA_PRIORITY = 9,
	IFLA_MASTER = 10,
	IFLA_WIRELESS = 11,
	IFLA_PROTINFO = 12,
	IFLA_TXQLEN = 13,
	IFLA_MAP = 14,
	IFLA_WEIGHT = 15,
	IFLA_OPERSTATE = 16,
	IFLA_LINKMODE = 17,
	IFLA_LINKINFO = 18,
	IFLA_NET_NS_PID = 19,
	IFLA_IFALIAS = 20,
	IFLA_NUM_VF = 21,
	IFLA_VFINFO_LIST = 22,
	IFLA_STATS64 = 23,
	IFLA_VF_PORTS = 24,
	IFLA_PORT_SELF = 25,
	IFLA_AF_SPEC = 26,
	IFLA_GROUP = 27,
	IFLA_NET_NS_FD = 28,
	IFLA_EXT_MASK = 29,
	IFLA_PROMISCUITY = 30,
	IFLA_NUM_TX_QUEUES = 31,
	IFLA_NUM_RX_QUEUES = 32,
	IFLA_CARRIER = 33,
	IFLA_PHYS_PORT_ID = 34,
	IFLA_CARRIER_CHANGES = 35,
	IFLA_PHYS_SWITCH_ID = 36,
	IFLA_LINK_NETNSID = 37,
	IFLA_PHYS_PORT_NAME = 38,
	IFLA_PROTO_DOWN = 39,
	IFLA_GSO_MAX_SEGS = 40,
	IFLA_GSO_MAX_SIZE = 41,
	IFLA_PAD = 42,
	IFLA_XDP = 43,
	IFLA_EVENT = 44,
	IFLA_NEW_NETNSID = 45,
	IFLA_IF_NETNSID = 46,
	IFLA_TARGET_NETNSID = 46,
	IFLA_CARRIER_UP_COUNT = 47,
	IFLA_CARRIER_DOWN_COUNT = 48,
	IFLA_NEW_IFINDEX = 49,
	IFLA_MIN_MTU = 50,
	IFLA_MAX_MTU = 51,
	IFLA_PROP_LIST = 52,
	IFLA_ALT_IFNAME = 53,
	IFLA_PERM_ADDRESS = 54,
	IFLA_PROTO_DOWN_REASON = 55,
	IFLA_PARENT_DEV_NAME = 56,
	IFLA_PARENT_DEV_BUS_NAME = 57,
	IFLA_GRO_MAX_SIZE = 58,
	IFLA_TSO_MAX_SIZE = 59,
	IFLA_TSO_MAX_SEGS = 60,
	IFLA_ALLMULTI = 61,
	IFLA_DEVLINK_PORT = 62,
	IFLA_GSO_IPV4_MAX_SIZE = 63,
	IFLA_GRO_IPV4_MAX_SIZE = 64,
	IFLA_DPLL_PIN = 65,
	IFLA_MAX_PACING_OFFLOAD_HORIZON = 66,
	IFLA_NETNS_IMMUTABLE = 67,
	__IFLA_MAX = 68,
};

enum {
	IFLA_VF_INFO_UNSPEC = 0,
	IFLA_VF_INFO = 1,
	__IFLA_VF_INFO_MAX = 2,
};

enum {
	IFLA_VF_LINK_STATE_AUTO = 0,
	IFLA_VF_LINK_STATE_ENABLE = 1,
	IFLA_VF_LINK_STATE_DISABLE = 2,
	__IFLA_VF_LINK_STATE_MAX = 3,
};

enum {
	IFLA_VF_PORT_UNSPEC = 0,
	IFLA_VF_PORT = 1,
	__IFLA_VF_PORT_MAX = 2,
};

enum {
	IFLA_VF_STATS_RX_PACKETS = 0,
	IFLA_VF_STATS_TX_PACKETS = 1,
	IFLA_VF_STATS_RX_BYTES = 2,
	IFLA_VF_STATS_TX_BYTES = 3,
	IFLA_VF_STATS_BROADCAST = 4,
	IFLA_VF_STATS_MULTICAST = 5,
	IFLA_VF_STATS_PAD = 6,
	IFLA_VF_STATS_RX_DROPPED = 7,
	IFLA_VF_STATS_TX_DROPPED = 8,
	__IFLA_VF_STATS_MAX = 9,
};

enum {
	IFLA_VF_UNSPEC = 0,
	IFLA_VF_MAC = 1,
	IFLA_VF_VLAN = 2,
	IFLA_VF_TX_RATE = 3,
	IFLA_VF_SPOOFCHK = 4,
	IFLA_VF_LINK_STATE = 5,
	IFLA_VF_RATE = 6,
	IFLA_VF_RSS_QUERY_EN = 7,
	IFLA_VF_STATS = 8,
	IFLA_VF_TRUST = 9,
	IFLA_VF_IB_NODE_GUID = 10,
	IFLA_VF_IB_PORT_GUID = 11,
	IFLA_VF_VLAN_LIST = 12,
	IFLA_VF_BROADCAST = 13,
	__IFLA_VF_MAX = 14,
};

enum {
	IFLA_VF_VLAN_INFO_UNSPEC = 0,
	IFLA_VF_VLAN_INFO = 1,
	__IFLA_VF_VLAN_INFO_MAX = 2,
};

enum {
	IFLA_XDP_UNSPEC = 0,
	IFLA_XDP_FD = 1,
	IFLA_XDP_ATTACHED = 2,
	IFLA_XDP_FLAGS = 3,
	IFLA_XDP_PROG_ID = 4,
	IFLA_XDP_DRV_PROG_ID = 5,
	IFLA_XDP_SKB_PROG_ID = 6,
	IFLA_XDP_HW_PROG_ID = 7,
	IFLA_XDP_EXPECTED_FD = 8,
	__IFLA_XDP_MAX = 9,
};

enum {
	IF_ACT_NONE = -1,
	IF_ACT_FILTER = 0,
	IF_ACT_START = 1,
	IF_ACT_STOP = 2,
	IF_SRC_FILE = 3,
	IF_SRC_KERNEL = 4,
	IF_SRC_FILEADDR = 5,
	IF_SRC_KERNELADDR = 6,
};

enum {
	IF_LINK_MODE_DEFAULT = 0,
	IF_LINK_MODE_DORMANT = 1,
	IF_LINK_MODE_TESTING = 2,
};

enum {
	IF_OPER_UNKNOWN = 0,
	IF_OPER_NOTPRESENT = 1,
	IF_OPER_DOWN = 2,
	IF_OPER_LOWERLAYERDOWN = 3,
	IF_OPER_TESTING = 4,
	IF_OPER_DORMANT = 5,
	IF_OPER_UP = 6,
};

enum {
	IF_STATE_ACTION = 0,
	IF_STATE_SOURCE = 1,
	IF_STATE_END = 2,
};

enum {
	INBAND_CISCO_SGMII = 0,
	INBAND_BASEX = 1,
};

enum {
	INET_DIAG_BC_NOP = 0,
	INET_DIAG_BC_JMP = 1,
	INET_DIAG_BC_S_GE = 2,
	INET_DIAG_BC_S_LE = 3,
	INET_DIAG_BC_D_GE = 4,
	INET_DIAG_BC_D_LE = 5,
	INET_DIAG_BC_AUTO = 6,
	INET_DIAG_BC_S_COND = 7,
	INET_DIAG_BC_D_COND = 8,
	INET_DIAG_BC_DEV_COND = 9,
	INET_DIAG_BC_MARK_COND = 10,
	INET_DIAG_BC_S_EQ = 11,
	INET_DIAG_BC_D_EQ = 12,
	INET_DIAG_BC_CGROUP_COND = 13,
};

enum {
	INET_DIAG_NONE = 0,
	INET_DIAG_MEMINFO = 1,
	INET_DIAG_INFO = 2,
	INET_DIAG_VEGASINFO = 3,
	INET_DIAG_CONG = 4,
	INET_DIAG_TOS = 5,
	INET_DIAG_TCLASS = 6,
	INET_DIAG_SKMEMINFO = 7,
	INET_DIAG_SHUTDOWN = 8,
	INET_DIAG_DCTCPINFO = 9,
	INET_DIAG_PROTOCOL = 10,
	INET_DIAG_SKV6ONLY = 11,
	INET_DIAG_LOCALS = 12,
	INET_DIAG_PEERS = 13,
	INET_DIAG_PAD = 14,
	INET_DIAG_MARK = 15,
	INET_DIAG_BBRINFO = 16,
	INET_DIAG_CLASS_ID = 17,
	INET_DIAG_MD5SIG = 18,
	INET_DIAG_ULP_INFO = 19,
	INET_DIAG_SK_BPF_STORAGES = 20,
	INET_DIAG_CGROUP_ID = 21,
	INET_DIAG_SOCKOPT = 22,
	__INET_DIAG_MAX = 23,
};

enum {
	INET_DIAG_REQ_NONE = 0,
	INET_DIAG_REQ_BYTECODE = 1,
	INET_DIAG_REQ_SK_BPF_STORAGES = 2,
	INET_DIAG_REQ_PROTOCOL = 3,
	__INET_DIAG_REQ_MAX = 4,
};

enum {
	INET_ECN_NOT_ECT = 0,
	INET_ECN_ECT_1 = 1,
	INET_ECN_ECT_0 = 2,
	INET_ECN_CE = 3,
	INET_ECN_MASK = 3,
};

enum {
	INET_FLAGS_PKTINFO = 0,
	INET_FLAGS_TTL = 1,
	INET_FLAGS_TOS = 2,
	INET_FLAGS_RECVOPTS = 3,
	INET_FLAGS_RETOPTS = 4,
	INET_FLAGS_PASSSEC = 5,
	INET_FLAGS_ORIGDSTADDR = 6,
	INET_FLAGS_CHECKSUM = 7,
	INET_FLAGS_RECVFRAGSIZE = 8,
	INET_FLAGS_RECVERR = 9,
	INET_FLAGS_RECVERR_RFC4884 = 10,
	INET_FLAGS_FREEBIND = 11,
	INET_FLAGS_HDRINCL = 12,
	INET_FLAGS_MC_LOOP = 13,
	INET_FLAGS_MC_ALL = 14,
	INET_FLAGS_TRANSPARENT = 15,
	INET_FLAGS_IS_ICSK = 16,
	INET_FLAGS_NODEFRAG = 17,
	INET_FLAGS_BIND_ADDRESS_NO_PORT = 18,
	INET_FLAGS_DEFER_CONNECT = 19,
	INET_FLAGS_MC6_LOOP = 20,
	INET_FLAGS_RECVERR6_RFC4884 = 21,
	INET_FLAGS_MC6_ALL = 22,
	INET_FLAGS_AUTOFLOWLABEL_SET = 23,
	INET_FLAGS_AUTOFLOWLABEL = 24,
	INET_FLAGS_DONTFRAG = 25,
	INET_FLAGS_RECVERR6 = 26,
	INET_FLAGS_REPFLOW = 27,
	INET_FLAGS_RTALERT_ISOLATE = 28,
	INET_FLAGS_SNDFLOW = 29,
	INET_FLAGS_RTALERT = 30,
};

enum {
	INET_FRAG_FIRST_IN = 1,
	INET_FRAG_LAST_IN = 2,
	INET_FRAG_COMPLETE = 4,
	INET_FRAG_HASH_DEAD = 8,
	INET_FRAG_DROP = 16,
};

enum {
	INET_ULP_INFO_UNSPEC = 0,
	INET_ULP_INFO_NAME = 1,
	INET_ULP_INFO_TLS = 2,
	INET_ULP_INFO_MPTCP = 3,
	__INET_ULP_INFO_MAX = 4,
};

enum {
	INSN_F_FRAMENO_MASK = 7,
	INSN_F_SPI_MASK = 63,
	INSN_F_SPI_SHIFT = 3,
	INSN_F_STACK_ACCESS = 512,
	INSN_F_DST_REG_STACK = 1024,
	INSN_F_SRC_REG_STACK = 2048,
};

enum {
	INTEL_DSM_FNS = 0,
	INTEL_DSM_V18_SWITCH = 3,
	INTEL_DSM_V33_SWITCH = 4,
	INTEL_DSM_HS_CAPS = 8,
};

enum {
	INTERRUPT_MASK_ALL_VER_11 = 204799,
	INTERRUPT_MASK_ALL_VER_21 = 466943,
};

enum {
	INVERT = 1,
	PROCESS_AND = 2,
	PROCESS_OR = 4,
};

enum {
	IOBL_BUF_RING = 1,
	IOBL_INC = 2,
};

enum {
	IOCB_CMD_PREAD = 0,
	IOCB_CMD_PWRITE = 1,
	IOCB_CMD_FSYNC = 2,
	IOCB_CMD_FDSYNC = 3,
	IOCB_CMD_POLL = 5,
	IOCB_CMD_NOOP = 6,
	IOCB_CMD_PREADV = 7,
	IOCB_CMD_PWRITEV = 8,
};

enum {
	IOMMUFD_ACCESS_RW_READ = 0,
	IOMMUFD_ACCESS_RW_WRITE = 1,
	IOMMUFD_ACCESS_RW_KTHREAD = 2,
	__IOMMUFD_ACCESS_RW_SLOW_PATH = 4,
};

enum {
	IOMMU_PASID_ARRAY_DOMAIN = 0,
	IOMMU_PASID_ARRAY_HANDLE = 1,
};

enum {
	IOMMU_SET_DOMAIN_MUST_SUCCEED = 1,
};

enum {
	IOPRIO_CLASS_NONE = 0,
	IOPRIO_CLASS_RT = 1,
	IOPRIO_CLASS_BE = 2,
	IOPRIO_CLASS_IDLE = 3,
	IOPRIO_CLASS_INVALID = 7,
};

enum {
	IOPRIO_HINT_NONE = 0,
	IOPRIO_HINT_DEV_DURATION_LIMIT_1 = 1,
	IOPRIO_HINT_DEV_DURATION_LIMIT_2 = 2,
	IOPRIO_HINT_DEV_DURATION_LIMIT_3 = 3,
	IOPRIO_HINT_DEV_DURATION_LIMIT_4 = 4,
	IOPRIO_HINT_DEV_DURATION_LIMIT_5 = 5,
	IOPRIO_HINT_DEV_DURATION_LIMIT_6 = 6,
	IOPRIO_HINT_DEV_DURATION_LIMIT_7 = 7,
};

enum {
	IOPRIO_WHO_PROCESS = 1,
	IOPRIO_WHO_PGRP = 2,
	IOPRIO_WHO_USER = 3,
};

enum {
	IORES_DESC_NONE = 0,
	IORES_DESC_CRASH_KERNEL = 1,
	IORES_DESC_ACPI_TABLES = 2,
	IORES_DESC_ACPI_NV_STORAGE = 3,
	IORES_DESC_PERSISTENT_MEMORY = 4,
	IORES_DESC_PERSISTENT_MEMORY_LEGACY = 5,
	IORES_DESC_DEVICE_PRIVATE_MEMORY = 6,
	IORES_DESC_RESERVED = 7,
	IORES_DESC_SOFT_RESERVED = 8,
	IORES_DESC_CXL = 9,
};

enum {
	IORING_MEM_REGION_REG_WAIT_ARG = 1,
};

enum {
	IORING_MEM_REGION_TYPE_USER = 1,
};

enum {
	IORING_REGISTER_SRC_REGISTERED = 1,
	IORING_REGISTER_DST_REPLACE = 2,
};

enum {
	IORING_REG_WAIT_TS = 1,
};

enum {
	IORING_RSRC_FILE = 0,
	IORING_RSRC_BUFFER = 1,
};

enum {
	IOU_COMPLETE = 0,
	IOU_ISSUE_SKIP_COMPLETE = -529,
	IOU_RETRY = -11,
	IOU_REQUEUE = -3072,
};

enum {
	IOU_F_TWQ_LAZY_WAKE = 1,
};

enum {
	IOU_POLL_DONE = 0,
	IOU_POLL_NO_ACTION = 1,
	IOU_POLL_REMOVE_POLL_USE_RES = 2,
	IOU_POLL_REISSUE = 3,
	IOU_POLL_REQUEUE = 4,
};

enum {
	IO_ACCT_STALLED_BIT = 0,
};

enum {
	IO_APOLL_OK = 0,
	IO_APOLL_ABORTED = 1,
	IO_APOLL_READY = 2,
};

enum {
	IO_CHECK_CQ_OVERFLOW_BIT = 0,
	IO_CHECK_CQ_DROPPED_BIT = 1,
};

enum {
	IO_EVENTFD_OP_SIGNAL_BIT = 0,
};

enum {
	IO_IMU_DEST = 1,
	IO_IMU_SOURCE = 2,
};

enum {
	IO_REGION_F_VMAP = 1,
	IO_REGION_F_USER_PROVIDED = 2,
	IO_REGION_F_SINGLE_REF = 4,
};

enum {
	IO_SQ_THREAD_SHOULD_STOP = 0,
	IO_SQ_THREAD_SHOULD_PARK = 1,
};

enum {
	IO_WORKER_F_UP = 0,
	IO_WORKER_F_RUNNING = 1,
	IO_WORKER_F_FREE = 2,
};

enum {
	IO_WQ_ACCT_BOUND = 0,
	IO_WQ_ACCT_UNBOUND = 1,
	IO_WQ_ACCT_NR = 2,
};

enum {
	IO_WQ_BIT_EXIT = 0,
};

enum {
	IO_WQ_WORK_CANCEL = 1,
	IO_WQ_WORK_HASHED = 2,
	IO_WQ_WORK_UNBOUND = 4,
	IO_WQ_WORK_CONCURRENT = 16,
	IO_WQ_HASH_SHIFT = 24,
};

enum {
	IP6_FH_F_FRAG = 1,
	IP6_FH_F_AUTH = 2,
	IP6_FH_F_SKIP_RH = 4,
};

enum {
	IPPROTO_IP = 0,
	IPPROTO_ICMP = 1,
	IPPROTO_IGMP = 2,
	IPPROTO_IPIP = 4,
	IPPROTO_TCP = 6,
	IPPROTO_EGP = 8,
	IPPROTO_PUP = 12,
	IPPROTO_UDP = 17,
	IPPROTO_IDP = 22,
	IPPROTO_TP = 29,
	IPPROTO_DCCP = 33,
	IPPROTO_IPV6 = 41,
	IPPROTO_RSVP = 46,
	IPPROTO_GRE = 47,
	IPPROTO_ESP = 50,
	IPPROTO_AH = 51,
	IPPROTO_MTP = 92,
	IPPROTO_BEETPH = 94,
	IPPROTO_ENCAP = 98,
	IPPROTO_PIM = 103,
	IPPROTO_COMP = 108,
	IPPROTO_L2TP = 115,
	IPPROTO_SCTP = 132,
	IPPROTO_UDPLITE = 136,
	IPPROTO_MPLS = 137,
	IPPROTO_ETHERNET = 143,
	IPPROTO_AGGFRAG = 144,
	IPPROTO_RAW = 255,
	IPPROTO_SMC = 256,
	IPPROTO_MPTCP = 262,
	IPPROTO_MAX = 263,
};

enum {
	IPSTATS_MIB_NUM = 0,
	IPSTATS_MIB_INPKTS = 1,
	IPSTATS_MIB_INOCTETS = 2,
	IPSTATS_MIB_INDELIVERS = 3,
	IPSTATS_MIB_NOECTPKTS = 4,
	IPSTATS_MIB_ECT1PKTS = 5,
	IPSTATS_MIB_ECT0PKTS = 6,
	IPSTATS_MIB_CEPKTS = 7,
	IPSTATS_MIB_OUTREQUESTS = 8,
	IPSTATS_MIB_OUTPKTS = 9,
	IPSTATS_MIB_OUTOCTETS = 10,
	IPSTATS_MIB_OUTFORWDATAGRAMS = 11,
	IPSTATS_MIB_INHDRERRORS = 12,
	IPSTATS_MIB_INTOOBIGERRORS = 13,
	IPSTATS_MIB_INNOROUTES = 14,
	IPSTATS_MIB_INADDRERRORS = 15,
	IPSTATS_MIB_INUNKNOWNPROTOS = 16,
	IPSTATS_MIB_INTRUNCATEDPKTS = 17,
	IPSTATS_MIB_INDISCARDS = 18,
	IPSTATS_MIB_OUTDISCARDS = 19,
	IPSTATS_MIB_OUTNOROUTES = 20,
	IPSTATS_MIB_REASMTIMEOUT = 21,
	IPSTATS_MIB_REASMREQDS = 22,
	IPSTATS_MIB_REASMOKS = 23,
	IPSTATS_MIB_REASMFAILS = 24,
	IPSTATS_MIB_FRAGOKS = 25,
	IPSTATS_MIB_FRAGFAILS = 26,
	IPSTATS_MIB_FRAGCREATES = 27,
	IPSTATS_MIB_INMCASTPKTS = 28,
	IPSTATS_MIB_OUTMCASTPKTS = 29,
	IPSTATS_MIB_INBCASTPKTS = 30,
	IPSTATS_MIB_OUTBCASTPKTS = 31,
	IPSTATS_MIB_INMCASTOCTETS = 32,
	IPSTATS_MIB_OUTMCASTOCTETS = 33,
	IPSTATS_MIB_INBCASTOCTETS = 34,
	IPSTATS_MIB_OUTBCASTOCTETS = 35,
	IPSTATS_MIB_CSUMERRORS = 36,
	IPSTATS_MIB_REASM_OVERLAPS = 37,
	__IPSTATS_MIB_MAX = 38,
};

enum {
	IPV4_DEVCONF_FORWARDING = 1,
	IPV4_DEVCONF_MC_FORWARDING = 2,
	IPV4_DEVCONF_PROXY_ARP = 3,
	IPV4_DEVCONF_ACCEPT_REDIRECTS = 4,
	IPV4_DEVCONF_SECURE_REDIRECTS = 5,
	IPV4_DEVCONF_SEND_REDIRECTS = 6,
	IPV4_DEVCONF_SHARED_MEDIA = 7,
	IPV4_DEVCONF_RP_FILTER = 8,
	IPV4_DEVCONF_ACCEPT_SOURCE_ROUTE = 9,
	IPV4_DEVCONF_BOOTP_RELAY = 10,
	IPV4_DEVCONF_LOG_MARTIANS = 11,
	IPV4_DEVCONF_TAG = 12,
	IPV4_DEVCONF_ARPFILTER = 13,
	IPV4_DEVCONF_MEDIUM_ID = 14,
	IPV4_DEVCONF_NOXFRM = 15,
	IPV4_DEVCONF_NOPOLICY = 16,
	IPV4_DEVCONF_FORCE_IGMP_VERSION = 17,
	IPV4_DEVCONF_ARP_ANNOUNCE = 18,
	IPV4_DEVCONF_ARP_IGNORE = 19,
	IPV4_DEVCONF_PROMOTE_SECONDARIES = 20,
	IPV4_DEVCONF_ARP_ACCEPT = 21,
	IPV4_DEVCONF_ARP_NOTIFY = 22,
	IPV4_DEVCONF_ACCEPT_LOCAL = 23,
	IPV4_DEVCONF_SRC_VMARK = 24,
	IPV4_DEVCONF_PROXY_ARP_PVLAN = 25,
	IPV4_DEVCONF_ROUTE_LOCALNET = 26,
	IPV4_DEVCONF_IGMPV2_UNSOLICITED_REPORT_INTERVAL = 27,
	IPV4_DEVCONF_IGMPV3_UNSOLICITED_REPORT_INTERVAL = 28,
	IPV4_DEVCONF_IGNORE_ROUTES_WITH_LINKDOWN = 29,
	IPV4_DEVCONF_DROP_UNICAST_IN_L2_MULTICAST = 30,
	IPV4_DEVCONF_DROP_GRATUITOUS_ARP = 31,
	IPV4_DEVCONF_BC_FORWARDING = 32,
	IPV4_DEVCONF_ARP_EVICT_NOCARRIER = 33,
	__IPV4_DEVCONF_MAX = 34,
};

enum {
	IP_TUNNEL_CSUM_BIT = 0,
	IP_TUNNEL_ROUTING_BIT = 1,
	IP_TUNNEL_KEY_BIT = 2,
	IP_TUNNEL_SEQ_BIT = 3,
	IP_TUNNEL_STRICT_BIT = 4,
	IP_TUNNEL_REC_BIT = 5,
	IP_TUNNEL_VERSION_BIT = 6,
	IP_TUNNEL_NO_KEY_BIT = 7,
	IP_TUNNEL_DONT_FRAGMENT_BIT = 8,
	IP_TUNNEL_OAM_BIT = 9,
	IP_TUNNEL_CRIT_OPT_BIT = 10,
	IP_TUNNEL_GENEVE_OPT_BIT = 11,
	IP_TUNNEL_VXLAN_OPT_BIT = 12,
	IP_TUNNEL_NOCACHE_BIT = 13,
	IP_TUNNEL_ERSPAN_OPT_BIT = 14,
	IP_TUNNEL_GTP_OPT_BIT = 15,
	IP_TUNNEL_VTI_BIT = 16,
	IP_TUNNEL_SIT_ISATAP_BIT = 16,
	IP_TUNNEL_PFCP_OPT_BIT = 17,
	__IP_TUNNEL_FLAG_NUM = 18,
};

enum {
	IRQCHIP_FWNODE_REAL = 0,
	IRQCHIP_FWNODE_NAMED = 1,
	IRQCHIP_FWNODE_NAMED_ID = 2,
};

enum {
	IRQCHIP_SET_TYPE_MASKED = 1,
	IRQCHIP_EOI_IF_HANDLED = 2,
	IRQCHIP_MASK_ON_SUSPEND = 4,
	IRQCHIP_ONOFFLINE_ENABLED = 8,
	IRQCHIP_SKIP_SET_WAKE = 16,
	IRQCHIP_ONESHOT_SAFE = 32,
	IRQCHIP_EOI_THREADED = 64,
	IRQCHIP_SUPPORTS_LEVEL_MSI = 128,
	IRQCHIP_SUPPORTS_NMI = 256,
	IRQCHIP_ENABLE_WAKEUP_ON_SUSPEND = 512,
	IRQCHIP_AFFINITY_PRE_STARTUP = 1024,
	IRQCHIP_IMMUTABLE = 2048,
	IRQCHIP_MOVE_DEFERRED = 4096,
};

enum {
	IRQC_IS_HARDIRQ = 0,
	IRQC_IS_NESTED = 1,
};

enum {
	IRQD_TRIGGER_MASK = 15,
	IRQD_SETAFFINITY_PENDING = 256,
	IRQD_ACTIVATED = 512,
	IRQD_NO_BALANCING = 1024,
	IRQD_PER_CPU = 2048,
	IRQD_AFFINITY_SET = 4096,
	IRQD_LEVEL = 8192,
	IRQD_WAKEUP_STATE = 16384,
	IRQD_IRQ_DISABLED = 65536,
	IRQD_IRQ_MASKED = 131072,
	IRQD_IRQ_INPROGRESS = 262144,
	IRQD_WAKEUP_ARMED = 524288,
	IRQD_FORWARDED_TO_VCPU = 1048576,
	IRQD_AFFINITY_MANAGED = 2097152,
	IRQD_IRQ_STARTED = 4194304,
	IRQD_MANAGED_SHUTDOWN = 8388608,
	IRQD_SINGLE_TARGET = 16777216,
	IRQD_DEFAULT_TRIGGER_SET = 33554432,
	IRQD_CAN_RESERVE = 67108864,
	IRQD_HANDLE_ENFORCE_IRQCTX = 134217728,
	IRQD_AFFINITY_ON_ACTIVATE = 268435456,
	IRQD_IRQ_ENABLED_ON_SUSPEND = 536870912,
	IRQD_RESEND_WHEN_IN_PROGRESS = 1073741824,
};

enum {
	IRQS_AUTODETECT = 1,
	IRQS_SPURIOUS_DISABLED = 2,
	IRQS_POLL_INPROGRESS = 8,
	IRQS_ONESHOT = 32,
	IRQS_REPLAY = 64,
	IRQS_WAITING = 128,
	IRQS_PENDING = 512,
	IRQS_SUSPENDED = 2048,
	IRQS_TIMINGS = 4096,
	IRQS_NMI = 8192,
	IRQS_SYSFS = 16384,
};

enum {
	IRQTF_RUNTHREAD = 0,
	IRQTF_WARNED = 1,
	IRQTF_AFFINITY = 2,
	IRQTF_FORCED_THREAD = 3,
	IRQTF_READY = 4,
};

enum {
	IRQ_DOMAIN_FLAG_HIERARCHY = 1,
	IRQ_DOMAIN_NAME_ALLOCATED = 2,
	IRQ_DOMAIN_FLAG_IPI_PER_CPU = 4,
	IRQ_DOMAIN_FLAG_IPI_SINGLE = 8,
	IRQ_DOMAIN_FLAG_MSI = 16,
	IRQ_DOMAIN_FLAG_ISOLATED_MSI = 32,
	IRQ_DOMAIN_FLAG_NO_MAP = 64,
	IRQ_DOMAIN_FLAG_MSI_PARENT = 256,
	IRQ_DOMAIN_FLAG_MSI_DEVICE = 512,
	IRQ_DOMAIN_FLAG_DESTROY_GC = 1024,
	IRQ_DOMAIN_FLAG_MSI_IMMUTABLE = 2048,
	IRQ_DOMAIN_FLAG_NONCORE = 65536,
};

enum {
	IRQ_POLL_F_SCHED = 0,
	IRQ_POLL_F_DISABLE = 1,
};

enum {
	IRQ_SET_MASK_OK = 0,
	IRQ_SET_MASK_OK_NOCOPY = 1,
	IRQ_SET_MASK_OK_DONE = 2,
};

enum {
	IRQ_STARTUP_NORMAL = 0,
	IRQ_STARTUP_MANAGED = 1,
	IRQ_STARTUP_ABORT = 2,
};

enum {
	IRQ_TYPE_NONE = 0,
	IRQ_TYPE_EDGE_RISING = 1,
	IRQ_TYPE_EDGE_FALLING = 2,
	IRQ_TYPE_EDGE_BOTH = 3,
	IRQ_TYPE_LEVEL_HIGH = 4,
	IRQ_TYPE_LEVEL_LOW = 8,
	IRQ_TYPE_LEVEL_MASK = 12,
	IRQ_TYPE_SENSE_MASK = 15,
	IRQ_TYPE_DEFAULT = 15,
	IRQ_TYPE_PROBE = 16,
	IRQ_LEVEL = 256,
	IRQ_PER_CPU = 512,
	IRQ_NOPROBE = 1024,
	IRQ_NOREQUEST = 2048,
	IRQ_NOAUTOEN = 4096,
	IRQ_NO_BALANCING = 8192,
	IRQ_NESTED_THREAD = 32768,
	IRQ_NOTHREAD = 65536,
	IRQ_PER_CPU_DEVID = 131072,
	IRQ_IS_POLLED = 262144,
	IRQ_DISABLE_UNLAZY = 524288,
	IRQ_HIDDEN = 1048576,
	IRQ_NO_DEBUG = 2097152,
};

enum {
	I_DATA_SEM_NORMAL = 0,
	I_DATA_SEM_OTHER = 1,
	I_DATA_SEM_QUOTA = 2,
	I_DATA_SEM_EA = 3,
};

enum {
	K3_UDMA_GLUE_SRC_TAG_LO_KEEP = 0,
	K3_UDMA_GLUE_SRC_TAG_LO_USE_FLOW_REG = 1,
	K3_UDMA_GLUE_SRC_TAG_LO_USE_REMOTE_FLOW_ID = 2,
	K3_UDMA_GLUE_SRC_TAG_LO_USE_REMOTE_SRC_TAG = 4,
};

enum {
	KBUF_MODE_EXPAND = 1,
	KBUF_MODE_FREE = 2,
};

enum {
	KERNEL_PARAM_FL_UNSAFE = 1,
	KERNEL_PARAM_FL_HWPARAM = 2,
};

enum {
	KERNEL_PARAM_OPS_FL_NOARG = 1,
};

enum {
	KF_ARG_DYNPTR_ID = 0,
	KF_ARG_LIST_HEAD_ID = 1,
	KF_ARG_LIST_NODE_ID = 2,
	KF_ARG_RB_ROOT_ID = 3,
	KF_ARG_RB_NODE_ID = 4,
	KF_ARG_WORKQUEUE_ID = 5,
	KF_ARG_RES_SPIN_LOCK_ID = 6,
};

enum {
	KPARAM_MEM = 0,
	KPARAM_WIDTH = 1,
	KPARAM_HEIGHT = 2,
	KPARAM_CNT = 3,
};

enum {
	KPARAM_X = 0,
	KPARAM_Y = 1,
	KPARAM_CNT___2 = 2,
};

enum {
	KTW_FREEZABLE = 1,
};

enum {
	KVM_REG_ARM_STD_BIT_TRNG_V1_0 = 0,
	KVM_REG_ARM_STD_BMAP_BIT_COUNT = 1,
};

enum {
	KVM_REG_ARM_STD_HYP_BIT_PV_TIME = 0,
	KVM_REG_ARM_STD_HYP_BMAP_BIT_COUNT = 1,
};

enum {
	KVM_REG_ARM_VENDOR_HYP_BIT_DISCOVER_IMPL_VER = 0,
	KVM_REG_ARM_VENDOR_HYP_BIT_DISCOVER_IMPL_CPUS = 1,
	KVM_REG_ARM_VENDOR_HYP_BMAP_2_BIT_COUNT = 2,
};

enum {
	KVM_REG_ARM_VENDOR_HYP_BIT_FUNC_FEAT = 0,
	KVM_REG_ARM_VENDOR_HYP_BIT_PTP = 1,
	KVM_REG_ARM_VENDOR_HYP_BMAP_BIT_COUNT = 2,
};

enum {
	KYBER_ASYNC_PERCENT = 75,
};

enum {
	KYBER_LATENCY_SHIFT = 2,
	KYBER_GOOD_BUCKETS = 4,
	KYBER_LATENCY_BUCKETS = 8,
};

enum {
	KYBER_READ = 0,
	KYBER_WRITE = 1,
	KYBER_DISCARD = 2,
	KYBER_OTHER = 3,
	KYBER_NUM_DOMAINS = 4,
};

enum {
	KYBER_TOTAL_LATENCY = 0,
	KYBER_IO_LATENCY = 1,
};

enum {
	LANE_0 = 0,
	LANE_1 = 1,
};

enum {
	LAST_NORM = 0,
	LAST_ROOT = 1,
	LAST_DOT = 2,
	LAST_DOTDOT = 3,
};

enum {
	LED_PAR_CTRL_COLX = 0,
	LED_PAR_CTRL_ERROR = 1,
	LED_PAR_CTRL_DUPLEX = 2,
	LED_PAR_CTRL_DP_COL = 3,
	LED_PAR_CTRL_SPEED = 4,
	LED_PAR_CTRL_LINK = 5,
	LED_PAR_CTRL_TX = 6,
	LED_PAR_CTRL_RX = 7,
	LED_PAR_CTRL_ACT = 8,
	LED_PAR_CTRL_LNK_RX = 9,
	LED_PAR_CTRL_LNK_AC = 10,
	LED_PAR_CTRL_ACT_BL = 11,
	LED_PAR_CTRL_TX_BL = 12,
	LED_PAR_CTRL_RX_BL = 13,
	LED_PAR_CTRL_COL_BL = 14,
	LED_PAR_CTRL_INACT = 15,
};

enum {
	LIBATA_MAX_PRD = 128,
	LIBATA_DUMB_MAX_PRD = 64,
	ATA_DEF_QUEUE = 1,
	ATA_MAX_QUEUE = 32,
	ATA_TAG_INTERNAL = 32,
	ATA_SHORT_PAUSE = 16,
	ATAPI_MAX_DRAIN = 16384,
	ATA_ALL_DEVICES = 3,
	ATA_SHT_EMULATED = 1,
	ATA_SHT_THIS_ID = -1,
	ATA_TFLAG_LBA48 = 1,
	ATA_TFLAG_ISADDR = 2,
	ATA_TFLAG_DEVICE = 4,
	ATA_TFLAG_WRITE = 8,
	ATA_TFLAG_LBA = 16,
	ATA_TFLAG_FUA = 32,
	ATA_TFLAG_POLLING = 64,
	ATA_DFLAG_LBA = 1,
	ATA_DFLAG_LBA48 = 2,
	ATA_DFLAG_CDB_INTR = 4,
	ATA_DFLAG_NCQ = 8,
	ATA_DFLAG_FLUSH_EXT = 16,
	ATA_DFLAG_ACPI_PENDING = 32,
	ATA_DFLAG_ACPI_FAILED = 64,
	ATA_DFLAG_AN = 128,
	ATA_DFLAG_TRUSTED = 256,
	ATA_DFLAG_FUA = 512,
	ATA_DFLAG_DMADIR = 1024,
	ATA_DFLAG_NCQ_SEND_RECV = 2048,
	ATA_DFLAG_NCQ_PRIO = 4096,
	ATA_DFLAG_CDL = 8192,
	ATA_DFLAG_CFG_MASK = 16383,
	ATA_DFLAG_PIO = 16384,
	ATA_DFLAG_NCQ_OFF = 32768,
	ATA_DFLAG_SLEEPING = 65536,
	ATA_DFLAG_DUBIOUS_XFER = 131072,
	ATA_DFLAG_NO_UNLOAD = 262144,
	ATA_DFLAG_UNLOCK_HPA = 524288,
	ATA_DFLAG_INIT_MASK = 1048575,
	ATA_DFLAG_NCQ_PRIO_ENABLED = 1048576,
	ATA_DFLAG_CDL_ENABLED = 2097152,
	ATA_DFLAG_RESUMING = 4194304,
	ATA_DFLAG_DETACH = 16777216,
	ATA_DFLAG_DETACHED = 33554432,
	ATA_DFLAG_DA = 67108864,
	ATA_DFLAG_DEVSLP = 134217728,
	ATA_DFLAG_ACPI_DISABLED = 268435456,
	ATA_DFLAG_D_SENSE = 536870912,
	ATA_DFLAG_ZAC = 1073741824,
	ATA_DFLAG_FEATURES_MASK = 201341696,
	ATA_DEV_UNKNOWN = 0,
	ATA_DEV_ATA = 1,
	ATA_DEV_ATA_UNSUP = 2,
	ATA_DEV_ATAPI = 3,
	ATA_DEV_ATAPI_UNSUP = 4,
	ATA_DEV_PMP = 5,
	ATA_DEV_PMP_UNSUP = 6,
	ATA_DEV_SEMB = 7,
	ATA_DEV_SEMB_UNSUP = 8,
	ATA_DEV_ZAC = 9,
	ATA_DEV_ZAC_UNSUP = 10,
	ATA_DEV_NONE = 11,
	ATA_LFLAG_NO_HRST = 2,
	ATA_LFLAG_NO_SRST = 4,
	ATA_LFLAG_ASSUME_ATA = 8,
	ATA_LFLAG_ASSUME_SEMB = 16,
	ATA_LFLAG_ASSUME_CLASS = 24,
	ATA_LFLAG_NO_RETRY = 32,
	ATA_LFLAG_DISABLED = 64,
	ATA_LFLAG_SW_ACTIVITY = 128,
	ATA_LFLAG_NO_LPM = 256,
	ATA_LFLAG_RST_ONCE = 512,
	ATA_LFLAG_CHANGED = 1024,
	ATA_LFLAG_NO_DEBOUNCE_DELAY = 2048,
	ATA_FLAG_SLAVE_POSS = 1,
	ATA_FLAG_SATA = 2,
	ATA_FLAG_NO_LPM = 4,
	ATA_FLAG_NO_LOG_PAGE = 32,
	ATA_FLAG_NO_ATAPI = 64,
	ATA_FLAG_PIO_DMA = 128,
	ATA_FLAG_PIO_LBA48 = 256,
	ATA_FLAG_PIO_POLLING = 512,
	ATA_FLAG_NCQ = 1024,
	ATA_FLAG_NO_POWEROFF_SPINDOWN = 2048,
	ATA_FLAG_NO_HIBERNATE_SPINDOWN = 4096,
	ATA_FLAG_DEBUGMSG = 8192,
	ATA_FLAG_FPDMA_AA = 16384,
	ATA_FLAG_IGN_SIMPLEX = 32768,
	ATA_FLAG_NO_IORDY = 65536,
	ATA_FLAG_ACPI_SATA = 131072,
	ATA_FLAG_AN = 262144,
	ATA_FLAG_PMP = 524288,
	ATA_FLAG_FPDMA_AUX = 1048576,
	ATA_FLAG_EM = 2097152,
	ATA_FLAG_SW_ACTIVITY = 4194304,
	ATA_FLAG_NO_DIPM = 8388608,
	ATA_FLAG_SAS_HOST = 16777216,
	ATA_PFLAG_EH_PENDING = 1,
	ATA_PFLAG_EH_IN_PROGRESS = 2,
	ATA_PFLAG_FROZEN = 4,
	ATA_PFLAG_RECOVERED = 8,
	ATA_PFLAG_LOADING = 16,
	ATA_PFLAG_SCSI_HOTPLUG = 64,
	ATA_PFLAG_INITIALIZING = 128,
	ATA_PFLAG_RESETTING = 256,
	ATA_PFLAG_UNLOADING = 512,
	ATA_PFLAG_UNLOADED = 1024,
	ATA_PFLAG_RESUMING = 65536,
	ATA_PFLAG_SUSPENDED = 131072,
	ATA_PFLAG_PM_PENDING = 262144,
	ATA_PFLAG_INIT_GTM_VALID = 524288,
	ATA_PFLAG_PIO32 = 1048576,
	ATA_PFLAG_PIO32CHANGE = 2097152,
	ATA_PFLAG_EXTERNAL = 4194304,
	ATA_QCFLAG_ACTIVE = 1,
	ATA_QCFLAG_DMAMAP = 2,
	ATA_QCFLAG_RTF_FILLED = 4,
	ATA_QCFLAG_IO = 8,
	ATA_QCFLAG_RESULT_TF = 16,
	ATA_QCFLAG_CLEAR_EXCL = 32,
	ATA_QCFLAG_QUIET = 64,
	ATA_QCFLAG_RETRY = 128,
	ATA_QCFLAG_HAS_CDL = 256,
	ATA_QCFLAG_EH = 65536,
	ATA_QCFLAG_SENSE_VALID = 131072,
	ATA_QCFLAG_EH_SCHEDULED = 262144,
	ATA_QCFLAG_EH_SUCCESS_CMD = 524288,
	ATA_HOST_SIMPLEX = 1,
	ATA_HOST_STARTED = 2,
	ATA_HOST_PARALLEL_SCAN = 4,
	ATA_HOST_IGNORE_ATA = 8,
	ATA_HOST_NO_PART = 16,
	ATA_HOST_NO_SSC = 32,
	ATA_HOST_NO_DEVSLP = 64,
	ATA_TMOUT_INTERNAL_QUICK = 5000,
	ATA_TMOUT_MAX_PARK = 30000,
	ATA_TMOUT_FF_WAIT_LONG = 2000,
	ATA_TMOUT_FF_WAIT = 800,
	ATA_WAIT_AFTER_RESET = 150,
	ATA_TMOUT_PMP_SRST_WAIT = 10000,
	ATA_TMOUT_SPURIOUS_PHY = 10000,
	BUS_UNKNOWN = 0,
	BUS_DMA = 1,
	BUS_IDLE = 2,
	BUS_NOINTR = 3,
	BUS_NODATA = 4,
	BUS_TIMER = 5,
	BUS_PIO = 6,
	BUS_EDD = 7,
	BUS_IDENTIFY = 8,
	BUS_PACKET = 9,
	PORT_UNKNOWN = 0,
	PORT_ENABLED = 1,
	PORT_DISABLED = 2,
	ATA_NR_PIO_MODES = 7,
	ATA_NR_MWDMA_MODES = 5,
	ATA_NR_UDMA_MODES = 8,
	ATA_SHIFT_PIO = 0,
	ATA_SHIFT_MWDMA = 7,
	ATA_SHIFT_UDMA = 12,
	ATA_SHIFT_PRIO = 6,
	ATA_PRIO_HIGH = 2,
	ATA_DMA_PAD_SZ = 4,
	ATA_ERING_SIZE = 32,
	ATA_DEFER_LINK = 1,
	ATA_DEFER_PORT = 2,
	ATA_EH_DESC_LEN = 80,
	ATA_EH_REVALIDATE = 1,
	ATA_EH_SOFTRESET = 2,
	ATA_EH_HARDRESET = 4,
	ATA_EH_RESET = 6,
	ATA_EH_ENABLE_LINK = 8,
	ATA_EH_PARK = 32,
	ATA_EH_GET_SUCCESS_SENSE = 64,
	ATA_EH_SET_ACTIVE = 128,
	ATA_EH_PERDEV_MASK = 225,
	ATA_EH_ALL_ACTIONS = 15,
	ATA_EHI_HOTPLUGGED = 1,
	ATA_EHI_NO_AUTOPSY = 4,
	ATA_EHI_QUIET = 8,
	ATA_EHI_NO_RECOVERY = 16,
	ATA_EHI_DID_SOFTRESET = 65536,
	ATA_EHI_DID_HARDRESET = 131072,
	ATA_EHI_PRINTINFO = 262144,
	ATA_EHI_SETMODE = 524288,
	ATA_EHI_POST_SETMODE = 1048576,
	ATA_EHI_DID_PRINT_QUIRKS = 2097152,
	ATA_EHI_DID_RESET = 196608,
	ATA_EHI_TO_SLAVE_MASK = 12,
	ATA_EH_MAX_TRIES = 5,
	ATA_LINK_RESUME_TRIES = 5,
	ATA_EH_DEV_TRIES = 3,
	ATA_EH_PMP_TRIES = 5,
	ATA_EH_PMP_LINK_TRIES = 3,
	SATA_PMP_RW_TIMEOUT = 3000,
	ATA_EH_CMD_TIMEOUT_TABLE_SIZE = 8,
	ATA_QUIRK_DIAGNOSTIC = 1,
	ATA_QUIRK_NODMA = 2,
	ATA_QUIRK_NONCQ = 4,
	ATA_QUIRK_MAX_SEC_128 = 8,
	ATA_QUIRK_BROKEN_HPA = 16,
	ATA_QUIRK_DISABLE = 32,
	ATA_QUIRK_HPA_SIZE = 64,
	ATA_QUIRK_IVB = 128,
	ATA_QUIRK_STUCK_ERR = 256,
	ATA_QUIRK_BRIDGE_OK = 512,
	ATA_QUIRK_ATAPI_MOD16_DMA = 1024,
	ATA_QUIRK_FIRMWARE_WARN = 2048,
	ATA_QUIRK_1_5_GBPS = 4096,
	ATA_QUIRK_NOSETXFER = 8192,
	ATA_QUIRK_BROKEN_FPDMA_AA = 16384,
	ATA_QUIRK_DUMP_ID = 32768,
	ATA_QUIRK_MAX_SEC_LBA48 = 65536,
	ATA_QUIRK_ATAPI_DMADIR = 131072,
	ATA_QUIRK_NO_NCQ_TRIM = 262144,
	ATA_QUIRK_NOLPM = 524288,
	ATA_QUIRK_WD_BROKEN_LPM = 1048576,
	ATA_QUIRK_ZERO_AFTER_TRIM = 2097152,
	ATA_QUIRK_NO_DMA_LOG = 4194304,
	ATA_QUIRK_NOTRIM = 8388608,
	ATA_QUIRK_MAX_SEC_1024 = 16777216,
	ATA_QUIRK_MAX_TRIM_128M = 33554432,
	ATA_QUIRK_NO_NCQ_ON_ATI = 67108864,
	ATA_QUIRK_NO_LPM_ON_ATI = 134217728,
	ATA_QUIRK_NO_ID_DEV_LOG = 268435456,
	ATA_QUIRK_NO_LOG_DIR = 536870912,
	ATA_QUIRK_NO_FUA = 1073741824,
	ATA_DMA_MASK_ATA = 1,
	ATA_DMA_MASK_ATAPI = 2,
	ATA_DMA_MASK_CFA = 4,
	ATAPI_READ = 0,
	ATAPI_WRITE = 1,
	ATAPI_READ_CD = 2,
	ATAPI_PASS_THRU = 3,
	ATAPI_MISC = 4,
	ATA_TIMING_SETUP = 1,
	ATA_TIMING_ACT8B = 2,
	ATA_TIMING_REC8B = 4,
	ATA_TIMING_CYC8B = 8,
	ATA_TIMING_8BIT = 14,
	ATA_TIMING_ACTIVE = 16,
	ATA_TIMING_RECOVER = 32,
	ATA_TIMING_DMACK_HOLD = 64,
	ATA_TIMING_CYCLE = 128,
	ATA_TIMING_UDMA = 256,
	ATA_TIMING_ALL = 511,
	ATA_ACPI_FILTER_SETXFER = 1,
	ATA_ACPI_FILTER_LOCK = 2,
	ATA_ACPI_FILTER_DIPM = 4,
	ATA_ACPI_FILTER_FPDMA_OFFSET = 8,
	ATA_ACPI_FILTER_FPDMA_AA = 16,
	ATA_ACPI_FILTER_DEFAULT = 7,
};

enum {
	LINKLED_OFF = 1,
	LINKLED_ON = 2,
	LINKLED_LINKSYNC_OFF = 4,
	LINKLED_LINKSYNC_ON = 8,
	LINKLED_BLINK_OFF = 16,
	LINKLED_BLINK_ON = 32,
};

enum {
	LINK_CAPA_10HD = 0,
	LINK_CAPA_10FD = 1,
	LINK_CAPA_100HD = 2,
	LINK_CAPA_100FD = 3,
	LINK_CAPA_1000HD = 4,
	LINK_CAPA_1000FD = 5,
	LINK_CAPA_2500FD = 6,
	LINK_CAPA_5000FD = 7,
	LINK_CAPA_10000FD = 8,
	LINK_CAPA_20000FD = 9,
	LINK_CAPA_25000FD = 10,
	LINK_CAPA_40000FD = 11,
	LINK_CAPA_50000FD = 12,
	LINK_CAPA_56000FD = 13,
	LINK_CAPA_100000FD = 14,
	LINK_CAPA_200000FD = 15,
	LINK_CAPA_400000FD = 16,
	LINK_CAPA_800000FD = 17,
	__LINK_CAPA_MAX = 18,
};

enum {
	LINUX_MIB_NUM = 0,
	LINUX_MIB_SYNCOOKIESSENT = 1,
	LINUX_MIB_SYNCOOKIESRECV = 2,
	LINUX_MIB_SYNCOOKIESFAILED = 3,
	LINUX_MIB_EMBRYONICRSTS = 4,
	LINUX_MIB_PRUNECALLED = 5,
	LINUX_MIB_RCVPRUNED = 6,
	LINUX_MIB_OFOPRUNED = 7,
	LINUX_MIB_OUTOFWINDOWICMPS = 8,
	LINUX_MIB_LOCKDROPPEDICMPS = 9,
	LINUX_MIB_ARPFILTER = 10,
	LINUX_MIB_TIMEWAITED = 11,
	LINUX_MIB_TIMEWAITRECYCLED = 12,
	LINUX_MIB_TIMEWAITKILLED = 13,
	LINUX_MIB_PAWSACTIVEREJECTED = 14,
	LINUX_MIB_PAWSESTABREJECTED = 15,
	LINUX_MIB_TSECRREJECTED = 16,
	LINUX_MIB_PAWS_OLD_ACK = 17,
	LINUX_MIB_PAWS_TW_REJECTED = 18,
	LINUX_MIB_DELAYEDACKS = 19,
	LINUX_MIB_DELAYEDACKLOCKED = 20,
	LINUX_MIB_DELAYEDACKLOST = 21,
	LINUX_MIB_LISTENOVERFLOWS = 22,
	LINUX_MIB_LISTENDROPS = 23,
	LINUX_MIB_TCPHPHITS = 24,
	LINUX_MIB_TCPPUREACKS = 25,
	LINUX_MIB_TCPHPACKS = 26,
	LINUX_MIB_TCPRENORECOVERY = 27,
	LINUX_MIB_TCPSACKRECOVERY = 28,
	LINUX_MIB_TCPSACKRENEGING = 29,
	LINUX_MIB_TCPSACKREORDER = 30,
	LINUX_MIB_TCPRENOREORDER = 31,
	LINUX_MIB_TCPTSREORDER = 32,
	LINUX_MIB_TCPFULLUNDO = 33,
	LINUX_MIB_TCPPARTIALUNDO = 34,
	LINUX_MIB_TCPDSACKUNDO = 35,
	LINUX_MIB_TCPLOSSUNDO = 36,
	LINUX_MIB_TCPLOSTRETRANSMIT = 37,
	LINUX_MIB_TCPRENOFAILURES = 38,
	LINUX_MIB_TCPSACKFAILURES = 39,
	LINUX_MIB_TCPLOSSFAILURES = 40,
	LINUX_MIB_TCPFASTRETRANS = 41,
	LINUX_MIB_TCPSLOWSTARTRETRANS = 42,
	LINUX_MIB_TCPTIMEOUTS = 43,
	LINUX_MIB_TCPLOSSPROBES = 44,
	LINUX_MIB_TCPLOSSPROBERECOVERY = 45,
	LINUX_MIB_TCPRENORECOVERYFAIL = 46,
	LINUX_MIB_TCPSACKRECOVERYFAIL = 47,
	LINUX_MIB_TCPRCVCOLLAPSED = 48,
	LINUX_MIB_TCPDSACKOLDSENT = 49,
	LINUX_MIB_TCPDSACKOFOSENT = 50,
	LINUX_MIB_TCPDSACKRECV = 51,
	LINUX_MIB_TCPDSACKOFORECV = 52,
	LINUX_MIB_TCPABORTONDATA = 53,
	LINUX_MIB_TCPABORTONCLOSE = 54,
	LINUX_MIB_TCPABORTONMEMORY = 55,
	LINUX_MIB_TCPABORTONTIMEOUT = 56,
	LINUX_MIB_TCPABORTONLINGER = 57,
	LINUX_MIB_TCPABORTFAILED = 58,
	LINUX_MIB_TCPMEMORYPRESSURES = 59,
	LINUX_MIB_TCPMEMORYPRESSURESCHRONO = 60,
	LINUX_MIB_TCPSACKDISCARD = 61,
	LINUX_MIB_TCPDSACKIGNOREDOLD = 62,
	LINUX_MIB_TCPDSACKIGNOREDNOUNDO = 63,
	LINUX_MIB_TCPSPURIOUSRTOS = 64,
	LINUX_MIB_TCPMD5NOTFOUND = 65,
	LINUX_MIB_TCPMD5UNEXPECTED = 66,
	LINUX_MIB_TCPMD5FAILURE = 67,
	LINUX_MIB_SACKSHIFTED = 68,
	LINUX_MIB_SACKMERGED = 69,
	LINUX_MIB_SACKSHIFTFALLBACK = 70,
	LINUX_MIB_TCPBACKLOGDROP = 71,
	LINUX_MIB_PFMEMALLOCDROP = 72,
	LINUX_MIB_TCPMINTTLDROP = 73,
	LINUX_MIB_TCPDEFERACCEPTDROP = 74,
	LINUX_MIB_IPRPFILTER = 75,
	LINUX_MIB_TCPTIMEWAITOVERFLOW = 76,
	LINUX_MIB_TCPREQQFULLDOCOOKIES = 77,
	LINUX_MIB_TCPREQQFULLDROP = 78,
	LINUX_MIB_TCPRETRANSFAIL = 79,
	LINUX_MIB_TCPRCVCOALESCE = 80,
	LINUX_MIB_TCPBACKLOGCOALESCE = 81,
	LINUX_MIB_TCPOFOQUEUE = 82,
	LINUX_MIB_TCPOFODROP = 83,
	LINUX_MIB_TCPOFOMERGE = 84,
	LINUX_MIB_TCPCHALLENGEACK = 85,
	LINUX_MIB_TCPSYNCHALLENGE = 86,
	LINUX_MIB_TCPFASTOPENACTIVE = 87,
	LINUX_MIB_TCPFASTOPENACTIVEFAIL = 88,
	LINUX_MIB_TCPFASTOPENPASSIVE = 89,
	LINUX_MIB_TCPFASTOPENPASSIVEFAIL = 90,
	LINUX_MIB_TCPFASTOPENLISTENOVERFLOW = 91,
	LINUX_MIB_TCPFASTOPENCOOKIEREQD = 92,
	LINUX_MIB_TCPFASTOPENBLACKHOLE = 93,
	LINUX_MIB_TCPSPURIOUS_RTX_HOSTQUEUES = 94,
	LINUX_MIB_BUSYPOLLRXPACKETS = 95,
	LINUX_MIB_TCPAUTOCORKING = 96,
	LINUX_MIB_TCPFROMZEROWINDOWADV = 97,
	LINUX_MIB_TCPTOZEROWINDOWADV = 98,
	LINUX_MIB_TCPWANTZEROWINDOWADV = 99,
	LINUX_MIB_TCPSYNRETRANS = 100,
	LINUX_MIB_TCPORIGDATASENT = 101,
	LINUX_MIB_TCPHYSTARTTRAINDETECT = 102,
	LINUX_MIB_TCPHYSTARTTRAINCWND = 103,
	LINUX_MIB_TCPHYSTARTDELAYDETECT = 104,
	LINUX_MIB_TCPHYSTARTDELAYCWND = 105,
	LINUX_MIB_TCPACKSKIPPEDSYNRECV = 106,
	LINUX_MIB_TCPACKSKIPPEDPAWS = 107,
	LINUX_MIB_TCPACKSKIPPEDSEQ = 108,
	LINUX_MIB_TCPACKSKIPPEDFINWAIT2 = 109,
	LINUX_MIB_TCPACKSKIPPEDTIMEWAIT = 110,
	LINUX_MIB_TCPACKSKIPPEDCHALLENGE = 111,
	LINUX_MIB_TCPWINPROBE = 112,
	LINUX_MIB_TCPKEEPALIVE = 113,
	LINUX_MIB_TCPMTUPFAIL = 114,
	LINUX_MIB_TCPMTUPSUCCESS = 115,
	LINUX_MIB_TCPDELIVERED = 116,
	LINUX_MIB_TCPDELIVEREDCE = 117,
	LINUX_MIB_TCPACKCOMPRESSED = 118,
	LINUX_MIB_TCPZEROWINDOWDROP = 119,
	LINUX_MIB_TCPRCVQDROP = 120,
	LINUX_MIB_TCPWQUEUETOOBIG = 121,
	LINUX_MIB_TCPFASTOPENPASSIVEALTKEY = 122,
	LINUX_MIB_TCPTIMEOUTREHASH = 123,
	LINUX_MIB_TCPDUPLICATEDATAREHASH = 124,
	LINUX_MIB_TCPDSACKRECVSEGS = 125,
	LINUX_MIB_TCPDSACKIGNOREDDUBIOUS = 126,
	LINUX_MIB_TCPMIGRATEREQSUCCESS = 127,
	LINUX_MIB_TCPMIGRATEREQFAILURE = 128,
	LINUX_MIB_TCPPLBREHASH = 129,
	LINUX_MIB_TCPAOREQUIRED = 130,
	LINUX_MIB_TCPAOBAD = 131,
	LINUX_MIB_TCPAOKEYNOTFOUND = 132,
	LINUX_MIB_TCPAOGOOD = 133,
	LINUX_MIB_TCPAODROPPEDICMPS = 134,
	__LINUX_MIB_MAX = 135,
};

enum {
	LINUX_MIB_TLSNUM = 0,
	LINUX_MIB_TLSCURRTXSW = 1,
	LINUX_MIB_TLSCURRRXSW = 2,
	LINUX_MIB_TLSCURRTXDEVICE = 3,
	LINUX_MIB_TLSCURRRXDEVICE = 4,
	LINUX_MIB_TLSTXSW = 5,
	LINUX_MIB_TLSRXSW = 6,
	LINUX_MIB_TLSTXDEVICE = 7,
	LINUX_MIB_TLSRXDEVICE = 8,
	LINUX_MIB_TLSDECRYPTERROR = 9,
	LINUX_MIB_TLSRXDEVICERESYNC = 10,
	LINUX_MIB_TLSDECRYPTRETRY = 11,
	LINUX_MIB_TLSRXNOPADVIOL = 12,
	LINUX_MIB_TLSRXREKEYOK = 13,
	LINUX_MIB_TLSRXREKEYERROR = 14,
	LINUX_MIB_TLSTXREKEYOK = 15,
	LINUX_MIB_TLSTXREKEYERROR = 16,
	LINUX_MIB_TLSRXREKEYRECEIVED = 17,
	__LINUX_MIB_TLSMAX = 18,
};

enum {
	LINUX_MIB_XFRMNUM = 0,
	LINUX_MIB_XFRMINERROR = 1,
	LINUX_MIB_XFRMINBUFFERERROR = 2,
	LINUX_MIB_XFRMINHDRERROR = 3,
	LINUX_MIB_XFRMINNOSTATES = 4,
	LINUX_MIB_XFRMINSTATEPROTOERROR = 5,
	LINUX_MIB_XFRMINSTATEMODEERROR = 6,
	LINUX_MIB_XFRMINSTATESEQERROR = 7,
	LINUX_MIB_XFRMINSTATEEXPIRED = 8,
	LINUX_MIB_XFRMINSTATEMISMATCH = 9,
	LINUX_MIB_XFRMINSTATEINVALID = 10,
	LINUX_MIB_XFRMINTMPLMISMATCH = 11,
	LINUX_MIB_XFRMINNOPOLS = 12,
	LINUX_MIB_XFRMINPOLBLOCK = 13,
	LINUX_MIB_XFRMINPOLERROR = 14,
	LINUX_MIB_XFRMOUTERROR = 15,
	LINUX_MIB_XFRMOUTBUNDLEGENERROR = 16,
	LINUX_MIB_XFRMOUTBUNDLECHECKERROR = 17,
	LINUX_MIB_XFRMOUTNOSTATES = 18,
	LINUX_MIB_XFRMOUTSTATEPROTOERROR = 19,
	LINUX_MIB_XFRMOUTSTATEMODEERROR = 20,
	LINUX_MIB_XFRMOUTSTATESEQERROR = 21,
	LINUX_MIB_XFRMOUTSTATEEXPIRED = 22,
	LINUX_MIB_XFRMOUTPOLBLOCK = 23,
	LINUX_MIB_XFRMOUTPOLDEAD = 24,
	LINUX_MIB_XFRMOUTPOLERROR = 25,
	LINUX_MIB_XFRMFWDHDRERROR = 26,
	LINUX_MIB_XFRMOUTSTATEINVALID = 27,
	LINUX_MIB_XFRMACQUIREERROR = 28,
	LINUX_MIB_XFRMOUTSTATEDIRERROR = 29,
	LINUX_MIB_XFRMINSTATEDIRERROR = 30,
	LINUX_MIB_XFRMINIPTFSERROR = 31,
	LINUX_MIB_XFRMOUTNOQSPACE = 32,
	__LINUX_MIB_XFRMMAX = 33,
};

enum {
	LK_STATE_IN_USE = 0,
	NFS_DELEGATED_STATE = 1,
	NFS_OPEN_STATE = 2,
	NFS_O_RDONLY_STATE = 3,
	NFS_O_WRONLY_STATE = 4,
	NFS_O_RDWR_STATE = 5,
	NFS_STATE_RECLAIM_REBOOT = 6,
	NFS_STATE_RECLAIM_NOGRACE = 7,
	NFS_STATE_POSIX_LOCKS = 8,
	NFS_STATE_RECOVERY_FAILED = 9,
	NFS_STATE_MAY_NOTIFY_LOCK = 10,
	NFS_STATE_CHANGE_WAIT = 11,
	NFS_CLNT_DST_SSC_COPY_STATE = 12,
	NFS_CLNT_SRC_SSC_COPY_STATE = 13,
	NFS_SRV_SSC_COPY_STATE = 14,
};

enum {
	LNK_SYNC_INI = 3120,
	LNK_SYNC_VAL = 3124,
	LNK_SYNC_CTRL = 3128,
	LNK_SYNC_TST = 3129,
	LNK_LED_REG = 3132,
	RX_GMF_EA = 3136,
	RX_GMF_AF_THR = 3140,
	RX_GMF_CTRL_T = 3144,
	RX_GMF_FL_MSK = 3148,
	RX_GMF_FL_THR = 3152,
	RX_GMF_FL_CTRL = 3154,
	RX_GMF_TR_THR = 3156,
	RX_GMF_UP_THR = 3160,
	RX_GMF_LP_THR = 3162,
	RX_GMF_VLAN = 3164,
	RX_GMF_WP = 3168,
	RX_GMF_WLEV = 3176,
	RX_GMF_RP = 3184,
	RX_GMF_RLEV = 3192,
};

enum {
	LOCKD_A_SERVER_GRACETIME = 1,
	LOCKD_A_SERVER_TCP_PORT = 2,
	LOCKD_A_SERVER_UDP_PORT = 3,
	__LOCKD_A_SERVER_MAX = 4,
	LOCKD_A_SERVER_MAX = 3,
};

enum {
	LOCKD_CMD_SERVER_SET = 1,
	LOCKD_CMD_SERVER_GET = 2,
	__LOCKD_CMD_MAX = 3,
	LOCKD_CMD_MAX = 2,
};

enum {
	LOGIC_PIO_INDIRECT = 0,
	LOGIC_PIO_CPU_MMIO = 1,
};

enum {
	LO_FLAGS_READ_ONLY = 1,
	LO_FLAGS_AUTOCLEAR = 4,
	LO_FLAGS_PARTSCAN = 8,
	LO_FLAGS_DIRECT_IO = 16,
};

enum {
	LS1021A = 0,
	LS1012A = 1,
	LS1028A = 2,
	LS1043A = 3,
	LS1046A = 4,
	LS2080A = 5,
	LS2085A = 6,
	LX2160A = 7,
	MCF5441X = 8,
	VF610 = 9,
};

enum {
	LTSSM_DETECT_QUIET = 0,
	LTSSM_DETECT_ACTIVE = 1,
	LTSSM_POLLING_ACTIVE = 2,
	LTSSM_POLLING_COMPLIANCE = 3,
	LTSSM_POLLING_CONFIGURATION = 4,
	LTSSM_CONFIG_LINKWIDTH_START = 5,
	LTSSM_CONFIG_LINKWIDTH_ACCEPT = 6,
	LTSSM_CONFIG_LANENUM_ACCEPT = 7,
	LTSSM_CONFIG_LANENUM_WAIT = 8,
	LTSSM_CONFIG_COMPLETE = 9,
	LTSSM_CONFIG_IDLE = 10,
	LTSSM_RECOVERY_RCVR_LOCK = 11,
	LTSSM_RECOVERY_SPEED = 12,
	LTSSM_RECOVERY_RCVR_CFG = 13,
	LTSSM_RECOVERY_IDLE = 14,
	LTSSM_L0 = 16,
	LTSSM_RX_L0S_ENTRY = 17,
	LTSSM_RX_L0S_IDLE = 18,
	LTSSM_RX_L0S_FTS = 19,
	LTSSM_TX_L0S_ENTRY = 20,
	LTSSM_TX_L0S_IDLE = 21,
	LTSSM_TX_L0S_FTS = 22,
	LTSSM_L1_ENTRY = 23,
	LTSSM_L1_IDLE = 24,
	LTSSM_L2_IDLE = 25,
	LTSSM_L2_TRANSMIT_WAKE = 26,
	LTSSM_DISABLED = 32,
	LTSSM_LOOPBACK_ENTRY_MASTER = 33,
	LTSSM_LOOPBACK_ACTIVE_MASTER = 34,
	LTSSM_LOOPBACK_EXIT_MASTER = 35,
	LTSSM_LOOPBACK_ENTRY_SLAVE = 36,
	LTSSM_LOOPBACK_ACTIVE_SLAVE = 37,
	LTSSM_LOOPBACK_EXIT_SLAVE = 38,
	LTSSM_HOT_RESET = 39,
	LTSSM_RECOVERY_EQUALIZATION_PHASE0 = 40,
	LTSSM_RECOVERY_EQUALIZATION_PHASE1 = 41,
	LTSSM_RECOVERY_EQUALIZATION_PHASE2 = 42,
	LTSSM_RECOVERY_EQUALIZATION_PHASE3 = 43,
};

enum {
	LWTUNNEL_IP_OPTS_UNSPEC = 0,
	LWTUNNEL_IP_OPTS_GENEVE = 1,
	LWTUNNEL_IP_OPTS_VXLAN = 2,
	LWTUNNEL_IP_OPTS_ERSPAN = 3,
	__LWTUNNEL_IP_OPTS_MAX = 4,
};

enum {
	LWTUNNEL_IP_OPT_ERSPAN_UNSPEC = 0,
	LWTUNNEL_IP_OPT_ERSPAN_VER = 1,
	LWTUNNEL_IP_OPT_ERSPAN_INDEX = 2,
	LWTUNNEL_IP_OPT_ERSPAN_DIR = 3,
	LWTUNNEL_IP_OPT_ERSPAN_HWID = 4,
	__LWTUNNEL_IP_OPT_ERSPAN_MAX = 5,
};

enum {
	LWTUNNEL_IP_OPT_GENEVE_UNSPEC = 0,
	LWTUNNEL_IP_OPT_GENEVE_CLASS = 1,
	LWTUNNEL_IP_OPT_GENEVE_TYPE = 2,
	LWTUNNEL_IP_OPT_GENEVE_DATA = 3,
	__LWTUNNEL_IP_OPT_GENEVE_MAX = 4,
};

enum {
	LWTUNNEL_IP_OPT_VXLAN_UNSPEC = 0,
	LWTUNNEL_IP_OPT_VXLAN_GBP = 1,
	__LWTUNNEL_IP_OPT_VXLAN_MAX = 2,
};

enum {
	LWTUNNEL_XMIT_DONE = 0,
	LWTUNNEL_XMIT_CONTINUE = 256,
};

enum {
	Lo_unbound = 0,
	Lo_bound = 1,
	Lo_rundown = 2,
	Lo_deleting = 3,
};

enum {
	MAC_TX_CLK_0_MHZ = 2,
	MAC_TX_CLK_2_5_MHZ = 6,
	MAC_TX_CLK_25_MHZ = 7,
};

enum {
	MAGNITUDE_STRONG = 2,
	MAGNITUDE_WEAK = 3,
	MAGNITUDE_NUM = 4,
};

enum {
	MASK_EE_STATUS = 65535,
	MASK_EE_DYNCAP_EVENT = 1,
	MASK_EE_SYSPOOL_EVENT = 2,
	MASK_EE_URGENT_BKOPS = 4,
	MASK_EE_TOO_HIGH_TEMP = 8,
	MASK_EE_TOO_LOW_TEMP = 16,
	MASK_EE_WRITEBOOSTER_EVENT = 32,
	MASK_EE_PERFORMANCE_THROTTLING = 64,
	MASK_EE_DEV_LVL_EXCEPTION = 128,
	MASK_EE_HEALTH_CRITICAL = 512,
};

enum {
	MASK_OCS = 15,
};

enum {
	MASK_TM_SERVICE_RESP = 255,
};

enum {
	MASK_TRANSFER_REQUESTS_SLOTS_SDB = 31,
	MASK_TRANSFER_REQUESTS_SLOTS_MCQ = 255,
	MASK_NUMBER_OUTSTANDING_RTT = 65280,
	MASK_TASK_MANAGEMENT_REQUEST_SLOTS = 458752,
	MASK_EHSLUTRD_SUPPORTED = 4194304,
	MASK_AUTO_HIBERN8_SUPPORT = 8388608,
	MASK_64_ADDRESSING_SUPPORT = 16777216,
	MASK_OUT_OF_ORDER_DATA_DELIVERY_SUPPORT = 33554432,
	MASK_UIC_DME_TEST_MODE_SUPPORT = 67108864,
	MASK_CRYPTO_SUPPORT = 268435456,
	MASK_LSDB_SUPPORT = 536870912,
	MASK_MCQ_SUPPORT = 1073741824,
};

enum {
	MATCH_MTR = 0,
	MATCH_MEQ = 1,
	MATCH_MLE = 2,
	MATCH_MLT = 3,
	MATCH_MGE = 4,
	MATCH_MGT = 5,
};

enum {
	MAX7319 = 0,
	MAX7320 = 1,
	MAX7321 = 2,
	MAX7322 = 3,
	MAX7323 = 4,
	MAX7324 = 5,
	MAX7325 = 6,
	MAX7326 = 7,
	MAX7327 = 8,
};

enum {
	MAX77620_GPIO0 = 0,
	MAX77620_GPIO1 = 1,
	MAX77620_GPIO2 = 2,
	MAX77620_GPIO3 = 3,
	MAX77620_GPIO4 = 4,
	MAX77620_GPIO5 = 5,
	MAX77620_GPIO6 = 6,
	MAX77620_GPIO7 = 7,
	MAX77620_GPIO_NR = 8,
};

enum {
	MAX77620_IRQ_TOP_GLBL = 0,
	MAX77620_IRQ_TOP_SD = 1,
	MAX77620_IRQ_TOP_LDO = 2,
	MAX77620_IRQ_TOP_GPIO = 3,
	MAX77620_IRQ_TOP_RTC = 4,
	MAX77620_IRQ_TOP_32K = 5,
	MAX77620_IRQ_TOP_ONOFF = 6,
	MAX77620_IRQ_LBT_MBATLOW = 7,
	MAX77620_IRQ_LBT_TJALRM1 = 8,
	MAX77620_IRQ_LBT_TJALRM2 = 9,
};

enum {
	MAX_IORES_LEVEL = 5,
};

enum {
	MAX_OPT_ARGS = 3,
};

enum {
	MBE_REFERENCED_B = 0,
	MBE_REUSABLE_B = 1,
};

enum {
	MB_INODE_PA = 0,
	MB_GROUP_PA = 1,
};

enum {
	MCT_INT_SPI = 0,
	MCT_INT_PPI = 1,
};

enum {
	MDBA_GET_ENTRY_UNSPEC = 0,
	MDBA_GET_ENTRY = 1,
	MDBA_GET_ENTRY_ATTRS = 2,
	__MDBA_GET_ENTRY_MAX = 3,
};

enum {
	MDBA_SET_ENTRY_UNSPEC = 0,
	MDBA_SET_ENTRY = 1,
	MDBA_SET_ENTRY_ATTRS = 2,
	__MDBA_SET_ENTRY_MAX = 3,
};

enum {
	MEGASAS_HBA_OPERATIONAL = 0,
	MEGASAS_ADPRESET_SM_INFAULT = 1,
	MEGASAS_ADPRESET_SM_FW_RESET_SUCCESS = 2,
	MEGASAS_ADPRESET_SM_OPERATIONAL = 3,
	MEGASAS_HW_CRITICAL_ERROR = 4,
	MEGASAS_ADPRESET_SM_POLLING = 5,
	MEGASAS_ADPRESET_INPROG_SIGN = 3735936685,
};

enum {
	MEMBARRIER_FLAG_SYNC_CORE = 1,
	MEMBARRIER_FLAG_RSEQ = 2,
};

enum {
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_READY = 1,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED = 2,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED_READY = 4,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED = 8,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE_READY = 16,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE = 32,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ_READY = 64,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ = 128,
};

enum {
	MEMMAP_ON_MEMORY_DISABLE = 0,
	MEMMAP_ON_MEMORY_ENABLE = 1,
	MEMMAP_ON_MEMORY_FORCE = 2,
};

enum {
	MEMORY_RECLAIM_SWAPPINESS = 0,
	MEMORY_RECLAIM_SWAPPINESS_MAX = 1,
	MEMORY_RECLAIM_NULL = 2,
};

enum {
	MEMREMAP_WB = 1,
	MEMREMAP_WT = 2,
	MEMREMAP_WC = 4,
	MEMREMAP_ENC = 8,
	MEMREMAP_DEC = 16,
};

enum {
	MICRON_ON_DIE_UNSUPPORTED = 0,
	MICRON_ON_DIE_SUPPORTED = 1,
	MICRON_ON_DIE_MANDATORY = 2,
};

enum {
	MIIM_CMD_IDLE = 0,
	MIIM_CMD_LEGACY_WRITE = 1,
	MIIM_CMD_LEGACY_READ = 2,
};

enum {
	MIPI_DCS_NOP = 0,
	MIPI_DCS_SOFT_RESET = 1,
	MIPI_DCS_GET_COMPRESSION_MODE = 3,
	MIPI_DCS_GET_DISPLAY_ID = 4,
	MIPI_DCS_GET_ERROR_COUNT_ON_DSI = 5,
	MIPI_DCS_GET_RED_CHANNEL = 6,
	MIPI_DCS_GET_GREEN_CHANNEL = 7,
	MIPI_DCS_GET_BLUE_CHANNEL = 8,
	MIPI_DCS_GET_DISPLAY_STATUS = 9,
	MIPI_DCS_GET_POWER_MODE = 10,
	MIPI_DCS_GET_ADDRESS_MODE = 11,
	MIPI_DCS_GET_PIXEL_FORMAT = 12,
	MIPI_DCS_GET_DISPLAY_MODE = 13,
	MIPI_DCS_GET_SIGNAL_MODE = 14,
	MIPI_DCS_GET_DIAGNOSTIC_RESULT = 15,
	MIPI_DCS_ENTER_SLEEP_MODE = 16,
	MIPI_DCS_EXIT_SLEEP_MODE = 17,
	MIPI_DCS_ENTER_PARTIAL_MODE = 18,
	MIPI_DCS_ENTER_NORMAL_MODE = 19,
	MIPI_DCS_GET_IMAGE_CHECKSUM_RGB = 20,
	MIPI_DCS_GET_IMAGE_CHECKSUM_CT = 21,
	MIPI_DCS_EXIT_INVERT_MODE = 32,
	MIPI_DCS_ENTER_INVERT_MODE = 33,
	MIPI_DCS_SET_GAMMA_CURVE = 38,
	MIPI_DCS_SET_DISPLAY_OFF = 40,
	MIPI_DCS_SET_DISPLAY_ON = 41,
	MIPI_DCS_SET_COLUMN_ADDRESS = 42,
	MIPI_DCS_SET_PAGE_ADDRESS = 43,
	MIPI_DCS_WRITE_MEMORY_START = 44,
	MIPI_DCS_WRITE_LUT = 45,
	MIPI_DCS_READ_MEMORY_START = 46,
	MIPI_DCS_SET_PARTIAL_ROWS = 48,
	MIPI_DCS_SET_PARTIAL_COLUMNS = 49,
	MIPI_DCS_SET_SCROLL_AREA = 51,
	MIPI_DCS_SET_TEAR_OFF = 52,
	MIPI_DCS_SET_TEAR_ON = 53,
	MIPI_DCS_SET_ADDRESS_MODE = 54,
	MIPI_DCS_SET_SCROLL_START = 55,
	MIPI_DCS_EXIT_IDLE_MODE = 56,
	MIPI_DCS_ENTER_IDLE_MODE = 57,
	MIPI_DCS_SET_PIXEL_FORMAT = 58,
	MIPI_DCS_WRITE_MEMORY_CONTINUE = 60,
	MIPI_DCS_SET_3D_CONTROL = 61,
	MIPI_DCS_READ_MEMORY_CONTINUE = 62,
	MIPI_DCS_GET_3D_CONTROL = 63,
	MIPI_DCS_SET_VSYNC_TIMING = 64,
	MIPI_DCS_SET_TEAR_SCANLINE = 68,
	MIPI_DCS_GET_SCANLINE = 69,
	MIPI_DCS_SET_DISPLAY_BRIGHTNESS = 81,
	MIPI_DCS_GET_DISPLAY_BRIGHTNESS = 82,
	MIPI_DCS_WRITE_CONTROL_DISPLAY = 83,
	MIPI_DCS_GET_CONTROL_DISPLAY = 84,
	MIPI_DCS_WRITE_POWER_SAVE = 85,
	MIPI_DCS_GET_POWER_SAVE = 86,
	MIPI_DCS_SET_CABC_MIN_BRIGHTNESS = 94,
	MIPI_DCS_GET_CABC_MIN_BRIGHTNESS = 95,
	MIPI_DCS_READ_DDB_START = 161,
	MIPI_DCS_READ_PPS_START = 162,
	MIPI_DCS_READ_DDB_CONTINUE = 168,
	MIPI_DCS_READ_PPS_CONTINUE = 169,
};

enum {
	MIPI_DSI_V_SYNC_START = 1,
	MIPI_DSI_V_SYNC_END = 17,
	MIPI_DSI_H_SYNC_START = 33,
	MIPI_DSI_H_SYNC_END = 49,
	MIPI_DSI_COMPRESSION_MODE = 7,
	MIPI_DSI_END_OF_TRANSMISSION = 8,
	MIPI_DSI_COLOR_MODE_OFF = 2,
	MIPI_DSI_COLOR_MODE_ON = 18,
	MIPI_DSI_SHUTDOWN_PERIPHERAL = 34,
	MIPI_DSI_TURN_ON_PERIPHERAL = 50,
	MIPI_DSI_GENERIC_SHORT_WRITE_0_PARAM = 3,
	MIPI_DSI_GENERIC_SHORT_WRITE_1_PARAM = 19,
	MIPI_DSI_GENERIC_SHORT_WRITE_2_PARAM = 35,
	MIPI_DSI_GENERIC_READ_REQUEST_0_PARAM = 4,
	MIPI_DSI_GENERIC_READ_REQUEST_1_PARAM = 20,
	MIPI_DSI_GENERIC_READ_REQUEST_2_PARAM = 36,
	MIPI_DSI_DCS_SHORT_WRITE = 5,
	MIPI_DSI_DCS_SHORT_WRITE_PARAM = 21,
	MIPI_DSI_DCS_READ = 6,
	MIPI_DSI_EXECUTE_QUEUE = 22,
	MIPI_DSI_SET_MAXIMUM_RETURN_PACKET_SIZE = 55,
	MIPI_DSI_NULL_PACKET = 9,
	MIPI_DSI_BLANKING_PACKET = 25,
	MIPI_DSI_GENERIC_LONG_WRITE = 41,
	MIPI_DSI_DCS_LONG_WRITE = 57,
	MIPI_DSI_PICTURE_PARAMETER_SET = 10,
	MIPI_DSI_COMPRESSED_PIXEL_STREAM = 11,
	MIPI_DSI_LOOSELY_PACKED_PIXEL_STREAM_YCBCR20 = 12,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR24 = 28,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR16 = 44,
	MIPI_DSI_PACKED_PIXEL_STREAM_30 = 13,
	MIPI_DSI_PACKED_PIXEL_STREAM_36 = 29,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR12 = 61,
	MIPI_DSI_PACKED_PIXEL_STREAM_16 = 14,
	MIPI_DSI_PACKED_PIXEL_STREAM_18 = 30,
	MIPI_DSI_PIXEL_STREAM_3BYTE_18 = 46,
	MIPI_DSI_PACKED_PIXEL_STREAM_24 = 62,
};

enum {
	MIX_INFLIGHT = 2147483648,
};

enum {
	MLO_PAUSE_NONE = 0,
	MLO_PAUSE_RX = 1,
	MLO_PAUSE_TX = 2,
	MLO_PAUSE_TXRX_MASK = 3,
	MLO_PAUSE_AN = 4,
	MLO_AN_PHY = 0,
	MLO_AN_FIXED = 1,
	MLO_AN_INBAND = 2,
	PHYLINK_PCS_NEG_NONE = 0,
	PHYLINK_PCS_NEG_ENABLED = 16,
	PHYLINK_PCS_NEG_OUTBAND = 32,
	PHYLINK_PCS_NEG_INBAND = 64,
	PHYLINK_PCS_NEG_INBAND_DISABLED = 64,
	PHYLINK_PCS_NEG_INBAND_ENABLED = 80,
	MAC_SYM_PAUSE = 1,
	MAC_ASYM_PAUSE = 2,
	MAC_10HD = 4,
	MAC_10FD = 8,
	MAC_10 = 12,
	MAC_100HD = 16,
	MAC_100FD = 32,
	MAC_100 = 48,
	MAC_1000HD = 64,
	MAC_1000FD = 128,
	MAC_1000 = 192,
	MAC_2500FD = 256,
	MAC_5000FD = 512,
	MAC_10000FD = 1024,
	MAC_20000FD = 2048,
	MAC_25000FD = 4096,
	MAC_40000FD = 8192,
	MAC_50000FD = 16384,
	MAC_56000FD = 32768,
	MAC_100000FD = 65536,
	MAC_200000FD = 131072,
	MAC_400000FD = 262144,
};

enum {
	MMOP_OFFLINE = 0,
	MMOP_ONLINE = 1,
	MMOP_ONLINE_KERNEL = 2,
	MMOP_ONLINE_MOVABLE = 3,
};

enum {
	MM_FILEPAGES = 0,
	MM_ANONPAGES = 1,
	MM_SWAPENTS = 2,
	MM_SHMEMPAGES = 3,
	NR_MM_COUNTERS = 4,
};

enum {
	MOUNTPROC3_NULL = 0,
	MOUNTPROC3_MNT = 1,
	MOUNTPROC3_DUMP = 2,
	MOUNTPROC3_UMNT = 3,
	MOUNTPROC3_UMNTALL = 4,
	MOUNTPROC3_EXPORT = 5,
};

enum {
	MOUNTPROC_NULL = 0,
	MOUNTPROC_MNT = 1,
	MOUNTPROC_DUMP = 2,
	MOUNTPROC_UMNT = 3,
	MOUNTPROC_UMNTALL = 4,
	MOUNTPROC_EXPORT = 5,
};

enum {
	MOXA_SUPP_RS232 = 1,
	MOXA_SUPP_RS422 = 2,
	MOXA_SUPP_RS485 = 4,
};

enum {
	MPOL_DEFAULT = 0,
	MPOL_PREFERRED = 1,
	MPOL_BIND = 2,
	MPOL_INTERLEAVE = 3,
	MPOL_LOCAL = 4,
	MPOL_PREFERRED_MANY = 5,
	MPOL_WEIGHTED_INTERLEAVE = 6,
	MPOL_MAX = 7,
};

enum {
	MSI_CHIP_FLAG_SET_EOI = 1,
	MSI_CHIP_FLAG_SET_ACK = 2,
};

enum {
	MSI_FLAG_USE_DEF_DOM_OPS = 1,
	MSI_FLAG_USE_DEF_CHIP_OPS = 2,
	MSI_FLAG_ACTIVATE_EARLY = 4,
	MSI_FLAG_MUST_REACTIVATE = 8,
	MSI_FLAG_DEV_SYSFS = 16,
	MSI_FLAG_ALLOC_SIMPLE_MSI_DESCS = 32,
	MSI_FLAG_FREE_MSI_DESCS = 64,
	MSI_FLAG_USE_DEV_FWNODE = 128,
	MSI_FLAG_PARENT_PM_DEV = 256,
	MSI_FLAG_PCI_MSI_MASK_PARENT = 512,
	MSI_GENERIC_FLAGS_MASK = 65535,
	MSI_DOMAIN_FLAGS_MASK = 4294901760,
	MSI_FLAG_MULTI_PCI_MSI = 65536,
	MSI_FLAG_PCI_MSIX = 131072,
	MSI_FLAG_LEVEL_CAPABLE = 262144,
	MSI_FLAG_MSIX_CONTIGUOUS = 524288,
	MSI_FLAG_PCI_MSIX_ALLOC_DYN = 1048576,
	MSI_FLAG_NO_AFFINITY = 2097152,
	MSI_FLAG_NO_MASK = 4194304,
};

enum {
	MSPI_DONE = 1,
	BSPI_DONE = 2,
	BSPI_ERR = 4,
	MSPI_BSPI_DONE = 7,
};

enum {
	MT6357_ID_VCORE = 0,
	MT6357_ID_VMODEM = 1,
	MT6357_ID_VPA = 2,
	MT6357_ID_VPROC = 3,
	MT6357_ID_VS1 = 4,
	MT6357_ID_VAUX18 = 5,
	MT6357_ID_VAUD28 = 6,
	MT6357_ID_VCAMA = 7,
	MT6357_ID_VCAMD = 8,
	MT6357_ID_VCAMIO = 9,
	MT6357_ID_VCN18 = 10,
	MT6357_ID_VCN28 = 11,
	MT6357_ID_VCN33_BT = 12,
	MT6357_ID_VCN33_WIFI = 13,
	MT6357_ID_VDRAM = 14,
	MT6357_ID_VEFUSE = 15,
	MT6357_ID_VEMC = 16,
	MT6357_ID_VFE28 = 17,
	MT6357_ID_VIBR = 18,
	MT6357_ID_VIO18 = 19,
	MT6357_ID_VIO28 = 20,
	MT6357_ID_VLDO28 = 21,
	MT6357_ID_VMC = 22,
	MT6357_ID_VMCH = 23,
	MT6357_ID_VRF12 = 24,
	MT6357_ID_VRF18 = 25,
	MT6357_ID_VSIM1 = 26,
	MT6357_ID_VSIM2 = 27,
	MT6357_ID_VSRAM_OTHERS = 28,
	MT6357_ID_VSRAM_PROC = 29,
	MT6357_ID_VUSB33 = 30,
	MT6357_ID_VXO22 = 31,
	MT6357_ID_RG_MAX = 32,
};

enum {
	MT6358_ID_VDRAM1 = 0,
	MT6358_ID_VCORE = 1,
	MT6358_ID_VPA = 2,
	MT6358_ID_VPROC11 = 3,
	MT6358_ID_VPROC12 = 4,
	MT6358_ID_VGPU = 5,
	MT6358_ID_VS2 = 6,
	MT6358_ID_VMODEM = 7,
	MT6358_ID_VS1 = 8,
	MT6358_ID_VDRAM2 = 9,
	MT6358_ID_VSIM1 = 10,
	MT6358_ID_VIBR = 11,
	MT6358_ID_VRF12 = 12,
	MT6358_ID_VIO18 = 13,
	MT6358_ID_VUSB = 14,
	MT6358_ID_VCAMIO = 15,
	MT6358_ID_VCAMD = 16,
	MT6358_ID_VCN18 = 17,
	MT6358_ID_VFE28 = 18,
	MT6358_ID_VSRAM_PROC11 = 19,
	MT6358_ID_VCN28 = 20,
	MT6358_ID_VSRAM_OTHERS = 21,
	MT6358_ID_VSRAM_GPU = 22,
	MT6358_ID_VXO22 = 23,
	MT6358_ID_VEFUSE = 24,
	MT6358_ID_VAUX18 = 25,
	MT6358_ID_VMCH = 26,
	MT6358_ID_VBIF28 = 27,
	MT6358_ID_VSRAM_PROC12 = 28,
	MT6358_ID_VCAMA1 = 29,
	MT6358_ID_VEMC = 30,
	MT6358_ID_VIO28 = 31,
	MT6358_ID_VA12 = 32,
	MT6358_ID_VRF18 = 33,
	MT6358_ID_VCN33 = 34,
	MT6358_ID_VCAMA2 = 35,
	MT6358_ID_VMC = 36,
	MT6358_ID_VLDO28 = 37,
	MT6358_ID_VAUD28 = 38,
	MT6358_ID_VSIM2 = 39,
	MT6358_ID_RG_MAX = 40,
};

enum {
	MT6359_ID_VS1 = 0,
	MT6359_ID_VGPU11 = 1,
	MT6359_ID_VMODEM = 2,
	MT6359_ID_VPU = 3,
	MT6359_ID_VCORE = 4,
	MT6359_ID_VS2 = 5,
	MT6359_ID_VPA = 6,
	MT6359_ID_VPROC2 = 7,
	MT6359_ID_VPROC1 = 8,
	MT6359_ID_VCORE_SSHUB = 9,
	MT6359_ID_VGPU11_SSHUB = 9,
	MT6359_ID_VAUD18 = 10,
	MT6359_ID_VSIM1 = 11,
	MT6359_ID_VIBR = 12,
	MT6359_ID_VRF12 = 13,
	MT6359_ID_VUSB = 14,
	MT6359_ID_VSRAM_PROC2 = 15,
	MT6359_ID_VIO18 = 16,
	MT6359_ID_VCAMIO = 17,
	MT6359_ID_VCN18 = 18,
	MT6359_ID_VFE28 = 19,
	MT6359_ID_VCN13 = 20,
	MT6359_ID_VCN33_1_BT = 21,
	MT6359_ID_VCN33_1_WIFI = 22,
	MT6359_ID_VAUX18 = 23,
	MT6359_ID_VSRAM_OTHERS = 24,
	MT6359_ID_VEFUSE = 25,
	MT6359_ID_VXO22 = 26,
	MT6359_ID_VRFCK = 27,
	MT6359_ID_VBIF28 = 28,
	MT6359_ID_VIO28 = 29,
	MT6359_ID_VEMC = 30,
	MT6359_ID_VCN33_2_BT = 31,
	MT6359_ID_VCN33_2_WIFI = 32,
	MT6359_ID_VA12 = 33,
	MT6359_ID_VA09 = 34,
	MT6359_ID_VRF18 = 35,
	MT6359_ID_VSRAM_MD = 36,
	MT6359_ID_VUFS = 37,
	MT6359_ID_VM18 = 38,
	MT6359_ID_VBBCK = 39,
	MT6359_ID_VSRAM_PROC1 = 40,
	MT6359_ID_VSIM2 = 41,
	MT6359_ID_VSRAM_OTHERS_SSHUB = 42,
	MT6359_ID_RG_MAX = 43,
};

enum {
	MT6360_REGULATOR_BUCK1 = 0,
	MT6360_REGULATOR_BUCK2 = 1,
	MT6360_REGULATOR_LDO6 = 2,
	MT6360_REGULATOR_LDO7 = 3,
	MT6360_REGULATOR_LDO1 = 4,
	MT6360_REGULATOR_LDO2 = 5,
	MT6360_REGULATOR_LDO3 = 6,
	MT6360_REGULATOR_LDO5 = 7,
	MT6360_REGULATOR_MAX = 8,
};

enum {
	MT6360_SLAVE_TCPC = 0,
	MT6360_SLAVE_PMIC = 1,
	MT6360_SLAVE_LDO = 2,
	MT6360_SLAVE_PMU = 3,
	MT6360_SLAVE_MAX = 4,
};

enum {
	MT6366_ID_VDRAM1 = 0,
	MT6366_ID_VCORE = 1,
	MT6366_ID_VPA = 2,
	MT6366_ID_VPROC11 = 3,
	MT6366_ID_VPROC12 = 4,
	MT6366_ID_VGPU = 5,
	MT6366_ID_VS2 = 6,
	MT6366_ID_VMODEM = 7,
	MT6366_ID_VS1 = 8,
	MT6366_ID_VDRAM2 = 9,
	MT6366_ID_VSIM1 = 10,
	MT6366_ID_VIBR = 11,
	MT6366_ID_VRF12 = 12,
	MT6366_ID_VIO18 = 13,
	MT6366_ID_VUSB = 14,
	MT6366_ID_VCN18 = 15,
	MT6366_ID_VFE28 = 16,
	MT6366_ID_VSRAM_PROC11 = 17,
	MT6366_ID_VCN28 = 18,
	MT6366_ID_VSRAM_OTHERS = 19,
	MT6366_ID_VSRAM_GPU = 20,
	MT6366_ID_VXO22 = 21,
	MT6366_ID_VEFUSE = 22,
	MT6366_ID_VAUX18 = 23,
	MT6366_ID_VMCH = 24,
	MT6366_ID_VBIF28 = 25,
	MT6366_ID_VSRAM_PROC12 = 26,
	MT6366_ID_VEMC = 27,
	MT6366_ID_VIO28 = 28,
	MT6366_ID_VA12 = 29,
	MT6366_ID_VRF18 = 30,
	MT6366_ID_VCN33 = 31,
	MT6366_ID_VMC = 32,
	MT6366_ID_VAUD28 = 33,
	MT6366_ID_VSIM2 = 34,
	MT6366_ID_VM18 = 35,
	MT6366_ID_VMDDR = 36,
	MT6366_ID_VSRAM_CORE = 37,
	MT6366_ID_RG_MAX = 38,
};

enum {
	MT6397_ID_VPCA15 = 0,
	MT6397_ID_VPCA7 = 1,
	MT6397_ID_VSRAMCA15 = 2,
	MT6397_ID_VSRAMCA7 = 3,
	MT6397_ID_VCORE = 4,
	MT6397_ID_VGPU = 5,
	MT6397_ID_VDRM = 6,
	MT6397_ID_VIO18 = 7,
	MT6397_ID_VTCXO = 8,
	MT6397_ID_VA28 = 9,
	MT6397_ID_VCAMA = 10,
	MT6397_ID_VIO28 = 11,
	MT6397_ID_VUSB = 12,
	MT6397_ID_VMC = 13,
	MT6397_ID_VMCH = 14,
	MT6397_ID_VEMC3V3 = 15,
	MT6397_ID_VGP1 = 16,
	MT6397_ID_VGP2 = 17,
	MT6397_ID_VGP3 = 18,
	MT6397_ID_VGP4 = 19,
	MT6397_ID_VGP5 = 20,
	MT6397_ID_VGP6 = 21,
	MT6397_ID_VIBR = 22,
	MT6397_ID_RG_MAX = 23,
};

enum {
	MTD_OPS_PLACE_OOB = 0,
	MTD_OPS_AUTO_OOB = 1,
	MTD_OPS_RAW = 2,
};

enum {
	MTK_UART_FC_NONE = 0,
	MTK_UART_FC_SW = 1,
	MTK_UART_FC_HW = 2,
};

enum {
	MUSB_CONTROLLER_MHDRC = 0,
	MUSB_CONTROLLER_HDRC = 1,
};

enum {
	MV64XXX_I2C_ACTION_INVALID = 0,
	MV64XXX_I2C_ACTION_CONTINUE = 1,
	MV64XXX_I2C_ACTION_SEND_RESTART = 2,
	MV64XXX_I2C_ACTION_SEND_ADDR_1 = 3,
	MV64XXX_I2C_ACTION_SEND_ADDR_2 = 4,
	MV64XXX_I2C_ACTION_SEND_DATA = 5,
	MV64XXX_I2C_ACTION_RCV_DATA = 6,
	MV64XXX_I2C_ACTION_RCV_DATA_STOP = 7,
	MV64XXX_I2C_ACTION_SEND_STOP = 8,
};

enum {
	MV64XXX_I2C_STATE_INVALID = 0,
	MV64XXX_I2C_STATE_IDLE = 1,
	MV64XXX_I2C_STATE_WAITING_FOR_START_COND = 2,
	MV64XXX_I2C_STATE_WAITING_FOR_RESTART = 3,
	MV64XXX_I2C_STATE_WAITING_FOR_ADDR_1_ACK = 4,
	MV64XXX_I2C_STATE_WAITING_FOR_ADDR_2_ACK = 5,
	MV64XXX_I2C_STATE_WAITING_FOR_TARGET_ACK = 6,
	MV64XXX_I2C_STATE_WAITING_FOR_TARGET_DATA = 7,
};

enum {
	MV_PMA_FW_VER0 = 49169,
	MV_PMA_FW_VER1 = 49170,
	MV_PMA_21X0_PORT_CTRL = 49226,
	MV_PMA_21X0_PORT_CTRL_SWRST = 32768,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_MASK = 7,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_USXGMII = 0,
	MV_PMA_2180_PORT_CTRL_MACTYPE_DXGMII = 1,
	MV_PMA_2180_PORT_CTRL_MACTYPE_QXGMII = 2,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_5GBASER = 4,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_5GBASER_NO_SGMII_AN = 5,
	MV_PMA_21X0_PORT_CTRL_MACTYPE_10GBASER_RATE_MATCH = 6,
	MV_PMA_BOOT = 49232,
	MV_PMA_BOOT_FATAL = 1,
	MV_PCS_BASE_T = 0,
	MV_PCS_BASE_R = 4096,
	MV_PCS_1000BASEX = 8192,
	MV_PCS_CSCR1 = 32768,
	MV_PCS_CSCR1_ED_MASK = 768,
	MV_PCS_CSCR1_ED_OFF = 0,
	MV_PCS_CSCR1_ED_RX = 512,
	MV_PCS_CSCR1_ED_NLP = 768,
	MV_PCS_CSCR1_MDIX_MASK = 96,
	MV_PCS_CSCR1_MDIX_MDI = 0,
	MV_PCS_CSCR1_MDIX_MDIX = 32,
	MV_PCS_CSCR1_MDIX_AUTO = 96,
	MV_PCS_DSC1 = 32771,
	MV_PCS_DSC1_ENABLE = 512,
	MV_PCS_DSC1_10GBT = 448,
	MV_PCS_DSC1_1GBR = 56,
	MV_PCS_DSC1_100BTX = 7,
	MV_PCS_DSC2 = 32772,
	MV_PCS_DSC2_2P5G = 61440,
	MV_PCS_DSC2_5G = 3840,
	MV_PCS_CSSR1 = 32776,
	MV_PCS_CSSR1_SPD1_MASK = 49152,
	MV_PCS_CSSR1_SPD1_SPD2 = 49152,
	MV_PCS_CSSR1_SPD1_1000 = 32768,
	MV_PCS_CSSR1_SPD1_100 = 16384,
	MV_PCS_CSSR1_SPD1_10 = 0,
	MV_PCS_CSSR1_DUPLEX_FULL = 8192,
	MV_PCS_CSSR1_RESOLVED = 2048,
	MV_PCS_CSSR1_MDIX = 64,
	MV_PCS_CSSR1_SPD2_MASK = 12,
	MV_PCS_CSSR1_SPD2_5000 = 8,
	MV_PCS_CSSR1_SPD2_2500 = 4,
	MV_PCS_CSSR1_SPD2_10000 = 0,
	MV_PCS_TEMP = 32834,
	MV_PCS_PORT_INFO = 53261,
	MV_PCS_PORT_INFO_NPORTS_MASK = 896,
	MV_PCS_PORT_INFO_NPORTS_SHIFT = 7,
	MV_AN_21X0_SERDES_CTRL2 = 32783,
	MV_AN_21X0_SERDES_CTRL2_AUTO_INIT_DIS = 8192,
	MV_AN_21X0_SERDES_CTRL2_RUN_INIT = 32768,
	MV_AN_CTRL1000 = 32768,
	MV_AN_STAT1000 = 32769,
	MV_V2_PORT_CTRL = 61441,
	MV_V2_PORT_CTRL_PWRDOWN = 2048,
	MV_V2_33X0_PORT_CTRL_SWRST = 32768,
	MV_V2_33X0_PORT_CTRL_MACTYPE_MASK = 7,
	MV_V2_33X0_PORT_CTRL_MACTYPE_RXAUI = 0,
	MV_V2_3310_PORT_CTRL_MACTYPE_XAUI_RATE_MATCH = 1,
	MV_V2_3340_PORT_CTRL_MACTYPE_RXAUI_NO_SGMII_AN = 1,
	MV_V2_33X0_PORT_CTRL_MACTYPE_RXAUI_RATE_MATCH = 2,
	MV_V2_3310_PORT_CTRL_MACTYPE_XAUI = 3,
	MV_V2_33X0_PORT_CTRL_MACTYPE_10GBASER = 4,
	MV_V2_33X0_PORT_CTRL_MACTYPE_10GBASER_NO_SGMII_AN = 5,
	MV_V2_33X0_PORT_CTRL_MACTYPE_10GBASER_RATE_MATCH = 6,
	MV_V2_33X0_PORT_CTRL_MACTYPE_USXGMII = 7,
	MV_V2_PORT_INTR_STS = 61504,
	MV_V2_PORT_INTR_MASK = 61507,
	MV_V2_PORT_INTR_STS_WOL_EN = 256,
	MV_V2_MAGIC_PKT_WORD0 = 61547,
	MV_V2_MAGIC_PKT_WORD1 = 61548,
	MV_V2_MAGIC_PKT_WORD2 = 61549,
	MV_V2_WOL_CTRL = 61550,
	MV_V2_WOL_CTRL_CLEAR_STS = 32768,
	MV_V2_WOL_CTRL_MAGIC_PKT_EN = 1,
	MV_V2_TEMP_CTRL = 61578,
	MV_V2_TEMP_CTRL_MASK = 49152,
	MV_V2_TEMP_CTRL_SAMPLE = 0,
	MV_V2_TEMP_CTRL_DISABLE = 49152,
	MV_V2_TEMP = 61580,
	MV_V2_TEMP_UNKNOWN = 38400,
};

enum {
	M_I17 = 0,
	M_I20 = 1,
	M_I20_SR = 2,
	M_I24 = 3,
	M_I24_8_1 = 4,
	M_I24_10_1 = 5,
	M_I27_11_1 = 6,
	M_MINI = 7,
	M_MINI_3_1 = 8,
	M_MINI_4_1 = 9,
	M_MB = 10,
	M_MB_2 = 11,
	M_MB_3 = 12,
	M_MB_5_1 = 13,
	M_MB_6_1 = 14,
	M_MB_7_1 = 15,
	M_MB_SR = 16,
	M_MBA = 17,
	M_MBA_3 = 18,
	M_MBP = 19,
	M_MBP_2 = 20,
	M_MBP_2_2 = 21,
	M_MBP_SR = 22,
	M_MBP_4 = 23,
	M_MBP_5_1 = 24,
	M_MBP_5_2 = 25,
	M_MBP_5_3 = 26,
	M_MBP_6_1 = 27,
	M_MBP_6_2 = 28,
	M_MBP_7_1 = 29,
	M_MBP_8_2 = 30,
	M_UNKNOWN = 31,
};

enum {
	NAPIF_STATE_SCHED = 1,
	NAPIF_STATE_MISSED = 2,
	NAPIF_STATE_DISABLE = 4,
	NAPIF_STATE_NPSVC = 8,
	NAPIF_STATE_LISTED = 16,
	NAPIF_STATE_NO_BUSY_POLL = 32,
	NAPIF_STATE_IN_BUSY_POLL = 64,
	NAPIF_STATE_PREFER_BUSY_POLL = 128,
	NAPIF_STATE_THREADED = 256,
	NAPIF_STATE_SCHED_THREADED = 512,
	NAPIF_STATE_HAS_NOTIFIER = 1024,
};

enum {
	NAPI_F_PREFER_BUSY_POLL = 1,
	NAPI_F_END_ON_RESCHED = 2,
};

enum {
	NAPI_STATE_SCHED = 0,
	NAPI_STATE_MISSED = 1,
	NAPI_STATE_DISABLE = 2,
	NAPI_STATE_NPSVC = 3,
	NAPI_STATE_LISTED = 4,
	NAPI_STATE_NO_BUSY_POLL = 5,
	NAPI_STATE_IN_BUSY_POLL = 6,
	NAPI_STATE_PREFER_BUSY_POLL = 7,
	NAPI_STATE_THREADED = 8,
	NAPI_STATE_SCHED_THREADED = 9,
	NAPI_STATE_HAS_NOTIFIER = 10,
};

enum {
	NDA_UNSPEC = 0,
	NDA_DST = 1,
	NDA_LLADDR = 2,
	NDA_CACHEINFO = 3,
	NDA_PROBES = 4,
	NDA_VLAN = 5,
	NDA_PORT = 6,
	NDA_VNI = 7,
	NDA_IFINDEX = 8,
	NDA_MASTER = 9,
	NDA_LINK_NETNSID = 10,
	NDA_SRC_VNI = 11,
	NDA_PROTOCOL = 12,
	NDA_NH_ID = 13,
	NDA_FDB_EXT_ATTRS = 14,
	NDA_FLAGS_EXT = 15,
	NDA_NDM_STATE_MASK = 16,
	NDA_NDM_FLAGS_MASK = 17,
	__NDA_MAX = 18,
};

enum {
	NDD_UNARMED = 1,
	NDD_LOCKED = 2,
	NDD_SECURITY_OVERWRITE = 3,
	NDD_WORK_PENDING = 4,
	NDD_LABELING = 6,
	NDD_INCOHERENT = 7,
	NDD_REGISTER_SYNC = 8,
	ND_IOCTL_MAX_BUFLEN = 4194304,
	ND_CMD_MAX_ELEM = 5,
	ND_CMD_MAX_ENVELOPE = 256,
	ND_MAX_MAPPINGS = 32,
	ND_REGION_PAGEMAP = 0,
	ND_REGION_PERSIST_CACHE = 1,
	ND_REGION_PERSIST_MEMCTRL = 2,
	ND_REGION_ASYNC = 3,
	ND_REGION_CXL = 4,
	DPA_RESOURCE_ADJUSTED = 1,
};

enum {
	NDTA_UNSPEC = 0,
	NDTA_NAME = 1,
	NDTA_THRESH1 = 2,
	NDTA_THRESH2 = 3,
	NDTA_THRESH3 = 4,
	NDTA_CONFIG = 5,
	NDTA_PARMS = 6,
	NDTA_STATS = 7,
	NDTA_GC_INTERVAL = 8,
	NDTA_PAD = 9,
	__NDTA_MAX = 10,
};

enum {
	NDTPA_UNSPEC = 0,
	NDTPA_IFINDEX = 1,
	NDTPA_REFCNT = 2,
	NDTPA_REACHABLE_TIME = 3,
	NDTPA_BASE_REACHABLE_TIME = 4,
	NDTPA_RETRANS_TIME = 5,
	NDTPA_GC_STALETIME = 6,
	NDTPA_DELAY_PROBE_TIME = 7,
	NDTPA_QUEUE_LEN = 8,
	NDTPA_APP_PROBES = 9,
	NDTPA_UCAST_PROBES = 10,
	NDTPA_MCAST_PROBES = 11,
	NDTPA_ANYCAST_DELAY = 12,
	NDTPA_PROXY_DELAY = 13,
	NDTPA_PROXY_QLEN = 14,
	NDTPA_LOCKTIME = 15,
	NDTPA_QUEUE_LENBYTES = 16,
	NDTPA_MCAST_REPROBES = 17,
	NDTPA_PAD = 18,
	NDTPA_INTERVAL_PROBE_TIME_MS = 19,
	__NDTPA_MAX = 20,
};

enum {
	NEIGH_ARP_TABLE = 0,
	NEIGH_ND_TABLE = 1,
	NEIGH_NR_TABLES = 2,
	NEIGH_LINK_TABLE = 2,
};

enum {
	NEIGH_VAR_MCAST_PROBES = 0,
	NEIGH_VAR_UCAST_PROBES = 1,
	NEIGH_VAR_APP_PROBES = 2,
	NEIGH_VAR_MCAST_REPROBES = 3,
	NEIGH_VAR_RETRANS_TIME = 4,
	NEIGH_VAR_BASE_REACHABLE_TIME = 5,
	NEIGH_VAR_DELAY_PROBE_TIME = 6,
	NEIGH_VAR_INTERVAL_PROBE_TIME_MS = 7,
	NEIGH_VAR_GC_STALETIME = 8,
	NEIGH_VAR_QUEUE_LEN_BYTES = 9,
	NEIGH_VAR_PROXY_QLEN = 10,
	NEIGH_VAR_ANYCAST_DELAY = 11,
	NEIGH_VAR_PROXY_DELAY = 12,
	NEIGH_VAR_LOCKTIME = 13,
	NEIGH_VAR_QUEUE_LEN = 14,
	NEIGH_VAR_RETRANS_TIME_MS = 15,
	NEIGH_VAR_BASE_REACHABLE_TIME_MS = 16,
	NEIGH_VAR_GC_INTERVAL = 17,
	NEIGH_VAR_GC_THRESH1 = 18,
	NEIGH_VAR_GC_THRESH2 = 19,
	NEIGH_VAR_GC_THRESH3 = 20,
	NEIGH_VAR_MAX = 21,
};

enum {
	NESTED_SYNC_IMM_BIT = 0,
	NESTED_SYNC_TODO_BIT = 1,
};

enum {
	NETCONFA_UNSPEC = 0,
	NETCONFA_IFINDEX = 1,
	NETCONFA_FORWARDING = 2,
	NETCONFA_RP_FILTER = 3,
	NETCONFA_MC_FORWARDING = 4,
	NETCONFA_PROXY_NEIGH = 5,
	NETCONFA_IGNORE_ROUTES_WITH_LINKDOWN = 6,
	NETCONFA_INPUT = 7,
	NETCONFA_BC_FORWARDING = 8,
	__NETCONFA_MAX = 9,
};

enum {
	NETDEV_A_DEV_IFINDEX = 1,
	NETDEV_A_DEV_PAD = 2,
	NETDEV_A_DEV_XDP_FEATURES = 3,
	NETDEV_A_DEV_XDP_ZC_MAX_SEGS = 4,
	NETDEV_A_DEV_XDP_RX_METADATA_FEATURES = 5,
	NETDEV_A_DEV_XSK_FEATURES = 6,
	__NETDEV_A_DEV_MAX = 7,
	NETDEV_A_DEV_MAX = 6,
};

enum {
	NETDEV_A_DMABUF_IFINDEX = 1,
	NETDEV_A_DMABUF_QUEUES = 2,
	NETDEV_A_DMABUF_FD = 3,
	NETDEV_A_DMABUF_ID = 4,
	__NETDEV_A_DMABUF_MAX = 5,
	NETDEV_A_DMABUF_MAX = 4,
};

enum {
	NETDEV_A_NAPI_IFINDEX = 1,
	NETDEV_A_NAPI_ID = 2,
	NETDEV_A_NAPI_IRQ = 3,
	NETDEV_A_NAPI_PID = 4,
	NETDEV_A_NAPI_DEFER_HARD_IRQS = 5,
	NETDEV_A_NAPI_GRO_FLUSH_TIMEOUT = 6,
	NETDEV_A_NAPI_IRQ_SUSPEND_TIMEOUT = 7,
	__NETDEV_A_NAPI_MAX = 8,
	NETDEV_A_NAPI_MAX = 7,
};

enum {
	NETDEV_A_PAGE_POOL_ID = 1,
	NETDEV_A_PAGE_POOL_IFINDEX = 2,
	NETDEV_A_PAGE_POOL_NAPI_ID = 3,
	NETDEV_A_PAGE_POOL_INFLIGHT = 4,
	NETDEV_A_PAGE_POOL_INFLIGHT_MEM = 5,
	NETDEV_A_PAGE_POOL_DETACH_TIME = 6,
	NETDEV_A_PAGE_POOL_DMABUF = 7,
	NETDEV_A_PAGE_POOL_IO_URING = 8,
	__NETDEV_A_PAGE_POOL_MAX = 9,
	NETDEV_A_PAGE_POOL_MAX = 8,
};

enum {
	NETDEV_A_PAGE_POOL_STATS_INFO = 1,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_FAST = 8,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_SLOW = 9,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_SLOW_HIGH_ORDER = 10,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_EMPTY = 11,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_REFILL = 12,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_WAIVE = 13,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_CACHED = 14,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_CACHE_FULL = 15,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RING = 16,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RING_FULL = 17,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RELEASED_REFCNT = 18,
	__NETDEV_A_PAGE_POOL_STATS_MAX = 19,
	NETDEV_A_PAGE_POOL_STATS_MAX = 18,
};

enum {
	NETDEV_A_QSTATS_IFINDEX = 1,
	NETDEV_A_QSTATS_QUEUE_TYPE = 2,
	NETDEV_A_QSTATS_QUEUE_ID = 3,
	NETDEV_A_QSTATS_SCOPE = 4,
	NETDEV_A_QSTATS_RX_PACKETS = 8,
	NETDEV_A_QSTATS_RX_BYTES = 9,
	NETDEV_A_QSTATS_TX_PACKETS = 10,
	NETDEV_A_QSTATS_TX_BYTES = 11,
	NETDEV_A_QSTATS_RX_ALLOC_FAIL = 12,
	NETDEV_A_QSTATS_RX_HW_DROPS = 13,
	NETDEV_A_QSTATS_RX_HW_DROP_OVERRUNS = 14,
	NETDEV_A_QSTATS_RX_CSUM_COMPLETE = 15,
	NETDEV_A_QSTATS_RX_CSUM_UNNECESSARY = 16,
	NETDEV_A_QSTATS_RX_CSUM_NONE = 17,
	NETDEV_A_QSTATS_RX_CSUM_BAD = 18,
	NETDEV_A_QSTATS_RX_HW_GRO_PACKETS = 19,
	NETDEV_A_QSTATS_RX_HW_GRO_BYTES = 20,
	NETDEV_A_QSTATS_RX_HW_GRO_WIRE_PACKETS = 21,
	NETDEV_A_QSTATS_RX_HW_GRO_WIRE_BYTES = 22,
	NETDEV_A_QSTATS_RX_HW_DROP_RATELIMITS = 23,
	NETDEV_A_QSTATS_TX_HW_DROPS = 24,
	NETDEV_A_QSTATS_TX_HW_DROP_ERRORS = 25,
	NETDEV_A_QSTATS_TX_CSUM_NONE = 26,
	NETDEV_A_QSTATS_TX_NEEDS_CSUM = 27,
	NETDEV_A_QSTATS_TX_HW_GSO_PACKETS = 28,
	NETDEV_A_QSTATS_TX_HW_GSO_BYTES = 29,
	NETDEV_A_QSTATS_TX_HW_GSO_WIRE_PACKETS = 30,
	NETDEV_A_QSTATS_TX_HW_GSO_WIRE_BYTES = 31,
	NETDEV_A_QSTATS_TX_HW_DROP_RATELIMITS = 32,
	NETDEV_A_QSTATS_TX_STOP = 33,
	NETDEV_A_QSTATS_TX_WAKE = 34,
	__NETDEV_A_QSTATS_MAX = 35,
	NETDEV_A_QSTATS_MAX = 34,
};

enum {
	NETDEV_A_QUEUE_ID = 1,
	NETDEV_A_QUEUE_IFINDEX = 2,
	NETDEV_A_QUEUE_TYPE = 3,
	NETDEV_A_QUEUE_NAPI_ID = 4,
	NETDEV_A_QUEUE_DMABUF = 5,
	NETDEV_A_QUEUE_IO_URING = 6,
	NETDEV_A_QUEUE_XSK = 7,
	__NETDEV_A_QUEUE_MAX = 8,
	NETDEV_A_QUEUE_MAX = 7,
};

enum {
	NETDEV_CMD_DEV_GET = 1,
	NETDEV_CMD_DEV_ADD_NTF = 2,
	NETDEV_CMD_DEV_DEL_NTF = 3,
	NETDEV_CMD_DEV_CHANGE_NTF = 4,
	NETDEV_CMD_PAGE_POOL_GET = 5,
	NETDEV_CMD_PAGE_POOL_ADD_NTF = 6,
	NETDEV_CMD_PAGE_POOL_DEL_NTF = 7,
	NETDEV_CMD_PAGE_POOL_CHANGE_NTF = 8,
	NETDEV_CMD_PAGE_POOL_STATS_GET = 9,
	NETDEV_CMD_QUEUE_GET = 10,
	NETDEV_CMD_NAPI_GET = 11,
	NETDEV_CMD_QSTATS_GET = 12,
	NETDEV_CMD_BIND_RX = 13,
	NETDEV_CMD_NAPI_SET = 14,
	NETDEV_CMD_BIND_TX = 15,
	__NETDEV_CMD_MAX = 16,
	NETDEV_CMD_MAX = 15,
};

enum {
	NETDEV_NLGRP_MGMT = 0,
	NETDEV_NLGRP_PAGE_POOL = 1,
};

enum {
	NETDEV_STATS = 0,
	E1000_STATS = 1,
};

enum {
	NETIF_F_SG_BIT = 0,
	NETIF_F_IP_CSUM_BIT = 1,
	__UNUSED_NETIF_F_1 = 2,
	NETIF_F_HW_CSUM_BIT = 3,
	NETIF_F_IPV6_CSUM_BIT = 4,
	NETIF_F_HIGHDMA_BIT = 5,
	NETIF_F_FRAGLIST_BIT = 6,
	NETIF_F_HW_VLAN_CTAG_TX_BIT = 7,
	NETIF_F_HW_VLAN_CTAG_RX_BIT = 8,
	NETIF_F_HW_VLAN_CTAG_FILTER_BIT = 9,
	NETIF_F_VLAN_CHALLENGED_BIT = 10,
	NETIF_F_GSO_BIT = 11,
	__UNUSED_NETIF_F_12 = 12,
	__UNUSED_NETIF_F_13 = 13,
	NETIF_F_GRO_BIT = 14,
	NETIF_F_LRO_BIT = 15,
	NETIF_F_GSO_SHIFT = 16,
	NETIF_F_TSO_BIT = 16,
	NETIF_F_GSO_ROBUST_BIT = 17,
	NETIF_F_TSO_ECN_BIT = 18,
	NETIF_F_TSO_MANGLEID_BIT = 19,
	NETIF_F_TSO6_BIT = 20,
	NETIF_F_FSO_BIT = 21,
	NETIF_F_GSO_GRE_BIT = 22,
	NETIF_F_GSO_GRE_CSUM_BIT = 23,
	NETIF_F_GSO_IPXIP4_BIT = 24,
	NETIF_F_GSO_IPXIP6_BIT = 25,
	NETIF_F_GSO_UDP_TUNNEL_BIT = 26,
	NETIF_F_GSO_UDP_TUNNEL_CSUM_BIT = 27,
	NETIF_F_GSO_PARTIAL_BIT = 28,
	NETIF_F_GSO_TUNNEL_REMCSUM_BIT = 29,
	NETIF_F_GSO_SCTP_BIT = 30,
	NETIF_F_GSO_ESP_BIT = 31,
	NETIF_F_GSO_UDP_BIT = 32,
	NETIF_F_GSO_UDP_L4_BIT = 33,
	NETIF_F_GSO_FRAGLIST_BIT = 34,
	NETIF_F_GSO_ACCECN_BIT = 35,
	NETIF_F_GSO_LAST = 35,
	NETIF_F_FCOE_CRC_BIT = 36,
	NETIF_F_SCTP_CRC_BIT = 37,
	NETIF_F_NTUPLE_BIT = 38,
	NETIF_F_RXHASH_BIT = 39,
	NETIF_F_RXCSUM_BIT = 40,
	NETIF_F_NOCACHE_COPY_BIT = 41,
	NETIF_F_LOOPBACK_BIT = 42,
	NETIF_F_RXFCS_BIT = 43,
	NETIF_F_RXALL_BIT = 44,
	NETIF_F_HW_VLAN_STAG_TX_BIT = 45,
	NETIF_F_HW_VLAN_STAG_RX_BIT = 46,
	NETIF_F_HW_VLAN_STAG_FILTER_BIT = 47,
	NETIF_F_HW_L2FW_DOFFLOAD_BIT = 48,
	NETIF_F_HW_TC_BIT = 49,
	NETIF_F_HW_ESP_BIT = 50,
	NETIF_F_HW_ESP_TX_CSUM_BIT = 51,
	NETIF_F_RX_UDP_TUNNEL_PORT_BIT = 52,
	NETIF_F_HW_TLS_TX_BIT = 53,
	NETIF_F_HW_TLS_RX_BIT = 54,
	NETIF_F_GRO_HW_BIT = 55,
	NETIF_F_HW_TLS_RECORD_BIT = 56,
	NETIF_F_GRO_FRAGLIST_BIT = 57,
	NETIF_F_HW_MACSEC_BIT = 58,
	NETIF_F_GRO_UDP_FWD_BIT = 59,
	NETIF_F_HW_HSR_TAG_INS_BIT = 60,
	NETIF_F_HW_HSR_TAG_RM_BIT = 61,
	NETIF_F_HW_HSR_FWD_BIT = 62,
	NETIF_F_HW_HSR_DUP_BIT = 63,
	NETDEV_FEATURE_COUNT = 64,
};

enum {
	NETIF_MSG_DRV_BIT = 0,
	NETIF_MSG_PROBE_BIT = 1,
	NETIF_MSG_LINK_BIT = 2,
	NETIF_MSG_TIMER_BIT = 3,
	NETIF_MSG_IFDOWN_BIT = 4,
	NETIF_MSG_IFUP_BIT = 5,
	NETIF_MSG_RX_ERR_BIT = 6,
	NETIF_MSG_TX_ERR_BIT = 7,
	NETIF_MSG_TX_QUEUED_BIT = 8,
	NETIF_MSG_INTR_BIT = 9,
	NETIF_MSG_TX_DONE_BIT = 10,
	NETIF_MSG_RX_STATUS_BIT = 11,
	NETIF_MSG_PKTDATA_BIT = 12,
	NETIF_MSG_HW_BIT = 13,
	NETIF_MSG_WOL_BIT = 14,
	NETIF_MSG_CLASS_COUNT = 15,
};

enum {
	NETLINK_F_KERNEL_SOCKET = 0,
	NETLINK_F_RECV_PKTINFO = 1,
	NETLINK_F_BROADCAST_SEND_ERROR = 2,
	NETLINK_F_RECV_NO_ENOBUFS = 3,
	NETLINK_F_LISTEN_ALL_NSID = 4,
	NETLINK_F_CAP_ACK = 5,
	NETLINK_F_EXT_ACK = 6,
	NETLINK_F_STRICT_CHK = 7,
};

enum {
	NETLINK_UNCONNECTED = 0,
	NETLINK_CONNECTED = 1,
};

enum {
	NETNSA_NONE = 0,
	NETNSA_NSID = 1,
	NETNSA_PID = 2,
	NETNSA_FD = 3,
	NETNSA_TARGET_NSID = 4,
	NETNSA_CURRENT_NSID = 5,
	__NETNSA_MAX = 6,
};

enum {
	NET_NS_INDEX = 0,
	UTS_NS_INDEX = 1,
	IPC_NS_INDEX = 2,
	PID_NS_INDEX = 3,
	USER_NS_INDEX = 4,
	MNT_NS_INDEX = 5,
	CGROUP_NS_INDEX = 6,
	NR_NAMESPACES = 7,
};

enum {
	NEXTHOP_GRP_TYPE_MPATH = 0,
	NEXTHOP_GRP_TYPE_RES = 1,
	__NEXTHOP_GRP_TYPE_MAX = 2,
};

enum {
	NFPROTO_UNSPEC = 0,
	NFPROTO_INET = 1,
	NFPROTO_IPV4 = 2,
	NFPROTO_ARP = 3,
	NFPROTO_NETDEV = 5,
	NFPROTO_BRIDGE = 7,
	NFPROTO_IPV6 = 10,
	NFPROTO_NUMPROTO = 11,
};

enum {
	NFSPROC4_CLNT_NULL = 0,
	NFSPROC4_CLNT_READ = 1,
	NFSPROC4_CLNT_WRITE = 2,
	NFSPROC4_CLNT_COMMIT = 3,
	NFSPROC4_CLNT_OPEN = 4,
	NFSPROC4_CLNT_OPEN_CONFIRM = 5,
	NFSPROC4_CLNT_OPEN_NOATTR = 6,
	NFSPROC4_CLNT_OPEN_DOWNGRADE = 7,
	NFSPROC4_CLNT_CLOSE = 8,
	NFSPROC4_CLNT_SETATTR = 9,
	NFSPROC4_CLNT_FSINFO = 10,
	NFSPROC4_CLNT_RENEW = 11,
	NFSPROC4_CLNT_SETCLIENTID = 12,
	NFSPROC4_CLNT_SETCLIENTID_CONFIRM = 13,
	NFSPROC4_CLNT_LOCK = 14,
	NFSPROC4_CLNT_LOCKT = 15,
	NFSPROC4_CLNT_LOCKU = 16,
	NFSPROC4_CLNT_ACCESS = 17,
	NFSPROC4_CLNT_GETATTR = 18,
	NFSPROC4_CLNT_LOOKUP = 19,
	NFSPROC4_CLNT_LOOKUP_ROOT = 20,
	NFSPROC4_CLNT_REMOVE = 21,
	NFSPROC4_CLNT_RENAME = 22,
	NFSPROC4_CLNT_LINK = 23,
	NFSPROC4_CLNT_SYMLINK = 24,
	NFSPROC4_CLNT_CREATE = 25,
	NFSPROC4_CLNT_PATHCONF = 26,
	NFSPROC4_CLNT_STATFS = 27,
	NFSPROC4_CLNT_READLINK = 28,
	NFSPROC4_CLNT_READDIR = 29,
	NFSPROC4_CLNT_SERVER_CAPS = 30,
	NFSPROC4_CLNT_DELEGRETURN = 31,
	NFSPROC4_CLNT_GETACL = 32,
	NFSPROC4_CLNT_SETACL = 33,
	NFSPROC4_CLNT_FS_LOCATIONS = 34,
	NFSPROC4_CLNT_RELEASE_LOCKOWNER = 35,
	NFSPROC4_CLNT_SECINFO = 36,
	NFSPROC4_CLNT_FSID_PRESENT = 37,
	NFSPROC4_CLNT_EXCHANGE_ID = 38,
	NFSPROC4_CLNT_CREATE_SESSION = 39,
	NFSPROC4_CLNT_DESTROY_SESSION = 40,
	NFSPROC4_CLNT_SEQUENCE = 41,
	NFSPROC4_CLNT_GET_LEASE_TIME = 42,
	NFSPROC4_CLNT_RECLAIM_COMPLETE = 43,
	NFSPROC4_CLNT_LAYOUTGET = 44,
	NFSPROC4_CLNT_GETDEVICEINFO = 45,
	NFSPROC4_CLNT_LAYOUTCOMMIT = 46,
	NFSPROC4_CLNT_LAYOUTRETURN = 47,
	NFSPROC4_CLNT_SECINFO_NO_NAME = 48,
	NFSPROC4_CLNT_TEST_STATEID = 49,
	NFSPROC4_CLNT_FREE_STATEID = 50,
	NFSPROC4_CLNT_GETDEVICELIST = 51,
	NFSPROC4_CLNT_BIND_CONN_TO_SESSION = 52,
	NFSPROC4_CLNT_DESTROY_CLIENTID = 53,
	NFSPROC4_CLNT_SEEK = 54,
	NFSPROC4_CLNT_ALLOCATE = 55,
	NFSPROC4_CLNT_DEALLOCATE = 56,
	NFSPROC4_CLNT_ZERO_RANGE = 57,
	NFSPROC4_CLNT_LAYOUTSTATS = 58,
	NFSPROC4_CLNT_CLONE = 59,
	NFSPROC4_CLNT_COPY = 60,
	NFSPROC4_CLNT_OFFLOAD_CANCEL = 61,
	NFSPROC4_CLNT_LOOKUPP = 62,
	NFSPROC4_CLNT_LAYOUTERROR = 63,
	NFSPROC4_CLNT_COPY_NOTIFY = 64,
	NFSPROC4_CLNT_GETXATTR = 65,
	NFSPROC4_CLNT_SETXATTR = 66,
	NFSPROC4_CLNT_LISTXATTRS = 67,
	NFSPROC4_CLNT_REMOVEXATTR = 68,
	NFSPROC4_CLNT_READ_PLUS = 69,
	NFSPROC4_CLNT_OFFLOAD_STATUS = 70,
};

enum {
	NFS_DELEGATION_NEED_RECLAIM = 0,
	NFS_DELEGATION_RETURN = 1,
	NFS_DELEGATION_RETURN_IF_CLOSED = 2,
	NFS_DELEGATION_REFERENCED = 3,
	NFS_DELEGATION_RETURNING = 4,
	NFS_DELEGATION_REVOKED = 5,
	NFS_DELEGATION_TEST_EXPIRED = 6,
	NFS_DELEGATION_INODE_FREEING = 7,
	NFS_DELEGATION_RETURN_DELAYED = 8,
	NFS_DELEGATION_DELEGTIME = 9,
};

enum {
	NFS_DEVICEID_INVALID = 0,
	NFS_DEVICEID_UNAVAILABLE = 1,
	NFS_DEVICEID_NOCACHE = 2,
};

enum {
	NFS_IOHDR_ERROR = 0,
	NFS_IOHDR_EOF = 1,
	NFS_IOHDR_REDO = 2,
	NFS_IOHDR_STAT = 3,
	NFS_IOHDR_RESEND_PNFS = 4,
	NFS_IOHDR_RESEND_MDS = 5,
	NFS_IOHDR_UNSTABLE_WRITES = 6,
	NFS_IOHDR_ODIRECT = 7,
};

enum {
	NFS_LAYOUT_RO_FAILED = 0,
	NFS_LAYOUT_RW_FAILED = 1,
	NFS_LAYOUT_BULK_RECALL = 2,
	NFS_LAYOUT_RETURN = 3,
	NFS_LAYOUT_RETURN_LOCK = 4,
	NFS_LAYOUT_RETURN_REQUESTED = 5,
	NFS_LAYOUT_INVALID_STID = 6,
	NFS_LAYOUT_FIRST_LAYOUTGET = 7,
	NFS_LAYOUT_INODE_FREEING = 8,
	NFS_LAYOUT_HASHED = 9,
	NFS_LAYOUT_DRAIN = 10,
};

enum {
	NFS_LSEG_VALID = 0,
	NFS_LSEG_ROC = 1,
	NFS_LSEG_LAYOUTCOMMIT = 2,
	NFS_LSEG_LAYOUTRETURN = 3,
	NFS_LSEG_UNAVAILABLE = 4,
};

enum {
	NFS_OWNER_RECLAIM_REBOOT = 0,
	NFS_OWNER_RECLAIM_NOGRACE = 1,
};

enum {
	NHA_GROUP_STATS_ENTRY_UNSPEC = 0,
	NHA_GROUP_STATS_ENTRY_ID = 1,
	NHA_GROUP_STATS_ENTRY_PACKETS = 2,
	NHA_GROUP_STATS_ENTRY_PACKETS_HW = 3,
	__NHA_GROUP_STATS_ENTRY_MAX = 4,
};

enum {
	NHA_GROUP_STATS_UNSPEC = 0,
	NHA_GROUP_STATS_ENTRY = 1,
	__NHA_GROUP_STATS_MAX = 2,
};

enum {
	NHA_RES_BUCKET_UNSPEC = 0,
	NHA_RES_BUCKET_PAD = 0,
	NHA_RES_BUCKET_INDEX = 1,
	NHA_RES_BUCKET_IDLE_TIME = 2,
	NHA_RES_BUCKET_NH_ID = 3,
	__NHA_RES_BUCKET_MAX = 4,
};

enum {
	NHA_RES_GROUP_UNSPEC = 0,
	NHA_RES_GROUP_PAD = 0,
	NHA_RES_GROUP_BUCKETS = 1,
	NHA_RES_GROUP_IDLE_TIMER = 2,
	NHA_RES_GROUP_UNBALANCED_TIMER = 3,
	NHA_RES_GROUP_UNBALANCED_TIME = 4,
	__NHA_RES_GROUP_MAX = 5,
};

enum {
	NHA_UNSPEC = 0,
	NHA_ID = 1,
	NHA_GROUP = 2,
	NHA_GROUP_TYPE = 3,
	NHA_BLACKHOLE = 4,
	NHA_OIF = 5,
	NHA_GATEWAY = 6,
	NHA_ENCAP_TYPE = 7,
	NHA_ENCAP = 8,
	NHA_GROUPS = 9,
	NHA_MASTER = 10,
	NHA_FDB = 11,
	NHA_RES_GROUP = 12,
	NHA_RES_BUCKET = 13,
	NHA_OP_FLAGS = 14,
	NHA_GROUP_STATS = 15,
	NHA_HW_STATS_ENABLE = 16,
	NHA_HW_STATS_USED = 17,
	__NHA_MAX = 18,
};

enum {
	NLA_UNSPEC = 0,
	NLA_U8 = 1,
	NLA_U16 = 2,
	NLA_U32 = 3,
	NLA_U64 = 4,
	NLA_STRING = 5,
	NLA_FLAG = 6,
	NLA_MSECS = 7,
	NLA_NESTED = 8,
	NLA_NESTED_ARRAY = 9,
	NLA_NUL_STRING = 10,
	NLA_BINARY = 11,
	NLA_S8 = 12,
	NLA_S16 = 13,
	NLA_S32 = 14,
	NLA_S64 = 15,
	NLA_BITFIELD32 = 16,
	NLA_REJECT = 17,
	NLA_BE16 = 18,
	NLA_BE32 = 19,
	NLA_SINT = 20,
	NLA_UINT = 21,
	__NLA_TYPE_MAX = 22,
};

enum {
	NLM_LCK_GRANTED = 0,
	NLM_LCK_DENIED = 1,
	NLM_LCK_DENIED_NOLOCKS = 2,
	NLM_LCK_BLOCKED = 3,
	NLM_LCK_DENIED_GRACE_PERIOD = 4,
	NLM_DEADLCK = 5,
	NLM_ROFS = 6,
	NLM_STALE_FH = 7,
	NLM_FBIG = 8,
	NLM_FAILED = 9,
};

enum {
	NODE_ACCESS_CLASS_GENPORT_SINK_LOCAL = 2,
	NODE_ACCESS_CLASS_GENPORT_SINK_CPU = 3,
	NODE_ACCESS_CLASS_MAX = 4,
};

enum {
	NORTH = 0,
	SOUTH = 1,
	EAST = 2,
};

enum {
	NORTH___2 = 0,
	SOUTH___2 = 1,
	WEST = 2,
};

enum {
	NORTH___3 = 0,
	CENTER = 1,
	SOUTH___3 = 2,
};

enum {
	NORTH___4 = 0,
	SOUTH___4 = 1,
	EAST___2 = 2,
	WEST___2 = 3,
};

enum {
	NSMPROC_NULL = 0,
	NSMPROC_STAT = 1,
	NSMPROC_MON = 2,
	NSMPROC_UNMON = 3,
	NSMPROC_UNMON_ALL = 4,
	NSMPROC_SIMU_CRASH = 5,
	NSMPROC_NOTIFY = 6,
};

enum {
	NUM_TRIAL_SAMPLES = 8192,
	MAX_SAMPLES_PER_BIT = 16,
};

enum {
	NVMEM_ADD = 1,
	NVMEM_REMOVE = 2,
	NVMEM_CELL_ADD = 3,
	NVMEM_CELL_REMOVE = 4,
	NVMEM_LAYOUT_ADD = 5,
	NVMEM_LAYOUT_REMOVE = 6,
};

enum {
	NVME_AEN_BIT_NS_ATTR = 8,
	NVME_AEN_BIT_FW_ACT = 9,
	NVME_AEN_BIT_ANA_CHANGE = 11,
	NVME_AEN_BIT_DISC_CHANGE = 31,
};

enum {
	NVME_CC_ENABLE = 1,
	NVME_CC_EN_SHIFT = 0,
	NVME_CC_CSS_SHIFT = 4,
	NVME_CC_CSS_MASK = 112,
	NVME_CC_CSS_NVM = 0,
	NVME_CC_CSS_CSI = 96,
	NVME_CC_MPS_SHIFT = 7,
	NVME_CC_MPS_MASK = 1920,
	NVME_CC_AMS_SHIFT = 11,
	NVME_CC_AMS_MASK = 14336,
	NVME_CC_AMS_RR = 0,
	NVME_CC_AMS_WRRU = 2048,
	NVME_CC_AMS_VS = 14336,
	NVME_CC_SHN_SHIFT = 14,
	NVME_CC_SHN_MASK = 49152,
	NVME_CC_SHN_NONE = 0,
	NVME_CC_SHN_NORMAL = 16384,
	NVME_CC_SHN_ABRUPT = 32768,
	NVME_CC_IOSQES_SHIFT = 16,
	NVME_CC_IOSQES_MASK = 983040,
	NVME_CC_IOSQES = 393216,
	NVME_CC_IOCQES_SHIFT = 20,
	NVME_CC_IOCQES_MASK = 15728640,
	NVME_CC_IOCQES = 4194304,
	NVME_CC_CRIME = 16777216,
};

enum {
	NVME_CSTS_RDY = 1,
	NVME_CSTS_CFS = 2,
	NVME_CSTS_NSSRO = 16,
	NVME_CSTS_PP = 32,
	NVME_CSTS_SHST_NORMAL = 0,
	NVME_CSTS_SHST_OCCUR = 4,
	NVME_CSTS_SHST_CMPLT = 8,
	NVME_CSTS_SHST_MASK = 12,
};

enum {
	NVME_REG_CAP = 0,
	NVME_REG_VS = 8,
	NVME_REG_INTMS = 12,
	NVME_REG_INTMC = 16,
	NVME_REG_CC = 20,
	NVME_REG_CSTS = 28,
	NVME_REG_NSSR = 32,
	NVME_REG_AQA = 36,
	NVME_REG_ASQ = 40,
	NVME_REG_ACQ = 48,
	NVME_REG_CMBLOC = 56,
	NVME_REG_CMBSZ = 60,
	NVME_REG_BPINFO = 64,
	NVME_REG_BPRSEL = 68,
	NVME_REG_BPMBL = 72,
	NVME_REG_CMBMSC = 80,
	NVME_REG_CRTO = 104,
	NVME_REG_PMRCAP = 3584,
	NVME_REG_PMRCTL = 3588,
	NVME_REG_PMRSTS = 3592,
	NVME_REG_PMREBS = 3596,
	NVME_REG_PMRSWTP = 3600,
	NVME_REG_DBS = 4096,
};

enum {
	OD_NORMAL_SAMPLE = 0,
	OD_SUB_SAMPLE = 1,
};

enum {
	OMAP_I2C_REV_REG = 0,
	OMAP_I2C_IE_REG = 1,
	OMAP_I2C_STAT_REG = 2,
	OMAP_I2C_IV_REG = 3,
	OMAP_I2C_WE_REG = 4,
	OMAP_I2C_SYSS_REG = 5,
	OMAP_I2C_BUF_REG = 6,
	OMAP_I2C_CNT_REG = 7,
	OMAP_I2C_DATA_REG = 8,
	OMAP_I2C_SYSC_REG = 9,
	OMAP_I2C_CON_REG = 10,
	OMAP_I2C_OA_REG = 11,
	OMAP_I2C_SA_REG = 12,
	OMAP_I2C_PSC_REG = 13,
	OMAP_I2C_SCLL_REG = 14,
	OMAP_I2C_SCLH_REG = 15,
	OMAP_I2C_SYSTEST_REG = 16,
	OMAP_I2C_BUFSTAT_REG = 17,
	OMAP_I2C_IP_V2_REVNB_LO = 18,
	OMAP_I2C_IP_V2_REVNB_HI = 19,
	OMAP_I2C_IP_V2_IRQSTATUS_RAW = 20,
	OMAP_I2C_IP_V2_IRQENABLE_SET = 21,
	OMAP_I2C_IP_V2_IRQENABLE_CLR = 22,
};

enum {
	ONLINE_POLICY_CONTIG_ZONES = 0,
	ONLINE_POLICY_AUTO_MOVABLE = 1,
};

enum {
	OPT_UID = 0,
	OPT_GID = 1,
	OPT_MODE = 2,
	OPT_DELEGATE_CMDS = 3,
	OPT_DELEGATE_MAPS = 4,
	OPT_DELEGATE_PROGS = 5,
	OPT_DELEGATE_ATTACHS = 6,
};

enum {
	OUTSIDE_GUEST_MODE = 0,
	IN_GUEST_MODE = 1,
	EXITING_GUEST_MODE = 2,
	READING_SHADOW_PAGE_TABLES = 3,
};

enum {
	OVERRIDE_NONE = 0,
	OVERRIDE_BASE = 1,
	OVERRIDE_STRIDE = 2,
	OVERRIDE_HEIGHT = 4,
	OVERRIDE_WIDTH = 8,
};

enum {
	Opt_bsd_df = 0,
	Opt_minix_df = 1,
	Opt_grpid = 2,
	Opt_nogrpid = 3,
	Opt_resgid = 4,
	Opt_resuid = 5,
	Opt_sb = 6,
	Opt_nouid32 = 7,
	Opt_debug = 8,
	Opt_removed = 9,
	Opt_user_xattr = 10,
	Opt_acl = 11,
	Opt_auto_da_alloc = 12,
	Opt_noauto_da_alloc = 13,
	Opt_noload = 14,
	Opt_commit = 15,
	Opt_min_batch_time = 16,
	Opt_max_batch_time = 17,
	Opt_journal_dev = 18,
	Opt_journal_path = 19,
	Opt_journal_checksum = 20,
	Opt_journal_async_commit = 21,
	Opt_abort = 22,
	Opt_data_journal = 23,
	Opt_data_ordered = 24,
	Opt_data_writeback = 25,
	Opt_data_err_abort = 26,
	Opt_data_err_ignore = 27,
	Opt_test_dummy_encryption = 28,
	Opt_inlinecrypt = 29,
	Opt_usrjquota = 30,
	Opt_grpjquota = 31,
	Opt_quota = 32,
	Opt_noquota = 33,
	Opt_barrier = 34,
	Opt_nobarrier = 35,
	Opt_err = 36,
	Opt_usrquota = 37,
	Opt_grpquota = 38,
	Opt_prjquota = 39,
	Opt_dax = 40,
	Opt_dax_always = 41,
	Opt_dax_inode = 42,
	Opt_dax_never = 43,
	Opt_stripe = 44,
	Opt_delalloc = 45,
	Opt_nodelalloc = 46,
	Opt_warn_on_error = 47,
	Opt_nowarn_on_error = 48,
	Opt_mblk_io_submit = 49,
	Opt_debug_want_extra_isize = 50,
	Opt_nomblk_io_submit = 51,
	Opt_block_validity = 52,
	Opt_noblock_validity = 53,
	Opt_inode_readahead_blks = 54,
	Opt_journal_ioprio = 55,
	Opt_dioread_nolock = 56,
	Opt_dioread_lock = 57,
	Opt_discard = 58,
	Opt_nodiscard = 59,
	Opt_init_itable = 60,
	Opt_noinit_itable = 61,
	Opt_max_dir_size_kb = 62,
	Opt_nojournal_checksum = 63,
	Opt_nombcache = 64,
	Opt_no_prefetch_block_bitmaps = 65,
	Opt_mb_optimize_scan = 66,
	Opt_errors = 67,
	Opt_data = 68,
	Opt_data_err = 69,
	Opt_jqfmt = 70,
	Opt_dax_type = 71,
};

enum {
	Opt_check = 0,
	Opt_uid = 1,
	Opt_gid = 2,
	Opt_umask = 3,
	Opt_dmask = 4,
	Opt_fmask = 5,
	Opt_allow_utime = 6,
	Opt_codepage = 7,
	Opt_usefree = 8,
	Opt_nocase = 9,
	Opt_quiet = 10,
	Opt_showexec = 11,
	Opt_debug___2 = 12,
	Opt_immutable = 13,
	Opt_dots = 14,
	Opt_dotsOK = 15,
	Opt_charset = 16,
	Opt_shortname = 17,
	Opt_utf8 = 18,
	Opt_utf8_bool = 19,
	Opt_uni_xl = 20,
	Opt_uni_xl_bool = 21,
	Opt_nonumtail = 22,
	Opt_nonumtail_bool = 23,
	Opt_obsolete = 24,
	Opt_flush = 25,
	Opt_tz = 26,
	Opt_rodir = 27,
	Opt_errors___2 = 28,
	Opt_discard___2 = 29,
	Opt_nfs = 30,
	Opt_nfs_enum = 31,
	Opt_time_offset = 32,
	Opt_dos1xfloppy = 33,
};

enum {
	Opt_debug___3 = 0,
	Opt_dfltuid = 1,
	Opt_dfltgid = 2,
	Opt_afid = 3,
	Opt_uname = 4,
	Opt_remotename = 5,
	Opt_cache = 6,
	Opt_cachetag = 7,
	Opt_nodevmap = 8,
	Opt_noxattr = 9,
	Opt_directio = 10,
	Opt_ignoreqv = 11,
	Opt_access = 12,
	Opt_posixacl = 13,
	Opt_locktimeout = 14,
	Opt_err___2 = 15,
};

enum {
	Opt_direct = 0,
	Opt_fd = 1,
	Opt_gid___2 = 2,
	Opt_ignore = 3,
	Opt_indirect = 4,
	Opt_maxproto = 5,
	Opt_minproto = 6,
	Opt_offset = 7,
	Opt_pgrp = 8,
	Opt_strictexpire = 9,
	Opt_uid___2 = 10,
};

enum {
	Opt_err___3 = 0,
	Opt_enc = 1,
	Opt_hash = 2,
};

enum {
	Opt_fatal_neterrors_default = 0,
	Opt_fatal_neterrors_enetunreach = 1,
	Opt_fatal_neterrors_none = 2,
};

enum {
	Opt_find_uid = 0,
	Opt_find_gid = 1,
	Opt_find_user = 2,
	Opt_find_group = 3,
	Opt_find_err = 4,
};

enum {
	Opt_kmsg_bytes = 0,
};

enum {
	Opt_local_lock_all = 0,
	Opt_local_lock_flock = 1,
	Opt_local_lock_none = 2,
	Opt_local_lock_posix = 3,
};

enum {
	Opt_lookupcache_all = 0,
	Opt_lookupcache_none = 1,
	Opt_lookupcache_positive = 2,
};

enum {
	Opt_msize = 0,
	Opt_trans = 1,
	Opt_legacy = 2,
	Opt_version = 3,
	Opt_err___4 = 4,
};

enum {
	Opt_port = 0,
	Opt_rfdno = 1,
	Opt_wfdno = 2,
	Opt_err___5 = 3,
	Opt_privport = 4,
};

enum {
	Opt_sec_krb5 = 0,
	Opt_sec_krb5i = 1,
	Opt_sec_krb5p = 2,
	Opt_sec_lkey = 3,
	Opt_sec_lkeyi = 4,
	Opt_sec_lkeyp = 5,
	Opt_sec_none = 6,
	Opt_sec_spkm = 7,
	Opt_sec_spkmi = 8,
	Opt_sec_spkmp = 9,
	Opt_sec_sys = 10,
	nr__Opt_sec = 11,
};

enum {
	Opt_uid___3 = 0,
	Opt_gid___3 = 1,
};

enum {
	Opt_uid___4 = 0,
	Opt_gid___4 = 1,
	Opt_mode = 2,
};

enum {
	Opt_uid___5 = 0,
	Opt_gid___5 = 1,
	Opt_mode___2 = 2,
	Opt_source = 3,
};

enum {
	Opt_uid___6 = 0,
	Opt_gid___6 = 1,
	Opt_mode___3 = 2,
	Opt_ptmxmode = 3,
	Opt_newinstance = 4,
	Opt_max = 5,
	Opt_err___6 = 6,
};

enum {
	Opt_vers_2 = 0,
	Opt_vers_3 = 1,
	Opt_vers_4 = 2,
	Opt_vers_4_0 = 3,
	Opt_vers_4_1 = 4,
	Opt_vers_4_2 = 5,
};

enum {
	Opt_write_lazy = 0,
	Opt_write_eager = 1,
	Opt_write_wait = 2,
};

enum {
	Opt_xprt_rdma = 0,
	Opt_xprt_rdma6 = 1,
	Opt_xprt_tcp = 2,
	Opt_xprt_tcp6 = 3,
	Opt_xprt_udp = 4,
	Opt_xprt_udp6 = 5,
	nr__Opt_xprt = 6,
};

enum {
	Opt_xprtsec_none = 0,
	Opt_xprtsec_tls = 1,
	Opt_xprtsec_mtls = 2,
	nr__Opt_xprtsec = 3,
};

enum {
	PAGE_REPORTING_IDLE = 0,
	PAGE_REPORTING_REQUESTED = 1,
	PAGE_REPORTING_ACTIVE = 2,
};

enum {
	PAGE_WAS_MAPPED = 1,
	PAGE_WAS_MLOCKED = 2,
	PAGE_OLD_STATES = 3,
};

enum {
	PARSE_INVALID = 1,
	PARSE_NOT_LONGNAME = 2,
	PARSE_EOF = 3,
};

enum {
	PCA9450_BUCK1 = 0,
	PCA9450_BUCK2 = 1,
	PCA9450_BUCK3 = 2,
	PCA9450_BUCK4 = 3,
	PCA9450_BUCK5 = 4,
	PCA9450_BUCK6 = 5,
	PCA9450_LDO1 = 6,
	PCA9450_LDO2 = 7,
	PCA9450_LDO3 = 8,
	PCA9450_LDO4 = 9,
	PCA9450_LDO5 = 10,
	PCA9450_REGULATOR_CNT = 11,
};

enum {
	PCA9450_DVS_LEVEL_RUN = 0,
	PCA9450_DVS_LEVEL_STANDBY = 1,
	PCA9450_DVS_LEVEL_MAX = 2,
};

enum {
	PCA9450_REG_DEV_ID = 0,
	PCA9450_REG_INT1 = 1,
	PCA9450_REG_INT1_MSK = 2,
	PCA9450_REG_STATUS1 = 3,
	PCA9450_REG_STATUS2 = 4,
	PCA9450_REG_PWRON_STAT = 5,
	PCA9450_REG_SWRST = 6,
	PCA9450_REG_PWRCTRL = 7,
	PCA9450_REG_RESET_CTRL = 8,
	PCA9450_REG_CONFIG1 = 9,
	PCA9450_REG_CONFIG2 = 10,
	PCA9450_REG_BUCK123_DVS = 12,
	PCA9450_REG_BUCK1OUT_LIMIT = 13,
	PCA9450_REG_BUCK2OUT_LIMIT = 14,
	PCA9450_REG_BUCK3OUT_LIMIT = 15,
	PCA9450_REG_BUCK1CTRL = 16,
	PCA9450_REG_BUCK1OUT_DVS0 = 17,
	PCA9450_REG_BUCK1OUT_DVS1 = 18,
	PCA9450_REG_BUCK2CTRL = 19,
	PCA9450_REG_BUCK2OUT_DVS0 = 20,
	PCA9450_REG_BUCK2OUT_DVS1 = 21,
	PCA9450_REG_BUCK3CTRL = 22,
	PCA9450_REG_BUCK3OUT_DVS0 = 23,
	PCA9450_REG_BUCK3OUT_DVS1 = 24,
	PCA9450_REG_BUCK4CTRL = 25,
	PCA9450_REG_BUCK4OUT = 26,
	PCA9450_REG_BUCK5CTRL = 27,
	PCA9450_REG_BUCK5OUT = 28,
	PCA9450_REG_BUCK6CTRL = 29,
	PCA9450_REG_BUCK6OUT = 30,
	PCA9450_REG_LDO_AD_CTRL = 32,
	PCA9450_REG_LDO1CTRL = 33,
	PCA9450_REG_LDO2CTRL = 34,
	PCA9450_REG_LDO3CTRL = 35,
	PCA9450_REG_LDO4CTRL = 36,
	PCA9450_REG_LDO5CTRL_L = 37,
	PCA9450_REG_LDO5CTRL_H = 38,
	PCA9450_REG_LOADSW_CTRL = 42,
	PCA9450_REG_VRFLT1_STS = 43,
	PCA9450_REG_VRFLT2_STS = 44,
	PCA9450_REG_VRFLT1_MASK = 45,
	PCA9450_REG_VRFLT2_MASK = 46,
	PCA9450_MAX_REGISTER = 47,
};

enum {
	PCI_BRIDGE_EMUL_NO_PREFMEM_FORWARD = 1,
	PCI_BRIDGE_EMUL_NO_IO_FORWARD = 2,
};

enum {
	PCI_DEV_REG1 = 64,
	PCI_DEV_REG2 = 68,
	PCI_DEV_STATUS = 124,
	PCI_DEV_REG3 = 128,
	PCI_DEV_REG4 = 132,
	PCI_DEV_REG5 = 136,
	PCI_CFG_REG_0 = 144,
	PCI_CFG_REG_1 = 148,
	PSM_CONFIG_REG0 = 152,
	PSM_CONFIG_REG1 = 156,
	PSM_CONFIG_REG2 = 352,
	PSM_CONFIG_REG3 = 356,
	PSM_CONFIG_REG4 = 360,
	PCI_LDO_CTRL = 188,
};

enum {
	PCI_ID_F_VFIO_DRIVER_OVERRIDE = 1,
};

enum {
	PCI_REASSIGN_ALL_RSRC = 1,
	PCI_REASSIGN_ALL_BUS = 2,
	PCI_PROBE_ONLY = 4,
	PCI_CAN_SKIP_ISA_ALIGN = 8,
	PCI_ENABLE_PROC_DOMAINS = 16,
	PCI_COMPAT_DOMAIN_0 = 32,
	PCI_SCAN_ALL_PCIE_DEVS = 64,
};

enum {
	PCI_STD_RESOURCES = 0,
	PCI_STD_RESOURCE_END = 5,
	PCI_ROM_RESOURCE = 6,
	PCI_IOV_RESOURCES = 7,
	PCI_IOV_RESOURCE_END = 12,
	PCI_BRIDGE_RESOURCES = 13,
	PCI_BRIDGE_RESOURCE_END = 16,
	PCI_NUM_RESOURCES = 17,
	DEVICE_COUNT_RESOURCE = 17,
};

enum {
	PC_VAUX_ENA = 128,
	PC_VAUX_DIS = 64,
	PC_VCC_ENA = 32,
	PC_VCC_DIS = 16,
	PC_VAUX_ON = 8,
	PC_VAUX_OFF = 4,
	PC_VCC_ON = 2,
	PC_VCC_OFF = 1,
};

enum {
	PERCPU_REF_INIT_ATOMIC = 1,
	PERCPU_REF_INIT_DEAD = 2,
	PERCPU_REF_ALLOW_REINIT = 4,
};

enum {
	PERF_FC_LEVEL = 0,
	PERF_FC_LIMIT = 1,
	PERF_FC_MAX = 2,
};

enum {
	PER_LINUX = 0,
	PER_LINUX_32BIT = 8388608,
	PER_LINUX_FDPIC = 524288,
	PER_SVR4 = 68157441,
	PER_SVR3 = 83886082,
	PER_SCOSVR3 = 117440515,
	PER_OSR5 = 100663299,
	PER_WYSEV386 = 83886084,
	PER_ISCR4 = 67108869,
	PER_BSD = 6,
	PER_SUNOS = 67108870,
	PER_XENIX = 83886087,
	PER_LINUX32 = 8,
	PER_LINUX32_3GB = 134217736,
	PER_IRIX32 = 67108873,
	PER_IRIXN32 = 67108874,
	PER_IRIX64 = 67108875,
	PER_RISCOS = 12,
	PER_SOLARIS = 67108877,
	PER_UW7 = 68157454,
	PER_OSF4 = 15,
	PER_HPUX = 16,
	PER_MASK = 255,
};

enum {
	PEX_RD_ACCESS = -2147483648,
	PEX_DB_ACCESS = 1073741824,
};

enum {
	PG_BUSY = 0,
	PG_MAPPED = 1,
	PG_FOLIO = 2,
	PG_CLEAN = 3,
	PG_COMMIT_TO_DS = 4,
	PG_INODE_REF = 5,
	PG_HEADLOCK = 6,
	PG_TEARDOWN = 7,
	PG_UNLOCKPAGE = 8,
	PG_UPTODATE = 9,
	PG_WB_END = 10,
	PG_REMOVE = 11,
	PG_CONTENDED1 = 12,
	PG_CONTENDED2 = 13,
};

enum {
	PHYLINK_DISABLE_STOPPED = 0,
	PHYLINK_DISABLE_LINK = 1,
	PHYLINK_DISABLE_MAC_WOL = 2,
	PCS_STATE_DOWN = 0,
	PCS_STATE_STARTING = 1,
	PCS_STATE_STARTED = 2,
};

enum {
	PHY_ADDR_MARV = 0,
};

enum {
	PHY_AN_NXT_PG = 32768,
	PHY_AN_ACK = 16384,
	PHY_AN_RF = 8192,
	PHY_AN_PAUSE_ASYM = 2048,
	PHY_AN_PAUSE_CAP = 1024,
	PHY_AN_100BASE4 = 512,
	PHY_AN_100FULL = 256,
	PHY_AN_100HALF = 128,
	PHY_AN_10FULL = 64,
	PHY_AN_10HALF = 32,
	PHY_AN_CSMA = 1,
	PHY_AN_SEL = 31,
	PHY_AN_FULL = 321,
	PHY_AN_ALL = 480,
};

enum {
	PHY_CT_RESET = 32768,
	PHY_CT_LOOP = 16384,
	PHY_CT_SPS_LSB = 8192,
	PHY_CT_ANE = 4096,
	PHY_CT_PDOWN = 2048,
	PHY_CT_ISOL = 1024,
	PHY_CT_RE_CFG = 512,
	PHY_CT_DUP_MD = 256,
	PHY_CT_COL_TST = 128,
	PHY_CT_SPS_MSB = 64,
};

enum {
	PHY_CT_SP1000 = 64,
	PHY_CT_SP100 = 8192,
	PHY_CT_SP10 = 0,
};

enum {
	PHY_GMII_SEL_PORT_MODE = 0,
	PHY_GMII_SEL_RGMII_ID_MODE = 1,
	PHY_GMII_SEL_RMII_IO_CLK_EN = 2,
	PHY_GMII_SEL_LAST = 3,
};

enum {
	PHY_MARV_CTRL = 0,
	PHY_MARV_STAT = 1,
	PHY_MARV_ID0 = 2,
	PHY_MARV_ID1 = 3,
	PHY_MARV_AUNE_ADV = 4,
	PHY_MARV_AUNE_LP = 5,
	PHY_MARV_AUNE_EXP = 6,
	PHY_MARV_NEPG = 7,
	PHY_MARV_NEPG_LP = 8,
	PHY_MARV_1000T_CTRL = 9,
	PHY_MARV_1000T_STAT = 10,
	PHY_MARV_EXT_STAT = 15,
	PHY_MARV_PHY_CTRL = 16,
	PHY_MARV_PHY_STAT = 17,
	PHY_MARV_INT_MASK = 18,
	PHY_MARV_INT_STAT = 19,
	PHY_MARV_EXT_CTRL = 20,
	PHY_MARV_RXE_CNT = 21,
	PHY_MARV_EXT_ADR = 22,
	PHY_MARV_PORT_IRQ = 23,
	PHY_MARV_LED_CTRL = 24,
	PHY_MARV_LED_OVER = 25,
	PHY_MARV_EXT_CTRL_2 = 26,
	PHY_MARV_EXT_P_STAT = 27,
	PHY_MARV_CABLE_DIAG = 28,
	PHY_MARV_PAGE_ADDR = 29,
	PHY_MARV_PAGE_DATA = 30,
	PHY_MARV_FE_LED_PAR = 22,
	PHY_MARV_FE_LED_SER = 23,
	PHY_MARV_FE_VCT_TX = 26,
	PHY_MARV_FE_VCT_RX = 27,
	PHY_MARV_FE_SPEC_2 = 28,
};

enum {
	PHY_MARV_ID0_VAL = 321,
	PHY_BCOM_ID1_A1 = 24641,
	PHY_BCOM_ID1_B2 = 24643,
	PHY_BCOM_ID1_C0 = 24644,
	PHY_BCOM_ID1_C5 = 24647,
	PHY_MARV_ID1_B0 = 3107,
	PHY_MARV_ID1_B2 = 3109,
	PHY_MARV_ID1_C2 = 3266,
	PHY_MARV_ID1_Y2 = 3217,
	PHY_MARV_ID1_FE = 3203,
	PHY_MARV_ID1_ECU = 3248,
};

enum {
	PHY_M_1000C_TEST = 57344,
	PHY_M_1000C_MSE = 4096,
	PHY_M_1000C_MSC = 2048,
	PHY_M_1000C_MPD = 1024,
	PHY_M_1000C_AFD = 512,
	PHY_M_1000C_AHD = 256,
};

enum {
	PHY_M_AN_ASP_X = 256,
	PHY_M_AN_PC_X = 128,
	PHY_M_AN_1000X_AHD = 64,
	PHY_M_AN_1000X_AFD = 32,
};

enum {
	PHY_M_AN_NXT_PG = 32768,
	PHY_M_AN_ACK = 16384,
	PHY_M_AN_RF = 8192,
	PHY_M_AN_ASP = 2048,
	PHY_M_AN_PC = 1024,
	PHY_M_AN_100_T4 = 512,
	PHY_M_AN_100_FD = 256,
	PHY_M_AN_100_HD = 128,
	PHY_M_AN_10_FD = 64,
	PHY_M_AN_10_HD = 32,
	PHY_M_AN_SEL_MSK = 496,
};

enum {
	PHY_M_EC_ENA_BC_EXT = 32768,
	PHY_M_EC_ENA_LIN_LB = 16384,
	PHY_M_EC_DIS_LINK_P = 4096,
	PHY_M_EC_M_DSC_MSK = 3072,
	PHY_M_EC_S_DSC_MSK = 768,
	PHY_M_EC_M_DSC_MSK2 = 3584,
	PHY_M_EC_DOWN_S_ENA = 256,
	PHY_M_EC_RX_TIM_CT = 128,
	PHY_M_EC_MAC_S_MSK = 112,
	PHY_M_EC_FIB_AN_ENA = 8,
	PHY_M_EC_DTE_D_ENA = 4,
	PHY_M_EC_TX_TIM_CT = 2,
	PHY_M_EC_TRANS_DIS = 1,
	PHY_M_10B_TE_ENABLE = 128,
};

enum {
	PHY_M_FC_AUTO_SEL = 32768,
	PHY_M_FC_AN_REG_ACC = 16384,
	PHY_M_FC_RESOLUTION = 8192,
	PHY_M_SER_IF_AN_BP = 4096,
	PHY_M_SER_IF_BP_ST = 2048,
	PHY_M_IRQ_POLARITY = 1024,
	PHY_M_DIS_AUT_MED = 512,
	PHY_M_UNDOC1 = 128,
	PHY_M_DTE_POW_STAT = 16,
	PHY_M_MODE_MASK = 15,
};

enum {
	PHY_M_FELP_LED2_MSK = 3840,
	PHY_M_FELP_LED1_MSK = 240,
	PHY_M_FELP_LED0_MSK = 15,
};

enum {
	PHY_M_FESC_DIS_WAIT = 4,
	PHY_M_FESC_ENA_MCLK = 2,
	PHY_M_FESC_SEL_CL_A = 1,
};

enum {
	PHY_M_FIB_FORCE_LNK = 1024,
	PHY_M_FIB_SIGD_POL = 512,
	PHY_M_FIB_TX_DIS = 8,
};

enum {
	PHY_M_IS_AN_ERROR = 32768,
	PHY_M_IS_LSP_CHANGE = 16384,
	PHY_M_IS_DUP_CHANGE = 8192,
	PHY_M_IS_AN_PR = 4096,
	PHY_M_IS_AN_COMPL = 2048,
	PHY_M_IS_LST_CHANGE = 1024,
	PHY_M_IS_SYMB_ERROR = 512,
	PHY_M_IS_FALSE_CARR = 256,
	PHY_M_IS_FIFO_ERROR = 128,
	PHY_M_IS_MDI_CHANGE = 64,
	PHY_M_IS_DOWNSH_DET = 32,
	PHY_M_IS_END_CHANGE = 16,
	PHY_M_IS_DTE_CHANGE = 4,
	PHY_M_IS_POL_CHANGE = 2,
	PHY_M_IS_JABBER = 1,
	PHY_M_DEF_MSK = 25600,
	PHY_M_AN_MSK = 34816,
};

enum {
	PHY_M_LEDC_DIS_LED = 32768,
	PHY_M_LEDC_PULS_MSK = 28672,
	PHY_M_LEDC_F_INT = 2048,
	PHY_M_LEDC_BL_R_MSK = 1792,
	PHY_M_LEDC_DP_C_LSB = 128,
	PHY_M_LEDC_TX_C_LSB = 64,
	PHY_M_LEDC_LK_C_MSK = 56,
};

enum {
	PHY_M_LEDC_LINK_MSK = 24,
	PHY_M_LEDC_DP_CTRL = 4,
	PHY_M_LEDC_DP_C_MSB = 4,
	PHY_M_LEDC_RX_CTRL = 2,
	PHY_M_LEDC_TX_CTRL = 1,
	PHY_M_LEDC_TX_C_MSB = 1,
};

enum {
	PHY_M_LEDC_LOS_MSK = 61440,
	PHY_M_LEDC_INIT_MSK = 3840,
	PHY_M_LEDC_STA1_MSK = 240,
	PHY_M_LEDC_STA0_MSK = 15,
};

enum {
	PHY_M_MAC_MD_MSK = 896,
	PHY_M_MAC_GMIF_PUP = 8,
	PHY_M_MAC_MD_AUTO = 3,
	PHY_M_MAC_MD_COPPER = 5,
	PHY_M_MAC_MD_1000BX = 7,
};

enum {
	PHY_M_PC_COP_TX_DIS = 8,
	PHY_M_PC_POW_D_ENA = 4,
};

enum {
	PHY_M_PC_DIS_LINK_Pa = 32768,
	PHY_M_PC_DSC_MSK = 28672,
	PHY_M_PC_DOWN_S_ENA = 2048,
};

enum {
	PHY_M_PC_ENA_DTE_DT = 32768,
	PHY_M_PC_ENA_ENE_DT = 16384,
	PHY_M_PC_DIS_NLP_CK = 8192,
	PHY_M_PC_ENA_LIP_NP = 4096,
	PHY_M_PC_DIS_NLP_GN = 2048,
	PHY_M_PC_DIS_SCRAMB = 512,
	PHY_M_PC_DIS_FEFI = 256,
	PHY_M_PC_SH_TP_SEL = 64,
	PHY_M_PC_RX_FD_MSK = 12,
};

enum {
	PHY_M_PC_MAN_MDI = 0,
	PHY_M_PC_MAN_MDIX = 1,
	PHY_M_PC_ENA_AUTO = 3,
};

enum {
	PHY_M_PC_TX_FFD_MSK = 49152,
	PHY_M_PC_RX_FFD_MSK = 12288,
	PHY_M_PC_ASS_CRS_TX = 2048,
	PHY_M_PC_FL_GOOD = 1024,
	PHY_M_PC_EN_DET_MSK = 768,
	PHY_M_PC_ENA_EXT_D = 128,
	PHY_M_PC_MDIX_MSK = 96,
	PHY_M_PC_DIS_125CLK = 16,
	PHY_M_PC_MAC_POW_UP = 8,
	PHY_M_PC_SQE_T_ENA = 4,
	PHY_M_PC_POL_R_DIS = 2,
	PHY_M_PC_DIS_JABBER = 1,
};

enum {
	PHY_M_POLC_LS1M_MSK = 61440,
	PHY_M_POLC_IS0M_MSK = 3840,
	PHY_M_POLC_LOS_MSK = 192,
	PHY_M_POLC_INIT_MSK = 48,
	PHY_M_POLC_STA1_MSK = 12,
	PHY_M_POLC_STA0_MSK = 3,
};

enum {
	PHY_M_PS_SPEED_MSK = 49152,
	PHY_M_PS_SPEED_1000 = 32768,
	PHY_M_PS_SPEED_100 = 16384,
	PHY_M_PS_SPEED_10 = 0,
	PHY_M_PS_FULL_DUP = 8192,
	PHY_M_PS_PAGE_REC = 4096,
	PHY_M_PS_SPDUP_RES = 2048,
	PHY_M_PS_LINK_UP = 1024,
	PHY_M_PS_CABLE_MSK = 896,
	PHY_M_PS_MDI_X_STAT = 64,
	PHY_M_PS_DOWNS_STAT = 32,
	PHY_M_PS_ENDET_STAT = 16,
	PHY_M_PS_TX_P_EN = 8,
	PHY_M_PS_RX_P_EN = 4,
	PHY_M_PS_POL_REV = 2,
	PHY_M_PS_JABBER = 1,
};

enum {
	PHY_M_P_NO_PAUSE_X = 0,
	PHY_M_P_SYM_MD_X = 128,
	PHY_M_P_ASYM_MD_X = 256,
	PHY_M_P_BOTH_MD_X = 384,
};

enum {
	PINCTRL_PIN_REG_MODE = 0,
	PINCTRL_PIN_REG_DIR = 1,
	PINCTRL_PIN_REG_DI = 2,
	PINCTRL_PIN_REG_DO = 3,
	PINCTRL_PIN_REG_SR = 4,
	PINCTRL_PIN_REG_SMT = 5,
	PINCTRL_PIN_REG_PD = 6,
	PINCTRL_PIN_REG_PU = 7,
	PINCTRL_PIN_REG_E4 = 8,
	PINCTRL_PIN_REG_E8 = 9,
	PINCTRL_PIN_REG_TDSEL = 10,
	PINCTRL_PIN_REG_RDSEL = 11,
	PINCTRL_PIN_REG_DRV = 12,
	PINCTRL_PIN_REG_PUPD = 13,
	PINCTRL_PIN_REG_R0 = 14,
	PINCTRL_PIN_REG_R1 = 15,
	PINCTRL_PIN_REG_IES = 16,
	PINCTRL_PIN_REG_PULLEN = 17,
	PINCTRL_PIN_REG_PULLSEL = 18,
	PINCTRL_PIN_REG_DRV_EN = 19,
	PINCTRL_PIN_REG_DRV_E0 = 20,
	PINCTRL_PIN_REG_DRV_E1 = 21,
	PINCTRL_PIN_REG_DRV_ADV = 22,
	PINCTRL_PIN_REG_RSEL = 23,
	PINCTRL_PIN_REG_MAX = 24,
};

enum {
	PINMUX_RESERVED = 0,
	PINMUX_DATA_BEGIN = 1,
	GP_0_0_DATA = 2,
	GP_0_1_DATA = 3,
	GP_0_2_DATA = 4,
	GP_0_3_DATA = 5,
	GP_0_4_DATA = 6,
	GP_0_5_DATA = 7,
	GP_0_6_DATA = 8,
	GP_0_7_DATA = 9,
	GP_0_8_DATA = 10,
	GP_0_9_DATA = 11,
	GP_0_10_DATA = 12,
	GP_0_11_DATA = 13,
	GP_0_12_DATA = 14,
	GP_0_13_DATA = 15,
	GP_0_14_DATA = 16,
	GP_0_15_DATA = 17,
	GP_1_0_DATA = 18,
	GP_1_1_DATA = 19,
	GP_1_2_DATA = 20,
	GP_1_3_DATA = 21,
	GP_1_4_DATA = 22,
	GP_1_5_DATA = 23,
	GP_1_6_DATA = 24,
	GP_1_7_DATA = 25,
	GP_1_8_DATA = 26,
	GP_1_9_DATA = 27,
	GP_1_10_DATA = 28,
	GP_1_11_DATA = 29,
	GP_1_12_DATA = 30,
	GP_1_13_DATA = 31,
	GP_1_14_DATA = 32,
	GP_1_15_DATA = 33,
	GP_1_16_DATA = 34,
	GP_1_17_DATA = 35,
	GP_1_18_DATA = 36,
	GP_1_19_DATA = 37,
	GP_1_20_DATA = 38,
	GP_1_21_DATA = 39,
	GP_1_22_DATA = 40,
	GP_1_23_DATA = 41,
	GP_1_24_DATA = 42,
	GP_1_25_DATA = 43,
	GP_1_26_DATA = 44,
	GP_1_27_DATA = 45,
	GP_1_28_DATA = 46,
	GP_2_0_DATA = 47,
	GP_2_1_DATA = 48,
	GP_2_2_DATA = 49,
	GP_2_3_DATA = 50,
	GP_2_4_DATA = 51,
	GP_2_5_DATA = 52,
	GP_2_6_DATA = 53,
	GP_2_7_DATA = 54,
	GP_2_8_DATA = 55,
	GP_2_9_DATA = 56,
	GP_2_10_DATA = 57,
	GP_2_11_DATA = 58,
	GP_2_12_DATA = 59,
	GP_2_13_DATA = 60,
	GP_2_14_DATA = 61,
	GP_3_0_DATA = 62,
	GP_3_1_DATA = 63,
	GP_3_2_DATA = 64,
	GP_3_3_DATA = 65,
	GP_3_4_DATA = 66,
	GP_3_5_DATA = 67,
	GP_3_6_DATA = 68,
	GP_3_7_DATA = 69,
	GP_3_8_DATA = 70,
	GP_3_9_DATA = 71,
	GP_3_10_DATA = 72,
	GP_3_11_DATA = 73,
	GP_3_12_DATA = 74,
	GP_3_13_DATA = 75,
	GP_3_14_DATA = 76,
	GP_3_15_DATA = 77,
	GP_4_0_DATA = 78,
	GP_4_1_DATA = 79,
	GP_4_2_DATA = 80,
	GP_4_3_DATA = 81,
	GP_4_4_DATA = 82,
	GP_4_5_DATA = 83,
	GP_4_6_DATA = 84,
	GP_4_7_DATA = 85,
	GP_4_8_DATA = 86,
	GP_4_9_DATA = 87,
	GP_4_10_DATA = 88,
	GP_4_11_DATA = 89,
	GP_4_12_DATA = 90,
	GP_4_13_DATA = 91,
	GP_4_14_DATA = 92,
	GP_4_15_DATA = 93,
	GP_4_16_DATA = 94,
	GP_4_17_DATA = 95,
	GP_5_0_DATA = 96,
	GP_5_1_DATA = 97,
	GP_5_2_DATA = 98,
	GP_5_3_DATA = 99,
	GP_5_4_DATA = 100,
	GP_5_5_DATA = 101,
	GP_5_6_DATA = 102,
	GP_5_7_DATA = 103,
	GP_5_8_DATA = 104,
	GP_5_9_DATA = 105,
	GP_5_10_DATA = 106,
	GP_5_11_DATA = 107,
	GP_5_12_DATA = 108,
	GP_5_13_DATA = 109,
	GP_5_14_DATA = 110,
	GP_5_15_DATA = 111,
	GP_5_16_DATA = 112,
	GP_5_17_DATA = 113,
	GP_5_18_DATA = 114,
	GP_5_19_DATA = 115,
	GP_5_20_DATA = 116,
	GP_5_21_DATA = 117,
	GP_5_22_DATA = 118,
	GP_5_23_DATA = 119,
	GP_5_24_DATA = 120,
	GP_5_25_DATA = 121,
	GP_6_0_DATA = 122,
	GP_6_1_DATA = 123,
	GP_6_2_DATA = 124,
	GP_6_3_DATA = 125,
	GP_6_4_DATA = 126,
	GP_6_5_DATA = 127,
	GP_6_6_DATA = 128,
	GP_6_7_DATA = 129,
	GP_6_8_DATA = 130,
	GP_6_9_DATA = 131,
	GP_6_10_DATA = 132,
	GP_6_11_DATA = 133,
	GP_6_12_DATA = 134,
	GP_6_13_DATA = 135,
	GP_6_14_DATA = 136,
	GP_6_15_DATA = 137,
	GP_6_16_DATA = 138,
	GP_6_17_DATA = 139,
	GP_6_18_DATA = 140,
	GP_6_19_DATA = 141,
	GP_6_20_DATA = 142,
	GP_6_21_DATA = 143,
	GP_6_22_DATA = 144,
	GP_6_23_DATA = 145,
	GP_6_24_DATA = 146,
	GP_6_25_DATA = 147,
	GP_6_26_DATA = 148,
	GP_6_27_DATA = 149,
	GP_6_28_DATA = 150,
	GP_6_29_DATA = 151,
	GP_6_30_DATA = 152,
	GP_6_31_DATA = 153,
	GP_7_0_DATA = 154,
	GP_7_1_DATA = 155,
	GP_7_2_DATA = 156,
	GP_7_3_DATA = 157,
	PINMUX_DATA_END = 158,
	PINMUX_FUNCTION_BEGIN = 159,
	GP_0_0_FN = 160,
	GP_0_1_FN = 161,
	GP_0_2_FN = 162,
	GP_0_3_FN = 163,
	GP_0_4_FN = 164,
	GP_0_5_FN = 165,
	GP_0_6_FN = 166,
	GP_0_7_FN = 167,
	GP_0_8_FN = 168,
	GP_0_9_FN = 169,
	GP_0_10_FN = 170,
	GP_0_11_FN = 171,
	GP_0_12_FN = 172,
	GP_0_13_FN = 173,
	GP_0_14_FN = 174,
	GP_0_15_FN = 175,
	GP_1_0_FN = 176,
	GP_1_1_FN = 177,
	GP_1_2_FN = 178,
	GP_1_3_FN = 179,
	GP_1_4_FN = 180,
	GP_1_5_FN = 181,
	GP_1_6_FN = 182,
	GP_1_7_FN = 183,
	GP_1_8_FN = 184,
	GP_1_9_FN = 185,
	GP_1_10_FN = 186,
	GP_1_11_FN = 187,
	GP_1_12_FN = 188,
	GP_1_13_FN = 189,
	GP_1_14_FN = 190,
	GP_1_15_FN = 191,
	GP_1_16_FN = 192,
	GP_1_17_FN = 193,
	GP_1_18_FN = 194,
	GP_1_19_FN = 195,
	GP_1_20_FN = 196,
	GP_1_21_FN = 197,
	GP_1_22_FN = 198,
	GP_1_23_FN = 199,
	GP_1_24_FN = 200,
	GP_1_25_FN = 201,
	GP_1_26_FN = 202,
	GP_1_27_FN = 203,
	GP_1_28_FN = 204,
	GP_2_0_FN = 205,
	GP_2_1_FN = 206,
	GP_2_2_FN = 207,
	GP_2_3_FN = 208,
	GP_2_4_FN = 209,
	GP_2_5_FN = 210,
	GP_2_6_FN = 211,
	GP_2_7_FN = 212,
	GP_2_8_FN = 213,
	GP_2_9_FN = 214,
	GP_2_10_FN = 215,
	GP_2_11_FN = 216,
	GP_2_12_FN = 217,
	GP_2_13_FN = 218,
	GP_2_14_FN = 219,
	GP_3_0_FN = 220,
	GP_3_1_FN = 221,
	GP_3_2_FN = 222,
	GP_3_3_FN = 223,
	GP_3_4_FN = 224,
	GP_3_5_FN = 225,
	GP_3_6_FN = 226,
	GP_3_7_FN = 227,
	GP_3_8_FN = 228,
	GP_3_9_FN = 229,
	GP_3_10_FN = 230,
	GP_3_11_FN = 231,
	GP_3_12_FN = 232,
	GP_3_13_FN = 233,
	GP_3_14_FN = 234,
	GP_3_15_FN = 235,
	GP_4_0_FN = 236,
	GP_4_1_FN = 237,
	GP_4_2_FN = 238,
	GP_4_3_FN = 239,
	GP_4_4_FN = 240,
	GP_4_5_FN = 241,
	GP_4_6_FN = 242,
	GP_4_7_FN = 243,
	GP_4_8_FN = 244,
	GP_4_9_FN = 245,
	GP_4_10_FN = 246,
	GP_4_11_FN = 247,
	GP_4_12_FN = 248,
	GP_4_13_FN = 249,
	GP_4_14_FN = 250,
	GP_4_15_FN = 251,
	GP_4_16_FN = 252,
	GP_4_17_FN = 253,
	GP_5_0_FN = 254,
	GP_5_1_FN = 255,
	GP_5_2_FN = 256,
	GP_5_3_FN = 257,
	GP_5_4_FN = 258,
	GP_5_5_FN = 259,
	GP_5_6_FN = 260,
	GP_5_7_FN = 261,
	GP_5_8_FN = 262,
	GP_5_9_FN = 263,
	GP_5_10_FN = 264,
	GP_5_11_FN = 265,
	GP_5_12_FN = 266,
	GP_5_13_FN = 267,
	GP_5_14_FN = 268,
	GP_5_15_FN = 269,
	GP_5_16_FN = 270,
	GP_5_17_FN = 271,
	GP_5_18_FN = 272,
	GP_5_19_FN = 273,
	GP_5_20_FN = 274,
	GP_5_21_FN = 275,
	GP_5_22_FN = 276,
	GP_5_23_FN = 277,
	GP_5_24_FN = 278,
	GP_5_25_FN = 279,
	GP_6_0_FN = 280,
	GP_6_1_FN = 281,
	GP_6_2_FN = 282,
	GP_6_3_FN = 283,
	GP_6_4_FN = 284,
	GP_6_5_FN = 285,
	GP_6_6_FN = 286,
	GP_6_7_FN = 287,
	GP_6_8_FN = 288,
	GP_6_9_FN = 289,
	GP_6_10_FN = 290,
	GP_6_11_FN = 291,
	GP_6_12_FN = 292,
	GP_6_13_FN = 293,
	GP_6_14_FN = 294,
	GP_6_15_FN = 295,
	GP_6_16_FN = 296,
	GP_6_17_FN = 297,
	GP_6_18_FN = 298,
	GP_6_19_FN = 299,
	GP_6_20_FN = 300,
	GP_6_21_FN = 301,
	GP_6_22_FN = 302,
	GP_6_23_FN = 303,
	GP_6_24_FN = 304,
	GP_6_25_FN = 305,
	GP_6_26_FN = 306,
	GP_6_27_FN = 307,
	GP_6_28_FN = 308,
	GP_6_29_FN = 309,
	GP_6_30_FN = 310,
	GP_6_31_FN = 311,
	GP_7_0_FN = 312,
	GP_7_1_FN = 313,
	GP_7_2_FN = 314,
	GP_7_3_FN = 315,
	FN_CLKOUT = 316,
	FN_MSIOF0_RXD = 317,
	FN_MSIOF0_TXD = 318,
	FN_MSIOF0_SCK = 319,
	FN_SSI_SDATA5 = 320,
	FN_SSI_WS5 = 321,
	FN_SSI_SCK5 = 322,
	FN_GP7_03 = 323,
	FN_GP7_02 = 324,
	FN_AVS2 = 325,
	FN_AVS1 = 326,
	FN_IP0_3_0 = 327,
	FN_AVB_MDC = 328,
	FN_MSIOF2_SS2_C = 329,
	FN_IP1_3_0 = 330,
	FN_IRQ2 = 331,
	FN_QCPV_QDE = 332,
	FN_DU_EXODDF_DU_ODDF_DISP_CDE = 333,
	FN_VI4_DATA2_B = 334,
	FN_MSIOF3_SYNC_E = 335,
	FN_PWM3_B = 336,
	FN_IP2_3_0 = 337,
	FN_A1 = 338,
	FN_LCDOUT17 = 339,
	FN_MSIOF3_TXD_B = 340,
	FN_VI4_DATA9 = 341,
	FN_DU_DB1 = 342,
	FN_PWM4_A = 343,
	FN_IP3_3_0 = 344,
	FN_A9 = 345,
	FN_MSIOF2_SCK_A = 346,
	FN_CTS4_N_B = 347,
	FN_VI5_VSYNC_N = 348,
	FN_IP0_7_4 = 349,
	FN_AVB_MAGIC = 350,
	FN_MSIOF2_SS1_C = 351,
	FN_SCK4_A = 352,
	FN_IP1_7_4 = 353,
	FN_IRQ3 = 354,
	FN_QSTVB_QVE = 355,
	FN_DU_DOTCLKOUT1 = 356,
	FN_VI4_DATA3_B = 357,
	FN_MSIOF3_SCK_E = 358,
	FN_PWM4_B = 359,
	FN_IP2_7_4 = 360,
	FN_A2 = 361,
	FN_LCDOUT18 = 362,
	FN_MSIOF3_SCK_B = 363,
	FN_VI4_DATA10 = 364,
	FN_DU_DB2 = 365,
	FN_PWM5_A = 366,
	FN_IP3_7_4 = 367,
	FN_A10 = 368,
	FN_MSIOF2_RXD_A = 369,
	FN_RTS4_N_B = 370,
	FN_VI5_HSYNC_N = 371,
	FN_IP0_11_8 = 372,
	FN_AVB_PHY_INT = 373,
	FN_MSIOF2_SYNC_C = 374,
	FN_RX4_A = 375,
	FN_IP1_11_8 = 376,
	FN_IRQ4 = 377,
	FN_QSTH_QHS = 378,
	FN_DU_EXHSYNC_DU_HSYNC = 379,
	FN_VI4_DATA4_B = 380,
	FN_MSIOF3_RXD_E = 381,
	FN_PWM5_B = 382,
	FN_IP2_11_8 = 383,
	FN_A3 = 384,
	FN_LCDOUT19 = 385,
	FN_MSIOF3_RXD_B = 386,
	FN_VI4_DATA11 = 387,
	FN_DU_DB3 = 388,
	FN_PWM6_A = 389,
	FN_IP3_11_8 = 390,
	FN_A11 = 391,
	FN_TX3_B = 392,
	FN_MSIOF2_TXD_A = 393,
	FN_HTX4_B = 394,
	FN_HSCK4 = 395,
	FN_VI5_FIELD = 396,
	FN_SCL6_A = 397,
	FN_AVB_AVTP_CAPTURE_B = 398,
	FN_PWM2_B = 399,
	FN_IP0_15_12 = 400,
	FN_AVB_LINK = 401,
	FN_MSIOF2_SCK_C = 402,
	FN_TX4_A = 403,
	FN_IP1_15_12 = 404,
	FN_IRQ5 = 405,
	FN_QSTB_QHE = 406,
	FN_DU_EXVSYNC_DU_VSYNC = 407,
	FN_VI4_DATA5_B = 408,
	FN_MSIOF3_TXD_E = 409,
	FN_PWM6_B = 410,
	FN_IP2_15_12 = 411,
	FN_A4 = 412,
	FN_LCDOUT20 = 413,
	FN_MSIOF3_SS1_B = 414,
	FN_VI4_DATA12 = 415,
	FN_VI5_DATA12 = 416,
	FN_DU_DB4 = 417,
	FN_IP3_15_12 = 418,
	FN_A12 = 419,
	FN_LCDOUT12 = 420,
	FN_MSIOF3_SCK_C = 421,
	FN_HRX4_A = 422,
	FN_VI5_DATA8 = 423,
	FN_DU_DG4 = 424,
	FN_IP0_19_16 = 425,
	FN_AVB_AVTP_MATCH_A = 426,
	FN_MSIOF2_RXD_C = 427,
	FN_CTS4_N_A = 428,
	FN_IP1_19_16 = 429,
	FN_PWM0 = 430,
	FN_AVB_AVTP_PPS = 431,
	FN_VI4_DATA6_B = 432,
	FN_IECLK_B = 433,
	FN_IP2_19_16 = 434,
	FN_A5 = 435,
	FN_LCDOUT21 = 436,
	FN_MSIOF3_SS2_B = 437,
	FN_SCK4_B = 438,
	FN_VI4_DATA13 = 439,
	FN_VI5_DATA13 = 440,
	FN_DU_DB5 = 441,
	FN_IP3_19_16 = 442,
	FN_A13 = 443,
	FN_LCDOUT13 = 444,
	FN_MSIOF3_SYNC_C = 445,
	FN_HTX4_A = 446,
	FN_VI5_DATA9 = 447,
	FN_DU_DG5 = 448,
	FN_IP0_23_20 = 449,
	FN_AVB_AVTP_CAPTURE_A = 450,
	FN_MSIOF2_TXD_C = 451,
	FN_RTS4_N_A = 452,
	FN_IP1_23_20 = 453,
	FN_PWM1_A = 454,
	FN_HRX3_D = 455,
	FN_VI4_DATA7_B = 456,
	FN_IERX_B = 457,
	FN_IP2_23_20 = 458,
	FN_A6 = 459,
	FN_LCDOUT22 = 460,
	FN_MSIOF2_SS1_A = 461,
	FN_RX4_B = 462,
	FN_VI4_DATA14 = 463,
	FN_VI5_DATA14 = 464,
	FN_DU_DB6 = 465,
	FN_IP3_23_20 = 466,
	FN_A14 = 467,
	FN_LCDOUT14 = 468,
	FN_MSIOF3_RXD_C = 469,
	FN_HCTS4_N = 470,
	FN_VI5_DATA10 = 471,
	FN_DU_DG6 = 472,
	FN_IP0_27_24 = 473,
	FN_IRQ0 = 474,
	FN_QPOLB = 475,
	FN_DU_CDE = 476,
	FN_VI4_DATA0_B = 477,
	FN_CAN0_TX_B = 478,
	FN_CANFD0_TX_B = 479,
	FN_MSIOF3_SS2_E = 480,
	FN_IP1_27_24 = 481,
	FN_PWM2_A = 482,
	FN_HTX3_D = 483,
	FN_IETX_B = 484,
	FN_IP2_27_24 = 485,
	FN_A7 = 486,
	FN_LCDOUT23 = 487,
	FN_MSIOF2_SS2_A = 488,
	FN_TX4_B = 489,
	FN_VI4_DATA15 = 490,
	FN_VI5_DATA15 = 491,
	FN_DU_DB7 = 492,
	FN_IP3_27_24 = 493,
	FN_A15 = 494,
	FN_LCDOUT15 = 495,
	FN_MSIOF3_TXD_C = 496,
	FN_HRTS4_N = 497,
	FN_VI5_DATA11 = 498,
	FN_DU_DG7 = 499,
	FN_IP0_31_28 = 500,
	FN_IRQ1 = 501,
	FN_QPOLA = 502,
	FN_DU_DISP = 503,
	FN_VI4_DATA1_B = 504,
	FN_CAN0_RX_B = 505,
	FN_CANFD0_RX_B = 506,
	FN_MSIOF3_SS1_E = 507,
	FN_IP1_31_28 = 508,
	FN_A0 = 509,
	FN_LCDOUT16 = 510,
	FN_MSIOF3_SYNC_B = 511,
	FN_VI4_DATA8 = 512,
	FN_DU_DB0 = 513,
	FN_PWM3_A = 514,
	FN_IP2_31_28 = 515,
	FN_A8 = 516,
	FN_RX3_B = 517,
	FN_MSIOF2_SYNC_A = 518,
	FN_HRX4_B = 519,
	FN_SDA6_A = 520,
	FN_AVB_AVTP_MATCH_B = 521,
	FN_PWM1_B = 522,
	FN_IP3_31_28 = 523,
	FN_A16 = 524,
	FN_LCDOUT8 = 525,
	FN_VI4_FIELD = 526,
	FN_DU_DG0 = 527,
	FN_IP4_3_0 = 528,
	FN_A17 = 529,
	FN_LCDOUT9 = 530,
	FN_VI4_VSYNC_N = 531,
	FN_DU_DG1 = 532,
	FN_IP5_3_0 = 533,
	FN_WE0_N = 534,
	FN_MSIOF3_TXD_D = 535,
	FN_CTS3_N = 536,
	FN_HCTS3_N = 537,
	FN_SCL6_B = 538,
	FN_CAN_CLK = 539,
	FN_IECLK_A = 540,
	FN_IP6_3_0 = 541,
	FN_D5 = 542,
	FN_MSIOF2_SYNC_B = 543,
	FN_VI4_DATA21 = 544,
	FN_VI5_DATA5 = 545,
	FN_IP7_3_0 = 546,
	FN_D13 = 547,
	FN_LCDOUT5 = 548,
	FN_MSIOF2_SS2_D = 549,
	FN_TX4_C = 550,
	FN_VI4_DATA5_A = 551,
	FN_DU_DR5 = 552,
	FN_IP4_7_4 = 553,
	FN_A18 = 554,
	FN_LCDOUT10 = 555,
	FN_VI4_HSYNC_N = 556,
	FN_DU_DG2 = 557,
	FN_IP5_7_4 = 558,
	FN_WE1_N = 559,
	FN_MSIOF3_SS1_D = 560,
	FN_RTS3_N = 561,
	FN_HRTS3_N = 562,
	FN_SDA6_B = 563,
	FN_CAN1_RX = 564,
	FN_CANFD1_RX = 565,
	FN_IERX_A = 566,
	FN_IP6_7_4 = 567,
	FN_D6 = 568,
	FN_MSIOF2_RXD_B = 569,
	FN_VI4_DATA22 = 570,
	FN_VI5_DATA6 = 571,
	FN_IP7_7_4 = 572,
	FN_D14 = 573,
	FN_LCDOUT6 = 574,
	FN_MSIOF3_SS1_A = 575,
	FN_HRX3_C = 576,
	FN_VI4_DATA6_A = 577,
	FN_DU_DR6 = 578,
	FN_SCL6_C = 579,
	FN_IP4_11_8 = 580,
	FN_A19 = 581,
	FN_LCDOUT11 = 582,
	FN_VI4_CLKENB = 583,
	FN_DU_DG3 = 584,
	FN_IP5_11_8 = 585,
	FN_EX_WAIT0_A = 586,
	FN_QCLK = 587,
	FN_VI4_CLK = 588,
	FN_DU_DOTCLKOUT0 = 589,
	FN_IP6_11_8 = 590,
	FN_D7 = 591,
	FN_MSIOF2_TXD_B = 592,
	FN_VI4_DATA23 = 593,
	FN_VI5_DATA7 = 594,
	FN_IP7_11_8 = 595,
	FN_D15 = 596,
	FN_LCDOUT7 = 597,
	FN_MSIOF3_SS2_A = 598,
	FN_HTX3_C = 599,
	FN_VI4_DATA7_A = 600,
	FN_DU_DR7 = 601,
	FN_SDA6_C = 602,
	FN_IP4_15_12 = 603,
	FN_CS0_N = 604,
	FN_VI5_CLKENB = 605,
	FN_IP5_15_12 = 606,
	FN_D0 = 607,
	FN_MSIOF2_SS1_B = 608,
	FN_MSIOF3_SCK_A = 609,
	FN_VI4_DATA16 = 610,
	FN_VI5_DATA0 = 611,
	FN_IP6_15_12 = 612,
	FN_D8 = 613,
	FN_LCDOUT0 = 614,
	FN_MSIOF2_SCK_D = 615,
	FN_SCK4_C = 616,
	FN_VI4_DATA0_A = 617,
	FN_DU_DR0 = 618,
	FN_IP4_19_16 = 619,
	FN_CS1_N = 620,
	FN_VI5_CLK = 621,
	FN_EX_WAIT0_B = 622,
	FN_IP5_19_16 = 623,
	FN_D1 = 624,
	FN_MSIOF2_SS2_B = 625,
	FN_MSIOF3_SYNC_A = 626,
	FN_VI4_DATA17 = 627,
	FN_VI5_DATA1 = 628,
	FN_IP6_19_16 = 629,
	FN_D9 = 630,
	FN_LCDOUT1 = 631,
	FN_MSIOF2_SYNC_D = 632,
	FN_VI4_DATA1_A = 633,
	FN_DU_DR1 = 634,
	FN_IP7_19_16 = 635,
	FN_SD0_CLK = 636,
	FN_MSIOF1_SCK_E = 637,
	FN_STP_OPWM_0_B = 638,
	FN_IP4_23_20 = 639,
	FN_BS_N = 640,
	FN_QSTVA_QVS = 641,
	FN_MSIOF3_SCK_D = 642,
	FN_SCK3 = 643,
	FN_HSCK3 = 644,
	FN_CAN1_TX = 645,
	FN_CANFD1_TX = 646,
	FN_IETX_A = 647,
	FN_IP5_23_20 = 648,
	FN_D2 = 649,
	FN_MSIOF3_RXD_A = 650,
	FN_VI4_DATA18 = 651,
	FN_VI5_DATA2 = 652,
	FN_IP6_23_20 = 653,
	FN_D10 = 654,
	FN_LCDOUT2 = 655,
	FN_MSIOF2_RXD_D = 656,
	FN_HRX3_B = 657,
	FN_VI4_DATA2_A = 658,
	FN_CTS4_N_C = 659,
	FN_DU_DR2 = 660,
	FN_IP7_23_20 = 661,
	FN_SD0_CMD = 662,
	FN_MSIOF1_SYNC_E = 663,
	FN_STP_IVCXO27_0_B = 664,
	FN_IP4_27_24 = 665,
	FN_RD_N = 666,
	FN_MSIOF3_SYNC_D = 667,
	FN_RX3_A = 668,
	FN_HRX3_A = 669,
	FN_CAN0_TX_A = 670,
	FN_CANFD0_TX_A = 671,
	FN_IP5_27_24 = 672,
	FN_D3 = 673,
	FN_MSIOF3_TXD_A = 674,
	FN_VI4_DATA19 = 675,
	FN_VI5_DATA3 = 676,
	FN_IP6_27_24 = 677,
	FN_D11 = 678,
	FN_LCDOUT3 = 679,
	FN_MSIOF2_TXD_D = 680,
	FN_HTX3_B = 681,
	FN_VI4_DATA3_A = 682,
	FN_RTS4_N_C = 683,
	FN_DU_DR3 = 684,
	FN_IP7_27_24 = 685,
	FN_SD0_DAT0 = 686,
	FN_MSIOF1_RXD_E = 687,
	FN_TS_SCK0_B = 688,
	FN_STP_ISCLK_0_B = 689,
	FN_IP4_31_28 = 690,
	FN_RD_WR_N = 691,
	FN_MSIOF3_RXD_D = 692,
	FN_TX3_A = 693,
	FN_HTX3_A = 694,
	FN_CAN0_RX_A = 695,
	FN_CANFD0_RX_A = 696,
	FN_IP5_31_28 = 697,
	FN_D4 = 698,
	FN_MSIOF2_SCK_B = 699,
	FN_VI4_DATA20 = 700,
	FN_VI5_DATA4 = 701,
	FN_IP6_31_28 = 702,
	FN_D12 = 703,
	FN_LCDOUT4 = 704,
	FN_MSIOF2_SS1_D = 705,
	FN_RX4_C = 706,
	FN_VI4_DATA4_A = 707,
	FN_DU_DR4 = 708,
	FN_IP7_31_28 = 709,
	FN_SD0_DAT1 = 710,
	FN_MSIOF1_TXD_E = 711,
	FN_TS_SPSYNC0_B = 712,
	FN_STP_ISSYNC_0_B = 713,
	FN_IP8_3_0 = 714,
	FN_SD0_DAT2 = 715,
	FN_MSIOF1_SS1_E = 716,
	FN_TS_SDAT0_B = 717,
	FN_STP_ISD_0_B = 718,
	FN_IP9_3_0 = 719,
	FN_SD2_CLK = 720,
	FN_NFDATA8 = 721,
	FN_IP10_3_0 = 722,
	FN_SD3_CMD = 723,
	FN_NFRE_N = 724,
	FN_IP11_3_0 = 725,
	FN_SD3_DAT7 = 726,
	FN_SD3_WP = 727,
	FN_NFDATA7 = 728,
	FN_IP8_7_4 = 729,
	FN_SD0_DAT3 = 730,
	FN_MSIOF1_SS2_E = 731,
	FN_TS_SDEN0_B = 732,
	FN_STP_ISEN_0_B = 733,
	FN_IP9_7_4 = 734,
	FN_SD2_CMD = 735,
	FN_NFDATA9 = 736,
	FN_IP10_7_4 = 737,
	FN_SD3_DAT0 = 738,
	FN_NFDATA0 = 739,
	FN_IP11_7_4 = 740,
	FN_SD3_DS = 741,
	FN_NFCLE = 742,
	FN_IP8_11_8 = 743,
	FN_SD1_CLK = 744,
	FN_MSIOF1_SCK_G = 745,
	FN_SIM0_CLK_A = 746,
	FN_IP9_11_8 = 747,
	FN_SD2_DAT0 = 748,
	FN_NFDATA10 = 749,
	FN_IP10_11_8 = 750,
	FN_SD3_DAT1 = 751,
	FN_NFDATA1 = 752,
	FN_IP11_11_8 = 753,
	FN_SD0_CD = 754,
	FN_NFDATA14_A = 755,
	FN_SCL2_B = 756,
	FN_SIM0_RST_A = 757,
	FN_IP8_15_12 = 758,
	FN_SD1_CMD = 759,
	FN_MSIOF1_SYNC_G = 760,
	FN_NFCE_N_B = 761,
	FN_SIM0_D_A = 762,
	FN_STP_IVCXO27_1_B = 763,
	FN_IP9_15_12 = 764,
	FN_SD2_DAT1 = 765,
	FN_NFDATA11 = 766,
	FN_IP10_15_12 = 767,
	FN_SD3_DAT2 = 768,
	FN_NFDATA2 = 769,
	FN_IP11_15_12 = 770,
	FN_SD0_WP = 771,
	FN_NFDATA15_A = 772,
	FN_SDA2_B = 773,
	FN_IP8_19_16 = 774,
	FN_SD1_DAT0 = 775,
	FN_SD2_DAT4 = 776,
	FN_MSIOF1_RXD_G = 777,
	FN_NFWP_N_B = 778,
	FN_TS_SCK1_B = 779,
	FN_STP_ISCLK_1_B = 780,
	FN_IP9_19_16 = 781,
	FN_SD2_DAT2 = 782,
	FN_NFDATA12 = 783,
	FN_IP10_19_16 = 784,
	FN_SD3_DAT3 = 785,
	FN_NFDATA3 = 786,
	FN_IP11_19_16 = 787,
	FN_SD1_CD = 788,
	FN_NFRB_N_A = 789,
	FN_SIM0_CLK_B = 790,
	FN_IP8_23_20 = 791,
	FN_SD1_DAT1 = 792,
	FN_SD2_DAT5 = 793,
	FN_MSIOF1_TXD_G = 794,
	FN_NFDATA14_B = 795,
	FN_TS_SPSYNC1_B = 796,
	FN_STP_ISSYNC_1_B = 797,
	FN_IP9_23_20 = 798,
	FN_SD2_DAT3 = 799,
	FN_NFDATA13 = 800,
	FN_IP10_23_20 = 801,
	FN_SD3_DAT4 = 802,
	FN_SD2_CD_A = 803,
	FN_NFDATA4 = 804,
	FN_IP11_23_20 = 805,
	FN_SD1_WP = 806,
	FN_NFCE_N_A = 807,
	FN_SIM0_D_B = 808,
	FN_IP8_27_24 = 809,
	FN_SD1_DAT2 = 810,
	FN_SD2_DAT6 = 811,
	FN_MSIOF1_SS1_G = 812,
	FN_NFDATA15_B = 813,
	FN_TS_SDAT1_B = 814,
	FN_STP_ISD_1_B = 815,
	FN_IP9_27_24 = 816,
	FN_SD2_DS = 817,
	FN_NFALE = 818,
	FN_IP10_27_24 = 819,
	FN_SD3_DAT5 = 820,
	FN_SD2_WP_A = 821,
	FN_NFDATA5 = 822,
	FN_IP11_27_24 = 823,
	FN_SCK0 = 824,
	FN_HSCK1_B = 825,
	FN_MSIOF1_SS2_B = 826,
	FN_AUDIO_CLKC_B = 827,
	FN_SDA2_A = 828,
	FN_SIM0_RST_B = 829,
	FN_STP_OPWM_0_C = 830,
	FN_RIF0_CLK_B = 831,
	FN_ADICHS2 = 832,
	FN_SCK5_B = 833,
	FN_IP8_31_28 = 834,
	FN_SD1_DAT3 = 835,
	FN_SD2_DAT7 = 836,
	FN_MSIOF1_SS2_G = 837,
	FN_NFRB_N_B = 838,
	FN_TS_SDEN1_B = 839,
	FN_STP_ISEN_1_B = 840,
	FN_IP9_31_28 = 841,
	FN_SD3_CLK = 842,
	FN_NFWE_N = 843,
	FN_IP10_31_28 = 844,
	FN_SD3_DAT6 = 845,
	FN_SD3_CD = 846,
	FN_NFDATA6 = 847,
	FN_IP11_31_28 = 848,
	FN_RX0 = 849,
	FN_HRX1_B = 850,
	FN_TS_SCK0_C = 851,
	FN_STP_ISCLK_0_C = 852,
	FN_RIF0_D0_B = 853,
	FN_IP12_3_0 = 854,
	FN_TX0 = 855,
	FN_HTX1_B = 856,
	FN_TS_SPSYNC0_C = 857,
	FN_STP_ISSYNC_0_C = 858,
	FN_RIF0_D1_B = 859,
	FN_IP13_3_0 = 860,
	FN_TX2_A = 861,
	FN_SD2_CD_B = 862,
	FN_SCL1_A = 863,
	FN_FMCLK_A = 864,
	FN_RIF1_D1_C = 865,
	FN_FSO_CFE_0_N = 866,
	FN_IP14_3_0 = 867,
	FN_MSIOF0_SS1 = 868,
	FN_RX5_A = 869,
	FN_NFWP_N_A = 870,
	FN_AUDIO_CLKA_C = 871,
	FN_SSI_SCK2_A = 872,
	FN_STP_IVCXO27_0_C = 873,
	FN_AUDIO_CLKOUT3_A = 874,
	FN_TCLK1_B = 875,
	FN_IP15_3_0 = 876,
	FN_SSI_SDATA1_A = 877,
	FN_IP12_7_4 = 878,
	FN_CTS0_N = 879,
	FN_HCTS1_N_B = 880,
	FN_MSIOF1_SYNC_B = 881,
	FN_TS_SPSYNC1_C = 882,
	FN_STP_ISSYNC_1_C = 883,
	FN_RIF1_SYNC_B = 884,
	FN_AUDIO_CLKOUT_C = 885,
	FN_ADICS_SAMP = 886,
	FN_IP13_7_4 = 887,
	FN_RX2_A = 888,
	FN_SD2_WP_B = 889,
	FN_SDA1_A = 890,
	FN_FMIN_A = 891,
	FN_RIF1_SYNC_C = 892,
	FN_FSO_CFE_1_N = 893,
	FN_IP14_7_4 = 894,
	FN_MSIOF0_SS2 = 895,
	FN_TX5_A = 896,
	FN_MSIOF1_SS2_D = 897,
	FN_AUDIO_CLKC_A = 898,
	FN_SSI_WS2_A = 899,
	FN_STP_OPWM_0_D = 900,
	FN_AUDIO_CLKOUT_D = 901,
	FN_SPEEDIN_B = 902,
	FN_IP15_7_4 = 903,
	FN_SSI_SDATA2_A = 904,
	FN_SSI_SCK1_B = 905,
	FN_IP12_11_8 = 906,
	FN_RTS0_N = 907,
	FN_HRTS1_N_B = 908,
	FN_MSIOF1_SS1_B = 909,
	FN_AUDIO_CLKA_B = 910,
	FN_SCL2_A = 911,
	FN_STP_IVCXO27_1_C = 912,
	FN_RIF0_SYNC_B = 913,
	FN_ADICHS1 = 914,
	FN_IP13_11_8 = 915,
	FN_HSCK0 = 916,
	FN_MSIOF1_SCK_D = 917,
	FN_AUDIO_CLKB_A = 918,
	FN_SSI_SDATA1_B = 919,
	FN_TS_SCK0_D = 920,
	FN_STP_ISCLK_0_D = 921,
	FN_RIF0_CLK_C = 922,
	FN_RX5_B = 923,
	FN_IP14_11_8 = 924,
	FN_MLB_CLK = 925,
	FN_MSIOF1_SCK_F = 926,
	FN_SCL1_B = 927,
	FN_IP15_11_8 = 928,
	FN_SSI_SCK349 = 929,
	FN_MSIOF1_SS1_A = 930,
	FN_STP_OPWM_0_A = 931,
	FN_IP12_15_12 = 932,
	FN_RX1_A = 933,
	FN_HRX1_A = 934,
	FN_TS_SDAT0_C = 935,
	FN_STP_ISD_0_C = 936,
	FN_RIF1_CLK_C = 937,
	FN_IP13_15_12 = 938,
	FN_HRX0 = 939,
	FN_MSIOF1_RXD_D = 940,
	FN_SSI_SDATA2_B = 941,
	FN_TS_SDEN0_D = 942,
	FN_STP_ISEN_0_D = 943,
	FN_RIF0_D0_C = 944,
	FN_IP14_15_12 = 945,
	FN_MLB_SIG = 946,
	FN_RX1_B = 947,
	FN_MSIOF1_SYNC_F = 948,
	FN_SDA1_B = 949,
	FN_IP15_15_12 = 950,
	FN_SSI_WS349 = 951,
	FN_HCTS2_N_A = 952,
	FN_MSIOF1_SS2_A = 953,
	FN_STP_IVCXO27_0_A = 954,
	FN_IP12_19_16 = 955,
	FN_TX1_A = 956,
	FN_HTX1_A = 957,
	FN_TS_SDEN0_C = 958,
	FN_STP_ISEN_0_C = 959,
	FN_RIF1_D0_C = 960,
	FN_IP13_19_16 = 961,
	FN_HTX0 = 962,
	FN_MSIOF1_TXD_D = 963,
	FN_SSI_SDATA9_B = 964,
	FN_TS_SDAT0_D = 965,
	FN_STP_ISD_0_D = 966,
	FN_RIF0_D1_C = 967,
	FN_IP14_19_16 = 968,
	FN_MLB_DAT = 969,
	FN_TX1_B = 970,
	FN_MSIOF1_RXD_F = 971,
	FN_IP15_19_16 = 972,
	FN_SSI_SDATA3 = 973,
	FN_HRTS2_N_A = 974,
	FN_MSIOF1_TXD_A = 975,
	FN_TS_SCK0_A = 976,
	FN_STP_ISCLK_0_A = 977,
	FN_RIF0_D1_A = 978,
	FN_RIF2_D0_A = 979,
	FN_IP12_23_20 = 980,
	FN_CTS1_N = 981,
	FN_HCTS1_N_A = 982,
	FN_MSIOF1_RXD_B = 983,
	FN_TS_SDEN1_C = 984,
	FN_STP_ISEN_1_C = 985,
	FN_RIF1_D0_B = 986,
	FN_ADIDATA = 987,
	FN_IP13_23_20 = 988,
	FN_HCTS0_N = 989,
	FN_RX2_B = 990,
	FN_MSIOF1_SYNC_D = 991,
	FN_SSI_SCK9_A = 992,
	FN_TS_SPSYNC0_D = 993,
	FN_STP_ISSYNC_0_D = 994,
	FN_RIF0_SYNC_C = 995,
	FN_AUDIO_CLKOUT1_A = 996,
	FN_IP14_23_20 = 997,
	FN_SSI_SCK01239 = 998,
	FN_MSIOF1_TXD_F = 999,
	FN_IP15_23_20 = 1000,
	FN_SSI_SCK4 = 1001,
	FN_HRX2_A = 1002,
	FN_MSIOF1_SCK_A = 1003,
	FN_TS_SDAT0_A = 1004,
	FN_STP_ISD_0_A = 1005,
	FN_RIF0_CLK_A = 1006,
	FN_RIF2_CLK_A = 1007,
	FN_IP12_27_24 = 1008,
	FN_RTS1_N = 1009,
	FN_HRTS1_N_A = 1010,
	FN_MSIOF1_TXD_B = 1011,
	FN_TS_SDAT1_C = 1012,
	FN_STP_ISD_1_C = 1013,
	FN_RIF1_D1_B = 1014,
	FN_ADICHS0 = 1015,
	FN_IP13_27_24 = 1016,
	FN_HRTS0_N = 1017,
	FN_TX2_B = 1018,
	FN_MSIOF1_SS1_D = 1019,
	FN_SSI_WS9_A = 1020,
	FN_STP_IVCXO27_0_D = 1021,
	FN_BPFCLK_A = 1022,
	FN_AUDIO_CLKOUT2_A = 1023,
	FN_IP14_27_24 = 1024,
	FN_SSI_WS01239 = 1025,
	FN_MSIOF1_SS1_F = 1026,
	FN_IP15_27_24 = 1027,
	FN_SSI_WS4 = 1028,
	FN_HTX2_A = 1029,
	FN_MSIOF1_SYNC_A = 1030,
	FN_TS_SDEN0_A = 1031,
	FN_STP_ISEN_0_A = 1032,
	FN_RIF0_SYNC_A = 1033,
	FN_RIF2_SYNC_A = 1034,
	FN_IP12_31_28 = 1035,
	FN_SCK2 = 1036,
	FN_SCIF_CLK_B = 1037,
	FN_MSIOF1_SCK_B = 1038,
	FN_TS_SCK1_C = 1039,
	FN_STP_ISCLK_1_C = 1040,
	FN_RIF1_CLK_B = 1041,
	FN_ADICLK = 1042,
	FN_IP13_31_28 = 1043,
	FN_MSIOF0_SYNC = 1044,
	FN_AUDIO_CLKOUT_A = 1045,
	FN_TX5_B = 1046,
	FN_BPFCLK_D = 1047,
	FN_IP14_31_28 = 1048,
	FN_SSI_SDATA0 = 1049,
	FN_MSIOF1_SS2_F = 1050,
	FN_IP15_31_28 = 1051,
	FN_SSI_SDATA4 = 1052,
	FN_HSCK2_A = 1053,
	FN_MSIOF1_RXD_A = 1054,
	FN_TS_SPSYNC0_A = 1055,
	FN_STP_ISSYNC_0_A = 1056,
	FN_RIF0_D0_A = 1057,
	FN_RIF2_D1_A = 1058,
	FN_IP16_3_0 = 1059,
	FN_SSI_SCK6 = 1060,
	FN_SIM0_RST_D = 1061,
	FN_IP17_3_0 = 1062,
	FN_AUDIO_CLKA_A = 1063,
	FN_IP18_3_0 = 1064,
	FN_GP6_30 = 1065,
	FN_AUDIO_CLKOUT2_B = 1066,
	FN_SSI_SCK9_B = 1067,
	FN_TS_SDEN0_E = 1068,
	FN_STP_ISEN_0_E = 1069,
	FN_RIF2_D0_B = 1070,
	FN_TPU0TO2 = 1071,
	FN_FMCLK_C = 1072,
	FN_FMCLK_D = 1073,
	FN_IP16_7_4 = 1074,
	FN_SSI_WS6 = 1075,
	FN_SIM0_D_D = 1076,
	FN_IP17_7_4 = 1077,
	FN_AUDIO_CLKB_B = 1078,
	FN_SCIF_CLK_A = 1079,
	FN_STP_IVCXO27_1_D = 1080,
	FN_REMOCON_A = 1081,
	FN_TCLK1_A = 1082,
	FN_IP18_7_4 = 1083,
	FN_GP6_31 = 1084,
	FN_AUDIO_CLKOUT3_B = 1085,
	FN_SSI_WS9_B = 1086,
	FN_TS_SPSYNC0_E = 1087,
	FN_STP_ISSYNC_0_E = 1088,
	FN_RIF2_D1_B = 1089,
	FN_TPU0TO3 = 1090,
	FN_FMIN_C = 1091,
	FN_FMIN_D = 1092,
	FN_IP16_11_8 = 1093,
	FN_SSI_SDATA6 = 1094,
	FN_SIM0_CLK_D = 1095,
	FN_IP17_11_8 = 1096,
	FN_USB0_PWEN = 1097,
	FN_SIM0_RST_C = 1098,
	FN_TS_SCK1_D = 1099,
	FN_STP_ISCLK_1_D = 1100,
	FN_BPFCLK_B = 1101,
	FN_RIF3_CLK_B = 1102,
	FN_HSCK2_C = 1103,
	FN_IP16_15_12 = 1104,
	FN_SSI_SCK78 = 1105,
	FN_HRX2_B = 1106,
	FN_MSIOF1_SCK_C = 1107,
	FN_TS_SCK1_A = 1108,
	FN_STP_ISCLK_1_A = 1109,
	FN_RIF1_CLK_A = 1110,
	FN_RIF3_CLK_A = 1111,
	FN_IP17_15_12 = 1112,
	FN_USB0_OVC = 1113,
	FN_SIM0_D_C = 1114,
	FN_TS_SDAT1_D = 1115,
	FN_STP_ISD_1_D = 1116,
	FN_RIF3_SYNC_B = 1117,
	FN_HRX2_C = 1118,
	FN_IP16_19_16 = 1119,
	FN_SSI_WS78 = 1120,
	FN_HTX2_B = 1121,
	FN_MSIOF1_SYNC_C = 1122,
	FN_TS_SDAT1_A = 1123,
	FN_STP_ISD_1_A = 1124,
	FN_RIF1_SYNC_A = 1125,
	FN_RIF3_SYNC_A = 1126,
	FN_IP17_19_16 = 1127,
	FN_USB1_PWEN = 1128,
	FN_SIM0_CLK_C = 1129,
	FN_SSI_SCK1_A = 1130,
	FN_TS_SCK0_E = 1131,
	FN_STP_ISCLK_0_E = 1132,
	FN_FMCLK_B = 1133,
	FN_RIF2_CLK_B = 1134,
	FN_SPEEDIN_A = 1135,
	FN_HTX2_C = 1136,
	FN_IP16_23_20 = 1137,
	FN_SSI_SDATA7 = 1138,
	FN_HCTS2_N_B = 1139,
	FN_MSIOF1_RXD_C = 1140,
	FN_TS_SDEN1_A = 1141,
	FN_STP_ISEN_1_A = 1142,
	FN_RIF1_D0_A = 1143,
	FN_RIF3_D0_A = 1144,
	FN_TCLK2_A = 1145,
	FN_IP17_23_20 = 1146,
	FN_USB1_OVC = 1147,
	FN_MSIOF1_SS2_C = 1148,
	FN_SSI_WS1_A = 1149,
	FN_TS_SDAT0_E = 1150,
	FN_STP_ISD_0_E = 1151,
	FN_FMIN_B = 1152,
	FN_RIF2_SYNC_B = 1153,
	FN_REMOCON_B = 1154,
	FN_HCTS2_N_C = 1155,
	FN_IP16_27_24 = 1156,
	FN_SSI_SDATA8 = 1157,
	FN_HRTS2_N_B = 1158,
	FN_MSIOF1_TXD_C = 1159,
	FN_TS_SPSYNC1_A = 1160,
	FN_STP_ISSYNC_1_A = 1161,
	FN_RIF1_D1_A = 1162,
	FN_RIF3_D1_A = 1163,
	FN_IP17_27_24 = 1164,
	FN_USB30_PWEN = 1165,
	FN_AUDIO_CLKOUT_B = 1166,
	FN_SSI_SCK2_B = 1167,
	FN_TS_SDEN1_D = 1168,
	FN_STP_ISEN_1_D = 1169,
	FN_STP_OPWM_0_E = 1170,
	FN_RIF3_D0_B = 1171,
	FN_TCLK2_B = 1172,
	FN_TPU0TO0 = 1173,
	FN_BPFCLK_C = 1174,
	FN_HRTS2_N_C = 1175,
	FN_IP16_31_28 = 1176,
	FN_SSI_SDATA9_A = 1177,
	FN_HSCK2_B = 1178,
	FN_MSIOF1_SS1_C = 1179,
	FN_HSCK1_A = 1180,
	FN_SSI_WS1_B = 1181,
	FN_SCK1 = 1182,
	FN_STP_IVCXO27_1_A = 1183,
	FN_SCK5_A = 1184,
	FN_IP17_31_28 = 1185,
	FN_USB30_OVC = 1186,
	FN_AUDIO_CLKOUT1_B = 1187,
	FN_SSI_WS2_B = 1188,
	FN_TS_SPSYNC1_D = 1189,
	FN_STP_ISSYNC_1_D = 1190,
	FN_STP_IVCXO27_0_E = 1191,
	FN_RIF3_D1_B = 1192,
	FN_FSO_TOE_N = 1193,
	FN_TPU0TO1 = 1194,
	FN_SEL_MSIOF3_0 = 1195,
	FN_SEL_MSIOF3_1 = 1196,
	FN_SEL_MSIOF3_2 = 1197,
	FN_SEL_MSIOF3_3 = 1198,
	FN_SEL_MSIOF3_4 = 1199,
	FN_SEL_TSIF1_0 = 1200,
	FN_SEL_TSIF1_1 = 1201,
	FN_SEL_TSIF1_2 = 1202,
	FN_SEL_TSIF1_3 = 1203,
	FN_I2C_SEL_5_0 = 1204,
	FN_I2C_SEL_5_1 = 1205,
	FN_I2C_SEL_3_0 = 1206,
	FN_I2C_SEL_3_1 = 1207,
	FN_SEL_TSIF0_0 = 1208,
	FN_SEL_TSIF0_1 = 1209,
	FN_SEL_TSIF0_2 = 1210,
	FN_SEL_TSIF0_3 = 1211,
	FN_SEL_TSIF0_4 = 1212,
	FN_I2C_SEL_0_0 = 1213,
	FN_I2C_SEL_0_1 = 1214,
	FN_SEL_MSIOF2_0 = 1215,
	FN_SEL_MSIOF2_1 = 1216,
	FN_SEL_MSIOF2_2 = 1217,
	FN_SEL_MSIOF2_3 = 1218,
	FN_SEL_FM_0 = 1219,
	FN_SEL_FM_1 = 1220,
	FN_SEL_FM_2 = 1221,
	FN_SEL_FM_3 = 1222,
	FN_SEL_MSIOF1_0 = 1223,
	FN_SEL_MSIOF1_1 = 1224,
	FN_SEL_MSIOF1_2 = 1225,
	FN_SEL_MSIOF1_3 = 1226,
	FN_SEL_MSIOF1_4 = 1227,
	FN_SEL_MSIOF1_5 = 1228,
	FN_SEL_MSIOF1_6 = 1229,
	FN_SEL_TIMER_TMU_0 = 1230,
	FN_SEL_TIMER_TMU_1 = 1231,
	FN_SEL_SCIF5_0 = 1232,
	FN_SEL_SCIF5_1 = 1233,
	FN_SEL_SSP1_1_0 = 1234,
	FN_SEL_SSP1_1_1 = 1235,
	FN_SEL_SSP1_1_2 = 1236,
	FN_SEL_SSP1_1_3 = 1237,
	FN_SEL_I2C6_0 = 1238,
	FN_SEL_I2C6_1 = 1239,
	FN_SEL_I2C6_2 = 1240,
	FN_SEL_LBSC_0 = 1241,
	FN_SEL_LBSC_1 = 1242,
	FN_SEL_SSP1_0_0 = 1243,
	FN_SEL_SSP1_0_1 = 1244,
	FN_SEL_SSP1_0_2 = 1245,
	FN_SEL_SSP1_0_3 = 1246,
	FN_SEL_SSP1_0_4 = 1247,
	FN_SEL_IEBUS_0 = 1248,
	FN_SEL_IEBUS_1 = 1249,
	FN_SEL_NDF_0 = 1250,
	FN_SEL_NDF_1 = 1251,
	FN_SEL_I2C2_0 = 1252,
	FN_SEL_I2C2_1 = 1253,
	FN_SEL_SSI2_0 = 1254,
	FN_SEL_SSI2_1 = 1255,
	FN_SEL_I2C1_0 = 1256,
	FN_SEL_I2C1_1 = 1257,
	FN_SEL_SSI1_0 = 1258,
	FN_SEL_SSI1_1 = 1259,
	FN_SEL_SSI9_0 = 1260,
	FN_SEL_SSI9_1 = 1261,
	FN_SEL_HSCIF4_0 = 1262,
	FN_SEL_HSCIF4_1 = 1263,
	FN_SEL_SPEED_PULSE_0 = 1264,
	FN_SEL_SPEED_PULSE_1 = 1265,
	FN_SEL_TIMER_TMU2_0 = 1266,
	FN_SEL_TIMER_TMU2_1 = 1267,
	FN_SEL_HSCIF3_0 = 1268,
	FN_SEL_HSCIF3_1 = 1269,
	FN_SEL_HSCIF3_2 = 1270,
	FN_SEL_HSCIF3_3 = 1271,
	FN_SEL_SIMCARD_0 = 1272,
	FN_SEL_SIMCARD_1 = 1273,
	FN_SEL_SIMCARD_2 = 1274,
	FN_SEL_SIMCARD_3 = 1275,
	FN_SEL_ADGB_0 = 1276,
	FN_SEL_ADGB_1 = 1277,
	FN_SEL_ADGC_0 = 1278,
	FN_SEL_ADGC_1 = 1279,
	FN_SEL_HSCIF1_0 = 1280,
	FN_SEL_HSCIF1_1 = 1281,
	FN_SEL_SDHI2_0 = 1282,
	FN_SEL_SDHI2_1 = 1283,
	FN_SEL_SCIF4_0 = 1284,
	FN_SEL_SCIF4_1 = 1285,
	FN_SEL_SCIF4_2 = 1286,
	FN_SEL_HSCIF2_0 = 1287,
	FN_SEL_HSCIF2_1 = 1288,
	FN_SEL_HSCIF2_2 = 1289,
	FN_SEL_SCIF3_0 = 1290,
	FN_SEL_SCIF3_1 = 1291,
	FN_SEL_ETHERAVB_0 = 1292,
	FN_SEL_ETHERAVB_1 = 1293,
	FN_SEL_SCIF2_0 = 1294,
	FN_SEL_SCIF2_1 = 1295,
	FN_SEL_DRIF3_0 = 1296,
	FN_SEL_DRIF3_1 = 1297,
	FN_SEL_SCIF1_0 = 1298,
	FN_SEL_SCIF1_1 = 1299,
	FN_SEL_DRIF2_0 = 1300,
	FN_SEL_DRIF2_1 = 1301,
	FN_SEL_SCIF_0 = 1302,
	FN_SEL_SCIF_1 = 1303,
	FN_SEL_DRIF1_0 = 1304,
	FN_SEL_DRIF1_1 = 1305,
	FN_SEL_DRIF1_2 = 1306,
	FN_SEL_REMOCON_0 = 1307,
	FN_SEL_REMOCON_1 = 1308,
	FN_SEL_DRIF0_0 = 1309,
	FN_SEL_DRIF0_1 = 1310,
	FN_SEL_DRIF0_2 = 1311,
	FN_SEL_RCAN0_0 = 1312,
	FN_SEL_RCAN0_1 = 1313,
	FN_SEL_CANFD0_0 = 1314,
	FN_SEL_CANFD0_1 = 1315,
	FN_SEL_PWM6_0 = 1316,
	FN_SEL_PWM6_1 = 1317,
	FN_SEL_ADGA_0 = 1318,
	FN_SEL_ADGA_1 = 1319,
	FN_SEL_ADGA_2 = 1320,
	FN_SEL_ADGA_3 = 1321,
	FN_SEL_PWM5_0 = 1322,
	FN_SEL_PWM5_1 = 1323,
	FN_SEL_PWM4_0 = 1324,
	FN_SEL_PWM4_1 = 1325,
	FN_SEL_PWM3_0 = 1326,
	FN_SEL_PWM3_1 = 1327,
	FN_SEL_PWM2_0 = 1328,
	FN_SEL_PWM2_1 = 1329,
	FN_SEL_PWM1_0 = 1330,
	FN_SEL_PWM1_1 = 1331,
	FN_SEL_VIN4_0 = 1332,
	FN_SEL_VIN4_1 = 1333,
	PINMUX_FUNCTION_END = 1334,
	PINMUX_MARK_BEGIN = 1335,
	CLKOUT_MARK = 1336,
	MSIOF0_RXD_MARK = 1337,
	MSIOF0_TXD_MARK = 1338,
	MSIOF0_SCK_MARK = 1339,
	SSI_SDATA5_MARK = 1340,
	SSI_WS5_MARK = 1341,
	SSI_SCK5_MARK = 1342,
	GP7_03_MARK = 1343,
	GP7_02_MARK = 1344,
	AVS2_MARK = 1345,
	AVS1_MARK = 1346,
	IP0_3_0_MARK = 1347,
	AVB_MDC_MARK = 1348,
	MSIOF2_SS2_C_MARK = 1349,
	IP1_3_0_MARK = 1350,
	IRQ2_MARK = 1351,
	QCPV_QDE_MARK = 1352,
	DU_EXODDF_DU_ODDF_DISP_CDE_MARK = 1353,
	VI4_DATA2_B_MARK = 1354,
	MSIOF3_SYNC_E_MARK = 1355,
	PWM3_B_MARK = 1356,
	IP2_3_0_MARK = 1357,
	A1_MARK = 1358,
	LCDOUT17_MARK = 1359,
	MSIOF3_TXD_B_MARK = 1360,
	VI4_DATA9_MARK = 1361,
	DU_DB1_MARK = 1362,
	PWM4_A_MARK = 1363,
	IP3_3_0_MARK = 1364,
	A9_MARK = 1365,
	MSIOF2_SCK_A_MARK = 1366,
	CTS4_N_B_MARK = 1367,
	VI5_VSYNC_N_MARK = 1368,
	IP0_7_4_MARK = 1369,
	AVB_MAGIC_MARK = 1370,
	MSIOF2_SS1_C_MARK = 1371,
	SCK4_A_MARK = 1372,
	IP1_7_4_MARK = 1373,
	IRQ3_MARK = 1374,
	QSTVB_QVE_MARK = 1375,
	DU_DOTCLKOUT1_MARK = 1376,
	VI4_DATA3_B_MARK = 1377,
	MSIOF3_SCK_E_MARK = 1378,
	PWM4_B_MARK = 1379,
	IP2_7_4_MARK = 1380,
	A2_MARK = 1381,
	LCDOUT18_MARK = 1382,
	MSIOF3_SCK_B_MARK = 1383,
	VI4_DATA10_MARK = 1384,
	DU_DB2_MARK = 1385,
	PWM5_A_MARK = 1386,
	IP3_7_4_MARK = 1387,
	A10_MARK = 1388,
	MSIOF2_RXD_A_MARK = 1389,
	RTS4_N_B_MARK = 1390,
	VI5_HSYNC_N_MARK = 1391,
	IP0_11_8_MARK = 1392,
	AVB_PHY_INT_MARK = 1393,
	MSIOF2_SYNC_C_MARK = 1394,
	RX4_A_MARK = 1395,
	IP1_11_8_MARK = 1396,
	IRQ4_MARK = 1397,
	QSTH_QHS_MARK = 1398,
	DU_EXHSYNC_DU_HSYNC_MARK = 1399,
	VI4_DATA4_B_MARK = 1400,
	MSIOF3_RXD_E_MARK = 1401,
	PWM5_B_MARK = 1402,
	IP2_11_8_MARK = 1403,
	A3_MARK = 1404,
	LCDOUT19_MARK = 1405,
	MSIOF3_RXD_B_MARK = 1406,
	VI4_DATA11_MARK = 1407,
	DU_DB3_MARK = 1408,
	PWM6_A_MARK = 1409,
	IP3_11_8_MARK = 1410,
	A11_MARK = 1411,
	TX3_B_MARK = 1412,
	MSIOF2_TXD_A_MARK = 1413,
	HTX4_B_MARK = 1414,
	HSCK4_MARK = 1415,
	VI5_FIELD_MARK = 1416,
	SCL6_A_MARK = 1417,
	AVB_AVTP_CAPTURE_B_MARK = 1418,
	PWM2_B_MARK = 1419,
	IP0_15_12_MARK = 1420,
	AVB_LINK_MARK = 1421,
	MSIOF2_SCK_C_MARK = 1422,
	TX4_A_MARK = 1423,
	IP1_15_12_MARK = 1424,
	IRQ5_MARK = 1425,
	QSTB_QHE_MARK = 1426,
	DU_EXVSYNC_DU_VSYNC_MARK = 1427,
	VI4_DATA5_B_MARK = 1428,
	MSIOF3_TXD_E_MARK = 1429,
	PWM6_B_MARK = 1430,
	IP2_15_12_MARK = 1431,
	A4_MARK = 1432,
	LCDOUT20_MARK = 1433,
	MSIOF3_SS1_B_MARK = 1434,
	VI4_DATA12_MARK = 1435,
	VI5_DATA12_MARK = 1436,
	DU_DB4_MARK = 1437,
	IP3_15_12_MARK = 1438,
	A12_MARK = 1439,
	LCDOUT12_MARK = 1440,
	MSIOF3_SCK_C_MARK = 1441,
	HRX4_A_MARK = 1442,
	VI5_DATA8_MARK = 1443,
	DU_DG4_MARK = 1444,
	IP0_19_16_MARK = 1445,
	AVB_AVTP_MATCH_A_MARK = 1446,
	MSIOF2_RXD_C_MARK = 1447,
	CTS4_N_A_MARK = 1448,
	IP1_19_16_MARK = 1449,
	PWM0_MARK = 1450,
	AVB_AVTP_PPS_MARK = 1451,
	VI4_DATA6_B_MARK = 1452,
	IECLK_B_MARK = 1453,
	IP2_19_16_MARK = 1454,
	A5_MARK = 1455,
	LCDOUT21_MARK = 1456,
	MSIOF3_SS2_B_MARK = 1457,
	SCK4_B_MARK = 1458,
	VI4_DATA13_MARK = 1459,
	VI5_DATA13_MARK = 1460,
	DU_DB5_MARK = 1461,
	IP3_19_16_MARK = 1462,
	A13_MARK = 1463,
	LCDOUT13_MARK = 1464,
	MSIOF3_SYNC_C_MARK = 1465,
	HTX4_A_MARK = 1466,
	VI5_DATA9_MARK = 1467,
	DU_DG5_MARK = 1468,
	IP0_23_20_MARK = 1469,
	AVB_AVTP_CAPTURE_A_MARK = 1470,
	MSIOF2_TXD_C_MARK = 1471,
	RTS4_N_A_MARK = 1472,
	IP1_23_20_MARK = 1473,
	PWM1_A_MARK = 1474,
	HRX3_D_MARK = 1475,
	VI4_DATA7_B_MARK = 1476,
	IERX_B_MARK = 1477,
	IP2_23_20_MARK = 1478,
	A6_MARK = 1479,
	LCDOUT22_MARK = 1480,
	MSIOF2_SS1_A_MARK = 1481,
	RX4_B_MARK = 1482,
	VI4_DATA14_MARK = 1483,
	VI5_DATA14_MARK = 1484,
	DU_DB6_MARK = 1485,
	IP3_23_20_MARK = 1486,
	A14_MARK = 1487,
	LCDOUT14_MARK = 1488,
	MSIOF3_RXD_C_MARK = 1489,
	HCTS4_N_MARK = 1490,
	VI5_DATA10_MARK = 1491,
	DU_DG6_MARK = 1492,
	IP0_27_24_MARK = 1493,
	IRQ0_MARK = 1494,
	QPOLB_MARK = 1495,
	DU_CDE_MARK = 1496,
	VI4_DATA0_B_MARK = 1497,
	CAN0_TX_B_MARK = 1498,
	CANFD0_TX_B_MARK = 1499,
	MSIOF3_SS2_E_MARK = 1500,
	IP1_27_24_MARK = 1501,
	PWM2_A_MARK = 1502,
	HTX3_D_MARK = 1503,
	IETX_B_MARK = 1504,
	IP2_27_24_MARK = 1505,
	A7_MARK = 1506,
	LCDOUT23_MARK = 1507,
	MSIOF2_SS2_A_MARK = 1508,
	TX4_B_MARK = 1509,
	VI4_DATA15_MARK = 1510,
	VI5_DATA15_MARK = 1511,
	DU_DB7_MARK = 1512,
	IP3_27_24_MARK = 1513,
	A15_MARK = 1514,
	LCDOUT15_MARK = 1515,
	MSIOF3_TXD_C_MARK = 1516,
	HRTS4_N_MARK = 1517,
	VI5_DATA11_MARK = 1518,
	DU_DG7_MARK = 1519,
	IP0_31_28_MARK = 1520,
	IRQ1_MARK = 1521,
	QPOLA_MARK = 1522,
	DU_DISP_MARK = 1523,
	VI4_DATA1_B_MARK = 1524,
	CAN0_RX_B_MARK = 1525,
	CANFD0_RX_B_MARK = 1526,
	MSIOF3_SS1_E_MARK = 1527,
	IP1_31_28_MARK = 1528,
	A0_MARK = 1529,
	LCDOUT16_MARK = 1530,
	MSIOF3_SYNC_B_MARK = 1531,
	VI4_DATA8_MARK = 1532,
	DU_DB0_MARK = 1533,
	PWM3_A_MARK = 1534,
	IP2_31_28_MARK = 1535,
	A8_MARK = 1536,
	RX3_B_MARK = 1537,
	MSIOF2_SYNC_A_MARK = 1538,
	HRX4_B_MARK = 1539,
	SDA6_A_MARK = 1540,
	AVB_AVTP_MATCH_B_MARK = 1541,
	PWM1_B_MARK = 1542,
	IP3_31_28_MARK = 1543,
	A16_MARK = 1544,
	LCDOUT8_MARK = 1545,
	VI4_FIELD_MARK = 1546,
	DU_DG0_MARK = 1547,
	IP4_3_0_MARK = 1548,
	A17_MARK = 1549,
	LCDOUT9_MARK = 1550,
	VI4_VSYNC_N_MARK = 1551,
	DU_DG1_MARK = 1552,
	IP5_3_0_MARK = 1553,
	WE0_N_MARK = 1554,
	MSIOF3_TXD_D_MARK = 1555,
	CTS3_N_MARK = 1556,
	HCTS3_N_MARK = 1557,
	SCL6_B_MARK = 1558,
	CAN_CLK_MARK = 1559,
	IECLK_A_MARK = 1560,
	IP6_3_0_MARK = 1561,
	D5_MARK = 1562,
	MSIOF2_SYNC_B_MARK = 1563,
	VI4_DATA21_MARK = 1564,
	VI5_DATA5_MARK = 1565,
	IP7_3_0_MARK = 1566,
	D13_MARK = 1567,
	LCDOUT5_MARK = 1568,
	MSIOF2_SS2_D_MARK = 1569,
	TX4_C_MARK = 1570,
	VI4_DATA5_A_MARK = 1571,
	DU_DR5_MARK = 1572,
	IP4_7_4_MARK = 1573,
	A18_MARK = 1574,
	LCDOUT10_MARK = 1575,
	VI4_HSYNC_N_MARK = 1576,
	DU_DG2_MARK = 1577,
	IP5_7_4_MARK = 1578,
	WE1_N_MARK = 1579,
	MSIOF3_SS1_D_MARK = 1580,
	RTS3_N_MARK = 1581,
	HRTS3_N_MARK = 1582,
	SDA6_B_MARK = 1583,
	CAN1_RX_MARK = 1584,
	CANFD1_RX_MARK = 1585,
	IERX_A_MARK = 1586,
	IP6_7_4_MARK = 1587,
	D6_MARK = 1588,
	MSIOF2_RXD_B_MARK = 1589,
	VI4_DATA22_MARK = 1590,
	VI5_DATA6_MARK = 1591,
	IP7_7_4_MARK = 1592,
	D14_MARK = 1593,
	LCDOUT6_MARK = 1594,
	MSIOF3_SS1_A_MARK = 1595,
	HRX3_C_MARK = 1596,
	VI4_DATA6_A_MARK = 1597,
	DU_DR6_MARK = 1598,
	SCL6_C_MARK = 1599,
	IP4_11_8_MARK = 1600,
	A19_MARK = 1601,
	LCDOUT11_MARK = 1602,
	VI4_CLKENB_MARK = 1603,
	DU_DG3_MARK = 1604,
	IP5_11_8_MARK = 1605,
	EX_WAIT0_A_MARK = 1606,
	QCLK_MARK = 1607,
	VI4_CLK_MARK = 1608,
	DU_DOTCLKOUT0_MARK = 1609,
	IP6_11_8_MARK = 1610,
	D7_MARK = 1611,
	MSIOF2_TXD_B_MARK = 1612,
	VI4_DATA23_MARK = 1613,
	VI5_DATA7_MARK = 1614,
	IP7_11_8_MARK = 1615,
	D15_MARK = 1616,
	LCDOUT7_MARK = 1617,
	MSIOF3_SS2_A_MARK = 1618,
	HTX3_C_MARK = 1619,
	VI4_DATA7_A_MARK = 1620,
	DU_DR7_MARK = 1621,
	SDA6_C_MARK = 1622,
	IP4_15_12_MARK = 1623,
	CS0_N_MARK = 1624,
	VI5_CLKENB_MARK = 1625,
	IP5_15_12_MARK = 1626,
	D0_MARK = 1627,
	MSIOF2_SS1_B_MARK = 1628,
	MSIOF3_SCK_A_MARK = 1629,
	VI4_DATA16_MARK = 1630,
	VI5_DATA0_MARK = 1631,
	IP6_15_12_MARK = 1632,
	D8_MARK = 1633,
	LCDOUT0_MARK = 1634,
	MSIOF2_SCK_D_MARK = 1635,
	SCK4_C_MARK = 1636,
	VI4_DATA0_A_MARK = 1637,
	DU_DR0_MARK = 1638,
	IP4_19_16_MARK = 1639,
	CS1_N_MARK = 1640,
	VI5_CLK_MARK = 1641,
	EX_WAIT0_B_MARK = 1642,
	IP5_19_16_MARK = 1643,
	D1_MARK = 1644,
	MSIOF2_SS2_B_MARK = 1645,
	MSIOF3_SYNC_A_MARK = 1646,
	VI4_DATA17_MARK = 1647,
	VI5_DATA1_MARK = 1648,
	IP6_19_16_MARK = 1649,
	D9_MARK = 1650,
	LCDOUT1_MARK = 1651,
	MSIOF2_SYNC_D_MARK = 1652,
	VI4_DATA1_A_MARK = 1653,
	DU_DR1_MARK = 1654,
	IP7_19_16_MARK = 1655,
	SD0_CLK_MARK = 1656,
	MSIOF1_SCK_E_MARK = 1657,
	STP_OPWM_0_B_MARK = 1658,
	IP4_23_20_MARK = 1659,
	BS_N_MARK = 1660,
	QSTVA_QVS_MARK = 1661,
	MSIOF3_SCK_D_MARK = 1662,
	SCK3_MARK = 1663,
	HSCK3_MARK = 1664,
	CAN1_TX_MARK = 1665,
	CANFD1_TX_MARK = 1666,
	IETX_A_MARK = 1667,
	IP5_23_20_MARK = 1668,
	D2_MARK = 1669,
	MSIOF3_RXD_A_MARK = 1670,
	VI4_DATA18_MARK = 1671,
	VI5_DATA2_MARK = 1672,
	IP6_23_20_MARK = 1673,
	D10_MARK = 1674,
	LCDOUT2_MARK = 1675,
	MSIOF2_RXD_D_MARK = 1676,
	HRX3_B_MARK = 1677,
	VI4_DATA2_A_MARK = 1678,
	CTS4_N_C_MARK = 1679,
	DU_DR2_MARK = 1680,
	IP7_23_20_MARK = 1681,
	SD0_CMD_MARK = 1682,
	MSIOF1_SYNC_E_MARK = 1683,
	STP_IVCXO27_0_B_MARK = 1684,
	IP4_27_24_MARK = 1685,
	RD_N_MARK = 1686,
	MSIOF3_SYNC_D_MARK = 1687,
	RX3_A_MARK = 1688,
	HRX3_A_MARK = 1689,
	CAN0_TX_A_MARK = 1690,
	CANFD0_TX_A_MARK = 1691,
	IP5_27_24_MARK = 1692,
	D3_MARK = 1693,
	MSIOF3_TXD_A_MARK = 1694,
	VI4_DATA19_MARK = 1695,
	VI5_DATA3_MARK = 1696,
	IP6_27_24_MARK = 1697,
	D11_MARK = 1698,
	LCDOUT3_MARK = 1699,
	MSIOF2_TXD_D_MARK = 1700,
	HTX3_B_MARK = 1701,
	VI4_DATA3_A_MARK = 1702,
	RTS4_N_C_MARK = 1703,
	DU_DR3_MARK = 1704,
	IP7_27_24_MARK = 1705,
	SD0_DAT0_MARK = 1706,
	MSIOF1_RXD_E_MARK = 1707,
	TS_SCK0_B_MARK = 1708,
	STP_ISCLK_0_B_MARK = 1709,
	IP4_31_28_MARK = 1710,
	RD_WR_N_MARK = 1711,
	MSIOF3_RXD_D_MARK = 1712,
	TX3_A_MARK = 1713,
	HTX3_A_MARK = 1714,
	CAN0_RX_A_MARK = 1715,
	CANFD0_RX_A_MARK = 1716,
	IP5_31_28_MARK = 1717,
	D4_MARK = 1718,
	MSIOF2_SCK_B_MARK = 1719,
	VI4_DATA20_MARK = 1720,
	VI5_DATA4_MARK = 1721,
	IP6_31_28_MARK = 1722,
	D12_MARK = 1723,
	LCDOUT4_MARK = 1724,
	MSIOF2_SS1_D_MARK = 1725,
	RX4_C_MARK = 1726,
	VI4_DATA4_A_MARK = 1727,
	DU_DR4_MARK = 1728,
	IP7_31_28_MARK = 1729,
	SD0_DAT1_MARK = 1730,
	MSIOF1_TXD_E_MARK = 1731,
	TS_SPSYNC0_B_MARK = 1732,
	STP_ISSYNC_0_B_MARK = 1733,
	IP8_3_0_MARK = 1734,
	SD0_DAT2_MARK = 1735,
	MSIOF1_SS1_E_MARK = 1736,
	TS_SDAT0_B_MARK = 1737,
	STP_ISD_0_B_MARK = 1738,
	IP9_3_0_MARK = 1739,
	SD2_CLK_MARK = 1740,
	NFDATA8_MARK = 1741,
	IP10_3_0_MARK = 1742,
	SD3_CMD_MARK = 1743,
	NFRE_N_MARK = 1744,
	IP11_3_0_MARK = 1745,
	SD3_DAT7_MARK = 1746,
	SD3_WP_MARK = 1747,
	NFDATA7_MARK = 1748,
	IP8_7_4_MARK = 1749,
	SD0_DAT3_MARK = 1750,
	MSIOF1_SS2_E_MARK = 1751,
	TS_SDEN0_B_MARK = 1752,
	STP_ISEN_0_B_MARK = 1753,
	IP9_7_4_MARK = 1754,
	SD2_CMD_MARK = 1755,
	NFDATA9_MARK = 1756,
	IP10_7_4_MARK = 1757,
	SD3_DAT0_MARK = 1758,
	NFDATA0_MARK = 1759,
	IP11_7_4_MARK = 1760,
	SD3_DS_MARK = 1761,
	NFCLE_MARK = 1762,
	IP8_11_8_MARK = 1763,
	SD1_CLK_MARK = 1764,
	MSIOF1_SCK_G_MARK = 1765,
	SIM0_CLK_A_MARK = 1766,
	IP9_11_8_MARK = 1767,
	SD2_DAT0_MARK = 1768,
	NFDATA10_MARK = 1769,
	IP10_11_8_MARK = 1770,
	SD3_DAT1_MARK = 1771,
	NFDATA1_MARK = 1772,
	IP11_11_8_MARK = 1773,
	SD0_CD_MARK = 1774,
	NFDATA14_A_MARK = 1775,
	SCL2_B_MARK = 1776,
	SIM0_RST_A_MARK = 1777,
	IP8_15_12_MARK = 1778,
	SD1_CMD_MARK = 1779,
	MSIOF1_SYNC_G_MARK = 1780,
	NFCE_N_B_MARK = 1781,
	SIM0_D_A_MARK = 1782,
	STP_IVCXO27_1_B_MARK = 1783,
	IP9_15_12_MARK = 1784,
	SD2_DAT1_MARK = 1785,
	NFDATA11_MARK = 1786,
	IP10_15_12_MARK = 1787,
	SD3_DAT2_MARK = 1788,
	NFDATA2_MARK = 1789,
	IP11_15_12_MARK = 1790,
	SD0_WP_MARK = 1791,
	NFDATA15_A_MARK = 1792,
	SDA2_B_MARK = 1793,
	IP8_19_16_MARK = 1794,
	SD1_DAT0_MARK = 1795,
	SD2_DAT4_MARK = 1796,
	MSIOF1_RXD_G_MARK = 1797,
	NFWP_N_B_MARK = 1798,
	TS_SCK1_B_MARK = 1799,
	STP_ISCLK_1_B_MARK = 1800,
	IP9_19_16_MARK = 1801,
	SD2_DAT2_MARK = 1802,
	NFDATA12_MARK = 1803,
	IP10_19_16_MARK = 1804,
	SD3_DAT3_MARK = 1805,
	NFDATA3_MARK = 1806,
	IP11_19_16_MARK = 1807,
	SD1_CD_MARK = 1808,
	NFRB_N_A_MARK = 1809,
	SIM0_CLK_B_MARK = 1810,
	IP8_23_20_MARK = 1811,
	SD1_DAT1_MARK = 1812,
	SD2_DAT5_MARK = 1813,
	MSIOF1_TXD_G_MARK = 1814,
	NFDATA14_B_MARK = 1815,
	TS_SPSYNC1_B_MARK = 1816,
	STP_ISSYNC_1_B_MARK = 1817,
	IP9_23_20_MARK = 1818,
	SD2_DAT3_MARK = 1819,
	NFDATA13_MARK = 1820,
	IP10_23_20_MARK = 1821,
	SD3_DAT4_MARK = 1822,
	SD2_CD_A_MARK = 1823,
	NFDATA4_MARK = 1824,
	IP11_23_20_MARK = 1825,
	SD1_WP_MARK = 1826,
	NFCE_N_A_MARK = 1827,
	SIM0_D_B_MARK = 1828,
	IP8_27_24_MARK = 1829,
	SD1_DAT2_MARK = 1830,
	SD2_DAT6_MARK = 1831,
	MSIOF1_SS1_G_MARK = 1832,
	NFDATA15_B_MARK = 1833,
	TS_SDAT1_B_MARK = 1834,
	STP_ISD_1_B_MARK = 1835,
	IP9_27_24_MARK = 1836,
	SD2_DS_MARK = 1837,
	NFALE_MARK = 1838,
	IP10_27_24_MARK = 1839,
	SD3_DAT5_MARK = 1840,
	SD2_WP_A_MARK = 1841,
	NFDATA5_MARK = 1842,
	IP11_27_24_MARK = 1843,
	SCK0_MARK = 1844,
	HSCK1_B_MARK = 1845,
	MSIOF1_SS2_B_MARK = 1846,
	AUDIO_CLKC_B_MARK = 1847,
	SDA2_A_MARK = 1848,
	SIM0_RST_B_MARK = 1849,
	STP_OPWM_0_C_MARK = 1850,
	RIF0_CLK_B_MARK = 1851,
	ADICHS2_MARK = 1852,
	SCK5_B_MARK = 1853,
	IP8_31_28_MARK = 1854,
	SD1_DAT3_MARK = 1855,
	SD2_DAT7_MARK = 1856,
	MSIOF1_SS2_G_MARK = 1857,
	NFRB_N_B_MARK = 1858,
	TS_SDEN1_B_MARK = 1859,
	STP_ISEN_1_B_MARK = 1860,
	IP9_31_28_MARK = 1861,
	SD3_CLK_MARK = 1862,
	NFWE_N_MARK = 1863,
	IP10_31_28_MARK = 1864,
	SD3_DAT6_MARK = 1865,
	SD3_CD_MARK = 1866,
	NFDATA6_MARK = 1867,
	IP11_31_28_MARK = 1868,
	RX0_MARK = 1869,
	HRX1_B_MARK = 1870,
	TS_SCK0_C_MARK = 1871,
	STP_ISCLK_0_C_MARK = 1872,
	RIF0_D0_B_MARK = 1873,
	IP12_3_0_MARK = 1874,
	TX0_MARK = 1875,
	HTX1_B_MARK = 1876,
	TS_SPSYNC0_C_MARK = 1877,
	STP_ISSYNC_0_C_MARK = 1878,
	RIF0_D1_B_MARK = 1879,
	IP13_3_0_MARK = 1880,
	TX2_A_MARK = 1881,
	SD2_CD_B_MARK = 1882,
	SCL1_A_MARK = 1883,
	FMCLK_A_MARK = 1884,
	RIF1_D1_C_MARK = 1885,
	FSO_CFE_0_N_MARK = 1886,
	IP14_3_0_MARK = 1887,
	MSIOF0_SS1_MARK = 1888,
	RX5_A_MARK = 1889,
	NFWP_N_A_MARK = 1890,
	AUDIO_CLKA_C_MARK = 1891,
	SSI_SCK2_A_MARK = 1892,
	STP_IVCXO27_0_C_MARK = 1893,
	AUDIO_CLKOUT3_A_MARK = 1894,
	TCLK1_B_MARK = 1895,
	IP15_3_0_MARK = 1896,
	SSI_SDATA1_A_MARK = 1897,
	IP12_7_4_MARK = 1898,
	CTS0_N_MARK = 1899,
	HCTS1_N_B_MARK = 1900,
	MSIOF1_SYNC_B_MARK = 1901,
	TS_SPSYNC1_C_MARK = 1902,
	STP_ISSYNC_1_C_MARK = 1903,
	RIF1_SYNC_B_MARK = 1904,
	AUDIO_CLKOUT_C_MARK = 1905,
	ADICS_SAMP_MARK = 1906,
	IP13_7_4_MARK = 1907,
	RX2_A_MARK = 1908,
	SD2_WP_B_MARK = 1909,
	SDA1_A_MARK = 1910,
	FMIN_A_MARK = 1911,
	RIF1_SYNC_C_MARK = 1912,
	FSO_CFE_1_N_MARK = 1913,
	IP14_7_4_MARK = 1914,
	MSIOF0_SS2_MARK = 1915,
	TX5_A_MARK = 1916,
	MSIOF1_SS2_D_MARK = 1917,
	AUDIO_CLKC_A_MARK = 1918,
	SSI_WS2_A_MARK = 1919,
	STP_OPWM_0_D_MARK = 1920,
	AUDIO_CLKOUT_D_MARK = 1921,
	SPEEDIN_B_MARK = 1922,
	IP15_7_4_MARK = 1923,
	SSI_SDATA2_A_MARK = 1924,
	SSI_SCK1_B_MARK = 1925,
	IP12_11_8_MARK = 1926,
	RTS0_N_MARK = 1927,
	HRTS1_N_B_MARK = 1928,
	MSIOF1_SS1_B_MARK = 1929,
	AUDIO_CLKA_B_MARK = 1930,
	SCL2_A_MARK = 1931,
	STP_IVCXO27_1_C_MARK = 1932,
	RIF0_SYNC_B_MARK = 1933,
	ADICHS1_MARK = 1934,
	IP13_11_8_MARK = 1935,
	HSCK0_MARK = 1936,
	MSIOF1_SCK_D_MARK = 1937,
	AUDIO_CLKB_A_MARK = 1938,
	SSI_SDATA1_B_MARK = 1939,
	TS_SCK0_D_MARK = 1940,
	STP_ISCLK_0_D_MARK = 1941,
	RIF0_CLK_C_MARK = 1942,
	RX5_B_MARK = 1943,
	IP14_11_8_MARK = 1944,
	MLB_CLK_MARK = 1945,
	MSIOF1_SCK_F_MARK = 1946,
	SCL1_B_MARK = 1947,
	IP15_11_8_MARK = 1948,
	SSI_SCK349_MARK = 1949,
	MSIOF1_SS1_A_MARK = 1950,
	STP_OPWM_0_A_MARK = 1951,
	IP12_15_12_MARK = 1952,
	RX1_A_MARK = 1953,
	HRX1_A_MARK = 1954,
	TS_SDAT0_C_MARK = 1955,
	STP_ISD_0_C_MARK = 1956,
	RIF1_CLK_C_MARK = 1957,
	IP13_15_12_MARK = 1958,
	HRX0_MARK = 1959,
	MSIOF1_RXD_D_MARK = 1960,
	SSI_SDATA2_B_MARK = 1961,
	TS_SDEN0_D_MARK = 1962,
	STP_ISEN_0_D_MARK = 1963,
	RIF0_D0_C_MARK = 1964,
	IP14_15_12_MARK = 1965,
	MLB_SIG_MARK = 1966,
	RX1_B_MARK = 1967,
	MSIOF1_SYNC_F_MARK = 1968,
	SDA1_B_MARK = 1969,
	IP15_15_12_MARK = 1970,
	SSI_WS349_MARK = 1971,
	HCTS2_N_A_MARK = 1972,
	MSIOF1_SS2_A_MARK = 1973,
	STP_IVCXO27_0_A_MARK = 1974,
	IP12_19_16_MARK = 1975,
	TX1_A_MARK = 1976,
	HTX1_A_MARK = 1977,
	TS_SDEN0_C_MARK = 1978,
	STP_ISEN_0_C_MARK = 1979,
	RIF1_D0_C_MARK = 1980,
	IP13_19_16_MARK = 1981,
	HTX0_MARK = 1982,
	MSIOF1_TXD_D_MARK = 1983,
	SSI_SDATA9_B_MARK = 1984,
	TS_SDAT0_D_MARK = 1985,
	STP_ISD_0_D_MARK = 1986,
	RIF0_D1_C_MARK = 1987,
	IP14_19_16_MARK = 1988,
	MLB_DAT_MARK = 1989,
	TX1_B_MARK = 1990,
	MSIOF1_RXD_F_MARK = 1991,
	IP15_19_16_MARK = 1992,
	SSI_SDATA3_MARK = 1993,
	HRTS2_N_A_MARK = 1994,
	MSIOF1_TXD_A_MARK = 1995,
	TS_SCK0_A_MARK = 1996,
	STP_ISCLK_0_A_MARK = 1997,
	RIF0_D1_A_MARK = 1998,
	RIF2_D0_A_MARK = 1999,
	IP12_23_20_MARK = 2000,
	CTS1_N_MARK = 2001,
	HCTS1_N_A_MARK = 2002,
	MSIOF1_RXD_B_MARK = 2003,
	TS_SDEN1_C_MARK = 2004,
	STP_ISEN_1_C_MARK = 2005,
	RIF1_D0_B_MARK = 2006,
	ADIDATA_MARK = 2007,
	IP13_23_20_MARK = 2008,
	HCTS0_N_MARK = 2009,
	RX2_B_MARK = 2010,
	MSIOF1_SYNC_D_MARK = 2011,
	SSI_SCK9_A_MARK = 2012,
	TS_SPSYNC0_D_MARK = 2013,
	STP_ISSYNC_0_D_MARK = 2014,
	RIF0_SYNC_C_MARK = 2015,
	AUDIO_CLKOUT1_A_MARK = 2016,
	IP14_23_20_MARK = 2017,
	SSI_SCK01239_MARK = 2018,
	MSIOF1_TXD_F_MARK = 2019,
	IP15_23_20_MARK = 2020,
	SSI_SCK4_MARK = 2021,
	HRX2_A_MARK = 2022,
	MSIOF1_SCK_A_MARK = 2023,
	TS_SDAT0_A_MARK = 2024,
	STP_ISD_0_A_MARK = 2025,
	RIF0_CLK_A_MARK = 2026,
	RIF2_CLK_A_MARK = 2027,
	IP12_27_24_MARK = 2028,
	RTS1_N_MARK = 2029,
	HRTS1_N_A_MARK = 2030,
	MSIOF1_TXD_B_MARK = 2031,
	TS_SDAT1_C_MARK = 2032,
	STP_ISD_1_C_MARK = 2033,
	RIF1_D1_B_MARK = 2034,
	ADICHS0_MARK = 2035,
	IP13_27_24_MARK = 2036,
	HRTS0_N_MARK = 2037,
	TX2_B_MARK = 2038,
	MSIOF1_SS1_D_MARK = 2039,
	SSI_WS9_A_MARK = 2040,
	STP_IVCXO27_0_D_MARK = 2041,
	BPFCLK_A_MARK = 2042,
	AUDIO_CLKOUT2_A_MARK = 2043,
	IP14_27_24_MARK = 2044,
	SSI_WS01239_MARK = 2045,
	MSIOF1_SS1_F_MARK = 2046,
	IP15_27_24_MARK = 2047,
	SSI_WS4_MARK = 2048,
	HTX2_A_MARK = 2049,
	MSIOF1_SYNC_A_MARK = 2050,
	TS_SDEN0_A_MARK = 2051,
	STP_ISEN_0_A_MARK = 2052,
	RIF0_SYNC_A_MARK = 2053,
	RIF2_SYNC_A_MARK = 2054,
	IP12_31_28_MARK = 2055,
	SCK2_MARK = 2056,
	SCIF_CLK_B_MARK = 2057,
	MSIOF1_SCK_B_MARK = 2058,
	TS_SCK1_C_MARK = 2059,
	STP_ISCLK_1_C_MARK = 2060,
	RIF1_CLK_B_MARK = 2061,
	ADICLK_MARK = 2062,
	IP13_31_28_MARK = 2063,
	MSIOF0_SYNC_MARK = 2064,
	AUDIO_CLKOUT_A_MARK = 2065,
	TX5_B_MARK = 2066,
	BPFCLK_D_MARK = 2067,
	IP14_31_28_MARK = 2068,
	SSI_SDATA0_MARK = 2069,
	MSIOF1_SS2_F_MARK = 2070,
	IP15_31_28_MARK = 2071,
	SSI_SDATA4_MARK = 2072,
	HSCK2_A_MARK = 2073,
	MSIOF1_RXD_A_MARK = 2074,
	TS_SPSYNC0_A_MARK = 2075,
	STP_ISSYNC_0_A_MARK = 2076,
	RIF0_D0_A_MARK = 2077,
	RIF2_D1_A_MARK = 2078,
	IP16_3_0_MARK = 2079,
	SSI_SCK6_MARK = 2080,
	SIM0_RST_D_MARK = 2081,
	IP17_3_0_MARK = 2082,
	AUDIO_CLKA_A_MARK = 2083,
	IP18_3_0_MARK = 2084,
	GP6_30_MARK = 2085,
	AUDIO_CLKOUT2_B_MARK = 2086,
	SSI_SCK9_B_MARK = 2087,
	TS_SDEN0_E_MARK = 2088,
	STP_ISEN_0_E_MARK = 2089,
	RIF2_D0_B_MARK = 2090,
	TPU0TO2_MARK = 2091,
	FMCLK_C_MARK = 2092,
	FMCLK_D_MARK = 2093,
	IP16_7_4_MARK = 2094,
	SSI_WS6_MARK = 2095,
	SIM0_D_D_MARK = 2096,
	IP17_7_4_MARK = 2097,
	AUDIO_CLKB_B_MARK = 2098,
	SCIF_CLK_A_MARK = 2099,
	STP_IVCXO27_1_D_MARK = 2100,
	REMOCON_A_MARK = 2101,
	TCLK1_A_MARK = 2102,
	IP18_7_4_MARK = 2103,
	GP6_31_MARK = 2104,
	AUDIO_CLKOUT3_B_MARK = 2105,
	SSI_WS9_B_MARK = 2106,
	TS_SPSYNC0_E_MARK = 2107,
	STP_ISSYNC_0_E_MARK = 2108,
	RIF2_D1_B_MARK = 2109,
	TPU0TO3_MARK = 2110,
	FMIN_C_MARK = 2111,
	FMIN_D_MARK = 2112,
	IP16_11_8_MARK = 2113,
	SSI_SDATA6_MARK = 2114,
	SIM0_CLK_D_MARK = 2115,
	IP17_11_8_MARK = 2116,
	USB0_PWEN_MARK = 2117,
	SIM0_RST_C_MARK = 2118,
	TS_SCK1_D_MARK = 2119,
	STP_ISCLK_1_D_MARK = 2120,
	BPFCLK_B_MARK = 2121,
	RIF3_CLK_B_MARK = 2122,
	HSCK2_C_MARK = 2123,
	IP16_15_12_MARK = 2124,
	SSI_SCK78_MARK = 2125,
	HRX2_B_MARK = 2126,
	MSIOF1_SCK_C_MARK = 2127,
	TS_SCK1_A_MARK = 2128,
	STP_ISCLK_1_A_MARK = 2129,
	RIF1_CLK_A_MARK = 2130,
	RIF3_CLK_A_MARK = 2131,
	IP17_15_12_MARK = 2132,
	USB0_OVC_MARK = 2133,
	SIM0_D_C_MARK = 2134,
	TS_SDAT1_D_MARK = 2135,
	STP_ISD_1_D_MARK = 2136,
	RIF3_SYNC_B_MARK = 2137,
	HRX2_C_MARK = 2138,
	IP16_19_16_MARK = 2139,
	SSI_WS78_MARK = 2140,
	HTX2_B_MARK = 2141,
	MSIOF1_SYNC_C_MARK = 2142,
	TS_SDAT1_A_MARK = 2143,
	STP_ISD_1_A_MARK = 2144,
	RIF1_SYNC_A_MARK = 2145,
	RIF3_SYNC_A_MARK = 2146,
	IP17_19_16_MARK = 2147,
	USB1_PWEN_MARK = 2148,
	SIM0_CLK_C_MARK = 2149,
	SSI_SCK1_A_MARK = 2150,
	TS_SCK0_E_MARK = 2151,
	STP_ISCLK_0_E_MARK = 2152,
	FMCLK_B_MARK = 2153,
	RIF2_CLK_B_MARK = 2154,
	SPEEDIN_A_MARK = 2155,
	HTX2_C_MARK = 2156,
	IP16_23_20_MARK = 2157,
	SSI_SDATA7_MARK = 2158,
	HCTS2_N_B_MARK = 2159,
	MSIOF1_RXD_C_MARK = 2160,
	TS_SDEN1_A_MARK = 2161,
	STP_ISEN_1_A_MARK = 2162,
	RIF1_D0_A_MARK = 2163,
	RIF3_D0_A_MARK = 2164,
	TCLK2_A_MARK = 2165,
	IP17_23_20_MARK = 2166,
	USB1_OVC_MARK = 2167,
	MSIOF1_SS2_C_MARK = 2168,
	SSI_WS1_A_MARK = 2169,
	TS_SDAT0_E_MARK = 2170,
	STP_ISD_0_E_MARK = 2171,
	FMIN_B_MARK = 2172,
	RIF2_SYNC_B_MARK = 2173,
	REMOCON_B_MARK = 2174,
	HCTS2_N_C_MARK = 2175,
	IP16_27_24_MARK = 2176,
	SSI_SDATA8_MARK = 2177,
	HRTS2_N_B_MARK = 2178,
	MSIOF1_TXD_C_MARK = 2179,
	TS_SPSYNC1_A_MARK = 2180,
	STP_ISSYNC_1_A_MARK = 2181,
	RIF1_D1_A_MARK = 2182,
	RIF3_D1_A_MARK = 2183,
	IP17_27_24_MARK = 2184,
	USB30_PWEN_MARK = 2185,
	AUDIO_CLKOUT_B_MARK = 2186,
	SSI_SCK2_B_MARK = 2187,
	TS_SDEN1_D_MARK = 2188,
	STP_ISEN_1_D_MARK = 2189,
	STP_OPWM_0_E_MARK = 2190,
	RIF3_D0_B_MARK = 2191,
	TCLK2_B_MARK = 2192,
	TPU0TO0_MARK = 2193,
	BPFCLK_C_MARK = 2194,
	HRTS2_N_C_MARK = 2195,
	IP16_31_28_MARK = 2196,
	SSI_SDATA9_A_MARK = 2197,
	HSCK2_B_MARK = 2198,
	MSIOF1_SS1_C_MARK = 2199,
	HSCK1_A_MARK = 2200,
	SSI_WS1_B_MARK = 2201,
	SCK1_MARK = 2202,
	STP_IVCXO27_1_A_MARK = 2203,
	SCK5_A_MARK = 2204,
	IP17_31_28_MARK = 2205,
	USB30_OVC_MARK = 2206,
	AUDIO_CLKOUT1_B_MARK = 2207,
	SSI_WS2_B_MARK = 2208,
	TS_SPSYNC1_D_MARK = 2209,
	STP_ISSYNC_1_D_MARK = 2210,
	STP_IVCXO27_0_E_MARK = 2211,
	RIF3_D1_B_MARK = 2212,
	FSO_TOE_N_MARK = 2213,
	TPU0TO1_MARK = 2214,
	SEL_MSIOF3_0_MARK = 2215,
	SEL_MSIOF3_1_MARK = 2216,
	SEL_MSIOF3_2_MARK = 2217,
	SEL_MSIOF3_3_MARK = 2218,
	SEL_MSIOF3_4_MARK = 2219,
	SEL_TSIF1_0_MARK = 2220,
	SEL_TSIF1_1_MARK = 2221,
	SEL_TSIF1_2_MARK = 2222,
	SEL_TSIF1_3_MARK = 2223,
	I2C_SEL_5_0_MARK = 2224,
	I2C_SEL_5_1_MARK = 2225,
	I2C_SEL_3_0_MARK = 2226,
	I2C_SEL_3_1_MARK = 2227,
	SEL_TSIF0_0_MARK = 2228,
	SEL_TSIF0_1_MARK = 2229,
	SEL_TSIF0_2_MARK = 2230,
	SEL_TSIF0_3_MARK = 2231,
	SEL_TSIF0_4_MARK = 2232,
	I2C_SEL_0_0_MARK = 2233,
	I2C_SEL_0_1_MARK = 2234,
	SEL_MSIOF2_0_MARK = 2235,
	SEL_MSIOF2_1_MARK = 2236,
	SEL_MSIOF2_2_MARK = 2237,
	SEL_MSIOF2_3_MARK = 2238,
	SEL_FM_0_MARK = 2239,
	SEL_FM_1_MARK = 2240,
	SEL_FM_2_MARK = 2241,
	SEL_FM_3_MARK = 2242,
	SEL_MSIOF1_0_MARK = 2243,
	SEL_MSIOF1_1_MARK = 2244,
	SEL_MSIOF1_2_MARK = 2245,
	SEL_MSIOF1_3_MARK = 2246,
	SEL_MSIOF1_4_MARK = 2247,
	SEL_MSIOF1_5_MARK = 2248,
	SEL_MSIOF1_6_MARK = 2249,
	SEL_TIMER_TMU_0_MARK = 2250,
	SEL_TIMER_TMU_1_MARK = 2251,
	SEL_SCIF5_0_MARK = 2252,
	SEL_SCIF5_1_MARK = 2253,
	SEL_SSP1_1_0_MARK = 2254,
	SEL_SSP1_1_1_MARK = 2255,
	SEL_SSP1_1_2_MARK = 2256,
	SEL_SSP1_1_3_MARK = 2257,
	SEL_I2C6_0_MARK = 2258,
	SEL_I2C6_1_MARK = 2259,
	SEL_I2C6_2_MARK = 2260,
	SEL_LBSC_0_MARK = 2261,
	SEL_LBSC_1_MARK = 2262,
	SEL_SSP1_0_0_MARK = 2263,
	SEL_SSP1_0_1_MARK = 2264,
	SEL_SSP1_0_2_MARK = 2265,
	SEL_SSP1_0_3_MARK = 2266,
	SEL_SSP1_0_4_MARK = 2267,
	SEL_IEBUS_0_MARK = 2268,
	SEL_IEBUS_1_MARK = 2269,
	SEL_NDF_0_MARK = 2270,
	SEL_NDF_1_MARK = 2271,
	SEL_I2C2_0_MARK = 2272,
	SEL_I2C2_1_MARK = 2273,
	SEL_SSI2_0_MARK = 2274,
	SEL_SSI2_1_MARK = 2275,
	SEL_I2C1_0_MARK = 2276,
	SEL_I2C1_1_MARK = 2277,
	SEL_SSI1_0_MARK = 2278,
	SEL_SSI1_1_MARK = 2279,
	SEL_SSI9_0_MARK = 2280,
	SEL_SSI9_1_MARK = 2281,
	SEL_HSCIF4_0_MARK = 2282,
	SEL_HSCIF4_1_MARK = 2283,
	SEL_SPEED_PULSE_0_MARK = 2284,
	SEL_SPEED_PULSE_1_MARK = 2285,
	SEL_TIMER_TMU2_0_MARK = 2286,
	SEL_TIMER_TMU2_1_MARK = 2287,
	SEL_HSCIF3_0_MARK = 2288,
	SEL_HSCIF3_1_MARK = 2289,
	SEL_HSCIF3_2_MARK = 2290,
	SEL_HSCIF3_3_MARK = 2291,
	SEL_SIMCARD_0_MARK = 2292,
	SEL_SIMCARD_1_MARK = 2293,
	SEL_SIMCARD_2_MARK = 2294,
	SEL_SIMCARD_3_MARK = 2295,
	SEL_ADGB_0_MARK = 2296,
	SEL_ADGB_1_MARK = 2297,
	SEL_ADGC_0_MARK = 2298,
	SEL_ADGC_1_MARK = 2299,
	SEL_HSCIF1_0_MARK = 2300,
	SEL_HSCIF1_1_MARK = 2301,
	SEL_SDHI2_0_MARK = 2302,
	SEL_SDHI2_1_MARK = 2303,
	SEL_SCIF4_0_MARK = 2304,
	SEL_SCIF4_1_MARK = 2305,
	SEL_SCIF4_2_MARK = 2306,
	SEL_HSCIF2_0_MARK = 2307,
	SEL_HSCIF2_1_MARK = 2308,
	SEL_HSCIF2_2_MARK = 2309,
	SEL_SCIF3_0_MARK = 2310,
	SEL_SCIF3_1_MARK = 2311,
	SEL_ETHERAVB_0_MARK = 2312,
	SEL_ETHERAVB_1_MARK = 2313,
	SEL_SCIF2_0_MARK = 2314,
	SEL_SCIF2_1_MARK = 2315,
	SEL_DRIF3_0_MARK = 2316,
	SEL_DRIF3_1_MARK = 2317,
	SEL_SCIF1_0_MARK = 2318,
	SEL_SCIF1_1_MARK = 2319,
	SEL_DRIF2_0_MARK = 2320,
	SEL_DRIF2_1_MARK = 2321,
	SEL_SCIF_0_MARK = 2322,
	SEL_SCIF_1_MARK = 2323,
	SEL_DRIF1_0_MARK = 2324,
	SEL_DRIF1_1_MARK = 2325,
	SEL_DRIF1_2_MARK = 2326,
	SEL_REMOCON_0_MARK = 2327,
	SEL_REMOCON_1_MARK = 2328,
	SEL_DRIF0_0_MARK = 2329,
	SEL_DRIF0_1_MARK = 2330,
	SEL_DRIF0_2_MARK = 2331,
	SEL_RCAN0_0_MARK = 2332,
	SEL_RCAN0_1_MARK = 2333,
	SEL_CANFD0_0_MARK = 2334,
	SEL_CANFD0_1_MARK = 2335,
	SEL_PWM6_0_MARK = 2336,
	SEL_PWM6_1_MARK = 2337,
	SEL_ADGA_0_MARK = 2338,
	SEL_ADGA_1_MARK = 2339,
	SEL_ADGA_2_MARK = 2340,
	SEL_ADGA_3_MARK = 2341,
	SEL_PWM5_0_MARK = 2342,
	SEL_PWM5_1_MARK = 2343,
	SEL_PWM4_0_MARK = 2344,
	SEL_PWM4_1_MARK = 2345,
	SEL_PWM3_0_MARK = 2346,
	SEL_PWM3_1_MARK = 2347,
	SEL_PWM2_0_MARK = 2348,
	SEL_PWM2_1_MARK = 2349,
	SEL_PWM1_0_MARK = 2350,
	SEL_PWM1_1_MARK = 2351,
	SEL_VIN4_0_MARK = 2352,
	SEL_VIN4_1_MARK = 2353,
	QSPI0_SPCLK_MARK = 2354,
	QSPI0_SSL_MARK = 2355,
	QSPI0_MOSI_IO0_MARK = 2356,
	QSPI0_MISO_IO1_MARK = 2357,
	QSPI0_IO2_MARK = 2358,
	QSPI0_IO3_MARK = 2359,
	QSPI1_SPCLK_MARK = 2360,
	QSPI1_SSL_MARK = 2361,
	QSPI1_MOSI_IO0_MARK = 2362,
	QSPI1_MISO_IO1_MARK = 2363,
	QSPI1_IO2_MARK = 2364,
	QSPI1_IO3_MARK = 2365,
	RPC_INT_MARK = 2366,
	RPC_WP_MARK = 2367,
	RPC_RESET_MARK = 2368,
	AVB_TX_CTL_MARK = 2369,
	AVB_TXC_MARK = 2370,
	AVB_TD0_MARK = 2371,
	AVB_TD1_MARK = 2372,
	AVB_TD2_MARK = 2373,
	AVB_TD3_MARK = 2374,
	AVB_RX_CTL_MARK = 2375,
	AVB_RXC_MARK = 2376,
	AVB_RD0_MARK = 2377,
	AVB_RD1_MARK = 2378,
	AVB_RD2_MARK = 2379,
	AVB_RD3_MARK = 2380,
	AVB_TXCREFCLK_MARK = 2381,
	AVB_MDIO_MARK = 2382,
	PRESETOUT_MARK = 2383,
	DU_DOTCLKIN0_MARK = 2384,
	DU_DOTCLKIN1_MARK = 2385,
	DU_DOTCLKIN2_MARK = 2386,
	TMS_MARK = 2387,
	TDO_MARK = 2388,
	ASEBRK_MARK = 2389,
	MLB_REF_MARK = 2390,
	TDI_MARK = 2391,
	TCK_MARK = 2392,
	TRST_MARK = 2393,
	EXTALR_MARK = 2394,
	SCL0_MARK = 2395,
	SDA0_MARK = 2396,
	SCL3_MARK = 2397,
	SDA3_MARK = 2398,
	SCL5_MARK = 2399,
	SDA5_MARK = 2400,
	PINMUX_MARK_END = 2401,
};

enum {
	PINMUX_RESERVED___2 = 0,
	PINMUX_DATA_BEGIN___2 = 1,
	GP_0_0_DATA___2 = 2,
	GP_0_1_DATA___2 = 3,
	GP_0_2_DATA___2 = 4,
	GP_0_3_DATA___2 = 5,
	GP_0_4_DATA___2 = 6,
	GP_0_5_DATA___2 = 7,
	GP_0_6_DATA___2 = 8,
	GP_0_7_DATA___2 = 9,
	GP_0_8_DATA___2 = 10,
	GP_0_9_DATA___2 = 11,
	GP_0_10_DATA___2 = 12,
	GP_0_11_DATA___2 = 13,
	GP_0_12_DATA___2 = 14,
	GP_0_13_DATA___2 = 15,
	GP_0_14_DATA___2 = 16,
	GP_0_15_DATA___2 = 17,
	GP_1_0_DATA___2 = 18,
	GP_1_1_DATA___2 = 19,
	GP_1_2_DATA___2 = 20,
	GP_1_3_DATA___2 = 21,
	GP_1_4_DATA___2 = 22,
	GP_1_5_DATA___2 = 23,
	GP_1_6_DATA___2 = 24,
	GP_1_7_DATA___2 = 25,
	GP_1_8_DATA___2 = 26,
	GP_1_9_DATA___2 = 27,
	GP_1_10_DATA___2 = 28,
	GP_1_11_DATA___2 = 29,
	GP_1_12_DATA___2 = 30,
	GP_1_13_DATA___2 = 31,
	GP_1_14_DATA___2 = 32,
	GP_1_15_DATA___2 = 33,
	GP_1_16_DATA___2 = 34,
	GP_1_17_DATA___2 = 35,
	GP_1_18_DATA___2 = 36,
	GP_1_19_DATA___2 = 37,
	GP_1_20_DATA___2 = 38,
	GP_1_21_DATA___2 = 39,
	GP_1_22_DATA___2 = 40,
	GP_1_23_DATA___2 = 41,
	GP_1_24_DATA___2 = 42,
	GP_1_25_DATA___2 = 43,
	GP_1_26_DATA___2 = 44,
	GP_1_27_DATA___2 = 45,
	GP_1_28_DATA___2 = 46,
	GP_2_0_DATA___2 = 47,
	GP_2_1_DATA___2 = 48,
	GP_2_2_DATA___2 = 49,
	GP_2_3_DATA___2 = 50,
	GP_2_4_DATA___2 = 51,
	GP_2_5_DATA___2 = 52,
	GP_2_6_DATA___2 = 53,
	GP_2_7_DATA___2 = 54,
	GP_2_8_DATA___2 = 55,
	GP_2_9_DATA___2 = 56,
	GP_2_10_DATA___2 = 57,
	GP_2_11_DATA___2 = 58,
	GP_2_12_DATA___2 = 59,
	GP_2_13_DATA___2 = 60,
	GP_2_14_DATA___2 = 61,
	GP_3_0_DATA___2 = 62,
	GP_3_1_DATA___2 = 63,
	GP_3_2_DATA___2 = 64,
	GP_3_3_DATA___2 = 65,
	GP_3_4_DATA___2 = 66,
	GP_3_5_DATA___2 = 67,
	GP_3_6_DATA___2 = 68,
	GP_3_7_DATA___2 = 69,
	GP_3_8_DATA___2 = 70,
	GP_3_9_DATA___2 = 71,
	GP_3_10_DATA___2 = 72,
	GP_3_11_DATA___2 = 73,
	GP_3_12_DATA___2 = 74,
	GP_3_13_DATA___2 = 75,
	GP_3_14_DATA___2 = 76,
	GP_3_15_DATA___2 = 77,
	GP_4_0_DATA___2 = 78,
	GP_4_1_DATA___2 = 79,
	GP_4_2_DATA___2 = 80,
	GP_4_3_DATA___2 = 81,
	GP_4_4_DATA___2 = 82,
	GP_4_5_DATA___2 = 83,
	GP_4_6_DATA___2 = 84,
	GP_4_7_DATA___2 = 85,
	GP_4_8_DATA___2 = 86,
	GP_4_9_DATA___2 = 87,
	GP_4_10_DATA___2 = 88,
	GP_4_11_DATA___2 = 89,
	GP_4_12_DATA___2 = 90,
	GP_4_13_DATA___2 = 91,
	GP_4_14_DATA___2 = 92,
	GP_4_15_DATA___2 = 93,
	GP_4_16_DATA___2 = 94,
	GP_4_17_DATA___2 = 95,
	GP_5_0_DATA___2 = 96,
	GP_5_1_DATA___2 = 97,
	GP_5_2_DATA___2 = 98,
	GP_5_3_DATA___2 = 99,
	GP_5_4_DATA___2 = 100,
	GP_5_5_DATA___2 = 101,
	GP_5_6_DATA___2 = 102,
	GP_5_7_DATA___2 = 103,
	GP_5_8_DATA___2 = 104,
	GP_5_9_DATA___2 = 105,
	GP_5_10_DATA___2 = 106,
	GP_5_11_DATA___2 = 107,
	GP_5_12_DATA___2 = 108,
	GP_5_13_DATA___2 = 109,
	GP_5_14_DATA___2 = 110,
	GP_5_15_DATA___2 = 111,
	GP_5_16_DATA___2 = 112,
	GP_5_17_DATA___2 = 113,
	GP_5_18_DATA___2 = 114,
	GP_5_19_DATA___2 = 115,
	GP_5_20_DATA___2 = 116,
	GP_5_21_DATA___2 = 117,
	GP_5_22_DATA___2 = 118,
	GP_5_23_DATA___2 = 119,
	GP_5_24_DATA___2 = 120,
	GP_5_25_DATA___2 = 121,
	GP_6_0_DATA___2 = 122,
	GP_6_1_DATA___2 = 123,
	GP_6_2_DATA___2 = 124,
	GP_6_3_DATA___2 = 125,
	GP_6_4_DATA___2 = 126,
	GP_6_5_DATA___2 = 127,
	GP_6_6_DATA___2 = 128,
	GP_6_7_DATA___2 = 129,
	GP_6_8_DATA___2 = 130,
	GP_6_9_DATA___2 = 131,
	GP_6_10_DATA___2 = 132,
	GP_6_11_DATA___2 = 133,
	GP_6_12_DATA___2 = 134,
	GP_6_13_DATA___2 = 135,
	GP_6_14_DATA___2 = 136,
	GP_6_15_DATA___2 = 137,
	GP_6_16_DATA___2 = 138,
	GP_6_17_DATA___2 = 139,
	GP_6_18_DATA___2 = 140,
	GP_6_19_DATA___2 = 141,
	GP_6_20_DATA___2 = 142,
	GP_6_21_DATA___2 = 143,
	GP_6_22_DATA___2 = 144,
	GP_6_23_DATA___2 = 145,
	GP_6_24_DATA___2 = 146,
	GP_6_25_DATA___2 = 147,
	GP_6_26_DATA___2 = 148,
	GP_6_27_DATA___2 = 149,
	GP_6_28_DATA___2 = 150,
	GP_6_29_DATA___2 = 151,
	GP_6_30_DATA___2 = 152,
	GP_6_31_DATA___2 = 153,
	GP_7_0_DATA___2 = 154,
	GP_7_1_DATA___2 = 155,
	GP_7_2_DATA___2 = 156,
	GP_7_3_DATA___2 = 157,
	PINMUX_DATA_END___2 = 158,
	PINMUX_FUNCTION_BEGIN___2 = 159,
	GP_0_0_FN___2 = 160,
	GP_0_1_FN___2 = 161,
	GP_0_2_FN___2 = 162,
	GP_0_3_FN___2 = 163,
	GP_0_4_FN___2 = 164,
	GP_0_5_FN___2 = 165,
	GP_0_6_FN___2 = 166,
	GP_0_7_FN___2 = 167,
	GP_0_8_FN___2 = 168,
	GP_0_9_FN___2 = 169,
	GP_0_10_FN___2 = 170,
	GP_0_11_FN___2 = 171,
	GP_0_12_FN___2 = 172,
	GP_0_13_FN___2 = 173,
	GP_0_14_FN___2 = 174,
	GP_0_15_FN___2 = 175,
	GP_1_0_FN___2 = 176,
	GP_1_1_FN___2 = 177,
	GP_1_2_FN___2 = 178,
	GP_1_3_FN___2 = 179,
	GP_1_4_FN___2 = 180,
	GP_1_5_FN___2 = 181,
	GP_1_6_FN___2 = 182,
	GP_1_7_FN___2 = 183,
	GP_1_8_FN___2 = 184,
	GP_1_9_FN___2 = 185,
	GP_1_10_FN___2 = 186,
	GP_1_11_FN___2 = 187,
	GP_1_12_FN___2 = 188,
	GP_1_13_FN___2 = 189,
	GP_1_14_FN___2 = 190,
	GP_1_15_FN___2 = 191,
	GP_1_16_FN___2 = 192,
	GP_1_17_FN___2 = 193,
	GP_1_18_FN___2 = 194,
	GP_1_19_FN___2 = 195,
	GP_1_20_FN___2 = 196,
	GP_1_21_FN___2 = 197,
	GP_1_22_FN___2 = 198,
	GP_1_23_FN___2 = 199,
	GP_1_24_FN___2 = 200,
	GP_1_25_FN___2 = 201,
	GP_1_26_FN___2 = 202,
	GP_1_27_FN___2 = 203,
	GP_1_28_FN___2 = 204,
	GP_2_0_FN___2 = 205,
	GP_2_1_FN___2 = 206,
	GP_2_2_FN___2 = 207,
	GP_2_3_FN___2 = 208,
	GP_2_4_FN___2 = 209,
	GP_2_5_FN___2 = 210,
	GP_2_6_FN___2 = 211,
	GP_2_7_FN___2 = 212,
	GP_2_8_FN___2 = 213,
	GP_2_9_FN___2 = 214,
	GP_2_10_FN___2 = 215,
	GP_2_11_FN___2 = 216,
	GP_2_12_FN___2 = 217,
	GP_2_13_FN___2 = 218,
	GP_2_14_FN___2 = 219,
	GP_3_0_FN___2 = 220,
	GP_3_1_FN___2 = 221,
	GP_3_2_FN___2 = 222,
	GP_3_3_FN___2 = 223,
	GP_3_4_FN___2 = 224,
	GP_3_5_FN___2 = 225,
	GP_3_6_FN___2 = 226,
	GP_3_7_FN___2 = 227,
	GP_3_8_FN___2 = 228,
	GP_3_9_FN___2 = 229,
	GP_3_10_FN___2 = 230,
	GP_3_11_FN___2 = 231,
	GP_3_12_FN___2 = 232,
	GP_3_13_FN___2 = 233,
	GP_3_14_FN___2 = 234,
	GP_3_15_FN___2 = 235,
	GP_4_0_FN___2 = 236,
	GP_4_1_FN___2 = 237,
	GP_4_2_FN___2 = 238,
	GP_4_3_FN___2 = 239,
	GP_4_4_FN___2 = 240,
	GP_4_5_FN___2 = 241,
	GP_4_6_FN___2 = 242,
	GP_4_7_FN___2 = 243,
	GP_4_8_FN___2 = 244,
	GP_4_9_FN___2 = 245,
	GP_4_10_FN___2 = 246,
	GP_4_11_FN___2 = 247,
	GP_4_12_FN___2 = 248,
	GP_4_13_FN___2 = 249,
	GP_4_14_FN___2 = 250,
	GP_4_15_FN___2 = 251,
	GP_4_16_FN___2 = 252,
	GP_4_17_FN___2 = 253,
	GP_5_0_FN___2 = 254,
	GP_5_1_FN___2 = 255,
	GP_5_2_FN___2 = 256,
	GP_5_3_FN___2 = 257,
	GP_5_4_FN___2 = 258,
	GP_5_5_FN___2 = 259,
	GP_5_6_FN___2 = 260,
	GP_5_7_FN___2 = 261,
	GP_5_8_FN___2 = 262,
	GP_5_9_FN___2 = 263,
	GP_5_10_FN___2 = 264,
	GP_5_11_FN___2 = 265,
	GP_5_12_FN___2 = 266,
	GP_5_13_FN___2 = 267,
	GP_5_14_FN___2 = 268,
	GP_5_15_FN___2 = 269,
	GP_5_16_FN___2 = 270,
	GP_5_17_FN___2 = 271,
	GP_5_18_FN___2 = 272,
	GP_5_19_FN___2 = 273,
	GP_5_20_FN___2 = 274,
	GP_5_21_FN___2 = 275,
	GP_5_22_FN___2 = 276,
	GP_5_23_FN___2 = 277,
	GP_5_24_FN___2 = 278,
	GP_5_25_FN___2 = 279,
	GP_6_0_FN___2 = 280,
	GP_6_1_FN___2 = 281,
	GP_6_2_FN___2 = 282,
	GP_6_3_FN___2 = 283,
	GP_6_4_FN___2 = 284,
	GP_6_5_FN___2 = 285,
	GP_6_6_FN___2 = 286,
	GP_6_7_FN___2 = 287,
	GP_6_8_FN___2 = 288,
	GP_6_9_FN___2 = 289,
	GP_6_10_FN___2 = 290,
	GP_6_11_FN___2 = 291,
	GP_6_12_FN___2 = 292,
	GP_6_13_FN___2 = 293,
	GP_6_14_FN___2 = 294,
	GP_6_15_FN___2 = 295,
	GP_6_16_FN___2 = 296,
	GP_6_17_FN___2 = 297,
	GP_6_18_FN___2 = 298,
	GP_6_19_FN___2 = 299,
	GP_6_20_FN___2 = 300,
	GP_6_21_FN___2 = 301,
	GP_6_22_FN___2 = 302,
	GP_6_23_FN___2 = 303,
	GP_6_24_FN___2 = 304,
	GP_6_25_FN___2 = 305,
	GP_6_26_FN___2 = 306,
	GP_6_27_FN___2 = 307,
	GP_6_28_FN___2 = 308,
	GP_6_29_FN___2 = 309,
	GP_6_30_FN___2 = 310,
	GP_6_31_FN___2 = 311,
	GP_7_0_FN___2 = 312,
	GP_7_1_FN___2 = 313,
	GP_7_2_FN___2 = 314,
	GP_7_3_FN___2 = 315,
	FN_CLKOUT___2 = 316,
	FN_MSIOF0_RXD___2 = 317,
	FN_MSIOF0_TXD___2 = 318,
	FN_MSIOF0_SCK___2 = 319,
	FN_SSI_SDATA5___2 = 320,
	FN_SSI_WS5___2 = 321,
	FN_SSI_SCK5___2 = 322,
	FN_GP7_03___2 = 323,
	FN_GP7_02___2 = 324,
	FN_AVS2___2 = 325,
	FN_AVS1___2 = 326,
	FN_IP0_3_0___2 = 327,
	FN_AVB_MDC___2 = 328,
	FN_MSIOF2_SS2_C___2 = 329,
	FN_IP1_3_0___2 = 330,
	FN_IRQ2___2 = 331,
	FN_QCPV_QDE___2 = 332,
	FN_DU_EXODDF_DU_ODDF_DISP_CDE___2 = 333,
	FN_VI4_DATA2_B___2 = 334,
	FN_MSIOF3_SYNC_E___2 = 335,
	FN_PWM3_B___2 = 336,
	FN_IP2_3_0___2 = 337,
	FN_A1___2 = 338,
	FN_LCDOUT17___2 = 339,
	FN_MSIOF3_TXD_B___2 = 340,
	FN_VI4_DATA9___2 = 341,
	FN_DU_DB1___2 = 342,
	FN_PWM4_A___2 = 343,
	FN_IP3_3_0___2 = 344,
	FN_A9___2 = 345,
	FN_MSIOF2_SCK_A___2 = 346,
	FN_CTS4_N_B___2 = 347,
	FN_VI5_VSYNC_N___2 = 348,
	FN_IP0_7_4___2 = 349,
	FN_AVB_MAGIC___2 = 350,
	FN_MSIOF2_SS1_C___2 = 351,
	FN_SCK4_A___2 = 352,
	FN_IP1_7_4___2 = 353,
	FN_IRQ3___2 = 354,
	FN_QSTVB_QVE___2 = 355,
	FN_DU_DOTCLKOUT1___2 = 356,
	FN_VI4_DATA3_B___2 = 357,
	FN_MSIOF3_SCK_E___2 = 358,
	FN_PWM4_B___2 = 359,
	FN_IP2_7_4___2 = 360,
	FN_A2___2 = 361,
	FN_LCDOUT18___2 = 362,
	FN_MSIOF3_SCK_B___2 = 363,
	FN_VI4_DATA10___2 = 364,
	FN_DU_DB2___2 = 365,
	FN_PWM5_A___2 = 366,
	FN_IP3_7_4___2 = 367,
	FN_A10___2 = 368,
	FN_MSIOF2_RXD_A___2 = 369,
	FN_RTS4_N_B___2 = 370,
	FN_VI5_HSYNC_N___2 = 371,
	FN_IP0_11_8___2 = 372,
	FN_AVB_PHY_INT___2 = 373,
	FN_MSIOF2_SYNC_C___2 = 374,
	FN_RX4_A___2 = 375,
	FN_IP1_11_8___2 = 376,
	FN_IRQ4___2 = 377,
	FN_QSTH_QHS___2 = 378,
	FN_DU_EXHSYNC_DU_HSYNC___2 = 379,
	FN_VI4_DATA4_B___2 = 380,
	FN_MSIOF3_RXD_E___2 = 381,
	FN_PWM5_B___2 = 382,
	FN_IP2_11_8___2 = 383,
	FN_A3___2 = 384,
	FN_LCDOUT19___2 = 385,
	FN_MSIOF3_RXD_B___2 = 386,
	FN_VI4_DATA11___2 = 387,
	FN_DU_DB3___2 = 388,
	FN_PWM6_A___2 = 389,
	FN_IP3_11_8___2 = 390,
	FN_A11___2 = 391,
	FN_TX3_B___2 = 392,
	FN_MSIOF2_TXD_A___2 = 393,
	FN_HTX4_B___2 = 394,
	FN_HSCK4___2 = 395,
	FN_VI5_FIELD___2 = 396,
	FN_SCL6_A___2 = 397,
	FN_AVB_AVTP_CAPTURE_B___2 = 398,
	FN_PWM2_B___2 = 399,
	FN_IP0_15_12___2 = 400,
	FN_AVB_LINK___2 = 401,
	FN_MSIOF2_SCK_C___2 = 402,
	FN_TX4_A___2 = 403,
	FN_IP1_15_12___2 = 404,
	FN_IRQ5___2 = 405,
	FN_QSTB_QHE___2 = 406,
	FN_DU_EXVSYNC_DU_VSYNC___2 = 407,
	FN_VI4_DATA5_B___2 = 408,
	FN_FSCLKST2_N_B = 409,
	FN_MSIOF3_TXD_E___2 = 410,
	FN_PWM6_B___2 = 411,
	FN_IP2_15_12___2 = 412,
	FN_A4___2 = 413,
	FN_LCDOUT20___2 = 414,
	FN_MSIOF3_SS1_B___2 = 415,
	FN_VI4_DATA12___2 = 416,
	FN_VI5_DATA12___2 = 417,
	FN_DU_DB4___2 = 418,
	FN_IP3_15_12___2 = 419,
	FN_A12___2 = 420,
	FN_LCDOUT12___2 = 421,
	FN_MSIOF3_SCK_C___2 = 422,
	FN_HRX4_A___2 = 423,
	FN_VI5_DATA8___2 = 424,
	FN_DU_DG4___2 = 425,
	FN_IP0_19_16___2 = 426,
	FN_AVB_AVTP_MATCH_A___2 = 427,
	FN_MSIOF2_RXD_C___2 = 428,
	FN_CTS4_N_A___2 = 429,
	FN_FSCLKST2_N_A = 430,
	FN_IP1_19_16___2 = 431,
	FN_PWM0___2 = 432,
	FN_AVB_AVTP_PPS___2 = 433,
	FN_VI4_DATA6_B___2 = 434,
	FN_IECLK_B___2 = 435,
	FN_IP2_19_16___2 = 436,
	FN_A5___2 = 437,
	FN_LCDOUT21___2 = 438,
	FN_MSIOF3_SS2_B___2 = 439,
	FN_SCK4_B___2 = 440,
	FN_VI4_DATA13___2 = 441,
	FN_VI5_DATA13___2 = 442,
	FN_DU_DB5___2 = 443,
	FN_IP3_19_16___2 = 444,
	FN_A13___2 = 445,
	FN_LCDOUT13___2 = 446,
	FN_MSIOF3_SYNC_C___2 = 447,
	FN_HTX4_A___2 = 448,
	FN_VI5_DATA9___2 = 449,
	FN_DU_DG5___2 = 450,
	FN_IP0_23_20___2 = 451,
	FN_AVB_AVTP_CAPTURE_A___2 = 452,
	FN_MSIOF2_TXD_C___2 = 453,
	FN_RTS4_N_A___2 = 454,
	FN_IP1_23_20___2 = 455,
	FN_PWM1_A___2 = 456,
	FN_HRX3_D___2 = 457,
	FN_VI4_DATA7_B___2 = 458,
	FN_IERX_B___2 = 459,
	FN_IP2_23_20___2 = 460,
	FN_A6___2 = 461,
	FN_LCDOUT22___2 = 462,
	FN_MSIOF2_SS1_A___2 = 463,
	FN_RX4_B___2 = 464,
	FN_VI4_DATA14___2 = 465,
	FN_VI5_DATA14___2 = 466,
	FN_DU_DB6___2 = 467,
	FN_IP3_23_20___2 = 468,
	FN_A14___2 = 469,
	FN_LCDOUT14___2 = 470,
	FN_MSIOF3_RXD_C___2 = 471,
	FN_HCTS4_N___2 = 472,
	FN_VI5_DATA10___2 = 473,
	FN_DU_DG6___2 = 474,
	FN_IP0_27_24___2 = 475,
	FN_IRQ0___2 = 476,
	FN_QPOLB___2 = 477,
	FN_DU_CDE___2 = 478,
	FN_VI4_DATA0_B___2 = 479,
	FN_CAN0_TX_B___2 = 480,
	FN_CANFD0_TX_B___2 = 481,
	FN_MSIOF3_SS2_E___2 = 482,
	FN_IP1_27_24___2 = 483,
	FN_PWM2_A___2 = 484,
	FN_HTX3_D___2 = 485,
	FN_IETX_B___2 = 486,
	FN_IP2_27_24___2 = 487,
	FN_A7___2 = 488,
	FN_LCDOUT23___2 = 489,
	FN_MSIOF2_SS2_A___2 = 490,
	FN_TX4_B___2 = 491,
	FN_VI4_DATA15___2 = 492,
	FN_VI5_DATA15___2 = 493,
	FN_DU_DB7___2 = 494,
	FN_IP3_27_24___2 = 495,
	FN_A15___2 = 496,
	FN_LCDOUT15___2 = 497,
	FN_MSIOF3_TXD_C___2 = 498,
	FN_HRTS4_N___2 = 499,
	FN_VI5_DATA11___2 = 500,
	FN_DU_DG7___2 = 501,
	FN_IP0_31_28___2 = 502,
	FN_IRQ1___2 = 503,
	FN_QPOLA___2 = 504,
	FN_DU_DISP___2 = 505,
	FN_VI4_DATA1_B___2 = 506,
	FN_CAN0_RX_B___2 = 507,
	FN_CANFD0_RX_B___2 = 508,
	FN_MSIOF3_SS1_E___2 = 509,
	FN_IP1_31_28___2 = 510,
	FN_A0___2 = 511,
	FN_LCDOUT16___2 = 512,
	FN_MSIOF3_SYNC_B___2 = 513,
	FN_VI4_DATA8___2 = 514,
	FN_DU_DB0___2 = 515,
	FN_PWM3_A___2 = 516,
	FN_IP2_31_28___2 = 517,
	FN_A8___2 = 518,
	FN_RX3_B___2 = 519,
	FN_MSIOF2_SYNC_A___2 = 520,
	FN_HRX4_B___2 = 521,
	FN_SDA6_A___2 = 522,
	FN_AVB_AVTP_MATCH_B___2 = 523,
	FN_PWM1_B___2 = 524,
	FN_IP3_31_28___2 = 525,
	FN_A16___2 = 526,
	FN_LCDOUT8___2 = 527,
	FN_VI4_FIELD___2 = 528,
	FN_DU_DG0___2 = 529,
	FN_IP4_3_0___2 = 530,
	FN_A17___2 = 531,
	FN_LCDOUT9___2 = 532,
	FN_VI4_VSYNC_N___2 = 533,
	FN_DU_DG1___2 = 534,
	FN_IP5_3_0___2 = 535,
	FN_WE0_N___2 = 536,
	FN_MSIOF3_TXD_D___2 = 537,
	FN_CTS3_N___2 = 538,
	FN_HCTS3_N___2 = 539,
	FN_SCL6_B___2 = 540,
	FN_CAN_CLK___2 = 541,
	FN_IECLK_A___2 = 542,
	FN_IP6_3_0___2 = 543,
	FN_D5___2 = 544,
	FN_MSIOF2_SYNC_B___2 = 545,
	FN_VI4_DATA21___2 = 546,
	FN_VI5_DATA5___2 = 547,
	FN_IP7_3_0___2 = 548,
	FN_D13___2 = 549,
	FN_LCDOUT5___2 = 550,
	FN_MSIOF2_SS2_D___2 = 551,
	FN_TX4_C___2 = 552,
	FN_VI4_DATA5_A___2 = 553,
	FN_DU_DR5___2 = 554,
	FN_IP4_7_4___2 = 555,
	FN_A18___2 = 556,
	FN_LCDOUT10___2 = 557,
	FN_VI4_HSYNC_N___2 = 558,
	FN_DU_DG2___2 = 559,
	FN_IP5_7_4___2 = 560,
	FN_WE1_N___2 = 561,
	FN_MSIOF3_SS1_D___2 = 562,
	FN_RTS3_N___2 = 563,
	FN_HRTS3_N___2 = 564,
	FN_SDA6_B___2 = 565,
	FN_CAN1_RX___2 = 566,
	FN_CANFD1_RX___2 = 567,
	FN_IERX_A___2 = 568,
	FN_IP6_7_4___2 = 569,
	FN_D6___2 = 570,
	FN_MSIOF2_RXD_B___2 = 571,
	FN_VI4_DATA22___2 = 572,
	FN_VI5_DATA6___2 = 573,
	FN_IP7_7_4___2 = 574,
	FN_D14___2 = 575,
	FN_LCDOUT6___2 = 576,
	FN_MSIOF3_SS1_A___2 = 577,
	FN_HRX3_C___2 = 578,
	FN_VI4_DATA6_A___2 = 579,
	FN_DU_DR6___2 = 580,
	FN_SCL6_C___2 = 581,
	FN_IP4_11_8___2 = 582,
	FN_A19___2 = 583,
	FN_LCDOUT11___2 = 584,
	FN_VI4_CLKENB___2 = 585,
	FN_DU_DG3___2 = 586,
	FN_IP5_11_8___2 = 587,
	FN_EX_WAIT0_A___2 = 588,
	FN_QCLK___2 = 589,
	FN_VI4_CLK___2 = 590,
	FN_DU_DOTCLKOUT0___2 = 591,
	FN_IP6_11_8___2 = 592,
	FN_D7___2 = 593,
	FN_MSIOF2_TXD_B___2 = 594,
	FN_VI4_DATA23___2 = 595,
	FN_VI5_DATA7___2 = 596,
	FN_IP7_11_8___2 = 597,
	FN_D15___2 = 598,
	FN_LCDOUT7___2 = 599,
	FN_MSIOF3_SS2_A___2 = 600,
	FN_HTX3_C___2 = 601,
	FN_VI4_DATA7_A___2 = 602,
	FN_DU_DR7___2 = 603,
	FN_SDA6_C___2 = 604,
	FN_IP4_15_12___2 = 605,
	FN_CS0_N___2 = 606,
	FN_VI5_CLKENB___2 = 607,
	FN_IP5_15_12___2 = 608,
	FN_D0___2 = 609,
	FN_MSIOF2_SS1_B___2 = 610,
	FN_MSIOF3_SCK_A___2 = 611,
	FN_VI4_DATA16___2 = 612,
	FN_VI5_DATA0___2 = 613,
	FN_IP6_15_12___2 = 614,
	FN_D8___2 = 615,
	FN_LCDOUT0___2 = 616,
	FN_MSIOF2_SCK_D___2 = 617,
	FN_SCK4_C___2 = 618,
	FN_VI4_DATA0_A___2 = 619,
	FN_DU_DR0___2 = 620,
	FN_IP4_19_16___2 = 621,
	FN_CS1_N___2 = 622,
	FN_VI5_CLK___2 = 623,
	FN_EX_WAIT0_B___2 = 624,
	FN_IP5_19_16___2 = 625,
	FN_D1___2 = 626,
	FN_MSIOF2_SS2_B___2 = 627,
	FN_MSIOF3_SYNC_A___2 = 628,
	FN_VI4_DATA17___2 = 629,
	FN_VI5_DATA1___2 = 630,
	FN_IP6_19_16___2 = 631,
	FN_D9___2 = 632,
	FN_LCDOUT1___2 = 633,
	FN_MSIOF2_SYNC_D___2 = 634,
	FN_VI4_DATA1_A___2 = 635,
	FN_DU_DR1___2 = 636,
	FN_IP7_19_16___2 = 637,
	FN_SD0_CLK___2 = 638,
	FN_MSIOF1_SCK_E___2 = 639,
	FN_STP_OPWM_0_B___2 = 640,
	FN_IP4_23_20___2 = 641,
	FN_BS_N___2 = 642,
	FN_QSTVA_QVS___2 = 643,
	FN_MSIOF3_SCK_D___2 = 644,
	FN_SCK3___2 = 645,
	FN_HSCK3___2 = 646,
	FN_CAN1_TX___2 = 647,
	FN_CANFD1_TX___2 = 648,
	FN_IETX_A___2 = 649,
	FN_IP5_23_20___2 = 650,
	FN_D2___2 = 651,
	FN_MSIOF3_RXD_A___2 = 652,
	FN_VI4_DATA18___2 = 653,
	FN_VI5_DATA2___2 = 654,
	FN_IP6_23_20___2 = 655,
	FN_D10___2 = 656,
	FN_LCDOUT2___2 = 657,
	FN_MSIOF2_RXD_D___2 = 658,
	FN_HRX3_B___2 = 659,
	FN_VI4_DATA2_A___2 = 660,
	FN_CTS4_N_C___2 = 661,
	FN_DU_DR2___2 = 662,
	FN_IP7_23_20___2 = 663,
	FN_SD0_CMD___2 = 664,
	FN_MSIOF1_SYNC_E___2 = 665,
	FN_STP_IVCXO27_0_B___2 = 666,
	FN_IP4_27_24___2 = 667,
	FN_RD_N___2 = 668,
	FN_MSIOF3_SYNC_D___2 = 669,
	FN_RX3_A___2 = 670,
	FN_HRX3_A___2 = 671,
	FN_CAN0_TX_A___2 = 672,
	FN_CANFD0_TX_A___2 = 673,
	FN_IP5_27_24___2 = 674,
	FN_D3___2 = 675,
	FN_MSIOF3_TXD_A___2 = 676,
	FN_VI4_DATA19___2 = 677,
	FN_VI5_DATA3___2 = 678,
	FN_IP6_27_24___2 = 679,
	FN_D11___2 = 680,
	FN_LCDOUT3___2 = 681,
	FN_MSIOF2_TXD_D___2 = 682,
	FN_HTX3_B___2 = 683,
	FN_VI4_DATA3_A___2 = 684,
	FN_RTS4_N_C___2 = 685,
	FN_DU_DR3___2 = 686,
	FN_IP7_27_24___2 = 687,
	FN_SD0_DAT0___2 = 688,
	FN_MSIOF1_RXD_E___2 = 689,
	FN_TS_SCK0_B___2 = 690,
	FN_STP_ISCLK_0_B___2 = 691,
	FN_IP4_31_28___2 = 692,
	FN_RD_WR_N___2 = 693,
	FN_MSIOF3_RXD_D___2 = 694,
	FN_TX3_A___2 = 695,
	FN_HTX3_A___2 = 696,
	FN_CAN0_RX_A___2 = 697,
	FN_CANFD0_RX_A___2 = 698,
	FN_IP5_31_28___2 = 699,
	FN_D4___2 = 700,
	FN_MSIOF2_SCK_B___2 = 701,
	FN_VI4_DATA20___2 = 702,
	FN_VI5_DATA4___2 = 703,
	FN_IP6_31_28___2 = 704,
	FN_D12___2 = 705,
	FN_LCDOUT4___2 = 706,
	FN_MSIOF2_SS1_D___2 = 707,
	FN_RX4_C___2 = 708,
	FN_VI4_DATA4_A___2 = 709,
	FN_DU_DR4___2 = 710,
	FN_IP7_31_28___2 = 711,
	FN_SD0_DAT1___2 = 712,
	FN_MSIOF1_TXD_E___2 = 713,
	FN_TS_SPSYNC0_B___2 = 714,
	FN_STP_ISSYNC_0_B___2 = 715,
	FN_IP8_3_0___2 = 716,
	FN_SD0_DAT2___2 = 717,
	FN_MSIOF1_SS1_E___2 = 718,
	FN_TS_SDAT0_B___2 = 719,
	FN_STP_ISD_0_B___2 = 720,
	FN_IP9_3_0___2 = 721,
	FN_SD2_CLK___2 = 722,
	FN_NFDATA8___2 = 723,
	FN_IP10_3_0___2 = 724,
	FN_SD3_CMD___2 = 725,
	FN_NFRE_N___2 = 726,
	FN_IP11_3_0___2 = 727,
	FN_SD3_DAT7___2 = 728,
	FN_SD3_WP___2 = 729,
	FN_NFDATA7___2 = 730,
	FN_IP8_7_4___2 = 731,
	FN_SD0_DAT3___2 = 732,
	FN_MSIOF1_SS2_E___2 = 733,
	FN_TS_SDEN0_B___2 = 734,
	FN_STP_ISEN_0_B___2 = 735,
	FN_IP9_7_4___2 = 736,
	FN_SD2_CMD___2 = 737,
	FN_NFDATA9___2 = 738,
	FN_IP10_7_4___2 = 739,
	FN_SD3_DAT0___2 = 740,
	FN_NFDATA0___2 = 741,
	FN_IP11_7_4___2 = 742,
	FN_SD3_DS___2 = 743,
	FN_NFCLE___2 = 744,
	FN_IP8_11_8___2 = 745,
	FN_SD1_CLK___2 = 746,
	FN_MSIOF1_SCK_G___2 = 747,
	FN_SIM0_CLK_A___2 = 748,
	FN_IP9_11_8___2 = 749,
	FN_SD2_DAT0___2 = 750,
	FN_NFDATA10___2 = 751,
	FN_IP10_11_8___2 = 752,
	FN_SD3_DAT1___2 = 753,
	FN_NFDATA1___2 = 754,
	FN_IP11_11_8___2 = 755,
	FN_SD0_CD___2 = 756,
	FN_NFDATA14_A___2 = 757,
	FN_SCL2_B___2 = 758,
	FN_SIM0_RST_A___2 = 759,
	FN_IP8_15_12___2 = 760,
	FN_SD1_CMD___2 = 761,
	FN_MSIOF1_SYNC_G___2 = 762,
	FN_NFCE_N_B___2 = 763,
	FN_SIM0_D_A___2 = 764,
	FN_STP_IVCXO27_1_B___2 = 765,
	FN_IP9_15_12___2 = 766,
	FN_SD2_DAT1___2 = 767,
	FN_NFDATA11___2 = 768,
	FN_IP10_15_12___2 = 769,
	FN_SD3_DAT2___2 = 770,
	FN_NFDATA2___2 = 771,
	FN_IP11_15_12___2 = 772,
	FN_SD0_WP___2 = 773,
	FN_NFDATA15_A___2 = 774,
	FN_SDA2_B___2 = 775,
	FN_IP8_19_16___2 = 776,
	FN_SD1_DAT0___2 = 777,
	FN_SD2_DAT4___2 = 778,
	FN_MSIOF1_RXD_G___2 = 779,
	FN_NFWP_N_B___2 = 780,
	FN_TS_SCK1_B___2 = 781,
	FN_STP_ISCLK_1_B___2 = 782,
	FN_IP9_19_16___2 = 783,
	FN_SD2_DAT2___2 = 784,
	FN_NFDATA12___2 = 785,
	FN_IP10_19_16___2 = 786,
	FN_SD3_DAT3___2 = 787,
	FN_NFDATA3___2 = 788,
	FN_IP11_19_16___2 = 789,
	FN_SD1_CD___2 = 790,
	FN_NFRB_N_A___2 = 791,
	FN_SIM0_CLK_B___2 = 792,
	FN_IP8_23_20___2 = 793,
	FN_SD1_DAT1___2 = 794,
	FN_SD2_DAT5___2 = 795,
	FN_MSIOF1_TXD_G___2 = 796,
	FN_NFDATA14_B___2 = 797,
	FN_TS_SPSYNC1_B___2 = 798,
	FN_STP_ISSYNC_1_B___2 = 799,
	FN_IP9_23_20___2 = 800,
	FN_SD2_DAT3___2 = 801,
	FN_NFDATA13___2 = 802,
	FN_IP10_23_20___2 = 803,
	FN_SD3_DAT4___2 = 804,
	FN_SD2_CD_A___2 = 805,
	FN_NFDATA4___2 = 806,
	FN_IP11_23_20___2 = 807,
	FN_SD1_WP___2 = 808,
	FN_NFCE_N_A___2 = 809,
	FN_SIM0_D_B___2 = 810,
	FN_IP8_27_24___2 = 811,
	FN_SD1_DAT2___2 = 812,
	FN_SD2_DAT6___2 = 813,
	FN_MSIOF1_SS1_G___2 = 814,
	FN_NFDATA15_B___2 = 815,
	FN_TS_SDAT1_B___2 = 816,
	FN_STP_ISD_1_B___2 = 817,
	FN_IP9_27_24___2 = 818,
	FN_SD2_DS___2 = 819,
	FN_NFALE___2 = 820,
	FN_SATA_DEVSLP_B = 821,
	FN_IP10_27_24___2 = 822,
	FN_SD3_DAT5___2 = 823,
	FN_SD2_WP_A___2 = 824,
	FN_NFDATA5___2 = 825,
	FN_IP11_27_24___2 = 826,
	FN_SCK0___2 = 827,
	FN_HSCK1_B___2 = 828,
	FN_MSIOF1_SS2_B___2 = 829,
	FN_AUDIO_CLKC_B___2 = 830,
	FN_SDA2_A___2 = 831,
	FN_SIM0_RST_B___2 = 832,
	FN_STP_OPWM_0_C___2 = 833,
	FN_RIF0_CLK_B___2 = 834,
	FN_ADICHS2___2 = 835,
	FN_SCK5_B___2 = 836,
	FN_IP8_31_28___2 = 837,
	FN_SD1_DAT3___2 = 838,
	FN_SD2_DAT7___2 = 839,
	FN_MSIOF1_SS2_G___2 = 840,
	FN_NFRB_N_B___2 = 841,
	FN_TS_SDEN1_B___2 = 842,
	FN_STP_ISEN_1_B___2 = 843,
	FN_IP9_31_28___2 = 844,
	FN_SD3_CLK___2 = 845,
	FN_NFWE_N___2 = 846,
	FN_IP10_31_28___2 = 847,
	FN_SD3_DAT6___2 = 848,
	FN_SD3_CD___2 = 849,
	FN_NFDATA6___2 = 850,
	FN_IP11_31_28___2 = 851,
	FN_RX0___2 = 852,
	FN_HRX1_B___2 = 853,
	FN_TS_SCK0_C___2 = 854,
	FN_STP_ISCLK_0_C___2 = 855,
	FN_RIF0_D0_B___2 = 856,
	FN_IP12_3_0___2 = 857,
	FN_TX0___2 = 858,
	FN_HTX1_B___2 = 859,
	FN_TS_SPSYNC0_C___2 = 860,
	FN_STP_ISSYNC_0_C___2 = 861,
	FN_RIF0_D1_B___2 = 862,
	FN_IP13_3_0___2 = 863,
	FN_TX2_A___2 = 864,
	FN_SD2_CD_B___2 = 865,
	FN_SCL1_A___2 = 866,
	FN_FMCLK_A___2 = 867,
	FN_RIF1_D1_C___2 = 868,
	FN_FSO_CFE_0_N___2 = 869,
	FN_IP14_3_0___2 = 870,
	FN_MSIOF0_SS1___2 = 871,
	FN_RX5_A___2 = 872,
	FN_NFWP_N_A___2 = 873,
	FN_AUDIO_CLKA_C___2 = 874,
	FN_SSI_SCK2_A___2 = 875,
	FN_STP_IVCXO27_0_C___2 = 876,
	FN_AUDIO_CLKOUT3_A___2 = 877,
	FN_TCLK1_B___2 = 878,
	FN_IP15_3_0___2 = 879,
	FN_SSI_SDATA1_A___2 = 880,
	FN_IP12_7_4___2 = 881,
	FN_CTS0_N___2 = 882,
	FN_HCTS1_N_B___2 = 883,
	FN_MSIOF1_SYNC_B___2 = 884,
	FN_TS_SPSYNC1_C___2 = 885,
	FN_STP_ISSYNC_1_C___2 = 886,
	FN_RIF1_SYNC_B___2 = 887,
	FN_AUDIO_CLKOUT_C___2 = 888,
	FN_ADICS_SAMP___2 = 889,
	FN_IP13_7_4___2 = 890,
	FN_RX2_A___2 = 891,
	FN_SD2_WP_B___2 = 892,
	FN_SDA1_A___2 = 893,
	FN_FMIN_A___2 = 894,
	FN_RIF1_SYNC_C___2 = 895,
	FN_FSO_CFE_1_N___2 = 896,
	FN_IP14_7_4___2 = 897,
	FN_MSIOF0_SS2___2 = 898,
	FN_TX5_A___2 = 899,
	FN_MSIOF1_SS2_D___2 = 900,
	FN_AUDIO_CLKC_A___2 = 901,
	FN_SSI_WS2_A___2 = 902,
	FN_STP_OPWM_0_D___2 = 903,
	FN_AUDIO_CLKOUT_D___2 = 904,
	FN_SPEEDIN_B___2 = 905,
	FN_IP15_7_4___2 = 906,
	FN_SSI_SDATA2_A___2 = 907,
	FN_SSI_SCK1_B___2 = 908,
	FN_IP12_11_8___2 = 909,
	FN_RTS0_N___2 = 910,
	FN_HRTS1_N_B___2 = 911,
	FN_MSIOF1_SS1_B___2 = 912,
	FN_AUDIO_CLKA_B___2 = 913,
	FN_SCL2_A___2 = 914,
	FN_STP_IVCXO27_1_C___2 = 915,
	FN_RIF0_SYNC_B___2 = 916,
	FN_ADICHS1___2 = 917,
	FN_IP13_11_8___2 = 918,
	FN_HSCK0___2 = 919,
	FN_MSIOF1_SCK_D___2 = 920,
	FN_AUDIO_CLKB_A___2 = 921,
	FN_SSI_SDATA1_B___2 = 922,
	FN_TS_SCK0_D___2 = 923,
	FN_STP_ISCLK_0_D___2 = 924,
	FN_RIF0_CLK_C___2 = 925,
	FN_RX5_B___2 = 926,
	FN_IP14_11_8___2 = 927,
	FN_MLB_CLK___2 = 928,
	FN_MSIOF1_SCK_F___2 = 929,
	FN_SCL1_B___2 = 930,
	FN_IP15_11_8___2 = 931,
	FN_SSI_SCK349___2 = 932,
	FN_MSIOF1_SS1_A___2 = 933,
	FN_STP_OPWM_0_A___2 = 934,
	FN_IP12_15_12___2 = 935,
	FN_RX1_A___2 = 936,
	FN_HRX1_A___2 = 937,
	FN_TS_SDAT0_C___2 = 938,
	FN_STP_ISD_0_C___2 = 939,
	FN_RIF1_CLK_C___2 = 940,
	FN_IP13_15_12___2 = 941,
	FN_HRX0___2 = 942,
	FN_MSIOF1_RXD_D___2 = 943,
	FN_SSI_SDATA2_B___2 = 944,
	FN_TS_SDEN0_D___2 = 945,
	FN_STP_ISEN_0_D___2 = 946,
	FN_RIF0_D0_C___2 = 947,
	FN_IP14_15_12___2 = 948,
	FN_MLB_SIG___2 = 949,
	FN_RX1_B___2 = 950,
	FN_MSIOF1_SYNC_F___2 = 951,
	FN_SDA1_B___2 = 952,
	FN_IP15_15_12___2 = 953,
	FN_SSI_WS349___2 = 954,
	FN_HCTS2_N_A___2 = 955,
	FN_MSIOF1_SS2_A___2 = 956,
	FN_STP_IVCXO27_0_A___2 = 957,
	FN_IP12_19_16___2 = 958,
	FN_TX1_A___2 = 959,
	FN_HTX1_A___2 = 960,
	FN_TS_SDEN0_C___2 = 961,
	FN_STP_ISEN_0_C___2 = 962,
	FN_RIF1_D0_C___2 = 963,
	FN_IP13_19_16___2 = 964,
	FN_HTX0___2 = 965,
	FN_MSIOF1_TXD_D___2 = 966,
	FN_SSI_SDATA9_B___2 = 967,
	FN_TS_SDAT0_D___2 = 968,
	FN_STP_ISD_0_D___2 = 969,
	FN_RIF0_D1_C___2 = 970,
	FN_IP14_19_16___2 = 971,
	FN_MLB_DAT___2 = 972,
	FN_TX1_B___2 = 973,
	FN_MSIOF1_RXD_F___2 = 974,
	FN_IP15_19_16___2 = 975,
	FN_SSI_SDATA3___2 = 976,
	FN_HRTS2_N_A___2 = 977,
	FN_MSIOF1_TXD_A___2 = 978,
	FN_TS_SCK0_A___2 = 979,
	FN_STP_ISCLK_0_A___2 = 980,
	FN_RIF0_D1_A___2 = 981,
	FN_RIF2_D0_A___2 = 982,
	FN_IP12_23_20___2 = 983,
	FN_CTS1_N___2 = 984,
	FN_HCTS1_N_A___2 = 985,
	FN_MSIOF1_RXD_B___2 = 986,
	FN_TS_SDEN1_C___2 = 987,
	FN_STP_ISEN_1_C___2 = 988,
	FN_RIF1_D0_B___2 = 989,
	FN_ADIDATA___2 = 990,
	FN_IP13_23_20___2 = 991,
	FN_HCTS0_N___2 = 992,
	FN_RX2_B___2 = 993,
	FN_MSIOF1_SYNC_D___2 = 994,
	FN_SSI_SCK9_A___2 = 995,
	FN_TS_SPSYNC0_D___2 = 996,
	FN_STP_ISSYNC_0_D___2 = 997,
	FN_RIF0_SYNC_C___2 = 998,
	FN_AUDIO_CLKOUT1_A___2 = 999,
	FN_IP14_23_20___2 = 1000,
	FN_SSI_SCK01239___2 = 1001,
	FN_MSIOF1_TXD_F___2 = 1002,
	FN_IP15_23_20___2 = 1003,
	FN_SSI_SCK4___2 = 1004,
	FN_HRX2_A___2 = 1005,
	FN_MSIOF1_SCK_A___2 = 1006,
	FN_TS_SDAT0_A___2 = 1007,
	FN_STP_ISD_0_A___2 = 1008,
	FN_RIF0_CLK_A___2 = 1009,
	FN_RIF2_CLK_A___2 = 1010,
	FN_IP12_27_24___2 = 1011,
	FN_RTS1_N___2 = 1012,
	FN_HRTS1_N_A___2 = 1013,
	FN_MSIOF1_TXD_B___2 = 1014,
	FN_TS_SDAT1_C___2 = 1015,
	FN_STP_ISD_1_C___2 = 1016,
	FN_RIF1_D1_B___2 = 1017,
	FN_ADICHS0___2 = 1018,
	FN_IP13_27_24___2 = 1019,
	FN_HRTS0_N___2 = 1020,
	FN_TX2_B___2 = 1021,
	FN_MSIOF1_SS1_D___2 = 1022,
	FN_SSI_WS9_A___2 = 1023,
	FN_STP_IVCXO27_0_D___2 = 1024,
	FN_BPFCLK_A___2 = 1025,
	FN_AUDIO_CLKOUT2_A___2 = 1026,
	FN_IP14_27_24___2 = 1027,
	FN_SSI_WS01239___2 = 1028,
	FN_MSIOF1_SS1_F___2 = 1029,
	FN_IP15_27_24___2 = 1030,
	FN_SSI_WS4___2 = 1031,
	FN_HTX2_A___2 = 1032,
	FN_MSIOF1_SYNC_A___2 = 1033,
	FN_TS_SDEN0_A___2 = 1034,
	FN_STP_ISEN_0_A___2 = 1035,
	FN_RIF0_SYNC_A___2 = 1036,
	FN_RIF2_SYNC_A___2 = 1037,
	FN_IP12_31_28___2 = 1038,
	FN_SCK2___2 = 1039,
	FN_SCIF_CLK_B___2 = 1040,
	FN_MSIOF1_SCK_B___2 = 1041,
	FN_TS_SCK1_C___2 = 1042,
	FN_STP_ISCLK_1_C___2 = 1043,
	FN_RIF1_CLK_B___2 = 1044,
	FN_ADICLK___2 = 1045,
	FN_IP13_31_28___2 = 1046,
	FN_MSIOF0_SYNC___2 = 1047,
	FN_AUDIO_CLKOUT_A___2 = 1048,
	FN_TX5_B___2 = 1049,
	FN_BPFCLK_D___2 = 1050,
	FN_IP14_31_28___2 = 1051,
	FN_SSI_SDATA0___2 = 1052,
	FN_MSIOF1_SS2_F___2 = 1053,
	FN_IP15_31_28___2 = 1054,
	FN_SSI_SDATA4___2 = 1055,
	FN_HSCK2_A___2 = 1056,
	FN_MSIOF1_RXD_A___2 = 1057,
	FN_TS_SPSYNC0_A___2 = 1058,
	FN_STP_ISSYNC_0_A___2 = 1059,
	FN_RIF0_D0_A___2 = 1060,
	FN_RIF2_D1_A___2 = 1061,
	FN_IP16_3_0___2 = 1062,
	FN_SSI_SCK6___2 = 1063,
	FN_USB2_PWEN = 1064,
	FN_SIM0_RST_D___2 = 1065,
	FN_IP17_3_0___2 = 1066,
	FN_AUDIO_CLKA_A___2 = 1067,
	FN_IP18_3_0___2 = 1068,
	FN_USB2_CH3_PWEN = 1069,
	FN_AUDIO_CLKOUT2_B___2 = 1070,
	FN_SSI_SCK9_B___2 = 1071,
	FN_TS_SDEN0_E___2 = 1072,
	FN_STP_ISEN_0_E___2 = 1073,
	FN_RIF2_D0_B___2 = 1074,
	FN_TPU0TO2___2 = 1075,
	FN_FMCLK_C___2 = 1076,
	FN_FMCLK_D___2 = 1077,
	FN_IP16_7_4___2 = 1078,
	FN_SSI_WS6___2 = 1079,
	FN_USB2_OVC = 1080,
	FN_SIM0_D_D___2 = 1081,
	FN_IP17_7_4___2 = 1082,
	FN_AUDIO_CLKB_B___2 = 1083,
	FN_SCIF_CLK_A___2 = 1084,
	FN_STP_IVCXO27_1_D___2 = 1085,
	FN_REMOCON_A___2 = 1086,
	FN_TCLK1_A___2 = 1087,
	FN_IP18_7_4___2 = 1088,
	FN_USB2_CH3_OVC = 1089,
	FN_AUDIO_CLKOUT3_B___2 = 1090,
	FN_SSI_WS9_B___2 = 1091,
	FN_TS_SPSYNC0_E___2 = 1092,
	FN_STP_ISSYNC_0_E___2 = 1093,
	FN_RIF2_D1_B___2 = 1094,
	FN_TPU0TO3___2 = 1095,
	FN_FMIN_C___2 = 1096,
	FN_FMIN_D___2 = 1097,
	FN_IP16_11_8___2 = 1098,
	FN_SSI_SDATA6___2 = 1099,
	FN_SIM0_CLK_D___2 = 1100,
	FN_SATA_DEVSLP_A = 1101,
	FN_IP17_11_8___2 = 1102,
	FN_USB0_PWEN___2 = 1103,
	FN_SIM0_RST_C___2 = 1104,
	FN_TS_SCK1_D___2 = 1105,
	FN_STP_ISCLK_1_D___2 = 1106,
	FN_BPFCLK_B___2 = 1107,
	FN_RIF3_CLK_B___2 = 1108,
	FN_HSCK2_C___2 = 1109,
	FN_IP16_15_12___2 = 1110,
	FN_SSI_SCK78___2 = 1111,
	FN_HRX2_B___2 = 1112,
	FN_MSIOF1_SCK_C___2 = 1113,
	FN_TS_SCK1_A___2 = 1114,
	FN_STP_ISCLK_1_A___2 = 1115,
	FN_RIF1_CLK_A___2 = 1116,
	FN_RIF3_CLK_A___2 = 1117,
	FN_IP17_15_12___2 = 1118,
	FN_USB0_OVC___2 = 1119,
	FN_SIM0_D_C___2 = 1120,
	FN_TS_SDAT1_D___2 = 1121,
	FN_STP_ISD_1_D___2 = 1122,
	FN_RIF3_SYNC_B___2 = 1123,
	FN_HRX2_C___2 = 1124,
	FN_IP16_19_16___2 = 1125,
	FN_SSI_WS78___2 = 1126,
	FN_HTX2_B___2 = 1127,
	FN_MSIOF1_SYNC_C___2 = 1128,
	FN_TS_SDAT1_A___2 = 1129,
	FN_STP_ISD_1_A___2 = 1130,
	FN_RIF1_SYNC_A___2 = 1131,
	FN_RIF3_SYNC_A___2 = 1132,
	FN_IP17_19_16___2 = 1133,
	FN_USB1_PWEN___2 = 1134,
	FN_SIM0_CLK_C___2 = 1135,
	FN_SSI_SCK1_A___2 = 1136,
	FN_TS_SCK0_E___2 = 1137,
	FN_STP_ISCLK_0_E___2 = 1138,
	FN_FMCLK_B___2 = 1139,
	FN_RIF2_CLK_B___2 = 1140,
	FN_SPEEDIN_A___2 = 1141,
	FN_HTX2_C___2 = 1142,
	FN_IP16_23_20___2 = 1143,
	FN_SSI_SDATA7___2 = 1144,
	FN_HCTS2_N_B___2 = 1145,
	FN_MSIOF1_RXD_C___2 = 1146,
	FN_TS_SDEN1_A___2 = 1147,
	FN_STP_ISEN_1_A___2 = 1148,
	FN_RIF1_D0_A___2 = 1149,
	FN_RIF3_D0_A___2 = 1150,
	FN_TCLK2_A___2 = 1151,
	FN_IP17_23_20___2 = 1152,
	FN_USB1_OVC___2 = 1153,
	FN_MSIOF1_SS2_C___2 = 1154,
	FN_SSI_WS1_A___2 = 1155,
	FN_TS_SDAT0_E___2 = 1156,
	FN_STP_ISD_0_E___2 = 1157,
	FN_FMIN_B___2 = 1158,
	FN_RIF2_SYNC_B___2 = 1159,
	FN_REMOCON_B___2 = 1160,
	FN_HCTS2_N_C___2 = 1161,
	FN_IP16_27_24___2 = 1162,
	FN_SSI_SDATA8___2 = 1163,
	FN_HRTS2_N_B___2 = 1164,
	FN_MSIOF1_TXD_C___2 = 1165,
	FN_TS_SPSYNC1_A___2 = 1166,
	FN_STP_ISSYNC_1_A___2 = 1167,
	FN_RIF1_D1_A___2 = 1168,
	FN_RIF3_D1_A___2 = 1169,
	FN_IP17_27_24___2 = 1170,
	FN_USB30_PWEN___2 = 1171,
	FN_AUDIO_CLKOUT_B___2 = 1172,
	FN_SSI_SCK2_B___2 = 1173,
	FN_TS_SDEN1_D___2 = 1174,
	FN_STP_ISEN_1_D___2 = 1175,
	FN_STP_OPWM_0_E___2 = 1176,
	FN_RIF3_D0_B___2 = 1177,
	FN_TCLK2_B___2 = 1178,
	FN_TPU0TO0___2 = 1179,
	FN_BPFCLK_C___2 = 1180,
	FN_HRTS2_N_C___2 = 1181,
	FN_IP16_31_28___2 = 1182,
	FN_SSI_SDATA9_A___2 = 1183,
	FN_HSCK2_B___2 = 1184,
	FN_MSIOF1_SS1_C___2 = 1185,
	FN_HSCK1_A___2 = 1186,
	FN_SSI_WS1_B___2 = 1187,
	FN_SCK1___2 = 1188,
	FN_STP_IVCXO27_1_A___2 = 1189,
	FN_SCK5_A___2 = 1190,
	FN_IP17_31_28___2 = 1191,
	FN_USB30_OVC___2 = 1192,
	FN_AUDIO_CLKOUT1_B___2 = 1193,
	FN_SSI_WS2_B___2 = 1194,
	FN_TS_SPSYNC1_D___2 = 1195,
	FN_STP_ISSYNC_1_D___2 = 1196,
	FN_STP_IVCXO27_0_E___2 = 1197,
	FN_RIF3_D1_B___2 = 1198,
	FN_FSO_TOE_N___2 = 1199,
	FN_TPU0TO1___2 = 1200,
	FN_SEL_MSIOF3_0___2 = 1201,
	FN_SEL_MSIOF3_1___2 = 1202,
	FN_SEL_MSIOF3_2___2 = 1203,
	FN_SEL_MSIOF3_3___2 = 1204,
	FN_SEL_MSIOF3_4___2 = 1205,
	FN_SEL_TSIF1_0___2 = 1206,
	FN_SEL_TSIF1_1___2 = 1207,
	FN_SEL_TSIF1_2___2 = 1208,
	FN_SEL_TSIF1_3___2 = 1209,
	FN_I2C_SEL_5_0___2 = 1210,
	FN_I2C_SEL_5_1___2 = 1211,
	FN_I2C_SEL_3_0___2 = 1212,
	FN_I2C_SEL_3_1___2 = 1213,
	FN_SEL_TSIF0_0___2 = 1214,
	FN_SEL_TSIF0_1___2 = 1215,
	FN_SEL_TSIF0_2___2 = 1216,
	FN_SEL_TSIF0_3___2 = 1217,
	FN_SEL_TSIF0_4___2 = 1218,
	FN_I2C_SEL_0_0___2 = 1219,
	FN_I2C_SEL_0_1___2 = 1220,
	FN_SEL_MSIOF2_0___2 = 1221,
	FN_SEL_MSIOF2_1___2 = 1222,
	FN_SEL_MSIOF2_2___2 = 1223,
	FN_SEL_MSIOF2_3___2 = 1224,
	FN_SEL_FM_0___2 = 1225,
	FN_SEL_FM_1___2 = 1226,
	FN_SEL_FM_2___2 = 1227,
	FN_SEL_FM_3___2 = 1228,
	FN_SEL_MSIOF1_0___2 = 1229,
	FN_SEL_MSIOF1_1___2 = 1230,
	FN_SEL_MSIOF1_2___2 = 1231,
	FN_SEL_MSIOF1_3___2 = 1232,
	FN_SEL_MSIOF1_4___2 = 1233,
	FN_SEL_MSIOF1_5___2 = 1234,
	FN_SEL_MSIOF1_6___2 = 1235,
	FN_SEL_TIMER_TMU1_0 = 1236,
	FN_SEL_TIMER_TMU1_1 = 1237,
	FN_SEL_SCIF5_0___2 = 1238,
	FN_SEL_SCIF5_1___2 = 1239,
	FN_SEL_SSP1_1_0___2 = 1240,
	FN_SEL_SSP1_1_1___2 = 1241,
	FN_SEL_SSP1_1_2___2 = 1242,
	FN_SEL_SSP1_1_3___2 = 1243,
	FN_SEL_I2C6_0___2 = 1244,
	FN_SEL_I2C6_1___2 = 1245,
	FN_SEL_I2C6_2___2 = 1246,
	FN_SEL_LBSC_0___2 = 1247,
	FN_SEL_LBSC_1___2 = 1248,
	FN_SEL_SSP1_0_0___2 = 1249,
	FN_SEL_SSP1_0_1___2 = 1250,
	FN_SEL_SSP1_0_2___2 = 1251,
	FN_SEL_SSP1_0_3___2 = 1252,
	FN_SEL_SSP1_0_4___2 = 1253,
	FN_SEL_IEBUS_0___2 = 1254,
	FN_SEL_IEBUS_1___2 = 1255,
	FN_SEL_I2C2_0___2 = 1256,
	FN_SEL_I2C2_1___2 = 1257,
	FN_SEL_SSI2_0___2 = 1258,
	FN_SEL_SSI2_1___2 = 1259,
	FN_SEL_I2C1_0___2 = 1260,
	FN_SEL_I2C1_1___2 = 1261,
	FN_SEL_SSI1_0___2 = 1262,
	FN_SEL_SSI1_1___2 = 1263,
	FN_SEL_SSI9_0___2 = 1264,
	FN_SEL_SSI9_1___2 = 1265,
	FN_SEL_HSCIF4_0___2 = 1266,
	FN_SEL_HSCIF4_1___2 = 1267,
	FN_SEL_SPEED_PULSE_0___2 = 1268,
	FN_SEL_SPEED_PULSE_1___2 = 1269,
	FN_SEL_TIMER_TMU2_0___2 = 1270,
	FN_SEL_TIMER_TMU2_1___2 = 1271,
	FN_SEL_HSCIF3_0___2 = 1272,
	FN_SEL_HSCIF3_1___2 = 1273,
	FN_SEL_HSCIF3_2___2 = 1274,
	FN_SEL_HSCIF3_3___2 = 1275,
	FN_SEL_SIMCARD_0___2 = 1276,
	FN_SEL_SIMCARD_1___2 = 1277,
	FN_SEL_SIMCARD_2___2 = 1278,
	FN_SEL_SIMCARD_3___2 = 1279,
	FN_SEL_ADGB_0___2 = 1280,
	FN_SEL_ADGB_1___2 = 1281,
	FN_SEL_ADGC_0___2 = 1282,
	FN_SEL_ADGC_1___2 = 1283,
	FN_SEL_HSCIF1_0___2 = 1284,
	FN_SEL_HSCIF1_1___2 = 1285,
	FN_SEL_SDHI2_0___2 = 1286,
	FN_SEL_SDHI2_1___2 = 1287,
	FN_SEL_SCIF4_0___2 = 1288,
	FN_SEL_SCIF4_1___2 = 1289,
	FN_SEL_SCIF4_2___2 = 1290,
	FN_SEL_HSCIF2_0___2 = 1291,
	FN_SEL_HSCIF2_1___2 = 1292,
	FN_SEL_HSCIF2_2___2 = 1293,
	FN_SEL_SCIF3_0___2 = 1294,
	FN_SEL_SCIF3_1___2 = 1295,
	FN_SEL_ETHERAVB_0___2 = 1296,
	FN_SEL_ETHERAVB_1___2 = 1297,
	FN_SEL_SCIF2_0___2 = 1298,
	FN_SEL_SCIF2_1___2 = 1299,
	FN_SEL_DRIF3_0___2 = 1300,
	FN_SEL_DRIF3_1___2 = 1301,
	FN_SEL_SCIF1_0___2 = 1302,
	FN_SEL_SCIF1_1___2 = 1303,
	FN_SEL_DRIF2_0___2 = 1304,
	FN_SEL_DRIF2_1___2 = 1305,
	FN_SEL_SCIF_0___2 = 1306,
	FN_SEL_SCIF_1___2 = 1307,
	FN_SEL_DRIF1_0___2 = 1308,
	FN_SEL_DRIF1_1___2 = 1309,
	FN_SEL_DRIF1_2___2 = 1310,
	FN_SEL_REMOCON_0___2 = 1311,
	FN_SEL_REMOCON_1___2 = 1312,
	FN_SEL_DRIF0_0___2 = 1313,
	FN_SEL_DRIF0_1___2 = 1314,
	FN_SEL_DRIF0_2___2 = 1315,
	FN_SEL_RCAN0_0___2 = 1316,
	FN_SEL_RCAN0_1___2 = 1317,
	FN_SEL_CANFD0_0___2 = 1318,
	FN_SEL_CANFD0_1___2 = 1319,
	FN_SEL_PWM6_0___2 = 1320,
	FN_SEL_PWM6_1___2 = 1321,
	FN_SEL_ADGA_0___2 = 1322,
	FN_SEL_ADGA_1___2 = 1323,
	FN_SEL_ADGA_2___2 = 1324,
	FN_SEL_ADGA_3___2 = 1325,
	FN_SEL_PWM5_0___2 = 1326,
	FN_SEL_PWM5_1___2 = 1327,
	FN_SEL_PWM4_0___2 = 1328,
	FN_SEL_PWM4_1___2 = 1329,
	FN_SEL_PWM3_0___2 = 1330,
	FN_SEL_PWM3_1___2 = 1331,
	FN_SEL_PWM2_0___2 = 1332,
	FN_SEL_PWM2_1___2 = 1333,
	FN_SEL_PWM1_0___2 = 1334,
	FN_SEL_PWM1_1___2 = 1335,
	FN_SEL_VIN4_0___2 = 1336,
	FN_SEL_VIN4_1___2 = 1337,
	PINMUX_FUNCTION_END___2 = 1338,
	PINMUX_MARK_BEGIN___2 = 1339,
	CLKOUT_MARK___2 = 1340,
	MSIOF0_RXD_MARK___2 = 1341,
	MSIOF0_TXD_MARK___2 = 1342,
	MSIOF0_SCK_MARK___2 = 1343,
	SSI_SDATA5_MARK___2 = 1344,
	SSI_WS5_MARK___2 = 1345,
	SSI_SCK5_MARK___2 = 1346,
	GP7_03_MARK___2 = 1347,
	GP7_02_MARK___2 = 1348,
	AVS2_MARK___2 = 1349,
	AVS1_MARK___2 = 1350,
	IP0_3_0_MARK___2 = 1351,
	AVB_MDC_MARK___2 = 1352,
	MSIOF2_SS2_C_MARK___2 = 1353,
	IP1_3_0_MARK___2 = 1354,
	IRQ2_MARK___2 = 1355,
	QCPV_QDE_MARK___2 = 1356,
	DU_EXODDF_DU_ODDF_DISP_CDE_MARK___2 = 1357,
	VI4_DATA2_B_MARK___2 = 1358,
	MSIOF3_SYNC_E_MARK___2 = 1359,
	PWM3_B_MARK___2 = 1360,
	IP2_3_0_MARK___2 = 1361,
	A1_MARK___2 = 1362,
	LCDOUT17_MARK___2 = 1363,
	MSIOF3_TXD_B_MARK___2 = 1364,
	VI4_DATA9_MARK___2 = 1365,
	DU_DB1_MARK___2 = 1366,
	PWM4_A_MARK___2 = 1367,
	IP3_3_0_MARK___2 = 1368,
	A9_MARK___2 = 1369,
	MSIOF2_SCK_A_MARK___2 = 1370,
	CTS4_N_B_MARK___2 = 1371,
	VI5_VSYNC_N_MARK___2 = 1372,
	IP0_7_4_MARK___2 = 1373,
	AVB_MAGIC_MARK___2 = 1374,
	MSIOF2_SS1_C_MARK___2 = 1375,
	SCK4_A_MARK___2 = 1376,
	IP1_7_4_MARK___2 = 1377,
	IRQ3_MARK___2 = 1378,
	QSTVB_QVE_MARK___2 = 1379,
	DU_DOTCLKOUT1_MARK___2 = 1380,
	VI4_DATA3_B_MARK___2 = 1381,
	MSIOF3_SCK_E_MARK___2 = 1382,
	PWM4_B_MARK___2 = 1383,
	IP2_7_4_MARK___2 = 1384,
	A2_MARK___2 = 1385,
	LCDOUT18_MARK___2 = 1386,
	MSIOF3_SCK_B_MARK___2 = 1387,
	VI4_DATA10_MARK___2 = 1388,
	DU_DB2_MARK___2 = 1389,
	PWM5_A_MARK___2 = 1390,
	IP3_7_4_MARK___2 = 1391,
	A10_MARK___2 = 1392,
	MSIOF2_RXD_A_MARK___2 = 1393,
	RTS4_N_B_MARK___2 = 1394,
	VI5_HSYNC_N_MARK___2 = 1395,
	IP0_11_8_MARK___2 = 1396,
	AVB_PHY_INT_MARK___2 = 1397,
	MSIOF2_SYNC_C_MARK___2 = 1398,
	RX4_A_MARK___2 = 1399,
	IP1_11_8_MARK___2 = 1400,
	IRQ4_MARK___2 = 1401,
	QSTH_QHS_MARK___2 = 1402,
	DU_EXHSYNC_DU_HSYNC_MARK___2 = 1403,
	VI4_DATA4_B_MARK___2 = 1404,
	MSIOF3_RXD_E_MARK___2 = 1405,
	PWM5_B_MARK___2 = 1406,
	IP2_11_8_MARK___2 = 1407,
	A3_MARK___2 = 1408,
	LCDOUT19_MARK___2 = 1409,
	MSIOF3_RXD_B_MARK___2 = 1410,
	VI4_DATA11_MARK___2 = 1411,
	DU_DB3_MARK___2 = 1412,
	PWM6_A_MARK___2 = 1413,
	IP3_11_8_MARK___2 = 1414,
	A11_MARK___2 = 1415,
	TX3_B_MARK___2 = 1416,
	MSIOF2_TXD_A_MARK___2 = 1417,
	HTX4_B_MARK___2 = 1418,
	HSCK4_MARK___2 = 1419,
	VI5_FIELD_MARK___2 = 1420,
	SCL6_A_MARK___2 = 1421,
	AVB_AVTP_CAPTURE_B_MARK___2 = 1422,
	PWM2_B_MARK___2 = 1423,
	IP0_15_12_MARK___2 = 1424,
	AVB_LINK_MARK___2 = 1425,
	MSIOF2_SCK_C_MARK___2 = 1426,
	TX4_A_MARK___2 = 1427,
	IP1_15_12_MARK___2 = 1428,
	IRQ5_MARK___2 = 1429,
	QSTB_QHE_MARK___2 = 1430,
	DU_EXVSYNC_DU_VSYNC_MARK___2 = 1431,
	VI4_DATA5_B_MARK___2 = 1432,
	FSCLKST2_N_B_MARK = 1433,
	MSIOF3_TXD_E_MARK___2 = 1434,
	PWM6_B_MARK___2 = 1435,
	IP2_15_12_MARK___2 = 1436,
	A4_MARK___2 = 1437,
	LCDOUT20_MARK___2 = 1438,
	MSIOF3_SS1_B_MARK___2 = 1439,
	VI4_DATA12_MARK___2 = 1440,
	VI5_DATA12_MARK___2 = 1441,
	DU_DB4_MARK___2 = 1442,
	IP3_15_12_MARK___2 = 1443,
	A12_MARK___2 = 1444,
	LCDOUT12_MARK___2 = 1445,
	MSIOF3_SCK_C_MARK___2 = 1446,
	HRX4_A_MARK___2 = 1447,
	VI5_DATA8_MARK___2 = 1448,
	DU_DG4_MARK___2 = 1449,
	IP0_19_16_MARK___2 = 1450,
	AVB_AVTP_MATCH_A_MARK___2 = 1451,
	MSIOF2_RXD_C_MARK___2 = 1452,
	CTS4_N_A_MARK___2 = 1453,
	FSCLKST2_N_A_MARK = 1454,
	IP1_19_16_MARK___2 = 1455,
	PWM0_MARK___2 = 1456,
	AVB_AVTP_PPS_MARK___2 = 1457,
	VI4_DATA6_B_MARK___2 = 1458,
	IECLK_B_MARK___2 = 1459,
	IP2_19_16_MARK___2 = 1460,
	A5_MARK___2 = 1461,
	LCDOUT21_MARK___2 = 1462,
	MSIOF3_SS2_B_MARK___2 = 1463,
	SCK4_B_MARK___2 = 1464,
	VI4_DATA13_MARK___2 = 1465,
	VI5_DATA13_MARK___2 = 1466,
	DU_DB5_MARK___2 = 1467,
	IP3_19_16_MARK___2 = 1468,
	A13_MARK___2 = 1469,
	LCDOUT13_MARK___2 = 1470,
	MSIOF3_SYNC_C_MARK___2 = 1471,
	HTX4_A_MARK___2 = 1472,
	VI5_DATA9_MARK___2 = 1473,
	DU_DG5_MARK___2 = 1474,
	IP0_23_20_MARK___2 = 1475,
	AVB_AVTP_CAPTURE_A_MARK___2 = 1476,
	MSIOF2_TXD_C_MARK___2 = 1477,
	RTS4_N_A_MARK___2 = 1478,
	IP1_23_20_MARK___2 = 1479,
	PWM1_A_MARK___2 = 1480,
	HRX3_D_MARK___2 = 1481,
	VI4_DATA7_B_MARK___2 = 1482,
	IERX_B_MARK___2 = 1483,
	IP2_23_20_MARK___2 = 1484,
	A6_MARK___2 = 1485,
	LCDOUT22_MARK___2 = 1486,
	MSIOF2_SS1_A_MARK___2 = 1487,
	RX4_B_MARK___2 = 1488,
	VI4_DATA14_MARK___2 = 1489,
	VI5_DATA14_MARK___2 = 1490,
	DU_DB6_MARK___2 = 1491,
	IP3_23_20_MARK___2 = 1492,
	A14_MARK___2 = 1493,
	LCDOUT14_MARK___2 = 1494,
	MSIOF3_RXD_C_MARK___2 = 1495,
	HCTS4_N_MARK___2 = 1496,
	VI5_DATA10_MARK___2 = 1497,
	DU_DG6_MARK___2 = 1498,
	IP0_27_24_MARK___2 = 1499,
	IRQ0_MARK___2 = 1500,
	QPOLB_MARK___2 = 1501,
	DU_CDE_MARK___2 = 1502,
	VI4_DATA0_B_MARK___2 = 1503,
	CAN0_TX_B_MARK___2 = 1504,
	CANFD0_TX_B_MARK___2 = 1505,
	MSIOF3_SS2_E_MARK___2 = 1506,
	IP1_27_24_MARK___2 = 1507,
	PWM2_A_MARK___2 = 1508,
	HTX3_D_MARK___2 = 1509,
	IETX_B_MARK___2 = 1510,
	IP2_27_24_MARK___2 = 1511,
	A7_MARK___2 = 1512,
	LCDOUT23_MARK___2 = 1513,
	MSIOF2_SS2_A_MARK___2 = 1514,
	TX4_B_MARK___2 = 1515,
	VI4_DATA15_MARK___2 = 1516,
	VI5_DATA15_MARK___2 = 1517,
	DU_DB7_MARK___2 = 1518,
	IP3_27_24_MARK___2 = 1519,
	A15_MARK___2 = 1520,
	LCDOUT15_MARK___2 = 1521,
	MSIOF3_TXD_C_MARK___2 = 1522,
	HRTS4_N_MARK___2 = 1523,
	VI5_DATA11_MARK___2 = 1524,
	DU_DG7_MARK___2 = 1525,
	IP0_31_28_MARK___2 = 1526,
	IRQ1_MARK___2 = 1527,
	QPOLA_MARK___2 = 1528,
	DU_DISP_MARK___2 = 1529,
	VI4_DATA1_B_MARK___2 = 1530,
	CAN0_RX_B_MARK___2 = 1531,
	CANFD0_RX_B_MARK___2 = 1532,
	MSIOF3_SS1_E_MARK___2 = 1533,
	IP1_31_28_MARK___2 = 1534,
	A0_MARK___2 = 1535,
	LCDOUT16_MARK___2 = 1536,
	MSIOF3_SYNC_B_MARK___2 = 1537,
	VI4_DATA8_MARK___2 = 1538,
	DU_DB0_MARK___2 = 1539,
	PWM3_A_MARK___2 = 1540,
	IP2_31_28_MARK___2 = 1541,
	A8_MARK___2 = 1542,
	RX3_B_MARK___2 = 1543,
	MSIOF2_SYNC_A_MARK___2 = 1544,
	HRX4_B_MARK___2 = 1545,
	SDA6_A_MARK___2 = 1546,
	AVB_AVTP_MATCH_B_MARK___2 = 1547,
	PWM1_B_MARK___2 = 1548,
	IP3_31_28_MARK___2 = 1549,
	A16_MARK___2 = 1550,
	LCDOUT8_MARK___2 = 1551,
	VI4_FIELD_MARK___2 = 1552,
	DU_DG0_MARK___2 = 1553,
	IP4_3_0_MARK___2 = 1554,
	A17_MARK___2 = 1555,
	LCDOUT9_MARK___2 = 1556,
	VI4_VSYNC_N_MARK___2 = 1557,
	DU_DG1_MARK___2 = 1558,
	IP5_3_0_MARK___2 = 1559,
	WE0_N_MARK___2 = 1560,
	MSIOF3_TXD_D_MARK___2 = 1561,
	CTS3_N_MARK___2 = 1562,
	HCTS3_N_MARK___2 = 1563,
	SCL6_B_MARK___2 = 1564,
	CAN_CLK_MARK___2 = 1565,
	IECLK_A_MARK___2 = 1566,
	IP6_3_0_MARK___2 = 1567,
	D5_MARK___2 = 1568,
	MSIOF2_SYNC_B_MARK___2 = 1569,
	VI4_DATA21_MARK___2 = 1570,
	VI5_DATA5_MARK___2 = 1571,
	IP7_3_0_MARK___2 = 1572,
	D13_MARK___2 = 1573,
	LCDOUT5_MARK___2 = 1574,
	MSIOF2_SS2_D_MARK___2 = 1575,
	TX4_C_MARK___2 = 1576,
	VI4_DATA5_A_MARK___2 = 1577,
	DU_DR5_MARK___2 = 1578,
	IP4_7_4_MARK___2 = 1579,
	A18_MARK___2 = 1580,
	LCDOUT10_MARK___2 = 1581,
	VI4_HSYNC_N_MARK___2 = 1582,
	DU_DG2_MARK___2 = 1583,
	IP5_7_4_MARK___2 = 1584,
	WE1_N_MARK___2 = 1585,
	MSIOF3_SS1_D_MARK___2 = 1586,
	RTS3_N_MARK___2 = 1587,
	HRTS3_N_MARK___2 = 1588,
	SDA6_B_MARK___2 = 1589,
	CAN1_RX_MARK___2 = 1590,
	CANFD1_RX_MARK___2 = 1591,
	IERX_A_MARK___2 = 1592,
	IP6_7_4_MARK___2 = 1593,
	D6_MARK___2 = 1594,
	MSIOF2_RXD_B_MARK___2 = 1595,
	VI4_DATA22_MARK___2 = 1596,
	VI5_DATA6_MARK___2 = 1597,
	IP7_7_4_MARK___2 = 1598,
	D14_MARK___2 = 1599,
	LCDOUT6_MARK___2 = 1600,
	MSIOF3_SS1_A_MARK___2 = 1601,
	HRX3_C_MARK___2 = 1602,
	VI4_DATA6_A_MARK___2 = 1603,
	DU_DR6_MARK___2 = 1604,
	SCL6_C_MARK___2 = 1605,
	IP4_11_8_MARK___2 = 1606,
	A19_MARK___2 = 1607,
	LCDOUT11_MARK___2 = 1608,
	VI4_CLKENB_MARK___2 = 1609,
	DU_DG3_MARK___2 = 1610,
	IP5_11_8_MARK___2 = 1611,
	EX_WAIT0_A_MARK___2 = 1612,
	QCLK_MARK___2 = 1613,
	VI4_CLK_MARK___2 = 1614,
	DU_DOTCLKOUT0_MARK___2 = 1615,
	IP6_11_8_MARK___2 = 1616,
	D7_MARK___2 = 1617,
	MSIOF2_TXD_B_MARK___2 = 1618,
	VI4_DATA23_MARK___2 = 1619,
	VI5_DATA7_MARK___2 = 1620,
	IP7_11_8_MARK___2 = 1621,
	D15_MARK___2 = 1622,
	LCDOUT7_MARK___2 = 1623,
	MSIOF3_SS2_A_MARK___2 = 1624,
	HTX3_C_MARK___2 = 1625,
	VI4_DATA7_A_MARK___2 = 1626,
	DU_DR7_MARK___2 = 1627,
	SDA6_C_MARK___2 = 1628,
	IP4_15_12_MARK___2 = 1629,
	CS0_N_MARK___2 = 1630,
	VI5_CLKENB_MARK___2 = 1631,
	IP5_15_12_MARK___2 = 1632,
	D0_MARK___2 = 1633,
	MSIOF2_SS1_B_MARK___2 = 1634,
	MSIOF3_SCK_A_MARK___2 = 1635,
	VI4_DATA16_MARK___2 = 1636,
	VI5_DATA0_MARK___2 = 1637,
	IP6_15_12_MARK___2 = 1638,
	D8_MARK___2 = 1639,
	LCDOUT0_MARK___2 = 1640,
	MSIOF2_SCK_D_MARK___2 = 1641,
	SCK4_C_MARK___2 = 1642,
	VI4_DATA0_A_MARK___2 = 1643,
	DU_DR0_MARK___2 = 1644,
	IP4_19_16_MARK___2 = 1645,
	CS1_N_MARK___2 = 1646,
	VI5_CLK_MARK___2 = 1647,
	EX_WAIT0_B_MARK___2 = 1648,
	IP5_19_16_MARK___2 = 1649,
	D1_MARK___2 = 1650,
	MSIOF2_SS2_B_MARK___2 = 1651,
	MSIOF3_SYNC_A_MARK___2 = 1652,
	VI4_DATA17_MARK___2 = 1653,
	VI5_DATA1_MARK___2 = 1654,
	IP6_19_16_MARK___2 = 1655,
	D9_MARK___2 = 1656,
	LCDOUT1_MARK___2 = 1657,
	MSIOF2_SYNC_D_MARK___2 = 1658,
	VI4_DATA1_A_MARK___2 = 1659,
	DU_DR1_MARK___2 = 1660,
	IP7_19_16_MARK___2 = 1661,
	SD0_CLK_MARK___2 = 1662,
	MSIOF1_SCK_E_MARK___2 = 1663,
	STP_OPWM_0_B_MARK___2 = 1664,
	IP4_23_20_MARK___2 = 1665,
	BS_N_MARK___2 = 1666,
	QSTVA_QVS_MARK___2 = 1667,
	MSIOF3_SCK_D_MARK___2 = 1668,
	SCK3_MARK___2 = 1669,
	HSCK3_MARK___2 = 1670,
	CAN1_TX_MARK___2 = 1671,
	CANFD1_TX_MARK___2 = 1672,
	IETX_A_MARK___2 = 1673,
	IP5_23_20_MARK___2 = 1674,
	D2_MARK___2 = 1675,
	MSIOF3_RXD_A_MARK___2 = 1676,
	VI4_DATA18_MARK___2 = 1677,
	VI5_DATA2_MARK___2 = 1678,
	IP6_23_20_MARK___2 = 1679,
	D10_MARK___2 = 1680,
	LCDOUT2_MARK___2 = 1681,
	MSIOF2_RXD_D_MARK___2 = 1682,
	HRX3_B_MARK___2 = 1683,
	VI4_DATA2_A_MARK___2 = 1684,
	CTS4_N_C_MARK___2 = 1685,
	DU_DR2_MARK___2 = 1686,
	IP7_23_20_MARK___2 = 1687,
	SD0_CMD_MARK___2 = 1688,
	MSIOF1_SYNC_E_MARK___2 = 1689,
	STP_IVCXO27_0_B_MARK___2 = 1690,
	IP4_27_24_MARK___2 = 1691,
	RD_N_MARK___2 = 1692,
	MSIOF3_SYNC_D_MARK___2 = 1693,
	RX3_A_MARK___2 = 1694,
	HRX3_A_MARK___2 = 1695,
	CAN0_TX_A_MARK___2 = 1696,
	CANFD0_TX_A_MARK___2 = 1697,
	IP5_27_24_MARK___2 = 1698,
	D3_MARK___2 = 1699,
	MSIOF3_TXD_A_MARK___2 = 1700,
	VI4_DATA19_MARK___2 = 1701,
	VI5_DATA3_MARK___2 = 1702,
	IP6_27_24_MARK___2 = 1703,
	D11_MARK___2 = 1704,
	LCDOUT3_MARK___2 = 1705,
	MSIOF2_TXD_D_MARK___2 = 1706,
	HTX3_B_MARK___2 = 1707,
	VI4_DATA3_A_MARK___2 = 1708,
	RTS4_N_C_MARK___2 = 1709,
	DU_DR3_MARK___2 = 1710,
	IP7_27_24_MARK___2 = 1711,
	SD0_DAT0_MARK___2 = 1712,
	MSIOF1_RXD_E_MARK___2 = 1713,
	TS_SCK0_B_MARK___2 = 1714,
	STP_ISCLK_0_B_MARK___2 = 1715,
	IP4_31_28_MARK___2 = 1716,
	RD_WR_N_MARK___2 = 1717,
	MSIOF3_RXD_D_MARK___2 = 1718,
	TX3_A_MARK___2 = 1719,
	HTX3_A_MARK___2 = 1720,
	CAN0_RX_A_MARK___2 = 1721,
	CANFD0_RX_A_MARK___2 = 1722,
	IP5_31_28_MARK___2 = 1723,
	D4_MARK___2 = 1724,
	MSIOF2_SCK_B_MARK___2 = 1725,
	VI4_DATA20_MARK___2 = 1726,
	VI5_DATA4_MARK___2 = 1727,
	IP6_31_28_MARK___2 = 1728,
	D12_MARK___2 = 1729,
	LCDOUT4_MARK___2 = 1730,
	MSIOF2_SS1_D_MARK___2 = 1731,
	RX4_C_MARK___2 = 1732,
	VI4_DATA4_A_MARK___2 = 1733,
	DU_DR4_MARK___2 = 1734,
	IP7_31_28_MARK___2 = 1735,
	SD0_DAT1_MARK___2 = 1736,
	MSIOF1_TXD_E_MARK___2 = 1737,
	TS_SPSYNC0_B_MARK___2 = 1738,
	STP_ISSYNC_0_B_MARK___2 = 1739,
	IP8_3_0_MARK___2 = 1740,
	SD0_DAT2_MARK___2 = 1741,
	MSIOF1_SS1_E_MARK___2 = 1742,
	TS_SDAT0_B_MARK___2 = 1743,
	STP_ISD_0_B_MARK___2 = 1744,
	IP9_3_0_MARK___2 = 1745,
	SD2_CLK_MARK___2 = 1746,
	NFDATA8_MARK___2 = 1747,
	IP10_3_0_MARK___2 = 1748,
	SD3_CMD_MARK___2 = 1749,
	NFRE_N_MARK___2 = 1750,
	IP11_3_0_MARK___2 = 1751,
	SD3_DAT7_MARK___2 = 1752,
	SD3_WP_MARK___2 = 1753,
	NFDATA7_MARK___2 = 1754,
	IP8_7_4_MARK___2 = 1755,
	SD0_DAT3_MARK___2 = 1756,
	MSIOF1_SS2_E_MARK___2 = 1757,
	TS_SDEN0_B_MARK___2 = 1758,
	STP_ISEN_0_B_MARK___2 = 1759,
	IP9_7_4_MARK___2 = 1760,
	SD2_CMD_MARK___2 = 1761,
	NFDATA9_MARK___2 = 1762,
	IP10_7_4_MARK___2 = 1763,
	SD3_DAT0_MARK___2 = 1764,
	NFDATA0_MARK___2 = 1765,
	IP11_7_4_MARK___2 = 1766,
	SD3_DS_MARK___2 = 1767,
	NFCLE_MARK___2 = 1768,
	IP8_11_8_MARK___2 = 1769,
	SD1_CLK_MARK___2 = 1770,
	MSIOF1_SCK_G_MARK___2 = 1771,
	SIM0_CLK_A_MARK___2 = 1772,
	IP9_11_8_MARK___2 = 1773,
	SD2_DAT0_MARK___2 = 1774,
	NFDATA10_MARK___2 = 1775,
	IP10_11_8_MARK___2 = 1776,
	SD3_DAT1_MARK___2 = 1777,
	NFDATA1_MARK___2 = 1778,
	IP11_11_8_MARK___2 = 1779,
	SD0_CD_MARK___2 = 1780,
	NFDATA14_A_MARK___2 = 1781,
	SCL2_B_MARK___2 = 1782,
	SIM0_RST_A_MARK___2 = 1783,
	IP8_15_12_MARK___2 = 1784,
	SD1_CMD_MARK___2 = 1785,
	MSIOF1_SYNC_G_MARK___2 = 1786,
	NFCE_N_B_MARK___2 = 1787,
	SIM0_D_A_MARK___2 = 1788,
	STP_IVCXO27_1_B_MARK___2 = 1789,
	IP9_15_12_MARK___2 = 1790,
	SD2_DAT1_MARK___2 = 1791,
	NFDATA11_MARK___2 = 1792,
	IP10_15_12_MARK___2 = 1793,
	SD3_DAT2_MARK___2 = 1794,
	NFDATA2_MARK___2 = 1795,
	IP11_15_12_MARK___2 = 1796,
	SD0_WP_MARK___2 = 1797,
	NFDATA15_A_MARK___2 = 1798,
	SDA2_B_MARK___2 = 1799,
	IP8_19_16_MARK___2 = 1800,
	SD1_DAT0_MARK___2 = 1801,
	SD2_DAT4_MARK___2 = 1802,
	MSIOF1_RXD_G_MARK___2 = 1803,
	NFWP_N_B_MARK___2 = 1804,
	TS_SCK1_B_MARK___2 = 1805,
	STP_ISCLK_1_B_MARK___2 = 1806,
	IP9_19_16_MARK___2 = 1807,
	SD2_DAT2_MARK___2 = 1808,
	NFDATA12_MARK___2 = 1809,
	IP10_19_16_MARK___2 = 1810,
	SD3_DAT3_MARK___2 = 1811,
	NFDATA3_MARK___2 = 1812,
	IP11_19_16_MARK___2 = 1813,
	SD1_CD_MARK___2 = 1814,
	NFRB_N_A_MARK___2 = 1815,
	SIM0_CLK_B_MARK___2 = 1816,
	IP8_23_20_MARK___2 = 1817,
	SD1_DAT1_MARK___2 = 1818,
	SD2_DAT5_MARK___2 = 1819,
	MSIOF1_TXD_G_MARK___2 = 1820,
	NFDATA14_B_MARK___2 = 1821,
	TS_SPSYNC1_B_MARK___2 = 1822,
	STP_ISSYNC_1_B_MARK___2 = 1823,
	IP9_23_20_MARK___2 = 1824,
	SD2_DAT3_MARK___2 = 1825,
	NFDATA13_MARK___2 = 1826,
	IP10_23_20_MARK___2 = 1827,
	SD3_DAT4_MARK___2 = 1828,
	SD2_CD_A_MARK___2 = 1829,
	NFDATA4_MARK___2 = 1830,
	IP11_23_20_MARK___2 = 1831,
	SD1_WP_MARK___2 = 1832,
	NFCE_N_A_MARK___2 = 1833,
	SIM0_D_B_MARK___2 = 1834,
	IP8_27_24_MARK___2 = 1835,
	SD1_DAT2_MARK___2 = 1836,
	SD2_DAT6_MARK___2 = 1837,
	MSIOF1_SS1_G_MARK___2 = 1838,
	NFDATA15_B_MARK___2 = 1839,
	TS_SDAT1_B_MARK___2 = 1840,
	STP_ISD_1_B_MARK___2 = 1841,
	IP9_27_24_MARK___2 = 1842,
	SD2_DS_MARK___2 = 1843,
	NFALE_MARK___2 = 1844,
	SATA_DEVSLP_B_MARK = 1845,
	IP10_27_24_MARK___2 = 1846,
	SD3_DAT5_MARK___2 = 1847,
	SD2_WP_A_MARK___2 = 1848,
	NFDATA5_MARK___2 = 1849,
	IP11_27_24_MARK___2 = 1850,
	SCK0_MARK___2 = 1851,
	HSCK1_B_MARK___2 = 1852,
	MSIOF1_SS2_B_MARK___2 = 1853,
	AUDIO_CLKC_B_MARK___2 = 1854,
	SDA2_A_MARK___2 = 1855,
	SIM0_RST_B_MARK___2 = 1856,
	STP_OPWM_0_C_MARK___2 = 1857,
	RIF0_CLK_B_MARK___2 = 1858,
	ADICHS2_MARK___2 = 1859,
	SCK5_B_MARK___2 = 1860,
	IP8_31_28_MARK___2 = 1861,
	SD1_DAT3_MARK___2 = 1862,
	SD2_DAT7_MARK___2 = 1863,
	MSIOF1_SS2_G_MARK___2 = 1864,
	NFRB_N_B_MARK___2 = 1865,
	TS_SDEN1_B_MARK___2 = 1866,
	STP_ISEN_1_B_MARK___2 = 1867,
	IP9_31_28_MARK___2 = 1868,
	SD3_CLK_MARK___2 = 1869,
	NFWE_N_MARK___2 = 1870,
	IP10_31_28_MARK___2 = 1871,
	SD3_DAT6_MARK___2 = 1872,
	SD3_CD_MARK___2 = 1873,
	NFDATA6_MARK___2 = 1874,
	IP11_31_28_MARK___2 = 1875,
	RX0_MARK___2 = 1876,
	HRX1_B_MARK___2 = 1877,
	TS_SCK0_C_MARK___2 = 1878,
	STP_ISCLK_0_C_MARK___2 = 1879,
	RIF0_D0_B_MARK___2 = 1880,
	IP12_3_0_MARK___2 = 1881,
	TX0_MARK___2 = 1882,
	HTX1_B_MARK___2 = 1883,
	TS_SPSYNC0_C_MARK___2 = 1884,
	STP_ISSYNC_0_C_MARK___2 = 1885,
	RIF0_D1_B_MARK___2 = 1886,
	IP13_3_0_MARK___2 = 1887,
	TX2_A_MARK___2 = 1888,
	SD2_CD_B_MARK___2 = 1889,
	SCL1_A_MARK___2 = 1890,
	FMCLK_A_MARK___2 = 1891,
	RIF1_D1_C_MARK___2 = 1892,
	FSO_CFE_0_N_MARK___2 = 1893,
	IP14_3_0_MARK___2 = 1894,
	MSIOF0_SS1_MARK___2 = 1895,
	RX5_A_MARK___2 = 1896,
	NFWP_N_A_MARK___2 = 1897,
	AUDIO_CLKA_C_MARK___2 = 1898,
	SSI_SCK2_A_MARK___2 = 1899,
	STP_IVCXO27_0_C_MARK___2 = 1900,
	AUDIO_CLKOUT3_A_MARK___2 = 1901,
	TCLK1_B_MARK___2 = 1902,
	IP15_3_0_MARK___2 = 1903,
	SSI_SDATA1_A_MARK___2 = 1904,
	IP12_7_4_MARK___2 = 1905,
	CTS0_N_MARK___2 = 1906,
	HCTS1_N_B_MARK___2 = 1907,
	MSIOF1_SYNC_B_MARK___2 = 1908,
	TS_SPSYNC1_C_MARK___2 = 1909,
	STP_ISSYNC_1_C_MARK___2 = 1910,
	RIF1_SYNC_B_MARK___2 = 1911,
	AUDIO_CLKOUT_C_MARK___2 = 1912,
	ADICS_SAMP_MARK___2 = 1913,
	IP13_7_4_MARK___2 = 1914,
	RX2_A_MARK___2 = 1915,
	SD2_WP_B_MARK___2 = 1916,
	SDA1_A_MARK___2 = 1917,
	FMIN_A_MARK___2 = 1918,
	RIF1_SYNC_C_MARK___2 = 1919,
	FSO_CFE_1_N_MARK___2 = 1920,
	IP14_7_4_MARK___2 = 1921,
	MSIOF0_SS2_MARK___2 = 1922,
	TX5_A_MARK___2 = 1923,
	MSIOF1_SS2_D_MARK___2 = 1924,
	AUDIO_CLKC_A_MARK___2 = 1925,
	SSI_WS2_A_MARK___2 = 1926,
	STP_OPWM_0_D_MARK___2 = 1927,
	AUDIO_CLKOUT_D_MARK___2 = 1928,
	SPEEDIN_B_MARK___2 = 1929,
	IP15_7_4_MARK___2 = 1930,
	SSI_SDATA2_A_MARK___2 = 1931,
	SSI_SCK1_B_MARK___2 = 1932,
	IP12_11_8_MARK___2 = 1933,
	RTS0_N_MARK___2 = 1934,
	HRTS1_N_B_MARK___2 = 1935,
	MSIOF1_SS1_B_MARK___2 = 1936,
	AUDIO_CLKA_B_MARK___2 = 1937,
	SCL2_A_MARK___2 = 1938,
	STP_IVCXO27_1_C_MARK___2 = 1939,
	RIF0_SYNC_B_MARK___2 = 1940,
	ADICHS1_MARK___2 = 1941,
	IP13_11_8_MARK___2 = 1942,
	HSCK0_MARK___2 = 1943,
	MSIOF1_SCK_D_MARK___2 = 1944,
	AUDIO_CLKB_A_MARK___2 = 1945,
	SSI_SDATA1_B_MARK___2 = 1946,
	TS_SCK0_D_MARK___2 = 1947,
	STP_ISCLK_0_D_MARK___2 = 1948,
	RIF0_CLK_C_MARK___2 = 1949,
	RX5_B_MARK___2 = 1950,
	IP14_11_8_MARK___2 = 1951,
	MLB_CLK_MARK___2 = 1952,
	MSIOF1_SCK_F_MARK___2 = 1953,
	SCL1_B_MARK___2 = 1954,
	IP15_11_8_MARK___2 = 1955,
	SSI_SCK349_MARK___2 = 1956,
	MSIOF1_SS1_A_MARK___2 = 1957,
	STP_OPWM_0_A_MARK___2 = 1958,
	IP12_15_12_MARK___2 = 1959,
	RX1_A_MARK___2 = 1960,
	HRX1_A_MARK___2 = 1961,
	TS_SDAT0_C_MARK___2 = 1962,
	STP_ISD_0_C_MARK___2 = 1963,
	RIF1_CLK_C_MARK___2 = 1964,
	IP13_15_12_MARK___2 = 1965,
	HRX0_MARK___2 = 1966,
	MSIOF1_RXD_D_MARK___2 = 1967,
	SSI_SDATA2_B_MARK___2 = 1968,
	TS_SDEN0_D_MARK___2 = 1969,
	STP_ISEN_0_D_MARK___2 = 1970,
	RIF0_D0_C_MARK___2 = 1971,
	IP14_15_12_MARK___2 = 1972,
	MLB_SIG_MARK___2 = 1973,
	RX1_B_MARK___2 = 1974,
	MSIOF1_SYNC_F_MARK___2 = 1975,
	SDA1_B_MARK___2 = 1976,
	IP15_15_12_MARK___2 = 1977,
	SSI_WS349_MARK___2 = 1978,
	HCTS2_N_A_MARK___2 = 1979,
	MSIOF1_SS2_A_MARK___2 = 1980,
	STP_IVCXO27_0_A_MARK___2 = 1981,
	IP12_19_16_MARK___2 = 1982,
	TX1_A_MARK___2 = 1983,
	HTX1_A_MARK___2 = 1984,
	TS_SDEN0_C_MARK___2 = 1985,
	STP_ISEN_0_C_MARK___2 = 1986,
	RIF1_D0_C_MARK___2 = 1987,
	IP13_19_16_MARK___2 = 1988,
	HTX0_MARK___2 = 1989,
	MSIOF1_TXD_D_MARK___2 = 1990,
	SSI_SDATA9_B_MARK___2 = 1991,
	TS_SDAT0_D_MARK___2 = 1992,
	STP_ISD_0_D_MARK___2 = 1993,
	RIF0_D1_C_MARK___2 = 1994,
	IP14_19_16_MARK___2 = 1995,
	MLB_DAT_MARK___2 = 1996,
	TX1_B_MARK___2 = 1997,
	MSIOF1_RXD_F_MARK___2 = 1998,
	IP15_19_16_MARK___2 = 1999,
	SSI_SDATA3_MARK___2 = 2000,
	HRTS2_N_A_MARK___2 = 2001,
	MSIOF1_TXD_A_MARK___2 = 2002,
	TS_SCK0_A_MARK___2 = 2003,
	STP_ISCLK_0_A_MARK___2 = 2004,
	RIF0_D1_A_MARK___2 = 2005,
	RIF2_D0_A_MARK___2 = 2006,
	IP12_23_20_MARK___2 = 2007,
	CTS1_N_MARK___2 = 2008,
	HCTS1_N_A_MARK___2 = 2009,
	MSIOF1_RXD_B_MARK___2 = 2010,
	TS_SDEN1_C_MARK___2 = 2011,
	STP_ISEN_1_C_MARK___2 = 2012,
	RIF1_D0_B_MARK___2 = 2013,
	ADIDATA_MARK___2 = 2014,
	IP13_23_20_MARK___2 = 2015,
	HCTS0_N_MARK___2 = 2016,
	RX2_B_MARK___2 = 2017,
	MSIOF1_SYNC_D_MARK___2 = 2018,
	SSI_SCK9_A_MARK___2 = 2019,
	TS_SPSYNC0_D_MARK___2 = 2020,
	STP_ISSYNC_0_D_MARK___2 = 2021,
	RIF0_SYNC_C_MARK___2 = 2022,
	AUDIO_CLKOUT1_A_MARK___2 = 2023,
	IP14_23_20_MARK___2 = 2024,
	SSI_SCK01239_MARK___2 = 2025,
	MSIOF1_TXD_F_MARK___2 = 2026,
	IP15_23_20_MARK___2 = 2027,
	SSI_SCK4_MARK___2 = 2028,
	HRX2_A_MARK___2 = 2029,
	MSIOF1_SCK_A_MARK___2 = 2030,
	TS_SDAT0_A_MARK___2 = 2031,
	STP_ISD_0_A_MARK___2 = 2032,
	RIF0_CLK_A_MARK___2 = 2033,
	RIF2_CLK_A_MARK___2 = 2034,
	IP12_27_24_MARK___2 = 2035,
	RTS1_N_MARK___2 = 2036,
	HRTS1_N_A_MARK___2 = 2037,
	MSIOF1_TXD_B_MARK___2 = 2038,
	TS_SDAT1_C_MARK___2 = 2039,
	STP_ISD_1_C_MARK___2 = 2040,
	RIF1_D1_B_MARK___2 = 2041,
	ADICHS0_MARK___2 = 2042,
	IP13_27_24_MARK___2 = 2043,
	HRTS0_N_MARK___2 = 2044,
	TX2_B_MARK___2 = 2045,
	MSIOF1_SS1_D_MARK___2 = 2046,
	SSI_WS9_A_MARK___2 = 2047,
	STP_IVCXO27_0_D_MARK___2 = 2048,
	BPFCLK_A_MARK___2 = 2049,
	AUDIO_CLKOUT2_A_MARK___2 = 2050,
	IP14_27_24_MARK___2 = 2051,
	SSI_WS01239_MARK___2 = 2052,
	MSIOF1_SS1_F_MARK___2 = 2053,
	IP15_27_24_MARK___2 = 2054,
	SSI_WS4_MARK___2 = 2055,
	HTX2_A_MARK___2 = 2056,
	MSIOF1_SYNC_A_MARK___2 = 2057,
	TS_SDEN0_A_MARK___2 = 2058,
	STP_ISEN_0_A_MARK___2 = 2059,
	RIF0_SYNC_A_MARK___2 = 2060,
	RIF2_SYNC_A_MARK___2 = 2061,
	IP12_31_28_MARK___2 = 2062,
	SCK2_MARK___2 = 2063,
	SCIF_CLK_B_MARK___2 = 2064,
	MSIOF1_SCK_B_MARK___2 = 2065,
	TS_SCK1_C_MARK___2 = 2066,
	STP_ISCLK_1_C_MARK___2 = 2067,
	RIF1_CLK_B_MARK___2 = 2068,
	ADICLK_MARK___2 = 2069,
	IP13_31_28_MARK___2 = 2070,
	MSIOF0_SYNC_MARK___2 = 2071,
	AUDIO_CLKOUT_A_MARK___2 = 2072,
	TX5_B_MARK___2 = 2073,
	BPFCLK_D_MARK___2 = 2074,
	IP14_31_28_MARK___2 = 2075,
	SSI_SDATA0_MARK___2 = 2076,
	MSIOF1_SS2_F_MARK___2 = 2077,
	IP15_31_28_MARK___2 = 2078,
	SSI_SDATA4_MARK___2 = 2079,
	HSCK2_A_MARK___2 = 2080,
	MSIOF1_RXD_A_MARK___2 = 2081,
	TS_SPSYNC0_A_MARK___2 = 2082,
	STP_ISSYNC_0_A_MARK___2 = 2083,
	RIF0_D0_A_MARK___2 = 2084,
	RIF2_D1_A_MARK___2 = 2085,
	IP16_3_0_MARK___2 = 2086,
	SSI_SCK6_MARK___2 = 2087,
	USB2_PWEN_MARK = 2088,
	SIM0_RST_D_MARK___2 = 2089,
	IP17_3_0_MARK___2 = 2090,
	AUDIO_CLKA_A_MARK___2 = 2091,
	IP18_3_0_MARK___2 = 2092,
	USB2_CH3_PWEN_MARK = 2093,
	AUDIO_CLKOUT2_B_MARK___2 = 2094,
	SSI_SCK9_B_MARK___2 = 2095,
	TS_SDEN0_E_MARK___2 = 2096,
	STP_ISEN_0_E_MARK___2 = 2097,
	RIF2_D0_B_MARK___2 = 2098,
	TPU0TO2_MARK___2 = 2099,
	FMCLK_C_MARK___2 = 2100,
	FMCLK_D_MARK___2 = 2101,
	IP16_7_4_MARK___2 = 2102,
	SSI_WS6_MARK___2 = 2103,
	USB2_OVC_MARK = 2104,
	SIM0_D_D_MARK___2 = 2105,
	IP17_7_4_MARK___2 = 2106,
	AUDIO_CLKB_B_MARK___2 = 2107,
	SCIF_CLK_A_MARK___2 = 2108,
	STP_IVCXO27_1_D_MARK___2 = 2109,
	REMOCON_A_MARK___2 = 2110,
	TCLK1_A_MARK___2 = 2111,
	IP18_7_4_MARK___2 = 2112,
	USB2_CH3_OVC_MARK = 2113,
	AUDIO_CLKOUT3_B_MARK___2 = 2114,
	SSI_WS9_B_MARK___2 = 2115,
	TS_SPSYNC0_E_MARK___2 = 2116,
	STP_ISSYNC_0_E_MARK___2 = 2117,
	RIF2_D1_B_MARK___2 = 2118,
	TPU0TO3_MARK___2 = 2119,
	FMIN_C_MARK___2 = 2120,
	FMIN_D_MARK___2 = 2121,
	IP16_11_8_MARK___2 = 2122,
	SSI_SDATA6_MARK___2 = 2123,
	SIM0_CLK_D_MARK___2 = 2124,
	SATA_DEVSLP_A_MARK = 2125,
	IP17_11_8_MARK___2 = 2126,
	USB0_PWEN_MARK___2 = 2127,
	SIM0_RST_C_MARK___2 = 2128,
	TS_SCK1_D_MARK___2 = 2129,
	STP_ISCLK_1_D_MARK___2 = 2130,
	BPFCLK_B_MARK___2 = 2131,
	RIF3_CLK_B_MARK___2 = 2132,
	HSCK2_C_MARK___2 = 2133,
	IP16_15_12_MARK___2 = 2134,
	SSI_SCK78_MARK___2 = 2135,
	HRX2_B_MARK___2 = 2136,
	MSIOF1_SCK_C_MARK___2 = 2137,
	TS_SCK1_A_MARK___2 = 2138,
	STP_ISCLK_1_A_MARK___2 = 2139,
	RIF1_CLK_A_MARK___2 = 2140,
	RIF3_CLK_A_MARK___2 = 2141,
	IP17_15_12_MARK___2 = 2142,
	USB0_OVC_MARK___2 = 2143,
	SIM0_D_C_MARK___2 = 2144,
	TS_SDAT1_D_MARK___2 = 2145,
	STP_ISD_1_D_MARK___2 = 2146,
	RIF3_SYNC_B_MARK___2 = 2147,
	HRX2_C_MARK___2 = 2148,
	IP16_19_16_MARK___2 = 2149,
	SSI_WS78_MARK___2 = 2150,
	HTX2_B_MARK___2 = 2151,
	MSIOF1_SYNC_C_MARK___2 = 2152,
	TS_SDAT1_A_MARK___2 = 2153,
	STP_ISD_1_A_MARK___2 = 2154,
	RIF1_SYNC_A_MARK___2 = 2155,
	RIF3_SYNC_A_MARK___2 = 2156,
	IP17_19_16_MARK___2 = 2157,
	USB1_PWEN_MARK___2 = 2158,
	SIM0_CLK_C_MARK___2 = 2159,
	SSI_SCK1_A_MARK___2 = 2160,
	TS_SCK0_E_MARK___2 = 2161,
	STP_ISCLK_0_E_MARK___2 = 2162,
	FMCLK_B_MARK___2 = 2163,
	RIF2_CLK_B_MARK___2 = 2164,
	SPEEDIN_A_MARK___2 = 2165,
	HTX2_C_MARK___2 = 2166,
	IP16_23_20_MARK___2 = 2167,
	SSI_SDATA7_MARK___2 = 2168,
	HCTS2_N_B_MARK___2 = 2169,
	MSIOF1_RXD_C_MARK___2 = 2170,
	TS_SDEN1_A_MARK___2 = 2171,
	STP_ISEN_1_A_MARK___2 = 2172,
	RIF1_D0_A_MARK___2 = 2173,
	RIF3_D0_A_MARK___2 = 2174,
	TCLK2_A_MARK___2 = 2175,
	IP17_23_20_MARK___2 = 2176,
	USB1_OVC_MARK___2 = 2177,
	MSIOF1_SS2_C_MARK___2 = 2178,
	SSI_WS1_A_MARK___2 = 2179,
	TS_SDAT0_E_MARK___2 = 2180,
	STP_ISD_0_E_MARK___2 = 2181,
	FMIN_B_MARK___2 = 2182,
	RIF2_SYNC_B_MARK___2 = 2183,
	REMOCON_B_MARK___2 = 2184,
	HCTS2_N_C_MARK___2 = 2185,
	IP16_27_24_MARK___2 = 2186,
	SSI_SDATA8_MARK___2 = 2187,
	HRTS2_N_B_MARK___2 = 2188,
	MSIOF1_TXD_C_MARK___2 = 2189,
	TS_SPSYNC1_A_MARK___2 = 2190,
	STP_ISSYNC_1_A_MARK___2 = 2191,
	RIF1_D1_A_MARK___2 = 2192,
	RIF3_D1_A_MARK___2 = 2193,
	IP17_27_24_MARK___2 = 2194,
	USB30_PWEN_MARK___2 = 2195,
	AUDIO_CLKOUT_B_MARK___2 = 2196,
	SSI_SCK2_B_MARK___2 = 2197,
	TS_SDEN1_D_MARK___2 = 2198,
	STP_ISEN_1_D_MARK___2 = 2199,
	STP_OPWM_0_E_MARK___2 = 2200,
	RIF3_D0_B_MARK___2 = 2201,
	TCLK2_B_MARK___2 = 2202,
	TPU0TO0_MARK___2 = 2203,
	BPFCLK_C_MARK___2 = 2204,
	HRTS2_N_C_MARK___2 = 2205,
	IP16_31_28_MARK___2 = 2206,
	SSI_SDATA9_A_MARK___2 = 2207,
	HSCK2_B_MARK___2 = 2208,
	MSIOF1_SS1_C_MARK___2 = 2209,
	HSCK1_A_MARK___2 = 2210,
	SSI_WS1_B_MARK___2 = 2211,
	SCK1_MARK___2 = 2212,
	STP_IVCXO27_1_A_MARK___2 = 2213,
	SCK5_A_MARK___2 = 2214,
	IP17_31_28_MARK___2 = 2215,
	USB30_OVC_MARK___2 = 2216,
	AUDIO_CLKOUT1_B_MARK___2 = 2217,
	SSI_WS2_B_MARK___2 = 2218,
	TS_SPSYNC1_D_MARK___2 = 2219,
	STP_ISSYNC_1_D_MARK___2 = 2220,
	STP_IVCXO27_0_E_MARK___2 = 2221,
	RIF3_D1_B_MARK___2 = 2222,
	FSO_TOE_N_MARK___2 = 2223,
	TPU0TO1_MARK___2 = 2224,
	SEL_MSIOF3_0_MARK___2 = 2225,
	SEL_MSIOF3_1_MARK___2 = 2226,
	SEL_MSIOF3_2_MARK___2 = 2227,
	SEL_MSIOF3_3_MARK___2 = 2228,
	SEL_MSIOF3_4_MARK___2 = 2229,
	SEL_TSIF1_0_MARK___2 = 2230,
	SEL_TSIF1_1_MARK___2 = 2231,
	SEL_TSIF1_2_MARK___2 = 2232,
	SEL_TSIF1_3_MARK___2 = 2233,
	I2C_SEL_5_0_MARK___2 = 2234,
	I2C_SEL_5_1_MARK___2 = 2235,
	I2C_SEL_3_0_MARK___2 = 2236,
	I2C_SEL_3_1_MARK___2 = 2237,
	SEL_TSIF0_0_MARK___2 = 2238,
	SEL_TSIF0_1_MARK___2 = 2239,
	SEL_TSIF0_2_MARK___2 = 2240,
	SEL_TSIF0_3_MARK___2 = 2241,
	SEL_TSIF0_4_MARK___2 = 2242,
	I2C_SEL_0_0_MARK___2 = 2243,
	I2C_SEL_0_1_MARK___2 = 2244,
	SEL_MSIOF2_0_MARK___2 = 2245,
	SEL_MSIOF2_1_MARK___2 = 2246,
	SEL_MSIOF2_2_MARK___2 = 2247,
	SEL_MSIOF2_3_MARK___2 = 2248,
	SEL_FM_0_MARK___2 = 2249,
	SEL_FM_1_MARK___2 = 2250,
	SEL_FM_2_MARK___2 = 2251,
	SEL_FM_3_MARK___2 = 2252,
	SEL_MSIOF1_0_MARK___2 = 2253,
	SEL_MSIOF1_1_MARK___2 = 2254,
	SEL_MSIOF1_2_MARK___2 = 2255,
	SEL_MSIOF1_3_MARK___2 = 2256,
	SEL_MSIOF1_4_MARK___2 = 2257,
	SEL_MSIOF1_5_MARK___2 = 2258,
	SEL_MSIOF1_6_MARK___2 = 2259,
	SEL_TIMER_TMU1_0_MARK = 2260,
	SEL_TIMER_TMU1_1_MARK = 2261,
	SEL_SCIF5_0_MARK___2 = 2262,
	SEL_SCIF5_1_MARK___2 = 2263,
	SEL_SSP1_1_0_MARK___2 = 2264,
	SEL_SSP1_1_1_MARK___2 = 2265,
	SEL_SSP1_1_2_MARK___2 = 2266,
	SEL_SSP1_1_3_MARK___2 = 2267,
	SEL_I2C6_0_MARK___2 = 2268,
	SEL_I2C6_1_MARK___2 = 2269,
	SEL_I2C6_2_MARK___2 = 2270,
	SEL_LBSC_0_MARK___2 = 2271,
	SEL_LBSC_1_MARK___2 = 2272,
	SEL_SSP1_0_0_MARK___2 = 2273,
	SEL_SSP1_0_1_MARK___2 = 2274,
	SEL_SSP1_0_2_MARK___2 = 2275,
	SEL_SSP1_0_3_MARK___2 = 2276,
	SEL_SSP1_0_4_MARK___2 = 2277,
	SEL_IEBUS_0_MARK___2 = 2278,
	SEL_IEBUS_1_MARK___2 = 2279,
	SEL_I2C2_0_MARK___2 = 2280,
	SEL_I2C2_1_MARK___2 = 2281,
	SEL_SSI2_0_MARK___2 = 2282,
	SEL_SSI2_1_MARK___2 = 2283,
	SEL_I2C1_0_MARK___2 = 2284,
	SEL_I2C1_1_MARK___2 = 2285,
	SEL_SSI1_0_MARK___2 = 2286,
	SEL_SSI1_1_MARK___2 = 2287,
	SEL_SSI9_0_MARK___2 = 2288,
	SEL_SSI9_1_MARK___2 = 2289,
	SEL_HSCIF4_0_MARK___2 = 2290,
	SEL_HSCIF4_1_MARK___2 = 2291,
	SEL_SPEED_PULSE_0_MARK___2 = 2292,
	SEL_SPEED_PULSE_1_MARK___2 = 2293,
	SEL_TIMER_TMU2_0_MARK___2 = 2294,
	SEL_TIMER_TMU2_1_MARK___2 = 2295,
	SEL_HSCIF3_0_MARK___2 = 2296,
	SEL_HSCIF3_1_MARK___2 = 2297,
	SEL_HSCIF3_2_MARK___2 = 2298,
	SEL_HSCIF3_3_MARK___2 = 2299,
	SEL_SIMCARD_0_MARK___2 = 2300,
	SEL_SIMCARD_1_MARK___2 = 2301,
	SEL_SIMCARD_2_MARK___2 = 2302,
	SEL_SIMCARD_3_MARK___2 = 2303,
	SEL_ADGB_0_MARK___2 = 2304,
	SEL_ADGB_1_MARK___2 = 2305,
	SEL_ADGC_0_MARK___2 = 2306,
	SEL_ADGC_1_MARK___2 = 2307,
	SEL_HSCIF1_0_MARK___2 = 2308,
	SEL_HSCIF1_1_MARK___2 = 2309,
	SEL_SDHI2_0_MARK___2 = 2310,
	SEL_SDHI2_1_MARK___2 = 2311,
	SEL_SCIF4_0_MARK___2 = 2312,
	SEL_SCIF4_1_MARK___2 = 2313,
	SEL_SCIF4_2_MARK___2 = 2314,
	SEL_HSCIF2_0_MARK___2 = 2315,
	SEL_HSCIF2_1_MARK___2 = 2316,
	SEL_HSCIF2_2_MARK___2 = 2317,
	SEL_SCIF3_0_MARK___2 = 2318,
	SEL_SCIF3_1_MARK___2 = 2319,
	SEL_ETHERAVB_0_MARK___2 = 2320,
	SEL_ETHERAVB_1_MARK___2 = 2321,
	SEL_SCIF2_0_MARK___2 = 2322,
	SEL_SCIF2_1_MARK___2 = 2323,
	SEL_DRIF3_0_MARK___2 = 2324,
	SEL_DRIF3_1_MARK___2 = 2325,
	SEL_SCIF1_0_MARK___2 = 2326,
	SEL_SCIF1_1_MARK___2 = 2327,
	SEL_DRIF2_0_MARK___2 = 2328,
	SEL_DRIF2_1_MARK___2 = 2329,
	SEL_SCIF_0_MARK___2 = 2330,
	SEL_SCIF_1_MARK___2 = 2331,
	SEL_DRIF1_0_MARK___2 = 2332,
	SEL_DRIF1_1_MARK___2 = 2333,
	SEL_DRIF1_2_MARK___2 = 2334,
	SEL_REMOCON_0_MARK___2 = 2335,
	SEL_REMOCON_1_MARK___2 = 2336,
	SEL_DRIF0_0_MARK___2 = 2337,
	SEL_DRIF0_1_MARK___2 = 2338,
	SEL_DRIF0_2_MARK___2 = 2339,
	SEL_RCAN0_0_MARK___2 = 2340,
	SEL_RCAN0_1_MARK___2 = 2341,
	SEL_CANFD0_0_MARK___2 = 2342,
	SEL_CANFD0_1_MARK___2 = 2343,
	SEL_PWM6_0_MARK___2 = 2344,
	SEL_PWM6_1_MARK___2 = 2345,
	SEL_ADGA_0_MARK___2 = 2346,
	SEL_ADGA_1_MARK___2 = 2347,
	SEL_ADGA_2_MARK___2 = 2348,
	SEL_ADGA_3_MARK___2 = 2349,
	SEL_PWM5_0_MARK___2 = 2350,
	SEL_PWM5_1_MARK___2 = 2351,
	SEL_PWM4_0_MARK___2 = 2352,
	SEL_PWM4_1_MARK___2 = 2353,
	SEL_PWM3_0_MARK___2 = 2354,
	SEL_PWM3_1_MARK___2 = 2355,
	SEL_PWM2_0_MARK___2 = 2356,
	SEL_PWM2_1_MARK___2 = 2357,
	SEL_PWM1_0_MARK___2 = 2358,
	SEL_PWM1_1_MARK___2 = 2359,
	SEL_VIN4_0_MARK___2 = 2360,
	SEL_VIN4_1_MARK___2 = 2361,
	QSPI0_SPCLK_MARK___2 = 2362,
	QSPI0_SSL_MARK___2 = 2363,
	QSPI0_MOSI_IO0_MARK___2 = 2364,
	QSPI0_MISO_IO1_MARK___2 = 2365,
	QSPI0_IO2_MARK___2 = 2366,
	QSPI0_IO3_MARK___2 = 2367,
	QSPI1_SPCLK_MARK___2 = 2368,
	QSPI1_SSL_MARK___2 = 2369,
	QSPI1_MOSI_IO0_MARK___2 = 2370,
	QSPI1_MISO_IO1_MARK___2 = 2371,
	QSPI1_IO2_MARK___2 = 2372,
	QSPI1_IO3_MARK___2 = 2373,
	RPC_INT_MARK___2 = 2374,
	RPC_WP_MARK___2 = 2375,
	RPC_RESET_MARK___2 = 2376,
	AVB_TX_CTL_MARK___2 = 2377,
	AVB_TXC_MARK___2 = 2378,
	AVB_TD0_MARK___2 = 2379,
	AVB_TD1_MARK___2 = 2380,
	AVB_TD2_MARK___2 = 2381,
	AVB_TD3_MARK___2 = 2382,
	AVB_RX_CTL_MARK___2 = 2383,
	AVB_RXC_MARK___2 = 2384,
	AVB_RD0_MARK___2 = 2385,
	AVB_RD1_MARK___2 = 2386,
	AVB_RD2_MARK___2 = 2387,
	AVB_RD3_MARK___2 = 2388,
	AVB_TXCREFCLK_MARK___2 = 2389,
	AVB_MDIO_MARK___2 = 2390,
	PRESETOUT_MARK___2 = 2391,
	DU_DOTCLKIN0_MARK___2 = 2392,
	DU_DOTCLKIN1_MARK___2 = 2393,
	DU_DOTCLKIN2_MARK___2 = 2394,
	DU_DOTCLKIN3_MARK = 2395,
	TMS_MARK___2 = 2396,
	TDO_MARK___2 = 2397,
	ASEBRK_MARK___2 = 2398,
	MLB_REF_MARK___2 = 2399,
	TDI_MARK___2 = 2400,
	TCK_MARK___2 = 2401,
	TRST_MARK___2 = 2402,
	EXTALR_MARK___2 = 2403,
	SCL0_MARK___2 = 2404,
	SDA0_MARK___2 = 2405,
	SCL3_MARK___2 = 2406,
	SDA3_MARK___2 = 2407,
	SCL5_MARK___2 = 2408,
	SDA5_MARK___2 = 2409,
	PINMUX_MARK_END___2 = 2410,
};

enum {
	PINMUX_RESERVED___3 = 0,
	PINMUX_DATA_BEGIN___3 = 1,
	GP_0_0_DATA___3 = 2,
	GP_0_1_DATA___3 = 3,
	GP_0_2_DATA___3 = 4,
	GP_0_3_DATA___3 = 5,
	GP_0_4_DATA___3 = 6,
	GP_0_5_DATA___3 = 7,
	GP_0_6_DATA___3 = 8,
	GP_0_7_DATA___3 = 9,
	GP_0_8_DATA___3 = 10,
	GP_0_9_DATA___3 = 11,
	GP_0_10_DATA___3 = 12,
	GP_0_11_DATA___3 = 13,
	GP_0_12_DATA___3 = 14,
	GP_0_13_DATA___3 = 15,
	GP_0_14_DATA___3 = 16,
	GP_0_15_DATA___3 = 17,
	GP_0_16_DATA = 18,
	GP_0_17_DATA = 19,
	GP_0_18_DATA = 20,
	GP_0_19_DATA = 21,
	GP_0_20_DATA = 22,
	GP_0_21_DATA = 23,
	GP_1_0_DATA___3 = 24,
	GP_1_1_DATA___3 = 25,
	GP_1_2_DATA___3 = 26,
	GP_1_3_DATA___3 = 27,
	GP_1_4_DATA___3 = 28,
	GP_1_5_DATA___3 = 29,
	GP_1_6_DATA___3 = 30,
	GP_1_7_DATA___3 = 31,
	GP_1_8_DATA___3 = 32,
	GP_1_9_DATA___3 = 33,
	GP_1_10_DATA___3 = 34,
	GP_1_11_DATA___3 = 35,
	GP_1_12_DATA___3 = 36,
	GP_1_13_DATA___3 = 37,
	GP_1_14_DATA___3 = 38,
	GP_1_15_DATA___3 = 39,
	GP_1_16_DATA___3 = 40,
	GP_1_17_DATA___3 = 41,
	GP_1_18_DATA___3 = 42,
	GP_1_19_DATA___3 = 43,
	GP_1_20_DATA___3 = 44,
	GP_1_21_DATA___3 = 45,
	GP_1_22_DATA___3 = 46,
	GP_1_23_DATA___3 = 47,
	GP_1_24_DATA___3 = 48,
	GP_1_25_DATA___3 = 49,
	GP_1_26_DATA___3 = 50,
	GP_1_27_DATA___3 = 51,
	GP_2_0_DATA___3 = 52,
	GP_2_1_DATA___3 = 53,
	GP_2_2_DATA___3 = 54,
	GP_2_3_DATA___3 = 55,
	GP_2_4_DATA___3 = 56,
	GP_2_5_DATA___3 = 57,
	GP_2_6_DATA___3 = 58,
	GP_2_7_DATA___3 = 59,
	GP_2_8_DATA___3 = 60,
	GP_2_9_DATA___3 = 61,
	GP_2_10_DATA___3 = 62,
	GP_2_11_DATA___3 = 63,
	GP_2_12_DATA___3 = 64,
	GP_2_13_DATA___3 = 65,
	GP_2_14_DATA___3 = 66,
	GP_2_15_DATA = 67,
	GP_2_16_DATA = 68,
	GP_2_17_DATA = 69,
	GP_2_18_DATA = 70,
	GP_2_19_DATA = 71,
	GP_2_20_DATA = 72,
	GP_2_21_DATA = 73,
	GP_2_22_DATA = 74,
	GP_2_23_DATA = 75,
	GP_2_24_DATA = 76,
	GP_2_25_DATA = 77,
	GP_2_26_DATA = 78,
	GP_2_27_DATA = 79,
	GP_2_28_DATA = 80,
	GP_2_29_DATA = 81,
	GP_3_0_DATA___3 = 82,
	GP_3_1_DATA___3 = 83,
	GP_3_2_DATA___3 = 84,
	GP_3_3_DATA___3 = 85,
	GP_3_4_DATA___3 = 86,
	GP_3_5_DATA___3 = 87,
	GP_3_6_DATA___3 = 88,
	GP_3_7_DATA___3 = 89,
	GP_3_8_DATA___3 = 90,
	GP_3_9_DATA___3 = 91,
	GP_3_10_DATA___3 = 92,
	GP_3_11_DATA___3 = 93,
	GP_3_12_DATA___3 = 94,
	GP_3_13_DATA___3 = 95,
	GP_3_14_DATA___3 = 96,
	GP_3_15_DATA___3 = 97,
	GP_3_16_DATA = 98,
	GP_4_0_DATA___3 = 99,
	GP_4_1_DATA___3 = 100,
	GP_4_2_DATA___3 = 101,
	GP_4_3_DATA___3 = 102,
	GP_4_4_DATA___3 = 103,
	GP_4_5_DATA___3 = 104,
	GP_4_6_DATA___3 = 105,
	GP_4_7_DATA___3 = 106,
	GP_4_8_DATA___3 = 107,
	GP_4_9_DATA___3 = 108,
	GP_4_10_DATA___3 = 109,
	GP_4_11_DATA___3 = 110,
	GP_4_12_DATA___3 = 111,
	GP_4_13_DATA___3 = 112,
	GP_4_14_DATA___3 = 113,
	GP_4_15_DATA___3 = 114,
	GP_4_16_DATA___3 = 115,
	GP_4_17_DATA___3 = 116,
	GP_4_18_DATA = 117,
	GP_4_19_DATA = 118,
	GP_4_20_DATA = 119,
	GP_4_21_DATA = 120,
	GP_4_22_DATA = 121,
	GP_4_23_DATA = 122,
	GP_4_24_DATA = 123,
	GP_5_0_DATA___3 = 124,
	GP_5_1_DATA___3 = 125,
	GP_5_2_DATA___3 = 126,
	GP_5_3_DATA___3 = 127,
	GP_5_4_DATA___3 = 128,
	GP_5_5_DATA___3 = 129,
	GP_5_6_DATA___3 = 130,
	GP_5_7_DATA___3 = 131,
	GP_5_8_DATA___3 = 132,
	GP_5_9_DATA___3 = 133,
	GP_5_10_DATA___3 = 134,
	GP_5_11_DATA___3 = 135,
	GP_5_12_DATA___3 = 136,
	GP_5_13_DATA___3 = 137,
	GP_5_14_DATA___3 = 138,
	PINMUX_DATA_END___3 = 139,
	PINMUX_FUNCTION_BEGIN___3 = 140,
	GP_0_0_FN___3 = 141,
	GP_0_1_FN___3 = 142,
	GP_0_2_FN___3 = 143,
	GP_0_3_FN___3 = 144,
	GP_0_4_FN___3 = 145,
	GP_0_5_FN___3 = 146,
	GP_0_6_FN___3 = 147,
	GP_0_7_FN___3 = 148,
	GP_0_8_FN___3 = 149,
	GP_0_9_FN___3 = 150,
	GP_0_10_FN___3 = 151,
	GP_0_11_FN___3 = 152,
	GP_0_12_FN___3 = 153,
	GP_0_13_FN___3 = 154,
	GP_0_14_FN___3 = 155,
	GP_0_15_FN___3 = 156,
	GP_0_16_FN = 157,
	GP_0_17_FN = 158,
	GP_0_18_FN = 159,
	GP_0_19_FN = 160,
	GP_0_20_FN = 161,
	GP_0_21_FN = 162,
	GP_1_0_FN___3 = 163,
	GP_1_1_FN___3 = 164,
	GP_1_2_FN___3 = 165,
	GP_1_3_FN___3 = 166,
	GP_1_4_FN___3 = 167,
	GP_1_5_FN___3 = 168,
	GP_1_6_FN___3 = 169,
	GP_1_7_FN___3 = 170,
	GP_1_8_FN___3 = 171,
	GP_1_9_FN___3 = 172,
	GP_1_10_FN___3 = 173,
	GP_1_11_FN___3 = 174,
	GP_1_12_FN___3 = 175,
	GP_1_13_FN___3 = 176,
	GP_1_14_FN___3 = 177,
	GP_1_15_FN___3 = 178,
	GP_1_16_FN___3 = 179,
	GP_1_17_FN___3 = 180,
	GP_1_18_FN___3 = 181,
	GP_1_19_FN___3 = 182,
	GP_1_20_FN___3 = 183,
	GP_1_21_FN___3 = 184,
	GP_1_22_FN___3 = 185,
	GP_1_23_FN___3 = 186,
	GP_1_24_FN___3 = 187,
	GP_1_25_FN___3 = 188,
	GP_1_26_FN___3 = 189,
	GP_1_27_FN___3 = 190,
	GP_2_0_FN___3 = 191,
	GP_2_1_FN___3 = 192,
	GP_2_2_FN___3 = 193,
	GP_2_3_FN___3 = 194,
	GP_2_4_FN___3 = 195,
	GP_2_5_FN___3 = 196,
	GP_2_6_FN___3 = 197,
	GP_2_7_FN___3 = 198,
	GP_2_8_FN___3 = 199,
	GP_2_9_FN___3 = 200,
	GP_2_10_FN___3 = 201,
	GP_2_11_FN___3 = 202,
	GP_2_12_FN___3 = 203,
	GP_2_13_FN___3 = 204,
	GP_2_14_FN___3 = 205,
	GP_2_15_FN = 206,
	GP_2_16_FN = 207,
	GP_2_17_FN = 208,
	GP_2_18_FN = 209,
	GP_2_19_FN = 210,
	GP_2_20_FN = 211,
	GP_2_21_FN = 212,
	GP_2_22_FN = 213,
	GP_2_23_FN = 214,
	GP_2_24_FN = 215,
	GP_2_25_FN = 216,
	GP_2_26_FN = 217,
	GP_2_27_FN = 218,
	GP_2_28_FN = 219,
	GP_2_29_FN = 220,
	GP_3_0_FN___3 = 221,
	GP_3_1_FN___3 = 222,
	GP_3_2_FN___3 = 223,
	GP_3_3_FN___3 = 224,
	GP_3_4_FN___3 = 225,
	GP_3_5_FN___3 = 226,
	GP_3_6_FN___3 = 227,
	GP_3_7_FN___3 = 228,
	GP_3_8_FN___3 = 229,
	GP_3_9_FN___3 = 230,
	GP_3_10_FN___3 = 231,
	GP_3_11_FN___3 = 232,
	GP_3_12_FN___3 = 233,
	GP_3_13_FN___3 = 234,
	GP_3_14_FN___3 = 235,
	GP_3_15_FN___3 = 236,
	GP_3_16_FN = 237,
	GP_4_0_FN___3 = 238,
	GP_4_1_FN___3 = 239,
	GP_4_2_FN___3 = 240,
	GP_4_3_FN___3 = 241,
	GP_4_4_FN___3 = 242,
	GP_4_5_FN___3 = 243,
	GP_4_6_FN___3 = 244,
	GP_4_7_FN___3 = 245,
	GP_4_8_FN___3 = 246,
	GP_4_9_FN___3 = 247,
	GP_4_10_FN___3 = 248,
	GP_4_11_FN___3 = 249,
	GP_4_12_FN___3 = 250,
	GP_4_13_FN___3 = 251,
	GP_4_14_FN___3 = 252,
	GP_4_15_FN___3 = 253,
	GP_4_16_FN___3 = 254,
	GP_4_17_FN___3 = 255,
	GP_4_18_FN = 256,
	GP_4_19_FN = 257,
	GP_4_20_FN = 258,
	GP_4_21_FN = 259,
	GP_4_22_FN = 260,
	GP_4_23_FN = 261,
	GP_4_24_FN = 262,
	GP_5_0_FN___3 = 263,
	GP_5_1_FN___3 = 264,
	GP_5_2_FN___3 = 265,
	GP_5_3_FN___3 = 266,
	GP_5_4_FN___3 = 267,
	GP_5_5_FN___3 = 268,
	GP_5_6_FN___3 = 269,
	GP_5_7_FN___3 = 270,
	GP_5_8_FN___3 = 271,
	GP_5_9_FN___3 = 272,
	GP_5_10_FN___3 = 273,
	GP_5_11_FN___3 = 274,
	GP_5_12_FN___3 = 275,
	GP_5_13_FN___3 = 276,
	GP_5_14_FN___3 = 277,
	FN_GETHER_LINK_A = 278,
	FN_GETHER_PHY_INT_A = 279,
	FN_GETHER_MAGIC = 280,
	FN_GETHER_MDC_A = 281,
	FN_GETHER_MDIO_A = 282,
	FN_GETHER_TXCREFCLK_MEGA = 283,
	FN_AVB_LINK___3 = 284,
	FN_GETHER_TXCREFCLK = 285,
	FN_AVB_PHY_INT___3 = 286,
	FN_GETHER_TD3 = 287,
	FN_AVB_MAGIC___3 = 288,
	FN_GETHER_TD2 = 289,
	FN_AVB_MDC___3 = 290,
	FN_GETHER_TD1 = 291,
	FN_AVB_MDIO = 292,
	FN_GETHER_TD0 = 293,
	FN_RPC_INT_N = 294,
	FN_AVB_TXCREFCLK = 295,
	FN_GETHER_TXC = 296,
	FN_RPC_WP_N = 297,
	FN_AVB_TD3 = 298,
	FN_GETHER_TX_CTL = 299,
	FN_RPC_RESET_N = 300,
	FN_AVB_TD2 = 301,
	FN_GETHER_RD3 = 302,
	FN_QSPI1_SSL = 303,
	FN_AVB_TD1 = 304,
	FN_GETHER_RD2 = 305,
	FN_QSPI1_IO3 = 306,
	FN_AVB_TD0 = 307,
	FN_GETHER_RD1 = 308,
	FN_QSPI1_IO2 = 309,
	FN_AVB_TXC = 310,
	FN_GETHER_RD0 = 311,
	FN_QSPI1_MISO_IO1 = 312,
	FN_AVB_TX_CTL = 313,
	FN_GETHER_RXC = 314,
	FN_QSPI1_MOSI_IO0 = 315,
	FN_AVB_RD3 = 316,
	FN_GETHER_RX_CTL = 317,
	FN_QSPI1_SPCLK = 318,
	FN_AVB_RD2 = 319,
	FN_QSPI0_SSL = 320,
	FN_AVB_RD1 = 321,
	FN_QSPI0_IO3 = 322,
	FN_AVB_RD0 = 323,
	FN_QSPI0_IO2 = 324,
	FN_AVB_RXC = 325,
	FN_QSPI0_MISO_IO1 = 326,
	FN_AVB_RX_CTL = 327,
	FN_QSPI0_MOSI_IO0 = 328,
	FN_QSPI0_SPCLK = 329,
	FN_IP0_3_0___3 = 330,
	FN_DU_DR2___3 = 331,
	FN_SCK4 = 332,
	FN_GETHER_RMII_CRS_DV = 333,
	FN_A0___3 = 334,
	FN_IP1_3_0___3 = 335,
	FN_DU_DG4___3 = 336,
	FN_SCL5 = 337,
	FN_A8___3 = 338,
	FN_IP2_3_0___3 = 339,
	FN_DU_DB6___3 = 340,
	FN_MSIOF3_RXD = 341,
	FN_A16___3 = 342,
	FN_IP3_3_0___3 = 343,
	FN_VI0_CLKENB = 344,
	FN_MSIOF2_RXD = 345,
	FN_RX3 = 346,
	FN_RD_WR_N___3 = 347,
	FN_HCTS3_N___3 = 348,
	FN_IP0_7_4___3 = 349,
	FN_DU_DR3___3 = 350,
	FN_RX4 = 351,
	FN_GETHER_RMII_RX_ER = 352,
	FN_A1___3 = 353,
	FN_IP1_7_4___3 = 354,
	FN_DU_DG5___3 = 355,
	FN_SDA5 = 356,
	FN_GETHER_MDC_B = 357,
	FN_A9___3 = 358,
	FN_IP2_7_4___3 = 359,
	FN_DU_DB7___3 = 360,
	FN_MSIOF3_TXD = 361,
	FN_A17___3 = 362,
	FN_IP3_7_4___3 = 363,
	FN_VI0_HSYNC_N = 364,
	FN_MSIOF2_TXD = 365,
	FN_TX3 = 366,
	FN_HRTS3_N___3 = 367,
	FN_IP0_11_8___3 = 368,
	FN_DU_DR4___3 = 369,
	FN_TX4 = 370,
	FN_GETHER_RMII_RXD0 = 371,
	FN_A2___3 = 372,
	FN_IP1_11_8___3 = 373,
	FN_DU_DG6___3 = 374,
	FN_SCIF_CLK_A___3 = 375,
	FN_GETHER_MDIO_B = 376,
	FN_A10___3 = 377,
	FN_IP2_11_8___3 = 378,
	FN_DU_DOTCLKOUT = 379,
	FN_MSIOF3_SS1 = 380,
	FN_GETHER_LINK_B = 381,
	FN_A18___3 = 382,
	FN_IP3_11_8___3 = 383,
	FN_VI0_VSYNC_N = 384,
	FN_MSIOF2_SYNC = 385,
	FN_CTS3_N___3 = 386,
	FN_HTX3 = 387,
	FN_IP0_15_12___3 = 388,
	FN_DU_DR5___3 = 389,
	FN_CTS4_N = 390,
	FN_GETHER_RMII_RXD1 = 391,
	FN_A3___3 = 392,
	FN_IP1_15_12___3 = 393,
	FN_DU_DG7___3 = 394,
	FN_HRX0_A = 395,
	FN_A11___3 = 396,
	FN_IP2_15_12___3 = 397,
	FN_DU_EXHSYNC_DU_HSYNC___3 = 398,
	FN_MSIOF3_SS2 = 399,
	FN_GETHER_PHY_INT_B = 400,
	FN_A19___3 = 401,
	FN_FXR_TXENA_N = 402,
	FN_IP3_15_12___3 = 403,
	FN_VI0_DATA0 = 404,
	FN_MSIOF2_SS1 = 405,
	FN_RTS3_N___3 = 406,
	FN_HRX3 = 407,
	FN_IP0_19_16___3 = 408,
	FN_DU_DR6___3 = 409,
	FN_RTS4_N = 410,
	FN_GETHER_RMII_TXD_EN = 411,
	FN_A4___3 = 412,
	FN_IP1_19_16___3 = 413,
	FN_DU_DB2___3 = 414,
	FN_HSCK0_A = 415,
	FN_A12___3 = 416,
	FN_IRQ1___3 = 417,
	FN_IP2_19_16___3 = 418,
	FN_DU_EXVSYNC_DU_VSYNC___3 = 419,
	FN_MSIOF3_SCK = 420,
	FN_FXR_TXENB_N = 421,
	FN_IP3_19_16___3 = 422,
	FN_VI0_DATA1 = 423,
	FN_MSIOF2_SS2 = 424,
	FN_SCK1___3 = 425,
	FN_SPEEDIN_A___3 = 426,
	FN_IP0_23_20___3 = 427,
	FN_DU_DR7___3 = 428,
	FN_GETHER_RMII_TXD0 = 429,
	FN_A5___3 = 430,
	FN_IP1_23_20___3 = 431,
	FN_DU_DB3___3 = 432,
	FN_HRTS0_N_A = 433,
	FN_A13___3 = 434,
	FN_IRQ2___3 = 435,
	FN_IP2_23_20___3 = 436,
	FN_DU_EXODDF_DU_ODDF_DISP_CDE___3 = 437,
	FN_MSIOF3_SYNC = 438,
	FN_IP3_23_20___3 = 439,
	FN_VI0_DATA2 = 440,
	FN_AVB_AVTP_PPS___3 = 441,
	FN_IP0_27_24___3 = 442,
	FN_DU_DG2___3 = 443,
	FN_GETHER_RMII_TXD1 = 444,
	FN_A6___3 = 445,
	FN_IP1_27_24___3 = 446,
	FN_DU_DB4___3 = 447,
	FN_HCTS0_N_A = 448,
	FN_A14___3 = 449,
	FN_IRQ3___3 = 450,
	FN_IP2_27_24___3 = 451,
	FN_IRQ0___3 = 452,
	FN_IP3_27_24___3 = 453,
	FN_VI0_DATA3 = 454,
	FN_HSCK1 = 455,
	FN_IP0_31_28___3 = 456,
	FN_DU_DG3___3 = 457,
	FN_CPG_CPCKOUT = 458,
	FN_GETHER_RMII_REFCLK = 459,
	FN_A7___3 = 460,
	FN_PWMFSW0 = 461,
	FN_IP1_31_28___3 = 462,
	FN_DU_DB5___3 = 463,
	FN_HTX0_A = 464,
	FN_PWM0_A = 465,
	FN_A15___3 = 466,
	FN_IP2_31_28___3 = 467,
	FN_VI0_CLK = 468,
	FN_MSIOF2_SCK = 469,
	FN_SCK3___3 = 470,
	FN_HSCK3___3 = 471,
	FN_IP3_31_28___3 = 472,
	FN_VI0_DATA4 = 473,
	FN_HRTS1_N = 474,
	FN_RX1_A___3 = 475,
	FN_IP4_3_0___3 = 476,
	FN_VI0_DATA5 = 477,
	FN_HCTS1_N = 478,
	FN_TX1_A___3 = 479,
	FN_IP5_3_0___3 = 480,
	FN_VI1_CLK = 481,
	FN_MSIOF1_RXD = 482,
	FN_CS0_N___3 = 483,
	FN_IP6_3_0___3 = 484,
	FN_VI1_DATA4 = 485,
	FN_CANFD_CLK_B = 486,
	FN_D7___3 = 487,
	FN_MMC_D0 = 488,
	FN_IP7_3_0___3 = 489,
	FN_VI1_FIELD = 490,
	FN_SDA4 = 491,
	FN_D15___3 = 492,
	FN_MMC_D7 = 493,
	FN_IP4_7_4___3 = 494,
	FN_VI0_DATA6 = 495,
	FN_HTX1 = 496,
	FN_CTS1_N___3 = 497,
	FN_IP5_7_4___3 = 498,
	FN_VI1_CLKENB = 499,
	FN_MSIOF1_TXD = 500,
	FN_D0___3 = 501,
	FN_IP6_7_4___3 = 502,
	FN_VI1_DATA5 = 503,
	FN_D8___3 = 504,
	FN_MMC_D1 = 505,
	FN_IP7_7_4___3 = 506,
	FN_SCL0 = 507,
	FN_CLKOUT___3 = 508,
	FN_IP4_11_8___3 = 509,
	FN_VI0_DATA7 = 510,
	FN_HRX1 = 511,
	FN_RTS1_N___3 = 512,
	FN_IP5_11_8___3 = 513,
	FN_VI1_HSYNC_N = 514,
	FN_MSIOF1_SCK = 515,
	FN_D1___3 = 516,
	FN_IP6_11_8___3 = 517,
	FN_VI1_DATA6 = 518,
	FN_D9___3 = 519,
	FN_MMC_D2 = 520,
	FN_IP7_11_8___3 = 521,
	FN_SDA0 = 522,
	FN_BS_N___3 = 523,
	FN_SCK0___3 = 524,
	FN_HSCK0_B = 525,
	FN_IP4_15_12___3 = 526,
	FN_VI0_DATA8 = 527,
	FN_HSCK2 = 528,
	FN_IP5_15_12___3 = 529,
	FN_VI1_VSYNC_N = 530,
	FN_MSIOF1_SYNC = 531,
	FN_D2___3 = 532,
	FN_IP6_15_12___3 = 533,
	FN_VI1_DATA7 = 534,
	FN_D10___3 = 535,
	FN_MMC_D3 = 536,
	FN_IP7_15_12 = 537,
	FN_SCL1 = 538,
	FN_TPU0TO2___3 = 539,
	FN_RD_N___3 = 540,
	FN_CTS0_N___3 = 541,
	FN_HCTS0_N_B = 542,
	FN_IP4_19_16___3 = 543,
	FN_VI0_DATA9 = 544,
	FN_HCTS2_N = 545,
	FN_PWM1_A___3 = 546,
	FN_IP5_19_16___3 = 547,
	FN_VI1_DATA0 = 548,
	FN_MSIOF1_SS1 = 549,
	FN_D3___3 = 550,
	FN_MMC_WP = 551,
	FN_IP6_19_16___3 = 552,
	FN_VI1_DATA8 = 553,
	FN_D11___3 = 554,
	FN_MMC_CLK = 555,
	FN_IP7_19_16___3 = 556,
	FN_SDA1 = 557,
	FN_TPU0TO3___3 = 558,
	FN_WE0_N___3 = 559,
	FN_RTS0_N___3 = 560,
	FN_HRTS0_N_B = 561,
	FN_IP4_23_20___3 = 562,
	FN_VI0_DATA10 = 563,
	FN_HRTS2_N = 564,
	FN_PWM2_A___3 = 565,
	FN_IP5_23_20___3 = 566,
	FN_VI1_DATA1 = 567,
	FN_MSIOF1_SS2 = 568,
	FN_D4___3 = 569,
	FN_MMC_CD = 570,
	FN_IP6_23_20___3 = 571,
	FN_VI1_DATA9 = 572,
	FN_TCLK1_A___3 = 573,
	FN_D12___3 = 574,
	FN_MMC_D4 = 575,
	FN_IP7_23_20___3 = 576,
	FN_SCL2 = 577,
	FN_WE1_N___3 = 578,
	FN_RX0___3 = 579,
	FN_HRX0_B = 580,
	FN_IP4_27_24___3 = 581,
	FN_VI0_DATA11 = 582,
	FN_HTX2 = 583,
	FN_PWM3_A___3 = 584,
	FN_IP5_27_24___3 = 585,
	FN_VI1_DATA2 = 586,
	FN_CANFD0_TX_B___3 = 587,
	FN_D5___3 = 588,
	FN_MMC_DS = 589,
	FN_IP6_27_24___3 = 590,
	FN_VI1_DATA10 = 591,
	FN_TCLK2_A___3 = 592,
	FN_D13___3 = 593,
	FN_MMC_D5 = 594,
	FN_IP7_27_24___3 = 595,
	FN_SDA2 = 596,
	FN_EX_WAIT0 = 597,
	FN_TX0___3 = 598,
	FN_HTX0_B = 599,
	FN_IP4_31_28___3 = 600,
	FN_VI0_FIELD = 601,
	FN_HRX2 = 602,
	FN_PWM4_A___3 = 603,
	FN_CS1_N___3 = 604,
	FN_IP5_31_28___3 = 605,
	FN_VI1_DATA3 = 606,
	FN_CANFD0_RX_B___3 = 607,
	FN_D6___3 = 608,
	FN_MMC_CMD = 609,
	FN_IP6_31_28___3 = 610,
	FN_VI1_DATA11 = 611,
	FN_SCL4 = 612,
	FN_D14___3 = 613,
	FN_MMC_D6 = 614,
	FN_IP7_31_28___3 = 615,
	FN_AVB_AVTP_MATCH = 616,
	FN_TPU0TO0___3 = 617,
	FN_IP8_3_0___3 = 618,
	FN_AVB_AVTP_CAPTURE = 619,
	FN_TPU0TO1___3 = 620,
	FN_IP9_3_0___3 = 621,
	FN_IRQ4___3 = 622,
	FN_VI0_DATA12 = 623,
	FN_IP10_3_0___3 = 624,
	FN_SCL3 = 625,
	FN_VI0_DATA20 = 626,
	FN_IP8_7_4___3 = 627,
	FN_CANFD0_TX_A___3 = 628,
	FN_FXR_TXDA = 629,
	FN_PWM0_B = 630,
	FN_DU_DISP___3 = 631,
	FN_IP9_7_4___3 = 632,
	FN_IRQ5___3 = 633,
	FN_VI0_DATA13 = 634,
	FN_IP10_7_4___3 = 635,
	FN_SDA3 = 636,
	FN_VI0_DATA21 = 637,
	FN_IP8_11_8___3 = 638,
	FN_CANFD0_RX_A___3 = 639,
	FN_RXDA_EXTFXR = 640,
	FN_PWM1_B___3 = 641,
	FN_DU_CDE___3 = 642,
	FN_IP9_11_8___3 = 643,
	FN_MSIOF0_RXD___3 = 644,
	FN_DU_DR0___3 = 645,
	FN_VI0_DATA14 = 646,
	FN_IP10_11_8___3 = 647,
	FN_FSO_CFE_0_N___3 = 648,
	FN_VI0_DATA22 = 649,
	FN_IP8_15_12___3 = 650,
	FN_CANFD1_TX___3 = 651,
	FN_FXR_TXDB = 652,
	FN_PWM2_B___3 = 653,
	FN_TCLK1_B___3 = 654,
	FN_TX1_B___3 = 655,
	FN_IP9_15_12___3 = 656,
	FN_MSIOF0_TXD___3 = 657,
	FN_DU_DR1___3 = 658,
	FN_VI0_DATA15 = 659,
	FN_IP10_15_12___3 = 660,
	FN_FSO_CFE_1_N___3 = 661,
	FN_VI0_DATA23 = 662,
	FN_IP8_19_16___3 = 663,
	FN_CANFD1_RX___3 = 664,
	FN_RXDB_EXTFXR = 665,
	FN_PWM3_B___3 = 666,
	FN_TCLK2_B___3 = 667,
	FN_RX1_B___3 = 668,
	FN_IP9_19_16___3 = 669,
	FN_MSIOF0_SCK___3 = 670,
	FN_DU_DG0___3 = 671,
	FN_VI0_DATA16 = 672,
	FN_IP10_19_16___3 = 673,
	FN_FSO_TOE_N___3 = 674,
	FN_IP8_23_20___3 = 675,
	FN_CANFD_CLK_A = 676,
	FN_CLK_EXTFXR = 677,
	FN_PWM4_B___3 = 678,
	FN_SPEEDIN_B___3 = 679,
	FN_SCIF_CLK_B___3 = 680,
	FN_IP9_23_20___3 = 681,
	FN_MSIOF0_SYNC___3 = 682,
	FN_DU_DG1___3 = 683,
	FN_VI0_DATA17 = 684,
	FN_IP8_27_24___3 = 685,
	FN_DIGRF_CLKIN = 686,
	FN_DIGRF_CLKEN_IN = 687,
	FN_IP9_27_24___3 = 688,
	FN_MSIOF0_SS1___3 = 689,
	FN_DU_DB0___3 = 690,
	FN_TCLK3 = 691,
	FN_VI0_DATA18 = 692,
	FN_IP8_31_28___3 = 693,
	FN_DIGRF_CLKOUT = 694,
	FN_DIGRF_CLKEN_OUT = 695,
	FN_IP9_31_28___3 = 696,
	FN_MSIOF0_SS2___3 = 697,
	FN_DU_DB1___3 = 698,
	FN_TCLK4 = 699,
	FN_VI0_DATA19 = 700,
	FN_SEL_CANFD0_0___3 = 701,
	FN_SEL_CANFD0_1___3 = 702,
	FN_SEL_GETHER_0 = 703,
	FN_SEL_GETHER_1 = 704,
	FN_SEL_HSCIF0_0 = 705,
	FN_SEL_HSCIF0_1 = 706,
	FN_SEL_PWM0_0 = 707,
	FN_SEL_PWM0_1 = 708,
	FN_SEL_PWM1_0___3 = 709,
	FN_SEL_PWM1_1___3 = 710,
	FN_SEL_PWM2_0___3 = 711,
	FN_SEL_PWM2_1___3 = 712,
	FN_SEL_PWM3_0___3 = 713,
	FN_SEL_PWM3_1___3 = 714,
	FN_SEL_PWM4_0___3 = 715,
	FN_SEL_PWM4_1___3 = 716,
	FN_SEL_RSP_0 = 717,
	FN_SEL_RSP_1 = 718,
	FN_SEL_SCIF1_0___3 = 719,
	FN_SEL_SCIF1_1___3 = 720,
	FN_SEL_TMU_0 = 721,
	FN_SEL_TMU_1 = 722,
	PINMUX_FUNCTION_END___3 = 723,
	PINMUX_MARK_BEGIN___3 = 724,
	GETHER_LINK_A_MARK = 725,
	GETHER_PHY_INT_A_MARK = 726,
	GETHER_MAGIC_MARK = 727,
	GETHER_MDC_A_MARK = 728,
	GETHER_MDIO_A_MARK = 729,
	GETHER_TXCREFCLK_MEGA_MARK = 730,
	AVB_LINK_MARK___3 = 731,
	GETHER_TXCREFCLK_MARK = 732,
	AVB_PHY_INT_MARK___3 = 733,
	GETHER_TD3_MARK = 734,
	AVB_MAGIC_MARK___3 = 735,
	GETHER_TD2_MARK = 736,
	AVB_MDC_MARK___3 = 737,
	GETHER_TD1_MARK = 738,
	AVB_MDIO_MARK___3 = 739,
	GETHER_TD0_MARK = 740,
	RPC_INT_N_MARK = 741,
	AVB_TXCREFCLK_MARK___3 = 742,
	GETHER_TXC_MARK = 743,
	RPC_WP_N_MARK = 744,
	AVB_TD3_MARK___3 = 745,
	GETHER_TX_CTL_MARK = 746,
	RPC_RESET_N_MARK = 747,
	AVB_TD2_MARK___3 = 748,
	GETHER_RD3_MARK = 749,
	QSPI1_SSL_MARK___3 = 750,
	AVB_TD1_MARK___3 = 751,
	GETHER_RD2_MARK = 752,
	QSPI1_IO3_MARK___3 = 753,
	AVB_TD0_MARK___3 = 754,
	GETHER_RD1_MARK = 755,
	QSPI1_IO2_MARK___3 = 756,
	AVB_TXC_MARK___3 = 757,
	GETHER_RD0_MARK = 758,
	QSPI1_MISO_IO1_MARK___3 = 759,
	AVB_TX_CTL_MARK___3 = 760,
	GETHER_RXC_MARK = 761,
	QSPI1_MOSI_IO0_MARK___3 = 762,
	AVB_RD3_MARK___3 = 763,
	GETHER_RX_CTL_MARK = 764,
	QSPI1_SPCLK_MARK___3 = 765,
	AVB_RD2_MARK___3 = 766,
	QSPI0_SSL_MARK___3 = 767,
	AVB_RD1_MARK___3 = 768,
	QSPI0_IO3_MARK___3 = 769,
	AVB_RD0_MARK___3 = 770,
	QSPI0_IO2_MARK___3 = 771,
	AVB_RXC_MARK___3 = 772,
	QSPI0_MISO_IO1_MARK___3 = 773,
	AVB_RX_CTL_MARK___3 = 774,
	QSPI0_MOSI_IO0_MARK___3 = 775,
	QSPI0_SPCLK_MARK___3 = 776,
	IP0_3_0_MARK___3 = 777,
	DU_DR2_MARK___3 = 778,
	SCK4_MARK = 779,
	GETHER_RMII_CRS_DV_MARK = 780,
	A0_MARK___3 = 781,
	IP1_3_0_MARK___3 = 782,
	DU_DG4_MARK___3 = 783,
	SCL5_MARK___3 = 784,
	A8_MARK___3 = 785,
	IP2_3_0_MARK___3 = 786,
	DU_DB6_MARK___3 = 787,
	MSIOF3_RXD_MARK = 788,
	A16_MARK___3 = 789,
	IP3_3_0_MARK___3 = 790,
	VI0_CLKENB_MARK = 791,
	MSIOF2_RXD_MARK = 792,
	RX3_MARK = 793,
	RD_WR_N_MARK___3 = 794,
	HCTS3_N_MARK___3 = 795,
	IP0_7_4_MARK___3 = 796,
	DU_DR3_MARK___3 = 797,
	RX4_MARK = 798,
	GETHER_RMII_RX_ER_MARK = 799,
	A1_MARK___3 = 800,
	IP1_7_4_MARK___3 = 801,
	DU_DG5_MARK___3 = 802,
	SDA5_MARK___3 = 803,
	GETHER_MDC_B_MARK = 804,
	A9_MARK___3 = 805,
	IP2_7_4_MARK___3 = 806,
	DU_DB7_MARK___3 = 807,
	MSIOF3_TXD_MARK = 808,
	A17_MARK___3 = 809,
	IP3_7_4_MARK___3 = 810,
	VI0_HSYNC_N_MARK = 811,
	MSIOF2_TXD_MARK = 812,
	TX3_MARK = 813,
	HRTS3_N_MARK___3 = 814,
	IP0_11_8_MARK___3 = 815,
	DU_DR4_MARK___3 = 816,
	TX4_MARK = 817,
	GETHER_RMII_RXD0_MARK = 818,
	A2_MARK___3 = 819,
	IP1_11_8_MARK___3 = 820,
	DU_DG6_MARK___3 = 821,
	SCIF_CLK_A_MARK___3 = 822,
	GETHER_MDIO_B_MARK = 823,
	A10_MARK___3 = 824,
	IP2_11_8_MARK___3 = 825,
	DU_DOTCLKOUT_MARK = 826,
	MSIOF3_SS1_MARK = 827,
	GETHER_LINK_B_MARK = 828,
	A18_MARK___3 = 829,
	IP3_11_8_MARK___3 = 830,
	VI0_VSYNC_N_MARK = 831,
	MSIOF2_SYNC_MARK = 832,
	CTS3_N_MARK___3 = 833,
	HTX3_MARK = 834,
	IP0_15_12_MARK___3 = 835,
	DU_DR5_MARK___3 = 836,
	CTS4_N_MARK = 837,
	GETHER_RMII_RXD1_MARK = 838,
	A3_MARK___3 = 839,
	IP1_15_12_MARK___3 = 840,
	DU_DG7_MARK___3 = 841,
	HRX0_A_MARK = 842,
	A11_MARK___3 = 843,
	IP2_15_12_MARK___3 = 844,
	DU_EXHSYNC_DU_HSYNC_MARK___3 = 845,
	MSIOF3_SS2_MARK = 846,
	GETHER_PHY_INT_B_MARK = 847,
	A19_MARK___3 = 848,
	FXR_TXENA_N_MARK = 849,
	IP3_15_12_MARK___3 = 850,
	VI0_DATA0_MARK = 851,
	MSIOF2_SS1_MARK = 852,
	RTS3_N_MARK___3 = 853,
	HRX3_MARK = 854,
	IP0_19_16_MARK___3 = 855,
	DU_DR6_MARK___3 = 856,
	RTS4_N_MARK = 857,
	GETHER_RMII_TXD_EN_MARK = 858,
	A4_MARK___3 = 859,
	IP1_19_16_MARK___3 = 860,
	DU_DB2_MARK___3 = 861,
	HSCK0_A_MARK = 862,
	A12_MARK___3 = 863,
	IRQ1_MARK___3 = 864,
	IP2_19_16_MARK___3 = 865,
	DU_EXVSYNC_DU_VSYNC_MARK___3 = 866,
	MSIOF3_SCK_MARK = 867,
	FXR_TXENB_N_MARK = 868,
	IP3_19_16_MARK___3 = 869,
	VI0_DATA1_MARK = 870,
	MSIOF2_SS2_MARK = 871,
	SCK1_MARK___3 = 872,
	SPEEDIN_A_MARK___3 = 873,
	IP0_23_20_MARK___3 = 874,
	DU_DR7_MARK___3 = 875,
	GETHER_RMII_TXD0_MARK = 876,
	A5_MARK___3 = 877,
	IP1_23_20_MARK___3 = 878,
	DU_DB3_MARK___3 = 879,
	HRTS0_N_A_MARK = 880,
	A13_MARK___3 = 881,
	IRQ2_MARK___3 = 882,
	IP2_23_20_MARK___3 = 883,
	DU_EXODDF_DU_ODDF_DISP_CDE_MARK___3 = 884,
	MSIOF3_SYNC_MARK = 885,
	IP3_23_20_MARK___3 = 886,
	VI0_DATA2_MARK = 887,
	AVB_AVTP_PPS_MARK___3 = 888,
	IP0_27_24_MARK___3 = 889,
	DU_DG2_MARK___3 = 890,
	GETHER_RMII_TXD1_MARK = 891,
	A6_MARK___3 = 892,
	IP1_27_24_MARK___3 = 893,
	DU_DB4_MARK___3 = 894,
	HCTS0_N_A_MARK = 895,
	A14_MARK___3 = 896,
	IRQ3_MARK___3 = 897,
	IP2_27_24_MARK___3 = 898,
	IRQ0_MARK___3 = 899,
	IP3_27_24_MARK___3 = 900,
	VI0_DATA3_MARK = 901,
	HSCK1_MARK = 902,
	IP0_31_28_MARK___3 = 903,
	DU_DG3_MARK___3 = 904,
	CPG_CPCKOUT_MARK = 905,
	GETHER_RMII_REFCLK_MARK = 906,
	A7_MARK___3 = 907,
	PWMFSW0_MARK = 908,
	IP1_31_28_MARK___3 = 909,
	DU_DB5_MARK___3 = 910,
	HTX0_A_MARK = 911,
	PWM0_A_MARK = 912,
	A15_MARK___3 = 913,
	IP2_31_28_MARK___3 = 914,
	VI0_CLK_MARK = 915,
	MSIOF2_SCK_MARK = 916,
	SCK3_MARK___3 = 917,
	HSCK3_MARK___3 = 918,
	IP3_31_28_MARK___3 = 919,
	VI0_DATA4_MARK = 920,
	HRTS1_N_MARK = 921,
	RX1_A_MARK___3 = 922,
	IP4_3_0_MARK___3 = 923,
	VI0_DATA5_MARK = 924,
	HCTS1_N_MARK = 925,
	TX1_A_MARK___3 = 926,
	IP5_3_0_MARK___3 = 927,
	VI1_CLK_MARK = 928,
	MSIOF1_RXD_MARK = 929,
	CS0_N_MARK___3 = 930,
	IP6_3_0_MARK___3 = 931,
	VI1_DATA4_MARK = 932,
	CANFD_CLK_B_MARK = 933,
	D7_MARK___3 = 934,
	MMC_D0_MARK = 935,
	IP7_3_0_MARK___3 = 936,
	VI1_FIELD_MARK = 937,
	SDA4_MARK = 938,
	D15_MARK___3 = 939,
	MMC_D7_MARK = 940,
	IP4_7_4_MARK___3 = 941,
	VI0_DATA6_MARK = 942,
	HTX1_MARK = 943,
	CTS1_N_MARK___3 = 944,
	IP5_7_4_MARK___3 = 945,
	VI1_CLKENB_MARK = 946,
	MSIOF1_TXD_MARK = 947,
	D0_MARK___3 = 948,
	IP6_7_4_MARK___3 = 949,
	VI1_DATA5_MARK = 950,
	D8_MARK___3 = 951,
	MMC_D1_MARK = 952,
	IP7_7_4_MARK___3 = 953,
	SCL0_MARK___3 = 954,
	CLKOUT_MARK___3 = 955,
	IP4_11_8_MARK___3 = 956,
	VI0_DATA7_MARK = 957,
	HRX1_MARK = 958,
	RTS1_N_MARK___3 = 959,
	IP5_11_8_MARK___3 = 960,
	VI1_HSYNC_N_MARK = 961,
	MSIOF1_SCK_MARK = 962,
	D1_MARK___3 = 963,
	IP6_11_8_MARK___3 = 964,
	VI1_DATA6_MARK = 965,
	D9_MARK___3 = 966,
	MMC_D2_MARK = 967,
	IP7_11_8_MARK___3 = 968,
	SDA0_MARK___3 = 969,
	BS_N_MARK___3 = 970,
	SCK0_MARK___3 = 971,
	HSCK0_B_MARK = 972,
	IP4_15_12_MARK___3 = 973,
	VI0_DATA8_MARK = 974,
	HSCK2_MARK = 975,
	IP5_15_12_MARK___3 = 976,
	VI1_VSYNC_N_MARK = 977,
	MSIOF1_SYNC_MARK = 978,
	D2_MARK___3 = 979,
	IP6_15_12_MARK___3 = 980,
	VI1_DATA7_MARK = 981,
	D10_MARK___3 = 982,
	MMC_D3_MARK = 983,
	IP7_15_12_MARK = 984,
	SCL1_MARK = 985,
	TPU0TO2_MARK___3 = 986,
	RD_N_MARK___3 = 987,
	CTS0_N_MARK___3 = 988,
	HCTS0_N_B_MARK = 989,
	IP4_19_16_MARK___3 = 990,
	VI0_DATA9_MARK = 991,
	HCTS2_N_MARK = 992,
	PWM1_A_MARK___3 = 993,
	IP5_19_16_MARK___3 = 994,
	VI1_DATA0_MARK = 995,
	MSIOF1_SS1_MARK = 996,
	D3_MARK___3 = 997,
	MMC_WP_MARK = 998,
	IP6_19_16_MARK___3 = 999,
	VI1_DATA8_MARK = 1000,
	D11_MARK___3 = 1001,
	MMC_CLK_MARK = 1002,
	IP7_19_16_MARK___3 = 1003,
	SDA1_MARK = 1004,
	TPU0TO3_MARK___3 = 1005,
	WE0_N_MARK___3 = 1006,
	RTS0_N_MARK___3 = 1007,
	HRTS0_N_B_MARK = 1008,
	IP4_23_20_MARK___3 = 1009,
	VI0_DATA10_MARK = 1010,
	HRTS2_N_MARK = 1011,
	PWM2_A_MARK___3 = 1012,
	IP5_23_20_MARK___3 = 1013,
	VI1_DATA1_MARK = 1014,
	MSIOF1_SS2_MARK = 1015,
	D4_MARK___3 = 1016,
	MMC_CD_MARK = 1017,
	IP6_23_20_MARK___3 = 1018,
	VI1_DATA9_MARK = 1019,
	TCLK1_A_MARK___3 = 1020,
	D12_MARK___3 = 1021,
	MMC_D4_MARK = 1022,
	IP7_23_20_MARK___3 = 1023,
	SCL2_MARK = 1024,
	WE1_N_MARK___3 = 1025,
	RX0_MARK___3 = 1026,
	HRX0_B_MARK = 1027,
	IP4_27_24_MARK___3 = 1028,
	VI0_DATA11_MARK = 1029,
	HTX2_MARK = 1030,
	PWM3_A_MARK___3 = 1031,
	IP5_27_24_MARK___3 = 1032,
	VI1_DATA2_MARK = 1033,
	CANFD0_TX_B_MARK___3 = 1034,
	D5_MARK___3 = 1035,
	MMC_DS_MARK = 1036,
	IP6_27_24_MARK___3 = 1037,
	VI1_DATA10_MARK = 1038,
	TCLK2_A_MARK___3 = 1039,
	D13_MARK___3 = 1040,
	MMC_D5_MARK = 1041,
	IP7_27_24_MARK___3 = 1042,
	SDA2_MARK = 1043,
	EX_WAIT0_MARK = 1044,
	TX0_MARK___3 = 1045,
	HTX0_B_MARK = 1046,
	IP4_31_28_MARK___3 = 1047,
	VI0_FIELD_MARK = 1048,
	HRX2_MARK = 1049,
	PWM4_A_MARK___3 = 1050,
	CS1_N_MARK___3 = 1051,
	IP5_31_28_MARK___3 = 1052,
	VI1_DATA3_MARK = 1053,
	CANFD0_RX_B_MARK___3 = 1054,
	D6_MARK___3 = 1055,
	MMC_CMD_MARK = 1056,
	IP6_31_28_MARK___3 = 1057,
	VI1_DATA11_MARK = 1058,
	SCL4_MARK = 1059,
	D14_MARK___3 = 1060,
	MMC_D6_MARK = 1061,
	IP7_31_28_MARK___3 = 1062,
	AVB_AVTP_MATCH_MARK = 1063,
	TPU0TO0_MARK___3 = 1064,
	IP8_3_0_MARK___3 = 1065,
	AVB_AVTP_CAPTURE_MARK = 1066,
	TPU0TO1_MARK___3 = 1067,
	IP9_3_0_MARK___3 = 1068,
	IRQ4_MARK___3 = 1069,
	VI0_DATA12_MARK = 1070,
	IP10_3_0_MARK___3 = 1071,
	SCL3_MARK___3 = 1072,
	VI0_DATA20_MARK = 1073,
	IP8_7_4_MARK___3 = 1074,
	CANFD0_TX_A_MARK___3 = 1075,
	FXR_TXDA_MARK = 1076,
	PWM0_B_MARK = 1077,
	DU_DISP_MARK___3 = 1078,
	IP9_7_4_MARK___3 = 1079,
	IRQ5_MARK___3 = 1080,
	VI0_DATA13_MARK = 1081,
	IP10_7_4_MARK___3 = 1082,
	SDA3_MARK___3 = 1083,
	VI0_DATA21_MARK = 1084,
	IP8_11_8_MARK___3 = 1085,
	CANFD0_RX_A_MARK___3 = 1086,
	RXDA_EXTFXR_MARK = 1087,
	PWM1_B_MARK___3 = 1088,
	DU_CDE_MARK___3 = 1089,
	IP9_11_8_MARK___3 = 1090,
	MSIOF0_RXD_MARK___3 = 1091,
	DU_DR0_MARK___3 = 1092,
	VI0_DATA14_MARK = 1093,
	IP10_11_8_MARK___3 = 1094,
	FSO_CFE_0_N_MARK___3 = 1095,
	VI0_DATA22_MARK = 1096,
	IP8_15_12_MARK___3 = 1097,
	CANFD1_TX_MARK___3 = 1098,
	FXR_TXDB_MARK = 1099,
	PWM2_B_MARK___3 = 1100,
	TCLK1_B_MARK___3 = 1101,
	TX1_B_MARK___3 = 1102,
	IP9_15_12_MARK___3 = 1103,
	MSIOF0_TXD_MARK___3 = 1104,
	DU_DR1_MARK___3 = 1105,
	VI0_DATA15_MARK = 1106,
	IP10_15_12_MARK___3 = 1107,
	FSO_CFE_1_N_MARK___3 = 1108,
	VI0_DATA23_MARK = 1109,
	IP8_19_16_MARK___3 = 1110,
	CANFD1_RX_MARK___3 = 1111,
	RXDB_EXTFXR_MARK = 1112,
	PWM3_B_MARK___3 = 1113,
	TCLK2_B_MARK___3 = 1114,
	RX1_B_MARK___3 = 1115,
	IP9_19_16_MARK___3 = 1116,
	MSIOF0_SCK_MARK___3 = 1117,
	DU_DG0_MARK___3 = 1118,
	VI0_DATA16_MARK = 1119,
	IP10_19_16_MARK___3 = 1120,
	FSO_TOE_N_MARK___3 = 1121,
	IP8_23_20_MARK___3 = 1122,
	CANFD_CLK_A_MARK = 1123,
	CLK_EXTFXR_MARK = 1124,
	PWM4_B_MARK___3 = 1125,
	SPEEDIN_B_MARK___3 = 1126,
	SCIF_CLK_B_MARK___3 = 1127,
	IP9_23_20_MARK___3 = 1128,
	MSIOF0_SYNC_MARK___3 = 1129,
	DU_DG1_MARK___3 = 1130,
	VI0_DATA17_MARK = 1131,
	IP8_27_24_MARK___3 = 1132,
	DIGRF_CLKIN_MARK = 1133,
	DIGRF_CLKEN_IN_MARK = 1134,
	IP9_27_24_MARK___3 = 1135,
	MSIOF0_SS1_MARK___3 = 1136,
	DU_DB0_MARK___3 = 1137,
	TCLK3_MARK = 1138,
	VI0_DATA18_MARK = 1139,
	IP8_31_28_MARK___3 = 1140,
	DIGRF_CLKOUT_MARK = 1141,
	DIGRF_CLKEN_OUT_MARK = 1142,
	IP9_31_28_MARK___3 = 1143,
	MSIOF0_SS2_MARK___3 = 1144,
	DU_DB1_MARK___3 = 1145,
	TCLK4_MARK = 1146,
	VI0_DATA19_MARK = 1147,
	SEL_CANFD0_0_MARK___3 = 1148,
	SEL_CANFD0_1_MARK___3 = 1149,
	SEL_GETHER_0_MARK = 1150,
	SEL_GETHER_1_MARK = 1151,
	SEL_HSCIF0_0_MARK = 1152,
	SEL_HSCIF0_1_MARK = 1153,
	SEL_PWM0_0_MARK = 1154,
	SEL_PWM0_1_MARK = 1155,
	SEL_PWM1_0_MARK___3 = 1156,
	SEL_PWM1_1_MARK___3 = 1157,
	SEL_PWM2_0_MARK___3 = 1158,
	SEL_PWM2_1_MARK___3 = 1159,
	SEL_PWM3_0_MARK___3 = 1160,
	SEL_PWM3_1_MARK___3 = 1161,
	SEL_PWM4_0_MARK___3 = 1162,
	SEL_PWM4_1_MARK___3 = 1163,
	SEL_RSP_0_MARK = 1164,
	SEL_RSP_1_MARK = 1165,
	SEL_SCIF1_0_MARK___3 = 1166,
	SEL_SCIF1_1_MARK___3 = 1167,
	SEL_TMU_0_MARK = 1168,
	SEL_TMU_1_MARK = 1169,
	PINMUX_MARK_END___3 = 1170,
};

enum {
	PINMUX_RESERVED___4 = 0,
	PINMUX_DATA_BEGIN___4 = 1,
	GP_0_0_DATA___4 = 2,
	GP_0_1_DATA___4 = 3,
	GP_0_2_DATA___4 = 4,
	GP_0_3_DATA___4 = 5,
	GP_0_4_DATA___4 = 6,
	GP_0_5_DATA___4 = 7,
	GP_0_6_DATA___4 = 8,
	GP_0_7_DATA___4 = 9,
	GP_0_8_DATA___4 = 10,
	GP_0_9_DATA___4 = 11,
	GP_0_10_DATA___4 = 12,
	GP_0_11_DATA___4 = 13,
	GP_0_12_DATA___4 = 14,
	GP_0_13_DATA___4 = 15,
	GP_0_14_DATA___4 = 16,
	GP_0_15_DATA___4 = 17,
	GP_1_0_DATA___4 = 18,
	GP_1_1_DATA___4 = 19,
	GP_1_2_DATA___4 = 20,
	GP_1_3_DATA___4 = 21,
	GP_1_4_DATA___4 = 22,
	GP_1_5_DATA___4 = 23,
	GP_1_6_DATA___4 = 24,
	GP_1_7_DATA___4 = 25,
	GP_1_8_DATA___4 = 26,
	GP_1_9_DATA___4 = 27,
	GP_1_10_DATA___4 = 28,
	GP_1_11_DATA___4 = 29,
	GP_1_12_DATA___4 = 30,
	GP_1_13_DATA___4 = 31,
	GP_1_14_DATA___4 = 32,
	GP_1_15_DATA___4 = 33,
	GP_1_16_DATA___4 = 34,
	GP_1_17_DATA___4 = 35,
	GP_1_18_DATA___4 = 36,
	GP_1_19_DATA___4 = 37,
	GP_1_20_DATA___4 = 38,
	GP_1_21_DATA___4 = 39,
	GP_1_22_DATA___4 = 40,
	GP_1_23_DATA___4 = 41,
	GP_1_24_DATA___4 = 42,
	GP_1_25_DATA___4 = 43,
	GP_1_26_DATA___4 = 44,
	GP_1_27_DATA___4 = 45,
	GP_1_28_DATA___3 = 46,
	GP_2_0_DATA___4 = 47,
	GP_2_1_DATA___4 = 48,
	GP_2_2_DATA___4 = 49,
	GP_2_3_DATA___4 = 50,
	GP_2_4_DATA___4 = 51,
	GP_2_5_DATA___4 = 52,
	GP_2_6_DATA___4 = 53,
	GP_2_7_DATA___4 = 54,
	GP_2_8_DATA___4 = 55,
	GP_2_9_DATA___4 = 56,
	GP_2_10_DATA___4 = 57,
	GP_2_11_DATA___4 = 58,
	GP_2_12_DATA___4 = 59,
	GP_2_13_DATA___4 = 60,
	GP_2_14_DATA___4 = 61,
	GP_3_0_DATA___4 = 62,
	GP_3_1_DATA___4 = 63,
	GP_3_2_DATA___4 = 64,
	GP_3_3_DATA___4 = 65,
	GP_3_4_DATA___4 = 66,
	GP_3_5_DATA___4 = 67,
	GP_3_6_DATA___4 = 68,
	GP_3_7_DATA___4 = 69,
	GP_3_8_DATA___4 = 70,
	GP_3_9_DATA___4 = 71,
	GP_3_10_DATA___4 = 72,
	GP_3_11_DATA___4 = 73,
	GP_3_12_DATA___4 = 74,
	GP_3_13_DATA___4 = 75,
	GP_3_14_DATA___4 = 76,
	GP_3_15_DATA___4 = 77,
	GP_4_0_DATA___4 = 78,
	GP_4_1_DATA___4 = 79,
	GP_4_2_DATA___4 = 80,
	GP_4_3_DATA___4 = 81,
	GP_4_4_DATA___4 = 82,
	GP_4_5_DATA___4 = 83,
	GP_4_6_DATA___4 = 84,
	GP_4_7_DATA___4 = 85,
	GP_4_8_DATA___4 = 86,
	GP_4_9_DATA___4 = 87,
	GP_4_10_DATA___4 = 88,
	GP_4_11_DATA___4 = 89,
	GP_4_12_DATA___4 = 90,
	GP_4_13_DATA___4 = 91,
	GP_4_14_DATA___4 = 92,
	GP_4_15_DATA___4 = 93,
	GP_4_16_DATA___4 = 94,
	GP_4_17_DATA___4 = 95,
	GP_5_0_DATA___4 = 96,
	GP_5_1_DATA___4 = 97,
	GP_5_2_DATA___4 = 98,
	GP_5_3_DATA___4 = 99,
	GP_5_4_DATA___4 = 100,
	GP_5_5_DATA___4 = 101,
	GP_5_6_DATA___4 = 102,
	GP_5_7_DATA___4 = 103,
	GP_5_8_DATA___4 = 104,
	GP_5_9_DATA___4 = 105,
	GP_5_10_DATA___4 = 106,
	GP_5_11_DATA___4 = 107,
	GP_5_12_DATA___4 = 108,
	GP_5_13_DATA___4 = 109,
	GP_5_14_DATA___4 = 110,
	GP_5_15_DATA___3 = 111,
	GP_5_16_DATA___3 = 112,
	GP_5_17_DATA___3 = 113,
	GP_5_18_DATA___3 = 114,
	GP_5_19_DATA___3 = 115,
	GP_5_20_DATA___3 = 116,
	GP_5_21_DATA___3 = 117,
	GP_5_22_DATA___3 = 118,
	GP_5_23_DATA___3 = 119,
	GP_5_24_DATA___3 = 120,
	GP_5_25_DATA___3 = 121,
	GP_6_0_DATA___3 = 122,
	GP_6_1_DATA___3 = 123,
	GP_6_2_DATA___3 = 124,
	GP_6_3_DATA___3 = 125,
	GP_6_4_DATA___3 = 126,
	GP_6_5_DATA___3 = 127,
	GP_6_6_DATA___3 = 128,
	GP_6_7_DATA___3 = 129,
	GP_6_8_DATA___3 = 130,
	GP_6_9_DATA___3 = 131,
	GP_6_10_DATA___3 = 132,
	GP_6_11_DATA___3 = 133,
	GP_6_12_DATA___3 = 134,
	GP_6_13_DATA___3 = 135,
	GP_6_14_DATA___3 = 136,
	GP_6_15_DATA___3 = 137,
	GP_6_16_DATA___3 = 138,
	GP_6_17_DATA___3 = 139,
	GP_6_18_DATA___3 = 140,
	GP_6_19_DATA___3 = 141,
	GP_6_20_DATA___3 = 142,
	GP_6_21_DATA___3 = 143,
	GP_6_22_DATA___3 = 144,
	GP_6_23_DATA___3 = 145,
	GP_6_24_DATA___3 = 146,
	GP_6_25_DATA___3 = 147,
	GP_6_26_DATA___3 = 148,
	GP_6_27_DATA___3 = 149,
	GP_6_28_DATA___3 = 150,
	GP_6_29_DATA___3 = 151,
	GP_6_30_DATA___3 = 152,
	GP_6_31_DATA___3 = 153,
	GP_7_0_DATA___3 = 154,
	GP_7_1_DATA___3 = 155,
	GP_7_2_DATA___3 = 156,
	GP_7_3_DATA___3 = 157,
	PINMUX_DATA_END___4 = 158,
	PINMUX_FUNCTION_BEGIN___4 = 159,
	GP_0_0_FN___4 = 160,
	GP_0_1_FN___4 = 161,
	GP_0_2_FN___4 = 162,
	GP_0_3_FN___4 = 163,
	GP_0_4_FN___4 = 164,
	GP_0_5_FN___4 = 165,
	GP_0_6_FN___4 = 166,
	GP_0_7_FN___4 = 167,
	GP_0_8_FN___4 = 168,
	GP_0_9_FN___4 = 169,
	GP_0_10_FN___4 = 170,
	GP_0_11_FN___4 = 171,
	GP_0_12_FN___4 = 172,
	GP_0_13_FN___4 = 173,
	GP_0_14_FN___4 = 174,
	GP_0_15_FN___4 = 175,
	GP_1_0_FN___4 = 176,
	GP_1_1_FN___4 = 177,
	GP_1_2_FN___4 = 178,
	GP_1_3_FN___4 = 179,
	GP_1_4_FN___4 = 180,
	GP_1_5_FN___4 = 181,
	GP_1_6_FN___4 = 182,
	GP_1_7_FN___4 = 183,
	GP_1_8_FN___4 = 184,
	GP_1_9_FN___4 = 185,
	GP_1_10_FN___4 = 186,
	GP_1_11_FN___4 = 187,
	GP_1_12_FN___4 = 188,
	GP_1_13_FN___4 = 189,
	GP_1_14_FN___4 = 190,
	GP_1_15_FN___4 = 191,
	GP_1_16_FN___4 = 192,
	GP_1_17_FN___4 = 193,
	GP_1_18_FN___4 = 194,
	GP_1_19_FN___4 = 195,
	GP_1_20_FN___4 = 196,
	GP_1_21_FN___4 = 197,
	GP_1_22_FN___4 = 198,
	GP_1_23_FN___4 = 199,
	GP_1_24_FN___4 = 200,
	GP_1_25_FN___4 = 201,
	GP_1_26_FN___4 = 202,
	GP_1_27_FN___4 = 203,
	GP_1_28_FN___3 = 204,
	GP_2_0_FN___4 = 205,
	GP_2_1_FN___4 = 206,
	GP_2_2_FN___4 = 207,
	GP_2_3_FN___4 = 208,
	GP_2_4_FN___4 = 209,
	GP_2_5_FN___4 = 210,
	GP_2_6_FN___4 = 211,
	GP_2_7_FN___4 = 212,
	GP_2_8_FN___4 = 213,
	GP_2_9_FN___4 = 214,
	GP_2_10_FN___4 = 215,
	GP_2_11_FN___4 = 216,
	GP_2_12_FN___4 = 217,
	GP_2_13_FN___4 = 218,
	GP_2_14_FN___4 = 219,
	GP_3_0_FN___4 = 220,
	GP_3_1_FN___4 = 221,
	GP_3_2_FN___4 = 222,
	GP_3_3_FN___4 = 223,
	GP_3_4_FN___4 = 224,
	GP_3_5_FN___4 = 225,
	GP_3_6_FN___4 = 226,
	GP_3_7_FN___4 = 227,
	GP_3_8_FN___4 = 228,
	GP_3_9_FN___4 = 229,
	GP_3_10_FN___4 = 230,
	GP_3_11_FN___4 = 231,
	GP_3_12_FN___4 = 232,
	GP_3_13_FN___4 = 233,
	GP_3_14_FN___4 = 234,
	GP_3_15_FN___4 = 235,
	GP_4_0_FN___4 = 236,
	GP_4_1_FN___4 = 237,
	GP_4_2_FN___4 = 238,
	GP_4_3_FN___4 = 239,
	GP_4_4_FN___4 = 240,
	GP_4_5_FN___4 = 241,
	GP_4_6_FN___4 = 242,
	GP_4_7_FN___4 = 243,
	GP_4_8_FN___4 = 244,
	GP_4_9_FN___4 = 245,
	GP_4_10_FN___4 = 246,
	GP_4_11_FN___4 = 247,
	GP_4_12_FN___4 = 248,
	GP_4_13_FN___4 = 249,
	GP_4_14_FN___4 = 250,
	GP_4_15_FN___4 = 251,
	GP_4_16_FN___4 = 252,
	GP_4_17_FN___4 = 253,
	GP_5_0_FN___4 = 254,
	GP_5_1_FN___4 = 255,
	GP_5_2_FN___4 = 256,
	GP_5_3_FN___4 = 257,
	GP_5_4_FN___4 = 258,
	GP_5_5_FN___4 = 259,
	GP_5_6_FN___4 = 260,
	GP_5_7_FN___4 = 261,
	GP_5_8_FN___4 = 262,
	GP_5_9_FN___4 = 263,
	GP_5_10_FN___4 = 264,
	GP_5_11_FN___4 = 265,
	GP_5_12_FN___4 = 266,
	GP_5_13_FN___4 = 267,
	GP_5_14_FN___4 = 268,
	GP_5_15_FN___3 = 269,
	GP_5_16_FN___3 = 270,
	GP_5_17_FN___3 = 271,
	GP_5_18_FN___3 = 272,
	GP_5_19_FN___3 = 273,
	GP_5_20_FN___3 = 274,
	GP_5_21_FN___3 = 275,
	GP_5_22_FN___3 = 276,
	GP_5_23_FN___3 = 277,
	GP_5_24_FN___3 = 278,
	GP_5_25_FN___3 = 279,
	GP_6_0_FN___3 = 280,
	GP_6_1_FN___3 = 281,
	GP_6_2_FN___3 = 282,
	GP_6_3_FN___3 = 283,
	GP_6_4_FN___3 = 284,
	GP_6_5_FN___3 = 285,
	GP_6_6_FN___3 = 286,
	GP_6_7_FN___3 = 287,
	GP_6_8_FN___3 = 288,
	GP_6_9_FN___3 = 289,
	GP_6_10_FN___3 = 290,
	GP_6_11_FN___3 = 291,
	GP_6_12_FN___3 = 292,
	GP_6_13_FN___3 = 293,
	GP_6_14_FN___3 = 294,
	GP_6_15_FN___3 = 295,
	GP_6_16_FN___3 = 296,
	GP_6_17_FN___3 = 297,
	GP_6_18_FN___3 = 298,
	GP_6_19_FN___3 = 299,
	GP_6_20_FN___3 = 300,
	GP_6_21_FN___3 = 301,
	GP_6_22_FN___3 = 302,
	GP_6_23_FN___3 = 303,
	GP_6_24_FN___3 = 304,
	GP_6_25_FN___3 = 305,
	GP_6_26_FN___3 = 306,
	GP_6_27_FN___3 = 307,
	GP_6_28_FN___3 = 308,
	GP_6_29_FN___3 = 309,
	GP_6_30_FN___3 = 310,
	GP_6_31_FN___3 = 311,
	GP_7_0_FN___3 = 312,
	GP_7_1_FN___3 = 313,
	GP_7_2_FN___3 = 314,
	GP_7_3_FN___3 = 315,
	FN_CLKOUT___4 = 316,
	FN_MSIOF0_RXD___4 = 317,
	FN_MSIOF0_TXD___4 = 318,
	FN_MSIOF0_SCK___4 = 319,
	FN_SSI_SDATA5___3 = 320,
	FN_SSI_WS5___3 = 321,
	FN_SSI_SCK5___3 = 322,
	FN_GP7_03___3 = 323,
	FN_GP7_02___3 = 324,
	FN_AVS2___3 = 325,
	FN_AVS1___3 = 326,
	FN_IP0_3_0___4 = 327,
	FN_AVB_MDC___4 = 328,
	FN_MSIOF2_SS2_C___3 = 329,
	FN_IP1_3_0___4 = 330,
	FN_IRQ2___4 = 331,
	FN_QCPV_QDE___3 = 332,
	FN_DU_EXODDF_DU_ODDF_DISP_CDE___4 = 333,
	FN_VI4_DATA2_B___3 = 334,
	FN_MSIOF3_SYNC_E___3 = 335,
	FN_PWM3_B___4 = 336,
	FN_IP2_3_0___4 = 337,
	FN_A1___4 = 338,
	FN_LCDOUT17___3 = 339,
	FN_MSIOF3_TXD_B___3 = 340,
	FN_VI4_DATA9___3 = 341,
	FN_DU_DB1___4 = 342,
	FN_PWM4_A___4 = 343,
	FN_IP3_3_0___4 = 344,
	FN_A9___4 = 345,
	FN_MSIOF2_SCK_A___3 = 346,
	FN_CTS4_N_B___3 = 347,
	FN_VI5_VSYNC_N___3 = 348,
	FN_IP0_7_4___4 = 349,
	FN_AVB_MAGIC___4 = 350,
	FN_MSIOF2_SS1_C___3 = 351,
	FN_SCK4_A___3 = 352,
	FN_IP1_7_4___4 = 353,
	FN_IRQ3___4 = 354,
	FN_QSTVB_QVE___3 = 355,
	FN_DU_DOTCLKOUT1___3 = 356,
	FN_VI4_DATA3_B___3 = 357,
	FN_MSIOF3_SCK_E___3 = 358,
	FN_PWM4_B___4 = 359,
	FN_IP2_7_4___4 = 360,
	FN_A2___4 = 361,
	FN_LCDOUT18___3 = 362,
	FN_MSIOF3_SCK_B___3 = 363,
	FN_VI4_DATA10___3 = 364,
	FN_DU_DB2___4 = 365,
	FN_PWM5_A___3 = 366,
	FN_IP3_7_4___4 = 367,
	FN_A10___4 = 368,
	FN_MSIOF2_RXD_A___3 = 369,
	FN_RTS4_N_B___3 = 370,
	FN_VI5_HSYNC_N___3 = 371,
	FN_IP0_11_8___4 = 372,
	FN_AVB_PHY_INT___4 = 373,
	FN_MSIOF2_SYNC_C___3 = 374,
	FN_RX4_A___3 = 375,
	FN_IP1_11_8___4 = 376,
	FN_IRQ4___4 = 377,
	FN_QSTH_QHS___3 = 378,
	FN_DU_EXHSYNC_DU_HSYNC___4 = 379,
	FN_VI4_DATA4_B___3 = 380,
	FN_MSIOF3_RXD_E___3 = 381,
	FN_PWM5_B___3 = 382,
	FN_IP2_11_8___4 = 383,
	FN_A3___4 = 384,
	FN_LCDOUT19___3 = 385,
	FN_MSIOF3_RXD_B___3 = 386,
	FN_VI4_DATA11___3 = 387,
	FN_DU_DB3___4 = 388,
	FN_PWM6_A___3 = 389,
	FN_IP3_11_8___4 = 390,
	FN_A11___4 = 391,
	FN_TX3_B___3 = 392,
	FN_MSIOF2_TXD_A___3 = 393,
	FN_HTX4_B___3 = 394,
	FN_HSCK4___3 = 395,
	FN_VI5_FIELD___3 = 396,
	FN_SCL6_A___3 = 397,
	FN_AVB_AVTP_CAPTURE_B___3 = 398,
	FN_PWM2_B___4 = 399,
	FN_IP0_15_12___4 = 400,
	FN_AVB_LINK___4 = 401,
	FN_MSIOF2_SCK_C___3 = 402,
	FN_TX4_A___3 = 403,
	FN_IP1_15_12___4 = 404,
	FN_IRQ5___4 = 405,
	FN_QSTB_QHE___3 = 406,
	FN_DU_EXVSYNC_DU_VSYNC___4 = 407,
	FN_VI4_DATA5_B___3 = 408,
	FN_FSCLKST2_N_B___2 = 409,
	FN_MSIOF3_TXD_E___3 = 410,
	FN_PWM6_B___3 = 411,
	FN_IP2_15_12___4 = 412,
	FN_A4___4 = 413,
	FN_LCDOUT20___3 = 414,
	FN_MSIOF3_SS1_B___3 = 415,
	FN_VI4_DATA12___3 = 416,
	FN_VI5_DATA12___3 = 417,
	FN_DU_DB4___4 = 418,
	FN_IP3_15_12___4 = 419,
	FN_A12___4 = 420,
	FN_LCDOUT12___3 = 421,
	FN_MSIOF3_SCK_C___3 = 422,
	FN_HRX4_A___3 = 423,
	FN_VI5_DATA8___3 = 424,
	FN_DU_DG4___4 = 425,
	FN_IP0_19_16___4 = 426,
	FN_AVB_AVTP_MATCH_A___3 = 427,
	FN_MSIOF2_RXD_C___3 = 428,
	FN_CTS4_N_A___3 = 429,
	FN_FSCLKST2_N_A___2 = 430,
	FN_IP1_19_16___4 = 431,
	FN_PWM0___3 = 432,
	FN_AVB_AVTP_PPS___4 = 433,
	FN_VI4_DATA6_B___3 = 434,
	FN_IECLK_B___3 = 435,
	FN_IP2_19_16___4 = 436,
	FN_A5___4 = 437,
	FN_LCDOUT21___3 = 438,
	FN_MSIOF3_SS2_B___3 = 439,
	FN_SCK4_B___3 = 440,
	FN_VI4_DATA13___3 = 441,
	FN_VI5_DATA13___3 = 442,
	FN_DU_DB5___4 = 443,
	FN_IP3_19_16___4 = 444,
	FN_A13___4 = 445,
	FN_LCDOUT13___3 = 446,
	FN_MSIOF3_SYNC_C___3 = 447,
	FN_HTX4_A___3 = 448,
	FN_VI5_DATA9___3 = 449,
	FN_DU_DG5___4 = 450,
	FN_IP0_23_20___4 = 451,
	FN_AVB_AVTP_CAPTURE_A___3 = 452,
	FN_MSIOF2_TXD_C___3 = 453,
	FN_RTS4_N_A___3 = 454,
	FN_IP1_23_20___4 = 455,
	FN_PWM1_A___4 = 456,
	FN_HRX3_D___3 = 457,
	FN_VI4_DATA7_B___3 = 458,
	FN_IERX_B___3 = 459,
	FN_IP2_23_20___4 = 460,
	FN_A6___4 = 461,
	FN_LCDOUT22___3 = 462,
	FN_MSIOF2_SS1_A___3 = 463,
	FN_RX4_B___3 = 464,
	FN_VI4_DATA14___3 = 465,
	FN_VI5_DATA14___3 = 466,
	FN_DU_DB6___4 = 467,
	FN_IP3_23_20___4 = 468,
	FN_A14___4 = 469,
	FN_LCDOUT14___3 = 470,
	FN_MSIOF3_RXD_C___3 = 471,
	FN_HCTS4_N___3 = 472,
	FN_VI5_DATA10___3 = 473,
	FN_DU_DG6___4 = 474,
	FN_IP0_27_24___4 = 475,
	FN_IRQ0___4 = 476,
	FN_QPOLB___3 = 477,
	FN_DU_CDE___4 = 478,
	FN_VI4_DATA0_B___3 = 479,
	FN_CAN0_TX_B___3 = 480,
	FN_CANFD0_TX_B___4 = 481,
	FN_MSIOF3_SS2_E___3 = 482,
	FN_IP1_27_24___4 = 483,
	FN_PWM2_A___4 = 484,
	FN_HTX3_D___3 = 485,
	FN_IETX_B___3 = 486,
	FN_IP2_27_24___4 = 487,
	FN_A7___4 = 488,
	FN_LCDOUT23___3 = 489,
	FN_MSIOF2_SS2_A___3 = 490,
	FN_TX4_B___3 = 491,
	FN_VI4_DATA15___3 = 492,
	FN_VI5_DATA15___3 = 493,
	FN_DU_DB7___4 = 494,
	FN_IP3_27_24___4 = 495,
	FN_A15___4 = 496,
	FN_LCDOUT15___3 = 497,
	FN_MSIOF3_TXD_C___3 = 498,
	FN_HRTS4_N___3 = 499,
	FN_VI5_DATA11___3 = 500,
	FN_DU_DG7___4 = 501,
	FN_IP0_31_28___4 = 502,
	FN_IRQ1___4 = 503,
	FN_QPOLA___3 = 504,
	FN_DU_DISP___4 = 505,
	FN_VI4_DATA1_B___3 = 506,
	FN_CAN0_RX_B___3 = 507,
	FN_CANFD0_RX_B___4 = 508,
	FN_MSIOF3_SS1_E___3 = 509,
	FN_IP1_31_28___4 = 510,
	FN_A0___4 = 511,
	FN_LCDOUT16___3 = 512,
	FN_MSIOF3_SYNC_B___3 = 513,
	FN_VI4_DATA8___3 = 514,
	FN_DU_DB0___4 = 515,
	FN_PWM3_A___4 = 516,
	FN_IP2_31_28___4 = 517,
	FN_A8___4 = 518,
	FN_RX3_B___3 = 519,
	FN_MSIOF2_SYNC_A___3 = 520,
	FN_HRX4_B___3 = 521,
	FN_SDA6_A___3 = 522,
	FN_AVB_AVTP_MATCH_B___3 = 523,
	FN_PWM1_B___4 = 524,
	FN_IP3_31_28___4 = 525,
	FN_A16___4 = 526,
	FN_LCDOUT8___3 = 527,
	FN_VI4_FIELD___3 = 528,
	FN_DU_DG0___4 = 529,
	FN_IP4_3_0___4 = 530,
	FN_A17___4 = 531,
	FN_LCDOUT9___3 = 532,
	FN_VI4_VSYNC_N___3 = 533,
	FN_DU_DG1___4 = 534,
	FN_IP5_3_0___4 = 535,
	FN_WE0_N___4 = 536,
	FN_MSIOF3_TXD_D___3 = 537,
	FN_CTS3_N___4 = 538,
	FN_HCTS3_N___4 = 539,
	FN_SCL6_B___3 = 540,
	FN_CAN_CLK___3 = 541,
	FN_IECLK_A___3 = 542,
	FN_IP6_3_0___4 = 543,
	FN_D5___4 = 544,
	FN_MSIOF2_SYNC_B___3 = 545,
	FN_VI4_DATA21___3 = 546,
	FN_VI5_DATA5___3 = 547,
	FN_IP7_3_0___4 = 548,
	FN_D13___4 = 549,
	FN_LCDOUT5___3 = 550,
	FN_MSIOF2_SS2_D___3 = 551,
	FN_TX4_C___3 = 552,
	FN_VI4_DATA5_A___3 = 553,
	FN_DU_DR5___4 = 554,
	FN_IP4_7_4___4 = 555,
	FN_A18___4 = 556,
	FN_LCDOUT10___3 = 557,
	FN_VI4_HSYNC_N___3 = 558,
	FN_DU_DG2___4 = 559,
	FN_IP5_7_4___4 = 560,
	FN_WE1_N___4 = 561,
	FN_MSIOF3_SS1_D___3 = 562,
	FN_RTS3_N___4 = 563,
	FN_HRTS3_N___4 = 564,
	FN_SDA6_B___3 = 565,
	FN_CAN1_RX___3 = 566,
	FN_CANFD1_RX___4 = 567,
	FN_IERX_A___3 = 568,
	FN_IP6_7_4___4 = 569,
	FN_D6___4 = 570,
	FN_MSIOF2_RXD_B___3 = 571,
	FN_VI4_DATA22___3 = 572,
	FN_VI5_DATA6___3 = 573,
	FN_IP7_7_4___4 = 574,
	FN_D14___4 = 575,
	FN_LCDOUT6___3 = 576,
	FN_MSIOF3_SS1_A___3 = 577,
	FN_HRX3_C___3 = 578,
	FN_VI4_DATA6_A___3 = 579,
	FN_DU_DR6___4 = 580,
	FN_SCL6_C___3 = 581,
	FN_IP4_11_8___4 = 582,
	FN_A19___4 = 583,
	FN_LCDOUT11___3 = 584,
	FN_VI4_CLKENB___3 = 585,
	FN_DU_DG3___4 = 586,
	FN_IP5_11_8___4 = 587,
	FN_EX_WAIT0_A___3 = 588,
	FN_QCLK___3 = 589,
	FN_VI4_CLK___3 = 590,
	FN_DU_DOTCLKOUT0___3 = 591,
	FN_IP6_11_8___4 = 592,
	FN_D7___4 = 593,
	FN_MSIOF2_TXD_B___3 = 594,
	FN_VI4_DATA23___3 = 595,
	FN_VI5_DATA7___3 = 596,
	FN_IP7_11_8___4 = 597,
	FN_D15___4 = 598,
	FN_LCDOUT7___3 = 599,
	FN_MSIOF3_SS2_A___3 = 600,
	FN_HTX3_C___3 = 601,
	FN_VI4_DATA7_A___3 = 602,
	FN_DU_DR7___4 = 603,
	FN_SDA6_C___3 = 604,
	FN_IP4_15_12___4 = 605,
	FN_CS0_N___4 = 606,
	FN_VI5_CLKENB___3 = 607,
	FN_IP5_15_12___4 = 608,
	FN_D0___4 = 609,
	FN_MSIOF2_SS1_B___3 = 610,
	FN_MSIOF3_SCK_A___3 = 611,
	FN_VI4_DATA16___3 = 612,
	FN_VI5_DATA0___3 = 613,
	FN_IP6_15_12___4 = 614,
	FN_D8___4 = 615,
	FN_LCDOUT0___3 = 616,
	FN_MSIOF2_SCK_D___3 = 617,
	FN_SCK4_C___3 = 618,
	FN_VI4_DATA0_A___3 = 619,
	FN_DU_DR0___4 = 620,
	FN_IP4_19_16___4 = 621,
	FN_CS1_N___4 = 622,
	FN_VI5_CLK___3 = 623,
	FN_EX_WAIT0_B___3 = 624,
	FN_IP5_19_16___4 = 625,
	FN_D1___4 = 626,
	FN_MSIOF2_SS2_B___3 = 627,
	FN_MSIOF3_SYNC_A___3 = 628,
	FN_VI4_DATA17___3 = 629,
	FN_VI5_DATA1___3 = 630,
	FN_IP6_19_16___4 = 631,
	FN_D9___4 = 632,
	FN_LCDOUT1___3 = 633,
	FN_MSIOF2_SYNC_D___3 = 634,
	FN_VI4_DATA1_A___3 = 635,
	FN_DU_DR1___4 = 636,
	FN_IP7_19_16___4 = 637,
	FN_SD0_CLK___3 = 638,
	FN_MSIOF1_SCK_E___3 = 639,
	FN_STP_OPWM_0_B___3 = 640,
	FN_IP4_23_20___4 = 641,
	FN_BS_N___4 = 642,
	FN_QSTVA_QVS___3 = 643,
	FN_MSIOF3_SCK_D___3 = 644,
	FN_SCK3___4 = 645,
	FN_HSCK3___4 = 646,
	FN_CAN1_TX___3 = 647,
	FN_CANFD1_TX___4 = 648,
	FN_IETX_A___3 = 649,
	FN_IP5_23_20___4 = 650,
	FN_D2___4 = 651,
	FN_MSIOF3_RXD_A___3 = 652,
	FN_VI4_DATA18___3 = 653,
	FN_VI5_DATA2___3 = 654,
	FN_IP6_23_20___4 = 655,
	FN_D10___4 = 656,
	FN_LCDOUT2___3 = 657,
	FN_MSIOF2_RXD_D___3 = 658,
	FN_HRX3_B___3 = 659,
	FN_VI4_DATA2_A___3 = 660,
	FN_CTS4_N_C___3 = 661,
	FN_DU_DR2___4 = 662,
	FN_IP7_23_20___4 = 663,
	FN_SD0_CMD___3 = 664,
	FN_MSIOF1_SYNC_E___3 = 665,
	FN_STP_IVCXO27_0_B___3 = 666,
	FN_IP4_27_24___4 = 667,
	FN_RD_N___4 = 668,
	FN_MSIOF3_SYNC_D___3 = 669,
	FN_RX3_A___3 = 670,
	FN_HRX3_A___3 = 671,
	FN_CAN0_TX_A___3 = 672,
	FN_CANFD0_TX_A___4 = 673,
	FN_IP5_27_24___4 = 674,
	FN_D3___4 = 675,
	FN_MSIOF3_TXD_A___3 = 676,
	FN_VI4_DATA19___3 = 677,
	FN_VI5_DATA3___3 = 678,
	FN_IP6_27_24___4 = 679,
	FN_D11___4 = 680,
	FN_LCDOUT3___3 = 681,
	FN_MSIOF2_TXD_D___3 = 682,
	FN_HTX3_B___3 = 683,
	FN_VI4_DATA3_A___3 = 684,
	FN_RTS4_N_C___3 = 685,
	FN_DU_DR3___4 = 686,
	FN_IP7_27_24___4 = 687,
	FN_SD0_DAT0___3 = 688,
	FN_MSIOF1_RXD_E___3 = 689,
	FN_TS_SCK0_B___3 = 690,
	FN_STP_ISCLK_0_B___3 = 691,
	FN_IP4_31_28___4 = 692,
	FN_RD_WR_N___4 = 693,
	FN_MSIOF3_RXD_D___3 = 694,
	FN_TX3_A___3 = 695,
	FN_HTX3_A___3 = 696,
	FN_CAN0_RX_A___3 = 697,
	FN_CANFD0_RX_A___4 = 698,
	FN_IP5_31_28___4 = 699,
	FN_D4___4 = 700,
	FN_MSIOF2_SCK_B___3 = 701,
	FN_VI4_DATA20___3 = 702,
	FN_VI5_DATA4___3 = 703,
	FN_IP6_31_28___4 = 704,
	FN_D12___4 = 705,
	FN_LCDOUT4___3 = 706,
	FN_MSIOF2_SS1_D___3 = 707,
	FN_RX4_C___3 = 708,
	FN_VI4_DATA4_A___3 = 709,
	FN_DU_DR4___4 = 710,
	FN_IP7_31_28___4 = 711,
	FN_SD0_DAT1___3 = 712,
	FN_MSIOF1_TXD_E___3 = 713,
	FN_TS_SPSYNC0_B___3 = 714,
	FN_STP_ISSYNC_0_B___3 = 715,
	FN_IP8_3_0___4 = 716,
	FN_SD0_DAT2___3 = 717,
	FN_MSIOF1_SS1_E___3 = 718,
	FN_TS_SDAT0_B___3 = 719,
	FN_STP_ISD_0_B___3 = 720,
	FN_IP9_3_0___4 = 721,
	FN_SD2_CLK___3 = 722,
	FN_NFDATA8___3 = 723,
	FN_IP10_3_0___4 = 724,
	FN_SD3_CMD___3 = 725,
	FN_NFRE_N___3 = 726,
	FN_IP11_3_0___3 = 727,
	FN_SD3_DAT7___3 = 728,
	FN_SD3_WP___3 = 729,
	FN_NFDATA7___3 = 730,
	FN_IP8_7_4___4 = 731,
	FN_SD0_DAT3___3 = 732,
	FN_MSIOF1_SS2_E___3 = 733,
	FN_TS_SDEN0_B___3 = 734,
	FN_STP_ISEN_0_B___3 = 735,
	FN_IP9_7_4___4 = 736,
	FN_SD2_CMD___3 = 737,
	FN_NFDATA9___3 = 738,
	FN_IP10_7_4___4 = 739,
	FN_SD3_DAT0___3 = 740,
	FN_NFDATA0___3 = 741,
	FN_IP11_7_4___3 = 742,
	FN_SD3_DS___3 = 743,
	FN_NFCLE___3 = 744,
	FN_IP8_11_8___4 = 745,
	FN_SD1_CLK___3 = 746,
	FN_MSIOF1_SCK_G___3 = 747,
	FN_SIM0_CLK_A___3 = 748,
	FN_IP9_11_8___4 = 749,
	FN_SD2_DAT0___3 = 750,
	FN_NFDATA10___3 = 751,
	FN_IP10_11_8___4 = 752,
	FN_SD3_DAT1___3 = 753,
	FN_NFDATA1___3 = 754,
	FN_IP11_11_8___3 = 755,
	FN_SD0_CD___3 = 756,
	FN_NFDATA14_A___3 = 757,
	FN_SCL2_B___3 = 758,
	FN_SIM0_RST_A___3 = 759,
	FN_IP8_15_12___4 = 760,
	FN_SD1_CMD___3 = 761,
	FN_MSIOF1_SYNC_G___3 = 762,
	FN_NFCE_N_B___3 = 763,
	FN_SIM0_D_A___3 = 764,
	FN_STP_IVCXO27_1_B___3 = 765,
	FN_IP9_15_12___4 = 766,
	FN_SD2_DAT1___3 = 767,
	FN_NFDATA11___3 = 768,
	FN_IP10_15_12___4 = 769,
	FN_SD3_DAT2___3 = 770,
	FN_NFDATA2___3 = 771,
	FN_IP11_15_12___3 = 772,
	FN_SD0_WP___3 = 773,
	FN_NFDATA15_A___3 = 774,
	FN_SDA2_B___3 = 775,
	FN_IP8_19_16___4 = 776,
	FN_SD1_DAT0___3 = 777,
	FN_SD2_DAT4___3 = 778,
	FN_MSIOF1_RXD_G___3 = 779,
	FN_NFWP_N_B___3 = 780,
	FN_TS_SCK1_B___3 = 781,
	FN_STP_ISCLK_1_B___3 = 782,
	FN_IP9_19_16___4 = 783,
	FN_SD2_DAT2___3 = 784,
	FN_NFDATA12___3 = 785,
	FN_IP10_19_16___4 = 786,
	FN_SD3_DAT3___3 = 787,
	FN_NFDATA3___3 = 788,
	FN_IP11_19_16___3 = 789,
	FN_SD1_CD___3 = 790,
	FN_NFRB_N_A___3 = 791,
	FN_SIM0_CLK_B___3 = 792,
	FN_IP8_23_20___4 = 793,
	FN_SD1_DAT1___3 = 794,
	FN_SD2_DAT5___3 = 795,
	FN_MSIOF1_TXD_G___3 = 796,
	FN_NFDATA14_B___3 = 797,
	FN_TS_SPSYNC1_B___3 = 798,
	FN_STP_ISSYNC_1_B___3 = 799,
	FN_IP9_23_20___4 = 800,
	FN_SD2_DAT3___3 = 801,
	FN_NFDATA13___3 = 802,
	FN_IP10_23_20___3 = 803,
	FN_SD3_DAT4___3 = 804,
	FN_SD2_CD_A___3 = 805,
	FN_NFDATA4___3 = 806,
	FN_IP11_23_20___3 = 807,
	FN_SD1_WP___3 = 808,
	FN_NFCE_N_A___3 = 809,
	FN_SIM0_D_B___3 = 810,
	FN_IP8_27_24___4 = 811,
	FN_SD1_DAT2___3 = 812,
	FN_SD2_DAT6___3 = 813,
	FN_MSIOF1_SS1_G___3 = 814,
	FN_NFDATA15_B___3 = 815,
	FN_TS_SDAT1_B___3 = 816,
	FN_STP_ISD_1_B___3 = 817,
	FN_IP9_27_24___4 = 818,
	FN_SD2_DS___3 = 819,
	FN_NFALE___3 = 820,
	FN_SATA_DEVSLP_B___2 = 821,
	FN_IP10_27_24___3 = 822,
	FN_SD3_DAT5___3 = 823,
	FN_SD2_WP_A___3 = 824,
	FN_NFDATA5___3 = 825,
	FN_IP11_27_24___3 = 826,
	FN_SCK0___4 = 827,
	FN_HSCK1_B___3 = 828,
	FN_MSIOF1_SS2_B___3 = 829,
	FN_AUDIO_CLKC_B___3 = 830,
	FN_SDA2_A___3 = 831,
	FN_SIM0_RST_B___3 = 832,
	FN_STP_OPWM_0_C___3 = 833,
	FN_RIF0_CLK_B___3 = 834,
	FN_ADICHS2___3 = 835,
	FN_SCK5_B___3 = 836,
	FN_IP8_31_28___4 = 837,
	FN_SD1_DAT3___3 = 838,
	FN_SD2_DAT7___3 = 839,
	FN_MSIOF1_SS2_G___3 = 840,
	FN_NFRB_N_B___3 = 841,
	FN_TS_SDEN1_B___3 = 842,
	FN_STP_ISEN_1_B___3 = 843,
	FN_IP9_31_28___4 = 844,
	FN_SD3_CLK___3 = 845,
	FN_NFWE_N___3 = 846,
	FN_IP10_31_28___3 = 847,
	FN_SD3_DAT6___3 = 848,
	FN_SD3_CD___3 = 849,
	FN_NFDATA6___3 = 850,
	FN_IP11_31_28___3 = 851,
	FN_RX0___4 = 852,
	FN_HRX1_B___3 = 853,
	FN_TS_SCK0_C___3 = 854,
	FN_STP_ISCLK_0_C___3 = 855,
	FN_RIF0_D0_B___3 = 856,
	FN_IP12_3_0___3 = 857,
	FN_TX0___4 = 858,
	FN_HTX1_B___3 = 859,
	FN_TS_SPSYNC0_C___3 = 860,
	FN_STP_ISSYNC_0_C___3 = 861,
	FN_RIF0_D1_B___3 = 862,
	FN_IP13_3_0___3 = 863,
	FN_TX2_A___3 = 864,
	FN_SD2_CD_B___3 = 865,
	FN_SCL1_A___3 = 866,
	FN_FMCLK_A___3 = 867,
	FN_RIF1_D1_C___3 = 868,
	FN_FSO_CFE_0_N___4 = 869,
	FN_IP14_3_0___3 = 870,
	FN_MSIOF0_SS1___4 = 871,
	FN_RX5_A___3 = 872,
	FN_NFWP_N_A___3 = 873,
	FN_AUDIO_CLKA_C___3 = 874,
	FN_SSI_SCK2_A___3 = 875,
	FN_STP_IVCXO27_0_C___3 = 876,
	FN_AUDIO_CLKOUT3_A___3 = 877,
	FN_TCLK1_B___4 = 878,
	FN_IP15_3_0___3 = 879,
	FN_SSI_SDATA1_A___3 = 880,
	FN_IP12_7_4___3 = 881,
	FN_CTS0_N___4 = 882,
	FN_HCTS1_N_B___3 = 883,
	FN_MSIOF1_SYNC_B___3 = 884,
	FN_TS_SPSYNC1_C___3 = 885,
	FN_STP_ISSYNC_1_C___3 = 886,
	FN_RIF1_SYNC_B___3 = 887,
	FN_AUDIO_CLKOUT_C___3 = 888,
	FN_ADICS_SAMP___3 = 889,
	FN_IP13_7_4___3 = 890,
	FN_RX2_A___3 = 891,
	FN_SD2_WP_B___3 = 892,
	FN_SDA1_A___3 = 893,
	FN_FMIN_A___3 = 894,
	FN_RIF1_SYNC_C___3 = 895,
	FN_FSO_CFE_1_N___4 = 896,
	FN_IP14_7_4___3 = 897,
	FN_MSIOF0_SS2___4 = 898,
	FN_TX5_A___3 = 899,
	FN_MSIOF1_SS2_D___3 = 900,
	FN_AUDIO_CLKC_A___3 = 901,
	FN_SSI_WS2_A___3 = 902,
	FN_STP_OPWM_0_D___3 = 903,
	FN_AUDIO_CLKOUT_D___3 = 904,
	FN_SPEEDIN_B___4 = 905,
	FN_IP15_7_4___3 = 906,
	FN_SSI_SDATA2_A___3 = 907,
	FN_SSI_SCK1_B___3 = 908,
	FN_IP12_11_8___3 = 909,
	FN_RTS0_N___4 = 910,
	FN_HRTS1_N_B___3 = 911,
	FN_MSIOF1_SS1_B___3 = 912,
	FN_AUDIO_CLKA_B___3 = 913,
	FN_SCL2_A___3 = 914,
	FN_STP_IVCXO27_1_C___3 = 915,
	FN_RIF0_SYNC_B___3 = 916,
	FN_ADICHS1___3 = 917,
	FN_IP13_11_8___3 = 918,
	FN_HSCK0___3 = 919,
	FN_MSIOF1_SCK_D___3 = 920,
	FN_AUDIO_CLKB_A___3 = 921,
	FN_SSI_SDATA1_B___3 = 922,
	FN_TS_SCK0_D___3 = 923,
	FN_STP_ISCLK_0_D___3 = 924,
	FN_RIF0_CLK_C___3 = 925,
	FN_RX5_B___3 = 926,
	FN_IP14_11_8___3 = 927,
	FN_MLB_CLK___3 = 928,
	FN_MSIOF1_SCK_F___3 = 929,
	FN_SCL1_B___3 = 930,
	FN_IP15_11_8___3 = 931,
	FN_SSI_SCK349___3 = 932,
	FN_MSIOF1_SS1_A___3 = 933,
	FN_STP_OPWM_0_A___3 = 934,
	FN_IP12_15_12___3 = 935,
	FN_RX1_A___4 = 936,
	FN_HRX1_A___3 = 937,
	FN_TS_SDAT0_C___3 = 938,
	FN_STP_ISD_0_C___3 = 939,
	FN_RIF1_CLK_C___3 = 940,
	FN_IP13_15_12___3 = 941,
	FN_HRX0___3 = 942,
	FN_MSIOF1_RXD_D___3 = 943,
	FN_SSI_SDATA2_B___3 = 944,
	FN_TS_SDEN0_D___3 = 945,
	FN_STP_ISEN_0_D___3 = 946,
	FN_RIF0_D0_C___3 = 947,
	FN_IP14_15_12___3 = 948,
	FN_MLB_SIG___3 = 949,
	FN_RX1_B___4 = 950,
	FN_MSIOF1_SYNC_F___3 = 951,
	FN_SDA1_B___3 = 952,
	FN_IP15_15_12___3 = 953,
	FN_SSI_WS349___3 = 954,
	FN_HCTS2_N_A___3 = 955,
	FN_MSIOF1_SS2_A___3 = 956,
	FN_STP_IVCXO27_0_A___3 = 957,
	FN_IP12_19_16___3 = 958,
	FN_TX1_A___4 = 959,
	FN_HTX1_A___3 = 960,
	FN_TS_SDEN0_C___3 = 961,
	FN_STP_ISEN_0_C___3 = 962,
	FN_RIF1_D0_C___3 = 963,
	FN_IP13_19_16___3 = 964,
	FN_HTX0___3 = 965,
	FN_MSIOF1_TXD_D___3 = 966,
	FN_SSI_SDATA9_B___3 = 967,
	FN_TS_SDAT0_D___3 = 968,
	FN_STP_ISD_0_D___3 = 969,
	FN_RIF0_D1_C___3 = 970,
	FN_IP14_19_16___3 = 971,
	FN_MLB_DAT___3 = 972,
	FN_TX1_B___4 = 973,
	FN_MSIOF1_RXD_F___3 = 974,
	FN_IP15_19_16___3 = 975,
	FN_SSI_SDATA3___3 = 976,
	FN_HRTS2_N_A___3 = 977,
	FN_MSIOF1_TXD_A___3 = 978,
	FN_TS_SCK0_A___3 = 979,
	FN_STP_ISCLK_0_A___3 = 980,
	FN_RIF0_D1_A___3 = 981,
	FN_RIF2_D0_A___3 = 982,
	FN_IP12_23_20___3 = 983,
	FN_CTS1_N___4 = 984,
	FN_HCTS1_N_A___3 = 985,
	FN_MSIOF1_RXD_B___3 = 986,
	FN_TS_SDEN1_C___3 = 987,
	FN_STP_ISEN_1_C___3 = 988,
	FN_RIF1_D0_B___3 = 989,
	FN_ADIDATA___3 = 990,
	FN_IP13_23_20___3 = 991,
	FN_HCTS0_N___3 = 992,
	FN_RX2_B___3 = 993,
	FN_MSIOF1_SYNC_D___3 = 994,
	FN_SSI_SCK9_A___3 = 995,
	FN_TS_SPSYNC0_D___3 = 996,
	FN_STP_ISSYNC_0_D___3 = 997,
	FN_RIF0_SYNC_C___3 = 998,
	FN_AUDIO_CLKOUT1_A___3 = 999,
	FN_IP14_23_20___3 = 1000,
	FN_SSI_SCK01239___3 = 1001,
	FN_MSIOF1_TXD_F___3 = 1002,
	FN_IP15_23_20___3 = 1003,
	FN_SSI_SCK4___3 = 1004,
	FN_HRX2_A___3 = 1005,
	FN_MSIOF1_SCK_A___3 = 1006,
	FN_TS_SDAT0_A___3 = 1007,
	FN_STP_ISD_0_A___3 = 1008,
	FN_RIF0_CLK_A___3 = 1009,
	FN_RIF2_CLK_A___3 = 1010,
	FN_IP12_27_24___3 = 1011,
	FN_RTS1_N___4 = 1012,
	FN_HRTS1_N_A___3 = 1013,
	FN_MSIOF1_TXD_B___3 = 1014,
	FN_TS_SDAT1_C___3 = 1015,
	FN_STP_ISD_1_C___3 = 1016,
	FN_RIF1_D1_B___3 = 1017,
	FN_ADICHS0___3 = 1018,
	FN_IP13_27_24___3 = 1019,
	FN_HRTS0_N___3 = 1020,
	FN_TX2_B___3 = 1021,
	FN_MSIOF1_SS1_D___3 = 1022,
	FN_SSI_WS9_A___3 = 1023,
	FN_STP_IVCXO27_0_D___3 = 1024,
	FN_BPFCLK_A___3 = 1025,
	FN_AUDIO_CLKOUT2_A___3 = 1026,
	FN_IP14_27_24___3 = 1027,
	FN_SSI_WS01239___3 = 1028,
	FN_MSIOF1_SS1_F___3 = 1029,
	FN_IP15_27_24___3 = 1030,
	FN_SSI_WS4___3 = 1031,
	FN_HTX2_A___3 = 1032,
	FN_MSIOF1_SYNC_A___3 = 1033,
	FN_TS_SDEN0_A___3 = 1034,
	FN_STP_ISEN_0_A___3 = 1035,
	FN_RIF0_SYNC_A___3 = 1036,
	FN_RIF2_SYNC_A___3 = 1037,
	FN_IP12_31_28___3 = 1038,
	FN_SCK2___3 = 1039,
	FN_SCIF_CLK_B___4 = 1040,
	FN_MSIOF1_SCK_B___3 = 1041,
	FN_TS_SCK1_C___3 = 1042,
	FN_STP_ISCLK_1_C___3 = 1043,
	FN_RIF1_CLK_B___3 = 1044,
	FN_ADICLK___3 = 1045,
	FN_IP13_31_28___3 = 1046,
	FN_MSIOF0_SYNC___4 = 1047,
	FN_AUDIO_CLKOUT_A___3 = 1048,
	FN_TX5_B___3 = 1049,
	FN_BPFCLK_D___3 = 1050,
	FN_IP14_31_28___3 = 1051,
	FN_SSI_SDATA0___3 = 1052,
	FN_MSIOF1_SS2_F___3 = 1053,
	FN_IP15_31_28___3 = 1054,
	FN_SSI_SDATA4___3 = 1055,
	FN_HSCK2_A___3 = 1056,
	FN_MSIOF1_RXD_A___3 = 1057,
	FN_TS_SPSYNC0_A___3 = 1058,
	FN_STP_ISSYNC_0_A___3 = 1059,
	FN_RIF0_D0_A___3 = 1060,
	FN_RIF2_D1_A___3 = 1061,
	FN_IP16_3_0___3 = 1062,
	FN_SSI_SCK6___3 = 1063,
	FN_SIM0_RST_D___3 = 1064,
	FN_IP17_3_0___3 = 1065,
	FN_AUDIO_CLKA_A___3 = 1066,
	FN_IP18_3_0___3 = 1067,
	FN_GP6_30___2 = 1068,
	FN_AUDIO_CLKOUT2_B___3 = 1069,
	FN_SSI_SCK9_B___3 = 1070,
	FN_TS_SDEN0_E___3 = 1071,
	FN_STP_ISEN_0_E___3 = 1072,
	FN_RIF2_D0_B___3 = 1073,
	FN_TPU0TO2___4 = 1074,
	FN_FMCLK_C___3 = 1075,
	FN_FMCLK_D___3 = 1076,
	FN_IP16_7_4___3 = 1077,
	FN_SSI_WS6___3 = 1078,
	FN_SIM0_D_D___3 = 1079,
	FN_IP17_7_4___3 = 1080,
	FN_AUDIO_CLKB_B___3 = 1081,
	FN_SCIF_CLK_A___4 = 1082,
	FN_STP_IVCXO27_1_D___3 = 1083,
	FN_REMOCON_A___3 = 1084,
	FN_TCLK1_A___4 = 1085,
	FN_IP18_7_4___3 = 1086,
	FN_GP6_31___2 = 1087,
	FN_AUDIO_CLKOUT3_B___3 = 1088,
	FN_SSI_WS9_B___3 = 1089,
	FN_TS_SPSYNC0_E___3 = 1090,
	FN_STP_ISSYNC_0_E___3 = 1091,
	FN_RIF2_D1_B___3 = 1092,
	FN_TPU0TO3___4 = 1093,
	FN_FMIN_C___3 = 1094,
	FN_FMIN_D___3 = 1095,
	FN_IP16_11_8___3 = 1096,
	FN_SSI_SDATA6___3 = 1097,
	FN_SIM0_CLK_D___3 = 1098,
	FN_SATA_DEVSLP_A___2 = 1099,
	FN_IP17_11_8___3 = 1100,
	FN_USB0_PWEN___3 = 1101,
	FN_SIM0_RST_C___3 = 1102,
	FN_TS_SCK1_D___3 = 1103,
	FN_STP_ISCLK_1_D___3 = 1104,
	FN_BPFCLK_B___3 = 1105,
	FN_RIF3_CLK_B___3 = 1106,
	FN_HSCK2_C___3 = 1107,
	FN_IP16_15_12___3 = 1108,
	FN_SSI_SCK78___3 = 1109,
	FN_HRX2_B___3 = 1110,
	FN_MSIOF1_SCK_C___3 = 1111,
	FN_TS_SCK1_A___3 = 1112,
	FN_STP_ISCLK_1_A___3 = 1113,
	FN_RIF1_CLK_A___3 = 1114,
	FN_RIF3_CLK_A___3 = 1115,
	FN_IP17_15_12___3 = 1116,
	FN_USB0_OVC___3 = 1117,
	FN_SIM0_D_C___3 = 1118,
	FN_TS_SDAT1_D___3 = 1119,
	FN_STP_ISD_1_D___3 = 1120,
	FN_RIF3_SYNC_B___3 = 1121,
	FN_HRX2_C___3 = 1122,
	FN_IP16_19_16___3 = 1123,
	FN_SSI_WS78___3 = 1124,
	FN_HTX2_B___3 = 1125,
	FN_MSIOF1_SYNC_C___3 = 1126,
	FN_TS_SDAT1_A___3 = 1127,
	FN_STP_ISD_1_A___3 = 1128,
	FN_RIF1_SYNC_A___3 = 1129,
	FN_RIF3_SYNC_A___3 = 1130,
	FN_IP17_19_16___3 = 1131,
	FN_USB1_PWEN___3 = 1132,
	FN_SIM0_CLK_C___3 = 1133,
	FN_SSI_SCK1_A___3 = 1134,
	FN_TS_SCK0_E___3 = 1135,
	FN_STP_ISCLK_0_E___3 = 1136,
	FN_FMCLK_B___3 = 1137,
	FN_RIF2_CLK_B___3 = 1138,
	FN_SPEEDIN_A___4 = 1139,
	FN_HTX2_C___3 = 1140,
	FN_IP16_23_20___3 = 1141,
	FN_SSI_SDATA7___3 = 1142,
	FN_HCTS2_N_B___3 = 1143,
	FN_MSIOF1_RXD_C___3 = 1144,
	FN_TS_SDEN1_A___3 = 1145,
	FN_STP_ISEN_1_A___3 = 1146,
	FN_RIF1_D0_A___3 = 1147,
	FN_RIF3_D0_A___3 = 1148,
	FN_TCLK2_A___4 = 1149,
	FN_IP17_23_20___3 = 1150,
	FN_USB1_OVC___3 = 1151,
	FN_MSIOF1_SS2_C___3 = 1152,
	FN_SSI_WS1_A___3 = 1153,
	FN_TS_SDAT0_E___3 = 1154,
	FN_STP_ISD_0_E___3 = 1155,
	FN_FMIN_B___3 = 1156,
	FN_RIF2_SYNC_B___3 = 1157,
	FN_REMOCON_B___3 = 1158,
	FN_HCTS2_N_C___3 = 1159,
	FN_IP16_27_24___3 = 1160,
	FN_SSI_SDATA8___3 = 1161,
	FN_HRTS2_N_B___3 = 1162,
	FN_MSIOF1_TXD_C___3 = 1163,
	FN_TS_SPSYNC1_A___3 = 1164,
	FN_STP_ISSYNC_1_A___3 = 1165,
	FN_RIF1_D1_A___3 = 1166,
	FN_RIF3_D1_A___3 = 1167,
	FN_IP17_27_24___3 = 1168,
	FN_USB30_PWEN___3 = 1169,
	FN_AUDIO_CLKOUT_B___3 = 1170,
	FN_SSI_SCK2_B___3 = 1171,
	FN_TS_SDEN1_D___3 = 1172,
	FN_STP_ISEN_1_D___3 = 1173,
	FN_STP_OPWM_0_E___3 = 1174,
	FN_RIF3_D0_B___3 = 1175,
	FN_TCLK2_B___4 = 1176,
	FN_TPU0TO0___4 = 1177,
	FN_BPFCLK_C___3 = 1178,
	FN_HRTS2_N_C___3 = 1179,
	FN_IP16_31_28___3 = 1180,
	FN_SSI_SDATA9_A___3 = 1181,
	FN_HSCK2_B___3 = 1182,
	FN_MSIOF1_SS1_C___3 = 1183,
	FN_HSCK1_A___3 = 1184,
	FN_SSI_WS1_B___3 = 1185,
	FN_SCK1___4 = 1186,
	FN_STP_IVCXO27_1_A___3 = 1187,
	FN_SCK5_A___3 = 1188,
	FN_IP17_31_28___3 = 1189,
	FN_USB30_OVC___3 = 1190,
	FN_AUDIO_CLKOUT1_B___3 = 1191,
	FN_SSI_WS2_B___3 = 1192,
	FN_TS_SPSYNC1_D___3 = 1193,
	FN_STP_ISSYNC_1_D___3 = 1194,
	FN_STP_IVCXO27_0_E___3 = 1195,
	FN_RIF3_D1_B___3 = 1196,
	FN_FSO_TOE_N___4 = 1197,
	FN_TPU0TO1___4 = 1198,
	FN_SEL_MSIOF3_0___3 = 1199,
	FN_SEL_MSIOF3_1___3 = 1200,
	FN_SEL_MSIOF3_2___3 = 1201,
	FN_SEL_MSIOF3_3___3 = 1202,
	FN_SEL_MSIOF3_4___3 = 1203,
	FN_SEL_TSIF1_0___3 = 1204,
	FN_SEL_TSIF1_1___3 = 1205,
	FN_SEL_TSIF1_2___3 = 1206,
	FN_SEL_TSIF1_3___3 = 1207,
	FN_I2C_SEL_5_0___3 = 1208,
	FN_I2C_SEL_5_1___3 = 1209,
	FN_I2C_SEL_3_0___3 = 1210,
	FN_I2C_SEL_3_1___3 = 1211,
	FN_SEL_TSIF0_0___3 = 1212,
	FN_SEL_TSIF0_1___3 = 1213,
	FN_SEL_TSIF0_2___3 = 1214,
	FN_SEL_TSIF0_3___3 = 1215,
	FN_SEL_TSIF0_4___3 = 1216,
	FN_I2C_SEL_0_0___3 = 1217,
	FN_I2C_SEL_0_1___3 = 1218,
	FN_SEL_MSIOF2_0___3 = 1219,
	FN_SEL_MSIOF2_1___3 = 1220,
	FN_SEL_MSIOF2_2___3 = 1221,
	FN_SEL_MSIOF2_3___3 = 1222,
	FN_SEL_FM_0___3 = 1223,
	FN_SEL_FM_1___3 = 1224,
	FN_SEL_FM_2___3 = 1225,
	FN_SEL_FM_3___3 = 1226,
	FN_SEL_MSIOF1_0___3 = 1227,
	FN_SEL_MSIOF1_1___3 = 1228,
	FN_SEL_MSIOF1_2___3 = 1229,
	FN_SEL_MSIOF1_3___3 = 1230,
	FN_SEL_MSIOF1_4___3 = 1231,
	FN_SEL_MSIOF1_5___3 = 1232,
	FN_SEL_MSIOF1_6___3 = 1233,
	FN_SEL_TIMER_TMU_0___2 = 1234,
	FN_SEL_TIMER_TMU_1___2 = 1235,
	FN_SEL_SCIF5_0___3 = 1236,
	FN_SEL_SCIF5_1___3 = 1237,
	FN_SEL_SSP1_1_0___3 = 1238,
	FN_SEL_SSP1_1_1___3 = 1239,
	FN_SEL_SSP1_1_2___3 = 1240,
	FN_SEL_SSP1_1_3___3 = 1241,
	FN_SEL_I2C6_0___3 = 1242,
	FN_SEL_I2C6_1___3 = 1243,
	FN_SEL_I2C6_2___3 = 1244,
	FN_SEL_LBSC_0___3 = 1245,
	FN_SEL_LBSC_1___3 = 1246,
	FN_SEL_SSP1_0_0___3 = 1247,
	FN_SEL_SSP1_0_1___3 = 1248,
	FN_SEL_SSP1_0_2___3 = 1249,
	FN_SEL_SSP1_0_3___3 = 1250,
	FN_SEL_SSP1_0_4___3 = 1251,
	FN_SEL_IEBUS_0___3 = 1252,
	FN_SEL_IEBUS_1___3 = 1253,
	FN_SEL_NDF_0___2 = 1254,
	FN_SEL_NDF_1___2 = 1255,
	FN_SEL_I2C2_0___3 = 1256,
	FN_SEL_I2C2_1___3 = 1257,
	FN_SEL_SSI2_0___3 = 1258,
	FN_SEL_SSI2_1___3 = 1259,
	FN_SEL_I2C1_0___3 = 1260,
	FN_SEL_I2C1_1___3 = 1261,
	FN_SEL_SSI1_0___3 = 1262,
	FN_SEL_SSI1_1___3 = 1263,
	FN_SEL_SSI9_0___3 = 1264,
	FN_SEL_SSI9_1___3 = 1265,
	FN_SEL_HSCIF4_0___3 = 1266,
	FN_SEL_HSCIF4_1___3 = 1267,
	FN_SEL_SPEED_PULSE_0___3 = 1268,
	FN_SEL_SPEED_PULSE_1___3 = 1269,
	FN_SEL_TIMER_TMU2_0___3 = 1270,
	FN_SEL_TIMER_TMU2_1___3 = 1271,
	FN_SEL_HSCIF3_0___3 = 1272,
	FN_SEL_HSCIF3_1___3 = 1273,
	FN_SEL_HSCIF3_2___3 = 1274,
	FN_SEL_HSCIF3_3___3 = 1275,
	FN_SEL_SIMCARD_0___3 = 1276,
	FN_SEL_SIMCARD_1___3 = 1277,
	FN_SEL_SIMCARD_2___3 = 1278,
	FN_SEL_SIMCARD_3___3 = 1279,
	FN_SEL_ADGB_0___3 = 1280,
	FN_SEL_ADGB_1___3 = 1281,
	FN_SEL_ADGC_0___3 = 1282,
	FN_SEL_ADGC_1___3 = 1283,
	FN_SEL_HSCIF1_0___3 = 1284,
	FN_SEL_HSCIF1_1___3 = 1285,
	FN_SEL_SDHI2_0___3 = 1286,
	FN_SEL_SDHI2_1___3 = 1287,
	FN_SEL_SCIF4_0___3 = 1288,
	FN_SEL_SCIF4_1___3 = 1289,
	FN_SEL_SCIF4_2___3 = 1290,
	FN_SEL_HSCIF2_0___3 = 1291,
	FN_SEL_HSCIF2_1___3 = 1292,
	FN_SEL_HSCIF2_2___3 = 1293,
	FN_SEL_SCIF3_0___3 = 1294,
	FN_SEL_SCIF3_1___3 = 1295,
	FN_SEL_ETHERAVB_0___3 = 1296,
	FN_SEL_ETHERAVB_1___3 = 1297,
	FN_SEL_SCIF2_0___3 = 1298,
	FN_SEL_SCIF2_1___3 = 1299,
	FN_SEL_DRIF3_0___3 = 1300,
	FN_SEL_DRIF3_1___3 = 1301,
	FN_SEL_SCIF1_0___4 = 1302,
	FN_SEL_SCIF1_1___4 = 1303,
	FN_SEL_DRIF2_0___3 = 1304,
	FN_SEL_DRIF2_1___3 = 1305,
	FN_SEL_SCIF_0___3 = 1306,
	FN_SEL_SCIF_1___3 = 1307,
	FN_SEL_DRIF1_0___3 = 1308,
	FN_SEL_DRIF1_1___3 = 1309,
	FN_SEL_DRIF1_2___3 = 1310,
	FN_SEL_REMOCON_0___3 = 1311,
	FN_SEL_REMOCON_1___3 = 1312,
	FN_SEL_DRIF0_0___3 = 1313,
	FN_SEL_DRIF0_1___3 = 1314,
	FN_SEL_DRIF0_2___3 = 1315,
	FN_SEL_RCAN0_0___3 = 1316,
	FN_SEL_RCAN0_1___3 = 1317,
	FN_SEL_CANFD0_0___4 = 1318,
	FN_SEL_CANFD0_1___4 = 1319,
	FN_SEL_PWM6_0___3 = 1320,
	FN_SEL_PWM6_1___3 = 1321,
	FN_SEL_ADGA_0___3 = 1322,
	FN_SEL_ADGA_1___3 = 1323,
	FN_SEL_ADGA_2___3 = 1324,
	FN_SEL_ADGA_3___3 = 1325,
	FN_SEL_PWM5_0___3 = 1326,
	FN_SEL_PWM5_1___3 = 1327,
	FN_SEL_PWM4_0___4 = 1328,
	FN_SEL_PWM4_1___4 = 1329,
	FN_SEL_PWM3_0___4 = 1330,
	FN_SEL_PWM3_1___4 = 1331,
	FN_SEL_PWM2_0___4 = 1332,
	FN_SEL_PWM2_1___4 = 1333,
	FN_SEL_PWM1_0___4 = 1334,
	FN_SEL_PWM1_1___4 = 1335,
	FN_SEL_VIN4_0___3 = 1336,
	FN_SEL_VIN4_1___3 = 1337,
	PINMUX_FUNCTION_END___4 = 1338,
	PINMUX_MARK_BEGIN___4 = 1339,
	CLKOUT_MARK___4 = 1340,
	MSIOF0_RXD_MARK___4 = 1341,
	MSIOF0_TXD_MARK___4 = 1342,
	MSIOF0_SCK_MARK___4 = 1343,
	SSI_SDATA5_MARK___3 = 1344,
	SSI_WS5_MARK___3 = 1345,
	SSI_SCK5_MARK___3 = 1346,
	GP7_03_MARK___3 = 1347,
	GP7_02_MARK___3 = 1348,
	AVS2_MARK___3 = 1349,
	AVS1_MARK___3 = 1350,
	IP0_3_0_MARK___4 = 1351,
	AVB_MDC_MARK___4 = 1352,
	MSIOF2_SS2_C_MARK___3 = 1353,
	IP1_3_0_MARK___4 = 1354,
	IRQ2_MARK___4 = 1355,
	QCPV_QDE_MARK___3 = 1356,
	DU_EXODDF_DU_ODDF_DISP_CDE_MARK___4 = 1357,
	VI4_DATA2_B_MARK___3 = 1358,
	MSIOF3_SYNC_E_MARK___3 = 1359,
	PWM3_B_MARK___4 = 1360,
	IP2_3_0_MARK___4 = 1361,
	A1_MARK___4 = 1362,
	LCDOUT17_MARK___3 = 1363,
	MSIOF3_TXD_B_MARK___3 = 1364,
	VI4_DATA9_MARK___3 = 1365,
	DU_DB1_MARK___4 = 1366,
	PWM4_A_MARK___4 = 1367,
	IP3_3_0_MARK___4 = 1368,
	A9_MARK___4 = 1369,
	MSIOF2_SCK_A_MARK___3 = 1370,
	CTS4_N_B_MARK___3 = 1371,
	VI5_VSYNC_N_MARK___3 = 1372,
	IP0_7_4_MARK___4 = 1373,
	AVB_MAGIC_MARK___4 = 1374,
	MSIOF2_SS1_C_MARK___3 = 1375,
	SCK4_A_MARK___3 = 1376,
	IP1_7_4_MARK___4 = 1377,
	IRQ3_MARK___4 = 1378,
	QSTVB_QVE_MARK___3 = 1379,
	DU_DOTCLKOUT1_MARK___3 = 1380,
	VI4_DATA3_B_MARK___3 = 1381,
	MSIOF3_SCK_E_MARK___3 = 1382,
	PWM4_B_MARK___4 = 1383,
	IP2_7_4_MARK___4 = 1384,
	A2_MARK___4 = 1385,
	LCDOUT18_MARK___3 = 1386,
	MSIOF3_SCK_B_MARK___3 = 1387,
	VI4_DATA10_MARK___3 = 1388,
	DU_DB2_MARK___4 = 1389,
	PWM5_A_MARK___3 = 1390,
	IP3_7_4_MARK___4 = 1391,
	A10_MARK___4 = 1392,
	MSIOF2_RXD_A_MARK___3 = 1393,
	RTS4_N_B_MARK___3 = 1394,
	VI5_HSYNC_N_MARK___3 = 1395,
	IP0_11_8_MARK___4 = 1396,
	AVB_PHY_INT_MARK___4 = 1397,
	MSIOF2_SYNC_C_MARK___3 = 1398,
	RX4_A_MARK___3 = 1399,
	IP1_11_8_MARK___4 = 1400,
	IRQ4_MARK___4 = 1401,
	QSTH_QHS_MARK___3 = 1402,
	DU_EXHSYNC_DU_HSYNC_MARK___4 = 1403,
	VI4_DATA4_B_MARK___3 = 1404,
	MSIOF3_RXD_E_MARK___3 = 1405,
	PWM5_B_MARK___3 = 1406,
	IP2_11_8_MARK___4 = 1407,
	A3_MARK___4 = 1408,
	LCDOUT19_MARK___3 = 1409,
	MSIOF3_RXD_B_MARK___3 = 1410,
	VI4_DATA11_MARK___3 = 1411,
	DU_DB3_MARK___4 = 1412,
	PWM6_A_MARK___3 = 1413,
	IP3_11_8_MARK___4 = 1414,
	A11_MARK___4 = 1415,
	TX3_B_MARK___3 = 1416,
	MSIOF2_TXD_A_MARK___3 = 1417,
	HTX4_B_MARK___3 = 1418,
	HSCK4_MARK___3 = 1419,
	VI5_FIELD_MARK___3 = 1420,
	SCL6_A_MARK___3 = 1421,
	AVB_AVTP_CAPTURE_B_MARK___3 = 1422,
	PWM2_B_MARK___4 = 1423,
	IP0_15_12_MARK___4 = 1424,
	AVB_LINK_MARK___4 = 1425,
	MSIOF2_SCK_C_MARK___3 = 1426,
	TX4_A_MARK___3 = 1427,
	IP1_15_12_MARK___4 = 1428,
	IRQ5_MARK___4 = 1429,
	QSTB_QHE_MARK___3 = 1430,
	DU_EXVSYNC_DU_VSYNC_MARK___4 = 1431,
	VI4_DATA5_B_MARK___3 = 1432,
	FSCLKST2_N_B_MARK___2 = 1433,
	MSIOF3_TXD_E_MARK___3 = 1434,
	PWM6_B_MARK___3 = 1435,
	IP2_15_12_MARK___4 = 1436,
	A4_MARK___4 = 1437,
	LCDOUT20_MARK___3 = 1438,
	MSIOF3_SS1_B_MARK___3 = 1439,
	VI4_DATA12_MARK___3 = 1440,
	VI5_DATA12_MARK___3 = 1441,
	DU_DB4_MARK___4 = 1442,
	IP3_15_12_MARK___4 = 1443,
	A12_MARK___4 = 1444,
	LCDOUT12_MARK___3 = 1445,
	MSIOF3_SCK_C_MARK___3 = 1446,
	HRX4_A_MARK___3 = 1447,
	VI5_DATA8_MARK___3 = 1448,
	DU_DG4_MARK___4 = 1449,
	IP0_19_16_MARK___4 = 1450,
	AVB_AVTP_MATCH_A_MARK___3 = 1451,
	MSIOF2_RXD_C_MARK___3 = 1452,
	CTS4_N_A_MARK___3 = 1453,
	FSCLKST2_N_A_MARK___2 = 1454,
	IP1_19_16_MARK___4 = 1455,
	PWM0_MARK___3 = 1456,
	AVB_AVTP_PPS_MARK___4 = 1457,
	VI4_DATA6_B_MARK___3 = 1458,
	IECLK_B_MARK___3 = 1459,
	IP2_19_16_MARK___4 = 1460,
	A5_MARK___4 = 1461,
	LCDOUT21_MARK___3 = 1462,
	MSIOF3_SS2_B_MARK___3 = 1463,
	SCK4_B_MARK___3 = 1464,
	VI4_DATA13_MARK___3 = 1465,
	VI5_DATA13_MARK___3 = 1466,
	DU_DB5_MARK___4 = 1467,
	IP3_19_16_MARK___4 = 1468,
	A13_MARK___4 = 1469,
	LCDOUT13_MARK___3 = 1470,
	MSIOF3_SYNC_C_MARK___3 = 1471,
	HTX4_A_MARK___3 = 1472,
	VI5_DATA9_MARK___3 = 1473,
	DU_DG5_MARK___4 = 1474,
	IP0_23_20_MARK___4 = 1475,
	AVB_AVTP_CAPTURE_A_MARK___3 = 1476,
	MSIOF2_TXD_C_MARK___3 = 1477,
	RTS4_N_A_MARK___3 = 1478,
	IP1_23_20_MARK___4 = 1479,
	PWM1_A_MARK___4 = 1480,
	HRX3_D_MARK___3 = 1481,
	VI4_DATA7_B_MARK___3 = 1482,
	IERX_B_MARK___3 = 1483,
	IP2_23_20_MARK___4 = 1484,
	A6_MARK___4 = 1485,
	LCDOUT22_MARK___3 = 1486,
	MSIOF2_SS1_A_MARK___3 = 1487,
	RX4_B_MARK___3 = 1488,
	VI4_DATA14_MARK___3 = 1489,
	VI5_DATA14_MARK___3 = 1490,
	DU_DB6_MARK___4 = 1491,
	IP3_23_20_MARK___4 = 1492,
	A14_MARK___4 = 1493,
	LCDOUT14_MARK___3 = 1494,
	MSIOF3_RXD_C_MARK___3 = 1495,
	HCTS4_N_MARK___3 = 1496,
	VI5_DATA10_MARK___3 = 1497,
	DU_DG6_MARK___4 = 1498,
	IP0_27_24_MARK___4 = 1499,
	IRQ0_MARK___4 = 1500,
	QPOLB_MARK___3 = 1501,
	DU_CDE_MARK___4 = 1502,
	VI4_DATA0_B_MARK___3 = 1503,
	CAN0_TX_B_MARK___3 = 1504,
	CANFD0_TX_B_MARK___4 = 1505,
	MSIOF3_SS2_E_MARK___3 = 1506,
	IP1_27_24_MARK___4 = 1507,
	PWM2_A_MARK___4 = 1508,
	HTX3_D_MARK___3 = 1509,
	IETX_B_MARK___3 = 1510,
	IP2_27_24_MARK___4 = 1511,
	A7_MARK___4 = 1512,
	LCDOUT23_MARK___3 = 1513,
	MSIOF2_SS2_A_MARK___3 = 1514,
	TX4_B_MARK___3 = 1515,
	VI4_DATA15_MARK___3 = 1516,
	VI5_DATA15_MARK___3 = 1517,
	DU_DB7_MARK___4 = 1518,
	IP3_27_24_MARK___4 = 1519,
	A15_MARK___4 = 1520,
	LCDOUT15_MARK___3 = 1521,
	MSIOF3_TXD_C_MARK___3 = 1522,
	HRTS4_N_MARK___3 = 1523,
	VI5_DATA11_MARK___3 = 1524,
	DU_DG7_MARK___4 = 1525,
	IP0_31_28_MARK___4 = 1526,
	IRQ1_MARK___4 = 1527,
	QPOLA_MARK___3 = 1528,
	DU_DISP_MARK___4 = 1529,
	VI4_DATA1_B_MARK___3 = 1530,
	CAN0_RX_B_MARK___3 = 1531,
	CANFD0_RX_B_MARK___4 = 1532,
	MSIOF3_SS1_E_MARK___3 = 1533,
	IP1_31_28_MARK___4 = 1534,
	A0_MARK___4 = 1535,
	LCDOUT16_MARK___3 = 1536,
	MSIOF3_SYNC_B_MARK___3 = 1537,
	VI4_DATA8_MARK___3 = 1538,
	DU_DB0_MARK___4 = 1539,
	PWM3_A_MARK___4 = 1540,
	IP2_31_28_MARK___4 = 1541,
	A8_MARK___4 = 1542,
	RX3_B_MARK___3 = 1543,
	MSIOF2_SYNC_A_MARK___3 = 1544,
	HRX4_B_MARK___3 = 1545,
	SDA6_A_MARK___3 = 1546,
	AVB_AVTP_MATCH_B_MARK___3 = 1547,
	PWM1_B_MARK___4 = 1548,
	IP3_31_28_MARK___4 = 1549,
	A16_MARK___4 = 1550,
	LCDOUT8_MARK___3 = 1551,
	VI4_FIELD_MARK___3 = 1552,
	DU_DG0_MARK___4 = 1553,
	IP4_3_0_MARK___4 = 1554,
	A17_MARK___4 = 1555,
	LCDOUT9_MARK___3 = 1556,
	VI4_VSYNC_N_MARK___3 = 1557,
	DU_DG1_MARK___4 = 1558,
	IP5_3_0_MARK___4 = 1559,
	WE0_N_MARK___4 = 1560,
	MSIOF3_TXD_D_MARK___3 = 1561,
	CTS3_N_MARK___4 = 1562,
	HCTS3_N_MARK___4 = 1563,
	SCL6_B_MARK___3 = 1564,
	CAN_CLK_MARK___3 = 1565,
	IECLK_A_MARK___3 = 1566,
	IP6_3_0_MARK___4 = 1567,
	D5_MARK___4 = 1568,
	MSIOF2_SYNC_B_MARK___3 = 1569,
	VI4_DATA21_MARK___3 = 1570,
	VI5_DATA5_MARK___3 = 1571,
	IP7_3_0_MARK___4 = 1572,
	D13_MARK___4 = 1573,
	LCDOUT5_MARK___3 = 1574,
	MSIOF2_SS2_D_MARK___3 = 1575,
	TX4_C_MARK___3 = 1576,
	VI4_DATA5_A_MARK___3 = 1577,
	DU_DR5_MARK___4 = 1578,
	IP4_7_4_MARK___4 = 1579,
	A18_MARK___4 = 1580,
	LCDOUT10_MARK___3 = 1581,
	VI4_HSYNC_N_MARK___3 = 1582,
	DU_DG2_MARK___4 = 1583,
	IP5_7_4_MARK___4 = 1584,
	WE1_N_MARK___4 = 1585,
	MSIOF3_SS1_D_MARK___3 = 1586,
	RTS3_N_MARK___4 = 1587,
	HRTS3_N_MARK___4 = 1588,
	SDA6_B_MARK___3 = 1589,
	CAN1_RX_MARK___3 = 1590,
	CANFD1_RX_MARK___4 = 1591,
	IERX_A_MARK___3 = 1592,
	IP6_7_4_MARK___4 = 1593,
	D6_MARK___4 = 1594,
	MSIOF2_RXD_B_MARK___3 = 1595,
	VI4_DATA22_MARK___3 = 1596,
	VI5_DATA6_MARK___3 = 1597,
	IP7_7_4_MARK___4 = 1598,
	D14_MARK___4 = 1599,
	LCDOUT6_MARK___3 = 1600,
	MSIOF3_SS1_A_MARK___3 = 1601,
	HRX3_C_MARK___3 = 1602,
	VI4_DATA6_A_MARK___3 = 1603,
	DU_DR6_MARK___4 = 1604,
	SCL6_C_MARK___3 = 1605,
	IP4_11_8_MARK___4 = 1606,
	A19_MARK___4 = 1607,
	LCDOUT11_MARK___3 = 1608,
	VI4_CLKENB_MARK___3 = 1609,
	DU_DG3_MARK___4 = 1610,
	IP5_11_8_MARK___4 = 1611,
	EX_WAIT0_A_MARK___3 = 1612,
	QCLK_MARK___3 = 1613,
	VI4_CLK_MARK___3 = 1614,
	DU_DOTCLKOUT0_MARK___3 = 1615,
	IP6_11_8_MARK___4 = 1616,
	D7_MARK___4 = 1617,
	MSIOF2_TXD_B_MARK___3 = 1618,
	VI4_DATA23_MARK___3 = 1619,
	VI5_DATA7_MARK___3 = 1620,
	IP7_11_8_MARK___4 = 1621,
	D15_MARK___4 = 1622,
	LCDOUT7_MARK___3 = 1623,
	MSIOF3_SS2_A_MARK___3 = 1624,
	HTX3_C_MARK___3 = 1625,
	VI4_DATA7_A_MARK___3 = 1626,
	DU_DR7_MARK___4 = 1627,
	SDA6_C_MARK___3 = 1628,
	IP4_15_12_MARK___4 = 1629,
	CS0_N_MARK___4 = 1630,
	VI5_CLKENB_MARK___3 = 1631,
	IP5_15_12_MARK___4 = 1632,
	D0_MARK___4 = 1633,
	MSIOF2_SS1_B_MARK___3 = 1634,
	MSIOF3_SCK_A_MARK___3 = 1635,
	VI4_DATA16_MARK___3 = 1636,
	VI5_DATA0_MARK___3 = 1637,
	IP6_15_12_MARK___4 = 1638,
	D8_MARK___4 = 1639,
	LCDOUT0_MARK___3 = 1640,
	MSIOF2_SCK_D_MARK___3 = 1641,
	SCK4_C_MARK___3 = 1642,
	VI4_DATA0_A_MARK___3 = 1643,
	DU_DR0_MARK___4 = 1644,
	IP4_19_16_MARK___4 = 1645,
	CS1_N_MARK___4 = 1646,
	VI5_CLK_MARK___3 = 1647,
	EX_WAIT0_B_MARK___3 = 1648,
	IP5_19_16_MARK___4 = 1649,
	D1_MARK___4 = 1650,
	MSIOF2_SS2_B_MARK___3 = 1651,
	MSIOF3_SYNC_A_MARK___3 = 1652,
	VI4_DATA17_MARK___3 = 1653,
	VI5_DATA1_MARK___3 = 1654,
	IP6_19_16_MARK___4 = 1655,
	D9_MARK___4 = 1656,
	LCDOUT1_MARK___3 = 1657,
	MSIOF2_SYNC_D_MARK___3 = 1658,
	VI4_DATA1_A_MARK___3 = 1659,
	DU_DR1_MARK___4 = 1660,
	IP7_19_16_MARK___4 = 1661,
	SD0_CLK_MARK___3 = 1662,
	MSIOF1_SCK_E_MARK___3 = 1663,
	STP_OPWM_0_B_MARK___3 = 1664,
	IP4_23_20_MARK___4 = 1665,
	BS_N_MARK___4 = 1666,
	QSTVA_QVS_MARK___3 = 1667,
	MSIOF3_SCK_D_MARK___3 = 1668,
	SCK3_MARK___4 = 1669,
	HSCK3_MARK___4 = 1670,
	CAN1_TX_MARK___3 = 1671,
	CANFD1_TX_MARK___4 = 1672,
	IETX_A_MARK___3 = 1673,
	IP5_23_20_MARK___4 = 1674,
	D2_MARK___4 = 1675,
	MSIOF3_RXD_A_MARK___3 = 1676,
	VI4_DATA18_MARK___3 = 1677,
	VI5_DATA2_MARK___3 = 1678,
	IP6_23_20_MARK___4 = 1679,
	D10_MARK___4 = 1680,
	LCDOUT2_MARK___3 = 1681,
	MSIOF2_RXD_D_MARK___3 = 1682,
	HRX3_B_MARK___3 = 1683,
	VI4_DATA2_A_MARK___3 = 1684,
	CTS4_N_C_MARK___3 = 1685,
	DU_DR2_MARK___4 = 1686,
	IP7_23_20_MARK___4 = 1687,
	SD0_CMD_MARK___3 = 1688,
	MSIOF1_SYNC_E_MARK___3 = 1689,
	STP_IVCXO27_0_B_MARK___3 = 1690,
	IP4_27_24_MARK___4 = 1691,
	RD_N_MARK___4 = 1692,
	MSIOF3_SYNC_D_MARK___3 = 1693,
	RX3_A_MARK___3 = 1694,
	HRX3_A_MARK___3 = 1695,
	CAN0_TX_A_MARK___3 = 1696,
	CANFD0_TX_A_MARK___4 = 1697,
	IP5_27_24_MARK___4 = 1698,
	D3_MARK___4 = 1699,
	MSIOF3_TXD_A_MARK___3 = 1700,
	VI4_DATA19_MARK___3 = 1701,
	VI5_DATA3_MARK___3 = 1702,
	IP6_27_24_MARK___4 = 1703,
	D11_MARK___4 = 1704,
	LCDOUT3_MARK___3 = 1705,
	MSIOF2_TXD_D_MARK___3 = 1706,
	HTX3_B_MARK___3 = 1707,
	VI4_DATA3_A_MARK___3 = 1708,
	RTS4_N_C_MARK___3 = 1709,
	DU_DR3_MARK___4 = 1710,
	IP7_27_24_MARK___4 = 1711,
	SD0_DAT0_MARK___3 = 1712,
	MSIOF1_RXD_E_MARK___3 = 1713,
	TS_SCK0_B_MARK___3 = 1714,
	STP_ISCLK_0_B_MARK___3 = 1715,
	IP4_31_28_MARK___4 = 1716,
	RD_WR_N_MARK___4 = 1717,
	MSIOF3_RXD_D_MARK___3 = 1718,
	TX3_A_MARK___3 = 1719,
	HTX3_A_MARK___3 = 1720,
	CAN0_RX_A_MARK___3 = 1721,
	CANFD0_RX_A_MARK___4 = 1722,
	IP5_31_28_MARK___4 = 1723,
	D4_MARK___4 = 1724,
	MSIOF2_SCK_B_MARK___3 = 1725,
	VI4_DATA20_MARK___3 = 1726,
	VI5_DATA4_MARK___3 = 1727,
	IP6_31_28_MARK___4 = 1728,
	D12_MARK___4 = 1729,
	LCDOUT4_MARK___3 = 1730,
	MSIOF2_SS1_D_MARK___3 = 1731,
	RX4_C_MARK___3 = 1732,
	VI4_DATA4_A_MARK___3 = 1733,
	DU_DR4_MARK___4 = 1734,
	IP7_31_28_MARK___4 = 1735,
	SD0_DAT1_MARK___3 = 1736,
	MSIOF1_TXD_E_MARK___3 = 1737,
	TS_SPSYNC0_B_MARK___3 = 1738,
	STP_ISSYNC_0_B_MARK___3 = 1739,
	IP8_3_0_MARK___4 = 1740,
	SD0_DAT2_MARK___3 = 1741,
	MSIOF1_SS1_E_MARK___3 = 1742,
	TS_SDAT0_B_MARK___3 = 1743,
	STP_ISD_0_B_MARK___3 = 1744,
	IP9_3_0_MARK___4 = 1745,
	SD2_CLK_MARK___3 = 1746,
	NFDATA8_MARK___3 = 1747,
	IP10_3_0_MARK___4 = 1748,
	SD3_CMD_MARK___3 = 1749,
	NFRE_N_MARK___3 = 1750,
	IP11_3_0_MARK___3 = 1751,
	SD3_DAT7_MARK___3 = 1752,
	SD3_WP_MARK___3 = 1753,
	NFDATA7_MARK___3 = 1754,
	IP8_7_4_MARK___4 = 1755,
	SD0_DAT3_MARK___3 = 1756,
	MSIOF1_SS2_E_MARK___3 = 1757,
	TS_SDEN0_B_MARK___3 = 1758,
	STP_ISEN_0_B_MARK___3 = 1759,
	IP9_7_4_MARK___4 = 1760,
	SD2_CMD_MARK___3 = 1761,
	NFDATA9_MARK___3 = 1762,
	IP10_7_4_MARK___4 = 1763,
	SD3_DAT0_MARK___3 = 1764,
	NFDATA0_MARK___3 = 1765,
	IP11_7_4_MARK___3 = 1766,
	SD3_DS_MARK___3 = 1767,
	NFCLE_MARK___3 = 1768,
	IP8_11_8_MARK___4 = 1769,
	SD1_CLK_MARK___3 = 1770,
	MSIOF1_SCK_G_MARK___3 = 1771,
	SIM0_CLK_A_MARK___3 = 1772,
	IP9_11_8_MARK___4 = 1773,
	SD2_DAT0_MARK___3 = 1774,
	NFDATA10_MARK___3 = 1775,
	IP10_11_8_MARK___4 = 1776,
	SD3_DAT1_MARK___3 = 1777,
	NFDATA1_MARK___3 = 1778,
	IP11_11_8_MARK___3 = 1779,
	SD0_CD_MARK___3 = 1780,
	NFDATA14_A_MARK___3 = 1781,
	SCL2_B_MARK___3 = 1782,
	SIM0_RST_A_MARK___3 = 1783,
	IP8_15_12_MARK___4 = 1784,
	SD1_CMD_MARK___3 = 1785,
	MSIOF1_SYNC_G_MARK___3 = 1786,
	NFCE_N_B_MARK___3 = 1787,
	SIM0_D_A_MARK___3 = 1788,
	STP_IVCXO27_1_B_MARK___3 = 1789,
	IP9_15_12_MARK___4 = 1790,
	SD2_DAT1_MARK___3 = 1791,
	NFDATA11_MARK___3 = 1792,
	IP10_15_12_MARK___4 = 1793,
	SD3_DAT2_MARK___3 = 1794,
	NFDATA2_MARK___3 = 1795,
	IP11_15_12_MARK___3 = 1796,
	SD0_WP_MARK___3 = 1797,
	NFDATA15_A_MARK___3 = 1798,
	SDA2_B_MARK___3 = 1799,
	IP8_19_16_MARK___4 = 1800,
	SD1_DAT0_MARK___3 = 1801,
	SD2_DAT4_MARK___3 = 1802,
	MSIOF1_RXD_G_MARK___3 = 1803,
	NFWP_N_B_MARK___3 = 1804,
	TS_SCK1_B_MARK___3 = 1805,
	STP_ISCLK_1_B_MARK___3 = 1806,
	IP9_19_16_MARK___4 = 1807,
	SD2_DAT2_MARK___3 = 1808,
	NFDATA12_MARK___3 = 1809,
	IP10_19_16_MARK___4 = 1810,
	SD3_DAT3_MARK___3 = 1811,
	NFDATA3_MARK___3 = 1812,
	IP11_19_16_MARK___3 = 1813,
	SD1_CD_MARK___3 = 1814,
	NFRB_N_A_MARK___3 = 1815,
	SIM0_CLK_B_MARK___3 = 1816,
	IP8_23_20_MARK___4 = 1817,
	SD1_DAT1_MARK___3 = 1818,
	SD2_DAT5_MARK___3 = 1819,
	MSIOF1_TXD_G_MARK___3 = 1820,
	NFDATA14_B_MARK___3 = 1821,
	TS_SPSYNC1_B_MARK___3 = 1822,
	STP_ISSYNC_1_B_MARK___3 = 1823,
	IP9_23_20_MARK___4 = 1824,
	SD2_DAT3_MARK___3 = 1825,
	NFDATA13_MARK___3 = 1826,
	IP10_23_20_MARK___3 = 1827,
	SD3_DAT4_MARK___3 = 1828,
	SD2_CD_A_MARK___3 = 1829,
	NFDATA4_MARK___3 = 1830,
	IP11_23_20_MARK___3 = 1831,
	SD1_WP_MARK___3 = 1832,
	NFCE_N_A_MARK___3 = 1833,
	SIM0_D_B_MARK___3 = 1834,
	IP8_27_24_MARK___4 = 1835,
	SD1_DAT2_MARK___3 = 1836,
	SD2_DAT6_MARK___3 = 1837,
	MSIOF1_SS1_G_MARK___3 = 1838,
	NFDATA15_B_MARK___3 = 1839,
	TS_SDAT1_B_MARK___3 = 1840,
	STP_ISD_1_B_MARK___3 = 1841,
	IP9_27_24_MARK___4 = 1842,
	SD2_DS_MARK___3 = 1843,
	NFALE_MARK___3 = 1844,
	SATA_DEVSLP_B_MARK___2 = 1845,
	IP10_27_24_MARK___3 = 1846,
	SD3_DAT5_MARK___3 = 1847,
	SD2_WP_A_MARK___3 = 1848,
	NFDATA5_MARK___3 = 1849,
	IP11_27_24_MARK___3 = 1850,
	SCK0_MARK___4 = 1851,
	HSCK1_B_MARK___3 = 1852,
	MSIOF1_SS2_B_MARK___3 = 1853,
	AUDIO_CLKC_B_MARK___3 = 1854,
	SDA2_A_MARK___3 = 1855,
	SIM0_RST_B_MARK___3 = 1856,
	STP_OPWM_0_C_MARK___3 = 1857,
	RIF0_CLK_B_MARK___3 = 1858,
	ADICHS2_MARK___3 = 1859,
	SCK5_B_MARK___3 = 1860,
	IP8_31_28_MARK___4 = 1861,
	SD1_DAT3_MARK___3 = 1862,
	SD2_DAT7_MARK___3 = 1863,
	MSIOF1_SS2_G_MARK___3 = 1864,
	NFRB_N_B_MARK___3 = 1865,
	TS_SDEN1_B_MARK___3 = 1866,
	STP_ISEN_1_B_MARK___3 = 1867,
	IP9_31_28_MARK___4 = 1868,
	SD3_CLK_MARK___3 = 1869,
	NFWE_N_MARK___3 = 1870,
	IP10_31_28_MARK___3 = 1871,
	SD3_DAT6_MARK___3 = 1872,
	SD3_CD_MARK___3 = 1873,
	NFDATA6_MARK___3 = 1874,
	IP11_31_28_MARK___3 = 1875,
	RX0_MARK___4 = 1876,
	HRX1_B_MARK___3 = 1877,
	TS_SCK0_C_MARK___3 = 1878,
	STP_ISCLK_0_C_MARK___3 = 1879,
	RIF0_D0_B_MARK___3 = 1880,
	IP12_3_0_MARK___3 = 1881,
	TX0_MARK___4 = 1882,
	HTX1_B_MARK___3 = 1883,
	TS_SPSYNC0_C_MARK___3 = 1884,
	STP_ISSYNC_0_C_MARK___3 = 1885,
	RIF0_D1_B_MARK___3 = 1886,
	IP13_3_0_MARK___3 = 1887,
	TX2_A_MARK___3 = 1888,
	SD2_CD_B_MARK___3 = 1889,
	SCL1_A_MARK___3 = 1890,
	FMCLK_A_MARK___3 = 1891,
	RIF1_D1_C_MARK___3 = 1892,
	FSO_CFE_0_N_MARK___4 = 1893,
	IP14_3_0_MARK___3 = 1894,
	MSIOF0_SS1_MARK___4 = 1895,
	RX5_A_MARK___3 = 1896,
	NFWP_N_A_MARK___3 = 1897,
	AUDIO_CLKA_C_MARK___3 = 1898,
	SSI_SCK2_A_MARK___3 = 1899,
	STP_IVCXO27_0_C_MARK___3 = 1900,
	AUDIO_CLKOUT3_A_MARK___3 = 1901,
	TCLK1_B_MARK___4 = 1902,
	IP15_3_0_MARK___3 = 1903,
	SSI_SDATA1_A_MARK___3 = 1904,
	IP12_7_4_MARK___3 = 1905,
	CTS0_N_MARK___4 = 1906,
	HCTS1_N_B_MARK___3 = 1907,
	MSIOF1_SYNC_B_MARK___3 = 1908,
	TS_SPSYNC1_C_MARK___3 = 1909,
	STP_ISSYNC_1_C_MARK___3 = 1910,
	RIF1_SYNC_B_MARK___3 = 1911,
	AUDIO_CLKOUT_C_MARK___3 = 1912,
	ADICS_SAMP_MARK___3 = 1913,
	IP13_7_4_MARK___3 = 1914,
	RX2_A_MARK___3 = 1915,
	SD2_WP_B_MARK___3 = 1916,
	SDA1_A_MARK___3 = 1917,
	FMIN_A_MARK___3 = 1918,
	RIF1_SYNC_C_MARK___3 = 1919,
	FSO_CFE_1_N_MARK___4 = 1920,
	IP14_7_4_MARK___3 = 1921,
	MSIOF0_SS2_MARK___4 = 1922,
	TX5_A_MARK___3 = 1923,
	MSIOF1_SS2_D_MARK___3 = 1924,
	AUDIO_CLKC_A_MARK___3 = 1925,
	SSI_WS2_A_MARK___3 = 1926,
	STP_OPWM_0_D_MARK___3 = 1927,
	AUDIO_CLKOUT_D_MARK___3 = 1928,
	SPEEDIN_B_MARK___4 = 1929,
	IP15_7_4_MARK___3 = 1930,
	SSI_SDATA2_A_MARK___3 = 1931,
	SSI_SCK1_B_MARK___3 = 1932,
	IP12_11_8_MARK___3 = 1933,
	RTS0_N_MARK___4 = 1934,
	HRTS1_N_B_MARK___3 = 1935,
	MSIOF1_SS1_B_MARK___3 = 1936,
	AUDIO_CLKA_B_MARK___3 = 1937,
	SCL2_A_MARK___3 = 1938,
	STP_IVCXO27_1_C_MARK___3 = 1939,
	RIF0_SYNC_B_MARK___3 = 1940,
	ADICHS1_MARK___3 = 1941,
	IP13_11_8_MARK___3 = 1942,
	HSCK0_MARK___3 = 1943,
	MSIOF1_SCK_D_MARK___3 = 1944,
	AUDIO_CLKB_A_MARK___3 = 1945,
	SSI_SDATA1_B_MARK___3 = 1946,
	TS_SCK0_D_MARK___3 = 1947,
	STP_ISCLK_0_D_MARK___3 = 1948,
	RIF0_CLK_C_MARK___3 = 1949,
	RX5_B_MARK___3 = 1950,
	IP14_11_8_MARK___3 = 1951,
	MLB_CLK_MARK___3 = 1952,
	MSIOF1_SCK_F_MARK___3 = 1953,
	SCL1_B_MARK___3 = 1954,
	IP15_11_8_MARK___3 = 1955,
	SSI_SCK349_MARK___3 = 1956,
	MSIOF1_SS1_A_MARK___3 = 1957,
	STP_OPWM_0_A_MARK___3 = 1958,
	IP12_15_12_MARK___3 = 1959,
	RX1_A_MARK___4 = 1960,
	HRX1_A_MARK___3 = 1961,
	TS_SDAT0_C_MARK___3 = 1962,
	STP_ISD_0_C_MARK___3 = 1963,
	RIF1_CLK_C_MARK___3 = 1964,
	IP13_15_12_MARK___3 = 1965,
	HRX0_MARK___3 = 1966,
	MSIOF1_RXD_D_MARK___3 = 1967,
	SSI_SDATA2_B_MARK___3 = 1968,
	TS_SDEN0_D_MARK___3 = 1969,
	STP_ISEN_0_D_MARK___3 = 1970,
	RIF0_D0_C_MARK___3 = 1971,
	IP14_15_12_MARK___3 = 1972,
	MLB_SIG_MARK___3 = 1973,
	RX1_B_MARK___4 = 1974,
	MSIOF1_SYNC_F_MARK___3 = 1975,
	SDA1_B_MARK___3 = 1976,
	IP15_15_12_MARK___3 = 1977,
	SSI_WS349_MARK___3 = 1978,
	HCTS2_N_A_MARK___3 = 1979,
	MSIOF1_SS2_A_MARK___3 = 1980,
	STP_IVCXO27_0_A_MARK___3 = 1981,
	IP12_19_16_MARK___3 = 1982,
	TX1_A_MARK___4 = 1983,
	HTX1_A_MARK___3 = 1984,
	TS_SDEN0_C_MARK___3 = 1985,
	STP_ISEN_0_C_MARK___3 = 1986,
	RIF1_D0_C_MARK___3 = 1987,
	IP13_19_16_MARK___3 = 1988,
	HTX0_MARK___3 = 1989,
	MSIOF1_TXD_D_MARK___3 = 1990,
	SSI_SDATA9_B_MARK___3 = 1991,
	TS_SDAT0_D_MARK___3 = 1992,
	STP_ISD_0_D_MARK___3 = 1993,
	RIF0_D1_C_MARK___3 = 1994,
	IP14_19_16_MARK___3 = 1995,
	MLB_DAT_MARK___3 = 1996,
	TX1_B_MARK___4 = 1997,
	MSIOF1_RXD_F_MARK___3 = 1998,
	IP15_19_16_MARK___3 = 1999,
	SSI_SDATA3_MARK___3 = 2000,
	HRTS2_N_A_MARK___3 = 2001,
	MSIOF1_TXD_A_MARK___3 = 2002,
	TS_SCK0_A_MARK___3 = 2003,
	STP_ISCLK_0_A_MARK___3 = 2004,
	RIF0_D1_A_MARK___3 = 2005,
	RIF2_D0_A_MARK___3 = 2006,
	IP12_23_20_MARK___3 = 2007,
	CTS1_N_MARK___4 = 2008,
	HCTS1_N_A_MARK___3 = 2009,
	MSIOF1_RXD_B_MARK___3 = 2010,
	TS_SDEN1_C_MARK___3 = 2011,
	STP_ISEN_1_C_MARK___3 = 2012,
	RIF1_D0_B_MARK___3 = 2013,
	ADIDATA_MARK___3 = 2014,
	IP13_23_20_MARK___3 = 2015,
	HCTS0_N_MARK___3 = 2016,
	RX2_B_MARK___3 = 2017,
	MSIOF1_SYNC_D_MARK___3 = 2018,
	SSI_SCK9_A_MARK___3 = 2019,
	TS_SPSYNC0_D_MARK___3 = 2020,
	STP_ISSYNC_0_D_MARK___3 = 2021,
	RIF0_SYNC_C_MARK___3 = 2022,
	AUDIO_CLKOUT1_A_MARK___3 = 2023,
	IP14_23_20_MARK___3 = 2024,
	SSI_SCK01239_MARK___3 = 2025,
	MSIOF1_TXD_F_MARK___3 = 2026,
	IP15_23_20_MARK___3 = 2027,
	SSI_SCK4_MARK___3 = 2028,
	HRX2_A_MARK___3 = 2029,
	MSIOF1_SCK_A_MARK___3 = 2030,
	TS_SDAT0_A_MARK___3 = 2031,
	STP_ISD_0_A_MARK___3 = 2032,
	RIF0_CLK_A_MARK___3 = 2033,
	RIF2_CLK_A_MARK___3 = 2034,
	IP12_27_24_MARK___3 = 2035,
	RTS1_N_MARK___4 = 2036,
	HRTS1_N_A_MARK___3 = 2037,
	MSIOF1_TXD_B_MARK___3 = 2038,
	TS_SDAT1_C_MARK___3 = 2039,
	STP_ISD_1_C_MARK___3 = 2040,
	RIF1_D1_B_MARK___3 = 2041,
	ADICHS0_MARK___3 = 2042,
	IP13_27_24_MARK___3 = 2043,
	HRTS0_N_MARK___3 = 2044,
	TX2_B_MARK___3 = 2045,
	MSIOF1_SS1_D_MARK___3 = 2046,
	SSI_WS9_A_MARK___3 = 2047,
	STP_IVCXO27_0_D_MARK___3 = 2048,
	BPFCLK_A_MARK___3 = 2049,
	AUDIO_CLKOUT2_A_MARK___3 = 2050,
	IP14_27_24_MARK___3 = 2051,
	SSI_WS01239_MARK___3 = 2052,
	MSIOF1_SS1_F_MARK___3 = 2053,
	IP15_27_24_MARK___3 = 2054,
	SSI_WS4_MARK___3 = 2055,
	HTX2_A_MARK___3 = 2056,
	MSIOF1_SYNC_A_MARK___3 = 2057,
	TS_SDEN0_A_MARK___3 = 2058,
	STP_ISEN_0_A_MARK___3 = 2059,
	RIF0_SYNC_A_MARK___3 = 2060,
	RIF2_SYNC_A_MARK___3 = 2061,
	IP12_31_28_MARK___3 = 2062,
	SCK2_MARK___3 = 2063,
	SCIF_CLK_B_MARK___4 = 2064,
	MSIOF1_SCK_B_MARK___3 = 2065,
	TS_SCK1_C_MARK___3 = 2066,
	STP_ISCLK_1_C_MARK___3 = 2067,
	RIF1_CLK_B_MARK___3 = 2068,
	ADICLK_MARK___3 = 2069,
	IP13_31_28_MARK___3 = 2070,
	MSIOF0_SYNC_MARK___4 = 2071,
	AUDIO_CLKOUT_A_MARK___3 = 2072,
	TX5_B_MARK___3 = 2073,
	BPFCLK_D_MARK___3 = 2074,
	IP14_31_28_MARK___3 = 2075,
	SSI_SDATA0_MARK___3 = 2076,
	MSIOF1_SS2_F_MARK___3 = 2077,
	IP15_31_28_MARK___3 = 2078,
	SSI_SDATA4_MARK___3 = 2079,
	HSCK2_A_MARK___3 = 2080,
	MSIOF1_RXD_A_MARK___3 = 2081,
	TS_SPSYNC0_A_MARK___3 = 2082,
	STP_ISSYNC_0_A_MARK___3 = 2083,
	RIF0_D0_A_MARK___3 = 2084,
	RIF2_D1_A_MARK___3 = 2085,
	IP16_3_0_MARK___3 = 2086,
	SSI_SCK6_MARK___3 = 2087,
	SIM0_RST_D_MARK___3 = 2088,
	IP17_3_0_MARK___3 = 2089,
	AUDIO_CLKA_A_MARK___3 = 2090,
	IP18_3_0_MARK___3 = 2091,
	GP6_30_MARK___2 = 2092,
	AUDIO_CLKOUT2_B_MARK___3 = 2093,
	SSI_SCK9_B_MARK___3 = 2094,
	TS_SDEN0_E_MARK___3 = 2095,
	STP_ISEN_0_E_MARK___3 = 2096,
	RIF2_D0_B_MARK___3 = 2097,
	TPU0TO2_MARK___4 = 2098,
	FMCLK_C_MARK___3 = 2099,
	FMCLK_D_MARK___3 = 2100,
	IP16_7_4_MARK___3 = 2101,
	SSI_WS6_MARK___3 = 2102,
	SIM0_D_D_MARK___3 = 2103,
	IP17_7_4_MARK___3 = 2104,
	AUDIO_CLKB_B_MARK___3 = 2105,
	SCIF_CLK_A_MARK___4 = 2106,
	STP_IVCXO27_1_D_MARK___3 = 2107,
	REMOCON_A_MARK___3 = 2108,
	TCLK1_A_MARK___4 = 2109,
	IP18_7_4_MARK___3 = 2110,
	GP6_31_MARK___2 = 2111,
	AUDIO_CLKOUT3_B_MARK___3 = 2112,
	SSI_WS9_B_MARK___3 = 2113,
	TS_SPSYNC0_E_MARK___3 = 2114,
	STP_ISSYNC_0_E_MARK___3 = 2115,
	RIF2_D1_B_MARK___3 = 2116,
	TPU0TO3_MARK___4 = 2117,
	FMIN_C_MARK___3 = 2118,
	FMIN_D_MARK___3 = 2119,
	IP16_11_8_MARK___3 = 2120,
	SSI_SDATA6_MARK___3 = 2121,
	SIM0_CLK_D_MARK___3 = 2122,
	SATA_DEVSLP_A_MARK___2 = 2123,
	IP17_11_8_MARK___3 = 2124,
	USB0_PWEN_MARK___3 = 2125,
	SIM0_RST_C_MARK___3 = 2126,
	TS_SCK1_D_MARK___3 = 2127,
	STP_ISCLK_1_D_MARK___3 = 2128,
	BPFCLK_B_MARK___3 = 2129,
	RIF3_CLK_B_MARK___3 = 2130,
	HSCK2_C_MARK___3 = 2131,
	IP16_15_12_MARK___3 = 2132,
	SSI_SCK78_MARK___3 = 2133,
	HRX2_B_MARK___3 = 2134,
	MSIOF1_SCK_C_MARK___3 = 2135,
	TS_SCK1_A_MARK___3 = 2136,
	STP_ISCLK_1_A_MARK___3 = 2137,
	RIF1_CLK_A_MARK___3 = 2138,
	RIF3_CLK_A_MARK___3 = 2139,
	IP17_15_12_MARK___3 = 2140,
	USB0_OVC_MARK___3 = 2141,
	SIM0_D_C_MARK___3 = 2142,
	TS_SDAT1_D_MARK___3 = 2143,
	STP_ISD_1_D_MARK___3 = 2144,
	RIF3_SYNC_B_MARK___3 = 2145,
	HRX2_C_MARK___3 = 2146,
	IP16_19_16_MARK___3 = 2147,
	SSI_WS78_MARK___3 = 2148,
	HTX2_B_MARK___3 = 2149,
	MSIOF1_SYNC_C_MARK___3 = 2150,
	TS_SDAT1_A_MARK___3 = 2151,
	STP_ISD_1_A_MARK___3 = 2152,
	RIF1_SYNC_A_MARK___3 = 2153,
	RIF3_SYNC_A_MARK___3 = 2154,
	IP17_19_16_MARK___3 = 2155,
	USB1_PWEN_MARK___3 = 2156,
	SIM0_CLK_C_MARK___3 = 2157,
	SSI_SCK1_A_MARK___3 = 2158,
	TS_SCK0_E_MARK___3 = 2159,
	STP_ISCLK_0_E_MARK___3 = 2160,
	FMCLK_B_MARK___3 = 2161,
	RIF2_CLK_B_MARK___3 = 2162,
	SPEEDIN_A_MARK___4 = 2163,
	HTX2_C_MARK___3 = 2164,
	IP16_23_20_MARK___3 = 2165,
	SSI_SDATA7_MARK___3 = 2166,
	HCTS2_N_B_MARK___3 = 2167,
	MSIOF1_RXD_C_MARK___3 = 2168,
	TS_SDEN1_A_MARK___3 = 2169,
	STP_ISEN_1_A_MARK___3 = 2170,
	RIF1_D0_A_MARK___3 = 2171,
	RIF3_D0_A_MARK___3 = 2172,
	TCLK2_A_MARK___4 = 2173,
	IP17_23_20_MARK___3 = 2174,
	USB1_OVC_MARK___3 = 2175,
	MSIOF1_SS2_C_MARK___3 = 2176,
	SSI_WS1_A_MARK___3 = 2177,
	TS_SDAT0_E_MARK___3 = 2178,
	STP_ISD_0_E_MARK___3 = 2179,
	FMIN_B_MARK___3 = 2180,
	RIF2_SYNC_B_MARK___3 = 2181,
	REMOCON_B_MARK___3 = 2182,
	HCTS2_N_C_MARK___3 = 2183,
	IP16_27_24_MARK___3 = 2184,
	SSI_SDATA8_MARK___3 = 2185,
	HRTS2_N_B_MARK___3 = 2186,
	MSIOF1_TXD_C_MARK___3 = 2187,
	TS_SPSYNC1_A_MARK___3 = 2188,
	STP_ISSYNC_1_A_MARK___3 = 2189,
	RIF1_D1_A_MARK___3 = 2190,
	RIF3_D1_A_MARK___3 = 2191,
	IP17_27_24_MARK___3 = 2192,
	USB30_PWEN_MARK___3 = 2193,
	AUDIO_CLKOUT_B_MARK___3 = 2194,
	SSI_SCK2_B_MARK___3 = 2195,
	TS_SDEN1_D_MARK___3 = 2196,
	STP_ISEN_1_D_MARK___3 = 2197,
	STP_OPWM_0_E_MARK___3 = 2198,
	RIF3_D0_B_MARK___3 = 2199,
	TCLK2_B_MARK___4 = 2200,
	TPU0TO0_MARK___4 = 2201,
	BPFCLK_C_MARK___3 = 2202,
	HRTS2_N_C_MARK___3 = 2203,
	IP16_31_28_MARK___3 = 2204,
	SSI_SDATA9_A_MARK___3 = 2205,
	HSCK2_B_MARK___3 = 2206,
	MSIOF1_SS1_C_MARK___3 = 2207,
	HSCK1_A_MARK___3 = 2208,
	SSI_WS1_B_MARK___3 = 2209,
	SCK1_MARK___4 = 2210,
	STP_IVCXO27_1_A_MARK___3 = 2211,
	SCK5_A_MARK___3 = 2212,
	IP17_31_28_MARK___3 = 2213,
	USB30_OVC_MARK___3 = 2214,
	AUDIO_CLKOUT1_B_MARK___3 = 2215,
	SSI_WS2_B_MARK___3 = 2216,
	TS_SPSYNC1_D_MARK___3 = 2217,
	STP_ISSYNC_1_D_MARK___3 = 2218,
	STP_IVCXO27_0_E_MARK___3 = 2219,
	RIF3_D1_B_MARK___3 = 2220,
	FSO_TOE_N_MARK___4 = 2221,
	TPU0TO1_MARK___4 = 2222,
	SEL_MSIOF3_0_MARK___3 = 2223,
	SEL_MSIOF3_1_MARK___3 = 2224,
	SEL_MSIOF3_2_MARK___3 = 2225,
	SEL_MSIOF3_3_MARK___3 = 2226,
	SEL_MSIOF3_4_MARK___3 = 2227,
	SEL_TSIF1_0_MARK___3 = 2228,
	SEL_TSIF1_1_MARK___3 = 2229,
	SEL_TSIF1_2_MARK___3 = 2230,
	SEL_TSIF1_3_MARK___3 = 2231,
	I2C_SEL_5_0_MARK___3 = 2232,
	I2C_SEL_5_1_MARK___3 = 2233,
	I2C_SEL_3_0_MARK___3 = 2234,
	I2C_SEL_3_1_MARK___3 = 2235,
	SEL_TSIF0_0_MARK___3 = 2236,
	SEL_TSIF0_1_MARK___3 = 2237,
	SEL_TSIF0_2_MARK___3 = 2238,
	SEL_TSIF0_3_MARK___3 = 2239,
	SEL_TSIF0_4_MARK___3 = 2240,
	I2C_SEL_0_0_MARK___3 = 2241,
	I2C_SEL_0_1_MARK___3 = 2242,
	SEL_MSIOF2_0_MARK___3 = 2243,
	SEL_MSIOF2_1_MARK___3 = 2244,
	SEL_MSIOF2_2_MARK___3 = 2245,
	SEL_MSIOF2_3_MARK___3 = 2246,
	SEL_FM_0_MARK___3 = 2247,
	SEL_FM_1_MARK___3 = 2248,
	SEL_FM_2_MARK___3 = 2249,
	SEL_FM_3_MARK___3 = 2250,
	SEL_MSIOF1_0_MARK___3 = 2251,
	SEL_MSIOF1_1_MARK___3 = 2252,
	SEL_MSIOF1_2_MARK___3 = 2253,
	SEL_MSIOF1_3_MARK___3 = 2254,
	SEL_MSIOF1_4_MARK___3 = 2255,
	SEL_MSIOF1_5_MARK___3 = 2256,
	SEL_MSIOF1_6_MARK___3 = 2257,
	SEL_TIMER_TMU_0_MARK___2 = 2258,
	SEL_TIMER_TMU_1_MARK___2 = 2259,
	SEL_SCIF5_0_MARK___3 = 2260,
	SEL_SCIF5_1_MARK___3 = 2261,
	SEL_SSP1_1_0_MARK___3 = 2262,
	SEL_SSP1_1_1_MARK___3 = 2263,
	SEL_SSP1_1_2_MARK___3 = 2264,
	SEL_SSP1_1_3_MARK___3 = 2265,
	SEL_I2C6_0_MARK___3 = 2266,
	SEL_I2C6_1_MARK___3 = 2267,
	SEL_I2C6_2_MARK___3 = 2268,
	SEL_LBSC_0_MARK___3 = 2269,
	SEL_LBSC_1_MARK___3 = 2270,
	SEL_SSP1_0_0_MARK___3 = 2271,
	SEL_SSP1_0_1_MARK___3 = 2272,
	SEL_SSP1_0_2_MARK___3 = 2273,
	SEL_SSP1_0_3_MARK___3 = 2274,
	SEL_SSP1_0_4_MARK___3 = 2275,
	SEL_IEBUS_0_MARK___3 = 2276,
	SEL_IEBUS_1_MARK___3 = 2277,
	SEL_NDF_0_MARK___2 = 2278,
	SEL_NDF_1_MARK___2 = 2279,
	SEL_I2C2_0_MARK___3 = 2280,
	SEL_I2C2_1_MARK___3 = 2281,
	SEL_SSI2_0_MARK___3 = 2282,
	SEL_SSI2_1_MARK___3 = 2283,
	SEL_I2C1_0_MARK___3 = 2284,
	SEL_I2C1_1_MARK___3 = 2285,
	SEL_SSI1_0_MARK___3 = 2286,
	SEL_SSI1_1_MARK___3 = 2287,
	SEL_SSI9_0_MARK___3 = 2288,
	SEL_SSI9_1_MARK___3 = 2289,
	SEL_HSCIF4_0_MARK___3 = 2290,
	SEL_HSCIF4_1_MARK___3 = 2291,
	SEL_SPEED_PULSE_0_MARK___3 = 2292,
	SEL_SPEED_PULSE_1_MARK___3 = 2293,
	SEL_TIMER_TMU2_0_MARK___3 = 2294,
	SEL_TIMER_TMU2_1_MARK___3 = 2295,
	SEL_HSCIF3_0_MARK___3 = 2296,
	SEL_HSCIF3_1_MARK___3 = 2297,
	SEL_HSCIF3_2_MARK___3 = 2298,
	SEL_HSCIF3_3_MARK___3 = 2299,
	SEL_SIMCARD_0_MARK___3 = 2300,
	SEL_SIMCARD_1_MARK___3 = 2301,
	SEL_SIMCARD_2_MARK___3 = 2302,
	SEL_SIMCARD_3_MARK___3 = 2303,
	SEL_ADGB_0_MARK___3 = 2304,
	SEL_ADGB_1_MARK___3 = 2305,
	SEL_ADGC_0_MARK___3 = 2306,
	SEL_ADGC_1_MARK___3 = 2307,
	SEL_HSCIF1_0_MARK___3 = 2308,
	SEL_HSCIF1_1_MARK___3 = 2309,
	SEL_SDHI2_0_MARK___3 = 2310,
	SEL_SDHI2_1_MARK___3 = 2311,
	SEL_SCIF4_0_MARK___3 = 2312,
	SEL_SCIF4_1_MARK___3 = 2313,
	SEL_SCIF4_2_MARK___3 = 2314,
	SEL_HSCIF2_0_MARK___3 = 2315,
	SEL_HSCIF2_1_MARK___3 = 2316,
	SEL_HSCIF2_2_MARK___3 = 2317,
	SEL_SCIF3_0_MARK___3 = 2318,
	SEL_SCIF3_1_MARK___3 = 2319,
	SEL_ETHERAVB_0_MARK___3 = 2320,
	SEL_ETHERAVB_1_MARK___3 = 2321,
	SEL_SCIF2_0_MARK___3 = 2322,
	SEL_SCIF2_1_MARK___3 = 2323,
	SEL_DRIF3_0_MARK___3 = 2324,
	SEL_DRIF3_1_MARK___3 = 2325,
	SEL_SCIF1_0_MARK___4 = 2326,
	SEL_SCIF1_1_MARK___4 = 2327,
	SEL_DRIF2_0_MARK___3 = 2328,
	SEL_DRIF2_1_MARK___3 = 2329,
	SEL_SCIF_0_MARK___3 = 2330,
	SEL_SCIF_1_MARK___3 = 2331,
	SEL_DRIF1_0_MARK___3 = 2332,
	SEL_DRIF1_1_MARK___3 = 2333,
	SEL_DRIF1_2_MARK___3 = 2334,
	SEL_REMOCON_0_MARK___3 = 2335,
	SEL_REMOCON_1_MARK___3 = 2336,
	SEL_DRIF0_0_MARK___3 = 2337,
	SEL_DRIF0_1_MARK___3 = 2338,
	SEL_DRIF0_2_MARK___3 = 2339,
	SEL_RCAN0_0_MARK___3 = 2340,
	SEL_RCAN0_1_MARK___3 = 2341,
	SEL_CANFD0_0_MARK___4 = 2342,
	SEL_CANFD0_1_MARK___4 = 2343,
	SEL_PWM6_0_MARK___3 = 2344,
	SEL_PWM6_1_MARK___3 = 2345,
	SEL_ADGA_0_MARK___3 = 2346,
	SEL_ADGA_1_MARK___3 = 2347,
	SEL_ADGA_2_MARK___3 = 2348,
	SEL_ADGA_3_MARK___3 = 2349,
	SEL_PWM5_0_MARK___3 = 2350,
	SEL_PWM5_1_MARK___3 = 2351,
	SEL_PWM4_0_MARK___4 = 2352,
	SEL_PWM4_1_MARK___4 = 2353,
	SEL_PWM3_0_MARK___4 = 2354,
	SEL_PWM3_1_MARK___4 = 2355,
	SEL_PWM2_0_MARK___4 = 2356,
	SEL_PWM2_1_MARK___4 = 2357,
	SEL_PWM1_0_MARK___4 = 2358,
	SEL_PWM1_1_MARK___4 = 2359,
	SEL_VIN4_0_MARK___3 = 2360,
	SEL_VIN4_1_MARK___3 = 2361,
	QSPI0_SPCLK_MARK___4 = 2362,
	QSPI0_SSL_MARK___4 = 2363,
	QSPI0_MOSI_IO0_MARK___4 = 2364,
	QSPI0_MISO_IO1_MARK___4 = 2365,
	QSPI0_IO2_MARK___4 = 2366,
	QSPI0_IO3_MARK___4 = 2367,
	QSPI1_SPCLK_MARK___4 = 2368,
	QSPI1_SSL_MARK___4 = 2369,
	QSPI1_MOSI_IO0_MARK___4 = 2370,
	QSPI1_MISO_IO1_MARK___4 = 2371,
	QSPI1_IO2_MARK___4 = 2372,
	QSPI1_IO3_MARK___4 = 2373,
	RPC_INT_MARK___3 = 2374,
	RPC_WP_MARK___3 = 2375,
	RPC_RESET_MARK___3 = 2376,
	AVB_TX_CTL_MARK___4 = 2377,
	AVB_TXC_MARK___4 = 2378,
	AVB_TD0_MARK___4 = 2379,
	AVB_TD1_MARK___4 = 2380,
	AVB_TD2_MARK___4 = 2381,
	AVB_TD3_MARK___4 = 2382,
	AVB_RX_CTL_MARK___4 = 2383,
	AVB_RXC_MARK___4 = 2384,
	AVB_RD0_MARK___4 = 2385,
	AVB_RD1_MARK___4 = 2386,
	AVB_RD2_MARK___4 = 2387,
	AVB_RD3_MARK___4 = 2388,
	AVB_TXCREFCLK_MARK___4 = 2389,
	AVB_MDIO_MARK___4 = 2390,
	PRESETOUT_MARK___3 = 2391,
	DU_DOTCLKIN0_MARK___3 = 2392,
	DU_DOTCLKIN1_MARK___3 = 2393,
	DU_DOTCLKIN3_MARK___2 = 2394,
	TMS_MARK___3 = 2395,
	TDO_MARK___3 = 2396,
	ASEBRK_MARK___3 = 2397,
	MLB_REF_MARK___3 = 2398,
	TDI_MARK___3 = 2399,
	TCK_MARK___3 = 2400,
	TRST_MARK___3 = 2401,
	EXTALR_MARK___3 = 2402,
	SCL0_MARK___4 = 2403,
	SDA0_MARK___4 = 2404,
	SCL3_MARK___4 = 2405,
	SDA3_MARK___4 = 2406,
	SCL5_MARK___4 = 2407,
	SDA5_MARK___4 = 2408,
	PINMUX_MARK_END___4 = 2409,
};

enum {
	PINMUX_RESERVED___5 = 0,
	PINMUX_DATA_BEGIN___5 = 1,
	GP_0_0_DATA___5 = 2,
	GP_0_1_DATA___5 = 3,
	GP_0_2_DATA___5 = 4,
	GP_0_3_DATA___5 = 5,
	GP_0_4_DATA___5 = 6,
	GP_0_5_DATA___5 = 7,
	GP_0_6_DATA___5 = 8,
	GP_0_7_DATA___5 = 9,
	GP_0_8_DATA___5 = 10,
	GP_0_9_DATA___5 = 11,
	GP_0_10_DATA___5 = 12,
	GP_0_11_DATA___5 = 13,
	GP_0_12_DATA___5 = 14,
	GP_0_13_DATA___5 = 15,
	GP_0_14_DATA___5 = 16,
	GP_0_15_DATA___5 = 17,
	GP_0_16_DATA___2 = 18,
	GP_0_17_DATA___2 = 19,
	GP_0_18_DATA___2 = 20,
	GP_1_0_DATA___5 = 21,
	GP_1_1_DATA___5 = 22,
	GP_1_2_DATA___5 = 23,
	GP_1_3_DATA___5 = 24,
	GP_1_4_DATA___5 = 25,
	GP_1_5_DATA___5 = 26,
	GP_1_6_DATA___5 = 27,
	GP_1_7_DATA___5 = 28,
	GP_1_8_DATA___5 = 29,
	GP_1_9_DATA___5 = 30,
	GP_1_10_DATA___5 = 31,
	GP_1_11_DATA___5 = 32,
	GP_1_12_DATA___5 = 33,
	GP_1_13_DATA___5 = 34,
	GP_1_14_DATA___5 = 35,
	GP_1_15_DATA___5 = 36,
	GP_1_16_DATA___5 = 37,
	GP_1_17_DATA___5 = 38,
	GP_1_18_DATA___5 = 39,
	GP_1_19_DATA___5 = 40,
	GP_1_20_DATA___5 = 41,
	GP_1_21_DATA___5 = 42,
	GP_1_22_DATA___5 = 43,
	GP_1_23_DATA___5 = 44,
	GP_1_24_DATA___5 = 45,
	GP_1_25_DATA___5 = 46,
	GP_1_26_DATA___5 = 47,
	GP_1_27_DATA___5 = 48,
	GP_1_28_DATA___4 = 49,
	GP_2_0_DATA___5 = 50,
	GP_2_1_DATA___5 = 51,
	GP_2_2_DATA___5 = 52,
	GP_2_3_DATA___5 = 53,
	GP_2_4_DATA___5 = 54,
	GP_2_5_DATA___5 = 55,
	GP_2_6_DATA___5 = 56,
	GP_2_7_DATA___5 = 57,
	GP_2_8_DATA___5 = 58,
	GP_2_9_DATA___5 = 59,
	GP_2_10_DATA___5 = 60,
	GP_2_11_DATA___5 = 61,
	GP_2_12_DATA___5 = 62,
	GP_2_13_DATA___5 = 63,
	GP_2_14_DATA___5 = 64,
	GP_2_15_DATA___2 = 65,
	GP_2_16_DATA___2 = 66,
	GP_2_17_DATA___2 = 67,
	GP_2_18_DATA___2 = 68,
	GP_2_19_DATA___2 = 69,
	GP_3_0_DATA___5 = 70,
	GP_3_1_DATA___5 = 71,
	GP_3_2_DATA___5 = 72,
	GP_3_3_DATA___5 = 73,
	GP_3_4_DATA___5 = 74,
	GP_3_5_DATA___5 = 75,
	GP_3_6_DATA___5 = 76,
	GP_3_7_DATA___5 = 77,
	GP_3_8_DATA___5 = 78,
	GP_3_9_DATA___5 = 79,
	GP_3_10_DATA___5 = 80,
	GP_3_11_DATA___5 = 81,
	GP_3_12_DATA___5 = 82,
	GP_3_13_DATA___5 = 83,
	GP_3_14_DATA___5 = 84,
	GP_3_15_DATA___5 = 85,
	GP_3_16_DATA___2 = 86,
	GP_3_17_DATA = 87,
	GP_3_18_DATA = 88,
	GP_3_19_DATA = 89,
	GP_3_20_DATA = 90,
	GP_3_21_DATA = 91,
	GP_3_22_DATA = 92,
	GP_3_23_DATA = 93,
	GP_3_24_DATA = 94,
	GP_3_25_DATA = 95,
	GP_3_26_DATA = 96,
	GP_3_27_DATA = 97,
	GP_3_28_DATA = 98,
	GP_3_29_DATA = 99,
	GP_4_0_DATA___5 = 100,
	GP_4_1_DATA___5 = 101,
	GP_4_2_DATA___5 = 102,
	GP_4_3_DATA___5 = 103,
	GP_4_4_DATA___5 = 104,
	GP_4_5_DATA___5 = 105,
	GP_4_6_DATA___5 = 106,
	GP_4_7_DATA___5 = 107,
	GP_4_8_DATA___5 = 108,
	GP_4_9_DATA___5 = 109,
	GP_4_10_DATA___5 = 110,
	GP_4_11_DATA___5 = 111,
	GP_4_12_DATA___5 = 112,
	GP_4_13_DATA___5 = 113,
	GP_4_14_DATA___5 = 114,
	GP_4_15_DATA___5 = 115,
	GP_4_16_DATA___5 = 116,
	GP_4_17_DATA___5 = 117,
	GP_4_18_DATA___2 = 118,
	GP_4_19_DATA___2 = 119,
	GP_4_20_DATA___2 = 120,
	GP_4_21_DATA___2 = 121,
	GP_4_22_DATA___2 = 122,
	GP_4_23_DATA___2 = 123,
	GP_4_24_DATA___2 = 124,
	GP_5_0_DATA___5 = 125,
	GP_5_1_DATA___5 = 126,
	GP_5_2_DATA___5 = 127,
	GP_5_3_DATA___5 = 128,
	GP_5_4_DATA___5 = 129,
	GP_5_5_DATA___5 = 130,
	GP_5_6_DATA___5 = 131,
	GP_5_7_DATA___5 = 132,
	GP_5_8_DATA___5 = 133,
	GP_5_9_DATA___5 = 134,
	GP_5_10_DATA___5 = 135,
	GP_5_11_DATA___5 = 136,
	GP_5_12_DATA___5 = 137,
	GP_5_13_DATA___5 = 138,
	GP_5_14_DATA___5 = 139,
	GP_5_15_DATA___4 = 140,
	GP_5_16_DATA___4 = 141,
	GP_5_17_DATA___4 = 142,
	GP_5_18_DATA___4 = 143,
	GP_5_19_DATA___4 = 144,
	GP_5_20_DATA___4 = 145,
	GP_6_0_DATA___4 = 146,
	GP_6_1_DATA___4 = 147,
	GP_6_2_DATA___4 = 148,
	GP_6_3_DATA___4 = 149,
	GP_6_4_DATA___4 = 150,
	GP_6_5_DATA___4 = 151,
	GP_6_6_DATA___4 = 152,
	GP_6_7_DATA___4 = 153,
	GP_6_8_DATA___4 = 154,
	GP_6_9_DATA___4 = 155,
	GP_6_10_DATA___4 = 156,
	GP_6_11_DATA___4 = 157,
	GP_6_12_DATA___4 = 158,
	GP_6_13_DATA___4 = 159,
	GP_6_14_DATA___4 = 160,
	GP_6_15_DATA___4 = 161,
	GP_6_16_DATA___4 = 162,
	GP_6_17_DATA___4 = 163,
	GP_6_18_DATA___4 = 164,
	GP_6_19_DATA___4 = 165,
	GP_6_20_DATA___4 = 166,
	GP_7_0_DATA___4 = 167,
	GP_7_1_DATA___4 = 168,
	GP_7_2_DATA___4 = 169,
	GP_7_3_DATA___4 = 170,
	GP_7_4_DATA = 171,
	GP_7_5_DATA = 172,
	GP_7_6_DATA = 173,
	GP_7_7_DATA = 174,
	GP_7_8_DATA = 175,
	GP_7_9_DATA = 176,
	GP_7_10_DATA = 177,
	GP_7_11_DATA = 178,
	GP_7_12_DATA = 179,
	GP_7_13_DATA = 180,
	GP_7_14_DATA = 181,
	GP_7_15_DATA = 182,
	GP_7_16_DATA = 183,
	GP_7_17_DATA = 184,
	GP_7_18_DATA = 185,
	GP_7_19_DATA = 186,
	GP_7_20_DATA = 187,
	GP_8_0_DATA = 188,
	GP_8_1_DATA = 189,
	GP_8_2_DATA = 190,
	GP_8_3_DATA = 191,
	GP_8_4_DATA = 192,
	GP_8_5_DATA = 193,
	GP_8_6_DATA = 194,
	GP_8_7_DATA = 195,
	GP_8_8_DATA = 196,
	GP_8_9_DATA = 197,
	GP_8_10_DATA = 198,
	GP_8_11_DATA = 199,
	GP_8_12_DATA = 200,
	GP_8_13_DATA = 201,
	PINMUX_DATA_END___5 = 202,
	PINMUX_FUNCTION_BEGIN___5 = 203,
	GP_0_0_FN___5 = 204,
	GP_0_1_FN___5 = 205,
	GP_0_2_FN___5 = 206,
	GP_0_3_FN___5 = 207,
	GP_0_4_FN___5 = 208,
	GP_0_5_FN___5 = 209,
	GP_0_6_FN___5 = 210,
	GP_0_7_FN___5 = 211,
	GP_0_8_FN___5 = 212,
	GP_0_9_FN___5 = 213,
	GP_0_10_FN___5 = 214,
	GP_0_11_FN___5 = 215,
	GP_0_12_FN___5 = 216,
	GP_0_13_FN___5 = 217,
	GP_0_14_FN___5 = 218,
	GP_0_15_FN___5 = 219,
	GP_0_16_FN___2 = 220,
	GP_0_17_FN___2 = 221,
	GP_0_18_FN___2 = 222,
	GP_1_0_FN___5 = 223,
	GP_1_1_FN___5 = 224,
	GP_1_2_FN___5 = 225,
	GP_1_3_FN___5 = 226,
	GP_1_4_FN___5 = 227,
	GP_1_5_FN___5 = 228,
	GP_1_6_FN___5 = 229,
	GP_1_7_FN___5 = 230,
	GP_1_8_FN___5 = 231,
	GP_1_9_FN___5 = 232,
	GP_1_10_FN___5 = 233,
	GP_1_11_FN___5 = 234,
	GP_1_12_FN___5 = 235,
	GP_1_13_FN___5 = 236,
	GP_1_14_FN___5 = 237,
	GP_1_15_FN___5 = 238,
	GP_1_16_FN___5 = 239,
	GP_1_17_FN___5 = 240,
	GP_1_18_FN___5 = 241,
	GP_1_19_FN___5 = 242,
	GP_1_20_FN___5 = 243,
	GP_1_21_FN___5 = 244,
	GP_1_22_FN___5 = 245,
	GP_1_23_FN___5 = 246,
	GP_1_24_FN___5 = 247,
	GP_1_25_FN___5 = 248,
	GP_1_26_FN___5 = 249,
	GP_1_27_FN___5 = 250,
	GP_1_28_FN___4 = 251,
	GP_2_0_FN___5 = 252,
	GP_2_1_FN___5 = 253,
	GP_2_2_FN___5 = 254,
	GP_2_3_FN___5 = 255,
	GP_2_4_FN___5 = 256,
	GP_2_5_FN___5 = 257,
	GP_2_6_FN___5 = 258,
	GP_2_7_FN___5 = 259,
	GP_2_8_FN___5 = 260,
	GP_2_9_FN___5 = 261,
	GP_2_10_FN___5 = 262,
	GP_2_11_FN___5 = 263,
	GP_2_12_FN___5 = 264,
	GP_2_13_FN___5 = 265,
	GP_2_14_FN___5 = 266,
	GP_2_15_FN___2 = 267,
	GP_2_16_FN___2 = 268,
	GP_2_17_FN___2 = 269,
	GP_2_18_FN___2 = 270,
	GP_2_19_FN___2 = 271,
	GP_3_0_FN___5 = 272,
	GP_3_1_FN___5 = 273,
	GP_3_2_FN___5 = 274,
	GP_3_3_FN___5 = 275,
	GP_3_4_FN___5 = 276,
	GP_3_5_FN___5 = 277,
	GP_3_6_FN___5 = 278,
	GP_3_7_FN___5 = 279,
	GP_3_8_FN___5 = 280,
	GP_3_9_FN___5 = 281,
	GP_3_10_FN___5 = 282,
	GP_3_11_FN___5 = 283,
	GP_3_12_FN___5 = 284,
	GP_3_13_FN___5 = 285,
	GP_3_14_FN___5 = 286,
	GP_3_15_FN___5 = 287,
	GP_3_16_FN___2 = 288,
	GP_3_17_FN = 289,
	GP_3_18_FN = 290,
	GP_3_19_FN = 291,
	GP_3_20_FN = 292,
	GP_3_21_FN = 293,
	GP_3_22_FN = 294,
	GP_3_23_FN = 295,
	GP_3_24_FN = 296,
	GP_3_25_FN = 297,
	GP_3_26_FN = 298,
	GP_3_27_FN = 299,
	GP_3_28_FN = 300,
	GP_3_29_FN = 301,
	GP_4_0_FN___5 = 302,
	GP_4_1_FN___5 = 303,
	GP_4_2_FN___5 = 304,
	GP_4_3_FN___5 = 305,
	GP_4_4_FN___5 = 306,
	GP_4_5_FN___5 = 307,
	GP_4_6_FN___5 = 308,
	GP_4_7_FN___5 = 309,
	GP_4_8_FN___5 = 310,
	GP_4_9_FN___5 = 311,
	GP_4_10_FN___5 = 312,
	GP_4_11_FN___5 = 313,
	GP_4_12_FN___5 = 314,
	GP_4_13_FN___5 = 315,
	GP_4_14_FN___5 = 316,
	GP_4_15_FN___5 = 317,
	GP_4_16_FN___5 = 318,
	GP_4_17_FN___5 = 319,
	GP_4_18_FN___2 = 320,
	GP_4_19_FN___2 = 321,
	GP_4_20_FN___2 = 322,
	GP_4_21_FN___2 = 323,
	GP_4_22_FN___2 = 324,
	GP_4_23_FN___2 = 325,
	GP_4_24_FN___2 = 326,
	GP_5_0_FN___5 = 327,
	GP_5_1_FN___5 = 328,
	GP_5_2_FN___5 = 329,
	GP_5_3_FN___5 = 330,
	GP_5_4_FN___5 = 331,
	GP_5_5_FN___5 = 332,
	GP_5_6_FN___5 = 333,
	GP_5_7_FN___5 = 334,
	GP_5_8_FN___5 = 335,
	GP_5_9_FN___5 = 336,
	GP_5_10_FN___5 = 337,
	GP_5_11_FN___5 = 338,
	GP_5_12_FN___5 = 339,
	GP_5_13_FN___5 = 340,
	GP_5_14_FN___5 = 341,
	GP_5_15_FN___4 = 342,
	GP_5_16_FN___4 = 343,
	GP_5_17_FN___4 = 344,
	GP_5_18_FN___4 = 345,
	GP_5_19_FN___4 = 346,
	GP_5_20_FN___4 = 347,
	GP_6_0_FN___4 = 348,
	GP_6_1_FN___4 = 349,
	GP_6_2_FN___4 = 350,
	GP_6_3_FN___4 = 351,
	GP_6_4_FN___4 = 352,
	GP_6_5_FN___4 = 353,
	GP_6_6_FN___4 = 354,
	GP_6_7_FN___4 = 355,
	GP_6_8_FN___4 = 356,
	GP_6_9_FN___4 = 357,
	GP_6_10_FN___4 = 358,
	GP_6_11_FN___4 = 359,
	GP_6_12_FN___4 = 360,
	GP_6_13_FN___4 = 361,
	GP_6_14_FN___4 = 362,
	GP_6_15_FN___4 = 363,
	GP_6_16_FN___4 = 364,
	GP_6_17_FN___4 = 365,
	GP_6_18_FN___4 = 366,
	GP_6_19_FN___4 = 367,
	GP_6_20_FN___4 = 368,
	GP_7_0_FN___4 = 369,
	GP_7_1_FN___4 = 370,
	GP_7_2_FN___4 = 371,
	GP_7_3_FN___4 = 372,
	GP_7_4_FN = 373,
	GP_7_5_FN = 374,
	GP_7_6_FN = 375,
	GP_7_7_FN = 376,
	GP_7_8_FN = 377,
	GP_7_9_FN = 378,
	GP_7_10_FN = 379,
	GP_7_11_FN = 380,
	GP_7_12_FN = 381,
	GP_7_13_FN = 382,
	GP_7_14_FN = 383,
	GP_7_15_FN = 384,
	GP_7_16_FN = 385,
	GP_7_17_FN = 386,
	GP_7_18_FN = 387,
	GP_7_19_FN = 388,
	GP_7_20_FN = 389,
	GP_8_0_FN = 390,
	GP_8_1_FN = 391,
	GP_8_2_FN = 392,
	GP_8_3_FN = 393,
	GP_8_4_FN = 394,
	GP_8_5_FN = 395,
	GP_8_6_FN = 396,
	GP_8_7_FN = 397,
	GP_8_8_FN = 398,
	GP_8_9_FN = 399,
	GP_8_10_FN = 400,
	GP_8_11_FN = 401,
	GP_8_12_FN = 402,
	GP_8_13_FN = 403,
	FN_IP0SR0_3_0 = 404,
	FN_ERROROUTC_N_B = 405,
	FN_TCLK2_B___5 = 406,
	FN_IP1SR0_3_0 = 407,
	FN_MSIOF5_SS1 = 408,
	FN_IP2SR0_3_0 = 409,
	FN_MSIOF2_TXD___2 = 410,
	FN_HCTS1_N_A___4 = 411,
	FN_CTS1_N_A = 412,
	FN_IP0SR0_7_4 = 413,
	FN_MSIOF3_SS1___2 = 414,
	FN_IP1SR0_7_4 = 415,
	FN_MSIOF5_SYNC = 416,
	FN_IP2SR0_7_4 = 417,
	FN_MSIOF2_SCK___2 = 418,
	FN_HRTS1_N_A___4 = 419,
	FN_RTS1_N_A = 420,
	FN_IP0SR0_11_8 = 421,
	FN_MSIOF3_SS2___2 = 422,
	FN_IP1SR0_11_8 = 423,
	FN_MSIOF5_TXD = 424,
	FN_IP2SR0_11_8 = 425,
	FN_MSIOF2_RXD___2 = 426,
	FN_HSCK1_A___4 = 427,
	FN_SCK1_A = 428,
	FN_IP0SR0_15_12 = 429,
	FN_IRQ3_A = 430,
	FN_MSIOF3_SCK___2 = 431,
	FN_IP1SR0_15_12 = 432,
	FN_MSIOF5_SCK = 433,
	FN_IP0SR0_19_16 = 434,
	FN_IRQ2_A = 435,
	FN_MSIOF3_TXD___2 = 436,
	FN_IP1SR0_19_16 = 437,
	FN_MSIOF5_RXD = 438,
	FN_IP0SR0_23_20 = 439,
	FN_IRQ1_A = 440,
	FN_MSIOF3_RXD___2 = 441,
	FN_IP1SR0_23_20 = 442,
	FN_MSIOF2_SS2___2 = 443,
	FN_TCLK1_A___5 = 444,
	FN_IRQ2_B = 445,
	FN_IP0SR0_27_24 = 446,
	FN_IRQ0_A = 447,
	FN_MSIOF3_SYNC___2 = 448,
	FN_IP1SR0_27_24 = 449,
	FN_MSIOF2_SS1___2 = 450,
	FN_HTX1_A___4 = 451,
	FN_TX1_A___5 = 452,
	FN_IP0SR0_31_28 = 453,
	FN_MSIOF5_SS2 = 454,
	FN_IP1SR0_31_28 = 455,
	FN_MSIOF2_SYNC___2 = 456,
	FN_HRX1_A___4 = 457,
	FN_RX1_A___5 = 458,
	FN_IP0SR1_3_0 = 459,
	FN_MSIOF1_SS2___2 = 460,
	FN_HTX3_B___4 = 461,
	FN_TX3_B___4 = 462,
	FN_IP1SR1_3_0 = 463,
	FN_MSIOF0_SYNC___5 = 464,
	FN_HCTS1_N_B___4 = 465,
	FN_CTS1_N_B = 466,
	FN_CANFD5_TX_B = 467,
	FN_IP2SR1_3_0 = 468,
	FN_HRX0___4 = 469,
	FN_RX0___5 = 470,
	FN_IP3SR1_3_0 = 471,
	FN_HRX3_A___4 = 472,
	FN_SCK3_A = 473,
	FN_MSIOF4_SS2 = 474,
	FN_IP0SR1_7_4 = 475,
	FN_MSIOF1_SS1___2 = 476,
	FN_HCTS3_N_B = 477,
	FN_RX3_B___4 = 478,
	FN_IP1SR1_7_4 = 479,
	FN_MSIOF0_TXD___5 = 480,
	FN_HRTS1_N_B___4 = 481,
	FN_RTS1_N_B = 482,
	FN_CANFD5_RX_B = 483,
	FN_IP2SR1_7_4 = 484,
	FN_SCIF_CLK = 485,
	FN_IRQ4_A = 486,
	FN_IP3SR1_7_4 = 487,
	FN_HSCK3_A = 488,
	FN_CTS3_N_A = 489,
	FN_MSIOF4_SCK = 490,
	FN_TPU0TO0_B = 491,
	FN_IP0SR1_11_8 = 492,
	FN_MSIOF1_SYNC___2 = 493,
	FN_HRTS3_N_B = 494,
	FN_RTS3_N_B = 495,
	FN_IP1SR1_11_8 = 496,
	FN_MSIOF0_SCK___5 = 497,
	FN_HSCK1_B___4 = 498,
	FN_SCK1_B = 499,
	FN_IP2SR1_11_8 = 500,
	FN_SSI_SCK = 501,
	FN_TCLK3_B = 502,
	FN_IP3SR1_11_8 = 503,
	FN_HRTS3_N_A = 504,
	FN_RTS3_N_A = 505,
	FN_MSIOF4_TXD = 506,
	FN_TPU0TO1_B = 507,
	FN_IP0SR1_15_12 = 508,
	FN_MSIOF1_SCK___2 = 509,
	FN_HSCK3_B = 510,
	FN_CTS3_N_B = 511,
	FN_IP1SR1_15_12 = 512,
	FN_MSIOF0_RXD___5 = 513,
	FN_IP2SR1_15_12 = 514,
	FN_SSI_WS = 515,
	FN_TCLK4_B = 516,
	FN_IP3SR1_15_12 = 517,
	FN_HCTS3_N_A = 518,
	FN_RX3_A___4 = 519,
	FN_MSIOF4_RXD = 520,
	FN_IP0SR1_19_16 = 521,
	FN_MSIOF1_TXD___2 = 522,
	FN_HRX3_B___4 = 523,
	FN_SCK3_B = 524,
	FN_IP1SR1_19_16 = 525,
	FN_HTX0___4 = 526,
	FN_TX0___5 = 527,
	FN_IP2SR1_19_16 = 528,
	FN_SSI_SD = 529,
	FN_IRQ0_B = 530,
	FN_IP3SR1_19_16 = 531,
	FN_HTX3_A___4 = 532,
	FN_TX3_A___4 = 533,
	FN_MSIOF4_SYNC = 534,
	FN_IP0SR1_23_20 = 535,
	FN_MSIOF1_RXD___2 = 536,
	FN_IP1SR1_23_20 = 537,
	FN_HCTS0_N___4 = 538,
	FN_CTS0_N___5 = 539,
	FN_PWM8 = 540,
	FN_IP2SR1_23_20 = 541,
	FN_AUDIO_CLKOUT = 542,
	FN_IRQ1_B = 543,
	FN_IP0SR1_27_24 = 544,
	FN_MSIOF0_SS2___5 = 545,
	FN_HTX1_B___4 = 546,
	FN_TX1_B___5 = 547,
	FN_IP1SR1_27_24 = 548,
	FN_HRTS0_N___4 = 549,
	FN_RTS0_N___5 = 550,
	FN_PWM9 = 551,
	FN_IP2SR1_27_24 = 552,
	FN_AUDIO_CLKIN = 553,
	FN_PWM3_A___5 = 554,
	FN_IP0SR1_31_28 = 555,
	FN_MSIOF0_SS1___5 = 556,
	FN_HRX1_B___4 = 557,
	FN_RX1_B___5 = 558,
	FN_IP1SR1_31_28 = 559,
	FN_HSCK0___4 = 560,
	FN_SCK0___5 = 561,
	FN_PWM0___4 = 562,
	FN_IP2SR1_31_28 = 563,
	FN_TCLK2_A___5 = 564,
	FN_MSIOF4_SS1 = 565,
	FN_IRQ3_B = 566,
	FN_IP0SR2_3_0 = 567,
	FN_FXR_TXDA___2 = 568,
	FN_CANFD1_TX___5 = 569,
	FN_TPU0TO2_B = 570,
	FN_IP1SR2_3_0 = 571,
	FN_TPU0TO0_A = 572,
	FN_CANFD6_RX = 573,
	FN_TCLK1_B___5 = 574,
	FN_IP2SR2_3_0 = 575,
	FN_CANFD4_TX = 576,
	FN_PWM4 = 577,
	FN_IP0SR2_7_4 = 578,
	FN_FXR_TXENA_N_A = 579,
	FN_CANFD1_RX___5 = 580,
	FN_TPU0TO3_B = 581,
	FN_IP1SR2_7_4 = 582,
	FN_CAN_CLK___4 = 583,
	FN_FXR_TXENA_N_B = 584,
	FN_IP2SR2_7_4 = 585,
	FN_CANFD4_RX = 586,
	FN_PWM5 = 587,
	FN_IP0SR2_11_8 = 588,
	FN_RXDA_EXTFXR___2 = 589,
	FN_CANFD5_TX_A = 590,
	FN_IRQ5___5 = 591,
	FN_IP1SR2_11_8 = 592,
	FN_CANFD0_TX = 593,
	FN_FXR_TXENB_N_B = 594,
	FN_IP2SR2_11_8 = 595,
	FN_CANFD7_TX = 596,
	FN_PWM6 = 597,
	FN_IP0SR2_15_12 = 598,
	FN_CLK_EXTFXR___2 = 599,
	FN_CANFD5_RX_A = 600,
	FN_IRQ4_B = 601,
	FN_IP1SR2_15_12 = 602,
	FN_CANFD0_RX = 603,
	FN_STPWT_EXTFXR = 604,
	FN_IP2SR2_15_12 = 605,
	FN_CANFD7_RX = 606,
	FN_PWM7 = 607,
	FN_IP0SR2_19_16 = 608,
	FN_RXDB_EXTFXR___2 = 609,
	FN_IP1SR2_19_16 = 610,
	FN_CANFD2_TX = 611,
	FN_TPU0TO2_A = 612,
	FN_TCLK3_C = 613,
	FN_IP0SR2_23_20 = 614,
	FN_FXR_TXENB_N_A = 615,
	FN_IP1SR2_23_20 = 616,
	FN_CANFD2_RX = 617,
	FN_TPU0TO3_A = 618,
	FN_PWM1_B___5 = 619,
	FN_TCLK4_C = 620,
	FN_IP0SR2_27_24 = 621,
	FN_FXR_TXDB___2 = 622,
	FN_IP1SR2_27_24 = 623,
	FN_CANFD3_TX = 624,
	FN_PWM2 = 625,
	FN_IP0SR2_31_28 = 626,
	FN_TPU0TO1_A = 627,
	FN_CANFD6_TX = 628,
	FN_TCLK2_C = 629,
	FN_IP1SR2_31_28 = 630,
	FN_CANFD3_RX = 631,
	FN_PWM3_B___5 = 632,
	FN_IP0SR3_3_0 = 633,
	FN_MMC_SD_D1 = 634,
	FN_IP1SR3_3_0 = 635,
	FN_MMC_D7___2 = 636,
	FN_IP2SR3_3_0 = 637,
	FN_QSPI0_IO3___2 = 638,
	FN_IP3SR3_3_0 = 639,
	FN_QSPI1_IO2___2 = 640,
	FN_IP0SR3_7_4 = 641,
	FN_MMC_SD_D0 = 642,
	FN_IP1SR3_7_4 = 643,
	FN_MMC_D6___2 = 644,
	FN_IP2SR3_7_4 = 645,
	FN_QSPI0_IO2___2 = 646,
	FN_IP3SR3_7_4 = 647,
	FN_QSPI1_SSL___2 = 648,
	FN_IP0SR3_11_8 = 649,
	FN_MMC_SD_D2 = 650,
	FN_IP1SR3_11_8 = 651,
	FN_MMC_SD_CMD = 652,
	FN_IP2SR3_11_8 = 653,
	FN_QSPI0_MISO_IO1___2 = 654,
	FN_IP3SR3_11_8 = 655,
	FN_QSPI1_IO3___2 = 656,
	FN_IP0SR3_15_12 = 657,
	FN_MMC_SD_CLK = 658,
	FN_IP1SR3_15_12 = 659,
	FN_SD_CD = 660,
	FN_IP2SR3_15_12 = 661,
	FN_QSPI0_MOSI_IO0___2 = 662,
	FN_IP3SR3_15_12 = 663,
	FN_RPC_RESET_N___2 = 664,
	FN_IP0SR3_19_16 = 665,
	FN_MMC_DS___2 = 666,
	FN_IP1SR3_19_16 = 667,
	FN_SD_WP = 668,
	FN_IP2SR3_19_16 = 669,
	FN_QSPI0_SPCLK___2 = 670,
	FN_IP3SR3_19_16 = 671,
	FN_RPC_WP_N___2 = 672,
	FN_IP0SR3_23_20 = 673,
	FN_MMC_SD_D3 = 674,
	FN_IP1SR3_23_20 = 675,
	FN_IPC_CLKIN = 676,
	FN_IPC_CLKEN_IN = 677,
	FN_PWM1_A___5 = 678,
	FN_TCLK3_A = 679,
	FN_IP2SR3_23_20 = 680,
	FN_QSPI1_MOSI_IO0___2 = 681,
	FN_IP3SR3_23_20 = 682,
	FN_RPC_INT_N___2 = 683,
	FN_IP0SR3_27_24 = 684,
	FN_MMC_D5___2 = 685,
	FN_IP1SR3_27_24 = 686,
	FN_IPC_CLKOUT = 687,
	FN_IPC_CLKEN_OUT = 688,
	FN_ERROROUTC_N_A = 689,
	FN_TCLK4_A = 690,
	FN_IP2SR3_27_24 = 691,
	FN_QSPI1_SPCLK___2 = 692,
	FN_IP0SR3_31_28 = 693,
	FN_MMC_D4___2 = 694,
	FN_IP1SR3_31_28 = 695,
	FN_QSPI0_SSL___2 = 696,
	FN_IP2SR3_31_28 = 697,
	FN_QSPI1_MISO_IO1___2 = 698,
	FN_IP0SR4_3_0 = 699,
	FN_TSN0_MDIO = 700,
	FN_IP1SR4_3_0 = 701,
	FN_TSN0_AVTP_PPS0 = 702,
	FN_IP2SR4_3_0 = 703,
	FN_TSN0_RD3 = 704,
	FN_IP3SR4_3_0 = 705,
	FN_AVS1___4 = 706,
	FN_IP0SR4_7_4 = 707,
	FN_TSN0_MDC = 708,
	FN_IP1SR4_7_4 = 709,
	FN_TSN0_TX_CTL = 710,
	FN_IP2SR4_7_4 = 711,
	FN_TSN0_RD2 = 712,
	FN_IP0SR4_11_8 = 713,
	FN_TSN0_AVTP_PPS1 = 714,
	FN_IP1SR4_11_8 = 715,
	FN_TSN0_RD0 = 716,
	FN_IP2SR4_11_8 = 717,
	FN_TSN0_TD3 = 718,
	FN_IP0SR4_15_12 = 719,
	FN_TSN0_PHY_INT = 720,
	FN_IP1SR4_15_12 = 721,
	FN_TSN0_RXC = 722,
	FN_IP2SR4_15_12 = 723,
	FN_TSN0_TD2 = 724,
	FN_IP0SR4_19_16 = 725,
	FN_TSN0_LINK = 726,
	FN_IP1SR4_19_16 = 727,
	FN_TSN0_TXC = 728,
	FN_IP2SR4_19_16 = 729,
	FN_TSN0_TXCREFCLK = 730,
	FN_IP0SR4_23_20 = 731,
	FN_TSN0_AVTP_MATCH = 732,
	FN_IP1SR4_23_20 = 733,
	FN_TSN0_RD1 = 734,
	FN_IP2SR4_23_20 = 735,
	FN_PCIE0_CLKREQ_N = 736,
	FN_IP0SR4_27_24 = 737,
	FN_TSN0_AVTP_CAPTURE = 738,
	FN_IP1SR4_27_24 = 739,
	FN_TSN0_TD1 = 740,
	FN_IP2SR4_27_24 = 741,
	FN_PCIE1_CLKREQ_N = 742,
	FN_IP0SR4_31_28 = 743,
	FN_TSN0_RX_CTL = 744,
	FN_IP1SR4_31_28 = 745,
	FN_TSN0_TD0 = 746,
	FN_IP2SR4_31_28 = 747,
	FN_AVS0 = 748,
	FN_IP0SR5_3_0 = 749,
	FN_AVB2_AVTP_PPS = 750,
	FN_IP1SR5_3_0 = 751,
	FN_AVB2_TD3 = 752,
	FN_IP2SR5_3_0 = 753,
	FN_AVB2_TXC = 754,
	FN_IP0SR5_7_4 = 755,
	FN_AVB2_AVTP_CAPTURE = 756,
	FN_IP1SR5_7_4 = 757,
	FN_AVB2_RD3 = 758,
	FN_IP2SR5_7_4 = 759,
	FN_AVB2_RD0 = 760,
	FN_IP0SR5_11_8 = 761,
	FN_AVB2_AVTP_MATCH = 762,
	FN_IP1SR5_11_8 = 763,
	FN_AVB2_MDIO = 764,
	FN_IP2SR5_11_8 = 765,
	FN_AVB2_RXC = 766,
	FN_IP0SR5_15_12 = 767,
	FN_AVB2_LINK = 768,
	FN_IP1SR5_15_12 = 769,
	FN_AVB2_TD2 = 770,
	FN_IP2SR5_15_12 = 771,
	FN_AVB2_TX_CTL = 772,
	FN_IP0SR5_19_16 = 773,
	FN_AVB2_PHY_INT = 774,
	FN_IP1SR5_19_16 = 775,
	FN_AVB2_TD1 = 776,
	FN_IP2SR5_19_16 = 777,
	FN_AVB2_RX_CTL = 778,
	FN_IP0SR5_23_20 = 779,
	FN_AVB2_MAGIC = 780,
	FN_IP1SR5_23_20 = 781,
	FN_AVB2_RD2 = 782,
	FN_IP0SR5_27_24 = 783,
	FN_AVB2_MDC = 784,
	FN_IP1SR5_27_24 = 785,
	FN_AVB2_RD1 = 786,
	FN_IP0SR5_31_28 = 787,
	FN_AVB2_TXCREFCLK = 788,
	FN_IP1SR5_31_28 = 789,
	FN_AVB2_TD0 = 790,
	FN_IP0SR6_3_0 = 791,
	FN_AVB1_MDIO = 792,
	FN_IP1SR6_3_0 = 793,
	FN_AVB1_RXC = 794,
	FN_AVB1_MII_RXC = 795,
	FN_IP2SR6_3_0 = 796,
	FN_AVB1_TD2 = 797,
	FN_AVB1_MII_TD2 = 798,
	FN_IP0SR6_7_4 = 799,
	FN_AVB1_MAGIC = 800,
	FN_IP1SR6_7_4 = 801,
	FN_AVB1_RX_CTL = 802,
	FN_AVB1_MII_RX_DV = 803,
	FN_IP2SR6_7_4 = 804,
	FN_AVB1_RD2 = 805,
	FN_AVB1_MII_RD2 = 806,
	FN_IP0SR6_11_8 = 807,
	FN_AVB1_MDC = 808,
	FN_IP1SR6_11_8 = 809,
	FN_AVB1_AVTP_PPS = 810,
	FN_AVB1_MII_COL = 811,
	FN_IP2SR6_11_8 = 812,
	FN_AVB1_TD3 = 813,
	FN_AVB1_MII_TD3 = 814,
	FN_IP0SR6_15_12 = 815,
	FN_AVB1_PHY_INT = 816,
	FN_IP1SR6_15_12 = 817,
	FN_AVB1_AVTP_CAPTURE = 818,
	FN_AVB1_MII_CRS = 819,
	FN_IP2SR6_15_12 = 820,
	FN_AVB1_RD3 = 821,
	FN_AVB1_MII_RD3 = 822,
	FN_IP0SR6_19_16 = 823,
	FN_AVB1_LINK = 824,
	FN_AVB1_MII_TX_ER = 825,
	FN_IP1SR6_19_16 = 826,
	FN_AVB1_TD1 = 827,
	FN_AVB1_MII_TD1 = 828,
	FN_IP2SR6_19_16 = 829,
	FN_AVB1_TXCREFCLK = 830,
	FN_IP0SR6_23_20 = 831,
	FN_AVB1_AVTP_MATCH = 832,
	FN_AVB1_MII_RX_ER = 833,
	FN_IP1SR6_23_20 = 834,
	FN_AVB1_TD0 = 835,
	FN_AVB1_MII_TD0 = 836,
	FN_IP0SR6_27_24 = 837,
	FN_AVB1_TXC = 838,
	FN_AVB1_MII_TXC = 839,
	FN_IP1SR6_27_24 = 840,
	FN_AVB1_RD1 = 841,
	FN_AVB1_MII_RD1 = 842,
	FN_IP0SR6_31_28 = 843,
	FN_AVB1_TX_CTL = 844,
	FN_AVB1_MII_TX_EN = 845,
	FN_IP1SR6_31_28 = 846,
	FN_AVB1_RD0 = 847,
	FN_AVB1_MII_RD0 = 848,
	FN_IP0SR7_3_0 = 849,
	FN_AVB0_AVTP_PPS = 850,
	FN_AVB0_MII_COL = 851,
	FN_IP1SR7_3_0 = 852,
	FN_AVB0_RD3 = 853,
	FN_AVB0_MII_RD3 = 854,
	FN_IP2SR7_3_0 = 855,
	FN_AVB0_TX_CTL = 856,
	FN_AVB0_MII_TX_EN = 857,
	FN_IP0SR7_7_4 = 858,
	FN_AVB0_AVTP_CAPTURE = 859,
	FN_AVB0_MII_CRS = 860,
	FN_IP1SR7_7_4 = 861,
	FN_AVB0_TXCREFCLK = 862,
	FN_IP2SR7_7_4 = 863,
	FN_AVB0_RD1 = 864,
	FN_AVB0_MII_RD1 = 865,
	FN_IP0SR7_11_8 = 866,
	FN_AVB0_AVTP_MATCH = 867,
	FN_AVB0_MII_RX_ER = 868,
	FN_CC5_OSCOUT = 869,
	FN_IP1SR7_11_8 = 870,
	FN_AVB0_MAGIC = 871,
	FN_IP2SR7_11_8 = 872,
	FN_AVB0_RD0 = 873,
	FN_AVB0_MII_RD0 = 874,
	FN_IP0SR7_15_12 = 875,
	FN_AVB0_TD3 = 876,
	FN_AVB0_MII_TD3 = 877,
	FN_IP1SR7_15_12 = 878,
	FN_AVB0_TD0 = 879,
	FN_AVB0_MII_TD0 = 880,
	FN_IP2SR7_15_12 = 881,
	FN_AVB0_RXC = 882,
	FN_AVB0_MII_RXC = 883,
	FN_IP0SR7_19_16 = 884,
	FN_AVB0_LINK = 885,
	FN_AVB0_MII_TX_ER = 886,
	FN_IP1SR7_19_16 = 887,
	FN_AVB0_RD2 = 888,
	FN_AVB0_MII_RD2 = 889,
	FN_IP2SR7_19_16 = 890,
	FN_AVB0_RX_CTL = 891,
	FN_AVB0_MII_RX_DV = 892,
	FN_IP0SR7_23_20 = 893,
	FN_AVB0_PHY_INT = 894,
	FN_IP1SR7_23_20 = 895,
	FN_AVB0_MDC = 896,
	FN_IP0SR7_27_24 = 897,
	FN_AVB0_TD2 = 898,
	FN_AVB0_MII_TD2 = 899,
	FN_IP1SR7_27_24 = 900,
	FN_AVB0_MDIO = 901,
	FN_IP0SR7_31_28 = 902,
	FN_AVB0_TD1 = 903,
	FN_AVB0_MII_TD1 = 904,
	FN_IP1SR7_31_28 = 905,
	FN_AVB0_TXC = 906,
	FN_AVB0_MII_TXC = 907,
	FN_IP0SR8_3_0 = 908,
	FN_SCL0___2 = 909,
	FN_IP1SR8_3_0 = 910,
	FN_SCL4___2 = 911,
	FN_HRX2___2 = 912,
	FN_SCK4___2 = 913,
	FN_IP0SR8_7_4 = 914,
	FN_SDA0___2 = 915,
	FN_IP1SR8_7_4 = 916,
	FN_SDA4___2 = 917,
	FN_HTX2___2 = 918,
	FN_CTS4_N___2 = 919,
	FN_IP0SR8_11_8 = 920,
	FN_SCL1___2 = 921,
	FN_IP1SR8_11_8 = 922,
	FN_SCL5___2 = 923,
	FN_HRTS2_N___2 = 924,
	FN_RTS4_N___2 = 925,
	FN_IP0SR8_15_12 = 926,
	FN_SDA1___2 = 927,
	FN_IP1SR8_15_12 = 928,
	FN_SDA5___2 = 929,
	FN_SCIF_CLK2 = 930,
	FN_IP0SR8_19_16 = 931,
	FN_SCL2___2 = 932,
	FN_IP1SR8_19_16 = 933,
	FN_HCTS2_N___2 = 934,
	FN_TX4___2 = 935,
	FN_IP0SR8_23_20 = 936,
	FN_SDA2___2 = 937,
	FN_IP1SR8_23_20 = 938,
	FN_HSCK2___2 = 939,
	FN_RX4___2 = 940,
	FN_IP0SR8_27_24 = 941,
	FN_SCL3___2 = 942,
	FN_IP0SR8_31_28 = 943,
	FN_SDA3___2 = 944,
	FN_SEL_SDA5_0 = 945,
	FN_SEL_SDA5_1 = 946,
	FN_SEL_SCL5_0 = 947,
	FN_SEL_SCL5_1 = 948,
	FN_SEL_SDA4_0 = 949,
	FN_SEL_SDA4_1 = 950,
	FN_SEL_SCL4_0 = 951,
	FN_SEL_SCL4_1 = 952,
	FN_SEL_SDA3_0 = 953,
	FN_SEL_SDA3_1 = 954,
	FN_SEL_SCL3_0 = 955,
	FN_SEL_SCL3_1 = 956,
	FN_SEL_SDA2_0 = 957,
	FN_SEL_SDA2_1 = 958,
	FN_SEL_SCL2_0 = 959,
	FN_SEL_SCL2_1 = 960,
	FN_SEL_SDA1_0 = 961,
	FN_SEL_SDA1_1 = 962,
	FN_SEL_SCL1_0 = 963,
	FN_SEL_SCL1_1 = 964,
	FN_SEL_SDA0_0 = 965,
	FN_SEL_SDA0_1 = 966,
	FN_SEL_SCL0_0 = 967,
	FN_SEL_SCL0_1 = 968,
	PINMUX_FUNCTION_END___5 = 969,
	PINMUX_MARK_BEGIN___5 = 970,
	IP0SR0_3_0_MARK = 971,
	ERROROUTC_N_B_MARK = 972,
	TCLK2_B_MARK___5 = 973,
	IP1SR0_3_0_MARK = 974,
	MSIOF5_SS1_MARK = 975,
	IP2SR0_3_0_MARK = 976,
	MSIOF2_TXD_MARK___2 = 977,
	HCTS1_N_A_MARK___4 = 978,
	CTS1_N_A_MARK = 979,
	IP0SR0_7_4_MARK = 980,
	MSIOF3_SS1_MARK___2 = 981,
	IP1SR0_7_4_MARK = 982,
	MSIOF5_SYNC_MARK = 983,
	IP2SR0_7_4_MARK = 984,
	MSIOF2_SCK_MARK___2 = 985,
	HRTS1_N_A_MARK___4 = 986,
	RTS1_N_A_MARK = 987,
	IP0SR0_11_8_MARK = 988,
	MSIOF3_SS2_MARK___2 = 989,
	IP1SR0_11_8_MARK = 990,
	MSIOF5_TXD_MARK = 991,
	IP2SR0_11_8_MARK = 992,
	MSIOF2_RXD_MARK___2 = 993,
	HSCK1_A_MARK___4 = 994,
	SCK1_A_MARK = 995,
	IP0SR0_15_12_MARK = 996,
	IRQ3_A_MARK = 997,
	MSIOF3_SCK_MARK___2 = 998,
	IP1SR0_15_12_MARK = 999,
	MSIOF5_SCK_MARK = 1000,
	IP0SR0_19_16_MARK = 1001,
	IRQ2_A_MARK = 1002,
	MSIOF3_TXD_MARK___2 = 1003,
	IP1SR0_19_16_MARK = 1004,
	MSIOF5_RXD_MARK = 1005,
	IP0SR0_23_20_MARK = 1006,
	IRQ1_A_MARK = 1007,
	MSIOF3_RXD_MARK___2 = 1008,
	IP1SR0_23_20_MARK = 1009,
	MSIOF2_SS2_MARK___2 = 1010,
	TCLK1_A_MARK___5 = 1011,
	IRQ2_B_MARK = 1012,
	IP0SR0_27_24_MARK = 1013,
	IRQ0_A_MARK = 1014,
	MSIOF3_SYNC_MARK___2 = 1015,
	IP1SR0_27_24_MARK = 1016,
	MSIOF2_SS1_MARK___2 = 1017,
	HTX1_A_MARK___4 = 1018,
	TX1_A_MARK___5 = 1019,
	IP0SR0_31_28_MARK = 1020,
	MSIOF5_SS2_MARK = 1021,
	IP1SR0_31_28_MARK = 1022,
	MSIOF2_SYNC_MARK___2 = 1023,
	HRX1_A_MARK___4 = 1024,
	RX1_A_MARK___5 = 1025,
	IP0SR1_3_0_MARK = 1026,
	MSIOF1_SS2_MARK___2 = 1027,
	HTX3_B_MARK___4 = 1028,
	TX3_B_MARK___4 = 1029,
	IP1SR1_3_0_MARK = 1030,
	MSIOF0_SYNC_MARK___5 = 1031,
	HCTS1_N_B_MARK___4 = 1032,
	CTS1_N_B_MARK = 1033,
	CANFD5_TX_B_MARK = 1034,
	IP2SR1_3_0_MARK = 1035,
	HRX0_MARK___4 = 1036,
	RX0_MARK___5 = 1037,
	IP3SR1_3_0_MARK = 1038,
	HRX3_A_MARK___4 = 1039,
	SCK3_A_MARK = 1040,
	MSIOF4_SS2_MARK = 1041,
	IP0SR1_7_4_MARK = 1042,
	MSIOF1_SS1_MARK___2 = 1043,
	HCTS3_N_B_MARK = 1044,
	RX3_B_MARK___4 = 1045,
	IP1SR1_7_4_MARK = 1046,
	MSIOF0_TXD_MARK___5 = 1047,
	HRTS1_N_B_MARK___4 = 1048,
	RTS1_N_B_MARK = 1049,
	CANFD5_RX_B_MARK = 1050,
	IP2SR1_7_4_MARK = 1051,
	SCIF_CLK_MARK = 1052,
	IRQ4_A_MARK = 1053,
	IP3SR1_7_4_MARK = 1054,
	HSCK3_A_MARK = 1055,
	CTS3_N_A_MARK = 1056,
	MSIOF4_SCK_MARK = 1057,
	TPU0TO0_B_MARK = 1058,
	IP0SR1_11_8_MARK = 1059,
	MSIOF1_SYNC_MARK___2 = 1060,
	HRTS3_N_B_MARK = 1061,
	RTS3_N_B_MARK = 1062,
	IP1SR1_11_8_MARK = 1063,
	MSIOF0_SCK_MARK___5 = 1064,
	HSCK1_B_MARK___4 = 1065,
	SCK1_B_MARK = 1066,
	IP2SR1_11_8_MARK = 1067,
	SSI_SCK_MARK = 1068,
	TCLK3_B_MARK = 1069,
	IP3SR1_11_8_MARK = 1070,
	HRTS3_N_A_MARK = 1071,
	RTS3_N_A_MARK = 1072,
	MSIOF4_TXD_MARK = 1073,
	TPU0TO1_B_MARK = 1074,
	IP0SR1_15_12_MARK = 1075,
	MSIOF1_SCK_MARK___2 = 1076,
	HSCK3_B_MARK = 1077,
	CTS3_N_B_MARK = 1078,
	IP1SR1_15_12_MARK = 1079,
	MSIOF0_RXD_MARK___5 = 1080,
	IP2SR1_15_12_MARK = 1081,
	SSI_WS_MARK = 1082,
	TCLK4_B_MARK = 1083,
	IP3SR1_15_12_MARK = 1084,
	HCTS3_N_A_MARK = 1085,
	RX3_A_MARK___4 = 1086,
	MSIOF4_RXD_MARK = 1087,
	IP0SR1_19_16_MARK = 1088,
	MSIOF1_TXD_MARK___2 = 1089,
	HRX3_B_MARK___4 = 1090,
	SCK3_B_MARK = 1091,
	IP1SR1_19_16_MARK = 1092,
	HTX0_MARK___4 = 1093,
	TX0_MARK___5 = 1094,
	IP2SR1_19_16_MARK = 1095,
	SSI_SD_MARK = 1096,
	IRQ0_B_MARK = 1097,
	IP3SR1_19_16_MARK = 1098,
	HTX3_A_MARK___4 = 1099,
	TX3_A_MARK___4 = 1100,
	MSIOF4_SYNC_MARK = 1101,
	IP0SR1_23_20_MARK = 1102,
	MSIOF1_RXD_MARK___2 = 1103,
	IP1SR1_23_20_MARK = 1104,
	HCTS0_N_MARK___4 = 1105,
	CTS0_N_MARK___5 = 1106,
	PWM8_MARK = 1107,
	IP2SR1_23_20_MARK = 1108,
	AUDIO_CLKOUT_MARK = 1109,
	IRQ1_B_MARK = 1110,
	IP0SR1_27_24_MARK = 1111,
	MSIOF0_SS2_MARK___5 = 1112,
	HTX1_B_MARK___4 = 1113,
	TX1_B_MARK___5 = 1114,
	IP1SR1_27_24_MARK = 1115,
	HRTS0_N_MARK___4 = 1116,
	RTS0_N_MARK___5 = 1117,
	PWM9_MARK = 1118,
	IP2SR1_27_24_MARK = 1119,
	AUDIO_CLKIN_MARK = 1120,
	PWM3_A_MARK___5 = 1121,
	IP0SR1_31_28_MARK = 1122,
	MSIOF0_SS1_MARK___5 = 1123,
	HRX1_B_MARK___4 = 1124,
	RX1_B_MARK___5 = 1125,
	IP1SR1_31_28_MARK = 1126,
	HSCK0_MARK___4 = 1127,
	SCK0_MARK___5 = 1128,
	PWM0_MARK___4 = 1129,
	IP2SR1_31_28_MARK = 1130,
	TCLK2_A_MARK___5 = 1131,
	MSIOF4_SS1_MARK = 1132,
	IRQ3_B_MARK = 1133,
	IP0SR2_3_0_MARK = 1134,
	FXR_TXDA_MARK___2 = 1135,
	CANFD1_TX_MARK___5 = 1136,
	TPU0TO2_B_MARK = 1137,
	IP1SR2_3_0_MARK = 1138,
	TPU0TO0_A_MARK = 1139,
	CANFD6_RX_MARK = 1140,
	TCLK1_B_MARK___5 = 1141,
	IP2SR2_3_0_MARK = 1142,
	CANFD4_TX_MARK = 1143,
	PWM4_MARK = 1144,
	IP0SR2_7_4_MARK = 1145,
	FXR_TXENA_N_A_MARK = 1146,
	CANFD1_RX_MARK___5 = 1147,
	TPU0TO3_B_MARK = 1148,
	IP1SR2_7_4_MARK = 1149,
	CAN_CLK_MARK___4 = 1150,
	FXR_TXENA_N_B_MARK = 1151,
	IP2SR2_7_4_MARK = 1152,
	CANFD4_RX_MARK = 1153,
	PWM5_MARK = 1154,
	IP0SR2_11_8_MARK = 1155,
	RXDA_EXTFXR_MARK___2 = 1156,
	CANFD5_TX_A_MARK = 1157,
	IRQ5_MARK___5 = 1158,
	IP1SR2_11_8_MARK = 1159,
	CANFD0_TX_MARK = 1160,
	FXR_TXENB_N_B_MARK = 1161,
	IP2SR2_11_8_MARK = 1162,
	CANFD7_TX_MARK = 1163,
	PWM6_MARK = 1164,
	IP0SR2_15_12_MARK = 1165,
	CLK_EXTFXR_MARK___2 = 1166,
	CANFD5_RX_A_MARK = 1167,
	IRQ4_B_MARK = 1168,
	IP1SR2_15_12_MARK = 1169,
	CANFD0_RX_MARK = 1170,
	STPWT_EXTFXR_MARK = 1171,
	IP2SR2_15_12_MARK = 1172,
	CANFD7_RX_MARK = 1173,
	PWM7_MARK = 1174,
	IP0SR2_19_16_MARK = 1175,
	RXDB_EXTFXR_MARK___2 = 1176,
	IP1SR2_19_16_MARK = 1177,
	CANFD2_TX_MARK = 1178,
	TPU0TO2_A_MARK = 1179,
	TCLK3_C_MARK = 1180,
	IP0SR2_23_20_MARK = 1181,
	FXR_TXENB_N_A_MARK = 1182,
	IP1SR2_23_20_MARK = 1183,
	CANFD2_RX_MARK = 1184,
	TPU0TO3_A_MARK = 1185,
	PWM1_B_MARK___5 = 1186,
	TCLK4_C_MARK = 1187,
	IP0SR2_27_24_MARK = 1188,
	FXR_TXDB_MARK___2 = 1189,
	IP1SR2_27_24_MARK = 1190,
	CANFD3_TX_MARK = 1191,
	PWM2_MARK = 1192,
	IP0SR2_31_28_MARK = 1193,
	TPU0TO1_A_MARK = 1194,
	CANFD6_TX_MARK = 1195,
	TCLK2_C_MARK = 1196,
	IP1SR2_31_28_MARK = 1197,
	CANFD3_RX_MARK = 1198,
	PWM3_B_MARK___5 = 1199,
	IP0SR3_3_0_MARK = 1200,
	MMC_SD_D1_MARK = 1201,
	IP1SR3_3_0_MARK = 1202,
	MMC_D7_MARK___2 = 1203,
	IP2SR3_3_0_MARK = 1204,
	QSPI0_IO3_MARK___5 = 1205,
	IP3SR3_3_0_MARK = 1206,
	QSPI1_IO2_MARK___5 = 1207,
	IP0SR3_7_4_MARK = 1208,
	MMC_SD_D0_MARK = 1209,
	IP1SR3_7_4_MARK = 1210,
	MMC_D6_MARK___2 = 1211,
	IP2SR3_7_4_MARK = 1212,
	QSPI0_IO2_MARK___5 = 1213,
	IP3SR3_7_4_MARK = 1214,
	QSPI1_SSL_MARK___5 = 1215,
	IP0SR3_11_8_MARK = 1216,
	MMC_SD_D2_MARK = 1217,
	IP1SR3_11_8_MARK = 1218,
	MMC_SD_CMD_MARK = 1219,
	IP2SR3_11_8_MARK = 1220,
	QSPI0_MISO_IO1_MARK___5 = 1221,
	IP3SR3_11_8_MARK = 1222,
	QSPI1_IO3_MARK___5 = 1223,
	IP0SR3_15_12_MARK = 1224,
	MMC_SD_CLK_MARK = 1225,
	IP1SR3_15_12_MARK = 1226,
	SD_CD_MARK = 1227,
	IP2SR3_15_12_MARK = 1228,
	QSPI0_MOSI_IO0_MARK___5 = 1229,
	IP3SR3_15_12_MARK = 1230,
	RPC_RESET_N_MARK___2 = 1231,
	IP0SR3_19_16_MARK = 1232,
	MMC_DS_MARK___2 = 1233,
	IP1SR3_19_16_MARK = 1234,
	SD_WP_MARK = 1235,
	IP2SR3_19_16_MARK = 1236,
	QSPI0_SPCLK_MARK___5 = 1237,
	IP3SR3_19_16_MARK = 1238,
	RPC_WP_N_MARK___2 = 1239,
	IP0SR3_23_20_MARK = 1240,
	MMC_SD_D3_MARK = 1241,
	IP1SR3_23_20_MARK = 1242,
	IPC_CLKIN_MARK = 1243,
	IPC_CLKEN_IN_MARK = 1244,
	PWM1_A_MARK___5 = 1245,
	TCLK3_A_MARK = 1246,
	IP2SR3_23_20_MARK = 1247,
	QSPI1_MOSI_IO0_MARK___5 = 1248,
	IP3SR3_23_20_MARK = 1249,
	RPC_INT_N_MARK___2 = 1250,
	IP0SR3_27_24_MARK = 1251,
	MMC_D5_MARK___2 = 1252,
	IP1SR3_27_24_MARK = 1253,
	IPC_CLKOUT_MARK = 1254,
	IPC_CLKEN_OUT_MARK = 1255,
	ERROROUTC_N_A_MARK = 1256,
	TCLK4_A_MARK = 1257,
	IP2SR3_27_24_MARK = 1258,
	QSPI1_SPCLK_MARK___5 = 1259,
	IP0SR3_31_28_MARK = 1260,
	MMC_D4_MARK___2 = 1261,
	IP1SR3_31_28_MARK = 1262,
	QSPI0_SSL_MARK___5 = 1263,
	IP2SR3_31_28_MARK = 1264,
	QSPI1_MISO_IO1_MARK___5 = 1265,
	IP0SR4_3_0_MARK = 1266,
	TSN0_MDIO_MARK = 1267,
	IP1SR4_3_0_MARK = 1268,
	TSN0_AVTP_PPS0_MARK = 1269,
	IP2SR4_3_0_MARK = 1270,
	TSN0_RD3_MARK = 1271,
	IP3SR4_3_0_MARK = 1272,
	AVS1_MARK___4 = 1273,
	IP0SR4_7_4_MARK = 1274,
	TSN0_MDC_MARK = 1275,
	IP1SR4_7_4_MARK = 1276,
	TSN0_TX_CTL_MARK = 1277,
	IP2SR4_7_4_MARK = 1278,
	TSN0_RD2_MARK = 1279,
	IP0SR4_11_8_MARK = 1280,
	TSN0_AVTP_PPS1_MARK = 1281,
	IP1SR4_11_8_MARK = 1282,
	TSN0_RD0_MARK = 1283,
	IP2SR4_11_8_MARK = 1284,
	TSN0_TD3_MARK = 1285,
	IP0SR4_15_12_MARK = 1286,
	TSN0_PHY_INT_MARK = 1287,
	IP1SR4_15_12_MARK = 1288,
	TSN0_RXC_MARK = 1289,
	IP2SR4_15_12_MARK = 1290,
	TSN0_TD2_MARK = 1291,
	IP0SR4_19_16_MARK = 1292,
	TSN0_LINK_MARK = 1293,
	IP1SR4_19_16_MARK = 1294,
	TSN0_TXC_MARK = 1295,
	IP2SR4_19_16_MARK = 1296,
	TSN0_TXCREFCLK_MARK = 1297,
	IP0SR4_23_20_MARK = 1298,
	TSN0_AVTP_MATCH_MARK = 1299,
	IP1SR4_23_20_MARK = 1300,
	TSN0_RD1_MARK = 1301,
	IP2SR4_23_20_MARK = 1302,
	PCIE0_CLKREQ_N_MARK = 1303,
	IP0SR4_27_24_MARK = 1304,
	TSN0_AVTP_CAPTURE_MARK = 1305,
	IP1SR4_27_24_MARK = 1306,
	TSN0_TD1_MARK = 1307,
	IP2SR4_27_24_MARK = 1308,
	PCIE1_CLKREQ_N_MARK = 1309,
	IP0SR4_31_28_MARK = 1310,
	TSN0_RX_CTL_MARK = 1311,
	IP1SR4_31_28_MARK = 1312,
	TSN0_TD0_MARK = 1313,
	IP2SR4_31_28_MARK = 1314,
	AVS0_MARK = 1315,
	IP0SR5_3_0_MARK = 1316,
	AVB2_AVTP_PPS_MARK = 1317,
	IP1SR5_3_0_MARK = 1318,
	AVB2_TD3_MARK = 1319,
	IP2SR5_3_0_MARK = 1320,
	AVB2_TXC_MARK = 1321,
	IP0SR5_7_4_MARK = 1322,
	AVB2_AVTP_CAPTURE_MARK = 1323,
	IP1SR5_7_4_MARK = 1324,
	AVB2_RD3_MARK = 1325,
	IP2SR5_7_4_MARK = 1326,
	AVB2_RD0_MARK = 1327,
	IP0SR5_11_8_MARK = 1328,
	AVB2_AVTP_MATCH_MARK = 1329,
	IP1SR5_11_8_MARK = 1330,
	AVB2_MDIO_MARK = 1331,
	IP2SR5_11_8_MARK = 1332,
	AVB2_RXC_MARK = 1333,
	IP0SR5_15_12_MARK = 1334,
	AVB2_LINK_MARK = 1335,
	IP1SR5_15_12_MARK = 1336,
	AVB2_TD2_MARK = 1337,
	IP2SR5_15_12_MARK = 1338,
	AVB2_TX_CTL_MARK = 1339,
	IP0SR5_19_16_MARK = 1340,
	AVB2_PHY_INT_MARK = 1341,
	IP1SR5_19_16_MARK = 1342,
	AVB2_TD1_MARK = 1343,
	IP2SR5_19_16_MARK = 1344,
	AVB2_RX_CTL_MARK = 1345,
	IP0SR5_23_20_MARK = 1346,
	AVB2_MAGIC_MARK = 1347,
	IP1SR5_23_20_MARK = 1348,
	AVB2_RD2_MARK = 1349,
	IP0SR5_27_24_MARK = 1350,
	AVB2_MDC_MARK = 1351,
	IP1SR5_27_24_MARK = 1352,
	AVB2_RD1_MARK = 1353,
	IP0SR5_31_28_MARK = 1354,
	AVB2_TXCREFCLK_MARK = 1355,
	IP1SR5_31_28_MARK = 1356,
	AVB2_TD0_MARK = 1357,
	IP0SR6_3_0_MARK = 1358,
	AVB1_MDIO_MARK = 1359,
	IP1SR6_3_0_MARK = 1360,
	AVB1_RXC_MARK = 1361,
	AVB1_MII_RXC_MARK = 1362,
	IP2SR6_3_0_MARK = 1363,
	AVB1_TD2_MARK = 1364,
	AVB1_MII_TD2_MARK = 1365,
	IP0SR6_7_4_MARK = 1366,
	AVB1_MAGIC_MARK = 1367,
	IP1SR6_7_4_MARK = 1368,
	AVB1_RX_CTL_MARK = 1369,
	AVB1_MII_RX_DV_MARK = 1370,
	IP2SR6_7_4_MARK = 1371,
	AVB1_RD2_MARK = 1372,
	AVB1_MII_RD2_MARK = 1373,
	IP0SR6_11_8_MARK = 1374,
	AVB1_MDC_MARK = 1375,
	IP1SR6_11_8_MARK = 1376,
	AVB1_AVTP_PPS_MARK = 1377,
	AVB1_MII_COL_MARK = 1378,
	IP2SR6_11_8_MARK = 1379,
	AVB1_TD3_MARK = 1380,
	AVB1_MII_TD3_MARK = 1381,
	IP0SR6_15_12_MARK = 1382,
	AVB1_PHY_INT_MARK = 1383,
	IP1SR6_15_12_MARK = 1384,
	AVB1_AVTP_CAPTURE_MARK = 1385,
	AVB1_MII_CRS_MARK = 1386,
	IP2SR6_15_12_MARK = 1387,
	AVB1_RD3_MARK = 1388,
	AVB1_MII_RD3_MARK = 1389,
	IP0SR6_19_16_MARK = 1390,
	AVB1_LINK_MARK = 1391,
	AVB1_MII_TX_ER_MARK = 1392,
	IP1SR6_19_16_MARK = 1393,
	AVB1_TD1_MARK = 1394,
	AVB1_MII_TD1_MARK = 1395,
	IP2SR6_19_16_MARK = 1396,
	AVB1_TXCREFCLK_MARK = 1397,
	IP0SR6_23_20_MARK = 1398,
	AVB1_AVTP_MATCH_MARK = 1399,
	AVB1_MII_RX_ER_MARK = 1400,
	IP1SR6_23_20_MARK = 1401,
	AVB1_TD0_MARK = 1402,
	AVB1_MII_TD0_MARK = 1403,
	IP0SR6_27_24_MARK = 1404,
	AVB1_TXC_MARK = 1405,
	AVB1_MII_TXC_MARK = 1406,
	IP1SR6_27_24_MARK = 1407,
	AVB1_RD1_MARK = 1408,
	AVB1_MII_RD1_MARK = 1409,
	IP0SR6_31_28_MARK = 1410,
	AVB1_TX_CTL_MARK = 1411,
	AVB1_MII_TX_EN_MARK = 1412,
	IP1SR6_31_28_MARK = 1413,
	AVB1_RD0_MARK = 1414,
	AVB1_MII_RD0_MARK = 1415,
	IP0SR7_3_0_MARK = 1416,
	AVB0_AVTP_PPS_MARK = 1417,
	AVB0_MII_COL_MARK = 1418,
	IP1SR7_3_0_MARK = 1419,
	AVB0_RD3_MARK = 1420,
	AVB0_MII_RD3_MARK = 1421,
	IP2SR7_3_0_MARK = 1422,
	AVB0_TX_CTL_MARK = 1423,
	AVB0_MII_TX_EN_MARK = 1424,
	IP0SR7_7_4_MARK = 1425,
	AVB0_AVTP_CAPTURE_MARK = 1426,
	AVB0_MII_CRS_MARK = 1427,
	IP1SR7_7_4_MARK = 1428,
	AVB0_TXCREFCLK_MARK = 1429,
	IP2SR7_7_4_MARK = 1430,
	AVB0_RD1_MARK = 1431,
	AVB0_MII_RD1_MARK = 1432,
	IP0SR7_11_8_MARK = 1433,
	AVB0_AVTP_MATCH_MARK = 1434,
	AVB0_MII_RX_ER_MARK = 1435,
	CC5_OSCOUT_MARK = 1436,
	IP1SR7_11_8_MARK = 1437,
	AVB0_MAGIC_MARK = 1438,
	IP2SR7_11_8_MARK = 1439,
	AVB0_RD0_MARK = 1440,
	AVB0_MII_RD0_MARK = 1441,
	IP0SR7_15_12_MARK = 1442,
	AVB0_TD3_MARK = 1443,
	AVB0_MII_TD3_MARK = 1444,
	IP1SR7_15_12_MARK = 1445,
	AVB0_TD0_MARK = 1446,
	AVB0_MII_TD0_MARK = 1447,
	IP2SR7_15_12_MARK = 1448,
	AVB0_RXC_MARK = 1449,
	AVB0_MII_RXC_MARK = 1450,
	IP0SR7_19_16_MARK = 1451,
	AVB0_LINK_MARK = 1452,
	AVB0_MII_TX_ER_MARK = 1453,
	IP1SR7_19_16_MARK = 1454,
	AVB0_RD2_MARK = 1455,
	AVB0_MII_RD2_MARK = 1456,
	IP2SR7_19_16_MARK = 1457,
	AVB0_RX_CTL_MARK = 1458,
	AVB0_MII_RX_DV_MARK = 1459,
	IP0SR7_23_20_MARK = 1460,
	AVB0_PHY_INT_MARK = 1461,
	IP1SR7_23_20_MARK = 1462,
	AVB0_MDC_MARK = 1463,
	IP0SR7_27_24_MARK = 1464,
	AVB0_TD2_MARK = 1465,
	AVB0_MII_TD2_MARK = 1466,
	IP1SR7_27_24_MARK = 1467,
	AVB0_MDIO_MARK = 1468,
	IP0SR7_31_28_MARK = 1469,
	AVB0_TD1_MARK = 1470,
	AVB0_MII_TD1_MARK = 1471,
	IP1SR7_31_28_MARK = 1472,
	AVB0_TXC_MARK = 1473,
	AVB0_MII_TXC_MARK = 1474,
	IP0SR8_3_0_MARK = 1475,
	SCL0_MARK___5 = 1476,
	IP1SR8_3_0_MARK = 1477,
	SCL4_MARK___2 = 1478,
	HRX2_MARK___2 = 1479,
	SCK4_MARK___2 = 1480,
	IP0SR8_7_4_MARK = 1481,
	SDA0_MARK___5 = 1482,
	IP1SR8_7_4_MARK = 1483,
	SDA4_MARK___2 = 1484,
	HTX2_MARK___2 = 1485,
	CTS4_N_MARK___2 = 1486,
	IP0SR8_11_8_MARK = 1487,
	SCL1_MARK___2 = 1488,
	IP1SR8_11_8_MARK = 1489,
	SCL5_MARK___5 = 1490,
	HRTS2_N_MARK___2 = 1491,
	RTS4_N_MARK___2 = 1492,
	IP0SR8_15_12_MARK = 1493,
	SDA1_MARK___2 = 1494,
	IP1SR8_15_12_MARK = 1495,
	SDA5_MARK___5 = 1496,
	SCIF_CLK2_MARK = 1497,
	IP0SR8_19_16_MARK = 1498,
	SCL2_MARK___2 = 1499,
	IP1SR8_19_16_MARK = 1500,
	HCTS2_N_MARK___2 = 1501,
	TX4_MARK___2 = 1502,
	IP0SR8_23_20_MARK = 1503,
	SDA2_MARK___2 = 1504,
	IP1SR8_23_20_MARK = 1505,
	HSCK2_MARK___2 = 1506,
	RX4_MARK___2 = 1507,
	IP0SR8_27_24_MARK = 1508,
	SCL3_MARK___5 = 1509,
	IP0SR8_31_28_MARK = 1510,
	SDA3_MARK___5 = 1511,
	SEL_SDA5_0_MARK = 1512,
	SEL_SDA5_1_MARK = 1513,
	SEL_SCL5_0_MARK = 1514,
	SEL_SCL5_1_MARK = 1515,
	SEL_SDA4_0_MARK = 1516,
	SEL_SDA4_1_MARK = 1517,
	SEL_SCL4_0_MARK = 1518,
	SEL_SCL4_1_MARK = 1519,
	SEL_SDA3_0_MARK = 1520,
	SEL_SDA3_1_MARK = 1521,
	SEL_SCL3_0_MARK = 1522,
	SEL_SCL3_1_MARK = 1523,
	SEL_SDA2_0_MARK = 1524,
	SEL_SDA2_1_MARK = 1525,
	SEL_SCL2_0_MARK = 1526,
	SEL_SCL2_1_MARK = 1527,
	SEL_SDA1_0_MARK = 1528,
	SEL_SDA1_1_MARK = 1529,
	SEL_SCL1_0_MARK = 1530,
	SEL_SCL1_1_MARK = 1531,
	SEL_SDA0_0_MARK = 1532,
	SEL_SDA0_1_MARK = 1533,
	SEL_SCL0_0_MARK = 1534,
	SEL_SCL0_1_MARK = 1535,
	PINMUX_MARK_END___5 = 1536,
};

enum {
	PINMUX_RESERVED___6 = 0,
	PINMUX_DATA_BEGIN___6 = 1,
	GP_0_0_DATA___6 = 2,
	GP_0_1_DATA___6 = 3,
	GP_0_2_DATA___6 = 4,
	GP_0_3_DATA___6 = 5,
	GP_0_4_DATA___6 = 6,
	GP_0_5_DATA___6 = 7,
	GP_0_6_DATA___6 = 8,
	GP_0_7_DATA___6 = 9,
	GP_0_8_DATA___6 = 10,
	GP_0_9_DATA___6 = 11,
	GP_0_10_DATA___6 = 12,
	GP_0_11_DATA___6 = 13,
	GP_0_12_DATA___6 = 14,
	GP_0_13_DATA___6 = 15,
	GP_0_14_DATA___6 = 16,
	GP_0_15_DATA___6 = 17,
	GP_0_16_DATA___3 = 18,
	GP_0_17_DATA___3 = 19,
	GP_0_18_DATA___3 = 20,
	GP_0_19_DATA___2 = 21,
	GP_0_20_DATA___2 = 22,
	GP_1_0_DATA___6 = 23,
	GP_1_1_DATA___6 = 24,
	GP_1_2_DATA___6 = 25,
	GP_1_3_DATA___6 = 26,
	GP_1_4_DATA___6 = 27,
	GP_1_5_DATA___6 = 28,
	GP_1_6_DATA___6 = 29,
	GP_1_7_DATA___6 = 30,
	GP_1_8_DATA___6 = 31,
	GP_1_9_DATA___6 = 32,
	GP_1_10_DATA___6 = 33,
	GP_1_11_DATA___6 = 34,
	GP_1_12_DATA___6 = 35,
	GP_1_13_DATA___6 = 36,
	GP_1_14_DATA___6 = 37,
	GP_1_15_DATA___6 = 38,
	GP_1_16_DATA___6 = 39,
	GP_1_17_DATA___6 = 40,
	GP_1_18_DATA___6 = 41,
	GP_1_19_DATA___6 = 42,
	GP_1_20_DATA___6 = 43,
	GP_1_21_DATA___6 = 44,
	GP_1_22_DATA___6 = 45,
	GP_1_23_DATA___6 = 46,
	GP_1_24_DATA___6 = 47,
	GP_2_0_DATA___6 = 48,
	GP_2_1_DATA___6 = 49,
	GP_2_2_DATA___6 = 50,
	GP_2_3_DATA___6 = 51,
	GP_2_4_DATA___6 = 52,
	GP_2_5_DATA___6 = 53,
	GP_2_6_DATA___6 = 54,
	GP_2_7_DATA___6 = 55,
	GP_2_8_DATA___6 = 56,
	GP_2_9_DATA___6 = 57,
	GP_2_10_DATA___6 = 58,
	GP_2_11_DATA___6 = 59,
	GP_2_12_DATA___6 = 60,
	GP_2_13_DATA___6 = 61,
	GP_2_14_DATA___6 = 62,
	GP_2_15_DATA___3 = 63,
	GP_2_16_DATA___3 = 64,
	GP_3_0_DATA___6 = 65,
	GP_3_1_DATA___6 = 66,
	GP_3_2_DATA___6 = 67,
	GP_3_3_DATA___6 = 68,
	GP_3_4_DATA___6 = 69,
	GP_3_5_DATA___6 = 70,
	GP_3_6_DATA___6 = 71,
	GP_3_7_DATA___6 = 72,
	GP_3_8_DATA___6 = 73,
	GP_3_9_DATA___6 = 74,
	GP_3_10_DATA___6 = 75,
	GP_3_11_DATA___6 = 76,
	GP_3_12_DATA___6 = 77,
	GP_3_13_DATA___6 = 78,
	GP_3_14_DATA___6 = 79,
	GP_3_15_DATA___6 = 80,
	GP_3_16_DATA___3 = 81,
	GP_3_17_DATA___2 = 82,
	GP_3_18_DATA___2 = 83,
	PINMUX_DATA_END___6 = 84,
	PINMUX_FUNCTION_BEGIN___6 = 85,
	GP_0_0_FN___6 = 86,
	GP_0_1_FN___6 = 87,
	GP_0_2_FN___6 = 88,
	GP_0_3_FN___6 = 89,
	GP_0_4_FN___6 = 90,
	GP_0_5_FN___6 = 91,
	GP_0_6_FN___6 = 92,
	GP_0_7_FN___6 = 93,
	GP_0_8_FN___6 = 94,
	GP_0_9_FN___6 = 95,
	GP_0_10_FN___6 = 96,
	GP_0_11_FN___6 = 97,
	GP_0_12_FN___6 = 98,
	GP_0_13_FN___6 = 99,
	GP_0_14_FN___6 = 100,
	GP_0_15_FN___6 = 101,
	GP_0_16_FN___3 = 102,
	GP_0_17_FN___3 = 103,
	GP_0_18_FN___3 = 104,
	GP_0_19_FN___2 = 105,
	GP_0_20_FN___2 = 106,
	GP_1_0_FN___6 = 107,
	GP_1_1_FN___6 = 108,
	GP_1_2_FN___6 = 109,
	GP_1_3_FN___6 = 110,
	GP_1_4_FN___6 = 111,
	GP_1_5_FN___6 = 112,
	GP_1_6_FN___6 = 113,
	GP_1_7_FN___6 = 114,
	GP_1_8_FN___6 = 115,
	GP_1_9_FN___6 = 116,
	GP_1_10_FN___6 = 117,
	GP_1_11_FN___6 = 118,
	GP_1_12_FN___6 = 119,
	GP_1_13_FN___6 = 120,
	GP_1_14_FN___6 = 121,
	GP_1_15_FN___6 = 122,
	GP_1_16_FN___6 = 123,
	GP_1_17_FN___6 = 124,
	GP_1_18_FN___6 = 125,
	GP_1_19_FN___6 = 126,
	GP_1_20_FN___6 = 127,
	GP_1_21_FN___6 = 128,
	GP_1_22_FN___6 = 129,
	GP_1_23_FN___6 = 130,
	GP_1_24_FN___6 = 131,
	GP_2_0_FN___6 = 132,
	GP_2_1_FN___6 = 133,
	GP_2_2_FN___6 = 134,
	GP_2_3_FN___6 = 135,
	GP_2_4_FN___6 = 136,
	GP_2_5_FN___6 = 137,
	GP_2_6_FN___6 = 138,
	GP_2_7_FN___6 = 139,
	GP_2_8_FN___6 = 140,
	GP_2_9_FN___6 = 141,
	GP_2_10_FN___6 = 142,
	GP_2_11_FN___6 = 143,
	GP_2_12_FN___6 = 144,
	GP_2_13_FN___6 = 145,
	GP_2_14_FN___6 = 146,
	GP_2_15_FN___3 = 147,
	GP_2_16_FN___3 = 148,
	GP_3_0_FN___6 = 149,
	GP_3_1_FN___6 = 150,
	GP_3_2_FN___6 = 151,
	GP_3_3_FN___6 = 152,
	GP_3_4_FN___6 = 153,
	GP_3_5_FN___6 = 154,
	GP_3_6_FN___6 = 155,
	GP_3_7_FN___6 = 156,
	GP_3_8_FN___6 = 157,
	GP_3_9_FN___6 = 158,
	GP_3_10_FN___6 = 159,
	GP_3_11_FN___6 = 160,
	GP_3_12_FN___6 = 161,
	GP_3_13_FN___6 = 162,
	GP_3_14_FN___6 = 163,
	GP_3_15_FN___6 = 164,
	GP_3_16_FN___3 = 165,
	GP_3_17_FN___2 = 166,
	GP_3_18_FN___2 = 167,
	FN_SD_WP___2 = 168,
	FN_SD_CD___2 = 169,
	FN_MMC_SD_CMD___2 = 170,
	FN_MMC_D7___3 = 171,
	FN_MMC_DS___3 = 172,
	FN_MMC_D6___3 = 173,
	FN_MMC_D4___3 = 174,
	FN_TSN0_AVTP_CAPTURE_B = 175,
	FN_MMC_D5___3 = 176,
	FN_TSN0_AVTP_MATCH_B = 177,
	FN_MMC_SD_D3___2 = 178,
	FN_PCIE1_CLKREQ_N___2 = 179,
	FN_TSN0_AVTP_PPS = 180,
	FN_MMC_SD_D2___2 = 181,
	FN_PCIE0_CLKREQ_N___2 = 182,
	FN_TSN1_AVTP_CAPTURE_B = 183,
	FN_MMC_SD_D1___2 = 184,
	FN_QSPI0_IO3___3 = 185,
	FN_TSN1_AVTP_MATCH_B = 186,
	FN_MMC_SD_D0___2 = 187,
	FN_QSPI0_SSL___3 = 188,
	FN_TSN1_AVTP_PPS = 189,
	FN_MMC_SD_CLK___2 = 190,
	FN_QSPI0_MISO_IO1___3 = 191,
	FN_TSN0_MAGIC_B = 192,
	FN_GP1_11 = 193,
	FN_QSPI0_IO2___3 = 194,
	FN_TSN1_PHY_INT_B = 195,
	FN_GP1_10 = 196,
	FN_QSPI0_SPCLK___3 = 197,
	FN_TSN0_PHY_INT_B = 198,
	FN_GP1_09 = 199,
	FN_QSPI0_MOSI_IO0___3 = 200,
	FN_TSN2_PHY_INT_B = 201,
	FN_GP1_08 = 202,
	FN_QSPI1_SPCLK___3 = 203,
	FN_TSN0_LINK_B = 204,
	FN_QSPI1_MOSI_IO0___3 = 205,
	FN_TSN2_LINK_B = 206,
	FN_QSPI1_IO2___3 = 207,
	FN_TSN1_LINK_B = 208,
	FN_QSPI1_MISO_IO1___3 = 209,
	FN_TSN1_MDC_B = 210,
	FN_QSPI1_IO3___3 = 211,
	FN_TSN0_MDC_B = 212,
	FN_QSPI1_SSL___3 = 213,
	FN_TSN2_MDC_B = 214,
	FN_RPC_RESET_N___3 = 215,
	FN_TSN0_MDIO_B = 216,
	FN_RPC_WP_N___3 = 217,
	FN_TSN2_MDIO_B = 218,
	FN_RPC_INT_N___3 = 219,
	FN_TSN1_MDIO_B = 220,
	FN_IP0SR0_3_0___2 = 221,
	FN_SCIF_CLK___2 = 222,
	FN_IP1SR0_3_0___2 = 223,
	FN_SCK0___6 = 224,
	FN_HSCK1___2 = 225,
	FN_MSIOF1_SCK___3 = 226,
	FN_IP2SR0_3_0___2 = 227,
	FN_MSIOF0_SS2___6 = 228,
	FN_TSN2_LINK_A = 229,
	FN_IP0SR0_7_4___2 = 230,
	FN_HSCK0___5 = 231,
	FN_SCK3___5 = 232,
	FN_MSIOF3_SCK___3 = 233,
	FN_TSN0_AVTP_CAPTURE_A = 234,
	FN_IP1SR0_7_4___2 = 235,
	FN_RTS0_N___6 = 236,
	FN_HRTS1_N___2 = 237,
	FN_MSIOF3_SYNC___3 = 238,
	FN_TSN1_MDIO_A = 239,
	FN_IP2SR0_7_4___2 = 240,
	FN_IRQ0___5 = 241,
	FN_MSIOF1_SS1___3 = 242,
	FN_TSN0_MAGIC_A = 243,
	FN_IP0SR0_11_8___2 = 244,
	FN_HRX0___5 = 245,
	FN_RX3___2 = 246,
	FN_MSIOF3_RXD___3 = 247,
	FN_TSN0_AVTP_MATCH_A = 248,
	FN_IP1SR0_11_8___2 = 249,
	FN_CTS0_N___6 = 250,
	FN_HCTS1_N___2 = 251,
	FN_MSIOF1_SYNC___3 = 252,
	FN_TSN1_MDC_A = 253,
	FN_IP2SR0_11_8___2 = 254,
	FN_IRQ1___5 = 255,
	FN_MSIOF1_SS2___3 = 256,
	FN_TSN0_PHY_INT_A = 257,
	FN_IP0SR0_15_12___2 = 258,
	FN_HTX0___5 = 259,
	FN_TX3___2 = 260,
	FN_MSIOF3_TXD___3 = 261,
	FN_IP1SR0_15_12___2 = 262,
	FN_MSIOF0_SYNC___6 = 263,
	FN_HCTS3_N___5 = 264,
	FN_CTS1_N___5 = 265,
	FN_IRQ4___5 = 266,
	FN_TSN0_LINK_A = 267,
	FN_IP2SR0_15_12 = 268,
	FN_IRQ2___5 = 269,
	FN_TSN1_PHY_INT_A = 270,
	FN_IP0SR0_19_16___2 = 271,
	FN_HCTS0_N___5 = 272,
	FN_CTS3_N___5 = 273,
	FN_MSIOF3_SS1___3 = 274,
	FN_TSN0_MDC_A = 275,
	FN_IP1SR0_19_16___2 = 276,
	FN_MSIOF0_RXD___6 = 277,
	FN_HRX3___2 = 278,
	FN_RX1 = 279,
	FN_IP2SR0_19_16 = 280,
	FN_IRQ3___5 = 281,
	FN_TSN2_PHY_INT_A = 282,
	FN_IP0SR0_23_20___2 = 283,
	FN_HRTS0_N___5 = 284,
	FN_RTS3_N___5 = 285,
	FN_MSIOF3_SS2___3 = 286,
	FN_TSN0_MDIO_A = 287,
	FN_IP1SR0_23_20___2 = 288,
	FN_MSIOF0_TXD___6 = 289,
	FN_HTX3___2 = 290,
	FN_TX1 = 291,
	FN_IP0SR0_27_24___2 = 292,
	FN_RX0___6 = 293,
	FN_HRX1___2 = 294,
	FN_MSIOF1_RXD___3 = 295,
	FN_TSN1_AVTP_MATCH_A = 296,
	FN_IP1SR0_27_24___2 = 297,
	FN_MSIOF0_SCK___6 = 298,
	FN_HSCK3___5 = 299,
	FN_SCK1___5 = 300,
	FN_IP0SR0_31_28___2 = 301,
	FN_TX0___6 = 302,
	FN_HTX1___2 = 303,
	FN_MSIOF1_TXD___3 = 304,
	FN_TSN1_AVTP_CAPTURE_A = 305,
	FN_IP1SR0_31_28___2 = 306,
	FN_MSIOF0_SS1___6 = 307,
	FN_HRTS3_N___5 = 308,
	FN_RTS1_N___5 = 309,
	FN_IRQ5___6 = 310,
	FN_TSN1_LINK_A = 311,
	FN_IP0SR1_3_0___2 = 312,
	FN_GP1_00 = 313,
	FN_TCLK1 = 314,
	FN_HSCK2___3 = 315,
	FN_IP0SR1_7_4___2 = 316,
	FN_GP1_01 = 317,
	FN_TCLK4___2 = 318,
	FN_HRX2___3 = 319,
	FN_IP0SR1_11_8___2 = 320,
	FN_GP1_02 = 321,
	FN_HTX2___3 = 322,
	FN_MSIOF2_SS1___3 = 323,
	FN_TSN2_MDC_A = 324,
	FN_IP0SR1_15_12___2 = 325,
	FN_GP1_03 = 326,
	FN_TCLK2 = 327,
	FN_HCTS2_N___3 = 328,
	FN_MSIOF2_SS2___3 = 329,
	FN_CTS4_N___3 = 330,
	FN_TSN2_MDIO_A = 331,
	FN_IP0SR1_19_16___2 = 332,
	FN_GP1_04 = 333,
	FN_TCLK3___2 = 334,
	FN_HRTS2_N___3 = 335,
	FN_MSIOF2_SYNC___3 = 336,
	FN_RTS4_N___3 = 337,
	FN_IP0SR1_23_20___2 = 338,
	FN_GP1_05 = 339,
	FN_MSIOF2_SCK___3 = 340,
	FN_SCK4___3 = 341,
	FN_IP0SR1_27_24___2 = 342,
	FN_GP1_06 = 343,
	FN_MSIOF2_RXD___3 = 344,
	FN_RX4___3 = 345,
	FN_IP0SR1_31_28___2 = 346,
	FN_GP1_07 = 347,
	FN_MSIOF2_TXD___3 = 348,
	FN_TX4___3 = 349,
	FN_SEL_I2C5_0 = 350,
	FN_SEL_I2C5_3 = 351,
	FN_SEL_I2C4_0 = 352,
	FN_SEL_I2C4_3 = 353,
	FN_SEL_I2C3_0 = 354,
	FN_SEL_I2C3_3 = 355,
	FN_SEL_I2C2_0___4 = 356,
	FN_SEL_I2C2_3 = 357,
	FN_SEL_I2C1_0___4 = 358,
	FN_SEL_I2C1_3 = 359,
	FN_SEL_I2C0_0 = 360,
	FN_SEL_I2C0_3 = 361,
	PINMUX_FUNCTION_END___6 = 362,
	PINMUX_MARK_BEGIN___6 = 363,
	SD_WP_MARK___2 = 364,
	SD_CD_MARK___2 = 365,
	MMC_SD_CMD_MARK___2 = 366,
	MMC_D7_MARK___3 = 367,
	MMC_DS_MARK___3 = 368,
	MMC_D6_MARK___3 = 369,
	MMC_D4_MARK___3 = 370,
	TSN0_AVTP_CAPTURE_B_MARK = 371,
	MMC_D5_MARK___3 = 372,
	TSN0_AVTP_MATCH_B_MARK = 373,
	MMC_SD_D3_MARK___2 = 374,
	PCIE1_CLKREQ_N_MARK___2 = 375,
	TSN0_AVTP_PPS_MARK = 376,
	MMC_SD_D2_MARK___2 = 377,
	PCIE0_CLKREQ_N_MARK___2 = 378,
	TSN1_AVTP_CAPTURE_B_MARK = 379,
	MMC_SD_D1_MARK___2 = 380,
	QSPI0_IO3_MARK___6 = 381,
	TSN1_AVTP_MATCH_B_MARK = 382,
	MMC_SD_D0_MARK___2 = 383,
	QSPI0_SSL_MARK___6 = 384,
	TSN1_AVTP_PPS_MARK = 385,
	MMC_SD_CLK_MARK___2 = 386,
	QSPI0_MISO_IO1_MARK___6 = 387,
	TSN0_MAGIC_B_MARK = 388,
	GP1_11_MARK = 389,
	QSPI0_IO2_MARK___6 = 390,
	TSN1_PHY_INT_B_MARK = 391,
	GP1_10_MARK = 392,
	QSPI0_SPCLK_MARK___6 = 393,
	TSN0_PHY_INT_B_MARK = 394,
	GP1_09_MARK = 395,
	QSPI0_MOSI_IO0_MARK___6 = 396,
	TSN2_PHY_INT_B_MARK = 397,
	GP1_08_MARK = 398,
	QSPI1_SPCLK_MARK___6 = 399,
	TSN0_LINK_B_MARK = 400,
	QSPI1_MOSI_IO0_MARK___6 = 401,
	TSN2_LINK_B_MARK = 402,
	QSPI1_IO2_MARK___6 = 403,
	TSN1_LINK_B_MARK = 404,
	QSPI1_MISO_IO1_MARK___6 = 405,
	TSN1_MDC_B_MARK = 406,
	QSPI1_IO3_MARK___6 = 407,
	TSN0_MDC_B_MARK = 408,
	QSPI1_SSL_MARK___6 = 409,
	TSN2_MDC_B_MARK = 410,
	RPC_RESET_N_MARK___3 = 411,
	TSN0_MDIO_B_MARK = 412,
	RPC_WP_N_MARK___3 = 413,
	TSN2_MDIO_B_MARK = 414,
	RPC_INT_N_MARK___3 = 415,
	TSN1_MDIO_B_MARK = 416,
	IP0SR0_3_0_MARK___2 = 417,
	SCIF_CLK_MARK___2 = 418,
	IP1SR0_3_0_MARK___2 = 419,
	SCK0_MARK___6 = 420,
	HSCK1_MARK___2 = 421,
	MSIOF1_SCK_MARK___3 = 422,
	IP2SR0_3_0_MARK___2 = 423,
	MSIOF0_SS2_MARK___6 = 424,
	TSN2_LINK_A_MARK = 425,
	IP0SR0_7_4_MARK___2 = 426,
	HSCK0_MARK___5 = 427,
	SCK3_MARK___5 = 428,
	MSIOF3_SCK_MARK___3 = 429,
	TSN0_AVTP_CAPTURE_A_MARK = 430,
	IP1SR0_7_4_MARK___2 = 431,
	RTS0_N_MARK___6 = 432,
	HRTS1_N_MARK___2 = 433,
	MSIOF3_SYNC_MARK___3 = 434,
	TSN1_MDIO_A_MARK = 435,
	IP2SR0_7_4_MARK___2 = 436,
	IRQ0_MARK___5 = 437,
	MSIOF1_SS1_MARK___3 = 438,
	TSN0_MAGIC_A_MARK = 439,
	IP0SR0_11_8_MARK___2 = 440,
	HRX0_MARK___5 = 441,
	RX3_MARK___2 = 442,
	MSIOF3_RXD_MARK___3 = 443,
	TSN0_AVTP_MATCH_A_MARK = 444,
	IP1SR0_11_8_MARK___2 = 445,
	CTS0_N_MARK___6 = 446,
	HCTS1_N_MARK___2 = 447,
	MSIOF1_SYNC_MARK___3 = 448,
	TSN1_MDC_A_MARK = 449,
	IP2SR0_11_8_MARK___2 = 450,
	IRQ1_MARK___5 = 451,
	MSIOF1_SS2_MARK___3 = 452,
	TSN0_PHY_INT_A_MARK = 453,
	IP0SR0_15_12_MARK___2 = 454,
	HTX0_MARK___5 = 455,
	TX3_MARK___2 = 456,
	MSIOF3_TXD_MARK___3 = 457,
	IP1SR0_15_12_MARK___2 = 458,
	MSIOF0_SYNC_MARK___6 = 459,
	HCTS3_N_MARK___5 = 460,
	CTS1_N_MARK___5 = 461,
	IRQ4_MARK___5 = 462,
	TSN0_LINK_A_MARK = 463,
	IP2SR0_15_12_MARK = 464,
	IRQ2_MARK___5 = 465,
	TSN1_PHY_INT_A_MARK = 466,
	IP0SR0_19_16_MARK___2 = 467,
	HCTS0_N_MARK___5 = 468,
	CTS3_N_MARK___5 = 469,
	MSIOF3_SS1_MARK___3 = 470,
	TSN0_MDC_A_MARK = 471,
	IP1SR0_19_16_MARK___2 = 472,
	MSIOF0_RXD_MARK___6 = 473,
	HRX3_MARK___2 = 474,
	RX1_MARK = 475,
	IP2SR0_19_16_MARK = 476,
	IRQ3_MARK___5 = 477,
	TSN2_PHY_INT_A_MARK = 478,
	IP0SR0_23_20_MARK___2 = 479,
	HRTS0_N_MARK___5 = 480,
	RTS3_N_MARK___5 = 481,
	MSIOF3_SS2_MARK___3 = 482,
	TSN0_MDIO_A_MARK = 483,
	IP1SR0_23_20_MARK___2 = 484,
	MSIOF0_TXD_MARK___6 = 485,
	HTX3_MARK___2 = 486,
	TX1_MARK = 487,
	IP0SR0_27_24_MARK___2 = 488,
	RX0_MARK___6 = 489,
	HRX1_MARK___2 = 490,
	MSIOF1_RXD_MARK___3 = 491,
	TSN1_AVTP_MATCH_A_MARK = 492,
	IP1SR0_27_24_MARK___2 = 493,
	MSIOF0_SCK_MARK___6 = 494,
	HSCK3_MARK___5 = 495,
	SCK1_MARK___5 = 496,
	IP0SR0_31_28_MARK___2 = 497,
	TX0_MARK___6 = 498,
	HTX1_MARK___2 = 499,
	MSIOF1_TXD_MARK___3 = 500,
	TSN1_AVTP_CAPTURE_A_MARK = 501,
	IP1SR0_31_28_MARK___2 = 502,
	MSIOF0_SS1_MARK___6 = 503,
	HRTS3_N_MARK___5 = 504,
	RTS1_N_MARK___5 = 505,
	IRQ5_MARK___6 = 506,
	TSN1_LINK_A_MARK = 507,
	IP0SR1_3_0_MARK___2 = 508,
	GP1_00_MARK = 509,
	TCLK1_MARK = 510,
	HSCK2_MARK___3 = 511,
	IP0SR1_7_4_MARK___2 = 512,
	GP1_01_MARK = 513,
	TCLK4_MARK___2 = 514,
	HRX2_MARK___3 = 515,
	IP0SR1_11_8_MARK___2 = 516,
	GP1_02_MARK = 517,
	HTX2_MARK___3 = 518,
	MSIOF2_SS1_MARK___3 = 519,
	TSN2_MDC_A_MARK = 520,
	IP0SR1_15_12_MARK___2 = 521,
	GP1_03_MARK = 522,
	TCLK2_MARK = 523,
	HCTS2_N_MARK___3 = 524,
	MSIOF2_SS2_MARK___3 = 525,
	CTS4_N_MARK___3 = 526,
	TSN2_MDIO_A_MARK = 527,
	IP0SR1_19_16_MARK___2 = 528,
	GP1_04_MARK = 529,
	TCLK3_MARK___2 = 530,
	HRTS2_N_MARK___3 = 531,
	MSIOF2_SYNC_MARK___3 = 532,
	RTS4_N_MARK___3 = 533,
	IP0SR1_23_20_MARK___2 = 534,
	GP1_05_MARK = 535,
	MSIOF2_SCK_MARK___3 = 536,
	SCK4_MARK___3 = 537,
	IP0SR1_27_24_MARK___2 = 538,
	GP1_06_MARK = 539,
	MSIOF2_RXD_MARK___3 = 540,
	RX4_MARK___3 = 541,
	IP0SR1_31_28_MARK___2 = 542,
	GP1_07_MARK = 543,
	MSIOF2_TXD_MARK___3 = 544,
	TX4_MARK___3 = 545,
	SEL_I2C5_0_MARK = 546,
	SEL_I2C5_3_MARK = 547,
	SEL_I2C4_0_MARK = 548,
	SEL_I2C4_3_MARK = 549,
	SEL_I2C3_0_MARK = 550,
	SEL_I2C3_3_MARK = 551,
	SEL_I2C2_0_MARK___4 = 552,
	SEL_I2C2_3_MARK = 553,
	SEL_I2C1_0_MARK___4 = 554,
	SEL_I2C1_3_MARK = 555,
	SEL_I2C0_0_MARK = 556,
	SEL_I2C0_3_MARK = 557,
	SCL0_MARK___6 = 558,
	SDA0_MARK___6 = 559,
	SCL1_MARK___3 = 560,
	SDA1_MARK___3 = 561,
	SCL2_MARK___3 = 562,
	SDA2_MARK___3 = 563,
	SCL3_MARK___6 = 564,
	SDA3_MARK___6 = 565,
	SCL4_MARK___3 = 566,
	SDA4_MARK___3 = 567,
	SCL5_MARK___6 = 568,
	SDA5_MARK___6 = 569,
	PINMUX_MARK_END___6 = 570,
};

enum {
	PINMUX_RESERVED___7 = 0,
	PINMUX_DATA_BEGIN___7 = 1,
	GP_0_0_DATA___7 = 2,
	GP_0_1_DATA___7 = 3,
	GP_0_2_DATA___7 = 4,
	GP_0_3_DATA___7 = 5,
	GP_0_4_DATA___7 = 6,
	GP_0_5_DATA___7 = 7,
	GP_0_6_DATA___7 = 8,
	GP_0_7_DATA___7 = 9,
	GP_0_8_DATA___7 = 10,
	GP_1_0_DATA___7 = 11,
	GP_1_1_DATA___7 = 12,
	GP_1_2_DATA___7 = 13,
	GP_1_3_DATA___7 = 14,
	GP_1_4_DATA___7 = 15,
	GP_1_5_DATA___7 = 16,
	GP_1_6_DATA___7 = 17,
	GP_1_7_DATA___7 = 18,
	GP_1_8_DATA___7 = 19,
	GP_1_9_DATA___7 = 20,
	GP_1_10_DATA___7 = 21,
	GP_1_11_DATA___7 = 22,
	GP_1_12_DATA___7 = 23,
	GP_1_13_DATA___7 = 24,
	GP_1_14_DATA___7 = 25,
	GP_1_15_DATA___7 = 26,
	GP_1_16_DATA___7 = 27,
	GP_1_17_DATA___7 = 28,
	GP_1_18_DATA___7 = 29,
	GP_1_19_DATA___7 = 30,
	GP_1_20_DATA___7 = 31,
	GP_1_21_DATA___7 = 32,
	GP_1_22_DATA___7 = 33,
	GP_1_23_DATA___7 = 34,
	GP_1_24_DATA___7 = 35,
	GP_1_25_DATA___6 = 36,
	GP_1_26_DATA___6 = 37,
	GP_1_27_DATA___6 = 38,
	GP_1_28_DATA___5 = 39,
	GP_1_29_DATA = 40,
	GP_1_30_DATA = 41,
	GP_1_31_DATA = 42,
	GP_2_0_DATA___7 = 43,
	GP_2_1_DATA___7 = 44,
	GP_2_2_DATA___7 = 45,
	GP_2_3_DATA___7 = 46,
	GP_2_4_DATA___7 = 47,
	GP_2_5_DATA___7 = 48,
	GP_2_6_DATA___7 = 49,
	GP_2_7_DATA___7 = 50,
	GP_2_8_DATA___7 = 51,
	GP_2_9_DATA___7 = 52,
	GP_2_10_DATA___7 = 53,
	GP_2_11_DATA___7 = 54,
	GP_2_12_DATA___7 = 55,
	GP_2_13_DATA___7 = 56,
	GP_2_14_DATA___7 = 57,
	GP_2_15_DATA___4 = 58,
	GP_2_16_DATA___4 = 59,
	GP_2_17_DATA___3 = 60,
	GP_2_18_DATA___3 = 61,
	GP_2_19_DATA___3 = 62,
	GP_2_20_DATA___2 = 63,
	GP_2_21_DATA___2 = 64,
	GP_2_22_DATA___2 = 65,
	GP_2_23_DATA___2 = 66,
	GP_2_24_DATA___2 = 67,
	GP_2_25_DATA___2 = 68,
	GP_2_26_DATA___2 = 69,
	GP_2_27_DATA___2 = 70,
	GP_2_28_DATA___2 = 71,
	GP_2_29_DATA___2 = 72,
	GP_2_30_DATA = 73,
	GP_2_31_DATA = 74,
	GP_3_0_DATA___7 = 75,
	GP_3_1_DATA___7 = 76,
	GP_3_2_DATA___7 = 77,
	GP_3_3_DATA___7 = 78,
	GP_3_4_DATA___7 = 79,
	GP_3_5_DATA___7 = 80,
	GP_3_6_DATA___7 = 81,
	GP_3_7_DATA___7 = 82,
	GP_3_8_DATA___7 = 83,
	GP_3_9_DATA___7 = 84,
	GP_4_0_DATA___6 = 85,
	GP_4_1_DATA___6 = 86,
	GP_4_2_DATA___6 = 87,
	GP_4_3_DATA___6 = 88,
	GP_4_4_DATA___6 = 89,
	GP_4_5_DATA___6 = 90,
	GP_4_6_DATA___6 = 91,
	GP_4_7_DATA___6 = 92,
	GP_4_8_DATA___6 = 93,
	GP_4_9_DATA___6 = 94,
	GP_4_10_DATA___6 = 95,
	GP_4_11_DATA___6 = 96,
	GP_4_12_DATA___6 = 97,
	GP_4_13_DATA___6 = 98,
	GP_4_14_DATA___6 = 99,
	GP_4_15_DATA___6 = 100,
	GP_4_16_DATA___6 = 101,
	GP_4_17_DATA___6 = 102,
	GP_4_18_DATA___3 = 103,
	GP_4_19_DATA___3 = 104,
	GP_4_20_DATA___3 = 105,
	GP_4_21_DATA___3 = 106,
	GP_4_22_DATA___3 = 107,
	GP_4_23_DATA___3 = 108,
	GP_4_24_DATA___3 = 109,
	GP_4_25_DATA = 110,
	GP_4_26_DATA = 111,
	GP_4_27_DATA = 112,
	GP_4_28_DATA = 113,
	GP_4_29_DATA = 114,
	GP_4_30_DATA = 115,
	GP_4_31_DATA = 116,
	GP_5_0_DATA___6 = 117,
	GP_5_1_DATA___6 = 118,
	GP_5_2_DATA___6 = 119,
	GP_5_3_DATA___6 = 120,
	GP_5_4_DATA___6 = 121,
	GP_5_5_DATA___6 = 122,
	GP_5_6_DATA___6 = 123,
	GP_5_7_DATA___6 = 124,
	GP_5_8_DATA___6 = 125,
	GP_5_9_DATA___6 = 126,
	GP_5_10_DATA___6 = 127,
	GP_5_11_DATA___6 = 128,
	GP_5_12_DATA___6 = 129,
	GP_5_13_DATA___6 = 130,
	GP_5_14_DATA___6 = 131,
	GP_5_15_DATA___5 = 132,
	GP_5_16_DATA___5 = 133,
	GP_5_17_DATA___5 = 134,
	GP_5_18_DATA___5 = 135,
	GP_5_19_DATA___5 = 136,
	GP_5_20_DATA___5 = 137,
	GP_6_0_DATA___5 = 138,
	GP_6_1_DATA___5 = 139,
	GP_6_2_DATA___5 = 140,
	GP_6_3_DATA___5 = 141,
	GP_6_4_DATA___5 = 142,
	GP_6_5_DATA___5 = 143,
	GP_6_6_DATA___5 = 144,
	GP_6_7_DATA___5 = 145,
	GP_6_8_DATA___5 = 146,
	GP_6_9_DATA___5 = 147,
	GP_6_10_DATA___5 = 148,
	GP_6_11_DATA___5 = 149,
	GP_6_12_DATA___5 = 150,
	GP_6_13_DATA___5 = 151,
	PINMUX_DATA_END___7 = 152,
	PINMUX_FUNCTION_BEGIN___7 = 153,
	GP_0_0_FN___7 = 154,
	GP_0_1_FN___7 = 155,
	GP_0_2_FN___7 = 156,
	GP_0_3_FN___7 = 157,
	GP_0_4_FN___7 = 158,
	GP_0_5_FN___7 = 159,
	GP_0_6_FN___7 = 160,
	GP_0_7_FN___7 = 161,
	GP_0_8_FN___7 = 162,
	GP_1_0_FN___7 = 163,
	GP_1_1_FN___7 = 164,
	GP_1_2_FN___7 = 165,
	GP_1_3_FN___7 = 166,
	GP_1_4_FN___7 = 167,
	GP_1_5_FN___7 = 168,
	GP_1_6_FN___7 = 169,
	GP_1_7_FN___7 = 170,
	GP_1_8_FN___7 = 171,
	GP_1_9_FN___7 = 172,
	GP_1_10_FN___7 = 173,
	GP_1_11_FN___7 = 174,
	GP_1_12_FN___7 = 175,
	GP_1_13_FN___7 = 176,
	GP_1_14_FN___7 = 177,
	GP_1_15_FN___7 = 178,
	GP_1_16_FN___7 = 179,
	GP_1_17_FN___7 = 180,
	GP_1_18_FN___7 = 181,
	GP_1_19_FN___7 = 182,
	GP_1_20_FN___7 = 183,
	GP_1_21_FN___7 = 184,
	GP_1_22_FN___7 = 185,
	GP_1_23_FN___7 = 186,
	GP_1_24_FN___7 = 187,
	GP_1_25_FN___6 = 188,
	GP_1_26_FN___6 = 189,
	GP_1_27_FN___6 = 190,
	GP_1_28_FN___5 = 191,
	GP_1_29_FN = 192,
	GP_1_30_FN = 193,
	GP_1_31_FN = 194,
	GP_2_0_FN___7 = 195,
	GP_2_1_FN___7 = 196,
	GP_2_2_FN___7 = 197,
	GP_2_3_FN___7 = 198,
	GP_2_4_FN___7 = 199,
	GP_2_5_FN___7 = 200,
	GP_2_6_FN___7 = 201,
	GP_2_7_FN___7 = 202,
	GP_2_8_FN___7 = 203,
	GP_2_9_FN___7 = 204,
	GP_2_10_FN___7 = 205,
	GP_2_11_FN___7 = 206,
	GP_2_12_FN___7 = 207,
	GP_2_13_FN___7 = 208,
	GP_2_14_FN___7 = 209,
	GP_2_15_FN___4 = 210,
	GP_2_16_FN___4 = 211,
	GP_2_17_FN___3 = 212,
	GP_2_18_FN___3 = 213,
	GP_2_19_FN___3 = 214,
	GP_2_20_FN___2 = 215,
	GP_2_21_FN___2 = 216,
	GP_2_22_FN___2 = 217,
	GP_2_23_FN___2 = 218,
	GP_2_24_FN___2 = 219,
	GP_2_25_FN___2 = 220,
	GP_2_26_FN___2 = 221,
	GP_2_27_FN___2 = 222,
	GP_2_28_FN___2 = 223,
	GP_2_29_FN___2 = 224,
	GP_2_30_FN = 225,
	GP_2_31_FN = 226,
	GP_3_0_FN___7 = 227,
	GP_3_1_FN___7 = 228,
	GP_3_2_FN___7 = 229,
	GP_3_3_FN___7 = 230,
	GP_3_4_FN___7 = 231,
	GP_3_5_FN___7 = 232,
	GP_3_6_FN___7 = 233,
	GP_3_7_FN___7 = 234,
	GP_3_8_FN___7 = 235,
	GP_3_9_FN___7 = 236,
	GP_4_0_FN___6 = 237,
	GP_4_1_FN___6 = 238,
	GP_4_2_FN___6 = 239,
	GP_4_3_FN___6 = 240,
	GP_4_4_FN___6 = 241,
	GP_4_5_FN___6 = 242,
	GP_4_6_FN___6 = 243,
	GP_4_7_FN___6 = 244,
	GP_4_8_FN___6 = 245,
	GP_4_9_FN___6 = 246,
	GP_4_10_FN___6 = 247,
	GP_4_11_FN___6 = 248,
	GP_4_12_FN___6 = 249,
	GP_4_13_FN___6 = 250,
	GP_4_14_FN___6 = 251,
	GP_4_15_FN___6 = 252,
	GP_4_16_FN___6 = 253,
	GP_4_17_FN___6 = 254,
	GP_4_18_FN___3 = 255,
	GP_4_19_FN___3 = 256,
	GP_4_20_FN___3 = 257,
	GP_4_21_FN___3 = 258,
	GP_4_22_FN___3 = 259,
	GP_4_23_FN___3 = 260,
	GP_4_24_FN___3 = 261,
	GP_4_25_FN = 262,
	GP_4_26_FN = 263,
	GP_4_27_FN = 264,
	GP_4_28_FN = 265,
	GP_4_29_FN = 266,
	GP_4_30_FN = 267,
	GP_4_31_FN = 268,
	GP_5_0_FN___6 = 269,
	GP_5_1_FN___6 = 270,
	GP_5_2_FN___6 = 271,
	GP_5_3_FN___6 = 272,
	GP_5_4_FN___6 = 273,
	GP_5_5_FN___6 = 274,
	GP_5_6_FN___6 = 275,
	GP_5_7_FN___6 = 276,
	GP_5_8_FN___6 = 277,
	GP_5_9_FN___6 = 278,
	GP_5_10_FN___6 = 279,
	GP_5_11_FN___6 = 280,
	GP_5_12_FN___6 = 281,
	GP_5_13_FN___6 = 282,
	GP_5_14_FN___6 = 283,
	GP_5_15_FN___5 = 284,
	GP_5_16_FN___5 = 285,
	GP_5_17_FN___5 = 286,
	GP_5_18_FN___5 = 287,
	GP_5_19_FN___5 = 288,
	GP_5_20_FN___5 = 289,
	GP_6_0_FN___5 = 290,
	GP_6_1_FN___5 = 291,
	GP_6_2_FN___5 = 292,
	GP_6_3_FN___5 = 293,
	GP_6_4_FN___5 = 294,
	GP_6_5_FN___5 = 295,
	GP_6_6_FN___5 = 296,
	GP_6_7_FN___5 = 297,
	GP_6_8_FN___5 = 298,
	GP_6_9_FN___5 = 299,
	GP_6_10_FN___5 = 300,
	GP_6_11_FN___5 = 301,
	GP_6_12_FN___5 = 302,
	GP_6_13_FN___5 = 303,
	FN_TX2 = 304,
	FN_RX2 = 305,
	FN_AVB0_LINK___2 = 306,
	FN_AVB0_PHY_INT___2 = 307,
	FN_AVB0_MAGIC___2 = 308,
	FN_AVB0_MDC___2 = 309,
	FN_AVB0_MDIO___2 = 310,
	FN_MSIOF0_RXD___7 = 311,
	FN_AVB0_TXCREFCLK___2 = 312,
	FN_MSIOF0_TXD___7 = 313,
	FN_AVB0_TD3___2 = 314,
	FN_MSIOF0_SYNC___7 = 315,
	FN_AVB0_TD2___2 = 316,
	FN_RPC_INT_N___4 = 317,
	FN_MSIOF0_SCK___7 = 318,
	FN_AVB0_TD1___2 = 319,
	FN_RPC_RESET_N___4 = 320,
	FN_AVB0_TD0___2 = 321,
	FN_QSPI1_SSL___4 = 322,
	FN_AVB0_TXC___2 = 323,
	FN_QSPI1_IO3___4 = 324,
	FN_SDA0___3 = 325,
	FN_AVB0_TX_CTL___2 = 326,
	FN_QSPI1_IO2___4 = 327,
	FN_SCL0___3 = 328,
	FN_AVB0_RD3___2 = 329,
	FN_QSPI1_MISO_IO1___4 = 330,
	FN_AVB0_RD2___2 = 331,
	FN_QSPI1_MOSI_IO0___4 = 332,
	FN_AVB0_RD1___2 = 333,
	FN_QSPI1_SPCLK___4 = 334,
	FN_VI4_DATA4 = 335,
	FN_AVB0_RD0___2 = 336,
	FN_QSPI0_SSL___4 = 337,
	FN_AVB0_RXC___2 = 338,
	FN_QSPI0_IO3___4 = 339,
	FN_AVB0_RX_CTL___2 = 340,
	FN_QSPI0_IO2___4 = 341,
	FN_QSPI0_MISO_IO1___4 = 342,
	FN_USB0_OVC___4 = 343,
	FN_QSPI0_MOSI_IO0___4 = 344,
	FN_USB0_PWEN___4 = 345,
	FN_VI4_CLK___4 = 346,
	FN_QSPI0_SPCLK___4 = 347,
	FN_IP0_3_0___5 = 348,
	FN_IRQ0_A___2 = 349,
	FN_MSIOF2_SYNC_B___4 = 350,
	FN_IP1_3_0___5 = 351,
	FN_DU_DB1___5 = 352,
	FN_LCDOUT1___4 = 353,
	FN_MSIOF3_RXD_B___4 = 354,
	FN_IP2_3_0___5 = 355,
	FN_DU_DG1___5 = 356,
	FN_LCDOUT9___4 = 357,
	FN_MSIOF3_SYNC_B___4 = 358,
	FN_IP3_3_0___5 = 359,
	FN_DU_DR1___5 = 360,
	FN_LCDOUT17___4 = 361,
	FN_TX4_B___4 = 362,
	FN_IP0_7_4___5 = 363,
	FN_MSIOF2_SCK___4 = 364,
	FN_IP1_7_4___5 = 365,
	FN_DU_DB2___5 = 366,
	FN_LCDOUT2___4 = 367,
	FN_IRQ0_B___2 = 368,
	FN_IP2_7_4___5 = 369,
	FN_DU_DG2___5 = 370,
	FN_LCDOUT10___4 = 371,
	FN_IP3_7_4___5 = 372,
	FN_DU_DR2___5 = 373,
	FN_LCDOUT18___4 = 374,
	FN_PWM0_B___2 = 375,
	FN_IP0_11_8___5 = 376,
	FN_MSIOF2_TXD___4 = 377,
	FN_SCL3_A = 378,
	FN_IP1_11_8___5 = 379,
	FN_DU_DB3___5 = 380,
	FN_LCDOUT3___4 = 381,
	FN_SCK5_B___4 = 382,
	FN_IP2_11_8___5 = 383,
	FN_DU_DG3___5 = 384,
	FN_LCDOUT11___4 = 385,
	FN_IRQ1_A___2 = 386,
	FN_IP3_11_8___5 = 387,
	FN_DU_DR3___5 = 388,
	FN_LCDOUT19___4 = 389,
	FN_PWM1_B___6 = 390,
	FN_IP0_15_12___5 = 391,
	FN_MSIOF2_RXD___4 = 392,
	FN_SDA3_A = 393,
	FN_IP1_15_12___5 = 394,
	FN_DU_DB4___5 = 395,
	FN_LCDOUT4___4 = 396,
	FN_RX5_B___4 = 397,
	FN_IP2_15_12___5 = 398,
	FN_DU_DG4___5 = 399,
	FN_LCDOUT12___4 = 400,
	FN_HSCK3_B___2 = 401,
	FN_IP3_15_12___5 = 402,
	FN_DU_DR4___5 = 403,
	FN_LCDOUT20___4 = 404,
	FN_TCLK2_B___6 = 405,
	FN_IP0_19_16___5 = 406,
	FN_MLB_CLK___4 = 407,
	FN_MSIOF2_SYNC_A___4 = 408,
	FN_SCK5_A___4 = 409,
	FN_IP1_19_16___5 = 410,
	FN_DU_DB5___5 = 411,
	FN_LCDOUT5___4 = 412,
	FN_TX5_B___4 = 413,
	FN_IP2_19_16___5 = 414,
	FN_DU_DG5___5 = 415,
	FN_LCDOUT13___4 = 416,
	FN_HTX3_B___5 = 417,
	FN_IP3_19_16___5 = 418,
	FN_DU_DR5___5 = 419,
	FN_LCDOUT21___4 = 420,
	FN_NMI = 421,
	FN_IP0_23_20___5 = 422,
	FN_MLB_DAT___4 = 423,
	FN_MSIOF2_SS1___4 = 424,
	FN_RX5_A___4 = 425,
	FN_SCL3_B = 426,
	FN_IP1_23_20___5 = 427,
	FN_DU_DB6___5 = 428,
	FN_LCDOUT6___4 = 429,
	FN_MSIOF3_SS1_B___4 = 430,
	FN_IP2_23_20___5 = 431,
	FN_DU_DG6___5 = 432,
	FN_LCDOUT14___4 = 433,
	FN_HRX3_B___5 = 434,
	FN_IP3_23_20___5 = 435,
	FN_DU_DR6___5 = 436,
	FN_LCDOUT22___4 = 437,
	FN_PWM2_B___5 = 438,
	FN_IP0_27_24___5 = 439,
	FN_MLB_SIG___4 = 440,
	FN_MSIOF2_SS2___4 = 441,
	FN_TX5_A___4 = 442,
	FN_SDA3_B = 443,
	FN_IP1_27_24___5 = 444,
	FN_DU_DB7___5 = 445,
	FN_LCDOUT7___4 = 446,
	FN_MSIOF3_SS2_B___4 = 447,
	FN_IP2_27_24___5 = 448,
	FN_DU_DG7___5 = 449,
	FN_LCDOUT15___4 = 450,
	FN_SCK4_B___4 = 451,
	FN_IP3_27_24___5 = 452,
	FN_DU_DR7___5 = 453,
	FN_LCDOUT23___4 = 454,
	FN_TCLK1_B___6 = 455,
	FN_IP0_31_28___5 = 456,
	FN_DU_DB0___5 = 457,
	FN_LCDOUT0___4 = 458,
	FN_MSIOF3_TXD_B___4 = 459,
	FN_IP1_31_28___5 = 460,
	FN_DU_DG0___5 = 461,
	FN_LCDOUT8___4 = 462,
	FN_MSIOF3_SCK_B___4 = 463,
	FN_IP2_31_28___5 = 464,
	FN_DU_DR0___5 = 465,
	FN_LCDOUT16___4 = 466,
	FN_RX4_B___4 = 467,
	FN_IP3_31_28___5 = 468,
	FN_DU_DOTCLKOUT0___4 = 469,
	FN_QCLK___4 = 470,
	FN_IP4_3_0___5 = 471,
	FN_DU_HSYNC = 472,
	FN_QSTH_QHS___4 = 473,
	FN_IRQ3_A___2 = 474,
	FN_IP5_3_0___5 = 475,
	FN_VI4_DATA1 = 476,
	FN_PWM1_A___6 = 477,
	FN_IP6_3_0___5 = 478,
	FN_VI4_DATA10___4 = 479,
	FN_RX4_A___4 = 480,
	FN_IP7_3_0___5 = 481,
	FN_VI4_DATA18___4 = 482,
	FN_HSCK3_A___2 = 483,
	FN_IP4_7_4___5 = 484,
	FN_DU_VSYNC = 485,
	FN_QSTVA_QVS___4 = 486,
	FN_IRQ4_A___2 = 487,
	FN_IP5_7_4___5 = 488,
	FN_VI4_DATA2 = 489,
	FN_PWM2_A___5 = 490,
	FN_IP6_7_4___5 = 491,
	FN_VI4_DATA11___4 = 492,
	FN_TX4_A___4 = 493,
	FN_IP7_7_4___5 = 494,
	FN_VI4_DATA19___4 = 495,
	FN_SSI_WS4_B = 496,
	FN_NFDATA15 = 497,
	FN_IP4_11_8___5 = 498,
	FN_DU_DISP___5 = 499,
	FN_QSTVB_QVE___4 = 500,
	FN_PWM3_B___6 = 501,
	FN_IP5_11_8___5 = 502,
	FN_VI4_DATA3 = 503,
	FN_PWM3_A___6 = 504,
	FN_IP6_11_8___5 = 505,
	FN_VI4_DATA12___4 = 506,
	FN_TCLK1_A___6 = 507,
	FN_IP7_11_8___5 = 508,
	FN_VI4_DATA20___4 = 509,
	FN_MSIOF3_SYNC_A___4 = 510,
	FN_NFDATA14 = 511,
	FN_IP4_15_12___5 = 512,
	FN_DU_DISP_CDE = 513,
	FN_QCPV_QDE___4 = 514,
	FN_IRQ2_B___2 = 515,
	FN_DU_DOTCLKIN1 = 516,
	FN_IP5_15_12___5 = 517,
	FN_VI4_DATA5 = 518,
	FN_SCK4_A___4 = 519,
	FN_IP6_15_12___5 = 520,
	FN_VI4_DATA13___4 = 521,
	FN_MSIOF3_SS1_A___4 = 522,
	FN_HCTS3_N___6 = 523,
	FN_IP7_15_12___2 = 524,
	FN_VI4_DATA21___4 = 525,
	FN_MSIOF3_TXD_A___4 = 526,
	FN_NFDATA13___4 = 527,
	FN_IP4_19_16___5 = 528,
	FN_DU_CDE___5 = 529,
	FN_QSTB_QHE___4 = 530,
	FN_SCK3_B___2 = 531,
	FN_IP5_19_16___5 = 532,
	FN_VI4_DATA6 = 533,
	FN_IRQ2_A___2 = 534,
	FN_IP6_19_16___5 = 535,
	FN_VI4_DATA14___4 = 536,
	FN_SSI_SCK4_B = 537,
	FN_HRTS3_N___6 = 538,
	FN_IP7_19_16___5 = 539,
	FN_VI4_DATA22___4 = 540,
	FN_MSIOF3_RXD_A___4 = 541,
	FN_NFDATA12___4 = 542,
	FN_IP4_23_20___5 = 543,
	FN_QPOLA___4 = 544,
	FN_RX3_B___5 = 545,
	FN_IP5_23_20___5 = 546,
	FN_VI4_DATA7 = 547,
	FN_TCLK2_A___6 = 548,
	FN_IP6_23_20___5 = 549,
	FN_VI4_DATA15___4 = 550,
	FN_SSI_SDATA4_B = 551,
	FN_IP7_23_20___5 = 552,
	FN_VI4_DATA23___4 = 553,
	FN_MSIOF3_SCK_A___4 = 554,
	FN_NFDATA11___4 = 555,
	FN_IP4_27_24___5 = 556,
	FN_QPOLB___4 = 557,
	FN_TX3_B___5 = 558,
	FN_IP5_27_24___5 = 559,
	FN_VI4_DATA8___4 = 560,
	FN_IP6_27_24___5 = 561,
	FN_VI4_DATA16___4 = 562,
	FN_HRX3_A___5 = 563,
	FN_IP7_27_24___5 = 564,
	FN_VI4_VSYNC_N___4 = 565,
	FN_SCK1_B___2 = 566,
	FN_NFDATA10___4 = 567,
	FN_IP4_31_28___5 = 568,
	FN_VI4_DATA0 = 569,
	FN_PWM0_A___2 = 570,
	FN_IP5_31_28___5 = 571,
	FN_VI4_DATA9___4 = 572,
	FN_MSIOF3_SS2_A___4 = 573,
	FN_IRQ1_B___2 = 574,
	FN_IP6_31_28___5 = 575,
	FN_VI4_DATA17___4 = 576,
	FN_HTX3_A___5 = 577,
	FN_IP7_31_28___5 = 578,
	FN_VI4_HSYNC_N___4 = 579,
	FN_RX1_B___6 = 580,
	FN_NFDATA9___4 = 581,
	FN_IP8_3_0___5 = 582,
	FN_VI4_FIELD___4 = 583,
	FN_AUDIO_CLKB = 584,
	FN_IRQ5_A = 585,
	FN_SCIF_CLK___3 = 586,
	FN_NFDATA8___4 = 587,
	FN_IP9_3_0___5 = 588,
	FN_NFDATA0___4 = 589,
	FN_MMC_D0___2 = 590,
	FN_IP10_3_0___5 = 591,
	FN_AUDIO_CLKA = 592,
	FN_DVC_MUTE_B = 593,
	FN_IP11_3_0___4 = 594,
	FN_SDA1___3 = 595,
	FN_RTS1_N___6 = 596,
	FN_IP8_7_4___5 = 597,
	FN_VI4_CLKENB___4 = 598,
	FN_TX1_B___6 = 599,
	FN_NFWP_N = 600,
	FN_DVC_MUTE_A = 601,
	FN_IP9_7_4___5 = 602,
	FN_NFDATA1___4 = 603,
	FN_MMC_D1___2 = 604,
	FN_IP10_7_4___5 = 605,
	FN_SSI_SCK34 = 606,
	FN_FSO_CFE_0_N_A = 607,
	FN_IP11_7_4___4 = 608,
	FN_MSIOF1_SCK___4 = 609,
	FN_AVB0_AVTP_PPS_B = 610,
	FN_IP8_11_8___5 = 611,
	FN_NFALE___4 = 612,
	FN_SCL2_B___4 = 613,
	FN_IRQ3_B___2 = 614,
	FN_PWM0_C = 615,
	FN_IP9_11_8___5 = 616,
	FN_NFDATA2___4 = 617,
	FN_MMC_D2___2 = 618,
	FN_IP10_11_8___5 = 619,
	FN_SSI_SDATA3___4 = 620,
	FN_FSO_CFE_1_N_A = 621,
	FN_IP11_11_8___4 = 622,
	FN_MSIOF1_TXD___4 = 623,
	FN_AVB0_AVTP_CAPTURE_B = 624,
	FN_IP8_15_12___5 = 625,
	FN_NFCLE___4 = 626,
	FN_SDA2_B___4 = 627,
	FN_SCK3_A___2 = 628,
	FN_PWM1_C = 629,
	FN_IP9_15_12___5 = 630,
	FN_NFDATA3___4 = 631,
	FN_MMC_D3___2 = 632,
	FN_IP10_15_12___5 = 633,
	FN_SSI_WS34 = 634,
	FN_FSO_TOE_N_A = 635,
	FN_IP11_15_12___4 = 636,
	FN_MSIOF1_RXD___4 = 637,
	FN_AVB0_AVTP_MATCH_B = 638,
	FN_IP8_19_16___5 = 639,
	FN_NFCE_N = 640,
	FN_RX3_A___5 = 641,
	FN_PWM2_C = 642,
	FN_IP9_19_16___5 = 643,
	FN_NFDATA4___4 = 644,
	FN_MMC_D4___4 = 645,
	FN_IP10_19_16___5 = 646,
	FN_SSI_SCK4_A = 647,
	FN_HSCK0___6 = 648,
	FN_AUDIO_CLKOUT___2 = 649,
	FN_CAN0_RX_B___4 = 650,
	FN_IRQ4_B___2 = 651,
	FN_IP11_19_16___4 = 652,
	FN_SCK0_A = 653,
	FN_MSIOF1_SYNC___4 = 654,
	FN_FSO_CFE_0_N_B = 655,
	FN_IP8_23_20___5 = 656,
	FN_NFRB_N = 657,
	FN_TX3_A___5 = 658,
	FN_PWM3_C = 659,
	FN_IP9_23_20___5 = 660,
	FN_NFDATA5___4 = 661,
	FN_MMC_D5___4 = 662,
	FN_IP10_23_20___4 = 663,
	FN_SSI_SDATA4_A = 664,
	FN_HTX0___6 = 665,
	FN_SCL2_A___4 = 666,
	FN_CAN1_RX_B = 667,
	FN_IP11_23_20___4 = 668,
	FN_RX0_A = 669,
	FN_MSIOF0_SS1___7 = 670,
	FN_FSO_CFE_1_N_B = 671,
	FN_IP8_27_24___5 = 672,
	FN_NFRE_N___4 = 673,
	FN_MMC_CMD___2 = 674,
	FN_IP9_27_24___5 = 675,
	FN_NFDATA6___4 = 676,
	FN_MMC_D6___4 = 677,
	FN_IP10_27_24___4 = 678,
	FN_SSI_WS4_A = 679,
	FN_HRX0___6 = 680,
	FN_SDA2_A___4 = 681,
	FN_CAN1_TX_B = 682,
	FN_IP11_27_24___4 = 683,
	FN_TX0_A = 684,
	FN_MSIOF0_SS2___7 = 685,
	FN_FSO_TOE_N_B = 686,
	FN_IP8_31_28___5 = 687,
	FN_NFWE_N___4 = 688,
	FN_MMC_CLK___2 = 689,
	FN_IP9_31_28___5 = 690,
	FN_NFDATA7___4 = 691,
	FN_MMC_D7___4 = 692,
	FN_IP10_31_28___4 = 693,
	FN_SCL1___3 = 694,
	FN_CTS1_N___6 = 695,
	FN_IP11_31_28___4 = 696,
	FN_SCK1_A___2 = 697,
	FN_MSIOF1_SS2___4 = 698,
	FN_TPU0TO2_B___2 = 699,
	FN_CAN0_TX_B___4 = 700,
	FN_AUDIO_CLKOUT1 = 701,
	FN_IP12_3_0___4 = 702,
	FN_RX1_A___6 = 703,
	FN_CTS0_N___7 = 704,
	FN_TPU0TO0_B___2 = 705,
	FN_IP13_3_0___4 = 706,
	FN_CAN1_RX_A = 707,
	FN_CANFD1_RX___6 = 708,
	FN_TPU0TO2_A___2 = 709,
	FN_IP12_7_4___4 = 710,
	FN_TX1_A___6 = 711,
	FN_RTS0_N___7 = 712,
	FN_TPU0TO1_B___2 = 713,
	FN_IP13_7_4___4 = 714,
	FN_CAN1_TX_A = 715,
	FN_CANFD1_TX___6 = 716,
	FN_TPU0TO3_A___2 = 717,
	FN_IP12_11_8___4 = 718,
	FN_SCK2___4 = 719,
	FN_MSIOF1_SS1___4 = 720,
	FN_TPU0TO3_B___2 = 721,
	FN_IP12_15_12___4 = 722,
	FN_TPU0TO0_A___2 = 723,
	FN_AVB0_AVTP_CAPTURE_A = 724,
	FN_HCTS0_N___6 = 725,
	FN_IP12_19_16___4 = 726,
	FN_TPU0TO1_A___2 = 727,
	FN_AVB0_AVTP_MATCH_A = 728,
	FN_HRTS0_N___6 = 729,
	FN_IP12_23_20___4 = 730,
	FN_CAN_CLK___5 = 731,
	FN_AVB0_AVTP_PPS_A = 732,
	FN_SCK0_B = 733,
	FN_IRQ5_B = 734,
	FN_IP12_27_24___4 = 735,
	FN_CAN0_RX_A___4 = 736,
	FN_CANFD0_RX___2 = 737,
	FN_RX0_B = 738,
	FN_IP12_31_28___4 = 739,
	FN_CAN0_TX_A___4 = 740,
	FN_CANFD0_TX___2 = 741,
	FN_TX0_B = 742,
	FN_SEL_CAN0_0 = 743,
	FN_SEL_CAN0_1 = 744,
	FN_SEL_MSIOF2_0___4 = 745,
	FN_SEL_MSIOF2_1___4 = 746,
	FN_SEL_CAN1_0 = 747,
	FN_SEL_CAN1_1 = 748,
	FN_SEL_I2C3_0___2 = 749,
	FN_SEL_I2C3_1 = 750,
	FN_SEL_I2C2_0___5 = 751,
	FN_SEL_I2C2_1___4 = 752,
	FN_SEL_SCIF5_0___4 = 753,
	FN_SEL_SCIF5_1___4 = 754,
	FN_SEL_ETHERAVB_0___4 = 755,
	FN_SEL_ETHERAVB_1___4 = 756,
	FN_SEL_MSIOF3_0___4 = 757,
	FN_SEL_MSIOF3_1___4 = 758,
	FN_SEL_SCIF0_0 = 759,
	FN_SEL_SCIF0_1 = 760,
	FN_SEL_HSCIF3_0___4 = 761,
	FN_SEL_HSCIF3_1___4 = 762,
	FN_SEL_SSIF4_0 = 763,
	FN_SEL_SSIF4_1 = 764,
	FN_SEL_SCIF4_0___4 = 765,
	FN_SEL_SCIF4_1___4 = 766,
	FN_SEL_PWM0_0___2 = 767,
	FN_SEL_PWM0_2 = 768,
	FN_SEL_PWM0_1___2 = 769,
	FN_SEL_PWM1_0___5 = 770,
	FN_SEL_PWM1_2 = 771,
	FN_SEL_PWM1_1___5 = 772,
	FN_SEL_PWM2_0___5 = 773,
	FN_SEL_PWM2_2 = 774,
	FN_SEL_PWM2_1___5 = 775,
	FN_SEL_PWM3_0___5 = 776,
	FN_SEL_PWM3_2 = 777,
	FN_SEL_PWM3_1___5 = 778,
	FN_SEL_IRQ_0_0 = 779,
	FN_SEL_IRQ_0_1 = 780,
	FN_SEL_IRQ_1_0 = 781,
	FN_SEL_IRQ_1_1 = 782,
	FN_SEL_IRQ_2_0 = 783,
	FN_SEL_IRQ_2_1 = 784,
	FN_SEL_IRQ_3_0 = 785,
	FN_SEL_IRQ_3_1 = 786,
	FN_SEL_IRQ_4_0 = 787,
	FN_SEL_IRQ_4_1 = 788,
	FN_SEL_IRQ_5_0 = 789,
	FN_SEL_IRQ_5_1 = 790,
	FN_SEL_TMU_0_0 = 791,
	FN_SEL_TMU_0_1 = 792,
	FN_SEL_TMU_1_0 = 793,
	FN_SEL_TMU_1_1 = 794,
	FN_SEL_SCIF3_0___4 = 795,
	FN_SEL_SCIF3_1___4 = 796,
	FN_SEL_SCIF1_0___5 = 797,
	FN_SEL_SCIF1_1___5 = 798,
	FN_SEL_SCU_0 = 799,
	FN_SEL_SCU_1 = 800,
	FN_SEL_RFSO_0 = 801,
	FN_SEL_RFSO_1 = 802,
	PINMUX_FUNCTION_END___7 = 803,
	PINMUX_MARK_BEGIN___7 = 804,
	TX2_MARK = 805,
	RX2_MARK = 806,
	AVB0_LINK_MARK___2 = 807,
	AVB0_PHY_INT_MARK___2 = 808,
	AVB0_MAGIC_MARK___2 = 809,
	AVB0_MDC_MARK___2 = 810,
	AVB0_MDIO_MARK___2 = 811,
	MSIOF0_RXD_MARK___7 = 812,
	AVB0_TXCREFCLK_MARK___2 = 813,
	MSIOF0_TXD_MARK___7 = 814,
	AVB0_TD3_MARK___2 = 815,
	MSIOF0_SYNC_MARK___7 = 816,
	AVB0_TD2_MARK___2 = 817,
	RPC_INT_N_MARK___4 = 818,
	MSIOF0_SCK_MARK___7 = 819,
	AVB0_TD1_MARK___2 = 820,
	RPC_RESET_N_MARK___4 = 821,
	AVB0_TD0_MARK___2 = 822,
	QSPI1_SSL_MARK___7 = 823,
	AVB0_TXC_MARK___2 = 824,
	QSPI1_IO3_MARK___7 = 825,
	SDA0_MARK___7 = 826,
	AVB0_TX_CTL_MARK___2 = 827,
	QSPI1_IO2_MARK___7 = 828,
	SCL0_MARK___7 = 829,
	AVB0_RD3_MARK___2 = 830,
	QSPI1_MISO_IO1_MARK___7 = 831,
	AVB0_RD2_MARK___2 = 832,
	QSPI1_MOSI_IO0_MARK___7 = 833,
	AVB0_RD1_MARK___2 = 834,
	QSPI1_SPCLK_MARK___7 = 835,
	VI4_DATA4_MARK = 836,
	AVB0_RD0_MARK___2 = 837,
	QSPI0_SSL_MARK___7 = 838,
	AVB0_RXC_MARK___2 = 839,
	QSPI0_IO3_MARK___7 = 840,
	AVB0_RX_CTL_MARK___2 = 841,
	QSPI0_IO2_MARK___7 = 842,
	QSPI0_MISO_IO1_MARK___7 = 843,
	USB0_OVC_MARK___4 = 844,
	QSPI0_MOSI_IO0_MARK___7 = 845,
	USB0_PWEN_MARK___4 = 846,
	VI4_CLK_MARK___4 = 847,
	QSPI0_SPCLK_MARK___7 = 848,
	IP0_3_0_MARK___5 = 849,
	IRQ0_A_MARK___2 = 850,
	MSIOF2_SYNC_B_MARK___4 = 851,
	IP1_3_0_MARK___5 = 852,
	DU_DB1_MARK___5 = 853,
	LCDOUT1_MARK___4 = 854,
	MSIOF3_RXD_B_MARK___4 = 855,
	IP2_3_0_MARK___5 = 856,
	DU_DG1_MARK___5 = 857,
	LCDOUT9_MARK___4 = 858,
	MSIOF3_SYNC_B_MARK___4 = 859,
	IP3_3_0_MARK___5 = 860,
	DU_DR1_MARK___5 = 861,
	LCDOUT17_MARK___4 = 862,
	TX4_B_MARK___4 = 863,
	IP0_7_4_MARK___5 = 864,
	MSIOF2_SCK_MARK___4 = 865,
	IP1_7_4_MARK___5 = 866,
	DU_DB2_MARK___5 = 867,
	LCDOUT2_MARK___4 = 868,
	IRQ0_B_MARK___2 = 869,
	IP2_7_4_MARK___5 = 870,
	DU_DG2_MARK___5 = 871,
	LCDOUT10_MARK___4 = 872,
	IP3_7_4_MARK___5 = 873,
	DU_DR2_MARK___5 = 874,
	LCDOUT18_MARK___4 = 875,
	PWM0_B_MARK___2 = 876,
	IP0_11_8_MARK___5 = 877,
	MSIOF2_TXD_MARK___4 = 878,
	SCL3_A_MARK = 879,
	IP1_11_8_MARK___5 = 880,
	DU_DB3_MARK___5 = 881,
	LCDOUT3_MARK___4 = 882,
	SCK5_B_MARK___4 = 883,
	IP2_11_8_MARK___5 = 884,
	DU_DG3_MARK___5 = 885,
	LCDOUT11_MARK___4 = 886,
	IRQ1_A_MARK___2 = 887,
	IP3_11_8_MARK___5 = 888,
	DU_DR3_MARK___5 = 889,
	LCDOUT19_MARK___4 = 890,
	PWM1_B_MARK___6 = 891,
	IP0_15_12_MARK___5 = 892,
	MSIOF2_RXD_MARK___4 = 893,
	SDA3_A_MARK = 894,
	IP1_15_12_MARK___5 = 895,
	DU_DB4_MARK___5 = 896,
	LCDOUT4_MARK___4 = 897,
	RX5_B_MARK___4 = 898,
	IP2_15_12_MARK___5 = 899,
	DU_DG4_MARK___5 = 900,
	LCDOUT12_MARK___4 = 901,
	HSCK3_B_MARK___2 = 902,
	IP3_15_12_MARK___5 = 903,
	DU_DR4_MARK___5 = 904,
	LCDOUT20_MARK___4 = 905,
	TCLK2_B_MARK___6 = 906,
	IP0_19_16_MARK___5 = 907,
	MLB_CLK_MARK___4 = 908,
	MSIOF2_SYNC_A_MARK___4 = 909,
	SCK5_A_MARK___4 = 910,
	IP1_19_16_MARK___5 = 911,
	DU_DB5_MARK___5 = 912,
	LCDOUT5_MARK___4 = 913,
	TX5_B_MARK___4 = 914,
	IP2_19_16_MARK___5 = 915,
	DU_DG5_MARK___5 = 916,
	LCDOUT13_MARK___4 = 917,
	HTX3_B_MARK___5 = 918,
	IP3_19_16_MARK___5 = 919,
	DU_DR5_MARK___5 = 920,
	LCDOUT21_MARK___4 = 921,
	NMI_MARK = 922,
	IP0_23_20_MARK___5 = 923,
	MLB_DAT_MARK___4 = 924,
	MSIOF2_SS1_MARK___4 = 925,
	RX5_A_MARK___4 = 926,
	SCL3_B_MARK = 927,
	IP1_23_20_MARK___5 = 928,
	DU_DB6_MARK___5 = 929,
	LCDOUT6_MARK___4 = 930,
	MSIOF3_SS1_B_MARK___4 = 931,
	IP2_23_20_MARK___5 = 932,
	DU_DG6_MARK___5 = 933,
	LCDOUT14_MARK___4 = 934,
	HRX3_B_MARK___5 = 935,
	IP3_23_20_MARK___5 = 936,
	DU_DR6_MARK___5 = 937,
	LCDOUT22_MARK___4 = 938,
	PWM2_B_MARK___5 = 939,
	IP0_27_24_MARK___5 = 940,
	MLB_SIG_MARK___4 = 941,
	MSIOF2_SS2_MARK___4 = 942,
	TX5_A_MARK___4 = 943,
	SDA3_B_MARK = 944,
	IP1_27_24_MARK___5 = 945,
	DU_DB7_MARK___5 = 946,
	LCDOUT7_MARK___4 = 947,
	MSIOF3_SS2_B_MARK___4 = 948,
	IP2_27_24_MARK___5 = 949,
	DU_DG7_MARK___5 = 950,
	LCDOUT15_MARK___4 = 951,
	SCK4_B_MARK___4 = 952,
	IP3_27_24_MARK___5 = 953,
	DU_DR7_MARK___5 = 954,
	LCDOUT23_MARK___4 = 955,
	TCLK1_B_MARK___6 = 956,
	IP0_31_28_MARK___5 = 957,
	DU_DB0_MARK___5 = 958,
	LCDOUT0_MARK___4 = 959,
	MSIOF3_TXD_B_MARK___4 = 960,
	IP1_31_28_MARK___5 = 961,
	DU_DG0_MARK___5 = 962,
	LCDOUT8_MARK___4 = 963,
	MSIOF3_SCK_B_MARK___4 = 964,
	IP2_31_28_MARK___5 = 965,
	DU_DR0_MARK___5 = 966,
	LCDOUT16_MARK___4 = 967,
	RX4_B_MARK___4 = 968,
	IP3_31_28_MARK___5 = 969,
	DU_DOTCLKOUT0_MARK___4 = 970,
	QCLK_MARK___4 = 971,
	IP4_3_0_MARK___5 = 972,
	DU_HSYNC_MARK = 973,
	QSTH_QHS_MARK___4 = 974,
	IRQ3_A_MARK___2 = 975,
	IP5_3_0_MARK___5 = 976,
	VI4_DATA1_MARK = 977,
	PWM1_A_MARK___6 = 978,
	IP6_3_0_MARK___5 = 979,
	VI4_DATA10_MARK___4 = 980,
	RX4_A_MARK___4 = 981,
	IP7_3_0_MARK___5 = 982,
	VI4_DATA18_MARK___4 = 983,
	HSCK3_A_MARK___2 = 984,
	IP4_7_4_MARK___5 = 985,
	DU_VSYNC_MARK = 986,
	QSTVA_QVS_MARK___4 = 987,
	IRQ4_A_MARK___2 = 988,
	IP5_7_4_MARK___5 = 989,
	VI4_DATA2_MARK = 990,
	PWM2_A_MARK___5 = 991,
	IP6_7_4_MARK___5 = 992,
	VI4_DATA11_MARK___4 = 993,
	TX4_A_MARK___4 = 994,
	IP7_7_4_MARK___5 = 995,
	VI4_DATA19_MARK___4 = 996,
	SSI_WS4_B_MARK = 997,
	NFDATA15_MARK = 998,
	IP4_11_8_MARK___5 = 999,
	DU_DISP_MARK___5 = 1000,
	QSTVB_QVE_MARK___4 = 1001,
	PWM3_B_MARK___6 = 1002,
	IP5_11_8_MARK___5 = 1003,
	VI4_DATA3_MARK = 1004,
	PWM3_A_MARK___6 = 1005,
	IP6_11_8_MARK___5 = 1006,
	VI4_DATA12_MARK___4 = 1007,
	TCLK1_A_MARK___6 = 1008,
	IP7_11_8_MARK___5 = 1009,
	VI4_DATA20_MARK___4 = 1010,
	MSIOF3_SYNC_A_MARK___4 = 1011,
	NFDATA14_MARK = 1012,
	IP4_15_12_MARK___5 = 1013,
	DU_DISP_CDE_MARK = 1014,
	QCPV_QDE_MARK___4 = 1015,
	IRQ2_B_MARK___2 = 1016,
	DU_DOTCLKIN1_MARK___4 = 1017,
	IP5_15_12_MARK___5 = 1018,
	VI4_DATA5_MARK = 1019,
	SCK4_A_MARK___4 = 1020,
	IP6_15_12_MARK___5 = 1021,
	VI4_DATA13_MARK___4 = 1022,
	MSIOF3_SS1_A_MARK___4 = 1023,
	HCTS3_N_MARK___6 = 1024,
	IP7_15_12_MARK___2 = 1025,
	VI4_DATA21_MARK___4 = 1026,
	MSIOF3_TXD_A_MARK___4 = 1027,
	NFDATA13_MARK___4 = 1028,
	IP4_19_16_MARK___5 = 1029,
	DU_CDE_MARK___5 = 1030,
	QSTB_QHE_MARK___4 = 1031,
	SCK3_B_MARK___2 = 1032,
	IP5_19_16_MARK___5 = 1033,
	VI4_DATA6_MARK = 1034,
	IRQ2_A_MARK___2 = 1035,
	IP6_19_16_MARK___5 = 1036,
	VI4_DATA14_MARK___4 = 1037,
	SSI_SCK4_B_MARK = 1038,
	HRTS3_N_MARK___6 = 1039,
	IP7_19_16_MARK___5 = 1040,
	VI4_DATA22_MARK___4 = 1041,
	MSIOF3_RXD_A_MARK___4 = 1042,
	NFDATA12_MARK___4 = 1043,
	IP4_23_20_MARK___5 = 1044,
	QPOLA_MARK___4 = 1045,
	RX3_B_MARK___5 = 1046,
	IP5_23_20_MARK___5 = 1047,
	VI4_DATA7_MARK = 1048,
	TCLK2_A_MARK___6 = 1049,
	IP6_23_20_MARK___5 = 1050,
	VI4_DATA15_MARK___4 = 1051,
	SSI_SDATA4_B_MARK = 1052,
	IP7_23_20_MARK___5 = 1053,
	VI4_DATA23_MARK___4 = 1054,
	MSIOF3_SCK_A_MARK___4 = 1055,
	NFDATA11_MARK___4 = 1056,
	IP4_27_24_MARK___5 = 1057,
	QPOLB_MARK___4 = 1058,
	TX3_B_MARK___5 = 1059,
	IP5_27_24_MARK___5 = 1060,
	VI4_DATA8_MARK___4 = 1061,
	IP6_27_24_MARK___5 = 1062,
	VI4_DATA16_MARK___4 = 1063,
	HRX3_A_MARK___5 = 1064,
	IP7_27_24_MARK___5 = 1065,
	VI4_VSYNC_N_MARK___4 = 1066,
	SCK1_B_MARK___2 = 1067,
	NFDATA10_MARK___4 = 1068,
	IP4_31_28_MARK___5 = 1069,
	VI4_DATA0_MARK = 1070,
	PWM0_A_MARK___2 = 1071,
	IP5_31_28_MARK___5 = 1072,
	VI4_DATA9_MARK___4 = 1073,
	MSIOF3_SS2_A_MARK___4 = 1074,
	IRQ1_B_MARK___2 = 1075,
	IP6_31_28_MARK___5 = 1076,
	VI4_DATA17_MARK___4 = 1077,
	HTX3_A_MARK___5 = 1078,
	IP7_31_28_MARK___5 = 1079,
	VI4_HSYNC_N_MARK___4 = 1080,
	RX1_B_MARK___6 = 1081,
	NFDATA9_MARK___4 = 1082,
	IP8_3_0_MARK___5 = 1083,
	VI4_FIELD_MARK___4 = 1084,
	AUDIO_CLKB_MARK = 1085,
	IRQ5_A_MARK = 1086,
	SCIF_CLK_MARK___3 = 1087,
	NFDATA8_MARK___4 = 1088,
	IP9_3_0_MARK___5 = 1089,
	NFDATA0_MARK___4 = 1090,
	MMC_D0_MARK___2 = 1091,
	IP10_3_0_MARK___5 = 1092,
	AUDIO_CLKA_MARK = 1093,
	DVC_MUTE_B_MARK = 1094,
	IP11_3_0_MARK___4 = 1095,
	SDA1_MARK___4 = 1096,
	RTS1_N_MARK___6 = 1097,
	IP8_7_4_MARK___5 = 1098,
	VI4_CLKENB_MARK___4 = 1099,
	TX1_B_MARK___6 = 1100,
	NFWP_N_MARK = 1101,
	DVC_MUTE_A_MARK = 1102,
	IP9_7_4_MARK___5 = 1103,
	NFDATA1_MARK___4 = 1104,
	MMC_D1_MARK___2 = 1105,
	IP10_7_4_MARK___5 = 1106,
	SSI_SCK34_MARK = 1107,
	FSO_CFE_0_N_A_MARK = 1108,
	IP11_7_4_MARK___4 = 1109,
	MSIOF1_SCK_MARK___4 = 1110,
	AVB0_AVTP_PPS_B_MARK = 1111,
	IP8_11_8_MARK___5 = 1112,
	NFALE_MARK___4 = 1113,
	SCL2_B_MARK___4 = 1114,
	IRQ3_B_MARK___2 = 1115,
	PWM0_C_MARK = 1116,
	IP9_11_8_MARK___5 = 1117,
	NFDATA2_MARK___4 = 1118,
	MMC_D2_MARK___2 = 1119,
	IP10_11_8_MARK___5 = 1120,
	SSI_SDATA3_MARK___4 = 1121,
	FSO_CFE_1_N_A_MARK = 1122,
	IP11_11_8_MARK___4 = 1123,
	MSIOF1_TXD_MARK___4 = 1124,
	AVB0_AVTP_CAPTURE_B_MARK = 1125,
	IP8_15_12_MARK___5 = 1126,
	NFCLE_MARK___4 = 1127,
	SDA2_B_MARK___4 = 1128,
	SCK3_A_MARK___2 = 1129,
	PWM1_C_MARK = 1130,
	IP9_15_12_MARK___5 = 1131,
	NFDATA3_MARK___4 = 1132,
	MMC_D3_MARK___2 = 1133,
	IP10_15_12_MARK___5 = 1134,
	SSI_WS34_MARK = 1135,
	FSO_TOE_N_A_MARK = 1136,
	IP11_15_12_MARK___4 = 1137,
	MSIOF1_RXD_MARK___4 = 1138,
	AVB0_AVTP_MATCH_B_MARK = 1139,
	IP8_19_16_MARK___5 = 1140,
	NFCE_N_MARK = 1141,
	RX3_A_MARK___5 = 1142,
	PWM2_C_MARK = 1143,
	IP9_19_16_MARK___5 = 1144,
	NFDATA4_MARK___4 = 1145,
	MMC_D4_MARK___4 = 1146,
	IP10_19_16_MARK___5 = 1147,
	SSI_SCK4_A_MARK = 1148,
	HSCK0_MARK___6 = 1149,
	AUDIO_CLKOUT_MARK___2 = 1150,
	CAN0_RX_B_MARK___4 = 1151,
	IRQ4_B_MARK___2 = 1152,
	IP11_19_16_MARK___4 = 1153,
	SCK0_A_MARK = 1154,
	MSIOF1_SYNC_MARK___4 = 1155,
	FSO_CFE_0_N_B_MARK = 1156,
	IP8_23_20_MARK___5 = 1157,
	NFRB_N_MARK = 1158,
	TX3_A_MARK___5 = 1159,
	PWM3_C_MARK = 1160,
	IP9_23_20_MARK___5 = 1161,
	NFDATA5_MARK___4 = 1162,
	MMC_D5_MARK___4 = 1163,
	IP10_23_20_MARK___4 = 1164,
	SSI_SDATA4_A_MARK = 1165,
	HTX0_MARK___6 = 1166,
	SCL2_A_MARK___4 = 1167,
	CAN1_RX_B_MARK = 1168,
	IP11_23_20_MARK___4 = 1169,
	RX0_A_MARK = 1170,
	MSIOF0_SS1_MARK___7 = 1171,
	FSO_CFE_1_N_B_MARK = 1172,
	IP8_27_24_MARK___5 = 1173,
	NFRE_N_MARK___4 = 1174,
	MMC_CMD_MARK___2 = 1175,
	IP9_27_24_MARK___5 = 1176,
	NFDATA6_MARK___4 = 1177,
	MMC_D6_MARK___4 = 1178,
	IP10_27_24_MARK___4 = 1179,
	SSI_WS4_A_MARK = 1180,
	HRX0_MARK___6 = 1181,
	SDA2_A_MARK___4 = 1182,
	CAN1_TX_B_MARK = 1183,
	IP11_27_24_MARK___4 = 1184,
	TX0_A_MARK = 1185,
	MSIOF0_SS2_MARK___7 = 1186,
	FSO_TOE_N_B_MARK = 1187,
	IP8_31_28_MARK___5 = 1188,
	NFWE_N_MARK___4 = 1189,
	MMC_CLK_MARK___2 = 1190,
	IP9_31_28_MARK___5 = 1191,
	NFDATA7_MARK___4 = 1192,
	MMC_D7_MARK___4 = 1193,
	IP10_31_28_MARK___4 = 1194,
	SCL1_MARK___4 = 1195,
	CTS1_N_MARK___6 = 1196,
	IP11_31_28_MARK___4 = 1197,
	SCK1_A_MARK___2 = 1198,
	MSIOF1_SS2_MARK___4 = 1199,
	TPU0TO2_B_MARK___2 = 1200,
	CAN0_TX_B_MARK___4 = 1201,
	AUDIO_CLKOUT1_MARK = 1202,
	IP12_3_0_MARK___4 = 1203,
	RX1_A_MARK___6 = 1204,
	CTS0_N_MARK___7 = 1205,
	TPU0TO0_B_MARK___2 = 1206,
	IP13_3_0_MARK___4 = 1207,
	CAN1_RX_A_MARK = 1208,
	CANFD1_RX_MARK___6 = 1209,
	TPU0TO2_A_MARK___2 = 1210,
	IP12_7_4_MARK___4 = 1211,
	TX1_A_MARK___6 = 1212,
	RTS0_N_MARK___7 = 1213,
	TPU0TO1_B_MARK___2 = 1214,
	IP13_7_4_MARK___4 = 1215,
	CAN1_TX_A_MARK = 1216,
	CANFD1_TX_MARK___6 = 1217,
	TPU0TO3_A_MARK___2 = 1218,
	IP12_11_8_MARK___4 = 1219,
	SCK2_MARK___4 = 1220,
	MSIOF1_SS1_MARK___4 = 1221,
	TPU0TO3_B_MARK___2 = 1222,
	IP12_15_12_MARK___4 = 1223,
	TPU0TO0_A_MARK___2 = 1224,
	AVB0_AVTP_CAPTURE_A_MARK = 1225,
	HCTS0_N_MARK___6 = 1226,
	IP12_19_16_MARK___4 = 1227,
	TPU0TO1_A_MARK___2 = 1228,
	AVB0_AVTP_MATCH_A_MARK = 1229,
	HRTS0_N_MARK___6 = 1230,
	IP12_23_20_MARK___4 = 1231,
	CAN_CLK_MARK___5 = 1232,
	AVB0_AVTP_PPS_A_MARK = 1233,
	SCK0_B_MARK = 1234,
	IRQ5_B_MARK = 1235,
	IP12_27_24_MARK___4 = 1236,
	CAN0_RX_A_MARK___4 = 1237,
	CANFD0_RX_MARK___2 = 1238,
	RX0_B_MARK = 1239,
	IP12_31_28_MARK___4 = 1240,
	CAN0_TX_A_MARK___4 = 1241,
	CANFD0_TX_MARK___2 = 1242,
	TX0_B_MARK = 1243,
	SEL_CAN0_0_MARK = 1244,
	SEL_CAN0_1_MARK = 1245,
	SEL_MSIOF2_0_MARK___4 = 1246,
	SEL_MSIOF2_1_MARK___4 = 1247,
	SEL_CAN1_0_MARK = 1248,
	SEL_CAN1_1_MARK = 1249,
	SEL_I2C3_0_MARK___2 = 1250,
	SEL_I2C3_1_MARK = 1251,
	SEL_I2C2_0_MARK___5 = 1252,
	SEL_I2C2_1_MARK___4 = 1253,
	SEL_SCIF5_0_MARK___4 = 1254,
	SEL_SCIF5_1_MARK___4 = 1255,
	SEL_ETHERAVB_0_MARK___4 = 1256,
	SEL_ETHERAVB_1_MARK___4 = 1257,
	SEL_MSIOF3_0_MARK___4 = 1258,
	SEL_MSIOF3_1_MARK___4 = 1259,
	SEL_SCIF0_0_MARK = 1260,
	SEL_SCIF0_1_MARK = 1261,
	SEL_HSCIF3_0_MARK___4 = 1262,
	SEL_HSCIF3_1_MARK___4 = 1263,
	SEL_SSIF4_0_MARK = 1264,
	SEL_SSIF4_1_MARK = 1265,
	SEL_SCIF4_0_MARK___4 = 1266,
	SEL_SCIF4_1_MARK___4 = 1267,
	SEL_PWM0_0_MARK___2 = 1268,
	SEL_PWM0_2_MARK = 1269,
	SEL_PWM0_1_MARK___2 = 1270,
	SEL_PWM1_0_MARK___5 = 1271,
	SEL_PWM1_2_MARK = 1272,
	SEL_PWM1_1_MARK___5 = 1273,
	SEL_PWM2_0_MARK___5 = 1274,
	SEL_PWM2_2_MARK = 1275,
	SEL_PWM2_1_MARK___5 = 1276,
	SEL_PWM3_0_MARK___5 = 1277,
	SEL_PWM3_2_MARK = 1278,
	SEL_PWM3_1_MARK___5 = 1279,
	SEL_IRQ_0_0_MARK = 1280,
	SEL_IRQ_0_1_MARK = 1281,
	SEL_IRQ_1_0_MARK = 1282,
	SEL_IRQ_1_1_MARK = 1283,
	SEL_IRQ_2_0_MARK = 1284,
	SEL_IRQ_2_1_MARK = 1285,
	SEL_IRQ_3_0_MARK = 1286,
	SEL_IRQ_3_1_MARK = 1287,
	SEL_IRQ_4_0_MARK = 1288,
	SEL_IRQ_4_1_MARK = 1289,
	SEL_IRQ_5_0_MARK = 1290,
	SEL_IRQ_5_1_MARK = 1291,
	SEL_TMU_0_0_MARK = 1292,
	SEL_TMU_0_1_MARK = 1293,
	SEL_TMU_1_0_MARK = 1294,
	SEL_TMU_1_1_MARK = 1295,
	SEL_SCIF3_0_MARK___4 = 1296,
	SEL_SCIF3_1_MARK___4 = 1297,
	SEL_SCIF1_0_MARK___5 = 1298,
	SEL_SCIF1_1_MARK___5 = 1299,
	SEL_SCU_0_MARK = 1300,
	SEL_SCU_1_MARK = 1301,
	SEL_RFSO_0_MARK = 1302,
	SEL_RFSO_1_MARK = 1303,
	PINMUX_MARK_END___7 = 1304,
};

enum {
	PINMUX_RESERVED___8 = 0,
	PINMUX_DATA_BEGIN___8 = 1,
	GP_0_0_DATA___8 = 2,
	GP_0_1_DATA___8 = 3,
	GP_0_2_DATA___8 = 4,
	GP_0_3_DATA___8 = 5,
	GP_0_4_DATA___8 = 6,
	GP_0_5_DATA___8 = 7,
	GP_0_6_DATA___8 = 8,
	GP_0_7_DATA___8 = 9,
	GP_0_8_DATA___8 = 10,
	GP_0_9_DATA___7 = 11,
	GP_0_10_DATA___7 = 12,
	GP_0_11_DATA___7 = 13,
	GP_0_12_DATA___7 = 14,
	GP_0_13_DATA___7 = 15,
	GP_0_14_DATA___7 = 16,
	GP_0_15_DATA___7 = 17,
	GP_0_16_DATA___4 = 18,
	GP_0_17_DATA___4 = 19,
	GP_0_18_DATA___4 = 20,
	GP_1_0_DATA___8 = 21,
	GP_1_1_DATA___8 = 22,
	GP_1_2_DATA___8 = 23,
	GP_1_3_DATA___8 = 24,
	GP_1_4_DATA___8 = 25,
	GP_1_5_DATA___8 = 26,
	GP_1_6_DATA___8 = 27,
	GP_1_7_DATA___8 = 28,
	GP_1_8_DATA___8 = 29,
	GP_1_9_DATA___8 = 30,
	GP_1_10_DATA___8 = 31,
	GP_1_11_DATA___8 = 32,
	GP_1_12_DATA___8 = 33,
	GP_1_13_DATA___8 = 34,
	GP_1_14_DATA___8 = 35,
	GP_1_15_DATA___8 = 36,
	GP_1_16_DATA___8 = 37,
	GP_1_17_DATA___8 = 38,
	GP_1_18_DATA___8 = 39,
	GP_1_19_DATA___8 = 40,
	GP_1_20_DATA___8 = 41,
	GP_1_21_DATA___8 = 42,
	GP_1_22_DATA___8 = 43,
	GP_1_23_DATA___8 = 44,
	GP_1_24_DATA___8 = 45,
	GP_1_25_DATA___7 = 46,
	GP_1_26_DATA___7 = 47,
	GP_1_27_DATA___7 = 48,
	GP_1_28_DATA___6 = 49,
	GP_1_29_DATA___2 = 50,
	GP_2_0_DATA___8 = 51,
	GP_2_1_DATA___8 = 52,
	GP_2_2_DATA___8 = 53,
	GP_2_3_DATA___8 = 54,
	GP_2_4_DATA___8 = 55,
	GP_2_5_DATA___8 = 56,
	GP_2_6_DATA___8 = 57,
	GP_2_7_DATA___8 = 58,
	GP_2_8_DATA___8 = 59,
	GP_2_9_DATA___8 = 60,
	GP_2_10_DATA___8 = 61,
	GP_2_11_DATA___8 = 62,
	GP_2_12_DATA___8 = 63,
	GP_2_13_DATA___8 = 64,
	GP_2_14_DATA___8 = 65,
	GP_2_15_DATA___5 = 66,
	GP_2_17_DATA___4 = 67,
	GP_2_19_DATA___4 = 68,
	GP_3_0_DATA___8 = 69,
	GP_3_1_DATA___8 = 70,
	GP_3_2_DATA___8 = 71,
	GP_3_3_DATA___8 = 72,
	GP_3_4_DATA___8 = 73,
	GP_3_5_DATA___8 = 74,
	GP_3_6_DATA___8 = 75,
	GP_3_7_DATA___8 = 76,
	GP_3_8_DATA___8 = 77,
	GP_3_9_DATA___8 = 78,
	GP_3_10_DATA___7 = 79,
	GP_3_11_DATA___7 = 80,
	GP_3_12_DATA___7 = 81,
	GP_3_13_DATA___7 = 82,
	GP_3_14_DATA___7 = 83,
	GP_3_15_DATA___7 = 84,
	GP_3_16_DATA___4 = 85,
	GP_3_17_DATA___3 = 86,
	GP_3_18_DATA___3 = 87,
	GP_3_19_DATA___2 = 88,
	GP_3_20_DATA___2 = 89,
	GP_3_21_DATA___2 = 90,
	GP_3_22_DATA___2 = 91,
	GP_3_23_DATA___2 = 92,
	GP_3_24_DATA___2 = 93,
	GP_3_25_DATA___2 = 94,
	GP_3_26_DATA___2 = 95,
	GP_3_27_DATA___2 = 96,
	GP_3_28_DATA___2 = 97,
	GP_3_29_DATA___2 = 98,
	GP_3_30_DATA = 99,
	GP_3_31_DATA = 100,
	GP_4_0_DATA___7 = 101,
	GP_4_1_DATA___7 = 102,
	GP_4_2_DATA___7 = 103,
	GP_4_3_DATA___7 = 104,
	GP_4_4_DATA___7 = 105,
	GP_4_5_DATA___7 = 106,
	GP_4_6_DATA___7 = 107,
	GP_4_7_DATA___7 = 108,
	GP_4_8_DATA___7 = 109,
	GP_4_9_DATA___7 = 110,
	GP_4_10_DATA___7 = 111,
	GP_4_11_DATA___7 = 112,
	GP_4_12_DATA___7 = 113,
	GP_4_13_DATA___7 = 114,
	GP_4_14_DATA___7 = 115,
	GP_4_15_DATA___7 = 116,
	GP_4_21_DATA___4 = 117,
	GP_4_23_DATA___4 = 118,
	GP_4_24_DATA___4 = 119,
	GP_5_0_DATA___7 = 120,
	GP_5_1_DATA___7 = 121,
	GP_5_2_DATA___7 = 122,
	GP_5_3_DATA___7 = 123,
	GP_5_4_DATA___7 = 124,
	GP_5_5_DATA___7 = 125,
	GP_5_6_DATA___7 = 126,
	GP_5_7_DATA___7 = 127,
	GP_5_8_DATA___7 = 128,
	GP_5_9_DATA___7 = 129,
	GP_5_10_DATA___7 = 130,
	GP_5_11_DATA___7 = 131,
	GP_5_12_DATA___7 = 132,
	GP_5_13_DATA___7 = 133,
	GP_5_14_DATA___7 = 134,
	GP_5_15_DATA___6 = 135,
	GP_5_16_DATA___6 = 136,
	GP_5_17_DATA___6 = 137,
	GP_5_18_DATA___6 = 138,
	GP_5_19_DATA___6 = 139,
	GP_5_20_DATA___6 = 140,
	GP_6_0_DATA___6 = 141,
	GP_6_1_DATA___6 = 142,
	GP_6_2_DATA___6 = 143,
	GP_6_3_DATA___6 = 144,
	GP_6_4_DATA___6 = 145,
	GP_6_5_DATA___6 = 146,
	GP_6_6_DATA___6 = 147,
	GP_6_7_DATA___6 = 148,
	GP_6_8_DATA___6 = 149,
	GP_6_9_DATA___6 = 150,
	GP_6_10_DATA___6 = 151,
	GP_6_11_DATA___6 = 152,
	GP_6_12_DATA___6 = 153,
	GP_6_13_DATA___6 = 154,
	GP_6_14_DATA___5 = 155,
	GP_6_15_DATA___5 = 156,
	GP_6_16_DATA___5 = 157,
	GP_6_17_DATA___5 = 158,
	GP_6_18_DATA___5 = 159,
	GP_6_19_DATA___5 = 160,
	GP_6_20_DATA___5 = 161,
	GP_7_0_DATA___5 = 162,
	GP_7_1_DATA___5 = 163,
	GP_7_2_DATA___5 = 164,
	GP_7_3_DATA___5 = 165,
	GP_7_4_DATA___2 = 166,
	GP_7_5_DATA___2 = 167,
	GP_7_6_DATA___2 = 168,
	GP_7_7_DATA___2 = 169,
	GP_7_8_DATA___2 = 170,
	GP_7_9_DATA___2 = 171,
	GP_7_10_DATA___2 = 172,
	GP_7_11_DATA___2 = 173,
	GP_7_12_DATA___2 = 174,
	GP_7_13_DATA___2 = 175,
	GP_7_14_DATA___2 = 176,
	GP_7_15_DATA___2 = 177,
	GP_7_16_DATA___2 = 178,
	GP_7_17_DATA___2 = 179,
	GP_7_18_DATA___2 = 180,
	GP_7_19_DATA___2 = 181,
	GP_7_20_DATA___2 = 182,
	PINMUX_DATA_END___8 = 183,
	PINMUX_FUNCTION_BEGIN___8 = 184,
	GP_0_0_FN___8 = 185,
	GP_0_1_FN___8 = 186,
	GP_0_2_FN___8 = 187,
	GP_0_3_FN___8 = 188,
	GP_0_4_FN___8 = 189,
	GP_0_5_FN___8 = 190,
	GP_0_6_FN___8 = 191,
	GP_0_7_FN___8 = 192,
	GP_0_8_FN___8 = 193,
	GP_0_9_FN___7 = 194,
	GP_0_10_FN___7 = 195,
	GP_0_11_FN___7 = 196,
	GP_0_12_FN___7 = 197,
	GP_0_13_FN___7 = 198,
	GP_0_14_FN___7 = 199,
	GP_0_15_FN___7 = 200,
	GP_0_16_FN___4 = 201,
	GP_0_17_FN___4 = 202,
	GP_0_18_FN___4 = 203,
	GP_1_0_FN___8 = 204,
	GP_1_1_FN___8 = 205,
	GP_1_2_FN___8 = 206,
	GP_1_3_FN___8 = 207,
	GP_1_4_FN___8 = 208,
	GP_1_5_FN___8 = 209,
	GP_1_6_FN___8 = 210,
	GP_1_7_FN___8 = 211,
	GP_1_8_FN___8 = 212,
	GP_1_9_FN___8 = 213,
	GP_1_10_FN___8 = 214,
	GP_1_11_FN___8 = 215,
	GP_1_12_FN___8 = 216,
	GP_1_13_FN___8 = 217,
	GP_1_14_FN___8 = 218,
	GP_1_15_FN___8 = 219,
	GP_1_16_FN___8 = 220,
	GP_1_17_FN___8 = 221,
	GP_1_18_FN___8 = 222,
	GP_1_19_FN___8 = 223,
	GP_1_20_FN___8 = 224,
	GP_1_21_FN___8 = 225,
	GP_1_22_FN___8 = 226,
	GP_1_23_FN___8 = 227,
	GP_1_24_FN___8 = 228,
	GP_1_25_FN___7 = 229,
	GP_1_26_FN___7 = 230,
	GP_1_27_FN___7 = 231,
	GP_1_28_FN___6 = 232,
	GP_1_29_FN___2 = 233,
	GP_2_0_FN___8 = 234,
	GP_2_1_FN___8 = 235,
	GP_2_2_FN___8 = 236,
	GP_2_3_FN___8 = 237,
	GP_2_4_FN___8 = 238,
	GP_2_5_FN___8 = 239,
	GP_2_6_FN___8 = 240,
	GP_2_7_FN___8 = 241,
	GP_2_8_FN___8 = 242,
	GP_2_9_FN___8 = 243,
	GP_2_10_FN___8 = 244,
	GP_2_11_FN___8 = 245,
	GP_2_12_FN___8 = 246,
	GP_2_13_FN___8 = 247,
	GP_2_14_FN___8 = 248,
	GP_2_15_FN___5 = 249,
	GP_2_17_FN___4 = 250,
	GP_2_19_FN___4 = 251,
	GP_3_0_FN___8 = 252,
	GP_3_1_FN___8 = 253,
	GP_3_2_FN___8 = 254,
	GP_3_3_FN___8 = 255,
	GP_3_4_FN___8 = 256,
	GP_3_5_FN___8 = 257,
	GP_3_6_FN___8 = 258,
	GP_3_7_FN___8 = 259,
	GP_3_8_FN___8 = 260,
	GP_3_9_FN___8 = 261,
	GP_3_10_FN___7 = 262,
	GP_3_11_FN___7 = 263,
	GP_3_12_FN___7 = 264,
	GP_3_13_FN___7 = 265,
	GP_3_14_FN___7 = 266,
	GP_3_15_FN___7 = 267,
	GP_3_16_FN___4 = 268,
	GP_3_17_FN___3 = 269,
	GP_3_18_FN___3 = 270,
	GP_3_19_FN___2 = 271,
	GP_3_20_FN___2 = 272,
	GP_3_21_FN___2 = 273,
	GP_3_22_FN___2 = 274,
	GP_3_23_FN___2 = 275,
	GP_3_24_FN___2 = 276,
	GP_3_25_FN___2 = 277,
	GP_3_26_FN___2 = 278,
	GP_3_27_FN___2 = 279,
	GP_3_28_FN___2 = 280,
	GP_3_29_FN___2 = 281,
	GP_3_30_FN = 282,
	GP_3_31_FN = 283,
	GP_4_0_FN___7 = 284,
	GP_4_1_FN___7 = 285,
	GP_4_2_FN___7 = 286,
	GP_4_3_FN___7 = 287,
	GP_4_4_FN___7 = 288,
	GP_4_5_FN___7 = 289,
	GP_4_6_FN___7 = 290,
	GP_4_7_FN___7 = 291,
	GP_4_8_FN___7 = 292,
	GP_4_9_FN___7 = 293,
	GP_4_10_FN___7 = 294,
	GP_4_11_FN___7 = 295,
	GP_4_12_FN___7 = 296,
	GP_4_13_FN___7 = 297,
	GP_4_14_FN___7 = 298,
	GP_4_15_FN___7 = 299,
	GP_4_21_FN___4 = 300,
	GP_4_23_FN___4 = 301,
	GP_4_24_FN___4 = 302,
	GP_5_0_FN___7 = 303,
	GP_5_1_FN___7 = 304,
	GP_5_2_FN___7 = 305,
	GP_5_3_FN___7 = 306,
	GP_5_4_FN___7 = 307,
	GP_5_5_FN___7 = 308,
	GP_5_6_FN___7 = 309,
	GP_5_7_FN___7 = 310,
	GP_5_8_FN___7 = 311,
	GP_5_9_FN___7 = 312,
	GP_5_10_FN___7 = 313,
	GP_5_11_FN___7 = 314,
	GP_5_12_FN___7 = 315,
	GP_5_13_FN___7 = 316,
	GP_5_14_FN___7 = 317,
	GP_5_15_FN___6 = 318,
	GP_5_16_FN___6 = 319,
	GP_5_17_FN___6 = 320,
	GP_5_18_FN___6 = 321,
	GP_5_19_FN___6 = 322,
	GP_5_20_FN___6 = 323,
	GP_6_0_FN___6 = 324,
	GP_6_1_FN___6 = 325,
	GP_6_2_FN___6 = 326,
	GP_6_3_FN___6 = 327,
	GP_6_4_FN___6 = 328,
	GP_6_5_FN___6 = 329,
	GP_6_6_FN___6 = 330,
	GP_6_7_FN___6 = 331,
	GP_6_8_FN___6 = 332,
	GP_6_9_FN___6 = 333,
	GP_6_10_FN___6 = 334,
	GP_6_11_FN___6 = 335,
	GP_6_12_FN___6 = 336,
	GP_6_13_FN___6 = 337,
	GP_6_14_FN___5 = 338,
	GP_6_15_FN___5 = 339,
	GP_6_16_FN___5 = 340,
	GP_6_17_FN___5 = 341,
	GP_6_18_FN___5 = 342,
	GP_6_19_FN___5 = 343,
	GP_6_20_FN___5 = 344,
	GP_7_0_FN___5 = 345,
	GP_7_1_FN___5 = 346,
	GP_7_2_FN___5 = 347,
	GP_7_3_FN___5 = 348,
	GP_7_4_FN___2 = 349,
	GP_7_5_FN___2 = 350,
	GP_7_6_FN___2 = 351,
	GP_7_7_FN___2 = 352,
	GP_7_8_FN___2 = 353,
	GP_7_9_FN___2 = 354,
	GP_7_10_FN___2 = 355,
	GP_7_11_FN___2 = 356,
	GP_7_12_FN___2 = 357,
	GP_7_13_FN___2 = 358,
	GP_7_14_FN___2 = 359,
	GP_7_15_FN___2 = 360,
	GP_7_16_FN___2 = 361,
	GP_7_17_FN___2 = 362,
	GP_7_18_FN___2 = 363,
	GP_7_19_FN___2 = 364,
	GP_7_20_FN___2 = 365,
	FN_IP0SR0_3_0___3 = 366,
	FN_ERROROUTC_N_B___2 = 367,
	FN_TCLK2_B___7 = 368,
	FN_IP1SR0_3_0___3 = 369,
	FN_MSIOF5_SS1___2 = 370,
	FN_IP2SR0_3_0___3 = 371,
	FN_MSIOF2_TXD___5 = 372,
	FN_HCTS1_N_A___5 = 373,
	FN_CTS1_N_A___2 = 374,
	FN_IP0SR0_7_4___3 = 375,
	FN_MSIOF3_SS1___4 = 376,
	FN_IP1SR0_7_4___3 = 377,
	FN_MSIOF5_SYNC___2 = 378,
	FN_IP2SR0_7_4___3 = 379,
	FN_MSIOF2_SCK___5 = 380,
	FN_HRTS1_N_A___5 = 381,
	FN_RTS1_N_A___2 = 382,
	FN_IP0SR0_11_8___3 = 383,
	FN_MSIOF3_SS2___4 = 384,
	FN_IP1SR0_11_8___3 = 385,
	FN_MSIOF5_TXD___2 = 386,
	FN_IP2SR0_11_8___3 = 387,
	FN_MSIOF2_RXD___5 = 388,
	FN_HSCK1_A___5 = 389,
	FN_SCK1_A___3 = 390,
	FN_IP0SR0_15_12___3 = 391,
	FN_IRQ3_A___3 = 392,
	FN_MSIOF3_SCK___4 = 393,
	FN_IP1SR0_15_12___3 = 394,
	FN_MSIOF5_SCK___2 = 395,
	FN_IP0SR0_19_16___3 = 396,
	FN_IRQ2_A___3 = 397,
	FN_MSIOF3_TXD___4 = 398,
	FN_IP1SR0_19_16___3 = 399,
	FN_MSIOF5_RXD___2 = 400,
	FN_IP0SR0_23_20___3 = 401,
	FN_IRQ1_A___3 = 402,
	FN_MSIOF3_RXD___4 = 403,
	FN_IP1SR0_23_20___3 = 404,
	FN_MSIOF2_SS2___5 = 405,
	FN_TCLK1_A___7 = 406,
	FN_IRQ2_B___3 = 407,
	FN_IP0SR0_27_24___3 = 408,
	FN_IRQ0_A___3 = 409,
	FN_MSIOF3_SYNC___4 = 410,
	FN_IP1SR0_27_24___3 = 411,
	FN_MSIOF2_SS1___5 = 412,
	FN_HTX1_A___5 = 413,
	FN_TX1_A___7 = 414,
	FN_IP0SR0_31_28___3 = 415,
	FN_MSIOF5_SS2___2 = 416,
	FN_IP1SR0_31_28___3 = 417,
	FN_MSIOF2_SYNC___4 = 418,
	FN_HRX1_A___5 = 419,
	FN_RX1_A___7 = 420,
	FN_IP0SR1_3_0___3 = 421,
	FN_MSIOF1_SS2___5 = 422,
	FN_HTX3_B___6 = 423,
	FN_TX3_B___6 = 424,
	FN_IP1SR1_3_0___2 = 425,
	FN_MSIOF0_SYNC___8 = 426,
	FN_HCTS1_N_B___5 = 427,
	FN_CTS1_N_B___2 = 428,
	FN_IP2SR1_3_0___2 = 429,
	FN_HRX0___7 = 430,
	FN_RX0___7 = 431,
	FN_IP3SR1_3_0___2 = 432,
	FN_HRX3_A___6 = 433,
	FN_SCK3_A___3 = 434,
	FN_MSIOF4_SS2___2 = 435,
	FN_IP0SR1_7_4___3 = 436,
	FN_MSIOF1_SS1___5 = 437,
	FN_HCTS3_N_B___2 = 438,
	FN_RX3_B___6 = 439,
	FN_IP1SR1_7_4___2 = 440,
	FN_MSIOF0_TXD___8 = 441,
	FN_HRTS1_N_B___5 = 442,
	FN_RTS1_N_B___2 = 443,
	FN_IP2SR1_7_4___2 = 444,
	FN_SCIF_CLK___4 = 445,
	FN_IRQ4_A___3 = 446,
	FN_IP3SR1_7_4___2 = 447,
	FN_HSCK3_A___3 = 448,
	FN_CTS3_N_A___2 = 449,
	FN_MSIOF4_SCK___2 = 450,
	FN_TPU0TO0_B___3 = 451,
	FN_IP0SR1_11_8___3 = 452,
	FN_MSIOF1_SYNC___5 = 453,
	FN_HRTS3_N_B___2 = 454,
	FN_RTS3_N_B___2 = 455,
	FN_IP1SR1_11_8___2 = 456,
	FN_MSIOF0_SCK___8 = 457,
	FN_HSCK1_B___5 = 458,
	FN_SCK1_B___3 = 459,
	FN_IP2SR1_11_8___2 = 460,
	FN_SSI_SCK___2 = 461,
	FN_TCLK3_B___2 = 462,
	FN_IP3SR1_11_8___2 = 463,
	FN_HRTS3_N_A___2 = 464,
	FN_RTS3_N_A___2 = 465,
	FN_MSIOF4_TXD___2 = 466,
	FN_TPU0TO1_B___3 = 467,
	FN_IP0SR1_15_12___3 = 468,
	FN_MSIOF1_SCK___5 = 469,
	FN_HSCK3_B___3 = 470,
	FN_CTS3_N_B___2 = 471,
	FN_IP1SR1_15_12___2 = 472,
	FN_MSIOF0_RXD___8 = 473,
	FN_IP2SR1_15_12___2 = 474,
	FN_SSI_WS___2 = 475,
	FN_TCLK4_B___2 = 476,
	FN_IP3SR1_15_12___2 = 477,
	FN_HCTS3_N_A___2 = 478,
	FN_RX3_A___6 = 479,
	FN_MSIOF4_RXD___2 = 480,
	FN_IP0SR1_19_16___3 = 481,
	FN_MSIOF1_TXD___5 = 482,
	FN_HRX3_B___6 = 483,
	FN_SCK3_B___3 = 484,
	FN_IP1SR1_19_16___2 = 485,
	FN_HTX0___7 = 486,
	FN_TX0___7 = 487,
	FN_IP2SR1_19_16___2 = 488,
	FN_SSI_SD___2 = 489,
	FN_IRQ0_B___3 = 490,
	FN_IP3SR1_19_16___2 = 491,
	FN_HTX3_A___6 = 492,
	FN_TX3_A___6 = 493,
	FN_MSIOF4_SYNC___2 = 494,
	FN_IP0SR1_23_20___3 = 495,
	FN_MSIOF1_RXD___5 = 496,
	FN_IP1SR1_23_20___2 = 497,
	FN_HCTS0_N___7 = 498,
	FN_CTS0_N___8 = 499,
	FN_IP2SR1_23_20___2 = 500,
	FN_AUDIO_CLKOUT___3 = 501,
	FN_IRQ1_B___3 = 502,
	FN_IP3SR1_23_20 = 503,
	FN_ERROROUTC_N_A___2 = 504,
	FN_IP0SR1_27_24___3 = 505,
	FN_MSIOF0_SS2___8 = 506,
	FN_HTX1_B___5 = 507,
	FN_TX1_B___7 = 508,
	FN_IP1SR1_27_24___2 = 509,
	FN_HRTS0_N___7 = 510,
	FN_RTS0_N___8 = 511,
	FN_PWM0_B___3 = 512,
	FN_IP2SR1_27_24___2 = 513,
	FN_AUDIO_CLKIN___2 = 514,
	FN_PWM3_C___2 = 515,
	FN_IP0SR1_31_28___3 = 516,
	FN_MSIOF0_SS1___8 = 517,
	FN_HRX1_B___5 = 518,
	FN_RX1_B___7 = 519,
	FN_IP1SR1_31_28___2 = 520,
	FN_HSCK0___7 = 521,
	FN_SCK0___7 = 522,
	FN_PWM0_A___3 = 523,
	FN_IP2SR1_31_28___2 = 524,
	FN_TCLK2_A___7 = 525,
	FN_MSIOF4_SS1___2 = 526,
	FN_IRQ3_B___3 = 527,
	FN_IP0SR2_3_0___2 = 528,
	FN_FXR_TXDA___3 = 529,
	FN_TPU0TO2_B___3 = 530,
	FN_IP1SR2_3_0___2 = 531,
	FN_TPU0TO0_A___3 = 532,
	FN_TCLK1_B___7 = 533,
	FN_IP0SR2_7_4___2 = 534,
	FN_FXR_TXENA_N_A___2 = 535,
	FN_TPU0TO3_B___3 = 536,
	FN_IP1SR2_7_4___2 = 537,
	FN_CAN_CLK___6 = 538,
	FN_FXR_TXENA_N_B___2 = 539,
	FN_IP2SR2_7_4___2 = 540,
	FN_CANFD1_TX___7 = 541,
	FN_PWM1_C___2 = 542,
	FN_IP0SR2_11_8___2 = 543,
	FN_RXDA_EXTFXR___3 = 544,
	FN_IRQ5___7 = 545,
	FN_IP1SR2_11_8___2 = 546,
	FN_CANFD0_TX___3 = 547,
	FN_FXR_TXENB_N_B___2 = 548,
	FN_IP0SR2_15_12___2 = 549,
	FN_CLK_EXTFXR___3 = 550,
	FN_IRQ4_B___3 = 551,
	FN_IP1SR2_15_12___2 = 552,
	FN_CANFD0_RX___3 = 553,
	FN_STPWT_EXTFXR___2 = 554,
	FN_IP2SR2_15_12___2 = 555,
	FN_CANFD1_RX___7 = 556,
	FN_PWM2_C___2 = 557,
	FN_IP0SR2_19_16___2 = 558,
	FN_RXDB_EXTFXR___3 = 559,
	FN_IP1SR2_19_16___2 = 560,
	FN_CANFD2_TX___2 = 561,
	FN_TPU0TO2_A___3 = 562,
	FN_TCLK3_C___2 = 563,
	FN_IP0SR2_23_20___2 = 564,
	FN_FXR_TXENB_N_A___2 = 565,
	FN_IP1SR2_23_20___2 = 566,
	FN_CANFD2_RX___2 = 567,
	FN_TPU0TO3_A___3 = 568,
	FN_PWM1_B___7 = 569,
	FN_TCLK4_C___2 = 570,
	FN_IP0SR2_27_24___2 = 571,
	FN_FXR_TXDB___3 = 572,
	FN_IP1SR2_27_24___2 = 573,
	FN_CANFD3_TX___2 = 574,
	FN_PWM2_B___6 = 575,
	FN_IP0SR2_31_28___2 = 576,
	FN_TPU0TO1_A___3 = 577,
	FN_TCLK2_C___2 = 578,
	FN_IP1SR2_31_28___2 = 579,
	FN_CANFD3_RX___2 = 580,
	FN_PWM3_B___7 = 581,
	FN_IP0SR3_3_0___2 = 582,
	FN_MMC_SD_D1___3 = 583,
	FN_IP1SR3_3_0___2 = 584,
	FN_MMC_D7___5 = 585,
	FN_IP2SR3_3_0___2 = 586,
	FN_QSPI0_IO3___5 = 587,
	FN_IP3SR3_3_0___2 = 588,
	FN_QSPI1_IO2___5 = 589,
	FN_IP0SR3_7_4___2 = 590,
	FN_MMC_SD_D0___3 = 591,
	FN_IP1SR3_7_4___2 = 592,
	FN_MMC_D6___5 = 593,
	FN_IP2SR3_7_4___2 = 594,
	FN_QSPI0_IO2___5 = 595,
	FN_IP3SR3_7_4___2 = 596,
	FN_QSPI1_SSL___5 = 597,
	FN_IP0SR3_11_8___2 = 598,
	FN_MMC_SD_D2___3 = 599,
	FN_IP1SR3_11_8___2 = 600,
	FN_MMC_SD_CMD___3 = 601,
	FN_IP2SR3_11_8___2 = 602,
	FN_QSPI0_MISO_IO1___5 = 603,
	FN_IP3SR3_11_8___2 = 604,
	FN_QSPI1_IO3___5 = 605,
	FN_IP0SR3_15_12___2 = 606,
	FN_MMC_SD_CLK___3 = 607,
	FN_IP1SR3_15_12___2 = 608,
	FN_SD_CD___3 = 609,
	FN_IP2SR3_15_12___2 = 610,
	FN_QSPI0_MOSI_IO0___5 = 611,
	FN_IP3SR3_15_12___2 = 612,
	FN_RPC_RESET_N___5 = 613,
	FN_IP0SR3_19_16___2 = 614,
	FN_MMC_DS___4 = 615,
	FN_IP1SR3_19_16___2 = 616,
	FN_SD_WP___3 = 617,
	FN_IP2SR3_19_16___2 = 618,
	FN_QSPI0_SPCLK___5 = 619,
	FN_IP3SR3_19_16___2 = 620,
	FN_RPC_WP_N___4 = 621,
	FN_IP0SR3_23_20___2 = 622,
	FN_MMC_SD_D3___3 = 623,
	FN_IP1SR3_23_20___2 = 624,
	FN_PWM1_A___7 = 625,
	FN_IP2SR3_23_20___2 = 626,
	FN_QSPI1_MOSI_IO0___5 = 627,
	FN_IP3SR3_23_20___2 = 628,
	FN_RPC_INT_N___5 = 629,
	FN_IP0SR3_27_24___2 = 630,
	FN_MMC_D5___5 = 631,
	FN_IP1SR3_27_24___2 = 632,
	FN_PWM2_A___6 = 633,
	FN_IP2SR3_27_24___2 = 634,
	FN_QSPI1_SPCLK___5 = 635,
	FN_IP3SR3_27_24 = 636,
	FN_TCLK3_A___2 = 637,
	FN_IP0SR3_31_28___2 = 638,
	FN_MMC_D4___5 = 639,
	FN_IP1SR3_31_28___2 = 640,
	FN_QSPI0_SSL___5 = 641,
	FN_IP2SR3_31_28___2 = 642,
	FN_QSPI1_MISO_IO1___5 = 643,
	FN_IP3SR3_31_28 = 644,
	FN_TCLK4_A___2 = 645,
	FN_IP0SR4_3_0___2 = 646,
	FN_SCL0___4 = 647,
	FN_IP1SR4_3_0___2 = 648,
	FN_HRX2___4 = 649,
	FN_SCK4___4 = 650,
	FN_IP3SR4_3_0___2 = 651,
	FN_AVS1___5 = 652,
	FN_IP0SR4_7_4___2 = 653,
	FN_SDA0___4 = 654,
	FN_IP1SR4_7_4___2 = 655,
	FN_HTX2___4 = 656,
	FN_CTS4_N___4 = 657,
	FN_IP0SR4_11_8___2 = 658,
	FN_SCL1___4 = 659,
	FN_IP1SR4_11_8___2 = 660,
	FN_HRTS2_N___4 = 661,
	FN_RTS4_N___4 = 662,
	FN_IP0SR4_15_12___2 = 663,
	FN_SDA1___4 = 664,
	FN_IP1SR4_15_12___2 = 665,
	FN_SCIF_CLK2___2 = 666,
	FN_IP0SR4_19_16___2 = 667,
	FN_SCL2___3 = 668,
	FN_IP1SR4_19_16___2 = 669,
	FN_HCTS2_N___4 = 670,
	FN_TX4___4 = 671,
	FN_IP0SR4_23_20___2 = 672,
	FN_SDA2___3 = 673,
	FN_IP1SR4_23_20___2 = 674,
	FN_HSCK2___4 = 675,
	FN_RX4___4 = 676,
	FN_IP2SR4_23_20___2 = 677,
	FN_PCIE0_CLKREQ_N___3 = 678,
	FN_IP0SR4_27_24___2 = 679,
	FN_SCL3___3 = 680,
	FN_IP1SR4_27_24___2 = 681,
	FN_PWM3_A___7 = 682,
	FN_IP0SR4_31_28___2 = 683,
	FN_SDA3___3 = 684,
	FN_IP1SR4_31_28___2 = 685,
	FN_PWM4___2 = 686,
	FN_IP2SR4_31_28___2 = 687,
	FN_AVS0___2 = 688,
	FN_IP0SR5_3_0___2 = 689,
	FN_AVB2_AVTP_PPS___2 = 690,
	FN_Ether_GPTP_PPS0 = 691,
	FN_IP1SR5_3_0___2 = 692,
	FN_AVB2_TD3___2 = 693,
	FN_IP2SR5_3_0___2 = 694,
	FN_AVB2_TXC___2 = 695,
	FN_IP0SR5_7_4___2 = 696,
	FN_AVB2_AVTP_CAPTURE___2 = 697,
	FN_Ether_GPTP_CAPTURE = 698,
	FN_IP1SR5_7_4___2 = 699,
	FN_AVB2_RD3___2 = 700,
	FN_IP2SR5_7_4___2 = 701,
	FN_AVB2_RD0___2 = 702,
	FN_IP0SR5_11_8___2 = 703,
	FN_AVB2_AVTP_MATCH___2 = 704,
	FN_Ether_GPTP_MATCH = 705,
	FN_IP1SR5_11_8___2 = 706,
	FN_AVB2_MDIO___2 = 707,
	FN_IP2SR5_11_8___2 = 708,
	FN_AVB2_RXC___2 = 709,
	FN_IP0SR5_15_12___2 = 710,
	FN_AVB2_LINK___2 = 711,
	FN_IP1SR5_15_12___2 = 712,
	FN_AVB2_TD2___2 = 713,
	FN_IP2SR5_15_12___2 = 714,
	FN_AVB2_TX_CTL___2 = 715,
	FN_IP0SR5_19_16___2 = 716,
	FN_AVB2_PHY_INT___2 = 717,
	FN_IP1SR5_19_16___2 = 718,
	FN_AVB2_TD1___2 = 719,
	FN_IP2SR5_19_16___2 = 720,
	FN_AVB2_RX_CTL___2 = 721,
	FN_IP0SR5_23_20___2 = 722,
	FN_AVB2_MAGIC___2 = 723,
	FN_Ether_GPTP_PPS1 = 724,
	FN_IP1SR5_23_20___2 = 725,
	FN_AVB2_RD2___2 = 726,
	FN_IP0SR5_27_24___2 = 727,
	FN_AVB2_MDC___2 = 728,
	FN_IP1SR5_27_24___2 = 729,
	FN_AVB2_RD1___2 = 730,
	FN_IP0SR5_31_28___2 = 731,
	FN_AVB2_TXCREFCLK___2 = 732,
	FN_IP1SR5_31_28___2 = 733,
	FN_AVB2_TD0___2 = 734,
	FN_IP0SR6_3_0___2 = 735,
	FN_AVB1_MDIO___2 = 736,
	FN_IP1SR6_3_0___2 = 737,
	FN_AVB1_RXC___2 = 738,
	FN_AVB1_MII_RXC___2 = 739,
	FN_IP2SR6_3_0___2 = 740,
	FN_AVB1_TD2___2 = 741,
	FN_AVB1_MII_TD2___2 = 742,
	FN_IP0SR6_7_4___2 = 743,
	FN_AVB1_MAGIC___2 = 744,
	FN_IP1SR6_7_4___2 = 745,
	FN_AVB1_RX_CTL___2 = 746,
	FN_AVB1_MII_RX_DV___2 = 747,
	FN_IP2SR6_7_4___2 = 748,
	FN_AVB1_RD2___2 = 749,
	FN_AVB1_MII_RD2___2 = 750,
	FN_IP0SR6_11_8___2 = 751,
	FN_AVB1_MDC___2 = 752,
	FN_IP1SR6_11_8___2 = 753,
	FN_AVB1_AVTP_PPS___2 = 754,
	FN_AVB1_MII_COL___2 = 755,
	FN_IP2SR6_11_8___2 = 756,
	FN_AVB1_TD3___2 = 757,
	FN_AVB1_MII_TD3___2 = 758,
	FN_IP0SR6_15_12___2 = 759,
	FN_AVB1_PHY_INT___2 = 760,
	FN_IP1SR6_15_12___2 = 761,
	FN_AVB1_AVTP_CAPTURE___2 = 762,
	FN_AVB1_MII_CRS___2 = 763,
	FN_IP2SR6_15_12___2 = 764,
	FN_AVB1_RD3___2 = 765,
	FN_AVB1_MII_RD3___2 = 766,
	FN_IP0SR6_19_16___2 = 767,
	FN_AVB1_LINK___2 = 768,
	FN_AVB1_MII_TX_ER___2 = 769,
	FN_IP1SR6_19_16___2 = 770,
	FN_AVB1_TD1___2 = 771,
	FN_AVB1_MII_TD1___2 = 772,
	FN_IP2SR6_19_16___2 = 773,
	FN_AVB1_TXCREFCLK___2 = 774,
	FN_IP0SR6_23_20___2 = 775,
	FN_AVB1_AVTP_MATCH___2 = 776,
	FN_AVB1_MII_RX_ER___2 = 777,
	FN_IP1SR6_23_20___2 = 778,
	FN_AVB1_TD0___2 = 779,
	FN_AVB1_MII_TD0___2 = 780,
	FN_IP0SR6_27_24___2 = 781,
	FN_AVB1_TXC___2 = 782,
	FN_AVB1_MII_TXC___2 = 783,
	FN_IP1SR6_27_24___2 = 784,
	FN_AVB1_RD1___2 = 785,
	FN_AVB1_MII_RD1___2 = 786,
	FN_IP0SR6_31_28___2 = 787,
	FN_AVB1_TX_CTL___2 = 788,
	FN_AVB1_MII_TX_EN___2 = 789,
	FN_IP1SR6_31_28___2 = 790,
	FN_AVB1_RD0___2 = 791,
	FN_AVB1_MII_RD0___2 = 792,
	FN_IP0SR7_3_0___2 = 793,
	FN_AVB0_AVTP_PPS___2 = 794,
	FN_AVB0_MII_COL___2 = 795,
	FN_IP1SR7_3_0___2 = 796,
	FN_AVB0_RD3___3 = 797,
	FN_AVB0_MII_RD3___2 = 798,
	FN_IP2SR7_3_0___2 = 799,
	FN_AVB0_TX_CTL___3 = 800,
	FN_AVB0_MII_TX_EN___2 = 801,
	FN_IP0SR7_7_4___2 = 802,
	FN_AVB0_AVTP_CAPTURE___2 = 803,
	FN_AVB0_MII_CRS___2 = 804,
	FN_IP1SR7_7_4___2 = 805,
	FN_AVB0_TXCREFCLK___3 = 806,
	FN_IP2SR7_7_4___2 = 807,
	FN_AVB0_RD1___3 = 808,
	FN_AVB0_MII_RD1___2 = 809,
	FN_IP0SR7_11_8___2 = 810,
	FN_AVB0_AVTP_MATCH___2 = 811,
	FN_AVB0_MII_RX_ER___2 = 812,
	FN_CC5_OSCOUT___2 = 813,
	FN_IP1SR7_11_8___2 = 814,
	FN_AVB0_MAGIC___3 = 815,
	FN_IP2SR7_11_8___2 = 816,
	FN_AVB0_RD0___3 = 817,
	FN_AVB0_MII_RD0___2 = 818,
	FN_IP0SR7_15_12___2 = 819,
	FN_AVB0_TD3___3 = 820,
	FN_AVB0_MII_TD3___2 = 821,
	FN_IP1SR7_15_12___2 = 822,
	FN_AVB0_TD0___3 = 823,
	FN_AVB0_MII_TD0___2 = 824,
	FN_IP2SR7_15_12___2 = 825,
	FN_AVB0_RXC___3 = 826,
	FN_AVB0_MII_RXC___2 = 827,
	FN_IP0SR7_19_16___2 = 828,
	FN_AVB0_LINK___3 = 829,
	FN_AVB0_MII_TX_ER___2 = 830,
	FN_IP1SR7_19_16___2 = 831,
	FN_AVB0_RD2___3 = 832,
	FN_AVB0_MII_RD2___2 = 833,
	FN_IP2SR7_19_16___2 = 834,
	FN_AVB0_RX_CTL___3 = 835,
	FN_AVB0_MII_RX_DV___2 = 836,
	FN_IP0SR7_23_20___2 = 837,
	FN_AVB0_PHY_INT___3 = 838,
	FN_IP1SR7_23_20___2 = 839,
	FN_AVB0_MDC___3 = 840,
	FN_IP0SR7_27_24___2 = 841,
	FN_AVB0_TD2___3 = 842,
	FN_AVB0_MII_TD2___2 = 843,
	FN_IP1SR7_27_24___2 = 844,
	FN_AVB0_MDIO___3 = 845,
	FN_IP0SR7_31_28___2 = 846,
	FN_AVB0_TD1___3 = 847,
	FN_AVB0_MII_TD1___2 = 848,
	FN_IP1SR7_31_28___2 = 849,
	FN_AVB0_TXC___3 = 850,
	FN_AVB0_MII_TXC___2 = 851,
	FN_SEL_SDA3_0___2 = 852,
	FN_SEL_SDA3_1___2 = 853,
	FN_SEL_SCL3_0___2 = 854,
	FN_SEL_SCL3_1___2 = 855,
	FN_SEL_SDA2_0___2 = 856,
	FN_SEL_SDA2_1___2 = 857,
	FN_SEL_SCL2_0___2 = 858,
	FN_SEL_SCL2_1___2 = 859,
	FN_SEL_SDA1_0___2 = 860,
	FN_SEL_SDA1_1___2 = 861,
	FN_SEL_SCL1_0___2 = 862,
	FN_SEL_SCL1_1___2 = 863,
	FN_SEL_SDA0_0___2 = 864,
	FN_SEL_SDA0_1___2 = 865,
	FN_SEL_SCL0_0___2 = 866,
	FN_SEL_SCL0_1___2 = 867,
	PINMUX_FUNCTION_END___8 = 868,
	PINMUX_MARK_BEGIN___8 = 869,
	IP0SR0_3_0_MARK___3 = 870,
	ERROROUTC_N_B_MARK___2 = 871,
	TCLK2_B_MARK___7 = 872,
	IP1SR0_3_0_MARK___3 = 873,
	MSIOF5_SS1_MARK___2 = 874,
	IP2SR0_3_0_MARK___3 = 875,
	MSIOF2_TXD_MARK___5 = 876,
	HCTS1_N_A_MARK___5 = 877,
	CTS1_N_A_MARK___2 = 878,
	IP0SR0_7_4_MARK___3 = 879,
	MSIOF3_SS1_MARK___4 = 880,
	IP1SR0_7_4_MARK___3 = 881,
	MSIOF5_SYNC_MARK___2 = 882,
	IP2SR0_7_4_MARK___3 = 883,
	MSIOF2_SCK_MARK___5 = 884,
	HRTS1_N_A_MARK___5 = 885,
	RTS1_N_A_MARK___2 = 886,
	IP0SR0_11_8_MARK___3 = 887,
	MSIOF3_SS2_MARK___4 = 888,
	IP1SR0_11_8_MARK___3 = 889,
	MSIOF5_TXD_MARK___2 = 890,
	IP2SR0_11_8_MARK___3 = 891,
	MSIOF2_RXD_MARK___5 = 892,
	HSCK1_A_MARK___5 = 893,
	SCK1_A_MARK___3 = 894,
	IP0SR0_15_12_MARK___3 = 895,
	IRQ3_A_MARK___3 = 896,
	MSIOF3_SCK_MARK___4 = 897,
	IP1SR0_15_12_MARK___3 = 898,
	MSIOF5_SCK_MARK___2 = 899,
	IP0SR0_19_16_MARK___3 = 900,
	IRQ2_A_MARK___3 = 901,
	MSIOF3_TXD_MARK___4 = 902,
	IP1SR0_19_16_MARK___3 = 903,
	MSIOF5_RXD_MARK___2 = 904,
	IP0SR0_23_20_MARK___3 = 905,
	IRQ1_A_MARK___3 = 906,
	MSIOF3_RXD_MARK___4 = 907,
	IP1SR0_23_20_MARK___3 = 908,
	MSIOF2_SS2_MARK___5 = 909,
	TCLK1_A_MARK___7 = 910,
	IRQ2_B_MARK___3 = 911,
	IP0SR0_27_24_MARK___3 = 912,
	IRQ0_A_MARK___3 = 913,
	MSIOF3_SYNC_MARK___4 = 914,
	IP1SR0_27_24_MARK___3 = 915,
	MSIOF2_SS1_MARK___5 = 916,
	HTX1_A_MARK___5 = 917,
	TX1_A_MARK___7 = 918,
	IP0SR0_31_28_MARK___3 = 919,
	MSIOF5_SS2_MARK___2 = 920,
	IP1SR0_31_28_MARK___3 = 921,
	MSIOF2_SYNC_MARK___4 = 922,
	HRX1_A_MARK___5 = 923,
	RX1_A_MARK___7 = 924,
	IP0SR1_3_0_MARK___3 = 925,
	MSIOF1_SS2_MARK___5 = 926,
	HTX3_B_MARK___6 = 927,
	TX3_B_MARK___6 = 928,
	IP1SR1_3_0_MARK___2 = 929,
	MSIOF0_SYNC_MARK___8 = 930,
	HCTS1_N_B_MARK___5 = 931,
	CTS1_N_B_MARK___2 = 932,
	IP2SR1_3_0_MARK___2 = 933,
	HRX0_MARK___7 = 934,
	RX0_MARK___7 = 935,
	IP3SR1_3_0_MARK___2 = 936,
	HRX3_A_MARK___6 = 937,
	SCK3_A_MARK___3 = 938,
	MSIOF4_SS2_MARK___2 = 939,
	IP0SR1_7_4_MARK___3 = 940,
	MSIOF1_SS1_MARK___5 = 941,
	HCTS3_N_B_MARK___2 = 942,
	RX3_B_MARK___6 = 943,
	IP1SR1_7_4_MARK___2 = 944,
	MSIOF0_TXD_MARK___8 = 945,
	HRTS1_N_B_MARK___5 = 946,
	RTS1_N_B_MARK___2 = 947,
	IP2SR1_7_4_MARK___2 = 948,
	SCIF_CLK_MARK___4 = 949,
	IRQ4_A_MARK___3 = 950,
	IP3SR1_7_4_MARK___2 = 951,
	HSCK3_A_MARK___3 = 952,
	CTS3_N_A_MARK___2 = 953,
	MSIOF4_SCK_MARK___2 = 954,
	TPU0TO0_B_MARK___3 = 955,
	IP0SR1_11_8_MARK___3 = 956,
	MSIOF1_SYNC_MARK___5 = 957,
	HRTS3_N_B_MARK___2 = 958,
	RTS3_N_B_MARK___2 = 959,
	IP1SR1_11_8_MARK___2 = 960,
	MSIOF0_SCK_MARK___8 = 961,
	HSCK1_B_MARK___5 = 962,
	SCK1_B_MARK___3 = 963,
	IP2SR1_11_8_MARK___2 = 964,
	SSI_SCK_MARK___2 = 965,
	TCLK3_B_MARK___2 = 966,
	IP3SR1_11_8_MARK___2 = 967,
	HRTS3_N_A_MARK___2 = 968,
	RTS3_N_A_MARK___2 = 969,
	MSIOF4_TXD_MARK___2 = 970,
	TPU0TO1_B_MARK___3 = 971,
	IP0SR1_15_12_MARK___3 = 972,
	MSIOF1_SCK_MARK___5 = 973,
	HSCK3_B_MARK___3 = 974,
	CTS3_N_B_MARK___2 = 975,
	IP1SR1_15_12_MARK___2 = 976,
	MSIOF0_RXD_MARK___8 = 977,
	IP2SR1_15_12_MARK___2 = 978,
	SSI_WS_MARK___2 = 979,
	TCLK4_B_MARK___2 = 980,
	IP3SR1_15_12_MARK___2 = 981,
	HCTS3_N_A_MARK___2 = 982,
	RX3_A_MARK___6 = 983,
	MSIOF4_RXD_MARK___2 = 984,
	IP0SR1_19_16_MARK___3 = 985,
	MSIOF1_TXD_MARK___5 = 986,
	HRX3_B_MARK___6 = 987,
	SCK3_B_MARK___3 = 988,
	IP1SR1_19_16_MARK___2 = 989,
	HTX0_MARK___7 = 990,
	TX0_MARK___7 = 991,
	IP2SR1_19_16_MARK___2 = 992,
	SSI_SD_MARK___2 = 993,
	IRQ0_B_MARK___3 = 994,
	IP3SR1_19_16_MARK___2 = 995,
	HTX3_A_MARK___6 = 996,
	TX3_A_MARK___6 = 997,
	MSIOF4_SYNC_MARK___2 = 998,
	IP0SR1_23_20_MARK___3 = 999,
	MSIOF1_RXD_MARK___5 = 1000,
	IP1SR1_23_20_MARK___2 = 1001,
	HCTS0_N_MARK___7 = 1002,
	CTS0_N_MARK___8 = 1003,
	IP2SR1_23_20_MARK___2 = 1004,
	AUDIO_CLKOUT_MARK___3 = 1005,
	IRQ1_B_MARK___3 = 1006,
	IP3SR1_23_20_MARK = 1007,
	ERROROUTC_N_A_MARK___2 = 1008,
	IP0SR1_27_24_MARK___3 = 1009,
	MSIOF0_SS2_MARK___8 = 1010,
	HTX1_B_MARK___5 = 1011,
	TX1_B_MARK___7 = 1012,
	IP1SR1_27_24_MARK___2 = 1013,
	HRTS0_N_MARK___7 = 1014,
	RTS0_N_MARK___8 = 1015,
	PWM0_B_MARK___3 = 1016,
	IP2SR1_27_24_MARK___2 = 1017,
	AUDIO_CLKIN_MARK___2 = 1018,
	PWM3_C_MARK___2 = 1019,
	IP0SR1_31_28_MARK___3 = 1020,
	MSIOF0_SS1_MARK___8 = 1021,
	HRX1_B_MARK___5 = 1022,
	RX1_B_MARK___7 = 1023,
	IP1SR1_31_28_MARK___2 = 1024,
	HSCK0_MARK___7 = 1025,
	SCK0_MARK___7 = 1026,
	PWM0_A_MARK___3 = 1027,
	IP2SR1_31_28_MARK___2 = 1028,
	TCLK2_A_MARK___7 = 1029,
	MSIOF4_SS1_MARK___2 = 1030,
	IRQ3_B_MARK___3 = 1031,
	IP0SR2_3_0_MARK___2 = 1032,
	FXR_TXDA_MARK___3 = 1033,
	TPU0TO2_B_MARK___3 = 1034,
	IP1SR2_3_0_MARK___2 = 1035,
	TPU0TO0_A_MARK___3 = 1036,
	TCLK1_B_MARK___7 = 1037,
	IP0SR2_7_4_MARK___2 = 1038,
	FXR_TXENA_N_A_MARK___2 = 1039,
	TPU0TO3_B_MARK___3 = 1040,
	IP1SR2_7_4_MARK___2 = 1041,
	CAN_CLK_MARK___6 = 1042,
	FXR_TXENA_N_B_MARK___2 = 1043,
	IP2SR2_7_4_MARK___2 = 1044,
	CANFD1_TX_MARK___7 = 1045,
	PWM1_C_MARK___2 = 1046,
	IP0SR2_11_8_MARK___2 = 1047,
	RXDA_EXTFXR_MARK___3 = 1048,
	IRQ5_MARK___7 = 1049,
	IP1SR2_11_8_MARK___2 = 1050,
	CANFD0_TX_MARK___3 = 1051,
	FXR_TXENB_N_B_MARK___2 = 1052,
	IP0SR2_15_12_MARK___2 = 1053,
	CLK_EXTFXR_MARK___3 = 1054,
	IRQ4_B_MARK___3 = 1055,
	IP1SR2_15_12_MARK___2 = 1056,
	CANFD0_RX_MARK___3 = 1057,
	STPWT_EXTFXR_MARK___2 = 1058,
	IP2SR2_15_12_MARK___2 = 1059,
	CANFD1_RX_MARK___7 = 1060,
	PWM2_C_MARK___2 = 1061,
	IP0SR2_19_16_MARK___2 = 1062,
	RXDB_EXTFXR_MARK___3 = 1063,
	IP1SR2_19_16_MARK___2 = 1064,
	CANFD2_TX_MARK___2 = 1065,
	TPU0TO2_A_MARK___3 = 1066,
	TCLK3_C_MARK___2 = 1067,
	IP0SR2_23_20_MARK___2 = 1068,
	FXR_TXENB_N_A_MARK___2 = 1069,
	IP1SR2_23_20_MARK___2 = 1070,
	CANFD2_RX_MARK___2 = 1071,
	TPU0TO3_A_MARK___3 = 1072,
	PWM1_B_MARK___7 = 1073,
	TCLK4_C_MARK___2 = 1074,
	IP0SR2_27_24_MARK___2 = 1075,
	FXR_TXDB_MARK___3 = 1076,
	IP1SR2_27_24_MARK___2 = 1077,
	CANFD3_TX_MARK___2 = 1078,
	PWM2_B_MARK___6 = 1079,
	IP0SR2_31_28_MARK___2 = 1080,
	TPU0TO1_A_MARK___3 = 1081,
	TCLK2_C_MARK___2 = 1082,
	IP1SR2_31_28_MARK___2 = 1083,
	CANFD3_RX_MARK___2 = 1084,
	PWM3_B_MARK___7 = 1085,
	IP0SR3_3_0_MARK___2 = 1086,
	MMC_SD_D1_MARK___3 = 1087,
	IP1SR3_3_0_MARK___2 = 1088,
	MMC_D7_MARK___5 = 1089,
	IP2SR3_3_0_MARK___2 = 1090,
	QSPI0_IO3_MARK___8 = 1091,
	IP3SR3_3_0_MARK___2 = 1092,
	QSPI1_IO2_MARK___8 = 1093,
	IP0SR3_7_4_MARK___2 = 1094,
	MMC_SD_D0_MARK___3 = 1095,
	IP1SR3_7_4_MARK___2 = 1096,
	MMC_D6_MARK___5 = 1097,
	IP2SR3_7_4_MARK___2 = 1098,
	QSPI0_IO2_MARK___8 = 1099,
	IP3SR3_7_4_MARK___2 = 1100,
	QSPI1_SSL_MARK___8 = 1101,
	IP0SR3_11_8_MARK___2 = 1102,
	MMC_SD_D2_MARK___3 = 1103,
	IP1SR3_11_8_MARK___2 = 1104,
	MMC_SD_CMD_MARK___3 = 1105,
	IP2SR3_11_8_MARK___2 = 1106,
	QSPI0_MISO_IO1_MARK___8 = 1107,
	IP3SR3_11_8_MARK___2 = 1108,
	QSPI1_IO3_MARK___8 = 1109,
	IP0SR3_15_12_MARK___2 = 1110,
	MMC_SD_CLK_MARK___3 = 1111,
	IP1SR3_15_12_MARK___2 = 1112,
	SD_CD_MARK___3 = 1113,
	IP2SR3_15_12_MARK___2 = 1114,
	QSPI0_MOSI_IO0_MARK___8 = 1115,
	IP3SR3_15_12_MARK___2 = 1116,
	RPC_RESET_N_MARK___5 = 1117,
	IP0SR3_19_16_MARK___2 = 1118,
	MMC_DS_MARK___4 = 1119,
	IP1SR3_19_16_MARK___2 = 1120,
	SD_WP_MARK___3 = 1121,
	IP2SR3_19_16_MARK___2 = 1122,
	QSPI0_SPCLK_MARK___8 = 1123,
	IP3SR3_19_16_MARK___2 = 1124,
	RPC_WP_N_MARK___4 = 1125,
	IP0SR3_23_20_MARK___2 = 1126,
	MMC_SD_D3_MARK___3 = 1127,
	IP1SR3_23_20_MARK___2 = 1128,
	PWM1_A_MARK___7 = 1129,
	IP2SR3_23_20_MARK___2 = 1130,
	QSPI1_MOSI_IO0_MARK___8 = 1131,
	IP3SR3_23_20_MARK___2 = 1132,
	RPC_INT_N_MARK___5 = 1133,
	IP0SR3_27_24_MARK___2 = 1134,
	MMC_D5_MARK___5 = 1135,
	IP1SR3_27_24_MARK___2 = 1136,
	PWM2_A_MARK___6 = 1137,
	IP2SR3_27_24_MARK___2 = 1138,
	QSPI1_SPCLK_MARK___8 = 1139,
	IP3SR3_27_24_MARK = 1140,
	TCLK3_A_MARK___2 = 1141,
	IP0SR3_31_28_MARK___2 = 1142,
	MMC_D4_MARK___5 = 1143,
	IP1SR3_31_28_MARK___2 = 1144,
	QSPI0_SSL_MARK___8 = 1145,
	IP2SR3_31_28_MARK___2 = 1146,
	QSPI1_MISO_IO1_MARK___8 = 1147,
	IP3SR3_31_28_MARK = 1148,
	TCLK4_A_MARK___2 = 1149,
	IP0SR4_3_0_MARK___2 = 1150,
	SCL0_MARK___8 = 1151,
	IP1SR4_3_0_MARK___2 = 1152,
	HRX2_MARK___4 = 1153,
	SCK4_MARK___4 = 1154,
	IP3SR4_3_0_MARK___2 = 1155,
	AVS1_MARK___5 = 1156,
	IP0SR4_7_4_MARK___2 = 1157,
	SDA0_MARK___8 = 1158,
	IP1SR4_7_4_MARK___2 = 1159,
	HTX2_MARK___4 = 1160,
	CTS4_N_MARK___4 = 1161,
	IP0SR4_11_8_MARK___2 = 1162,
	SCL1_MARK___5 = 1163,
	IP1SR4_11_8_MARK___2 = 1164,
	HRTS2_N_MARK___4 = 1165,
	RTS4_N_MARK___4 = 1166,
	IP0SR4_15_12_MARK___2 = 1167,
	SDA1_MARK___5 = 1168,
	IP1SR4_15_12_MARK___2 = 1169,
	SCIF_CLK2_MARK___2 = 1170,
	IP0SR4_19_16_MARK___2 = 1171,
	SCL2_MARK___4 = 1172,
	IP1SR4_19_16_MARK___2 = 1173,
	HCTS2_N_MARK___4 = 1174,
	TX4_MARK___4 = 1175,
	IP0SR4_23_20_MARK___2 = 1176,
	SDA2_MARK___4 = 1177,
	IP1SR4_23_20_MARK___2 = 1178,
	HSCK2_MARK___4 = 1179,
	RX4_MARK___4 = 1180,
	IP2SR4_23_20_MARK___2 = 1181,
	PCIE0_CLKREQ_N_MARK___3 = 1182,
	IP0SR4_27_24_MARK___2 = 1183,
	SCL3_MARK___7 = 1184,
	IP1SR4_27_24_MARK___2 = 1185,
	PWM3_A_MARK___7 = 1186,
	IP0SR4_31_28_MARK___2 = 1187,
	SDA3_MARK___7 = 1188,
	IP1SR4_31_28_MARK___2 = 1189,
	PWM4_MARK___2 = 1190,
	IP2SR4_31_28_MARK___2 = 1191,
	AVS0_MARK___2 = 1192,
	IP0SR5_3_0_MARK___2 = 1193,
	AVB2_AVTP_PPS_MARK___2 = 1194,
	Ether_GPTP_PPS0_MARK = 1195,
	IP1SR5_3_0_MARK___2 = 1196,
	AVB2_TD3_MARK___2 = 1197,
	IP2SR5_3_0_MARK___2 = 1198,
	AVB2_TXC_MARK___2 = 1199,
	IP0SR5_7_4_MARK___2 = 1200,
	AVB2_AVTP_CAPTURE_MARK___2 = 1201,
	Ether_GPTP_CAPTURE_MARK = 1202,
	IP1SR5_7_4_MARK___2 = 1203,
	AVB2_RD3_MARK___2 = 1204,
	IP2SR5_7_4_MARK___2 = 1205,
	AVB2_RD0_MARK___2 = 1206,
	IP0SR5_11_8_MARK___2 = 1207,
	AVB2_AVTP_MATCH_MARK___2 = 1208,
	Ether_GPTP_MATCH_MARK = 1209,
	IP1SR5_11_8_MARK___2 = 1210,
	AVB2_MDIO_MARK___2 = 1211,
	IP2SR5_11_8_MARK___2 = 1212,
	AVB2_RXC_MARK___2 = 1213,
	IP0SR5_15_12_MARK___2 = 1214,
	AVB2_LINK_MARK___2 = 1215,
	IP1SR5_15_12_MARK___2 = 1216,
	AVB2_TD2_MARK___2 = 1217,
	IP2SR5_15_12_MARK___2 = 1218,
	AVB2_TX_CTL_MARK___2 = 1219,
	IP0SR5_19_16_MARK___2 = 1220,
	AVB2_PHY_INT_MARK___2 = 1221,
	IP1SR5_19_16_MARK___2 = 1222,
	AVB2_TD1_MARK___2 = 1223,
	IP2SR5_19_16_MARK___2 = 1224,
	AVB2_RX_CTL_MARK___2 = 1225,
	IP0SR5_23_20_MARK___2 = 1226,
	AVB2_MAGIC_MARK___2 = 1227,
	Ether_GPTP_PPS1_MARK = 1228,
	IP1SR5_23_20_MARK___2 = 1229,
	AVB2_RD2_MARK___2 = 1230,
	IP0SR5_27_24_MARK___2 = 1231,
	AVB2_MDC_MARK___2 = 1232,
	IP1SR5_27_24_MARK___2 = 1233,
	AVB2_RD1_MARK___2 = 1234,
	IP0SR5_31_28_MARK___2 = 1235,
	AVB2_TXCREFCLK_MARK___2 = 1236,
	IP1SR5_31_28_MARK___2 = 1237,
	AVB2_TD0_MARK___2 = 1238,
	IP0SR6_3_0_MARK___2 = 1239,
	AVB1_MDIO_MARK___2 = 1240,
	IP1SR6_3_0_MARK___2 = 1241,
	AVB1_RXC_MARK___2 = 1242,
	AVB1_MII_RXC_MARK___2 = 1243,
	IP2SR6_3_0_MARK___2 = 1244,
	AVB1_TD2_MARK___2 = 1245,
	AVB1_MII_TD2_MARK___2 = 1246,
	IP0SR6_7_4_MARK___2 = 1247,
	AVB1_MAGIC_MARK___2 = 1248,
	IP1SR6_7_4_MARK___2 = 1249,
	AVB1_RX_CTL_MARK___2 = 1250,
	AVB1_MII_RX_DV_MARK___2 = 1251,
	IP2SR6_7_4_MARK___2 = 1252,
	AVB1_RD2_MARK___2 = 1253,
	AVB1_MII_RD2_MARK___2 = 1254,
	IP0SR6_11_8_MARK___2 = 1255,
	AVB1_MDC_MARK___2 = 1256,
	IP1SR6_11_8_MARK___2 = 1257,
	AVB1_AVTP_PPS_MARK___2 = 1258,
	AVB1_MII_COL_MARK___2 = 1259,
	IP2SR6_11_8_MARK___2 = 1260,
	AVB1_TD3_MARK___2 = 1261,
	AVB1_MII_TD3_MARK___2 = 1262,
	IP0SR6_15_12_MARK___2 = 1263,
	AVB1_PHY_INT_MARK___2 = 1264,
	IP1SR6_15_12_MARK___2 = 1265,
	AVB1_AVTP_CAPTURE_MARK___2 = 1266,
	AVB1_MII_CRS_MARK___2 = 1267,
	IP2SR6_15_12_MARK___2 = 1268,
	AVB1_RD3_MARK___2 = 1269,
	AVB1_MII_RD3_MARK___2 = 1270,
	IP0SR6_19_16_MARK___2 = 1271,
	AVB1_LINK_MARK___2 = 1272,
	AVB1_MII_TX_ER_MARK___2 = 1273,
	IP1SR6_19_16_MARK___2 = 1274,
	AVB1_TD1_MARK___2 = 1275,
	AVB1_MII_TD1_MARK___2 = 1276,
	IP2SR6_19_16_MARK___2 = 1277,
	AVB1_TXCREFCLK_MARK___2 = 1278,
	IP0SR6_23_20_MARK___2 = 1279,
	AVB1_AVTP_MATCH_MARK___2 = 1280,
	AVB1_MII_RX_ER_MARK___2 = 1281,
	IP1SR6_23_20_MARK___2 = 1282,
	AVB1_TD0_MARK___2 = 1283,
	AVB1_MII_TD0_MARK___2 = 1284,
	IP0SR6_27_24_MARK___2 = 1285,
	AVB1_TXC_MARK___2 = 1286,
	AVB1_MII_TXC_MARK___2 = 1287,
	IP1SR6_27_24_MARK___2 = 1288,
	AVB1_RD1_MARK___2 = 1289,
	AVB1_MII_RD1_MARK___2 = 1290,
	IP0SR6_31_28_MARK___2 = 1291,
	AVB1_TX_CTL_MARK___2 = 1292,
	AVB1_MII_TX_EN_MARK___2 = 1293,
	IP1SR6_31_28_MARK___2 = 1294,
	AVB1_RD0_MARK___2 = 1295,
	AVB1_MII_RD0_MARK___2 = 1296,
	IP0SR7_3_0_MARK___2 = 1297,
	AVB0_AVTP_PPS_MARK___2 = 1298,
	AVB0_MII_COL_MARK___2 = 1299,
	IP1SR7_3_0_MARK___2 = 1300,
	AVB0_RD3_MARK___3 = 1301,
	AVB0_MII_RD3_MARK___2 = 1302,
	IP2SR7_3_0_MARK___2 = 1303,
	AVB0_TX_CTL_MARK___3 = 1304,
	AVB0_MII_TX_EN_MARK___2 = 1305,
	IP0SR7_7_4_MARK___2 = 1306,
	AVB0_AVTP_CAPTURE_MARK___2 = 1307,
	AVB0_MII_CRS_MARK___2 = 1308,
	IP1SR7_7_4_MARK___2 = 1309,
	AVB0_TXCREFCLK_MARK___3 = 1310,
	IP2SR7_7_4_MARK___2 = 1311,
	AVB0_RD1_MARK___3 = 1312,
	AVB0_MII_RD1_MARK___2 = 1313,
	IP0SR7_11_8_MARK___2 = 1314,
	AVB0_AVTP_MATCH_MARK___2 = 1315,
	AVB0_MII_RX_ER_MARK___2 = 1316,
	CC5_OSCOUT_MARK___2 = 1317,
	IP1SR7_11_8_MARK___2 = 1318,
	AVB0_MAGIC_MARK___3 = 1319,
	IP2SR7_11_8_MARK___2 = 1320,
	AVB0_RD0_MARK___3 = 1321,
	AVB0_MII_RD0_MARK___2 = 1322,
	IP0SR7_15_12_MARK___2 = 1323,
	AVB0_TD3_MARK___3 = 1324,
	AVB0_MII_TD3_MARK___2 = 1325,
	IP1SR7_15_12_MARK___2 = 1326,
	AVB0_TD0_MARK___3 = 1327,
	AVB0_MII_TD0_MARK___2 = 1328,
	IP2SR7_15_12_MARK___2 = 1329,
	AVB0_RXC_MARK___3 = 1330,
	AVB0_MII_RXC_MARK___2 = 1331,
	IP0SR7_19_16_MARK___2 = 1332,
	AVB0_LINK_MARK___3 = 1333,
	AVB0_MII_TX_ER_MARK___2 = 1334,
	IP1SR7_19_16_MARK___2 = 1335,
	AVB0_RD2_MARK___3 = 1336,
	AVB0_MII_RD2_MARK___2 = 1337,
	IP2SR7_19_16_MARK___2 = 1338,
	AVB0_RX_CTL_MARK___3 = 1339,
	AVB0_MII_RX_DV_MARK___2 = 1340,
	IP0SR7_23_20_MARK___2 = 1341,
	AVB0_PHY_INT_MARK___3 = 1342,
	IP1SR7_23_20_MARK___2 = 1343,
	AVB0_MDC_MARK___3 = 1344,
	IP0SR7_27_24_MARK___2 = 1345,
	AVB0_TD2_MARK___3 = 1346,
	AVB0_MII_TD2_MARK___2 = 1347,
	IP1SR7_27_24_MARK___2 = 1348,
	AVB0_MDIO_MARK___3 = 1349,
	IP0SR7_31_28_MARK___2 = 1350,
	AVB0_TD1_MARK___3 = 1351,
	AVB0_MII_TD1_MARK___2 = 1352,
	IP1SR7_31_28_MARK___2 = 1353,
	AVB0_TXC_MARK___3 = 1354,
	AVB0_MII_TXC_MARK___2 = 1355,
	SEL_SDA3_0_MARK___2 = 1356,
	SEL_SDA3_1_MARK___2 = 1357,
	SEL_SCL3_0_MARK___2 = 1358,
	SEL_SCL3_1_MARK___2 = 1359,
	SEL_SDA2_0_MARK___2 = 1360,
	SEL_SDA2_1_MARK___2 = 1361,
	SEL_SCL2_0_MARK___2 = 1362,
	SEL_SCL2_1_MARK___2 = 1363,
	SEL_SDA1_0_MARK___2 = 1364,
	SEL_SDA1_1_MARK___2 = 1365,
	SEL_SCL1_0_MARK___2 = 1366,
	SEL_SCL1_1_MARK___2 = 1367,
	SEL_SDA0_0_MARK___2 = 1368,
	SEL_SDA0_1_MARK___2 = 1369,
	SEL_SCL0_0_MARK___2 = 1370,
	SEL_SCL0_1_MARK___2 = 1371,
	PINMUX_MARK_END___8 = 1372,
};

enum {
	PINMUX_RESERVED___9 = 0,
	PINMUX_DATA_BEGIN___9 = 1,
	GP_0_0_DATA___9 = 2,
	GP_0_1_DATA___9 = 3,
	GP_0_2_DATA___9 = 4,
	GP_0_3_DATA___9 = 5,
	GP_0_4_DATA___9 = 6,
	GP_0_5_DATA___9 = 7,
	GP_0_6_DATA___9 = 8,
	GP_0_7_DATA___9 = 9,
	GP_0_8_DATA___9 = 10,
	GP_0_9_DATA___8 = 11,
	GP_0_10_DATA___8 = 12,
	GP_0_11_DATA___8 = 13,
	GP_0_12_DATA___8 = 14,
	GP_0_13_DATA___8 = 15,
	GP_0_14_DATA___8 = 16,
	GP_0_15_DATA___8 = 17,
	GP_0_16_DATA___5 = 18,
	GP_0_17_DATA___5 = 19,
	GP_1_0_DATA___9 = 20,
	GP_1_1_DATA___9 = 21,
	GP_1_2_DATA___9 = 22,
	GP_1_3_DATA___9 = 23,
	GP_1_4_DATA___9 = 24,
	GP_1_5_DATA___9 = 25,
	GP_1_6_DATA___9 = 26,
	GP_1_7_DATA___9 = 27,
	GP_1_8_DATA___9 = 28,
	GP_1_9_DATA___9 = 29,
	GP_1_10_DATA___9 = 30,
	GP_1_11_DATA___9 = 31,
	GP_1_12_DATA___9 = 32,
	GP_1_13_DATA___9 = 33,
	GP_1_14_DATA___9 = 34,
	GP_1_15_DATA___9 = 35,
	GP_1_16_DATA___9 = 36,
	GP_1_17_DATA___9 = 37,
	GP_1_18_DATA___9 = 38,
	GP_1_19_DATA___9 = 39,
	GP_1_20_DATA___9 = 40,
	GP_1_21_DATA___9 = 41,
	GP_1_22_DATA___9 = 42,
	GP_2_0_DATA___9 = 43,
	GP_2_1_DATA___9 = 44,
	GP_2_2_DATA___9 = 45,
	GP_2_3_DATA___9 = 46,
	GP_2_4_DATA___9 = 47,
	GP_2_5_DATA___9 = 48,
	GP_2_6_DATA___9 = 49,
	GP_2_7_DATA___9 = 50,
	GP_2_8_DATA___9 = 51,
	GP_2_9_DATA___9 = 52,
	GP_2_10_DATA___9 = 53,
	GP_2_11_DATA___9 = 54,
	GP_2_12_DATA___9 = 55,
	GP_2_13_DATA___9 = 56,
	GP_2_14_DATA___9 = 57,
	GP_2_15_DATA___6 = 58,
	GP_2_16_DATA___5 = 59,
	GP_2_17_DATA___5 = 60,
	GP_2_18_DATA___4 = 61,
	GP_2_19_DATA___5 = 62,
	GP_2_20_DATA___3 = 63,
	GP_2_21_DATA___3 = 64,
	GP_2_22_DATA___3 = 65,
	GP_2_23_DATA___3 = 66,
	GP_2_24_DATA___3 = 67,
	GP_2_25_DATA___3 = 68,
	GP_3_0_DATA___9 = 69,
	GP_3_1_DATA___9 = 70,
	GP_3_2_DATA___9 = 71,
	GP_3_3_DATA___9 = 72,
	GP_3_4_DATA___9 = 73,
	GP_3_5_DATA___9 = 74,
	GP_3_6_DATA___9 = 75,
	GP_3_7_DATA___9 = 76,
	GP_3_8_DATA___9 = 77,
	GP_3_9_DATA___9 = 78,
	GP_3_10_DATA___8 = 79,
	GP_3_11_DATA___8 = 80,
	GP_3_12_DATA___8 = 81,
	GP_3_13_DATA___8 = 82,
	GP_3_14_DATA___8 = 83,
	GP_3_15_DATA___8 = 84,
	GP_4_0_DATA___8 = 85,
	GP_4_1_DATA___8 = 86,
	GP_4_2_DATA___8 = 87,
	GP_4_3_DATA___8 = 88,
	GP_4_4_DATA___8 = 89,
	GP_4_5_DATA___8 = 90,
	GP_4_6_DATA___8 = 91,
	GP_4_7_DATA___8 = 92,
	GP_4_8_DATA___8 = 93,
	GP_4_9_DATA___8 = 94,
	GP_4_10_DATA___8 = 95,
	GP_5_0_DATA___8 = 96,
	GP_5_1_DATA___8 = 97,
	GP_5_2_DATA___8 = 98,
	GP_5_3_DATA___8 = 99,
	GP_5_4_DATA___8 = 100,
	GP_5_5_DATA___8 = 101,
	GP_5_6_DATA___8 = 102,
	GP_5_7_DATA___8 = 103,
	GP_5_8_DATA___8 = 104,
	GP_5_9_DATA___8 = 105,
	GP_5_10_DATA___8 = 106,
	GP_5_11_DATA___8 = 107,
	GP_5_12_DATA___8 = 108,
	GP_5_13_DATA___8 = 109,
	GP_5_14_DATA___8 = 110,
	GP_5_15_DATA___7 = 111,
	GP_5_16_DATA___7 = 112,
	GP_5_17_DATA___7 = 113,
	GP_5_18_DATA___7 = 114,
	GP_5_19_DATA___7 = 115,
	GP_6_0_DATA___7 = 116,
	GP_6_1_DATA___7 = 117,
	GP_6_2_DATA___7 = 118,
	GP_6_3_DATA___7 = 119,
	GP_6_4_DATA___7 = 120,
	GP_6_5_DATA___7 = 121,
	GP_6_6_DATA___7 = 122,
	GP_6_7_DATA___7 = 123,
	GP_6_8_DATA___7 = 124,
	GP_6_9_DATA___7 = 125,
	GP_6_10_DATA___7 = 126,
	GP_6_11_DATA___7 = 127,
	GP_6_12_DATA___7 = 128,
	GP_6_13_DATA___7 = 129,
	GP_6_14_DATA___6 = 130,
	GP_6_15_DATA___6 = 131,
	GP_6_16_DATA___6 = 132,
	GP_6_17_DATA___6 = 133,
	PINMUX_DATA_END___9 = 134,
	PINMUX_FUNCTION_BEGIN___9 = 135,
	GP_0_0_FN___9 = 136,
	GP_0_1_FN___9 = 137,
	GP_0_2_FN___9 = 138,
	GP_0_3_FN___9 = 139,
	GP_0_4_FN___9 = 140,
	GP_0_5_FN___9 = 141,
	GP_0_6_FN___9 = 142,
	GP_0_7_FN___9 = 143,
	GP_0_8_FN___9 = 144,
	GP_0_9_FN___8 = 145,
	GP_0_10_FN___8 = 146,
	GP_0_11_FN___8 = 147,
	GP_0_12_FN___8 = 148,
	GP_0_13_FN___8 = 149,
	GP_0_14_FN___8 = 150,
	GP_0_15_FN___8 = 151,
	GP_0_16_FN___5 = 152,
	GP_0_17_FN___5 = 153,
	GP_1_0_FN___9 = 154,
	GP_1_1_FN___9 = 155,
	GP_1_2_FN___9 = 156,
	GP_1_3_FN___9 = 157,
	GP_1_4_FN___9 = 158,
	GP_1_5_FN___9 = 159,
	GP_1_6_FN___9 = 160,
	GP_1_7_FN___9 = 161,
	GP_1_8_FN___9 = 162,
	GP_1_9_FN___9 = 163,
	GP_1_10_FN___9 = 164,
	GP_1_11_FN___9 = 165,
	GP_1_12_FN___9 = 166,
	GP_1_13_FN___9 = 167,
	GP_1_14_FN___9 = 168,
	GP_1_15_FN___9 = 169,
	GP_1_16_FN___9 = 170,
	GP_1_17_FN___9 = 171,
	GP_1_18_FN___9 = 172,
	GP_1_19_FN___9 = 173,
	GP_1_20_FN___9 = 174,
	GP_1_21_FN___9 = 175,
	GP_1_22_FN___9 = 176,
	GP_2_0_FN___9 = 177,
	GP_2_1_FN___9 = 178,
	GP_2_2_FN___9 = 179,
	GP_2_3_FN___9 = 180,
	GP_2_4_FN___9 = 181,
	GP_2_5_FN___9 = 182,
	GP_2_6_FN___9 = 183,
	GP_2_7_FN___9 = 184,
	GP_2_8_FN___9 = 185,
	GP_2_9_FN___9 = 186,
	GP_2_10_FN___9 = 187,
	GP_2_11_FN___9 = 188,
	GP_2_12_FN___9 = 189,
	GP_2_13_FN___9 = 190,
	GP_2_14_FN___9 = 191,
	GP_2_15_FN___6 = 192,
	GP_2_16_FN___5 = 193,
	GP_2_17_FN___5 = 194,
	GP_2_18_FN___4 = 195,
	GP_2_19_FN___5 = 196,
	GP_2_20_FN___3 = 197,
	GP_2_21_FN___3 = 198,
	GP_2_22_FN___3 = 199,
	GP_2_23_FN___3 = 200,
	GP_2_24_FN___3 = 201,
	GP_2_25_FN___3 = 202,
	GP_3_0_FN___9 = 203,
	GP_3_1_FN___9 = 204,
	GP_3_2_FN___9 = 205,
	GP_3_3_FN___9 = 206,
	GP_3_4_FN___9 = 207,
	GP_3_5_FN___9 = 208,
	GP_3_6_FN___9 = 209,
	GP_3_7_FN___9 = 210,
	GP_3_8_FN___9 = 211,
	GP_3_9_FN___9 = 212,
	GP_3_10_FN___8 = 213,
	GP_3_11_FN___8 = 214,
	GP_3_12_FN___8 = 215,
	GP_3_13_FN___8 = 216,
	GP_3_14_FN___8 = 217,
	GP_3_15_FN___8 = 218,
	GP_4_0_FN___8 = 219,
	GP_4_1_FN___8 = 220,
	GP_4_2_FN___8 = 221,
	GP_4_3_FN___8 = 222,
	GP_4_4_FN___8 = 223,
	GP_4_5_FN___8 = 224,
	GP_4_6_FN___8 = 225,
	GP_4_7_FN___8 = 226,
	GP_4_8_FN___8 = 227,
	GP_4_9_FN___8 = 228,
	GP_4_10_FN___8 = 229,
	GP_5_0_FN___8 = 230,
	GP_5_1_FN___8 = 231,
	GP_5_2_FN___8 = 232,
	GP_5_3_FN___8 = 233,
	GP_5_4_FN___8 = 234,
	GP_5_5_FN___8 = 235,
	GP_5_6_FN___8 = 236,
	GP_5_7_FN___8 = 237,
	GP_5_8_FN___8 = 238,
	GP_5_9_FN___8 = 239,
	GP_5_10_FN___8 = 240,
	GP_5_11_FN___8 = 241,
	GP_5_12_FN___8 = 242,
	GP_5_13_FN___8 = 243,
	GP_5_14_FN___8 = 244,
	GP_5_15_FN___7 = 245,
	GP_5_16_FN___7 = 246,
	GP_5_17_FN___7 = 247,
	GP_5_18_FN___7 = 248,
	GP_5_19_FN___7 = 249,
	GP_6_0_FN___7 = 250,
	GP_6_1_FN___7 = 251,
	GP_6_2_FN___7 = 252,
	GP_6_3_FN___7 = 253,
	GP_6_4_FN___7 = 254,
	GP_6_5_FN___7 = 255,
	GP_6_6_FN___7 = 256,
	GP_6_7_FN___7 = 257,
	GP_6_8_FN___7 = 258,
	GP_6_9_FN___7 = 259,
	GP_6_10_FN___7 = 260,
	GP_6_11_FN___7 = 261,
	GP_6_12_FN___7 = 262,
	GP_6_13_FN___7 = 263,
	GP_6_14_FN___6 = 264,
	GP_6_15_FN___6 = 265,
	GP_6_16_FN___6 = 266,
	GP_6_17_FN___6 = 267,
	FN_AVB_PHY_INT___5 = 268,
	FN_CLKOUT___5 = 269,
	FN_AVB_RD3___2 = 270,
	FN_AVB_RXC___2 = 271,
	FN_AVB_RX_CTL___2 = 272,
	FN_QSPI0_SSL___6 = 273,
	FN_IP0_3_0___6 = 274,
	FN_QSPI0_SPCLK___6 = 275,
	FN_HSCK4_A = 276,
	FN_IP1_3_0___6 = 277,
	FN_QSPI1_IO2___6 = 278,
	FN_RIF2_D1_A___4 = 279,
	FN_HTX3_C___4 = 280,
	FN_VI4_DATA3_A___4 = 281,
	FN_IP2_3_0___6 = 282,
	FN_AVB_TXCREFCLK___2 = 283,
	FN_IP3_3_0___6 = 284,
	FN_A1___5 = 285,
	FN_IRQ1___6 = 286,
	FN_PWM3_A___8 = 287,
	FN_DU_DOTCLKIN1___2 = 288,
	FN_VI5_DATA0_A = 289,
	FN_DU_DISP_CDE___2 = 290,
	FN_SDA6_B___4 = 291,
	FN_IETX = 292,
	FN_QCPV_QDE___5 = 293,
	FN_IP0_7_4___6 = 294,
	FN_QSPI0_MOSI_IO0___6 = 295,
	FN_HCTS4_N_A = 296,
	FN_IP1_7_4___6 = 297,
	FN_QSPI1_IO3___6 = 298,
	FN_RIF3_CLK_A___4 = 299,
	FN_HRX3_C___4 = 300,
	FN_VI4_DATA4_A___4 = 301,
	FN_IP2_7_4___6 = 302,
	FN_AVB_MDIO___2 = 303,
	FN_IP3_7_4___6 = 304,
	FN_A2___5 = 305,
	FN_IRQ2___6 = 306,
	FN_AVB_AVTP_PPS___5 = 307,
	FN_VI4_CLKENB___5 = 308,
	FN_VI5_DATA1_A = 309,
	FN_DU_DISP___6 = 310,
	FN_SCL6_B___4 = 311,
	FN_QSTVB_QVE___5 = 312,
	FN_IP0_11_8___6 = 313,
	FN_QSPI0_MISO_IO1___6 = 314,
	FN_HRTS4_N_A = 315,
	FN_IP1_11_8___6 = 316,
	FN_QSPI1_SSL___6 = 317,
	FN_RIF3_SYNC_A___4 = 318,
	FN_HSCK3_C = 319,
	FN_VI4_DATA5_A___4 = 320,
	FN_IP2_11_8___6 = 321,
	FN_AVB_MDC___5 = 322,
	FN_IP3_11_8___6 = 323,
	FN_A3___5 = 324,
	FN_CTS4_N_A___4 = 325,
	FN_PWM4_A___5 = 326,
	FN_VI4_DATA12___5 = 327,
	FN_DU_DOTCLKOUT0___5 = 328,
	FN_HTX3_D___4 = 329,
	FN_IECLK = 330,
	FN_LCDOUT12___5 = 331,
	FN_IP0_15_12___6 = 332,
	FN_QSPI0_IO2___6 = 333,
	FN_HTX4_A___4 = 334,
	FN_IP1_15_12___6 = 335,
	FN_RPC_INT_N___6 = 336,
	FN_RIF3_D0_A___4 = 337,
	FN_HCTS3_N_C = 338,
	FN_VI4_DATA6_A___4 = 339,
	FN_IP2_15_12___6 = 340,
	FN_BS_N___5 = 341,
	FN_PWM0_A___4 = 342,
	FN_AVB_MAGIC___5 = 343,
	FN_VI4_CLK___5 = 344,
	FN_TX3_C = 345,
	FN_VI5_CLK_B = 346,
	FN_IP3_15_12___6 = 347,
	FN_A4___5 = 348,
	FN_RTS4_N_A___4 = 349,
	FN_MSIOF3_SYNC_B___5 = 350,
	FN_VI4_DATA8___5 = 351,
	FN_PWM2_B___7 = 352,
	FN_DU_DG4___6 = 353,
	FN_RIF2_CLK_B___4 = 354,
	FN_IP0_19_16___6 = 355,
	FN_QSPI0_IO3___6 = 356,
	FN_HRX4_A___4 = 357,
	FN_IP1_19_16___6 = 358,
	FN_RPC_RESET_N___6 = 359,
	FN_RIF3_D1_A___4 = 360,
	FN_HRTS3_N_C = 361,
	FN_VI4_DATA7_A___4 = 362,
	FN_IP2_19_16___6 = 363,
	FN_RD_N___5 = 364,
	FN_PWM1_A___8 = 365,
	FN_AVB_LINK___5 = 366,
	FN_VI4_FIELD___5 = 367,
	FN_RX3_C = 368,
	FN_FSCLKST2_N_A___3 = 369,
	FN_VI5_DATA0_B = 370,
	FN_IP3_19_16___6 = 371,
	FN_A5___5 = 372,
	FN_SCK4_A___5 = 373,
	FN_MSIOF3_SCK_B___5 = 374,
	FN_VI4_DATA9___5 = 375,
	FN_PWM3_B___8 = 376,
	FN_RIF2_SYNC_B___4 = 377,
	FN_QPOLA___5 = 378,
	FN_IP0_23_20___6 = 379,
	FN_QSPI1_SPCLK___6 = 380,
	FN_RIF2_CLK_A___4 = 381,
	FN_HSCK4_B = 382,
	FN_VI4_DATA0_A___4 = 383,
	FN_IP1_23_20___6 = 384,
	FN_AVB_RD0___2 = 385,
	FN_IP2_23_20___6 = 386,
	FN_RD_WR_N___5 = 387,
	FN_SCL7_A = 388,
	FN_AVB_AVTP_MATCH___2 = 389,
	FN_VI4_VSYNC_N___5 = 390,
	FN_TX5_B___5 = 391,
	FN_SCK3_C = 392,
	FN_PWM5_A___4 = 393,
	FN_IP3_23_20___6 = 394,
	FN_A6___5 = 395,
	FN_RX4_A___5 = 396,
	FN_MSIOF3_RXD_B___5 = 397,
	FN_VI4_DATA10___5 = 398,
	FN_RIF2_D0_B___4 = 399,
	FN_IP0_27_24___6 = 400,
	FN_QSPI1_MOSI_IO0___6 = 401,
	FN_RIF2_SYNC_A___4 = 402,
	FN_HTX4_B___4 = 403,
	FN_VI4_DATA1_A___4 = 404,
	FN_IP1_27_24___6 = 405,
	FN_AVB_RD1___2 = 406,
	FN_IP2_27_24___6 = 407,
	FN_EX_WAIT0___2 = 408,
	FN_SDA7_A = 409,
	FN_AVB_AVTP_CAPTURE___2 = 410,
	FN_VI4_HSYNC_N___5 = 411,
	FN_RX5_B___5 = 412,
	FN_PWM6_A___4 = 413,
	FN_IP3_27_24___6 = 414,
	FN_A7___5 = 415,
	FN_TX4_A___5 = 416,
	FN_MSIOF3_TXD_B___5 = 417,
	FN_VI4_DATA11___5 = 418,
	FN_RIF2_D1_B___4 = 419,
	FN_IP0_31_28___6 = 420,
	FN_QSPI1_MISO_IO1___6 = 421,
	FN_RIF2_D0_A___4 = 422,
	FN_HRX4_B___4 = 423,
	FN_VI4_DATA2_A___4 = 424,
	FN_IP1_31_28___6 = 425,
	FN_AVB_RD2___2 = 426,
	FN_IP2_31_28___6 = 427,
	FN_A0___5 = 428,
	FN_IRQ0___6 = 429,
	FN_PWM2_A___7 = 430,
	FN_MSIOF3_SS1_B___5 = 431,
	FN_VI5_CLK_A = 432,
	FN_DU_CDE___6 = 433,
	FN_HRX3_D___4 = 434,
	FN_IERX = 435,
	FN_QSTB_QHE___5 = 436,
	FN_IP3_31_28___6 = 437,
	FN_A8___5 = 438,
	FN_SDA6_A___4 = 439,
	FN_RX3_B___7 = 440,
	FN_HRX4_C = 441,
	FN_VI5_HSYNC_N_A = 442,
	FN_DU_HSYNC___2 = 443,
	FN_VI4_DATA0_B___4 = 444,
	FN_QSTH_QHS___5 = 445,
	FN_IP4_3_0___6 = 446,
	FN_A9___5 = 447,
	FN_TX5_A___5 = 448,
	FN_IRQ3___6 = 449,
	FN_VI4_DATA16___5 = 450,
	FN_VI5_VSYNC_N_A = 451,
	FN_DU_DG7___6 = 452,
	FN_LCDOUT15___5 = 453,
	FN_IP5_3_0___6 = 454,
	FN_A17___5 = 455,
	FN_MSIOF1_RXD___6 = 456,
	FN_VI4_DATA20___5 = 457,
	FN_VI5_DATA6_A = 458,
	FN_DU_DB6___6 = 459,
	FN_LCDOUT6___5 = 460,
	FN_IP6_3_0___6 = 461,
	FN_D3___5 = 462,
	FN_MSIOF3_TXD_A___5 = 463,
	FN_TX5_C = 464,
	FN_VI5_DATA15_A = 465,
	FN_DU_DR4___6 = 466,
	FN_TX4_C___4 = 467,
	FN_LCDOUT20___5 = 468,
	FN_IP7_3_0___6 = 469,
	FN_D11___5 = 470,
	FN_MSIOF2_TXD_A___4 = 471,
	FN_VI5_DATA11_A = 472,
	FN_DU_DG2___6 = 473,
	FN_RIF3_D1_B___4 = 474,
	FN_HRTS3_N_E = 475,
	FN_LCDOUT10___5 = 476,
	FN_IP4_7_4___6 = 477,
	FN_A10___5 = 478,
	FN_IRQ4___6 = 479,
	FN_MSIOF2_SYNC_B___5 = 480,
	FN_VI4_DATA13___5 = 481,
	FN_VI5_FIELD_A = 482,
	FN_DU_DG5___6 = 483,
	FN_FSCLKST2_N_B___3 = 484,
	FN_LCDOUT13___5 = 485,
	FN_IP5_7_4___6 = 486,
	FN_A18___5 = 487,
	FN_MSIOF1_TXD___6 = 488,
	FN_VI4_DATA21___5 = 489,
	FN_VI5_DATA7_A = 490,
	FN_DU_DB0___6 = 491,
	FN_HRX4_E = 492,
	FN_LCDOUT0___5 = 493,
	FN_IP6_7_4___6 = 494,
	FN_D4___5 = 495,
	FN_CANFD1_TX___8 = 496,
	FN_HSCK3_B___4 = 497,
	FN_CAN1_TX___4 = 498,
	FN_RTS3_N_A___3 = 499,
	FN_MSIOF3_SS2_A___5 = 500,
	FN_VI5_DATA1_B = 501,
	FN_IP7_7_4___6 = 502,
	FN_D12___5 = 503,
	FN_CANFD0_TX___4 = 504,
	FN_TX4_B___5 = 505,
	FN_CAN0_TX = 506,
	FN_VI5_DATA8_A = 507,
	FN_VI5_DATA3_B = 508,
	FN_IP4_11_8___6 = 509,
	FN_A11___5 = 510,
	FN_SCL6_A___4 = 511,
	FN_TX3_B___7 = 512,
	FN_HTX4_C = 513,
	FN_DU_VSYNC___2 = 514,
	FN_VI4_DATA1_B___4 = 515,
	FN_QSTVA_QVS___5 = 516,
	FN_IP5_11_8___6 = 517,
	FN_A19___5 = 518,
	FN_MSIOF1_SCK___6 = 519,
	FN_VI4_DATA22___5 = 520,
	FN_VI5_DATA2_A = 521,
	FN_DU_DB1___6 = 522,
	FN_HTX4_E = 523,
	FN_LCDOUT1___5 = 524,
	FN_IP6_11_8___6 = 525,
	FN_D5___5 = 526,
	FN_RX3_A___7 = 527,
	FN_HRX3_B___7 = 528,
	FN_DU_DR5___6 = 529,
	FN_VI4_DATA4_B___4 = 530,
	FN_LCDOUT21___5 = 531,
	FN_IP7_11_8___6 = 532,
	FN_D13___5 = 533,
	FN_CANFD0_RX___4 = 534,
	FN_RX4_B___5 = 535,
	FN_CAN0_RX = 536,
	FN_VI5_DATA9_A = 537,
	FN_SCL7_B = 538,
	FN_VI5_DATA4_B = 539,
	FN_IP4_15_12___6 = 540,
	FN_A12___5 = 541,
	FN_RX5_A___5 = 542,
	FN_MSIOF2_SS2_B___4 = 543,
	FN_VI4_DATA17___5 = 544,
	FN_VI5_DATA3_A = 545,
	FN_DU_DG6___6 = 546,
	FN_LCDOUT14___5 = 547,
	FN_IP5_15_12___6 = 548,
	FN_CS0_N___5 = 549,
	FN_SCL5___3 = 550,
	FN_DU_DR0___6 = 551,
	FN_VI4_DATA2_B___4 = 552,
	FN_LCDOUT16___5 = 553,
	FN_IP6_15_12___6 = 554,
	FN_D6___5 = 555,
	FN_TX3_A___7 = 556,
	FN_HTX3_B___7 = 557,
	FN_DU_DR6___6 = 558,
	FN_VI4_DATA5_B___4 = 559,
	FN_LCDOUT22___5 = 560,
	FN_IP7_15_12___3 = 561,
	FN_D14___5 = 562,
	FN_CAN_CLK___7 = 563,
	FN_HRX3_A___7 = 564,
	FN_MSIOF2_SS2_A___4 = 565,
	FN_SDA7_B = 566,
	FN_VI5_DATA5_B = 567,
	FN_IP4_19_16___6 = 568,
	FN_A13___5 = 569,
	FN_SCK5_A___5 = 570,
	FN_MSIOF2_SCK_B___4 = 571,
	FN_VI4_DATA14___5 = 572,
	FN_HRX4_D = 573,
	FN_DU_DB2___6 = 574,
	FN_LCDOUT2___5 = 575,
	FN_IP5_19_16___6 = 576,
	FN_WE0_N___5 = 577,
	FN_SDA5___3 = 578,
	FN_DU_DR1___6 = 579,
	FN_VI4_DATA3_B___4 = 580,
	FN_LCDOUT17___5 = 581,
	FN_IP6_19_16___6 = 582,
	FN_D7___5 = 583,
	FN_CANFD1_RX___8 = 584,
	FN_IRQ5___8 = 585,
	FN_CAN1_RX___4 = 586,
	FN_CTS3_N_A___3 = 587,
	FN_VI5_DATA2_B = 588,
	FN_IP7_19_16___6 = 589,
	FN_D15___5 = 590,
	FN_MSIOF2_SS1_A___4 = 591,
	FN_HTX3_A___7 = 592,
	FN_MSIOF3_SS1_A___5 = 593,
	FN_DU_DG3___6 = 594,
	FN_LCDOUT11___5 = 595,
	FN_IP4_23_20___6 = 596,
	FN_A14___5 = 597,
	FN_MSIOF1_SS1___6 = 598,
	FN_MSIOF2_RXD_B___4 = 599,
	FN_VI4_DATA15___5 = 600,
	FN_HTX4_D = 601,
	FN_DU_DB3___6 = 602,
	FN_LCDOUT3___5 = 603,
	FN_IP5_23_20___6 = 604,
	FN_D0___5 = 605,
	FN_MSIOF3_SCK_A___5 = 606,
	FN_DU_DR2___6 = 607,
	FN_CTS4_N_C___4 = 608,
	FN_LCDOUT18___5 = 609,
	FN_IP6_23_20___6 = 610,
	FN_D8___5 = 611,
	FN_MSIOF2_SCK_A___4 = 612,
	FN_SCK4_B___5 = 613,
	FN_VI5_DATA12_A = 614,
	FN_DU_DR7___6 = 615,
	FN_RIF3_CLK_B___4 = 616,
	FN_HCTS3_N_E = 617,
	FN_LCDOUT23___5 = 618,
	FN_IP7_23_20___6 = 619,
	FN_SCL4___3 = 620,
	FN_CS1_N_A26 = 621,
	FN_DU_DOTCLKIN0 = 622,
	FN_VI4_DATA6_B___4 = 623,
	FN_VI5_DATA6_B = 624,
	FN_QCLK___5 = 625,
	FN_IP4_27_24___6 = 626,
	FN_A15___5 = 627,
	FN_MSIOF1_SS2___6 = 628,
	FN_MSIOF2_TXD_B___4 = 629,
	FN_VI4_DATA18___5 = 630,
	FN_VI5_DATA4_A = 631,
	FN_DU_DB4___6 = 632,
	FN_LCDOUT4___5 = 633,
	FN_IP5_27_24___6 = 634,
	FN_D1___5 = 635,
	FN_MSIOF3_SYNC_A___5 = 636,
	FN_SCK3_A___4 = 637,
	FN_VI4_DATA23___5 = 638,
	FN_VI5_CLKENB_A = 639,
	FN_DU_DB7___6 = 640,
	FN_RTS4_N_C___4 = 641,
	FN_LCDOUT7___5 = 642,
	FN_IP6_27_24___6 = 643,
	FN_D9___5 = 644,
	FN_MSIOF2_SYNC_A___5 = 645,
	FN_VI5_DATA10_A = 646,
	FN_DU_DG0___6 = 647,
	FN_RIF3_SYNC_B___4 = 648,
	FN_HRX3_E = 649,
	FN_LCDOUT8___5 = 650,
	FN_IP7_27_24___6 = 651,
	FN_SDA4___3 = 652,
	FN_WE1_N___5 = 653,
	FN_VI4_DATA7_B___4 = 654,
	FN_VI5_DATA7_B = 655,
	FN_QPOLB___5 = 656,
	FN_IP4_31_28___6 = 657,
	FN_A16___5 = 658,
	FN_MSIOF1_SYNC___6 = 659,
	FN_MSIOF2_SS1_B___4 = 660,
	FN_VI4_DATA19___5 = 661,
	FN_VI5_DATA5_A = 662,
	FN_DU_DB5___6 = 663,
	FN_LCDOUT5___5 = 664,
	FN_IP5_31_28___6 = 665,
	FN_D2___5 = 666,
	FN_MSIOF3_RXD_A___5 = 667,
	FN_RX5_C = 668,
	FN_VI5_DATA14_A = 669,
	FN_DU_DR3___6 = 670,
	FN_RX4_C___4 = 671,
	FN_LCDOUT19___5 = 672,
	FN_IP6_31_28___6 = 673,
	FN_D10___5 = 674,
	FN_MSIOF2_RXD_A___4 = 675,
	FN_VI5_DATA13_A = 676,
	FN_DU_DG1___6 = 677,
	FN_RIF3_D0_B___4 = 678,
	FN_HTX3_E = 679,
	FN_LCDOUT9___5 = 680,
	FN_IP7_31_28___6 = 681,
	FN_SD0_CLK___4 = 682,
	FN_NFDATA8___5 = 683,
	FN_SCL1_C = 684,
	FN_HSCK1_B___6 = 685,
	FN_SDA2_E = 686,
	FN_FMCLK_B___4 = 687,
	FN_IP8_3_0___6 = 688,
	FN_SD0_CMD___4 = 689,
	FN_NFDATA9___5 = 690,
	FN_HRX1_B___6 = 691,
	FN_SPEEDIN_B___5 = 692,
	FN_IP9_3_0___6 = 693,
	FN_SD1_DAT1___4 = 694,
	FN_NFCE_N_B___4 = 695,
	FN_IP10_3_0___6 = 696,
	FN_SD3_DAT3___4 = 697,
	FN_NFDATA3___5 = 698,
	FN_IP11_3_0___5 = 699,
	FN_SD1_CD___4 = 700,
	FN_NFCE_N_A___4 = 701,
	FN_SSI_SCK1 = 702,
	FN_RIF0_D1_B___4 = 703,
	FN_TS_SDEN0 = 704,
	FN_IP8_7_4___6 = 705,
	FN_SD0_DAT0___4 = 706,
	FN_NFDATA10___5 = 707,
	FN_HTX1_B___6 = 708,
	FN_REMOCON_B___4 = 709,
	FN_IP9_7_4___6 = 710,
	FN_SD1_DAT2___4 = 711,
	FN_NFALE_B = 712,
	FN_IP10_7_4___6 = 713,
	FN_SD3_DAT4___4 = 714,
	FN_NFDATA4___5 = 715,
	FN_IP11_7_4___5 = 716,
	FN_SD1_WP___4 = 717,
	FN_NFWP_N_A___4 = 718,
	FN_SSI_WS1 = 719,
	FN_RIF0_SYNC_B___4 = 720,
	FN_TS_SPSYNC0 = 721,
	FN_IP8_11_8___6 = 722,
	FN_SD0_DAT1___4 = 723,
	FN_NFDATA11___5 = 724,
	FN_SDA2_C = 725,
	FN_HCTS1_N_B___6 = 726,
	FN_FMIN_B___4 = 727,
	FN_IP9_11_8___6 = 728,
	FN_SD1_DAT3___4 = 729,
	FN_NFRB_N_B___4 = 730,
	FN_IP10_11_8___6 = 731,
	FN_SD3_DAT5___4 = 732,
	FN_NFDATA5___5 = 733,
	FN_IP11_11_8___5 = 734,
	FN_RX0_A___2 = 735,
	FN_HRX1_A___6 = 736,
	FN_SSI_SCK2_A___4 = 737,
	FN_RIF1_SYNC = 738,
	FN_TS_SCK1 = 739,
	FN_IP8_15_12___6 = 740,
	FN_SD0_DAT2___4 = 741,
	FN_NFDATA12___5 = 742,
	FN_SCL2_C = 743,
	FN_HRTS1_N_B___6 = 744,
	FN_BPFCLK_B___4 = 745,
	FN_IP9_15_12___6 = 746,
	FN_SD3_CLK___4 = 747,
	FN_NFWE_N___5 = 748,
	FN_IP10_15_12___6 = 749,
	FN_SD3_DAT6___4 = 750,
	FN_NFDATA6___5 = 751,
	FN_IP11_15_12___5 = 752,
	FN_TX0_A___2 = 753,
	FN_HTX1_A___6 = 754,
	FN_SSI_WS2_A___4 = 755,
	FN_RIF1_D0 = 756,
	FN_TS_SDAT1 = 757,
	FN_IP8_19_16___6 = 758,
	FN_SD0_DAT3___4 = 759,
	FN_NFDATA13___5 = 760,
	FN_SDA1_C = 761,
	FN_SCL2_E = 762,
	FN_SPEEDIN_C = 763,
	FN_REMOCON_C = 764,
	FN_IP9_19_16___6 = 765,
	FN_SD3_CMD___4 = 766,
	FN_NFRE_N___5 = 767,
	FN_IP10_19_16___6 = 768,
	FN_SD3_DAT7___4 = 769,
	FN_NFDATA7___5 = 770,
	FN_IP11_19_16___5 = 771,
	FN_CTS0_N_A = 772,
	FN_NFDATA14_A___4 = 773,
	FN_AUDIO_CLKOUT_A___4 = 774,
	FN_RIF1_D1 = 775,
	FN_SCIF_CLK_A___5 = 776,
	FN_FMCLK_A___4 = 777,
	FN_IP8_23_20___6 = 778,
	FN_SD1_CLK___4 = 779,
	FN_NFDATA14_B___4 = 780,
	FN_IP9_23_20___6 = 781,
	FN_SD3_DAT0___4 = 782,
	FN_NFDATA0___5 = 783,
	FN_IP10_23_20___5 = 784,
	FN_SD3_DS___4 = 785,
	FN_NFCLE___5 = 786,
	FN_IP11_23_20___5 = 787,
	FN_RTS0_N_A = 788,
	FN_NFDATA15_A___4 = 789,
	FN_AUDIO_CLKOUT1_A___4 = 790,
	FN_RIF1_CLK = 791,
	FN_SCL2_A___5 = 792,
	FN_FMIN_A___4 = 793,
	FN_IP8_27_24___6 = 794,
	FN_SD1_CMD___4 = 795,
	FN_NFDATA15_B___4 = 796,
	FN_IP9_27_24___6 = 797,
	FN_SD3_DAT1___4 = 798,
	FN_NFDATA1___5 = 799,
	FN_IP10_27_24___5 = 800,
	FN_SD0_CD___4 = 801,
	FN_NFALE_A = 802,
	FN_SD3_CD___4 = 803,
	FN_RIF0_CLK_B___4 = 804,
	FN_SCL2_B___5 = 805,
	FN_TCLK1_A___8 = 806,
	FN_SSI_SCK2_B___4 = 807,
	FN_TS_SCK0 = 808,
	FN_IP11_27_24___5 = 809,
	FN_SCK0_A___2 = 810,
	FN_HSCK1_A___6 = 811,
	FN_USB3HS0_ID = 812,
	FN_RTS1_N___7 = 813,
	FN_SDA2_A___5 = 814,
	FN_FMCLK_C___4 = 815,
	FN_USB0_ID = 816,
	FN_IP8_31_28___6 = 817,
	FN_SD1_DAT0___4 = 818,
	FN_NFWP_N_B___4 = 819,
	FN_IP9_31_28___6 = 820,
	FN_SD3_DAT2___4 = 821,
	FN_NFDATA2___5 = 822,
	FN_IP10_31_28___5 = 823,
	FN_SD0_WP___4 = 824,
	FN_NFRB_N_A___4 = 825,
	FN_SD3_WP___4 = 826,
	FN_RIF0_D0_B___4 = 827,
	FN_SDA2_B___5 = 828,
	FN_TCLK2_A___8 = 829,
	FN_SSI_WS2_B___4 = 830,
	FN_TS_SDAT0 = 831,
	FN_IP11_31_28___5 = 832,
	FN_RX1___2 = 833,
	FN_HRX2_B___4 = 834,
	FN_SSI_SCK9_B___4 = 835,
	FN_AUDIO_CLKOUT1_B___4 = 836,
	FN_IP12_3_0___5 = 837,
	FN_TX1___2 = 838,
	FN_HTX2_B___4 = 839,
	FN_SSI_WS9_B___4 = 840,
	FN_AUDIO_CLKOUT3_B___4 = 841,
	FN_IP13_3_0___5 = 842,
	FN_MSIOF0_SS1___9 = 843,
	FN_HRX2_A___4 = 844,
	FN_SSI_SCK4___4 = 845,
	FN_HCTS0_N_A___2 = 846,
	FN_BPFCLK_C___4 = 847,
	FN_SPEEDIN_A___5 = 848,
	FN_IP14_3_0___4 = 849,
	FN_SSI_SDATA0___4 = 850,
	FN_IP15_3_0___4 = 851,
	FN_SSI_WS5___4 = 852,
	FN_HTX0_B___2 = 853,
	FN_USB0_OVC_B = 854,
	FN_SDA2_D = 855,
	FN_IP12_7_4___5 = 856,
	FN_SCK2_A = 857,
	FN_HSCK0_A___2 = 858,
	FN_AUDIO_CLKB_A___4 = 859,
	FN_CTS1_N___7 = 860,
	FN_RIF0_CLK_A___4 = 861,
	FN_REMOCON_A___4 = 862,
	FN_SCIF_CLK_B___5 = 863,
	FN_IP13_7_4___5 = 864,
	FN_MSIOF0_SS2___9 = 865,
	FN_HTX2_A___4 = 866,
	FN_SSI_WS4___4 = 867,
	FN_HRTS0_N_A___2 = 868,
	FN_FMIN_C___4 = 869,
	FN_BPFCLK_A___4 = 870,
	FN_IP14_7_4___4 = 871,
	FN_SSI_SDATA1 = 872,
	FN_AUDIO_CLKC_B___4 = 873,
	FN_PWM0_B___4 = 874,
	FN_IP15_7_4___4 = 875,
	FN_SSI_SDATA5___4 = 876,
	FN_HSCK0_B___2 = 877,
	FN_AUDIO_CLKB_C = 878,
	FN_TPU0TO0___5 = 879,
	FN_IP12_11_8___5 = 880,
	FN_TX2_A___4 = 881,
	FN_HRX0_A___2 = 882,
	FN_AUDIO_CLKOUT2_A___4 = 883,
	FN_SCL1_A___4 = 884,
	FN_FSO_CFE_0_N_A___2 = 885,
	FN_TS_SDEN1 = 886,
	FN_IP13_11_8___4 = 887,
	FN_SSI_SDATA9 = 888,
	FN_AUDIO_CLKC_A___4 = 889,
	FN_SCK1___6 = 890,
	FN_IP14_11_8___4 = 891,
	FN_SSI_SDATA2 = 892,
	FN_AUDIO_CLKOUT2_B___4 = 893,
	FN_SSI_SCK9_A___4 = 894,
	FN_PWM1_B___8 = 895,
	FN_IP15_11_8___4 = 896,
	FN_SSI_SCK6___4 = 897,
	FN_HSCK2_A___4 = 898,
	FN_AUDIO_CLKC_C = 899,
	FN_TPU0TO1___5 = 900,
	FN_FSO_CFE_0_N_B___2 = 901,
	FN_SIM0_RST_B___4 = 902,
	FN_IP12_15_12___5 = 903,
	FN_RX2_A___4 = 904,
	FN_HTX0_A___2 = 905,
	FN_AUDIO_CLKOUT3_A___4 = 906,
	FN_SDA1_A___4 = 907,
	FN_FSO_CFE_1_N_A___2 = 908,
	FN_TS_SPSYNC1 = 909,
	FN_IP13_15_12___4 = 910,
	FN_MLB_CLK___5 = 911,
	FN_RX0_B___2 = 912,
	FN_RIF0_D0_A___4 = 913,
	FN_SCL1_B___4 = 914,
	FN_TCLK1_B___8 = 915,
	FN_SIM0_RST_A___4 = 916,
	FN_IP14_15_12___4 = 917,
	FN_SSI_SCK349___4 = 918,
	FN_PWM2_C___3 = 919,
	FN_IP15_15_12___4 = 920,
	FN_SSI_WS6___4 = 921,
	FN_HCTS2_N_A___4 = 922,
	FN_AUDIO_CLKOUT2_C = 923,
	FN_TPU0TO2___5 = 924,
	FN_SDA1_D = 925,
	FN_FSO_CFE_1_N_B___2 = 926,
	FN_SIM0_D_B___4 = 927,
	FN_IP12_19_16___5 = 928,
	FN_MSIOF0_SCK___9 = 929,
	FN_SSI_SCK78___4 = 930,
	FN_IP13_19_16___4 = 931,
	FN_MLB_SIG___5 = 932,
	FN_SCK0_B___2 = 933,
	FN_RIF0_D1_A___4 = 934,
	FN_SDA1_B___4 = 935,
	FN_TCLK2_B___8 = 936,
	FN_SIM0_D_A___4 = 937,
	FN_IP14_19_16___4 = 938,
	FN_SSI_WS349___4 = 939,
	FN_PWM3_C___3 = 940,
	FN_IP15_19_16___4 = 941,
	FN_SSI_SDATA6___4 = 942,
	FN_HRTS2_N_A___4 = 943,
	FN_AUDIO_CLKOUT3_C = 944,
	FN_TPU0TO3___5 = 945,
	FN_SCL1_D = 946,
	FN_FSO_TOE_N_B___2 = 947,
	FN_SIM0_CLK_B___4 = 948,
	FN_IP12_23_20___5 = 949,
	FN_MSIOF0_RXD___9 = 950,
	FN_SSI_WS78___4 = 951,
	FN_TX2_B___4 = 952,
	FN_IP13_23_20___4 = 953,
	FN_MLB_DAT___5 = 954,
	FN_TX0_B___2 = 955,
	FN_RIF0_SYNC_A___4 = 956,
	FN_SIM0_CLK_A___4 = 957,
	FN_IP14_23_20___4 = 958,
	FN_SSI_SDATA3___5 = 959,
	FN_AUDIO_CLKOUT1_C = 960,
	FN_AUDIO_CLKB_B___4 = 961,
	FN_PWM4_B___5 = 962,
	FN_IP15_23_20___4 = 963,
	FN_AUDIO_CLKA___2 = 964,
	FN_IP12_27_24___5 = 965,
	FN_MSIOF0_TXD___9 = 966,
	FN_SSI_SDATA7___4 = 967,
	FN_RX2_B___4 = 968,
	FN_IP13_27_24___4 = 969,
	FN_SSI_SCK01239___4 = 970,
	FN_IP14_27_24___4 = 971,
	FN_SSI_SDATA4___4 = 972,
	FN_SSI_WS9_A___4 = 973,
	FN_PWM5_B___4 = 974,
	FN_IP15_27_24___4 = 975,
	FN_USB30_PWEN___4 = 976,
	FN_USB0_PWEN_A = 977,
	FN_IP12_31_28___5 = 978,
	FN_MSIOF0_SYNC___9 = 979,
	FN_AUDIO_CLKOUT_B___4 = 980,
	FN_SSI_SDATA8___4 = 981,
	FN_IP13_31_28___4 = 982,
	FN_SSI_WS01239___4 = 983,
	FN_IP14_31_28___4 = 984,
	FN_SSI_SCK5___4 = 985,
	FN_HRX0_B___2 = 986,
	FN_USB0_PWEN_B = 987,
	FN_SCL2_D = 988,
	FN_PWM6_B___4 = 989,
	FN_IP15_31_28___4 = 990,
	FN_USB30_OVC___4 = 991,
	FN_USB0_OVC_A = 992,
	FN_FSO_TOE_N_A___2 = 993,
	FN_SEL_SIMCARD_0___4 = 994,
	FN_SEL_SIMCARD_1___4 = 995,
	FN_SEL_ADGB_0___4 = 996,
	FN_SEL_ADGB_2 = 997,
	FN_SEL_ADGB_1___4 = 998,
	FN_SEL_SSI2_0___4 = 999,
	FN_SEL_SSI2_1___4 = 1000,
	FN_SEL_TIMER_TMU_0___3 = 1001,
	FN_SEL_TIMER_TMU_1___3 = 1002,
	FN_SEL_DRIF0_0___4 = 1003,
	FN_SEL_DRIF0_1___4 = 1004,
	FN_SEL_USB_20_CH0_0 = 1005,
	FN_SEL_USB_20_CH0_1 = 1006,
	FN_SEL_FM_0___4 = 1007,
	FN_SEL_FM_2___4 = 1008,
	FN_SEL_FM_1___4 = 1009,
	FN_SEL_DRIF2_0___4 = 1010,
	FN_SEL_DRIF2_1___4 = 1011,
	FN_SEL_FSO_0 = 1012,
	FN_SEL_FSO_1 = 1013,
	FN_SEL_DRIF3_0___4 = 1014,
	FN_SEL_DRIF3_1___4 = 1015,
	FN_SEL_HSCIF0_0___2 = 1016,
	FN_SEL_HSCIF0_1___2 = 1017,
	FN_SEL_HSCIF3_0___5 = 1018,
	FN_SEL_HSCIF3_4 = 1019,
	FN_SEL_HSCIF3_2___4 = 1020,
	FN_SEL_HSCIF3_1___5 = 1021,
	FN_SEL_HSCIF3_3___4 = 1022,
	FN_SEL_HSCIF1_0___4 = 1023,
	FN_SEL_HSCIF1_1___4 = 1024,
	FN_SEL_HSCIF2_0___4 = 1025,
	FN_SEL_HSCIF2_1___4 = 1026,
	FN_SEL_I2C1_0___5 = 1027,
	FN_SEL_I2C1_2 = 1028,
	FN_SEL_I2C1_1___4 = 1029,
	FN_SEL_I2C1_3___2 = 1030,
	FN_SEL_HSCIF4_0___4 = 1031,
	FN_SEL_HSCIF4_4 = 1032,
	FN_SEL_HSCIF4_2 = 1033,
	FN_SEL_HSCIF4_1___4 = 1034,
	FN_SEL_HSCIF4_3 = 1035,
	FN_SEL_I2C2_0___6 = 1036,
	FN_SEL_I2C2_4 = 1037,
	FN_SEL_I2C2_2 = 1038,
	FN_SEL_I2C2_1___5 = 1039,
	FN_SEL_I2C2_3___2 = 1040,
	FN_SEL_I2C6_0___4 = 1041,
	FN_SEL_I2C6_1___4 = 1042,
	FN_SEL_I2C7_0 = 1043,
	FN_SEL_I2C7_1 = 1044,
	FN_SEL_NDF_0___3 = 1045,
	FN_SEL_NDF_1___3 = 1046,
	FN_SEL_MSIOF2_0___5 = 1047,
	FN_SEL_MSIOF2_1___5 = 1048,
	FN_SEL_PWM0_0___3 = 1049,
	FN_SEL_PWM0_1___3 = 1050,
	FN_SEL_MSIOF3_0___5 = 1051,
	FN_SEL_MSIOF3_1___5 = 1052,
	FN_SEL_PWM1_0___6 = 1053,
	FN_SEL_PWM1_1___6 = 1054,
	FN_SEL_SCIF3_0___5 = 1055,
	FN_SEL_SCIF3_2 = 1056,
	FN_SEL_SCIF3_1___5 = 1057,
	FN_SEL_PWM2_0___6 = 1058,
	FN_SEL_PWM2_2___2 = 1059,
	FN_SEL_PWM2_1___6 = 1060,
	FN_SEL_SCIF4_0___5 = 1061,
	FN_SEL_SCIF4_2___4 = 1062,
	FN_SEL_SCIF4_1___5 = 1063,
	FN_SEL_PWM3_0___6 = 1064,
	FN_SEL_PWM3_2___2 = 1065,
	FN_SEL_PWM3_1___6 = 1066,
	FN_SEL_SCIF5_0___5 = 1067,
	FN_SEL_SCIF5_2 = 1068,
	FN_SEL_SCIF5_1___5 = 1069,
	FN_SEL_PWM4_0___5 = 1070,
	FN_SEL_PWM4_1___5 = 1071,
	FN_SEL_PWM5_0___4 = 1072,
	FN_SEL_PWM5_1___4 = 1073,
	FN_SEL_VIN4_0___4 = 1074,
	FN_SEL_VIN4_1___4 = 1075,
	FN_SEL_PWM6_0___4 = 1076,
	FN_SEL_PWM6_1___4 = 1077,
	FN_SEL_VIN5_0 = 1078,
	FN_SEL_VIN5_1 = 1079,
	FN_SEL_REMOCON_0___4 = 1080,
	FN_SEL_REMOCON_2 = 1081,
	FN_SEL_REMOCON_1___4 = 1082,
	FN_SEL_ADGC_0___4 = 1083,
	FN_SEL_ADGC_2 = 1084,
	FN_SEL_ADGC_1___4 = 1085,
	FN_SEL_SCIF_0___4 = 1086,
	FN_SEL_SCIF_1___4 = 1087,
	FN_SEL_SSI9_0___4 = 1088,
	FN_SEL_SSI9_1___4 = 1089,
	FN_SEL_SCIF0_0___2 = 1090,
	FN_SEL_SCIF0_1___2 = 1091,
	FN_SEL_SCIF2_0___4 = 1092,
	FN_SEL_SCIF2_1___4 = 1093,
	FN_SEL_SPEED_PULSE_IF_0 = 1094,
	FN_SEL_SPEED_PULSE_IF_2 = 1095,
	FN_SEL_SPEED_PULSE_IF_1 = 1096,
	PINMUX_FUNCTION_END___9 = 1097,
	PINMUX_MARK_BEGIN___9 = 1098,
	AVB_PHY_INT_MARK___5 = 1099,
	CLKOUT_MARK___5 = 1100,
	AVB_RD3_MARK___5 = 1101,
	AVB_RXC_MARK___5 = 1102,
	AVB_RX_CTL_MARK___5 = 1103,
	QSPI0_SSL_MARK___9 = 1104,
	IP0_3_0_MARK___6 = 1105,
	QSPI0_SPCLK_MARK___9 = 1106,
	HSCK4_A_MARK = 1107,
	IP1_3_0_MARK___6 = 1108,
	QSPI1_IO2_MARK___9 = 1109,
	RIF2_D1_A_MARK___4 = 1110,
	HTX3_C_MARK___4 = 1111,
	VI4_DATA3_A_MARK___4 = 1112,
	IP2_3_0_MARK___6 = 1113,
	AVB_TXCREFCLK_MARK___5 = 1114,
	IP3_3_0_MARK___6 = 1115,
	A1_MARK___5 = 1116,
	IRQ1_MARK___6 = 1117,
	PWM3_A_MARK___8 = 1118,
	DU_DOTCLKIN1_MARK___5 = 1119,
	VI5_DATA0_A_MARK = 1120,
	DU_DISP_CDE_MARK___2 = 1121,
	SDA6_B_MARK___4 = 1122,
	IETX_MARK = 1123,
	QCPV_QDE_MARK___5 = 1124,
	IP0_7_4_MARK___6 = 1125,
	QSPI0_MOSI_IO0_MARK___9 = 1126,
	HCTS4_N_A_MARK = 1127,
	IP1_7_4_MARK___6 = 1128,
	QSPI1_IO3_MARK___9 = 1129,
	RIF3_CLK_A_MARK___4 = 1130,
	HRX3_C_MARK___4 = 1131,
	VI4_DATA4_A_MARK___4 = 1132,
	IP2_7_4_MARK___6 = 1133,
	AVB_MDIO_MARK___5 = 1134,
	IP3_7_4_MARK___6 = 1135,
	A2_MARK___5 = 1136,
	IRQ2_MARK___6 = 1137,
	AVB_AVTP_PPS_MARK___5 = 1138,
	VI4_CLKENB_MARK___5 = 1139,
	VI5_DATA1_A_MARK = 1140,
	DU_DISP_MARK___6 = 1141,
	SCL6_B_MARK___4 = 1142,
	QSTVB_QVE_MARK___5 = 1143,
	IP0_11_8_MARK___6 = 1144,
	QSPI0_MISO_IO1_MARK___9 = 1145,
	HRTS4_N_A_MARK = 1146,
	IP1_11_8_MARK___6 = 1147,
	QSPI1_SSL_MARK___9 = 1148,
	RIF3_SYNC_A_MARK___4 = 1149,
	HSCK3_C_MARK = 1150,
	VI4_DATA5_A_MARK___4 = 1151,
	IP2_11_8_MARK___6 = 1152,
	AVB_MDC_MARK___5 = 1153,
	IP3_11_8_MARK___6 = 1154,
	A3_MARK___5 = 1155,
	CTS4_N_A_MARK___4 = 1156,
	PWM4_A_MARK___5 = 1157,
	VI4_DATA12_MARK___5 = 1158,
	DU_DOTCLKOUT0_MARK___5 = 1159,
	HTX3_D_MARK___4 = 1160,
	IECLK_MARK = 1161,
	LCDOUT12_MARK___5 = 1162,
	IP0_15_12_MARK___6 = 1163,
	QSPI0_IO2_MARK___9 = 1164,
	HTX4_A_MARK___4 = 1165,
	IP1_15_12_MARK___6 = 1166,
	RPC_INT_N_MARK___6 = 1167,
	RIF3_D0_A_MARK___4 = 1168,
	HCTS3_N_C_MARK = 1169,
	VI4_DATA6_A_MARK___4 = 1170,
	IP2_15_12_MARK___6 = 1171,
	BS_N_MARK___5 = 1172,
	PWM0_A_MARK___4 = 1173,
	AVB_MAGIC_MARK___5 = 1174,
	VI4_CLK_MARK___5 = 1175,
	TX3_C_MARK = 1176,
	VI5_CLK_B_MARK = 1177,
	IP3_15_12_MARK___6 = 1178,
	A4_MARK___5 = 1179,
	RTS4_N_A_MARK___4 = 1180,
	MSIOF3_SYNC_B_MARK___5 = 1181,
	VI4_DATA8_MARK___5 = 1182,
	PWM2_B_MARK___7 = 1183,
	DU_DG4_MARK___6 = 1184,
	RIF2_CLK_B_MARK___4 = 1185,
	IP0_19_16_MARK___6 = 1186,
	QSPI0_IO3_MARK___9 = 1187,
	HRX4_A_MARK___4 = 1188,
	IP1_19_16_MARK___6 = 1189,
	RPC_RESET_N_MARK___6 = 1190,
	RIF3_D1_A_MARK___4 = 1191,
	HRTS3_N_C_MARK = 1192,
	VI4_DATA7_A_MARK___4 = 1193,
	IP2_19_16_MARK___6 = 1194,
	RD_N_MARK___5 = 1195,
	PWM1_A_MARK___8 = 1196,
	AVB_LINK_MARK___5 = 1197,
	VI4_FIELD_MARK___5 = 1198,
	RX3_C_MARK = 1199,
	FSCLKST2_N_A_MARK___3 = 1200,
	VI5_DATA0_B_MARK = 1201,
	IP3_19_16_MARK___6 = 1202,
	A5_MARK___5 = 1203,
	SCK4_A_MARK___5 = 1204,
	MSIOF3_SCK_B_MARK___5 = 1205,
	VI4_DATA9_MARK___5 = 1206,
	PWM3_B_MARK___8 = 1207,
	RIF2_SYNC_B_MARK___4 = 1208,
	QPOLA_MARK___5 = 1209,
	IP0_23_20_MARK___6 = 1210,
	QSPI1_SPCLK_MARK___9 = 1211,
	RIF2_CLK_A_MARK___4 = 1212,
	HSCK4_B_MARK = 1213,
	VI4_DATA0_A_MARK___4 = 1214,
	IP1_23_20_MARK___6 = 1215,
	AVB_RD0_MARK___5 = 1216,
	IP2_23_20_MARK___6 = 1217,
	RD_WR_N_MARK___5 = 1218,
	SCL7_A_MARK = 1219,
	AVB_AVTP_MATCH_MARK___2 = 1220,
	VI4_VSYNC_N_MARK___5 = 1221,
	TX5_B_MARK___5 = 1222,
	SCK3_C_MARK = 1223,
	PWM5_A_MARK___4 = 1224,
	IP3_23_20_MARK___6 = 1225,
	A6_MARK___5 = 1226,
	RX4_A_MARK___5 = 1227,
	MSIOF3_RXD_B_MARK___5 = 1228,
	VI4_DATA10_MARK___5 = 1229,
	RIF2_D0_B_MARK___4 = 1230,
	IP0_27_24_MARK___6 = 1231,
	QSPI1_MOSI_IO0_MARK___9 = 1232,
	RIF2_SYNC_A_MARK___4 = 1233,
	HTX4_B_MARK___4 = 1234,
	VI4_DATA1_A_MARK___4 = 1235,
	IP1_27_24_MARK___6 = 1236,
	AVB_RD1_MARK___5 = 1237,
	IP2_27_24_MARK___6 = 1238,
	EX_WAIT0_MARK___2 = 1239,
	SDA7_A_MARK = 1240,
	AVB_AVTP_CAPTURE_MARK___2 = 1241,
	VI4_HSYNC_N_MARK___5 = 1242,
	RX5_B_MARK___5 = 1243,
	PWM6_A_MARK___4 = 1244,
	IP3_27_24_MARK___6 = 1245,
	A7_MARK___5 = 1246,
	TX4_A_MARK___5 = 1247,
	MSIOF3_TXD_B_MARK___5 = 1248,
	VI4_DATA11_MARK___5 = 1249,
	RIF2_D1_B_MARK___4 = 1250,
	IP0_31_28_MARK___6 = 1251,
	QSPI1_MISO_IO1_MARK___9 = 1252,
	RIF2_D0_A_MARK___4 = 1253,
	HRX4_B_MARK___4 = 1254,
	VI4_DATA2_A_MARK___4 = 1255,
	IP1_31_28_MARK___6 = 1256,
	AVB_RD2_MARK___5 = 1257,
	IP2_31_28_MARK___6 = 1258,
	A0_MARK___5 = 1259,
	IRQ0_MARK___6 = 1260,
	PWM2_A_MARK___7 = 1261,
	MSIOF3_SS1_B_MARK___5 = 1262,
	VI5_CLK_A_MARK = 1263,
	DU_CDE_MARK___6 = 1264,
	HRX3_D_MARK___4 = 1265,
	IERX_MARK = 1266,
	QSTB_QHE_MARK___5 = 1267,
	IP3_31_28_MARK___6 = 1268,
	A8_MARK___5 = 1269,
	SDA6_A_MARK___4 = 1270,
	RX3_B_MARK___7 = 1271,
	HRX4_C_MARK = 1272,
	VI5_HSYNC_N_A_MARK = 1273,
	DU_HSYNC_MARK___2 = 1274,
	VI4_DATA0_B_MARK___4 = 1275,
	QSTH_QHS_MARK___5 = 1276,
	IP4_3_0_MARK___6 = 1277,
	A9_MARK___5 = 1278,
	TX5_A_MARK___5 = 1279,
	IRQ3_MARK___6 = 1280,
	VI4_DATA16_MARK___5 = 1281,
	VI5_VSYNC_N_A_MARK = 1282,
	DU_DG7_MARK___6 = 1283,
	LCDOUT15_MARK___5 = 1284,
	IP5_3_0_MARK___6 = 1285,
	A17_MARK___5 = 1286,
	MSIOF1_RXD_MARK___6 = 1287,
	VI4_DATA20_MARK___5 = 1288,
	VI5_DATA6_A_MARK = 1289,
	DU_DB6_MARK___6 = 1290,
	LCDOUT6_MARK___5 = 1291,
	IP6_3_0_MARK___6 = 1292,
	D3_MARK___5 = 1293,
	MSIOF3_TXD_A_MARK___5 = 1294,
	TX5_C_MARK = 1295,
	VI5_DATA15_A_MARK = 1296,
	DU_DR4_MARK___6 = 1297,
	TX4_C_MARK___4 = 1298,
	LCDOUT20_MARK___5 = 1299,
	IP7_3_0_MARK___6 = 1300,
	D11_MARK___5 = 1301,
	MSIOF2_TXD_A_MARK___4 = 1302,
	VI5_DATA11_A_MARK = 1303,
	DU_DG2_MARK___6 = 1304,
	RIF3_D1_B_MARK___4 = 1305,
	HRTS3_N_E_MARK = 1306,
	LCDOUT10_MARK___5 = 1307,
	IP4_7_4_MARK___6 = 1308,
	A10_MARK___5 = 1309,
	IRQ4_MARK___6 = 1310,
	MSIOF2_SYNC_B_MARK___5 = 1311,
	VI4_DATA13_MARK___5 = 1312,
	VI5_FIELD_A_MARK = 1313,
	DU_DG5_MARK___6 = 1314,
	FSCLKST2_N_B_MARK___3 = 1315,
	LCDOUT13_MARK___5 = 1316,
	IP5_7_4_MARK___6 = 1317,
	A18_MARK___5 = 1318,
	MSIOF1_TXD_MARK___6 = 1319,
	VI4_DATA21_MARK___5 = 1320,
	VI5_DATA7_A_MARK = 1321,
	DU_DB0_MARK___6 = 1322,
	HRX4_E_MARK = 1323,
	LCDOUT0_MARK___5 = 1324,
	IP6_7_4_MARK___6 = 1325,
	D4_MARK___5 = 1326,
	CANFD1_TX_MARK___8 = 1327,
	HSCK3_B_MARK___4 = 1328,
	CAN1_TX_MARK___4 = 1329,
	RTS3_N_A_MARK___3 = 1330,
	MSIOF3_SS2_A_MARK___5 = 1331,
	VI5_DATA1_B_MARK = 1332,
	IP7_7_4_MARK___6 = 1333,
	D12_MARK___5 = 1334,
	CANFD0_TX_MARK___4 = 1335,
	TX4_B_MARK___5 = 1336,
	CAN0_TX_MARK = 1337,
	VI5_DATA8_A_MARK = 1338,
	VI5_DATA3_B_MARK = 1339,
	IP4_11_8_MARK___6 = 1340,
	A11_MARK___5 = 1341,
	SCL6_A_MARK___4 = 1342,
	TX3_B_MARK___7 = 1343,
	HTX4_C_MARK = 1344,
	DU_VSYNC_MARK___2 = 1345,
	VI4_DATA1_B_MARK___4 = 1346,
	QSTVA_QVS_MARK___5 = 1347,
	IP5_11_8_MARK___6 = 1348,
	A19_MARK___5 = 1349,
	MSIOF1_SCK_MARK___6 = 1350,
	VI4_DATA22_MARK___5 = 1351,
	VI5_DATA2_A_MARK = 1352,
	DU_DB1_MARK___6 = 1353,
	HTX4_E_MARK = 1354,
	LCDOUT1_MARK___5 = 1355,
	IP6_11_8_MARK___6 = 1356,
	D5_MARK___5 = 1357,
	RX3_A_MARK___7 = 1358,
	HRX3_B_MARK___7 = 1359,
	DU_DR5_MARK___6 = 1360,
	VI4_DATA4_B_MARK___4 = 1361,
	LCDOUT21_MARK___5 = 1362,
	IP7_11_8_MARK___6 = 1363,
	D13_MARK___5 = 1364,
	CANFD0_RX_MARK___4 = 1365,
	RX4_B_MARK___5 = 1366,
	CAN0_RX_MARK = 1367,
	VI5_DATA9_A_MARK = 1368,
	SCL7_B_MARK = 1369,
	VI5_DATA4_B_MARK = 1370,
	IP4_15_12_MARK___6 = 1371,
	A12_MARK___5 = 1372,
	RX5_A_MARK___5 = 1373,
	MSIOF2_SS2_B_MARK___4 = 1374,
	VI4_DATA17_MARK___5 = 1375,
	VI5_DATA3_A_MARK = 1376,
	DU_DG6_MARK___6 = 1377,
	LCDOUT14_MARK___5 = 1378,
	IP5_15_12_MARK___6 = 1379,
	CS0_N_MARK___5 = 1380,
	SCL5_MARK___7 = 1381,
	DU_DR0_MARK___6 = 1382,
	VI4_DATA2_B_MARK___4 = 1383,
	LCDOUT16_MARK___5 = 1384,
	IP6_15_12_MARK___6 = 1385,
	D6_MARK___5 = 1386,
	TX3_A_MARK___7 = 1387,
	HTX3_B_MARK___7 = 1388,
	DU_DR6_MARK___6 = 1389,
	VI4_DATA5_B_MARK___4 = 1390,
	LCDOUT22_MARK___5 = 1391,
	IP7_15_12_MARK___3 = 1392,
	D14_MARK___5 = 1393,
	CAN_CLK_MARK___7 = 1394,
	HRX3_A_MARK___7 = 1395,
	MSIOF2_SS2_A_MARK___4 = 1396,
	SDA7_B_MARK = 1397,
	VI5_DATA5_B_MARK = 1398,
	IP4_19_16_MARK___6 = 1399,
	A13_MARK___5 = 1400,
	SCK5_A_MARK___5 = 1401,
	MSIOF2_SCK_B_MARK___4 = 1402,
	VI4_DATA14_MARK___5 = 1403,
	HRX4_D_MARK = 1404,
	DU_DB2_MARK___6 = 1405,
	LCDOUT2_MARK___5 = 1406,
	IP5_19_16_MARK___6 = 1407,
	WE0_N_MARK___5 = 1408,
	SDA5_MARK___7 = 1409,
	DU_DR1_MARK___6 = 1410,
	VI4_DATA3_B_MARK___4 = 1411,
	LCDOUT17_MARK___5 = 1412,
	IP6_19_16_MARK___6 = 1413,
	D7_MARK___5 = 1414,
	CANFD1_RX_MARK___8 = 1415,
	IRQ5_MARK___8 = 1416,
	CAN1_RX_MARK___4 = 1417,
	CTS3_N_A_MARK___3 = 1418,
	VI5_DATA2_B_MARK = 1419,
	IP7_19_16_MARK___6 = 1420,
	D15_MARK___5 = 1421,
	MSIOF2_SS1_A_MARK___4 = 1422,
	HTX3_A_MARK___7 = 1423,
	MSIOF3_SS1_A_MARK___5 = 1424,
	DU_DG3_MARK___6 = 1425,
	LCDOUT11_MARK___5 = 1426,
	IP4_23_20_MARK___6 = 1427,
	A14_MARK___5 = 1428,
	MSIOF1_SS1_MARK___6 = 1429,
	MSIOF2_RXD_B_MARK___4 = 1430,
	VI4_DATA15_MARK___5 = 1431,
	HTX4_D_MARK = 1432,
	DU_DB3_MARK___6 = 1433,
	LCDOUT3_MARK___5 = 1434,
	IP5_23_20_MARK___6 = 1435,
	D0_MARK___5 = 1436,
	MSIOF3_SCK_A_MARK___5 = 1437,
	DU_DR2_MARK___6 = 1438,
	CTS4_N_C_MARK___4 = 1439,
	LCDOUT18_MARK___5 = 1440,
	IP6_23_20_MARK___6 = 1441,
	D8_MARK___5 = 1442,
	MSIOF2_SCK_A_MARK___4 = 1443,
	SCK4_B_MARK___5 = 1444,
	VI5_DATA12_A_MARK = 1445,
	DU_DR7_MARK___6 = 1446,
	RIF3_CLK_B_MARK___4 = 1447,
	HCTS3_N_E_MARK = 1448,
	LCDOUT23_MARK___5 = 1449,
	IP7_23_20_MARK___6 = 1450,
	SCL4_MARK___4 = 1451,
	CS1_N_A26_MARK = 1452,
	DU_DOTCLKIN0_MARK___4 = 1453,
	VI4_DATA6_B_MARK___4 = 1454,
	VI5_DATA6_B_MARK = 1455,
	QCLK_MARK___5 = 1456,
	IP4_27_24_MARK___6 = 1457,
	A15_MARK___5 = 1458,
	MSIOF1_SS2_MARK___6 = 1459,
	MSIOF2_TXD_B_MARK___4 = 1460,
	VI4_DATA18_MARK___5 = 1461,
	VI5_DATA4_A_MARK = 1462,
	DU_DB4_MARK___6 = 1463,
	LCDOUT4_MARK___5 = 1464,
	IP5_27_24_MARK___6 = 1465,
	D1_MARK___5 = 1466,
	MSIOF3_SYNC_A_MARK___5 = 1467,
	SCK3_A_MARK___4 = 1468,
	VI4_DATA23_MARK___5 = 1469,
	VI5_CLKENB_A_MARK = 1470,
	DU_DB7_MARK___6 = 1471,
	RTS4_N_C_MARK___4 = 1472,
	LCDOUT7_MARK___5 = 1473,
	IP6_27_24_MARK___6 = 1474,
	D9_MARK___5 = 1475,
	MSIOF2_SYNC_A_MARK___5 = 1476,
	VI5_DATA10_A_MARK = 1477,
	DU_DG0_MARK___6 = 1478,
	RIF3_SYNC_B_MARK___4 = 1479,
	HRX3_E_MARK = 1480,
	LCDOUT8_MARK___5 = 1481,
	IP7_27_24_MARK___6 = 1482,
	SDA4_MARK___4 = 1483,
	WE1_N_MARK___5 = 1484,
	VI4_DATA7_B_MARK___4 = 1485,
	VI5_DATA7_B_MARK = 1486,
	QPOLB_MARK___5 = 1487,
	IP4_31_28_MARK___6 = 1488,
	A16_MARK___5 = 1489,
	MSIOF1_SYNC_MARK___6 = 1490,
	MSIOF2_SS1_B_MARK___4 = 1491,
	VI4_DATA19_MARK___5 = 1492,
	VI5_DATA5_A_MARK = 1493,
	DU_DB5_MARK___6 = 1494,
	LCDOUT5_MARK___5 = 1495,
	IP5_31_28_MARK___6 = 1496,
	D2_MARK___5 = 1497,
	MSIOF3_RXD_A_MARK___5 = 1498,
	RX5_C_MARK = 1499,
	VI5_DATA14_A_MARK = 1500,
	DU_DR3_MARK___6 = 1501,
	RX4_C_MARK___4 = 1502,
	LCDOUT19_MARK___5 = 1503,
	IP6_31_28_MARK___6 = 1504,
	D10_MARK___5 = 1505,
	MSIOF2_RXD_A_MARK___4 = 1506,
	VI5_DATA13_A_MARK = 1507,
	DU_DG1_MARK___6 = 1508,
	RIF3_D0_B_MARK___4 = 1509,
	HTX3_E_MARK = 1510,
	LCDOUT9_MARK___5 = 1511,
	IP7_31_28_MARK___6 = 1512,
	SD0_CLK_MARK___4 = 1513,
	NFDATA8_MARK___5 = 1514,
	SCL1_C_MARK = 1515,
	HSCK1_B_MARK___6 = 1516,
	SDA2_E_MARK = 1517,
	FMCLK_B_MARK___4 = 1518,
	IP8_3_0_MARK___6 = 1519,
	SD0_CMD_MARK___4 = 1520,
	NFDATA9_MARK___5 = 1521,
	HRX1_B_MARK___6 = 1522,
	SPEEDIN_B_MARK___5 = 1523,
	IP9_3_0_MARK___6 = 1524,
	SD1_DAT1_MARK___4 = 1525,
	NFCE_N_B_MARK___4 = 1526,
	IP10_3_0_MARK___6 = 1527,
	SD3_DAT3_MARK___4 = 1528,
	NFDATA3_MARK___5 = 1529,
	IP11_3_0_MARK___5 = 1530,
	SD1_CD_MARK___4 = 1531,
	NFCE_N_A_MARK___4 = 1532,
	SSI_SCK1_MARK = 1533,
	RIF0_D1_B_MARK___4 = 1534,
	TS_SDEN0_MARK = 1535,
	IP8_7_4_MARK___6 = 1536,
	SD0_DAT0_MARK___4 = 1537,
	NFDATA10_MARK___5 = 1538,
	HTX1_B_MARK___6 = 1539,
	REMOCON_B_MARK___4 = 1540,
	IP9_7_4_MARK___6 = 1541,
	SD1_DAT2_MARK___4 = 1542,
	NFALE_B_MARK = 1543,
	IP10_7_4_MARK___6 = 1544,
	SD3_DAT4_MARK___4 = 1545,
	NFDATA4_MARK___5 = 1546,
	IP11_7_4_MARK___5 = 1547,
	SD1_WP_MARK___4 = 1548,
	NFWP_N_A_MARK___4 = 1549,
	SSI_WS1_MARK = 1550,
	RIF0_SYNC_B_MARK___4 = 1551,
	TS_SPSYNC0_MARK = 1552,
	IP8_11_8_MARK___6 = 1553,
	SD0_DAT1_MARK___4 = 1554,
	NFDATA11_MARK___5 = 1555,
	SDA2_C_MARK = 1556,
	HCTS1_N_B_MARK___6 = 1557,
	FMIN_B_MARK___4 = 1558,
	IP9_11_8_MARK___6 = 1559,
	SD1_DAT3_MARK___4 = 1560,
	NFRB_N_B_MARK___4 = 1561,
	IP10_11_8_MARK___6 = 1562,
	SD3_DAT5_MARK___4 = 1563,
	NFDATA5_MARK___5 = 1564,
	IP11_11_8_MARK___5 = 1565,
	RX0_A_MARK___2 = 1566,
	HRX1_A_MARK___6 = 1567,
	SSI_SCK2_A_MARK___4 = 1568,
	RIF1_SYNC_MARK = 1569,
	TS_SCK1_MARK = 1570,
	IP8_15_12_MARK___6 = 1571,
	SD0_DAT2_MARK___4 = 1572,
	NFDATA12_MARK___5 = 1573,
	SCL2_C_MARK = 1574,
	HRTS1_N_B_MARK___6 = 1575,
	BPFCLK_B_MARK___4 = 1576,
	IP9_15_12_MARK___6 = 1577,
	SD3_CLK_MARK___4 = 1578,
	NFWE_N_MARK___5 = 1579,
	IP10_15_12_MARK___6 = 1580,
	SD3_DAT6_MARK___4 = 1581,
	NFDATA6_MARK___5 = 1582,
	IP11_15_12_MARK___5 = 1583,
	TX0_A_MARK___2 = 1584,
	HTX1_A_MARK___6 = 1585,
	SSI_WS2_A_MARK___4 = 1586,
	RIF1_D0_MARK = 1587,
	TS_SDAT1_MARK = 1588,
	IP8_19_16_MARK___6 = 1589,
	SD0_DAT3_MARK___4 = 1590,
	NFDATA13_MARK___5 = 1591,
	SDA1_C_MARK = 1592,
	SCL2_E_MARK = 1593,
	SPEEDIN_C_MARK = 1594,
	REMOCON_C_MARK = 1595,
	IP9_19_16_MARK___6 = 1596,
	SD3_CMD_MARK___4 = 1597,
	NFRE_N_MARK___5 = 1598,
	IP10_19_16_MARK___6 = 1599,
	SD3_DAT7_MARK___4 = 1600,
	NFDATA7_MARK___5 = 1601,
	IP11_19_16_MARK___5 = 1602,
	CTS0_N_A_MARK = 1603,
	NFDATA14_A_MARK___4 = 1604,
	AUDIO_CLKOUT_A_MARK___4 = 1605,
	RIF1_D1_MARK = 1606,
	SCIF_CLK_A_MARK___5 = 1607,
	FMCLK_A_MARK___4 = 1608,
	IP8_23_20_MARK___6 = 1609,
	SD1_CLK_MARK___4 = 1610,
	NFDATA14_B_MARK___4 = 1611,
	IP9_23_20_MARK___6 = 1612,
	SD3_DAT0_MARK___4 = 1613,
	NFDATA0_MARK___5 = 1614,
	IP10_23_20_MARK___5 = 1615,
	SD3_DS_MARK___4 = 1616,
	NFCLE_MARK___5 = 1617,
	IP11_23_20_MARK___5 = 1618,
	RTS0_N_A_MARK = 1619,
	NFDATA15_A_MARK___4 = 1620,
	AUDIO_CLKOUT1_A_MARK___4 = 1621,
	RIF1_CLK_MARK = 1622,
	SCL2_A_MARK___5 = 1623,
	FMIN_A_MARK___4 = 1624,
	IP8_27_24_MARK___6 = 1625,
	SD1_CMD_MARK___4 = 1626,
	NFDATA15_B_MARK___4 = 1627,
	IP9_27_24_MARK___6 = 1628,
	SD3_DAT1_MARK___4 = 1629,
	NFDATA1_MARK___5 = 1630,
	IP10_27_24_MARK___5 = 1631,
	SD0_CD_MARK___4 = 1632,
	NFALE_A_MARK = 1633,
	SD3_CD_MARK___4 = 1634,
	RIF0_CLK_B_MARK___4 = 1635,
	SCL2_B_MARK___5 = 1636,
	TCLK1_A_MARK___8 = 1637,
	SSI_SCK2_B_MARK___4 = 1638,
	TS_SCK0_MARK = 1639,
	IP11_27_24_MARK___5 = 1640,
	SCK0_A_MARK___2 = 1641,
	HSCK1_A_MARK___6 = 1642,
	USB3HS0_ID_MARK = 1643,
	RTS1_N_MARK___7 = 1644,
	SDA2_A_MARK___5 = 1645,
	FMCLK_C_MARK___4 = 1646,
	USB0_ID_MARK = 1647,
	IP8_31_28_MARK___6 = 1648,
	SD1_DAT0_MARK___4 = 1649,
	NFWP_N_B_MARK___4 = 1650,
	IP9_31_28_MARK___6 = 1651,
	SD3_DAT2_MARK___4 = 1652,
	NFDATA2_MARK___5 = 1653,
	IP10_31_28_MARK___5 = 1654,
	SD0_WP_MARK___4 = 1655,
	NFRB_N_A_MARK___4 = 1656,
	SD3_WP_MARK___4 = 1657,
	RIF0_D0_B_MARK___4 = 1658,
	SDA2_B_MARK___5 = 1659,
	TCLK2_A_MARK___8 = 1660,
	SSI_WS2_B_MARK___4 = 1661,
	TS_SDAT0_MARK = 1662,
	IP11_31_28_MARK___5 = 1663,
	RX1_MARK___2 = 1664,
	HRX2_B_MARK___4 = 1665,
	SSI_SCK9_B_MARK___4 = 1666,
	AUDIO_CLKOUT1_B_MARK___4 = 1667,
	IP12_3_0_MARK___5 = 1668,
	TX1_MARK___2 = 1669,
	HTX2_B_MARK___4 = 1670,
	SSI_WS9_B_MARK___4 = 1671,
	AUDIO_CLKOUT3_B_MARK___4 = 1672,
	IP13_3_0_MARK___5 = 1673,
	MSIOF0_SS1_MARK___9 = 1674,
	HRX2_A_MARK___4 = 1675,
	SSI_SCK4_MARK___4 = 1676,
	HCTS0_N_A_MARK___2 = 1677,
	BPFCLK_C_MARK___4 = 1678,
	SPEEDIN_A_MARK___5 = 1679,
	IP14_3_0_MARK___4 = 1680,
	SSI_SDATA0_MARK___4 = 1681,
	IP15_3_0_MARK___4 = 1682,
	SSI_WS5_MARK___4 = 1683,
	HTX0_B_MARK___2 = 1684,
	USB0_OVC_B_MARK = 1685,
	SDA2_D_MARK = 1686,
	IP12_7_4_MARK___5 = 1687,
	SCK2_A_MARK = 1688,
	HSCK0_A_MARK___2 = 1689,
	AUDIO_CLKB_A_MARK___4 = 1690,
	CTS1_N_MARK___7 = 1691,
	RIF0_CLK_A_MARK___4 = 1692,
	REMOCON_A_MARK___4 = 1693,
	SCIF_CLK_B_MARK___5 = 1694,
	IP13_7_4_MARK___5 = 1695,
	MSIOF0_SS2_MARK___9 = 1696,
	HTX2_A_MARK___4 = 1697,
	SSI_WS4_MARK___4 = 1698,
	HRTS0_N_A_MARK___2 = 1699,
	FMIN_C_MARK___4 = 1700,
	BPFCLK_A_MARK___4 = 1701,
	IP14_7_4_MARK___4 = 1702,
	SSI_SDATA1_MARK = 1703,
	AUDIO_CLKC_B_MARK___4 = 1704,
	PWM0_B_MARK___4 = 1705,
	IP15_7_4_MARK___4 = 1706,
	SSI_SDATA5_MARK___4 = 1707,
	HSCK0_B_MARK___2 = 1708,
	AUDIO_CLKB_C_MARK = 1709,
	TPU0TO0_MARK___5 = 1710,
	IP12_11_8_MARK___5 = 1711,
	TX2_A_MARK___4 = 1712,
	HRX0_A_MARK___2 = 1713,
	AUDIO_CLKOUT2_A_MARK___4 = 1714,
	SCL1_A_MARK___4 = 1715,
	FSO_CFE_0_N_A_MARK___2 = 1716,
	TS_SDEN1_MARK = 1717,
	IP13_11_8_MARK___4 = 1718,
	SSI_SDATA9_MARK = 1719,
	AUDIO_CLKC_A_MARK___4 = 1720,
	SCK1_MARK___6 = 1721,
	IP14_11_8_MARK___4 = 1722,
	SSI_SDATA2_MARK = 1723,
	AUDIO_CLKOUT2_B_MARK___4 = 1724,
	SSI_SCK9_A_MARK___4 = 1725,
	PWM1_B_MARK___8 = 1726,
	IP15_11_8_MARK___4 = 1727,
	SSI_SCK6_MARK___4 = 1728,
	HSCK2_A_MARK___4 = 1729,
	AUDIO_CLKC_C_MARK = 1730,
	TPU0TO1_MARK___5 = 1731,
	FSO_CFE_0_N_B_MARK___2 = 1732,
	SIM0_RST_B_MARK___4 = 1733,
	IP12_15_12_MARK___5 = 1734,
	RX2_A_MARK___4 = 1735,
	HTX0_A_MARK___2 = 1736,
	AUDIO_CLKOUT3_A_MARK___4 = 1737,
	SDA1_A_MARK___4 = 1738,
	FSO_CFE_1_N_A_MARK___2 = 1739,
	TS_SPSYNC1_MARK = 1740,
	IP13_15_12_MARK___4 = 1741,
	MLB_CLK_MARK___5 = 1742,
	RX0_B_MARK___2 = 1743,
	RIF0_D0_A_MARK___4 = 1744,
	SCL1_B_MARK___4 = 1745,
	TCLK1_B_MARK___8 = 1746,
	SIM0_RST_A_MARK___4 = 1747,
	IP14_15_12_MARK___4 = 1748,
	SSI_SCK349_MARK___4 = 1749,
	PWM2_C_MARK___3 = 1750,
	IP15_15_12_MARK___4 = 1751,
	SSI_WS6_MARK___4 = 1752,
	HCTS2_N_A_MARK___4 = 1753,
	AUDIO_CLKOUT2_C_MARK = 1754,
	TPU0TO2_MARK___5 = 1755,
	SDA1_D_MARK = 1756,
	FSO_CFE_1_N_B_MARK___2 = 1757,
	SIM0_D_B_MARK___4 = 1758,
	IP12_19_16_MARK___5 = 1759,
	MSIOF0_SCK_MARK___9 = 1760,
	SSI_SCK78_MARK___4 = 1761,
	IP13_19_16_MARK___4 = 1762,
	MLB_SIG_MARK___5 = 1763,
	SCK0_B_MARK___2 = 1764,
	RIF0_D1_A_MARK___4 = 1765,
	SDA1_B_MARK___4 = 1766,
	TCLK2_B_MARK___8 = 1767,
	SIM0_D_A_MARK___4 = 1768,
	IP14_19_16_MARK___4 = 1769,
	SSI_WS349_MARK___4 = 1770,
	PWM3_C_MARK___3 = 1771,
	IP15_19_16_MARK___4 = 1772,
	SSI_SDATA6_MARK___4 = 1773,
	HRTS2_N_A_MARK___4 = 1774,
	AUDIO_CLKOUT3_C_MARK = 1775,
	TPU0TO3_MARK___5 = 1776,
	SCL1_D_MARK = 1777,
	FSO_TOE_N_B_MARK___2 = 1778,
	SIM0_CLK_B_MARK___4 = 1779,
	IP12_23_20_MARK___5 = 1780,
	MSIOF0_RXD_MARK___9 = 1781,
	SSI_WS78_MARK___4 = 1782,
	TX2_B_MARK___4 = 1783,
	IP13_23_20_MARK___4 = 1784,
	MLB_DAT_MARK___5 = 1785,
	TX0_B_MARK___2 = 1786,
	RIF0_SYNC_A_MARK___4 = 1787,
	SIM0_CLK_A_MARK___4 = 1788,
	IP14_23_20_MARK___4 = 1789,
	SSI_SDATA3_MARK___5 = 1790,
	AUDIO_CLKOUT1_C_MARK = 1791,
	AUDIO_CLKB_B_MARK___4 = 1792,
	PWM4_B_MARK___5 = 1793,
	IP15_23_20_MARK___4 = 1794,
	AUDIO_CLKA_MARK___2 = 1795,
	IP12_27_24_MARK___5 = 1796,
	MSIOF0_TXD_MARK___9 = 1797,
	SSI_SDATA7_MARK___4 = 1798,
	RX2_B_MARK___4 = 1799,
	IP13_27_24_MARK___4 = 1800,
	SSI_SCK01239_MARK___4 = 1801,
	IP14_27_24_MARK___4 = 1802,
	SSI_SDATA4_MARK___4 = 1803,
	SSI_WS9_A_MARK___4 = 1804,
	PWM5_B_MARK___4 = 1805,
	IP15_27_24_MARK___4 = 1806,
	USB30_PWEN_MARK___4 = 1807,
	USB0_PWEN_A_MARK = 1808,
	IP12_31_28_MARK___5 = 1809,
	MSIOF0_SYNC_MARK___9 = 1810,
	AUDIO_CLKOUT_B_MARK___4 = 1811,
	SSI_SDATA8_MARK___4 = 1812,
	IP13_31_28_MARK___4 = 1813,
	SSI_WS01239_MARK___4 = 1814,
	IP14_31_28_MARK___4 = 1815,
	SSI_SCK5_MARK___4 = 1816,
	HRX0_B_MARK___2 = 1817,
	USB0_PWEN_B_MARK = 1818,
	SCL2_D_MARK = 1819,
	PWM6_B_MARK___4 = 1820,
	IP15_31_28_MARK___4 = 1821,
	USB30_OVC_MARK___4 = 1822,
	USB0_OVC_A_MARK = 1823,
	FSO_TOE_N_A_MARK___2 = 1824,
	SEL_SIMCARD_0_MARK___4 = 1825,
	SEL_SIMCARD_1_MARK___4 = 1826,
	SEL_ADGB_0_MARK___4 = 1827,
	SEL_ADGB_2_MARK = 1828,
	SEL_ADGB_1_MARK___4 = 1829,
	SEL_SSI2_0_MARK___4 = 1830,
	SEL_SSI2_1_MARK___4 = 1831,
	SEL_TIMER_TMU_0_MARK___3 = 1832,
	SEL_TIMER_TMU_1_MARK___3 = 1833,
	SEL_DRIF0_0_MARK___4 = 1834,
	SEL_DRIF0_1_MARK___4 = 1835,
	SEL_USB_20_CH0_0_MARK = 1836,
	SEL_USB_20_CH0_1_MARK = 1837,
	SEL_FM_0_MARK___4 = 1838,
	SEL_FM_2_MARK___4 = 1839,
	SEL_FM_1_MARK___4 = 1840,
	SEL_DRIF2_0_MARK___4 = 1841,
	SEL_DRIF2_1_MARK___4 = 1842,
	SEL_FSO_0_MARK = 1843,
	SEL_FSO_1_MARK = 1844,
	SEL_DRIF3_0_MARK___4 = 1845,
	SEL_DRIF3_1_MARK___4 = 1846,
	SEL_HSCIF0_0_MARK___2 = 1847,
	SEL_HSCIF0_1_MARK___2 = 1848,
	SEL_HSCIF3_0_MARK___5 = 1849,
	SEL_HSCIF3_4_MARK = 1850,
	SEL_HSCIF3_2_MARK___4 = 1851,
	SEL_HSCIF3_1_MARK___5 = 1852,
	SEL_HSCIF3_3_MARK___4 = 1853,
	SEL_HSCIF1_0_MARK___4 = 1854,
	SEL_HSCIF1_1_MARK___4 = 1855,
	SEL_HSCIF2_0_MARK___4 = 1856,
	SEL_HSCIF2_1_MARK___4 = 1857,
	SEL_I2C1_0_MARK___5 = 1858,
	SEL_I2C1_2_MARK = 1859,
	SEL_I2C1_1_MARK___4 = 1860,
	SEL_I2C1_3_MARK___2 = 1861,
	SEL_HSCIF4_0_MARK___4 = 1862,
	SEL_HSCIF4_4_MARK = 1863,
	SEL_HSCIF4_2_MARK = 1864,
	SEL_HSCIF4_1_MARK___4 = 1865,
	SEL_HSCIF4_3_MARK = 1866,
	SEL_I2C2_0_MARK___6 = 1867,
	SEL_I2C2_4_MARK = 1868,
	SEL_I2C2_2_MARK = 1869,
	SEL_I2C2_1_MARK___5 = 1870,
	SEL_I2C2_3_MARK___2 = 1871,
	SEL_I2C6_0_MARK___4 = 1872,
	SEL_I2C6_1_MARK___4 = 1873,
	SEL_I2C7_0_MARK = 1874,
	SEL_I2C7_1_MARK = 1875,
	SEL_NDF_0_MARK___3 = 1876,
	SEL_NDF_1_MARK___3 = 1877,
	SEL_MSIOF2_0_MARK___5 = 1878,
	SEL_MSIOF2_1_MARK___5 = 1879,
	SEL_PWM0_0_MARK___3 = 1880,
	SEL_PWM0_1_MARK___3 = 1881,
	SEL_MSIOF3_0_MARK___5 = 1882,
	SEL_MSIOF3_1_MARK___5 = 1883,
	SEL_PWM1_0_MARK___6 = 1884,
	SEL_PWM1_1_MARK___6 = 1885,
	SEL_SCIF3_0_MARK___5 = 1886,
	SEL_SCIF3_2_MARK = 1887,
	SEL_SCIF3_1_MARK___5 = 1888,
	SEL_PWM2_0_MARK___6 = 1889,
	SEL_PWM2_2_MARK___2 = 1890,
	SEL_PWM2_1_MARK___6 = 1891,
	SEL_SCIF4_0_MARK___5 = 1892,
	SEL_SCIF4_2_MARK___4 = 1893,
	SEL_SCIF4_1_MARK___5 = 1894,
	SEL_PWM3_0_MARK___6 = 1895,
	SEL_PWM3_2_MARK___2 = 1896,
	SEL_PWM3_1_MARK___6 = 1897,
	SEL_SCIF5_0_MARK___5 = 1898,
	SEL_SCIF5_2_MARK = 1899,
	SEL_SCIF5_1_MARK___5 = 1900,
	SEL_PWM4_0_MARK___5 = 1901,
	SEL_PWM4_1_MARK___5 = 1902,
	SEL_PWM5_0_MARK___4 = 1903,
	SEL_PWM5_1_MARK___4 = 1904,
	SEL_VIN4_0_MARK___4 = 1905,
	SEL_VIN4_1_MARK___4 = 1906,
	SEL_PWM6_0_MARK___4 = 1907,
	SEL_PWM6_1_MARK___4 = 1908,
	SEL_VIN5_0_MARK = 1909,
	SEL_VIN5_1_MARK = 1910,
	SEL_REMOCON_0_MARK___4 = 1911,
	SEL_REMOCON_2_MARK = 1912,
	SEL_REMOCON_1_MARK___4 = 1913,
	SEL_ADGC_0_MARK___4 = 1914,
	SEL_ADGC_2_MARK = 1915,
	SEL_ADGC_1_MARK___4 = 1916,
	SEL_SCIF_0_MARK___4 = 1917,
	SEL_SCIF_1_MARK___4 = 1918,
	SEL_SSI9_0_MARK___4 = 1919,
	SEL_SSI9_1_MARK___4 = 1920,
	SEL_SCIF0_0_MARK___2 = 1921,
	SEL_SCIF0_1_MARK___2 = 1922,
	SEL_SCIF2_0_MARK___4 = 1923,
	SEL_SCIF2_1_MARK___4 = 1924,
	SEL_SPEED_PULSE_IF_0_MARK = 1925,
	SEL_SPEED_PULSE_IF_2_MARK = 1926,
	SEL_SPEED_PULSE_IF_1_MARK = 1927,
	AVB_TX_CTL_MARK___5 = 1928,
	AVB_TXC_MARK___5 = 1929,
	AVB_TD0_MARK___5 = 1930,
	AVB_TD1_MARK___5 = 1931,
	AVB_TD2_MARK___5 = 1932,
	AVB_TD3_MARK___5 = 1933,
	PRESETOUT_N_MARK = 1934,
	FSCLKST_N_MARK = 1935,
	TRST_N_MARK = 1936,
	TCK_MARK___4 = 1937,
	TMS_MARK___4 = 1938,
	TDI_MARK___4 = 1939,
	ASEBRK_MARK___4 = 1940,
	MLB_REF_MARK___4 = 1941,
	VDDQ_AVB0_MARK = 1942,
	PINMUX_MARK_END___9 = 1943,
};

enum {
	PINMUX_RESERVED___10 = 0,
	PINMUX_DATA_BEGIN___10 = 1,
	GP_0_0_DATA___10 = 2,
	GP_0_1_DATA___10 = 3,
	GP_0_2_DATA___10 = 4,
	GP_0_3_DATA___10 = 5,
	GP_0_4_DATA___10 = 6,
	GP_0_5_DATA___10 = 7,
	GP_0_6_DATA___10 = 8,
	GP_0_7_DATA___10 = 9,
	GP_0_8_DATA___10 = 10,
	GP_0_9_DATA___9 = 11,
	GP_0_10_DATA___9 = 12,
	GP_0_11_DATA___9 = 13,
	GP_0_12_DATA___9 = 14,
	GP_0_13_DATA___9 = 15,
	GP_0_14_DATA___9 = 16,
	GP_0_15_DATA___9 = 17,
	GP_0_16_DATA___6 = 18,
	GP_0_17_DATA___6 = 19,
	GP_0_18_DATA___5 = 20,
	GP_0_19_DATA___3 = 21,
	GP_0_20_DATA___3 = 22,
	GP_0_21_DATA___2 = 23,
	GP_0_22_DATA = 24,
	GP_0_23_DATA = 25,
	GP_0_24_DATA = 26,
	GP_0_25_DATA = 27,
	GP_0_26_DATA = 28,
	GP_0_27_DATA = 29,
	GP_1_0_DATA___10 = 30,
	GP_1_1_DATA___10 = 31,
	GP_1_2_DATA___10 = 32,
	GP_1_3_DATA___10 = 33,
	GP_1_4_DATA___10 = 34,
	GP_1_5_DATA___10 = 35,
	GP_1_6_DATA___10 = 36,
	GP_1_7_DATA___10 = 37,
	GP_1_8_DATA___10 = 38,
	GP_1_9_DATA___10 = 39,
	GP_1_10_DATA___10 = 40,
	GP_1_11_DATA___10 = 41,
	GP_1_12_DATA___10 = 42,
	GP_1_13_DATA___10 = 43,
	GP_1_14_DATA___10 = 44,
	GP_1_15_DATA___10 = 45,
	GP_1_16_DATA___10 = 46,
	GP_1_17_DATA___10 = 47,
	GP_1_18_DATA___10 = 48,
	GP_1_19_DATA___10 = 49,
	GP_1_20_DATA___10 = 50,
	GP_1_21_DATA___10 = 51,
	GP_1_22_DATA___10 = 52,
	GP_1_23_DATA___9 = 53,
	GP_1_24_DATA___9 = 54,
	GP_1_25_DATA___8 = 55,
	GP_1_26_DATA___8 = 56,
	GP_1_27_DATA___8 = 57,
	GP_1_28_DATA___7 = 58,
	GP_1_29_DATA___3 = 59,
	GP_1_30_DATA___2 = 60,
	GP_2_0_DATA___10 = 61,
	GP_2_1_DATA___10 = 62,
	GP_2_2_DATA___10 = 63,
	GP_2_3_DATA___10 = 64,
	GP_2_4_DATA___10 = 65,
	GP_2_5_DATA___10 = 66,
	GP_2_6_DATA___10 = 67,
	GP_2_7_DATA___10 = 68,
	GP_2_8_DATA___10 = 69,
	GP_2_9_DATA___10 = 70,
	GP_2_10_DATA___10 = 71,
	GP_2_11_DATA___10 = 72,
	GP_2_12_DATA___10 = 73,
	GP_2_13_DATA___10 = 74,
	GP_2_14_DATA___10 = 75,
	GP_2_15_DATA___7 = 76,
	GP_2_16_DATA___6 = 77,
	GP_2_17_DATA___6 = 78,
	GP_2_18_DATA___5 = 79,
	GP_2_19_DATA___6 = 80,
	GP_2_20_DATA___4 = 81,
	GP_2_21_DATA___4 = 82,
	GP_2_22_DATA___4 = 83,
	GP_2_23_DATA___4 = 84,
	GP_2_24_DATA___4 = 85,
	GP_3_0_DATA___10 = 86,
	GP_3_1_DATA___10 = 87,
	GP_3_2_DATA___10 = 88,
	GP_3_3_DATA___10 = 89,
	GP_3_4_DATA___10 = 90,
	GP_3_5_DATA___10 = 91,
	GP_3_6_DATA___10 = 92,
	GP_3_7_DATA___10 = 93,
	GP_3_8_DATA___10 = 94,
	GP_3_9_DATA___10 = 95,
	GP_3_10_DATA___9 = 96,
	GP_3_11_DATA___9 = 97,
	GP_3_12_DATA___9 = 98,
	GP_3_13_DATA___9 = 99,
	GP_3_14_DATA___9 = 100,
	GP_3_15_DATA___9 = 101,
	GP_3_16_DATA___5 = 102,
	GP_4_0_DATA___9 = 103,
	GP_4_1_DATA___9 = 104,
	GP_4_2_DATA___9 = 105,
	GP_4_3_DATA___9 = 106,
	GP_4_4_DATA___9 = 107,
	GP_4_5_DATA___9 = 108,
	GP_4_6_DATA___9 = 109,
	GP_4_7_DATA___9 = 110,
	GP_4_8_DATA___9 = 111,
	GP_4_9_DATA___9 = 112,
	GP_4_10_DATA___9 = 113,
	GP_4_11_DATA___8 = 114,
	GP_4_12_DATA___8 = 115,
	GP_4_13_DATA___8 = 116,
	GP_4_14_DATA___8 = 117,
	GP_4_15_DATA___8 = 118,
	GP_4_16_DATA___7 = 119,
	GP_4_17_DATA___7 = 120,
	GP_4_18_DATA___4 = 121,
	GP_4_19_DATA___4 = 122,
	GP_4_20_DATA___4 = 123,
	GP_4_21_DATA___5 = 124,
	GP_4_22_DATA___4 = 125,
	GP_4_23_DATA___5 = 126,
	GP_4_24_DATA___5 = 127,
	GP_4_25_DATA___2 = 128,
	GP_4_26_DATA___2 = 129,
	GP_5_0_DATA___9 = 130,
	GP_5_1_DATA___9 = 131,
	GP_5_2_DATA___9 = 132,
	GP_5_3_DATA___9 = 133,
	GP_5_4_DATA___9 = 134,
	GP_5_5_DATA___9 = 135,
	GP_5_6_DATA___9 = 136,
	GP_5_7_DATA___9 = 137,
	GP_5_8_DATA___9 = 138,
	GP_5_9_DATA___9 = 139,
	GP_5_10_DATA___9 = 140,
	GP_5_11_DATA___9 = 141,
	GP_5_12_DATA___9 = 142,
	GP_5_13_DATA___9 = 143,
	GP_5_14_DATA___9 = 144,
	GP_5_15_DATA___8 = 145,
	GP_5_16_DATA___8 = 146,
	GP_5_17_DATA___8 = 147,
	GP_5_18_DATA___8 = 148,
	GP_5_19_DATA___8 = 149,
	GP_5_20_DATA___7 = 150,
	GP_6_0_DATA___8 = 151,
	GP_6_1_DATA___8 = 152,
	GP_6_2_DATA___8 = 153,
	GP_6_3_DATA___8 = 154,
	GP_6_4_DATA___8 = 155,
	GP_6_5_DATA___8 = 156,
	GP_6_6_DATA___8 = 157,
	GP_6_7_DATA___8 = 158,
	GP_6_8_DATA___8 = 159,
	GP_6_9_DATA___8 = 160,
	GP_6_10_DATA___8 = 161,
	GP_6_11_DATA___8 = 162,
	GP_6_12_DATA___8 = 163,
	GP_6_13_DATA___8 = 164,
	GP_6_14_DATA___7 = 165,
	GP_6_15_DATA___7 = 166,
	GP_6_16_DATA___7 = 167,
	GP_6_17_DATA___7 = 168,
	GP_6_18_DATA___6 = 169,
	GP_6_19_DATA___6 = 170,
	GP_6_20_DATA___6 = 171,
	GP_7_0_DATA___6 = 172,
	GP_7_1_DATA___6 = 173,
	GP_7_2_DATA___6 = 174,
	GP_7_3_DATA___6 = 175,
	GP_7_4_DATA___3 = 176,
	GP_7_5_DATA___3 = 177,
	GP_7_6_DATA___3 = 178,
	GP_7_7_DATA___3 = 179,
	GP_7_8_DATA___3 = 180,
	GP_7_9_DATA___3 = 181,
	GP_7_10_DATA___3 = 182,
	GP_7_11_DATA___3 = 183,
	GP_7_12_DATA___3 = 184,
	GP_7_13_DATA___3 = 185,
	GP_7_14_DATA___3 = 186,
	GP_7_15_DATA___3 = 187,
	GP_7_16_DATA___3 = 188,
	GP_7_17_DATA___3 = 189,
	GP_7_18_DATA___3 = 190,
	GP_7_19_DATA___3 = 191,
	GP_7_20_DATA___3 = 192,
	GP_8_0_DATA___2 = 193,
	GP_8_1_DATA___2 = 194,
	GP_8_2_DATA___2 = 195,
	GP_8_3_DATA___2 = 196,
	GP_8_4_DATA___2 = 197,
	GP_8_5_DATA___2 = 198,
	GP_8_6_DATA___2 = 199,
	GP_8_7_DATA___2 = 200,
	GP_8_8_DATA___2 = 201,
	GP_8_9_DATA___2 = 202,
	GP_8_10_DATA___2 = 203,
	GP_8_11_DATA___2 = 204,
	GP_8_12_DATA___2 = 205,
	GP_8_13_DATA___2 = 206,
	GP_8_14_DATA = 207,
	GP_8_15_DATA = 208,
	GP_8_16_DATA = 209,
	GP_8_17_DATA = 210,
	GP_8_18_DATA = 211,
	GP_8_19_DATA = 212,
	GP_8_20_DATA = 213,
	GP_9_0_DATA = 214,
	GP_9_1_DATA = 215,
	GP_9_2_DATA = 216,
	GP_9_3_DATA = 217,
	GP_9_4_DATA = 218,
	GP_9_5_DATA = 219,
	GP_9_6_DATA = 220,
	GP_9_7_DATA = 221,
	GP_9_8_DATA = 222,
	GP_9_9_DATA = 223,
	GP_9_10_DATA = 224,
	GP_9_11_DATA = 225,
	GP_9_12_DATA = 226,
	GP_9_13_DATA = 227,
	GP_9_14_DATA = 228,
	GP_9_15_DATA = 229,
	GP_9_16_DATA = 230,
	GP_9_17_DATA = 231,
	GP_9_18_DATA = 232,
	GP_9_19_DATA = 233,
	GP_9_20_DATA = 234,
	PINMUX_DATA_END___10 = 235,
	PINMUX_FUNCTION_BEGIN___10 = 236,
	GP_0_0_FN___10 = 237,
	GP_0_1_FN___10 = 238,
	GP_0_2_FN___10 = 239,
	GP_0_3_FN___10 = 240,
	GP_0_4_FN___10 = 241,
	GP_0_5_FN___10 = 242,
	GP_0_6_FN___10 = 243,
	GP_0_7_FN___10 = 244,
	GP_0_8_FN___10 = 245,
	GP_0_9_FN___9 = 246,
	GP_0_10_FN___9 = 247,
	GP_0_11_FN___9 = 248,
	GP_0_12_FN___9 = 249,
	GP_0_13_FN___9 = 250,
	GP_0_14_FN___9 = 251,
	GP_0_15_FN___9 = 252,
	GP_0_16_FN___6 = 253,
	GP_0_17_FN___6 = 254,
	GP_0_18_FN___5 = 255,
	GP_0_19_FN___3 = 256,
	GP_0_20_FN___3 = 257,
	GP_0_21_FN___2 = 258,
	GP_0_22_FN = 259,
	GP_0_23_FN = 260,
	GP_0_24_FN = 261,
	GP_0_25_FN = 262,
	GP_0_26_FN = 263,
	GP_0_27_FN = 264,
	GP_1_0_FN___10 = 265,
	GP_1_1_FN___10 = 266,
	GP_1_2_FN___10 = 267,
	GP_1_3_FN___10 = 268,
	GP_1_4_FN___10 = 269,
	GP_1_5_FN___10 = 270,
	GP_1_6_FN___10 = 271,
	GP_1_7_FN___10 = 272,
	GP_1_8_FN___10 = 273,
	GP_1_9_FN___10 = 274,
	GP_1_10_FN___10 = 275,
	GP_1_11_FN___10 = 276,
	GP_1_12_FN___10 = 277,
	GP_1_13_FN___10 = 278,
	GP_1_14_FN___10 = 279,
	GP_1_15_FN___10 = 280,
	GP_1_16_FN___10 = 281,
	GP_1_17_FN___10 = 282,
	GP_1_18_FN___10 = 283,
	GP_1_19_FN___10 = 284,
	GP_1_20_FN___10 = 285,
	GP_1_21_FN___10 = 286,
	GP_1_22_FN___10 = 287,
	GP_1_23_FN___9 = 288,
	GP_1_24_FN___9 = 289,
	GP_1_25_FN___8 = 290,
	GP_1_26_FN___8 = 291,
	GP_1_27_FN___8 = 292,
	GP_1_28_FN___7 = 293,
	GP_1_29_FN___3 = 294,
	GP_1_30_FN___2 = 295,
	GP_2_0_FN___10 = 296,
	GP_2_1_FN___10 = 297,
	GP_2_2_FN___10 = 298,
	GP_2_3_FN___10 = 299,
	GP_2_4_FN___10 = 300,
	GP_2_5_FN___10 = 301,
	GP_2_6_FN___10 = 302,
	GP_2_7_FN___10 = 303,
	GP_2_8_FN___10 = 304,
	GP_2_9_FN___10 = 305,
	GP_2_10_FN___10 = 306,
	GP_2_11_FN___10 = 307,
	GP_2_12_FN___10 = 308,
	GP_2_13_FN___10 = 309,
	GP_2_14_FN___10 = 310,
	GP_2_15_FN___7 = 311,
	GP_2_16_FN___6 = 312,
	GP_2_17_FN___6 = 313,
	GP_2_18_FN___5 = 314,
	GP_2_19_FN___6 = 315,
	GP_2_20_FN___4 = 316,
	GP_2_21_FN___4 = 317,
	GP_2_22_FN___4 = 318,
	GP_2_23_FN___4 = 319,
	GP_2_24_FN___4 = 320,
	GP_3_0_FN___10 = 321,
	GP_3_1_FN___10 = 322,
	GP_3_2_FN___10 = 323,
	GP_3_3_FN___10 = 324,
	GP_3_4_FN___10 = 325,
	GP_3_5_FN___10 = 326,
	GP_3_6_FN___10 = 327,
	GP_3_7_FN___10 = 328,
	GP_3_8_FN___10 = 329,
	GP_3_9_FN___10 = 330,
	GP_3_10_FN___9 = 331,
	GP_3_11_FN___9 = 332,
	GP_3_12_FN___9 = 333,
	GP_3_13_FN___9 = 334,
	GP_3_14_FN___9 = 335,
	GP_3_15_FN___9 = 336,
	GP_3_16_FN___5 = 337,
	GP_4_0_FN___9 = 338,
	GP_4_1_FN___9 = 339,
	GP_4_2_FN___9 = 340,
	GP_4_3_FN___9 = 341,
	GP_4_4_FN___9 = 342,
	GP_4_5_FN___9 = 343,
	GP_4_6_FN___9 = 344,
	GP_4_7_FN___9 = 345,
	GP_4_8_FN___9 = 346,
	GP_4_9_FN___9 = 347,
	GP_4_10_FN___9 = 348,
	GP_4_11_FN___8 = 349,
	GP_4_12_FN___8 = 350,
	GP_4_13_FN___8 = 351,
	GP_4_14_FN___8 = 352,
	GP_4_15_FN___8 = 353,
	GP_4_16_FN___7 = 354,
	GP_4_17_FN___7 = 355,
	GP_4_18_FN___4 = 356,
	GP_4_19_FN___4 = 357,
	GP_4_20_FN___4 = 358,
	GP_4_21_FN___5 = 359,
	GP_4_22_FN___4 = 360,
	GP_4_23_FN___5 = 361,
	GP_4_24_FN___5 = 362,
	GP_4_25_FN___2 = 363,
	GP_4_26_FN___2 = 364,
	GP_5_0_FN___9 = 365,
	GP_5_1_FN___9 = 366,
	GP_5_2_FN___9 = 367,
	GP_5_3_FN___9 = 368,
	GP_5_4_FN___9 = 369,
	GP_5_5_FN___9 = 370,
	GP_5_6_FN___9 = 371,
	GP_5_7_FN___9 = 372,
	GP_5_8_FN___9 = 373,
	GP_5_9_FN___9 = 374,
	GP_5_10_FN___9 = 375,
	GP_5_11_FN___9 = 376,
	GP_5_12_FN___9 = 377,
	GP_5_13_FN___9 = 378,
	GP_5_14_FN___9 = 379,
	GP_5_15_FN___8 = 380,
	GP_5_16_FN___8 = 381,
	GP_5_17_FN___8 = 382,
	GP_5_18_FN___8 = 383,
	GP_5_19_FN___8 = 384,
	GP_5_20_FN___7 = 385,
	GP_6_0_FN___8 = 386,
	GP_6_1_FN___8 = 387,
	GP_6_2_FN___8 = 388,
	GP_6_3_FN___8 = 389,
	GP_6_4_FN___8 = 390,
	GP_6_5_FN___8 = 391,
	GP_6_6_FN___8 = 392,
	GP_6_7_FN___8 = 393,
	GP_6_8_FN___8 = 394,
	GP_6_9_FN___8 = 395,
	GP_6_10_FN___8 = 396,
	GP_6_11_FN___8 = 397,
	GP_6_12_FN___8 = 398,
	GP_6_13_FN___8 = 399,
	GP_6_14_FN___7 = 400,
	GP_6_15_FN___7 = 401,
	GP_6_16_FN___7 = 402,
	GP_6_17_FN___7 = 403,
	GP_6_18_FN___6 = 404,
	GP_6_19_FN___6 = 405,
	GP_6_20_FN___6 = 406,
	GP_7_0_FN___6 = 407,
	GP_7_1_FN___6 = 408,
	GP_7_2_FN___6 = 409,
	GP_7_3_FN___6 = 410,
	GP_7_4_FN___3 = 411,
	GP_7_5_FN___3 = 412,
	GP_7_6_FN___3 = 413,
	GP_7_7_FN___3 = 414,
	GP_7_8_FN___3 = 415,
	GP_7_9_FN___3 = 416,
	GP_7_10_FN___3 = 417,
	GP_7_11_FN___3 = 418,
	GP_7_12_FN___3 = 419,
	GP_7_13_FN___3 = 420,
	GP_7_14_FN___3 = 421,
	GP_7_15_FN___3 = 422,
	GP_7_16_FN___3 = 423,
	GP_7_17_FN___3 = 424,
	GP_7_18_FN___3 = 425,
	GP_7_19_FN___3 = 426,
	GP_7_20_FN___3 = 427,
	GP_8_0_FN___2 = 428,
	GP_8_1_FN___2 = 429,
	GP_8_2_FN___2 = 430,
	GP_8_3_FN___2 = 431,
	GP_8_4_FN___2 = 432,
	GP_8_5_FN___2 = 433,
	GP_8_6_FN___2 = 434,
	GP_8_7_FN___2 = 435,
	GP_8_8_FN___2 = 436,
	GP_8_9_FN___2 = 437,
	GP_8_10_FN___2 = 438,
	GP_8_11_FN___2 = 439,
	GP_8_12_FN___2 = 440,
	GP_8_13_FN___2 = 441,
	GP_8_14_FN = 442,
	GP_8_15_FN = 443,
	GP_8_16_FN = 444,
	GP_8_17_FN = 445,
	GP_8_18_FN = 446,
	GP_8_19_FN = 447,
	GP_8_20_FN = 448,
	GP_9_0_FN = 449,
	GP_9_1_FN = 450,
	GP_9_2_FN = 451,
	GP_9_3_FN = 452,
	GP_9_4_FN = 453,
	GP_9_5_FN = 454,
	GP_9_6_FN = 455,
	GP_9_7_FN = 456,
	GP_9_8_FN = 457,
	GP_9_9_FN = 458,
	GP_9_10_FN = 459,
	GP_9_11_FN = 460,
	GP_9_12_FN = 461,
	GP_9_13_FN = 462,
	GP_9_14_FN = 463,
	GP_9_15_FN = 464,
	GP_9_16_FN = 465,
	GP_9_17_FN = 466,
	GP_9_18_FN = 467,
	GP_9_19_FN = 468,
	GP_9_20_FN = 469,
	FN_MMC_D7___6 = 470,
	FN_MMC_D6___6 = 471,
	FN_AVS1___6 = 472,
	FN_MMC_D5___6 = 473,
	FN_AVS0___3 = 474,
	FN_MMC_D4___6 = 475,
	FN_TCLK2_A___9 = 476,
	FN_PCIE3_CLKREQ_N = 477,
	FN_MMC_SD_CLK___4 = 478,
	FN_PCIE2_CLKREQ_N = 479,
	FN_MMC_SD_D3___4 = 480,
	FN_PCIE1_CLKREQ_N___3 = 481,
	FN_MMC_SD_D2___4 = 482,
	FN_PCIE0_CLKREQ_N___4 = 483,
	FN_MMC_SD_D1___4 = 484,
	FN_AVB2_AVTP_PPS___3 = 485,
	FN_AVB3_AVTP_PPS = 486,
	FN_AVB4_AVTP_PPS = 487,
	FN_AVB5_AVTP_PPS = 488,
	FN_MMC_SD_D0___4 = 489,
	FN_AVB2_AVTP_CAPTURE___3 = 490,
	FN_AVB3_AVTP_CAPTURE = 491,
	FN_AVB4_AVTP_CAPTURE = 492,
	FN_AVB5_AVTP_CAPTURE = 493,
	FN_MMC_SD_CMD___4 = 494,
	FN_AVB2_AVTP_MATCH___3 = 495,
	FN_AVB3_AVTP_MATCH = 496,
	FN_AVB4_AVTP_MATCH = 497,
	FN_AVB5_AVTP_MATCH = 498,
	FN_MMC_DS___5 = 499,
	FN_AVB2_LINK___3 = 500,
	FN_AVB3_LINK = 501,
	FN_AVB4_LINK = 502,
	FN_AVB5_LINK = 503,
	FN_SD_CD___4 = 504,
	FN_CANFD7_RX___2 = 505,
	FN_AVB0_PHY_INT___4 = 506,
	FN_AVB1_PHY_INT___3 = 507,
	FN_AVB2_PHY_INT___3 = 508,
	FN_AVB3_PHY_INT = 509,
	FN_AVB4_PHY_INT = 510,
	FN_AVB5_PHY_INT = 511,
	FN_SD_WP___4 = 512,
	FN_CANFD7_TX___2 = 513,
	FN_AVB2_MAGIC___3 = 514,
	FN_AVB3_MAGIC = 515,
	FN_AVB4_MAGIC = 516,
	FN_AVB5_MAGIC = 517,
	FN_RPC_INT_N___7 = 518,
	FN_CANFD6_RX___2 = 519,
	FN_AVB2_MDC___3 = 520,
	FN_AVB3_MDC = 521,
	FN_AVB4_MDC = 522,
	FN_AVB5_MDC = 523,
	FN_RPC_WP_N___5 = 524,
	FN_AVB2_MDIO___3 = 525,
	FN_AVB3_MDIO = 526,
	FN_AVB4_MDIO = 527,
	FN_AVB5_MDIO = 528,
	FN_RPC_RESET_N___7 = 529,
	FN_AVB2_TXCREFCLK___3 = 530,
	FN_AVB3_TXCREFCLK = 531,
	FN_AVB4_TXCREFCLK = 532,
	FN_AVB5_TXCREFCLK = 533,
	FN_QSPI1_SSL___7 = 534,
	FN_AVB2_TD3___3 = 535,
	FN_AVB3_TD3 = 536,
	FN_AVB4_TD3 = 537,
	FN_AVB5_TD3 = 538,
	FN_QSPI1_IO3___7 = 539,
	FN_AVB2_TD2___3 = 540,
	FN_AVB3_TD2 = 541,
	FN_AVB4_TD2 = 542,
	FN_AVB5_TD2 = 543,
	FN_QSPI1_IO2___7 = 544,
	FN_AVB2_TD1___3 = 545,
	FN_AVB3_TD1 = 546,
	FN_AVB4_TD1 = 547,
	FN_AVB5_TD1 = 548,
	FN_QSPI1_MISO_IO1___7 = 549,
	FN_AVB2_TD0___3 = 550,
	FN_AVB3_TD0 = 551,
	FN_AVB4_TD0 = 552,
	FN_AVB5_TD0 = 553,
	FN_QSPI1_MOSI_IO0___7 = 554,
	FN_AVB2_TXC___3 = 555,
	FN_AVB3_TXC = 556,
	FN_AVB4_TXC = 557,
	FN_AVB5_TXC = 558,
	FN_QSPI1_SPCLK___7 = 559,
	FN_AVB2_TX_CTL___3 = 560,
	FN_AVB3_TX_CTL = 561,
	FN_AVB4_TX_CTL = 562,
	FN_AVB5_TX_CTL = 563,
	FN_QSPI0_SSL___7 = 564,
	FN_AVB2_RD3___3 = 565,
	FN_AVB3_RD3 = 566,
	FN_AVB4_RD3 = 567,
	FN_AVB5_RD3 = 568,
	FN_QSPI0_IO3___7 = 569,
	FN_CANFD1_RX___9 = 570,
	FN_AVB2_RD2___3 = 571,
	FN_AVB3_RD2 = 572,
	FN_AVB4_RD2 = 573,
	FN_AVB5_RD2 = 574,
	FN_QSPI0_IO2___7 = 575,
	FN_CANFD1_TX___9 = 576,
	FN_AVB2_RD1___3 = 577,
	FN_AVB3_RD1 = 578,
	FN_AVB4_RD1 = 579,
	FN_AVB5_RD1 = 580,
	FN_QSPI0_MISO_IO1___7 = 581,
	FN_AVB2_RD0___3 = 582,
	FN_AVB3_RD0 = 583,
	FN_AVB4_RD0 = 584,
	FN_AVB5_RD0 = 585,
	FN_QSPI0_MOSI_IO0___7 = 586,
	FN_AVB2_RXC___3 = 587,
	FN_AVB3_RXC = 588,
	FN_AVB4_RXC = 589,
	FN_AVB5_RXC = 590,
	FN_QSPI0_SPCLK___7 = 591,
	FN_CAN_CLK___8 = 592,
	FN_AVB2_RX_CTL___3 = 593,
	FN_AVB3_RX_CTL = 594,
	FN_AVB4_RX_CTL = 595,
	FN_AVB5_RX_CTL = 596,
	FN_IP0SR1_3_0___4 = 597,
	FN_SCIF_CLK___5 = 598,
	FN_A0___6 = 599,
	FN_IP1SR1_3_0___3 = 600,
	FN_MSIOF0_SCK___10 = 601,
	FN_DU_DR4___7 = 602,
	FN_A8___6 = 603,
	FN_IP2SR1_3_0___3 = 604,
	FN_MSIOF1_SS1___7 = 605,
	FN_HCTS3_N___7 = 606,
	FN_RX3___3 = 607,
	FN_DU_DG6___7 = 608,
	FN_A16___6 = 609,
	FN_IP3SR1_3_0___3 = 610,
	FN_IRQ0___7 = 611,
	FN_DU_DOTCLKOUT___2 = 612,
	FN_A24 = 613,
	FN_IP0SR1_7_4___4 = 614,
	FN_HRX0___8 = 615,
	FN_RX0___8 = 616,
	FN_A1___6 = 617,
	FN_IP1SR1_7_4___3 = 618,
	FN_MSIOF0_SYNC___10 = 619,
	FN_DU_DR5___7 = 620,
	FN_A9___6 = 621,
	FN_IP2SR1_7_4___3 = 622,
	FN_MSIOF1_SS2___7 = 623,
	FN_HTX3___3 = 624,
	FN_TX3___3 = 625,
	FN_DU_DG7___7 = 626,
	FN_A17___6 = 627,
	FN_IP3SR1_7_4___3 = 628,
	FN_IRQ1___7 = 629,
	FN_DU_HSYNC___3 = 630,
	FN_A25 = 631,
	FN_IP0SR1_11_8___4 = 632,
	FN_HSCK0___8 = 633,
	FN_SCK0___8 = 634,
	FN_A2___6 = 635,
	FN_IP1SR1_11_8___3 = 636,
	FN_MSIOF0_SS1___10 = 637,
	FN_DU_DR6___7 = 638,
	FN_A10___6 = 639,
	FN_IP2SR1_11_8___3 = 640,
	FN_MSIOF2_RXD___6 = 641,
	FN_HSCK1___3 = 642,
	FN_SCK1___7 = 643,
	FN_DU_DB2___7 = 644,
	FN_A18___6 = 645,
	FN_IP3SR1_11_8___3 = 646,
	FN_IRQ2___7 = 647,
	FN_DU_VSYNC___3 = 648,
	FN_CS1_N_A26___2 = 649,
	FN_IP0SR1_15_12___4 = 650,
	FN_HRTS0_N___8 = 651,
	FN_RTS0_N___9 = 652,
	FN_A3___6 = 653,
	FN_IP1SR1_15_12___3 = 654,
	FN_MSIOF0_SS2___10 = 655,
	FN_DU_DR7___7 = 656,
	FN_A11___6 = 657,
	FN_IP2SR1_15_12___3 = 658,
	FN_MSIOF2_TXD___6 = 659,
	FN_HCTS1_N___3 = 660,
	FN_CTS1_N___8 = 661,
	FN_DU_DB3___7 = 662,
	FN_A19___6 = 663,
	FN_IP3SR1_15_12___3 = 664,
	FN_IRQ3___7 = 665,
	FN_DU_ODDF_DISP_CDE = 666,
	FN_CS0_N___6 = 667,
	FN_IP0SR1_19_16___4 = 668,
	FN_HCTS0_N___8 = 669,
	FN_CTS0_N___9 = 670,
	FN_A4___6 = 671,
	FN_IP1SR1_19_16___3 = 672,
	FN_MSIOF1_RXD___7 = 673,
	FN_DU_DG2___7 = 674,
	FN_A12___6 = 675,
	FN_IP2SR1_19_16___3 = 676,
	FN_MSIOF2_SCK___6 = 677,
	FN_HRTS1_N___3 = 678,
	FN_RTS1_N___8 = 679,
	FN_DU_DB4___7 = 680,
	FN_A20 = 681,
	FN_IP3SR1_19_16___3 = 682,
	FN_GP1_28 = 683,
	FN_D0___6 = 684,
	FN_IP0SR1_23_20___4 = 685,
	FN_HTX0___8 = 686,
	FN_TX0___8 = 687,
	FN_A5___6 = 688,
	FN_IP1SR1_23_20___3 = 689,
	FN_MSIOF1_TXD___7 = 690,
	FN_HRX3___3 = 691,
	FN_SCK3___6 = 692,
	FN_DU_DG3___7 = 693,
	FN_A13___6 = 694,
	FN_IP2SR1_23_20___3 = 695,
	FN_MSIOF2_SYNC___5 = 696,
	FN_HRX1___3 = 697,
	FN_RX1_A___8 = 698,
	FN_DU_DB5___7 = 699,
	FN_A21 = 700,
	FN_IP3SR1_23_20___2 = 701,
	FN_GP1_29 = 702,
	FN_D1___6 = 703,
	FN_IP0SR1_27_24___4 = 704,
	FN_MSIOF0_RXD___10 = 705,
	FN_DU_DR2___7 = 706,
	FN_A6___6 = 707,
	FN_IP1SR1_27_24___3 = 708,
	FN_MSIOF1_SCK___7 = 709,
	FN_HSCK3___6 = 710,
	FN_CTS3_N___6 = 711,
	FN_DU_DG4___7 = 712,
	FN_A14___6 = 713,
	FN_IP2SR1_27_24___3 = 714,
	FN_MSIOF2_SS1___6 = 715,
	FN_HTX1___3 = 716,
	FN_TX1_A___8 = 717,
	FN_DU_DB6___7 = 718,
	FN_A22 = 719,
	FN_IP3SR1_27_24 = 720,
	FN_GP1_30 = 721,
	FN_D2___6 = 722,
	FN_IP0SR1_31_28___4 = 723,
	FN_MSIOF0_TXD___10 = 724,
	FN_DU_DR3___7 = 725,
	FN_A7___6 = 726,
	FN_IP1SR1_31_28___3 = 727,
	FN_MSIOF1_SYNC___7 = 728,
	FN_HRTS3_N___7 = 729,
	FN_RTS3_N___6 = 730,
	FN_DU_DG5___7 = 731,
	FN_A15___6 = 732,
	FN_IP2SR1_31_28___3 = 733,
	FN_MSIOF2_SS2___6 = 734,
	FN_TCLK1_B___9 = 735,
	FN_DU_DB7___7 = 736,
	FN_A23 = 737,
	FN_IP0SR2_3_0___3 = 738,
	FN_IPC_CLKIN___2 = 739,
	FN_IPC_CLKEN_IN___2 = 740,
	FN_DU_DOTCLKIN = 741,
	FN_IP1SR2_3_0___3 = 742,
	FN_GP2_08 = 743,
	FN_HRX2___5 = 744,
	FN_MSIOF4_SS1___3 = 745,
	FN_RX4___5 = 746,
	FN_D9___6 = 747,
	FN_IP2SR2_3_0___2 = 748,
	FN_FXR_TXDA_A = 749,
	FN_MSIOF3_SS1___5 = 750,
	FN_IP0SR2_7_4___3 = 751,
	FN_IPC_CLKOUT___2 = 752,
	FN_IPC_CLKEN_OUT___2 = 753,
	FN_IP1SR2_7_4___3 = 754,
	FN_GP2_09 = 755,
	FN_HTX2___5 = 756,
	FN_MSIOF4_SS2___3 = 757,
	FN_TX4___5 = 758,
	FN_D10___6 = 759,
	FN_IP2SR2_7_4___3 = 760,
	FN_RXDA_EXTFXR_A = 761,
	FN_MSIOF3_SS2___5 = 762,
	FN_BS_N___6 = 763,
	FN_IP0SR2_11_8___3 = 764,
	FN_GP2_02 = 765,
	FN_D3___6 = 766,
	FN_IP1SR2_11_8___3 = 767,
	FN_GP2_10 = 768,
	FN_TCLK2_B___9 = 769,
	FN_MSIOF5_RXD___3 = 770,
	FN_D11___6 = 771,
	FN_IP2SR2_11_8___2 = 772,
	FN_FXR_TXDB___4 = 773,
	FN_MSIOF3_RXD___5 = 774,
	FN_RD_N___6 = 775,
	FN_IP0SR2_15_12___3 = 776,
	FN_GP2_03 = 777,
	FN_D4___6 = 778,
	FN_IP1SR2_15_12___3 = 779,
	FN_GP2_11 = 780,
	FN_TCLK3___3 = 781,
	FN_MSIOF5_TXD___3 = 782,
	FN_D12___6 = 783,
	FN_IP2SR2_15_12___3 = 784,
	FN_RXDB_EXTFXR___4 = 785,
	FN_MSIOF3_TXD___5 = 786,
	FN_WE0_N___6 = 787,
	FN_IP0SR2_19_16___3 = 788,
	FN_GP2_04 = 789,
	FN_MSIOF4_RXD___3 = 790,
	FN_D5___6 = 791,
	FN_IP1SR2_19_16___3 = 792,
	FN_GP2_12 = 793,
	FN_TCLK4___3 = 794,
	FN_MSIOF5_SCK___3 = 795,
	FN_D13___6 = 796,
	FN_IP2SR2_19_16 = 797,
	FN_CLK_EXTFXR___4 = 798,
	FN_MSIOF3_SCK___5 = 799,
	FN_WE1_N___6 = 800,
	FN_IP0SR2_23_20___3 = 801,
	FN_GP2_05 = 802,
	FN_HSCK2___5 = 803,
	FN_MSIOF4_TXD___3 = 804,
	FN_SCK4___5 = 805,
	FN_D6___6 = 806,
	FN_IP1SR2_23_20___3 = 807,
	FN_GP2_13 = 808,
	FN_MSIOF5_SYNC___3 = 809,
	FN_D14___6 = 810,
	FN_IP2SR2_23_20 = 811,
	FN_TPU0TO0___6 = 812,
	FN_MSIOF3_SYNC___5 = 813,
	FN_RD_WR_N___6 = 814,
	FN_IP0SR2_27_24___3 = 815,
	FN_GP2_06 = 816,
	FN_HCTS2_N___5 = 817,
	FN_MSIOF4_SCK___3 = 818,
	FN_CTS4_N___5 = 819,
	FN_D7___6 = 820,
	FN_IP1SR2_27_24___3 = 821,
	FN_GP2_14 = 822,
	FN_IRQ4___7 = 823,
	FN_MSIOF5_SS1___3 = 824,
	FN_D15___6 = 825,
	FN_IP2SR2_27_24 = 826,
	FN_TPU0TO1___6 = 827,
	FN_CLKOUT___6 = 828,
	FN_IP0SR2_31_28___3 = 829,
	FN_GP2_07 = 830,
	FN_HRTS2_N___5 = 831,
	FN_MSIOF4_SYNC___3 = 832,
	FN_RTS4_N___5 = 833,
	FN_D8___6 = 834,
	FN_IP1SR2_31_28___3 = 835,
	FN_GP2_15 = 836,
	FN_IRQ5___9 = 837,
	FN_MSIOF5_SS2___3 = 838,
	FN_CPG_CPCKOUT___2 = 839,
	FN_IP2SR2_31_28 = 840,
	FN_TCLK1_A___9 = 841,
	FN_EX_WAIT0___3 = 842,
	FN_IP1SR3_3_0___3 = 843,
	FN_CANFD3_RX___3 = 844,
	FN_PWM3 = 845,
	FN_IP0SR3_7_4___3 = 846,
	FN_CANFD0_TX___5 = 847,
	FN_FXR_TXDA_B = 848,
	FN_TX1_B___8 = 849,
	FN_IP1SR3_7_4___3 = 850,
	FN_CANFD4_TX___2 = 851,
	FN_PWM4___3 = 852,
	FN_FXR_CLKOUT1 = 853,
	FN_IP0SR3_11_8___3 = 854,
	FN_CANFD0_RX___5 = 855,
	FN_RXDA_EXTFXR_B = 856,
	FN_RX1_B___8 = 857,
	FN_IP1SR3_11_8___3 = 858,
	FN_CANFD4_RX___2 = 859,
	FN_FXR_CLKOUT2 = 860,
	FN_IP1SR3_15_12___3 = 861,
	FN_CANFD5_TX = 862,
	FN_FXR_TXENA_N___2 = 863,
	FN_IP1SR3_19_16___3 = 864,
	FN_CANFD5_RX = 865,
	FN_FXR_TXENB_N___2 = 866,
	FN_IP0SR3_23_20___3 = 867,
	FN_CANFD2_TX___3 = 868,
	FN_TPU0TO2___6 = 869,
	FN_PWM0___5 = 870,
	FN_IP1SR3_23_20___3 = 871,
	FN_CANFD6_TX___2 = 872,
	FN_STPWT_EXTFXR___3 = 873,
	FN_IP0SR3_27_24___3 = 874,
	FN_CANFD2_RX___3 = 875,
	FN_TPU0TO3___6 = 876,
	FN_PWM1 = 877,
	FN_IP0SR3_31_28___3 = 878,
	FN_CANFD3_TX___3 = 879,
	FN_PWM2___2 = 880,
	FN_IP0SR4_3_0___3 = 881,
	FN_AVB0_RX_CTL___4 = 882,
	FN_AVB0_MII_RX_DV___3 = 883,
	FN_IP1SR4_3_0___3 = 884,
	FN_AVB0_TD0___4 = 885,
	FN_AVB0_MII_TD0___3 = 886,
	FN_IP0SR4_7_4___3 = 887,
	FN_AVB0_RXC___4 = 888,
	FN_AVB0_MII_RXC___3 = 889,
	FN_IP1SR4_7_4___3 = 890,
	FN_AVB0_TD1___4 = 891,
	FN_AVB0_MII_TD1___3 = 892,
	FN_IP2SR4_7_4___2 = 893,
	FN_AVB0_LINK___4 = 894,
	FN_AVB0_MII_TX_ER___3 = 895,
	FN_IP0SR4_11_8___3 = 896,
	FN_AVB0_RD0___4 = 897,
	FN_AVB0_MII_RD0___3 = 898,
	FN_IP1SR4_11_8___3 = 899,
	FN_AVB0_TD2___4 = 900,
	FN_AVB0_MII_TD2___3 = 901,
	FN_IP2SR4_11_8___2 = 902,
	FN_AVB0_AVTP_MATCH___3 = 903,
	FN_AVB0_MII_RX_ER___3 = 904,
	FN_CC5_OSCOUT___3 = 905,
	FN_IP0SR4_15_12___3 = 906,
	FN_AVB0_RD1___4 = 907,
	FN_AVB0_MII_RD1___3 = 908,
	FN_IP1SR4_15_12___3 = 909,
	FN_AVB0_TD3___4 = 910,
	FN_AVB0_MII_TD3___3 = 911,
	FN_IP2SR4_15_12___2 = 912,
	FN_AVB0_AVTP_CAPTURE___3 = 913,
	FN_AVB0_MII_CRS___3 = 914,
	FN_IP0SR4_19_16___3 = 915,
	FN_AVB0_RD2___4 = 916,
	FN_AVB0_MII_RD2___3 = 917,
	FN_IP1SR4_19_16___3 = 918,
	FN_AVB0_TXCREFCLK___4 = 919,
	FN_IP2SR4_19_16___2 = 920,
	FN_AVB0_AVTP_PPS___3 = 921,
	FN_AVB0_MII_COL___3 = 922,
	FN_IP0SR4_23_20___3 = 923,
	FN_AVB0_RD3___4 = 924,
	FN_AVB0_MII_RD3___3 = 925,
	FN_IP1SR4_23_20___3 = 926,
	FN_AVB0_MDIO___4 = 927,
	FN_IP0SR4_27_24___3 = 928,
	FN_AVB0_TX_CTL___4 = 929,
	FN_AVB0_MII_TX_EN___3 = 930,
	FN_IP1SR4_27_24___3 = 931,
	FN_AVB0_MDC___4 = 932,
	FN_IP0SR4_31_28___3 = 933,
	FN_AVB0_TXC___4 = 934,
	FN_AVB0_MII_TXC___3 = 935,
	FN_IP1SR4_31_28___3 = 936,
	FN_AVB0_MAGIC___4 = 937,
	FN_IP0SR5_3_0___3 = 938,
	FN_AVB1_RX_CTL___3 = 939,
	FN_AVB1_MII_RX_DV___3 = 940,
	FN_IP1SR5_3_0___3 = 941,
	FN_AVB1_TD0___3 = 942,
	FN_AVB1_MII_TD0___3 = 943,
	FN_IP0SR5_7_4___3 = 944,
	FN_AVB1_RXC___3 = 945,
	FN_AVB1_MII_RXC___3 = 946,
	FN_IP1SR5_7_4___3 = 947,
	FN_AVB1_TD1___3 = 948,
	FN_AVB1_MII_TD1___3 = 949,
	FN_IP2SR5_7_4___3 = 950,
	FN_AVB1_LINK___3 = 951,
	FN_AVB1_MII_TX_ER___3 = 952,
	FN_IP0SR5_11_8___3 = 953,
	FN_AVB1_RD0___3 = 954,
	FN_AVB1_MII_RD0___3 = 955,
	FN_IP1SR5_11_8___3 = 956,
	FN_AVB1_TD2___3 = 957,
	FN_AVB1_MII_TD2___3 = 958,
	FN_IP2SR5_11_8___3 = 959,
	FN_AVB1_AVTP_MATCH___3 = 960,
	FN_AVB1_MII_RX_ER___3 = 961,
	FN_IP0SR5_15_12___3 = 962,
	FN_AVB1_RD1___3 = 963,
	FN_AVB1_MII_RD1___3 = 964,
	FN_IP1SR5_15_12___3 = 965,
	FN_AVB1_TD3___3 = 966,
	FN_AVB1_MII_TD3___3 = 967,
	FN_IP2SR5_15_12___3 = 968,
	FN_AVB1_AVTP_CAPTURE___3 = 969,
	FN_AVB1_MII_CRS___3 = 970,
	FN_IP0SR5_19_16___3 = 971,
	FN_AVB1_RD2___3 = 972,
	FN_AVB1_MII_RD2___3 = 973,
	FN_IP1SR5_19_16___3 = 974,
	FN_AVB1_TXCREFCLK___3 = 975,
	FN_IP2SR5_19_16___3 = 976,
	FN_AVB1_AVTP_PPS___3 = 977,
	FN_AVB1_MII_COL___3 = 978,
	FN_IP0SR5_23_20___3 = 979,
	FN_AVB1_RD3___3 = 980,
	FN_AVB1_MII_RD3___3 = 981,
	FN_IP1SR5_23_20___3 = 982,
	FN_AVB1_MDIO___3 = 983,
	FN_IP0SR5_27_24___3 = 984,
	FN_AVB1_TX_CTL___3 = 985,
	FN_AVB1_MII_TX_EN___3 = 986,
	FN_IP1SR5_27_24___3 = 987,
	FN_AVB1_MDC___3 = 988,
	FN_IP0SR5_31_28___3 = 989,
	FN_AVB1_TXC___3 = 990,
	FN_AVB1_MII_TXC___3 = 991,
	FN_IP1SR5_31_28___3 = 992,
	FN_AVB1_MAGIC___3 = 993,
	FN_SEL_I2C6_0___5 = 994,
	FN_SEL_I2C6_3 = 995,
	FN_SEL_I2C5_0___2 = 996,
	FN_SEL_I2C5_3___2 = 997,
	FN_SEL_I2C4_0___2 = 998,
	FN_SEL_I2C4_3___2 = 999,
	FN_SEL_I2C3_0___3 = 1000,
	FN_SEL_I2C3_3___2 = 1001,
	FN_SEL_I2C2_0___7 = 1002,
	FN_SEL_I2C2_3___3 = 1003,
	FN_SEL_I2C1_0___6 = 1004,
	FN_SEL_I2C1_3___3 = 1005,
	FN_SEL_I2C0_0___2 = 1006,
	FN_SEL_I2C0_3___2 = 1007,
	PINMUX_FUNCTION_END___10 = 1008,
	PINMUX_MARK_BEGIN___10 = 1009,
	MMC_D7_MARK___6 = 1010,
	MMC_D6_MARK___6 = 1011,
	AVS1_MARK___6 = 1012,
	MMC_D5_MARK___6 = 1013,
	AVS0_MARK___3 = 1014,
	MMC_D4_MARK___6 = 1015,
	TCLK2_A_MARK___9 = 1016,
	PCIE3_CLKREQ_N_MARK = 1017,
	MMC_SD_CLK_MARK___4 = 1018,
	PCIE2_CLKREQ_N_MARK = 1019,
	MMC_SD_D3_MARK___4 = 1020,
	PCIE1_CLKREQ_N_MARK___3 = 1021,
	MMC_SD_D2_MARK___4 = 1022,
	PCIE0_CLKREQ_N_MARK___4 = 1023,
	MMC_SD_D1_MARK___4 = 1024,
	AVB2_AVTP_PPS_MARK___3 = 1025,
	AVB3_AVTP_PPS_MARK = 1026,
	AVB4_AVTP_PPS_MARK = 1027,
	AVB5_AVTP_PPS_MARK = 1028,
	MMC_SD_D0_MARK___4 = 1029,
	AVB2_AVTP_CAPTURE_MARK___3 = 1030,
	AVB3_AVTP_CAPTURE_MARK = 1031,
	AVB4_AVTP_CAPTURE_MARK = 1032,
	AVB5_AVTP_CAPTURE_MARK = 1033,
	MMC_SD_CMD_MARK___4 = 1034,
	AVB2_AVTP_MATCH_MARK___3 = 1035,
	AVB3_AVTP_MATCH_MARK = 1036,
	AVB4_AVTP_MATCH_MARK = 1037,
	AVB5_AVTP_MATCH_MARK = 1038,
	MMC_DS_MARK___5 = 1039,
	AVB2_LINK_MARK___3 = 1040,
	AVB3_LINK_MARK = 1041,
	AVB4_LINK_MARK = 1042,
	AVB5_LINK_MARK = 1043,
	SD_CD_MARK___4 = 1044,
	CANFD7_RX_MARK___2 = 1045,
	AVB0_PHY_INT_MARK___4 = 1046,
	AVB1_PHY_INT_MARK___3 = 1047,
	AVB2_PHY_INT_MARK___3 = 1048,
	AVB3_PHY_INT_MARK = 1049,
	AVB4_PHY_INT_MARK = 1050,
	AVB5_PHY_INT_MARK = 1051,
	SD_WP_MARK___4 = 1052,
	CANFD7_TX_MARK___2 = 1053,
	AVB2_MAGIC_MARK___3 = 1054,
	AVB3_MAGIC_MARK = 1055,
	AVB4_MAGIC_MARK = 1056,
	AVB5_MAGIC_MARK = 1057,
	RPC_INT_N_MARK___7 = 1058,
	CANFD6_RX_MARK___2 = 1059,
	AVB2_MDC_MARK___3 = 1060,
	AVB3_MDC_MARK = 1061,
	AVB4_MDC_MARK = 1062,
	AVB5_MDC_MARK = 1063,
	RPC_WP_N_MARK___5 = 1064,
	AVB2_MDIO_MARK___3 = 1065,
	AVB3_MDIO_MARK = 1066,
	AVB4_MDIO_MARK = 1067,
	AVB5_MDIO_MARK = 1068,
	RPC_RESET_N_MARK___7 = 1069,
	AVB2_TXCREFCLK_MARK___3 = 1070,
	AVB3_TXCREFCLK_MARK = 1071,
	AVB4_TXCREFCLK_MARK = 1072,
	AVB5_TXCREFCLK_MARK = 1073,
	QSPI1_SSL_MARK___10 = 1074,
	AVB2_TD3_MARK___3 = 1075,
	AVB3_TD3_MARK = 1076,
	AVB4_TD3_MARK = 1077,
	AVB5_TD3_MARK = 1078,
	QSPI1_IO3_MARK___10 = 1079,
	AVB2_TD2_MARK___3 = 1080,
	AVB3_TD2_MARK = 1081,
	AVB4_TD2_MARK = 1082,
	AVB5_TD2_MARK = 1083,
	QSPI1_IO2_MARK___10 = 1084,
	AVB2_TD1_MARK___3 = 1085,
	AVB3_TD1_MARK = 1086,
	AVB4_TD1_MARK = 1087,
	AVB5_TD1_MARK = 1088,
	QSPI1_MISO_IO1_MARK___10 = 1089,
	AVB2_TD0_MARK___3 = 1090,
	AVB3_TD0_MARK = 1091,
	AVB4_TD0_MARK = 1092,
	AVB5_TD0_MARK = 1093,
	QSPI1_MOSI_IO0_MARK___10 = 1094,
	AVB2_TXC_MARK___3 = 1095,
	AVB3_TXC_MARK = 1096,
	AVB4_TXC_MARK = 1097,
	AVB5_TXC_MARK = 1098,
	QSPI1_SPCLK_MARK___10 = 1099,
	AVB2_TX_CTL_MARK___3 = 1100,
	AVB3_TX_CTL_MARK = 1101,
	AVB4_TX_CTL_MARK = 1102,
	AVB5_TX_CTL_MARK = 1103,
	QSPI0_SSL_MARK___10 = 1104,
	AVB2_RD3_MARK___3 = 1105,
	AVB3_RD3_MARK = 1106,
	AVB4_RD3_MARK = 1107,
	AVB5_RD3_MARK = 1108,
	QSPI0_IO3_MARK___10 = 1109,
	CANFD1_RX_MARK___9 = 1110,
	AVB2_RD2_MARK___3 = 1111,
	AVB3_RD2_MARK = 1112,
	AVB4_RD2_MARK = 1113,
	AVB5_RD2_MARK = 1114,
	QSPI0_IO2_MARK___10 = 1115,
	CANFD1_TX_MARK___9 = 1116,
	AVB2_RD1_MARK___3 = 1117,
	AVB3_RD1_MARK = 1118,
	AVB4_RD1_MARK = 1119,
	AVB5_RD1_MARK = 1120,
	QSPI0_MISO_IO1_MARK___10 = 1121,
	AVB2_RD0_MARK___3 = 1122,
	AVB3_RD0_MARK = 1123,
	AVB4_RD0_MARK = 1124,
	AVB5_RD0_MARK = 1125,
	QSPI0_MOSI_IO0_MARK___10 = 1126,
	AVB2_RXC_MARK___3 = 1127,
	AVB3_RXC_MARK = 1128,
	AVB4_RXC_MARK = 1129,
	AVB5_RXC_MARK = 1130,
	QSPI0_SPCLK_MARK___10 = 1131,
	CAN_CLK_MARK___8 = 1132,
	AVB2_RX_CTL_MARK___3 = 1133,
	AVB3_RX_CTL_MARK = 1134,
	AVB4_RX_CTL_MARK = 1135,
	AVB5_RX_CTL_MARK = 1136,
	IP0SR1_3_0_MARK___4 = 1137,
	SCIF_CLK_MARK___5 = 1138,
	A0_MARK___6 = 1139,
	IP1SR1_3_0_MARK___3 = 1140,
	MSIOF0_SCK_MARK___10 = 1141,
	DU_DR4_MARK___7 = 1142,
	A8_MARK___6 = 1143,
	IP2SR1_3_0_MARK___3 = 1144,
	MSIOF1_SS1_MARK___7 = 1145,
	HCTS3_N_MARK___7 = 1146,
	RX3_MARK___3 = 1147,
	DU_DG6_MARK___7 = 1148,
	A16_MARK___6 = 1149,
	IP3SR1_3_0_MARK___3 = 1150,
	IRQ0_MARK___7 = 1151,
	DU_DOTCLKOUT_MARK___2 = 1152,
	A24_MARK = 1153,
	IP0SR1_7_4_MARK___4 = 1154,
	HRX0_MARK___8 = 1155,
	RX0_MARK___8 = 1156,
	A1_MARK___6 = 1157,
	IP1SR1_7_4_MARK___3 = 1158,
	MSIOF0_SYNC_MARK___10 = 1159,
	DU_DR5_MARK___7 = 1160,
	A9_MARK___6 = 1161,
	IP2SR1_7_4_MARK___3 = 1162,
	MSIOF1_SS2_MARK___7 = 1163,
	HTX3_MARK___3 = 1164,
	TX3_MARK___3 = 1165,
	DU_DG7_MARK___7 = 1166,
	A17_MARK___6 = 1167,
	IP3SR1_7_4_MARK___3 = 1168,
	IRQ1_MARK___7 = 1169,
	DU_HSYNC_MARK___3 = 1170,
	A25_MARK = 1171,
	IP0SR1_11_8_MARK___4 = 1172,
	HSCK0_MARK___8 = 1173,
	SCK0_MARK___8 = 1174,
	A2_MARK___6 = 1175,
	IP1SR1_11_8_MARK___3 = 1176,
	MSIOF0_SS1_MARK___10 = 1177,
	DU_DR6_MARK___7 = 1178,
	A10_MARK___6 = 1179,
	IP2SR1_11_8_MARK___3 = 1180,
	MSIOF2_RXD_MARK___6 = 1181,
	HSCK1_MARK___3 = 1182,
	SCK1_MARK___7 = 1183,
	DU_DB2_MARK___7 = 1184,
	A18_MARK___6 = 1185,
	IP3SR1_11_8_MARK___3 = 1186,
	IRQ2_MARK___7 = 1187,
	DU_VSYNC_MARK___3 = 1188,
	CS1_N_A26_MARK___2 = 1189,
	IP0SR1_15_12_MARK___4 = 1190,
	HRTS0_N_MARK___8 = 1191,
	RTS0_N_MARK___9 = 1192,
	A3_MARK___6 = 1193,
	IP1SR1_15_12_MARK___3 = 1194,
	MSIOF0_SS2_MARK___10 = 1195,
	DU_DR7_MARK___7 = 1196,
	A11_MARK___6 = 1197,
	IP2SR1_15_12_MARK___3 = 1198,
	MSIOF2_TXD_MARK___6 = 1199,
	HCTS1_N_MARK___3 = 1200,
	CTS1_N_MARK___8 = 1201,
	DU_DB3_MARK___7 = 1202,
	A19_MARK___6 = 1203,
	IP3SR1_15_12_MARK___3 = 1204,
	IRQ3_MARK___7 = 1205,
	DU_ODDF_DISP_CDE_MARK = 1206,
	CS0_N_MARK___6 = 1207,
	IP0SR1_19_16_MARK___4 = 1208,
	HCTS0_N_MARK___8 = 1209,
	CTS0_N_MARK___9 = 1210,
	A4_MARK___6 = 1211,
	IP1SR1_19_16_MARK___3 = 1212,
	MSIOF1_RXD_MARK___7 = 1213,
	DU_DG2_MARK___7 = 1214,
	A12_MARK___6 = 1215,
	IP2SR1_19_16_MARK___3 = 1216,
	MSIOF2_SCK_MARK___6 = 1217,
	HRTS1_N_MARK___3 = 1218,
	RTS1_N_MARK___8 = 1219,
	DU_DB4_MARK___7 = 1220,
	A20_MARK = 1221,
	IP3SR1_19_16_MARK___3 = 1222,
	GP1_28_MARK = 1223,
	D0_MARK___6 = 1224,
	IP0SR1_23_20_MARK___4 = 1225,
	HTX0_MARK___8 = 1226,
	TX0_MARK___8 = 1227,
	A5_MARK___6 = 1228,
	IP1SR1_23_20_MARK___3 = 1229,
	MSIOF1_TXD_MARK___7 = 1230,
	HRX3_MARK___3 = 1231,
	SCK3_MARK___6 = 1232,
	DU_DG3_MARK___7 = 1233,
	A13_MARK___6 = 1234,
	IP2SR1_23_20_MARK___3 = 1235,
	MSIOF2_SYNC_MARK___5 = 1236,
	HRX1_MARK___3 = 1237,
	RX1_A_MARK___8 = 1238,
	DU_DB5_MARK___7 = 1239,
	A21_MARK = 1240,
	IP3SR1_23_20_MARK___2 = 1241,
	GP1_29_MARK = 1242,
	D1_MARK___6 = 1243,
	IP0SR1_27_24_MARK___4 = 1244,
	MSIOF0_RXD_MARK___10 = 1245,
	DU_DR2_MARK___7 = 1246,
	A6_MARK___6 = 1247,
	IP1SR1_27_24_MARK___3 = 1248,
	MSIOF1_SCK_MARK___7 = 1249,
	HSCK3_MARK___6 = 1250,
	CTS3_N_MARK___6 = 1251,
	DU_DG4_MARK___7 = 1252,
	A14_MARK___6 = 1253,
	IP2SR1_27_24_MARK___3 = 1254,
	MSIOF2_SS1_MARK___6 = 1255,
	HTX1_MARK___3 = 1256,
	TX1_A_MARK___8 = 1257,
	DU_DB6_MARK___7 = 1258,
	A22_MARK = 1259,
	IP3SR1_27_24_MARK = 1260,
	GP1_30_MARK = 1261,
	D2_MARK___6 = 1262,
	IP0SR1_31_28_MARK___4 = 1263,
	MSIOF0_TXD_MARK___10 = 1264,
	DU_DR3_MARK___7 = 1265,
	A7_MARK___6 = 1266,
	IP1SR1_31_28_MARK___3 = 1267,
	MSIOF1_SYNC_MARK___7 = 1268,
	HRTS3_N_MARK___7 = 1269,
	RTS3_N_MARK___6 = 1270,
	DU_DG5_MARK___7 = 1271,
	A15_MARK___6 = 1272,
	IP2SR1_31_28_MARK___3 = 1273,
	MSIOF2_SS2_MARK___6 = 1274,
	TCLK1_B_MARK___9 = 1275,
	DU_DB7_MARK___7 = 1276,
	A23_MARK = 1277,
	IP0SR2_3_0_MARK___3 = 1278,
	IPC_CLKIN_MARK___2 = 1279,
	IPC_CLKEN_IN_MARK___2 = 1280,
	DU_DOTCLKIN_MARK = 1281,
	IP1SR2_3_0_MARK___3 = 1282,
	GP2_08_MARK = 1283,
	HRX2_MARK___5 = 1284,
	MSIOF4_SS1_MARK___3 = 1285,
	RX4_MARK___5 = 1286,
	D9_MARK___6 = 1287,
	IP2SR2_3_0_MARK___2 = 1288,
	FXR_TXDA_A_MARK = 1289,
	MSIOF3_SS1_MARK___5 = 1290,
	IP0SR2_7_4_MARK___3 = 1291,
	IPC_CLKOUT_MARK___2 = 1292,
	IPC_CLKEN_OUT_MARK___2 = 1293,
	IP1SR2_7_4_MARK___3 = 1294,
	GP2_09_MARK = 1295,
	HTX2_MARK___5 = 1296,
	MSIOF4_SS2_MARK___3 = 1297,
	TX4_MARK___5 = 1298,
	D10_MARK___6 = 1299,
	IP2SR2_7_4_MARK___3 = 1300,
	RXDA_EXTFXR_A_MARK = 1301,
	MSIOF3_SS2_MARK___5 = 1302,
	BS_N_MARK___6 = 1303,
	IP0SR2_11_8_MARK___3 = 1304,
	GP2_02_MARK = 1305,
	D3_MARK___6 = 1306,
	IP1SR2_11_8_MARK___3 = 1307,
	GP2_10_MARK = 1308,
	TCLK2_B_MARK___9 = 1309,
	MSIOF5_RXD_MARK___3 = 1310,
	D11_MARK___6 = 1311,
	IP2SR2_11_8_MARK___2 = 1312,
	FXR_TXDB_MARK___4 = 1313,
	MSIOF3_RXD_MARK___5 = 1314,
	RD_N_MARK___6 = 1315,
	IP0SR2_15_12_MARK___3 = 1316,
	GP2_03_MARK = 1317,
	D4_MARK___6 = 1318,
	IP1SR2_15_12_MARK___3 = 1319,
	GP2_11_MARK = 1320,
	TCLK3_MARK___3 = 1321,
	MSIOF5_TXD_MARK___3 = 1322,
	D12_MARK___6 = 1323,
	IP2SR2_15_12_MARK___3 = 1324,
	RXDB_EXTFXR_MARK___4 = 1325,
	MSIOF3_TXD_MARK___5 = 1326,
	WE0_N_MARK___6 = 1327,
	IP0SR2_19_16_MARK___3 = 1328,
	GP2_04_MARK = 1329,
	MSIOF4_RXD_MARK___3 = 1330,
	D5_MARK___6 = 1331,
	IP1SR2_19_16_MARK___3 = 1332,
	GP2_12_MARK = 1333,
	TCLK4_MARK___3 = 1334,
	MSIOF5_SCK_MARK___3 = 1335,
	D13_MARK___6 = 1336,
	IP2SR2_19_16_MARK = 1337,
	CLK_EXTFXR_MARK___4 = 1338,
	MSIOF3_SCK_MARK___5 = 1339,
	WE1_N_MARK___6 = 1340,
	IP0SR2_23_20_MARK___3 = 1341,
	GP2_05_MARK = 1342,
	HSCK2_MARK___5 = 1343,
	MSIOF4_TXD_MARK___3 = 1344,
	SCK4_MARK___5 = 1345,
	D6_MARK___6 = 1346,
	IP1SR2_23_20_MARK___3 = 1347,
	GP2_13_MARK = 1348,
	MSIOF5_SYNC_MARK___3 = 1349,
	D14_MARK___6 = 1350,
	IP2SR2_23_20_MARK = 1351,
	TPU0TO0_MARK___6 = 1352,
	MSIOF3_SYNC_MARK___5 = 1353,
	RD_WR_N_MARK___6 = 1354,
	IP0SR2_27_24_MARK___3 = 1355,
	GP2_06_MARK = 1356,
	HCTS2_N_MARK___5 = 1357,
	MSIOF4_SCK_MARK___3 = 1358,
	CTS4_N_MARK___5 = 1359,
	D7_MARK___6 = 1360,
	IP1SR2_27_24_MARK___3 = 1361,
	GP2_14_MARK = 1362,
	IRQ4_MARK___7 = 1363,
	MSIOF5_SS1_MARK___3 = 1364,
	D15_MARK___6 = 1365,
	IP2SR2_27_24_MARK = 1366,
	TPU0TO1_MARK___6 = 1367,
	CLKOUT_MARK___6 = 1368,
	IP0SR2_31_28_MARK___3 = 1369,
	GP2_07_MARK = 1370,
	HRTS2_N_MARK___5 = 1371,
	MSIOF4_SYNC_MARK___3 = 1372,
	RTS4_N_MARK___5 = 1373,
	D8_MARK___6 = 1374,
	IP1SR2_31_28_MARK___3 = 1375,
	GP2_15_MARK = 1376,
	IRQ5_MARK___9 = 1377,
	MSIOF5_SS2_MARK___3 = 1378,
	CPG_CPCKOUT_MARK___2 = 1379,
	IP2SR2_31_28_MARK = 1380,
	TCLK1_A_MARK___9 = 1381,
	EX_WAIT0_MARK___3 = 1382,
	IP1SR3_3_0_MARK___3 = 1383,
	CANFD3_RX_MARK___3 = 1384,
	PWM3_MARK = 1385,
	IP0SR3_7_4_MARK___3 = 1386,
	CANFD0_TX_MARK___5 = 1387,
	FXR_TXDA_B_MARK = 1388,
	TX1_B_MARK___8 = 1389,
	IP1SR3_7_4_MARK___3 = 1390,
	CANFD4_TX_MARK___2 = 1391,
	PWM4_MARK___3 = 1392,
	FXR_CLKOUT1_MARK = 1393,
	IP0SR3_11_8_MARK___3 = 1394,
	CANFD0_RX_MARK___5 = 1395,
	RXDA_EXTFXR_B_MARK = 1396,
	RX1_B_MARK___8 = 1397,
	IP1SR3_11_8_MARK___3 = 1398,
	CANFD4_RX_MARK___2 = 1399,
	FXR_CLKOUT2_MARK = 1400,
	IP1SR3_15_12_MARK___3 = 1401,
	CANFD5_TX_MARK = 1402,
	FXR_TXENA_N_MARK___2 = 1403,
	IP1SR3_19_16_MARK___3 = 1404,
	CANFD5_RX_MARK = 1405,
	FXR_TXENB_N_MARK___2 = 1406,
	IP0SR3_23_20_MARK___3 = 1407,
	CANFD2_TX_MARK___3 = 1408,
	TPU0TO2_MARK___6 = 1409,
	PWM0_MARK___5 = 1410,
	IP1SR3_23_20_MARK___3 = 1411,
	CANFD6_TX_MARK___2 = 1412,
	STPWT_EXTFXR_MARK___3 = 1413,
	IP0SR3_27_24_MARK___3 = 1414,
	CANFD2_RX_MARK___3 = 1415,
	TPU0TO3_MARK___6 = 1416,
	PWM1_MARK = 1417,
	IP0SR3_31_28_MARK___3 = 1418,
	CANFD3_TX_MARK___3 = 1419,
	PWM2_MARK___2 = 1420,
	IP0SR4_3_0_MARK___3 = 1421,
	AVB0_RX_CTL_MARK___4 = 1422,
	AVB0_MII_RX_DV_MARK___3 = 1423,
	IP1SR4_3_0_MARK___3 = 1424,
	AVB0_TD0_MARK___4 = 1425,
	AVB0_MII_TD0_MARK___3 = 1426,
	IP0SR4_7_4_MARK___3 = 1427,
	AVB0_RXC_MARK___4 = 1428,
	AVB0_MII_RXC_MARK___3 = 1429,
	IP1SR4_7_4_MARK___3 = 1430,
	AVB0_TD1_MARK___4 = 1431,
	AVB0_MII_TD1_MARK___3 = 1432,
	IP2SR4_7_4_MARK___2 = 1433,
	AVB0_LINK_MARK___4 = 1434,
	AVB0_MII_TX_ER_MARK___3 = 1435,
	IP0SR4_11_8_MARK___3 = 1436,
	AVB0_RD0_MARK___4 = 1437,
	AVB0_MII_RD0_MARK___3 = 1438,
	IP1SR4_11_8_MARK___3 = 1439,
	AVB0_TD2_MARK___4 = 1440,
	AVB0_MII_TD2_MARK___3 = 1441,
	IP2SR4_11_8_MARK___2 = 1442,
	AVB0_AVTP_MATCH_MARK___3 = 1443,
	AVB0_MII_RX_ER_MARK___3 = 1444,
	CC5_OSCOUT_MARK___3 = 1445,
	IP0SR4_15_12_MARK___3 = 1446,
	AVB0_RD1_MARK___4 = 1447,
	AVB0_MII_RD1_MARK___3 = 1448,
	IP1SR4_15_12_MARK___3 = 1449,
	AVB0_TD3_MARK___4 = 1450,
	AVB0_MII_TD3_MARK___3 = 1451,
	IP2SR4_15_12_MARK___2 = 1452,
	AVB0_AVTP_CAPTURE_MARK___3 = 1453,
	AVB0_MII_CRS_MARK___3 = 1454,
	IP0SR4_19_16_MARK___3 = 1455,
	AVB0_RD2_MARK___4 = 1456,
	AVB0_MII_RD2_MARK___3 = 1457,
	IP1SR4_19_16_MARK___3 = 1458,
	AVB0_TXCREFCLK_MARK___4 = 1459,
	IP2SR4_19_16_MARK___2 = 1460,
	AVB0_AVTP_PPS_MARK___3 = 1461,
	AVB0_MII_COL_MARK___3 = 1462,
	IP0SR4_23_20_MARK___3 = 1463,
	AVB0_RD3_MARK___4 = 1464,
	AVB0_MII_RD3_MARK___3 = 1465,
	IP1SR4_23_20_MARK___3 = 1466,
	AVB0_MDIO_MARK___4 = 1467,
	IP0SR4_27_24_MARK___3 = 1468,
	AVB0_TX_CTL_MARK___4 = 1469,
	AVB0_MII_TX_EN_MARK___3 = 1470,
	IP1SR4_27_24_MARK___3 = 1471,
	AVB0_MDC_MARK___4 = 1472,
	IP0SR4_31_28_MARK___3 = 1473,
	AVB0_TXC_MARK___4 = 1474,
	AVB0_MII_TXC_MARK___3 = 1475,
	IP1SR4_31_28_MARK___3 = 1476,
	AVB0_MAGIC_MARK___4 = 1477,
	IP0SR5_3_0_MARK___3 = 1478,
	AVB1_RX_CTL_MARK___3 = 1479,
	AVB1_MII_RX_DV_MARK___3 = 1480,
	IP1SR5_3_0_MARK___3 = 1481,
	AVB1_TD0_MARK___3 = 1482,
	AVB1_MII_TD0_MARK___3 = 1483,
	IP0SR5_7_4_MARK___3 = 1484,
	AVB1_RXC_MARK___3 = 1485,
	AVB1_MII_RXC_MARK___3 = 1486,
	IP1SR5_7_4_MARK___3 = 1487,
	AVB1_TD1_MARK___3 = 1488,
	AVB1_MII_TD1_MARK___3 = 1489,
	IP2SR5_7_4_MARK___3 = 1490,
	AVB1_LINK_MARK___3 = 1491,
	AVB1_MII_TX_ER_MARK___3 = 1492,
	IP0SR5_11_8_MARK___3 = 1493,
	AVB1_RD0_MARK___3 = 1494,
	AVB1_MII_RD0_MARK___3 = 1495,
	IP1SR5_11_8_MARK___3 = 1496,
	AVB1_TD2_MARK___3 = 1497,
	AVB1_MII_TD2_MARK___3 = 1498,
	IP2SR5_11_8_MARK___3 = 1499,
	AVB1_AVTP_MATCH_MARK___3 = 1500,
	AVB1_MII_RX_ER_MARK___3 = 1501,
	IP0SR5_15_12_MARK___3 = 1502,
	AVB1_RD1_MARK___3 = 1503,
	AVB1_MII_RD1_MARK___3 = 1504,
	IP1SR5_15_12_MARK___3 = 1505,
	AVB1_TD3_MARK___3 = 1506,
	AVB1_MII_TD3_MARK___3 = 1507,
	IP2SR5_15_12_MARK___3 = 1508,
	AVB1_AVTP_CAPTURE_MARK___3 = 1509,
	AVB1_MII_CRS_MARK___3 = 1510,
	IP0SR5_19_16_MARK___3 = 1511,
	AVB1_RD2_MARK___3 = 1512,
	AVB1_MII_RD2_MARK___3 = 1513,
	IP1SR5_19_16_MARK___3 = 1514,
	AVB1_TXCREFCLK_MARK___3 = 1515,
	IP2SR5_19_16_MARK___3 = 1516,
	AVB1_AVTP_PPS_MARK___3 = 1517,
	AVB1_MII_COL_MARK___3 = 1518,
	IP0SR5_23_20_MARK___3 = 1519,
	AVB1_RD3_MARK___3 = 1520,
	AVB1_MII_RD3_MARK___3 = 1521,
	IP1SR5_23_20_MARK___3 = 1522,
	AVB1_MDIO_MARK___3 = 1523,
	IP0SR5_27_24_MARK___3 = 1524,
	AVB1_TX_CTL_MARK___3 = 1525,
	AVB1_MII_TX_EN_MARK___3 = 1526,
	IP1SR5_27_24_MARK___3 = 1527,
	AVB1_MDC_MARK___3 = 1528,
	IP0SR5_31_28_MARK___3 = 1529,
	AVB1_TXC_MARK___3 = 1530,
	AVB1_MII_TXC_MARK___3 = 1531,
	IP1SR5_31_28_MARK___3 = 1532,
	AVB1_MAGIC_MARK___3 = 1533,
	SEL_I2C6_0_MARK___5 = 1534,
	SEL_I2C6_3_MARK = 1535,
	SEL_I2C5_0_MARK___2 = 1536,
	SEL_I2C5_3_MARK___2 = 1537,
	SEL_I2C4_0_MARK___2 = 1538,
	SEL_I2C4_3_MARK___2 = 1539,
	SEL_I2C3_0_MARK___3 = 1540,
	SEL_I2C3_3_MARK___2 = 1541,
	SEL_I2C2_0_MARK___7 = 1542,
	SEL_I2C2_3_MARK___3 = 1543,
	SEL_I2C1_0_MARK___6 = 1544,
	SEL_I2C1_3_MARK___3 = 1545,
	SEL_I2C0_0_MARK___2 = 1546,
	SEL_I2C0_3_MARK___2 = 1547,
	SCL0_MARK___9 = 1548,
	SDA0_MARK___9 = 1549,
	SCL1_MARK___6 = 1550,
	SDA1_MARK___6 = 1551,
	SCL2_MARK___5 = 1552,
	SDA2_MARK___5 = 1553,
	SCL3_MARK___8 = 1554,
	SDA3_MARK___8 = 1555,
	SCL4_MARK___5 = 1556,
	SDA4_MARK___5 = 1557,
	SCL5_MARK___8 = 1558,
	SDA5_MARK___8 = 1559,
	SCL6_MARK = 1560,
	SDA6_MARK = 1561,
	PINMUX_MARK_END___10 = 1562,
};

enum {
	PINMUX_RESERVED___11 = 0,
	PINMUX_DATA_BEGIN___11 = 1,
	GP_0_0_DATA___11 = 2,
	GP_0_1_DATA___11 = 3,
	GP_0_2_DATA___11 = 4,
	GP_0_3_DATA___11 = 5,
	GP_0_4_DATA___11 = 6,
	GP_0_5_DATA___11 = 7,
	GP_0_6_DATA___11 = 8,
	GP_0_7_DATA___11 = 9,
	GP_0_8_DATA___11 = 10,
	GP_0_9_DATA___10 = 11,
	GP_0_10_DATA___10 = 12,
	GP_0_11_DATA___10 = 13,
	GP_0_12_DATA___10 = 14,
	GP_0_13_DATA___10 = 15,
	GP_0_14_DATA___10 = 16,
	GP_0_15_DATA___10 = 17,
	GP_0_16_DATA___7 = 18,
	GP_0_17_DATA___7 = 19,
	GP_0_18_DATA___6 = 20,
	GP_0_19_DATA___4 = 21,
	GP_0_20_DATA___4 = 22,
	GP_0_21_DATA___3 = 23,
	GP_1_0_DATA___11 = 24,
	GP_1_1_DATA___11 = 25,
	GP_1_2_DATA___11 = 26,
	GP_1_3_DATA___11 = 27,
	GP_1_4_DATA___11 = 28,
	GP_1_5_DATA___11 = 29,
	GP_1_6_DATA___11 = 30,
	GP_1_7_DATA___11 = 31,
	GP_1_8_DATA___11 = 32,
	GP_1_9_DATA___11 = 33,
	GP_1_10_DATA___11 = 34,
	GP_1_11_DATA___11 = 35,
	GP_1_12_DATA___11 = 36,
	GP_1_13_DATA___11 = 37,
	GP_1_14_DATA___11 = 38,
	GP_1_15_DATA___11 = 39,
	GP_1_16_DATA___11 = 40,
	GP_1_17_DATA___11 = 41,
	GP_1_18_DATA___11 = 42,
	GP_1_19_DATA___11 = 43,
	GP_1_20_DATA___11 = 44,
	GP_1_21_DATA___11 = 45,
	GP_1_22_DATA___11 = 46,
	GP_1_23_DATA___10 = 47,
	GP_1_24_DATA___10 = 48,
	GP_1_25_DATA___9 = 49,
	GP_1_26_DATA___9 = 50,
	GP_1_27_DATA___9 = 51,
	GP_2_0_DATA___11 = 52,
	GP_2_1_DATA___11 = 53,
	GP_2_2_DATA___11 = 54,
	GP_2_3_DATA___11 = 55,
	GP_2_4_DATA___11 = 56,
	GP_2_5_DATA___11 = 57,
	GP_2_6_DATA___11 = 58,
	GP_2_7_DATA___11 = 59,
	GP_2_8_DATA___11 = 60,
	GP_2_9_DATA___11 = 61,
	GP_2_10_DATA___11 = 62,
	GP_2_11_DATA___11 = 63,
	GP_2_12_DATA___11 = 64,
	GP_2_13_DATA___11 = 65,
	GP_2_14_DATA___11 = 66,
	GP_2_15_DATA___8 = 67,
	GP_2_16_DATA___7 = 68,
	GP_3_0_DATA___11 = 69,
	GP_3_1_DATA___11 = 70,
	GP_3_2_DATA___11 = 71,
	GP_3_3_DATA___11 = 72,
	GP_3_4_DATA___11 = 73,
	GP_3_5_DATA___11 = 74,
	GP_3_6_DATA___11 = 75,
	GP_3_7_DATA___11 = 76,
	GP_3_8_DATA___11 = 77,
	GP_3_9_DATA___11 = 78,
	GP_3_10_DATA___10 = 79,
	GP_3_11_DATA___10 = 80,
	GP_3_12_DATA___10 = 81,
	GP_3_13_DATA___10 = 82,
	GP_3_14_DATA___10 = 83,
	GP_3_15_DATA___10 = 84,
	GP_3_16_DATA___6 = 85,
	GP_4_0_DATA___10 = 86,
	GP_4_1_DATA___10 = 87,
	GP_4_2_DATA___10 = 88,
	GP_4_3_DATA___10 = 89,
	GP_4_4_DATA___10 = 90,
	GP_4_5_DATA___10 = 91,
	GP_5_0_DATA___10 = 92,
	GP_5_1_DATA___10 = 93,
	GP_5_2_DATA___10 = 94,
	GP_5_3_DATA___10 = 95,
	GP_5_4_DATA___10 = 96,
	GP_5_5_DATA___10 = 97,
	GP_5_6_DATA___10 = 98,
	GP_5_7_DATA___10 = 99,
	GP_5_8_DATA___10 = 100,
	GP_5_9_DATA___10 = 101,
	GP_5_10_DATA___10 = 102,
	GP_5_11_DATA___10 = 103,
	GP_5_12_DATA___10 = 104,
	GP_5_13_DATA___10 = 105,
	GP_5_14_DATA___10 = 106,
	PINMUX_DATA_END___11 = 107,
	PINMUX_FUNCTION_BEGIN___11 = 108,
	GP_0_0_FN___11 = 109,
	GP_0_1_FN___11 = 110,
	GP_0_2_FN___11 = 111,
	GP_0_3_FN___11 = 112,
	GP_0_4_FN___11 = 113,
	GP_0_5_FN___11 = 114,
	GP_0_6_FN___11 = 115,
	GP_0_7_FN___11 = 116,
	GP_0_8_FN___11 = 117,
	GP_0_9_FN___10 = 118,
	GP_0_10_FN___10 = 119,
	GP_0_11_FN___10 = 120,
	GP_0_12_FN___10 = 121,
	GP_0_13_FN___10 = 122,
	GP_0_14_FN___10 = 123,
	GP_0_15_FN___10 = 124,
	GP_0_16_FN___7 = 125,
	GP_0_17_FN___7 = 126,
	GP_0_18_FN___6 = 127,
	GP_0_19_FN___4 = 128,
	GP_0_20_FN___4 = 129,
	GP_0_21_FN___3 = 130,
	GP_1_0_FN___11 = 131,
	GP_1_1_FN___11 = 132,
	GP_1_2_FN___11 = 133,
	GP_1_3_FN___11 = 134,
	GP_1_4_FN___11 = 135,
	GP_1_5_FN___11 = 136,
	GP_1_6_FN___11 = 137,
	GP_1_7_FN___11 = 138,
	GP_1_8_FN___11 = 139,
	GP_1_9_FN___11 = 140,
	GP_1_10_FN___11 = 141,
	GP_1_11_FN___11 = 142,
	GP_1_12_FN___11 = 143,
	GP_1_13_FN___11 = 144,
	GP_1_14_FN___11 = 145,
	GP_1_15_FN___11 = 146,
	GP_1_16_FN___11 = 147,
	GP_1_17_FN___11 = 148,
	GP_1_18_FN___11 = 149,
	GP_1_19_FN___11 = 150,
	GP_1_20_FN___11 = 151,
	GP_1_21_FN___11 = 152,
	GP_1_22_FN___11 = 153,
	GP_1_23_FN___10 = 154,
	GP_1_24_FN___10 = 155,
	GP_1_25_FN___9 = 156,
	GP_1_26_FN___9 = 157,
	GP_1_27_FN___9 = 158,
	GP_2_0_FN___11 = 159,
	GP_2_1_FN___11 = 160,
	GP_2_2_FN___11 = 161,
	GP_2_3_FN___11 = 162,
	GP_2_4_FN___11 = 163,
	GP_2_5_FN___11 = 164,
	GP_2_6_FN___11 = 165,
	GP_2_7_FN___11 = 166,
	GP_2_8_FN___11 = 167,
	GP_2_9_FN___11 = 168,
	GP_2_10_FN___11 = 169,
	GP_2_11_FN___11 = 170,
	GP_2_12_FN___11 = 171,
	GP_2_13_FN___11 = 172,
	GP_2_14_FN___11 = 173,
	GP_2_15_FN___8 = 174,
	GP_2_16_FN___7 = 175,
	GP_3_0_FN___11 = 176,
	GP_3_1_FN___11 = 177,
	GP_3_2_FN___11 = 178,
	GP_3_3_FN___11 = 179,
	GP_3_4_FN___11 = 180,
	GP_3_5_FN___11 = 181,
	GP_3_6_FN___11 = 182,
	GP_3_7_FN___11 = 183,
	GP_3_8_FN___11 = 184,
	GP_3_9_FN___11 = 185,
	GP_3_10_FN___10 = 186,
	GP_3_11_FN___10 = 187,
	GP_3_12_FN___10 = 188,
	GP_3_13_FN___10 = 189,
	GP_3_14_FN___10 = 190,
	GP_3_15_FN___10 = 191,
	GP_3_16_FN___6 = 192,
	GP_4_0_FN___10 = 193,
	GP_4_1_FN___10 = 194,
	GP_4_2_FN___10 = 195,
	GP_4_3_FN___10 = 196,
	GP_4_4_FN___10 = 197,
	GP_4_5_FN___10 = 198,
	GP_5_0_FN___10 = 199,
	GP_5_1_FN___10 = 200,
	GP_5_2_FN___10 = 201,
	GP_5_3_FN___10 = 202,
	GP_5_4_FN___10 = 203,
	GP_5_5_FN___10 = 204,
	GP_5_6_FN___10 = 205,
	GP_5_7_FN___10 = 206,
	GP_5_8_FN___10 = 207,
	GP_5_9_FN___10 = 208,
	GP_5_10_FN___10 = 209,
	GP_5_11_FN___10 = 210,
	GP_5_12_FN___10 = 211,
	GP_5_13_FN___10 = 212,
	GP_5_14_FN___10 = 213,
	FN_AVB0_AVTP_MATCH___4 = 214,
	FN_AVB0_LINK___5 = 215,
	FN_AVB0_PHY_INT___5 = 216,
	FN_AVB0_MAGIC___5 = 217,
	FN_AVB0_MDC___5 = 218,
	FN_AVB0_MDIO___5 = 219,
	FN_RPC_INT_N___8 = 220,
	FN_AVB0_TXCREFCLK___5 = 221,
	FN_RPC_WP_N___6 = 222,
	FN_AVB0_TD3___5 = 223,
	FN_RPC_RESET_N___8 = 224,
	FN_AVB0_TD2___5 = 225,
	FN_QSPI1_SSL___8 = 226,
	FN_AVB0_TD1___5 = 227,
	FN_QSPI1_IO3___8 = 228,
	FN_AVB0_TD0___5 = 229,
	FN_QSPI1_IO2___8 = 230,
	FN_AVB0_TXC___5 = 231,
	FN_QSPI1_MISO_IO1___8 = 232,
	FN_AVB0_TX_CTL___5 = 233,
	FN_QSPI1_MOSI_IO0___8 = 234,
	FN_AVB0_RD3___5 = 235,
	FN_QSPI1_SPCLK___8 = 236,
	FN_AVB0_RD2___5 = 237,
	FN_QSPI0_SSL___8 = 238,
	FN_AVB0_RD1___5 = 239,
	FN_QSPI0_IO3___8 = 240,
	FN_AVB0_RD0___5 = 241,
	FN_QSPI0_IO2___8 = 242,
	FN_AVB0_RXC___5 = 243,
	FN_QSPI0_MISO_IO1___8 = 244,
	FN_AVB0_RX_CTL___5 = 245,
	FN_QSPI0_MOSI_IO0___8 = 246,
	FN_QSPI0_SPCLK___8 = 247,
	FN_IP0_3_0___7 = 248,
	FN_DU_DR2___8 = 249,
	FN_HSCK0___9 = 250,
	FN_A0___7 = 251,
	FN_IP1_3_0___7 = 252,
	FN_DU_DG4___8 = 253,
	FN_A8___7 = 254,
	FN_FSO_CFE_0_N_A___3 = 255,
	FN_IP2_3_0___7 = 256,
	FN_DU_DB6___8 = 257,
	FN_A16___7 = 258,
	FN_FXR_TXENB_N___3 = 259,
	FN_IP3_3_0___7 = 260,
	FN_VI0_CLKENB___2 = 261,
	FN_MSIOF2_RXD___7 = 262,
	FN_RX3___4 = 263,
	FN_RD_WR_N___7 = 264,
	FN_HCTS3_N___8 = 265,
	FN_IP0_7_4___7 = 266,
	FN_DU_DR3___8 = 267,
	FN_HRTS0_N___9 = 268,
	FN_A1___7 = 269,
	FN_IP1_7_4___7 = 270,
	FN_DU_DG5___8 = 271,
	FN_A9___7 = 272,
	FN_FSO_CFE_1_N_A___3 = 273,
	FN_IP2_7_4___7 = 274,
	FN_DU_DB7___8 = 275,
	FN_A17___7 = 276,
	FN_IP3_7_4___7 = 277,
	FN_VI0_HSYNC_N___2 = 278,
	FN_MSIOF2_TXD___7 = 279,
	FN_TX3___4 = 280,
	FN_HRTS3_N___8 = 281,
	FN_IP0_11_8___7 = 282,
	FN_DU_DR4___8 = 283,
	FN_HCTS0_N___9 = 284,
	FN_A2___7 = 285,
	FN_IP1_11_8___7 = 286,
	FN_DU_DG6___8 = 287,
	FN_A10___7 = 288,
	FN_FSO_TOE_N_A___3 = 289,
	FN_IP2_11_8___7 = 290,
	FN_DU_DOTCLKOUT___3 = 291,
	FN_SCIF_CLK_A___6 = 292,
	FN_A18___7 = 293,
	FN_IP3_11_8___7 = 294,
	FN_VI0_VSYNC_N___2 = 295,
	FN_MSIOF2_SYNC___6 = 296,
	FN_CTS3_N___7 = 297,
	FN_HTX3___4 = 298,
	FN_IP0_15_12___7 = 299,
	FN_DU_DR5___8 = 300,
	FN_HTX0___9 = 301,
	FN_A3___7 = 302,
	FN_IP1_15_12___7 = 303,
	FN_DU_DG7___8 = 304,
	FN_A11___7 = 305,
	FN_IRQ1___8 = 306,
	FN_IP2_15_12___7 = 307,
	FN_DU_EXHSYNC_DU_HSYNC___5 = 308,
	FN_HRX0___9 = 309,
	FN_A19___7 = 310,
	FN_IRQ3___8 = 311,
	FN_IP3_15_12___7 = 312,
	FN_VI0_DATA0___2 = 313,
	FN_MSIOF2_SS1___7 = 314,
	FN_RTS3_N___7 = 315,
	FN_HRX3___4 = 316,
	FN_IP0_19_16___7 = 317,
	FN_DU_DR6___8 = 318,
	FN_MSIOF3_RXD___6 = 319,
	FN_A4___7 = 320,
	FN_IP1_19_16___7 = 321,
	FN_DU_DB2___8 = 322,
	FN_A12___7 = 323,
	FN_IRQ2___8 = 324,
	FN_IP2_19_16___7 = 325,
	FN_DU_EXVSYNC_DU_VSYNC___5 = 326,
	FN_MSIOF3_SCK___6 = 327,
	FN_IP3_19_16___7 = 328,
	FN_VI0_DATA1___2 = 329,
	FN_MSIOF2_SS2___7 = 330,
	FN_SCK1___8 = 331,
	FN_SPEEDIN_A___6 = 332,
	FN_IP0_23_20___7 = 333,
	FN_DU_DR7___8 = 334,
	FN_MSIOF3_TXD___6 = 335,
	FN_A5___7 = 336,
	FN_IP1_23_20___7 = 337,
	FN_DU_DB3___8 = 338,
	FN_A13___7 = 339,
	FN_FXR_CLKOUT1___2 = 340,
	FN_IP2_23_20___7 = 341,
	FN_DU_EXODDF_DU_ODDF_DISP_CDE___5 = 342,
	FN_MSIOF3_SYNC___6 = 343,
	FN_IP3_23_20___7 = 344,
	FN_VI0_DATA2___2 = 345,
	FN_AVB0_AVTP_PPS___4 = 346,
	FN_SDA3_A___2 = 347,
	FN_IP0_27_24___7 = 348,
	FN_DU_DG2___8 = 349,
	FN_MSIOF3_SS1___6 = 350,
	FN_A6___7 = 351,
	FN_IP1_27_24___7 = 352,
	FN_DU_DB4___8 = 353,
	FN_A14___7 = 354,
	FN_FXR_CLKOUT2___2 = 355,
	FN_IP2_27_24___7 = 356,
	FN_IRQ0___8 = 357,
	FN_IP3_27_24___7 = 358,
	FN_VI0_DATA3___2 = 359,
	FN_HSCK1___4 = 360,
	FN_SCL3_A___2 = 361,
	FN_IP0_31_28___7 = 362,
	FN_DU_DG3___8 = 363,
	FN_MSIOF3_SS2___6 = 364,
	FN_A7___7 = 365,
	FN_PWMFSW0___2 = 366,
	FN_IP1_31_28___7 = 367,
	FN_DU_DB5___8 = 368,
	FN_A15___7 = 369,
	FN_FXR_TXENA_N___3 = 370,
	FN_IP2_31_28___7 = 371,
	FN_VI0_CLK___2 = 372,
	FN_MSIOF2_SCK___7 = 373,
	FN_SCK3___7 = 374,
	FN_HSCK3___7 = 375,
	FN_IP3_31_28___7 = 376,
	FN_VI0_DATA4___2 = 377,
	FN_HRTS1_N___4 = 378,
	FN_RX1_A___9 = 379,
	FN_IP4_3_0___7 = 380,
	FN_VI0_DATA5___2 = 381,
	FN_HCTS1_N___4 = 382,
	FN_TX1_A___9 = 383,
	FN_IP5_3_0___7 = 384,
	FN_VI1_CLK___2 = 385,
	FN_MSIOF1_RXD___8 = 386,
	FN_CS0_N___7 = 387,
	FN_IP6_3_0___7 = 388,
	FN_VI1_DATA4___2 = 389,
	FN_CANFD_CLK_B___2 = 390,
	FN_D7___7 = 391,
	FN_MMC_D2___3 = 392,
	FN_IP7_3_0___7 = 393,
	FN_VI1_FIELD___2 = 394,
	FN_SDA4___4 = 395,
	FN_IRQ5___10 = 396,
	FN_D15___7 = 397,
	FN_IP4_7_4___7 = 398,
	FN_VI0_DATA6___2 = 399,
	FN_HTX1___4 = 400,
	FN_CTS1_N___9 = 401,
	FN_IP5_7_4___7 = 402,
	FN_VI1_CLKENB___2 = 403,
	FN_MSIOF1_TXD___8 = 404,
	FN_D0___7 = 405,
	FN_IP6_7_4___7 = 406,
	FN_VI1_DATA5___2 = 407,
	FN_SCK4___6 = 408,
	FN_D8___7 = 409,
	FN_MMC_D3___3 = 410,
	FN_IP7_7_4___7 = 411,
	FN_SCL0___5 = 412,
	FN_DU_DR0___7 = 413,
	FN_TPU0TO0___7 = 414,
	FN_CLKOUT___7 = 415,
	FN_MSIOF0_RXD___11 = 416,
	FN_IP4_11_8___7 = 417,
	FN_VI0_DATA7___2 = 418,
	FN_HRX1___4 = 419,
	FN_RTS1_N___9 = 420,
	FN_IP5_11_8___7 = 421,
	FN_VI1_HSYNC_N___2 = 422,
	FN_MSIOF1_SCK___8 = 423,
	FN_D1___7 = 424,
	FN_IP6_11_8___7 = 425,
	FN_VI1_DATA6___2 = 426,
	FN_RX4___6 = 427,
	FN_D9___7 = 428,
	FN_MMC_CLK___3 = 429,
	FN_IP7_11_8___7 = 430,
	FN_SDA0___5 = 431,
	FN_DU_DR1___7 = 432,
	FN_TPU0TO1___7 = 433,
	FN_BS_N___7 = 434,
	FN_SCK0___9 = 435,
	FN_MSIOF0_TXD___11 = 436,
	FN_IP4_15_12___7 = 437,
	FN_VI0_DATA8___2 = 438,
	FN_HSCK2___6 = 439,
	FN_PWM0_A___5 = 440,
	FN_A22___2 = 441,
	FN_IP5_15_12___7 = 442,
	FN_VI1_VSYNC_N___2 = 443,
	FN_MSIOF1_SYNC___8 = 444,
	FN_D2___7 = 445,
	FN_IP6_15_12___7 = 446,
	FN_VI1_DATA7___2 = 447,
	FN_TX4___6 = 448,
	FN_D10___7 = 449,
	FN_MMC_D4___7 = 450,
	FN_IP7_15_12___4 = 451,
	FN_SCL1___5 = 452,
	FN_DU_DG0___7 = 453,
	FN_TPU0TO2___7 = 454,
	FN_RD_N___7 = 455,
	FN_CTS0_N___10 = 456,
	FN_MSIOF0_SCK___11 = 457,
	FN_IP4_19_16___7 = 458,
	FN_VI0_DATA9___2 = 459,
	FN_HCTS2_N___6 = 460,
	FN_PWM1_A___9 = 461,
	FN_A23___2 = 462,
	FN_FSO_CFE_0_N_B___3 = 463,
	FN_IP5_19_16___7 = 464,
	FN_VI1_DATA0___2 = 465,
	FN_MSIOF1_SS1___8 = 466,
	FN_D3___7 = 467,
	FN_IP6_19_16___7 = 468,
	FN_VI1_DATA8___2 = 469,
	FN_CTS4_N___6 = 470,
	FN_D11___7 = 471,
	FN_MMC_D5___7 = 472,
	FN_IP7_19_16___7 = 473,
	FN_SDA1___5 = 474,
	FN_DU_DG1___7 = 475,
	FN_TPU0TO3___7 = 476,
	FN_WE0_N___7 = 477,
	FN_RTS0_N___10 = 478,
	FN_MSIOF0_SYNC___11 = 479,
	FN_IP4_23_20___7 = 480,
	FN_VI0_DATA10___2 = 481,
	FN_HRTS2_N___6 = 482,
	FN_PWM2_A___8 = 483,
	FN_A24___2 = 484,
	FN_FSO_CFE_1_N_B___3 = 485,
	FN_IP5_23_20___7 = 486,
	FN_VI1_DATA1___2 = 487,
	FN_MSIOF1_SS2___8 = 488,
	FN_D4___7 = 489,
	FN_MMC_CMD___3 = 490,
	FN_IP6_23_20___7 = 491,
	FN_VI1_DATA9___2 = 492,
	FN_RTS4_N___6 = 493,
	FN_D12___7 = 494,
	FN_MMC_D6___7 = 495,
	FN_SCL3_B___2 = 496,
	FN_IP7_23_20___7 = 497,
	FN_SCL2___4 = 498,
	FN_DU_DB0___7 = 499,
	FN_TCLK1_A___10 = 500,
	FN_WE1_N___7 = 501,
	FN_RX0___9 = 502,
	FN_MSIOF0_SS1___11 = 503,
	FN_IP4_27_24___7 = 504,
	FN_VI0_DATA11___2 = 505,
	FN_HTX2___6 = 506,
	FN_PWM3_A___9 = 507,
	FN_A25___2 = 508,
	FN_FSO_TOE_N_B___3 = 509,
	FN_IP5_27_24___7 = 510,
	FN_VI1_DATA2___2 = 511,
	FN_CANFD0_TX_B___5 = 512,
	FN_D5___7 = 513,
	FN_MMC_D0___3 = 514,
	FN_IP6_27_24___7 = 515,
	FN_VI1_DATA10___2 = 516,
	FN_D13___7 = 517,
	FN_MMC_D7___7 = 518,
	FN_SDA3_B___2 = 519,
	FN_IP7_27_24___7 = 520,
	FN_SDA2___4 = 521,
	FN_DU_DB1___7 = 522,
	FN_TCLK2_A___10 = 523,
	FN_EX_WAIT0___4 = 524,
	FN_TX0___9 = 525,
	FN_MSIOF0_SS2___11 = 526,
	FN_IP4_31_28___7 = 527,
	FN_VI0_FIELD___2 = 528,
	FN_HRX2___6 = 529,
	FN_PWM4_A___6 = 530,
	FN_CS1_N___5 = 531,
	FN_FSCLKST2_N_A___4 = 532,
	FN_IP5_31_28___7 = 533,
	FN_VI1_DATA3___2 = 534,
	FN_CANFD0_RX_B___5 = 535,
	FN_D6___7 = 536,
	FN_MMC_D1___3 = 537,
	FN_IP6_31_28___7 = 538,
	FN_VI1_DATA11___2 = 539,
	FN_SCL4___4 = 540,
	FN_IRQ4___8 = 541,
	FN_D14___7 = 542,
	FN_IP7_31_28___7 = 543,
	FN_AVB0_AVTP_CAPTURE___4 = 544,
	FN_FSCLKST2_N_B___4 = 545,
	FN_IP8_3_0___7 = 546,
	FN_CANFD0_TX_A___5 = 547,
	FN_FXR_TXDA___4 = 548,
	FN_PWM0_B___5 = 549,
	FN_DU_DISP___7 = 550,
	FN_FSCLKST2_N_C = 551,
	FN_IP8_7_4___7 = 552,
	FN_CANFD0_RX_A___5 = 553,
	FN_RXDA_EXTFXR___4 = 554,
	FN_PWM1_B___9 = 555,
	FN_DU_CDE___7 = 556,
	FN_IP8_11_8___7 = 557,
	FN_CANFD1_TX___10 = 558,
	FN_FXR_TXDB___5 = 559,
	FN_PWM2_B___8 = 560,
	FN_TCLK1_B___10 = 561,
	FN_TX1_B___9 = 562,
	FN_IP8_15_12___7 = 563,
	FN_CANFD1_RX___10 = 564,
	FN_RXDB_EXTFXR___5 = 565,
	FN_PWM3_B___9 = 566,
	FN_TCLK2_B___10 = 567,
	FN_RX1_B___9 = 568,
	FN_IP8_19_16___7 = 569,
	FN_CANFD_CLK_A___2 = 570,
	FN_CLK_EXTFXR___5 = 571,
	FN_PWM4_B___6 = 572,
	FN_SPEEDIN_B___6 = 573,
	FN_SCIF_CLK_B___6 = 574,
	FN_IP8_23_20___7 = 575,
	FN_DIGRF_CLKIN___2 = 576,
	FN_DIGRF_CLKEN_IN___2 = 577,
	FN_IP8_27_24___7 = 578,
	FN_DIGRF_CLKOUT___2 = 579,
	FN_DIGRF_CLKEN_OUT___2 = 580,
	FN_SEL_I2C3_0___4 = 581,
	FN_SEL_I2C3_1___2 = 582,
	FN_SEL_HSCIF0_0___3 = 583,
	FN_SEL_HSCIF0_1___3 = 584,
	FN_SEL_SCIF1_0___6 = 585,
	FN_SEL_SCIF1_1___6 = 586,
	FN_SEL_CANFD0_0___5 = 587,
	FN_SEL_CANFD0_1___5 = 588,
	FN_SEL_PWM4_0___6 = 589,
	FN_SEL_PWM4_1___6 = 590,
	FN_SEL_PWM3_0___7 = 591,
	FN_SEL_PWM3_1___7 = 592,
	FN_SEL_PWM2_0___7 = 593,
	FN_SEL_PWM2_1___7 = 594,
	FN_SEL_PWM1_0___7 = 595,
	FN_SEL_PWM1_1___7 = 596,
	FN_SEL_PWM0_0___4 = 597,
	FN_SEL_PWM0_1___4 = 598,
	FN_SEL_RFSO_0___2 = 599,
	FN_SEL_RFSO_1___2 = 600,
	FN_SEL_RSP_0___2 = 601,
	FN_SEL_RSP_1___2 = 602,
	FN_SEL_TMU_0___2 = 603,
	FN_SEL_TMU_1___2 = 604,
	PINMUX_FUNCTION_END___11 = 605,
	PINMUX_MARK_BEGIN___11 = 606,
	AVB0_AVTP_MATCH_MARK___4 = 607,
	AVB0_LINK_MARK___5 = 608,
	AVB0_PHY_INT_MARK___5 = 609,
	AVB0_MAGIC_MARK___5 = 610,
	AVB0_MDC_MARK___5 = 611,
	AVB0_MDIO_MARK___5 = 612,
	RPC_INT_N_MARK___8 = 613,
	AVB0_TXCREFCLK_MARK___5 = 614,
	RPC_WP_N_MARK___6 = 615,
	AVB0_TD3_MARK___5 = 616,
	RPC_RESET_N_MARK___8 = 617,
	AVB0_TD2_MARK___5 = 618,
	QSPI1_SSL_MARK___11 = 619,
	AVB0_TD1_MARK___5 = 620,
	QSPI1_IO3_MARK___11 = 621,
	AVB0_TD0_MARK___5 = 622,
	QSPI1_IO2_MARK___11 = 623,
	AVB0_TXC_MARK___5 = 624,
	QSPI1_MISO_IO1_MARK___11 = 625,
	AVB0_TX_CTL_MARK___5 = 626,
	QSPI1_MOSI_IO0_MARK___11 = 627,
	AVB0_RD3_MARK___5 = 628,
	QSPI1_SPCLK_MARK___11 = 629,
	AVB0_RD2_MARK___5 = 630,
	QSPI0_SSL_MARK___11 = 631,
	AVB0_RD1_MARK___5 = 632,
	QSPI0_IO3_MARK___11 = 633,
	AVB0_RD0_MARK___5 = 634,
	QSPI0_IO2_MARK___11 = 635,
	AVB0_RXC_MARK___5 = 636,
	QSPI0_MISO_IO1_MARK___11 = 637,
	AVB0_RX_CTL_MARK___5 = 638,
	QSPI0_MOSI_IO0_MARK___11 = 639,
	QSPI0_SPCLK_MARK___11 = 640,
	IP0_3_0_MARK___7 = 641,
	DU_DR2_MARK___8 = 642,
	HSCK0_MARK___9 = 643,
	A0_MARK___7 = 644,
	IP1_3_0_MARK___7 = 645,
	DU_DG4_MARK___8 = 646,
	A8_MARK___7 = 647,
	FSO_CFE_0_N_A_MARK___3 = 648,
	IP2_3_0_MARK___7 = 649,
	DU_DB6_MARK___8 = 650,
	A16_MARK___7 = 651,
	FXR_TXENB_N_MARK___3 = 652,
	IP3_3_0_MARK___7 = 653,
	VI0_CLKENB_MARK___2 = 654,
	MSIOF2_RXD_MARK___7 = 655,
	RX3_MARK___4 = 656,
	RD_WR_N_MARK___7 = 657,
	HCTS3_N_MARK___8 = 658,
	IP0_7_4_MARK___7 = 659,
	DU_DR3_MARK___8 = 660,
	HRTS0_N_MARK___9 = 661,
	A1_MARK___7 = 662,
	IP1_7_4_MARK___7 = 663,
	DU_DG5_MARK___8 = 664,
	A9_MARK___7 = 665,
	FSO_CFE_1_N_A_MARK___3 = 666,
	IP2_7_4_MARK___7 = 667,
	DU_DB7_MARK___8 = 668,
	A17_MARK___7 = 669,
	IP3_7_4_MARK___7 = 670,
	VI0_HSYNC_N_MARK___2 = 671,
	MSIOF2_TXD_MARK___7 = 672,
	TX3_MARK___4 = 673,
	HRTS3_N_MARK___8 = 674,
	IP0_11_8_MARK___7 = 675,
	DU_DR4_MARK___8 = 676,
	HCTS0_N_MARK___9 = 677,
	A2_MARK___7 = 678,
	IP1_11_8_MARK___7 = 679,
	DU_DG6_MARK___8 = 680,
	A10_MARK___7 = 681,
	FSO_TOE_N_A_MARK___3 = 682,
	IP2_11_8_MARK___7 = 683,
	DU_DOTCLKOUT_MARK___3 = 684,
	SCIF_CLK_A_MARK___6 = 685,
	A18_MARK___7 = 686,
	IP3_11_8_MARK___7 = 687,
	VI0_VSYNC_N_MARK___2 = 688,
	MSIOF2_SYNC_MARK___6 = 689,
	CTS3_N_MARK___7 = 690,
	HTX3_MARK___4 = 691,
	IP0_15_12_MARK___7 = 692,
	DU_DR5_MARK___8 = 693,
	HTX0_MARK___9 = 694,
	A3_MARK___7 = 695,
	IP1_15_12_MARK___7 = 696,
	DU_DG7_MARK___8 = 697,
	A11_MARK___7 = 698,
	IRQ1_MARK___8 = 699,
	IP2_15_12_MARK___7 = 700,
	DU_EXHSYNC_DU_HSYNC_MARK___5 = 701,
	HRX0_MARK___9 = 702,
	A19_MARK___7 = 703,
	IRQ3_MARK___8 = 704,
	IP3_15_12_MARK___7 = 705,
	VI0_DATA0_MARK___2 = 706,
	MSIOF2_SS1_MARK___7 = 707,
	RTS3_N_MARK___7 = 708,
	HRX3_MARK___4 = 709,
	IP0_19_16_MARK___7 = 710,
	DU_DR6_MARK___8 = 711,
	MSIOF3_RXD_MARK___6 = 712,
	A4_MARK___7 = 713,
	IP1_19_16_MARK___7 = 714,
	DU_DB2_MARK___8 = 715,
	A12_MARK___7 = 716,
	IRQ2_MARK___8 = 717,
	IP2_19_16_MARK___7 = 718,
	DU_EXVSYNC_DU_VSYNC_MARK___5 = 719,
	MSIOF3_SCK_MARK___6 = 720,
	IP3_19_16_MARK___7 = 721,
	VI0_DATA1_MARK___2 = 722,
	MSIOF2_SS2_MARK___7 = 723,
	SCK1_MARK___8 = 724,
	SPEEDIN_A_MARK___6 = 725,
	IP0_23_20_MARK___7 = 726,
	DU_DR7_MARK___8 = 727,
	MSIOF3_TXD_MARK___6 = 728,
	A5_MARK___7 = 729,
	IP1_23_20_MARK___7 = 730,
	DU_DB3_MARK___8 = 731,
	A13_MARK___7 = 732,
	FXR_CLKOUT1_MARK___2 = 733,
	IP2_23_20_MARK___7 = 734,
	DU_EXODDF_DU_ODDF_DISP_CDE_MARK___5 = 735,
	MSIOF3_SYNC_MARK___6 = 736,
	IP3_23_20_MARK___7 = 737,
	VI0_DATA2_MARK___2 = 738,
	AVB0_AVTP_PPS_MARK___4 = 739,
	SDA3_A_MARK___2 = 740,
	IP0_27_24_MARK___7 = 741,
	DU_DG2_MARK___8 = 742,
	MSIOF3_SS1_MARK___6 = 743,
	A6_MARK___7 = 744,
	IP1_27_24_MARK___7 = 745,
	DU_DB4_MARK___8 = 746,
	A14_MARK___7 = 747,
	FXR_CLKOUT2_MARK___2 = 748,
	IP2_27_24_MARK___7 = 749,
	IRQ0_MARK___8 = 750,
	IP3_27_24_MARK___7 = 751,
	VI0_DATA3_MARK___2 = 752,
	HSCK1_MARK___4 = 753,
	SCL3_A_MARK___2 = 754,
	IP0_31_28_MARK___7 = 755,
	DU_DG3_MARK___8 = 756,
	MSIOF3_SS2_MARK___6 = 757,
	A7_MARK___7 = 758,
	PWMFSW0_MARK___2 = 759,
	IP1_31_28_MARK___7 = 760,
	DU_DB5_MARK___8 = 761,
	A15_MARK___7 = 762,
	FXR_TXENA_N_MARK___3 = 763,
	IP2_31_28_MARK___7 = 764,
	VI0_CLK_MARK___2 = 765,
	MSIOF2_SCK_MARK___7 = 766,
	SCK3_MARK___7 = 767,
	HSCK3_MARK___7 = 768,
	IP3_31_28_MARK___7 = 769,
	VI0_DATA4_MARK___2 = 770,
	HRTS1_N_MARK___4 = 771,
	RX1_A_MARK___9 = 772,
	IP4_3_0_MARK___7 = 773,
	VI0_DATA5_MARK___2 = 774,
	HCTS1_N_MARK___4 = 775,
	TX1_A_MARK___9 = 776,
	IP5_3_0_MARK___7 = 777,
	VI1_CLK_MARK___2 = 778,
	MSIOF1_RXD_MARK___8 = 779,
	CS0_N_MARK___7 = 780,
	IP6_3_0_MARK___7 = 781,
	VI1_DATA4_MARK___2 = 782,
	CANFD_CLK_B_MARK___2 = 783,
	D7_MARK___7 = 784,
	MMC_D2_MARK___3 = 785,
	IP7_3_0_MARK___7 = 786,
	VI1_FIELD_MARK___2 = 787,
	SDA4_MARK___6 = 788,
	IRQ5_MARK___10 = 789,
	D15_MARK___7 = 790,
	IP4_7_4_MARK___7 = 791,
	VI0_DATA6_MARK___2 = 792,
	HTX1_MARK___4 = 793,
	CTS1_N_MARK___9 = 794,
	IP5_7_4_MARK___7 = 795,
	VI1_CLKENB_MARK___2 = 796,
	MSIOF1_TXD_MARK___8 = 797,
	D0_MARK___7 = 798,
	IP6_7_4_MARK___7 = 799,
	VI1_DATA5_MARK___2 = 800,
	SCK4_MARK___6 = 801,
	D8_MARK___7 = 802,
	MMC_D3_MARK___3 = 803,
	IP7_7_4_MARK___7 = 804,
	SCL0_MARK___10 = 805,
	DU_DR0_MARK___7 = 806,
	TPU0TO0_MARK___7 = 807,
	CLKOUT_MARK___7 = 808,
	MSIOF0_RXD_MARK___11 = 809,
	IP4_11_8_MARK___7 = 810,
	VI0_DATA7_MARK___2 = 811,
	HRX1_MARK___4 = 812,
	RTS1_N_MARK___9 = 813,
	IP5_11_8_MARK___7 = 814,
	VI1_HSYNC_N_MARK___2 = 815,
	MSIOF1_SCK_MARK___8 = 816,
	D1_MARK___7 = 817,
	IP6_11_8_MARK___7 = 818,
	VI1_DATA6_MARK___2 = 819,
	RX4_MARK___6 = 820,
	D9_MARK___7 = 821,
	MMC_CLK_MARK___3 = 822,
	IP7_11_8_MARK___7 = 823,
	SDA0_MARK___10 = 824,
	DU_DR1_MARK___7 = 825,
	TPU0TO1_MARK___7 = 826,
	BS_N_MARK___7 = 827,
	SCK0_MARK___9 = 828,
	MSIOF0_TXD_MARK___11 = 829,
	IP4_15_12_MARK___7 = 830,
	VI0_DATA8_MARK___2 = 831,
	HSCK2_MARK___6 = 832,
	PWM0_A_MARK___5 = 833,
	A22_MARK___2 = 834,
	IP5_15_12_MARK___7 = 835,
	VI1_VSYNC_N_MARK___2 = 836,
	MSIOF1_SYNC_MARK___8 = 837,
	D2_MARK___7 = 838,
	IP6_15_12_MARK___7 = 839,
	VI1_DATA7_MARK___2 = 840,
	TX4_MARK___6 = 841,
	D10_MARK___7 = 842,
	MMC_D4_MARK___7 = 843,
	IP7_15_12_MARK___4 = 844,
	SCL1_MARK___7 = 845,
	DU_DG0_MARK___7 = 846,
	TPU0TO2_MARK___7 = 847,
	RD_N_MARK___7 = 848,
	CTS0_N_MARK___10 = 849,
	MSIOF0_SCK_MARK___11 = 850,
	IP4_19_16_MARK___7 = 851,
	VI0_DATA9_MARK___2 = 852,
	HCTS2_N_MARK___6 = 853,
	PWM1_A_MARK___9 = 854,
	A23_MARK___2 = 855,
	FSO_CFE_0_N_B_MARK___3 = 856,
	IP5_19_16_MARK___7 = 857,
	VI1_DATA0_MARK___2 = 858,
	MSIOF1_SS1_MARK___8 = 859,
	D3_MARK___7 = 860,
	IP6_19_16_MARK___7 = 861,
	VI1_DATA8_MARK___2 = 862,
	CTS4_N_MARK___6 = 863,
	D11_MARK___7 = 864,
	MMC_D5_MARK___7 = 865,
	IP7_19_16_MARK___7 = 866,
	SDA1_MARK___7 = 867,
	DU_DG1_MARK___7 = 868,
	TPU0TO3_MARK___7 = 869,
	WE0_N_MARK___7 = 870,
	RTS0_N_MARK___10 = 871,
	MSIOF0_SYNC_MARK___11 = 872,
	IP4_23_20_MARK___7 = 873,
	VI0_DATA10_MARK___2 = 874,
	HRTS2_N_MARK___6 = 875,
	PWM2_A_MARK___8 = 876,
	A24_MARK___2 = 877,
	FSO_CFE_1_N_B_MARK___3 = 878,
	IP5_23_20_MARK___7 = 879,
	VI1_DATA1_MARK___2 = 880,
	MSIOF1_SS2_MARK___8 = 881,
	D4_MARK___7 = 882,
	MMC_CMD_MARK___3 = 883,
	IP6_23_20_MARK___7 = 884,
	VI1_DATA9_MARK___2 = 885,
	RTS4_N_MARK___6 = 886,
	D12_MARK___7 = 887,
	MMC_D6_MARK___7 = 888,
	SCL3_B_MARK___2 = 889,
	IP7_23_20_MARK___7 = 890,
	SCL2_MARK___6 = 891,
	DU_DB0_MARK___7 = 892,
	TCLK1_A_MARK___10 = 893,
	WE1_N_MARK___7 = 894,
	RX0_MARK___9 = 895,
	MSIOF0_SS1_MARK___11 = 896,
	IP4_27_24_MARK___7 = 897,
	VI0_DATA11_MARK___2 = 898,
	HTX2_MARK___6 = 899,
	PWM3_A_MARK___9 = 900,
	A25_MARK___2 = 901,
	FSO_TOE_N_B_MARK___3 = 902,
	IP5_27_24_MARK___7 = 903,
	VI1_DATA2_MARK___2 = 904,
	CANFD0_TX_B_MARK___5 = 905,
	D5_MARK___7 = 906,
	MMC_D0_MARK___3 = 907,
	IP6_27_24_MARK___7 = 908,
	VI1_DATA10_MARK___2 = 909,
	D13_MARK___7 = 910,
	MMC_D7_MARK___7 = 911,
	SDA3_B_MARK___2 = 912,
	IP7_27_24_MARK___7 = 913,
	SDA2_MARK___6 = 914,
	DU_DB1_MARK___7 = 915,
	TCLK2_A_MARK___10 = 916,
	EX_WAIT0_MARK___4 = 917,
	TX0_MARK___9 = 918,
	MSIOF0_SS2_MARK___11 = 919,
	IP4_31_28_MARK___7 = 920,
	VI0_FIELD_MARK___2 = 921,
	HRX2_MARK___6 = 922,
	PWM4_A_MARK___6 = 923,
	CS1_N_MARK___5 = 924,
	FSCLKST2_N_A_MARK___4 = 925,
	IP5_31_28_MARK___7 = 926,
	VI1_DATA3_MARK___2 = 927,
	CANFD0_RX_B_MARK___5 = 928,
	D6_MARK___7 = 929,
	MMC_D1_MARK___3 = 930,
	IP6_31_28_MARK___7 = 931,
	VI1_DATA11_MARK___2 = 932,
	SCL4_MARK___6 = 933,
	IRQ4_MARK___8 = 934,
	D14_MARK___7 = 935,
	IP7_31_28_MARK___7 = 936,
	AVB0_AVTP_CAPTURE_MARK___4 = 937,
	FSCLKST2_N_B_MARK___4 = 938,
	IP8_3_0_MARK___7 = 939,
	CANFD0_TX_A_MARK___5 = 940,
	FXR_TXDA_MARK___4 = 941,
	PWM0_B_MARK___5 = 942,
	DU_DISP_MARK___7 = 943,
	FSCLKST2_N_C_MARK = 944,
	IP8_7_4_MARK___7 = 945,
	CANFD0_RX_A_MARK___5 = 946,
	RXDA_EXTFXR_MARK___4 = 947,
	PWM1_B_MARK___9 = 948,
	DU_CDE_MARK___7 = 949,
	IP8_11_8_MARK___7 = 950,
	CANFD1_TX_MARK___10 = 951,
	FXR_TXDB_MARK___5 = 952,
	PWM2_B_MARK___8 = 953,
	TCLK1_B_MARK___10 = 954,
	TX1_B_MARK___9 = 955,
	IP8_15_12_MARK___7 = 956,
	CANFD1_RX_MARK___10 = 957,
	RXDB_EXTFXR_MARK___5 = 958,
	PWM3_B_MARK___9 = 959,
	TCLK2_B_MARK___10 = 960,
	RX1_B_MARK___9 = 961,
	IP8_19_16_MARK___7 = 962,
	CANFD_CLK_A_MARK___2 = 963,
	CLK_EXTFXR_MARK___5 = 964,
	PWM4_B_MARK___6 = 965,
	SPEEDIN_B_MARK___6 = 966,
	SCIF_CLK_B_MARK___6 = 967,
	IP8_23_20_MARK___7 = 968,
	DIGRF_CLKIN_MARK___2 = 969,
	DIGRF_CLKEN_IN_MARK___2 = 970,
	IP8_27_24_MARK___7 = 971,
	DIGRF_CLKOUT_MARK___2 = 972,
	DIGRF_CLKEN_OUT_MARK___2 = 973,
	SEL_I2C3_0_MARK___4 = 974,
	SEL_I2C3_1_MARK___2 = 975,
	SEL_HSCIF0_0_MARK___3 = 976,
	SEL_HSCIF0_1_MARK___3 = 977,
	SEL_SCIF1_0_MARK___6 = 978,
	SEL_SCIF1_1_MARK___6 = 979,
	SEL_CANFD0_0_MARK___5 = 980,
	SEL_CANFD0_1_MARK___5 = 981,
	SEL_PWM4_0_MARK___6 = 982,
	SEL_PWM4_1_MARK___6 = 983,
	SEL_PWM3_0_MARK___7 = 984,
	SEL_PWM3_1_MARK___7 = 985,
	SEL_PWM2_0_MARK___7 = 986,
	SEL_PWM2_1_MARK___7 = 987,
	SEL_PWM1_0_MARK___7 = 988,
	SEL_PWM1_1_MARK___7 = 989,
	SEL_PWM0_0_MARK___4 = 990,
	SEL_PWM0_1_MARK___4 = 991,
	SEL_RFSO_0_MARK___2 = 992,
	SEL_RFSO_1_MARK___2 = 993,
	SEL_RSP_0_MARK___2 = 994,
	SEL_RSP_1_MARK___2 = 995,
	SEL_TMU_0_MARK___2 = 996,
	SEL_TMU_1_MARK___2 = 997,
	PINMUX_MARK_END___11 = 998,
};

enum {
	PINMUX_TYPE_NONE = 0,
	PINMUX_TYPE_FUNCTION = 1,
	PINMUX_TYPE_GPIO = 2,
	PINMUX_TYPE_OUTPUT = 3,
	PINMUX_TYPE_INPUT = 4,
};

enum {
	PLAT8250_DEV_LEGACY = -1,
	PLAT8250_DEV_PLATFORM = 0,
	PLAT8250_DEV_PLATFORM1 = 1,
	PLAT8250_DEV_PLATFORM2 = 2,
	PLAT8250_DEV_FOURPORT = 3,
	PLAT8250_DEV_ACCENT = 4,
	PLAT8250_DEV_BOCA = 5,
	PLAT8250_DEV_EXAR_ST16C554 = 6,
	PLAT8250_DEV_HUB6 = 7,
	PLAT8250_DEV_AU1X00 = 8,
	PLAT8250_DEV_SM501 = 9,
};

enum {
	PLL_LOCK_DONE = 0,
	PLL_DIV_S = 1,
	PLL_MOD_EN = 2,
	PLL_SDM_EN = 3,
	PLL_REFIN = 4,
	PLL_IBIAS = 5,
	PLL_N = 6,
	PLL_NINT = 7,
	PLL_KINT = 8,
	PLL_PREDIV = 9,
	PLL_POSTDIV = 10,
	PLL_FACT_MAX = 11,
};

enum {
	PLL_OFF_L_VAL = 0,
	PLL_OFF_CAL_L_VAL = 1,
	PLL_OFF_ALPHA_VAL = 2,
	PLL_OFF_ALPHA_VAL_U = 3,
	PLL_OFF_USER_CTL = 4,
	PLL_OFF_USER_CTL_U = 5,
	PLL_OFF_USER_CTL_U1 = 6,
	PLL_OFF_CONFIG_CTL = 7,
	PLL_OFF_CONFIG_CTL_U = 8,
	PLL_OFF_CONFIG_CTL_U1 = 9,
	PLL_OFF_CONFIG_CTL_U2 = 10,
	PLL_OFF_TEST_CTL = 11,
	PLL_OFF_TEST_CTL_U = 12,
	PLL_OFF_TEST_CTL_U1 = 13,
	PLL_OFF_TEST_CTL_U2 = 14,
	PLL_OFF_TEST_CTL_U3 = 15,
	PLL_OFF_STATE = 16,
	PLL_OFF_STATUS = 17,
	PLL_OFF_OPMODE = 18,
	PLL_OFF_FRAC = 19,
	PLL_OFF_CAL_VAL = 20,
	PLL_OFF_MAX_REGS = 21,
};

enum {
	POOL_BITS = 256,
	POOL_READY_BITS = 256,
	POOL_EARLY_BITS = 128,
};

enum {
	PORT_TYPE_SAS = 2,
	PORT_TYPE_SATA = 1,
};

enum {
	POWERCAP_FC_CAP = 0,
	POWERCAP_FC_PAI = 1,
	POWERCAP_FC_MAX = 2,
};

enum {
	POWER_SUPPLY_CAPACITY_LEVEL_UNKNOWN = 0,
	POWER_SUPPLY_CAPACITY_LEVEL_CRITICAL = 1,
	POWER_SUPPLY_CAPACITY_LEVEL_LOW = 2,
	POWER_SUPPLY_CAPACITY_LEVEL_NORMAL = 3,
	POWER_SUPPLY_CAPACITY_LEVEL_HIGH = 4,
	POWER_SUPPLY_CAPACITY_LEVEL_FULL = 5,
};

enum {
	POWER_SUPPLY_HEALTH_UNKNOWN = 0,
	POWER_SUPPLY_HEALTH_GOOD = 1,
	POWER_SUPPLY_HEALTH_OVERHEAT = 2,
	POWER_SUPPLY_HEALTH_DEAD = 3,
	POWER_SUPPLY_HEALTH_OVERVOLTAGE = 4,
	POWER_SUPPLY_HEALTH_UNDERVOLTAGE = 5,
	POWER_SUPPLY_HEALTH_UNSPEC_FAILURE = 6,
	POWER_SUPPLY_HEALTH_COLD = 7,
	POWER_SUPPLY_HEALTH_WATCHDOG_TIMER_EXPIRE = 8,
	POWER_SUPPLY_HEALTH_SAFETY_TIMER_EXPIRE = 9,
	POWER_SUPPLY_HEALTH_OVERCURRENT = 10,
	POWER_SUPPLY_HEALTH_CALIBRATION_REQUIRED = 11,
	POWER_SUPPLY_HEALTH_WARM = 12,
	POWER_SUPPLY_HEALTH_COOL = 13,
	POWER_SUPPLY_HEALTH_HOT = 14,
	POWER_SUPPLY_HEALTH_NO_BATTERY = 15,
	POWER_SUPPLY_HEALTH_BLOWN_FUSE = 16,
	POWER_SUPPLY_HEALTH_CELL_IMBALANCE = 17,
};

enum {
	POWER_SUPPLY_SCOPE_UNKNOWN = 0,
	POWER_SUPPLY_SCOPE_SYSTEM = 1,
	POWER_SUPPLY_SCOPE_DEVICE = 2,
};

enum {
	POWER_SUPPLY_STATUS_UNKNOWN = 0,
	POWER_SUPPLY_STATUS_CHARGING = 1,
	POWER_SUPPLY_STATUS_DISCHARGING = 2,
	POWER_SUPPLY_STATUS_NOT_CHARGING = 3,
	POWER_SUPPLY_STATUS_FULL = 4,
};

enum {
	POWER_SUPPLY_TECHNOLOGY_UNKNOWN = 0,
	POWER_SUPPLY_TECHNOLOGY_NiMH = 1,
	POWER_SUPPLY_TECHNOLOGY_LION = 2,
	POWER_SUPPLY_TECHNOLOGY_LIPO = 3,
	POWER_SUPPLY_TECHNOLOGY_LiFe = 4,
	POWER_SUPPLY_TECHNOLOGY_NiCd = 5,
	POWER_SUPPLY_TECHNOLOGY_LiMn = 6,
};

enum {
	PREF_UNIT_OP_ON = 8,
	PREF_UNIT_OP_OFF = 4,
	PREF_UNIT_RST_CLR = 2,
	PREF_UNIT_RST_SET = 1,
};

enum {
	PROCESS_SPIN_LOCK = 1,
	PROCESS_RES_LOCK = 2,
	PROCESS_LOCK_IRQ = 4,
};

enum {
	PROC_ENTRY_PERMANENT = 1,
	PROC_ENTRY_proc_read_iter = 2,
	PROC_ENTRY_proc_compat_ioctl = 4,
};

enum {
	PROC_ROOT_INO = 1,
	PROC_IPC_INIT_INO = 4026531839,
	PROC_UTS_INIT_INO = 4026531838,
	PROC_USER_INIT_INO = 4026531837,
	PROC_PID_INIT_INO = 4026531836,
	PROC_CGROUP_INIT_INO = 4026531835,
	PROC_TIME_INIT_INO = 4026531834,
};

enum {
	PSM_CONFIG_REG4_TIMER_PHY_LINK_DETECT_MSK = 240,
	PSM_CONFIG_REG4_TIMER_PHY_LINK_DETECT_BASE = 4,
	PSM_CONFIG_REG4_DEBUG_TIMER = 2,
	PSM_CONFIG_REG4_RST_PHY_LINK_DETECT = 1,
};

enum {
	PULS_NO_STR = 0,
	PULS_21MS = 1,
	PULS_42MS = 2,
	PULS_84MS = 3,
	PULS_170MS = 4,
	PULS_340MS = 5,
	PULS_670MS = 6,
	PULS_1300MS = 7,
};

enum {
	PWMF_REQUESTED = 0,
	PWMF_EXPORTED = 1,
};

enum {
	PWR_DESC_ANY = 0,
	PWR_DESC_PWM = 1,
	PWR_DESC_HS = 2,
	PWR_DESC_SER_A = 1,
	PWR_DESC_SER_B = 2,
	PWR_DESC_G1 = 1,
	PWR_DESC_G2 = 2,
	PWR_DESC_G3 = 3,
	MD_MASK = 3,
	SR_MASK = 3,
	GR_MASK = 7,
};

enum {
	PWR_OK = 0,
	PWR_LOCAL = 1,
	PWR_REMOTE = 2,
	PWR_BUSY = 3,
	PWR_ERROR_CAP = 4,
	PWR_FATAL_ERROR = 5,
};

enum {
	P_AUD_REF_CLK = 0,
	P_BI_TCXO = 1,
	P_GPLL0_OUT_EVEN = 2,
	P_GPLL0_OUT_MAIN = 3,
	P_GPLL1_OUT_MAIN = 4,
	P_GPLL2_OUT_MAIN = 5,
	P_GPLL4_OUT_MAIN = 6,
	P_GPLL5_OUT_MAIN = 7,
	P_GPLL7_OUT_MAIN = 8,
	P_GPLL9_OUT_MAIN = 9,
	P_SLEEP_CLK = 10,
};

enum {
	P_AUD_REF_CLK___2 = 0,
	P_GPLL0_OUT_MAIN___2 = 1,
	P_GPLL4_OUT_MAIN___2 = 2,
	P_PLL0_EARLY_DIV_CLK_SRC = 3,
	P_SLEEP_CLK___2 = 4,
	P_XO = 5,
};

enum {
	P_BI_TCXO___2 = 0,
	P_GCC_GPLL0_OUT_EVEN = 1,
	P_GCC_GPLL0_OUT_MAIN = 2,
	P_GCC_GPLL4_OUT_MAIN = 3,
	P_GCC_GPLL7_OUT_MAIN = 4,
	P_GCC_GPLL9_OUT_MAIN = 5,
	P_PCIE_0_PIPE_CLK = 6,
	P_PCIE_1_PHY_AUX_CLK = 7,
	P_PCIE_1_PIPE_CLK = 8,
	P_SLEEP_CLK___3 = 9,
	P_UFS_PHY_RX_SYMBOL_0_CLK = 10,
	P_UFS_PHY_RX_SYMBOL_1_CLK = 11,
	P_UFS_PHY_TX_SYMBOL_0_CLK = 12,
	P_USB3_PHY_WRAPPER_GCC_USB30_PIPE_CLK = 13,
};

enum {
	P_BI_TCXO___3 = 0,
	P_GCC_GPLL0_OUT_EVEN___2 = 1,
	P_GCC_GPLL0_OUT_MAIN___2 = 2,
	P_GCC_GPLL1_OUT_MAIN = 3,
	P_GCC_GPLL4_OUT_MAIN___2 = 4,
	P_GCC_GPLL7_OUT_MAIN___2 = 5,
	P_GCC_GPLL9_OUT_MAIN___2 = 6,
	P_PCIE_0_PIPE_CLK___2 = 7,
	P_PCIE_1_PIPE_CLK___2 = 8,
	P_PCIE_PHY_AUX_CLK = 9,
	P_RXC0_REF_CLK = 10,
	P_SLEEP_CLK___4 = 11,
	P_UFS_PHY_RX_SYMBOL_0_CLK___2 = 12,
	P_UFS_PHY_RX_SYMBOL_1_CLK___2 = 13,
	P_UFS_PHY_TX_SYMBOL_0_CLK___2 = 14,
	P_USB3_PHY_WRAPPER_GCC_USB30_PRIM_PIPE_CLK = 15,
};

enum {
	P_BI_TCXO___4 = 0,
	P_AUD_REF_CLK___3 = 1,
	P_GPLL0_OUT_EVEN___2 = 2,
	P_GPLL0_OUT_MAIN___3 = 3,
	P_GPLL4_OUT_MAIN___3 = 4,
	P_GPLL6_OUT_MAIN = 5,
	P_SLEEP_CLK___5 = 6,
};

enum {
	P_BI_TCXO___5 = 0,
	P_AUD_REF_CLK___4 = 1,
	P_GPLL0_OUT_EVEN___3 = 2,
	P_GPLL0_OUT_MAIN___4 = 3,
	P_GPLL4_OUT_MAIN___4 = 4,
	P_GPLL9_OUT_MAIN___2 = 5,
	P_SLEEP_CLK___6 = 6,
};

enum {
	P_BI_TCXO___6 = 0,
	P_AUD_REF_CLK___5 = 1,
	P_GPLL0_OUT_EVEN___4 = 2,
	P_GPLL0_OUT_MAIN___5 = 3,
	P_GPLL7_OUT_MAIN___2 = 4,
	P_GPLL9_OUT_MAIN___3 = 5,
	P_SLEEP_CLK___7 = 6,
};

enum {
	P_BI_TCXO___7 = 0,
	P_VIDEO_PLL0_OUT_MAIN = 1,
};

enum {
	P_BI_TCXO___8 = 0,
	P_EMAC0_SGMIIPHY_MAC_RCLK = 1,
	P_EMAC0_SGMIIPHY_MAC_TCLK = 2,
	P_EMAC0_SGMIIPHY_RCLK = 3,
	P_EMAC0_SGMIIPHY_TCLK = 4,
	P_EMAC1_SGMIIPHY_MAC_RCLK = 5,
	P_EMAC1_SGMIIPHY_MAC_TCLK = 6,
	P_EMAC1_SGMIIPHY_RCLK = 7,
	P_EMAC1_SGMIIPHY_TCLK = 8,
	P_GPLL0_OUT_EVEN___5 = 9,
	P_GPLL0_OUT_MAIN___6 = 10,
	P_GPLL4_OUT_MAIN___5 = 11,
	P_GPLL5_OUT_MAIN___2 = 12,
	P_GPLL6_OUT_MAIN___2 = 13,
	P_GPLL8_OUT_MAIN = 14,
	P_PCIE20_PHY_AUX_CLK = 15,
	P_PCIE_1_PIPE_CLK___3 = 16,
	P_PCIE_2_PIPE_CLK = 17,
	P_PCIE_PIPE_CLK = 18,
	P_SLEEP_CLK___8 = 19,
	P_USB3_PHY_WRAPPER_GCC_USB30_PIPE_CLK___2 = 20,
};

enum {
	P_BI_TCXO___9 = 0,
	P_GPLL0_OUT_EVEN___6 = 1,
	P_GPLL0_OUT_MAIN___7 = 2,
	P_GPLL1_OUT_MAIN___2 = 3,
	P_GPLL4_OUT_MAIN___6 = 4,
	P_GPLL6_OUT_MAIN___3 = 5,
	P_GPLL7_OUT_MAIN___3 = 6,
	P_SLEEP_CLK___9 = 7,
};

enum {
	P_BI_TCXO___10 = 0,
	P_GCC_GPLL0_OUT_EVEN___3 = 1,
	P_GCC_GPLL0_OUT_MAIN___3 = 2,
	P_GCC_GPLL0_OUT_ODD = 3,
	P_GCC_GPLL1_OUT_MAIN___2 = 4,
	P_GCC_GPLL3_OUT_MAIN = 5,
	P_GCC_GPLL4_OUT_MAIN___3 = 6,
	P_GCC_GPLL9_OUT_MAIN___3 = 7,
	P_GCC_GPLL10_OUT_MAIN = 8,
	P_SLEEP_CLK___10 = 9,
	P_UFS_PHY_RX_SYMBOL_0_CLK___3 = 10,
	P_UFS_PHY_RX_SYMBOL_1_CLK___3 = 11,
	P_UFS_PHY_TX_SYMBOL_0_CLK___3 = 12,
	P_USB3_PHY_WRAPPER_GCC_USB30_PIPE_CLK___3 = 13,
};

enum {
	P_BI_TCXO___11 = 0,
	P_GPLL0_OUT_MAIN___8 = 1,
	P_GPLL0_OUT_MAIN_DIV = 2,
	P_GPU_CC_PLL0_OUT_MAIN = 3,
	P_GPU_CC_PLL1_OUT_MAIN = 4,
};

enum {
	P_BI_TCXO___12 = 0,
	P_GCC_GPLL0_OUT_EVEN___4 = 1,
	P_GCC_GPLL0_OUT_MAIN___4 = 2,
	P_GCC_GPLL1_OUT_MAIN___3 = 3,
	P_GCC_GPLL2_OUT_MAIN = 4,
	P_GCC_GPLL3_OUT_MAIN___2 = 5,
	P_GCC_GPLL4_OUT_MAIN___4 = 6,
	P_GCC_GPLL5_OUT_MAIN = 7,
	P_GCC_GPLL6_OUT_MAIN = 8,
	P_GCC_GPLL7_OUT_MAIN___3 = 9,
	P_GCC_GPLL8_OUT_MAIN = 10,
	P_PCIE_0_PHY_AUX_CLK = 11,
	P_PCIE_0_PIPE_CLK___3 = 12,
	P_SLEEP_CLK___11 = 13,
	P_USB3_PHY_WRAPPER_GCC_USB30_PIPE_CLK___4 = 14,
};

enum {
	P_BI_TCXO___13 = 0,
	P_GCC_GPLL0_OUT_EVEN___5 = 1,
	P_GCC_GPLL0_OUT_MAIN___5 = 2,
	P_GCC_GPLL2_OUT_MAIN___2 = 3,
	P_GCC_GPLL4_OUT_MAIN___5 = 4,
	P_GCC_GPLL7_OUT_MAIN___4 = 5,
	P_GCC_GPLL8_OUT_MAIN___2 = 6,
	P_GCC_GPLL9_OUT_MAIN___4 = 7,
	P_GCC_USB3_PRIM_PHY_PIPE_CLK_SRC = 8,
	P_GCC_USB3_SEC_PHY_PIPE_CLK_SRC = 9,
	P_GCC_USB4_1_PHY_DP_GMUX_CLK_SRC = 10,
	P_GCC_USB4_1_PHY_PCIE_PIPE_CLK_SRC = 11,
	P_GCC_USB4_1_PHY_PCIE_PIPEGMUX_CLK_SRC = 12,
	P_GCC_USB4_1_PHY_PIPEGMUX_CLK_SRC = 13,
	P_GCC_USB4_1_PHY_SYS_PIPEGMUX_CLK_SRC = 14,
	P_GCC_USB4_PHY_DP_GMUX_CLK_SRC = 15,
	P_GCC_USB4_PHY_PCIE_PIPE_CLK_SRC = 16,
	P_GCC_USB4_PHY_PCIE_PIPEGMUX_CLK_SRC = 17,
	P_GCC_USB4_PHY_PIPEGMUX_CLK_SRC = 18,
	P_GCC_USB4_PHY_SYS_PIPEGMUX_CLK_SRC = 19,
	P_QUSB4PHY_1_GCC_USB4_RX0_CLK = 20,
	P_QUSB4PHY_1_GCC_USB4_RX1_CLK = 21,
	P_QUSB4PHY_GCC_USB4_RX0_CLK = 22,
	P_QUSB4PHY_GCC_USB4_RX1_CLK = 23,
	P_RXC0_REF_CLK___2 = 24,
	P_RXC1_REF_CLK = 25,
	P_SLEEP_CLK___12 = 26,
	P_UFS_CARD_RX_SYMBOL_0_CLK = 27,
	P_UFS_CARD_RX_SYMBOL_1_CLK = 28,
	P_UFS_CARD_TX_SYMBOL_0_CLK = 29,
	P_UFS_PHY_RX_SYMBOL_0_CLK___4 = 30,
	P_UFS_PHY_RX_SYMBOL_1_CLK___4 = 31,
	P_UFS_PHY_TX_SYMBOL_0_CLK___4 = 32,
	P_USB3_PHY_WRAPPER_GCC_USB30_PIPE_CLK___5 = 33,
	P_USB3_UNI_PHY_MP_GCC_USB30_PIPE_0_CLK = 34,
	P_USB3_UNI_PHY_MP_GCC_USB30_PIPE_1_CLK = 35,
	P_USB3_UNI_PHY_SEC_GCC_USB30_PIPE_CLK = 36,
	P_USB4_1_PHY_GCC_USB4_PCIE_PIPE_CLK = 37,
	P_USB4_1_PHY_GCC_USB4RTR_MAX_PIPE_CLK = 38,
	P_USB4_PHY_GCC_USB4_PCIE_PIPE_CLK = 39,
	P_USB4_PHY_GCC_USB4RTR_MAX_PIPE_CLK = 40,
};

enum {
	P_BI_TCXO___14 = 0,
	P_GPLL0_OUT_AUX2_DIV = 1,
	P_GPLL0_OUT_MAIN___9 = 2,
	P_GPLL3_OUT_MAIN = 3,
	P_GPLL3_OUT_MAIN_DIV = 4,
	P_GPLL4_OUT_MAIN___7 = 5,
	P_GPLL6_OUT_MAIN___4 = 6,
	P_GPLL7_OUT_MAIN___4 = 7,
	P_GPLL8_OUT_MAIN___2 = 8,
	P_SLEEP_CLK___13 = 9,
};

enum {
	P_BI_TCXO___15 = 0,
	P_GCC_GPLL0_OUT_EVEN___6 = 1,
	P_GCC_GPLL0_OUT_MAIN___6 = 2,
	P_GCC_GPLL1_OUT_MAIN___4 = 3,
	P_GCC_GPLL4_OUT_MAIN___6 = 4,
	P_GCC_GPLL7_OUT_MAIN___5 = 5,
	P_GCC_GPLL9_OUT_MAIN___5 = 6,
	P_PCIE_0_PIPE_CLK___4 = 7,
	P_SLEEP_CLK___14 = 8,
	P_UFS_PHY_RX_SYMBOL_0_CLK___5 = 9,
	P_UFS_PHY_RX_SYMBOL_1_CLK___5 = 10,
	P_UFS_PHY_TX_SYMBOL_0_CLK___5 = 11,
	P_USB3_PHY_WRAPPER_GCC_USB30_PIPE_CLK___6 = 12,
};

enum {
	P_BI_TCXO___16 = 0,
	P_GCC_GPLL0_OUT_EVEN___7 = 1,
	P_GCC_GPLL0_OUT_MAIN___7 = 2,
	P_GCC_GPLL0_OUT_ODD___2 = 3,
	P_GCC_GPLL10_OUT_MAIN___2 = 4,
	P_GCC_GPLL4_OUT_MAIN___7 = 5,
	P_GCC_GPLL9_OUT_MAIN___6 = 6,
	P_PCIE_0_PIPE_CLK___5 = 7,
	P_PCIE_1_PIPE_CLK___4 = 8,
	P_SLEEP_CLK___15 = 9,
	P_UFS_PHY_RX_SYMBOL_0_CLK___6 = 10,
	P_UFS_PHY_RX_SYMBOL_1_CLK___6 = 11,
	P_UFS_PHY_TX_SYMBOL_0_CLK___6 = 12,
	P_USB3_PHY_WRAPPER_GCC_USB30_PIPE_CLK___7 = 13,
	P_GCC_MSS_GPLL0_MAIN_DIV_CLK = 14,
};

enum {
	P_BI_TCXO___17 = 0,
	P_DISP_CC_PLL0_OUT_MAIN = 1,
	P_DISP_CC_PLL1_OUT_EVEN = 2,
	P_DISP_CC_PLL1_OUT_MAIN = 3,
	P_DP_PHY_PLL_LINK_CLK = 4,
	P_DP_PHY_PLL_VCO_DIV_CLK = 5,
	P_DPTX1_PHY_PLL_LINK_CLK = 6,
	P_DPTX1_PHY_PLL_VCO_DIV_CLK = 7,
	P_DPTX2_PHY_PLL_LINK_CLK = 8,
	P_DPTX2_PHY_PLL_VCO_DIV_CLK = 9,
	P_EDP_PHY_PLL_LINK_CLK = 10,
	P_EDP_PHY_PLL_VCO_DIV_CLK = 11,
	P_DSI0_PHY_PLL_OUT_BYTECLK = 12,
	P_DSI0_PHY_PLL_OUT_DSICLK = 13,
	P_DSI1_PHY_PLL_OUT_BYTECLK = 14,
	P_DSI1_PHY_PLL_OUT_DSICLK = 15,
};

enum {
	P_BI_TCXO___18 = 0,
	P_GCC_GPLL0_OUT_EVEN___8 = 1,
	P_GCC_GPLL0_OUT_MAIN___8 = 2,
	P_GCC_GPLL1_OUT_MAIN___5 = 3,
	P_GCC_GPLL4_OUT_MAIN___8 = 4,
	P_GCC_GPLL5_OUT_MAIN___2 = 5,
	P_GCC_GPLL7_OUT_MAIN___6 = 6,
	P_GCC_GPLL9_OUT_MAIN___7 = 7,
	P_PCIE_0_PIPE_CLK___6 = 8,
	P_PCIE_1_PIPE_CLK___5 = 9,
	P_PCIE_PHY_AUX_CLK___2 = 10,
	P_RXC0_REF_CLK___3 = 11,
	P_RXC1_REF_CLK___2 = 12,
	P_SLEEP_CLK___16 = 13,
	P_UFS_CARD_RX_SYMBOL_0_CLK___2 = 14,
	P_UFS_CARD_RX_SYMBOL_1_CLK___2 = 15,
	P_UFS_CARD_TX_SYMBOL_0_CLK___2 = 16,
	P_UFS_PHY_RX_SYMBOL_0_CLK___7 = 17,
	P_UFS_PHY_RX_SYMBOL_1_CLK___7 = 18,
	P_UFS_PHY_TX_SYMBOL_0_CLK___7 = 19,
	P_USB3_PHY_WRAPPER_GCC_USB30_PRIM_PIPE_CLK___2 = 20,
	P_USB3_PHY_WRAPPER_GCC_USB30_SEC_PIPE_CLK = 21,
};

enum {
	P_BI_TCXO___19 = 0,
	P_GCC_GPLL0_OUT_EVEN___9 = 1,
	P_GCC_GPLL0_OUT_MAIN___9 = 2,
	P_GCC_GPLL1_OUT_MAIN___6 = 3,
	P_GCC_GPLL3_OUT_MAIN___3 = 4,
	P_GCC_GPLL4_OUT_MAIN___9 = 5,
	P_GCC_GPLL6_OUT_MAIN___2 = 6,
	P_GCC_GPLL7_OUT_MAIN___7 = 7,
	P_GCC_GPLL9_OUT_MAIN___8 = 8,
	P_PCIE_0_PIPE_CLK___7 = 9,
	P_PCIE_1_PHY_AUX_CLK___2 = 10,
	P_PCIE_1_PIPE_CLK___6 = 11,
	P_SLEEP_CLK___17 = 12,
	P_UFS_PHY_RX_SYMBOL_0_CLK___8 = 13,
	P_UFS_PHY_RX_SYMBOL_1_CLK___8 = 14,
	P_UFS_PHY_TX_SYMBOL_0_CLK___8 = 15,
	P_USB3_PHY_WRAPPER_GCC_USB30_PIPE_CLK___8 = 16,
};

enum {
	P_BI_TCXO___20 = 0,
	P_DISP_CC_PLL0_OUT_MAIN___2 = 1,
	P_DSI0_PHY_PLL_OUT_BYTECLK___2 = 2,
	P_DSI0_PHY_PLL_OUT_DSICLK___2 = 3,
	P_DSI1_PHY_PLL_OUT_BYTECLK___2 = 4,
	P_DSI1_PHY_PLL_OUT_DSICLK___2 = 5,
	P_GPLL0_OUT_MAIN___10 = 6,
	P_GPLL0_OUT_MAIN_DIV___2 = 7,
	P_DP_PHY_PLL_LINK_CLK___2 = 8,
	P_DP_PHY_PLL_VCO_DIV_CLK___2 = 9,
};

enum {
	P_BI_TCXO___21 = 0,
	P_GCC_GPLL0_OUT_EVEN___10 = 1,
	P_GCC_GPLL0_OUT_MAIN___10 = 2,
	P_SM8475_GCC_GPLL2_OUT_EVEN = 3,
	P_SM8475_GCC_GPLL3_OUT_EVEN = 4,
	P_GCC_GPLL4_OUT_MAIN___10 = 5,
	P_GCC_GPLL9_OUT_MAIN___9 = 6,
	P_PCIE_1_PHY_AUX_CLK___3 = 7,
	P_SLEEP_CLK___18 = 8,
	P_UFS_PHY_RX_SYMBOL_0_CLK___9 = 9,
	P_UFS_PHY_RX_SYMBOL_1_CLK___9 = 10,
	P_UFS_PHY_TX_SYMBOL_0_CLK___9 = 11,
	P_USB3_PHY_WRAPPER_GCC_USB30_PIPE_CLK___9 = 12,
};

enum {
	P_BI_TCXO___22 = 0,
	P_GPLL0_OUT_AUX2 = 1,
	P_GPLL0_OUT_EARLY = 2,
	P_GPLL10_OUT_MAIN = 3,
	P_GPLL11_OUT_MAIN = 4,
	P_GPLL3_OUT_EARLY = 5,
	P_GPLL4_OUT_MAIN___8 = 6,
	P_GPLL6_OUT_EARLY = 7,
	P_GPLL6_OUT_MAIN___5 = 8,
	P_GPLL7_OUT_MAIN___5 = 9,
	P_GPLL8_OUT_EARLY = 10,
	P_GPLL8_OUT_MAIN___3 = 11,
	P_GPLL9_OUT_EARLY = 12,
	P_GPLL9_OUT_MAIN___4 = 13,
	P_SLEEP_CLK___19 = 14,
};

enum {
	P_BI_TCXO___23 = 0,
	P_GPLL0_OUT_AUX2___2 = 1,
	P_GPLL0_OUT_EARLY___2 = 2,
	P_GPLL10_OUT_MAIN___2 = 3,
	P_GPLL11_OUT_AUX = 4,
	P_GPLL11_OUT_AUX2 = 5,
	P_GPLL11_OUT_MAIN___2 = 6,
	P_GPLL3_OUT_EARLY___2 = 7,
	P_GPLL3_OUT_MAIN___2 = 8,
	P_GPLL4_OUT_MAIN___9 = 9,
	P_GPLL5_OUT_MAIN___3 = 10,
	P_GPLL6_OUT_EARLY___2 = 11,
	P_GPLL6_OUT_MAIN___6 = 12,
	P_GPLL7_OUT_MAIN___6 = 13,
	P_GPLL8_OUT_EARLY___2 = 14,
	P_GPLL8_OUT_MAIN___4 = 15,
	P_GPLL9_OUT_EARLY___2 = 16,
	P_GPLL9_OUT_MAIN___5 = 17,
	P_SLEEP_CLK___20 = 18,
};

enum {
	P_BI_TCXO___24 = 0,
	P_VIDEO_PLL0_OUT_MAIN___2 = 1,
	P_VIDEO_PLL1_OUT_MAIN = 2,
};

enum {
	P_BI_TCXO___25 = 0,
	P_GPLL0_OUT_MAIN___11 = 1,
	P_GPLL0_OUT_MAIN_DIV___3 = 2,
	P_GPU_CC_PLL1_OUT_MAIN___2 = 3,
};

enum {
	P_BI_TCXO___26 = 0,
	P_GCC_GPLL0_OUT_EVEN___11 = 1,
	P_GCC_GPLL0_OUT_MAIN___11 = 2,
	P_GCC_GPLL4_OUT_MAIN___11 = 3,
	P_GCC_GPLL9_OUT_MAIN___10 = 4,
	P_PCIE_0_PIPE_CLK___8 = 5,
	P_PCIE_1_PIPE_CLK___7 = 6,
	P_SLEEP_CLK___21 = 7,
	P_UFS_CARD_RX_SYMBOL_0_CLK___3 = 8,
	P_UFS_CARD_RX_SYMBOL_1_CLK___3 = 9,
	P_UFS_CARD_TX_SYMBOL_0_CLK___3 = 10,
	P_UFS_PHY_RX_SYMBOL_0_CLK___10 = 11,
	P_UFS_PHY_RX_SYMBOL_1_CLK___10 = 12,
	P_UFS_PHY_TX_SYMBOL_0_CLK___10 = 13,
	P_USB3_PHY_WRAPPER_GCC_USB30_PIPE_CLK___10 = 14,
	P_USB3_UNI_PHY_SEC_GCC_USB30_PIPE_CLK___2 = 15,
};

enum {
	P_BI_TCXO___27 = 0,
	P_GCC_GPLL0_OUT_EVEN___12 = 1,
	P_GCC_GPLL0_OUT_MAIN___12 = 2,
	P_GCC_GPLL4_OUT_MAIN___12 = 3,
	P_GCC_GPLL7_OUT_MAIN___8 = 4,
	P_GCC_GPLL8_OUT_MAIN___3 = 5,
	P_GCC_GPLL9_OUT_MAIN___11 = 6,
	P_SLEEP_CLK___22 = 7,
	P_USB3_PHY_0_WRAPPER_GCC_USB30_PIPE_CLK = 8,
	P_USB3_PHY_1_WRAPPER_GCC_USB30_PIPE_CLK = 9,
	P_USB3_PHY_2_WRAPPER_GCC_USB30_PIPE_CLK = 10,
};

enum {
	P_DSI0_PHY_PLL_OUT_BYTECLK___3 = 0,
	P_DSI0_PHY_PLL_OUT_DSICLK___3 = 1,
	P_GPLL0_OUT_MAIN___12 = 2,
	P_GPLL1_OUT_MAIN___3 = 3,
	P_GPLL3_OUT_MAIN___3 = 4,
	P_GPLL4_OUT_MAIN___10 = 5,
	P_GPLL6_OUT_AUX = 6,
	P_HDMI_PHY_PLL_CLK = 7,
	P_PCIE_0_PIPE_CLK___9 = 8,
	P_SLEEP_CLK___23 = 9,
	P_XO___2 = 10,
};

enum {
	P_GCC_GPLL0_OUT_MAIN_DIV_CLK_SRC = 0,
	P_GPLL0_OUT_AUX = 1,
	P_GPLL0_OUT_MAIN___13 = 2,
	P_GPLL2_OUT_AUX = 3,
	P_GPLL2_OUT_MAIN___2 = 4,
	P_GPLL4_OUT_AUX = 5,
	P_GPLL4_OUT_MAIN___11 = 6,
	P_SLEEP_CLK___24 = 7,
	P_XO___3 = 8,
	P_USB3PHY_0_PIPE = 9,
};

enum {
	P_PCIE3X2_PIPE = 0,
	P_PCIE3X1_0_PIPE = 1,
	P_PCIE3X1_1_PIPE = 2,
	P_USB3PHY_0_PIPE___2 = 3,
	P_CORE_BI_PLL_TEST_SE = 4,
	P_GCC_GPLL0_OUT_MAIN_DIV_CLK_SRC___2 = 5,
	P_GPLL0_OUT_AUX___2 = 6,
	P_GPLL0_OUT_MAIN___14 = 7,
	P_GPLL2_OUT_AUX___2 = 8,
	P_GPLL2_OUT_MAIN___3 = 9,
	P_GPLL4_OUT_AUX___2 = 10,
	P_GPLL4_OUT_MAIN___12 = 11,
	P_SLEEP_CLK___25 = 12,
	P_XO___4 = 13,
};

enum {
	P_XO___5 = 0,
	P_GPLL0 = 1,
	P_GPLL4 = 2,
};

enum {
	P_XO___6 = 0,
	P_PCIE30_PHY0_PIPE = 1,
	P_PCIE30_PHY1_PIPE = 2,
	P_PCIE30_PHY2_PIPE = 3,
	P_PCIE30_PHY3_PIPE = 4,
	P_USB3PHY_0_PIPE___3 = 5,
	P_GPLL0___2 = 6,
	P_GPLL0_DIV2 = 7,
	P_GPLL0_OUT_AUX___3 = 8,
	P_GPLL2 = 9,
	P_GPLL4___2 = 10,
	P_PI_SLEEP = 11,
	P_BIAS_PLL_UBI_NC_CLK = 12,
};

enum {
	P_XO___7 = 0,
	P_GPLL0___3 = 1,
	P_APSS_PLL_EARLY = 2,
};

enum {
	P_XO___8 = 0,
	P_GPLL0___4 = 1,
	P_GPLL0_DIV2___2 = 2,
	P_GPLL2___2 = 3,
	P_GPLL4___3 = 4,
	P_GPLL6 = 5,
	P_SLEEP_CLK___26 = 6,
	P_PCIE20_PHY0_PIPE = 7,
	P_PCIE20_PHY1_PIPE = 8,
	P_USB3PHY_0_PIPE___4 = 9,
	P_USB3PHY_1_PIPE = 10,
	P_UBI32_PLL = 11,
	P_NSS_CRYPTO_PLL = 12,
	P_BIAS_PLL = 13,
	P_BIAS_PLL_NSS_NOC = 14,
	P_UNIPHY0_RX = 15,
	P_UNIPHY0_TX = 16,
	P_UNIPHY1_RX = 17,
	P_UNIPHY1_TX = 18,
	P_UNIPHY2_RX = 19,
	P_UNIPHY2_TX = 20,
};

enum {
	P_XO___9 = 0,
	P_GPLL0___5 = 1,
	P_GPLL0_AUX = 2,
	P_BIMC = 3,
	P_GPLL1 = 4,
	P_GPLL1_AUX = 5,
	P_GPLL2___3 = 6,
	P_GPLL2_AUX = 7,
	P_SLEEP_CLK___27 = 8,
	P_DSI0_PHYPLL_BYTE = 9,
	P_DSI0_PHYPLL_DSI = 10,
	P_EXT_PRI_I2S = 11,
	P_EXT_SEC_I2S = 12,
	P_EXT_MCLK = 13,
};

enum {
	P_XO___10 = 0,
	P_GPLL0___6 = 1,
	P_GPLL0_EARLY_DIV = 2,
	P_SLEEP_CLK___28 = 3,
	P_GPLL4___4 = 4,
	P_AUD_REF_CLK___6 = 5,
};

enum {
	P_XO___11 = 0,
	P_BIAS_PLL___2 = 1,
	P_UNIPHY0_RX___2 = 2,
	P_UNIPHY0_TX___2 = 3,
	P_UNIPHY1_RX___2 = 4,
	P_BIAS_PLL_NSS_NOC___2 = 5,
	P_UNIPHY1_TX___2 = 6,
	P_PCIE20_PHY0_PIPE___2 = 7,
	P_USB3PHY_0_PIPE___5 = 8,
	P_GPLL0___7 = 9,
	P_GPLL0_DIV2___3 = 10,
	P_GPLL2___4 = 11,
	P_GPLL4___5 = 12,
	P_GPLL6___2 = 13,
	P_SLEEP_CLK___29 = 14,
	P_UBI32_PLL___2 = 15,
	P_NSS_CRYPTO_PLL___2 = 16,
	P_PI_SLEEP___2 = 17,
};

enum {
	P_XO___12 = 0,
	P_CORE_PI_SLEEP_CLK = 1,
	P_PCIE20_PHY0_PIPE___3 = 2,
	P_PCIE20_PHY1_PIPE___2 = 3,
	P_USB3PHY_0_PIPE___6 = 4,
	P_GEPHY_RX = 5,
	P_GEPHY_TX = 6,
	P_UNIPHY_RX = 7,
	P_UNIPHY_TX = 8,
	P_GPLL0___8 = 9,
	P_GPLL0_DIV2___4 = 10,
	P_GPLL2___5 = 11,
	P_GPLL4___6 = 12,
	P_UBI32_PLL___3 = 13,
};

enum {
	QCM2290_MASTER_APPSS_PROC = 1,
	QCM2290_MASTER_SNOC_BIMC_RT = 2,
	QCM2290_MASTER_SNOC_BIMC_NRT = 3,
	QCM2290_MASTER_SNOC_BIMC = 4,
	QCM2290_MASTER_TCU_0 = 5,
	QCM2290_MASTER_GFX3D = 6,
	QCM2290_MASTER_SNOC_CNOC = 7,
	QCM2290_MASTER_QDSS_DAP = 8,
	QCM2290_MASTER_CRYPTO_CORE0 = 9,
	QCM2290_MASTER_SNOC_CFG = 10,
	QCM2290_MASTER_TIC = 11,
	QCM2290_MASTER_ANOC_SNOC = 12,
	QCM2290_MASTER_BIMC_SNOC = 13,
	QCM2290_MASTER_PIMEM = 14,
	QCM2290_MASTER_QDSS_BAM = 15,
	QCM2290_MASTER_QUP_0 = 16,
	QCM2290_MASTER_IPA = 17,
	QCM2290_MASTER_QDSS_ETR = 18,
	QCM2290_MASTER_SDCC_1 = 19,
	QCM2290_MASTER_SDCC_2 = 20,
	QCM2290_MASTER_QPIC = 21,
	QCM2290_MASTER_USB3_0 = 22,
	QCM2290_MASTER_QUP_CORE_0 = 23,
	QCM2290_MASTER_CAMNOC_SF = 24,
	QCM2290_MASTER_VIDEO_P0 = 25,
	QCM2290_MASTER_VIDEO_PROC = 26,
	QCM2290_MASTER_CAMNOC_HF = 27,
	QCM2290_MASTER_MDP0 = 28,
	QCM2290_SLAVE_EBI1 = 29,
	QCM2290_SLAVE_BIMC_SNOC = 30,
	QCM2290_SLAVE_BIMC_CFG = 31,
	QCM2290_SLAVE_CAMERA_NRT_THROTTLE_CFG = 32,
	QCM2290_SLAVE_CAMERA_RT_THROTTLE_CFG = 33,
	QCM2290_SLAVE_CAMERA_CFG = 34,
	QCM2290_SLAVE_CLK_CTL = 35,
	QCM2290_SLAVE_CRYPTO_0_CFG = 36,
	QCM2290_SLAVE_DISPLAY_CFG = 37,
	QCM2290_SLAVE_DISPLAY_THROTTLE_CFG = 38,
	QCM2290_SLAVE_GPU_CFG = 39,
	QCM2290_SLAVE_HWKM = 40,
	QCM2290_SLAVE_IMEM_CFG = 41,
	QCM2290_SLAVE_IPA_CFG = 42,
	QCM2290_SLAVE_LPASS = 43,
	QCM2290_SLAVE_MESSAGE_RAM = 44,
	QCM2290_SLAVE_PDM = 45,
	QCM2290_SLAVE_PIMEM_CFG = 46,
	QCM2290_SLAVE_PKA_WRAPPER = 47,
	QCM2290_SLAVE_PMIC_ARB = 48,
	QCM2290_SLAVE_PRNG = 49,
	QCM2290_SLAVE_QDSS_CFG = 50,
	QCM2290_SLAVE_QM_CFG = 51,
	QCM2290_SLAVE_QM_MPU_CFG = 52,
	QCM2290_SLAVE_QPIC = 53,
	QCM2290_SLAVE_QUP_0 = 54,
	QCM2290_SLAVE_SDCC_1 = 55,
	QCM2290_SLAVE_SDCC_2 = 56,
	QCM2290_SLAVE_SNOC_CFG = 57,
	QCM2290_SLAVE_TCSR = 58,
	QCM2290_SLAVE_USB3 = 59,
	QCM2290_SLAVE_VENUS_CFG = 60,
	QCM2290_SLAVE_VENUS_THROTTLE_CFG = 61,
	QCM2290_SLAVE_VSENSE_CTRL_CFG = 62,
	QCM2290_SLAVE_SERVICE_CNOC = 63,
	QCM2290_SLAVE_APPSS = 64,
	QCM2290_SLAVE_SNOC_CNOC = 65,
	QCM2290_SLAVE_IMEM = 66,
	QCM2290_SLAVE_PIMEM = 67,
	QCM2290_SLAVE_SNOC_BIMC = 68,
	QCM2290_SLAVE_SERVICE_SNOC = 69,
	QCM2290_SLAVE_QDSS_STM = 70,
	QCM2290_SLAVE_TCU = 71,
	QCM2290_SLAVE_ANOC_SNOC = 72,
	QCM2290_SLAVE_QUP_CORE_0 = 73,
	QCM2290_SLAVE_SNOC_BIMC_NRT = 74,
	QCM2290_SLAVE_SNOC_BIMC_RT = 75,
};

enum {
	QIF_BLIMITS_B = 0,
	QIF_SPACE_B = 1,
	QIF_ILIMITS_B = 2,
	QIF_INODES_B = 3,
	QIF_BTIME_B = 4,
	QIF_ITIME_B = 5,
};

enum {
	QUERY_REQ_TIMEOUT_MIN = 1,
	QUERY_REQ_TIMEOUT_DEFAULT = 1500,
	QUERY_REQ_TIMEOUT_MAX = 30000,
};

enum {
	QUEUE_FLAG_DYING = 0,
	QUEUE_FLAG_NOMERGES = 1,
	QUEUE_FLAG_SAME_COMP = 2,
	QUEUE_FLAG_FAIL_IO = 3,
	QUEUE_FLAG_NOXMERGES = 4,
	QUEUE_FLAG_SAME_FORCE = 5,
	QUEUE_FLAG_INIT_DONE = 6,
	QUEUE_FLAG_STATS = 7,
	QUEUE_FLAG_REGISTERED = 8,
	QUEUE_FLAG_QUIESCED = 9,
	QUEUE_FLAG_RQ_ALLOC_TIME = 10,
	QUEUE_FLAG_HCTX_ACTIVE = 11,
	QUEUE_FLAG_SQ_SCHED = 12,
	QUEUE_FLAG_DISABLE_WBT_DEF = 13,
	QUEUE_FLAG_NO_ELV_SWITCH = 14,
	QUEUE_FLAG_MAX = 15,
};

enum {
	Q_R1 = 0,
	Q_R2 = 128,
	Q_XS1 = 512,
	Q_XA1 = 640,
	Q_XS2 = 768,
	Q_XA2 = 896,
};

enum {
	Q_REQUEUE_PI_NONE = 0,
	Q_REQUEUE_PI_IGNORE = 1,
	Q_REQUEUE_PI_IN_PROGRESS = 2,
	Q_REQUEUE_PI_WAIT = 3,
	Q_REQUEUE_PI_DONE = 4,
	Q_REQUEUE_PI_LOCKED = 5,
};

enum {
	RADIX_TREE_ITER_TAG_MASK = 15,
	RADIX_TREE_ITER_TAGGED = 16,
	RADIX_TREE_ITER_CONTIG = 32,
};

enum {
	RB_ADD_STAMP_NONE = 0,
	RB_ADD_STAMP_EXTEND = 2,
	RB_ADD_STAMP_ABSOLUTE = 4,
	RB_ADD_STAMP_FORCE = 8,
};

enum {
	RB_CTX_TRANSITION = 0,
	RB_CTX_NMI = 1,
	RB_CTX_IRQ = 2,
	RB_CTX_SOFTIRQ = 3,
	RB_CTX_NORMAL = 4,
	RB_CTX_MAX = 5,
};

enum {
	RB_ENA_STFWD = 32,
	RB_DIS_STFWD = 16,
	RB_ENA_OP_MD = 8,
	RB_DIS_OP_MD = 4,
	RB_RST_CLR = 2,
	RB_RST_SET = 1,
};

enum {
	RB_LEN_TIME_EXTEND = 8,
	RB_LEN_TIME_STAMP = 8,
};

enum {
	RB_START = 0,
	RB_END = 4,
	RB_WP = 8,
	RB_RP = 12,
	RB_RX_UTPP = 16,
	RB_RX_LTPP = 20,
	RB_RX_UTHP = 24,
	RB_RX_LTHP = 28,
	RB_PC = 32,
	RB_LEV = 36,
	RB_CTRL = 40,
	RB_TST1 = 41,
	RB_TST2 = 42,
};

enum {
	RCAR_PCI_ACCESS_READ = 0,
	RCAR_PCI_ACCESS_WRITE = 1,
};

enum {
	RCD = 0,
	RCH_DP = 1,
	DEVICE = 2,
	LD = 3,
	FMLD = 4,
	RP = 5,
	DSP = 6,
	USP = 7,
};

enum {
	REASON_BOUNDS = -1,
	REASON_TYPE = -2,
	REASON_PATHS = -3,
	REASON_LIMIT = -4,
	REASON_STACK = -5,
};

enum {
	REGION_INTERSECTS = 0,
	REGION_DISJOINT = 1,
	REGION_MIXED = 2,
};

enum {
	REGULATOR_ERROR_CLEARED = 0,
	REGULATOR_FAILED_RETRY = 1,
	REGULATOR_ERROR_ON = 2,
};

enum {
	REG_CONTROLLER_CAPABILITIES = 0,
	REG_MCQCAP = 4,
	REG_UFS_VERSION = 8,
	REG_EXT_CONTROLLER_CAPABILITIES = 12,
	REG_CONTROLLER_PID = 16,
	REG_CONTROLLER_MID = 20,
	REG_AUTO_HIBERNATE_IDLE_TIMER = 24,
	REG_INTERRUPT_STATUS = 32,
	REG_INTERRUPT_ENABLE = 36,
	REG_CONTROLLER_STATUS = 48,
	REG_CONTROLLER_ENABLE = 52,
	REG_UIC_ERROR_CODE_PHY_ADAPTER_LAYER = 56,
	REG_UIC_ERROR_CODE_DATA_LINK_LAYER = 60,
	REG_UIC_ERROR_CODE_NETWORK_LAYER = 64,
	REG_UIC_ERROR_CODE_TRANSPORT_LAYER = 68,
	REG_UIC_ERROR_CODE_DME = 72,
	REG_UTP_TRANSFER_REQ_INT_AGG_CONTROL = 76,
	REG_UTP_TRANSFER_REQ_LIST_BASE_L = 80,
	REG_UTP_TRANSFER_REQ_LIST_BASE_H = 84,
	REG_UTP_TRANSFER_REQ_DOOR_BELL = 88,
	REG_UTP_TRANSFER_REQ_LIST_CLEAR = 92,
	REG_UTP_TRANSFER_REQ_LIST_RUN_STOP = 96,
	REG_UTP_TASK_REQ_LIST_BASE_L = 112,
	REG_UTP_TASK_REQ_LIST_BASE_H = 116,
	REG_UTP_TASK_REQ_DOOR_BELL = 120,
	REG_UTP_TASK_REQ_LIST_CLEAR = 124,
	REG_UTP_TASK_REQ_LIST_RUN_STOP = 128,
	REG_UIC_COMMAND = 144,
	REG_UIC_COMMAND_ARG_1 = 148,
	REG_UIC_COMMAND_ARG_2 = 152,
	REG_UIC_COMMAND_ARG_3 = 156,
	UFSHCI_REG_SPACE_SIZE = 160,
	REG_UFS_CCAP = 256,
	REG_UFS_CRYPTOCAP = 260,
	REG_UFS_MEM_CFG = 768,
	REG_UFS_MCQ_CFG = 896,
	REG_UFS_ESILBA = 900,
	REG_UFS_ESIUBA = 904,
	UFSHCI_CRYPTO_REG_SPACE_SIZE = 1024,
};

enum {
	REG_CON_MOD_TX = 0,
	REG_CON_MOD_REGISTER_TX = 1,
	REG_CON_MOD_RX = 2,
	REG_CON_MOD_REGISTER_RX = 3,
};

enum {
	REG_CQHP = 0,
	REG_CQTP = 4,
};

enum {
	REG_CQIS = 0,
	REG_CQIE = 4,
};

enum {
	REG_DR = 0,
	REG_ST_DMAWM = 1,
	REG_ST_TIMEOUT = 2,
	REG_FR = 3,
	REG_LCRH_RX = 4,
	REG_LCRH_TX = 5,
	REG_IBRD = 6,
	REG_FBRD = 7,
	REG_CR = 8,
	REG_IFLS = 9,
	REG_IMSC = 10,
	REG_RIS = 11,
	REG_MIS = 12,
	REG_ICR = 13,
	REG_DMACR = 14,
	REG_ST_XFCR = 15,
	REG_ST_XON1 = 16,
	REG_ST_XON2 = 17,
	REG_ST_XOFF1 = 18,
	REG_ST_XOFF2 = 19,
	REG_ST_ITCR = 20,
	REG_ST_ITIP = 21,
	REG_ST_ABCR = 22,
	REG_ST_ABIMSC = 23,
	REG_ARRAY_SIZE = 24,
};

enum {
	REG_SQATTR = 0,
	REG_SQLBA = 4,
	REG_SQUBA = 8,
	REG_SQDAO = 12,
	REG_SQISAO = 16,
	REG_CQATTR = 32,
	REG_CQLBA = 36,
	REG_CQUBA = 40,
	REG_CQDAO = 44,
	REG_CQISAO = 48,
};

enum {
	REG_SQHP = 0,
	REG_SQTP = 4,
	REG_SQRTC = 8,
	REG_SQCTI = 12,
	REG_SQRTS = 16,
};

enum {
	REQUEST_ANY = 0,
	REQUEST_BY_ID = 1,
	REQUEST_BY_CAP = 2,
	REQUEST_BY_NODE = 3,
};

enum {
	REQ_FSEQ_PREFLUSH = 1,
	REQ_FSEQ_DATA = 2,
	REQ_FSEQ_POSTFLUSH = 4,
	REQ_FSEQ_DONE = 8,
	REQ_FSEQ_ACTIONS = 7,
	FLUSH_PENDING_TIMEOUT = 1250,
};

enum {
	REQ_F_FIXED_FILE = 1ULL,
	REQ_F_IO_DRAIN = 2ULL,
	REQ_F_LINK = 4ULL,
	REQ_F_HARDLINK = 8ULL,
	REQ_F_FORCE_ASYNC = 16ULL,
	REQ_F_BUFFER_SELECT = 32ULL,
	REQ_F_CQE_SKIP = 64ULL,
	REQ_F_FAIL = 256ULL,
	REQ_F_INFLIGHT = 512ULL,
	REQ_F_CUR_POS = 1024ULL,
	REQ_F_NOWAIT = 2048ULL,
	REQ_F_LINK_TIMEOUT = 4096ULL,
	REQ_F_NEED_CLEANUP = 8192ULL,
	REQ_F_POLLED = 16384ULL,
	REQ_F_IOPOLL_STATE = 32768ULL,
	REQ_F_BUFFER_SELECTED = 65536ULL,
	REQ_F_BUFFER_RING = 131072ULL,
	REQ_F_REISSUE = 262144ULL,
	REQ_F_SUPPORT_NOWAIT = 536870912ULL,
	REQ_F_ISREG = 1073741824ULL,
	REQ_F_CREDS = 524288ULL,
	REQ_F_REFCOUNT = 1048576ULL,
	REQ_F_ARM_LTIMEOUT = 2097152ULL,
	REQ_F_ASYNC_DATA = 4194304ULL,
	REQ_F_SKIP_LINK_CQES = 8388608ULL,
	REQ_F_SINGLE_POLL = 16777216ULL,
	REQ_F_DOUBLE_POLL = 33554432ULL,
	REQ_F_MULTISHOT = 67108864ULL,
	REQ_F_APOLL_MULTISHOT = 134217728ULL,
	REQ_F_CLEAR_POLLIN = 268435456ULL,
	REQ_F_POLL_NO_LAZY = 2147483648ULL,
	REQ_F_CAN_POLL = 4294967296ULL,
	REQ_F_BL_EMPTY = 8589934592ULL,
	REQ_F_BL_NO_RECYCLE = 17179869184ULL,
	REQ_F_BUFFERS_COMMIT = 34359738368ULL,
	REQ_F_BUF_NODE = 68719476736ULL,
	REQ_F_HAS_METADATA = 137438953472ULL,
	REQ_F_IMPORT_BUFFER = 274877906944ULL,
};

enum {
	REQ_F_FIXED_FILE_BIT = 0,
	REQ_F_IO_DRAIN_BIT = 1,
	REQ_F_LINK_BIT = 2,
	REQ_F_HARDLINK_BIT = 3,
	REQ_F_FORCE_ASYNC_BIT = 4,
	REQ_F_BUFFER_SELECT_BIT = 5,
	REQ_F_CQE_SKIP_BIT = 6,
	REQ_F_FAIL_BIT = 8,
	REQ_F_INFLIGHT_BIT = 9,
	REQ_F_CUR_POS_BIT = 10,
	REQ_F_NOWAIT_BIT = 11,
	REQ_F_LINK_TIMEOUT_BIT = 12,
	REQ_F_NEED_CLEANUP_BIT = 13,
	REQ_F_POLLED_BIT = 14,
	REQ_F_HYBRID_IOPOLL_STATE_BIT = 15,
	REQ_F_BUFFER_SELECTED_BIT = 16,
	REQ_F_BUFFER_RING_BIT = 17,
	REQ_F_REISSUE_BIT = 18,
	REQ_F_CREDS_BIT = 19,
	REQ_F_REFCOUNT_BIT = 20,
	REQ_F_ARM_LTIMEOUT_BIT = 21,
	REQ_F_ASYNC_DATA_BIT = 22,
	REQ_F_SKIP_LINK_CQES_BIT = 23,
	REQ_F_SINGLE_POLL_BIT = 24,
	REQ_F_DOUBLE_POLL_BIT = 25,
	REQ_F_MULTISHOT_BIT = 26,
	REQ_F_APOLL_MULTISHOT_BIT = 27,
	REQ_F_CLEAR_POLLIN_BIT = 28,
	REQ_F_SUPPORT_NOWAIT_BIT = 29,
	REQ_F_ISREG_BIT = 30,
	REQ_F_POLL_NO_LAZY_BIT = 31,
	REQ_F_CAN_POLL_BIT = 32,
	REQ_F_BL_EMPTY_BIT = 33,
	REQ_F_BL_NO_RECYCLE_BIT = 34,
	REQ_F_BUFFERS_COMMIT_BIT = 35,
	REQ_F_BUF_NODE_BIT = 36,
	REQ_F_HAS_METADATA_BIT = 37,
	REQ_F_IMPORT_BUFFER_BIT = 38,
	__REQ_F_LAST_BIT = 39,
};

enum {
	RES_USAGE = 0,
	RES_RSVD_USAGE = 1,
	RES_LIMIT = 2,
	RES_RSVD_LIMIT = 3,
	RES_MAX_USAGE = 4,
	RES_RSVD_MAX_USAGE = 5,
	RES_FAILCNT = 6,
	RES_RSVD_FAILCNT = 7,
};

enum {
	RI_CLR_RD_PERR = 512,
	RI_CLR_WR_PERR = 256,
	RI_RST_CLR = 2,
	RI_RST_SET = 1,
};

enum {
	RK805_BUCK1_2_ILMAX_2500MA = 0,
	RK805_BUCK1_2_ILMAX_3000MA = 1,
	RK805_BUCK1_2_ILMAX_3500MA = 2,
	RK805_BUCK1_2_ILMAX_4000MA = 3,
};

enum {
	RK805_BUCK3_ILMAX_1500MA = 0,
	RK805_BUCK3_ILMAX_2000MA = 1,
	RK805_BUCK3_ILMAX_2500MA = 2,
	RK805_BUCK3_ILMAX_3000MA = 3,
};

enum {
	RK805_BUCK4_ILMAX_2000MA = 0,
	RK805_BUCK4_ILMAX_2500MA = 1,
	RK805_BUCK4_ILMAX_3000MA = 2,
	RK805_BUCK4_ILMAX_3500MA = 3,
};

enum {
	RK805_ID = 32848,
	RK806_ID = 32864,
	RK808_ID = 0,
	RK809_ID = 32912,
	RK816_ID = 33120,
	RK817_ID = 33136,
	RK818_ID = 33152,
};

enum {
	RK8600_CHIP_ID_08 = 8,
};

enum {
	RK8602_CHIP_ID_10 = 10,
};

enum {
	RNG_OUTPUT_0_REG = 0,
	RNG_OUTPUT_1_REG = 1,
	RNG_OUTPUT_2_REG = 2,
	RNG_OUTPUT_3_REG = 3,
	RNG_STATUS_REG = 4,
	RNG_INTMASK_REG = 5,
	RNG_INTACK_REG = 6,
	RNG_CONTROL_REG = 7,
	RNG_CONFIG_REG = 8,
	RNG_ALARMCNT_REG = 9,
	RNG_FROENABLE_REG = 10,
	RNG_FRODETUNE_REG = 11,
	RNG_ALARMMASK_REG = 12,
	RNG_ALARMSTOP_REG = 13,
	RNG_REV_REG = 14,
	RNG_SYSCONFIG_REG = 15,
};

enum {
	RPCAUTH_info = 0,
	RPCAUTH_EOF = 1,
};

enum {
	RPCAUTH_lockd = 0,
	RPCAUTH_mount = 1,
	RPCAUTH_nfs = 2,
	RPCAUTH_portmap = 3,
	RPCAUTH_statd = 4,
	RPCAUTH_nfsd4_cb = 5,
	RPCAUTH_cache = 6,
	RPCAUTH_nfsd = 7,
	RPCAUTH_gssd = 8,
	RPCAUTH_RootEOF = 9,
};

enum {
	RPCBPROC_NULL = 0,
	RPCBPROC_SET = 1,
	RPCBPROC_UNSET = 2,
	RPCBPROC_GETPORT = 3,
	RPCBPROC_GETADDR = 3,
	RPCBPROC_DUMP = 4,
	RPCBPROC_CALLIT = 5,
	RPCBPROC_BCAST = 5,
	RPCBPROC_GETTIME = 6,
	RPCBPROC_UADDR2TADDR = 7,
	RPCBPROC_TADDR2UADDR = 8,
	RPCBPROC_GETVERSADDR = 9,
	RPCBPROC_INDIRECT = 10,
	RPCBPROC_GETADDRLIST = 11,
	RPCBPROC_GETSTAT = 12,
};

enum {
	RPCSVC_MAXPAYLOAD = 4194304,
	RPCSVC_MAXPAYLOAD_TCP = 4194304,
	RPCSVC_MAXPAYLOAD_UDP = 32768,
};

enum {
	RPC_PIPEFS_MOUNT = 0,
	RPC_PIPEFS_UMOUNT = 1,
};

enum {
	RPC_TASK_RUNNING = 0,
	RPC_TASK_QUEUED = 1,
	RPC_TASK_ACTIVE = 2,
	RPC_TASK_NEED_XMIT = 3,
	RPC_TASK_NEED_RECV = 4,
	RPC_TASK_MSG_PIN_WAIT = 5,
};

enum {
	RQ_SECURE = 0,
	RQ_LOCAL = 1,
	RQ_USEDEFERRAL = 2,
	RQ_DROPME = 3,
	RQ_VICTIM = 4,
	RQ_DATA = 5,
};

enum {
	RSC_DRV_TCS_OFFSET = 0,
	RSC_DRV_CMD_OFFSET = 1,
	DRV_SOLVER_CONFIG = 2,
	DRV_PRNT_CHLD_CONFIG = 3,
	RSC_DRV_IRQ_ENABLE = 4,
	RSC_DRV_IRQ_STATUS = 5,
	RSC_DRV_IRQ_CLEAR = 6,
	RSC_DRV_CMD_WAIT_FOR_CMPL = 7,
	RSC_DRV_CONTROL = 8,
	RSC_DRV_STATUS = 9,
	RSC_DRV_CMD_ENABLE = 10,
	RSC_DRV_CMD_MSGID = 11,
	RSC_DRV_CMD_ADDR = 12,
	RSC_DRV_CMD_DATA = 13,
	RSC_DRV_CMD_STATUS = 14,
	RSC_DRV_CMD_RESP_DATA = 15,
};

enum {
	RTAX_UNSPEC = 0,
	RTAX_LOCK = 1,
	RTAX_MTU = 2,
	RTAX_WINDOW = 3,
	RTAX_RTT = 4,
	RTAX_RTTVAR = 5,
	RTAX_SSTHRESH = 6,
	RTAX_CWND = 7,
	RTAX_ADVMSS = 8,
	RTAX_REORDERING = 9,
	RTAX_HOPLIMIT = 10,
	RTAX_INITCWND = 11,
	RTAX_FEATURES = 12,
	RTAX_RTO_MIN = 13,
	RTAX_INITRWND = 14,
	RTAX_QUICKACK = 15,
	RTAX_CC_ALGO = 16,
	RTAX_FASTOPEN_NO_COOKIE = 17,
	__RTAX_MAX = 18,
};

enum {
	RTC_SEC = 0,
	RTC_MIN = 1,
	RTC_HOUR = 2,
	RTC_WEEKDAY = 3,
	RTC_MONTH = 4,
	RTC_YEAR = 5,
	RTC_MONTHDAY = 6,
	RTC_NR_TIME = 7,
};

enum {
	RTC_SEC___2 = 0,
	RTC_MIN___2 = 1,
	RTC_HOUR___2 = 2,
	RTC_WEEKDAY___2 = 3,
	RTC_DATE = 4,
	RTC_MONTH___2 = 5,
	RTC_YEAR1 = 6,
	RTC_YEAR2 = 7,
	RTC_MAX_NUM_TIME_REGS = 8,
};

enum {
	RTM_BASE = 16,
	RTM_NEWLINK = 16,
	RTM_DELLINK = 17,
	RTM_GETLINK = 18,
	RTM_SETLINK = 19,
	RTM_NEWADDR = 20,
	RTM_DELADDR = 21,
	RTM_GETADDR = 22,
	RTM_NEWROUTE = 24,
	RTM_DELROUTE = 25,
	RTM_GETROUTE = 26,
	RTM_NEWNEIGH = 28,
	RTM_DELNEIGH = 29,
	RTM_GETNEIGH = 30,
	RTM_NEWRULE = 32,
	RTM_DELRULE = 33,
	RTM_GETRULE = 34,
	RTM_NEWQDISC = 36,
	RTM_DELQDISC = 37,
	RTM_GETQDISC = 38,
	RTM_NEWTCLASS = 40,
	RTM_DELTCLASS = 41,
	RTM_GETTCLASS = 42,
	RTM_NEWTFILTER = 44,
	RTM_DELTFILTER = 45,
	RTM_GETTFILTER = 46,
	RTM_NEWACTION = 48,
	RTM_DELACTION = 49,
	RTM_GETACTION = 50,
	RTM_NEWPREFIX = 52,
	RTM_NEWMULTICAST = 56,
	RTM_DELMULTICAST = 57,
	RTM_GETMULTICAST = 58,
	RTM_NEWANYCAST = 60,
	RTM_DELANYCAST = 61,
	RTM_GETANYCAST = 62,
	RTM_NEWNEIGHTBL = 64,
	RTM_GETNEIGHTBL = 66,
	RTM_SETNEIGHTBL = 67,
	RTM_NEWNDUSEROPT = 68,
	RTM_NEWADDRLABEL = 72,
	RTM_DELADDRLABEL = 73,
	RTM_GETADDRLABEL = 74,
	RTM_GETDCB = 78,
	RTM_SETDCB = 79,
	RTM_NEWNETCONF = 80,
	RTM_DELNETCONF = 81,
	RTM_GETNETCONF = 82,
	RTM_NEWMDB = 84,
	RTM_DELMDB = 85,
	RTM_GETMDB = 86,
	RTM_NEWNSID = 88,
	RTM_DELNSID = 89,
	RTM_GETNSID = 90,
	RTM_NEWSTATS = 92,
	RTM_GETSTATS = 94,
	RTM_SETSTATS = 95,
	RTM_NEWCACHEREPORT = 96,
	RTM_NEWCHAIN = 100,
	RTM_DELCHAIN = 101,
	RTM_GETCHAIN = 102,
	RTM_NEWNEXTHOP = 104,
	RTM_DELNEXTHOP = 105,
	RTM_GETNEXTHOP = 106,
	RTM_NEWLINKPROP = 108,
	RTM_DELLINKPROP = 109,
	RTM_GETLINKPROP = 110,
	RTM_NEWVLAN = 112,
	RTM_DELVLAN = 113,
	RTM_GETVLAN = 114,
	RTM_NEWNEXTHOPBUCKET = 116,
	RTM_DELNEXTHOPBUCKET = 117,
	RTM_GETNEXTHOPBUCKET = 118,
	RTM_NEWTUNNEL = 120,
	RTM_DELTUNNEL = 121,
	RTM_GETTUNNEL = 122,
	__RTM_MAX = 123,
};

enum {
	RTN_UNSPEC = 0,
	RTN_UNICAST = 1,
	RTN_LOCAL = 2,
	RTN_BROADCAST = 3,
	RTN_ANYCAST = 4,
	RTN_MULTICAST = 5,
	RTN_BLACKHOLE = 6,
	RTN_UNREACHABLE = 7,
	RTN_PROHIBIT = 8,
	RTN_THROW = 9,
	RTN_NAT = 10,
	RTN_XRESOLVE = 11,
	__RTN_MAX = 12,
};

enum {
	RX_GCLKMAC_ENA = -2147483648,
	RX_GCLKMAC_OFF = 1073741824,
	RX_STFW_DIS = 536870912,
	RX_STFW_ENA = 268435456,
	RX_TRUNC_ON = 134217728,
	RX_TRUNC_OFF = 67108864,
	RX_VLAN_STRIP_ON = 33554432,
	RX_VLAN_STRIP_OFF = 16777216,
	RX_MACSEC_FLUSH_ON = 8388608,
	RX_MACSEC_FLUSH_OFF = 4194304,
	RX_MACSEC_ASF_FLUSH_ON = 2097152,
	RX_MACSEC_ASF_FLUSH_OFF = 1048576,
	GMF_RX_OVER_ON = 524288,
	GMF_RX_OVER_OFF = 262144,
	GMF_ASF_RX_OVER_ON = 131072,
	GMF_ASF_RX_OVER_OFF = 65536,
	GMF_WP_TST_ON = 16384,
	GMF_WP_TST_OFF = 8192,
	GMF_WP_STEP = 4096,
	GMF_RP_TST_ON = 1024,
	GMF_RP_TST_OFF = 512,
	GMF_RP_STEP = 256,
	GMF_RX_F_FL_ON = 128,
	GMF_RX_F_FL_OFF = 64,
	GMF_CLI_RX_FO = 32,
	GMF_CLI_RX_C = 16,
	GMF_OPER_ON = 8,
	GMF_OPER_OFF = 4,
	GMF_RST_CLR = 2,
	GMF_RST_SET = 1,
	RX_GMF_FL_THR_DEF = 10,
	GMF_RX_CTRL_DEF = 136,
};

enum {
	RX_IPV6_SA_MOB_ENA = 512,
	RX_IPV6_SA_MOB_DIS = 256,
	RX_IPV6_DA_MOB_ENA = 128,
	RX_IPV6_DA_MOB_DIS = 64,
	RX_PTR_SYNCDLY_ENA = 32,
	RX_PTR_SYNCDLY_DIS = 16,
	RX_ASF_NEWFLAG_ENA = 8,
	RX_ASF_NEWFLAG_DIS = 4,
	RX_FLSH_MISSPKT_ENA = 2,
	RX_FLSH_MISSPKT_DIS = 1,
};

enum {
	RX_XDP_REDIRECT = 0,
	RX_XDP_PASS = 1,
	RX_XDP_DROP = 2,
	RX_XDP_TX = 3,
	RX_XDP_TX_ERRORS = 4,
	TX_XDP_XMIT = 5,
	TX_XDP_XMIT_ERRORS = 6,
	XDP_STATS_TOTAL = 7,
};

enum {
	Root_NFS = 255,
	Root_CIFS = 254,
	Root_Generic = 253,
	Root_RAM0 = 1048576,
};

enum {
	Rworksched = 1,
	Rpending = 2,
	Wworksched = 4,
	Wpending = 8,
};

enum {
	SAS_DATAPRES_NO_DATA = 0,
	SAS_DATAPRES_RESPONSE_DATA = 1,
	SAS_DATAPRES_SENSE_DATA = 2,
};

enum {
	SAS_DEV_GONE = 0,
	SAS_DEV_FOUND = 1,
	SAS_DEV_DESTROY = 2,
	SAS_DEV_EH_PENDING = 3,
	SAS_DEV_LU_RESET = 4,
	SAS_DEV_RESET = 5,
};

enum {
	SB_UNFROZEN = 0,
	SB_FREEZE_WRITE = 1,
	SB_FREEZE_PAGEFAULT = 2,
	SB_FREEZE_FS = 3,
	SB_FREEZE_COMPLETE = 4,
};

enum {
	SCIx_ERI_IRQ = 0,
	SCIx_RXI_IRQ = 1,
	SCIx_TXI_IRQ = 2,
	SCIx_BRI_IRQ = 3,
	SCIx_DRI_IRQ = 4,
	SCIx_TEI_IRQ = 5,
	SCIx_NR_IRQS = 6,
	SCIx_MUX_IRQ = 6,
};

enum {
	SCIx_PROBE_REGTYPE = 0,
	SCIx_SCI_REGTYPE = 1,
	SCIx_IRDA_REGTYPE = 2,
	SCIx_SCIFA_REGTYPE = 3,
	SCIx_SCIFB_REGTYPE = 4,
	SCIx_SH2_SCIF_FIFODATA_REGTYPE = 5,
	SCIx_SH3_SCIF_REGTYPE = 6,
	SCIx_SH4_SCIF_REGTYPE = 7,
	SCIx_SH4_SCIF_BRG_REGTYPE = 8,
	SCIx_SH4_SCIF_NO_SCSPTR_REGTYPE = 9,
	SCIx_SH4_SCIF_FIFODATA_REGTYPE = 10,
	SCIx_SH7705_SCIF_REGTYPE = 11,
	SCIx_HSCIF_REGTYPE = 12,
	SCIx_RZ_SCIFA_REGTYPE = 13,
	SCIx_RZV2H_SCIF_REGTYPE = 14,
	SCIx_NR_REGTYPES = 15,
};

enum {
	SCMI_RAW_REPLY_QUEUE = 0,
	SCMI_RAW_NOTIF_QUEUE = 1,
	SCMI_RAW_ERRS_QUEUE = 2,
	SCMI_RAW_MAX_QUEUE = 3,
};

enum {
	SCM_TSTAMP_SND = 0,
	SCM_TSTAMP_SCHED = 1,
	SCM_TSTAMP_ACK = 2,
	SCM_TSTAMP_COMPLETION = 3,
};

enum {
	SCSMR = 0,
	SCBRR = 1,
	SCSCR = 2,
	SCxSR = 3,
	SCFCR = 4,
	SCFDR = 5,
	SCxTDR = 6,
	SCxRDR = 7,
	SCLSR = 8,
	SCTFDR = 9,
	SCRFDR = 10,
	SCSPTR = 11,
	HSSRR = 12,
	SCPCR = 13,
	SCPDR = 14,
	SCDL = 15,
	SCCKS = 16,
	HSRTRGR = 17,
	HSTTRGR = 18,
	SEMR = 19,
};

enum {
	SC_STAT_CLR_IRQ = 16,
	SC_STAT_OP_ON = 8,
	SC_STAT_OP_OFF = 4,
	SC_STAT_RST_CLR = 2,
	SC_STAT_RST_SET = 1,
};

enum {
	SDHCI_ACPI_SD_CD = 1,
	SDHCI_ACPI_RUNTIME_PM = 2,
	SDHCI_ACPI_SD_CD_OVERRIDE_LEVEL = 4,
};

enum {
	SD_BALANCE_NEWIDLE = 1,
	SD_BALANCE_EXEC = 2,
	SD_BALANCE_FORK = 4,
	SD_BALANCE_WAKE = 8,
	SD_WAKE_AFFINE = 16,
	SD_ASYM_CPUCAPACITY = 32,
	SD_ASYM_CPUCAPACITY_FULL = 64,
	SD_SHARE_CPUCAPACITY = 128,
	SD_CLUSTER = 256,
	SD_SHARE_LLC = 512,
	SD_SERIALIZE = 1024,
	SD_ASYM_PACKING = 2048,
	SD_PREFER_SIBLING = 4096,
	SD_OVERLAP = 8192,
	SD_NUMA = 16384,
};

enum {
	SD_DEF_XFER_BLOCKS = 65535,
	SD_MAX_XFER_BLOCKS = 4294967295,
	SD_MAX_WS10_BLOCKS = 65535,
	SD_MAX_WS16_BLOCKS = 8388607,
};

enum {
	SD_EXT_CDB_SIZE = 32,
	SD_MEMPOOL_SIZE = 2,
};

enum {
	SD_LBP_FULL = 0,
	SD_LBP_UNMAP = 1,
	SD_LBP_WS16 = 2,
	SD_LBP_WS10 = 3,
	SD_LBP_ZERO = 4,
	SD_LBP_DISABLE = 5,
};

enum {
	SD_ZERO_WRITE = 0,
	SD_ZERO_WS = 1,
	SD_ZERO_WS16_UNMAP = 2,
	SD_ZERO_WS10_UNMAP = 3,
};

enum {
	SECTION_MARKED_PRESENT_BIT = 0,
	SECTION_HAS_MEM_MAP_BIT = 1,
	SECTION_IS_ONLINE_BIT = 2,
	SECTION_IS_EARLY_BIT = 3,
	SECTION_MAP_LAST_BIT = 4,
};

enum {
	SETWA_FLAGS_APICID = 1,
	SETWA_FLAGS_MEM = 2,
	SETWA_FLAGS_PCIE_SBDF = 4,
};

enum {
	SFF8024_ID_UNK = 0,
	SFF8024_ID_SFF_8472 = 2,
	SFF8024_ID_SFP = 3,
	SFF8024_ID_DWDM_SFP = 11,
	SFF8024_ID_QSFP_8438 = 12,
	SFF8024_ID_QSFP_8436_8636 = 13,
	SFF8024_ID_QSFP28_8636 = 17,
	SFF8024_ID_QSFP_DD = 24,
	SFF8024_ID_OSFP = 25,
	SFF8024_ID_DSFP = 27,
	SFF8024_ID_QSFP_PLUS_CMIS = 30,
	SFF8024_ID_SFP_DD_CMIS = 31,
	SFF8024_ID_SFP_PLUS_CMIS = 32,
	SFF8024_ENCODING_UNSPEC = 0,
	SFF8024_ENCODING_8B10B = 1,
	SFF8024_ENCODING_4B5B = 2,
	SFF8024_ENCODING_NRZ = 3,
	SFF8024_ENCODING_8472_MANCHESTER = 4,
	SFF8024_ENCODING_8472_SONET = 5,
	SFF8024_ENCODING_8472_64B66B = 6,
	SFF8024_ENCODING_8436_MANCHESTER = 6,
	SFF8024_ENCODING_8436_SONET = 4,
	SFF8024_ENCODING_8436_64B66B = 5,
	SFF8024_ENCODING_256B257B = 7,
	SFF8024_ENCODING_PAM4 = 8,
	SFF8024_CONNECTOR_UNSPEC = 0,
	SFF8024_CONNECTOR_SC = 1,
	SFF8024_CONNECTOR_FIBERJACK = 6,
	SFF8024_CONNECTOR_LC = 7,
	SFF8024_CONNECTOR_MT_RJ = 8,
	SFF8024_CONNECTOR_MU = 9,
	SFF8024_CONNECTOR_SG = 10,
	SFF8024_CONNECTOR_OPTICAL_PIGTAIL = 11,
	SFF8024_CONNECTOR_MPO_1X12 = 12,
	SFF8024_CONNECTOR_MPO_2X16 = 13,
	SFF8024_CONNECTOR_HSSDC_II = 32,
	SFF8024_CONNECTOR_COPPER_PIGTAIL = 33,
	SFF8024_CONNECTOR_RJ45 = 34,
	SFF8024_CONNECTOR_NOSEPARATE = 35,
	SFF8024_CONNECTOR_MXC_2X16 = 36,
	SFF8024_ECC_UNSPEC = 0,
	SFF8024_ECC_100G_25GAUI_C2M_AOC = 1,
	SFF8024_ECC_100GBASE_SR4_25GBASE_SR = 2,
	SFF8024_ECC_100GBASE_LR4_25GBASE_LR = 3,
	SFF8024_ECC_100GBASE_ER4_25GBASE_ER = 4,
	SFF8024_ECC_100GBASE_SR10 = 5,
	SFF8024_ECC_100GBASE_CR4 = 11,
	SFF8024_ECC_25GBASE_CR_S = 12,
	SFF8024_ECC_25GBASE_CR_N = 13,
	SFF8024_ECC_10GBASE_T_SFI = 22,
	SFF8024_ECC_10GBASE_T_SR = 28,
	SFF8024_ECC_5GBASE_T = 29,
	SFF8024_ECC_2_5GBASE_T = 30,
};

enum {
	SFP_PHYS_ID = 0,
	SFP_PHYS_EXT_ID = 1,
	SFP_PHYS_EXT_ID_SFP = 4,
	SFP_CONNECTOR = 2,
	SFP_COMPLIANCE = 3,
	SFP_ENCODING = 11,
	SFP_BR_NOMINAL = 12,
	SFP_RATE_ID = 13,
	SFF_RID_8079 = 1,
	SFF_RID_8431_RX_ONLY = 2,
	SFF_RID_8431_TX_ONLY = 4,
	SFF_RID_8431 = 6,
	SFF_RID_10G8G = 14,
	SFP_LINK_LEN_SM_KM = 14,
	SFP_LINK_LEN_SM_100M = 15,
	SFP_LINK_LEN_50UM_OM2_10M = 16,
	SFP_LINK_LEN_62_5UM_OM1_10M = 17,
	SFP_LINK_LEN_COPPER_1M = 18,
	SFP_LINK_LEN_50UM_OM4_10M = 18,
	SFP_LINK_LEN_50UM_OM3_10M = 19,
	SFP_VENDOR_NAME = 20,
	SFP_VENDOR_OUI = 37,
	SFP_VENDOR_PN = 40,
	SFP_VENDOR_REV = 56,
	SFP_OPTICAL_WAVELENGTH_MSB = 60,
	SFP_OPTICAL_WAVELENGTH_LSB = 61,
	SFP_CABLE_SPEC = 60,
	SFP_CC_BASE = 63,
	SFP_OPTIONS = 64,
	SFP_OPTIONS_HIGH_POWER_LEVEL = 8192,
	SFP_OPTIONS_PAGING_A2 = 4096,
	SFP_OPTIONS_RETIMER = 2048,
	SFP_OPTIONS_COOLED_XCVR = 1024,
	SFP_OPTIONS_POWER_DECL = 512,
	SFP_OPTIONS_RX_LINEAR_OUT = 256,
	SFP_OPTIONS_RX_DECISION_THRESH = 128,
	SFP_OPTIONS_TUNABLE_TX = 64,
	SFP_OPTIONS_RATE_SELECT = 32,
	SFP_OPTIONS_TX_DISABLE = 16,
	SFP_OPTIONS_TX_FAULT = 8,
	SFP_OPTIONS_LOS_INVERTED = 4,
	SFP_OPTIONS_LOS_NORMAL = 2,
	SFP_BR_MAX = 66,
	SFP_BR_MIN = 67,
	SFP_VENDOR_SN = 68,
	SFP_DATECODE = 84,
	SFP_DIAGMON = 92,
	SFP_DIAGMON_DDM = 64,
	SFP_DIAGMON_INT_CAL = 32,
	SFP_DIAGMON_EXT_CAL = 16,
	SFP_DIAGMON_RXPWR_AVG = 8,
	SFP_DIAGMON_ADDRMODE = 4,
	SFP_ENHOPTS = 93,
	SFP_ENHOPTS_ALARMWARN = 128,
	SFP_ENHOPTS_SOFT_TX_DISABLE = 64,
	SFP_ENHOPTS_SOFT_TX_FAULT = 32,
	SFP_ENHOPTS_SOFT_RX_LOS = 16,
	SFP_ENHOPTS_SOFT_RATE_SELECT = 8,
	SFP_ENHOPTS_APP_SELECT_SFF8079 = 4,
	SFP_ENHOPTS_SOFT_RATE_SFF8431 = 2,
	SFP_SFF8472_COMPLIANCE = 94,
	SFP_SFF8472_COMPLIANCE_NONE = 0,
	SFP_SFF8472_COMPLIANCE_REV9_3 = 1,
	SFP_SFF8472_COMPLIANCE_REV9_5 = 2,
	SFP_SFF8472_COMPLIANCE_REV10_2 = 3,
	SFP_SFF8472_COMPLIANCE_REV10_4 = 4,
	SFP_SFF8472_COMPLIANCE_REV11_0 = 5,
	SFP_SFF8472_COMPLIANCE_REV11_3 = 6,
	SFP_SFF8472_COMPLIANCE_REV11_4 = 7,
	SFP_SFF8472_COMPLIANCE_REV12_0 = 8,
	SFP_CC_EXT = 95,
};

enum {
	SH_ETH_REG_GIGABIT = 0,
	SH_ETH_REG_FAST_RCAR = 1,
	SH_ETH_REG_FAST_SH4 = 2,
	SH_ETH_REG_FAST_SH3_SH2 = 3,
};

enum {
	SIL24_HOST_BAR = 0,
	SIL24_PORT_BAR = 2,
	SIL24_PRB_SZ = 64,
	SIL24_MAX_SGT = 63,
	SIL24_MAX_SGE = 253,
	HOST_SLOT_STAT = 0,
	HOST_CTRL = 64,
	HOST_IRQ_STAT___2 = 68,
	HOST_PHY_CFG = 72,
	HOST_BIST_CTRL = 80,
	HOST_BIST_PTRN = 84,
	HOST_BIST_STAT = 88,
	HOST_MEM_BIST_STAT = 92,
	HOST_FLASH_CMD = 112,
	HOST_FLASH_DATA = 116,
	HOST_TRANSITION_DETECT = 117,
	HOST_GPIO_CTRL = 118,
	HOST_I2C_ADDR = 120,
	HOST_I2C_DATA = 124,
	HOST_I2C_XFER_CNT = 126,
	HOST_I2C_CTRL = 127,
	HOST_SSTAT_ATTN = -2147483648,
	HOST_CTRL_M66EN = 65536,
	HOST_CTRL_TRDY = 131072,
	HOST_CTRL_STOP = 262144,
	HOST_CTRL_DEVSEL = 524288,
	HOST_CTRL_REQ64 = 1048576,
	HOST_CTRL_GLOBAL_RST = -2147483648,
	PORT_REGS_SIZE = 8192,
	PORT_LRAM = 0,
	PORT_LRAM_SLOT_SZ = 128,
	PORT_PMP = 3968,
	PORT_PMP_STATUS = 0,
	PORT_PMP_QACTIVE = 4,
	PORT_PMP_SIZE = 8,
	PORT_CTRL_STAT = 4096,
	PORT_CTRL_CLR = 4100,
	PORT_IRQ_STAT___2 = 4104,
	PORT_IRQ_ENABLE_SET = 4112,
	PORT_IRQ_ENABLE_CLR = 4116,
	PORT_ACTIVATE_UPPER_ADDR = 4124,
	PORT_EXEC_FIFO = 4128,
	PORT_CMD_ERR = 4132,
	PORT_FIS_CFG = 4136,
	PORT_FIFO_THRES = 4140,
	PORT_DECODE_ERR_CNT = 4160,
	PORT_DECODE_ERR_THRESH = 4162,
	PORT_CRC_ERR_CNT = 4164,
	PORT_CRC_ERR_THRESH = 4166,
	PORT_HSHK_ERR_CNT = 4168,
	PORT_HSHK_ERR_THRESH = 4170,
	PORT_PHY_CFG = 4176,
	PORT_SLOT_STAT = 6144,
	PORT_CMD_ACTIVATE = 7168,
	PORT_CONTEXT = 7684,
	PORT_EXEC_DIAG = 7680,
	PORT_PSD_DIAG = 7744,
	PORT_SCONTROL = 7936,
	PORT_SSTATUS = 7940,
	PORT_SERROR = 7944,
	PORT_SACTIVE = 7948,
	PORT_CS_PORT_RST = 1,
	PORT_CS_DEV_RST = 2,
	PORT_CS_INIT = 4,
	PORT_CS_IRQ_WOC = 8,
	PORT_CS_CDB16 = 32,
	PORT_CS_PMP_RESUME = 64,
	PORT_CS_32BIT_ACTV = 1024,
	PORT_CS_PMP_EN = 8192,
	PORT_CS_RDY = -2147483648,
	PORT_IRQ_COMPLETE = 1,
	PORT_IRQ_ERROR___2 = 2,
	PORT_IRQ_PORTRDY_CHG = 4,
	PORT_IRQ_PWR_CHG = 8,
	PORT_IRQ_PHYRDY_CHG = 16,
	PORT_IRQ_COMWAKE = 32,
	PORT_IRQ_UNK_FIS___2 = 64,
	PORT_IRQ_DEV_XCHG = 128,
	PORT_IRQ_8B10B = 256,
	PORT_IRQ_CRC = 512,
	PORT_IRQ_HANDSHAKE = 1024,
	PORT_IRQ_SDB_NOTIFY = 2048,
	DEF_PORT_IRQ___2 = 2259,
	PORT_IRQ_RAW_SHIFT = 16,
	PORT_IRQ_MASKED_MASK = 2047,
	PORT_IRQ_RAW_MASK = 134152192,
	PORT_IRQ_STEER_SHIFT = 30,
	PORT_IRQ_STEER_MASK = -1073741824,
	PORT_CERR_DEV = 1,
	PORT_CERR_SDB = 2,
	PORT_CERR_DATA = 3,
	PORT_CERR_SEND = 4,
	PORT_CERR_INCONSISTENT = 5,
	PORT_CERR_DIRECTION = 6,
	PORT_CERR_UNDERRUN = 7,
	PORT_CERR_OVERRUN = 8,
	PORT_CERR_PKT_PROT = 11,
	PORT_CERR_SGT_BOUNDARY = 16,
	PORT_CERR_SGT_TGTABRT = 17,
	PORT_CERR_SGT_MSTABRT = 18,
	PORT_CERR_SGT_PCIPERR = 19,
	PORT_CERR_CMD_BOUNDARY = 24,
	PORT_CERR_CMD_TGTABRT = 25,
	PORT_CERR_CMD_MSTABRT = 26,
	PORT_CERR_CMD_PCIPERR = 27,
	PORT_CERR_XFR_UNDEF = 32,
	PORT_CERR_XFR_TGTABRT = 33,
	PORT_CERR_XFR_MSTABRT = 34,
	PORT_CERR_XFR_PCIPERR = 35,
	PORT_CERR_SENDSERVICE = 36,
	PRB_CTRL_PROTOCOL = 1,
	PRB_CTRL_PACKET_READ = 16,
	PRB_CTRL_PACKET_WRITE = 32,
	PRB_CTRL_NIEN = 64,
	PRB_CTRL_SRST = 128,
	PRB_PROT_PACKET = 1,
	PRB_PROT_TCQ = 2,
	PRB_PROT_NCQ = 4,
	PRB_PROT_READ = 8,
	PRB_PROT_WRITE = 16,
	PRB_PROT_TRANSPARENT = 32,
	SGE_TRM = -2147483648,
	SGE_LNK = 1073741824,
	SGE_DRD = 536870912,
	SIL24_MAX_CMDS = 31,
	BID_SIL3124 = 0,
	BID_SIL3132 = 1,
	BID_SIL3131 = 2,
	SIL24_COMMON_FLAGS = 918658,
	SIL24_FLAG_PCIX_IRQ_WOC = 16777216,
	IRQ_STAT_4PORTS = 15,
};

enum {
	SILERGY_SYR82X = 8,
	SILERGY_SYR83X = 9,
};

enum {
	SKBFL_ZEROCOPY_ENABLE = 1,
	SKBFL_SHARED_FRAG = 2,
	SKBFL_PURE_ZEROCOPY = 4,
	SKBFL_DONT_ORPHAN = 8,
	SKBFL_MANAGED_FRAG_REFS = 16,
};

enum {
	SKBTX_HW_TSTAMP_NOBPF = 1,
	SKBTX_SW_TSTAMP = 2,
	SKBTX_IN_PROGRESS = 4,
	SKBTX_COMPLETION_TSTAMP = 8,
	SKBTX_HW_TSTAMP_NETDEV = 32,
	SKBTX_SCHED_TSTAMP = 64,
	SKBTX_BPF = 128,
};

enum {
	SKB_FCLONE_UNAVAILABLE = 0,
	SKB_FCLONE_ORIG = 1,
	SKB_FCLONE_CLONE = 2,
};

enum {
	SKB_GSO_TCPV4 = 1,
	SKB_GSO_DODGY = 2,
	SKB_GSO_TCP_ECN = 4,
	SKB_GSO_TCP_FIXEDID = 8,
	SKB_GSO_TCPV6 = 16,
	SKB_GSO_FCOE = 32,
	SKB_GSO_GRE = 64,
	SKB_GSO_GRE_CSUM = 128,
	SKB_GSO_IPXIP4 = 256,
	SKB_GSO_IPXIP6 = 512,
	SKB_GSO_UDP_TUNNEL = 1024,
	SKB_GSO_UDP_TUNNEL_CSUM = 2048,
	SKB_GSO_PARTIAL = 4096,
	SKB_GSO_TUNNEL_REMCSUM = 8192,
	SKB_GSO_SCTP = 16384,
	SKB_GSO_ESP = 32768,
	SKB_GSO_UDP = 65536,
	SKB_GSO_UDP_L4 = 131072,
	SKB_GSO_FRAGLIST = 262144,
	SKB_GSO_TCP_ACCECN = 524288,
};

enum {
	SKCIPHER_WALK_SLOW = 1,
	SKCIPHER_WALK_COPY = 2,
	SKCIPHER_WALK_DIFF = 4,
	SKCIPHER_WALK_SLEEP = 8,
};

enum {
	SK_BPF_CB_TX_TIMESTAMPING = 1,
	SK_BPF_CB_MASK = 1,
};

enum {
	SK_DIAG_BPF_STORAGE_NONE = 0,
	SK_DIAG_BPF_STORAGE_PAD = 1,
	SK_DIAG_BPF_STORAGE_MAP_ID = 2,
	SK_DIAG_BPF_STORAGE_MAP_VALUE = 3,
	__SK_DIAG_BPF_STORAGE_MAX = 4,
};

enum {
	SK_DIAG_BPF_STORAGE_REP_NONE = 0,
	SK_DIAG_BPF_STORAGE = 1,
	__SK_DIAG_BPF_STORAGE_REP_MAX = 2,
};

enum {
	SK_DIAG_BPF_STORAGE_REQ_NONE = 0,
	SK_DIAG_BPF_STORAGE_REQ_MAP_FD = 1,
	__SK_DIAG_BPF_STORAGE_REQ_MAX = 2,
};

enum {
	SK_MEMINFO_RMEM_ALLOC = 0,
	SK_MEMINFO_RCVBUF = 1,
	SK_MEMINFO_WMEM_ALLOC = 2,
	SK_MEMINFO_SNDBUF = 3,
	SK_MEMINFO_FWD_ALLOC = 4,
	SK_MEMINFO_WMEM_QUEUED = 5,
	SK_MEMINFO_OPTMEM = 6,
	SK_MEMINFO_BACKLOG = 7,
	SK_MEMINFO_DROPS = 8,
	SK_MEMINFO_VARS = 9,
};

enum {
	SM6115_MASTER_AMPSS_M0 = 0,
	SM6115_MASTER_ANOC_SNOC = 1,
	SM6115_MASTER_BIMC_SNOC = 2,
	SM6115_MASTER_CAMNOC_HF = 3,
	SM6115_MASTER_CAMNOC_SF = 4,
	SM6115_MASTER_CRYPTO_CORE0 = 5,
	SM6115_MASTER_GRAPHICS_3D = 6,
	SM6115_MASTER_IPA = 7,
	SM6115_MASTER_MDP_PORT0 = 8,
	SM6115_MASTER_PIMEM = 9,
	SM6115_MASTER_QDSS_BAM = 10,
	SM6115_MASTER_QDSS_DAP = 11,
	SM6115_MASTER_QDSS_ETR = 12,
	SM6115_MASTER_QPIC = 13,
	SM6115_MASTER_QUP_0 = 14,
	SM6115_MASTER_QUP_CORE_0 = 15,
	SM6115_MASTER_SDCC_1 = 16,
	SM6115_MASTER_SDCC_2 = 17,
	SM6115_MASTER_SNOC_BIMC_NRT = 18,
	SM6115_MASTER_SNOC_BIMC_RT = 19,
	SM6115_MASTER_SNOC_BIMC = 20,
	SM6115_MASTER_SNOC_CFG = 21,
	SM6115_MASTER_SNOC_CNOC = 22,
	SM6115_MASTER_TCU_0 = 23,
	SM6115_MASTER_TIC = 24,
	SM6115_MASTER_USB3 = 25,
	SM6115_MASTER_VIDEO_P0 = 26,
	SM6115_MASTER_VIDEO_PROC = 27,
	SM6115_SLAVE_AHB2PHY_USB = 28,
	SM6115_SLAVE_ANOC_SNOC = 29,
	SM6115_SLAVE_APPSS = 30,
	SM6115_SLAVE_APSS_THROTTLE_CFG = 31,
	SM6115_SLAVE_BIMC_CFG = 32,
	SM6115_SLAVE_BIMC_SNOC = 33,
	SM6115_SLAVE_BOOT_ROM = 34,
	SM6115_SLAVE_CAMERA_CFG = 35,
	SM6115_SLAVE_CAMERA_NRT_THROTTLE_CFG = 36,
	SM6115_SLAVE_CAMERA_RT_THROTTLE_CFG = 37,
	SM6115_SLAVE_CLK_CTL = 38,
	SM6115_SLAVE_CNOC_MSS = 39,
	SM6115_SLAVE_CRYPTO_0_CFG = 40,
	SM6115_SLAVE_DCC_CFG = 41,
	SM6115_SLAVE_DDR_PHY_CFG = 42,
	SM6115_SLAVE_DDR_SS_CFG = 43,
	SM6115_SLAVE_DISPLAY_CFG = 44,
	SM6115_SLAVE_DISPLAY_THROTTLE_CFG = 45,
	SM6115_SLAVE_EBI_CH0 = 46,
	SM6115_SLAVE_GPU_CFG = 47,
	SM6115_SLAVE_GPU_THROTTLE_CFG = 48,
	SM6115_SLAVE_HWKM_CORE = 49,
	SM6115_SLAVE_IMEM_CFG = 50,
	SM6115_SLAVE_IPA_CFG = 51,
	SM6115_SLAVE_LPASS = 52,
	SM6115_SLAVE_MAPSS = 53,
	SM6115_SLAVE_MDSP_MPU_CFG = 54,
	SM6115_SLAVE_MESSAGE_RAM = 55,
	SM6115_SLAVE_OCIMEM = 56,
	SM6115_SLAVE_PDM = 57,
	SM6115_SLAVE_PIMEM_CFG = 58,
	SM6115_SLAVE_PIMEM = 59,
	SM6115_SLAVE_PKA_CORE = 60,
	SM6115_SLAVE_PMIC_ARB = 61,
	SM6115_SLAVE_QDSS_CFG = 62,
	SM6115_SLAVE_QDSS_STM = 63,
	SM6115_SLAVE_QM_CFG = 64,
	SM6115_SLAVE_QM_MPU_CFG = 65,
	SM6115_SLAVE_QPIC = 66,
	SM6115_SLAVE_QUP_0 = 67,
	SM6115_SLAVE_QUP_CORE_0 = 68,
	SM6115_SLAVE_RBCPR_CX_CFG = 69,
	SM6115_SLAVE_RBCPR_MX_CFG = 70,
	SM6115_SLAVE_RPM = 71,
	SM6115_SLAVE_SDCC_1 = 72,
	SM6115_SLAVE_SDCC_2 = 73,
	SM6115_SLAVE_SECURITY = 74,
	SM6115_SLAVE_SERVICE_CNOC = 75,
	SM6115_SLAVE_SERVICE_SNOC = 76,
	SM6115_SLAVE_SNOC_BIMC_NRT = 77,
	SM6115_SLAVE_SNOC_BIMC_RT = 78,
	SM6115_SLAVE_SNOC_BIMC = 79,
	SM6115_SLAVE_SNOC_CFG = 80,
	SM6115_SLAVE_SNOC_CNOC = 81,
	SM6115_SLAVE_TCSR = 82,
	SM6115_SLAVE_TCU = 83,
	SM6115_SLAVE_TLMM = 84,
	SM6115_SLAVE_USB3 = 85,
	SM6115_SLAVE_VENUS_CFG = 86,
	SM6115_SLAVE_VENUS_THROTTLE_CFG = 87,
	SM6115_SLAVE_VSENSE_CTRL_CFG = 88,
};

enum {
	SM_EFUSE_READ = 0,
	SM_EFUSE_WRITE = 1,
	SM_EFUSE_USER_MAX = 2,
	SM_GET_CHIP_ID = 3,
	SM_A1_PWRC_SET = 4,
	SM_A1_PWRC_GET = 5,
};

enum {
	SNDRV_CHMAP_UNKNOWN = 0,
	SNDRV_CHMAP_NA = 1,
	SNDRV_CHMAP_MONO = 2,
	SNDRV_CHMAP_FL = 3,
	SNDRV_CHMAP_FR = 4,
	SNDRV_CHMAP_RL = 5,
	SNDRV_CHMAP_RR = 6,
	SNDRV_CHMAP_FC = 7,
	SNDRV_CHMAP_LFE = 8,
	SNDRV_CHMAP_SL = 9,
	SNDRV_CHMAP_SR = 10,
	SNDRV_CHMAP_RC = 11,
	SNDRV_CHMAP_FLC = 12,
	SNDRV_CHMAP_FRC = 13,
	SNDRV_CHMAP_RLC = 14,
	SNDRV_CHMAP_RRC = 15,
	SNDRV_CHMAP_FLW = 16,
	SNDRV_CHMAP_FRW = 17,
	SNDRV_CHMAP_FLH = 18,
	SNDRV_CHMAP_FCH = 19,
	SNDRV_CHMAP_FRH = 20,
	SNDRV_CHMAP_TC = 21,
	SNDRV_CHMAP_TFL = 22,
	SNDRV_CHMAP_TFR = 23,
	SNDRV_CHMAP_TFC = 24,
	SNDRV_CHMAP_TRL = 25,
	SNDRV_CHMAP_TRR = 26,
	SNDRV_CHMAP_TRC = 27,
	SNDRV_CHMAP_TFLC = 28,
	SNDRV_CHMAP_TFRC = 29,
	SNDRV_CHMAP_TSL = 30,
	SNDRV_CHMAP_TSR = 31,
	SNDRV_CHMAP_LLFE = 32,
	SNDRV_CHMAP_RLFE = 33,
	SNDRV_CHMAP_BC = 34,
	SNDRV_CHMAP_BLC = 35,
	SNDRV_CHMAP_BRC = 36,
	SNDRV_CHMAP_LAST = 36,
};

enum {
	SNDRV_CTL_IOCTL_ELEM_LIST32 = 3225965840,
	SNDRV_CTL_IOCTL_ELEM_INFO32 = 3239073041,
	SNDRV_CTL_IOCTL_ELEM_READ32 = 3267908882,
	SNDRV_CTL_IOCTL_ELEM_WRITE32 = 3267908883,
	SNDRV_CTL_IOCTL_ELEM_ADD32 = 3239073047,
	SNDRV_CTL_IOCTL_ELEM_REPLACE32 = 3239073048,
};

enum {
	SNDRV_CTL_TLV_OP_READ = 0,
	SNDRV_CTL_TLV_OP_WRITE = 1,
	SNDRV_CTL_TLV_OP_CMD = -1,
};

enum {
	SNDRV_DEVICE_TYPE_CONTROL = 0,
	SNDRV_DEVICE_TYPE_SEQUENCER = 1,
	SNDRV_DEVICE_TYPE_TIMER = 2,
	SNDRV_DEVICE_TYPE_HWDEP = 3,
	SNDRV_DEVICE_TYPE_RAWMIDI = 4,
	SNDRV_DEVICE_TYPE_PCM_PLAYBACK = 5,
	SNDRV_DEVICE_TYPE_PCM_CAPTURE = 6,
	SNDRV_DEVICE_TYPE_COMPRESS = 7,
};

enum {
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_COMPAT = 0,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_DEFAULT = 1,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK = 2,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK_ABSOLUTE = 3,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK_ESTIMATED = 4,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK_SYNCHRONIZED = 5,
	SNDRV_PCM_AUDIO_TSTAMP_TYPE_LAST = 5,
};

enum {
	SNDRV_PCM_CLASS_GENERIC = 0,
	SNDRV_PCM_CLASS_MULTI = 1,
	SNDRV_PCM_CLASS_MODEM = 2,
	SNDRV_PCM_CLASS_DIGITIZER = 3,
	SNDRV_PCM_CLASS_LAST = 3,
};

enum {
	SNDRV_PCM_IOCTL_HW_REFINE32 = 3260825872,
	SNDRV_PCM_IOCTL_HW_PARAMS32 = 3260825873,
	SNDRV_PCM_IOCTL_SW_PARAMS32 = 3228057875,
	SNDRV_PCM_IOCTL_STATUS_COMPAT32 = 2154578208,
	SNDRV_PCM_IOCTL_STATUS_EXT_COMPAT32 = 3228320036,
	SNDRV_PCM_IOCTL_DELAY32 = 2147762465,
	SNDRV_PCM_IOCTL_CHANNEL_INFO32 = 2148548914,
	SNDRV_PCM_IOCTL_REWIND32 = 1074020678,
	SNDRV_PCM_IOCTL_FORWARD32 = 1074020681,
	SNDRV_PCM_IOCTL_WRITEI_FRAMES32 = 1074544976,
	SNDRV_PCM_IOCTL_READI_FRAMES32 = 2148286801,
	SNDRV_PCM_IOCTL_WRITEN_FRAMES32 = 1074544978,
	SNDRV_PCM_IOCTL_READN_FRAMES32 = 2148286803,
	SNDRV_PCM_IOCTL_STATUS_COMPAT64 = 2155888928,
	SNDRV_PCM_IOCTL_STATUS_EXT_COMPAT64 = 3229630756,
};

enum {
	SNDRV_PCM_MMAP_OFFSET_DATA = 0,
	SNDRV_PCM_MMAP_OFFSET_STATUS_OLD = 2147483648,
	SNDRV_PCM_MMAP_OFFSET_CONTROL_OLD = 2164260864,
	SNDRV_PCM_MMAP_OFFSET_STATUS_NEW = 2181038080,
	SNDRV_PCM_MMAP_OFFSET_CONTROL_NEW = 2197815296,
	SNDRV_PCM_MMAP_OFFSET_STATUS = 2181038080,
	SNDRV_PCM_MMAP_OFFSET_CONTROL = 2197815296,
};

enum {
	SNDRV_PCM_STREAM_PLAYBACK = 0,
	SNDRV_PCM_STREAM_CAPTURE = 1,
	SNDRV_PCM_STREAM_LAST = 1,
};

enum {
	SNDRV_PCM_TSTAMP_NONE = 0,
	SNDRV_PCM_TSTAMP_ENABLE = 1,
	SNDRV_PCM_TSTAMP_LAST = 1,
};

enum {
	SNDRV_PCM_TSTAMP_TYPE_GETTIMEOFDAY = 0,
	SNDRV_PCM_TSTAMP_TYPE_MONOTONIC = 1,
	SNDRV_PCM_TSTAMP_TYPE_MONOTONIC_RAW = 2,
	SNDRV_PCM_TSTAMP_TYPE_LAST = 2,
};

enum {
	SNDRV_TIMER_CLASS_NONE = -1,
	SNDRV_TIMER_CLASS_SLAVE = 0,
	SNDRV_TIMER_CLASS_GLOBAL = 1,
	SNDRV_TIMER_CLASS_CARD = 2,
	SNDRV_TIMER_CLASS_PCM = 3,
	SNDRV_TIMER_CLASS_LAST = 3,
};

enum {
	SNDRV_TIMER_EVENT_RESOLUTION = 0,
	SNDRV_TIMER_EVENT_TICK = 1,
	SNDRV_TIMER_EVENT_START = 2,
	SNDRV_TIMER_EVENT_STOP = 3,
	SNDRV_TIMER_EVENT_CONTINUE = 4,
	SNDRV_TIMER_EVENT_PAUSE = 5,
	SNDRV_TIMER_EVENT_EARLY = 6,
	SNDRV_TIMER_EVENT_SUSPEND = 7,
	SNDRV_TIMER_EVENT_RESUME = 8,
	SNDRV_TIMER_EVENT_MSTART = 12,
	SNDRV_TIMER_EVENT_MSTOP = 13,
	SNDRV_TIMER_EVENT_MCONTINUE = 14,
	SNDRV_TIMER_EVENT_MPAUSE = 15,
	SNDRV_TIMER_EVENT_MSUSPEND = 17,
	SNDRV_TIMER_EVENT_MRESUME = 18,
};

enum {
	SNDRV_TIMER_IOCTL_GPARAMS32 = 1077695492,
	SNDRV_TIMER_IOCTL_INFO32 = 2162185233,
	SNDRV_TIMER_IOCTL_STATUS_COMPAT32 = 1079530516,
	SNDRV_TIMER_IOCTL_STATUS_COMPAT64 = 1080054804,
};

enum {
	SNDRV_TIMER_IOCTL_START_OLD = 21536,
	SNDRV_TIMER_IOCTL_STOP_OLD = 21537,
	SNDRV_TIMER_IOCTL_CONTINUE_OLD = 21538,
	SNDRV_TIMER_IOCTL_PAUSE_OLD = 21539,
};

enum {
	SNDRV_TIMER_SCLASS_NONE = 0,
	SNDRV_TIMER_SCLASS_APPLICATION = 1,
	SNDRV_TIMER_SCLASS_SEQUENCER = 2,
	SNDRV_TIMER_SCLASS_OSS_SEQUENCER = 3,
	SNDRV_TIMER_SCLASS_LAST = 3,
};

enum {
	SND_CTL_SUBDEV_PCM = 0,
	SND_CTL_SUBDEV_RAWMIDI = 1,
	SND_CTL_SUBDEV_ITEMS = 2,
};

enum {
	SOCK_WAKE_IO = 0,
	SOCK_WAKE_WAITD = 1,
	SOCK_WAKE_SPACE = 2,
	SOCK_WAKE_URG = 3,
};

enum {
	SOF_TIMESTAMPING_TX_HARDWARE = 1,
	SOF_TIMESTAMPING_TX_SOFTWARE = 2,
	SOF_TIMESTAMPING_RX_HARDWARE = 4,
	SOF_TIMESTAMPING_RX_SOFTWARE = 8,
	SOF_TIMESTAMPING_SOFTWARE = 16,
	SOF_TIMESTAMPING_SYS_HARDWARE = 32,
	SOF_TIMESTAMPING_RAW_HARDWARE = 64,
	SOF_TIMESTAMPING_OPT_ID = 128,
	SOF_TIMESTAMPING_TX_SCHED = 256,
	SOF_TIMESTAMPING_TX_ACK = 512,
	SOF_TIMESTAMPING_OPT_CMSG = 1024,
	SOF_TIMESTAMPING_OPT_TSONLY = 2048,
	SOF_TIMESTAMPING_OPT_STATS = 4096,
	SOF_TIMESTAMPING_OPT_PKTINFO = 8192,
	SOF_TIMESTAMPING_OPT_TX_SWHW = 16384,
	SOF_TIMESTAMPING_BIND_PHC = 32768,
	SOF_TIMESTAMPING_OPT_ID_TCP = 65536,
	SOF_TIMESTAMPING_OPT_RX_FILTER = 131072,
	SOF_TIMESTAMPING_TX_COMPLETION = 262144,
	SOF_TIMESTAMPING_LAST = 262144,
	SOF_TIMESTAMPING_MASK = 524287,
};

enum {
	SOUTH___5 = 0,
	EAST___3 = 1,
	WEST___3 = 2,
};

enum {
	SP_TASK_PENDING = 0,
	SP_NEED_VICTIM = 1,
	SP_VICTIM_REMAINS = 2,
};

enum {
	SQ_START = 0,
	SQ_STOP = 1,
	SQ_ICU = 2,
};

enum {
	SQ_STS = 1,
	SQ_CUS = 2,
};

enum {
	STATE_IDLE = 0,
	STATE_READ = 1,
	STATE_WRITE = 2,
};

enum {
	STAT_CTRL = 3712,
	STAT_LAST_IDX = 3716,
	STAT_LIST_ADDR_LO = 3720,
	STAT_LIST_ADDR_HI = 3724,
	STAT_TXA1_RIDX = 3728,
	STAT_TXS1_RIDX = 3730,
	STAT_TXA2_RIDX = 3732,
	STAT_TXS2_RIDX = 3734,
	STAT_TX_IDX_TH = 3736,
	STAT_PUT_IDX = 3740,
	STAT_FIFO_WP = 3744,
	STAT_FIFO_RP = 3748,
	STAT_FIFO_RSP = 3750,
	STAT_FIFO_LEVEL = 3752,
	STAT_FIFO_SHLVL = 3754,
	STAT_FIFO_WM = 3756,
	STAT_FIFO_ISR_WM = 3757,
	STAT_LEV_TIMER_INI = 3760,
	STAT_LEV_TIMER_CNT = 3764,
	STAT_LEV_TIMER_CTRL = 3768,
	STAT_LEV_TIMER_TEST = 3769,
	STAT_TX_TIMER_INI = 3776,
	STAT_TX_TIMER_CNT = 3780,
	STAT_TX_TIMER_CTRL = 3784,
	STAT_TX_TIMER_TEST = 3785,
	STAT_ISR_TIMER_INI = 3792,
	STAT_ISR_TIMER_CNT = 3796,
	STAT_ISR_TIMER_CTRL = 3800,
	STAT_ISR_TIMER_TEST = 3801,
};

enum {
	SUNRPC_PIPEFS_NFS_PRIO = 0,
	SUNRPC_PIPEFS_RPC_PRIO = 1,
};

enum {
	SUNXI_SRC_TYPE_LEVEL_LOW = 0,
	SUNXI_SRC_TYPE_EDGE_FALLING = 1,
	SUNXI_SRC_TYPE_LEVEL_HIGH = 2,
	SUNXI_SRC_TYPE_EDGE_RISING = 3,
};

enum {
	SVC_HANDSHAKE_TO = 1250,
};

enum {
	SVC_POOL_AUTO = -1,
	SVC_POOL_GLOBAL = 0,
	SVC_POOL_PERCPU = 1,
	SVC_POOL_PERNODE = 2,
};

enum {
	SWITCHTEC_GAS_MRPC_OFFSET = 0,
	SWITCHTEC_GAS_TOP_CFG_OFFSET = 4096,
	SWITCHTEC_GAS_SW_EVENT_OFFSET = 6144,
	SWITCHTEC_GAS_SYS_INFO_OFFSET = 8192,
	SWITCHTEC_GAS_FLASH_INFO_OFFSET = 8704,
	SWITCHTEC_GAS_PART_CFG_OFFSET = 16384,
	SWITCHTEC_GAS_NTB_OFFSET = 65536,
	SWITCHTEC_GAS_PFF_CSR_OFFSET = 1261568,
};

enum {
	SWITCHTEC_NTB_REG_INFO_OFFSET = 0,
	SWITCHTEC_NTB_REG_CTRL_OFFSET = 16384,
	SWITCHTEC_NTB_REG_DBMSG_OFFSET = 409600,
};

enum {
	SWMII_SPEED_10 = 0,
	SWMII_SPEED_100 = 1,
	SWMII_SPEED_1000 = 2,
	SWMII_DUPLEX_HALF = 0,
	SWMII_DUPLEX_FULL = 1,
};

enum {
	SWP_USED = 1,
	SWP_WRITEOK = 2,
	SWP_DISCARDABLE = 4,
	SWP_DISCARDING = 8,
	SWP_SOLIDSTATE = 16,
	SWP_CONTINUED = 32,
	SWP_BLKDEV = 64,
	SWP_ACTIVATED = 128,
	SWP_FS_OPS = 256,
	SWP_AREA_DISCARD = 512,
	SWP_PAGE_DISCARD = 1024,
	SWP_STABLE_WRITES = 2048,
	SWP_SYNCHRONOUS_IO = 4096,
};

enum {
	SYNAPTICS_INTERTOUCH_NOT_SET = -1,
	SYNAPTICS_INTERTOUCH_OFF = 0,
	SYNAPTICS_INTERTOUCH_ON = 1,
};

enum {
	SYNC_LEN_G1 = 80000,
	SYNC_LEN_G2 = 40000,
	SYNC_LEN_G3 = 20000,
};

enum {
	SYSTAB = 0,
	MMBASE = 1,
	MMSIZE = 2,
	DCSIZE = 3,
	DCVERS = 4,
	PARAMCOUNT = 5,
};

enum {
	TASKLET_STATE_SCHED = 0,
	TASKLET_STATE_RUN = 1,
};

enum {
	TASKSTATS_CMD_ATTR_UNSPEC = 0,
	TASKSTATS_CMD_ATTR_PID = 1,
	TASKSTATS_CMD_ATTR_TGID = 2,
	TASKSTATS_CMD_ATTR_REGISTER_CPUMASK = 3,
	TASKSTATS_CMD_ATTR_DEREGISTER_CPUMASK = 4,
	__TASKSTATS_CMD_ATTR_MAX = 5,
};

enum {
	TASKSTATS_CMD_UNSPEC = 0,
	TASKSTATS_CMD_GET = 1,
	TASKSTATS_CMD_NEW = 2,
	__TASKSTATS_CMD_MAX = 3,
};

enum {
	TASKSTATS_TYPE_UNSPEC = 0,
	TASKSTATS_TYPE_PID = 1,
	TASKSTATS_TYPE_TGID = 2,
	TASKSTATS_TYPE_STATS = 3,
	TASKSTATS_TYPE_AGGR_PID = 4,
	TASKSTATS_TYPE_AGGR_TGID = 5,
	TASKSTATS_TYPE_NULL = 6,
	__TASKSTATS_TYPE_MAX = 7,
};

enum {
	TASK_COMM_LEN = 16,
};

enum {
	TASK_REQ_UPIU_SIZE_DWORDS = 8,
	TASK_RSP_UPIU_SIZE_DWORDS = 8,
	ALIGNED_UPIU_SIZE = 512,
};

enum {
	TBMU_TEST_BMU_TX_CHK_AUTO_OFF = -2147483648,
	TBMU_TEST_BMU_TX_CHK_AUTO_ON = 1073741824,
	TBMU_TEST_HOME_ADD_PAD_FIX1_EN = 536870912,
	TBMU_TEST_HOME_ADD_PAD_FIX1_DIS = 268435456,
	TBMU_TEST_ROUTING_ADD_FIX_EN = 134217728,
	TBMU_TEST_ROUTING_ADD_FIX_DIS = 67108864,
	TBMU_TEST_HOME_ADD_FIX_EN = 33554432,
	TBMU_TEST_HOME_ADD_FIX_DIS = 16777216,
	TBMU_TEST_TEST_RSPTR_ON = 4194304,
	TBMU_TEST_TEST_RSPTR_OFF = 2097152,
	TBMU_TEST_TESTSTEP_RSPTR = 1048576,
	TBMU_TEST_TEST_RPTR_ON = 262144,
	TBMU_TEST_TEST_RPTR_OFF = 131072,
	TBMU_TEST_TESTSTEP_RPTR = 65536,
	TBMU_TEST_TEST_WSPTR_ON = 16384,
	TBMU_TEST_TEST_WSPTR_OFF = 8192,
	TBMU_TEST_TESTSTEP_WSPTR = 4096,
	TBMU_TEST_TEST_WPTR_ON = 1024,
	TBMU_TEST_TEST_WPTR_OFF = 512,
	TBMU_TEST_TESTSTEP_WPTR = 256,
	TBMU_TEST_TEST_REQ_NB_ON = 64,
	TBMU_TEST_TEST_REQ_NB_OFF = 32,
	TBMU_TEST_TESTSTEP_REQ_NB = 16,
	TBMU_TEST_TEST_DONE_IDX_ON = 4,
	TBMU_TEST_TEST_DONE_IDX_OFF = 2,
	TBMU_TEST_TESTSTEP_DONE_IDX = 1,
};

enum {
	TCA_ACT_UNSPEC = 0,
	TCA_ACT_KIND = 1,
	TCA_ACT_OPTIONS = 2,
	TCA_ACT_INDEX = 3,
	TCA_ACT_STATS = 4,
	TCA_ACT_PAD = 5,
	TCA_ACT_COOKIE = 6,
	TCA_ACT_FLAGS = 7,
	TCA_ACT_HW_STATS = 8,
	TCA_ACT_USED_HW_STATS = 9,
	TCA_ACT_IN_HW_COUNT = 10,
	__TCA_ACT_MAX = 11,
};

enum {
	TCA_FLOWER_KEY_CT_FLAGS_NEW = 1,
	TCA_FLOWER_KEY_CT_FLAGS_ESTABLISHED = 2,
	TCA_FLOWER_KEY_CT_FLAGS_RELATED = 4,
	TCA_FLOWER_KEY_CT_FLAGS_TRACKED = 8,
	TCA_FLOWER_KEY_CT_FLAGS_INVALID = 16,
	TCA_FLOWER_KEY_CT_FLAGS_REPLY = 32,
	__TCA_FLOWER_KEY_CT_FLAGS_MAX = 33,
};

enum {
	TCA_FLOWER_KEY_FLAGS_IS_FRAGMENT = 1,
	TCA_FLOWER_KEY_FLAGS_FRAG_IS_FIRST = 2,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_CSUM = 4,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_DONT_FRAGMENT = 8,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_OAM = 16,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_CRIT_OPT = 32,
	__TCA_FLOWER_KEY_FLAGS_MAX = 33,
};

enum {
	TCA_ROOT_UNSPEC = 0,
	TCA_ROOT_TAB = 1,
	TCA_ROOT_FLAGS = 2,
	TCA_ROOT_COUNT = 3,
	TCA_ROOT_TIME_DELTA = 4,
	TCA_ROOT_EXT_WARN_MSG = 5,
	__TCA_ROOT_MAX = 6,
};

enum {
	TCA_STAB_UNSPEC = 0,
	TCA_STAB_BASE = 1,
	TCA_STAB_DATA = 2,
	__TCA_STAB_MAX = 3,
};

enum {
	TCA_STATS_UNSPEC = 0,
	TCA_STATS_BASIC = 1,
	TCA_STATS_RATE_EST = 2,
	TCA_STATS_QUEUE = 3,
	TCA_STATS_APP = 4,
	TCA_STATS_RATE_EST64 = 5,
	TCA_STATS_PAD = 6,
	TCA_STATS_BASIC_HW = 7,
	TCA_STATS_PKT64 = 8,
	__TCA_STATS_MAX = 9,
};

enum {
	TCA_UNSPEC = 0,
	TCA_KIND = 1,
	TCA_OPTIONS = 2,
	TCA_STATS = 3,
	TCA_XSTATS = 4,
	TCA_RATE = 5,
	TCA_FCNT = 6,
	TCA_STATS2 = 7,
	TCA_STAB = 8,
	TCA_PAD = 9,
	TCA_DUMP_INVISIBLE = 10,
	TCA_CHAIN = 11,
	TCA_HW_OFFLOAD = 12,
	TCA_INGRESS_BLOCK = 13,
	TCA_EGRESS_BLOCK = 14,
	TCA_DUMP_FLAGS = 15,
	TCA_EXT_WARN_MSG = 16,
	__TCA_MAX = 17,
};

enum {
	TCPF_ESTABLISHED = 2,
	TCPF_SYN_SENT = 4,
	TCPF_SYN_RECV = 8,
	TCPF_FIN_WAIT1 = 16,
	TCPF_FIN_WAIT2 = 32,
	TCPF_TIME_WAIT = 64,
	TCPF_CLOSE = 128,
	TCPF_CLOSE_WAIT = 256,
	TCPF_LAST_ACK = 512,
	TCPF_LISTEN = 1024,
	TCPF_CLOSING = 2048,
	TCPF_NEW_SYN_RECV = 4096,
	TCPF_BOUND_INACTIVE = 8192,
};

enum {
	TCP_BPF_BASE = 0,
	TCP_BPF_TX = 1,
	TCP_BPF_RX = 2,
	TCP_BPF_TXRX = 3,
	TCP_BPF_NUM_CFGS = 4,
};

enum {
	TCP_BPF_IPV4 = 0,
	TCP_BPF_IPV6 = 1,
	TCP_BPF_NUM_PROTS = 2,
};

enum {
	TCP_BPF_IW = 1001,
	TCP_BPF_SNDCWND_CLAMP = 1002,
	TCP_BPF_DELACK_MAX = 1003,
	TCP_BPF_RTO_MIN = 1004,
	TCP_BPF_SYN = 1005,
	TCP_BPF_SYN_IP = 1006,
	TCP_BPF_SYN_MAC = 1007,
	TCP_BPF_SOCK_OPS_CB_FLAGS = 1008,
	SK_BPF_CB_FLAGS = 1009,
};

enum {
	TCP_CMSG_INQ = 1,
	TCP_CMSG_TS = 2,
};

enum {
	TCP_ESTABLISHED = 1,
	TCP_SYN_SENT = 2,
	TCP_SYN_RECV = 3,
	TCP_FIN_WAIT1 = 4,
	TCP_FIN_WAIT2 = 5,
	TCP_TIME_WAIT = 6,
	TCP_CLOSE = 7,
	TCP_CLOSE_WAIT = 8,
	TCP_LAST_ACK = 9,
	TCP_LISTEN = 10,
	TCP_CLOSING = 11,
	TCP_NEW_SYN_RECV = 12,
	TCP_BOUND_INACTIVE = 13,
	TCP_MAX_STATES = 14,
};

enum {
	TCP_FLAG_AE = 1,
	TCP_FLAG_CWR = 32768,
	TCP_FLAG_ECE = 16384,
	TCP_FLAG_URG = 8192,
	TCP_FLAG_ACK = 4096,
	TCP_FLAG_PSH = 2048,
	TCP_FLAG_RST = 1024,
	TCP_FLAG_SYN = 512,
	TCP_FLAG_FIN = 256,
	TCP_RESERVED_BITS = 14,
	TCP_DATA_OFFSET = 240,
};

enum {
	TCP_METRICS_ATTR_UNSPEC = 0,
	TCP_METRICS_ATTR_ADDR_IPV4 = 1,
	TCP_METRICS_ATTR_ADDR_IPV6 = 2,
	TCP_METRICS_ATTR_AGE = 3,
	TCP_METRICS_ATTR_TW_TSVAL = 4,
	TCP_METRICS_ATTR_TW_TS_STAMP = 5,
	TCP_METRICS_ATTR_VALS = 6,
	TCP_METRICS_ATTR_FOPEN_MSS = 7,
	TCP_METRICS_ATTR_FOPEN_SYN_DROPS = 8,
	TCP_METRICS_ATTR_FOPEN_SYN_DROP_TS = 9,
	TCP_METRICS_ATTR_FOPEN_COOKIE = 10,
	TCP_METRICS_ATTR_SADDR_IPV4 = 11,
	TCP_METRICS_ATTR_SADDR_IPV6 = 12,
	TCP_METRICS_ATTR_PAD = 13,
	__TCP_METRICS_ATTR_MAX = 14,
};

enum {
	TCP_METRICS_CMD_UNSPEC = 0,
	TCP_METRICS_CMD_GET = 1,
	TCP_METRICS_CMD_DEL = 2,
	__TCP_METRICS_CMD_MAX = 3,
};

enum {
	TCP_MIB_NUM = 0,
	TCP_MIB_RTOALGORITHM = 1,
	TCP_MIB_RTOMIN = 2,
	TCP_MIB_RTOMAX = 3,
	TCP_MIB_MAXCONN = 4,
	TCP_MIB_ACTIVEOPENS = 5,
	TCP_MIB_PASSIVEOPENS = 6,
	TCP_MIB_ATTEMPTFAILS = 7,
	TCP_MIB_ESTABRESETS = 8,
	TCP_MIB_CURRESTAB = 9,
	TCP_MIB_INSEGS = 10,
	TCP_MIB_OUTSEGS = 11,
	TCP_MIB_RETRANSSEGS = 12,
	TCP_MIB_INERRS = 13,
	TCP_MIB_OUTRSTS = 14,
	TCP_MIB_CSUMERRORS = 15,
	__TCP_MIB_MAX = 16,
};

enum {
	TCP_NLA_PAD = 0,
	TCP_NLA_BUSY = 1,
	TCP_NLA_RWND_LIMITED = 2,
	TCP_NLA_SNDBUF_LIMITED = 3,
	TCP_NLA_DATA_SEGS_OUT = 4,
	TCP_NLA_TOTAL_RETRANS = 5,
	TCP_NLA_PACING_RATE = 6,
	TCP_NLA_DELIVERY_RATE = 7,
	TCP_NLA_SND_CWND = 8,
	TCP_NLA_REORDERING = 9,
	TCP_NLA_MIN_RTT = 10,
	TCP_NLA_RECUR_RETRANS = 11,
	TCP_NLA_DELIVERY_RATE_APP_LMT = 12,
	TCP_NLA_SNDQ_SIZE = 13,
	TCP_NLA_CA_STATE = 14,
	TCP_NLA_SND_SSTHRESH = 15,
	TCP_NLA_DELIVERED = 16,
	TCP_NLA_DELIVERED_CE = 17,
	TCP_NLA_BYTES_SENT = 18,
	TCP_NLA_BYTES_RETRANS = 19,
	TCP_NLA_DSACK_DUPS = 20,
	TCP_NLA_REORD_SEEN = 21,
	TCP_NLA_SRTT = 22,
	TCP_NLA_TIMEOUT_REHASH = 23,
	TCP_NLA_BYTES_NOTSENT = 24,
	TCP_NLA_EDT = 25,
	TCP_NLA_TTL = 26,
	TCP_NLA_REHASH = 27,
};

enum {
	TCP_NO_QUEUE = 0,
	TCP_RECV_QUEUE = 1,
	TCP_SEND_QUEUE = 2,
	TCP_QUEUES_NR = 3,
};

enum {
	TCP_V4_FLOW = 1,
	UDP_V4_FLOW = 2,
	SCTP_V4_FLOW = 3,
	AH_ESP_V4_FLOW = 4,
	TCP_V6_FLOW = 5,
	UDP_V6_FLOW = 6,
	SCTP_V6_FLOW = 7,
	AH_ESP_V6_FLOW = 8,
	AH_V4_FLOW = 9,
	ESP_V4_FLOW = 10,
	AH_V6_FLOW = 11,
	ESP_V6_FLOW = 12,
	IPV4_USER_FLOW = 13,
	IP_USER_FLOW = 13,
	IPV6_USER_FLOW = 14,
	IPV4_FLOW = 16,
	IPV6_FLOW = 17,
	ETHER_FLOW = 18,
	GTPU_V4_FLOW = 19,
	GTPU_V6_FLOW = 20,
	GTPC_V4_FLOW = 21,
	GTPC_V6_FLOW = 22,
	GTPC_TEID_V4_FLOW = 23,
	GTPC_TEID_V6_FLOW = 24,
	GTPU_EH_V4_FLOW = 25,
	GTPU_EH_V6_FLOW = 26,
	GTPU_UL_V4_FLOW = 27,
	GTPU_UL_V6_FLOW = 28,
	GTPU_DL_V4_FLOW = 29,
	GTPU_DL_V6_FLOW = 30,
	__FLOW_TYPE_COUNT = 31,
};

enum {
	TCS4525_CHIP_ID_12 = 12,
};

enum {
	TCS4526_CHIP_ID_00 = 0,
};

enum {
	TC_MQPRIO_HW_OFFLOAD_NONE = 0,
	TC_MQPRIO_HW_OFFLOAD_TCS = 1,
	__TC_MQPRIO_HW_OFFLOAD_MAX = 2,
};

enum {
	TC_MQPRIO_MODE_DCB = 0,
	TC_MQPRIO_MODE_CHANNEL = 1,
	__TC_MQPRIO_MODE_MAX = 2,
};

enum {
	TC_MQPRIO_SHAPER_DCB = 0,
	TC_MQPRIO_SHAPER_BW_RATE = 1,
	__TC_MQPRIO_SHAPER_MAX = 2,
};

enum {
	TEGRA_PIN_CAN0_DOUT_PAA0 = 0,
	TEGRA_PIN_CAN0_DIN_PAA1 = 1,
	TEGRA_PIN_CAN1_DOUT_PAA2 = 2,
	TEGRA_PIN_CAN1_DIN_PAA3 = 3,
	TEGRA_PIN_CAN0_STB_PAA4 = 4,
	TEGRA_PIN_CAN0_EN_PAA5 = 5,
	TEGRA_PIN_SOC_GPIO49_PAA6 = 6,
	TEGRA_PIN_CAN0_ERR_PAA7 = 7,
	TEGRA_PIN_CAN1_STB_PBB0 = 8,
	TEGRA_PIN_CAN1_EN_PBB1 = 9,
	TEGRA_PIN_SOC_GPIO50_PBB2 = 10,
	TEGRA_PIN_CAN1_ERR_PBB3 = 11,
	TEGRA_PIN_SPI2_SCK_PCC0 = 12,
	TEGRA_PIN_SPI2_MISO_PCC1 = 13,
	TEGRA_PIN_SPI2_MOSI_PCC2 = 14,
	TEGRA_PIN_SPI2_CS0_PCC3 = 15,
	TEGRA_PIN_TOUCH_CLK_PCC4 = 16,
	TEGRA_PIN_UART3_TX_PCC5 = 17,
	TEGRA_PIN_UART3_RX_PCC6 = 18,
	TEGRA_PIN_GEN2_I2C_SCL_PCC7 = 19,
	TEGRA_PIN_GEN2_I2C_SDA_PDD0 = 20,
	TEGRA_PIN_GEN8_I2C_SCL_PDD1 = 21,
	TEGRA_PIN_GEN8_I2C_SDA_PDD2 = 22,
	TEGRA_PIN_SCE_ERROR_PEE0 = 23,
	TEGRA_PIN_VCOMP_ALERT_PEE1 = 24,
	TEGRA_PIN_AO_RETENTION_N_PEE2 = 25,
	TEGRA_PIN_BATT_OC_PEE3 = 26,
	TEGRA_PIN_POWER_ON_PEE4 = 27,
	TEGRA_PIN_SOC_GPIO26_PEE5 = 28,
	TEGRA_PIN_SOC_GPIO27_PEE6 = 29,
	TEGRA_PIN_BOOTV_CTL_N_PEE7 = 30,
	TEGRA_PIN_HDMI_CEC_PGG0 = 31,
};

enum {
	TEGRA_PIN_CAN1_DOUT_PAA0 = 0,
	TEGRA_PIN_CAN1_DIN_PAA1 = 1,
	TEGRA_PIN_CAN0_DOUT_PAA2 = 2,
	TEGRA_PIN_CAN0_DIN_PAA3 = 3,
	TEGRA_PIN_CAN0_STB_PAA4___2 = 4,
	TEGRA_PIN_CAN0_EN_PAA5___2 = 5,
	TEGRA_PIN_CAN0_WAKE_PAA6 = 6,
	TEGRA_PIN_CAN0_ERR_PAA7___2 = 7,
	TEGRA_PIN_CAN1_STB_PBB0___2 = 8,
	TEGRA_PIN_CAN1_EN_PBB1___2 = 9,
	TEGRA_PIN_CAN1_WAKE_PBB2 = 10,
	TEGRA_PIN_CAN1_ERR_PBB3___2 = 11,
	TEGRA_PIN_SPI2_SCK_PCC0___2 = 12,
	TEGRA_PIN_SPI2_MISO_PCC1___2 = 13,
	TEGRA_PIN_SPI2_MOSI_PCC2___2 = 14,
	TEGRA_PIN_SPI2_CS0_PCC3___2 = 15,
	TEGRA_PIN_TOUCH_CLK_PCC4___2 = 16,
	TEGRA_PIN_UART3_TX_PCC5___2 = 17,
	TEGRA_PIN_UART3_RX_PCC6___2 = 18,
	TEGRA_PIN_GEN2_I2C_SCL_PCC7___2 = 19,
	TEGRA_PIN_GEN2_I2C_SDA_PDD0___2 = 20,
	TEGRA_PIN_GEN8_I2C_SCL_PDD1___2 = 21,
	TEGRA_PIN_GEN8_I2C_SDA_PDD2___2 = 22,
	TEGRA_PIN_SAFE_STATE_PEE0 = 23,
	TEGRA_PIN_VCOMP_ALERT_PEE1___2 = 24,
	TEGRA_PIN_AO_RETENTION_N_PEE2___2 = 25,
	TEGRA_PIN_BATT_OC_PEE3___2 = 26,
	TEGRA_PIN_POWER_ON_PEE4___2 = 27,
	TEGRA_PIN_PWR_I2C_SCL_PEE5 = 28,
	TEGRA_PIN_PWR_I2C_SDA_PEE6 = 29,
	TEGRA_PIN_SYS_RESET_N = 30,
	TEGRA_PIN_SHUTDOWN_N = 31,
	TEGRA_PIN_PMU_INT_N = 32,
	TEGRA_PIN_SOC_PWR_REQ = 33,
	TEGRA_PIN_CLK_32K_IN = 34,
};

enum {
	TEGRA_PIN_DAP6_SCLK_PA0 = 0,
	TEGRA_PIN_DAP6_DOUT_PA1 = 1,
	TEGRA_PIN_DAP6_DIN_PA2 = 2,
	TEGRA_PIN_DAP6_FS_PA3 = 3,
	TEGRA_PIN_DAP4_SCLK_PA4 = 4,
	TEGRA_PIN_DAP4_DOUT_PA5 = 5,
	TEGRA_PIN_DAP4_DIN_PA6 = 6,
	TEGRA_PIN_DAP4_FS_PA7 = 7,
	TEGRA_PIN_SOC_GPIO08_PB0 = 8,
	TEGRA_PIN_QSPI0_SCK_PC0 = 9,
	TEGRA_PIN_QSPI0_CS_N_PC1 = 10,
	TEGRA_PIN_QSPI0_IO0_PC2 = 11,
	TEGRA_PIN_QSPI0_IO1_PC3 = 12,
	TEGRA_PIN_QSPI0_IO2_PC4 = 13,
	TEGRA_PIN_QSPI0_IO3_PC5 = 14,
	TEGRA_PIN_QSPI1_SCK_PC6 = 15,
	TEGRA_PIN_QSPI1_CS_N_PC7 = 16,
	TEGRA_PIN_QSPI1_IO0_PD0 = 17,
	TEGRA_PIN_QSPI1_IO1_PD1 = 18,
	TEGRA_PIN_QSPI1_IO2_PD2 = 19,
	TEGRA_PIN_QSPI1_IO3_PD3 = 20,
	TEGRA_PIN_EQOS_TXC_PE0 = 21,
	TEGRA_PIN_EQOS_TD0_PE1 = 22,
	TEGRA_PIN_EQOS_TD1_PE2 = 23,
	TEGRA_PIN_EQOS_TD2_PE3 = 24,
	TEGRA_PIN_EQOS_TD3_PE4 = 25,
	TEGRA_PIN_EQOS_TX_CTL_PE5 = 26,
	TEGRA_PIN_EQOS_RD0_PE6 = 27,
	TEGRA_PIN_EQOS_RD1_PE7 = 28,
	TEGRA_PIN_EQOS_RD2_PF0 = 29,
	TEGRA_PIN_EQOS_RD3_PF1 = 30,
	TEGRA_PIN_EQOS_RX_CTL_PF2 = 31,
	TEGRA_PIN_EQOS_RXC_PF3 = 32,
	TEGRA_PIN_EQOS_SMA_MDIO_PF4 = 33,
	TEGRA_PIN_EQOS_SMA_MDC_PF5 = 34,
	TEGRA_PIN_SOC_GPIO13_PG0 = 35,
	TEGRA_PIN_SOC_GPIO14_PG1 = 36,
	TEGRA_PIN_SOC_GPIO15_PG2 = 37,
	TEGRA_PIN_SOC_GPIO16_PG3 = 38,
	TEGRA_PIN_SOC_GPIO17_PG4 = 39,
	TEGRA_PIN_SOC_GPIO18_PG5 = 40,
	TEGRA_PIN_SOC_GPIO19_PG6 = 41,
	TEGRA_PIN_SOC_GPIO20_PG7 = 42,
	TEGRA_PIN_SOC_GPIO21_PH0 = 43,
	TEGRA_PIN_SOC_GPIO22_PH1 = 44,
	TEGRA_PIN_SOC_GPIO06_PH2 = 45,
	TEGRA_PIN_UART4_TX_PH3 = 46,
	TEGRA_PIN_UART4_RX_PH4 = 47,
	TEGRA_PIN_UART4_RTS_PH5 = 48,
	TEGRA_PIN_UART4_CTS_PH6 = 49,
	TEGRA_PIN_SOC_GPIO41_PH7 = 50,
	TEGRA_PIN_SOC_GPIO42_PI0 = 51,
	TEGRA_PIN_SOC_GPIO43_PI1 = 52,
	TEGRA_PIN_SOC_GPIO44_PI2 = 53,
	TEGRA_PIN_GEN1_I2C_SCL_PI3 = 54,
	TEGRA_PIN_GEN1_I2C_SDA_PI4 = 55,
	TEGRA_PIN_CPU_PWR_REQ_PI5 = 56,
	TEGRA_PIN_SOC_GPIO07_PI6 = 57,
	TEGRA_PIN_SDMMC1_CLK_PJ0 = 58,
	TEGRA_PIN_SDMMC1_CMD_PJ1 = 59,
	TEGRA_PIN_SDMMC1_DAT0_PJ2 = 60,
	TEGRA_PIN_SDMMC1_DAT1_PJ3 = 61,
	TEGRA_PIN_SDMMC1_DAT2_PJ4 = 62,
	TEGRA_PIN_SDMMC1_DAT3_PJ5 = 63,
	TEGRA_PIN_PEX_L0_CLKREQ_N_PK0 = 64,
	TEGRA_PIN_PEX_L0_RST_N_PK1 = 65,
	TEGRA_PIN_PEX_L1_CLKREQ_N_PK2 = 66,
	TEGRA_PIN_PEX_L1_RST_N_PK3 = 67,
	TEGRA_PIN_PEX_L2_CLKREQ_N_PK4 = 68,
	TEGRA_PIN_PEX_L2_RST_N_PK5 = 69,
	TEGRA_PIN_PEX_L3_CLKREQ_N_PK6 = 70,
	TEGRA_PIN_PEX_L3_RST_N_PK7 = 71,
	TEGRA_PIN_PEX_L4_CLKREQ_N_PL0 = 72,
	TEGRA_PIN_PEX_L4_RST_N_PL1 = 73,
	TEGRA_PIN_PEX_WAKE_N_PL2 = 74,
	TEGRA_PIN_SOC_GPIO34_PL3 = 75,
	TEGRA_PIN_DP_AUX_CH0_HPD_PM0 = 76,
	TEGRA_PIN_DP_AUX_CH1_HPD_PM1 = 77,
	TEGRA_PIN_DP_AUX_CH2_HPD_PM2 = 78,
	TEGRA_PIN_DP_AUX_CH3_HPD_PM3 = 79,
	TEGRA_PIN_SOC_GPIO55_PM4 = 80,
	TEGRA_PIN_SOC_GPIO36_PM5 = 81,
	TEGRA_PIN_SOC_GPIO53_PM6 = 82,
	TEGRA_PIN_SOC_GPIO38_PM7 = 83,
	TEGRA_PIN_DP_AUX_CH3_N_PN0 = 84,
	TEGRA_PIN_SOC_GPIO39_PN1 = 85,
	TEGRA_PIN_SOC_GPIO40_PN2 = 86,
	TEGRA_PIN_DP_AUX_CH1_P_PN3 = 87,
	TEGRA_PIN_DP_AUX_CH1_N_PN4 = 88,
	TEGRA_PIN_DP_AUX_CH2_P_PN5 = 89,
	TEGRA_PIN_DP_AUX_CH2_N_PN6 = 90,
	TEGRA_PIN_DP_AUX_CH3_P_PN7 = 91,
	TEGRA_PIN_EXTPERIPH1_CLK_PP0 = 92,
	TEGRA_PIN_EXTPERIPH2_CLK_PP1 = 93,
	TEGRA_PIN_CAM_I2C_SCL_PP2 = 94,
	TEGRA_PIN_CAM_I2C_SDA_PP3 = 95,
	TEGRA_PIN_SOC_GPIO23_PP4 = 96,
	TEGRA_PIN_SOC_GPIO24_PP5 = 97,
	TEGRA_PIN_SOC_GPIO25_PP6 = 98,
	TEGRA_PIN_PWR_I2C_SCL_PP7 = 99,
	TEGRA_PIN_PWR_I2C_SDA_PQ0 = 100,
	TEGRA_PIN_SOC_GPIO28_PQ1 = 101,
	TEGRA_PIN_SOC_GPIO29_PQ2 = 102,
	TEGRA_PIN_SOC_GPIO30_PQ3 = 103,
	TEGRA_PIN_SOC_GPIO31_PQ4 = 104,
	TEGRA_PIN_SOC_GPIO32_PQ5 = 105,
	TEGRA_PIN_SOC_GPIO33_PQ6 = 106,
	TEGRA_PIN_SOC_GPIO35_PQ7 = 107,
	TEGRA_PIN_SOC_GPIO37_PR0 = 108,
	TEGRA_PIN_SOC_GPIO56_PR1 = 109,
	TEGRA_PIN_UART1_TX_PR2 = 110,
	TEGRA_PIN_UART1_RX_PR3 = 111,
	TEGRA_PIN_UART1_RTS_PR4 = 112,
	TEGRA_PIN_UART1_CTS_PR5 = 113,
	TEGRA_PIN_GPU_PWR_REQ_PX0 = 114,
	TEGRA_PIN_CV_PWR_REQ_PX1 = 115,
	TEGRA_PIN_GP_PWM2_PX2 = 116,
	TEGRA_PIN_GP_PWM3_PX3 = 117,
	TEGRA_PIN_UART2_TX_PX4 = 118,
	TEGRA_PIN_UART2_RX_PX5 = 119,
	TEGRA_PIN_UART2_RTS_PX6 = 120,
	TEGRA_PIN_UART2_CTS_PX7 = 121,
	TEGRA_PIN_SPI3_SCK_PY0 = 122,
	TEGRA_PIN_SPI3_MISO_PY1 = 123,
	TEGRA_PIN_SPI3_MOSI_PY2 = 124,
	TEGRA_PIN_SPI3_CS0_PY3 = 125,
	TEGRA_PIN_SPI3_CS1_PY4 = 126,
	TEGRA_PIN_UART5_TX_PY5 = 127,
	TEGRA_PIN_UART5_RX_PY6 = 128,
	TEGRA_PIN_UART5_RTS_PY7 = 129,
	TEGRA_PIN_UART5_CTS_PZ0 = 130,
	TEGRA_PIN_USB_VBUS_EN0_PZ1 = 131,
	TEGRA_PIN_USB_VBUS_EN1_PZ2 = 132,
	TEGRA_PIN_SPI1_SCK_PZ3 = 133,
	TEGRA_PIN_SPI1_MISO_PZ4 = 134,
	TEGRA_PIN_SPI1_MOSI_PZ5 = 135,
	TEGRA_PIN_SPI1_CS0_PZ6 = 136,
	TEGRA_PIN_SPI1_CS1_PZ7 = 137,
	TEGRA_PIN_SPI5_SCK_PAC0 = 138,
	TEGRA_PIN_SPI5_MISO_PAC1 = 139,
	TEGRA_PIN_SPI5_MOSI_PAC2 = 140,
	TEGRA_PIN_SPI5_CS0_PAC3 = 141,
	TEGRA_PIN_SOC_GPIO57_PAC4 = 142,
	TEGRA_PIN_SOC_GPIO58_PAC5 = 143,
	TEGRA_PIN_SOC_GPIO59_PAC6 = 144,
	TEGRA_PIN_SOC_GPIO60_PAC7 = 145,
	TEGRA_PIN_SOC_GPIO45_PAD0 = 146,
	TEGRA_PIN_SOC_GPIO46_PAD1 = 147,
	TEGRA_PIN_SOC_GPIO47_PAD2 = 148,
	TEGRA_PIN_SOC_GPIO48_PAD3 = 149,
	TEGRA_PIN_UFS0_REF_CLK_PAE0 = 150,
	TEGRA_PIN_UFS0_RST_N_PAE1 = 151,
	TEGRA_PIN_PEX_L5_CLKREQ_N_PAF0 = 152,
	TEGRA_PIN_PEX_L5_RST_N_PAF1 = 153,
	TEGRA_PIN_PEX_L6_CLKREQ_N_PAF2 = 154,
	TEGRA_PIN_PEX_L6_RST_N_PAF3 = 155,
	TEGRA_PIN_PEX_L7_CLKREQ_N_PAG0 = 156,
	TEGRA_PIN_PEX_L7_RST_N_PAG1 = 157,
	TEGRA_PIN_PEX_L8_CLKREQ_N_PAG2 = 158,
	TEGRA_PIN_PEX_L8_RST_N_PAG3 = 159,
	TEGRA_PIN_PEX_L9_CLKREQ_N_PAG4 = 160,
	TEGRA_PIN_PEX_L9_RST_N_PAG5 = 161,
	TEGRA_PIN_PEX_L10_CLKREQ_N_PAG6 = 162,
	TEGRA_PIN_PEX_L10_RST_N_PAG7 = 163,
	TEGRA_PIN_EQOS_COMP = 164,
	TEGRA_PIN_QSPI_COMP = 165,
	TEGRA_PIN_SDMMC1_COMP = 166,
};

enum {
	TEGRA_PIN_DAP6_SCLK_PA0___2 = 0,
	TEGRA_PIN_DAP6_DOUT_PA1___2 = 1,
	TEGRA_PIN_DAP6_DIN_PA2___2 = 2,
	TEGRA_PIN_DAP6_FS_PA3___2 = 3,
	TEGRA_PIN_DAP4_SCLK_PA4___2 = 4,
	TEGRA_PIN_DAP4_DOUT_PA5___2 = 5,
	TEGRA_PIN_DAP4_DIN_PA6___2 = 6,
	TEGRA_PIN_DAP4_FS_PA7___2 = 7,
	TEGRA_PIN_CPU_PWR_REQ_0_PB0 = 8,
	TEGRA_PIN_CPU_PWR_REQ_1_PB1 = 9,
	TEGRA_PIN_QSPI0_SCK_PC0___2 = 10,
	TEGRA_PIN_QSPI0_CS_N_PC1___2 = 11,
	TEGRA_PIN_QSPI0_IO0_PC2___2 = 12,
	TEGRA_PIN_QSPI0_IO1_PC3___2 = 13,
	TEGRA_PIN_QSPI0_IO2_PC4___2 = 14,
	TEGRA_PIN_QSPI0_IO3_PC5___2 = 15,
	TEGRA_PIN_QSPI1_SCK_PC6___2 = 16,
	TEGRA_PIN_QSPI1_CS_N_PC7___2 = 17,
	TEGRA_PIN_QSPI1_IO0_PD0___2 = 18,
	TEGRA_PIN_QSPI1_IO1_PD1___2 = 19,
	TEGRA_PIN_QSPI1_IO2_PD2___2 = 20,
	TEGRA_PIN_QSPI1_IO3_PD3___2 = 21,
	TEGRA_PIN_EQOS_TXC_PE0___2 = 22,
	TEGRA_PIN_EQOS_TD0_PE1___2 = 23,
	TEGRA_PIN_EQOS_TD1_PE2___2 = 24,
	TEGRA_PIN_EQOS_TD2_PE3___2 = 25,
	TEGRA_PIN_EQOS_TD3_PE4___2 = 26,
	TEGRA_PIN_EQOS_TX_CTL_PE5___2 = 27,
	TEGRA_PIN_EQOS_RD0_PE6___2 = 28,
	TEGRA_PIN_EQOS_RD1_PE7___2 = 29,
	TEGRA_PIN_EQOS_RD2_PF0___2 = 30,
	TEGRA_PIN_EQOS_RD3_PF1___2 = 31,
	TEGRA_PIN_EQOS_RX_CTL_PF2___2 = 32,
	TEGRA_PIN_EQOS_RXC_PF3___2 = 33,
	TEGRA_PIN_EQOS_SMA_MDIO_PF4___2 = 34,
	TEGRA_PIN_EQOS_SMA_MDC_PF5___2 = 35,
	TEGRA_PIN_SOC_GPIO00_PG0 = 36,
	TEGRA_PIN_SOC_GPIO01_PG1 = 37,
	TEGRA_PIN_SOC_GPIO02_PG2 = 38,
	TEGRA_PIN_SOC_GPIO03_PG3 = 39,
	TEGRA_PIN_SOC_GPIO08_PG4 = 40,
	TEGRA_PIN_SOC_GPIO09_PG5 = 41,
	TEGRA_PIN_SOC_GPIO10_PG6 = 42,
	TEGRA_PIN_SOC_GPIO11_PG7 = 43,
	TEGRA_PIN_SOC_GPIO12_PH0 = 44,
	TEGRA_PIN_SOC_GPIO13_PH1 = 45,
	TEGRA_PIN_SOC_GPIO14_PH2 = 46,
	TEGRA_PIN_UART4_TX_PH3___2 = 47,
	TEGRA_PIN_UART4_RX_PH4___2 = 48,
	TEGRA_PIN_UART4_RTS_PH5___2 = 49,
	TEGRA_PIN_UART4_CTS_PH6___2 = 50,
	TEGRA_PIN_DAP2_SCLK_PH7 = 51,
	TEGRA_PIN_DAP2_DOUT_PI0 = 52,
	TEGRA_PIN_DAP2_DIN_PI1 = 53,
	TEGRA_PIN_DAP2_FS_PI2 = 54,
	TEGRA_PIN_GEN1_I2C_SCL_PI3___2 = 55,
	TEGRA_PIN_GEN1_I2C_SDA_PI4___2 = 56,
	TEGRA_PIN_SDMMC1_CLK_PJ0___2 = 57,
	TEGRA_PIN_SDMMC1_CMD_PJ1___2 = 58,
	TEGRA_PIN_SDMMC1_DAT0_PJ2___2 = 59,
	TEGRA_PIN_SDMMC1_DAT1_PJ3___2 = 60,
	TEGRA_PIN_SDMMC1_DAT2_PJ4___2 = 61,
	TEGRA_PIN_SDMMC1_DAT3_PJ5___2 = 62,
	TEGRA_PIN_PEX_L0_CLKREQ_N_PK0___2 = 63,
	TEGRA_PIN_PEX_L0_RST_N_PK1___2 = 64,
	TEGRA_PIN_PEX_L1_CLKREQ_N_PK2___2 = 65,
	TEGRA_PIN_PEX_L1_RST_N_PK3___2 = 66,
	TEGRA_PIN_PEX_L2_CLKREQ_N_PK4___2 = 67,
	TEGRA_PIN_PEX_L2_RST_N_PK5___2 = 68,
	TEGRA_PIN_PEX_L3_CLKREQ_N_PK6___2 = 69,
	TEGRA_PIN_PEX_L3_RST_N_PK7___2 = 70,
	TEGRA_PIN_PEX_L4_CLKREQ_N_PL0___2 = 71,
	TEGRA_PIN_PEX_L4_RST_N_PL1___2 = 72,
	TEGRA_PIN_PEX_WAKE_N_PL2___2 = 73,
	TEGRA_PIN_SATA_DEV_SLP_PL3 = 74,
	TEGRA_PIN_DP_AUX_CH0_HPD_PM0___2 = 75,
	TEGRA_PIN_DP_AUX_CH1_HPD_PM1___2 = 76,
	TEGRA_PIN_DP_AUX_CH2_HPD_PM2___2 = 77,
	TEGRA_PIN_DP_AUX_CH3_HPD_PM3___2 = 78,
	TEGRA_PIN_HDMI_CEC_PM4 = 79,
	TEGRA_PIN_SOC_GPIO50_PM5 = 80,
	TEGRA_PIN_SOC_GPIO51_PM6 = 81,
	TEGRA_PIN_SOC_GPIO52_PM7 = 82,
	TEGRA_PIN_SOC_GPIO53_PN0 = 83,
	TEGRA_PIN_SOC_GPIO54_PN1 = 84,
	TEGRA_PIN_SOC_GPIO55_PN2 = 85,
	TEGRA_PIN_SDMMC3_CLK_PO0 = 86,
	TEGRA_PIN_SDMMC3_CMD_PO1 = 87,
	TEGRA_PIN_SDMMC3_DAT0_PO2 = 88,
	TEGRA_PIN_SDMMC3_DAT1_PO3 = 89,
	TEGRA_PIN_SDMMC3_DAT2_PO4 = 90,
	TEGRA_PIN_SDMMC3_DAT3_PO5 = 91,
	TEGRA_PIN_EXTPERIPH1_CLK_PP0___2 = 92,
	TEGRA_PIN_EXTPERIPH2_CLK_PP1___2 = 93,
	TEGRA_PIN_CAM_I2C_SCL_PP2___2 = 94,
	TEGRA_PIN_CAM_I2C_SDA_PP3___2 = 95,
	TEGRA_PIN_SOC_GPIO04_PP4 = 96,
	TEGRA_PIN_SOC_GPIO05_PP5 = 97,
	TEGRA_PIN_SOC_GPIO06_PP6 = 98,
	TEGRA_PIN_SOC_GPIO07_PP7 = 99,
	TEGRA_PIN_SOC_GPIO20_PQ0 = 100,
	TEGRA_PIN_SOC_GPIO21_PQ1 = 101,
	TEGRA_PIN_SOC_GPIO22_PQ2 = 102,
	TEGRA_PIN_SOC_GPIO23_PQ3 = 103,
	TEGRA_PIN_SOC_GPIO40_PQ4 = 104,
	TEGRA_PIN_SOC_GPIO41_PQ5 = 105,
	TEGRA_PIN_SOC_GPIO42_PQ6 = 106,
	TEGRA_PIN_SOC_GPIO43_PQ7 = 107,
	TEGRA_PIN_SOC_GPIO44_PR0 = 108,
	TEGRA_PIN_SOC_GPIO45_PR1 = 109,
	TEGRA_PIN_UART1_TX_PR2___2 = 110,
	TEGRA_PIN_UART1_RX_PR3___2 = 111,
	TEGRA_PIN_UART1_RTS_PR4___2 = 112,
	TEGRA_PIN_UART1_CTS_PR5___2 = 113,
	TEGRA_PIN_DAP1_SCLK_PS0 = 114,
	TEGRA_PIN_DAP1_DOUT_PS1 = 115,
	TEGRA_PIN_DAP1_DIN_PS2 = 116,
	TEGRA_PIN_DAP1_FS_PS3 = 117,
	TEGRA_PIN_AUD_MCLK_PS4 = 118,
	TEGRA_PIN_SOC_GPIO30_PS5 = 119,
	TEGRA_PIN_SOC_GPIO31_PS6 = 120,
	TEGRA_PIN_SOC_GPIO32_PS7 = 121,
	TEGRA_PIN_SOC_GPIO33_PT0 = 122,
	TEGRA_PIN_DAP3_SCLK_PT1 = 123,
	TEGRA_PIN_DAP3_DOUT_PT2 = 124,
	TEGRA_PIN_DAP3_DIN_PT3 = 125,
	TEGRA_PIN_DAP3_FS_PT4 = 126,
	TEGRA_PIN_DAP5_SCLK_PT5 = 127,
	TEGRA_PIN_DAP5_DOUT_PT6 = 128,
	TEGRA_PIN_DAP5_DIN_PT7 = 129,
	TEGRA_PIN_DAP5_FS_PU0 = 130,
	TEGRA_PIN_DIRECTDC1_CLK_PV0 = 131,
	TEGRA_PIN_DIRECTDC1_IN_PV1 = 132,
	TEGRA_PIN_DIRECTDC1_OUT0_PV2 = 133,
	TEGRA_PIN_DIRECTDC1_OUT1_PV3 = 134,
	TEGRA_PIN_DIRECTDC1_OUT2_PV4 = 135,
	TEGRA_PIN_DIRECTDC1_OUT3_PV5 = 136,
	TEGRA_PIN_DIRECTDC1_OUT4_PV6 = 137,
	TEGRA_PIN_DIRECTDC1_OUT5_PV7 = 138,
	TEGRA_PIN_DIRECTDC1_OUT6_PW0 = 139,
	TEGRA_PIN_DIRECTDC1_OUT7_PW1 = 140,
	TEGRA_PIN_GPU_PWR_REQ_PX0___2 = 141,
	TEGRA_PIN_CV_PWR_REQ_PX1___2 = 142,
	TEGRA_PIN_GP_PWM2_PX2___2 = 143,
	TEGRA_PIN_GP_PWM3_PX3___2 = 144,
	TEGRA_PIN_UART2_TX_PX4___2 = 145,
	TEGRA_PIN_UART2_RX_PX5___2 = 146,
	TEGRA_PIN_UART2_RTS_PX6___2 = 147,
	TEGRA_PIN_UART2_CTS_PX7___2 = 148,
	TEGRA_PIN_SPI3_SCK_PY0___2 = 149,
	TEGRA_PIN_SPI3_MISO_PY1___2 = 150,
	TEGRA_PIN_SPI3_MOSI_PY2___2 = 151,
	TEGRA_PIN_SPI3_CS0_PY3___2 = 152,
	TEGRA_PIN_SPI3_CS1_PY4___2 = 153,
	TEGRA_PIN_UART5_TX_PY5___2 = 154,
	TEGRA_PIN_UART5_RX_PY6___2 = 155,
	TEGRA_PIN_UART5_RTS_PY7___2 = 156,
	TEGRA_PIN_UART5_CTS_PZ0___2 = 157,
	TEGRA_PIN_USB_VBUS_EN0_PZ1___2 = 158,
	TEGRA_PIN_USB_VBUS_EN1_PZ2___2 = 159,
	TEGRA_PIN_SPI1_SCK_PZ3___2 = 160,
	TEGRA_PIN_SPI1_MISO_PZ4___2 = 161,
	TEGRA_PIN_SPI1_MOSI_PZ5___2 = 162,
	TEGRA_PIN_SPI1_CS0_PZ6___2 = 163,
	TEGRA_PIN_SPI1_CS1_PZ7___2 = 164,
	TEGRA_PIN_UFS0_REF_CLK_PFF0 = 165,
	TEGRA_PIN_UFS0_RST_PFF1 = 166,
	TEGRA_PIN_PEX_L5_CLKREQ_N_PGG0 = 167,
	TEGRA_PIN_PEX_L5_RST_N_PGG1 = 168,
	TEGRA_PIN_DIRECTDC_COMP = 169,
	TEGRA_PIN_SDMMC4_CLK = 170,
	TEGRA_PIN_SDMMC4_CMD = 171,
	TEGRA_PIN_SDMMC4_DQS = 172,
	TEGRA_PIN_SDMMC4_DAT7 = 173,
	TEGRA_PIN_SDMMC4_DAT6 = 174,
	TEGRA_PIN_SDMMC4_DAT5 = 175,
	TEGRA_PIN_SDMMC4_DAT4 = 176,
	TEGRA_PIN_SDMMC4_DAT3 = 177,
	TEGRA_PIN_SDMMC4_DAT2 = 178,
	TEGRA_PIN_SDMMC4_DAT1 = 179,
	TEGRA_PIN_SDMMC4_DAT0 = 180,
	TEGRA_PIN_SDMMC1_COMP___2 = 181,
	TEGRA_PIN_SDMMC1_HV_TRIM = 182,
	TEGRA_PIN_SDMMC3_COMP = 183,
	TEGRA_PIN_SDMMC3_HV_TRIM = 184,
	TEGRA_PIN_EQOS_COMP___2 = 185,
	TEGRA_PIN_QSPI_COMP___2 = 186,
};

enum {
	TEST_NONE = 0,
	TEST_CORE = 1,
	TEST_CPUS = 2,
	TEST_PLATFORM = 3,
	TEST_DEVICES = 4,
	TEST_FREEZER = 5,
	__TEST_AFTER_LAST = 6,
};

enum {
	THRESHOLD_INDEX_0 = 0,
	THRESHOLD_INDEX_1 = 1,
	THRESHOLD_INDEX_COUNT = 2,
};

enum {
	TIM_START = 4,
	TIM_STOP = 2,
	TIM_CLR_IRQ = 1,
};

enum {
	TLS_ALERT_DESC_CLOSE_NOTIFY = 0,
	TLS_ALERT_DESC_UNEXPECTED_MESSAGE = 10,
	TLS_ALERT_DESC_BAD_RECORD_MAC = 20,
	TLS_ALERT_DESC_RECORD_OVERFLOW = 22,
	TLS_ALERT_DESC_HANDSHAKE_FAILURE = 40,
	TLS_ALERT_DESC_BAD_CERTIFICATE = 42,
	TLS_ALERT_DESC_UNSUPPORTED_CERTIFICATE = 43,
	TLS_ALERT_DESC_CERTIFICATE_REVOKED = 44,
	TLS_ALERT_DESC_CERTIFICATE_EXPIRED = 45,
	TLS_ALERT_DESC_CERTIFICATE_UNKNOWN = 46,
	TLS_ALERT_DESC_ILLEGAL_PARAMETER = 47,
	TLS_ALERT_DESC_UNKNOWN_CA = 48,
	TLS_ALERT_DESC_ACCESS_DENIED = 49,
	TLS_ALERT_DESC_DECODE_ERROR = 50,
	TLS_ALERT_DESC_DECRYPT_ERROR = 51,
	TLS_ALERT_DESC_TOO_MANY_CIDS_REQUESTED = 52,
	TLS_ALERT_DESC_PROTOCOL_VERSION = 70,
	TLS_ALERT_DESC_INSUFFICIENT_SECURITY = 71,
	TLS_ALERT_DESC_INTERNAL_ERROR = 80,
	TLS_ALERT_DESC_INAPPROPRIATE_FALLBACK = 86,
	TLS_ALERT_DESC_USER_CANCELED = 90,
	TLS_ALERT_DESC_MISSING_EXTENSION = 109,
	TLS_ALERT_DESC_UNSUPPORTED_EXTENSION = 110,
	TLS_ALERT_DESC_UNRECOGNIZED_NAME = 112,
	TLS_ALERT_DESC_BAD_CERTIFICATE_STATUS_RESPONSE = 113,
	TLS_ALERT_DESC_UNKNOWN_PSK_IDENTITY = 115,
	TLS_ALERT_DESC_CERTIFICATE_REQUIRED = 116,
	TLS_ALERT_DESC_NO_APPLICATION_PROTOCOL = 120,
};

enum {
	TLS_ALERT_LEVEL_WARNING = 1,
	TLS_ALERT_LEVEL_FATAL = 2,
};

enum {
	TLS_NO_KEYRING = 0,
	TLS_NO_PEERID = 0,
	TLS_NO_CERT = 0,
	TLS_NO_PRIVKEY = 0,
};

enum {
	TLS_RECORD_TYPE_CHANGE_CIPHER_SPEC = 20,
	TLS_RECORD_TYPE_ALERT = 21,
	TLS_RECORD_TYPE_HANDSHAKE = 22,
	TLS_RECORD_TYPE_DATA = 23,
	TLS_RECORD_TYPE_HEARTBEAT = 24,
	TLS_RECORD_TYPE_TLS12_CID = 25,
	TLS_RECORD_TYPE_ACK = 26,
};

enum {
	TOKEN_END = 0,
	TOKEN_START = 1,
	TOKEN_SLAVE_ADDR_WRITE = 2,
	TOKEN_SLAVE_ADDR_READ = 3,
	TOKEN_DATA = 4,
	TOKEN_DATA_LAST = 5,
	TOKEN_STOP = 6,
};

enum {
	TOO_MANY_CLOSE = -1,
	TOO_MANY_OPEN = -2,
	MISSING_QUOTE = -3,
};

enum {
	TPS65219_INT_LDO3_SCG = 0,
	TPS65219_INT_LDO3_OC = 1,
	TPS65219_INT_LDO3_UV = 2,
	TPS65219_INT_LDO4_SCG = 3,
	TPS65219_INT_LDO4_OC = 4,
	TPS65219_INT_LDO4_UV = 5,
	TPS65215_INT_LDO1_SCG = 6,
	TPS65215_INT_LDO1_OC = 7,
	TPS65215_INT_LDO1_UV = 8,
	TPS65215_INT_LDO2_SCG = 9,
	TPS65215_INT_LDO2_OC = 10,
	TPS65215_INT_LDO2_UV = 11,
	TPS65219_INT_LDO1_SCG = 12,
	TPS65219_INT_LDO1_OC = 13,
	TPS65219_INT_LDO1_UV = 14,
	TPS65219_INT_LDO2_SCG = 15,
	TPS65219_INT_LDO2_OC = 16,
	TPS65219_INT_LDO2_UV = 17,
	TPS65219_INT_BUCK3_SCG = 18,
	TPS65219_INT_BUCK3_OC = 19,
	TPS65219_INT_BUCK3_NEG_OC = 20,
	TPS65219_INT_BUCK3_UV = 21,
	TPS65219_INT_BUCK1_SCG = 22,
	TPS65219_INT_BUCK1_OC = 23,
	TPS65219_INT_BUCK1_NEG_OC = 24,
	TPS65219_INT_BUCK1_UV = 25,
	TPS65219_INT_BUCK2_SCG = 26,
	TPS65219_INT_BUCK2_OC = 27,
	TPS65219_INT_BUCK2_NEG_OC = 28,
	TPS65219_INT_BUCK2_UV = 29,
	TPS65219_INT_SENSOR_3_WARM = 30,
	TPS65219_INT_SENSOR_2_WARM = 31,
	TPS65219_INT_SENSOR_1_WARM = 32,
	TPS65219_INT_SENSOR_0_WARM = 33,
	TPS65219_INT_SENSOR_3_HOT = 34,
	TPS65219_INT_SENSOR_2_HOT = 35,
	TPS65219_INT_SENSOR_1_HOT = 36,
	TPS65219_INT_SENSOR_0_HOT = 37,
	TPS65219_INT_BUCK1_RV = 38,
	TPS65219_INT_BUCK2_RV = 39,
	TPS65219_INT_BUCK3_RV = 40,
	TPS65219_INT_LDO1_RV = 41,
	TPS65219_INT_LDO2_RV = 42,
	TPS65215_INT_LDO2_RV = 43,
	TPS65214_INT_LDO2_RV = 44,
	TPS65219_INT_LDO3_RV = 45,
	TPS65219_INT_LDO4_RV = 46,
	TPS65219_INT_BUCK1_RV_SD = 47,
	TPS65219_INT_BUCK2_RV_SD = 48,
	TPS65219_INT_BUCK3_RV_SD = 49,
	TPS65219_INT_LDO1_RV_SD = 50,
	TPS65214_INT_LDO1_RV_SD = 51,
	TPS65215_INT_LDO2_RV_SD = 52,
	TPS65219_INT_LDO2_RV_SD = 53,
	TPS65219_INT_LDO3_RV_SD = 54,
	TPS65219_INT_LDO4_RV_SD = 55,
	TPS65219_INT_TIMEOUT = 56,
	TPS65219_INT_PB_FALLING_EDGE_DETECT = 57,
	TPS65219_INT_PB_RISING_EDGE_DETECT = 58,
};

enum {
	TP_ERR_FILE_NOT_FOUND = 0,
	TP_ERR_NO_REGULAR_FILE = 1,
	TP_ERR_BAD_REFCNT = 2,
	TP_ERR_REFCNT_OPEN_BRACE = 3,
	TP_ERR_BAD_REFCNT_SUFFIX = 4,
	TP_ERR_BAD_UPROBE_OFFS = 5,
	TP_ERR_BAD_MAXACT_TYPE = 6,
	TP_ERR_BAD_MAXACT = 7,
	TP_ERR_MAXACT_TOO_BIG = 8,
	TP_ERR_BAD_PROBE_ADDR = 9,
	TP_ERR_NON_UNIQ_SYMBOL = 10,
	TP_ERR_BAD_RETPROBE = 11,
	TP_ERR_NO_TRACEPOINT = 12,
	TP_ERR_BAD_TP_NAME = 13,
	TP_ERR_BAD_ADDR_SUFFIX = 14,
	TP_ERR_NO_GROUP_NAME = 15,
	TP_ERR_GROUP_TOO_LONG = 16,
	TP_ERR_BAD_GROUP_NAME = 17,
	TP_ERR_NO_EVENT_NAME = 18,
	TP_ERR_EVENT_TOO_LONG = 19,
	TP_ERR_BAD_EVENT_NAME = 20,
	TP_ERR_EVENT_EXIST = 21,
	TP_ERR_RETVAL_ON_PROBE = 22,
	TP_ERR_NO_RETVAL = 23,
	TP_ERR_BAD_STACK_NUM = 24,
	TP_ERR_BAD_ARG_NUM = 25,
	TP_ERR_BAD_VAR = 26,
	TP_ERR_BAD_REG_NAME = 27,
	TP_ERR_BAD_MEM_ADDR = 28,
	TP_ERR_BAD_IMM = 29,
	TP_ERR_IMMSTR_NO_CLOSE = 30,
	TP_ERR_FILE_ON_KPROBE = 31,
	TP_ERR_BAD_FILE_OFFS = 32,
	TP_ERR_SYM_ON_UPROBE = 33,
	TP_ERR_TOO_MANY_OPS = 34,
	TP_ERR_DEREF_NEED_BRACE = 35,
	TP_ERR_BAD_DEREF_OFFS = 36,
	TP_ERR_DEREF_OPEN_BRACE = 37,
	TP_ERR_COMM_CANT_DEREF = 38,
	TP_ERR_BAD_FETCH_ARG = 39,
	TP_ERR_ARRAY_NO_CLOSE = 40,
	TP_ERR_BAD_ARRAY_SUFFIX = 41,
	TP_ERR_BAD_ARRAY_NUM = 42,
	TP_ERR_ARRAY_TOO_BIG = 43,
	TP_ERR_BAD_TYPE = 44,
	TP_ERR_BAD_STRING = 45,
	TP_ERR_BAD_SYMSTRING = 46,
	TP_ERR_BAD_BITFIELD = 47,
	TP_ERR_ARG_NAME_TOO_LONG = 48,
	TP_ERR_NO_ARG_NAME = 49,
	TP_ERR_BAD_ARG_NAME = 50,
	TP_ERR_USED_ARG_NAME = 51,
	TP_ERR_ARG_TOO_LONG = 52,
	TP_ERR_NO_ARG_BODY = 53,
	TP_ERR_BAD_INSN_BNDRY = 54,
	TP_ERR_FAIL_REG_PROBE = 55,
	TP_ERR_DIFF_PROBE_TYPE = 56,
	TP_ERR_DIFF_ARG_TYPE = 57,
	TP_ERR_SAME_PROBE = 58,
	TP_ERR_NO_EVENT_INFO = 59,
	TP_ERR_BAD_ATTACH_EVENT = 60,
	TP_ERR_BAD_ATTACH_ARG = 61,
	TP_ERR_NO_EP_FILTER = 62,
	TP_ERR_NOSUP_BTFARG = 63,
	TP_ERR_NO_BTFARG = 64,
	TP_ERR_NO_BTF_ENTRY = 65,
	TP_ERR_BAD_VAR_ARGS = 66,
	TP_ERR_NOFENTRY_ARGS = 67,
	TP_ERR_DOUBLE_ARGS = 68,
	TP_ERR_ARGS_2LONG = 69,
	TP_ERR_ARGIDX_2BIG = 70,
	TP_ERR_NO_PTR_STRCT = 71,
	TP_ERR_NOSUP_DAT_ARG = 72,
	TP_ERR_BAD_HYPHEN = 73,
	TP_ERR_NO_BTF_FIELD = 74,
	TP_ERR_BAD_BTF_TID = 75,
	TP_ERR_BAD_TYPE4STR = 76,
	TP_ERR_NEED_STRING_TYPE = 77,
	TP_ERR_TOO_MANY_ARGS = 78,
	TP_ERR_TOO_MANY_EARGS = 79,
};

enum {
	TRACEFS_EVENT_INODE = 2,
	TRACEFS_GID_PERM_SET = 4,
	TRACEFS_UID_PERM_SET = 8,
	TRACEFS_INSTANCE_INODE = 16,
};

enum {
	TRACE_ARRAY_FL_GLOBAL = 1,
	TRACE_ARRAY_FL_BOOT = 2,
	TRACE_ARRAY_FL_LAST_BOOT = 4,
	TRACE_ARRAY_FL_MOD_INIT = 8,
	TRACE_ARRAY_FL_MEMMAP = 16,
};

enum {
	TRACE_EVENT_FL_CAP_ANY = 1,
	TRACE_EVENT_FL_NO_SET_FILTER = 2,
	TRACE_EVENT_FL_IGNORE_ENABLE = 4,
	TRACE_EVENT_FL_TRACEPOINT = 8,
	TRACE_EVENT_FL_DYNAMIC = 16,
	TRACE_EVENT_FL_KPROBE = 32,
	TRACE_EVENT_FL_UPROBE = 64,
	TRACE_EVENT_FL_EPROBE = 128,
	TRACE_EVENT_FL_FPROBE = 256,
	TRACE_EVENT_FL_CUSTOM = 512,
	TRACE_EVENT_FL_TEST_STR = 1024,
};

enum {
	TRACE_EVENT_FL_CAP_ANY_BIT = 0,
	TRACE_EVENT_FL_NO_SET_FILTER_BIT = 1,
	TRACE_EVENT_FL_IGNORE_ENABLE_BIT = 2,
	TRACE_EVENT_FL_TRACEPOINT_BIT = 3,
	TRACE_EVENT_FL_DYNAMIC_BIT = 4,
	TRACE_EVENT_FL_KPROBE_BIT = 5,
	TRACE_EVENT_FL_UPROBE_BIT = 6,
	TRACE_EVENT_FL_EPROBE_BIT = 7,
	TRACE_EVENT_FL_FPROBE_BIT = 8,
	TRACE_EVENT_FL_CUSTOM_BIT = 9,
	TRACE_EVENT_FL_TEST_STR_BIT = 10,
};

enum {
	TRACE_NOP_OPT_ACCEPT = 1,
	TRACE_NOP_OPT_REFUSE = 2,
};

enum {
	TRACE_PIDS = 1,
	TRACE_NO_PIDS = 2,
};

enum {
	TRACE_SIGNAL_DELIVERED = 0,
	TRACE_SIGNAL_IGNORED = 1,
	TRACE_SIGNAL_ALREADY_PENDING = 2,
	TRACE_SIGNAL_OVERFLOW_FAIL = 3,
	TRACE_SIGNAL_LOSE_INFO = 4,
};

enum {
	TRANS_MODE_PIO = 0,
	TRANS_MODE_IDMAC = 1,
	TRANS_MODE_EDMAC = 2,
};

enum {
	TRANS_TX_FAIL_BASE___2 = 0,
	TRANS_RX_FAIL_BASE___2 = 32,
	DMA_TX_ERR_BASE___2 = 64,
	SIPC_RX_ERR_BASE = 80,
	DMA_RX_ERR_BASE___2 = 96,
	TRANS_TX_OPEN_FAIL_WITH_IT_NEXUS_LOSS = 0,
	TRANS_TX_ERR_PHY_NOT_ENABLE = 1,
	TRANS_TX_OPEN_CNX_ERR_WRONG_DESTINATION = 2,
	TRANS_TX_OPEN_CNX_ERR_ZONE_VIOLATION = 3,
	TRANS_TX_OPEN_CNX_ERR_BY_OTHER = 4,
	RESERVED0 = 5,
	TRANS_TX_OPEN_CNX_ERR_AIP_TIMEOUT = 6,
	TRANS_TX_OPEN_CNX_ERR_STP_RESOURCES_BUSY = 7,
	TRANS_TX_OPEN_CNX_ERR_PROTOCOL_NOT_SUPPORTED = 8,
	TRANS_TX_OPEN_CNX_ERR_CONNECTION_RATE_NOT_SUPPORTED = 9,
	TRANS_TX_OPEN_CNX_ERR_BAD_DESTINATION = 10,
	TRANS_TX_OPEN_CNX_ERR_BREAK_RCVD = 11,
	TRANS_TX_OPEN_CNX_ERR_LOW_PHY_POWER = 12,
	TRANS_TX_OPEN_CNX_ERR_PATHWAY_BLOCKED = 13,
	TRANS_TX_OPEN_CNX_ERR_OPEN_TIMEOUT = 14,
	TRANS_TX_OPEN_CNX_ERR_NO_DESTINATION = 15,
	TRANS_TX_OPEN_RETRY_ERR_THRESHOLD_REACHED = 16,
	TRANS_TX_ERR_FRAME_TXED = 17,
	TRANS_TX_ERR_WITH_BREAK_TIMEOUT = 18,
	TRANS_TX_ERR_WITH_BREAK_REQUEST = 19,
	TRANS_TX_ERR_WITH_BREAK_RECEVIED = 20,
	TRANS_TX_ERR_WITH_CLOSE_TIMEOUT = 21,
	TRANS_TX_ERR_WITH_CLOSE_NORMAL = 22,
	TRANS_TX_ERR_WITH_CLOSE_PHYDISALE = 23,
	TRANS_TX_ERR_WITH_CLOSE_DWS_TIMEOUT = 24,
	TRANS_TX_ERR_WITH_CLOSE_COMINIT = 25,
	TRANS_TX_ERR_WITH_NAK_RECEVIED = 26,
	TRANS_TX_ERR_WITH_ACK_NAK_TIMEOUT = 27,
	TRANS_TX_ERR_WITH_CREDIT_TIMEOUT = 28,
	TRANS_TX_ERR_WITH_IPTT_CONFLICT = 29,
	TRANS_TX_ERR_WITH_OPEN_BY_DES_OR_OTHERS = 30,
	TRANS_TX_ERR_WITH_WAIT_RECV_TIMEOUT = 31,
	TRANS_RX_ERR_WITH_RXFRAME_CRC_ERR = 32,
	TRANS_RX_ERR_WITH_RXFIS_8B10B_DISP_ERR = 33,
	TRANS_RX_ERR_WITH_RXFRAME_HAVE_ERRPRM = 34,
	TRANS_RX_ERR_WITH_RXFIS_DECODE_ERROR = 35,
	TRANS_RX_ERR_WITH_RXFIS_CRC_ERR = 36,
	TRANS_RX_ERR_WITH_RXFRAME_LENGTH_OVERRUN = 37,
	TRANS_RX_ERR_WITH_RXFIS_RX_SYNCP = 38,
	TRANS_RX_ERR_WITH_LINK_BUF_OVERRUN = 39,
	TRANS_RX_ERR_WITH_BREAK_TIMEOUT = 40,
	TRANS_RX_ERR_WITH_BREAK_REQUEST = 41,
	TRANS_RX_ERR_WITH_BREAK_RECEVIED = 42,
	RESERVED1 = 43,
	TRANS_RX_ERR_WITH_CLOSE_NORMAL = 44,
	TRANS_RX_ERR_WITH_CLOSE_PHY_DISABLE = 45,
	TRANS_RX_ERR_WITH_CLOSE_DWS_TIMEOUT = 46,
	TRANS_RX_ERR_WITH_CLOSE_COMINIT = 47,
	TRANS_RX_ERR_WITH_DATA_LEN0 = 48,
	TRANS_RX_ERR_WITH_BAD_HASH = 49,
	TRANS_RX_XRDY_WLEN_ZERO_ERR = 50,
	TRANS_RX_SSP_FRM_LEN_ERR = 51,
	RESERVED2 = 52,
	RESERVED3 = 53,
	RESERVED4 = 54,
	RESERVED5 = 55,
	TRANS_RX_ERR_WITH_BAD_FRM_TYPE = 56,
	TRANS_RX_SMP_FRM_LEN_ERR = 57,
	TRANS_RX_SMP_RESP_TIMEOUT_ERR___2 = 58,
	RESERVED6 = 59,
	RESERVED7 = 60,
	RESERVED8 = 61,
	RESERVED9 = 62,
	TRANS_RX_R_ERR = 63,
	DMA_TX_DIF_CRC_ERR___2 = 64,
	DMA_TX_DIF_APP_ERR___2 = 65,
	DMA_TX_DIF_RPP_ERR___2 = 66,
	DMA_TX_DATA_SGL_OVERFLOW = 67,
	DMA_TX_DIF_SGL_OVERFLOW = 68,
	DMA_TX_UNEXP_XFER_ERR = 69,
	DMA_TX_UNEXP_RETRANS_ERR = 70,
	DMA_TX_XFER_LEN_OVERFLOW = 71,
	DMA_TX_XFER_OFFSET_ERR = 72,
	DMA_TX_RAM_ECC_ERR = 73,
	DMA_TX_DIF_LEN_ALIGN_ERR = 74,
	DMA_TX_MAX_ERR_CODE = 75,
	SIPC_RX_FIS_STATUS_ERR_BIT_VLD = 80,
	SIPC_RX_PIO_WRSETUP_STATUS_DRQ_ERR = 81,
	SIPC_RX_FIS_STATUS_BSY_BIT_ERR = 82,
	SIPC_RX_WRSETUP_LEN_ODD_ERR = 83,
	SIPC_RX_WRSETUP_LEN_ZERO_ERR = 84,
	SIPC_RX_WRDATA_LEN_NOT_MATCH_ERR = 85,
	SIPC_RX_NCQ_WRSETUP_OFFSET_ERR = 86,
	SIPC_RX_NCQ_WRSETUP_AUTO_ACTIVE_ERR = 87,
	SIPC_RX_SATA_UNEXP_FIS_ERR = 88,
	SIPC_RX_WRSETUP_ESTATUS_ERR = 89,
	SIPC_RX_DATA_UNDERFLOW_ERR = 90,
	SIPC_RX_MAX_ERR_CODE = 91,
	DMA_RX_DIF_CRC_ERR___2 = 96,
	DMA_RX_DIF_APP_ERR___2 = 97,
	DMA_RX_DIF_RPP_ERR___2 = 98,
	DMA_RX_DATA_SGL_OVERFLOW = 99,
	DMA_RX_DIF_SGL_OVERFLOW = 100,
	DMA_RX_DATA_LEN_OVERFLOW = 101,
	DMA_RX_DATA_LEN_UNDERFLOW = 102,
	DMA_RX_DATA_OFFSET_ERR___2 = 103,
	RESERVED10 = 104,
	DMA_RX_SATA_FRAME_TYPE_ERR = 105,
	DMA_RX_RESP_BUF_OVERFLOW = 106,
	DMA_RX_UNEXP_RETRANS_RESP_ERR___2 = 107,
	DMA_RX_UNEXP_NORM_RESP_ERR = 108,
	DMA_RX_UNEXP_RDFRAME_ERR = 109,
	DMA_RX_PIO_DATA_LEN_ERR = 110,
	DMA_RX_RDSETUP_STATUS_ERR = 111,
	DMA_RX_RDSETUP_STATUS_DRQ_ERR = 112,
	DMA_RX_RDSETUP_STATUS_BSY_ERR = 113,
	DMA_RX_RDSETUP_LEN_ODD_ERR = 114,
	DMA_RX_RDSETUP_LEN_ZERO_ERR = 115,
	DMA_RX_RDSETUP_LEN_OVER_ERR = 116,
	DMA_RX_RDSETUP_OFFSET_ERR = 117,
	DMA_RX_RDSETUP_ACTIVE_ERR = 118,
	DMA_RX_RDSETUP_ESTATUS_ERR = 119,
	DMA_RX_RAM_ECC_ERR = 120,
	DMA_RX_UNKNOWN_FRM_ERR = 121,
	DMA_RX_MAX_ERR_CODE = 122,
};

enum {
	TST_FRC_DPERR_MR = 128,
	TST_FRC_DPERR_MW = 64,
	TST_FRC_DPERR_TR = 32,
	TST_FRC_DPERR_TW = 16,
	TST_FRC_APERR_M = 8,
	TST_FRC_APERR_T = 4,
	TST_CFG_WRITE_ON = 2,
	TST_CFG_WRITE_OFF = 1,
};

enum {
	TXA_ENA_FSYNC = 128,
	TXA_DIS_FSYNC = 64,
	TXA_ENA_ALLOC = 32,
	TXA_DIS_ALLOC = 16,
	TXA_START_RC = 8,
	TXA_STOP_RC = 4,
	TXA_ENA_ARB = 2,
	TXA_DIS_ARB = 1,
};

enum {
	TXA_ITI_INI = 512,
	TXA_ITI_VAL = 516,
	TXA_LIM_INI = 520,
	TXA_LIM_VAL = 524,
	TXA_CTRL = 528,
	TXA_TEST = 529,
	TXA_STAT = 530,
	RSS_KEY = 544,
	RSS_CFG = 584,
};

enum {
	TX_DYN_WM_ENA = 3,
};

enum {
	TX_GMF_EA = 3392,
	TX_GMF_AE_THR = 3396,
	TX_GMF_CTRL_T = 3400,
	TX_GMF_WP = 3424,
	TX_GMF_WSP = 3428,
	TX_GMF_WLEV = 3432,
	TX_GMF_RP = 3440,
	TX_GMF_RSTP = 3444,
	TX_GMF_RLEV = 3448,
	ECU_AE_THR = 112,
	ECU_TXFF_LEV = 416,
	ECU_JUMBO_WM = 128,
};

enum {
	TX_STFW_DIS = -2147483648,
	TX_STFW_ENA = 1073741824,
	TX_VLAN_TAG_ON = 33554432,
	TX_VLAN_TAG_OFF = 16777216,
	TX_PCI_JUM_ENA = 8388608,
	TX_PCI_JUM_DIS = 4194304,
	GMF_WSP_TST_ON = 262144,
	GMF_WSP_TST_OFF = 131072,
	GMF_WSP_STEP = 65536,
	GMF_CLI_TX_FU = 64,
	GMF_CLI_TX_FC = 32,
	GMF_CLI_TX_PE = 16,
};

enum {
	UARTDM_1P1 = 1,
	UARTDM_1P2 = 2,
	UARTDM_1P3 = 3,
	UARTDM_1P4 = 4,
};

enum {
	UART_IRQ_SUM = 0,
	UART_RX_IRQ = 0,
	UART_TX_IRQ = 1,
	UART_IRQ_COUNT = 2,
};

enum {
	UDPTCP = 1,
	CALSUM = 2,
	WR_SUM = 4,
	INIT_SUM = 8,
	LOCK_SUM = 16,
	INS_VLAN = 32,
	EOP = 128,
};

enum {
	UDP_BPF_IPV4 = 0,
	UDP_BPF_IPV6 = 1,
	UDP_BPF_NUM_PROTS = 2,
};

enum {
	UDP_FLAGS_CORK = 0,
	UDP_FLAGS_NO_CHECK6_TX = 1,
	UDP_FLAGS_NO_CHECK6_RX = 2,
	UDP_FLAGS_GRO_ENABLED = 3,
	UDP_FLAGS_ACCEPT_FRAGLIST = 4,
	UDP_FLAGS_ACCEPT_L4 = 5,
	UDP_FLAGS_ENCAP_ENABLED = 6,
	UDP_FLAGS_UDPLITE_SEND_CC = 7,
	UDP_FLAGS_UDPLITE_RECV_CC = 8,
};

enum {
	UDP_MIB_NUM = 0,
	UDP_MIB_INDATAGRAMS = 1,
	UDP_MIB_NOPORTS = 2,
	UDP_MIB_INERRORS = 3,
	UDP_MIB_OUTDATAGRAMS = 4,
	UDP_MIB_RCVBUFERRORS = 5,
	UDP_MIB_SNDBUFERRORS = 6,
	UDP_MIB_CSUMERRORS = 7,
	UDP_MIB_IGNOREDMULTI = 8,
	UDP_MIB_MEMERRORS = 9,
	__UDP_MIB_MAX = 10,
};

enum {
	UFSHCD_EH_IN_PROGRESS = 1,
};

enum {
	UFSHCD_MAX_CHANNEL = 0,
	UFSHCD_MAX_ID = 1,
};

enum {
	UFSHCD_NANO_AMP = 0,
	UFSHCD_MICRO_AMP = 1,
	UFSHCD_MILI_AMP = 2,
	UFSHCD_AMP = 3,
};

enum {
	UFSHCD_POLL_FROM_INTERRUPT_CONTEXT = -1,
};

enum {
	UFSHCD_UIC_DL_PA_INIT_ERROR = 1,
	UFSHCD_UIC_DL_NAC_RECEIVED_ERROR = 2,
	UFSHCD_UIC_DL_TCx_REPLAY_ERROR = 4,
	UFSHCD_UIC_NL_ERROR = 8,
	UFSHCD_UIC_TL_ERROR = 16,
	UFSHCD_UIC_DME_ERROR = 32,
	UFSHCD_UIC_PA_GENERIC_ERROR = 64,
};

enum {
	UFS_ABORT_TASK = 1,
	UFS_ABORT_TASK_SET = 2,
	UFS_CLEAR_TASK_SET = 4,
	UFS_LOGICAL_RESET = 8,
	UFS_QUERY_TASK = 128,
	UFS_QUERY_TASK_SET = 129,
};

enum {
	UFS_DEV_HIGH_TEMP_NOTIF = 16,
	UFS_DEV_LOW_TEMP_NOTIF = 32,
	UFS_DEV_EXT_TEMP_NOTIF = 64,
	UFS_DEV_HPB_SUPPORT = 128,
	UFS_DEV_WRITE_BOOSTER_SUP = 256,
	UFS_DEV_LVL_EXCEPTION_SUP = 4096,
};

enum {
	UFS_DEV_WB_BUF_RESIZE = 1,
};

enum {
	UFS_REG_OCPTHRTL = 192,
	UFS_REG_OOCPR = 196,
	UFS_REG_CDACFG = 208,
	UFS_REG_CDATX1 = 212,
	UFS_REG_CDATX2 = 216,
	UFS_REG_CDARX1 = 220,
	UFS_REG_CDARX2 = 224,
	UFS_REG_CDASTA = 228,
	UFS_REG_LBMCFG = 240,
	UFS_REG_LBMSTA = 244,
	UFS_REG_UFSMODE = 248,
	UFS_REG_HCLKDIV = 252,
};

enum {
	UFS_UPIU_REPORT_LUNS_WLUN = 129,
	UFS_UPIU_UFS_DEVICE_WLUN = 208,
	UFS_UPIU_BOOT_WLUN = 176,
	UFS_UPIU_RPMB_WLUN = 196,
};

enum {
	UIC_CMD_TIMEOUT_DEFAULT = 500,
	UIC_CMD_TIMEOUT_MAX = 5000,
};

enum {
	UNAME26 = 131072,
	ADDR_NO_RANDOMIZE = 262144,
	FDPIC_FUNCPTRS = 524288,
	MMAP_PAGE_ZERO = 1048576,
	ADDR_COMPAT_LAYOUT = 2097152,
	READ_IMPLIES_EXEC = 4194304,
	ADDR_LIMIT_32BIT = 8388608,
	SHORT_INODE = 16777216,
	WHOLE_SECONDS = 33554432,
	STICKY_TIMEOUTS = 67108864,
	ADDR_LIMIT_3GB = 134217728,
};

enum {
	UNIPRO_L1_5 = 0,
	UNIPRO_L2 = 1,
	UNIPRO_L3 = 2,
	UNIPRO_L4 = 3,
	UNIPRO_DME = 4,
};

enum {
	UPIU_CMD_FLAGS_NONE = 0,
	UPIU_CMD_FLAGS_CP = 4,
	UPIU_CMD_FLAGS_WRITE = 32,
	UPIU_CMD_FLAGS_READ = 64,
};

enum {
	UPIU_COMMAND_SET_TYPE_SCSI = 0,
	UPIU_COMMAND_SET_TYPE_UFS = 1,
	UPIU_COMMAND_SET_TYPE_QUERY = 2,
};

enum {
	UPIU_QUERY_FUNC_STANDARD_READ_REQUEST = 1,
	UPIU_QUERY_FUNC_STANDARD_WRITE_REQUEST = 129,
};

enum {
	UPIU_RSP_FLAG_UNDERFLOW = 32,
	UPIU_RSP_FLAG_OVERFLOW = 64,
};

enum {
	UPIU_TASK_MANAGEMENT_FUNC_COMPL = 0,
	UPIU_TASK_MANAGEMENT_FUNC_NOT_SUPPORTED = 4,
	UPIU_TASK_MANAGEMENT_FUNC_SUCCEEDED = 8,
	UPIU_TASK_MANAGEMENT_FUNC_FAILED = 5,
	UPIU_INCORRECT_LOGICAL_UNIT_NO = 9,
};

enum {
	USB_CTRL_SETUP_SCB1_EN_SELECTOR = 0,
	USB_CTRL_SETUP_SCB2_EN_SELECTOR = 1,
	USB_CTRL_SETUP_SS_EHCI64BIT_EN_SELECTOR = 2,
	USB_CTRL_SETUP_STRAP_IPP_SEL_SELECTOR = 3,
	USB_CTRL_SETUP_OC3_DISABLE_PORT0_SELECTOR = 4,
	USB_CTRL_SETUP_OC3_DISABLE_PORT1_SELECTOR = 5,
	USB_CTRL_SETUP_OC3_DISABLE_SELECTOR = 6,
	USB_CTRL_PLL_CTL_PLL_IDDQ_PWRDN_SELECTOR = 7,
	USB_CTRL_USB_PM_BDC_SOFT_RESETB_SELECTOR = 8,
	USB_CTRL_USB_PM_XHC_SOFT_RESETB_SELECTOR = 9,
	USB_CTRL_USB_PM_USB_PWRDN_SELECTOR = 10,
	USB_CTRL_USB30_CTL1_XHC_SOFT_RESETB_SELECTOR = 11,
	USB_CTRL_USB30_CTL1_USB3_IOC_SELECTOR = 12,
	USB_CTRL_USB30_CTL1_USB3_IPP_SELECTOR = 13,
	USB_CTRL_USB_DEVICE_CTL1_PORT_MODE_SELECTOR = 14,
	USB_CTRL_USB_PM_SOFT_RESET_SELECTOR = 15,
	USB_CTRL_SETUP_CC_DRD_MODE_ENABLE_SELECTOR = 16,
	USB_CTRL_SETUP_STRAP_CC_DRD_MODE_ENABLE_SEL_SELECTOR = 17,
	USB_CTRL_USB_PM_USB20_HC_RESETB_SELECTOR = 18,
	USB_CTRL_SETUP_ENDIAN_SELECTOR = 19,
	USB_CTRL_SELECTOR_COUNT = 20,
};

enum {
	US_FL_SINGLE_LUN = 1,
	US_FL_NEED_OVERRIDE = 2,
	US_FL_SCM_MULT_TARG = 4,
	US_FL_FIX_INQUIRY = 8,
	US_FL_FIX_CAPACITY = 16,
	US_FL_IGNORE_RESIDUE = 32,
	US_FL_BULK32 = 64,
	US_FL_NOT_LOCKABLE = 128,
	US_FL_GO_SLOW = 256,
	US_FL_NO_WP_DETECT = 512,
	US_FL_MAX_SECTORS_64 = 1024,
	US_FL_IGNORE_DEVICE = 2048,
	US_FL_CAPACITY_HEURISTICS = 4096,
	US_FL_MAX_SECTORS_MIN = 8192,
	US_FL_BULK_IGNORE_TAG = 16384,
	US_FL_SANE_SENSE = 32768,
	US_FL_CAPACITY_OK = 65536,
	US_FL_BAD_SENSE = 131072,
	US_FL_NO_READ_DISC_INFO = 262144,
	US_FL_NO_READ_CAPACITY_16 = 524288,
	US_FL_INITIAL_READ10 = 1048576,
	US_FL_WRITE_CACHE = 2097152,
	US_FL_NEEDS_CAP16 = 4194304,
	US_FL_IGNORE_UAS = 8388608,
	US_FL_BROKEN_FUA = 16777216,
	US_FL_NO_ATA_1X = 33554432,
	US_FL_NO_REPORT_OPCODES = 67108864,
	US_FL_MAX_SECTORS_240 = 134217728,
	US_FL_NO_REPORT_LUNS = 268435456,
	US_FL_ALWAYS_SYNC = 536870912,
	US_FL_NO_SAME = 1073741824,
	US_FL_SENSE_AFTER_SYNC = 2147483648,
};

enum {
	UTP_CMD_TYPE_UFS_STORAGE = 1,
};

enum {
	VFIO_DEVICE_NUM_STATES = 8,
};

enum {
	VFIO_PCI_BAR0_REGION_INDEX = 0,
	VFIO_PCI_BAR1_REGION_INDEX = 1,
	VFIO_PCI_BAR2_REGION_INDEX = 2,
	VFIO_PCI_BAR3_REGION_INDEX = 3,
	VFIO_PCI_BAR4_REGION_INDEX = 4,
	VFIO_PCI_BAR5_REGION_INDEX = 5,
	VFIO_PCI_ROM_REGION_INDEX = 6,
	VFIO_PCI_CONFIG_REGION_INDEX = 7,
	VFIO_PCI_VGA_REGION_INDEX = 8,
	VFIO_PCI_NUM_REGIONS = 9,
};

enum {
	VFIO_PCI_INTX_IRQ_INDEX = 0,
	VFIO_PCI_MSI_IRQ_INDEX = 1,
	VFIO_PCI_MSIX_IRQ_INDEX = 2,
	VFIO_PCI_ERR_IRQ_INDEX = 3,
	VFIO_PCI_REQ_IRQ_INDEX = 4,
	VFIO_PCI_NUM_IRQS = 5,
};

enum {
	VP_MSIX_CONFIG_VECTOR = 0,
	VP_MSIX_VQ_VECTOR = 1,
};

enum {
	V_ARMADA_7K = 1,
	V_ARMADA_8K_CPM = 2,
	V_ARMADA_8K_CPS = 4,
	V_CP115_STANDALONE = 8,
	V_ARMADA_7K_8K_CPM = 3,
	V_ARMADA_7K_8K_CPS = 5,
};

enum {
	WALK_TRAILING = 1,
	WALK_MORE = 2,
	WALK_NOFOLLOW = 4,
};

enum {
	WB_BUF_MODE_LU_DEDICATED = 0,
	WB_BUF_MODE_SHARED = 1,
};

enum {
	WEST___4 = 0,
	SOUTH___6 = 1,
	NORTH___5 = 2,
};

enum {
	WOL_CTL_LINK_CHG_OCC = 32768,
	WOL_CTL_MAGIC_PKT_OCC = 16384,
	WOL_CTL_PATTERN_OCC = 8192,
	WOL_CTL_CLEAR_RESULT = 4096,
	WOL_CTL_ENA_PME_ON_LINK_CHG = 2048,
	WOL_CTL_DIS_PME_ON_LINK_CHG = 1024,
	WOL_CTL_ENA_PME_ON_MAGIC_PKT = 512,
	WOL_CTL_DIS_PME_ON_MAGIC_PKT = 256,
	WOL_CTL_ENA_PME_ON_PATTERN = 128,
	WOL_CTL_DIS_PME_ON_PATTERN = 64,
	WOL_CTL_ENA_LINK_CHG_UNIT = 32,
	WOL_CTL_DIS_LINK_CHG_UNIT = 16,
	WOL_CTL_ENA_MAGIC_PKT_UNIT = 8,
	WOL_CTL_DIS_MAGIC_PKT_UNIT = 4,
	WOL_CTL_ENA_PATTERN_UNIT = 2,
	WOL_CTL_DIS_PATTERN_UNIT = 1,
};

enum {
	XA_CHECK_SCHED = 4096,
};

enum {
	XDP_ATTACHED_NONE = 0,
	XDP_ATTACHED_DRV = 1,
	XDP_ATTACHED_SKB = 2,
	XDP_ATTACHED_HW = 3,
	XDP_ATTACHED_MULTI = 4,
};

enum {
	XFRM_LOOKUP_ICMP = 1,
	XFRM_LOOKUP_QUEUE = 2,
	XFRM_LOOKUP_KEEP_DST_REF = 4,
};

enum {
	XFRM_MSG_BASE = 16,
	XFRM_MSG_NEWSA = 16,
	XFRM_MSG_DELSA = 17,
	XFRM_MSG_GETSA = 18,
	XFRM_MSG_NEWPOLICY = 19,
	XFRM_MSG_DELPOLICY = 20,
	XFRM_MSG_GETPOLICY = 21,
	XFRM_MSG_ALLOCSPI = 22,
	XFRM_MSG_ACQUIRE = 23,
	XFRM_MSG_EXPIRE = 24,
	XFRM_MSG_UPDPOLICY = 25,
	XFRM_MSG_UPDSA = 26,
	XFRM_MSG_POLEXPIRE = 27,
	XFRM_MSG_FLUSHSA = 28,
	XFRM_MSG_FLUSHPOLICY = 29,
	XFRM_MSG_NEWAE = 30,
	XFRM_MSG_GETAE = 31,
	XFRM_MSG_REPORT = 32,
	XFRM_MSG_MIGRATE = 33,
	XFRM_MSG_NEWSADINFO = 34,
	XFRM_MSG_GETSADINFO = 35,
	XFRM_MSG_NEWSPDINFO = 36,
	XFRM_MSG_GETSPDINFO = 37,
	XFRM_MSG_MAPPING = 38,
	XFRM_MSG_SETDEFAULT = 39,
	XFRM_MSG_GETDEFAULT = 40,
	__XFRM_MSG_MAX = 41,
};

enum {
	XFRM_POLICY_IN = 0,
	XFRM_POLICY_OUT = 1,
	XFRM_POLICY_FWD = 2,
	XFRM_POLICY_MASK = 3,
	XFRM_POLICY_MAX = 3,
};

enum {
	XFRM_POLICY_TYPE_MAIN = 0,
	XFRM_POLICY_TYPE_SUB = 1,
	XFRM_POLICY_TYPE_MAX = 2,
	XFRM_POLICY_TYPE_ANY = 255,
};

enum {
	XPT_BUSY = 0,
	XPT_CONN = 1,
	XPT_CLOSE = 2,
	XPT_DATA = 3,
	XPT_TEMP = 4,
	XPT_DEAD = 5,
	XPT_CHNGBUF = 6,
	XPT_DEFERRED = 7,
	XPT_OLD = 8,
	XPT_LISTENER = 9,
	XPT_CACHE_AUTH = 10,
	XPT_LOCAL = 11,
	XPT_KILL_TEMP = 12,
	XPT_CONG_CTRL = 13,
	XPT_HANDSHAKE = 14,
	XPT_TLS_SESSION = 15,
	XPT_PEER_AUTH = 16,
	XPT_PEER_VALID = 17,
};

enum {
	Y2_ASF_OS_PRES = 16,
	Y2_ASF_RESET = 8,
	Y2_ASF_RUNNING = 4,
	Y2_ASF_CLR_HSTI = 2,
	Y2_ASF_IRQ = 1,
	Y2_ASF_UC_STATE = 12,
	Y2_ASF_CLK_HALT = 0,
};

enum {
	Y2_B8_PREF_REGS = 1104,
	PREF_UNIT_CTRL = 0,
	PREF_UNIT_LAST_IDX = 4,
	PREF_UNIT_ADDR_LO = 8,
	PREF_UNIT_ADDR_HI = 12,
	PREF_UNIT_GET_IDX = 16,
	PREF_UNIT_PUT_IDX = 20,
	PREF_UNIT_FIFO_WP = 32,
	PREF_UNIT_FIFO_RP = 36,
	PREF_UNIT_FIFO_WM = 40,
	PREF_UNIT_FIFO_LEV = 44,
	PREF_UNIT_MASK_IDX = 4095,
};

enum {
	Y2_CLK_DIV_VAL_MSK = 16711680,
	Y2_CLK_DIV_VAL2_MSK = 14680064,
	Y2_CLK_SELECT2_MSK = 2031616,
	Y2_CLK_DIV_ENA = 2,
	Y2_CLK_DIV_DIS = 1,
};

enum {
	Y2_IS_HW_ERR = -2147483648,
	Y2_IS_STAT_BMU = 1073741824,
	Y2_IS_ASF = 536870912,
	Y2_IS_CPU_TO = 268435456,
	Y2_IS_POLL_CHK = 134217728,
	Y2_IS_TWSI_RDY = 67108864,
	Y2_IS_IRQ_SW = 33554432,
	Y2_IS_TIMINT = 16777216,
	Y2_IS_IRQ_PHY2 = 4096,
	Y2_IS_IRQ_MAC2 = 2048,
	Y2_IS_CHK_RX2 = 1024,
	Y2_IS_CHK_TXS2 = 512,
	Y2_IS_CHK_TXA2 = 256,
	Y2_IS_PSM_ACK = 128,
	Y2_IS_PTP_TIST = 64,
	Y2_IS_PHY_QLNK = 32,
	Y2_IS_IRQ_PHY1 = 16,
	Y2_IS_IRQ_MAC1 = 8,
	Y2_IS_CHK_RX1 = 4,
	Y2_IS_CHK_TXS1 = 2,
	Y2_IS_CHK_TXA1 = 1,
	Y2_IS_BASE = -1073741824,
	Y2_IS_PORT_1 = 29,
	Y2_IS_PORT_2 = 7424,
	Y2_IS_ERROR = -2147480307,
};

enum {
	Y2_IS_TIST_OV = 536870912,
	Y2_IS_SENSOR = 268435456,
	Y2_IS_MST_ERR = 134217728,
	Y2_IS_IRQ_STAT = 67108864,
	Y2_IS_PCI_EXP = 33554432,
	Y2_IS_PCI_NEXP = 16777216,
	Y2_IS_PAR_RD2 = 8192,
	Y2_IS_PAR_WR2 = 4096,
	Y2_IS_PAR_MAC2 = 2048,
	Y2_IS_PAR_RX2 = 1024,
	Y2_IS_TCP_TXS2 = 512,
	Y2_IS_TCP_TXA2 = 256,
	Y2_IS_PAR_RD1 = 32,
	Y2_IS_PAR_WR1 = 16,
	Y2_IS_PAR_MAC1 = 8,
	Y2_IS_PAR_RX1 = 4,
	Y2_IS_TCP_TXS1 = 2,
	Y2_IS_TCP_TXA1 = 1,
	Y2_HWE_L1_MASK = 63,
	Y2_HWE_L2_MASK = 16128,
	Y2_HWE_ALL_MASK = 738213695,
};

enum {
	Y2_STATUS_LNK2_INAC = 128,
	Y2_CLK_GAT_LNK2_DIS = 64,
	Y2_COR_CLK_LNK2_DIS = 32,
	Y2_PCI_CLK_LNK2_DIS = 16,
	Y2_STATUS_LNK1_INAC = 8,
	Y2_CLK_GAT_LNK1_DIS = 4,
	Y2_COR_CLK_LNK1_DIS = 2,
	Y2_PCI_CLK_LNK1_DIS = 1,
};

enum {
	Y2_VMAIN_AVAIL = 131072,
	Y2_VAUX_AVAIL = 65536,
	Y2_HW_WOL_ON = 32768,
	Y2_HW_WOL_OFF = 16384,
	Y2_ASF_ENABLE = 8192,
	Y2_ASF_DISABLE = 4096,
	Y2_CLK_RUN_ENA = 2048,
	Y2_CLK_RUN_DIS = 1024,
	Y2_LED_STAT_ON = 512,
	Y2_LED_STAT_OFF = 256,
	CS_ST_SW_IRQ = 128,
	CS_CL_SW_IRQ = 64,
	CS_STOP_DONE = 32,
	CS_STOP_MAST = 16,
	CS_MRST_CLR = 8,
	CS_MRST_SET = 4,
	CS_RST_CLR = 2,
	CS_RST_SET = 1,
};

enum {
	ZONELIST_FALLBACK = 0,
	ZONELIST_NOFALLBACK = 1,
	MAX_ZONELISTS = 2,
};

enum {
	_DQUOT_USAGE_ENABLED = 0,
	_DQUOT_LIMITS_ENABLED = 1,
	_DQUOT_SUSPENDED = 2,
	_DQUOT_STATE_FLAGS = 3,
};

enum {
	_IRQ_DEFAULT_INIT_FLAGS = 0,
	_IRQ_PER_CPU = 512,
	_IRQ_LEVEL = 256,
	_IRQ_NOPROBE = 1024,
	_IRQ_NOREQUEST = 2048,
	_IRQ_NOTHREAD = 65536,
	_IRQ_NOAUTOEN = 4096,
	_IRQ_NO_BALANCING = 8192,
	_IRQ_NESTED_THREAD = 32768,
	_IRQ_PER_CPU_DEVID = 131072,
	_IRQ_IS_POLLED = 262144,
	_IRQ_DISABLE_UNLAZY = 524288,
	_IRQ_HIDDEN = 1048576,
	_IRQ_NO_DEBUG = 2097152,
	_IRQF_MODIFY_MASK = 2080527,
};

enum {
	__MVNETA_DOWN = 0,
};

enum {
	__ND_OPT_PREFIX_INFO_END = 0,
	ND_OPT_SOURCE_LL_ADDR = 1,
	ND_OPT_TARGET_LL_ADDR = 2,
	ND_OPT_PREFIX_INFO = 3,
	ND_OPT_REDIRECT_HDR = 4,
	ND_OPT_MTU = 5,
	ND_OPT_NONCE = 14,
	__ND_OPT_ARRAY_MAX = 15,
	ND_OPT_ROUTE_INFO = 24,
	ND_OPT_RDNSS = 25,
	ND_OPT_DNSSL = 31,
	ND_OPT_6CO = 34,
	ND_OPT_CAPTIVE_PORTAL = 37,
	ND_OPT_PREF64 = 38,
	__ND_OPT_MAX = 39,
};

enum {
	__PERCPU_REF_ATOMIC = 1,
	__PERCPU_REF_DEAD = 2,
	__PERCPU_REF_ATOMIC_DEAD = 3,
	__PERCPU_REF_FLAG_BITS = 2,
};

enum {
	__SCHED_FEAT_PLACE_LAG = 0,
	__SCHED_FEAT_PLACE_DEADLINE_INITIAL = 1,
	__SCHED_FEAT_PLACE_REL_DEADLINE = 2,
	__SCHED_FEAT_RUN_TO_PARITY = 3,
	__SCHED_FEAT_PREEMPT_SHORT = 4,
	__SCHED_FEAT_NEXT_BUDDY = 5,
	__SCHED_FEAT_PICK_BUDDY = 6,
	__SCHED_FEAT_CACHE_HOT_BUDDY = 7,
	__SCHED_FEAT_DELAY_DEQUEUE = 8,
	__SCHED_FEAT_DELAY_ZERO = 9,
	__SCHED_FEAT_WAKEUP_PREEMPTION = 10,
	__SCHED_FEAT_HRTICK = 11,
	__SCHED_FEAT_HRTICK_DL = 12,
	__SCHED_FEAT_NONTASK_CAPACITY = 13,
	__SCHED_FEAT_TTWU_QUEUE = 14,
	__SCHED_FEAT_SIS_UTIL = 15,
	__SCHED_FEAT_WARN_DOUBLE_CLOCK = 16,
	__SCHED_FEAT_RT_PUSH_IPI = 17,
	__SCHED_FEAT_RT_RUNTIME_SHARE = 18,
	__SCHED_FEAT_LB_MIN = 19,
	__SCHED_FEAT_ATTACH_AGE_LOAD = 20,
	__SCHED_FEAT_WA_IDLE = 21,
	__SCHED_FEAT_WA_WEIGHT = 22,
	__SCHED_FEAT_WA_BIAS = 23,
	__SCHED_FEAT_UTIL_EST = 24,
	__SCHED_FEAT_LATENCY_WARN = 25,
	__SCHED_FEAT_NR = 26,
};

enum {
	__SD_BALANCE_NEWIDLE = 0,
	__SD_BALANCE_EXEC = 1,
	__SD_BALANCE_FORK = 2,
	__SD_BALANCE_WAKE = 3,
	__SD_WAKE_AFFINE = 4,
	__SD_ASYM_CPUCAPACITY = 5,
	__SD_ASYM_CPUCAPACITY_FULL = 6,
	__SD_SHARE_CPUCAPACITY = 7,
	__SD_CLUSTER = 8,
	__SD_SHARE_LLC = 9,
	__SD_SERIALIZE = 10,
	__SD_ASYM_PACKING = 11,
	__SD_PREFER_SIBLING = 12,
	__SD_OVERLAP = 13,
	__SD_NUMA = 14,
	__SD_FLAG_CNT = 15,
};

enum {
	___GFP_DMA_BIT = 0,
	___GFP_HIGHMEM_BIT = 1,
	___GFP_DMA32_BIT = 2,
	___GFP_MOVABLE_BIT = 3,
	___GFP_RECLAIMABLE_BIT = 4,
	___GFP_HIGH_BIT = 5,
	___GFP_IO_BIT = 6,
	___GFP_FS_BIT = 7,
	___GFP_ZERO_BIT = 8,
	___GFP_UNUSED_BIT = 9,
	___GFP_DIRECT_RECLAIM_BIT = 10,
	___GFP_KSWAPD_RECLAIM_BIT = 11,
	___GFP_WRITE_BIT = 12,
	___GFP_NOWARN_BIT = 13,
	___GFP_RETRY_MAYFAIL_BIT = 14,
	___GFP_NOFAIL_BIT = 15,
	___GFP_NORETRY_BIT = 16,
	___GFP_MEMALLOC_BIT = 17,
	___GFP_COMP_BIT = 18,
	___GFP_NOMEMALLOC_BIT = 19,
	___GFP_HARDWALL_BIT = 20,
	___GFP_THISNODE_BIT = 21,
	___GFP_ACCOUNT_BIT = 22,
	___GFP_ZEROTAGS_BIT = 23,
	___GFP_NO_OBJ_EXT_BIT = 24,
	___GFP_LAST_BIT = 25,
};

enum {
	__ctx_convertBPF_PROG_TYPE_SOCKET_FILTER = 0,
	__ctx_convertBPF_PROG_TYPE_SCHED_CLS = 1,
	__ctx_convertBPF_PROG_TYPE_SCHED_ACT = 2,
	__ctx_convertBPF_PROG_TYPE_XDP = 3,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SKB = 4,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCK = 5,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCK_ADDR = 6,
	__ctx_convertBPF_PROG_TYPE_LWT_IN = 7,
	__ctx_convertBPF_PROG_TYPE_LWT_OUT = 8,
	__ctx_convertBPF_PROG_TYPE_LWT_XMIT = 9,
	__ctx_convertBPF_PROG_TYPE_LWT_SEG6LOCAL = 10,
	__ctx_convertBPF_PROG_TYPE_SOCK_OPS = 11,
	__ctx_convertBPF_PROG_TYPE_SK_SKB = 12,
	__ctx_convertBPF_PROG_TYPE_SK_MSG = 13,
	__ctx_convertBPF_PROG_TYPE_FLOW_DISSECTOR = 14,
	__ctx_convertBPF_PROG_TYPE_KPROBE = 15,
	__ctx_convertBPF_PROG_TYPE_TRACEPOINT = 16,
	__ctx_convertBPF_PROG_TYPE_PERF_EVENT = 17,
	__ctx_convertBPF_PROG_TYPE_RAW_TRACEPOINT = 18,
	__ctx_convertBPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE = 19,
	__ctx_convertBPF_PROG_TYPE_TRACING = 20,
	__ctx_convertBPF_PROG_TYPE_CGROUP_DEVICE = 21,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SYSCTL = 22,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCKOPT = 23,
	__ctx_convertBPF_PROG_TYPE_SK_REUSEPORT = 24,
	__ctx_convertBPF_PROG_TYPE_SK_LOOKUP = 25,
	__ctx_convertBPF_PROG_TYPE_STRUCT_OPS = 26,
	__ctx_convertBPF_PROG_TYPE_EXT = 27,
	__ctx_convertBPF_PROG_TYPE_SYSCALL = 28,
	__ctx_convertBPF_PROG_TYPE_NETFILTER = 29,
	__ctx_convert_unused = 30,
};

enum {
	attr_noop = 0,
	attr_delayed_allocation_blocks = 1,
	attr_session_write_kbytes = 2,
	attr_lifetime_write_kbytes = 3,
	attr_reserved_clusters = 4,
	attr_sra_exceeded_retry_limit = 5,
	attr_inode_readahead = 6,
	attr_trigger_test_error = 7,
	attr_first_error_time = 8,
	attr_last_error_time = 9,
	attr_clusters_in_group = 10,
	attr_mb_order = 11,
	attr_feature = 12,
	attr_pointer_pi = 13,
	attr_pointer_ui = 14,
	attr_pointer_ul = 15,
	attr_pointer_u64 = 16,
	attr_pointer_u8 = 17,
	attr_pointer_string = 18,
	attr_pointer_atomic = 19,
	attr_journal_task = 20,
};

enum {
	blank_off = 0,
	blank_normal_wait = 1,
	blank_vesa_wait = 2,
};

enum {
	cpuset = 0,
	possible = 1,
	fail = 2,
};

enum {
	dns_key_data = 0,
	dns_key_error = 1,
};

enum {
	e1000_10_half = 0,
	e1000_10_full = 1,
	e1000_100_half = 2,
	e1000_100_full = 3,
};

enum {
	e1000_igp_cable_length_10 = 10,
	e1000_igp_cable_length_20 = 20,
	e1000_igp_cable_length_30 = 30,
	e1000_igp_cable_length_40 = 40,
	e1000_igp_cable_length_50 = 50,
	e1000_igp_cable_length_60 = 60,
	e1000_igp_cable_length_70 = 70,
	e1000_igp_cable_length_80 = 80,
	e1000_igp_cable_length_90 = 90,
	e1000_igp_cable_length_100 = 100,
	e1000_igp_cable_length_110 = 110,
	e1000_igp_cable_length_115 = 115,
	e1000_igp_cable_length_120 = 120,
	e1000_igp_cable_length_130 = 130,
	e1000_igp_cable_length_140 = 140,
	e1000_igp_cable_length_150 = 150,
	e1000_igp_cable_length_160 = 160,
	e1000_igp_cable_length_170 = 170,
	e1000_igp_cable_length_180 = 180,
};

enum {
	false = 0,
	true = 1,
};

enum {
	hip08 = 0,
};

enum {
	kvm_ioeventfd_flag_nr_datamatch = 0,
	kvm_ioeventfd_flag_nr_pio = 1,
	kvm_ioeventfd_flag_nr_deassign = 2,
	kvm_ioeventfd_flag_nr_virtio_ccw_notify = 3,
	kvm_ioeventfd_flag_nr_fast_mmio = 4,
	kvm_ioeventfd_flag_nr_max = 5,
};

enum {
	none = 0,
	day = 1,
	month = 2,
	year = 3,
};

enum {
	pci_channel_io_normal = 1,
	pci_channel_io_frozen = 2,
	pci_channel_io_perm_failure = 3,
};

enum {
	ptr_explicit = 0,
	ptr_ext4_sb_info_offset = 1,
	ptr_ext4_super_block_offset = 2,
};

enum {
	sysctl_hung_task_timeout_secs = 0,
};

enum {
	vfio_noiommu = 0,
};

typedef enum {
	BIT_DStream_unfinished = 0,
	BIT_DStream_endOfBuffer = 1,
	BIT_DStream_completed = 2,
	BIT_DStream_overflow = 3,
} BIT_DStream_status;

typedef enum {
	EfiPciIoWidthUint8 = 0,
	EfiPciIoWidthUint16 = 1,
	EfiPciIoWidthUint32 = 2,
	EfiPciIoWidthUint64 = 3,
	EfiPciIoWidthFifoUint8 = 4,
	EfiPciIoWidthFifoUint16 = 5,
	EfiPciIoWidthFifoUint32 = 6,
	EfiPciIoWidthFifoUint64 = 7,
	EfiPciIoWidthFillUint8 = 8,
	EfiPciIoWidthFillUint16 = 9,
	EfiPciIoWidthFillUint32 = 10,
	EfiPciIoWidthFillUint64 = 11,
	EfiPciIoWidthMaximum = 12,
} EFI_PCI_IO_PROTOCOL_WIDTH;

typedef enum {
	EfiTimerCancel = 0,
	EfiTimerPeriodic = 1,
	EfiTimerRelative = 2,
} EFI_TIMER_DELAY;

typedef enum {
	ZSTD_error_no_error = 0,
	ZSTD_error_GENERIC = 1,
	ZSTD_error_prefix_unknown = 10,
	ZSTD_error_version_unsupported = 12,
	ZSTD_error_frameParameter_unsupported = 14,
	ZSTD_error_frameParameter_windowTooLarge = 16,
	ZSTD_error_corruption_detected = 20,
	ZSTD_error_checksum_wrong = 22,
	ZSTD_error_literals_headerWrong = 24,
	ZSTD_error_dictionary_corrupted = 30,
	ZSTD_error_dictionary_wrong = 32,
	ZSTD_error_dictionaryCreation_failed = 34,
	ZSTD_error_parameter_unsupported = 40,
	ZSTD_error_parameter_combination_unsupported = 41,
	ZSTD_error_parameter_outOfBound = 42,
	ZSTD_error_tableLog_tooLarge = 44,
	ZSTD_error_maxSymbolValue_tooLarge = 46,
	ZSTD_error_maxSymbolValue_tooSmall = 48,
	ZSTD_error_cannotProduce_uncompressedBlock = 49,
	ZSTD_error_stabilityCondition_notRespected = 50,
	ZSTD_error_stage_wrong = 60,
	ZSTD_error_init_missing = 62,
	ZSTD_error_memory_allocation = 64,
	ZSTD_error_workSpace_tooSmall = 66,
	ZSTD_error_dstSize_tooSmall = 70,
	ZSTD_error_srcSize_wrong = 72,
	ZSTD_error_dstBuffer_null = 74,
	ZSTD_error_noForwardProgress_destFull = 80,
	ZSTD_error_noForwardProgress_inputEmpty = 82,
	ZSTD_error_frameIndex_tooLarge = 100,
	ZSTD_error_seekableIO = 102,
	ZSTD_error_dstBuffer_wrong = 104,
	ZSTD_error_srcBuffer_wrong = 105,
	ZSTD_error_sequenceProducer_failed = 106,
	ZSTD_error_externalSequences_invalid = 107,
	ZSTD_error_maxCode = 120,
} ZSTD_ErrorCode;

typedef ZSTD_ErrorCode ERR_enum;

typedef enum {
	set_basic = 0,
	set_rle = 1,
	set_compressed = 2,
	set_repeat = 3,
} SymbolEncodingType_e;

typedef enum {
	ZSTD_frame = 0,
	ZSTD_skippableFrame = 1,
} ZSTD_FrameType_e;

typedef enum {
	ZSTD_reset_session_only = 1,
	ZSTD_reset_parameters = 2,
	ZSTD_reset_session_and_parameters = 3,
} ZSTD_ResetDirective;

typedef enum {
	ZSTD_bm_buffered = 0,
	ZSTD_bm_stable = 1,
} ZSTD_bufferMode_e;

typedef enum {
	ZSTD_d_windowLogMax = 100,
	ZSTD_d_experimentalParam1 = 1000,
	ZSTD_d_experimentalParam2 = 1001,
	ZSTD_d_experimentalParam3 = 1002,
	ZSTD_d_experimentalParam4 = 1003,
	ZSTD_d_experimentalParam5 = 1004,
	ZSTD_d_experimentalParam6 = 1005,
} ZSTD_dParameter;

typedef enum {
	ZSTDds_getFrameHeaderSize = 0,
	ZSTDds_decodeFrameHeader = 1,
	ZSTDds_decodeBlockHeader = 2,
	ZSTDds_decompressBlock = 3,
	ZSTDds_decompressLastBlock = 4,
	ZSTDds_checkChecksum = 5,
	ZSTDds_decodeSkippableHeader = 6,
	ZSTDds_skipFrame = 7,
} ZSTD_dStage;

typedef enum {
	zdss_init = 0,
	zdss_loadHeader = 1,
	zdss_read = 2,
	zdss_load = 3,
	zdss_flush = 4,
} ZSTD_dStreamStage;

typedef enum {
	ZSTD_dct_auto = 0,
	ZSTD_dct_rawContent = 1,
	ZSTD_dct_fullDict = 2,
} ZSTD_dictContentType_e;

typedef enum {
	ZSTD_dlm_byCopy = 0,
	ZSTD_dlm_byRef = 1,
} ZSTD_dictLoadMethod_e;

typedef enum {
	ZSTD_use_indefinitely = -1,
	ZSTD_dont_use = 0,
	ZSTD_use_once = 1,
} ZSTD_dictUses_e;

typedef enum {
	ZSTD_d_validateChecksum = 0,
	ZSTD_d_ignoreChecksum = 1,
} ZSTD_forceIgnoreChecksum_e;

typedef enum {
	ZSTD_f_zstd1 = 0,
	ZSTD_f_zstd1_magicless = 1,
} ZSTD_format_e;

typedef enum {
	ZSTD_not_in_dst = 0,
	ZSTD_in_dst = 1,
	ZSTD_split = 2,
} ZSTD_litLocation_e;

typedef enum {
	ZSTD_lo_isRegularOffset = 0,
	ZSTD_lo_isLongOffset = 1,
} ZSTD_longOffset_e;

typedef enum {
	ZSTDnit_frameHeader = 0,
	ZSTDnit_blockHeader = 1,
	ZSTDnit_block = 2,
	ZSTDnit_lastBlock = 3,
	ZSTDnit_checksum = 4,
	ZSTDnit_skippableFrame = 5,
} ZSTD_nextInputType_e;

typedef enum {
	ZSTD_no_overlap = 0,
	ZSTD_overlap_src_before_dst = 1,
} ZSTD_overlap_e;

typedef enum {
	ZSTD_rmd_refSingleDDict = 0,
	ZSTD_rmd_refMultipleDDicts = 1,
} ZSTD_refMultipleDDicts_e;

typedef enum {
	OSL_GLOBAL_LOCK_HANDLER = 0,
	OSL_NOTIFY_HANDLER = 1,
	OSL_GPE_HANDLER = 2,
	OSL_DEBUGGER_MAIN_THREAD = 3,
	OSL_DEBUGGER_EXEC_THREAD = 4,
	OSL_EC_POLL_HANDLER = 5,
	OSL_EC_BURST_HANDLER = 6,
} acpi_execute_type;

typedef enum {
	ACPI_IMODE_LOAD_PASS1 = 1,
	ACPI_IMODE_LOAD_PASS2 = 2,
	ACPI_IMODE_EXECUTE = 3,
} acpi_interpreter_mode;

typedef enum {
	ACPI_TRACE_AML_METHOD = 0,
	ACPI_TRACE_AML_OPCODE = 1,
	ACPI_TRACE_AML_REGION = 2,
} acpi_trace_event_type;

typedef enum {
	bt_raw = 0,
	bt_rle = 1,
	bt_compressed = 2,
	bt_reserved = 3,
} blockType_e;

typedef enum {
	need_more = 0,
	block_done = 1,
	finish_started = 2,
	finish_done = 3,
} block_state;

typedef enum {
	CODES = 0,
	LENS = 1,
	DISTS = 2,
} codetype;

typedef enum {
	FILE_MEMORY_MIGRATE = 0,
	FILE_CPULIST = 1,
	FILE_MEMLIST = 2,
	FILE_EFFECTIVE_CPULIST = 3,
	FILE_EFFECTIVE_MEMLIST = 4,
	FILE_SUBPARTS_CPULIST = 5,
	FILE_EXCLUSIVE_CPULIST = 6,
	FILE_EFFECTIVE_XCPULIST = 7,
	FILE_ISOLATED_CPULIST = 8,
	FILE_CPU_EXCLUSIVE = 9,
	FILE_MEM_EXCLUSIVE = 10,
	FILE_MEM_HARDWALL = 11,
	FILE_SCHED_LOAD_BALANCE = 12,
	FILE_PARTITION_ROOT = 13,
	FILE_SCHED_RELAX_DOMAIN_LEVEL = 14,
	FILE_MEMORY_PRESSURE_ENABLED = 15,
	FILE_MEMORY_PRESSURE = 16,
	FILE_SPREAD_PAGE = 17,
	FILE_SPREAD_SLAB = 18,
} cpuset_filetype_t;

typedef enum {
	CS_ONLINE = 0,
	CS_CPU_EXCLUSIVE = 1,
	CS_MEM_EXCLUSIVE = 2,
	CS_MEM_HARDWALL = 3,
	CS_MEMORY_MIGRATE = 4,
	CS_SCHED_LOAD_BALANCE = 5,
	CS_SPREAD_PAGE = 6,
	CS_SPREAD_SLAB = 7,
} cpuset_flagbits_t;

typedef enum {
	noDict = 0,
	withPrefix64k = 1,
	usingExtDict = 2,
} dict_directive;

typedef enum {
	EITHER = 0,
	INDEX = 1,
	DIRENT = 2,
	DIRENT_HTREE = 3,
} dirblock_type_t;

typedef enum {
	e1000_1000t_rx_status_not_ok = 0,
	e1000_1000t_rx_status_ok = 1,
	e1000_1000t_rx_status_undefined = 255,
} e1000_1000t_rx_status;

typedef enum {
	e1000_10bt_ext_dist_enable_normal = 0,
	e1000_10bt_ext_dist_enable_lower = 1,
	e1000_10bt_ext_dist_enable_undefined = 255,
} e1000_10bt_ext_dist_enable;

typedef enum {
	e1000_auto_x_mode_manual_mdi = 0,
	e1000_auto_x_mode_manual_mdix = 1,
	e1000_auto_x_mode_auto1 = 2,
	e1000_auto_x_mode_auto2 = 3,
	e1000_auto_x_mode_undefined = 255,
} e1000_auto_x_mode;

typedef enum {
	e1000_bus_speed_unknown = 0,
	e1000_bus_speed_33 = 1,
	e1000_bus_speed_66 = 2,
	e1000_bus_speed_100 = 3,
	e1000_bus_speed_120 = 4,
	e1000_bus_speed_133 = 5,
	e1000_bus_speed_reserved = 6,
} e1000_bus_speed;

typedef enum {
	e1000_bus_type_unknown = 0,
	e1000_bus_type_pci = 1,
	e1000_bus_type_pcix = 2,
	e1000_bus_type_reserved = 3,
} e1000_bus_type;

typedef enum {
	e1000_bus_width_unknown = 0,
	e1000_bus_width_32 = 1,
	e1000_bus_width_64 = 2,
	e1000_bus_width_reserved = 3,
} e1000_bus_width;

typedef enum {
	e1000_cable_length_50 = 0,
	e1000_cable_length_50_80 = 1,
	e1000_cable_length_80_110 = 2,
	e1000_cable_length_110_140 = 3,
	e1000_cable_length_140 = 4,
	e1000_cable_length_undefined = 255,
} e1000_cable_length;

typedef enum {
	e1000_downshift_normal = 0,
	e1000_downshift_activated = 1,
	e1000_downshift_undefined = 255,
} e1000_downshift;

typedef enum {
	e1000_dsp_config_disabled = 0,
	e1000_dsp_config_enabled = 1,
	e1000_dsp_config_activated = 2,
	e1000_dsp_config_undefined = 255,
} e1000_dsp_config;

typedef enum {
	e1000_eeprom_uninitialized = 0,
	e1000_eeprom_spi = 1,
	e1000_eeprom_microwire = 2,
	e1000_eeprom_flash = 3,
	e1000_eeprom_none = 4,
	e1000_num_eeprom_types = 5,
} e1000_eeprom_type;

typedef enum {
	E1000_FC_NONE = 0,
	E1000_FC_RX_PAUSE = 1,
	E1000_FC_TX_PAUSE = 2,
	E1000_FC_FULL = 3,
	E1000_FC_DEFAULT = 255,
} e1000_fc_type;

typedef enum {
	e1000_ffe_config_enabled = 0,
	e1000_ffe_config_active = 1,
	e1000_ffe_config_blocked = 2,
} e1000_ffe_config;

typedef enum {
	e1000_undefined = 0,
	e1000_82542_rev2_0 = 1,
	e1000_82542_rev2_1 = 2,
	e1000_82543 = 3,
	e1000_82544 = 4,
	e1000_82540 = 5,
	e1000_82545 = 6,
	e1000_82545_rev_3 = 7,
	e1000_82546 = 8,
	e1000_ce4100 = 9,
	e1000_82546_rev_3 = 10,
	e1000_82541 = 11,
	e1000_82541_rev_2 = 12,
	e1000_82547 = 13,
	e1000_82547_rev_2 = 14,
	e1000_num_macs = 15,
} e1000_mac_type;

typedef enum {
	e1000_media_type_copper = 0,
	e1000_media_type_fiber = 1,
	e1000_media_type_internal_serdes = 2,
	e1000_num_media_types = 3,
} e1000_media_type;

typedef enum {
	e1000_ms_hw_default = 0,
	e1000_ms_force_master = 1,
	e1000_ms_force_slave = 2,
	e1000_ms_auto = 3,
} e1000_ms_type;

typedef enum {
	e1000_phy_m88 = 0,
	e1000_phy_igp = 1,
	e1000_phy_8211 = 2,
	e1000_phy_8201 = 3,
	e1000_phy_undefined = 255,
} e1000_phy_type;

typedef enum {
	e1000_polarity_reversal_enabled = 0,
	e1000_polarity_reversal_disabled = 1,
	e1000_polarity_reversal_undefined = 255,
} e1000_polarity_reversal;

typedef enum {
	e1000_rev_polarity_normal = 0,
	e1000_rev_polarity_reversed = 1,
	e1000_rev_polarity_undefined = 255,
} e1000_rev_polarity;

typedef enum {
	e1000_smart_speed_default = 0,
	e1000_smart_speed_on = 1,
	e1000_smart_speed_off = 2,
} e1000_smart_speed;

typedef enum {
	decode_full_block = 0,
	partial_decode = 1,
} earlyEnd_directive;

typedef enum {
	endOnOutputSize = 0,
	endOnInputSize = 1,
} endCondition_directive;

typedef enum {
	EXT4_IGET_NORMAL = 0,
	EXT4_IGET_SPECIAL = 1,
	EXT4_IGET_HANDLE = 2,
	EXT4_IGET_BAD = 4,
	EXT4_IGET_EA_INODE = 8,
} ext4_iget_flags;

typedef enum {
	FL_READY = 0,
	FL_STATUS = 1,
	FL_CFI_QUERY = 2,
	FL_JEDEC_QUERY = 3,
	FL_ERASING = 4,
	FL_ERASE_SUSPENDING = 5,
	FL_ERASE_SUSPENDED = 6,
	FL_WRITING = 7,
	FL_WRITING_TO_BUFFER = 8,
	FL_OTP_WRITE = 9,
	FL_WRITE_SUSPENDING = 10,
	FL_WRITE_SUSPENDED = 11,
	FL_PM_SUSPENDED = 12,
	FL_SYNCING = 13,
	FL_UNLOADING = 14,
	FL_LOCKING = 15,
	FL_UNLOCKING = 16,
	FL_POINT = 17,
	FL_XIP_WHILE_ERASING = 18,
	FL_XIP_WHILE_WRITING = 19,
	FL_SHUTDOWN = 20,
	FL_READING = 21,
	FL_CACHEDPRG = 22,
	FL_RESETTING = 23,
	FL_OTPING = 24,
	FL_PREPARING_ERASE = 25,
	FL_VERIFYING_ERASE = 26,
	FL_UNKNOWN = 27,
} flstate_t;

typedef enum {
	HEAD = 0,
	FLAGS = 1,
	TIME = 2,
	OS = 3,
	EXLEN = 4,
	EXTRA = 5,
	NAME = 6,
	COMMENT = 7,
	HCRC = 8,
	DICTID = 9,
	DICT = 10,
	TYPE = 11,
	TYPEDO = 12,
	STORED = 13,
	COPY = 14,
	TABLE = 15,
	LENLENS = 16,
	CODELENS = 17,
	LEN = 18,
	LENEXT = 19,
	DIST = 20,
	DISTEXT = 21,
	MATCH = 22,
	LIT = 23,
	CHECK = 24,
	LENGTH = 25,
	DONE = 26,
	BAD = 27,
	MEM = 28,
	SYNC = 29,
} inflate_mode;

typedef enum {
	ISOLATE_ABORT = 0,
	ISOLATE_NONE = 1,
	ISOLATE_SUCCESS = 2,
} isolate_migrate_t;

typedef enum {
	MAP_CHG_REUSE = 0,
	MAP_CHG_NEEDED = 1,
	MAP_CHG_ENFORCED = 2,
} map_chg_state;

typedef enum {
	PAGE_KEEP = 0,
	PAGE_ACTIVATE = 1,
	PAGE_SUCCESS = 2,
	PAGE_CLEAN = 3,
} pageout_t;

typedef enum {
	PCI_BRIDGE_EMUL_HANDLED = 0,
	PCI_BRIDGE_EMUL_NOT_HANDLED = 1,
} pci_bridge_emul_read_status_t;

typedef enum {
	PHY_INTERFACE_MODE_NA = 0,
	PHY_INTERFACE_MODE_INTERNAL = 1,
	PHY_INTERFACE_MODE_MII = 2,
	PHY_INTERFACE_MODE_GMII = 3,
	PHY_INTERFACE_MODE_SGMII = 4,
	PHY_INTERFACE_MODE_TBI = 5,
	PHY_INTERFACE_MODE_REVMII = 6,
	PHY_INTERFACE_MODE_RMII = 7,
	PHY_INTERFACE_MODE_REVRMII = 8,
	PHY_INTERFACE_MODE_RGMII = 9,
	PHY_INTERFACE_MODE_RGMII_ID = 10,
	PHY_INTERFACE_MODE_RGMII_RXID = 11,
	PHY_INTERFACE_MODE_RGMII_TXID = 12,
	PHY_INTERFACE_MODE_RTBI = 13,
	PHY_INTERFACE_MODE_SMII = 14,
	PHY_INTERFACE_MODE_XGMII = 15,
	PHY_INTERFACE_MODE_XLGMII = 16,
	PHY_INTERFACE_MODE_MOCA = 17,
	PHY_INTERFACE_MODE_PSGMII = 18,
	PHY_INTERFACE_MODE_QSGMII = 19,
	PHY_INTERFACE_MODE_TRGMII = 20,
	PHY_INTERFACE_MODE_100BASEX = 21,
	PHY_INTERFACE_MODE_1000BASEX = 22,
	PHY_INTERFACE_MODE_2500BASEX = 23,
	PHY_INTERFACE_MODE_5GBASER = 24,
	PHY_INTERFACE_MODE_RXAUI = 25,
	PHY_INTERFACE_MODE_XAUI = 26,
	PHY_INTERFACE_MODE_10GBASER = 27,
	PHY_INTERFACE_MODE_25GBASER = 28,
	PHY_INTERFACE_MODE_USXGMII = 29,
	PHY_INTERFACE_MODE_10GKR = 30,
	PHY_INTERFACE_MODE_QUSGMII = 31,
	PHY_INTERFACE_MODE_1000BASEKX = 32,
	PHY_INTERFACE_MODE_10G_QXGMII = 33,
	PHY_INTERFACE_MODE_MAX = 34,
} phy_interface_t;

typedef enum {
	PSMOUSE_BAD_DATA = 0,
	PSMOUSE_GOOD_DATA = 1,
	PSMOUSE_FULL_PACKET = 2,
} psmouse_ret_t;

typedef enum {
	SS_FREE = 0,
	SS_UNCONNECTED = 1,
	SS_CONNECTING = 2,
	SS_CONNECTED = 3,
	SS_DISCONNECTING = 4,
} socket_state;

typedef enum {
	not_streaming = 0,
	is_streaming = 1,
} streaming_operation;

typedef ZSTD_ErrorCode zstd_error_code;

enum APSR_BIT {
	APSR_MEMS = 2,
	APSR_CMSW = 16,
	APSR_RDM = 8192,
	APSR_TDM = 16384,
	APSR_MIISELECT = 16777216,
};

enum ARSTR_BIT {
	ARSTR_ARST = 1,
};

enum CCC_BIT {
	CCC_OPC = 3,
	CCC_OPC_RESET = 0,
	CCC_OPC_CONFIG = 1,
	CCC_OPC_OPERATION = 2,
	CCC_GAC = 128,
	CCC_DTSR = 256,
	CCC_CSEL = 196608,
	CCC_CSEL_HPB = 65536,
	CCC_CSEL_ETH_TX = 131072,
	CCC_CSEL_GMII_REF = 196608,
	CCC_LBME = 16777216,
};

enum CIE_BIT {
	CIE_CRIE = 1,
	CIE_CTIE = 256,
	CIE_RQFM = 65536,
	CIE_CL0M = 131072,
	CIE_RFWL = 262144,
	CIE_RFFL = 524288,
};

enum CMD_RET_VALUES {
	REFIRE_CMD = 1,
	COMPLETE_CMD = 2,
	RETURN_CMD = 3,
};

enum CSI_J {
	CSI_J_CURSOR_TO_END = 0,
	CSI_J_START_TO_CURSOR = 1,
	CSI_J_VISIBLE = 2,
	CSI_J_FULL = 3,
};

enum CSI_right_square_bracket {
	CSI_RSB_COLOR_FOR_UNDERLINE = 1,
	CSI_RSB_COLOR_FOR_HALF_BRIGHT = 2,
	CSI_RSB_MAKE_CUR_COLOR_DEFAULT = 8,
	CSI_RSB_BLANKING_INTERVAL = 9,
	CSI_RSB_BELL_FREQUENCY = 10,
	CSI_RSB_BELL_DURATION = 11,
	CSI_RSB_BRING_CONSOLE_TO_FRONT = 12,
	CSI_RSB_UNBLANK = 13,
	CSI_RSB_VESA_OFF_INTERVAL = 14,
	CSI_RSB_BRING_PREV_CONSOLE_TO_FRONT = 15,
	CSI_RSB_CURSOR_BLINK_INTERVAL = 16,
};

enum CSR0_BIT {
	CSR0_TPE = 16,
	CSR0_RPE = 32,
};

enum CSR1_BIT {
	CSR1_TIP4 = 1,
	CSR1_TTCP4 = 16,
	CSR1_TUDP4 = 32,
	CSR1_TICMP4 = 64,
	CSR1_TTCP6 = 1048576,
	CSR1_TUDP6 = 2097152,
	CSR1_TICMP6 = 4194304,
	CSR1_THOP = 16777216,
	CSR1_TROUT = 33554432,
	CSR1_TAHD = 67108864,
	CSR1_TDHD = 134217728,
};

enum CSR2_BIT {
	CSR2_RIP4 = 1,
	CSR2_RTCP4 = 16,
	CSR2_RUDP4 = 32,
	CSR2_RICMP4 = 64,
	CSR2_RTCP6 = 1048576,
	CSR2_RUDP6 = 2097152,
	CSR2_RICMP6 = 4194304,
	CSR2_RHOP = 16777216,
	CSR2_RROUT = 33554432,
	CSR2_RAHD = 67108864,
	CSR2_RDHD = 134217728,
};

enum CSR_BIT {
	CSR_OPS = 15,
	CSR_OPS_RESET = 1,
	CSR_OPS_CONFIG = 2,
	CSR_OPS_OPERATION = 4,
	CSR_OPS_STANDBY = 8,
	CSR_DTS = 256,
	CSR_TPO0 = 65536,
	CSR_TPO1 = 131072,
	CSR_TPO2 = 262144,
	CSR_TPO3 = 524288,
	CSR_RPO = 1048576,
};

enum CXR31_BIT {
	CXR31_SEL_LINK0 = 1,
	CXR31_SEL_LINK1 = 8,
};

enum CXR35_BIT {
	CXR35_SEL_XMII = 3,
	CXR35_SEL_XMII_RGMII = 0,
	CXR35_SEL_XMII_MII = 2,
	CXR35_HALFCYC_CLKSW = 4294901760,
};

enum DCMD_RETURN_STATUS {
	DCMD_SUCCESS = 0,
	DCMD_TIMEOUT = 1,
	DCMD_FAILED = 2,
	DCMD_BUSY = 3,
	DCMD_INIT = 255,
};

enum DCMD_TIMEOUT_ACTION {
	INITIATE_OCR = 0,
	KILL_ADAPTER = 1,
	IGNORE_TIMEOUT = 2,
};

enum DIE_DT {
	DT_FEMPTY_IS = 16,
	DT_FEMPTY_IC = 32,
	DT_FEMPTY_ND = 48,
	DT_FEMPTY = 64,
	DT_FEMPTY_START = 80,
	DT_FEMPTY_MID = 96,
	DT_FEMPTY_END = 112,
	DT_FSINGLE = 128,
	DT_FSTART = 144,
	DT_FMID = 160,
	DT_FEND = 176,
	DT_LEMPTY = 192,
	DT_EEMPTY = 208,
	DT_LINK = 224,
	DT_EOS = 240,
	DT_MASK = 240,
	D_DIE = 8,
};

enum DIE_DT___2 {
	DT_FSINGLE___2 = 128,
	DT_FSTART___2 = 144,
	DT_FMID___2 = 160,
	DT_FEND___2 = 176,
	DT_LEMPTY___2 = 192,
	DT_EEMPTY___2 = 208,
	DT_LINKFIX = 0,
	DT_LINK___2 = 224,
	DT_EOS___2 = 240,
	DT_FEMPTY___2 = 64,
	DT_FEMPTY_IS___2 = 16,
	DT_FEMPTY_IC___2 = 32,
	DT_FEMPTY_ND___2 = 48,
	DT_FEMPTY_START___2 = 80,
	DT_FEMPTY_MID___2 = 96,
	DT_FEMPTY_END___2 = 112,
	DT_MASK___2 = 240,
	DIE = 8,
};

enum DIE_DT___3 {
	DT_FMID___3 = 64,
	DT_FSTART___3 = 80,
	DT_FEND___3 = 96,
	DT_FSINGLE___3 = 112,
	DT_LINK___3 = 128,
	DT_LINKFIX___2 = 144,
	DT_EOS___3 = 160,
	DT_FEMPTY___3 = 192,
	DT_FEMPTY_IS___3 = 208,
	DT_FEMPTY_IC___3 = 224,
	DT_FEMPTY_ND___3 = 240,
	DT_LEMPTY___3 = 32,
	DT_EEMPTY___3 = 48,
};

enum DMA_REGS_OFFSET {
	OFFSET_INT_FLAG = 0,
	OFFSET_INT_EN = 4,
	OFFSET_EN = 8,
	OFFSET_RST = 12,
	OFFSET_CON = 24,
	OFFSET_TX_MEM_ADDR = 28,
	OFFSET_RX_MEM_ADDR = 32,
	OFFSET_TX_LEN = 36,
	OFFSET_RX_LEN = 40,
	OFFSET_TX_4G_MODE = 84,
	OFFSET_RX_4G_MODE = 88,
};

enum E1000_INVM_STRUCTURE_TYPE {
	E1000_INVM_UNINITIALIZED_STRUCTURE = 0,
	E1000_INVM_WORD_AUTOLOAD_STRUCTURE = 1,
	E1000_INVM_CSR_AUTOLOAD_STRUCTURE = 2,
	E1000_INVM_PHY_REGISTER_AUTOLOAD_STRUCTURE = 3,
	E1000_INVM_RSA_KEY_SHA256_STRUCTURE = 4,
	E1000_INVM_INVALIDATED_STRUCTURE = 15,
};

enum ECMR_BIT {
	ECMR_PRM = 1,
	ECMR_DM = 2,
	ECMR_TE = 32,
	ECMR_RE = 64,
	ECMR_MPDE = 512,
	ECMR_TXF = 65536,
	ECMR_RXF = 131072,
	ECMR_PFR = 262144,
	ECMR_ZPF = 524288,
	ECMR_RZPF = 1048576,
	ECMR_DPAD = 2097152,
	ECMR_RCSC = 8388608,
	ECMR_RCPT = 33554432,
	ECMR_TRCCM = 67108864,
};

enum ECMR_BIT___2 {
	ECMR_TRCCM___2 = 67108864,
	ECMR_RCSC___2 = 8388608,
	ECMR_DPAD___2 = 2097152,
	ECMR_RZPF___2 = 1048576,
	ECMR_ZPF___2 = 524288,
	ECMR_PFR___2 = 262144,
	ECMR_RXF___2 = 131072,
	ECMR_TXF___2 = 65536,
	ECMR_MCT = 8192,
	ECMR_PRCEF = 4096,
	ECMR_MPDE___2 = 512,
	ECMR_RE___2 = 64,
	ECMR_TE___2 = 32,
	ECMR_RTM = 16,
	ECMR_ILB = 8,
	ECMR_ELB = 4,
	ECMR_DM___2 = 2,
	ECMR_PRM___2 = 1,
};

enum ECSIPR_BIT {
	ECSIPR_ICDIP = 1,
	ECSIPR_MPDIP = 2,
	ECSIPR_LCHNGIP = 4,
};

enum ECSIPR_BIT___2 {
	ECSIPR_BRCRXIP = 32,
	ECSIPR_PSRTOIP = 16,
	ECSIPR_LCHNGIP___2 = 4,
	ECSIPR_MPDIP___2 = 2,
	ECSIPR_ICDIP___2 = 1,
};

enum ECSR_BIT {
	ECSR_ICD = 1,
	ECSR_MPD = 2,
	ECSR_LCHNG = 4,
	ECSR_PHYI = 8,
	ECSR_PFRI = 16,
};

enum ECSR_BIT___2 {
	ECSR_BRCRX = 32,
	ECSR_PSRTO = 16,
	ECSR_LCHNG___2 = 4,
	ECSR_MPD___2 = 2,
	ECSR_ICD___2 = 1,
};

enum EDMR_BIT {
	EDMR_NBST = 128,
	EDMR_EL = 64,
	EDMR_DL1 = 32,
	EDMR_DL0 = 16,
	EDMR_SRST_GETHER = 3,
	EDMR_SRST_ETHER = 1,
};

enum EDRRR_BIT {
	EDRRR_R = 1,
};

enum EDSR_BIT {
	EDSR_ENT = 1,
	EDSR_ENR = 2,
};

enum EDTRR_BIT {
	EDTRR_TRNS_GETHER = 3,
	EDTRR_TRNS_ETHER = 1,
};

enum EESIPR_BIT {
	EESIPR_TWB1IP = 2147483648,
	EESIPR_TWBIP = 1073741824,
	EESIPR_TC1IP = 536870912,
	EESIPR_TUCIP = 268435456,
	EESIPR_ROCIP = 134217728,
	EESIPR_TABTIP = 67108864,
	EESIPR_RABTIP = 33554432,
	EESIPR_RFCOFIP = 16777216,
	EESIPR_ADEIP = 8388608,
	EESIPR_ECIIP = 4194304,
	EESIPR_FTCIP = 2097152,
	EESIPR_TDEIP = 1048576,
	EESIPR_TFUFIP = 524288,
	EESIPR_FRIP = 262144,
	EESIPR_RDEIP = 131072,
	EESIPR_RFOFIP = 65536,
	EESIPR_CNDIP = 2048,
	EESIPR_DLCIP = 1024,
	EESIPR_CDIP = 512,
	EESIPR_TROIP = 256,
	EESIPR_RMAFIP = 128,
	EESIPR_CEEFIP = 64,
	EESIPR_CELFIP = 32,
	EESIPR_RRFIP = 16,
	EESIPR_RTLFIP = 8,
	EESIPR_RTSFIP = 4,
	EESIPR_PREIP = 2,
	EESIPR_CERFIP = 1,
};

enum EESR_BIT {
	EESR_TWB1 = 2147483648,
	EESR_TWB = 1073741824,
	EESR_TC1 = 536870912,
	EESR_TUC = 268435456,
	EESR_ROC = 134217728,
	EESR_TABT = 67108864,
	EESR_RABT = 33554432,
	EESR_RFRMER = 16777216,
	EESR_ADE = 8388608,
	EESR_ECI = 4194304,
	EESR_FTC = 2097152,
	EESR_TDE = 1048576,
	EESR_TFE = 524288,
	EESR_FRC = 262144,
	EESR_RDE = 131072,
	EESR_RFE = 65536,
	EESR_CND = 2048,
	EESR_DLC = 1024,
	EESR_CD = 512,
	EESR_TRO = 256,
	EESR_RMAF = 128,
	EESR_CEEF = 64,
	EESR_CELF = 32,
	EESR_RRF = 16,
	EESR_RTLF = 8,
	EESR_RTSF = 4,
	EESR_PRE = 2,
	EESR_CERF = 1,
};

enum EIS_BIT {
	EIS_MREF = 1,
	EIS_MTEF = 2,
	EIS_QEF = 4,
	EIS_SEF = 8,
	EIS_CLLF0 = 16,
	EIS_CLLF1 = 32,
	EIS_CULF0 = 64,
	EIS_CULF1 = 128,
	EIS_TFFF = 256,
	EIS_QFS = 65536,
	EIS_RESERVED = 4294899712,
};

enum EXT_INFO_DS_BIT {
	TXC = 16384,
};

enum FCFTR_BIT {
	FCFTR_RFF2 = 262144,
	FCFTR_RFF1 = 131072,
	FCFTR_RFF0 = 65536,
	FCFTR_RFD2 = 4,
	FCFTR_RFD1 = 2,
	FCFTR_RFD0 = 1,
};

enum FW_BOOT_CONTEXT {
	PROBE_CONTEXT = 0,
	OCR_CONTEXT = 1,
};

enum GCCR_BIT {
	GCCR_TCR = 3,
	GCCR_TCR_NOREQ = 0,
	GCCR_TCR_RESET = 1,
	GCCR_TCR_CAPTURE = 3,
	GCCR_LTO = 4,
	GCCR_LTI = 8,
	GCCR_LPTC = 16,
	GCCR_LMTT = 32,
	GCCR_TCSS = 768,
	GCCR_TCSS_GPTP = 0,
	GCCR_TCSS_ADJGPTP = 256,
	GCCR_TCSS_AVTP = 512,
};

enum GECMR_BIT {
	GECMR_10 = 0,
	GECMR_100 = 4,
	GECMR_1000 = 1,
};

enum GECMR_BIT___2 {
	GECMR_SPEED = 1,
	GECMR_SPEED_100 = 0,
	GECMR_SPEED_1000 = 1,
	GBETH_GECMR_SPEED = 48,
	GBETH_GECMR_SPEED_10 = 0,
	GBETH_GECMR_SPEED_100 = 16,
	GBETH_GECMR_SPEED_1000 = 32,
};

enum GIC_BIT {
	GIC_PTCE = 1,
	GIC_PTME = 4,
};

enum GID_BIT {
	GID_PTCD = 1,
	GID_PTOD = 2,
	GID_PTMD0 = 4,
	GID_PTMD1 = 8,
	GID_PTMD2 = 16,
	GID_PTMD3 = 32,
	GID_PTMD4 = 64,
	GID_PTMD5 = 128,
	GID_PTMD6 = 256,
	GID_PTMD7 = 512,
	GID_ATCD0 = 65536,
	GID_ATCD1 = 131072,
	GID_ATCD2 = 262144,
	GID_ATCD3 = 524288,
	GID_ATCD4 = 1048576,
	GID_ATCD5 = 2097152,
	GID_ATCD6 = 4194304,
	GID_ATCD7 = 8388608,
	GID_ATCD8 = 16777216,
	GID_ATCD9 = 33554432,
	GID_ATCD10 = 67108864,
	GID_ATCD11 = 134217728,
	GID_ATCD12 = 268435456,
	GID_ATCD13 = 536870912,
	GID_ATCD14 = 1073741824,
	GID_ATCD15 = 2147483648,
};

enum GIE_BIT {
	GIE_PTCS = 1,
	GIE_PTOS = 2,
	GIE_PTMS0 = 4,
	GIE_PTMS1 = 8,
	GIE_PTMS2 = 16,
	GIE_PTMS3 = 32,
	GIE_PTMS4 = 64,
	GIE_PTMS5 = 128,
	GIE_PTMS6 = 256,
	GIE_PTMS7 = 512,
	GIE_ATCS0 = 65536,
	GIE_ATCS1 = 131072,
	GIE_ATCS2 = 262144,
	GIE_ATCS3 = 524288,
	GIE_ATCS4 = 1048576,
	GIE_ATCS5 = 2097152,
	GIE_ATCS6 = 4194304,
	GIE_ATCS7 = 8388608,
	GIE_ATCS8 = 16777216,
	GIE_ATCS9 = 33554432,
	GIE_ATCS10 = 67108864,
	GIE_ATCS11 = 134217728,
	GIE_ATCS12 = 268435456,
	GIE_ATCS13 = 536870912,
	GIE_ATCS14 = 1073741824,
	GIE_ATCS15 = 2147483648,
};

enum GIS_BIT {
	GIS_PTCF = 1,
	GIS_PTMF = 4,
	GIS_RESERVED = 64512,
};

enum GTI_BIT {
	GTI_TIV = 268435455,
};

enum HCLGE_COMM_API_CAP_BITS {
	HCLGE_COMM_API_CAP_FLEX_RSS_TBL_B = 0,
};

enum HCLGE_COMM_CAP_BITS {
	HCLGE_COMM_CAP_UDP_GSO_B = 0,
	HCLGE_COMM_CAP_QB_B = 1,
	HCLGE_COMM_CAP_FD_FORWARD_TC_B = 2,
	HCLGE_COMM_CAP_PTP_B = 3,
	HCLGE_COMM_CAP_INT_QL_B = 4,
	HCLGE_COMM_CAP_HW_TX_CSUM_B = 5,
	HCLGE_COMM_CAP_TX_PUSH_B = 6,
	HCLGE_COMM_CAP_PHY_IMP_B = 7,
	HCLGE_COMM_CAP_TQP_TXRX_INDEP_B = 8,
	HCLGE_COMM_CAP_HW_PAD_B = 9,
	HCLGE_COMM_CAP_STASH_B = 10,
	HCLGE_COMM_CAP_UDP_TUNNEL_CSUM_B = 11,
	HCLGE_COMM_CAP_RAS_IMP_B = 12,
	HCLGE_COMM_CAP_FEC_B = 13,
	HCLGE_COMM_CAP_PAUSE_B = 14,
	HCLGE_COMM_CAP_RXD_ADV_LAYOUT_B = 15,
	HCLGE_COMM_CAP_PORT_VLAN_BYPASS_B = 17,
	HCLGE_COMM_CAP_CQ_B = 18,
	HCLGE_COMM_CAP_GRO_B = 20,
	HCLGE_COMM_CAP_FD_B = 21,
	HCLGE_COMM_CAP_FEC_STATS_B = 25,
	HCLGE_COMM_CAP_VF_FAULT_B = 26,
	HCLGE_COMM_CAP_LANE_NUM_B = 27,
	HCLGE_COMM_CAP_WOL_B = 28,
	HCLGE_COMM_CAP_TM_FLUSH_B = 31,
	HCLGE_COMM_CAP_ERR_MOD_GEN_REG_B = 32,
};

enum HCLGE_DEV_STATE {
	HCLGE_STATE_REINITING = 0,
	HCLGE_STATE_DOWN = 1,
	HCLGE_STATE_DISABLED = 2,
	HCLGE_STATE_REMOVING = 3,
	HCLGE_STATE_NIC_REGISTERED = 4,
	HCLGE_STATE_ROCE_REGISTERED = 5,
	HCLGE_STATE_SERVICE_INITED = 6,
	HCLGE_STATE_RST_SERVICE_SCHED = 7,
	HCLGE_STATE_RST_HANDLING = 8,
	HCLGE_STATE_MBX_SERVICE_SCHED = 9,
	HCLGE_STATE_MBX_HANDLING = 10,
	HCLGE_STATE_ERR_SERVICE_SCHED = 11,
	HCLGE_STATE_STATISTICS_UPDATING = 12,
	HCLGE_STATE_LINK_UPDATING = 13,
	HCLGE_STATE_RST_FAIL = 14,
	HCLGE_STATE_FD_TBL_CHANGED = 15,
	HCLGE_STATE_FD_CLEAR_ALL = 16,
	HCLGE_STATE_FD_USER_DEF_CHANGED = 17,
	HCLGE_STATE_PTP_EN = 18,
	HCLGE_STATE_PTP_TX_HANDLING = 19,
	HCLGE_STATE_FEC_STATS_UPDATING = 20,
	HCLGE_STATE_MAX = 21,
};

enum HCLGE_FD_ACTION {
	HCLGE_FD_ACTION_SELECT_QUEUE = 0,
	HCLGE_FD_ACTION_DROP_PACKET = 1,
	HCLGE_FD_ACTION_SELECT_TC = 2,
};

enum HCLGE_FD_ACTIVE_RULE_TYPE {
	HCLGE_FD_RULE_NONE = 0,
	HCLGE_FD_ARFS_ACTIVE = 1,
	HCLGE_FD_EP_ACTIVE = 2,
	HCLGE_FD_TC_FLOWER_ACTIVE = 3,
};

enum HCLGE_FD_KEY_OPT {
	KEY_OPT_U8 = 0,
	KEY_OPT_LE16 = 1,
	KEY_OPT_LE32 = 2,
	KEY_OPT_MAC = 3,
	KEY_OPT_IP = 4,
	KEY_OPT_VNI = 5,
};

enum HCLGE_FD_KEY_TYPE {
	HCLGE_FD_KEY_BASE_ON_PTYPE = 0,
	HCLGE_FD_KEY_BASE_ON_TUPLE = 1,
};

enum HCLGE_FD_META_DATA {
	PACKET_TYPE_ID = 0,
	IP_FRAGEMENT = 1,
	ROCE_TYPE = 2,
	NEXT_KEY = 3,
	VLAN_NUMBER = 4,
	SRC_VPORT = 5,
	DST_VPORT = 6,
	TUNNEL_PACKET = 7,
	MAX_META_DATA = 8,
};

enum HCLGE_FD_MODE {
	HCLGE_FD_MODE_DEPTH_2K_WIDTH_400B_STAGE_1 = 0,
	HCLGE_FD_MODE_DEPTH_1K_WIDTH_400B_STAGE_2 = 1,
	HCLGE_FD_MODE_DEPTH_4K_WIDTH_200B_STAGE_1 = 2,
	HCLGE_FD_MODE_DEPTH_2K_WIDTH_200B_STAGE_2 = 3,
};

enum HCLGE_FD_NODE_STATE {
	HCLGE_FD_TO_ADD = 0,
	HCLGE_FD_TO_DEL = 1,
	HCLGE_FD_ACTIVE = 2,
	HCLGE_FD_DELETED = 3,
};

enum HCLGE_FD_PACKET_TYPE {
	NIC_PACKET = 0,
	ROCE_PACKET = 1,
};

enum HCLGE_FD_STAGE {
	HCLGE_FD_STAGE_1 = 0,
	HCLGE_FD_STAGE_2 = 1,
	MAX_STAGE_NUM = 2,
};

enum HCLGE_FD_TUPLE {
	OUTER_DST_MAC = 0,
	OUTER_SRC_MAC = 1,
	OUTER_VLAN_TAG_FST = 2,
	OUTER_VLAN_TAG_SEC = 3,
	OUTER_ETH_TYPE = 4,
	OUTER_L2_RSV = 5,
	OUTER_IP_TOS = 6,
	OUTER_IP_PROTO = 7,
	OUTER_SRC_IP = 8,
	OUTER_DST_IP = 9,
	OUTER_L3_RSV = 10,
	OUTER_SRC_PORT = 11,
	OUTER_DST_PORT = 12,
	OUTER_L4_RSV = 13,
	OUTER_TUN_VNI = 14,
	OUTER_TUN_FLOW_ID = 15,
	INNER_DST_MAC = 16,
	INNER_SRC_MAC = 17,
	INNER_VLAN_TAG_FST = 18,
	INNER_VLAN_TAG_SEC = 19,
	INNER_ETH_TYPE = 20,
	INNER_L2_RSV = 21,
	INNER_IP_TOS = 22,
	INNER_IP_PROTO = 23,
	INNER_SRC_IP = 24,
	INNER_DST_IP = 25,
	INNER_L3_RSV = 26,
	INNER_SRC_PORT = 27,
	INNER_DST_PORT = 28,
	INNER_L4_RSV = 29,
	MAX_TUPLE = 30,
};

enum HCLGE_FD_USER_DEF_LAYER {
	HCLGE_FD_USER_DEF_NONE = 0,
	HCLGE_FD_USER_DEF_L2 = 1,
	HCLGE_FD_USER_DEF_L3 = 2,
	HCLGE_FD_USER_DEF_L4 = 3,
};

enum HCLGE_FIRMWARE_MAC_SPEED {
	HCLGE_FW_MAC_SPEED_1G = 0,
	HCLGE_FW_MAC_SPEED_10G = 1,
	HCLGE_FW_MAC_SPEED_25G = 2,
	HCLGE_FW_MAC_SPEED_40G = 3,
	HCLGE_FW_MAC_SPEED_50G = 4,
	HCLGE_FW_MAC_SPEED_100G = 5,
	HCLGE_FW_MAC_SPEED_10M = 6,
	HCLGE_FW_MAC_SPEED_100M = 7,
	HCLGE_FW_MAC_SPEED_200G = 8,
};

enum HCLGE_MAC_ADDR_TYPE {
	HCLGE_MAC_ADDR_UC = 0,
	HCLGE_MAC_ADDR_MC = 1,
};

enum HCLGE_MAC_DUPLEX {
	HCLGE_MAC_HALF = 0,
	HCLGE_MAC_FULL = 1,
};

enum HCLGE_MAC_NODE_STATE {
	HCLGE_MAC_TO_ADD = 0,
	HCLGE_MAC_TO_DEL = 1,
	HCLGE_MAC_ACTIVE = 2,
};

enum HCLGE_MAC_SPEED {
	HCLGE_MAC_SPEED_UNKNOWN = 0,
	HCLGE_MAC_SPEED_10M = 10,
	HCLGE_MAC_SPEED_100M = 100,
	HCLGE_MAC_SPEED_1G = 1000,
	HCLGE_MAC_SPEED_10G = 10000,
	HCLGE_MAC_SPEED_25G = 25000,
	HCLGE_MAC_SPEED_40G = 40000,
	HCLGE_MAC_SPEED_50G = 50000,
	HCLGE_MAC_SPEED_100G = 100000,
	HCLGE_MAC_SPEED_200G = 200000,
};

enum HCLGE_MBX_OPCODE {
	HCLGE_MBX_RESET = 1,
	HCLGE_MBX_ASSERTING_RESET = 2,
	HCLGE_MBX_SET_UNICAST = 3,
	HCLGE_MBX_SET_MULTICAST = 4,
	HCLGE_MBX_SET_VLAN = 5,
	HCLGE_MBX_MAP_RING_TO_VECTOR = 6,
	HCLGE_MBX_UNMAP_RING_TO_VECTOR = 7,
	HCLGE_MBX_SET_PROMISC_MODE = 8,
	HCLGE_MBX_SET_MACVLAN = 9,
	HCLGE_MBX_API_NEGOTIATE = 10,
	HCLGE_MBX_GET_QINFO = 11,
	HCLGE_MBX_GET_QDEPTH = 12,
	HCLGE_MBX_GET_BASIC_INFO = 13,
	HCLGE_MBX_GET_RETA = 14,
	HCLGE_MBX_GET_RSS_KEY = 15,
	HCLGE_MBX_GET_MAC_ADDR = 16,
	HCLGE_MBX_PF_VF_RESP = 17,
	HCLGE_MBX_GET_BDNUM = 18,
	HCLGE_MBX_GET_BUFSIZE = 19,
	HCLGE_MBX_GET_STREAMID = 20,
	HCLGE_MBX_SET_AESTART = 21,
	HCLGE_MBX_SET_TSOSTATS = 22,
	HCLGE_MBX_LINK_STAT_CHANGE = 23,
	HCLGE_MBX_GET_BASE_CONFIG = 24,
	HCLGE_MBX_BIND_FUNC_QUEUE = 25,
	HCLGE_MBX_GET_LINK_STATUS = 26,
	HCLGE_MBX_QUEUE_RESET = 27,
	HCLGE_MBX_KEEP_ALIVE = 28,
	HCLGE_MBX_SET_ALIVE = 29,
	HCLGE_MBX_SET_MTU = 30,
	HCLGE_MBX_GET_QID_IN_PF = 31,
	HCLGE_MBX_LINK_STAT_MODE = 32,
	HCLGE_MBX_GET_LINK_MODE = 33,
	HCLGE_MBX_PUSH_VLAN_INFO = 34,
	HCLGE_MBX_GET_MEDIA_TYPE = 35,
	HCLGE_MBX_PUSH_PROMISC_INFO = 36,
	HCLGE_MBX_VF_UNINIT = 37,
	HCLGE_MBX_HANDLE_VF_TBL = 38,
	HCLGE_MBX_GET_RING_VECTOR_MAP = 39,
	HCLGE_MBX_GET_VF_FLR_STATUS = 200,
	HCLGE_MBX_PUSH_LINK_STATUS = 201,
	HCLGE_MBX_NCSI_ERROR = 202,
};

enum HCLGE_VPORT_NEED_NOTIFY {
	HCLGE_VPORT_NEED_NOTIFY_RESET = 0,
	HCLGE_VPORT_NEED_NOTIFY_VF_VLAN = 1,
};

enum HCLGE_VPORT_STATE {
	HCLGE_VPORT_STATE_ALIVE = 0,
	HCLGE_VPORT_STATE_MAC_TBL_CHANGE = 1,
	HCLGE_VPORT_STATE_PROMISC_CHANGE = 2,
	HCLGE_VPORT_STATE_VLAN_FLTR_CHANGE = 3,
	HCLGE_VPORT_STATE_INITED = 4,
	HCLGE_VPORT_STATE_MAX = 5,
};

enum HLCGE_PORT_TYPE {
	HOST_PORT = 0,
	NETWORK_PORT = 1,
};

enum HNAE3_DEV_CAP_BITS {
	HNAE3_DEV_SUPPORT_FD_B = 0,
	HNAE3_DEV_SUPPORT_GRO_B = 1,
	HNAE3_DEV_SUPPORT_FEC_B = 2,
	HNAE3_DEV_SUPPORT_UDP_GSO_B = 3,
	HNAE3_DEV_SUPPORT_QB_B = 4,
	HNAE3_DEV_SUPPORT_FD_FORWARD_TC_B = 5,
	HNAE3_DEV_SUPPORT_PTP_B = 6,
	HNAE3_DEV_SUPPORT_INT_QL_B = 7,
	HNAE3_DEV_SUPPORT_HW_TX_CSUM_B = 8,
	HNAE3_DEV_SUPPORT_TX_PUSH_B = 9,
	HNAE3_DEV_SUPPORT_PHY_IMP_B = 10,
	HNAE3_DEV_SUPPORT_TQP_TXRX_INDEP_B = 11,
	HNAE3_DEV_SUPPORT_HW_PAD_B = 12,
	HNAE3_DEV_SUPPORT_STASH_B = 13,
	HNAE3_DEV_SUPPORT_UDP_TUNNEL_CSUM_B = 14,
	HNAE3_DEV_SUPPORT_PAUSE_B = 15,
	HNAE3_DEV_SUPPORT_RAS_IMP_B = 16,
	HNAE3_DEV_SUPPORT_RXD_ADV_LAYOUT_B = 17,
	HNAE3_DEV_SUPPORT_PORT_VLAN_BYPASS_B = 18,
	HNAE3_DEV_SUPPORT_VLAN_FLTR_MDF_B = 19,
	HNAE3_DEV_SUPPORT_MC_MAC_MNG_B = 20,
	HNAE3_DEV_SUPPORT_CQ_B = 21,
	HNAE3_DEV_SUPPORT_FEC_STATS_B = 22,
	HNAE3_DEV_SUPPORT_LANE_NUM_B = 23,
	HNAE3_DEV_SUPPORT_WOL_B = 24,
	HNAE3_DEV_SUPPORT_TM_FLUSH_B = 25,
	HNAE3_DEV_SUPPORT_VF_FAULT_B = 26,
	HNAE3_DEV_SUPPORT_ERR_MOD_GEN_REG_B = 27,
};

enum HNAE3_PF_CAP_BITS {
	HNAE3_PF_SUPPORT_VLAN_FLTR_MDF_B = 0,
};

enum I2C_REGS_OFFSET {
	OFFSET_DATA_PORT = 0,
	OFFSET_SLAVE_ADDR = 1,
	OFFSET_INTR_MASK = 2,
	OFFSET_INTR_STAT = 3,
	OFFSET_CONTROL = 4,
	OFFSET_TRANSFER_LEN = 5,
	OFFSET_TRANSAC_LEN = 6,
	OFFSET_DELAY_LEN = 7,
	OFFSET_TIMING = 8,
	OFFSET_START = 9,
	OFFSET_EXT_CONF = 10,
	OFFSET_FIFO_STAT = 11,
	OFFSET_FIFO_THRESH = 12,
	OFFSET_FIFO_ADDR_CLR = 13,
	OFFSET_IO_CONFIG = 14,
	OFFSET_RSV_DEBUG = 15,
	OFFSET_HS = 16,
	OFFSET_SOFTRESET = 17,
	OFFSET_DCM_EN = 18,
	OFFSET_MULTI_DMA = 19,
	OFFSET_PATH_DIR = 20,
	OFFSET_DEBUGSTAT = 21,
	OFFSET_DEBUGCTRL = 22,
	OFFSET_TRANSFER_LEN_AUX = 23,
	OFFSET_CLOCK_DIV = 24,
	OFFSET_LTIMING = 25,
	OFFSET_SCL_HIGH_LOW_RATIO = 26,
	OFFSET_HS_SCL_HIGH_LOW_RATIO = 27,
	OFFSET_SCL_MIS_COMP_POINT = 28,
	OFFSET_STA_STO_AC_TIMING = 29,
	OFFSET_HS_STA_STO_AC_TIMING = 30,
	OFFSET_SDA_TIMING = 31,
};

enum ISS_BIT {
	ISS_FRS = 1,
	ISS_FTS = 4,
	ISS_ES = 64,
	ISS_MS = 128,
	ISS_TFUS = 256,
	ISS_TFWS = 512,
	ISS_RFWS = 4096,
	ISS_CGIS = 8192,
	ISS_DPS1 = 131072,
	ISS_DPS2 = 262144,
	ISS_DPS3 = 524288,
	ISS_DPS4 = 1048576,
	ISS_DPS5 = 2097152,
	ISS_DPS6 = 4194304,
	ISS_DPS7 = 8388608,
	ISS_DPS8 = 16777216,
	ISS_DPS9 = 33554432,
	ISS_DPS10 = 67108864,
	ISS_DPS11 = 134217728,
	ISS_DPS12 = 268435456,
	ISS_DPS13 = 536870912,
	ISS_DPS14 = 1073741824,
	ISS_DPS15 = 2147483648,
};

enum KTHREAD_BITS {
	KTHREAD_IS_PER_CPU = 0,
	KTHREAD_SHOULD_STOP = 1,
	KTHREAD_SHOULD_PARK = 2,
};

enum LMAC_TYPE {
	BGX_MODE_SGMII = 0,
	BGX_MODE_XAUI = 1,
	BGX_MODE_DXAUI = 1,
	BGX_MODE_RXAUI = 2,
	BGX_MODE_XFI = 3,
	BGX_MODE_XLAUI = 4,
	BGX_MODE_10G_KR = 3,
	BGX_MODE_40G_KR = 4,
	BGX_MODE_RGMII = 5,
	BGX_MODE_QSGMII = 6,
	BGX_MODE_INVALID = 7,
};

enum MAX77686_RTC_OP {
	MAX77686_RTC_WRITE = 0,
	MAX77686_RTC_READ = 1,
};

enum MCAST_MODE {
	MCAST_MODE_REJECT = 0,
	MCAST_MODE_ACCEPT = 1,
	MCAST_MODE_CAM_FILTER = 2,
	RSVD = 3,
};

enum MEGASAS_LD_TARGET_ID_STATUS {
	LD_TARGET_ID_INITIAL = 0,
	LD_TARGET_ID_ACTIVE = 1,
	LD_TARGET_ID_DELETED = 2,
};

enum MEGASAS_OCR_CAUSE {
	FW_FAULT_OCR = 0,
	SCSIIO_TIMEOUT_OCR = 1,
	MFI_IO_TIMEOUT_OCR = 2,
};

enum MFI_CMD_OP {
	MFI_CMD_INIT = 0,
	MFI_CMD_LD_READ = 1,
	MFI_CMD_LD_WRITE = 2,
	MFI_CMD_LD_SCSI_IO = 3,
	MFI_CMD_PD_SCSI_IO = 4,
	MFI_CMD_DCMD = 5,
	MFI_CMD_ABORT = 6,
	MFI_CMD_SMP = 7,
	MFI_CMD_STP = 8,
	MFI_CMD_NVME = 9,
	MFI_CMD_TOOLBOX = 10,
	MFI_CMD_OP_COUNT = 11,
	MFI_CMD_INVALID = 255,
};

enum MFI_STAT {
	MFI_STAT_OK = 0,
	MFI_STAT_INVALID_CMD = 1,
	MFI_STAT_INVALID_DCMD = 2,
	MFI_STAT_INVALID_PARAMETER = 3,
	MFI_STAT_INVALID_SEQUENCE_NUMBER = 4,
	MFI_STAT_ABORT_NOT_POSSIBLE = 5,
	MFI_STAT_APP_HOST_CODE_NOT_FOUND = 6,
	MFI_STAT_APP_IN_USE = 7,
	MFI_STAT_APP_NOT_INITIALIZED = 8,
	MFI_STAT_ARRAY_INDEX_INVALID = 9,
	MFI_STAT_ARRAY_ROW_NOT_EMPTY = 10,
	MFI_STAT_CONFIG_RESOURCE_CONFLICT = 11,
	MFI_STAT_DEVICE_NOT_FOUND = 12,
	MFI_STAT_DRIVE_TOO_SMALL = 13,
	MFI_STAT_FLASH_ALLOC_FAIL = 14,
	MFI_STAT_FLASH_BUSY = 15,
	MFI_STAT_FLASH_ERROR = 16,
	MFI_STAT_FLASH_IMAGE_BAD = 17,
	MFI_STAT_FLASH_IMAGE_INCOMPLETE = 18,
	MFI_STAT_FLASH_NOT_OPEN = 19,
	MFI_STAT_FLASH_NOT_STARTED = 20,
	MFI_STAT_FLUSH_FAILED = 21,
	MFI_STAT_HOST_CODE_NOT_FOUNT = 22,
	MFI_STAT_LD_CC_IN_PROGRESS = 23,
	MFI_STAT_LD_INIT_IN_PROGRESS = 24,
	MFI_STAT_LD_LBA_OUT_OF_RANGE = 25,
	MFI_STAT_LD_MAX_CONFIGURED = 26,
	MFI_STAT_LD_NOT_OPTIMAL = 27,
	MFI_STAT_LD_RBLD_IN_PROGRESS = 28,
	MFI_STAT_LD_RECON_IN_PROGRESS = 29,
	MFI_STAT_LD_WRONG_RAID_LEVEL = 30,
	MFI_STAT_MAX_SPARES_EXCEEDED = 31,
	MFI_STAT_MEMORY_NOT_AVAILABLE = 32,
	MFI_STAT_MFC_HW_ERROR = 33,
	MFI_STAT_NO_HW_PRESENT = 34,
	MFI_STAT_NOT_FOUND = 35,
	MFI_STAT_NOT_IN_ENCL = 36,
	MFI_STAT_PD_CLEAR_IN_PROGRESS = 37,
	MFI_STAT_PD_TYPE_WRONG = 38,
	MFI_STAT_PR_DISABLED = 39,
	MFI_STAT_ROW_INDEX_INVALID = 40,
	MFI_STAT_SAS_CONFIG_INVALID_ACTION = 41,
	MFI_STAT_SAS_CONFIG_INVALID_DATA = 42,
	MFI_STAT_SAS_CONFIG_INVALID_PAGE = 43,
	MFI_STAT_SAS_CONFIG_INVALID_TYPE = 44,
	MFI_STAT_SCSI_DONE_WITH_ERROR = 45,
	MFI_STAT_SCSI_IO_FAILED = 46,
	MFI_STAT_SCSI_RESERVATION_CONFLICT = 47,
	MFI_STAT_SHUTDOWN_FAILED = 48,
	MFI_STAT_TIME_NOT_SET = 49,
	MFI_STAT_WRONG_STATE = 50,
	MFI_STAT_LD_OFFLINE = 51,
	MFI_STAT_PEER_NOTIFICATION_REJECTED = 52,
	MFI_STAT_PEER_NOTIFICATION_FAILED = 53,
	MFI_STAT_RESERVATION_IN_PROGRESS = 54,
	MFI_STAT_I2C_ERRORS_DETECTED = 55,
	MFI_STAT_PCI_ERRORS_DETECTED = 56,
	MFI_STAT_CONFIG_SEQ_MISMATCH = 103,
	MFI_STAT_INVALID_STATUS = 255,
};

enum MR_ADAPTER_TYPE {
	MFI_SERIES = 1,
	THUNDERBOLT_SERIES = 2,
	INVADER_SERIES = 3,
	VENTURA_SERIES = 4,
	AERO_SERIES = 5,
};

enum MR_EVT_CLASS {
	MR_EVT_CLASS_DEBUG = -2,
	MR_EVT_CLASS_PROGRESS = -1,
	MR_EVT_CLASS_INFO = 0,
	MR_EVT_CLASS_WARNING = 1,
	MR_EVT_CLASS_CRITICAL = 2,
	MR_EVT_CLASS_FATAL = 3,
	MR_EVT_CLASS_DEAD = 4,
};

enum MR_EVT_LOCALE {
	MR_EVT_LOCALE_LD = 1,
	MR_EVT_LOCALE_PD = 2,
	MR_EVT_LOCALE_ENCL = 4,
	MR_EVT_LOCALE_BBU = 8,
	MR_EVT_LOCALE_SAS = 16,
	MR_EVT_LOCALE_CTRL = 32,
	MR_EVT_LOCALE_CONFIG = 64,
	MR_EVT_LOCALE_CLUSTER = 128,
	MR_EVT_LOCALE_ALL = 65535,
};

enum MR_FW_CRASH_DUMP_STATE {
	UNAVAILABLE = 0,
	AVAILABLE = 1,
	COPYING = 2,
	COPIED = 3,
	COPY_ERROR = 4,
};

enum MR_LD_QUERY_TYPE {
	MR_LD_QUERY_TYPE_ALL = 0,
	MR_LD_QUERY_TYPE_EXPOSED_TO_HOST = 1,
	MR_LD_QUERY_TYPE_USED_TGT_IDS = 2,
	MR_LD_QUERY_TYPE_CLUSTER_ACCESS = 3,
	MR_LD_QUERY_TYPE_CLUSTER_LOCALE = 4,
};

enum MR_PD_QUERY_TYPE {
	MR_PD_QUERY_TYPE_ALL = 0,
	MR_PD_QUERY_TYPE_STATE = 1,
	MR_PD_QUERY_TYPE_POWER_STATE = 2,
	MR_PD_QUERY_TYPE_MEDIA_TYPE = 3,
	MR_PD_QUERY_TYPE_SPEED = 4,
	MR_PD_QUERY_TYPE_EXPOSED_TO_HOST = 5,
};

enum MR_PD_STATE {
	MR_PD_STATE_UNCONFIGURED_GOOD = 0,
	MR_PD_STATE_UNCONFIGURED_BAD = 1,
	MR_PD_STATE_HOT_SPARE = 2,
	MR_PD_STATE_OFFLINE = 16,
	MR_PD_STATE_FAILED = 17,
	MR_PD_STATE_REBUILD = 20,
	MR_PD_STATE_ONLINE = 24,
	MR_PD_STATE_COPYBACK = 32,
	MR_PD_STATE_SYSTEM = 64,
};

enum MR_PD_TYPE {
	UNKNOWN_DRIVE = 0,
	PARALLEL_SCSI = 1,
	SAS_PD = 2,
	SATA_PD = 3,
	FC_PD = 4,
	NVME_PD = 5,
};

enum MR_PERF_MODE {
	MR_BALANCED_PERF_MODE = 0,
	MR_IOPS_PERF_MODE = 1,
	MR_LATENCY_PERF_MODE = 2,
};

enum MR_RAID_FLAGS_IO_SUB_TYPE {
	MR_RAID_FLAGS_IO_SUB_TYPE_NONE = 0,
	MR_RAID_FLAGS_IO_SUB_TYPE_SYSTEM_PD = 1,
	MR_RAID_FLAGS_IO_SUB_TYPE_RMW_DATA = 2,
	MR_RAID_FLAGS_IO_SUB_TYPE_RMW_P = 3,
	MR_RAID_FLAGS_IO_SUB_TYPE_RMW_Q = 4,
	MR_RAID_FLAGS_IO_SUB_TYPE_CACHE_BYPASS = 6,
	MR_RAID_FLAGS_IO_SUB_TYPE_LDIO_BW_LIMIT = 7,
	MR_RAID_FLAGS_IO_SUB_TYPE_R56_DIV_OFFLOAD = 8,
};

enum MR_RAID_MAP_DESC_TYPE {
	RAID_MAP_DESC_TYPE_DEVHDL_INFO = 0,
	RAID_MAP_DESC_TYPE_TGTID_INFO = 1,
	RAID_MAP_DESC_TYPE_ARRAY_INFO = 2,
	RAID_MAP_DESC_TYPE_SPAN_INFO = 3,
	RAID_MAP_DESC_TYPE_COUNT = 4,
};

enum MR_SCSI_CMD_TYPE {
	READ_WRITE_LDIO = 0,
	NON_READ_WRITE_LDIO = 1,
	READ_WRITE_SYSPDIO = 2,
	NON_READ_WRITE_SYSPDIO = 3,
};

enum MSC_BIT {
	MSC_CRC = 1,
	MSC_RFE = 2,
	MSC_RTSF = 4,
	MSC_RTLF = 8,
	MSC_FRE = 16,
	MSC_CRL = 32,
	MSC_CEEF = 64,
	MSC_MC = 128,
};

enum MT6323_IRQ_STATUS_numbers {
	MT6323_IRQ_STATUS_SPKL_AB = 0,
	MT6323_IRQ_STATUS_SPKL = 1,
	MT6323_IRQ_STATUS_BAT_L = 2,
	MT6323_IRQ_STATUS_BAT_H = 3,
	MT6323_IRQ_STATUS_WATCHDOG = 4,
	MT6323_IRQ_STATUS_PWRKEY = 5,
	MT6323_IRQ_STATUS_THR_L = 6,
	MT6323_IRQ_STATUS_THR_H = 7,
	MT6323_IRQ_STATUS_VBATON_UNDET = 8,
	MT6323_IRQ_STATUS_BVALID_DET = 9,
	MT6323_IRQ_STATUS_CHRDET = 10,
	MT6323_IRQ_STATUS_OV = 11,
	MT6323_IRQ_STATUS_LDO = 16,
	MT6323_IRQ_STATUS_FCHRKEY = 17,
	MT6323_IRQ_STATUS_ACCDET = 18,
	MT6323_IRQ_STATUS_AUDIO = 19,
	MT6323_IRQ_STATUS_RTC = 20,
	MT6323_IRQ_STATUS_VPROC = 21,
	MT6323_IRQ_STATUS_VSYS = 22,
	MT6323_IRQ_STATUS_VPA = 23,
	MT6323_IRQ_STATUS_NR = 24,
};

enum OID {
	OID_id_dsa_with_sha1 = 0,
	OID_id_dsa = 1,
	OID_id_ecPublicKey = 2,
	OID_id_prime192v1 = 3,
	OID_id_prime256v1 = 4,
	OID_id_ecdsa_with_sha1 = 5,
	OID_id_ecdsa_with_sha224 = 6,
	OID_id_ecdsa_with_sha256 = 7,
	OID_id_ecdsa_with_sha384 = 8,
	OID_id_ecdsa_with_sha512 = 9,
	OID_rsaEncryption = 10,
	OID_sha1WithRSAEncryption = 11,
	OID_sha256WithRSAEncryption = 12,
	OID_sha384WithRSAEncryption = 13,
	OID_sha512WithRSAEncryption = 14,
	OID_sha224WithRSAEncryption = 15,
	OID_data = 16,
	OID_signed_data = 17,
	OID_email_address = 18,
	OID_contentType = 19,
	OID_messageDigest = 20,
	OID_signingTime = 21,
	OID_smimeCapabilites = 22,
	OID_smimeAuthenticatedAttrs = 23,
	OID_mskrb5 = 24,
	OID_krb5 = 25,
	OID_krb5u2u = 26,
	OID_msIndirectData = 27,
	OID_msStatementType = 28,
	OID_msSpOpusInfo = 29,
	OID_msPeImageDataObjId = 30,
	OID_msIndividualSPKeyPurpose = 31,
	OID_msOutlookExpress = 32,
	OID_ntlmssp = 33,
	OID_negoex = 34,
	OID_spnego = 35,
	OID_IAKerb = 36,
	OID_PKU2U = 37,
	OID_Scram = 38,
	OID_certAuthInfoAccess = 39,
	OID_sha1 = 40,
	OID_id_ansip384r1 = 41,
	OID_id_ansip521r1 = 42,
	OID_sha256 = 43,
	OID_sha384 = 44,
	OID_sha512 = 45,
	OID_sha224 = 46,
	OID_commonName = 47,
	OID_surname = 48,
	OID_countryName = 49,
	OID_locality = 50,
	OID_stateOrProvinceName = 51,
	OID_organizationName = 52,
	OID_organizationUnitName = 53,
	OID_title = 54,
	OID_description = 55,
	OID_name = 56,
	OID_givenName = 57,
	OID_initials = 58,
	OID_generationalQualifier = 59,
	OID_subjectKeyIdentifier = 60,
	OID_keyUsage = 61,
	OID_subjectAltName = 62,
	OID_issuerAltName = 63,
	OID_basicConstraints = 64,
	OID_crlDistributionPoints = 65,
	OID_certPolicies = 66,
	OID_authorityKeyIdentifier = 67,
	OID_extKeyUsage = 68,
	OID_NetlogonMechanism = 69,
	OID_appleLocalKdcSupported = 70,
	OID_gostCPSignA = 71,
	OID_gostCPSignB = 72,
	OID_gostCPSignC = 73,
	OID_gost2012PKey256 = 74,
	OID_gost2012PKey512 = 75,
	OID_gost2012Digest256 = 76,
	OID_gost2012Digest512 = 77,
	OID_gost2012Signature256 = 78,
	OID_gost2012Signature512 = 79,
	OID_gostTC26Sign256A = 80,
	OID_gostTC26Sign256B = 81,
	OID_gostTC26Sign256C = 82,
	OID_gostTC26Sign256D = 83,
	OID_gostTC26Sign512A = 84,
	OID_gostTC26Sign512B = 85,
	OID_gostTC26Sign512C = 86,
	OID_sm2 = 87,
	OID_sm3 = 88,
	OID_SM2_with_SM3 = 89,
	OID_sm3WithRSAEncryption = 90,
	OID_TPMLoadableKey = 91,
	OID_TPMImportableKey = 92,
	OID_TPMSealedData = 93,
	OID_sha3_256 = 94,
	OID_sha3_384 = 95,
	OID_sha3_512 = 96,
	OID_id_ecdsa_with_sha3_256 = 97,
	OID_id_ecdsa_with_sha3_384 = 98,
	OID_id_ecdsa_with_sha3_512 = 99,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_256 = 100,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_384 = 101,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_512 = 102,
	OID__NR = 103,
};

enum Opt_errors {
	Opt_errors_continue = 0,
	Opt_errors_panic = 1,
};

enum PIR_BIT {
	PIR_MDI = 8,
	PIR_MDO = 4,
	PIR_MMD = 2,
	PIR_MDC = 1,
};

enum PIR_BIT___2 {
	PIR_MDC___2 = 1,
	PIR_MMD___2 = 2,
	PIR_MDO___2 = 4,
	PIR_MDI___2 = 8,
};

enum PSR_BIT {
	PSR_LMON = 1,
};

enum RAVB_QUEUE {
	RAVB_BE = 0,
	RAVB_NC = 1,
};

enum RCR_BIT {
	RCR_EFFS = 1,
	RCR_ENCF = 2,
	RCR_ESF = 12,
	RCR_ETS0 = 16,
	RCR_ETS2 = 32,
	RCR_RFCL = 536805376,
};

enum RD_LEN_BIT {
	RD_RFL = 65535,
	RD_RBL = 4294901760,
};

enum RD_STS_BIT {
	RD_RACT = 2147483648,
	RD_RDLE = 1073741824,
	RD_RFP1 = 536870912,
	RD_RFP0 = 268435456,
	RD_RFE = 134217728,
	RD_RFS10 = 512,
	RD_RFS9 = 256,
	RD_RFS8 = 128,
	RD_RFS7 = 64,
	RD_RFS6 = 32,
	RD_RFS5 = 16,
	RD_RFS4 = 8,
	RD_RFS3 = 4,
	RD_RFS2 = 2,
	RD_RFS1 = 1,
};

enum REGION_TYPE {
	REGION_TYPE_UNUSED = 0,
	REGION_TYPE_SHARED_READ = 1,
	REGION_TYPE_SHARED_WRITE = 2,
	REGION_TYPE_EXCLUSIVE = 3,
};

enum RIC0_BIT {
	RIC0_FRE0 = 1,
	RIC0_FRE1 = 2,
	RIC0_FRE2 = 4,
	RIC0_FRE3 = 8,
	RIC0_FRE4 = 16,
	RIC0_FRE5 = 32,
	RIC0_FRE6 = 64,
	RIC0_FRE7 = 128,
	RIC0_FRE8 = 256,
	RIC0_FRE9 = 512,
	RIC0_FRE10 = 1024,
	RIC0_FRE11 = 2048,
	RIC0_FRE12 = 4096,
	RIC0_FRE13 = 8192,
	RIC0_FRE14 = 16384,
	RIC0_FRE15 = 32768,
	RIC0_FRE16 = 65536,
	RIC0_FRE17 = 131072,
};

enum RIC2_BIT {
	RIC2_QFE0 = 1,
	RIC2_QFE1 = 2,
	RIC2_QFE2 = 4,
	RIC2_QFE3 = 8,
	RIC2_QFE4 = 16,
	RIC2_QFE5 = 32,
	RIC2_QFE6 = 64,
	RIC2_QFE7 = 128,
	RIC2_QFE8 = 256,
	RIC2_QFE9 = 512,
	RIC2_QFE10 = 1024,
	RIC2_QFE11 = 2048,
	RIC2_QFE12 = 4096,
	RIC2_QFE13 = 8192,
	RIC2_QFE14 = 16384,
	RIC2_QFE15 = 32768,
	RIC2_QFE16 = 65536,
	RIC2_QFE17 = 131072,
	RIC2_RFFE = 2147483648,
};

enum RIS0_BIT {
	RIS0_FRF0 = 1,
	RIS0_FRF1 = 2,
	RIS0_FRF2 = 4,
	RIS0_FRF3 = 8,
	RIS0_FRF4 = 16,
	RIS0_FRF5 = 32,
	RIS0_FRF6 = 64,
	RIS0_FRF7 = 128,
	RIS0_FRF8 = 256,
	RIS0_FRF9 = 512,
	RIS0_FRF10 = 1024,
	RIS0_FRF11 = 2048,
	RIS0_FRF12 = 4096,
	RIS0_FRF13 = 8192,
	RIS0_FRF14 = 16384,
	RIS0_FRF15 = 32768,
	RIS0_FRF16 = 65536,
	RIS0_FRF17 = 131072,
	RIS0_RESERVED = 4294705152,
};

enum RIS2_BIT {
	RIS2_QFF0 = 1,
	RIS2_QFF1 = 2,
	RIS2_QFF2 = 4,
	RIS2_QFF3 = 8,
	RIS2_QFF4 = 16,
	RIS2_QFF5 = 32,
	RIS2_QFF6 = 64,
	RIS2_QFF7 = 128,
	RIS2_QFF8 = 256,
	RIS2_QFF9 = 512,
	RIS2_QFF10 = 1024,
	RIS2_QFF11 = 2048,
	RIS2_QFF12 = 4096,
	RIS2_QFF13 = 8192,
	RIS2_QFF14 = 16384,
	RIS2_QFF15 = 32768,
	RIS2_QFF16 = 65536,
	RIS2_QFF17 = 131072,
	RIS2_RFFF = 2147483648,
	RIS2_RESERVED = 2147221504,
};

enum RMCR_BIT {
	RMCR_RNC = 1,
};

enum RX_DS_CC_BIT {
	RX_DS = 4095,
	RX_TR = 4096,
	RX_EI = 8192,
	RX_PS = 49152,
};

enum S2MPU02_reg {
	S2MPU02_REG_ID = 0,
	S2MPU02_REG_INT1 = 1,
	S2MPU02_REG_INT2 = 2,
	S2MPU02_REG_INT3 = 3,
	S2MPU02_REG_INT1M = 4,
	S2MPU02_REG_INT2M = 5,
	S2MPU02_REG_INT3M = 6,
	S2MPU02_REG_ST1 = 7,
	S2MPU02_REG_ST2 = 8,
	S2MPU02_REG_PWRONSRC = 9,
	S2MPU02_REG_OFFSRC = 10,
	S2MPU02_REG_BU_CHG = 11,
	S2MPU02_REG_RTCCTRL = 12,
	S2MPU02_REG_PMCTRL1 = 13,
	S2MPU02_REG_RSVD1 = 14,
	S2MPU02_REG_RSVD2 = 15,
	S2MPU02_REG_RSVD3 = 16,
	S2MPU02_REG_RSVD4 = 17,
	S2MPU02_REG_RSVD5 = 18,
	S2MPU02_REG_RSVD6 = 19,
	S2MPU02_REG_RSVD7 = 20,
	S2MPU02_REG_WRSTEN = 21,
	S2MPU02_REG_RSVD8 = 22,
	S2MPU02_REG_RSVD9 = 23,
	S2MPU02_REG_RSVD10 = 24,
	S2MPU02_REG_B1CTRL1 = 25,
	S2MPU02_REG_B1CTRL2 = 26,
	S2MPU02_REG_B2CTRL1 = 27,
	S2MPU02_REG_B2CTRL2 = 28,
	S2MPU02_REG_B3CTRL1 = 29,
	S2MPU02_REG_B3CTRL2 = 30,
	S2MPU02_REG_B4CTRL1 = 31,
	S2MPU02_REG_B4CTRL2 = 32,
	S2MPU02_REG_B5CTRL1 = 33,
	S2MPU02_REG_B5CTRL2 = 34,
	S2MPU02_REG_B5CTRL3 = 35,
	S2MPU02_REG_B5CTRL4 = 36,
	S2MPU02_REG_B5CTRL5 = 37,
	S2MPU02_REG_B6CTRL1 = 38,
	S2MPU02_REG_B6CTRL2 = 39,
	S2MPU02_REG_B7CTRL1 = 40,
	S2MPU02_REG_B7CTRL2 = 41,
	S2MPU02_REG_RAMP1 = 42,
	S2MPU02_REG_RAMP2 = 43,
	S2MPU02_REG_L1CTRL = 44,
	S2MPU02_REG_L2CTRL1 = 45,
	S2MPU02_REG_L2CTRL2 = 46,
	S2MPU02_REG_L2CTRL3 = 47,
	S2MPU02_REG_L2CTRL4 = 48,
	S2MPU02_REG_L3CTRL = 49,
	S2MPU02_REG_L4CTRL = 50,
	S2MPU02_REG_L5CTRL = 51,
	S2MPU02_REG_L6CTRL = 52,
	S2MPU02_REG_L7CTRL = 53,
	S2MPU02_REG_L8CTRL = 54,
	S2MPU02_REG_L9CTRL = 55,
	S2MPU02_REG_L10CTRL = 56,
	S2MPU02_REG_L11CTRL = 57,
	S2MPU02_REG_L12CTRL = 58,
	S2MPU02_REG_L13CTRL = 59,
	S2MPU02_REG_L14CTRL = 60,
	S2MPU02_REG_L15CTRL = 61,
	S2MPU02_REG_L16CTRL = 62,
	S2MPU02_REG_L17CTRL = 63,
	S2MPU02_REG_L18CTRL = 64,
	S2MPU02_REG_L19CTRL = 65,
	S2MPU02_REG_L20CTRL = 66,
	S2MPU02_REG_L21CTRL = 67,
	S2MPU02_REG_L22CTRL = 68,
	S2MPU02_REG_L23CTRL = 69,
	S2MPU02_REG_L24CTRL = 70,
	S2MPU02_REG_L25CTRL = 71,
	S2MPU02_REG_L26CTRL = 72,
	S2MPU02_REG_L27CTRL = 73,
	S2MPU02_REG_L28CTRL = 74,
	S2MPU02_REG_LDODSCH1 = 75,
	S2MPU02_REG_LDODSCH2 = 76,
	S2MPU02_REG_LDODSCH3 = 77,
	S2MPU02_REG_LDODSCH4 = 78,
	S2MPU02_REG_SELMIF = 79,
	S2MPU02_REG_RSVD11 = 80,
	S2MPU02_REG_RSVD12 = 81,
	S2MPU02_REG_RSVD13 = 82,
	S2MPU02_REG_DVSSEL = 83,
	S2MPU02_REG_DVSPTR = 84,
	S2MPU02_REG_DVSDATA = 85,
};

enum S2MPU02_regulators {
	S2MPU02_LDO1 = 0,
	S2MPU02_LDO2 = 1,
	S2MPU02_LDO3 = 2,
	S2MPU02_LDO4 = 3,
	S2MPU02_LDO5 = 4,
	S2MPU02_LDO6 = 5,
	S2MPU02_LDO7 = 6,
	S2MPU02_LDO8 = 7,
	S2MPU02_LDO9 = 8,
	S2MPU02_LDO10 = 9,
	S2MPU02_LDO11 = 10,
	S2MPU02_LDO12 = 11,
	S2MPU02_LDO13 = 12,
	S2MPU02_LDO14 = 13,
	S2MPU02_LDO15 = 14,
	S2MPU02_LDO16 = 15,
	S2MPU02_LDO17 = 16,
	S2MPU02_LDO18 = 17,
	S2MPU02_LDO19 = 18,
	S2MPU02_LDO20 = 19,
	S2MPU02_LDO21 = 20,
	S2MPU02_LDO22 = 21,
	S2MPU02_LDO23 = 22,
	S2MPU02_LDO24 = 23,
	S2MPU02_LDO25 = 24,
	S2MPU02_LDO26 = 25,
	S2MPU02_LDO27 = 26,
	S2MPU02_LDO28 = 27,
	S2MPU02_BUCK1 = 28,
	S2MPU02_BUCK2 = 29,
	S2MPU02_BUCK3 = 30,
	S2MPU02_BUCK4 = 31,
	S2MPU02_BUCK5 = 32,
	S2MPU02_BUCK6 = 33,
	S2MPU02_BUCK7 = 34,
	S2MPU02_REGULATOR_MAX = 35,
};

enum S2MPU05_reg {
	S2MPU05_REG_ID = 0,
	S2MPU05_REG_INT1 = 1,
	S2MPU05_REG_INT2 = 2,
	S2MPU05_REG_INT3 = 3,
	S2MPU05_REG_INT1M = 4,
	S2MPU05_REG_INT2M = 5,
	S2MPU05_REG_INT3M = 6,
	S2MPU05_REG_ST1 = 7,
	S2MPU05_REG_ST2 = 8,
	S2MPU05_REG_PWRONSRC = 9,
	S2MPU05_REG_OFFSRC = 10,
	S2MPU05_REG_BU_CHG = 11,
	S2MPU05_REG_RTC_BUF = 12,
	S2MPU05_REG_CTRL1 = 13,
	S2MPU05_REG_CTRL2 = 14,
	S2MPU05_REG_ETC_TEST = 15,
	S2MPU05_REG_OTP_ADRL = 16,
	S2MPU05_REG_OTP_ADRH = 17,
	S2MPU05_REG_OTP_DATA = 18,
	S2MPU05_REG_MON1SEL = 19,
	S2MPU05_REG_MON2SEL = 20,
	S2MPU05_REG_CTRL3 = 21,
	S2MPU05_REG_ETC_OTP = 22,
	S2MPU05_REG_UVLO = 23,
	S2MPU05_REG_TIME_CTRL1 = 24,
	S2MPU05_REG_TIME_CTRL2 = 25,
	S2MPU05_REG_B1CTRL1 = 26,
	S2MPU05_REG_B1CTRL2 = 27,
	S2MPU05_REG_B2CTRL1 = 28,
	S2MPU05_REG_B2CTRL2 = 29,
	S2MPU05_REG_B2CTRL3 = 30,
	S2MPU05_REG_B2CTRL4 = 31,
	S2MPU05_REG_B3CTRL1 = 32,
	S2MPU05_REG_B3CTRL2 = 33,
	S2MPU05_REG_B3CTRL3 = 34,
	S2MPU05_REG_B4CTRL1 = 35,
	S2MPU05_REG_B4CTRL2 = 36,
	S2MPU05_REG_B5CTRL1 = 37,
	S2MPU05_REG_B5CTRL2 = 38,
	S2MPU05_REG_BUCK_RAMP = 39,
	S2MPU05_REG_LDO_DVS1 = 40,
	S2MPU05_REG_LDO_DVS9 = 41,
	S2MPU05_REG_LDO_DVS10 = 42,
	S2MPU05_REG_L1CTRL = 43,
	S2MPU05_REG_L2CTRL = 44,
	S2MPU05_REG_L3CTRL = 45,
	S2MPU05_REG_L4CTRL = 46,
	S2MPU05_REG_L5CTRL = 47,
	S2MPU05_REG_L6CTRL = 48,
	S2MPU05_REG_L7CTRL = 49,
	S2MPU05_REG_L8CTRL = 50,
	S2MPU05_REG_L9CTRL1 = 51,
	S2MPU05_REG_L9CTRL2 = 52,
	S2MPU05_REG_L10CTRL = 53,
	S2MPU05_REG_L11CTRL1 = 54,
	S2MPU05_REG_L11CTRL2 = 55,
	S2MPU05_REG_L12CTRL = 56,
	S2MPU05_REG_L13CTRL = 57,
	S2MPU05_REG_L14CTRL = 58,
	S2MPU05_REG_L15CTRL = 59,
	S2MPU05_REG_L16CTRL = 60,
	S2MPU05_REG_L17CTRL1 = 61,
	S2MPU05_REG_L17CTRL2 = 62,
	S2MPU05_REG_L18CTRL1 = 63,
	S2MPU05_REG_L18CTRL2 = 64,
	S2MPU05_REG_L19CTRL = 65,
	S2MPU05_REG_L20CTRL = 66,
	S2MPU05_REG_L21CTRL = 67,
	S2MPU05_REG_L22CTRL = 68,
	S2MPU05_REG_L23CTRL = 69,
	S2MPU05_REG_L24CTRL = 70,
	S2MPU05_REG_L25CTRL = 71,
	S2MPU05_REG_L26CTRL = 72,
	S2MPU05_REG_L27CTRL = 73,
	S2MPU05_REG_L28CTRL = 74,
	S2MPU05_REG_L29CTRL = 75,
	S2MPU05_REG_L30CTRL = 76,
	S2MPU05_REG_L31CTRL = 77,
	S2MPU05_REG_L32CTRL = 78,
	S2MPU05_REG_L33CTRL = 79,
	S2MPU05_REG_L34CTRL = 80,
	S2MPU05_REG_L35CTRL = 81,
	S2MPU05_REG_LDO_DSCH1 = 82,
	S2MPU05_REG_LDO_DSCH2 = 83,
	S2MPU05_REG_LDO_DSCH3 = 84,
	S2MPU05_REG_LDO_DSCH4 = 85,
	S2MPU05_REG_LDO_DSCH5 = 86,
	S2MPU05_REG_LDO_CTRL1 = 87,
	S2MPU05_REG_LDO_CTRL2 = 88,
	S2MPU05_REG_TCXO_CTRL = 89,
	S2MPU05_REG_SELMIF = 90,
};

enum S2MPU05_regulators {
	S2MPU05_LDO1 = 0,
	S2MPU05_LDO2 = 1,
	S2MPU05_LDO3 = 2,
	S2MPU05_LDO4 = 3,
	S2MPU05_LDO5 = 4,
	S2MPU05_LDO6 = 5,
	S2MPU05_LDO7 = 6,
	S2MPU05_LDO8 = 7,
	S2MPU05_LDO9 = 8,
	S2MPU05_LDO10 = 9,
	S2MPU05_LDO11 = 10,
	S2MPU05_LDO12 = 11,
	S2MPU05_LDO13 = 12,
	S2MPU05_LDO14 = 13,
	S2MPU05_LDO15 = 14,
	S2MPU05_LDO16 = 15,
	S2MPU05_LDO17 = 16,
	S2MPU05_LDO18 = 17,
	S2MPU05_LDO19 = 18,
	S2MPU05_LDO20 = 19,
	S2MPU05_LDO21 = 20,
	S2MPU05_LDO22 = 21,
	S2MPU05_LDO23 = 22,
	S2MPU05_LDO24 = 23,
	S2MPU05_LDO25 = 24,
	S2MPU05_LDO26 = 25,
	S2MPU05_LDO27 = 26,
	S2MPU05_LDO28 = 27,
	S2MPU05_LDO29 = 28,
	S2MPU05_LDO30 = 29,
	S2MPU05_LDO31 = 30,
	S2MPU05_LDO32 = 31,
	S2MPU05_LDO33 = 32,
	S2MPU05_LDO34 = 33,
	S2MPU05_LDO35 = 34,
	S2MPU05_BUCK1 = 35,
	S2MPU05_BUCK2 = 36,
	S2MPU05_BUCK3 = 37,
	S2MPU05_BUCK4 = 38,
	S2MPU05_BUCK5 = 39,
	S2MPU05_REGULATOR_MAX = 40,
};

enum SCI_CLKS {
	SCI_FCK = 0,
	SCI_SCK = 1,
	SCI_BRG_INT = 2,
	SCI_SCIF_CLK = 3,
	SCI_NUM_CLKS = 4,
};

enum SHIFT_DIRECTION {
	SHIFT_LEFT = 0,
	SHIFT_RIGHT = 1,
};

enum SS4_PACKET_ID {
	SS4_PACKET_ID_IDLE = 0,
	SS4_PACKET_ID_ONE = 1,
	SS4_PACKET_ID_TWO = 2,
	SS4_PACKET_ID_MULTI = 3,
	SS4_PACKET_ID_STICK = 4,
};

enum TCCR_BIT {
	TCCR_TSRQ0 = 1,
	TCCR_TSRQ1 = 2,
	TCCR_TSRQ2 = 4,
	TCCR_TSRQ3 = 8,
	TCCR_TFEN = 256,
	TCCR_TFR = 512,
};

enum TD_STS_BIT {
	TD_TACT = 2147483648,
	TD_TDLE = 1073741824,
	TD_TFP1 = 536870912,
	TD_TFP0 = 268435456,
	TD_TFE = 134217728,
	TD_TWBI = 67108864,
};

enum TFA2_BIT {
	TFA2_TSV = 65535,
	TFA2_TST = 67043328,
};

enum TGC_BIT {
	TGC_TSM0 = 1,
	TGC_TSM1 = 2,
	TGC_TSM2 = 4,
	TGC_TSM3 = 8,
	TGC_TQP = 48,
	TGC_TQP_NONAVB = 0,
	TGC_TQP_AVBMODE1 = 16,
	TGC_TQP_AVBMODE2 = 48,
	TGC_TBD0 = 768,
	TGC_TBD1 = 12288,
	TGC_TBD2 = 196608,
	TGC_TBD3 = 3145728,
};

enum TIC_BIT {
	TIC_FTE0 = 1,
	TIC_FTE1 = 2,
	TIC_TFUE = 256,
	TIC_TFWE = 512,
};

enum TIS_BIT {
	TIS_FTF0 = 1,
	TIS_FTF1 = 2,
	TIS_TFUF = 256,
	TIS_TFWF = 512,
	TIS_RESERVED = 4293980400,
};

enum TPAUSER_BIT {
	TPAUSER_TPAUSE = 65535,
	TPAUSER_UNLIMITED = 0,
};

enum TPM_OPS_FLAGS {
	TPM_OPS_AUTO_STARTUP = 1,
};

enum TRSCER_BIT {
	TRSCER_CNDCE = 2048,
	TRSCER_DLCCE = 1024,
	TRSCER_CDCE = 512,
	TRSCER_TROCE = 256,
	TRSCER_RMAFCE = 128,
	TRSCER_RRFCE = 16,
	TRSCER_RTLFCE = 8,
	TRSCER_RTSFCE = 4,
	TRSCER_PRECE = 2,
	TRSCER_CERFCE = 1,
};

enum TSR_BIT {
	TSR_CCS0 = 3,
	TSR_CCS1 = 12,
	TSR_TFFL = 1792,
};

enum TSU_ADSBSY_BIT {
	TSU_ADSBSY_0 = 1,
};

enum TSU_FWSLC_BIT {
	TSU_FWSLC_POSTENU = 8192,
	TSU_FWSLC_POSTENL = 4096,
	TSU_FWSLC_CAMSEL03 = 128,
	TSU_FWSLC_CAMSEL02 = 64,
	TSU_FWSLC_CAMSEL01 = 32,
	TSU_FWSLC_CAMSEL00 = 16,
	TSU_FWSLC_CAMSEL13 = 8,
	TSU_FWSLC_CAMSEL12 = 4,
	TSU_FWSLC_CAMSEL11 = 2,
	TSU_FWSLC_CAMSEL10 = 1,
};

enum TX_DS_TAGL_BIT {
	TX_DS = 4095,
	TX_TAGL = 61440,
};

enum TX_FS_TAGL_BIT {
	TX_DS___2 = 4095,
	TX_TAGL___2 = 61440,
};

enum TX_TAGH_TSR_BIT {
	TX_TAGH = 63,
	TX_TSR = 64,
};

enum UART_TX_FLAGS {
	UART_TX_NOSTOP = 1,
};

enum V7_PACKET_ID {
	V7_PACKET_ID_IDLE = 0,
	V7_PACKET_ID_TWO = 1,
	V7_PACKET_ID_MULTI = 2,
	V7_PACKET_ID_NEW = 3,
	V7_PACKET_ID_UNKNOWN = 4,
};

enum _MR_CRASH_BUF_STATUS {
	MR_CRASH_BUF_TURN_OFF = 0,
	MR_CRASH_BUF_TURN_ON = 1,
};

enum __kvm_host_smccc_func {
	__KVM_HOST_SMCCC_FUNC___pkvm_init = 1,
	__KVM_HOST_SMCCC_FUNC___pkvm_create_private_mapping = 2,
	__KVM_HOST_SMCCC_FUNC___pkvm_cpu_set_vector = 3,
	__KVM_HOST_SMCCC_FUNC___kvm_enable_ssbs = 4,
	__KVM_HOST_SMCCC_FUNC___vgic_v3_init_lrs = 5,
	__KVM_HOST_SMCCC_FUNC___vgic_v3_get_gic_config = 6,
	__KVM_HOST_SMCCC_FUNC___pkvm_prot_finalize = 7,
	__KVM_HOST_SMCCC_FUNC___pkvm_host_share_hyp = 8,
	__KVM_HOST_SMCCC_FUNC___pkvm_host_unshare_hyp = 9,
	__KVM_HOST_SMCCC_FUNC___pkvm_host_share_guest = 10,
	__KVM_HOST_SMCCC_FUNC___pkvm_host_unshare_guest = 11,
	__KVM_HOST_SMCCC_FUNC___pkvm_host_relax_perms_guest = 12,
	__KVM_HOST_SMCCC_FUNC___pkvm_host_wrprotect_guest = 13,
	__KVM_HOST_SMCCC_FUNC___pkvm_host_test_clear_young_guest = 14,
	__KVM_HOST_SMCCC_FUNC___pkvm_host_mkyoung_guest = 15,
	__KVM_HOST_SMCCC_FUNC___kvm_adjust_pc = 16,
	__KVM_HOST_SMCCC_FUNC___kvm_vcpu_run = 17,
	__KVM_HOST_SMCCC_FUNC___kvm_flush_vm_context = 18,
	__KVM_HOST_SMCCC_FUNC___kvm_tlb_flush_vmid_ipa = 19,
	__KVM_HOST_SMCCC_FUNC___kvm_tlb_flush_vmid_ipa_nsh = 20,
	__KVM_HOST_SMCCC_FUNC___kvm_tlb_flush_vmid = 21,
	__KVM_HOST_SMCCC_FUNC___kvm_tlb_flush_vmid_range = 22,
	__KVM_HOST_SMCCC_FUNC___kvm_flush_cpu_context = 23,
	__KVM_HOST_SMCCC_FUNC___kvm_timer_set_cntvoff = 24,
	__KVM_HOST_SMCCC_FUNC___vgic_v3_save_vmcr_aprs = 25,
	__KVM_HOST_SMCCC_FUNC___vgic_v3_restore_vmcr_aprs = 26,
	__KVM_HOST_SMCCC_FUNC___pkvm_init_vm = 27,
	__KVM_HOST_SMCCC_FUNC___pkvm_init_vcpu = 28,
	__KVM_HOST_SMCCC_FUNC___pkvm_teardown_vm = 29,
	__KVM_HOST_SMCCC_FUNC___pkvm_vcpu_load = 30,
	__KVM_HOST_SMCCC_FUNC___pkvm_vcpu_put = 31,
	__KVM_HOST_SMCCC_FUNC___pkvm_tlb_flush_vmid = 32,
};

enum __sk_action {
	__SK_DROP = 0,
	__SK_PASS = 1,
	__SK_REDIRECT = 2,
	__SK_NONE = 3,
};

enum _dsm_op_index {
	HNS_OP_RESET_FUNC = 1,
	HNS_OP_SERDES_LP_FUNC = 2,
	HNS_OP_LED_SET_FUNC = 3,
	HNS_OP_GET_PORT_TYPE_FUNC = 4,
	HNS_OP_GET_SFP_STAT_FUNC = 5,
	HNS_OP_LOCATE_LED_SET_FUNC = 6,
};

enum _dsm_rst_type {
	HNS_DSAF_RESET_FUNC = 1,
	HNS_PPE_RESET_FUNC = 2,
	HNS_XGE_RESET_FUNC = 4,
	HNS_GE_RESET_FUNC = 5,
	HNS_DSAF_CHN_RESET_FUNC = 6,
	HNS_ROCE_RESET_FUNC = 7,
};

enum _pmux_input {
	SMUX_INDEX = 0,
	PLL_INDEX = 1,
	ACD_INDEX = 2,
	ALT_INDEX = 3,
	NUM_OF_PMUX_INPUTS = 4,
};

enum _slab_flag_bits {
	_SLAB_CONSISTENCY_CHECKS = 0,
	_SLAB_RED_ZONE = 1,
	_SLAB_POISON = 2,
	_SLAB_KMALLOC = 3,
	_SLAB_HWCACHE_ALIGN = 4,
	_SLAB_CACHE_DMA = 5,
	_SLAB_CACHE_DMA32 = 6,
	_SLAB_STORE_USER = 7,
	_SLAB_PANIC = 8,
	_SLAB_TYPESAFE_BY_RCU = 9,
	_SLAB_TRACE = 10,
	_SLAB_NOLEAKTRACE = 11,
	_SLAB_NO_MERGE = 12,
	_SLAB_ACCOUNT = 13,
	_SLAB_NO_USER_FLAGS = 14,
	_SLAB_RECLAIM_ACCOUNT = 15,
	_SLAB_OBJECT_POISON = 16,
	_SLAB_CMPXCHG_DOUBLE = 17,
	_SLAB_NO_OBJ_EXT = 18,
	_SLAB_FLAGS_LAST_BIT = 19,
};

enum aarch32_map {
	AA32_MAP_VECTORS = 0,
	AA32_MAP_SIGPAGE = 1,
	AA32_MAP_VDSO = 2,
};

enum aarch64_insn_adr_type {
	AARCH64_INSN_ADR_TYPE_ADRP = 0,
	AARCH64_INSN_ADR_TYPE_ADR = 1,
};

enum aarch64_insn_adsb_type {
	AARCH64_INSN_ADSB_ADD = 0,
	AARCH64_INSN_ADSB_SUB = 1,
	AARCH64_INSN_ADSB_ADD_SETFLAGS = 2,
	AARCH64_INSN_ADSB_SUB_SETFLAGS = 3,
};

enum aarch64_insn_bitfield_type {
	AARCH64_INSN_BITFIELD_MOVE = 0,
	AARCH64_INSN_BITFIELD_MOVE_UNSIGNED = 1,
	AARCH64_INSN_BITFIELD_MOVE_SIGNED = 2,
};

enum aarch64_insn_branch_type {
	AARCH64_INSN_BRANCH_NOLINK = 0,
	AARCH64_INSN_BRANCH_LINK = 1,
	AARCH64_INSN_BRANCH_RETURN = 2,
	AARCH64_INSN_BRANCH_COMP_ZERO = 3,
	AARCH64_INSN_BRANCH_COMP_NONZERO = 4,
};

enum aarch64_insn_condition {
	AARCH64_INSN_COND_EQ = 0,
	AARCH64_INSN_COND_NE = 1,
	AARCH64_INSN_COND_CS = 2,
	AARCH64_INSN_COND_CC = 3,
	AARCH64_INSN_COND_MI = 4,
	AARCH64_INSN_COND_PL = 5,
	AARCH64_INSN_COND_VS = 6,
	AARCH64_INSN_COND_VC = 7,
	AARCH64_INSN_COND_HI = 8,
	AARCH64_INSN_COND_LS = 9,
	AARCH64_INSN_COND_GE = 10,
	AARCH64_INSN_COND_LT = 11,
	AARCH64_INSN_COND_GT = 12,
	AARCH64_INSN_COND_LE = 13,
	AARCH64_INSN_COND_AL = 14,
};

enum aarch64_insn_data1_type {
	AARCH64_INSN_DATA1_REVERSE_16 = 0,
	AARCH64_INSN_DATA1_REVERSE_32 = 1,
	AARCH64_INSN_DATA1_REVERSE_64 = 2,
};

enum aarch64_insn_data2_type {
	AARCH64_INSN_DATA2_UDIV = 0,
	AARCH64_INSN_DATA2_SDIV = 1,
	AARCH64_INSN_DATA2_LSLV = 2,
	AARCH64_INSN_DATA2_LSRV = 3,
	AARCH64_INSN_DATA2_ASRV = 4,
	AARCH64_INSN_DATA2_RORV = 5,
};

enum aarch64_insn_data3_type {
	AARCH64_INSN_DATA3_MADD = 0,
	AARCH64_INSN_DATA3_MSUB = 1,
};

enum aarch64_insn_hint_cr_op {
	AARCH64_INSN_HINT_NOP = 0,
	AARCH64_INSN_HINT_YIELD = 32,
	AARCH64_INSN_HINT_WFE = 64,
	AARCH64_INSN_HINT_WFI = 96,
	AARCH64_INSN_HINT_SEV = 128,
	AARCH64_INSN_HINT_SEVL = 160,
	AARCH64_INSN_HINT_XPACLRI = 224,
	AARCH64_INSN_HINT_PACIA_1716 = 256,
	AARCH64_INSN_HINT_PACIB_1716 = 320,
	AARCH64_INSN_HINT_AUTIA_1716 = 384,
	AARCH64_INSN_HINT_AUTIB_1716 = 448,
	AARCH64_INSN_HINT_PACIAZ = 768,
	AARCH64_INSN_HINT_PACIASP = 800,
	AARCH64_INSN_HINT_PACIBZ = 832,
	AARCH64_INSN_HINT_PACIBSP = 864,
	AARCH64_INSN_HINT_AUTIAZ = 896,
	AARCH64_INSN_HINT_AUTIASP = 928,
	AARCH64_INSN_HINT_AUTIBZ = 960,
	AARCH64_INSN_HINT_AUTIBSP = 992,
	AARCH64_INSN_HINT_ESB = 512,
	AARCH64_INSN_HINT_PSB = 544,
	AARCH64_INSN_HINT_TSB = 576,
	AARCH64_INSN_HINT_CSDB = 640,
	AARCH64_INSN_HINT_CLEARBHB = 704,
	AARCH64_INSN_HINT_BTI = 1024,
	AARCH64_INSN_HINT_BTIC = 1088,
	AARCH64_INSN_HINT_BTIJ = 1152,
	AARCH64_INSN_HINT_BTIJC = 1216,
};

enum aarch64_insn_imm_type {
	AARCH64_INSN_IMM_ADR = 0,
	AARCH64_INSN_IMM_26 = 1,
	AARCH64_INSN_IMM_19 = 2,
	AARCH64_INSN_IMM_16 = 3,
	AARCH64_INSN_IMM_14 = 4,
	AARCH64_INSN_IMM_12 = 5,
	AARCH64_INSN_IMM_9 = 6,
	AARCH64_INSN_IMM_7 = 7,
	AARCH64_INSN_IMM_6 = 8,
	AARCH64_INSN_IMM_S = 9,
	AARCH64_INSN_IMM_R = 10,
	AARCH64_INSN_IMM_N = 11,
	AARCH64_INSN_IMM_MAX = 12,
};

enum aarch64_insn_ldst_type {
	AARCH64_INSN_LDST_LOAD_REG_OFFSET = 0,
	AARCH64_INSN_LDST_STORE_REG_OFFSET = 1,
	AARCH64_INSN_LDST_LOAD_IMM_OFFSET = 2,
	AARCH64_INSN_LDST_STORE_IMM_OFFSET = 3,
	AARCH64_INSN_LDST_LOAD_PAIR_PRE_INDEX = 4,
	AARCH64_INSN_LDST_STORE_PAIR_PRE_INDEX = 5,
	AARCH64_INSN_LDST_LOAD_PAIR_POST_INDEX = 6,
	AARCH64_INSN_LDST_STORE_PAIR_POST_INDEX = 7,
	AARCH64_INSN_LDST_LOAD_ACQ = 8,
	AARCH64_INSN_LDST_LOAD_EX = 9,
	AARCH64_INSN_LDST_LOAD_ACQ_EX = 10,
	AARCH64_INSN_LDST_STORE_REL = 11,
	AARCH64_INSN_LDST_STORE_EX = 12,
	AARCH64_INSN_LDST_STORE_REL_EX = 13,
	AARCH64_INSN_LDST_SIGNED_LOAD_IMM_OFFSET = 14,
	AARCH64_INSN_LDST_SIGNED_LOAD_REG_OFFSET = 15,
};

enum aarch64_insn_logic_type {
	AARCH64_INSN_LOGIC_AND = 0,
	AARCH64_INSN_LOGIC_BIC = 1,
	AARCH64_INSN_LOGIC_ORR = 2,
	AARCH64_INSN_LOGIC_ORN = 3,
	AARCH64_INSN_LOGIC_EOR = 4,
	AARCH64_INSN_LOGIC_EON = 5,
	AARCH64_INSN_LOGIC_AND_SETFLAGS = 6,
	AARCH64_INSN_LOGIC_BIC_SETFLAGS = 7,
};

enum aarch64_insn_mb_type {
	AARCH64_INSN_MB_SY = 0,
	AARCH64_INSN_MB_ST = 1,
	AARCH64_INSN_MB_LD = 2,
	AARCH64_INSN_MB_ISH = 3,
	AARCH64_INSN_MB_ISHST = 4,
	AARCH64_INSN_MB_ISHLD = 5,
	AARCH64_INSN_MB_NSH = 6,
	AARCH64_INSN_MB_NSHST = 7,
	AARCH64_INSN_MB_NSHLD = 8,
	AARCH64_INSN_MB_OSH = 9,
	AARCH64_INSN_MB_OSHST = 10,
	AARCH64_INSN_MB_OSHLD = 11,
};

enum aarch64_insn_mem_atomic_op {
	AARCH64_INSN_MEM_ATOMIC_ADD = 0,
	AARCH64_INSN_MEM_ATOMIC_CLR = 1,
	AARCH64_INSN_MEM_ATOMIC_EOR = 2,
	AARCH64_INSN_MEM_ATOMIC_SET = 3,
	AARCH64_INSN_MEM_ATOMIC_SWP = 4,
};

enum aarch64_insn_mem_order_type {
	AARCH64_INSN_MEM_ORDER_NONE = 0,
	AARCH64_INSN_MEM_ORDER_ACQ = 1,
	AARCH64_INSN_MEM_ORDER_REL = 2,
	AARCH64_INSN_MEM_ORDER_ACQREL = 3,
};

enum aarch64_insn_movewide_type {
	AARCH64_INSN_MOVEWIDE_ZERO = 0,
	AARCH64_INSN_MOVEWIDE_KEEP = 1,
	AARCH64_INSN_MOVEWIDE_INVERSE = 2,
};

enum aarch64_insn_movw_imm_type {
	AARCH64_INSN_IMM_MOVNZ = 0,
	AARCH64_INSN_IMM_MOVKZ = 1,
};

enum aarch64_insn_register {
	AARCH64_INSN_REG_0 = 0,
	AARCH64_INSN_REG_1 = 1,
	AARCH64_INSN_REG_2 = 2,
	AARCH64_INSN_REG_3 = 3,
	AARCH64_INSN_REG_4 = 4,
	AARCH64_INSN_REG_5 = 5,
	AARCH64_INSN_REG_6 = 6,
	AARCH64_INSN_REG_7 = 7,
	AARCH64_INSN_REG_8 = 8,
	AARCH64_INSN_REG_9 = 9,
	AARCH64_INSN_REG_10 = 10,
	AARCH64_INSN_REG_11 = 11,
	AARCH64_INSN_REG_12 = 12,
	AARCH64_INSN_REG_13 = 13,
	AARCH64_INSN_REG_14 = 14,
	AARCH64_INSN_REG_15 = 15,
	AARCH64_INSN_REG_16 = 16,
	AARCH64_INSN_REG_17 = 17,
	AARCH64_INSN_REG_18 = 18,
	AARCH64_INSN_REG_19 = 19,
	AARCH64_INSN_REG_20 = 20,
	AARCH64_INSN_REG_21 = 21,
	AARCH64_INSN_REG_22 = 22,
	AARCH64_INSN_REG_23 = 23,
	AARCH64_INSN_REG_24 = 24,
	AARCH64_INSN_REG_25 = 25,
	AARCH64_INSN_REG_26 = 26,
	AARCH64_INSN_REG_27 = 27,
	AARCH64_INSN_REG_28 = 28,
	AARCH64_INSN_REG_29 = 29,
	AARCH64_INSN_REG_FP = 29,
	AARCH64_INSN_REG_30 = 30,
	AARCH64_INSN_REG_LR = 30,
	AARCH64_INSN_REG_ZR = 31,
	AARCH64_INSN_REG_SP = 31,
};

enum aarch64_insn_register_type {
	AARCH64_INSN_REGTYPE_RT = 0,
	AARCH64_INSN_REGTYPE_RN = 1,
	AARCH64_INSN_REGTYPE_RT2 = 2,
	AARCH64_INSN_REGTYPE_RM = 3,
	AARCH64_INSN_REGTYPE_RD = 4,
	AARCH64_INSN_REGTYPE_RA = 5,
	AARCH64_INSN_REGTYPE_RS = 6,
};

enum aarch64_insn_size_type {
	AARCH64_INSN_SIZE_8 = 0,
	AARCH64_INSN_SIZE_16 = 1,
	AARCH64_INSN_SIZE_32 = 2,
	AARCH64_INSN_SIZE_64 = 3,
};

enum aarch64_insn_special_register {
	AARCH64_INSN_SPCLREG_SPSR_EL1 = 49664,
	AARCH64_INSN_SPCLREG_ELR_EL1 = 49665,
	AARCH64_INSN_SPCLREG_SP_EL0 = 49672,
	AARCH64_INSN_SPCLREG_SPSEL = 49680,
	AARCH64_INSN_SPCLREG_CURRENTEL = 49682,
	AARCH64_INSN_SPCLREG_DAIF = 55825,
	AARCH64_INSN_SPCLREG_NZCV = 55824,
	AARCH64_INSN_SPCLREG_FPCR = 55840,
	AARCH64_INSN_SPCLREG_DSPSR_EL0 = 55848,
	AARCH64_INSN_SPCLREG_DLR_EL0 = 55849,
	AARCH64_INSN_SPCLREG_SPSR_EL2 = 57856,
	AARCH64_INSN_SPCLREG_ELR_EL2 = 57857,
	AARCH64_INSN_SPCLREG_SP_EL1 = 57864,
	AARCH64_INSN_SPCLREG_SPSR_INQ = 57880,
	AARCH64_INSN_SPCLREG_SPSR_ABT = 57881,
	AARCH64_INSN_SPCLREG_SPSR_UND = 57882,
	AARCH64_INSN_SPCLREG_SPSR_FIQ = 57883,
	AARCH64_INSN_SPCLREG_SPSR_EL3 = 61952,
	AARCH64_INSN_SPCLREG_ELR_EL3 = 61953,
	AARCH64_INSN_SPCLREG_SP_EL2 = 61968,
};

enum aarch64_insn_system_register {
	AARCH64_INSN_SYSREG_TPIDR_EL1 = 18052,
	AARCH64_INSN_SYSREG_TPIDR_EL2 = 26242,
	AARCH64_INSN_SYSREG_SP_EL0 = 16904,
};

enum aarch64_insn_variant {
	AARCH64_INSN_VARIANT_32BIT = 0,
	AARCH64_INSN_VARIANT_64BIT = 1,
};

enum aarch64_regset {
	REGSET_GPR = 0,
	REGSET_FPR = 1,
	REGSET_TLS = 2,
	REGSET_HW_BREAK = 3,
	REGSET_HW_WATCH = 4,
	REGSET_FPMR = 5,
	REGSET_SYSTEM_CALL = 6,
	REGSET_SVE = 7,
	REGSET_SSVE = 8,
	REGSET_ZA = 9,
	REGSET_ZT = 10,
	REGSET_PAC_MASK = 11,
	REGSET_PAC_ENABLED_KEYS = 12,
	REGSET_TAGGED_ADDR_CTRL = 13,
	REGSET_POE = 14,
};

enum aarch64_reloc_op {
	RELOC_OP_NONE = 0,
	RELOC_OP_ABS = 1,
	RELOC_OP_PREL = 2,
	RELOC_OP_PAGE = 3,
};

enum access_coordinate_class {
	ACCESS_COORDINATE_LOCAL = 0,
	ACCESS_COORDINATE_CPU = 1,
	ACCESS_COORDINATE_MAX = 2,
};

enum acpi_attr_enum {
	ACPI_ATTR_LABEL_SHOW = 0,
	ACPI_ATTR_INDEX_SHOW = 1,
};

enum acpi_bridge_type {
	ACPI_BRIDGE_TYPE_PCIE = 1,
	ACPI_BRIDGE_TYPE_CXL = 2,
};

enum acpi_bus_device_type {
	ACPI_BUS_TYPE_DEVICE = 0,
	ACPI_BUS_TYPE_POWER = 1,
	ACPI_BUS_TYPE_PROCESSOR = 2,
	ACPI_BUS_TYPE_THERMAL = 3,
	ACPI_BUS_TYPE_POWER_BUTTON = 4,
	ACPI_BUS_TYPE_SLEEP_BUTTON = 5,
	ACPI_BUS_TYPE_ECDT_EC = 6,
	ACPI_BUS_DEVICE_TYPE_COUNT = 7,
};

enum acpi_cdat_type {
	ACPI_CDAT_TYPE_DSMAS = 0,
	ACPI_CDAT_TYPE_DSLBIS = 1,
	ACPI_CDAT_TYPE_DSMSCIS = 2,
	ACPI_CDAT_TYPE_DSIS = 3,
	ACPI_CDAT_TYPE_DSEMTS = 4,
	ACPI_CDAT_TYPE_SSLBIS = 5,
	ACPI_CDAT_TYPE_RESERVED = 6,
};

enum acpi_cedt_type {
	ACPI_CEDT_TYPE_CHBS = 0,
	ACPI_CEDT_TYPE_CFMWS = 1,
	ACPI_CEDT_TYPE_CXIMS = 2,
	ACPI_CEDT_TYPE_RDPAS = 3,
	ACPI_CEDT_TYPE_RESERVED = 4,
};

enum acpi_device_swnode_dev_props {
	ACPI_DEVICE_SWNODE_DEV_ROTATION = 0,
	ACPI_DEVICE_SWNODE_DEV_CLOCK_FREQUENCY = 1,
	ACPI_DEVICE_SWNODE_DEV_LED_MAX_MICROAMP = 2,
	ACPI_DEVICE_SWNODE_DEV_FLASH_MAX_MICROAMP = 3,
	ACPI_DEVICE_SWNODE_DEV_FLASH_MAX_TIMEOUT_US = 4,
	ACPI_DEVICE_SWNODE_DEV_NUM_OF = 5,
	ACPI_DEVICE_SWNODE_DEV_NUM_ENTRIES = 6,
};

enum acpi_device_swnode_ep_props {
	ACPI_DEVICE_SWNODE_EP_REMOTE_EP = 0,
	ACPI_DEVICE_SWNODE_EP_BUS_TYPE = 1,
	ACPI_DEVICE_SWNODE_EP_REG = 2,
	ACPI_DEVICE_SWNODE_EP_CLOCK_LANES = 3,
	ACPI_DEVICE_SWNODE_EP_DATA_LANES = 4,
	ACPI_DEVICE_SWNODE_EP_LANE_POLARITIES = 5,
	ACPI_DEVICE_SWNODE_EP_LINK_FREQUENCIES = 6,
	ACPI_DEVICE_SWNODE_EP_NUM_OF = 7,
	ACPI_DEVICE_SWNODE_EP_NUM_ENTRIES = 8,
};

enum acpi_device_swnode_port_props {
	ACPI_DEVICE_SWNODE_PORT_REG = 0,
	ACPI_DEVICE_SWNODE_PORT_NUM_OF = 1,
	ACPI_DEVICE_SWNODE_PORT_NUM_ENTRIES = 2,
};

enum acpi_einj_actions {
	ACPI_EINJ_BEGIN_OPERATION = 0,
	ACPI_EINJ_GET_TRIGGER_TABLE = 1,
	ACPI_EINJ_SET_ERROR_TYPE = 2,
	ACPI_EINJ_GET_ERROR_TYPE = 3,
	ACPI_EINJ_END_OPERATION = 4,
	ACPI_EINJ_EXECUTE_OPERATION = 5,
	ACPI_EINJ_CHECK_BUSY_STATUS = 6,
	ACPI_EINJ_GET_COMMAND_STATUS = 7,
	ACPI_EINJ_SET_ERROR_TYPE_WITH_ADDRESS = 8,
	ACPI_EINJ_GET_EXECUTE_TIMINGS = 9,
	ACPI_EINJV2_GET_ERROR_TYPE = 17,
	ACPI_EINJ_ACTION_RESERVED = 18,
	ACPI_EINJ_TRIGGER_ERROR = 255,
};

enum acpi_einj_instructions {
	ACPI_EINJ_READ_REGISTER = 0,
	ACPI_EINJ_READ_REGISTER_VALUE = 1,
	ACPI_EINJ_WRITE_REGISTER = 2,
	ACPI_EINJ_WRITE_REGISTER_VALUE = 3,
	ACPI_EINJ_NOOP = 4,
	ACPI_EINJ_FLUSH_CACHELINE = 5,
	ACPI_EINJ_INSTRUCTION_RESERVED = 6,
};

enum acpi_erst_actions {
	ACPI_ERST_BEGIN_WRITE = 0,
	ACPI_ERST_BEGIN_READ = 1,
	ACPI_ERST_BEGIN_CLEAR = 2,
	ACPI_ERST_END = 3,
	ACPI_ERST_SET_RECORD_OFFSET = 4,
	ACPI_ERST_EXECUTE_OPERATION = 5,
	ACPI_ERST_CHECK_BUSY_STATUS = 6,
	ACPI_ERST_GET_COMMAND_STATUS = 7,
	ACPI_ERST_GET_RECORD_ID = 8,
	ACPI_ERST_SET_RECORD_ID = 9,
	ACPI_ERST_GET_RECORD_COUNT = 10,
	ACPI_ERST_BEGIN_DUMMY_WRIITE = 11,
	ACPI_ERST_NOT_USED = 12,
	ACPI_ERST_GET_ERROR_RANGE = 13,
	ACPI_ERST_GET_ERROR_LENGTH = 14,
	ACPI_ERST_GET_ERROR_ATTRIBUTES = 15,
	ACPI_ERST_EXECUTE_TIMINGS = 16,
	ACPI_ERST_ACTION_RESERVED = 17,
};

enum acpi_erst_instructions {
	ACPI_ERST_READ_REGISTER = 0,
	ACPI_ERST_READ_REGISTER_VALUE = 1,
	ACPI_ERST_WRITE_REGISTER = 2,
	ACPI_ERST_WRITE_REGISTER_VALUE = 3,
	ACPI_ERST_NOOP = 4,
	ACPI_ERST_LOAD_VAR1 = 5,
	ACPI_ERST_LOAD_VAR2 = 6,
	ACPI_ERST_STORE_VAR1 = 7,
	ACPI_ERST_ADD = 8,
	ACPI_ERST_SUBTRACT = 9,
	ACPI_ERST_ADD_VALUE = 10,
	ACPI_ERST_SUBTRACT_VALUE = 11,
	ACPI_ERST_STALL = 12,
	ACPI_ERST_STALL_WHILE_TRUE = 13,
	ACPI_ERST_SKIP_NEXT_IF_TRUE = 14,
	ACPI_ERST_GOTO = 15,
	ACPI_ERST_SET_SRC_ADDRESS_BASE = 16,
	ACPI_ERST_SET_DST_ADDRESS_BASE = 17,
	ACPI_ERST_MOVE_DATA = 18,
	ACPI_ERST_INSTRUCTION_RESERVED = 19,
};

enum acpi_gpio_ignore_list {
	ACPI_GPIO_IGNORE_WAKE = 0,
	ACPI_GPIO_IGNORE_INTERRUPT = 1,
};

enum acpi_gtdt_type {
	ACPI_GTDT_TYPE_TIMER_BLOCK = 0,
	ACPI_GTDT_TYPE_WATCHDOG = 1,
	ACPI_GTDT_TYPE_RESERVED = 2,
};

enum acpi_hest_notify_types {
	ACPI_HEST_NOTIFY_POLLED = 0,
	ACPI_HEST_NOTIFY_EXTERNAL = 1,
	ACPI_HEST_NOTIFY_LOCAL = 2,
	ACPI_HEST_NOTIFY_SCI = 3,
	ACPI_HEST_NOTIFY_NMI = 4,
	ACPI_HEST_NOTIFY_CMCI = 5,
	ACPI_HEST_NOTIFY_MCE = 6,
	ACPI_HEST_NOTIFY_GPIO = 7,
	ACPI_HEST_NOTIFY_SEA = 8,
	ACPI_HEST_NOTIFY_SEI = 9,
	ACPI_HEST_NOTIFY_GSIV = 10,
	ACPI_HEST_NOTIFY_SOFTWARE_DELEGATED = 11,
	ACPI_HEST_NOTIFY_RESERVED = 12,
};

enum acpi_hest_types {
	ACPI_HEST_TYPE_IA32_CHECK = 0,
	ACPI_HEST_TYPE_IA32_CORRECTED_CHECK = 1,
	ACPI_HEST_TYPE_IA32_NMI = 2,
	ACPI_HEST_TYPE_NOT_USED3 = 3,
	ACPI_HEST_TYPE_NOT_USED4 = 4,
	ACPI_HEST_TYPE_NOT_USED5 = 5,
	ACPI_HEST_TYPE_AER_ROOT_PORT = 6,
	ACPI_HEST_TYPE_AER_ENDPOINT = 7,
	ACPI_HEST_TYPE_AER_BRIDGE = 8,
	ACPI_HEST_TYPE_GENERIC_ERROR = 9,
	ACPI_HEST_TYPE_GENERIC_ERROR_V2 = 10,
	ACPI_HEST_TYPE_IA32_DEFERRED_CHECK = 11,
	ACPI_HEST_TYPE_RESERVED = 12,
};

enum acpi_hmat_type {
	ACPI_HMAT_TYPE_PROXIMITY = 0,
	ACPI_HMAT_TYPE_LOCALITY = 1,
	ACPI_HMAT_TYPE_CACHE = 2,
	ACPI_HMAT_TYPE_RESERVED = 3,
};

enum acpi_iort_node_type {
	ACPI_IORT_NODE_ITS_GROUP = 0,
	ACPI_IORT_NODE_NAMED_COMPONENT = 1,
	ACPI_IORT_NODE_PCI_ROOT_COMPLEX = 2,
	ACPI_IORT_NODE_SMMU = 3,
	ACPI_IORT_NODE_SMMU_V3 = 4,
	ACPI_IORT_NODE_PMCG = 5,
	ACPI_IORT_NODE_RMR = 6,
};

enum acpi_irq_model_id {
	ACPI_IRQ_MODEL_PIC = 0,
	ACPI_IRQ_MODEL_IOAPIC = 1,
	ACPI_IRQ_MODEL_IOSAPIC = 2,
	ACPI_IRQ_MODEL_PLATFORM = 3,
	ACPI_IRQ_MODEL_GIC = 4,
	ACPI_IRQ_MODEL_LPIC = 5,
	ACPI_IRQ_MODEL_RINTC = 6,
	ACPI_IRQ_MODEL_COUNT = 7,
};

enum acpi_madt_gic_version {
	ACPI_MADT_GIC_VERSION_NONE = 0,
	ACPI_MADT_GIC_VERSION_V1 = 1,
	ACPI_MADT_GIC_VERSION_V2 = 2,
	ACPI_MADT_GIC_VERSION_V3 = 3,
	ACPI_MADT_GIC_VERSION_V4 = 4,
	ACPI_MADT_GIC_VERSION_RESERVED = 5,
};

enum acpi_madt_multiproc_wakeup_version {
	ACPI_MADT_MP_WAKEUP_VERSION_NONE = 0,
	ACPI_MADT_MP_WAKEUP_VERSION_V1 = 1,
	ACPI_MADT_MP_WAKEUP_VERSION_RESERVED = 2,
};

enum acpi_madt_type {
	ACPI_MADT_TYPE_LOCAL_APIC = 0,
	ACPI_MADT_TYPE_IO_APIC = 1,
	ACPI_MADT_TYPE_INTERRUPT_OVERRIDE = 2,
	ACPI_MADT_TYPE_NMI_SOURCE = 3,
	ACPI_MADT_TYPE_LOCAL_APIC_NMI = 4,
	ACPI_MADT_TYPE_LOCAL_APIC_OVERRIDE = 5,
	ACPI_MADT_TYPE_IO_SAPIC = 6,
	ACPI_MADT_TYPE_LOCAL_SAPIC = 7,
	ACPI_MADT_TYPE_INTERRUPT_SOURCE = 8,
	ACPI_MADT_TYPE_LOCAL_X2APIC = 9,
	ACPI_MADT_TYPE_LOCAL_X2APIC_NMI = 10,
	ACPI_MADT_TYPE_GENERIC_INTERRUPT = 11,
	ACPI_MADT_TYPE_GENERIC_DISTRIBUTOR = 12,
	ACPI_MADT_TYPE_GENERIC_MSI_FRAME = 13,
	ACPI_MADT_TYPE_GENERIC_REDISTRIBUTOR = 14,
	ACPI_MADT_TYPE_GENERIC_TRANSLATOR = 15,
	ACPI_MADT_TYPE_MULTIPROC_WAKEUP = 16,
	ACPI_MADT_TYPE_CORE_PIC = 17,
	ACPI_MADT_TYPE_LIO_PIC = 18,
	ACPI_MADT_TYPE_HT_PIC = 19,
	ACPI_MADT_TYPE_EIO_PIC = 20,
	ACPI_MADT_TYPE_MSI_PIC = 21,
	ACPI_MADT_TYPE_BIO_PIC = 22,
	ACPI_MADT_TYPE_LPC_PIC = 23,
	ACPI_MADT_TYPE_RINTC = 24,
	ACPI_MADT_TYPE_IMSIC = 25,
	ACPI_MADT_TYPE_APLIC = 26,
	ACPI_MADT_TYPE_PLIC = 27,
	ACPI_MADT_TYPE_RESERVED = 28,
	ACPI_MADT_TYPE_OEM_RESERVED = 128,
};

enum acpi_pcct_type {
	ACPI_PCCT_TYPE_GENERIC_SUBSPACE = 0,
	ACPI_PCCT_TYPE_HW_REDUCED_SUBSPACE = 1,
	ACPI_PCCT_TYPE_HW_REDUCED_SUBSPACE_TYPE2 = 2,
	ACPI_PCCT_TYPE_EXT_PCC_MASTER_SUBSPACE = 3,
	ACPI_PCCT_TYPE_EXT_PCC_SLAVE_SUBSPACE = 4,
	ACPI_PCCT_TYPE_HW_REG_COMM_SUBSPACE = 5,
	ACPI_PCCT_TYPE_RESERVED = 6,
};

enum acpi_pptt_type {
	ACPI_PPTT_TYPE_PROCESSOR = 0,
	ACPI_PPTT_TYPE_CACHE = 1,
	ACPI_PPTT_TYPE_ID = 2,
	ACPI_PPTT_TYPE_RESERVED = 3,
};

enum acpi_predicate {
	all_versions = 0,
	less_than_or_equal = 1,
	equal = 2,
	greater_than_or_equal = 3,
};

enum acpi_reconfig_event {
	ACPI_RECONFIG_DEVICE_ADD = 0,
	ACPI_RECONFIG_DEVICE_REMOVE = 1,
};

enum acpi_return_package_types {
	ACPI_PTYPE1_FIXED = 1,
	ACPI_PTYPE1_VAR = 2,
	ACPI_PTYPE1_OPTION = 3,
	ACPI_PTYPE2 = 4,
	ACPI_PTYPE2_COUNT = 5,
	ACPI_PTYPE2_PKG_COUNT = 6,
	ACPI_PTYPE2_FIXED = 7,
	ACPI_PTYPE2_MIN = 8,
	ACPI_PTYPE2_REV_FIXED = 9,
	ACPI_PTYPE2_FIX_VAR = 10,
	ACPI_PTYPE2_VAR_VAR = 11,
	ACPI_PTYPE2_UUID_PAIR = 12,
	ACPI_PTYPE_CUSTOM = 13,
};

enum acpi_srat_type {
	ACPI_SRAT_TYPE_CPU_AFFINITY = 0,
	ACPI_SRAT_TYPE_MEMORY_AFFINITY = 1,
	ACPI_SRAT_TYPE_X2APIC_CPU_AFFINITY = 2,
	ACPI_SRAT_TYPE_GICC_AFFINITY = 3,
	ACPI_SRAT_TYPE_GIC_ITS_AFFINITY = 4,
	ACPI_SRAT_TYPE_GENERIC_AFFINITY = 5,
	ACPI_SRAT_TYPE_GENERIC_PORT_AFFINITY = 6,
	ACPI_SRAT_TYPE_RINTC_AFFINITY = 7,
	ACPI_SRAT_TYPE_RESERVED = 8,
};

enum acpi_subtable_type {
	ACPI_SUBTABLE_COMMON = 0,
	ACPI_SUBTABLE_HMAT = 1,
	ACPI_SUBTABLE_PRMT = 2,
	ACPI_SUBTABLE_CEDT = 3,
	CDAT_SUBTABLE = 4,
};

enum actions {
	REGISTER = 0,
	DEREGISTER = 1,
	CPU_DONT_CARE = 2,
};

enum ahci_qoriq_type {
	AHCI_LS1021A = 0,
	AHCI_LS1028A = 1,
	AHCI_LS1043A = 2,
	AHCI_LS2080A = 3,
	AHCI_LS1046A = 4,
	AHCI_LS1088A = 5,
	AHCI_LS2088A = 6,
	AHCI_LX2160A = 7,
};

enum alarmtimer_type {
	ALARM_REALTIME = 0,
	ALARM_BOOTTIME = 1,
	ALARM_NUMTYPE = 2,
	ALARM_REALTIME_FREEZER = 3,
	ALARM_BOOTTIME_FREEZER = 4,
};

enum ale_fields {
	MINOR_VER = 0,
	MAJOR_VER = 1,
	ALE_ENTRIES = 2,
	ALE_POLICERS = 3,
	POL_PORT_MEN = 4,
	POL_TRUNK_ID = 5,
	POL_PORT_NUM = 6,
	POL_PRI_MEN = 7,
	POL_PRI_VAL = 8,
	POL_OUI_MEN = 9,
	POL_OUI_INDEX = 10,
	POL_DST_MEN = 11,
	POL_DST_INDEX = 12,
	POL_SRC_MEN = 13,
	POL_SRC_INDEX = 14,
	POL_OVLAN_MEN = 15,
	POL_OVLAN_INDEX = 16,
	POL_IVLAN_MEN = 17,
	POL_IVLAN_INDEX = 18,
	POL_ETHERTYPE_MEN = 19,
	POL_ETHERTYPE_INDEX = 20,
	POL_IPSRC_MEN = 21,
	POL_IPSRC_INDEX = 22,
	POL_IPDST_MEN = 23,
	POL_IPDST_INDEX = 24,
	POL_EN = 25,
	POL_RED_DROP_EN = 26,
	POL_YELLOW_DROP_EN = 27,
	POL_YELLOW_THRESH = 28,
	POL_POL_MATCH_MODE = 29,
	POL_PRIORITY_THREAD_EN = 30,
	POL_MAC_ONLY_DEF_DIS = 31,
	POL_TEST_CLR = 32,
	POL_TEST_CLR_RED = 33,
	POL_TEST_CLR_YELLOW = 34,
	POL_TEST_CLR_SELECTED = 35,
	POL_TEST_ENTRY = 36,
	POL_STATUS_HIT = 37,
	POL_STATUS_HIT_RED = 38,
	POL_STATUS_HIT_YELLOW = 39,
	ALE_DEFAULT_THREAD_EN = 40,
	ALE_DEFAULT_THREAD_VAL = 41,
	ALE_THREAD_CLASS_INDEX = 42,
	ALE_THREAD_ENABLE = 43,
	ALE_THREAD_VALUE = 44,
	ALE_FIELDS_MAX = 45,
};

enum altera_pcie_version {
	ALTERA_PCIE_V1 = 0,
	ALTERA_PCIE_V2 = 1,
	ALTERA_PCIE_V3 = 2,
};

enum am65_cpsw_tx_buf_type {
	AM65_CPSW_TX_BUF_TYPE_SKB = 0,
	AM65_CPSW_TX_BUF_TYPE_XDP_TX = 1,
	AM65_CPSW_TX_BUF_TYPE_XDP_NDO = 2,
};

enum aml_pinconf_drv {
	PINCONF_DRV_500UA = 0,
	PINCONF_DRV_2500UA = 1,
	PINCONF_DRV_3000UA = 2,
	PINCONF_DRV_4000UA = 3,
};

enum aqr_fw_src {
	AQR_FW_SRC_NVMEM = 0,
	AQR_FW_SRC_FS = 1,
};

enum arch_timer_erratum_match_type {
	ate_match_dt = 0,
	ate_match_local_cap_id = 1,
	ate_match_acpi_oem_info = 2,
};

enum arch_timer_ppi_nr {
	ARCH_TIMER_PHYS_SECURE_PPI = 0,
	ARCH_TIMER_PHYS_NONSECURE_PPI = 1,
	ARCH_TIMER_VIRT_PPI = 2,
	ARCH_TIMER_HYP_PPI = 3,
	ARCH_TIMER_HYP_VIRT_PPI = 4,
	ARCH_TIMER_MAX_TIMER_PPI = 5,
};

enum arch_timer_reg {
	ARCH_TIMER_REG_CTRL = 0,
	ARCH_TIMER_REG_CVAL = 1,
};

enum arch_timer_spi_nr {
	ARCH_TIMER_PHYS_SPI = 0,
	ARCH_TIMER_VIRT_SPI = 1,
	ARCH_TIMER_MAX_TIMER_SPI = 2,
};

enum arm64_bp_harden_el1_vectors {
	EL1_VECTOR_BHB_LOOP = 0,
	EL1_VECTOR_BHB_FW = 1,
	EL1_VECTOR_BHB_CLEAR_INSN = 2,
	EL1_VECTOR_KPTI = 3,
};

enum arm64_hyp_spectre_vector {
	HYP_VECTOR_DIRECT = 0,
	HYP_VECTOR_SPECTRE_DIRECT = 1,
	HYP_VECTOR_INDIRECT = 2,
	HYP_VECTOR_SPECTRE_INDIRECT = 3,
};

enum arm_smccc_conduit {
	SMCCC_CONDUIT_NONE = 0,
	SMCCC_CONDUIT_SMC = 1,
	SMCCC_CONDUIT_HVC = 2,
};

enum arm_smmu_arch_version {
	ARM_SMMU_V1 = 0,
	ARM_SMMU_V1_64K = 1,
	ARM_SMMU_V2 = 2,
};

enum arm_smmu_cbar_type {
	CBAR_TYPE_S2_TRANS = 0,
	CBAR_TYPE_S1_TRANS_S2_BYPASS = 1,
	CBAR_TYPE_S1_TRANS_S2_FAULT = 2,
	CBAR_TYPE_S1_TRANS_S2_TRANS = 3,
};

enum arm_smmu_context_fmt {
	ARM_SMMU_CTX_FMT_NONE = 0,
	ARM_SMMU_CTX_FMT_AARCH64 = 1,
	ARM_SMMU_CTX_FMT_AARCH32_L = 2,
	ARM_SMMU_CTX_FMT_AARCH32_S = 3,
};

enum arm_smmu_domain_stage {
	ARM_SMMU_DOMAIN_S1 = 0,
	ARM_SMMU_DOMAIN_S2 = 1,
};

enum arm_smmu_domain_stage___2 {
	ARM_SMMU_DOMAIN_S1___2 = 0,
	ARM_SMMU_DOMAIN_S2___2 = 1,
	ARM_SMMU_DOMAIN_NESTED = 2,
};

enum arm_smmu_implementation {
	GENERIC_SMMU = 0,
	ARM_MMU500 = 1,
	CAVIUM_SMMUV2 = 2,
	QCOM_SMMUV2 = 3,
};

enum arm_smmu_msi_index {
	EVTQ_MSI_INDEX = 0,
	GERROR_MSI_INDEX = 1,
	PRIQ_MSI_INDEX = 2,
	ARM_SMMU_MAX_MSIS = 3,
};

enum arm_smmu_s2cr_privcfg {
	S2CR_PRIVCFG_DEFAULT = 0,
	S2CR_PRIVCFG_DIPAN = 1,
	S2CR_PRIVCFG_UNPRIV = 2,
	S2CR_PRIVCFG_PRIV = 3,
};

enum arm_smmu_s2cr_type {
	S2CR_TYPE_TRANS = 0,
	S2CR_TYPE_BYPASS = 1,
	S2CR_TYPE_FAULT = 2,
};

enum armpmu_attr_groups {
	ARMPMU_ATTR_GROUP_COMMON = 0,
	ARMPMU_ATTR_GROUP_EVENTS = 1,
	ARMPMU_ATTR_GROUP_FORMATS = 2,
	ARMPMU_ATTR_GROUP_CAPS = 3,
	ARMPMU_NR_ATTR_GROUPS = 4,
};

enum asn1_class {
	ASN1_UNIV = 0,
	ASN1_APPL = 1,
	ASN1_CONT = 2,
	ASN1_PRIV = 3,
};

enum asn1_method {
	ASN1_PRIM = 0,
	ASN1_CONS = 1,
};

enum asn1_opcode {
	ASN1_OP_MATCH = 0,
	ASN1_OP_MATCH_OR_SKIP = 1,
	ASN1_OP_MATCH_ACT = 2,
	ASN1_OP_MATCH_ACT_OR_SKIP = 3,
	ASN1_OP_MATCH_JUMP = 4,
	ASN1_OP_MATCH_JUMP_OR_SKIP = 5,
	ASN1_OP_MATCH_ANY = 8,
	ASN1_OP_MATCH_ANY_OR_SKIP = 9,
	ASN1_OP_MATCH_ANY_ACT = 10,
	ASN1_OP_MATCH_ANY_ACT_OR_SKIP = 11,
	ASN1_OP_COND_MATCH_OR_SKIP = 17,
	ASN1_OP_COND_MATCH_ACT_OR_SKIP = 19,
	ASN1_OP_COND_MATCH_JUMP_OR_SKIP = 21,
	ASN1_OP_COND_MATCH_ANY = 24,
	ASN1_OP_COND_MATCH_ANY_OR_SKIP = 25,
	ASN1_OP_COND_MATCH_ANY_ACT = 26,
	ASN1_OP_COND_MATCH_ANY_ACT_OR_SKIP = 27,
	ASN1_OP_COND_FAIL = 28,
	ASN1_OP_COMPLETE = 29,
	ASN1_OP_ACT = 30,
	ASN1_OP_MAYBE_ACT = 31,
	ASN1_OP_END_SEQ = 32,
	ASN1_OP_END_SET = 33,
	ASN1_OP_END_SEQ_OF = 34,
	ASN1_OP_END_SET_OF = 35,
	ASN1_OP_END_SEQ_ACT = 36,
	ASN1_OP_END_SET_ACT = 37,
	ASN1_OP_END_SEQ_OF_ACT = 38,
	ASN1_OP_END_SET_OF_ACT = 39,
	ASN1_OP_RETURN = 40,
	ASN1_OP__NR = 41,
};

enum asn1_tag {
	ASN1_EOC = 0,
	ASN1_BOOL = 1,
	ASN1_INT = 2,
	ASN1_BTS = 3,
	ASN1_OTS = 4,
	ASN1_NULL = 5,
	ASN1_OID = 6,
	ASN1_ODE = 7,
	ASN1_EXT = 8,
	ASN1_REAL = 9,
	ASN1_ENUM = 10,
	ASN1_EPDV = 11,
	ASN1_UTF8STR = 12,
	ASN1_RELOID = 13,
	ASN1_SEQ = 16,
	ASN1_SET = 17,
	ASN1_NUMSTR = 18,
	ASN1_PRNSTR = 19,
	ASN1_TEXSTR = 20,
	ASN1_VIDSTR = 21,
	ASN1_IA5STR = 22,
	ASN1_UNITIM = 23,
	ASN1_GENTIM = 24,
	ASN1_GRASTR = 25,
	ASN1_VISSTR = 26,
	ASN1_GENSTR = 27,
	ASN1_UNISTR = 28,
	ASN1_CHRSTR = 29,
	ASN1_BMPSTR = 30,
	ASN1_LONG_TAG = 31,
};

enum asp_netfilt_reg_type {
	ASP_NETFILT_MATCH = 0,
	ASP_NETFILT_MASK = 1,
	ASP_NETFILT_MAX = 2,
};

enum asp_rx_filter_id {
	ASP_RX_FILTER_MDA_PROMISC = 0,
	ASP_RX_FILTER_MDA_ALLMULTI = 1,
	ASP_RX_FILTER_MDA_BROADCAST = 2,
	ASP_RX_FILTER_MDA_OWN_ADDR = 3,
	ASP_RX_FILTER_MDA_RES_MAX = 4,
};

enum asp_rx_net_filter_block {
	ASP_RX_FILTER_NET_L2 = 0,
	ASP_RX_FILTER_NET_L3_0 = 1,
	ASP_RX_FILTER_NET_L3_1 = 2,
	ASP_RX_FILTER_NET_L4 = 3,
	ASP_RX_FILTER_NET_BLOCK_MAX = 4,
};

enum assoc_array_walk_status {
	assoc_array_walk_tree_empty = 0,
	assoc_array_walk_found_terminal_node = 1,
	assoc_array_walk_found_wrong_shortcut = 2,
};

enum asymmetric_payload_bits {
	asym_crypto = 0,
	asym_subtype = 1,
	asym_key_ids = 2,
	asym_auth = 3,
};

enum ata_completion_errors {
	AC_ERR_OK = 0,
	AC_ERR_DEV = 1,
	AC_ERR_HSM = 2,
	AC_ERR_TIMEOUT = 4,
	AC_ERR_MEDIA = 8,
	AC_ERR_ATA_BUS = 16,
	AC_ERR_HOST_BUS = 32,
	AC_ERR_SYSTEM = 64,
	AC_ERR_INVALID = 128,
	AC_ERR_OTHER = 256,
	AC_ERR_NODEV_HINT = 512,
	AC_ERR_NCQ = 1024,
};

enum ata_dev_iter_mode {
	ATA_DITER_ENABLED = 0,
	ATA_DITER_ENABLED_REVERSE = 1,
	ATA_DITER_ALL = 2,
	ATA_DITER_ALL_REVERSE = 3,
};

enum ata_link_iter_mode {
	ATA_LITER_EDGE = 0,
	ATA_LITER_HOST_FIRST = 1,
	ATA_LITER_PMP_FIRST = 2,
};

enum ata_lpm_hints {
	ATA_LPM_EMPTY = 1,
	ATA_LPM_HIPM = 2,
	ATA_LPM_WAKE_ONLY = 4,
};

enum ata_lpm_policy {
	ATA_LPM_UNKNOWN = 0,
	ATA_LPM_MAX_POWER = 1,
	ATA_LPM_MED_POWER = 2,
	ATA_LPM_MED_POWER_WITH_DIPM = 3,
	ATA_LPM_MIN_POWER_WITH_PARTIAL = 4,
	ATA_LPM_MIN_POWER = 5,
};

enum ata_prot_flags {
	ATA_PROT_FLAG_PIO = 1,
	ATA_PROT_FLAG_DMA = 2,
	ATA_PROT_FLAG_NCQ = 4,
	ATA_PROT_FLAG_ATAPI = 8,
	ATA_PROT_UNKNOWN = 255,
	ATA_PROT_NODATA = 0,
	ATA_PROT_PIO = 1,
	ATA_PROT_DMA = 2,
	ATA_PROT_NCQ_NODATA = 4,
	ATA_PROT_NCQ = 6,
	ATAPI_PROT_NODATA = 8,
	ATAPI_PROT_PIO = 9,
	ATAPI_PROT_DMA = 10,
};

enum ata_quirks {
	__ATA_QUIRK_DIAGNOSTIC = 0,
	__ATA_QUIRK_NODMA = 1,
	__ATA_QUIRK_NONCQ = 2,
	__ATA_QUIRK_MAX_SEC_128 = 3,
	__ATA_QUIRK_BROKEN_HPA = 4,
	__ATA_QUIRK_DISABLE = 5,
	__ATA_QUIRK_HPA_SIZE = 6,
	__ATA_QUIRK_IVB = 7,
	__ATA_QUIRK_STUCK_ERR = 8,
	__ATA_QUIRK_BRIDGE_OK = 9,
	__ATA_QUIRK_ATAPI_MOD16_DMA = 10,
	__ATA_QUIRK_FIRMWARE_WARN = 11,
	__ATA_QUIRK_1_5_GBPS = 12,
	__ATA_QUIRK_NOSETXFER = 13,
	__ATA_QUIRK_BROKEN_FPDMA_AA = 14,
	__ATA_QUIRK_DUMP_ID = 15,
	__ATA_QUIRK_MAX_SEC_LBA48 = 16,
	__ATA_QUIRK_ATAPI_DMADIR = 17,
	__ATA_QUIRK_NO_NCQ_TRIM = 18,
	__ATA_QUIRK_NOLPM = 19,
	__ATA_QUIRK_WD_BROKEN_LPM = 20,
	__ATA_QUIRK_ZERO_AFTER_TRIM = 21,
	__ATA_QUIRK_NO_DMA_LOG = 22,
	__ATA_QUIRK_NOTRIM = 23,
	__ATA_QUIRK_MAX_SEC_1024 = 24,
	__ATA_QUIRK_MAX_TRIM_128M = 25,
	__ATA_QUIRK_NO_NCQ_ON_ATI = 26,
	__ATA_QUIRK_NO_LPM_ON_ATI = 27,
	__ATA_QUIRK_NO_ID_DEV_LOG = 28,
	__ATA_QUIRK_NO_LOG_DIR = 29,
	__ATA_QUIRK_NO_FUA = 30,
	__ATA_QUIRK_MAX = 31,
};

enum ata_xfer_mask {
	ATA_MASK_PIO = 127,
	ATA_MASK_MWDMA = 3968,
	ATA_MASK_UDMA = 1044480,
};

enum attr_idn {
	QUERY_ATTR_IDN_BOOT_LU_EN = 0,
	QUERY_ATTR_IDN_MAX_HPB_SINGLE_CMD = 1,
	QUERY_ATTR_IDN_POWER_MODE = 2,
	QUERY_ATTR_IDN_ACTIVE_ICC_LVL = 3,
	QUERY_ATTR_IDN_OOO_DATA_EN = 4,
	QUERY_ATTR_IDN_BKOPS_STATUS = 5,
	QUERY_ATTR_IDN_PURGE_STATUS = 6,
	QUERY_ATTR_IDN_MAX_DATA_IN = 7,
	QUERY_ATTR_IDN_MAX_DATA_OUT = 8,
	QUERY_ATTR_IDN_DYN_CAP_NEEDED = 9,
	QUERY_ATTR_IDN_REF_CLK_FREQ = 10,
	QUERY_ATTR_IDN_CONF_DESC_LOCK = 11,
	QUERY_ATTR_IDN_MAX_NUM_OF_RTT = 12,
	QUERY_ATTR_IDN_EE_CONTROL = 13,
	QUERY_ATTR_IDN_EE_STATUS = 14,
	QUERY_ATTR_IDN_SECONDS_PASSED = 15,
	QUERY_ATTR_IDN_CNTX_CONF = 16,
	QUERY_ATTR_IDN_CORR_PRG_BLK_NUM = 17,
	QUERY_ATTR_IDN_RESERVED2 = 18,
	QUERY_ATTR_IDN_RESERVED3 = 19,
	QUERY_ATTR_IDN_FFU_STATUS = 20,
	QUERY_ATTR_IDN_PSA_STATE = 21,
	QUERY_ATTR_IDN_PSA_DATA_SIZE = 22,
	QUERY_ATTR_IDN_REF_CLK_GATING_WAIT_TIME = 23,
	QUERY_ATTR_IDN_CASE_ROUGH_TEMP = 24,
	QUERY_ATTR_IDN_HIGH_TEMP_BOUND = 25,
	QUERY_ATTR_IDN_LOW_TEMP_BOUND = 26,
	QUERY_ATTR_IDN_WB_FLUSH_STATUS = 28,
	QUERY_ATTR_IDN_AVAIL_WB_BUFF_SIZE = 29,
	QUERY_ATTR_IDN_WB_BUFF_LIFE_TIME_EST = 30,
	QUERY_ATTR_IDN_CURR_WB_BUFF_SIZE = 31,
	QUERY_ATTR_IDN_TIMESTAMP = 48,
	QUERY_ATTR_IDN_DEV_LVL_EXCEPTION_ID = 52,
	QUERY_ATTR_IDN_WB_BUF_RESIZE_HINT = 60,
	QUERY_ATTR_IDN_WB_BUF_RESIZE_EN = 61,
	QUERY_ATTR_IDN_WB_BUF_RESIZE_STATUS = 62,
};

enum audit_nfcfgop {
	AUDIT_XT_OP_REGISTER = 0,
	AUDIT_XT_OP_REPLACE = 1,
	AUDIT_XT_OP_UNREGISTER = 2,
	AUDIT_NFT_OP_TABLE_REGISTER = 3,
	AUDIT_NFT_OP_TABLE_UNREGISTER = 4,
	AUDIT_NFT_OP_CHAIN_REGISTER = 5,
	AUDIT_NFT_OP_CHAIN_UNREGISTER = 6,
	AUDIT_NFT_OP_RULE_REGISTER = 7,
	AUDIT_NFT_OP_RULE_UNREGISTER = 8,
	AUDIT_NFT_OP_SET_REGISTER = 9,
	AUDIT_NFT_OP_SET_UNREGISTER = 10,
	AUDIT_NFT_OP_SETELEM_REGISTER = 11,
	AUDIT_NFT_OP_SETELEM_UNREGISTER = 12,
	AUDIT_NFT_OP_GEN_REGISTER = 13,
	AUDIT_NFT_OP_OBJ_REGISTER = 14,
	AUDIT_NFT_OP_OBJ_UNREGISTER = 15,
	AUDIT_NFT_OP_OBJ_RESET = 16,
	AUDIT_NFT_OP_FLOWTABLE_REGISTER = 17,
	AUDIT_NFT_OP_FLOWTABLE_UNREGISTER = 18,
	AUDIT_NFT_OP_SETELEM_RESET = 19,
	AUDIT_NFT_OP_RULE_RESET = 20,
	AUDIT_NFT_OP_INVALID = 21,
};

enum audit_nlgrps {
	AUDIT_NLGRP_NONE = 0,
	AUDIT_NLGRP_READLOG = 1,
	__AUDIT_NLGRP_MAX = 2,
};

enum audit_ntp_type {
	AUDIT_NTP_OFFSET = 0,
	AUDIT_NTP_FREQ = 1,
	AUDIT_NTP_STATUS = 2,
	AUDIT_NTP_TAI = 3,
	AUDIT_NTP_TICK = 4,
	AUDIT_NTP_ADJUST = 5,
	AUDIT_NTP_NVALS = 6,
};

enum audit_state {
	AUDIT_STATE_DISABLED = 0,
	AUDIT_STATE_BUILD = 1,
	AUDIT_STATE_RECORD = 2,
};

enum auditsc_class_t {
	AUDITSC_NATIVE = 0,
	AUDITSC_COMPAT = 1,
	AUDITSC_OPEN = 2,
	AUDITSC_OPENAT = 3,
	AUDITSC_SOCKETCALL = 4,
	AUDITSC_EXECVE = 5,
	AUDITSC_OPENAT2 = 6,
	AUDITSC_NVALS = 7,
};

enum autofs_notify {
	NFY_NONE = 0,
	NFY_MOUNT = 1,
	NFY_EXPIRE = 2,
};

enum axp15060_irqs {
	AXP15060_IRQ_DIE_TEMP_HIGH_LV1 = 1,
	AXP15060_IRQ_DIE_TEMP_HIGH_LV2 = 2,
	AXP15060_IRQ_DCDC1_V_LOW = 3,
	AXP15060_IRQ_DCDC2_V_LOW = 4,
	AXP15060_IRQ_DCDC3_V_LOW = 5,
	AXP15060_IRQ_DCDC4_V_LOW = 6,
	AXP15060_IRQ_DCDC5_V_LOW = 7,
	AXP15060_IRQ_DCDC6_V_LOW = 8,
	AXP15060_IRQ_PEK_LONG = 9,
	AXP15060_IRQ_PEK_SHORT = 10,
	AXP15060_IRQ_GPIO1_INPUT = 11,
	AXP15060_IRQ_PEK_FAL_EDGE = 12,
	AXP15060_IRQ_PEK_RIS_EDGE = 13,
	AXP15060_IRQ_GPIO2_INPUT = 14,
};

enum axp192_irqs {
	AXP192_IRQ_ACIN_OVER_V = 1,
	AXP192_IRQ_ACIN_PLUGIN = 2,
	AXP192_IRQ_ACIN_REMOVAL = 3,
	AXP192_IRQ_VBUS_OVER_V = 4,
	AXP192_IRQ_VBUS_PLUGIN = 5,
	AXP192_IRQ_VBUS_REMOVAL = 6,
	AXP192_IRQ_VBUS_V_LOW = 7,
	AXP192_IRQ_BATT_PLUGIN = 8,
	AXP192_IRQ_BATT_REMOVAL = 9,
	AXP192_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP192_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP192_IRQ_CHARG = 12,
	AXP192_IRQ_CHARG_DONE = 13,
	AXP192_IRQ_BATT_TEMP_HIGH = 14,
	AXP192_IRQ_BATT_TEMP_LOW = 15,
	AXP192_IRQ_DIE_TEMP_HIGH = 16,
	AXP192_IRQ_CHARG_I_LOW = 17,
	AXP192_IRQ_DCDC1_V_LONG = 18,
	AXP192_IRQ_DCDC2_V_LONG = 19,
	AXP192_IRQ_DCDC3_V_LONG = 20,
	AXP192_IRQ_PEK_SHORT = 22,
	AXP192_IRQ_PEK_LONG = 23,
	AXP192_IRQ_N_OE_PWR_ON = 24,
	AXP192_IRQ_N_OE_PWR_OFF = 25,
	AXP192_IRQ_VBUS_VALID = 26,
	AXP192_IRQ_VBUS_NOT_VALID = 27,
	AXP192_IRQ_VBUS_SESS_VALID = 28,
	AXP192_IRQ_VBUS_SESS_END = 29,
	AXP192_IRQ_LOW_PWR_LVL = 31,
	AXP192_IRQ_TIMER = 32,
	AXP192_IRQ_GPIO2_INPUT = 37,
	AXP192_IRQ_GPIO1_INPUT = 38,
	AXP192_IRQ_GPIO0_INPUT = 39,
};

enum axp20x_variants {
	AXP152_ID = 0,
	AXP192_ID = 1,
	AXP202_ID = 2,
	AXP209_ID = 3,
	AXP221_ID = 4,
	AXP223_ID = 5,
	AXP288_ID = 6,
	AXP313A_ID = 7,
	AXP323_ID = 8,
	AXP717_ID = 9,
	AXP803_ID = 10,
	AXP806_ID = 11,
	AXP809_ID = 12,
	AXP813_ID = 13,
	AXP15060_ID = 14,
	NR_AXP20X_VARIANTS = 15,
};

enum axp22x_irqs {
	AXP22X_IRQ_ACIN_OVER_V = 1,
	AXP22X_IRQ_ACIN_PLUGIN = 2,
	AXP22X_IRQ_ACIN_REMOVAL = 3,
	AXP22X_IRQ_VBUS_OVER_V = 4,
	AXP22X_IRQ_VBUS_PLUGIN = 5,
	AXP22X_IRQ_VBUS_REMOVAL = 6,
	AXP22X_IRQ_VBUS_V_LOW = 7,
	AXP22X_IRQ_BATT_PLUGIN = 8,
	AXP22X_IRQ_BATT_REMOVAL = 9,
	AXP22X_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP22X_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP22X_IRQ_CHARG = 12,
	AXP22X_IRQ_CHARG_DONE = 13,
	AXP22X_IRQ_BATT_TEMP_HIGH = 14,
	AXP22X_IRQ_BATT_TEMP_LOW = 15,
	AXP22X_IRQ_DIE_TEMP_HIGH = 16,
	AXP22X_IRQ_PEK_SHORT = 17,
	AXP22X_IRQ_PEK_LONG = 18,
	AXP22X_IRQ_LOW_PWR_LVL1 = 19,
	AXP22X_IRQ_LOW_PWR_LVL2 = 20,
	AXP22X_IRQ_TIMER = 21,
	AXP22X_IRQ_PEK_FAL_EDGE = 22,
	AXP22X_IRQ_PEK_RIS_EDGE = 23,
	AXP22X_IRQ_GPIO1_INPUT = 24,
	AXP22X_IRQ_GPIO0_INPUT = 25,
};

enum axp288_irqs {
	AXP288_IRQ_VBUS_FALL = 2,
	AXP288_IRQ_VBUS_RISE = 3,
	AXP288_IRQ_OV = 4,
	AXP288_IRQ_FALLING_ALT = 5,
	AXP288_IRQ_RISING_ALT = 6,
	AXP288_IRQ_OV_ALT = 7,
	AXP288_IRQ_DONE = 10,
	AXP288_IRQ_CHARGING = 11,
	AXP288_IRQ_SAFE_QUIT = 12,
	AXP288_IRQ_SAFE_ENTER = 13,
	AXP288_IRQ_ABSENT = 14,
	AXP288_IRQ_APPEND = 15,
	AXP288_IRQ_QWBTU = 16,
	AXP288_IRQ_WBTU = 17,
	AXP288_IRQ_QWBTO = 18,
	AXP288_IRQ_WBTO = 19,
	AXP288_IRQ_QCBTU = 20,
	AXP288_IRQ_CBTU = 21,
	AXP288_IRQ_QCBTO = 22,
	AXP288_IRQ_CBTO = 23,
	AXP288_IRQ_WL2 = 24,
	AXP288_IRQ_WL1 = 25,
	AXP288_IRQ_GPADC = 26,
	AXP288_IRQ_OT = 31,
	AXP288_IRQ_GPIO0 = 32,
	AXP288_IRQ_GPIO1 = 33,
	AXP288_IRQ_POKO = 34,
	AXP288_IRQ_POKL = 35,
	AXP288_IRQ_POKS = 36,
	AXP288_IRQ_POKN = 37,
	AXP288_IRQ_POKP = 38,
	AXP288_IRQ_TIMER = 39,
	AXP288_IRQ_MV_CHNG = 40,
	AXP288_IRQ_BC_USB_CHNG = 41,
};

enum axp313a_irqs {
	AXP313A_IRQ_DIE_TEMP_HIGH = 0,
	AXP313A_IRQ_DCDC2_V_LOW = 2,
	AXP313A_IRQ_DCDC3_V_LOW = 3,
	AXP313A_IRQ_PEK_LONG = 4,
	AXP313A_IRQ_PEK_SHORT = 5,
	AXP313A_IRQ_PEK_FAL_EDGE = 6,
	AXP313A_IRQ_PEK_RIS_EDGE = 7,
};

enum axp717_irqs {
	AXP717_IRQ_VBUS_FAULT = 0,
	AXP717_IRQ_VBUS_OVER_V = 1,
	AXP717_IRQ_BOOST_OVER_V = 2,
	AXP717_IRQ_GAUGE_NEW_SOC = 4,
	AXP717_IRQ_SOC_DROP_LVL1 = 6,
	AXP717_IRQ_SOC_DROP_LVL2 = 7,
	AXP717_IRQ_PEK_RIS_EDGE = 8,
	AXP717_IRQ_PEK_FAL_EDGE = 9,
	AXP717_IRQ_PEK_LONG = 10,
	AXP717_IRQ_PEK_SHORT = 11,
	AXP717_IRQ_BATT_REMOVAL = 12,
	AXP717_IRQ_BATT_PLUGIN = 13,
	AXP717_IRQ_VBUS_REMOVAL = 14,
	AXP717_IRQ_VBUS_PLUGIN = 15,
	AXP717_IRQ_BATT_OVER_V = 16,
	AXP717_IRQ_CHARG_TIMER = 17,
	AXP717_IRQ_DIE_TEMP_HIGH = 18,
	AXP717_IRQ_CHARG = 19,
	AXP717_IRQ_CHARG_DONE = 20,
	AXP717_IRQ_BATT_OVER_CURR = 21,
	AXP717_IRQ_LDO_OVER_CURR = 22,
	AXP717_IRQ_WDOG_EXPIRE = 23,
	AXP717_IRQ_BATT_ACT_TEMP_LOW = 24,
	AXP717_IRQ_BATT_ACT_TEMP_HIGH = 25,
	AXP717_IRQ_BATT_CHG_TEMP_LOW = 26,
	AXP717_IRQ_BATT_CHG_TEMP_HIGH = 27,
	AXP717_IRQ_BATT_QUIT_TEMP_HIGH = 28,
	AXP717_IRQ_BC_USB_CHNG = 30,
	AXP717_IRQ_BC_USB_DONE = 31,
	AXP717_IRQ_TYPEC_PLUGIN = 37,
	AXP717_IRQ_TYPEC_REMOVE = 38,
};

enum axp803_irqs {
	AXP803_IRQ_ACIN_OVER_V = 1,
	AXP803_IRQ_ACIN_PLUGIN = 2,
	AXP803_IRQ_ACIN_REMOVAL = 3,
	AXP803_IRQ_VBUS_OVER_V = 4,
	AXP803_IRQ_VBUS_PLUGIN = 5,
	AXP803_IRQ_VBUS_REMOVAL = 6,
	AXP803_IRQ_BATT_PLUGIN = 7,
	AXP803_IRQ_BATT_REMOVAL = 8,
	AXP803_IRQ_BATT_ENT_ACT_MODE = 9,
	AXP803_IRQ_BATT_EXIT_ACT_MODE = 10,
	AXP803_IRQ_CHARG = 11,
	AXP803_IRQ_CHARG_DONE = 12,
	AXP803_IRQ_BATT_CHG_TEMP_HIGH = 13,
	AXP803_IRQ_BATT_CHG_TEMP_HIGH_END = 14,
	AXP803_IRQ_BATT_CHG_TEMP_LOW = 15,
	AXP803_IRQ_BATT_CHG_TEMP_LOW_END = 16,
	AXP803_IRQ_BATT_ACT_TEMP_HIGH = 17,
	AXP803_IRQ_BATT_ACT_TEMP_HIGH_END = 18,
	AXP803_IRQ_BATT_ACT_TEMP_LOW = 19,
	AXP803_IRQ_BATT_ACT_TEMP_LOW_END = 20,
	AXP803_IRQ_DIE_TEMP_HIGH = 21,
	AXP803_IRQ_GPADC = 22,
	AXP803_IRQ_LOW_PWR_LVL1 = 23,
	AXP803_IRQ_LOW_PWR_LVL2 = 24,
	AXP803_IRQ_TIMER = 25,
	AXP803_IRQ_PEK_FAL_EDGE = 26,
	AXP803_IRQ_PEK_RIS_EDGE = 27,
	AXP803_IRQ_PEK_SHORT = 28,
	AXP803_IRQ_PEK_LONG = 29,
	AXP803_IRQ_PEK_OVER_OFF = 30,
	AXP803_IRQ_GPIO1_INPUT = 31,
	AXP803_IRQ_GPIO0_INPUT = 32,
	AXP803_IRQ_BC_USB_CHNG = 33,
	AXP803_IRQ_MV_CHNG = 34,
};

enum axp806_irqs {
	AXP806_IRQ_DIE_TEMP_HIGH_LV1 = 0,
	AXP806_IRQ_DIE_TEMP_HIGH_LV2 = 1,
	AXP806_IRQ_DCDCA_V_LOW = 2,
	AXP806_IRQ_DCDCB_V_LOW = 3,
	AXP806_IRQ_DCDCC_V_LOW = 4,
	AXP806_IRQ_DCDCD_V_LOW = 5,
	AXP806_IRQ_DCDCE_V_LOW = 6,
	AXP806_IRQ_POK_LONG = 7,
	AXP806_IRQ_POK_SHORT = 8,
	AXP806_IRQ_WAKEUP = 9,
	AXP806_IRQ_POK_FALL = 10,
	AXP806_IRQ_POK_RISE = 11,
};

enum axp809_irqs {
	AXP809_IRQ_ACIN_OVER_V = 1,
	AXP809_IRQ_ACIN_PLUGIN = 2,
	AXP809_IRQ_ACIN_REMOVAL = 3,
	AXP809_IRQ_VBUS_OVER_V = 4,
	AXP809_IRQ_VBUS_PLUGIN = 5,
	AXP809_IRQ_VBUS_REMOVAL = 6,
	AXP809_IRQ_VBUS_V_LOW = 7,
	AXP809_IRQ_BATT_PLUGIN = 8,
	AXP809_IRQ_BATT_REMOVAL = 9,
	AXP809_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP809_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP809_IRQ_CHARG = 12,
	AXP809_IRQ_CHARG_DONE = 13,
	AXP809_IRQ_BATT_CHG_TEMP_HIGH = 14,
	AXP809_IRQ_BATT_CHG_TEMP_HIGH_END = 15,
	AXP809_IRQ_BATT_CHG_TEMP_LOW = 16,
	AXP809_IRQ_BATT_CHG_TEMP_LOW_END = 17,
	AXP809_IRQ_BATT_ACT_TEMP_HIGH = 18,
	AXP809_IRQ_BATT_ACT_TEMP_HIGH_END = 19,
	AXP809_IRQ_BATT_ACT_TEMP_LOW = 20,
	AXP809_IRQ_BATT_ACT_TEMP_LOW_END = 21,
	AXP809_IRQ_DIE_TEMP_HIGH = 22,
	AXP809_IRQ_LOW_PWR_LVL1 = 23,
	AXP809_IRQ_LOW_PWR_LVL2 = 24,
	AXP809_IRQ_TIMER = 25,
	AXP809_IRQ_PEK_FAL_EDGE = 26,
	AXP809_IRQ_PEK_RIS_EDGE = 27,
	AXP809_IRQ_PEK_SHORT = 28,
	AXP809_IRQ_PEK_LONG = 29,
	AXP809_IRQ_PEK_OVER_OFF = 30,
	AXP809_IRQ_GPIO1_INPUT = 31,
	AXP809_IRQ_GPIO0_INPUT = 32,
};

enum bam_command_type {
	BAM_WRITE_COMMAND = 0,
	BAM_READ_COMMAND = 1,
};

enum bam_reg {
	BAM_CTRL = 0,
	BAM_REVISION = 1,
	BAM_NUM_PIPES = 2,
	BAM_DESC_CNT_TRSHLD = 3,
	BAM_IRQ_SRCS = 4,
	BAM_IRQ_SRCS_MSK = 5,
	BAM_IRQ_SRCS_UNMASKED = 6,
	BAM_IRQ_STTS = 7,
	BAM_IRQ_CLR = 8,
	BAM_IRQ_EN = 9,
	BAM_CNFG_BITS = 10,
	BAM_IRQ_SRCS_EE = 11,
	BAM_IRQ_SRCS_MSK_EE = 12,
	BAM_P_CTRL = 13,
	BAM_P_RST = 14,
	BAM_P_HALT = 15,
	BAM_P_IRQ_STTS = 16,
	BAM_P_IRQ_CLR = 17,
	BAM_P_IRQ_EN = 18,
	BAM_P_EVNT_DEST_ADDR = 19,
	BAM_P_EVNT_REG = 20,
	BAM_P_SW_OFSTS = 21,
	BAM_P_DATA_FIFO_ADDR = 22,
	BAM_P_DESC_FIFO_ADDR = 23,
	BAM_P_EVNT_GEN_TRSHLD = 24,
	BAM_P_FIFO_SIZES = 25,
};

enum base_type {
	MSPI = 0,
	BSPI = 1,
	CHIP_SELECT = 2,
	BASEMAX = 3,
};

enum batadv_packettype {
	BATADV_IV_OGM = 0,
	BATADV_BCAST = 1,
	BATADV_CODED = 2,
	BATADV_ELP = 3,
	BATADV_OGM2 = 4,
	BATADV_MCAST = 5,
	BATADV_UNICAST = 64,
	BATADV_UNICAST_FRAG = 65,
	BATADV_UNICAST_4ADDR = 66,
	BATADV_ICMP = 67,
	BATADV_UNICAST_TVLV = 68,
};

enum bcm2835_fsel {
	BCM2835_FSEL_COUNT = 8,
	BCM2835_FSEL_MASK = 7,
};

enum bcm_iproc_i2c_type {
	IPROC_I2C = 0,
	IPROC_I2C_NIC = 1,
};

enum bcm_usb_phy_ctrl_bits {
	CORERDY = 0,
	PHY_RESETB = 1,
	PHY_PCTL = 2,
};

enum bcm_usb_phy_reg {
	PLL_CTRL = 0,
	PHY_CTRL = 1,
	PHY_PLL_CTRL = 2,
};

enum bcm_usb_phy_type {
	USB_HS_PHY = 0,
	USB_SS_PHY = 1,
};

enum bcm_usb_phy_version {
	BCM_SR_USB_COMBO_PHY = 0,
	BCM_SR_USB_HS_PHY = 1,
};

enum bcma_hosttype {
	BCMA_HOSTTYPE_PCI = 0,
	BCMA_HOSTTYPE_SDIO = 1,
	BCMA_HOSTTYPE_SOC = 2,
};

enum bcmasp_stat_type {
	BCMASP_STAT_RX_CTRL = 0,
	BCMASP_STAT_RX_CTRL_PER_INTF = 1,
	BCMASP_STAT_SOFT = 2,
};

enum bd9571mwv_irqs {
	BD9571MWV_IRQ_MD1 = 0,
	BD9571MWV_IRQ_MD2_E1 = 1,
	BD9571MWV_IRQ_MD2_E2 = 2,
	BD9571MWV_IRQ_PROT_ERR = 3,
	BD9571MWV_IRQ_GP = 4,
	BD9571MWV_IRQ_128H_OF = 5,
	BD9571MWV_IRQ_WDT_OF = 6,
	BD9571MWV_IRQ_BKUP_TRG = 7,
};

enum bd9571mwv_regulators {
	VD09 = 0,
	VD18 = 1,
	VD25 = 2,
	VD33 = 3,
	DVFS = 4,
};

enum bdc_ep0_state {
	WAIT_FOR_SETUP = 0,
	WAIT_FOR_DATA_START = 1,
	WAIT_FOR_DATA_XMIT = 2,
	WAIT_FOR_STATUS_START = 3,
	WAIT_FOR_STATUS_XMIT = 4,
	STATUS_PENDING = 5,
};

enum bdc_link_state {
	BDC_LINK_STATE_U0 = 0,
	BDC_LINK_STATE_U3 = 3,
	BDC_LINK_STATE_RX_DET = 5,
	BDC_LINK_STATE_RESUME = 15,
};

enum bdcr_cmd_class {
	BDCR_CMD_UNSPEC = 0,
	BDCR_CMD_MAC_FILTER = 1,
	BDCR_CMD_VLAN_FILTER = 2,
	BDCR_CMD_RSS = 3,
	BDCR_CMD_RFS = 4,
	BDCR_CMD_PORT_GCL = 5,
	BDCR_CMD_RECV_CLASSIFIER = 6,
	BDCR_CMD_STREAM_IDENTIFY = 7,
	BDCR_CMD_STREAM_FILTER = 8,
	BDCR_CMD_STREAM_GCL = 9,
	BDCR_CMD_FLOW_METER = 10,
	__BDCR_CMD_MAX_LEN = 11,
	BDCR_CMD_MAX_LEN = 10,
};

enum behavior {
	EXCLUSIVE = 0,
	SHARED = 1,
	DROP = 2,
};

enum bfqq_expiration {
	BFQQE_TOO_IDLE = 0,
	BFQQE_BUDGET_TIMEOUT = 1,
	BFQQE_BUDGET_EXHAUSTED = 2,
	BFQQE_NO_MORE_REQUESTS = 3,
	BFQQE_PREEMPTED = 4,
};

enum bfqq_state_flags {
	BFQQF_just_created = 0,
	BFQQF_busy = 1,
	BFQQF_wait_request = 2,
	BFQQF_non_blocking_wait_rq = 3,
	BFQQF_fifo_expire = 4,
	BFQQF_has_short_ttime = 5,
	BFQQF_sync = 6,
	BFQQF_IO_bound = 7,
	BFQQF_in_large_burst = 8,
	BFQQF_softrt_update = 9,
	BFQQF_coop = 10,
	BFQQF_split_coop = 11,
};

enum bgmac_dma_ring_type {
	BGMAC_DMA_RING_TX = 0,
	BGMAC_DMA_RING_RX = 1,
};

enum bh_state_bits {
	BH_Uptodate = 0,
	BH_Dirty = 1,
	BH_Lock = 2,
	BH_Req = 3,
	BH_Mapped = 4,
	BH_New = 5,
	BH_Async_Read = 6,
	BH_Async_Write = 7,
	BH_Delay = 8,
	BH_Boundary = 9,
	BH_Write_EIO = 10,
	BH_Unwritten = 11,
	BH_Quiet = 12,
	BH_Meta = 13,
	BH_Prio = 14,
	BH_Defer_Completion = 15,
	BH_Migrate = 16,
	BH_PrivateStart = 17,
};

enum bhb_mitigation_bits {
	BHB_LOOP = 0,
	BHB_FW = 1,
	BHB_HW = 2,
	BHB_INSN = 3,
};

enum bio_merge_status {
	BIO_MERGE_OK = 0,
	BIO_MERGE_NONE = 1,
	BIO_MERGE_FAILED = 2,
};

enum bio_post_read_step {
	STEP_INITIAL = 0,
	STEP_DECRYPT = 1,
	STEP_VERITY = 2,
	STEP_MAX = 3,
};

enum bios_platform_class {
	BIOS_CLIENT = 0,
	BIOS_SERVER = 1,
};

enum bip_flags {
	BIP_BLOCK_INTEGRITY = 1,
	BIP_MAPPED_INTEGRITY = 2,
	BIP_DISK_NOCHECK = 4,
	BIP_IP_CHECKSUM = 8,
	BIP_COPY_USER = 16,
	BIP_CHECK_GUARD = 32,
	BIP_CHECK_REFTAG = 64,
	BIP_CHECK_APPTAG = 128,
};

enum bkops_status {
	BKOPS_STATUS_NO_OP = 0,
	BKOPS_STATUS_NON_CRITICAL = 1,
	BKOPS_STATUS_PERF_IMPACT = 2,
	BKOPS_STATUS_CRITICAL = 3,
	BKOPS_STATUS_MAX = 3,
};

enum blacklist_hash_type {
	BLACKLIST_HASH_X509_TBS = 1,
	BLACKLIST_HASH_BINARY = 2,
};

enum blake2s_iv {
	BLAKE2S_IV0 = 1779033703,
	BLAKE2S_IV1 = 3144134277,
	BLAKE2S_IV2 = 1013904242,
	BLAKE2S_IV3 = 2773480762,
	BLAKE2S_IV4 = 1359893119,
	BLAKE2S_IV5 = 2600822924,
	BLAKE2S_IV6 = 528734635,
	BLAKE2S_IV7 = 1541459225,
};

enum blake2s_lengths {
	BLAKE2S_BLOCK_SIZE = 64,
	BLAKE2S_HASH_SIZE = 32,
	BLAKE2S_KEY_SIZE = 32,
	BLAKE2S_128_HASH_SIZE = 16,
	BLAKE2S_160_HASH_SIZE = 20,
	BLAKE2S_224_HASH_SIZE = 28,
	BLAKE2S_256_HASH_SIZE = 32,
};

enum blk_crypto_key_type {
	BLK_CRYPTO_KEY_TYPE_RAW = 1,
	BLK_CRYPTO_KEY_TYPE_HW_WRAPPED = 2,
};

enum blk_crypto_mode_num {
	BLK_ENCRYPTION_MODE_INVALID = 0,
	BLK_ENCRYPTION_MODE_AES_256_XTS = 1,
	BLK_ENCRYPTION_MODE_AES_128_CBC_ESSIV = 2,
	BLK_ENCRYPTION_MODE_ADIANTUM = 3,
	BLK_ENCRYPTION_MODE_SM4_XTS = 4,
	BLK_ENCRYPTION_MODE_MAX = 5,
};

enum blk_default_limits {
	BLK_MAX_SEGMENTS = 128,
	BLK_SAFE_MAX_SECTORS = 255,
	BLK_MAX_SEGMENT_SIZE = 65536,
	BLK_SEG_BOUNDARY_MASK = 4294967295,
};

enum blk_eh_timer_return {
	BLK_EH_DONE = 0,
	BLK_EH_RESET_TIMER = 1,
};

enum blk_integrity_checksum {
	BLK_INTEGRITY_CSUM_NONE = 0,
	BLK_INTEGRITY_CSUM_IP = 1,
	BLK_INTEGRITY_CSUM_CRC = 2,
	BLK_INTEGRITY_CSUM_CRC64 = 3,
} __attribute__((mode(byte)));

enum blk_integrity_flags {
	BLK_INTEGRITY_NOVERIFY = 1,
	BLK_INTEGRITY_NOGENERATE = 2,
	BLK_INTEGRITY_DEVICE_CAPABLE = 4,
	BLK_INTEGRITY_REF_TAG = 8,
	BLK_INTEGRITY_STACKED = 16,
};

enum blk_req_status {
	REQ_PROCESSING = 0,
	REQ_WAITING = 1,
	REQ_DONE = 2,
	REQ_ERROR = 3,
	REQ_EOPNOTSUPP = 4,
};

enum blk_unique_id {
	BLK_UID_T10 = 1,
	BLK_UID_EUI64 = 2,
	BLK_UID_NAA = 3,
};

enum blkg_iostat_type {
	BLKG_IOSTAT_READ = 0,
	BLKG_IOSTAT_WRITE = 1,
	BLKG_IOSTAT_DISCARD = 2,
	BLKG_IOSTAT_NR = 3,
};

enum blkg_rwstat_type {
	BLKG_RWSTAT_READ = 0,
	BLKG_RWSTAT_WRITE = 1,
	BLKG_RWSTAT_SYNC = 2,
	BLKG_RWSTAT_ASYNC = 3,
	BLKG_RWSTAT_DISCARD = 4,
	BLKG_RWSTAT_NR = 5,
	BLKG_RWSTAT_TOTAL = 5,
};

enum blkif_state {
	BLKIF_STATE_DISCONNECTED = 0,
	BLKIF_STATE_CONNECTED = 1,
	BLKIF_STATE_SUSPENDED = 2,
	BLKIF_STATE_ERROR = 3,
};

enum blktrace_act {
	__BLK_TA_QUEUE = 1,
	__BLK_TA_BACKMERGE = 2,
	__BLK_TA_FRONTMERGE = 3,
	__BLK_TA_GETRQ = 4,
	__BLK_TA_SLEEPRQ = 5,
	__BLK_TA_REQUEUE = 6,
	__BLK_TA_ISSUE = 7,
	__BLK_TA_COMPLETE = 8,
	__BLK_TA_PLUG = 9,
	__BLK_TA_UNPLUG_IO = 10,
	__BLK_TA_UNPLUG_TIMER = 11,
	__BLK_TA_INSERT = 12,
	__BLK_TA_SPLIT = 13,
	__BLK_TA_BOUNCE = 14,
	__BLK_TA_REMAP = 15,
	__BLK_TA_ABORT = 16,
	__BLK_TA_DRV_DATA = 17,
	__BLK_TA_CGROUP = 256,
};

enum bm_rcr_cmode {
	bm_rcr_cci = 0,
	bm_rcr_cce = 1,
};

enum bm_rcr_pmode {
	bm_rcr_pci = 0,
	bm_rcr_pce = 1,
	bm_rcr_pvb = 2,
};

enum board_ids {
	board_ahci = 0,
	board_ahci_43bit_dma = 1,
	board_ahci_ign_iferr = 2,
	board_ahci_no_debounce_delay = 3,
	board_ahci_no_msi = 4,
	board_ahci_pcs_quirk = 5,
	board_ahci_pcs_quirk_no_devslp = 6,
	board_ahci_pcs_quirk_no_sntf = 7,
	board_ahci_yes_fbs = 8,
	board_ahci_yes_fbs_atapi_dma = 9,
	board_ahci_al = 10,
	board_ahci_avn = 11,
	board_ahci_mcp65 = 12,
	board_ahci_mcp77 = 13,
	board_ahci_mcp89 = 14,
	board_ahci_mv = 15,
	board_ahci_sb600 = 16,
	board_ahci_sb700 = 17,
	board_ahci_vt8251 = 18,
	board_ahci_mcp_linux = 12,
	board_ahci_mcp67 = 12,
	board_ahci_mcp73 = 12,
	board_ahci_mcp79 = 13,
};

enum bp_state {
	BP_DONE = 0,
	BP_WAIT = 1,
	BP_EAGAIN = 2,
	BP_ECANCELED = 3,
};

enum bp_type_idx {
	TYPE_INST = 0,
	TYPE_DATA = 1,
	TYPE_MAX = 2,
};

enum bpf_access_src {
	ACCESS_DIRECT = 1,
	ACCESS_HELPER = 2,
};

enum bpf_access_type {
	BPF_READ = 1,
	BPF_WRITE = 2,
};

enum bpf_addr_space_cast {
	BPF_ADDR_SPACE_CAST = 1,
};

enum bpf_adj_room_mode {
	BPF_ADJ_ROOM_NET = 0,
	BPF_ADJ_ROOM_MAC = 1,
};

enum bpf_arg_type {
	ARG_DONTCARE = 0,
	ARG_CONST_MAP_PTR = 1,
	ARG_PTR_TO_MAP_KEY = 2,
	ARG_PTR_TO_MAP_VALUE = 3,
	ARG_PTR_TO_MEM = 4,
	ARG_PTR_TO_ARENA = 5,
	ARG_CONST_SIZE = 6,
	ARG_CONST_SIZE_OR_ZERO = 7,
	ARG_PTR_TO_CTX = 8,
	ARG_ANYTHING = 9,
	ARG_PTR_TO_SPIN_LOCK = 10,
	ARG_PTR_TO_SOCK_COMMON = 11,
	ARG_PTR_TO_SOCKET = 12,
	ARG_PTR_TO_BTF_ID = 13,
	ARG_PTR_TO_RINGBUF_MEM = 14,
	ARG_CONST_ALLOC_SIZE_OR_ZERO = 15,
	ARG_PTR_TO_BTF_ID_SOCK_COMMON = 16,
	ARG_PTR_TO_PERCPU_BTF_ID = 17,
	ARG_PTR_TO_FUNC = 18,
	ARG_PTR_TO_STACK = 19,
	ARG_PTR_TO_CONST_STR = 20,
	ARG_PTR_TO_TIMER = 21,
	ARG_KPTR_XCHG_DEST = 22,
	ARG_PTR_TO_DYNPTR = 23,
	__BPF_ARG_TYPE_MAX = 24,
	ARG_PTR_TO_MAP_VALUE_OR_NULL = 259,
	ARG_PTR_TO_MEM_OR_NULL = 260,
	ARG_PTR_TO_CTX_OR_NULL = 264,
	ARG_PTR_TO_SOCKET_OR_NULL = 268,
	ARG_PTR_TO_STACK_OR_NULL = 275,
	ARG_PTR_TO_BTF_ID_OR_NULL = 269,
	ARG_PTR_TO_UNINIT_MEM = 67141636,
	ARG_PTR_TO_FIXED_SIZE_MEM = 262148,
	__BPF_ARG_TYPE_LIMIT = 134217727,
};

enum bpf_async_type {
	BPF_ASYNC_TYPE_TIMER = 0,
	BPF_ASYNC_TYPE_WQ = 1,
};

enum bpf_attach_type {
	BPF_CGROUP_INET_INGRESS = 0,
	BPF_CGROUP_INET_EGRESS = 1,
	BPF_CGROUP_INET_SOCK_CREATE = 2,
	BPF_CGROUP_SOCK_OPS = 3,
	BPF_SK_SKB_STREAM_PARSER = 4,
	BPF_SK_SKB_STREAM_VERDICT = 5,
	BPF_CGROUP_DEVICE = 6,
	BPF_SK_MSG_VERDICT = 7,
	BPF_CGROUP_INET4_BIND = 8,
	BPF_CGROUP_INET6_BIND = 9,
	BPF_CGROUP_INET4_CONNECT = 10,
	BPF_CGROUP_INET6_CONNECT = 11,
	BPF_CGROUP_INET4_POST_BIND = 12,
	BPF_CGROUP_INET6_POST_BIND = 13,
	BPF_CGROUP_UDP4_SENDMSG = 14,
	BPF_CGROUP_UDP6_SENDMSG = 15,
	BPF_LIRC_MODE2 = 16,
	BPF_FLOW_DISSECTOR = 17,
	BPF_CGROUP_SYSCTL = 18,
	BPF_CGROUP_UDP4_RECVMSG = 19,
	BPF_CGROUP_UDP6_RECVMSG = 20,
	BPF_CGROUP_GETSOCKOPT = 21,
	BPF_CGROUP_SETSOCKOPT = 22,
	BPF_TRACE_RAW_TP = 23,
	BPF_TRACE_FENTRY = 24,
	BPF_TRACE_FEXIT = 25,
	BPF_MODIFY_RETURN = 26,
	BPF_LSM_MAC = 27,
	BPF_TRACE_ITER = 28,
	BPF_CGROUP_INET4_GETPEERNAME = 29,
	BPF_CGROUP_INET6_GETPEERNAME = 30,
	BPF_CGROUP_INET4_GETSOCKNAME = 31,
	BPF_CGROUP_INET6_GETSOCKNAME = 32,
	BPF_XDP_DEVMAP = 33,
	BPF_CGROUP_INET_SOCK_RELEASE = 34,
	BPF_XDP_CPUMAP = 35,
	BPF_SK_LOOKUP = 36,
	BPF_XDP = 37,
	BPF_SK_SKB_VERDICT = 38,
	BPF_SK_REUSEPORT_SELECT = 39,
	BPF_SK_REUSEPORT_SELECT_OR_MIGRATE = 40,
	BPF_PERF_EVENT = 41,
	BPF_TRACE_KPROBE_MULTI = 42,
	BPF_LSM_CGROUP = 43,
	BPF_STRUCT_OPS = 44,
	BPF_NETFILTER = 45,
	BPF_TCX_INGRESS = 46,
	BPF_TCX_EGRESS = 47,
	BPF_TRACE_UPROBE_MULTI = 48,
	BPF_CGROUP_UNIX_CONNECT = 49,
	BPF_CGROUP_UNIX_SENDMSG = 50,
	BPF_CGROUP_UNIX_RECVMSG = 51,
	BPF_CGROUP_UNIX_GETPEERNAME = 52,
	BPF_CGROUP_UNIX_GETSOCKNAME = 53,
	BPF_NETKIT_PRIMARY = 54,
	BPF_NETKIT_PEER = 55,
	BPF_TRACE_KPROBE_SESSION = 56,
	BPF_TRACE_UPROBE_SESSION = 57,
	__MAX_BPF_ATTACH_TYPE = 58,
};

enum bpf_audit {
	BPF_AUDIT_LOAD = 0,
	BPF_AUDIT_UNLOAD = 1,
	BPF_AUDIT_MAX = 2,
};

enum bpf_cgroup_iter_order {
	BPF_CGROUP_ITER_ORDER_UNSPEC = 0,
	BPF_CGROUP_ITER_SELF_ONLY = 1,
	BPF_CGROUP_ITER_DESCENDANTS_PRE = 2,
	BPF_CGROUP_ITER_DESCENDANTS_POST = 3,
	BPF_CGROUP_ITER_ANCESTORS_UP = 4,
};

enum bpf_cgroup_storage_type {
	BPF_CGROUP_STORAGE_SHARED = 0,
	BPF_CGROUP_STORAGE_PERCPU = 1,
	__BPF_CGROUP_STORAGE_MAX = 2,
};

enum bpf_check_mtu_flags {
	BPF_MTU_CHK_SEGS = 1,
};

enum bpf_check_mtu_ret {
	BPF_MTU_CHK_RET_SUCCESS = 0,
	BPF_MTU_CHK_RET_FRAG_NEEDED = 1,
	BPF_MTU_CHK_RET_SEGS_TOOBIG = 2,
};

enum bpf_cmd {
	BPF_MAP_CREATE = 0,
	BPF_MAP_LOOKUP_ELEM = 1,
	BPF_MAP_UPDATE_ELEM = 2,
	BPF_MAP_DELETE_ELEM = 3,
	BPF_MAP_GET_NEXT_KEY = 4,
	BPF_PROG_LOAD = 5,
	BPF_OBJ_PIN = 6,
	BPF_OBJ_GET = 7,
	BPF_PROG_ATTACH = 8,
	BPF_PROG_DETACH = 9,
	BPF_PROG_TEST_RUN = 10,
	BPF_PROG_RUN = 10,
	BPF_PROG_GET_NEXT_ID = 11,
	BPF_MAP_GET_NEXT_ID = 12,
	BPF_PROG_GET_FD_BY_ID = 13,
	BPF_MAP_GET_FD_BY_ID = 14,
	BPF_OBJ_GET_INFO_BY_FD = 15,
	BPF_PROG_QUERY = 16,
	BPF_RAW_TRACEPOINT_OPEN = 17,
	BPF_BTF_LOAD = 18,
	BPF_BTF_GET_FD_BY_ID = 19,
	BPF_TASK_FD_QUERY = 20,
	BPF_MAP_LOOKUP_AND_DELETE_ELEM = 21,
	BPF_MAP_FREEZE = 22,
	BPF_BTF_GET_NEXT_ID = 23,
	BPF_MAP_LOOKUP_BATCH = 24,
	BPF_MAP_LOOKUP_AND_DELETE_BATCH = 25,
	BPF_MAP_UPDATE_BATCH = 26,
	BPF_MAP_DELETE_BATCH = 27,
	BPF_LINK_CREATE = 28,
	BPF_LINK_UPDATE = 29,
	BPF_LINK_GET_FD_BY_ID = 30,
	BPF_LINK_GET_NEXT_ID = 31,
	BPF_ENABLE_STATS = 32,
	BPF_ITER_CREATE = 33,
	BPF_LINK_DETACH = 34,
	BPF_PROG_BIND_MAP = 35,
	BPF_TOKEN_CREATE = 36,
	__MAX_BPF_CMD = 37,
};

enum bpf_cond_pseudo_jmp {
	BPF_MAY_GOTO = 0,
};

enum bpf_core_relo_kind {
	BPF_CORE_FIELD_BYTE_OFFSET = 0,
	BPF_CORE_FIELD_BYTE_SIZE = 1,
	BPF_CORE_FIELD_EXISTS = 2,
	BPF_CORE_FIELD_SIGNED = 3,
	BPF_CORE_FIELD_LSHIFT_U64 = 4,
	BPF_CORE_FIELD_RSHIFT_U64 = 5,
	BPF_CORE_TYPE_ID_LOCAL = 6,
	BPF_CORE_TYPE_ID_TARGET = 7,
	BPF_CORE_TYPE_EXISTS = 8,
	BPF_CORE_TYPE_SIZE = 9,
	BPF_CORE_ENUMVAL_EXISTS = 10,
	BPF_CORE_ENUMVAL_VALUE = 11,
	BPF_CORE_TYPE_MATCHES = 12,
};

enum bpf_dynptr_type {
	BPF_DYNPTR_TYPE_INVALID = 0,
	BPF_DYNPTR_TYPE_LOCAL = 1,
	BPF_DYNPTR_TYPE_RINGBUF = 2,
	BPF_DYNPTR_TYPE_SKB = 3,
	BPF_DYNPTR_TYPE_XDP = 4,
};

enum bpf_func_id {
	BPF_FUNC_unspec = 0,
	BPF_FUNC_map_lookup_elem = 1,
	BPF_FUNC_map_update_elem = 2,
	BPF_FUNC_map_delete_elem = 3,
	BPF_FUNC_probe_read = 4,
	BPF_FUNC_ktime_get_ns = 5,
	BPF_FUNC_trace_printk = 6,
	BPF_FUNC_get_prandom_u32 = 7,
	BPF_FUNC_get_smp_processor_id = 8,
	BPF_FUNC_skb_store_bytes = 9,
	BPF_FUNC_l3_csum_replace = 10,
	BPF_FUNC_l4_csum_replace = 11,
	BPF_FUNC_tail_call = 12,
	BPF_FUNC_clone_redirect = 13,
	BPF_FUNC_get_current_pid_tgid = 14,
	BPF_FUNC_get_current_uid_gid = 15,
	BPF_FUNC_get_current_comm = 16,
	BPF_FUNC_get_cgroup_classid = 17,
	BPF_FUNC_skb_vlan_push = 18,
	BPF_FUNC_skb_vlan_pop = 19,
	BPF_FUNC_skb_get_tunnel_key = 20,
	BPF_FUNC_skb_set_tunnel_key = 21,
	BPF_FUNC_perf_event_read = 22,
	BPF_FUNC_redirect = 23,
	BPF_FUNC_get_route_realm = 24,
	BPF_FUNC_perf_event_output = 25,
	BPF_FUNC_skb_load_bytes = 26,
	BPF_FUNC_get_stackid = 27,
	BPF_FUNC_csum_diff = 28,
	BPF_FUNC_skb_get_tunnel_opt = 29,
	BPF_FUNC_skb_set_tunnel_opt = 30,
	BPF_FUNC_skb_change_proto = 31,
	BPF_FUNC_skb_change_type = 32,
	BPF_FUNC_skb_under_cgroup = 33,
	BPF_FUNC_get_hash_recalc = 34,
	BPF_FUNC_get_current_task = 35,
	BPF_FUNC_probe_write_user = 36,
	BPF_FUNC_current_task_under_cgroup = 37,
	BPF_FUNC_skb_change_tail = 38,
	BPF_FUNC_skb_pull_data = 39,
	BPF_FUNC_csum_update = 40,
	BPF_FUNC_set_hash_invalid = 41,
	BPF_FUNC_get_numa_node_id = 42,
	BPF_FUNC_skb_change_head = 43,
	BPF_FUNC_xdp_adjust_head = 44,
	BPF_FUNC_probe_read_str = 45,
	BPF_FUNC_get_socket_cookie = 46,
	BPF_FUNC_get_socket_uid = 47,
	BPF_FUNC_set_hash = 48,
	BPF_FUNC_setsockopt = 49,
	BPF_FUNC_skb_adjust_room = 50,
	BPF_FUNC_redirect_map = 51,
	BPF_FUNC_sk_redirect_map = 52,
	BPF_FUNC_sock_map_update = 53,
	BPF_FUNC_xdp_adjust_meta = 54,
	BPF_FUNC_perf_event_read_value = 55,
	BPF_FUNC_perf_prog_read_value = 56,
	BPF_FUNC_getsockopt = 57,
	BPF_FUNC_override_return = 58,
	BPF_FUNC_sock_ops_cb_flags_set = 59,
	BPF_FUNC_msg_redirect_map = 60,
	BPF_FUNC_msg_apply_bytes = 61,
	BPF_FUNC_msg_cork_bytes = 62,
	BPF_FUNC_msg_pull_data = 63,
	BPF_FUNC_bind = 64,
	BPF_FUNC_xdp_adjust_tail = 65,
	BPF_FUNC_skb_get_xfrm_state = 66,
	BPF_FUNC_get_stack = 67,
	BPF_FUNC_skb_load_bytes_relative = 68,
	BPF_FUNC_fib_lookup = 69,
	BPF_FUNC_sock_hash_update = 70,
	BPF_FUNC_msg_redirect_hash = 71,
	BPF_FUNC_sk_redirect_hash = 72,
	BPF_FUNC_lwt_push_encap = 73,
	BPF_FUNC_lwt_seg6_store_bytes = 74,
	BPF_FUNC_lwt_seg6_adjust_srh = 75,
	BPF_FUNC_lwt_seg6_action = 76,
	BPF_FUNC_rc_repeat = 77,
	BPF_FUNC_rc_keydown = 78,
	BPF_FUNC_skb_cgroup_id = 79,
	BPF_FUNC_get_current_cgroup_id = 80,
	BPF_FUNC_get_local_storage = 81,
	BPF_FUNC_sk_select_reuseport = 82,
	BPF_FUNC_skb_ancestor_cgroup_id = 83,
	BPF_FUNC_sk_lookup_tcp = 84,
	BPF_FUNC_sk_lookup_udp = 85,
	BPF_FUNC_sk_release = 86,
	BPF_FUNC_map_push_elem = 87,
	BPF_FUNC_map_pop_elem = 88,
	BPF_FUNC_map_peek_elem = 89,
	BPF_FUNC_msg_push_data = 90,
	BPF_FUNC_msg_pop_data = 91,
	BPF_FUNC_rc_pointer_rel = 92,
	BPF_FUNC_spin_lock = 93,
	BPF_FUNC_spin_unlock = 94,
	BPF_FUNC_sk_fullsock = 95,
	BPF_FUNC_tcp_sock = 96,
	BPF_FUNC_skb_ecn_set_ce = 97,
	BPF_FUNC_get_listener_sock = 98,
	BPF_FUNC_skc_lookup_tcp = 99,
	BPF_FUNC_tcp_check_syncookie = 100,
	BPF_FUNC_sysctl_get_name = 101,
	BPF_FUNC_sysctl_get_current_value = 102,
	BPF_FUNC_sysctl_get_new_value = 103,
	BPF_FUNC_sysctl_set_new_value = 104,
	BPF_FUNC_strtol = 105,
	BPF_FUNC_strtoul = 106,
	BPF_FUNC_sk_storage_get = 107,
	BPF_FUNC_sk_storage_delete = 108,
	BPF_FUNC_send_signal = 109,
	BPF_FUNC_tcp_gen_syncookie = 110,
	BPF_FUNC_skb_output = 111,
	BPF_FUNC_probe_read_user = 112,
	BPF_FUNC_probe_read_kernel = 113,
	BPF_FUNC_probe_read_user_str = 114,
	BPF_FUNC_probe_read_kernel_str = 115,
	BPF_FUNC_tcp_send_ack = 116,
	BPF_FUNC_send_signal_thread = 117,
	BPF_FUNC_jiffies64 = 118,
	BPF_FUNC_read_branch_records = 119,
	BPF_FUNC_get_ns_current_pid_tgid = 120,
	BPF_FUNC_xdp_output = 121,
	BPF_FUNC_get_netns_cookie = 122,
	BPF_FUNC_get_current_ancestor_cgroup_id = 123,
	BPF_FUNC_sk_assign = 124,
	BPF_FUNC_ktime_get_boot_ns = 125,
	BPF_FUNC_seq_printf = 126,
	BPF_FUNC_seq_write = 127,
	BPF_FUNC_sk_cgroup_id = 128,
	BPF_FUNC_sk_ancestor_cgroup_id = 129,
	BPF_FUNC_ringbuf_output = 130,
	BPF_FUNC_ringbuf_reserve = 131,
	BPF_FUNC_ringbuf_submit = 132,
	BPF_FUNC_ringbuf_discard = 133,
	BPF_FUNC_ringbuf_query = 134,
	BPF_FUNC_csum_level = 135,
	BPF_FUNC_skc_to_tcp6_sock = 136,
	BPF_FUNC_skc_to_tcp_sock = 137,
	BPF_FUNC_skc_to_tcp_timewait_sock = 138,
	BPF_FUNC_skc_to_tcp_request_sock = 139,
	BPF_FUNC_skc_to_udp6_sock = 140,
	BPF_FUNC_get_task_stack = 141,
	BPF_FUNC_load_hdr_opt = 142,
	BPF_FUNC_store_hdr_opt = 143,
	BPF_FUNC_reserve_hdr_opt = 144,
	BPF_FUNC_inode_storage_get = 145,
	BPF_FUNC_inode_storage_delete = 146,
	BPF_FUNC_d_path = 147,
	BPF_FUNC_copy_from_user = 148,
	BPF_FUNC_snprintf_btf = 149,
	BPF_FUNC_seq_printf_btf = 150,
	BPF_FUNC_skb_cgroup_classid = 151,
	BPF_FUNC_redirect_neigh = 152,
	BPF_FUNC_per_cpu_ptr = 153,
	BPF_FUNC_this_cpu_ptr = 154,
	BPF_FUNC_redirect_peer = 155,
	BPF_FUNC_task_storage_get = 156,
	BPF_FUNC_task_storage_delete = 157,
	BPF_FUNC_get_current_task_btf = 158,
	BPF_FUNC_bprm_opts_set = 159,
	BPF_FUNC_ktime_get_coarse_ns = 160,
	BPF_FUNC_ima_inode_hash = 161,
	BPF_FUNC_sock_from_file = 162,
	BPF_FUNC_check_mtu = 163,
	BPF_FUNC_for_each_map_elem = 164,
	BPF_FUNC_snprintf = 165,
	BPF_FUNC_sys_bpf = 166,
	BPF_FUNC_btf_find_by_name_kind = 167,
	BPF_FUNC_sys_close = 168,
	BPF_FUNC_timer_init = 169,
	BPF_FUNC_timer_set_callback = 170,
	BPF_FUNC_timer_start = 171,
	BPF_FUNC_timer_cancel = 172,
	BPF_FUNC_get_func_ip = 173,
	BPF_FUNC_get_attach_cookie = 174,
	BPF_FUNC_task_pt_regs = 175,
	BPF_FUNC_get_branch_snapshot = 176,
	BPF_FUNC_trace_vprintk = 177,
	BPF_FUNC_skc_to_unix_sock = 178,
	BPF_FUNC_kallsyms_lookup_name = 179,
	BPF_FUNC_find_vma = 180,
	BPF_FUNC_loop = 181,
	BPF_FUNC_strncmp = 182,
	BPF_FUNC_get_func_arg = 183,
	BPF_FUNC_get_func_ret = 184,
	BPF_FUNC_get_func_arg_cnt = 185,
	BPF_FUNC_get_retval = 186,
	BPF_FUNC_set_retval = 187,
	BPF_FUNC_xdp_get_buff_len = 188,
	BPF_FUNC_xdp_load_bytes = 189,
	BPF_FUNC_xdp_store_bytes = 190,
	BPF_FUNC_copy_from_user_task = 191,
	BPF_FUNC_skb_set_tstamp = 192,
	BPF_FUNC_ima_file_hash = 193,
	BPF_FUNC_kptr_xchg = 194,
	BPF_FUNC_map_lookup_percpu_elem = 195,
	BPF_FUNC_skc_to_mptcp_sock = 196,
	BPF_FUNC_dynptr_from_mem = 197,
	BPF_FUNC_ringbuf_reserve_dynptr = 198,
	BPF_FUNC_ringbuf_submit_dynptr = 199,
	BPF_FUNC_ringbuf_discard_dynptr = 200,
	BPF_FUNC_dynptr_read = 201,
	BPF_FUNC_dynptr_write = 202,
	BPF_FUNC_dynptr_data = 203,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv4 = 204,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv6 = 205,
	BPF_FUNC_tcp_raw_check_syncookie_ipv4 = 206,
	BPF_FUNC_tcp_raw_check_syncookie_ipv6 = 207,
	BPF_FUNC_ktime_get_tai_ns = 208,
	BPF_FUNC_user_ringbuf_drain = 209,
	BPF_FUNC_cgrp_storage_get = 210,
	BPF_FUNC_cgrp_storage_delete = 211,
	__BPF_FUNC_MAX_ID = 212,
};

enum bpf_hdr_start_off {
	BPF_HDR_START_MAC = 0,
	BPF_HDR_START_NET = 1,
};

enum bpf_iter_feature {
	BPF_ITER_RESCHED = 1,
};

enum bpf_iter_state {
	BPF_ITER_STATE_INVALID = 0,
	BPF_ITER_STATE_ACTIVE = 1,
	BPF_ITER_STATE_DRAINED = 2,
};

enum bpf_iter_task_type {
	BPF_TASK_ITER_ALL = 0,
	BPF_TASK_ITER_TID = 1,
	BPF_TASK_ITER_TGID = 2,
};

enum bpf_jit_poke_reason {
	BPF_POKE_REASON_TAIL_CALL = 0,
};

enum bpf_kfunc_flags {
	BPF_F_PAD_ZEROS = 1,
};

enum bpf_link_type {
	BPF_LINK_TYPE_UNSPEC = 0,
	BPF_LINK_TYPE_RAW_TRACEPOINT = 1,
	BPF_LINK_TYPE_TRACING = 2,
	BPF_LINK_TYPE_CGROUP = 3,
	BPF_LINK_TYPE_ITER = 4,
	BPF_LINK_TYPE_NETNS = 5,
	BPF_LINK_TYPE_XDP = 6,
	BPF_LINK_TYPE_PERF_EVENT = 7,
	BPF_LINK_TYPE_KPROBE_MULTI = 8,
	BPF_LINK_TYPE_STRUCT_OPS = 9,
	BPF_LINK_TYPE_NETFILTER = 10,
	BPF_LINK_TYPE_TCX = 11,
	BPF_LINK_TYPE_UPROBE_MULTI = 12,
	BPF_LINK_TYPE_NETKIT = 13,
	BPF_LINK_TYPE_SOCKMAP = 14,
	__MAX_BPF_LINK_TYPE = 15,
};

enum bpf_lru_list_type {
	BPF_LRU_LIST_T_ACTIVE = 0,
	BPF_LRU_LIST_T_INACTIVE = 1,
	BPF_LRU_LIST_T_FREE = 2,
	BPF_LRU_LOCAL_LIST_T_FREE = 3,
	BPF_LRU_LOCAL_LIST_T_PENDING = 4,
};

enum bpf_map_type {
	BPF_MAP_TYPE_UNSPEC = 0,
	BPF_MAP_TYPE_HASH = 1,
	BPF_MAP_TYPE_ARRAY = 2,
	BPF_MAP_TYPE_PROG_ARRAY = 3,
	BPF_MAP_TYPE_PERF_EVENT_ARRAY = 4,
	BPF_MAP_TYPE_PERCPU_HASH = 5,
	BPF_MAP_TYPE_PERCPU_ARRAY = 6,
	BPF_MAP_TYPE_STACK_TRACE = 7,
	BPF_MAP_TYPE_CGROUP_ARRAY = 8,
	BPF_MAP_TYPE_LRU_HASH = 9,
	BPF_MAP_TYPE_LRU_PERCPU_HASH = 10,
	BPF_MAP_TYPE_LPM_TRIE = 11,
	BPF_MAP_TYPE_ARRAY_OF_MAPS = 12,
	BPF_MAP_TYPE_HASH_OF_MAPS = 13,
	BPF_MAP_TYPE_DEVMAP = 14,
	BPF_MAP_TYPE_SOCKMAP = 15,
	BPF_MAP_TYPE_CPUMAP = 16,
	BPF_MAP_TYPE_XSKMAP = 17,
	BPF_MAP_TYPE_SOCKHASH = 18,
	BPF_MAP_TYPE_CGROUP_STORAGE_DEPRECATED = 19,
	BPF_MAP_TYPE_CGROUP_STORAGE = 19,
	BPF_MAP_TYPE_REUSEPORT_SOCKARRAY = 20,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE_DEPRECATED = 21,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE = 21,
	BPF_MAP_TYPE_QUEUE = 22,
	BPF_MAP_TYPE_STACK = 23,
	BPF_MAP_TYPE_SK_STORAGE = 24,
	BPF_MAP_TYPE_DEVMAP_HASH = 25,
	BPF_MAP_TYPE_STRUCT_OPS = 26,
	BPF_MAP_TYPE_RINGBUF = 27,
	BPF_MAP_TYPE_INODE_STORAGE = 28,
	BPF_MAP_TYPE_TASK_STORAGE = 29,
	BPF_MAP_TYPE_BLOOM_FILTER = 30,
	BPF_MAP_TYPE_USER_RINGBUF = 31,
	BPF_MAP_TYPE_CGRP_STORAGE = 32,
	BPF_MAP_TYPE_ARENA = 33,
	__MAX_BPF_MAP_TYPE = 34,
};

enum bpf_netdev_command {
	XDP_SETUP_PROG = 0,
	XDP_SETUP_PROG_HW = 1,
	BPF_OFFLOAD_MAP_ALLOC = 2,
	BPF_OFFLOAD_MAP_FREE = 3,
	XDP_SETUP_XSK_POOL = 4,
};

enum bpf_perf_event_type {
	BPF_PERF_EVENT_UNSPEC = 0,
	BPF_PERF_EVENT_UPROBE = 1,
	BPF_PERF_EVENT_URETPROBE = 2,
	BPF_PERF_EVENT_KPROBE = 3,
	BPF_PERF_EVENT_KRETPROBE = 4,
	BPF_PERF_EVENT_TRACEPOINT = 5,
	BPF_PERF_EVENT_EVENT = 6,
};

enum bpf_prog_type {
	BPF_PROG_TYPE_UNSPEC = 0,
	BPF_PROG_TYPE_SOCKET_FILTER = 1,
	BPF_PROG_TYPE_KPROBE = 2,
	BPF_PROG_TYPE_SCHED_CLS = 3,
	BPF_PROG_TYPE_SCHED_ACT = 4,
	BPF_PROG_TYPE_TRACEPOINT = 5,
	BPF_PROG_TYPE_XDP = 6,
	BPF_PROG_TYPE_PERF_EVENT = 7,
	BPF_PROG_TYPE_CGROUP_SKB = 8,
	BPF_PROG_TYPE_CGROUP_SOCK = 9,
	BPF_PROG_TYPE_LWT_IN = 10,
	BPF_PROG_TYPE_LWT_OUT = 11,
	BPF_PROG_TYPE_LWT_XMIT = 12,
	BPF_PROG_TYPE_SOCK_OPS = 13,
	BPF_PROG_TYPE_SK_SKB = 14,
	BPF_PROG_TYPE_CGROUP_DEVICE = 15,
	BPF_PROG_TYPE_SK_MSG = 16,
	BPF_PROG_TYPE_RAW_TRACEPOINT = 17,
	BPF_PROG_TYPE_CGROUP_SOCK_ADDR = 18,
	BPF_PROG_TYPE_LWT_SEG6LOCAL = 19,
	BPF_PROG_TYPE_LIRC_MODE2 = 20,
	BPF_PROG_TYPE_SK_REUSEPORT = 21,
	BPF_PROG_TYPE_FLOW_DISSECTOR = 22,
	BPF_PROG_TYPE_CGROUP_SYSCTL = 23,
	BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE = 24,
	BPF_PROG_TYPE_CGROUP_SOCKOPT = 25,
	BPF_PROG_TYPE_TRACING = 26,
	BPF_PROG_TYPE_STRUCT_OPS = 27,
	BPF_PROG_TYPE_EXT = 28,
	BPF_PROG_TYPE_LSM = 29,
	BPF_PROG_TYPE_SK_LOOKUP = 30,
	BPF_PROG_TYPE_SYSCALL = 31,
	BPF_PROG_TYPE_NETFILTER = 32,
	__MAX_BPF_PROG_TYPE = 33,
};

enum bpf_reg_liveness {
	REG_LIVE_NONE = 0,
	REG_LIVE_READ32 = 1,
	REG_LIVE_READ64 = 2,
	REG_LIVE_READ = 3,
	REG_LIVE_WRITTEN = 4,
	REG_LIVE_DONE = 8,
};

enum bpf_reg_type {
	NOT_INIT = 0,
	SCALAR_VALUE = 1,
	PTR_TO_CTX = 2,
	CONST_PTR_TO_MAP = 3,
	PTR_TO_MAP_VALUE = 4,
	PTR_TO_MAP_KEY = 5,
	PTR_TO_STACK = 6,
	PTR_TO_PACKET_META = 7,
	PTR_TO_PACKET = 8,
	PTR_TO_PACKET_END = 9,
	PTR_TO_FLOW_KEYS = 10,
	PTR_TO_SOCKET = 11,
	PTR_TO_SOCK_COMMON = 12,
	PTR_TO_TCP_SOCK = 13,
	PTR_TO_TP_BUFFER = 14,
	PTR_TO_XDP_SOCK = 15,
	PTR_TO_BTF_ID = 16,
	PTR_TO_MEM = 17,
	PTR_TO_ARENA = 18,
	PTR_TO_BUF = 19,
	PTR_TO_FUNC = 20,
	CONST_PTR_TO_DYNPTR = 21,
	__BPF_REG_TYPE_MAX = 22,
	PTR_TO_MAP_VALUE_OR_NULL = 260,
	PTR_TO_SOCKET_OR_NULL = 267,
	PTR_TO_SOCK_COMMON_OR_NULL = 268,
	PTR_TO_TCP_SOCK_OR_NULL = 269,
	PTR_TO_BTF_ID_OR_NULL = 272,
	__BPF_REG_TYPE_LIMIT = 134217727,
};

enum bpf_ret_code {
	BPF_OK = 0,
	BPF_DROP = 2,
	BPF_REDIRECT = 7,
	BPF_LWT_REROUTE = 128,
	BPF_FLOW_DISSECTOR_CONTINUE = 129,
};

enum bpf_return_type {
	RET_INTEGER = 0,
	RET_VOID = 1,
	RET_PTR_TO_MAP_VALUE = 2,
	RET_PTR_TO_SOCKET = 3,
	RET_PTR_TO_TCP_SOCK = 4,
	RET_PTR_TO_SOCK_COMMON = 5,
	RET_PTR_TO_MEM = 6,
	RET_PTR_TO_MEM_OR_BTF_ID = 7,
	RET_PTR_TO_BTF_ID = 8,
	__BPF_RET_TYPE_MAX = 9,
	RET_PTR_TO_MAP_VALUE_OR_NULL = 258,
	RET_PTR_TO_SOCKET_OR_NULL = 259,
	RET_PTR_TO_TCP_SOCK_OR_NULL = 260,
	RET_PTR_TO_SOCK_COMMON_OR_NULL = 261,
	RET_PTR_TO_RINGBUF_MEM_OR_NULL = 1286,
	RET_PTR_TO_DYNPTR_MEM_OR_NULL = 262,
	RET_PTR_TO_BTF_ID_OR_NULL = 264,
	RET_PTR_TO_BTF_ID_TRUSTED = 1048584,
	__BPF_RET_TYPE_LIMIT = 134217727,
};

enum bpf_stack_build_id_status {
	BPF_STACK_BUILD_ID_EMPTY = 0,
	BPF_STACK_BUILD_ID_VALID = 1,
	BPF_STACK_BUILD_ID_IP = 2,
};

enum bpf_stack_slot_type {
	STACK_INVALID = 0,
	STACK_SPILL = 1,
	STACK_MISC = 2,
	STACK_ZERO = 3,
	STACK_DYNPTR = 4,
	STACK_ITER = 5,
	STACK_IRQ_FLAG = 6,
};

enum bpf_stats_type {
	BPF_STATS_RUN_TIME = 0,
};

enum bpf_struct_ops_state {
	BPF_STRUCT_OPS_STATE_INIT = 0,
	BPF_STRUCT_OPS_STATE_INUSE = 1,
	BPF_STRUCT_OPS_STATE_TOBEFREE = 2,
	BPF_STRUCT_OPS_STATE_READY = 3,
};

enum bpf_struct_walk_result {
	WALK_SCALAR = 0,
	WALK_PTR = 1,
	WALK_STRUCT = 2,
};

enum bpf_task_fd_type {
	BPF_FD_TYPE_RAW_TRACEPOINT = 0,
	BPF_FD_TYPE_TRACEPOINT = 1,
	BPF_FD_TYPE_KPROBE = 2,
	BPF_FD_TYPE_KRETPROBE = 3,
	BPF_FD_TYPE_UPROBE = 4,
	BPF_FD_TYPE_URETPROBE = 5,
};

enum bpf_task_vma_iter_find_op {
	task_vma_iter_first_vma = 0,
	task_vma_iter_next_vma = 1,
	task_vma_iter_find_vma = 2,
};

enum bpf_text_poke_type {
	BPF_MOD_CALL = 0,
	BPF_MOD_JUMP = 1,
};

enum bpf_tramp_prog_type {
	BPF_TRAMP_FENTRY = 0,
	BPF_TRAMP_FEXIT = 1,
	BPF_TRAMP_MODIFY_RETURN = 2,
	BPF_TRAMP_MAX = 3,
	BPF_TRAMP_REPLACE = 4,
};

enum bpf_type {
	BPF_TYPE_UNSPEC = 0,
	BPF_TYPE_PROG = 1,
	BPF_TYPE_MAP = 2,
	BPF_TYPE_LINK = 3,
};

enum bpf_type_flag {
	PTR_MAYBE_NULL = 256,
	MEM_RDONLY = 512,
	MEM_RINGBUF = 1024,
	MEM_USER = 2048,
	MEM_PERCPU = 4096,
	OBJ_RELEASE = 8192,
	PTR_UNTRUSTED = 16384,
	MEM_UNINIT = 32768,
	DYNPTR_TYPE_LOCAL = 65536,
	DYNPTR_TYPE_RINGBUF = 131072,
	MEM_FIXED_SIZE = 262144,
	MEM_ALLOC = 524288,
	PTR_TRUSTED = 1048576,
	MEM_RCU = 2097152,
	NON_OWN_REF = 4194304,
	DYNPTR_TYPE_SKB = 8388608,
	DYNPTR_TYPE_XDP = 16777216,
	MEM_ALIGNED = 33554432,
	MEM_WRITE = 67108864,
	__BPF_TYPE_FLAG_MAX = 67108865,
	__BPF_TYPE_LAST_FLAG = 67108864,
};

enum bpf_xdp_mode {
	XDP_MODE_SKB = 0,
	XDP_MODE_DRV = 1,
	XDP_MODE_HW = 2,
	__MAX_XDP_MODE = 3,
};

enum bq27xxx_chip {
	BQ27000 = 1,
	BQ27010 = 2,
	BQ2750X = 3,
	BQ2751X = 4,
	BQ2752X = 5,
	BQ27500 = 6,
	BQ27510G1 = 7,
	BQ27510G2 = 8,
	BQ27510G3 = 9,
	BQ27520G1 = 10,
	BQ27520G2 = 11,
	BQ27520G3 = 12,
	BQ27520G4 = 13,
	BQ27521 = 14,
	BQ27530 = 15,
	BQ27531 = 16,
	BQ27541 = 17,
	BQ27542 = 18,
	BQ27546 = 19,
	BQ27742 = 20,
	BQ27545 = 21,
	BQ27411 = 22,
	BQ27421 = 23,
	BQ27425 = 24,
	BQ27426 = 25,
	BQ27441 = 26,
	BQ27621 = 27,
	BQ27Z561 = 28,
	BQ28Z610 = 29,
	BQ34Z100 = 30,
	BQ78Z100 = 31,
};

enum bq27xxx_dm_reg_id {
	BQ27XXX_DM_DESIGN_CAPACITY = 0,
	BQ27XXX_DM_DESIGN_ENERGY = 1,
	BQ27XXX_DM_TERMINATE_VOLTAGE = 2,
};

enum bq27xxx_reg_index {
	BQ27XXX_REG_CTRL = 0,
	BQ27XXX_REG_TEMP = 1,
	BQ27XXX_REG_INT_TEMP = 2,
	BQ27XXX_REG_VOLT = 3,
	BQ27XXX_REG_AI = 4,
	BQ27XXX_REG_FLAGS = 5,
	BQ27XXX_REG_TTE = 6,
	BQ27XXX_REG_TTF = 7,
	BQ27XXX_REG_TTES = 8,
	BQ27XXX_REG_TTECP = 9,
	BQ27XXX_REG_NAC = 10,
	BQ27XXX_REG_RC = 11,
	BQ27XXX_REG_FCC = 12,
	BQ27XXX_REG_CYCT = 13,
	BQ27XXX_REG_AE = 14,
	BQ27XXX_REG_SOC = 15,
	BQ27XXX_REG_DCAP = 16,
	BQ27XXX_REG_AP = 17,
	BQ27XXX_DM_CTRL = 18,
	BQ27XXX_DM_CLASS = 19,
	BQ27XXX_DM_BLOCK = 20,
	BQ27XXX_DM_DATA = 21,
	BQ27XXX_DM_CKSUM = 22,
	BQ27XXX_REG_SEDVF = 23,
	BQ27XXX_REG_PKCFG = 24,
	BQ27XXX_REG_MAX = 25,
};

enum brcm_family_type {
	BRCM_FAMILY_3390A0 = 0,
	BRCM_FAMILY_4908 = 1,
	BRCM_FAMILY_7250B0 = 2,
	BRCM_FAMILY_7271A0 = 3,
	BRCM_FAMILY_7364A0 = 4,
	BRCM_FAMILY_7366C0 = 5,
	BRCM_FAMILY_74371A0 = 6,
	BRCM_FAMILY_7439B0 = 7,
	BRCM_FAMILY_7445D0 = 8,
	BRCM_FAMILY_7260A0 = 9,
	BRCM_FAMILY_7278A0 = 10,
	BRCM_FAMILY_COUNT = 11,
};

enum brcm_sata_phy_rxaeq_mode {
	RXAEQ_MODE_OFF = 0,
	RXAEQ_MODE_AUTO = 1,
	RXAEQ_MODE_MANUAL = 2,
};

enum brcm_sata_phy_version {
	BRCM_SATA_PHY_STB_16NM = 0,
	BRCM_SATA_PHY_STB_28NM = 1,
	BRCM_SATA_PHY_STB_40NM = 2,
	BRCM_SATA_PHY_IPROC_NS2 = 3,
	BRCM_SATA_PHY_IPROC_NSP = 4,
	BRCM_SATA_PHY_IPROC_SR = 5,
	BRCM_SATA_PHY_DSL_28NM = 6,
};

enum brcm_usb_phy_id {
	BRCM_USB_PHY_2_0 = 0,
	BRCM_USB_PHY_3_0 = 1,
	BRCM_USB_PHY_ID_MAX = 2,
};

enum brcmstb_memc_hwtype {
	BRCMSTB_MEMC_V21 = 0,
	BRCMSTB_MEMC_V20 = 1,
	BRCMSTB_MEMC_V1X = 2,
};

enum brcmusb_reg_sel {
	BRCM_REGS_CTRL = 0,
	BRCM_REGS_XHCI_EC = 1,
	BRCM_REGS_XHCI_GBL = 2,
	BRCM_REGS_USB_PHY = 3,
	BRCM_REGS_USB_MDIO = 4,
	BRCM_REGS_BDC_EC = 5,
	BRCM_REGS_MAX = 6,
};

enum bsc_xfer_cmd {
	CMD_WR = 0,
	CMD_RD = 1,
	CMD_WR_NOACK = 2,
	CMD_RD_NOACK = 3,
};

enum btf_arg_tag {
	ARG_TAG_CTX = 1,
	ARG_TAG_NONNULL = 2,
	ARG_TAG_TRUSTED = 4,
	ARG_TAG_NULLABLE = 8,
	ARG_TAG_ARENA = 16,
};

enum btf_field_iter_kind {
	BTF_FIELD_ITER_IDS = 0,
	BTF_FIELD_ITER_STRS = 1,
};

enum btf_field_type {
	BPF_SPIN_LOCK = 1,
	BPF_TIMER = 2,
	BPF_KPTR_UNREF = 4,
	BPF_KPTR_REF = 8,
	BPF_KPTR_PERCPU = 16,
	BPF_KPTR = 28,
	BPF_LIST_HEAD = 32,
	BPF_LIST_NODE = 64,
	BPF_RB_ROOT = 128,
	BPF_RB_NODE = 256,
	BPF_GRAPH_NODE = 320,
	BPF_GRAPH_ROOT = 160,
	BPF_REFCOUNT = 512,
	BPF_WORKQUEUE = 1024,
	BPF_UPTR = 2048,
	BPF_RES_SPIN_LOCK = 4096,
};

enum btf_func_linkage {
	BTF_FUNC_STATIC = 0,
	BTF_FUNC_GLOBAL = 1,
	BTF_FUNC_EXTERN = 2,
};

enum btf_kfunc_hook {
	BTF_KFUNC_HOOK_COMMON = 0,
	BTF_KFUNC_HOOK_XDP = 1,
	BTF_KFUNC_HOOK_TC = 2,
	BTF_KFUNC_HOOK_STRUCT_OPS = 3,
	BTF_KFUNC_HOOK_TRACING = 4,
	BTF_KFUNC_HOOK_SYSCALL = 5,
	BTF_KFUNC_HOOK_FMODRET = 6,
	BTF_KFUNC_HOOK_CGROUP = 7,
	BTF_KFUNC_HOOK_SCHED_ACT = 8,
	BTF_KFUNC_HOOK_SK_SKB = 9,
	BTF_KFUNC_HOOK_SOCKET_FILTER = 10,
	BTF_KFUNC_HOOK_LWT = 11,
	BTF_KFUNC_HOOK_NETFILTER = 12,
	BTF_KFUNC_HOOK_KPROBE = 13,
	BTF_KFUNC_HOOK_MAX = 14,
};

enum buf_type {
	TYPE_NETSEC_SKB = 0,
	TYPE_NETSEC_XDP_TX = 1,
	TYPE_NETSEC_XDP_NDO = 2,
};

enum buffer_map_state {
	UN_MAPPED = 0,
	PRE_MAPPED = 1,
	MUSB_MAPPED = 2,
};

enum bug_trap_type {
	BUG_TRAP_TYPE_NONE = 0,
	BUG_TRAP_TYPE_WARN = 1,
	BUG_TRAP_TYPE_BUG = 2,
};

enum bus_notifier_event {
	BUS_NOTIFY_ADD_DEVICE = 0,
	BUS_NOTIFY_DEL_DEVICE = 1,
	BUS_NOTIFY_REMOVED_DEVICE = 2,
	BUS_NOTIFY_BIND_DRIVER = 3,
	BUS_NOTIFY_BOUND_DRIVER = 4,
	BUS_NOTIFY_UNBIND_DRIVER = 5,
	BUS_NOTIFY_UNBOUND_DRIVER = 6,
	BUS_NOTIFY_DRIVER_NOT_BOUND = 7,
};

enum bus_speeds {
	SPD_375K = 0,
	SPD_390K = 1,
	SPD_187K = 2,
	SPD_200K = 3,
	SPD_93K = 4,
	SPD_97K = 5,
	SPD_46K = 6,
	SPD_50K = 7,
};

enum cache_indexing {
	NODE_CACHE_DIRECT_MAP = 0,
	NODE_CACHE_INDEXED = 1,
	NODE_CACHE_OTHER = 2,
};

enum cache_mode {
	NODE_CACHE_ADDR_MODE_RESERVED = 0,
	NODE_CACHE_ADDR_MODE_EXTENDED_LINEAR = 1,
};

enum cache_type {
	CACHE_TYPE_NOCACHE = 0,
	CACHE_TYPE_INST = 1,
	CACHE_TYPE_DATA = 2,
	CACHE_TYPE_SEPARATE = 3,
	CACHE_TYPE_UNIFIED = 4,
};

enum cache_write_policy {
	NODE_CACHE_WRITE_BACK = 0,
	NODE_CACHE_WRITE_THROUGH = 1,
	NODE_CACHE_WRITE_OTHER = 2,
};

enum cavium_mdiobus_mode {
	UNINIT = 0,
	C22 = 1,
	C45 = 2,
};

enum cc_attr {
	CC_ATTR_MEM_ENCRYPT = 0,
	CC_ATTR_HOST_MEM_ENCRYPT = 1,
	CC_ATTR_GUEST_MEM_ENCRYPT = 2,
	CC_ATTR_GUEST_STATE_ENCRYPT = 3,
	CC_ATTR_GUEST_UNROLL_STRING_IO = 4,
	CC_ATTR_GUEST_SEV_SNP = 5,
	CC_ATTR_GUEST_SNP_SECURE_TSC = 6,
	CC_ATTR_HOST_SEV_SNP = 7,
};

enum cd_types {
	ESDHC_CD_NONE = 0,
	ESDHC_CD_CONTROLLER = 1,
	ESDHC_CD_GPIO = 2,
	ESDHC_CD_PERMANENT = 3,
};

enum cea_audio_coding_types {
	AUDIO_CODING_TYPE_REF_STREAM_HEADER = 0,
	AUDIO_CODING_TYPE_LPCM = 1,
	AUDIO_CODING_TYPE_AC3 = 2,
	AUDIO_CODING_TYPE_MPEG1 = 3,
	AUDIO_CODING_TYPE_MP3 = 4,
	AUDIO_CODING_TYPE_MPEG2 = 5,
	AUDIO_CODING_TYPE_AACLC = 6,
	AUDIO_CODING_TYPE_DTS = 7,
	AUDIO_CODING_TYPE_ATRAC = 8,
	AUDIO_CODING_TYPE_SACD = 9,
	AUDIO_CODING_TYPE_EAC3 = 10,
	AUDIO_CODING_TYPE_DTS_HD = 11,
	AUDIO_CODING_TYPE_MLP = 12,
	AUDIO_CODING_TYPE_DST = 13,
	AUDIO_CODING_TYPE_WMAPRO = 14,
	AUDIO_CODING_TYPE_REF_CXT = 15,
	AUDIO_CODING_TYPE_HE_AAC = 15,
	AUDIO_CODING_TYPE_HE_AAC2 = 16,
	AUDIO_CODING_TYPE_MPEG_SURROUND = 17,
};

enum cea_audio_coding_xtypes {
	AUDIO_CODING_XTYPE_HE_REF_CT = 0,
	AUDIO_CODING_XTYPE_HE_AAC = 1,
	AUDIO_CODING_XTYPE_HE_AAC2 = 2,
	AUDIO_CODING_XTYPE_MPEG_SURROUND = 3,
	AUDIO_CODING_XTYPE_FIRST_RESERVED = 4,
};

enum cfi_quirks {
	CFI_QUIRK_DQ_TRUE_DATA = 1,
};

enum cgroup1_param {
	Opt_all = 0,
	Opt_clone_children = 1,
	Opt_cpuset_v2_mode = 2,
	Opt_name = 3,
	Opt_none = 4,
	Opt_noprefix = 5,
	Opt_release_agent = 6,
	Opt_xattr = 7,
	Opt_favordynmods = 8,
	Opt_nofavordynmods = 9,
};

enum cgroup2_param {
	Opt_nsdelegate = 0,
	Opt_favordynmods___2 = 1,
	Opt_memory_localevents = 2,
	Opt_memory_recursiveprot = 3,
	Opt_memory_hugetlb_accounting = 4,
	Opt_pids_localevents = 5,
	nr__cgroup2_params = 6,
};

enum cgroup_bpf_attach_type {
	CGROUP_BPF_ATTACH_TYPE_INVALID = -1,
	CGROUP_INET_INGRESS = 0,
	CGROUP_INET_EGRESS = 1,
	CGROUP_INET_SOCK_CREATE = 2,
	CGROUP_SOCK_OPS = 3,
	CGROUP_DEVICE = 4,
	CGROUP_INET4_BIND = 5,
	CGROUP_INET6_BIND = 6,
	CGROUP_INET4_CONNECT = 7,
	CGROUP_INET6_CONNECT = 8,
	CGROUP_UNIX_CONNECT = 9,
	CGROUP_INET4_POST_BIND = 10,
	CGROUP_INET6_POST_BIND = 11,
	CGROUP_UDP4_SENDMSG = 12,
	CGROUP_UDP6_SENDMSG = 13,
	CGROUP_UNIX_SENDMSG = 14,
	CGROUP_SYSCTL = 15,
	CGROUP_UDP4_RECVMSG = 16,
	CGROUP_UDP6_RECVMSG = 17,
	CGROUP_UNIX_RECVMSG = 18,
	CGROUP_GETSOCKOPT = 19,
	CGROUP_SETSOCKOPT = 20,
	CGROUP_INET4_GETPEERNAME = 21,
	CGROUP_INET6_GETPEERNAME = 22,
	CGROUP_UNIX_GETPEERNAME = 23,
	CGROUP_INET4_GETSOCKNAME = 24,
	CGROUP_INET6_GETSOCKNAME = 25,
	CGROUP_UNIX_GETSOCKNAME = 26,
	CGROUP_INET_SOCK_RELEASE = 27,
	CGROUP_LSM_START = 28,
	CGROUP_LSM_END = 27,
	MAX_CGROUP_BPF_ATTACH_TYPE = 28,
};

enum cgroup_filetype {
	CGROUP_FILE_PROCS = 0,
	CGROUP_FILE_TASKS = 1,
};

enum cgroup_lifetime_events {
	CGROUP_LIFETIME_ONLINE = 0,
	CGROUP_LIFETIME_OFFLINE = 1,
};

enum cgroup_opt_features {
	OPT_FEATURE_COUNT = 0,
};

enum cgroup_subsys_id {
	cpuset_cgrp_id = 0,
	cpu_cgrp_id = 1,
	cpuacct_cgrp_id = 2,
	io_cgrp_id = 3,
	memory_cgrp_id = 4,
	devices_cgrp_id = 5,
	freezer_cgrp_id = 6,
	perf_event_cgrp_id = 7,
	hugetlb_cgrp_id = 8,
	pids_cgrp_id = 9,
	CGROUP_SUBSYS_COUNT = 10,
};

enum cgt_group_id {
	__RESERVED__ = 0,
	CGT_HCR_TID1 = 1,
	CGT_HCR_TID2 = 2,
	CGT_HCR_TID3 = 3,
	CGT_HCR_IMO = 4,
	CGT_HCR_FMO = 5,
	CGT_HCR_TIDCP = 6,
	CGT_HCR_TACR = 7,
	CGT_HCR_TSW = 8,
	CGT_HCR_TPC = 9,
	CGT_HCR_TPU = 10,
	CGT_HCR_TTLB = 11,
	CGT_HCR_TVM = 12,
	CGT_HCR_TDZ = 13,
	CGT_HCR_TRVM = 14,
	CGT_HCR_TLOR = 15,
	CGT_HCR_TERR = 16,
	CGT_HCR_APK = 17,
	CGT_HCR_NV = 18,
	CGT_HCR_NV_nNV2 = 19,
	CGT_HCR_NV1_nNV2 = 20,
	CGT_HCR_AT = 21,
	CGT_HCR_nFIEN = 22,
	CGT_HCR_TID4 = 23,
	CGT_HCR_TICAB = 24,
	CGT_HCR_TOCU = 25,
	CGT_HCR_ENSCXT = 26,
	CGT_HCR_TTLBIS = 27,
	CGT_HCR_TTLBOS = 28,
	CGT_MDCR_TPMCR = 29,
	CGT_MDCR_TPM = 30,
	CGT_MDCR_TDE = 31,
	CGT_MDCR_TDA = 32,
	CGT_MDCR_TDOSA = 33,
	CGT_MDCR_TDRA = 34,
	CGT_MDCR_E2PB = 35,
	CGT_MDCR_TPMS = 36,
	CGT_MDCR_TTRF = 37,
	CGT_MDCR_E2TB = 38,
	CGT_MDCR_TDCC = 39,
	CGT_CPTR_TAM = 40,
	CGT_CPTR_TCPAC = 41,
	CGT_HCRX_EnFPM = 42,
	CGT_HCRX_TCR2En = 43,
	CGT_CNTHCTL_EL1TVT = 44,
	CGT_CNTHCTL_EL1TVCT = 45,
	CGT_ICH_HCR_TC = 46,
	CGT_ICH_HCR_TALL0 = 47,
	CGT_ICH_HCR_TALL1 = 48,
	CGT_ICH_HCR_TDIR = 49,
	__MULTIPLE_CONTROL_BITS__ = 50,
	CGT_HCR_IMO_FMO_ICH_HCR_TC = 50,
	CGT_HCR_TID2_TID4 = 51,
	CGT_HCR_TTLB_TTLBIS = 52,
	CGT_HCR_TTLB_TTLBOS = 53,
	CGT_HCR_TVM_TRVM = 54,
	CGT_HCR_TVM_TRVM_HCRX_TCR2En = 55,
	CGT_HCR_TPU_TICAB = 56,
	CGT_HCR_TPU_TOCU = 57,
	CGT_HCR_NV1_nNV2_ENSCXT = 58,
	CGT_MDCR_TPM_TPMCR = 59,
	CGT_MDCR_TPM_HPMN = 60,
	CGT_MDCR_TDE_TDA = 61,
	CGT_MDCR_TDE_TDOSA = 62,
	CGT_MDCR_TDE_TDRA = 63,
	CGT_MDCR_TDCC_TDE_TDA = 64,
	CGT_ICH_HCR_TC_TDIR = 65,
	__COMPLEX_CONDITIONS__ = 66,
	CGT_CNTHCTL_EL1PCTEN = 66,
	CGT_CNTHCTL_EL1PTEN = 67,
	CGT_CNTHCTL_EL1NVPCT = 68,
	CGT_CNTHCTL_EL1NVVCT = 69,
	CGT_CPTR_TTA = 70,
	CGT_MDCR_HPMN = 71,
	__NR_CGT_GROUP_IDS__ = 72,
};

enum ch_command {
	HIDMA_CH_DISABLE = 0,
	HIDMA_CH_ENABLE = 1,
	HIDMA_CH_SUSPEND = 2,
	HIDMA_CH_RESET = 9,
};

enum ch_state {
	HIDMA_CH_DISABLED = 0,
	HIDMA_CH_ENABLED = 1,
	HIDMA_CH_RUNNING = 2,
	HIDMA_CH_SUSPENDED = 3,
	HIDMA_CH_STOPPED = 4,
};

enum chacha_constants {
	CHACHA_CONSTANT_EXPA = 1634760805,
	CHACHA_CONSTANT_ND_3 = 857760878,
	CHACHA_CONSTANT_2_BY = 2036477234,
	CHACHA_CONSTANT_TE_K = 1797285236,
};

enum chip_id {
	MT6323_CHIP_ID = 35,
	MT6328_CHIP_ID = 48,
	MT6331_CHIP_ID = 32,
	MT6332_CHIP_ID = 32,
	MT6357_CHIP_ID = 87,
	MT6358_CHIP_ID = 88,
	MT6359_CHIP_ID = 89,
	MT6366_CHIP_ID = 102,
	MT6391_CHIP_ID = 145,
	MT6397_CHIP_ID = 151,
};

enum chips {
	PFUZE100 = 0,
	PFUZE200 = 1,
	PFUZE3000 = 3,
	PFUZE3001 = 49,
};

enum ci_hw_regs {
	CAP_CAPLENGTH = 0,
	CAP_HCCPARAMS = 1,
	CAP_DCCPARAMS = 2,
	CAP_TESTMODE = 3,
	CAP_LAST = 3,
	OP_USBCMD = 4,
	OP_USBSTS = 5,
	OP_USBINTR = 6,
	OP_FRINDEX = 7,
	OP_DEVICEADDR = 8,
	OP_ENDPTLISTADDR = 9,
	OP_TTCTRL = 10,
	OP_BURSTSIZE = 11,
	OP_ULPI_VIEWPORT = 12,
	OP_PORTSC = 13,
	OP_DEVLC = 14,
	OP_OTGSC = 15,
	OP_USBMODE = 16,
	OP_ENDPTSETUPSTAT = 17,
	OP_ENDPTPRIME = 18,
	OP_ENDPTFLUSH = 19,
	OP_ENDPTSTAT = 20,
	OP_ENDPTCOMPLETE = 21,
	OP_ENDPTCTRL = 22,
	OP_LAST = 38,
};

enum ci_revision {
	CI_REVISION_1X = 10,
	CI_REVISION_20 = 20,
	CI_REVISION_21 = 21,
	CI_REVISION_22 = 22,
	CI_REVISION_23 = 23,
	CI_REVISION_24 = 24,
	CI_REVISION_25 = 25,
	CI_REVISION_25_PLUS = 26,
	CI_REVISION_UNKNOWN = 99,
};

enum ci_role {
	CI_ROLE_HOST = 0,
	CI_ROLE_GADGET = 1,
	CI_ROLE_END = 2,
};

enum clear_refs_types {
	CLEAR_REFS_ALL = 1,
	CLEAR_REFS_ANON = 2,
	CLEAR_REFS_MAPPED = 3,
	CLEAR_REFS_SOFT_DIRTY = 4,
	CLEAR_REFS_MM_HIWATER_RSS = 5,
	CLEAR_REFS_LAST = 6,
};

enum clk_gating_state {
	CLKS_OFF = 0,
	CLKS_ON = 1,
	REQ_CLKS_OFF = 2,
	REQ_CLKS_ON = 3,
};

enum clk_id {
	tegra_clk_actmon = 0,
	tegra_clk_adx = 1,
	tegra_clk_adx1 = 2,
	tegra_clk_afi = 3,
	tegra_clk_amx = 4,
	tegra_clk_amx1 = 5,
	tegra_clk_apb2ape = 6,
	tegra_clk_ahbdma = 7,
	tegra_clk_apbdma = 8,
	tegra_clk_apbif = 9,
	tegra_clk_ape = 10,
	tegra_clk_audio0 = 11,
	tegra_clk_audio0_2x = 12,
	tegra_clk_audio0_mux = 13,
	tegra_clk_audio1 = 14,
	tegra_clk_audio1_2x = 15,
	tegra_clk_audio1_mux = 16,
	tegra_clk_audio2 = 17,
	tegra_clk_audio2_2x = 18,
	tegra_clk_audio2_mux = 19,
	tegra_clk_audio3 = 20,
	tegra_clk_audio3_2x = 21,
	tegra_clk_audio3_mux = 22,
	tegra_clk_audio4 = 23,
	tegra_clk_audio4_2x = 24,
	tegra_clk_audio4_mux = 25,
	tegra_clk_bsea = 26,
	tegra_clk_bsev = 27,
	tegra_clk_cclk_g = 28,
	tegra_clk_cclk_lp = 29,
	tegra_clk_cilab = 30,
	tegra_clk_cilcd = 31,
	tegra_clk_cile = 32,
	tegra_clk_clk_32k = 33,
	tegra_clk_clk72Mhz = 34,
	tegra_clk_clk72Mhz_8 = 35,
	tegra_clk_clk_m = 36,
	tegra_clk_osc = 37,
	tegra_clk_osc_div2 = 38,
	tegra_clk_osc_div4 = 39,
	tegra_clk_cml0 = 40,
	tegra_clk_cml1 = 41,
	tegra_clk_csi = 42,
	tegra_clk_csite = 43,
	tegra_clk_csite_8 = 44,
	tegra_clk_csus = 45,
	tegra_clk_cve = 46,
	tegra_clk_dam0 = 47,
	tegra_clk_dam1 = 48,
	tegra_clk_dam2 = 49,
	tegra_clk_d_audio = 50,
	tegra_clk_dbgapb = 51,
	tegra_clk_dds = 52,
	tegra_clk_dfll_ref = 53,
	tegra_clk_dfll_soc = 54,
	tegra_clk_disp1 = 55,
	tegra_clk_disp1_8 = 56,
	tegra_clk_disp2 = 57,
	tegra_clk_disp2_8 = 58,
	tegra_clk_dp2 = 59,
	tegra_clk_dpaux = 60,
	tegra_clk_dpaux1 = 61,
	tegra_clk_dsialp = 62,
	tegra_clk_dsia_mux = 63,
	tegra_clk_dsiblp = 64,
	tegra_clk_dsib_mux = 65,
	tegra_clk_dtv = 66,
	tegra_clk_emc = 67,
	tegra_clk_entropy = 68,
	tegra_clk_entropy_8 = 69,
	tegra_clk_epp = 70,
	tegra_clk_epp_8 = 71,
	tegra_clk_extern1 = 72,
	tegra_clk_extern2 = 73,
	tegra_clk_extern3 = 74,
	tegra_clk_fuse = 75,
	tegra_clk_fuse_burn = 76,
	tegra_clk_gpu = 77,
	tegra_clk_gr2d = 78,
	tegra_clk_gr2d_8 = 79,
	tegra_clk_gr3d = 80,
	tegra_clk_gr3d_8 = 81,
	tegra_clk_hclk = 82,
	tegra_clk_hda = 83,
	tegra_clk_hda_8 = 84,
	tegra_clk_hda2codec_2x = 85,
	tegra_clk_hda2codec_2x_8 = 86,
	tegra_clk_hda2hdmi = 87,
	tegra_clk_hdmi = 88,
	tegra_clk_hdmi_audio = 89,
	tegra_clk_host1x = 90,
	tegra_clk_host1x_8 = 91,
	tegra_clk_host1x_9 = 92,
	tegra_clk_hsic_trk = 93,
	tegra_clk_i2c1 = 94,
	tegra_clk_i2c2 = 95,
	tegra_clk_i2c3 = 96,
	tegra_clk_i2c4 = 97,
	tegra_clk_i2c5 = 98,
	tegra_clk_i2c6 = 99,
	tegra_clk_i2cslow = 100,
	tegra_clk_i2s0 = 101,
	tegra_clk_i2s0_sync = 102,
	tegra_clk_i2s1 = 103,
	tegra_clk_i2s1_sync = 104,
	tegra_clk_i2s2 = 105,
	tegra_clk_i2s2_sync = 106,
	tegra_clk_i2s3 = 107,
	tegra_clk_i2s3_sync = 108,
	tegra_clk_i2s4 = 109,
	tegra_clk_i2s4_sync = 110,
	tegra_clk_isp = 111,
	tegra_clk_isp_8 = 112,
	tegra_clk_isp_9 = 113,
	tegra_clk_ispb = 114,
	tegra_clk_kbc = 115,
	tegra_clk_kfuse = 116,
	tegra_clk_la = 117,
	tegra_clk_maud = 118,
	tegra_clk_mipi = 119,
	tegra_clk_mipibif = 120,
	tegra_clk_mipi_cal = 121,
	tegra_clk_mpe = 122,
	tegra_clk_mselect = 123,
	tegra_clk_msenc = 124,
	tegra_clk_ndflash = 125,
	tegra_clk_ndflash_8 = 126,
	tegra_clk_ndspeed = 127,
	tegra_clk_ndspeed_8 = 128,
	tegra_clk_nor = 129,
	tegra_clk_nvdec = 130,
	tegra_clk_nvenc = 131,
	tegra_clk_nvjpg = 132,
	tegra_clk_owr = 133,
	tegra_clk_owr_8 = 134,
	tegra_clk_pcie = 135,
	tegra_clk_pclk = 136,
	tegra_clk_pll_a = 137,
	tegra_clk_pll_a_out0 = 138,
	tegra_clk_pll_a1 = 139,
	tegra_clk_pll_c = 140,
	tegra_clk_pll_c2 = 141,
	tegra_clk_pll_c3 = 142,
	tegra_clk_pll_c4 = 143,
	tegra_clk_pll_c4_out0 = 144,
	tegra_clk_pll_c4_out1 = 145,
	tegra_clk_pll_c4_out2 = 146,
	tegra_clk_pll_c4_out3 = 147,
	tegra_clk_pll_c_out1 = 148,
	tegra_clk_pll_d = 149,
	tegra_clk_pll_d2 = 150,
	tegra_clk_pll_d2_out0 = 151,
	tegra_clk_pll_d_out0 = 152,
	tegra_clk_pll_dp = 153,
	tegra_clk_pll_e_out0 = 154,
	tegra_clk_pll_g_ref = 155,
	tegra_clk_pll_m = 156,
	tegra_clk_pll_m_out1 = 157,
	tegra_clk_pll_mb = 158,
	tegra_clk_pll_p = 159,
	tegra_clk_pll_p_out1 = 160,
	tegra_clk_pll_p_out2 = 161,
	tegra_clk_pll_p_out2_int = 162,
	tegra_clk_pll_p_out3 = 163,
	tegra_clk_pll_p_out4 = 164,
	tegra_clk_pll_p_out4_cpu = 165,
	tegra_clk_pll_p_out5 = 166,
	tegra_clk_pll_p_out_hsio = 167,
	tegra_clk_pll_p_out_xusb = 168,
	tegra_clk_pll_p_out_cpu = 169,
	tegra_clk_pll_p_out_adsp = 170,
	tegra_clk_pll_ref = 171,
	tegra_clk_pll_re_out = 172,
	tegra_clk_pll_re_vco = 173,
	tegra_clk_pll_u = 174,
	tegra_clk_pll_u_out = 175,
	tegra_clk_pll_u_out1 = 176,
	tegra_clk_pll_u_out2 = 177,
	tegra_clk_pll_u_12m = 178,
	tegra_clk_pll_u_480m = 179,
	tegra_clk_pll_u_48m = 180,
	tegra_clk_pll_u_60m = 181,
	tegra_clk_pll_x = 182,
	tegra_clk_pll_x_out0 = 183,
	tegra_clk_pwm = 184,
	tegra_clk_qspi = 185,
	tegra_clk_rtc = 186,
	tegra_clk_sata = 187,
	tegra_clk_sata_8 = 188,
	tegra_clk_sata_cold = 189,
	tegra_clk_sata_oob = 190,
	tegra_clk_sata_oob_8 = 191,
	tegra_clk_sbc1 = 192,
	tegra_clk_sbc1_8 = 193,
	tegra_clk_sbc1_9 = 194,
	tegra_clk_sbc2 = 195,
	tegra_clk_sbc2_8 = 196,
	tegra_clk_sbc2_9 = 197,
	tegra_clk_sbc3 = 198,
	tegra_clk_sbc3_8 = 199,
	tegra_clk_sbc3_9 = 200,
	tegra_clk_sbc4 = 201,
	tegra_clk_sbc4_8 = 202,
	tegra_clk_sbc4_9 = 203,
	tegra_clk_sbc5 = 204,
	tegra_clk_sbc5_8 = 205,
	tegra_clk_sbc6 = 206,
	tegra_clk_sbc6_8 = 207,
	tegra_clk_sclk = 208,
	tegra_clk_sdmmc_legacy = 209,
	tegra_clk_sdmmc1 = 210,
	tegra_clk_sdmmc1_8 = 211,
	tegra_clk_sdmmc1_9 = 212,
	tegra_clk_sdmmc2 = 213,
	tegra_clk_sdmmc2_8 = 214,
	tegra_clk_sdmmc3 = 215,
	tegra_clk_sdmmc3_8 = 216,
	tegra_clk_sdmmc3_9 = 217,
	tegra_clk_sdmmc4 = 218,
	tegra_clk_sdmmc4_8 = 219,
	tegra_clk_se = 220,
	tegra_clk_se_10 = 221,
	tegra_clk_soc_therm = 222,
	tegra_clk_soc_therm_8 = 223,
	tegra_clk_sor0 = 224,
	tegra_clk_sor0_out = 225,
	tegra_clk_sor1 = 226,
	tegra_clk_sor1_out = 227,
	tegra_clk_spdif = 228,
	tegra_clk_spdif_2x = 229,
	tegra_clk_spdif_in = 230,
	tegra_clk_spdif_in_8 = 231,
	tegra_clk_spdif_in_sync = 232,
	tegra_clk_spdif_mux = 233,
	tegra_clk_spdif_out = 234,
	tegra_clk_timer = 235,
	tegra_clk_trace = 236,
	tegra_clk_tsec = 237,
	tegra_clk_tsec_8 = 238,
	tegra_clk_tsecb = 239,
	tegra_clk_tsensor = 240,
	tegra_clk_tvdac = 241,
	tegra_clk_tvo = 242,
	tegra_clk_uarta = 243,
	tegra_clk_uarta_8 = 244,
	tegra_clk_uartb = 245,
	tegra_clk_uartb_8 = 246,
	tegra_clk_uartc = 247,
	tegra_clk_uartc_8 = 248,
	tegra_clk_uartd = 249,
	tegra_clk_uartd_8 = 250,
	tegra_clk_uarte = 251,
	tegra_clk_uarte_8 = 252,
	tegra_clk_uartape = 253,
	tegra_clk_usb2 = 254,
	tegra_clk_usb2_hsic_trk = 255,
	tegra_clk_usb2_trk = 256,
	tegra_clk_usb3 = 257,
	tegra_clk_usbd = 258,
	tegra_clk_vcp = 259,
	tegra_clk_vde = 260,
	tegra_clk_vde_8 = 261,
	tegra_clk_vfir = 262,
	tegra_clk_vi = 263,
	tegra_clk_vi_8 = 264,
	tegra_clk_vi_9 = 265,
	tegra_clk_vi_10 = 266,
	tegra_clk_vi_i2c = 267,
	tegra_clk_vic03 = 268,
	tegra_clk_vic03_8 = 269,
	tegra_clk_vim2_clk = 270,
	tegra_clk_vimclk_sync = 271,
	tegra_clk_vi_sensor = 272,
	tegra_clk_vi_sensor_8 = 273,
	tegra_clk_vi_sensor_9 = 274,
	tegra_clk_vi_sensor2 = 275,
	tegra_clk_vi_sensor2_8 = 276,
	tegra_clk_xusb_dev = 277,
	tegra_clk_xusb_dev_src = 278,
	tegra_clk_xusb_dev_src_8 = 279,
	tegra_clk_xusb_falcon_src = 280,
	tegra_clk_xusb_falcon_src_8 = 281,
	tegra_clk_xusb_fs_src = 282,
	tegra_clk_xusb_gate = 283,
	tegra_clk_xusb_host = 284,
	tegra_clk_xusb_host_src = 285,
	tegra_clk_xusb_host_src_8 = 286,
	tegra_clk_xusb_hs_src = 287,
	tegra_clk_xusb_hs_src_4 = 288,
	tegra_clk_xusb_ss = 289,
	tegra_clk_xusb_ss_src = 290,
	tegra_clk_xusb_ss_src_8 = 291,
	tegra_clk_xusb_ss_div2 = 292,
	tegra_clk_xusb_ssp_src = 293,
	tegra_clk_sclk_mux = 294,
	tegra_clk_sor_safe = 295,
	tegra_clk_cec = 296,
	tegra_clk_ispa = 297,
	tegra_clk_dmic1 = 298,
	tegra_clk_dmic2 = 299,
	tegra_clk_dmic3 = 300,
	tegra_clk_dmic1_sync_clk = 301,
	tegra_clk_dmic2_sync_clk = 302,
	tegra_clk_dmic3_sync_clk = 303,
	tegra_clk_dmic1_sync_clk_mux = 304,
	tegra_clk_dmic2_sync_clk_mux = 305,
	tegra_clk_dmic3_sync_clk_mux = 306,
	tegra_clk_iqc1 = 307,
	tegra_clk_iqc2 = 308,
	tegra_clk_pll_a_out_adsp = 309,
	tegra_clk_pll_a_out0_out_adsp = 310,
	tegra_clk_adsp = 311,
	tegra_clk_adsp_neon = 312,
	tegra_clk_max = 313,
};

enum clk_id___2 {
	CLK_NONE = 0,
	CLK_MM = 1,
	CLK_MFG = 2,
	CLK_VENC = 3,
	CLK_VENC_LT = 4,
	CLK_ETHIF = 5,
	CLK_VDEC = 6,
	CLK_HIFSEL = 7,
	CLK_JPGDEC = 8,
	CLK_AUDIO = 9,
	CLK_MAX = 10,
};

enum clk_ids {
	LAST_DT_CORE_CLK = 11,
	CLK_AUDIO_EXTAL = 12,
	CLK_RTXIN = 13,
	CLK_QEXTAL = 14,
	CLK_PLLCM33 = 15,
	CLK_PLLCLN = 16,
	CLK_PLLDTY = 17,
	CLK_PLLCA55 = 18,
	CLK_PLLCM33_DIV16 = 19,
	CLK_PLLCLN_DIV2 = 20,
	CLK_PLLCLN_DIV8 = 21,
	CLK_PLLDTY_ACPU = 22,
	CLK_PLLDTY_ACPU_DIV4 = 23,
	MOD_CLK_BASE = 24,
};

enum clk_ids___2 {
	LAST_DT_CORE_CLK___2 = 18,
	CLK_EXTAL = 19,
	CLK_OSC_DIV1000 = 20,
	CLK_PLL1 = 21,
	CLK_PLL2 = 22,
	CLK_PLL2_DIV2 = 23,
	CLK_PLL2_DIV2_8 = 24,
	CLK_PLL2_DIV2_10 = 25,
	CLK_PLL3 = 26,
	CLK_PLL3_400 = 27,
	CLK_PLL3_533 = 28,
	CLK_PLL3_DIV2 = 29,
	CLK_PLL3_DIV2_4 = 30,
	CLK_PLL3_DIV2_4_2 = 31,
	CLK_SEL_PLL3_3 = 32,
	CLK_DIV_PLL3_C = 33,
	CLK_M2_DIV2 = 34,
	CLK_PLL5 = 35,
	CLK_PLL5_500 = 36,
	CLK_PLL5_250 = 37,
	CLK_PLL5_FOUTPOSTDIV = 38,
	CLK_DSI_DIV = 39,
	CLK_PLL6 = 40,
	CLK_PLL6_250 = 41,
	CLK_P1_DIV2 = 42,
	CLK_PLL2_800 = 43,
	CLK_PLL2_SDHI_533 = 44,
	CLK_PLL2_SDHI_400 = 45,
	CLK_PLL2_SDHI_266 = 46,
	CLK_SD0_DIV4 = 47,
	CLK_SD1_DIV4 = 48,
	MOD_CLK_BASE___2 = 49,
};

enum clk_ids___3 {
	LAST_DT_CORE_CLK___3 = 25,
	CLK_EXTAL___2 = 26,
	CLK_OSC_DIV1000___2 = 27,
	CLK_PLL1___2 = 28,
	CLK_PLL2___2 = 29,
	CLK_PLL2_DIV2___2 = 30,
	CLK_PLL2_DIV2_8___2 = 31,
	CLK_PLL2_DIV2_10___2 = 32,
	CLK_PLL3___2 = 33,
	CLK_PLL3_400___2 = 34,
	CLK_PLL3_533___2 = 35,
	CLK_M2_DIV2___2 = 36,
	CLK_PLL3_DIV2___2 = 37,
	CLK_PLL3_DIV2_2 = 38,
	CLK_PLL3_DIV2_4___2 = 39,
	CLK_PLL3_DIV2_4_2___2 = 40,
	CLK_SEL_PLL3_3___2 = 41,
	CLK_DIV_PLL3_C___2 = 42,
	CLK_PLL4 = 43,
	CLK_PLL5___2 = 44,
	CLK_PLL5_FOUTPOSTDIV___2 = 45,
	CLK_PLL5_FOUT1PH0 = 46,
	CLK_PLL5_FOUT3 = 47,
	CLK_PLL5_250___2 = 48,
	CLK_PLL6___2 = 49,
	CLK_PLL6_250___2 = 50,
	CLK_P1_DIV2___2 = 51,
	CLK_PLL2_800___2 = 52,
	CLK_PLL2_SDHI_533___2 = 53,
	CLK_PLL2_SDHI_400___2 = 54,
	CLK_PLL2_SDHI_266___2 = 55,
	CLK_SD0_DIV4___2 = 56,
	CLK_SD1_DIV4___2 = 57,
	CLK_SEL_GPU2 = 58,
	CLK_SEL_PLL5_4 = 59,
	CLK_DSI_DIV___2 = 60,
	CLK_PLL2_533 = 61,
	CLK_PLL2_533_DIV2 = 62,
	CLK_DIV_DSI_LPCLK = 63,
	MOD_CLK_BASE___3 = 64,
};

enum clk_ids___4 {
	LAST_DT_CORE_CLK___4 = 42,
	CLK_EXTAL___3 = 43,
	CLK_EXTALR = 44,
	CLK_MAIN = 45,
	CLK_PLL1___3 = 46,
	CLK_PLL20 = 47,
	CLK_PLL21 = 48,
	CLK_PLL30 = 49,
	CLK_PLL31 = 50,
	CLK_PLL5___3 = 51,
	CLK_PLL1_DIV2 = 52,
	CLK_PLL20_DIV2 = 53,
	CLK_PLL21_DIV2 = 54,
	CLK_PLL30_DIV2 = 55,
	CLK_PLL31_DIV2 = 56,
	CLK_PLL5_DIV2 = 57,
	CLK_PLL5_DIV4 = 58,
	CLK_S1 = 59,
	CLK_S3 = 60,
	CLK_SDSRC = 61,
	CLK_RPCSRC = 62,
	CLK_OCO = 63,
	MOD_CLK_BASE___4 = 64,
};

enum clk_ids___5 {
	LAST_DT_CORE_CLK___5 = 30,
	CLK_EXTAL___4 = 31,
	CLK_EXTALR___2 = 32,
	CLK_MAIN___2 = 33,
	CLK_PLL0 = 34,
	CLK_PLL1___4 = 35,
	CLK_PLL3___3 = 36,
	CLK_PLL1_DIV2___2 = 37,
	CLK_PLL1_DIV4 = 38,
	MOD_CLK_BASE___5 = 39,
};

enum clk_ids___6 {
	LAST_DT_CORE_CLK___6 = 12,
	CLK_AUDIO_EXTAL___2 = 13,
	CLK_RTXIN___2 = 14,
	CLK_QEXTAL___2 = 15,
	CLK_PLLCM33___2 = 16,
	CLK_PLLCLN___2 = 17,
	CLK_PLLDTY___2 = 18,
	CLK_PLLCA55___2 = 19,
	CLK_PLLVDO = 20,
	CLK_PLLGPU = 21,
	CLK_PLLCM33_DIV4 = 22,
	CLK_PLLCM33_DIV4_PLLCM33 = 23,
	CLK_PLLCM33_DIV16___2 = 24,
	CLK_PLLCLN_DIV2___2 = 25,
	CLK_PLLCLN_DIV8___2 = 26,
	CLK_PLLCLN_DIV16 = 27,
	CLK_PLLDTY_ACPU___2 = 28,
	CLK_PLLDTY_ACPU_DIV2 = 29,
	CLK_PLLDTY_ACPU_DIV4___2 = 30,
	CLK_PLLDTY_DIV8 = 31,
	CLK_PLLDTY_DIV16 = 32,
	CLK_PLLDTY_RCPU = 33,
	CLK_PLLDTY_RCPU_DIV4 = 34,
	CLK_PLLVDO_CRU0 = 35,
	CLK_PLLVDO_CRU1 = 36,
	CLK_PLLVDO_CRU2 = 37,
	CLK_PLLVDO_CRU3 = 38,
	CLK_PLLGPU_GEAR = 39,
	MOD_CLK_BASE___6 = 40,
};

enum clk_ids___7 {
	LAST_DT_CORE_CLK___7 = 77,
	CLK_EXTAL___5 = 78,
	CLK_EXTALR___3 = 79,
	CLK_MAIN___3 = 80,
	CLK_PLL1___5 = 81,
	CLK_PLL2___3 = 82,
	CLK_PLL3___4 = 83,
	CLK_PLL4___2 = 84,
	CLK_PLL5___4 = 85,
	CLK_PLL6___3 = 86,
	CLK_PLL1_DIV2___3 = 87,
	CLK_PLL2_DIV2___3 = 88,
	CLK_PLL3_DIV2___3 = 89,
	CLK_PLL4_DIV2 = 90,
	CLK_PLL5_DIV2___2 = 91,
	CLK_PLL5_DIV4___2 = 92,
	CLK_PLL6_DIV2 = 93,
	CLK_S0 = 94,
	CLK_S0_VIO = 95,
	CLK_S0_VC = 96,
	CLK_S0_HSC = 97,
	CLK_SASYNCPER = 98,
	CLK_SV_VIP = 99,
	CLK_SV_IR = 100,
	CLK_SDSRC___2 = 101,
	CLK_RPCSRC___2 = 102,
	CLK_VIO = 103,
	CLK_VC = 104,
	CLK_OCO___2 = 105,
	MOD_CLK_BASE___7 = 106,
};

enum clk_ids___8 {
	LAST_DT_CORE_CLK___8 = 24,
	CLK_EXTAL___6 = 25,
	CLK_OSC_DIV1000___3 = 26,
	CLK_PLL1___6 = 27,
	CLK_PLL2___4 = 28,
	CLK_PLL2_DIV2___4 = 29,
	CLK_PLL2_DIV2_8___3 = 30,
	CLK_PLL2_DIV6 = 31,
	CLK_PLL3___5 = 32,
	CLK_PLL3_DIV2___4 = 33,
	CLK_PLL3_DIV2_4___3 = 34,
	CLK_PLL3_DIV2_8 = 35,
	CLK_PLL3_DIV6 = 36,
	CLK_PLL4___3 = 37,
	CLK_PLL6___4 = 38,
	CLK_PLL6_DIV2___2 = 39,
	CLK_SEL_SDHI0 = 40,
	CLK_SEL_SDHI1 = 41,
	CLK_SEL_SDHI2 = 42,
	CLK_SEL_PLL4 = 43,
	CLK_P1_DIV2___3 = 44,
	CLK_P3_DIV2 = 45,
	CLK_SD0_DIV4___3 = 46,
	CLK_SD1_DIV4___3 = 47,
	CLK_SD2_DIV4 = 48,
	MOD_CLK_BASE___8 = 49,
};

enum clk_ids___9 {
	LAST_DT_CORE_CLK___9 = 49,
	CLK_EXTAL___7 = 50,
	CLK_EXTALR___4 = 51,
	CLK_MAIN___4 = 52,
	CLK_PLL0___2 = 53,
	CLK_PLL1___7 = 54,
	CLK_PLL3___6 = 55,
	CLK_PLL4___4 = 56,
	CLK_PLL1_DIV2___4 = 57,
	CLK_PLL1_DIV4___2 = 58,
	CLK_S0___2 = 59,
	CLK_S1___2 = 60,
	CLK_S2 = 61,
	CLK_S3___2 = 62,
	CLK_SDSRC___3 = 63,
	CLK_SSPSRC = 64,
	CLK_RPCSRC___3 = 65,
	CLK_RINT = 66,
	MOD_CLK_BASE___9 = 67,
};

enum clk_ids___10 {
	LAST_DT_CORE_CLK___10 = 41,
	CLK_EXTAL___8 = 42,
	CLK_MAIN___5 = 43,
	CLK_PLL0___3 = 44,
	CLK_PLL1___8 = 45,
	CLK_PLL3___7 = 46,
	CLK_PLL0D2 = 47,
	CLK_PLL0D3 = 48,
	CLK_PLL0D5 = 49,
	CLK_PLL1D2 = 50,
	CLK_PE = 51,
	CLK_S0___3 = 52,
	CLK_S1___3 = 53,
	CLK_S2___2 = 54,
	CLK_S3___3 = 55,
	CLK_SDSRC___4 = 56,
	CLK_RPCSRC___4 = 57,
	CLK_RINT___2 = 58,
	CLK_OCO___3 = 59,
	MOD_CLK_BASE___10 = 60,
};

enum clk_ids___11 {
	LAST_DT_CORE_CLK___11 = 51,
	CLK_EXTAL___9 = 52,
	CLK_EXTALR___5 = 53,
	CLK_MAIN___6 = 54,
	CLK_PLL0___4 = 55,
	CLK_PLL1___9 = 56,
	CLK_PLL2___5 = 57,
	CLK_PLL3___8 = 58,
	CLK_PLL4___5 = 59,
	CLK_PLL1_DIV2___5 = 60,
	CLK_PLL1_DIV4___3 = 61,
	CLK_S0___4 = 62,
	CLK_S1___4 = 63,
	CLK_S2___3 = 64,
	CLK_S3___4 = 65,
	CLK_SDSRC___5 = 66,
	CLK_SSPSRC___2 = 67,
	CLK_RPCSRC___5 = 68,
	CLK_RINT___3 = 69,
	MOD_CLK_BASE___11 = 70,
};

enum clk_ids___12 {
	LAST_DT_CORE_CLK___12 = 52,
	CLK_EXTAL___10 = 53,
	CLK_EXTALR___6 = 54,
	CLK_MAIN___7 = 55,
	CLK_PLL0___5 = 56,
	CLK_PLL1___10 = 57,
	CLK_PLL2___6 = 58,
	CLK_PLL3___9 = 59,
	CLK_PLL4___6 = 60,
	CLK_PLL1_DIV2___6 = 61,
	CLK_PLL1_DIV4___4 = 62,
	CLK_S0___5 = 63,
	CLK_S1___5 = 64,
	CLK_S2___4 = 65,
	CLK_S3___5 = 66,
	CLK_SDSRC___6 = 67,
	CLK_SSPSRC___3 = 68,
	CLK_RPCSRC___6 = 69,
	CLK_RINT___4 = 70,
	MOD_CLK_BASE___12 = 71,
};

enum clk_ids___13 {
	LAST_DT_CORE_CLK___13 = 0,
	CLK_EXTAL___11 = 1,
	CLK_MAIN___8 = 2,
	CLK_MAIN_24 = 3,
	CLK_MAIN_2 = 4,
	CLK_PLL1___11 = 5,
	CLK_PLL2___7 = 6,
	CLK_PLL2_800___3 = 7,
	CLK_PLL2_400 = 8,
	CLK_PLL2_200 = 9,
	CLK_PLL2_100 = 10,
	CLK_PLL4___7 = 11,
	CLK_DIV_A = 12,
	CLK_DIV_B = 13,
	CLK_DIV_D = 14,
	CLK_DIV_E = 15,
	CLK_DIV_W = 16,
	CLK_SEL_B = 17,
	CLK_SEL_B_D2 = 18,
	CLK_SEL_CSI0 = 19,
	CLK_SEL_CSI4 = 20,
	CLK_SEL_D = 21,
	CLK_SEL_E = 22,
	CLK_SEL_SDI = 23,
	CLK_SEL_W0 = 24,
	MOD_CLK_BASE___13 = 25,
};

enum clk_ids___14 {
	LAST_DT_CORE_CLK___14 = 48,
	CLK_EXTAL___12 = 49,
	CLK_MAIN___9 = 50,
	CLK_PLL0___6 = 51,
	CLK_PLL1___12 = 52,
	CLK_PLL3___10 = 53,
	CLK_PLL0D4 = 54,
	CLK_PLL0D6 = 55,
	CLK_PLL0D8 = 56,
	CLK_PLL0D20 = 57,
	CLK_PLL0D24 = 58,
	CLK_PLL1D2___2 = 59,
	CLK_PE___2 = 60,
	CLK_S0___6 = 61,
	CLK_S1___6 = 62,
	CLK_S2___5 = 63,
	CLK_S3___6 = 64,
	CLK_SDSRC___7 = 65,
	CLK_RPCSRC___7 = 66,
	CLK_RINT___5 = 67,
	CLK_OCO___4 = 68,
	MOD_CLK_BASE___14 = 69,
};

enum clk_ids___15 {
	LAST_DT_CORE_CLK___15 = 49,
	CLK_EXTAL___13 = 50,
	CLK_MAIN___10 = 51,
	CLK_PLL0___7 = 52,
	CLK_PLL1___13 = 53,
	CLK_PLL3___11 = 54,
	CLK_PLL0D4___2 = 55,
	CLK_PLL0D6___2 = 56,
	CLK_PLL0D8___2 = 57,
	CLK_PLL0D20___2 = 58,
	CLK_PLL0D24___2 = 59,
	CLK_PLL1D2___3 = 60,
	CLK_PE___3 = 61,
	CLK_S0___7 = 62,
	CLK_S1___7 = 63,
	CLK_S2___6 = 64,
	CLK_S3___7 = 65,
	CLK_SDSRC___8 = 66,
	CLK_RPCSRC___8 = 67,
	CLK_RINT___6 = 68,
	CLK_OCO___5 = 69,
	MOD_CLK_BASE___15 = 70,
};

enum clk_ids___16 {
	LAST_DT_CORE_CLK___16 = 50,
	CLK_EXTAL___14 = 51,
	CLK_EXTALR___7 = 52,
	CLK_MAIN___11 = 53,
	CLK_PLL1___14 = 54,
	CLK_PLL2___8 = 55,
	CLK_PLL3___12 = 56,
	CLK_PLL5___5 = 57,
	CLK_PLL6___5 = 58,
	CLK_PLL1_DIV2___7 = 59,
	CLK_PLL2_DIV2___5 = 60,
	CLK_PLL3_DIV2___5 = 61,
	CLK_PLL5_DIV2___3 = 62,
	CLK_PLL5_DIV4___3 = 63,
	CLK_PLL6_DIV2___3 = 64,
	CLK_S0___8 = 65,
	CLK_SASYNCPER___2 = 66,
	CLK_SDSRC___9 = 67,
	CLK_RPCSRC___9 = 68,
	CLK_OCO___6 = 69,
	MOD_CLK_BASE___16 = 70,
};

enum clk_ids___17 {
	LAST_DT_CORE_CLK___17 = 46,
	CLK_EXTAL___15 = 47,
	CLK_EXTALR___8 = 48,
	CLK_MAIN___12 = 49,
	CLK_PLL0___8 = 50,
	CLK_PLL1___15 = 51,
	CLK_PLL2___9 = 52,
	CLK_PLL3___13 = 53,
	CLK_PLL4___8 = 54,
	CLK_PLL1_DIV2___8 = 55,
	CLK_PLL1_DIV4___5 = 56,
	CLK_S0___9 = 57,
	CLK_S1___8 = 58,
	CLK_S2___7 = 59,
	CLK_S3___8 = 60,
	CLK_SDSRC___10 = 61,
	CLK_RPCSRC___10 = 62,
	CLK_RINT___7 = 63,
	MOD_CLK_BASE___17 = 64,
};

enum clk_ids___18 {
	LAST_DT_CORE_CLK___18 = 37,
	CLK_EXTAL___16 = 38,
	CLK_EXTALR___9 = 39,
	CLK_MAIN___13 = 40,
	CLK_PLL1___16 = 41,
	CLK_PLL2___10 = 42,
	CLK_PLL3___14 = 43,
	CLK_PLL1_DIV2___9 = 44,
	CLK_PLL1_DIV4___6 = 45,
	CLK_S0___10 = 46,
	CLK_S1___9 = 47,
	CLK_S2___8 = 48,
	CLK_S3___9 = 49,
	CLK_SDSRC___11 = 50,
	CLK_RPCSRC___11 = 51,
	CLK_OCO___7 = 52,
	MOD_CLK_BASE___18 = 53,
};

enum clk_ids___19 {
	LAST_DT_CORE_CLK___19 = 44,
	CLK_EXTAL___17 = 45,
	CLK_EXTALR___10 = 46,
	CLK_MAIN___14 = 47,
	CLK_PLL0___9 = 48,
	CLK_PLL1___17 = 49,
	CLK_PLL3___15 = 50,
	CLK_PLL4___9 = 51,
	CLK_PLL1_DIV2___10 = 52,
	CLK_PLL1_DIV4___7 = 53,
	CLK_S0___11 = 54,
	CLK_S1___10 = 55,
	CLK_S2___9 = 56,
	CLK_S3___10 = 57,
	CLK_SDSRC___12 = 58,
	CLK_RPCSRC___12 = 59,
	CLK_RINT___8 = 60,
	MOD_CLK_BASE___19 = 61,
};

enum clk_ids___20 {
	LAST_DT_CORE_CLK___20 = 82,
	CLK_EXTAL___18 = 83,
	CLK_EXTALR___11 = 84,
	CLK_MAIN___15 = 85,
	CLK_PLL1___18 = 86,
	CLK_PLL2___11 = 87,
	CLK_PLL3___16 = 88,
	CLK_PLL4___10 = 89,
	CLK_PLL5___6 = 90,
	CLK_PLL6___6 = 91,
	CLK_PLL1_DIV2___11 = 92,
	CLK_PLL3_DIV2___6 = 93,
	CLK_PLL4_DIV2___2 = 94,
	CLK_PLL4_DIV5 = 95,
	CLK_PLL5_DIV2___4 = 96,
	CLK_PLL5_DIV4___4 = 97,
	CLK_PLL6_DIV2___4 = 98,
	CLK_S0___12 = 99,
	CLK_S0_VIO___2 = 100,
	CLK_S0_VC___2 = 101,
	CLK_S0_HSC___2 = 102,
	CLK_SASYNCPER___3 = 103,
	CLK_SV_VIP___2 = 104,
	CLK_SV_IR___2 = 105,
	CLK_IMPASRC = 106,
	CLK_IMPBSRC = 107,
	CLK_VIOSRC = 108,
	CLK_VCSRC = 109,
	CLK_SDSRC___13 = 110,
	CLK_RPCSRC___13 = 111,
	CLK_OCO___8 = 112,
	MOD_CLK_BASE___20 = 113,
};

enum clk_ids___21 {
	LAST_DT_CORE_CLK___21 = 11,
	CLK_AUDIO_EXTAL___3 = 12,
	CLK_RTXIN___3 = 13,
	CLK_QEXTAL___3 = 14,
	CLK_PLLCM33___3 = 15,
	CLK_PLLCLN___3 = 16,
	CLK_PLLDTY___3 = 17,
	CLK_PLLCA55___3 = 18,
	CLK_PLLVDO___2 = 19,
	CLK_PLLCM33_DIV3 = 20,
	CLK_PLLCM33_DIV4___2 = 21,
	CLK_PLLCM33_DIV5 = 22,
	CLK_PLLCM33_DIV16___3 = 23,
	CLK_PLLCM33_GEAR = 24,
	CLK_SMUX2_XSPI_CLK0 = 25,
	CLK_SMUX2_XSPI_CLK1 = 26,
	CLK_PLLCM33_XSPI = 27,
	CLK_PLLCLN_DIV2___3 = 28,
	CLK_PLLCLN_DIV8___3 = 29,
	CLK_PLLCLN_DIV16___2 = 30,
	CLK_PLLCLN_DIV20 = 31,
	CLK_PLLDTY_ACPU___3 = 32,
	CLK_PLLDTY_ACPU_DIV2___2 = 33,
	CLK_PLLDTY_ACPU_DIV4___3 = 34,
	CLK_PLLDTY_DIV16___2 = 35,
	CLK_PLLVDO_CRU0___2 = 36,
	CLK_PLLVDO_GPU = 37,
	MOD_CLK_BASE___21 = 38,
};

enum clk_reg_layout {
	CLK_REG_LAYOUT_RCAR_GEN2_AND_GEN3 = 0,
	CLK_REG_LAYOUT_RZ_A = 1,
	CLK_REG_LAYOUT_RCAR_GEN4 = 2,
};

enum clk_sel {
	LOW_SPEED_IO_SEL = 0,
	NON_IO_SEL = 1,
	FAST_SEL = 2,
	AUDIO_SEL = 3,
	VIDEO_SEL = 4,
	TPM_SEL = 5,
	CKO1_SEL = 6,
	CKO2_SEL = 7,
	MISC_SEL = 8,
	MAX_SEL = 9,
};

enum clk_state {
	CLK_STATE_DISABLE = 0,
	CLK_STATE_ENABLE = 1,
	CLK_STATE_RESERVED = 2,
	CLK_STATE_UNCHANGED = 3,
};

enum clk_type {
	CLK_TYPE_OUTPUT = 0,
	CLK_TYPE_EXTERNAL = 1,
};

enum clk_type_t {
	CLK_EXT_DIFF = 0,
	CLK_INT_DIFF = 1,
	CLK_INT_SING = 2,
};

enum clk_types {
	CLK_TYPE_IN = 0,
	CLK_TYPE_FF = 1,
	CLK_TYPE_PLL = 2,
	CLK_TYPE_DDIV = 3,
	CLK_TYPE_SMUX = 4,
};

enum clk_types___2 {
	CLK_TYPE_IN___2 = 0,
	CLK_TYPE_FF___2 = 1,
	CLK_TYPE_SAM_PLL = 2,
	CLK_TYPE_G3S_PLL = 3,
	CLK_TYPE_DIV = 4,
	CLK_TYPE_G3S_DIV = 5,
	CLK_TYPE_MUX = 6,
	CLK_TYPE_SD_MUX = 7,
	CLK_TYPE_SIPLL5 = 8,
	CLK_TYPE_PLL5_4_MUX = 9,
	CLK_TYPE_DSI_DIV = 10,
};

enum clk_types___3 {
	CLK_TYPE_IN___3 = 0,
	CLK_TYPE_FF___3 = 1,
	CLK_TYPE_DIV6P1 = 2,
	CLK_TYPE_DIV6_RO = 3,
	CLK_TYPE_FR = 4,
	CLK_TYPE_CUSTOM = 5,
};

enum clock_event_state {
	CLOCK_EVT_STATE_DETACHED = 0,
	CLOCK_EVT_STATE_SHUTDOWN = 1,
	CLOCK_EVT_STATE_PERIODIC = 2,
	CLOCK_EVT_STATE_ONESHOT = 3,
	CLOCK_EVT_STATE_ONESHOT_STOPPED = 4,
};

enum clocksource_ids {
	CSID_GENERIC = 0,
	CSID_ARM_ARCH_COUNTER = 1,
	CSID_S390_TOD = 2,
	CSID_X86_TSC_EARLY = 3,
	CSID_X86_TSC = 4,
	CSID_X86_KVM_CLK = 5,
	CSID_X86_ART = 6,
	CSID_MAX = 7,
};

enum cma_flags {
	CMA_RESERVE_PAGES_ON_ERROR = 0,
	CMA_ZONES_VALID = 1,
	CMA_ZONES_INVALID = 2,
	CMA_ACTIVATED = 3,
};

enum cmd_db_hw_type {
	CMD_DB_HW_INVALID = 0,
	CMD_DB_HW_MIN = 3,
	CMD_DB_HW_ARC = 3,
	CMD_DB_HW_VRM = 4,
	CMD_DB_HW_BCM = 5,
	CMD_DB_HW_MAX = 5,
	CMD_DB_HW_ALL = 255,
};

enum cmis_cdb_fw_write_mechanism {
	CMIS_CDB_FW_WRITE_MECHANISM_NONE = 0,
	CMIS_CDB_FW_WRITE_MECHANISM_LPL = 1,
	CMIS_CDB_FW_WRITE_MECHANISM_EPL = 16,
	CMIS_CDB_FW_WRITE_MECHANISM_BOTH = 17,
};

enum cmu_type_t {
	REF_CMU = 0,
	PHY_CMU = 1,
};

enum compact_priority {
	COMPACT_PRIO_SYNC_FULL = 0,
	MIN_COMPACT_PRIORITY = 0,
	COMPACT_PRIO_SYNC_LIGHT = 1,
	MIN_COMPACT_COSTLY_PRIORITY = 1,
	DEF_COMPACT_PRIORITY = 1,
	COMPACT_PRIO_ASYNC = 2,
	INIT_COMPACT_PRIORITY = 2,
};

enum compact_result {
	COMPACT_NOT_SUITABLE_ZONE = 0,
	COMPACT_SKIPPED = 1,
	COMPACT_DEFERRED = 2,
	COMPACT_NO_SUITABLE_PAGE = 3,
	COMPACT_CONTINUE = 4,
	COMPACT_COMPLETE = 5,
	COMPACT_PARTIAL_SKIPPED = 6,
	COMPACT_CONTENDED = 7,
	COMPACT_SUCCESS = 8,
};

enum compat_regset {
	REGSET_COMPAT_GPR = 0,
	REGSET_COMPAT_VFP = 1,
};

enum con_flush_mode {
	CONSOLE_FLUSH_PENDING = 0,
	CONSOLE_REPLAY_ALL = 1,
};

enum con_msg_format_flags {
	MSG_FORMAT_DEFAULT = 0,
	MSG_FORMAT_SYSLOG = 1,
};

enum con_scroll {
	SM_UP = 0,
	SM_DOWN = 1,
};

enum cons_flags {
	CON_PRINTBUFFER = 1,
	CON_CONSDEV = 2,
	CON_ENABLED = 4,
	CON_BOOT = 8,
	CON_ANYTIME = 16,
	CON_BRL = 32,
	CON_EXTENDED = 64,
	CON_SUSPENDED = 128,
	CON_NBCON = 256,
};

enum coredump_type_t {
	COREDUMP_FILE = 1,
	COREDUMP_PIPE = 2,
	COREDUMP_SOCK = 3,
};

enum cpi_algorithm_type {
	CPI_ALG_NONE = 0,
	CPI_ALG_VLAN = 1,
	CPI_ALG_VLAN16 = 2,
	CPI_ALG_DIFF = 3,
};

enum cpio_fields {
	C_MAGIC = 0,
	C_INO = 1,
	C_MODE = 2,
	C_UID = 3,
	C_GID = 4,
	C_NLINK = 5,
	C_MTIME = 6,
	C_FILESIZE = 7,
	C_MAJ = 8,
	C_MIN = 9,
	C_RMAJ = 10,
	C_RMIN = 11,
	C_NAMESIZE = 12,
	C_CHKSUM = 13,
	C_NFIELDS = 14,
};

enum cppc_regs {
	HIGHEST_PERF = 0,
	NOMINAL_PERF = 1,
	LOW_NON_LINEAR_PERF = 2,
	LOWEST_PERF = 3,
	GUARANTEED_PERF = 4,
	DESIRED_PERF = 5,
	MIN_PERF = 6,
	MAX_PERF = 7,
	PERF_REDUC_TOLERANCE = 8,
	TIME_WINDOW = 9,
	CTR_WRAP_TIME = 10,
	REFERENCE_CTR = 11,
	DELIVERED_CTR = 12,
	PERF_LIMITED = 13,
	ENABLE = 14,
	AUTO_SEL_ENABLE = 15,
	AUTO_ACT_WINDOW = 16,
	ENERGY_PERF = 17,
	REFERENCE_PERF = 18,
	LOWEST_FREQ = 19,
	NOMINAL_FREQ = 20,
};

enum cppi5_tr_event_size {
	CPPI5_TR_EVENT_SIZE_COMPLETION = 0,
	CPPI5_TR_EVENT_SIZE_ICNT1_DEC = 1,
	CPPI5_TR_EVENT_SIZE_ICNT2_DEC = 2,
	CPPI5_TR_EVENT_SIZE_ICNT3_DEC = 3,
	CPPI5_TR_EVENT_SIZE_MAX = 4,
};

enum cppi5_tr_trigger {
	CPPI5_TR_TRIGGER_NONE = 0,
	CPPI5_TR_TRIGGER_GLOBAL0 = 1,
	CPPI5_TR_TRIGGER_GLOBAL1 = 2,
	CPPI5_TR_TRIGGER_LOCAL_EVENT = 3,
	CPPI5_TR_TRIGGER_MAX = 4,
};

enum cppi5_tr_trigger_type {
	CPPI5_TR_TRIGGER_TYPE_ICNT1_DEC = 0,
	CPPI5_TR_TRIGGER_TYPE_ICNT2_DEC = 1,
	CPPI5_TR_TRIGGER_TYPE_ICNT3_DEC = 2,
	CPPI5_TR_TRIGGER_TYPE_ALL = 3,
	CPPI5_TR_TRIGGER_TYPE_MAX = 4,
};

enum cppi5_tr_types {
	CPPI5_TR_TYPE0 = 0,
	CPPI5_TR_TYPE1 = 1,
	CPPI5_TR_TYPE2 = 2,
	CPPI5_TR_TYPE3 = 3,
	CPPI5_TR_TYPE4 = 4,
	CPPI5_TR_TYPE5 = 5,
	CPPI5_TR_TYPE8 = 8,
	CPPI5_TR_TYPE9 = 9,
	CPPI5_TR_TYPE10 = 10,
	CPPI5_TR_TYPE11 = 11,
	CPPI5_TR_TYPE15 = 15,
	CPPI5_TR_TYPE_MAX = 16,
};

enum cpsw_ale_control {
	ALE_ENABLE = 0,
	ALE_CLEAR = 1,
	ALE_AGEOUT = 2,
	ALE_P0_UNI_FLOOD = 3,
	ALE_VLAN_NOLEARN = 4,
	ALE_NO_PORT_VLAN = 5,
	ALE_OUI_DENY = 6,
	ALE_BYPASS = 7,
	ALE_RATE_LIMIT_TX = 8,
	ALE_VLAN_AWARE = 9,
	ALE_AUTH_ENABLE = 10,
	ALE_RATE_LIMIT = 11,
	ALE_PORT_STATE = 12,
	ALE_PORT_DROP_UNTAGGED = 13,
	ALE_PORT_DROP_UNKNOWN_VLAN = 14,
	ALE_PORT_NOLEARN = 15,
	ALE_PORT_NO_SA_UPDATE = 16,
	ALE_PORT_UNKNOWN_VLAN_MEMBER = 17,
	ALE_PORT_UNKNOWN_MCAST_FLOOD = 18,
	ALE_PORT_UNKNOWN_REG_MCAST_FLOOD = 19,
	ALE_PORT_UNTAGGED_EGRESS = 20,
	ALE_PORT_MACONLY = 21,
	ALE_PORT_MACONLY_CAF = 22,
	ALE_PORT_BCAST_LIMIT = 23,
	ALE_PORT_MCAST_LIMIT = 24,
	ALE_DEFAULT_THREAD_ID = 25,
	ALE_DEFAULT_THREAD_ENABLE = 26,
	ALE_NUM_CONTROLS = 27,
};

enum cpsw_ale_port_state {
	ALE_PORT_STATE_DISABLE = 0,
	ALE_PORT_STATE_BLOCK = 1,
	ALE_PORT_STATE_LEARN = 2,
	ALE_PORT_STATE_FORWARD = 3,
};

enum cpsw_sl_regs {
	CPSW_SL_IDVER = 0,
	CPSW_SL_MACCONTROL = 1,
	CPSW_SL_MACSTATUS = 2,
	CPSW_SL_SOFT_RESET = 3,
	CPSW_SL_RX_MAXLEN = 4,
	CPSW_SL_BOFFTEST = 5,
	CPSW_SL_RX_PAUSE = 6,
	CPSW_SL_TX_PAUSE = 7,
	CPSW_SL_EMCONTROL = 8,
	CPSW_SL_RX_PRI_MAP = 9,
	CPSW_SL_TX_GAP = 10,
};

enum cpu_idle_type {
	__CPU_NOT_IDLE = 0,
	CPU_IDLE = 1,
	CPU_NEWLY_IDLE = 2,
	CPU_MAX_IDLE_TYPES = 3,
};

enum cpu_led_event {
	CPU_LED_IDLE_START = 0,
	CPU_LED_IDLE_END = 1,
	CPU_LED_START = 2,
	CPU_LED_STOP = 3,
	CPU_LED_HALTED = 4,
};

enum cpu_mitigations {
	CPU_MITIGATIONS_OFF = 0,
	CPU_MITIGATIONS_AUTO = 1,
	CPU_MITIGATIONS_AUTO_NOSMT = 2,
};

enum cpu_pm_event {
	CPU_PM_ENTER = 0,
	CPU_PM_ENTER_FAILED = 1,
	CPU_PM_EXIT = 2,
	CPU_CLUSTER_PM_ENTER = 3,
	CPU_CLUSTER_PM_ENTER_FAILED = 4,
	CPU_CLUSTER_PM_EXIT = 5,
};

enum cpu_usage_stat {
	CPUTIME_USER = 0,
	CPUTIME_NICE = 1,
	CPUTIME_SYSTEM = 2,
	CPUTIME_SOFTIRQ = 3,
	CPUTIME_IRQ = 4,
	CPUTIME_IDLE = 5,
	CPUTIME_IOWAIT = 6,
	CPUTIME_STEAL = 7,
	CPUTIME_GUEST = 8,
	CPUTIME_GUEST_NICE = 9,
	NR_STATS = 10,
};

enum cpuacct_stat_index {
	CPUACCT_STAT_USER = 0,
	CPUACCT_STAT_SYSTEM = 1,
	CPUACCT_STAT_NSTATS = 2,
};

enum cpubiuctrl_regs {
	CPU_CREDIT_REG = 0,
	CPU_MCP_FLOW_REG = 1,
	CPU_WRITEBACK_CTRL_REG = 2,
	RAC_CONFIG0_REG = 3,
	RAC_CONFIG1_REG = 4,
	NUM_CPU_BIUCTRL_REGS = 5,
};

enum cpufreq_table_sorting {
	CPUFREQ_TABLE_UNSORTED = 0,
	CPUFREQ_TABLE_SORTED_ASCENDING = 1,
	CPUFREQ_TABLE_SORTED_DESCENDING = 2,
};

enum cpuhp_smt_control {
	CPU_SMT_ENABLED = 0,
	CPU_SMT_DISABLED = 1,
	CPU_SMT_FORCE_DISABLED = 2,
	CPU_SMT_NOT_SUPPORTED = 3,
	CPU_SMT_NOT_IMPLEMENTED = 4,
};

enum cpuhp_state {
	CPUHP_INVALID = -1,
	CPUHP_OFFLINE = 0,
	CPUHP_CREATE_THREADS = 1,
	CPUHP_PERF_X86_PREPARE = 2,
	CPUHP_PERF_X86_AMD_UNCORE_PREP = 3,
	CPUHP_PERF_POWER = 4,
	CPUHP_PERF_SUPERH = 5,
	CPUHP_X86_HPET_DEAD = 6,
	CPUHP_X86_MCE_DEAD = 7,
	CPUHP_VIRT_NET_DEAD = 8,
	CPUHP_IBMVNIC_DEAD = 9,
	CPUHP_SLUB_DEAD = 10,
	CPUHP_DEBUG_OBJ_DEAD = 11,
	CPUHP_MM_WRITEBACK_DEAD = 12,
	CPUHP_MM_VMSTAT_DEAD = 13,
	CPUHP_SOFTIRQ_DEAD = 14,
	CPUHP_NET_MVNETA_DEAD = 15,
	CPUHP_CPUIDLE_DEAD = 16,
	CPUHP_ARM64_FPSIMD_DEAD = 17,
	CPUHP_ARM_OMAP_WAKE_DEAD = 18,
	CPUHP_IRQ_POLL_DEAD = 19,
	CPUHP_BLOCK_SOFTIRQ_DEAD = 20,
	CPUHP_BIO_DEAD = 21,
	CPUHP_ACPI_CPUDRV_DEAD = 22,
	CPUHP_S390_PFAULT_DEAD = 23,
	CPUHP_BLK_MQ_DEAD = 24,
	CPUHP_FS_BUFF_DEAD = 25,
	CPUHP_PRINTK_DEAD = 26,
	CPUHP_MM_MEMCQ_DEAD = 27,
	CPUHP_PERCPU_CNT_DEAD = 28,
	CPUHP_RADIX_DEAD = 29,
	CPUHP_PAGE_ALLOC = 30,
	CPUHP_NET_DEV_DEAD = 31,
	CPUHP_PCI_XGENE_DEAD = 32,
	CPUHP_IOMMU_IOVA_DEAD = 33,
	CPUHP_AP_ARM_CACHE_B15_RAC_DEAD = 34,
	CPUHP_PADATA_DEAD = 35,
	CPUHP_AP_DTPM_CPU_DEAD = 36,
	CPUHP_RANDOM_PREPARE = 37,
	CPUHP_WORKQUEUE_PREP = 38,
	CPUHP_POWER_NUMA_PREPARE = 39,
	CPUHP_HRTIMERS_PREPARE = 40,
	CPUHP_X2APIC_PREPARE = 41,
	CPUHP_SMPCFD_PREPARE = 42,
	CPUHP_RELAY_PREPARE = 43,
	CPUHP_MD_RAID5_PREPARE = 44,
	CPUHP_RCUTREE_PREP = 45,
	CPUHP_CPUIDLE_COUPLED_PREPARE = 46,
	CPUHP_POWERPC_PMAC_PREPARE = 47,
	CPUHP_POWERPC_MMU_CTX_PREPARE = 48,
	CPUHP_XEN_PREPARE = 49,
	CPUHP_XEN_EVTCHN_PREPARE = 50,
	CPUHP_ARM_SHMOBILE_SCU_PREPARE = 51,
	CPUHP_SH_SH3X_PREPARE = 52,
	CPUHP_TOPOLOGY_PREPARE = 53,
	CPUHP_NET_IUCV_PREPARE = 54,
	CPUHP_ARM_BL_PREPARE = 55,
	CPUHP_TRACE_RB_PREPARE = 56,
	CPUHP_MM_ZSWP_POOL_PREPARE = 57,
	CPUHP_KVM_PPC_BOOK3S_PREPARE = 58,
	CPUHP_ZCOMP_PREPARE = 59,
	CPUHP_TIMERS_PREPARE = 60,
	CPUHP_TMIGR_PREPARE = 61,
	CPUHP_MIPS_SOC_PREPARE = 62,
	CPUHP_BP_PREPARE_DYN = 63,
	CPUHP_BP_PREPARE_DYN_END = 83,
	CPUHP_BP_KICK_AP = 84,
	CPUHP_BRINGUP_CPU = 85,
	CPUHP_AP_IDLE_DEAD = 86,
	CPUHP_AP_OFFLINE = 87,
	CPUHP_AP_CACHECTRL_STARTING = 88,
	CPUHP_AP_SCHED_STARTING = 89,
	CPUHP_AP_RCUTREE_DYING = 90,
	CPUHP_AP_CPU_PM_STARTING = 91,
	CPUHP_AP_IRQ_GIC_STARTING = 92,
	CPUHP_AP_IRQ_HIP04_STARTING = 93,
	CPUHP_AP_IRQ_APPLE_AIC_STARTING = 94,
	CPUHP_AP_IRQ_ARMADA_XP_STARTING = 95,
	CPUHP_AP_IRQ_BCM2836_STARTING = 96,
	CPUHP_AP_IRQ_MIPS_GIC_STARTING = 97,
	CPUHP_AP_IRQ_EIOINTC_STARTING = 98,
	CPUHP_AP_IRQ_AVECINTC_STARTING = 99,
	CPUHP_AP_IRQ_SIFIVE_PLIC_STARTING = 100,
	CPUHP_AP_IRQ_THEAD_ACLINT_SSWI_STARTING = 101,
	CPUHP_AP_IRQ_RISCV_IMSIC_STARTING = 102,
	CPUHP_AP_IRQ_RISCV_SBI_IPI_STARTING = 103,
	CPUHP_AP_ARM_MVEBU_COHERENCY = 104,
	CPUHP_AP_PERF_X86_AMD_UNCORE_STARTING = 105,
	CPUHP_AP_PERF_X86_STARTING = 106,
	CPUHP_AP_PERF_X86_AMD_IBS_STARTING = 107,
	CPUHP_AP_PERF_XTENSA_STARTING = 108,
	CPUHP_AP_ARM_VFP_STARTING = 109,
	CPUHP_AP_ARM64_DEBUG_MONITORS_STARTING = 110,
	CPUHP_AP_PERF_ARM_HW_BREAKPOINT_STARTING = 111,
	CPUHP_AP_PERF_ARM_ACPI_STARTING = 112,
	CPUHP_AP_PERF_ARM_STARTING = 113,
	CPUHP_AP_PERF_RISCV_STARTING = 114,
	CPUHP_AP_ARM_L2X0_STARTING = 115,
	CPUHP_AP_EXYNOS4_MCT_TIMER_STARTING = 116,
	CPUHP_AP_ARM_ARCH_TIMER_STARTING = 117,
	CPUHP_AP_ARM_ARCH_TIMER_EVTSTRM_STARTING = 118,
	CPUHP_AP_ARM_GLOBAL_TIMER_STARTING = 119,
	CPUHP_AP_JCORE_TIMER_STARTING = 120,
	CPUHP_AP_ARM_TWD_STARTING = 121,
	CPUHP_AP_QCOM_TIMER_STARTING = 122,
	CPUHP_AP_TEGRA_TIMER_STARTING = 123,
	CPUHP_AP_ARMADA_TIMER_STARTING = 124,
	CPUHP_AP_MIPS_GIC_TIMER_STARTING = 125,
	CPUHP_AP_ARC_TIMER_STARTING = 126,
	CPUHP_AP_REALTEK_TIMER_STARTING = 127,
	CPUHP_AP_RISCV_TIMER_STARTING = 128,
	CPUHP_AP_CLINT_TIMER_STARTING = 129,
	CPUHP_AP_CSKY_TIMER_STARTING = 130,
	CPUHP_AP_TI_GP_TIMER_STARTING = 131,
	CPUHP_AP_HYPERV_TIMER_STARTING = 132,
	CPUHP_AP_DUMMY_TIMER_STARTING = 133,
	CPUHP_AP_ARM_XEN_STARTING = 134,
	CPUHP_AP_ARM_XEN_RUNSTATE_STARTING = 135,
	CPUHP_AP_ARM_CORESIGHT_STARTING = 136,
	CPUHP_AP_ARM_CORESIGHT_CTI_STARTING = 137,
	CPUHP_AP_ARM64_ISNDEP_STARTING = 138,
	CPUHP_AP_SMPCFD_DYING = 139,
	CPUHP_AP_HRTIMERS_DYING = 140,
	CPUHP_AP_TICK_DYING = 141,
	CPUHP_AP_X86_TBOOT_DYING = 142,
	CPUHP_AP_ARM_CACHE_B15_RAC_DYING = 143,
	CPUHP_AP_ONLINE = 144,
	CPUHP_TEARDOWN_CPU = 145,
	CPUHP_AP_ONLINE_IDLE = 146,
	CPUHP_AP_HYPERV_ONLINE = 147,
	CPUHP_AP_KVM_ONLINE = 148,
	CPUHP_AP_SCHED_WAIT_EMPTY = 149,
	CPUHP_AP_SMPBOOT_THREADS = 150,
	CPUHP_AP_IRQ_AFFINITY_ONLINE = 151,
	CPUHP_AP_BLK_MQ_ONLINE = 152,
	CPUHP_AP_ARM_MVEBU_SYNC_CLOCKS = 153,
	CPUHP_AP_X86_INTEL_EPB_ONLINE = 154,
	CPUHP_AP_PERF_ONLINE = 155,
	CPUHP_AP_PERF_X86_ONLINE = 156,
	CPUHP_AP_PERF_X86_UNCORE_ONLINE = 157,
	CPUHP_AP_PERF_X86_AMD_UNCORE_ONLINE = 158,
	CPUHP_AP_PERF_X86_AMD_POWER_ONLINE = 159,
	CPUHP_AP_PERF_S390_CF_ONLINE = 160,
	CPUHP_AP_PERF_S390_SF_ONLINE = 161,
	CPUHP_AP_PERF_ARM_CCI_ONLINE = 162,
	CPUHP_AP_PERF_ARM_CCN_ONLINE = 163,
	CPUHP_AP_PERF_ARM_HISI_CPA_ONLINE = 164,
	CPUHP_AP_PERF_ARM_HISI_DDRC_ONLINE = 165,
	CPUHP_AP_PERF_ARM_HISI_HHA_ONLINE = 166,
	CPUHP_AP_PERF_ARM_HISI_L3_ONLINE = 167,
	CPUHP_AP_PERF_ARM_HISI_PA_ONLINE = 168,
	CPUHP_AP_PERF_ARM_HISI_SLLC_ONLINE = 169,
	CPUHP_AP_PERF_ARM_HISI_PCIE_PMU_ONLINE = 170,
	CPUHP_AP_PERF_ARM_HNS3_PMU_ONLINE = 171,
	CPUHP_AP_PERF_ARM_L2X0_ONLINE = 172,
	CPUHP_AP_PERF_ARM_QCOM_L2_ONLINE = 173,
	CPUHP_AP_PERF_ARM_QCOM_L3_ONLINE = 174,
	CPUHP_AP_PERF_ARM_APM_XGENE_ONLINE = 175,
	CPUHP_AP_PERF_ARM_CAVIUM_TX2_UNCORE_ONLINE = 176,
	CPUHP_AP_PERF_ARM_MARVELL_CN10K_DDR_ONLINE = 177,
	CPUHP_AP_PERF_ARM_MRVL_PEM_ONLINE = 178,
	CPUHP_AP_PERF_POWERPC_NEST_IMC_ONLINE = 179,
	CPUHP_AP_PERF_POWERPC_CORE_IMC_ONLINE = 180,
	CPUHP_AP_PERF_POWERPC_THREAD_IMC_ONLINE = 181,
	CPUHP_AP_PERF_POWERPC_TRACE_IMC_ONLINE = 182,
	CPUHP_AP_PERF_POWERPC_HV_24x7_ONLINE = 183,
	CPUHP_AP_PERF_POWERPC_HV_GPCI_ONLINE = 184,
	CPUHP_AP_PERF_CSKY_ONLINE = 185,
	CPUHP_AP_TMIGR_ONLINE = 186,
	CPUHP_AP_WATCHDOG_ONLINE = 187,
	CPUHP_AP_WORKQUEUE_ONLINE = 188,
	CPUHP_AP_RANDOM_ONLINE = 189,
	CPUHP_AP_RCUTREE_ONLINE = 190,
	CPUHP_AP_KTHREADS_ONLINE = 191,
	CPUHP_AP_BASE_CACHEINFO_ONLINE = 192,
	CPUHP_AP_ONLINE_DYN = 193,
	CPUHP_AP_ONLINE_DYN_END = 233,
	CPUHP_AP_X86_HPET_ONLINE = 234,
	CPUHP_AP_X86_KVM_CLK_ONLINE = 235,
	CPUHP_AP_ACTIVE = 236,
	CPUHP_ONLINE = 237,
};

enum cpuhp_sync_state {
	SYNC_STATE_DEAD = 0,
	SYNC_STATE_KICKED = 1,
	SYNC_STATE_SHOULD_DIE = 2,
	SYNC_STATE_ALIVE = 3,
	SYNC_STATE_SHOULD_ONLINE = 4,
	SYNC_STATE_ONLINE = 5,
};

enum createmode4 {
	NFS4_CREATE_UNCHECKED = 0,
	NFS4_CREATE_GUARDED = 1,
	NFS4_CREATE_EXCLUSIVE = 2,
	NFS4_CREATE_EXCLUSIVE4_1 = 3,
};

enum criteria {
	CR_POWER2_ALIGNED = 0,
	CR_GOAL_LEN_FAST = 1,
	CR_BEST_AVAIL_LEN = 2,
	CR_GOAL_LEN_SLOW = 3,
	CR_ANY_FREE = 4,
	EXT4_MB_NUM_CRS = 5,
};

enum crypto_attr_type_t {
	CRYPTOCFGA_UNSPEC = 0,
	CRYPTOCFGA_PRIORITY_VAL = 1,
	CRYPTOCFGA_REPORT_LARVAL = 2,
	CRYPTOCFGA_REPORT_HASH = 3,
	CRYPTOCFGA_REPORT_BLKCIPHER = 4,
	CRYPTOCFGA_REPORT_AEAD = 5,
	CRYPTOCFGA_REPORT_COMPRESS = 6,
	CRYPTOCFGA_REPORT_RNG = 7,
	CRYPTOCFGA_REPORT_CIPHER = 8,
	CRYPTOCFGA_REPORT_AKCIPHER = 9,
	CRYPTOCFGA_REPORT_KPP = 10,
	CRYPTOCFGA_REPORT_ACOMP = 11,
	CRYPTOCFGA_STAT_LARVAL = 12,
	CRYPTOCFGA_STAT_HASH = 13,
	CRYPTOCFGA_STAT_BLKCIPHER = 14,
	CRYPTOCFGA_STAT_AEAD = 15,
	CRYPTOCFGA_STAT_COMPRESS = 16,
	CRYPTOCFGA_STAT_RNG = 17,
	CRYPTOCFGA_STAT_CIPHER = 18,
	CRYPTOCFGA_STAT_AKCIPHER = 19,
	CRYPTOCFGA_STAT_KPP = 20,
	CRYPTOCFGA_STAT_ACOMP = 21,
	CRYPTOCFGA_REPORT_SIG = 22,
	__CRYPTOCFGA_MAX = 23,
};

enum csr_regs {
	B0_RAP = 0,
	B0_CTST = 4,
	B0_POWER_CTRL = 7,
	B0_ISRC = 8,
	B0_IMSK = 12,
	B0_HWE_ISRC = 16,
	B0_HWE_IMSK = 20,
	B0_Y2_SP_ISRC2 = 28,
	B0_Y2_SP_ISRC3 = 32,
	B0_Y2_SP_EISR = 36,
	B0_Y2_SP_LISR = 40,
	B0_Y2_SP_ICR = 44,
	B2_MAC_1 = 256,
	B2_MAC_2 = 264,
	B2_MAC_3 = 272,
	B2_CONN_TYP = 280,
	B2_PMD_TYP = 281,
	B2_MAC_CFG = 282,
	B2_CHIP_ID = 283,
	B2_E_0 = 284,
	B2_Y2_CLK_GATE = 285,
	B2_Y2_HW_RES = 286,
	B2_E_3 = 287,
	B2_Y2_CLK_CTRL = 288,
	B2_TI_INI = 304,
	B2_TI_VAL = 308,
	B2_TI_CTRL = 312,
	B2_TI_TEST = 313,
	B2_TST_CTRL1 = 344,
	B2_TST_CTRL2 = 345,
	B2_GP_IO = 348,
	B2_I2C_CTRL = 352,
	B2_I2C_DATA = 356,
	B2_I2C_IRQ = 360,
	B2_I2C_SW = 364,
	Y2_PEX_PHY_DATA = 368,
	Y2_PEX_PHY_ADDR = 370,
	B3_RAM_ADDR = 384,
	B3_RAM_DATA_LO = 388,
	B3_RAM_DATA_HI = 392,
	B3_RI_WTO_R1 = 400,
	B3_RI_WTO_XA1 = 401,
	B3_RI_WTO_XS1 = 402,
	B3_RI_RTO_R1 = 403,
	B3_RI_RTO_XA1 = 404,
	B3_RI_RTO_XS1 = 405,
	B3_RI_WTO_R2 = 406,
	B3_RI_WTO_XA2 = 407,
	B3_RI_WTO_XS2 = 408,
	B3_RI_RTO_R2 = 409,
	B3_RI_RTO_XA2 = 410,
	B3_RI_RTO_XS2 = 411,
	B3_RI_TO_VAL = 412,
	B3_RI_CTRL = 416,
	B3_RI_TEST = 418,
	B3_MA_TOINI_RX1 = 432,
	B3_MA_TOINI_RX2 = 433,
	B3_MA_TOINI_TX1 = 434,
	B3_MA_TOINI_TX2 = 435,
	B3_MA_TOVAL_RX1 = 436,
	B3_MA_TOVAL_RX2 = 437,
	B3_MA_TOVAL_TX1 = 438,
	B3_MA_TOVAL_TX2 = 439,
	B3_MA_TO_CTRL = 440,
	B3_MA_TO_TEST = 442,
	B3_MA_RCINI_RX1 = 448,
	B3_MA_RCINI_RX2 = 449,
	B3_MA_RCINI_TX1 = 450,
	B3_MA_RCINI_TX2 = 451,
	B3_MA_RCVAL_RX1 = 452,
	B3_MA_RCVAL_RX2 = 453,
	B3_MA_RCVAL_TX1 = 454,
	B3_MA_RCVAL_TX2 = 455,
	B3_MA_RC_CTRL = 456,
	B3_MA_RC_TEST = 458,
	B3_PA_TOINI_RX1 = 464,
	B3_PA_TOINI_RX2 = 468,
	B3_PA_TOINI_TX1 = 472,
	B3_PA_TOINI_TX2 = 476,
	B3_PA_TOVAL_RX1 = 480,
	B3_PA_TOVAL_RX2 = 484,
	B3_PA_TOVAL_TX1 = 488,
	B3_PA_TOVAL_TX2 = 492,
	B3_PA_CTRL = 496,
	B3_PA_TEST = 498,
	Y2_CFG_SPC = 7168,
	Y2_CFG_AER = 7424,
};

enum csr_target {
	MACRO_CTRL = 7,
};

enum css_task_iter_flags {
	CSS_TASK_ITER_PROCS = 1,
	CSS_TASK_ITER_THREADED = 2,
	CSS_TASK_ITER_SKIPPED = 65536,
};

enum ct_dccp_states {
	CT_DCCP_NONE = 0,
	CT_DCCP_REQUEST = 1,
	CT_DCCP_RESPOND = 2,
	CT_DCCP_PARTOPEN = 3,
	CT_DCCP_OPEN = 4,
	CT_DCCP_CLOSEREQ = 5,
	CT_DCCP_CLOSING = 6,
	CT_DCCP_TIMEWAIT = 7,
	CT_DCCP_IGNORE = 8,
	CT_DCCP_INVALID = 9,
	__CT_DCCP_MAX = 10,
};

enum cti_port_type {
	CTI_PORT_TYPE_NONE = 0,
	CTI_PORT_TYPE_RS232 = 1,
	CTI_PORT_TYPE_RS422_485 = 2,
	CTI_PORT_TYPE_RS232_422_485_HW = 3,
	CTI_PORT_TYPE_RS232_422_485_SW = 4,
	CTI_PORT_TYPE_RS232_422_485_4B = 5,
	CTI_PORT_TYPE_RS232_422_485_2B = 6,
	CTI_PORT_TYPE_MAX = 7,
};

enum ctx_state {
	CT_STATE_DISABLED = -1,
	CT_STATE_KERNEL = 0,
	CT_STATE_IDLE = 1,
	CT_STATE_USER = 2,
	CT_STATE_GUEST = 3,
	CT_STATE_MAX = 4,
};

enum cxl_event_type {
	CXL_CPER_EVENT_GENERIC = 0,
	CXL_CPER_EVENT_GEN_MEDIA = 1,
	CXL_CPER_EVENT_DRAM = 2,
	CXL_CPER_EVENT_MEM_MODULE = 3,
};

enum d_real_type {
	D_REAL_DATA = 0,
	D_REAL_METADATA = 1,
};

enum d_walk_ret {
	D_WALK_CONTINUE = 0,
	D_WALK_QUIT = 1,
	D_WALK_NORETRY = 2,
	D_WALK_SKIP = 3,
};

enum dart_type {
	DART_T8020 = 0,
	DART_T6000 = 1,
	DART_T8110 = 2,
};

enum data_content4 {
	NFS4_CONTENT_DATA = 0,
	NFS4_CONTENT_HOLE = 1,
};

enum dbc_state {
	DS_DISABLED = 0,
	DS_INITIALIZED = 1,
	DS_ENABLED = 2,
	DS_CONNECTED = 3,
	DS_CONFIGURED = 4,
	DS_MAX = 5,
};

enum dbg_active_el {
	DBG_ACTIVE_EL0 = 0,
	DBG_ACTIVE_EL1 = 1,
};

enum dbgfs_get_mode {
	DBGFS_GET_ALREADY = 0,
	DBGFS_GET_REGULAR = 1,
	DBGFS_GET_SHORT = 2,
};

enum dd_data_dir {
	DD_READ = 0,
	DD_WRITE = 1,
};

enum dd_prio {
	DD_RT_PRIO = 0,
	DD_BE_PRIO = 1,
	DD_IDLE_PRIO = 2,
	DD_PRIO_MAX = 2,
};

enum debug_counters {
	SENT_OK = 0,
	SENT_FAIL = 1,
	SENT_FAIL_POLLING_UNSUPPORTED = 2,
	SENT_FAIL_CHANNEL_NOT_FOUND = 3,
	RESPONSE_OK = 4,
	NOTIFICATION_OK = 5,
	DELAYED_RESPONSE_OK = 6,
	XFERS_RESPONSE_TIMEOUT = 7,
	XFERS_RESPONSE_POLLED_TIMEOUT = 8,
	RESPONSE_POLLED_OK = 9,
	ERR_MSG_UNEXPECTED = 10,
	ERR_MSG_INVALID = 11,
	ERR_MSG_NOMEM = 12,
	ERR_PROTOCOL = 13,
	SCMI_DEBUG_COUNTERS_LAST = 14,
};

enum dentry_d_lock_class {
	DENTRY_D_LOCK_NORMAL = 0,
	DENTRY_D_LOCK_NESTED = 1,
};

enum dentry_flags {
	DCACHE_OP_HASH = 1,
	DCACHE_OP_COMPARE = 2,
	DCACHE_OP_REVALIDATE = 4,
	DCACHE_OP_DELETE = 8,
	DCACHE_OP_PRUNE = 16,
	DCACHE_DISCONNECTED = 32,
	DCACHE_REFERENCED = 64,
	DCACHE_DONTCACHE = 128,
	DCACHE_CANT_MOUNT = 256,
	DCACHE_GENOCIDE = 512,
	DCACHE_SHRINK_LIST = 1024,
	DCACHE_OP_WEAK_REVALIDATE = 2048,
	DCACHE_NFSFS_RENAMED = 4096,
	DCACHE_FSNOTIFY_PARENT_WATCHED = 8192,
	DCACHE_DENTRY_KILLED = 16384,
	DCACHE_MOUNTED = 32768,
	DCACHE_NEED_AUTOMOUNT = 65536,
	DCACHE_MANAGE_TRANSIT = 131072,
	DCACHE_LRU_LIST = 262144,
	DCACHE_ENTRY_TYPE = 3670016,
	DCACHE_MISS_TYPE = 0,
	DCACHE_WHITEOUT_TYPE = 524288,
	DCACHE_DIRECTORY_TYPE = 1048576,
	DCACHE_AUTODIR_TYPE = 1572864,
	DCACHE_REGULAR_TYPE = 2097152,
	DCACHE_SPECIAL_TYPE = 2621440,
	DCACHE_SYMLINK_TYPE = 3145728,
	DCACHE_NOKEY_NAME = 4194304,
	DCACHE_OP_REAL = 8388608,
	DCACHE_PAR_LOOKUP = 16777216,
	DCACHE_DENTRY_CURSOR = 33554432,
	DCACHE_NORCU = 67108864,
};

enum depot_counter_id {
	DEPOT_COUNTER_REFD_ALLOCS = 0,
	DEPOT_COUNTER_REFD_FREES = 1,
	DEPOT_COUNTER_REFD_INUSE = 2,
	DEPOT_COUNTER_FREELIST_SIZE = 3,
	DEPOT_COUNTER_PERSIST_COUNT = 4,
	DEPOT_COUNTER_PERSIST_BYTES = 5,
	DEPOT_COUNTER_COUNT = 6,
};

enum desc_header_offset {
	QUERY_DESC_LENGTH_OFFSET = 0,
	QUERY_DESC_DESC_TYPE_OFFSET = 1,
};

enum desc_id {
	AVE_DESCID_RX = 0,
	AVE_DESCID_TX = 1,
};

enum desc_idn {
	QUERY_DESC_IDN_DEVICE = 0,
	QUERY_DESC_IDN_CONFIGURATION = 1,
	QUERY_DESC_IDN_UNIT = 2,
	QUERY_DESC_IDN_RFU_0 = 3,
	QUERY_DESC_IDN_INTERCONNECT = 4,
	QUERY_DESC_IDN_STRING = 5,
	QUERY_DESC_IDN_RFU_1 = 6,
	QUERY_DESC_IDN_GEOMETRY = 7,
	QUERY_DESC_IDN_POWER = 8,
	QUERY_DESC_IDN_HEALTH = 9,
	QUERY_DESC_IDN_MAX = 10,
};

enum desc_state {
	desc_miss = -1,
	desc_reserved = 0,
	desc_committed = 1,
	desc_finalized = 2,
	desc_reusable = 3,
};

enum desc_state___2 {
	AVE_DESC_RX_PERMIT = 0,
	AVE_DESC_RX_SUSPEND = 1,
	AVE_DESC_START = 2,
	AVE_DESC_STOP = 3,
};

enum desc_status {
	FREE = 0,
	PREP = 1,
	BUSY = 2,
	PAUSED = 3,
	DONE___2 = 4,
};

enum dev_cmd_type {
	DEV_CMD_TYPE_NOP = 0,
	DEV_CMD_TYPE_QUERY = 1,
	DEV_CMD_TYPE_RPMB = 2,
};

enum dev_dma_attr {
	DEV_DMA_NOT_SUPPORTED = 0,
	DEV_DMA_NON_COHERENT = 1,
	DEV_DMA_COHERENT = 2,
};

enum dev_pm_opp_event {
	OPP_EVENT_ADD = 0,
	OPP_EVENT_REMOVE = 1,
	OPP_EVENT_ENABLE = 2,
	OPP_EVENT_DISABLE = 3,
	OPP_EVENT_ADJUST_VOLTAGE = 4,
};

enum dev_pm_qos_req_type {
	DEV_PM_QOS_RESUME_LATENCY = 1,
	DEV_PM_QOS_LATENCY_TOLERANCE = 2,
	DEV_PM_QOS_MIN_FREQUENCY = 3,
	DEV_PM_QOS_MAX_FREQUENCY = 4,
	DEV_PM_QOS_FLAGS = 5,
};

enum dev_prop_type {
	DEV_PROP_U8 = 0,
	DEV_PROP_U16 = 1,
	DEV_PROP_U32 = 2,
	DEV_PROP_U64 = 3,
	DEV_PROP_STRING = 4,
	DEV_PROP_REF = 5,
};

enum dev_status {
	HISI_SAS_DEV_INIT = 0,
	HISI_SAS_DEV_NORMAL = 1,
	HISI_SAS_DEV_NCQ_ERR = 2,
};

enum dev_type {
	DEV_UNKNOWN = 0,
	DEV_X1 = 1,
	DEV_X2 = 2,
	DEV_X4 = 3,
	DEV_X8 = 4,
	DEV_X16 = 5,
	DEV_X32 = 6,
	DEV_X64 = 7,
};

enum devcg_behavior {
	DEVCG_DEFAULT_NONE = 0,
	DEVCG_DEFAULT_ALLOW = 1,
	DEVCG_DEFAULT_DENY = 2,
};

enum devfreq_parent_dev_type {
	DEVFREQ_PARENT_DEV = 0,
	CPUFREQ_PARENT_DEV = 1,
};

enum devfreq_timer {
	DEVFREQ_TIMER_DEFERRABLE = 0,
	DEVFREQ_TIMER_DELAYED = 1,
	DEVFREQ_TIMER_NUM = 2,
};

enum device_desc_param {
	DEVICE_DESC_PARAM_LEN = 0,
	DEVICE_DESC_PARAM_TYPE = 1,
	DEVICE_DESC_PARAM_DEVICE_TYPE = 2,
	DEVICE_DESC_PARAM_DEVICE_CLASS = 3,
	DEVICE_DESC_PARAM_DEVICE_SUB_CLASS = 4,
	DEVICE_DESC_PARAM_PRTCL = 5,
	DEVICE_DESC_PARAM_NUM_LU = 6,
	DEVICE_DESC_PARAM_NUM_WLU = 7,
	DEVICE_DESC_PARAM_BOOT_ENBL = 8,
	DEVICE_DESC_PARAM_DESC_ACCSS_ENBL = 9,
	DEVICE_DESC_PARAM_INIT_PWR_MODE = 10,
	DEVICE_DESC_PARAM_HIGH_PR_LUN = 11,
	DEVICE_DESC_PARAM_SEC_RMV_TYPE = 12,
	DEVICE_DESC_PARAM_SEC_LU = 13,
	DEVICE_DESC_PARAM_BKOP_TERM_LT = 14,
	DEVICE_DESC_PARAM_ACTVE_ICC_LVL = 15,
	DEVICE_DESC_PARAM_SPEC_VER = 16,
	DEVICE_DESC_PARAM_MANF_DATE = 18,
	DEVICE_DESC_PARAM_MANF_NAME = 20,
	DEVICE_DESC_PARAM_PRDCT_NAME = 21,
	DEVICE_DESC_PARAM_SN = 22,
	DEVICE_DESC_PARAM_OEM_ID = 23,
	DEVICE_DESC_PARAM_MANF_ID = 24,
	DEVICE_DESC_PARAM_UD_OFFSET = 26,
	DEVICE_DESC_PARAM_UD_LEN = 27,
	DEVICE_DESC_PARAM_RTT_CAP = 28,
	DEVICE_DESC_PARAM_FRQ_RTC = 29,
	DEVICE_DESC_PARAM_UFS_FEAT = 31,
	DEVICE_DESC_PARAM_FFU_TMT = 32,
	DEVICE_DESC_PARAM_Q_DPTH = 33,
	DEVICE_DESC_PARAM_DEV_VER = 34,
	DEVICE_DESC_PARAM_NUM_SEC_WPA = 36,
	DEVICE_DESC_PARAM_PSA_MAX_DATA = 37,
	DEVICE_DESC_PARAM_PSA_TMT = 41,
	DEVICE_DESC_PARAM_PRDCT_REV = 42,
	DEVICE_DESC_PARAM_HPB_VER = 64,
	DEVICE_DESC_PARAM_HPB_CONTROL = 66,
	DEVICE_DESC_PARAM_EXT_WB_SUP = 77,
	DEVICE_DESC_PARAM_EXT_UFS_FEATURE_SUP = 79,
	DEVICE_DESC_PARAM_WB_PRESRV_USRSPC_EN = 83,
	DEVICE_DESC_PARAM_WB_TYPE = 84,
	DEVICE_DESC_PARAM_WB_SHARED_ALLOC_UNITS = 85,
};

enum device_id {
	MAX8973 = 0,
	MAX77621 = 1,
};

enum device_link_state {
	DL_STATE_NONE = -1,
	DL_STATE_DORMANT = 0,
	DL_STATE_AVAILABLE = 1,
	DL_STATE_CONSUMER_PROBE = 2,
	DL_STATE_ACTIVE = 3,
	DL_STATE_SUPPLIER_UNBIND = 4,
};

enum device_physical_location_horizontal_position {
	DEVICE_HORI_POS_LEFT = 0,
	DEVICE_HORI_POS_CENTER = 1,
	DEVICE_HORI_POS_RIGHT = 2,
};

enum device_physical_location_panel {
	DEVICE_PANEL_TOP = 0,
	DEVICE_PANEL_BOTTOM = 1,
	DEVICE_PANEL_LEFT = 2,
	DEVICE_PANEL_RIGHT = 3,
	DEVICE_PANEL_FRONT = 4,
	DEVICE_PANEL_BACK = 5,
	DEVICE_PANEL_UNKNOWN = 6,
};

enum device_physical_location_vertical_position {
	DEVICE_VERT_POS_UPPER = 0,
	DEVICE_VERT_POS_CENTER = 1,
	DEVICE_VERT_POS_LOWER = 2,
};

enum device_removable {
	DEVICE_REMOVABLE_NOT_SUPPORTED = 0,
	DEVICE_REMOVABLE_UNKNOWN = 1,
	DEVICE_FIXED = 2,
	DEVICE_REMOVABLE = 3,
};

enum devkmsg_log_bits {
	__DEVKMSG_LOG_BIT_ON = 0,
	__DEVKMSG_LOG_BIT_OFF = 1,
	__DEVKMSG_LOG_BIT_LOCK = 2,
};

enum devkmsg_log_masks {
	DEVKMSG_LOG_MASK_ON = 1,
	DEVKMSG_LOG_MASK_OFF = 2,
	DEVKMSG_LOG_MASK_LOCK = 4,
};

enum devlink_attr {
	DEVLINK_ATTR_UNSPEC = 0,
	DEVLINK_ATTR_BUS_NAME = 1,
	DEVLINK_ATTR_DEV_NAME = 2,
	DEVLINK_ATTR_PORT_INDEX = 3,
	DEVLINK_ATTR_PORT_TYPE = 4,
	DEVLINK_ATTR_PORT_DESIRED_TYPE = 5,
	DEVLINK_ATTR_PORT_NETDEV_IFINDEX = 6,
	DEVLINK_ATTR_PORT_NETDEV_NAME = 7,
	DEVLINK_ATTR_PORT_IBDEV_NAME = 8,
	DEVLINK_ATTR_PORT_SPLIT_COUNT = 9,
	DEVLINK_ATTR_PORT_SPLIT_GROUP = 10,
	DEVLINK_ATTR_SB_INDEX = 11,
	DEVLINK_ATTR_SB_SIZE = 12,
	DEVLINK_ATTR_SB_INGRESS_POOL_COUNT = 13,
	DEVLINK_ATTR_SB_EGRESS_POOL_COUNT = 14,
	DEVLINK_ATTR_SB_INGRESS_TC_COUNT = 15,
	DEVLINK_ATTR_SB_EGRESS_TC_COUNT = 16,
	DEVLINK_ATTR_SB_POOL_INDEX = 17,
	DEVLINK_ATTR_SB_POOL_TYPE = 18,
	DEVLINK_ATTR_SB_POOL_SIZE = 19,
	DEVLINK_ATTR_SB_POOL_THRESHOLD_TYPE = 20,
	DEVLINK_ATTR_SB_THRESHOLD = 21,
	DEVLINK_ATTR_SB_TC_INDEX = 22,
	DEVLINK_ATTR_SB_OCC_CUR = 23,
	DEVLINK_ATTR_SB_OCC_MAX = 24,
	DEVLINK_ATTR_ESWITCH_MODE = 25,
	DEVLINK_ATTR_ESWITCH_INLINE_MODE = 26,
	DEVLINK_ATTR_DPIPE_TABLES = 27,
	DEVLINK_ATTR_DPIPE_TABLE = 28,
	DEVLINK_ATTR_DPIPE_TABLE_NAME = 29,
	DEVLINK_ATTR_DPIPE_TABLE_SIZE = 30,
	DEVLINK_ATTR_DPIPE_TABLE_MATCHES = 31,
	DEVLINK_ATTR_DPIPE_TABLE_ACTIONS = 32,
	DEVLINK_ATTR_DPIPE_TABLE_COUNTERS_ENABLED = 33,
	DEVLINK_ATTR_DPIPE_ENTRIES = 34,
	DEVLINK_ATTR_DPIPE_ENTRY = 35,
	DEVLINK_ATTR_DPIPE_ENTRY_INDEX = 36,
	DEVLINK_ATTR_DPIPE_ENTRY_MATCH_VALUES = 37,
	DEVLINK_ATTR_DPIPE_ENTRY_ACTION_VALUES = 38,
	DEVLINK_ATTR_DPIPE_ENTRY_COUNTER = 39,
	DEVLINK_ATTR_DPIPE_MATCH = 40,
	DEVLINK_ATTR_DPIPE_MATCH_VALUE = 41,
	DEVLINK_ATTR_DPIPE_MATCH_TYPE = 42,
	DEVLINK_ATTR_DPIPE_ACTION = 43,
	DEVLINK_ATTR_DPIPE_ACTION_VALUE = 44,
	DEVLINK_ATTR_DPIPE_ACTION_TYPE = 45,
	DEVLINK_ATTR_DPIPE_VALUE = 46,
	DEVLINK_ATTR_DPIPE_VALUE_MASK = 47,
	DEVLINK_ATTR_DPIPE_VALUE_MAPPING = 48,
	DEVLINK_ATTR_DPIPE_HEADERS = 49,
	DEVLINK_ATTR_DPIPE_HEADER = 50,
	DEVLINK_ATTR_DPIPE_HEADER_NAME = 51,
	DEVLINK_ATTR_DPIPE_HEADER_ID = 52,
	DEVLINK_ATTR_DPIPE_HEADER_FIELDS = 53,
	DEVLINK_ATTR_DPIPE_HEADER_GLOBAL = 54,
	DEVLINK_ATTR_DPIPE_HEADER_INDEX = 55,
	DEVLINK_ATTR_DPIPE_FIELD = 56,
	DEVLINK_ATTR_DPIPE_FIELD_NAME = 57,
	DEVLINK_ATTR_DPIPE_FIELD_ID = 58,
	DEVLINK_ATTR_DPIPE_FIELD_BITWIDTH = 59,
	DEVLINK_ATTR_DPIPE_FIELD_MAPPING_TYPE = 60,
	DEVLINK_ATTR_PAD = 61,
	DEVLINK_ATTR_ESWITCH_ENCAP_MODE = 62,
	DEVLINK_ATTR_RESOURCE_LIST = 63,
	DEVLINK_ATTR_RESOURCE = 64,
	DEVLINK_ATTR_RESOURCE_NAME = 65,
	DEVLINK_ATTR_RESOURCE_ID = 66,
	DEVLINK_ATTR_RESOURCE_SIZE = 67,
	DEVLINK_ATTR_RESOURCE_SIZE_NEW = 68,
	DEVLINK_ATTR_RESOURCE_SIZE_VALID = 69,
	DEVLINK_ATTR_RESOURCE_SIZE_MIN = 70,
	DEVLINK_ATTR_RESOURCE_SIZE_MAX = 71,
	DEVLINK_ATTR_RESOURCE_SIZE_GRAN = 72,
	DEVLINK_ATTR_RESOURCE_UNIT = 73,
	DEVLINK_ATTR_RESOURCE_OCC = 74,
	DEVLINK_ATTR_DPIPE_TABLE_RESOURCE_ID = 75,
	DEVLINK_ATTR_DPIPE_TABLE_RESOURCE_UNITS = 76,
	DEVLINK_ATTR_PORT_FLAVOUR = 77,
	DEVLINK_ATTR_PORT_NUMBER = 78,
	DEVLINK_ATTR_PORT_SPLIT_SUBPORT_NUMBER = 79,
	DEVLINK_ATTR_PARAM = 80,
	DEVLINK_ATTR_PARAM_NAME = 81,
	DEVLINK_ATTR_PARAM_GENERIC = 82,
	DEVLINK_ATTR_PARAM_TYPE = 83,
	DEVLINK_ATTR_PARAM_VALUES_LIST = 84,
	DEVLINK_ATTR_PARAM_VALUE = 85,
	DEVLINK_ATTR_PARAM_VALUE_DATA = 86,
	DEVLINK_ATTR_PARAM_VALUE_CMODE = 87,
	DEVLINK_ATTR_REGION_NAME = 88,
	DEVLINK_ATTR_REGION_SIZE = 89,
	DEVLINK_ATTR_REGION_SNAPSHOTS = 90,
	DEVLINK_ATTR_REGION_SNAPSHOT = 91,
	DEVLINK_ATTR_REGION_SNAPSHOT_ID = 92,
	DEVLINK_ATTR_REGION_CHUNKS = 93,
	DEVLINK_ATTR_REGION_CHUNK = 94,
	DEVLINK_ATTR_REGION_CHUNK_DATA = 95,
	DEVLINK_ATTR_REGION_CHUNK_ADDR = 96,
	DEVLINK_ATTR_REGION_CHUNK_LEN = 97,
	DEVLINK_ATTR_INFO_DRIVER_NAME = 98,
	DEVLINK_ATTR_INFO_SERIAL_NUMBER = 99,
	DEVLINK_ATTR_INFO_VERSION_FIXED = 100,
	DEVLINK_ATTR_INFO_VERSION_RUNNING = 101,
	DEVLINK_ATTR_INFO_VERSION_STORED = 102,
	DEVLINK_ATTR_INFO_VERSION_NAME = 103,
	DEVLINK_ATTR_INFO_VERSION_VALUE = 104,
	DEVLINK_ATTR_SB_POOL_CELL_SIZE = 105,
	DEVLINK_ATTR_FMSG = 106,
	DEVLINK_ATTR_FMSG_OBJ_NEST_START = 107,
	DEVLINK_ATTR_FMSG_PAIR_NEST_START = 108,
	DEVLINK_ATTR_FMSG_ARR_NEST_START = 109,
	DEVLINK_ATTR_FMSG_NEST_END = 110,
	DEVLINK_ATTR_FMSG_OBJ_NAME = 111,
	DEVLINK_ATTR_FMSG_OBJ_VALUE_TYPE = 112,
	DEVLINK_ATTR_FMSG_OBJ_VALUE_DATA = 113,
	DEVLINK_ATTR_HEALTH_REPORTER = 114,
	DEVLINK_ATTR_HEALTH_REPORTER_NAME = 115,
	DEVLINK_ATTR_HEALTH_REPORTER_STATE = 116,
	DEVLINK_ATTR_HEALTH_REPORTER_ERR_COUNT = 117,
	DEVLINK_ATTR_HEALTH_REPORTER_RECOVER_COUNT = 118,
	DEVLINK_ATTR_HEALTH_REPORTER_DUMP_TS = 119,
	DEVLINK_ATTR_HEALTH_REPORTER_GRACEFUL_PERIOD = 120,
	DEVLINK_ATTR_HEALTH_REPORTER_AUTO_RECOVER = 121,
	DEVLINK_ATTR_FLASH_UPDATE_FILE_NAME = 122,
	DEVLINK_ATTR_FLASH_UPDATE_COMPONENT = 123,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_MSG = 124,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_DONE = 125,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_TOTAL = 126,
	DEVLINK_ATTR_PORT_PCI_PF_NUMBER = 127,
	DEVLINK_ATTR_PORT_PCI_VF_NUMBER = 128,
	DEVLINK_ATTR_STATS = 129,
	DEVLINK_ATTR_TRAP_NAME = 130,
	DEVLINK_ATTR_TRAP_ACTION = 131,
	DEVLINK_ATTR_TRAP_TYPE = 132,
	DEVLINK_ATTR_TRAP_GENERIC = 133,
	DEVLINK_ATTR_TRAP_METADATA = 134,
	DEVLINK_ATTR_TRAP_GROUP_NAME = 135,
	DEVLINK_ATTR_RELOAD_FAILED = 136,
	DEVLINK_ATTR_HEALTH_REPORTER_DUMP_TS_NS = 137,
	DEVLINK_ATTR_NETNS_FD = 138,
	DEVLINK_ATTR_NETNS_PID = 139,
	DEVLINK_ATTR_NETNS_ID = 140,
	DEVLINK_ATTR_HEALTH_REPORTER_AUTO_DUMP = 141,
	DEVLINK_ATTR_TRAP_POLICER_ID = 142,
	DEVLINK_ATTR_TRAP_POLICER_RATE = 143,
	DEVLINK_ATTR_TRAP_POLICER_BURST = 144,
	DEVLINK_ATTR_PORT_FUNCTION = 145,
	DEVLINK_ATTR_INFO_BOARD_SERIAL_NUMBER = 146,
	DEVLINK_ATTR_PORT_LANES = 147,
	DEVLINK_ATTR_PORT_SPLITTABLE = 148,
	DEVLINK_ATTR_PORT_EXTERNAL = 149,
	DEVLINK_ATTR_PORT_CONTROLLER_NUMBER = 150,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_TIMEOUT = 151,
	DEVLINK_ATTR_FLASH_UPDATE_OVERWRITE_MASK = 152,
	DEVLINK_ATTR_RELOAD_ACTION = 153,
	DEVLINK_ATTR_RELOAD_ACTIONS_PERFORMED = 154,
	DEVLINK_ATTR_RELOAD_LIMITS = 155,
	DEVLINK_ATTR_DEV_STATS = 156,
	DEVLINK_ATTR_RELOAD_STATS = 157,
	DEVLINK_ATTR_RELOAD_STATS_ENTRY = 158,
	DEVLINK_ATTR_RELOAD_STATS_LIMIT = 159,
	DEVLINK_ATTR_RELOAD_STATS_VALUE = 160,
	DEVLINK_ATTR_REMOTE_RELOAD_STATS = 161,
	DEVLINK_ATTR_RELOAD_ACTION_INFO = 162,
	DEVLINK_ATTR_RELOAD_ACTION_STATS = 163,
	DEVLINK_ATTR_PORT_PCI_SF_NUMBER = 164,
	DEVLINK_ATTR_RATE_TYPE = 165,
	DEVLINK_ATTR_RATE_TX_SHARE = 166,
	DEVLINK_ATTR_RATE_TX_MAX = 167,
	DEVLINK_ATTR_RATE_NODE_NAME = 168,
	DEVLINK_ATTR_RATE_PARENT_NODE_NAME = 169,
	DEVLINK_ATTR_REGION_MAX_SNAPSHOTS = 170,
	DEVLINK_ATTR_LINECARD_INDEX = 171,
	DEVLINK_ATTR_LINECARD_STATE = 172,
	DEVLINK_ATTR_LINECARD_TYPE = 173,
	DEVLINK_ATTR_LINECARD_SUPPORTED_TYPES = 174,
	DEVLINK_ATTR_NESTED_DEVLINK = 175,
	DEVLINK_ATTR_SELFTESTS = 176,
	DEVLINK_ATTR_RATE_TX_PRIORITY = 177,
	DEVLINK_ATTR_RATE_TX_WEIGHT = 178,
	DEVLINK_ATTR_REGION_DIRECT = 179,
	__DEVLINK_ATTR_MAX = 180,
	DEVLINK_ATTR_MAX = 179,
};

enum devlink_attr_selftest_id {
	DEVLINK_ATTR_SELFTEST_ID_UNSPEC = 0,
	DEVLINK_ATTR_SELFTEST_ID_FLASH = 1,
	__DEVLINK_ATTR_SELFTEST_ID_MAX = 2,
	DEVLINK_ATTR_SELFTEST_ID_MAX = 1,
};

enum devlink_attr_selftest_result {
	DEVLINK_ATTR_SELFTEST_RESULT_UNSPEC = 0,
	DEVLINK_ATTR_SELFTEST_RESULT = 1,
	DEVLINK_ATTR_SELFTEST_RESULT_ID = 2,
	DEVLINK_ATTR_SELFTEST_RESULT_STATUS = 3,
	__DEVLINK_ATTR_SELFTEST_RESULT_MAX = 4,
	DEVLINK_ATTR_SELFTEST_RESULT_MAX = 3,
};

enum devlink_command {
	DEVLINK_CMD_UNSPEC = 0,
	DEVLINK_CMD_GET = 1,
	DEVLINK_CMD_SET = 2,
	DEVLINK_CMD_NEW = 3,
	DEVLINK_CMD_DEL = 4,
	DEVLINK_CMD_PORT_GET = 5,
	DEVLINK_CMD_PORT_SET = 6,
	DEVLINK_CMD_PORT_NEW = 7,
	DEVLINK_CMD_PORT_DEL = 8,
	DEVLINK_CMD_PORT_SPLIT = 9,
	DEVLINK_CMD_PORT_UNSPLIT = 10,
	DEVLINK_CMD_SB_GET = 11,
	DEVLINK_CMD_SB_SET = 12,
	DEVLINK_CMD_SB_NEW = 13,
	DEVLINK_CMD_SB_DEL = 14,
	DEVLINK_CMD_SB_POOL_GET = 15,
	DEVLINK_CMD_SB_POOL_SET = 16,
	DEVLINK_CMD_SB_POOL_NEW = 17,
	DEVLINK_CMD_SB_POOL_DEL = 18,
	DEVLINK_CMD_SB_PORT_POOL_GET = 19,
	DEVLINK_CMD_SB_PORT_POOL_SET = 20,
	DEVLINK_CMD_SB_PORT_POOL_NEW = 21,
	DEVLINK_CMD_SB_PORT_POOL_DEL = 22,
	DEVLINK_CMD_SB_TC_POOL_BIND_GET = 23,
	DEVLINK_CMD_SB_TC_POOL_BIND_SET = 24,
	DEVLINK_CMD_SB_TC_POOL_BIND_NEW = 25,
	DEVLINK_CMD_SB_TC_POOL_BIND_DEL = 26,
	DEVLINK_CMD_SB_OCC_SNAPSHOT = 27,
	DEVLINK_CMD_SB_OCC_MAX_CLEAR = 28,
	DEVLINK_CMD_ESWITCH_GET = 29,
	DEVLINK_CMD_ESWITCH_SET = 30,
	DEVLINK_CMD_DPIPE_TABLE_GET = 31,
	DEVLINK_CMD_DPIPE_ENTRIES_GET = 32,
	DEVLINK_CMD_DPIPE_HEADERS_GET = 33,
	DEVLINK_CMD_DPIPE_TABLE_COUNTERS_SET = 34,
	DEVLINK_CMD_RESOURCE_SET = 35,
	DEVLINK_CMD_RESOURCE_DUMP = 36,
	DEVLINK_CMD_RELOAD = 37,
	DEVLINK_CMD_PARAM_GET = 38,
	DEVLINK_CMD_PARAM_SET = 39,
	DEVLINK_CMD_PARAM_NEW = 40,
	DEVLINK_CMD_PARAM_DEL = 41,
	DEVLINK_CMD_REGION_GET = 42,
	DEVLINK_CMD_REGION_SET = 43,
	DEVLINK_CMD_REGION_NEW = 44,
	DEVLINK_CMD_REGION_DEL = 45,
	DEVLINK_CMD_REGION_READ = 46,
	DEVLINK_CMD_PORT_PARAM_GET = 47,
	DEVLINK_CMD_PORT_PARAM_SET = 48,
	DEVLINK_CMD_PORT_PARAM_NEW = 49,
	DEVLINK_CMD_PORT_PARAM_DEL = 50,
	DEVLINK_CMD_INFO_GET = 51,
	DEVLINK_CMD_HEALTH_REPORTER_GET = 52,
	DEVLINK_CMD_HEALTH_REPORTER_SET = 53,
	DEVLINK_CMD_HEALTH_REPORTER_RECOVER = 54,
	DEVLINK_CMD_HEALTH_REPORTER_DIAGNOSE = 55,
	DEVLINK_CMD_HEALTH_REPORTER_DUMP_GET = 56,
	DEVLINK_CMD_HEALTH_REPORTER_DUMP_CLEAR = 57,
	DEVLINK_CMD_FLASH_UPDATE = 58,
	DEVLINK_CMD_FLASH_UPDATE_END = 59,
	DEVLINK_CMD_FLASH_UPDATE_STATUS = 60,
	DEVLINK_CMD_TRAP_GET = 61,
	DEVLINK_CMD_TRAP_SET = 62,
	DEVLINK_CMD_TRAP_NEW = 63,
	DEVLINK_CMD_TRAP_DEL = 64,
	DEVLINK_CMD_TRAP_GROUP_GET = 65,
	DEVLINK_CMD_TRAP_GROUP_SET = 66,
	DEVLINK_CMD_TRAP_GROUP_NEW = 67,
	DEVLINK_CMD_TRAP_GROUP_DEL = 68,
	DEVLINK_CMD_TRAP_POLICER_GET = 69,
	DEVLINK_CMD_TRAP_POLICER_SET = 70,
	DEVLINK_CMD_TRAP_POLICER_NEW = 71,
	DEVLINK_CMD_TRAP_POLICER_DEL = 72,
	DEVLINK_CMD_HEALTH_REPORTER_TEST = 73,
	DEVLINK_CMD_RATE_GET = 74,
	DEVLINK_CMD_RATE_SET = 75,
	DEVLINK_CMD_RATE_NEW = 76,
	DEVLINK_CMD_RATE_DEL = 77,
	DEVLINK_CMD_LINECARD_GET = 78,
	DEVLINK_CMD_LINECARD_SET = 79,
	DEVLINK_CMD_LINECARD_NEW = 80,
	DEVLINK_CMD_LINECARD_DEL = 81,
	DEVLINK_CMD_SELFTESTS_GET = 82,
	DEVLINK_CMD_SELFTESTS_RUN = 83,
	DEVLINK_CMD_NOTIFY_FILTER_SET = 84,
	__DEVLINK_CMD_MAX = 85,
	DEVLINK_CMD_MAX = 84,
};

enum devlink_dpipe_action_type {
	DEVLINK_DPIPE_ACTION_TYPE_FIELD_MODIFY = 0,
};

enum devlink_dpipe_field_ethernet_id {
	DEVLINK_DPIPE_FIELD_ETHERNET_DST_MAC = 0,
};

enum devlink_dpipe_field_ipv4_id {
	DEVLINK_DPIPE_FIELD_IPV4_DST_IP = 0,
};

enum devlink_dpipe_field_ipv6_id {
	DEVLINK_DPIPE_FIELD_IPV6_DST_IP = 0,
};

enum devlink_dpipe_field_mapping_type {
	DEVLINK_DPIPE_FIELD_MAPPING_TYPE_NONE = 0,
	DEVLINK_DPIPE_FIELD_MAPPING_TYPE_IFINDEX = 1,
};

enum devlink_dpipe_header_id {
	DEVLINK_DPIPE_HEADER_ETHERNET = 0,
	DEVLINK_DPIPE_HEADER_IPV4 = 1,
	DEVLINK_DPIPE_HEADER_IPV6 = 2,
};

enum devlink_dpipe_match_type {
	DEVLINK_DPIPE_MATCH_TYPE_FIELD_EXACT = 0,
};

enum devlink_eswitch_encap_mode {
	DEVLINK_ESWITCH_ENCAP_MODE_NONE = 0,
	DEVLINK_ESWITCH_ENCAP_MODE_BASIC = 1,
};

enum devlink_health_reporter_state {
	DEVLINK_HEALTH_REPORTER_STATE_HEALTHY = 0,
	DEVLINK_HEALTH_REPORTER_STATE_ERROR = 1,
};

enum devlink_info_version_type {
	DEVLINK_INFO_VERSION_TYPE_NONE = 0,
	DEVLINK_INFO_VERSION_TYPE_COMPONENT = 1,
};

enum devlink_linecard_state {
	DEVLINK_LINECARD_STATE_UNSPEC = 0,
	DEVLINK_LINECARD_STATE_UNPROVISIONED = 1,
	DEVLINK_LINECARD_STATE_UNPROVISIONING = 2,
	DEVLINK_LINECARD_STATE_PROVISIONING = 3,
	DEVLINK_LINECARD_STATE_PROVISIONING_FAILED = 4,
	DEVLINK_LINECARD_STATE_PROVISIONED = 5,
	DEVLINK_LINECARD_STATE_ACTIVE = 6,
	__DEVLINK_LINECARD_STATE_MAX = 7,
	DEVLINK_LINECARD_STATE_MAX = 6,
};

enum devlink_multicast_groups {
	DEVLINK_MCGRP_CONFIG = 0,
};

enum devlink_param_cmode {
	DEVLINK_PARAM_CMODE_RUNTIME = 0,
	DEVLINK_PARAM_CMODE_DRIVERINIT = 1,
	DEVLINK_PARAM_CMODE_PERMANENT = 2,
	__DEVLINK_PARAM_CMODE_MAX = 3,
	DEVLINK_PARAM_CMODE_MAX = 2,
};

enum devlink_param_generic_id {
	DEVLINK_PARAM_GENERIC_ID_INT_ERR_RESET = 0,
	DEVLINK_PARAM_GENERIC_ID_MAX_MACS = 1,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_SRIOV = 2,
	DEVLINK_PARAM_GENERIC_ID_REGION_SNAPSHOT = 3,
	DEVLINK_PARAM_GENERIC_ID_IGNORE_ARI = 4,
	DEVLINK_PARAM_GENERIC_ID_MSIX_VEC_PER_PF_MAX = 5,
	DEVLINK_PARAM_GENERIC_ID_MSIX_VEC_PER_PF_MIN = 6,
	DEVLINK_PARAM_GENERIC_ID_FW_LOAD_POLICY = 7,
	DEVLINK_PARAM_GENERIC_ID_RESET_DEV_ON_DRV_PROBE = 8,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_ROCE = 9,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_REMOTE_DEV_RESET = 10,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_ETH = 11,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_RDMA = 12,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_VNET = 13,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_IWARP = 14,
	DEVLINK_PARAM_GENERIC_ID_IO_EQ_SIZE = 15,
	DEVLINK_PARAM_GENERIC_ID_EVENT_EQ_SIZE = 16,
	__DEVLINK_PARAM_GENERIC_ID_MAX = 17,
	DEVLINK_PARAM_GENERIC_ID_MAX = 16,
};

enum devlink_param_type {
	DEVLINK_PARAM_TYPE_U8 = 1,
	DEVLINK_PARAM_TYPE_U16 = 2,
	DEVLINK_PARAM_TYPE_U32 = 3,
	DEVLINK_PARAM_TYPE_STRING = 5,
	DEVLINK_PARAM_TYPE_BOOL = 6,
};

enum devlink_port_flavour {
	DEVLINK_PORT_FLAVOUR_PHYSICAL = 0,
	DEVLINK_PORT_FLAVOUR_CPU = 1,
	DEVLINK_PORT_FLAVOUR_DSA = 2,
	DEVLINK_PORT_FLAVOUR_PCI_PF = 3,
	DEVLINK_PORT_FLAVOUR_PCI_VF = 4,
	DEVLINK_PORT_FLAVOUR_VIRTUAL = 5,
	DEVLINK_PORT_FLAVOUR_UNUSED = 6,
	DEVLINK_PORT_FLAVOUR_PCI_SF = 7,
};

enum devlink_port_fn_attr_cap {
	DEVLINK_PORT_FN_ATTR_CAP_ROCE_BIT = 0,
	DEVLINK_PORT_FN_ATTR_CAP_MIGRATABLE_BIT = 1,
	DEVLINK_PORT_FN_ATTR_CAP_IPSEC_CRYPTO_BIT = 2,
	DEVLINK_PORT_FN_ATTR_CAP_IPSEC_PACKET_BIT = 3,
	__DEVLINK_PORT_FN_ATTR_CAPS_MAX = 4,
};

enum devlink_port_fn_opstate {
	DEVLINK_PORT_FN_OPSTATE_DETACHED = 0,
	DEVLINK_PORT_FN_OPSTATE_ATTACHED = 1,
};

enum devlink_port_fn_state {
	DEVLINK_PORT_FN_STATE_INACTIVE = 0,
	DEVLINK_PORT_FN_STATE_ACTIVE = 1,
};

enum devlink_port_function_attr {
	DEVLINK_PORT_FUNCTION_ATTR_UNSPEC = 0,
	DEVLINK_PORT_FUNCTION_ATTR_HW_ADDR = 1,
	DEVLINK_PORT_FN_ATTR_STATE = 2,
	DEVLINK_PORT_FN_ATTR_OPSTATE = 3,
	DEVLINK_PORT_FN_ATTR_CAPS = 4,
	DEVLINK_PORT_FN_ATTR_DEVLINK = 5,
	DEVLINK_PORT_FN_ATTR_MAX_IO_EQS = 6,
	__DEVLINK_PORT_FUNCTION_ATTR_MAX = 7,
	DEVLINK_PORT_FUNCTION_ATTR_MAX = 6,
};

enum devlink_port_type {
	DEVLINK_PORT_TYPE_NOTSET = 0,
	DEVLINK_PORT_TYPE_AUTO = 1,
	DEVLINK_PORT_TYPE_ETH = 2,
	DEVLINK_PORT_TYPE_IB = 3,
};

enum devlink_rate_type {
	DEVLINK_RATE_TYPE_LEAF = 0,
	DEVLINK_RATE_TYPE_NODE = 1,
};

enum devlink_reload_action {
	DEVLINK_RELOAD_ACTION_UNSPEC = 0,
	DEVLINK_RELOAD_ACTION_DRIVER_REINIT = 1,
	DEVLINK_RELOAD_ACTION_FW_ACTIVATE = 2,
	__DEVLINK_RELOAD_ACTION_MAX = 3,
	DEVLINK_RELOAD_ACTION_MAX = 2,
};

enum devlink_reload_limit {
	DEVLINK_RELOAD_LIMIT_UNSPEC = 0,
	DEVLINK_RELOAD_LIMIT_NO_RESET = 1,
	__DEVLINK_RELOAD_LIMIT_MAX = 2,
	DEVLINK_RELOAD_LIMIT_MAX = 1,
};

enum devlink_resource_unit {
	DEVLINK_RESOURCE_UNIT_ENTRY = 0,
};

enum devlink_sb_pool_type {
	DEVLINK_SB_POOL_TYPE_INGRESS = 0,
	DEVLINK_SB_POOL_TYPE_EGRESS = 1,
};

enum devlink_sb_threshold_type {
	DEVLINK_SB_THRESHOLD_TYPE_STATIC = 0,
	DEVLINK_SB_THRESHOLD_TYPE_DYNAMIC = 1,
};

enum devlink_selftest_status {
	DEVLINK_SELFTEST_STATUS_SKIP = 0,
	DEVLINK_SELFTEST_STATUS_PASS = 1,
	DEVLINK_SELFTEST_STATUS_FAIL = 2,
};

enum devlink_trap_action {
	DEVLINK_TRAP_ACTION_DROP = 0,
	DEVLINK_TRAP_ACTION_TRAP = 1,
	DEVLINK_TRAP_ACTION_MIRROR = 2,
};

enum devlink_trap_generic_id {
	DEVLINK_TRAP_GENERIC_ID_SMAC_MC = 0,
	DEVLINK_TRAP_GENERIC_ID_VLAN_TAG_MISMATCH = 1,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_VLAN_FILTER = 2,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_STP_FILTER = 3,
	DEVLINK_TRAP_GENERIC_ID_EMPTY_TX_LIST = 4,
	DEVLINK_TRAP_GENERIC_ID_PORT_LOOPBACK_FILTER = 5,
	DEVLINK_TRAP_GENERIC_ID_BLACKHOLE_ROUTE = 6,
	DEVLINK_TRAP_GENERIC_ID_TTL_ERROR = 7,
	DEVLINK_TRAP_GENERIC_ID_TAIL_DROP = 8,
	DEVLINK_TRAP_GENERIC_ID_NON_IP_PACKET = 9,
	DEVLINK_TRAP_GENERIC_ID_UC_DIP_MC_DMAC = 10,
	DEVLINK_TRAP_GENERIC_ID_DIP_LB = 11,
	DEVLINK_TRAP_GENERIC_ID_SIP_MC = 12,
	DEVLINK_TRAP_GENERIC_ID_SIP_LB = 13,
	DEVLINK_TRAP_GENERIC_ID_CORRUPTED_IP_HDR = 14,
	DEVLINK_TRAP_GENERIC_ID_IPV4_SIP_BC = 15,
	DEVLINK_TRAP_GENERIC_ID_IPV6_MC_DIP_RESERVED_SCOPE = 16,
	DEVLINK_TRAP_GENERIC_ID_IPV6_MC_DIP_INTERFACE_LOCAL_SCOPE = 17,
	DEVLINK_TRAP_GENERIC_ID_MTU_ERROR = 18,
	DEVLINK_TRAP_GENERIC_ID_UNRESOLVED_NEIGH = 19,
	DEVLINK_TRAP_GENERIC_ID_RPF = 20,
	DEVLINK_TRAP_GENERIC_ID_REJECT_ROUTE = 21,
	DEVLINK_TRAP_GENERIC_ID_IPV4_LPM_UNICAST_MISS = 22,
	DEVLINK_TRAP_GENERIC_ID_IPV6_LPM_UNICAST_MISS = 23,
	DEVLINK_TRAP_GENERIC_ID_NON_ROUTABLE = 24,
	DEVLINK_TRAP_GENERIC_ID_DECAP_ERROR = 25,
	DEVLINK_TRAP_GENERIC_ID_OVERLAY_SMAC_MC = 26,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_FLOW_ACTION_DROP = 27,
	DEVLINK_TRAP_GENERIC_ID_EGRESS_FLOW_ACTION_DROP = 28,
	DEVLINK_TRAP_GENERIC_ID_STP = 29,
	DEVLINK_TRAP_GENERIC_ID_LACP = 30,
	DEVLINK_TRAP_GENERIC_ID_LLDP = 31,
	DEVLINK_TRAP_GENERIC_ID_IGMP_QUERY = 32,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V1_REPORT = 33,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V2_REPORT = 34,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V3_REPORT = 35,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V2_LEAVE = 36,
	DEVLINK_TRAP_GENERIC_ID_MLD_QUERY = 37,
	DEVLINK_TRAP_GENERIC_ID_MLD_V1_REPORT = 38,
	DEVLINK_TRAP_GENERIC_ID_MLD_V2_REPORT = 39,
	DEVLINK_TRAP_GENERIC_ID_MLD_V1_DONE = 40,
	DEVLINK_TRAP_GENERIC_ID_IPV4_DHCP = 41,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DHCP = 42,
	DEVLINK_TRAP_GENERIC_ID_ARP_REQUEST = 43,
	DEVLINK_TRAP_GENERIC_ID_ARP_RESPONSE = 44,
	DEVLINK_TRAP_GENERIC_ID_ARP_OVERLAY = 45,
	DEVLINK_TRAP_GENERIC_ID_IPV6_NEIGH_SOLICIT = 46,
	DEVLINK_TRAP_GENERIC_ID_IPV6_NEIGH_ADVERT = 47,
	DEVLINK_TRAP_GENERIC_ID_IPV4_BFD = 48,
	DEVLINK_TRAP_GENERIC_ID_IPV6_BFD = 49,
	DEVLINK_TRAP_GENERIC_ID_IPV4_OSPF = 50,
	DEVLINK_TRAP_GENERIC_ID_IPV6_OSPF = 51,
	DEVLINK_TRAP_GENERIC_ID_IPV4_BGP = 52,
	DEVLINK_TRAP_GENERIC_ID_IPV6_BGP = 53,
	DEVLINK_TRAP_GENERIC_ID_IPV4_VRRP = 54,
	DEVLINK_TRAP_GENERIC_ID_IPV6_VRRP = 55,
	DEVLINK_TRAP_GENERIC_ID_IPV4_PIM = 56,
	DEVLINK_TRAP_GENERIC_ID_IPV6_PIM = 57,
	DEVLINK_TRAP_GENERIC_ID_UC_LB = 58,
	DEVLINK_TRAP_GENERIC_ID_LOCAL_ROUTE = 59,
	DEVLINK_TRAP_GENERIC_ID_EXTERNAL_ROUTE = 60,
	DEVLINK_TRAP_GENERIC_ID_IPV6_UC_DIP_LINK_LOCAL_SCOPE = 61,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DIP_ALL_NODES = 62,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DIP_ALL_ROUTERS = 63,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_SOLICIT = 64,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_ADVERT = 65,
	DEVLINK_TRAP_GENERIC_ID_IPV6_REDIRECT = 66,
	DEVLINK_TRAP_GENERIC_ID_IPV4_ROUTER_ALERT = 67,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_ALERT = 68,
	DEVLINK_TRAP_GENERIC_ID_PTP_EVENT = 69,
	DEVLINK_TRAP_GENERIC_ID_PTP_GENERAL = 70,
	DEVLINK_TRAP_GENERIC_ID_FLOW_ACTION_SAMPLE = 71,
	DEVLINK_TRAP_GENERIC_ID_FLOW_ACTION_TRAP = 72,
	DEVLINK_TRAP_GENERIC_ID_EARLY_DROP = 73,
	DEVLINK_TRAP_GENERIC_ID_VXLAN_PARSING = 74,
	DEVLINK_TRAP_GENERIC_ID_LLC_SNAP_PARSING = 75,
	DEVLINK_TRAP_GENERIC_ID_VLAN_PARSING = 76,
	DEVLINK_TRAP_GENERIC_ID_PPPOE_PPP_PARSING = 77,
	DEVLINK_TRAP_GENERIC_ID_MPLS_PARSING = 78,
	DEVLINK_TRAP_GENERIC_ID_ARP_PARSING = 79,
	DEVLINK_TRAP_GENERIC_ID_IP_1_PARSING = 80,
	DEVLINK_TRAP_GENERIC_ID_IP_N_PARSING = 81,
	DEVLINK_TRAP_GENERIC_ID_GRE_PARSING = 82,
	DEVLINK_TRAP_GENERIC_ID_UDP_PARSING = 83,
	DEVLINK_TRAP_GENERIC_ID_TCP_PARSING = 84,
	DEVLINK_TRAP_GENERIC_ID_IPSEC_PARSING = 85,
	DEVLINK_TRAP_GENERIC_ID_SCTP_PARSING = 86,
	DEVLINK_TRAP_GENERIC_ID_DCCP_PARSING = 87,
	DEVLINK_TRAP_GENERIC_ID_GTP_PARSING = 88,
	DEVLINK_TRAP_GENERIC_ID_ESP_PARSING = 89,
	DEVLINK_TRAP_GENERIC_ID_BLACKHOLE_NEXTHOP = 90,
	DEVLINK_TRAP_GENERIC_ID_DMAC_FILTER = 91,
	DEVLINK_TRAP_GENERIC_ID_EAPOL = 92,
	DEVLINK_TRAP_GENERIC_ID_LOCKED_PORT = 93,
	__DEVLINK_TRAP_GENERIC_ID_MAX = 94,
	DEVLINK_TRAP_GENERIC_ID_MAX = 93,
};

enum devlink_trap_group_generic_id {
	DEVLINK_TRAP_GROUP_GENERIC_ID_L2_DROPS = 0,
	DEVLINK_TRAP_GROUP_GENERIC_ID_L3_DROPS = 1,
	DEVLINK_TRAP_GROUP_GENERIC_ID_L3_EXCEPTIONS = 2,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BUFFER_DROPS = 3,
	DEVLINK_TRAP_GROUP_GENERIC_ID_TUNNEL_DROPS = 4,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_DROPS = 5,
	DEVLINK_TRAP_GROUP_GENERIC_ID_STP = 6,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LACP = 7,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LLDP = 8,
	DEVLINK_TRAP_GROUP_GENERIC_ID_MC_SNOOPING = 9,
	DEVLINK_TRAP_GROUP_GENERIC_ID_DHCP = 10,
	DEVLINK_TRAP_GROUP_GENERIC_ID_NEIGH_DISCOVERY = 11,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BFD = 12,
	DEVLINK_TRAP_GROUP_GENERIC_ID_OSPF = 13,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BGP = 14,
	DEVLINK_TRAP_GROUP_GENERIC_ID_VRRP = 15,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PIM = 16,
	DEVLINK_TRAP_GROUP_GENERIC_ID_UC_LB = 17,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LOCAL_DELIVERY = 18,
	DEVLINK_TRAP_GROUP_GENERIC_ID_EXTERNAL_DELIVERY = 19,
	DEVLINK_TRAP_GROUP_GENERIC_ID_IPV6 = 20,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PTP_EVENT = 21,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PTP_GENERAL = 22,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_SAMPLE = 23,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_TRAP = 24,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PARSER_ERROR_DROPS = 25,
	DEVLINK_TRAP_GROUP_GENERIC_ID_EAPOL = 26,
	__DEVLINK_TRAP_GROUP_GENERIC_ID_MAX = 27,
	DEVLINK_TRAP_GROUP_GENERIC_ID_MAX = 26,
};

enum devlink_trap_type {
	DEVLINK_TRAP_TYPE_DROP = 0,
	DEVLINK_TRAP_TYPE_EXCEPTION = 1,
	DEVLINK_TRAP_TYPE_CONTROL = 2,
};

enum devlink_var_attr_type {
	DEVLINK_VAR_ATTR_TYPE_U8 = 1,
	DEVLINK_VAR_ATTR_TYPE_U16 = 2,
	DEVLINK_VAR_ATTR_TYPE_U32 = 3,
	DEVLINK_VAR_ATTR_TYPE_U64 = 4,
	DEVLINK_VAR_ATTR_TYPE_STRING = 5,
	DEVLINK_VAR_ATTR_TYPE_FLAG = 6,
	DEVLINK_VAR_ATTR_TYPE_NUL_STRING = 10,
	DEVLINK_VAR_ATTR_TYPE_BINARY = 11,
	__DEVLINK_VAR_ATTR_TYPE_CUSTOM_BASE = 128,
};

enum devm_ioremap_type {
	DEVM_IOREMAP = 0,
	DEVM_IOREMAP_UC = 1,
	DEVM_IOREMAP_WC = 2,
	DEVM_IOREMAP_NP = 3,
};

enum dew_regs {
	PWRAP_DEW_BASE = 0,
	PWRAP_DEW_DIO_EN = 1,
	PWRAP_DEW_READ_TEST = 2,
	PWRAP_DEW_WRITE_TEST = 3,
	PWRAP_DEW_CRC_EN = 4,
	PWRAP_DEW_CRC_VAL = 5,
	PWRAP_DEW_MON_GRP_SEL = 6,
	PWRAP_DEW_CIPHER_KEY_SEL = 7,
	PWRAP_DEW_CIPHER_IV_SEL = 8,
	PWRAP_DEW_CIPHER_RDY = 9,
	PWRAP_DEW_CIPHER_MODE = 10,
	PWRAP_DEW_CIPHER_SWRST = 11,
	PWRAP_DEW_CIPHER_EN = 12,
	PWRAP_DEW_RDDMY_NO = 13,
	PWRAP_SMT_CON1 = 14,
	PWRAP_DRV_CON1 = 15,
	PWRAP_FILTER_CON0 = 16,
	PWRAP_GPIO_PULLEN0_CLR = 17,
	PWRAP_RG_SPI_CON0 = 18,
	PWRAP_RG_SPI_RECORD0 = 19,
	PWRAP_RG_SPI_CON2 = 20,
	PWRAP_RG_SPI_CON3 = 21,
	PWRAP_RG_SPI_CON4 = 22,
	PWRAP_RG_SPI_CON5 = 23,
	PWRAP_RG_SPI_CON6 = 24,
	PWRAP_RG_SPI_CON7 = 25,
	PWRAP_RG_SPI_CON8 = 26,
	PWRAP_RG_SPI_CON13 = 27,
	PWRAP_SPISLV_KEY = 28,
	PWRAP_DEW_CRC_SWRST = 29,
	PWRAP_DEW_RG_EN_RECORD = 30,
	PWRAP_DEW_RECORD_CMD0 = 31,
	PWRAP_DEW_RECORD_CMD1 = 32,
	PWRAP_DEW_RECORD_CMD2 = 33,
	PWRAP_DEW_RECORD_CMD3 = 34,
	PWRAP_DEW_RECORD_CMD4 = 35,
	PWRAP_DEW_RECORD_CMD5 = 36,
	PWRAP_DEW_RECORD_WDATA0 = 37,
	PWRAP_DEW_RECORD_WDATA1 = 38,
	PWRAP_DEW_RECORD_WDATA2 = 39,
	PWRAP_DEW_RECORD_WDATA3 = 40,
	PWRAP_DEW_RECORD_WDATA4 = 41,
	PWRAP_DEW_RECORD_WDATA5 = 42,
	PWRAP_DEW_RG_ADDR_TARGET = 43,
	PWRAP_DEW_RG_ADDR_MASK = 44,
	PWRAP_DEW_RG_WDATA_TARGET = 45,
	PWRAP_DEW_RG_WDATA_MASK = 46,
	PWRAP_DEW_RG_SPI_RECORD_CLR = 47,
	PWRAP_DEW_RG_CMD_ALERT_CLR = 48,
	PWRAP_DEW_EVENT_OUT_EN = 49,
	PWRAP_DEW_EVENT_SRC_EN = 50,
	PWRAP_DEW_EVENT_SRC = 51,
	PWRAP_DEW_EVENT_FLAG = 52,
	PWRAP_DEW_MON_FLAG_SEL = 53,
	PWRAP_DEW_EVENT_TEST = 54,
	PWRAP_DEW_CIPHER_LOAD = 55,
	PWRAP_DEW_CIPHER_START = 56,
};

enum dfll_ctrl_mode {
	DFLL_UNINITIALIZED = 0,
	DFLL_DISABLED = 1,
	DFLL_OPEN_LOOP = 2,
	DFLL_CLOSED_LOOP = 3,
};

enum dfll_tune_range {
	DFLL_TUNE_UNINITIALIZED = 0,
	DFLL_TUNE_LOW = 1,
};

enum die_val {
	DIE_UNUSED = 0,
	DIE_OOPS = 1,
};

enum dim_cq_period_mode {
	DIM_CQ_PERIOD_MODE_START_FROM_EQE = 0,
	DIM_CQ_PERIOD_MODE_START_FROM_CQE = 1,
	DIM_CQ_PERIOD_NUM_MODES = 2,
};

enum dim_state {
	DIM_START_MEASURE = 0,
	DIM_MEASURE_IN_PROGRESS = 1,
	DIM_APPLY_NEW_PROFILE = 2,
};

enum dim_stats_state {
	DIM_STATS_WORSE = 0,
	DIM_STATS_SAME = 1,
	DIM_STATS_BETTER = 2,
};

enum dim_step_result {
	DIM_STEPPED = 0,
	DIM_TOO_TIRED = 1,
	DIM_ON_EDGE = 2,
};

enum dim_tune_state {
	DIM_PARKING_ON_TOP = 0,
	DIM_PARKING_TIRED = 1,
	DIM_GOING_RIGHT = 2,
	DIM_GOING_LEFT = 3,
};

enum discover_event {
	DISCE_DISCOVER_DOMAIN = 0,
	DISCE_REVALIDATE_DOMAIN = 1,
	DISCE_SUSPEND = 2,
	DISCE_RESUME = 3,
	DISC_NUM_EVENTS = 4,
};

enum display_flags {
	DISPLAY_FLAGS_HSYNC_LOW = 1,
	DISPLAY_FLAGS_HSYNC_HIGH = 2,
	DISPLAY_FLAGS_VSYNC_LOW = 4,
	DISPLAY_FLAGS_VSYNC_HIGH = 8,
	DISPLAY_FLAGS_DE_LOW = 16,
	DISPLAY_FLAGS_DE_HIGH = 32,
	DISPLAY_FLAGS_PIXDATA_POSEDGE = 64,
	DISPLAY_FLAGS_PIXDATA_NEGEDGE = 128,
	DISPLAY_FLAGS_INTERLACED = 256,
	DISPLAY_FLAGS_DOUBLESCAN = 512,
	DISPLAY_FLAGS_DOUBLECLK = 1024,
	DISPLAY_FLAGS_SYNC_POSEDGE = 2048,
	DISPLAY_FLAGS_SYNC_NEGEDGE = 4096,
};

enum dl_bw_request {
	dl_bw_req_deactivate = 0,
	dl_bw_req_alloc = 1,
	dl_bw_req_free = 2,
};

enum dl_dev_state {
	DL_DEV_NO_DRIVER = 0,
	DL_DEV_PROBING = 1,
	DL_DEV_DRIVER_BOUND = 2,
	DL_DEV_UNBINDING = 3,
};

enum dl_param {
	DL_RUNTIME = 0,
	DL_PERIOD = 1,
};

enum dll_reset_type {
	PM_DLL_RESET_ASSERT = 0,
	PM_DLL_RESET_RELEASE = 1,
	PM_DLL_RESET_PULSE = 2,
};

enum dma_channel_status {
	MUSB_DMA_STATUS_UNKNOWN = 0,
	MUSB_DMA_STATUS_FREE = 1,
	MUSB_DMA_STATUS_BUSY = 2,
	MUSB_DMA_STATUS_BUS_ABORT = 3,
	MUSB_DMA_STATUS_CORE_ABORT = 4,
};

enum dma_ctrl_flags {
	DMA_PREP_INTERRUPT = 1,
	DMA_CTRL_ACK = 2,
	DMA_PREP_PQ_DISABLE_P = 4,
	DMA_PREP_PQ_DISABLE_Q = 8,
	DMA_PREP_CONTINUE = 16,
	DMA_PREP_FENCE = 32,
	DMA_CTRL_REUSE = 64,
	DMA_PREP_CMD = 128,
	DMA_PREP_REPEAT = 256,
	DMA_PREP_LOAD_EOT = 512,
};

enum dma_data_direction {
	DMA_BIDIRECTIONAL = 0,
	DMA_TO_DEVICE = 1,
	DMA_FROM_DEVICE = 2,
	DMA_NONE = 3,
};

enum dma_desc_metadata_mode {
	DESC_METADATA_NONE = 0,
	DESC_METADATA_CLIENT = 1,
	DESC_METADATA_ENGINE = 2,
};

enum dma_fence_flag_bits {
	DMA_FENCE_FLAG_SIGNALED_BIT = 0,
	DMA_FENCE_FLAG_TIMESTAMP_BIT = 1,
	DMA_FENCE_FLAG_ENABLE_SIGNAL_BIT = 2,
	DMA_FENCE_FLAG_USER_BITS = 3,
};

enum dma_residue_granularity {
	DMA_RESIDUE_GRANULARITY_DESCRIPTOR = 0,
	DMA_RESIDUE_GRANULARITY_SEGMENT = 1,
	DMA_RESIDUE_GRANULARITY_BURST = 2,
};

enum dma_resv_usage {
	DMA_RESV_USAGE_KERNEL = 0,
	DMA_RESV_USAGE_WRITE = 1,
	DMA_RESV_USAGE_READ = 2,
	DMA_RESV_USAGE_BOOKKEEP = 3,
};

enum dma_rx_status {
	DMA_RX_START = 0,
	DMA_RX_RUNNING = 1,
	DMA_RX_SHUTDOWN = 2,
};

enum dma_slave_buswidth {
	DMA_SLAVE_BUSWIDTH_UNDEFINED = 0,
	DMA_SLAVE_BUSWIDTH_1_BYTE = 1,
	DMA_SLAVE_BUSWIDTH_2_BYTES = 2,
	DMA_SLAVE_BUSWIDTH_3_BYTES = 3,
	DMA_SLAVE_BUSWIDTH_4_BYTES = 4,
	DMA_SLAVE_BUSWIDTH_8_BYTES = 8,
	DMA_SLAVE_BUSWIDTH_16_BYTES = 16,
	DMA_SLAVE_BUSWIDTH_32_BYTES = 32,
	DMA_SLAVE_BUSWIDTH_64_BYTES = 64,
	DMA_SLAVE_BUSWIDTH_128_BYTES = 128,
};

enum dma_status {
	DMA_COMPLETE = 0,
	DMA_IN_PROGRESS = 1,
	DMA_PAUSED = 2,
	DMA_ERROR = 3,
	DMA_OUT_OF_ORDER = 4,
};

enum dma_transaction_type {
	DMA_MEMCPY = 0,
	DMA_XOR = 1,
	DMA_PQ = 2,
	DMA_XOR_VAL = 3,
	DMA_PQ_VAL = 4,
	DMA_MEMSET = 5,
	DMA_MEMSET_SG = 6,
	DMA_INTERRUPT = 7,
	DMA_PRIVATE = 8,
	DMA_ASYNC_TX = 9,
	DMA_SLAVE = 10,
	DMA_CYCLIC = 11,
	DMA_INTERLEAVE = 12,
	DMA_COMPLETION_NO_ORDER = 13,
	DMA_REPEAT = 14,
	DMA_LOAD_EOT = 15,
	DMA_TX_TYPE_END = 16,
};

enum dma_transfer_direction {
	DMA_MEM_TO_MEM = 0,
	DMA_MEM_TO_DEV = 1,
	DMA_DEV_TO_MEM = 2,
	DMA_DEV_TO_DEV = 3,
	DMA_TRANS_NONE = 4,
};

enum dmaengine_alignment {
	DMAENGINE_ALIGN_1_BYTE = 0,
	DMAENGINE_ALIGN_2_BYTES = 1,
	DMAENGINE_ALIGN_4_BYTES = 2,
	DMAENGINE_ALIGN_8_BYTES = 3,
	DMAENGINE_ALIGN_16_BYTES = 4,
	DMAENGINE_ALIGN_32_BYTES = 5,
	DMAENGINE_ALIGN_64_BYTES = 6,
	DMAENGINE_ALIGN_128_BYTES = 7,
	DMAENGINE_ALIGN_256_BYTES = 8,
};

enum dmaengine_tx_result {
	DMA_TRANS_NOERROR = 0,
	DMA_TRANS_READ_FAILED = 1,
	DMA_TRANS_WRITE_FAILED = 2,
	DMA_TRANS_ABORTED = 3,
};

enum dmamov_dst {
	SAR = 0,
	CCR = 1,
	DAR = 2,
};

enum dmi_device_type {
	DMI_DEV_TYPE_ANY = 0,
	DMI_DEV_TYPE_OTHER = 1,
	DMI_DEV_TYPE_UNKNOWN = 2,
	DMI_DEV_TYPE_VIDEO = 3,
	DMI_DEV_TYPE_SCSI = 4,
	DMI_DEV_TYPE_ETHERNET = 5,
	DMI_DEV_TYPE_TOKENRING = 6,
	DMI_DEV_TYPE_SOUND = 7,
	DMI_DEV_TYPE_PATA = 8,
	DMI_DEV_TYPE_SATA = 9,
	DMI_DEV_TYPE_SAS = 10,
	DMI_DEV_TYPE_IPMI = -1,
	DMI_DEV_TYPE_OEM_STRING = -2,
	DMI_DEV_TYPE_DEV_ONBOARD = -3,
	DMI_DEV_TYPE_DEV_SLOT = -4,
};

enum dmi_entry_type {
	DMI_ENTRY_BIOS = 0,
	DMI_ENTRY_SYSTEM = 1,
	DMI_ENTRY_BASEBOARD = 2,
	DMI_ENTRY_CHASSIS = 3,
	DMI_ENTRY_PROCESSOR = 4,
	DMI_ENTRY_MEM_CONTROLLER = 5,
	DMI_ENTRY_MEM_MODULE = 6,
	DMI_ENTRY_CACHE = 7,
	DMI_ENTRY_PORT_CONNECTOR = 8,
	DMI_ENTRY_SYSTEM_SLOT = 9,
	DMI_ENTRY_ONBOARD_DEVICE = 10,
	DMI_ENTRY_OEMSTRINGS = 11,
	DMI_ENTRY_SYSCONF = 12,
	DMI_ENTRY_BIOS_LANG = 13,
	DMI_ENTRY_GROUP_ASSOC = 14,
	DMI_ENTRY_SYSTEM_EVENT_LOG = 15,
	DMI_ENTRY_PHYS_MEM_ARRAY = 16,
	DMI_ENTRY_MEM_DEVICE = 17,
	DMI_ENTRY_32_MEM_ERROR = 18,
	DMI_ENTRY_MEM_ARRAY_MAPPED_ADDR = 19,
	DMI_ENTRY_MEM_DEV_MAPPED_ADDR = 20,
	DMI_ENTRY_BUILTIN_POINTING_DEV = 21,
	DMI_ENTRY_PORTABLE_BATTERY = 22,
	DMI_ENTRY_SYSTEM_RESET = 23,
	DMI_ENTRY_HW_SECURITY = 24,
	DMI_ENTRY_SYSTEM_POWER_CONTROLS = 25,
	DMI_ENTRY_VOLTAGE_PROBE = 26,
	DMI_ENTRY_COOLING_DEV = 27,
	DMI_ENTRY_TEMP_PROBE = 28,
	DMI_ENTRY_ELECTRICAL_CURRENT_PROBE = 29,
	DMI_ENTRY_OOB_REMOTE_ACCESS = 30,
	DMI_ENTRY_BIS_ENTRY = 31,
	DMI_ENTRY_SYSTEM_BOOT = 32,
	DMI_ENTRY_MGMT_DEV = 33,
	DMI_ENTRY_MGMT_DEV_COMPONENT = 34,
	DMI_ENTRY_MGMT_DEV_THRES = 35,
	DMI_ENTRY_MEM_CHANNEL = 36,
	DMI_ENTRY_IPMI_DEV = 37,
	DMI_ENTRY_SYS_POWER_SUPPLY = 38,
	DMI_ENTRY_ADDITIONAL = 39,
	DMI_ENTRY_ONBOARD_DEV_EXT = 40,
	DMI_ENTRY_MGMT_CONTROLLER_HOST = 41,
	DMI_ENTRY_INACTIVE = 126,
	DMI_ENTRY_END_OF_TABLE = 127,
};

enum dmi_field {
	DMI_NONE = 0,
	DMI_BIOS_VENDOR = 1,
	DMI_BIOS_VERSION = 2,
	DMI_BIOS_DATE = 3,
	DMI_BIOS_RELEASE = 4,
	DMI_EC_FIRMWARE_RELEASE = 5,
	DMI_SYS_VENDOR = 6,
	DMI_PRODUCT_NAME = 7,
	DMI_PRODUCT_VERSION = 8,
	DMI_PRODUCT_SERIAL = 9,
	DMI_PRODUCT_UUID = 10,
	DMI_PRODUCT_SKU = 11,
	DMI_PRODUCT_FAMILY = 12,
	DMI_BOARD_VENDOR = 13,
	DMI_BOARD_NAME = 14,
	DMI_BOARD_VERSION = 15,
	DMI_BOARD_SERIAL = 16,
	DMI_BOARD_ASSET_TAG = 17,
	DMI_CHASSIS_VENDOR = 18,
	DMI_CHASSIS_TYPE = 19,
	DMI_CHASSIS_VERSION = 20,
	DMI_CHASSIS_SERIAL = 21,
	DMI_CHASSIS_ASSET_TAG = 22,
	DMI_STRING_MAX = 23,
	DMI_OEM_STRING = 24,
};

enum dns_lookup_status {
	DNS_LOOKUP_NOT_DONE = 0,
	DNS_LOOKUP_GOOD = 1,
	DNS_LOOKUP_GOOD_WITH_BAD = 2,
	DNS_LOOKUP_BAD = 3,
	DNS_LOOKUP_GOT_NOT_FOUND = 4,
	DNS_LOOKUP_GOT_LOCAL_FAILURE = 5,
	DNS_LOOKUP_GOT_TEMP_FAILURE = 6,
	DNS_LOOKUP_GOT_NS_FAILURE = 7,
	NR__dns_lookup_status = 8,
};

enum dns_payload_content_type {
	DNS_PAYLOAD_IS_SERVER_LIST = 0,
};

enum dpaa2_eth_fq_type {
	DPAA2_RX_FQ = 0,
	DPAA2_TX_CONF_FQ = 1,
	DPAA2_RX_ERR_FQ = 2,
};

enum dpaa2_eth_rx_dist {
	DPAA2_ETH_RX_DIST_HASH = 0,
	DPAA2_ETH_RX_DIST_CLS = 1,
};

enum dpaa2_eth_swa_type {
	DPAA2_ETH_SWA_SINGLE = 0,
	DPAA2_ETH_SWA_SG = 1,
	DPAA2_ETH_SWA_XDP = 2,
	DPAA2_ETH_SWA_XSK = 3,
	DPAA2_ETH_SWA_SW_TSO = 4,
};

enum dpaa2_fd_format {
	dpaa2_fd_single = 0,
	dpaa2_fd_list = 1,
	dpaa2_fd_sg = 2,
};

enum dpaa_fq_type {
	FQ_TYPE_RX_DEFAULT = 1,
	FQ_TYPE_RX_ERROR = 2,
	FQ_TYPE_RX_PCD = 3,
	FQ_TYPE_TX = 4,
	FQ_TYPE_TX_CONFIRM = 5,
	FQ_TYPE_TX_CONF_MQ = 6,
	FQ_TYPE_TX_ERROR = 7,
};

enum dpfe_commands {
	DPFE_CMD_GET_INFO = 0,
	DPFE_CMD_GET_REFRESH = 1,
	DPFE_CMD_GET_VENDOR = 2,
	DPFE_CMD_MAX = 3,
};

enum dpfe_msg_fields {
	MSG_HEADER = 0,
	MSG_COMMAND = 1,
	MSG_ARG_COUNT = 2,
	MSG_ARG0 = 3,
	MSG_FIELD_MAX = 16,
};

enum dpio_channel_mode {
	DPIO_NO_CHANNEL = 0,
	DPIO_LOCAL_CHANNEL = 1,
};

enum dpkg_extract_from_hdr_type {
	DPKG_FROM_HDR = 0,
	DPKG_FROM_FIELD = 1,
	DPKG_FULL_FIELD = 2,
};

enum dpkg_extract_type {
	DPKG_EXTRACT_FROM_HDR = 0,
	DPKG_EXTRACT_FROM_DATA = 1,
	DPKG_EXTRACT_FROM_PARSE = 3,
};

enum dpm_order {
	DPM_ORDER_NONE = 0,
	DPM_ORDER_DEV_AFTER_PARENT = 1,
	DPM_ORDER_PARENT_BEFORE_DEV = 2,
	DPM_ORDER_DEV_LAST = 3,
};

enum dpmac_counter_id {
	DPMAC_CNT_ING_FRAME_64 = 0,
	DPMAC_CNT_ING_FRAME_127 = 1,
	DPMAC_CNT_ING_FRAME_255 = 2,
	DPMAC_CNT_ING_FRAME_511 = 3,
	DPMAC_CNT_ING_FRAME_1023 = 4,
	DPMAC_CNT_ING_FRAME_1518 = 5,
	DPMAC_CNT_ING_FRAME_1519_MAX = 6,
	DPMAC_CNT_ING_FRAG = 7,
	DPMAC_CNT_ING_JABBER = 8,
	DPMAC_CNT_ING_FRAME_DISCARD = 9,
	DPMAC_CNT_ING_ALIGN_ERR = 10,
	DPMAC_CNT_EGR_UNDERSIZED = 11,
	DPMAC_CNT_ING_OVERSIZED = 12,
	DPMAC_CNT_ING_VALID_PAUSE_FRAME = 13,
	DPMAC_CNT_EGR_VALID_PAUSE_FRAME = 14,
	DPMAC_CNT_ING_BYTE = 15,
	DPMAC_CNT_ING_MCAST_FRAME = 16,
	DPMAC_CNT_ING_BCAST_FRAME = 17,
	DPMAC_CNT_ING_ALL_FRAME = 18,
	DPMAC_CNT_ING_UCAST_FRAME = 19,
	DPMAC_CNT_ING_ERR_FRAME = 20,
	DPMAC_CNT_EGR_BYTE = 21,
	DPMAC_CNT_EGR_MCAST_FRAME = 22,
	DPMAC_CNT_EGR_BCAST_FRAME = 23,
	DPMAC_CNT_EGR_UCAST_FRAME = 24,
	DPMAC_CNT_EGR_ERR_FRAME = 25,
	DPMAC_CNT_ING_GOOD_FRAME = 26,
	DPMAC_CNT_EGR_GOOD_FRAME = 27,
};

enum dpmac_eth_if {
	DPMAC_ETH_IF_MII = 0,
	DPMAC_ETH_IF_RMII = 1,
	DPMAC_ETH_IF_SMII = 2,
	DPMAC_ETH_IF_GMII = 3,
	DPMAC_ETH_IF_RGMII = 4,
	DPMAC_ETH_IF_SGMII = 5,
	DPMAC_ETH_IF_QSGMII = 6,
	DPMAC_ETH_IF_XAUI = 7,
	DPMAC_ETH_IF_XFI = 8,
	DPMAC_ETH_IF_CAUI = 9,
	DPMAC_ETH_IF_1000BASEX = 10,
	DPMAC_ETH_IF_USXGMII = 11,
};

enum dpmac_link_type {
	DPMAC_LINK_TYPE_NONE = 0,
	DPMAC_LINK_TYPE_FIXED = 1,
	DPMAC_LINK_TYPE_PHY = 2,
	DPMAC_LINK_TYPE_BACKPLANE = 3,
};

enum dpni_congestion_point {
	DPNI_CP_QUEUE = 0,
	DPNI_CP_GROUP = 1,
};

enum dpni_congestion_unit {
	DPNI_CONGESTION_UNIT_BYTES = 0,
	DPNI_CONGESTION_UNIT_FRAMES = 1,
};

enum dpni_dest {
	DPNI_DEST_NONE = 0,
	DPNI_DEST_DPIO = 1,
	DPNI_DEST_DPCON = 2,
};

enum dpni_dist_mode {
	DPNI_DIST_MODE_NONE = 0,
	DPNI_DIST_MODE_HASH = 1,
	DPNI_DIST_MODE_FS = 2,
};

enum dpni_error_action {
	DPNI_ERROR_ACTION_DISCARD = 0,
	DPNI_ERROR_ACTION_CONTINUE = 1,
	DPNI_ERROR_ACTION_SEND_TO_ERROR_QUEUE = 2,
};

enum dpni_fs_miss_action {
	DPNI_FS_MISS_DROP = 0,
	DPNI_FS_MISS_EXPLICIT_FLOWID = 1,
	DPNI_FS_MISS_HASH = 2,
};

enum dpni_offload {
	DPNI_OFF_RX_L3_CSUM = 0,
	DPNI_OFF_RX_L4_CSUM = 1,
	DPNI_OFF_TX_L3_CSUM = 2,
	DPNI_OFF_TX_L4_CSUM = 3,
};

enum dpni_queue_type {
	DPNI_QUEUE_RX = 0,
	DPNI_QUEUE_TX = 1,
	DPNI_QUEUE_TX_CONFIRM = 2,
	DPNI_QUEUE_RX_ERR = 3,
};

enum dprc_region_type {
	DPRC_REGION_TYPE_MC_PORTAL = 0,
	DPRC_REGION_TYPE_QBMAN_PORTAL = 1,
	DPRC_REGION_TYPE_QBMAN_MEM_BACKED_PORTAL = 2,
};

enum drbg_prefixes {
	DRBG_PREFIX0 = 0,
	DRBG_PREFIX1 = 1,
	DRBG_PREFIX2 = 2,
	DRBG_PREFIX3 = 3,
};

enum drbg_seed_state {
	DRBG_SEED_STATE_UNSEEDED = 0,
	DRBG_SEED_STATE_PARTIAL = 1,
	DRBG_SEED_STATE_FULL = 2,
};

enum drm_panel_orientation {
	DRM_MODE_PANEL_ORIENTATION_UNKNOWN = -1,
	DRM_MODE_PANEL_ORIENTATION_NORMAL = 0,
	DRM_MODE_PANEL_ORIENTATION_BOTTOM_UP = 1,
	DRM_MODE_PANEL_ORIENTATION_LEFT_UP = 2,
	DRM_MODE_PANEL_ORIENTATION_RIGHT_UP = 3,
};

enum drvtype {
	LEGACY = 0,
	SYSCON = 1,
};

enum dsa_db_type {
	DSA_DB_PORT = 0,
	DSA_DB_LAG = 1,
	DSA_DB_BRIDGE = 2,
};

enum dsa_tag_protocol {
	DSA_TAG_PROTO_NONE = 0,
	DSA_TAG_PROTO_BRCM = 1,
	DSA_TAG_PROTO_BRCM_LEGACY = 22,
	DSA_TAG_PROTO_BRCM_PREPEND = 2,
	DSA_TAG_PROTO_DSA = 3,
	DSA_TAG_PROTO_EDSA = 4,
	DSA_TAG_PROTO_GSWIP = 5,
	DSA_TAG_PROTO_KSZ9477 = 6,
	DSA_TAG_PROTO_KSZ9893 = 7,
	DSA_TAG_PROTO_LAN9303 = 8,
	DSA_TAG_PROTO_MTK = 9,
	DSA_TAG_PROTO_QCA = 10,
	DSA_TAG_PROTO_TRAILER = 11,
	DSA_TAG_PROTO_8021Q = 12,
	DSA_TAG_PROTO_SJA1105 = 13,
	DSA_TAG_PROTO_KSZ8795 = 14,
	DSA_TAG_PROTO_OCELOT = 15,
	DSA_TAG_PROTO_AR9331 = 16,
	DSA_TAG_PROTO_RTL4_A = 17,
	DSA_TAG_PROTO_HELLCREEK = 18,
	DSA_TAG_PROTO_XRS700X = 19,
	DSA_TAG_PROTO_OCELOT_8021Q = 20,
	DSA_TAG_PROTO_SEVILLE = 21,
	DSA_TAG_PROTO_SJA1110 = 23,
	DSA_TAG_PROTO_RTL8_4 = 24,
	DSA_TAG_PROTO_RTL8_4T = 25,
	DSA_TAG_PROTO_RZN1_A5PSW = 26,
	DSA_TAG_PROTO_LAN937X = 27,
	DSA_TAG_PROTO_VSC73XX_8021Q = 28,
};

enum dsaf_mode {
	DSAF_MODE_INVALID = 0,
	DSAF_MODE_ENABLE_FIX = 1,
	DSAF_MODE_ENABLE_0VM = 2,
	DSAF_MODE_ENABLE_8VM = 3,
	DSAF_MODE_ENABLE_16VM = 4,
	DSAF_MODE_ENABLE_32VM = 5,
	DSAF_MODE_ENABLE_128VM = 6,
	DSAF_MODE_ENABLE = 7,
	DSAF_MODE_DISABLE_SP = 8,
	DSAF_MODE_DISABLE_FIX = 9,
	DSAF_MODE_DISABLE_2PORT_8VM = 10,
	DSAF_MODE_DISABLE_2PORT_16VM = 11,
	DSAF_MODE_DISABLE_2PORT_64VM = 12,
	DSAF_MODE_DISABLE_6PORT_0VM = 13,
	DSAF_MODE_DISABLE_6PORT_2VM = 14,
	DSAF_MODE_DISABLE_6PORT_4VM = 15,
	DSAF_MODE_DISABLE_6PORT_16VM = 16,
	DSAF_MODE_MAX = 17,
};

enum dsaf_port_rate_mode {
	DSAF_PORT_RATE_1000 = 0,
	DSAF_PORT_RATE_2500 = 1,
	DSAF_PORT_RATE_10000 = 2,
};

enum dsaf_stp_port_type {
	DSAF_STP_PORT_TYPE_DISCARD = 0,
	DSAF_STP_PORT_TYPE_BLOCK = 1,
	DSAF_STP_PORT_TYPE_LISTEN = 2,
	DSAF_STP_PORT_TYPE_LEARN = 3,
	DSAF_STP_PORT_TYPE_FORWARD = 4,
};

enum dsaf_sw_port_type {
	DSAF_SW_PORT_TYPE_NON_VLAN = 0,
	DSAF_SW_PORT_TYPE_ACCESS = 1,
	DSAF_SW_PORT_TYPE_TRUNK = 2,
};

enum dspi_trans_mode {
	DSPI_XSPI_MODE = 0,
	DSPI_DMA_MODE = 1,
};

enum dw_edma_chip_flags {
	DW_EDMA_CHIP_LOCAL = 1,
};

enum dw_edma_map_format {
	EDMA_MF_EDMA_LEGACY = 0,
	EDMA_MF_EDMA_UNROLL = 1,
	EDMA_MF_HDMA_COMPAT = 5,
	EDMA_MF_HDMA_NATIVE = 7,
};

enum dw_mci_cookie {
	COOKIE_UNMAPPED = 0,
	COOKIE_PRE_MAPPED = 1,
	COOKIE_MAPPED = 2,
};

enum dw_mci_exynos_type {
	DW_MCI_TYPE_EXYNOS4210 = 0,
	DW_MCI_TYPE_EXYNOS4412 = 1,
	DW_MCI_TYPE_EXYNOS5250 = 2,
	DW_MCI_TYPE_EXYNOS5420 = 3,
	DW_MCI_TYPE_EXYNOS5420_SMU = 4,
	DW_MCI_TYPE_EXYNOS7 = 5,
	DW_MCI_TYPE_EXYNOS7_SMU = 6,
	DW_MCI_TYPE_EXYNOS7870 = 7,
	DW_MCI_TYPE_EXYNOS7870_SMU = 8,
	DW_MCI_TYPE_ARTPEC8 = 9,
};

enum dw_mci_state {
	STATE_IDLE___2 = 0,
	STATE_SENDING_CMD = 1,
	STATE_SENDING_DATA = 2,
	STATE_DATA_BUSY = 3,
	STATE_SENDING_STOP = 4,
	STATE_DATA_ERROR = 5,
	STATE_SENDING_CMD11 = 6,
	STATE_WAITING_CMD11_DONE = 7,
};

enum dw_pcie_app_clk {
	DW_PCIE_DBI_CLK = 0,
	DW_PCIE_MSTR_CLK = 1,
	DW_PCIE_SLV_CLK = 2,
	DW_PCIE_NUM_APP_CLKS = 3,
};

enum dw_pcie_app_rst {
	DW_PCIE_DBI_RST = 0,
	DW_PCIE_MSTR_RST = 1,
	DW_PCIE_SLV_RST = 2,
	DW_PCIE_NUM_APP_RSTS = 3,
};

enum dw_pcie_core_clk {
	DW_PCIE_PIPE_CLK = 0,
	DW_PCIE_CORE_CLK = 1,
	DW_PCIE_AUX_CLK = 2,
	DW_PCIE_REF_CLK = 3,
	DW_PCIE_NUM_CORE_CLKS = 4,
};

enum dw_pcie_core_rst {
	DW_PCIE_NON_STICKY_RST = 0,
	DW_PCIE_STICKY_RST = 1,
	DW_PCIE_CORE_RST = 2,
	DW_PCIE_PIPE_RST = 3,
	DW_PCIE_PHY_RST = 4,
	DW_PCIE_HOT_RST = 5,
	DW_PCIE_PWR_RST = 6,
	DW_PCIE_NUM_CORE_RSTS = 7,
};

enum dw_pcie_device_mode {
	DW_PCIE_UNKNOWN_TYPE = 0,
	DW_PCIE_EP_TYPE = 1,
	DW_PCIE_LEG_EP_TYPE = 2,
	DW_PCIE_RC_TYPE = 3,
};

enum dw_pcie_ltssm {
	DW_PCIE_LTSSM_DETECT_QUIET = 0,
	DW_PCIE_LTSSM_DETECT_ACT = 1,
	DW_PCIE_LTSSM_POLL_ACTIVE = 2,
	DW_PCIE_LTSSM_POLL_COMPLIANCE = 3,
	DW_PCIE_LTSSM_POLL_CONFIG = 4,
	DW_PCIE_LTSSM_PRE_DETECT_QUIET = 5,
	DW_PCIE_LTSSM_DETECT_WAIT = 6,
	DW_PCIE_LTSSM_CFG_LINKWD_START = 7,
	DW_PCIE_LTSSM_CFG_LINKWD_ACEPT = 8,
	DW_PCIE_LTSSM_CFG_LANENUM_WAI = 9,
	DW_PCIE_LTSSM_CFG_LANENUM_ACEPT = 10,
	DW_PCIE_LTSSM_CFG_COMPLETE = 11,
	DW_PCIE_LTSSM_CFG_IDLE = 12,
	DW_PCIE_LTSSM_RCVRY_LOCK = 13,
	DW_PCIE_LTSSM_RCVRY_SPEED = 14,
	DW_PCIE_LTSSM_RCVRY_RCVRCFG = 15,
	DW_PCIE_LTSSM_RCVRY_IDLE = 16,
	DW_PCIE_LTSSM_L0 = 17,
	DW_PCIE_LTSSM_L0S = 18,
	DW_PCIE_LTSSM_L123_SEND_EIDLE = 19,
	DW_PCIE_LTSSM_L1_IDLE = 20,
	DW_PCIE_LTSSM_L2_IDLE = 21,
	DW_PCIE_LTSSM_L2_WAKE = 22,
	DW_PCIE_LTSSM_DISABLED_ENTRY = 23,
	DW_PCIE_LTSSM_DISABLED_IDLE = 24,
	DW_PCIE_LTSSM_DISABLED = 25,
	DW_PCIE_LTSSM_LPBK_ENTRY = 26,
	DW_PCIE_LTSSM_LPBK_ACTIVE = 27,
	DW_PCIE_LTSSM_LPBK_EXIT = 28,
	DW_PCIE_LTSSM_LPBK_EXIT_TIMEOUT = 29,
	DW_PCIE_LTSSM_HOT_RESET_ENTRY = 30,
	DW_PCIE_LTSSM_HOT_RESET = 31,
	DW_PCIE_LTSSM_RCVRY_EQ0 = 32,
	DW_PCIE_LTSSM_RCVRY_EQ1 = 33,
	DW_PCIE_LTSSM_RCVRY_EQ2 = 34,
	DW_PCIE_LTSSM_RCVRY_EQ3 = 35,
	DW_PCIE_LTSSM_UNKNOWN = 4294967295,
};

enum dw_wdt_rmod {
	DW_WDT_RMOD_RESET = 1,
	DW_WDT_RMOD_IRQ = 2,
};

enum dwc2_control_phase {
	DWC2_CONTROL_SETUP = 0,
	DWC2_CONTROL_DATA = 1,
	DWC2_CONTROL_STATUS = 2,
};

enum dwc2_ep0_state {
	DWC2_EP0_SETUP = 0,
	DWC2_EP0_DATA_IN = 1,
	DWC2_EP0_DATA_OUT = 2,
	DWC2_EP0_STATUS_IN = 3,
	DWC2_EP0_STATUS_OUT = 4,
};

enum dwc2_halt_status {
	DWC2_HC_XFER_NO_HALT_STATUS = 0,
	DWC2_HC_XFER_COMPLETE = 1,
	DWC2_HC_XFER_URB_COMPLETE = 2,
	DWC2_HC_XFER_ACK = 3,
	DWC2_HC_XFER_NAK = 4,
	DWC2_HC_XFER_NYET = 5,
	DWC2_HC_XFER_STALL = 6,
	DWC2_HC_XFER_XACT_ERR = 7,
	DWC2_HC_XFER_FRAME_OVERRUN = 8,
	DWC2_HC_XFER_BABBLE_ERR = 9,
	DWC2_HC_XFER_DATA_TOGGLE_ERR = 10,
	DWC2_HC_XFER_AHB_ERR = 11,
	DWC2_HC_XFER_PERIODIC_INCOMPLETE = 12,
	DWC2_HC_XFER_URB_DEQUEUE = 13,
};

enum dwc2_hsotg_dmamode {
	S3C_HSOTG_DMA_NONE = 0,
	S3C_HSOTG_DMA_ONLY = 1,
	S3C_HSOTG_DMA_DRV = 2,
};

enum dwc2_lx_state {
	DWC2_L0 = 0,
	DWC2_L1 = 1,
	DWC2_L2 = 2,
	DWC2_L3 = 3,
};

enum dwc2_transaction_type {
	DWC2_TRANSACTION_NONE = 0,
	DWC2_TRANSACTION_PERIODIC = 1,
	DWC2_TRANSACTION_NON_PERIODIC = 2,
	DWC2_TRANSACTION_ALL = 3,
};

enum dwc3_ep0_next {
	DWC3_EP0_UNKNOWN = 0,
	DWC3_EP0_COMPLETE = 1,
	DWC3_EP0_NRDY_DATA = 2,
	DWC3_EP0_NRDY_STATUS = 3,
};

enum dwc3_ep0_state {
	EP0_UNCONNECTED = 0,
	EP0_SETUP_PHASE = 1,
	EP0_DATA_PHASE = 2,
	EP0_STATUS_PHASE = 3,
};

enum dwc3_link_state {
	DWC3_LINK_STATE_U0 = 0,
	DWC3_LINK_STATE_U1 = 1,
	DWC3_LINK_STATE_U2 = 2,
	DWC3_LINK_STATE_U3 = 3,
	DWC3_LINK_STATE_SS_DIS = 4,
	DWC3_LINK_STATE_RX_DET = 5,
	DWC3_LINK_STATE_SS_INACT = 6,
	DWC3_LINK_STATE_POLL = 7,
	DWC3_LINK_STATE_RECOV = 8,
	DWC3_LINK_STATE_HRESET = 9,
	DWC3_LINK_STATE_CMPLY = 10,
	DWC3_LINK_STATE_LPBK = 11,
	DWC3_LINK_STATE_RESET = 14,
	DWC3_LINK_STATE_RESUME = 15,
	DWC3_LINK_STATE_MASK = 15,
};

enum dwcmshc_rk_type {
	DWCMSHC_RK3568 = 0,
	DWCMSHC_RK3588 = 1,
};

enum dynevent_type {
	DYNEVENT_TYPE_SYNTH = 1,
	DYNEVENT_TYPE_KPROBE = 2,
	DYNEVENT_TYPE_NONE = 3,
};

enum e1000_1000t_rx_status {
	e1000_1000t_rx_status_not_ok___2 = 0,
	e1000_1000t_rx_status_ok___2 = 1,
	e1000_1000t_rx_status_undefined___2 = 255,
};

enum e1000_boards {
	board_82571 = 0,
	board_82572 = 1,
	board_82573 = 2,
	board_82574 = 3,
	board_82583 = 4,
	board_80003es2lan = 5,
	board_ich8lan = 6,
	board_ich9lan = 7,
	board_ich10lan = 8,
	board_pchlan = 9,
	board_pch2lan = 10,
	board_pch_lpt = 11,
	board_pch_spt = 12,
	board_pch_cnp = 13,
	board_pch_tgp = 14,
	board_pch_adp = 15,
	board_pch_mtp = 16,
};

enum e1000_bus_speed {
	e1000_bus_speed_unknown___2 = 0,
	e1000_bus_speed_33___2 = 1,
	e1000_bus_speed_66___2 = 2,
	e1000_bus_speed_100___2 = 3,
	e1000_bus_speed_120___2 = 4,
	e1000_bus_speed_133___2 = 5,
	e1000_bus_speed_2500 = 6,
	e1000_bus_speed_5000 = 7,
	e1000_bus_speed_reserved___2 = 8,
};

enum e1000_bus_type {
	e1000_bus_type_unknown___2 = 0,
	e1000_bus_type_pci___2 = 1,
	e1000_bus_type_pcix___2 = 2,
	e1000_bus_type_pci_express = 3,
	e1000_bus_type_reserved___2 = 4,
};

enum e1000_bus_width {
	e1000_bus_width_unknown___2 = 0,
	e1000_bus_width_pcie_x1 = 1,
	e1000_bus_width_pcie_x2 = 2,
	e1000_bus_width_pcie_x4 = 4,
	e1000_bus_width_pcie_x8 = 8,
	e1000_bus_width_32___2 = 9,
	e1000_bus_width_64___2 = 10,
	e1000_bus_width_reserved___2 = 11,
};

enum e1000_fc_mode {
	e1000_fc_none = 0,
	e1000_fc_rx_pause = 1,
	e1000_fc_tx_pause = 2,
	e1000_fc_full = 3,
	e1000_fc_default = 255,
};

enum e1000_mac_type {
	e1000_undefined___2 = 0,
	e1000_vfadapt = 1,
	e1000_vfadapt_i350 = 2,
	e1000_num_macs___2 = 3,
};

enum e1000_mac_type___2 {
	e1000_82571 = 0,
	e1000_82572 = 1,
	e1000_82573 = 2,
	e1000_82574 = 3,
	e1000_82583 = 4,
	e1000_80003es2lan = 5,
	e1000_ich8lan = 6,
	e1000_ich9lan = 7,
	e1000_ich10lan = 8,
	e1000_pchlan = 9,
	e1000_pch2lan = 10,
	e1000_pch_lpt = 11,
	e1000_pch_spt = 12,
	e1000_pch_cnp = 13,
	e1000_pch_tgp = 14,
	e1000_pch_adp = 15,
	e1000_pch_mtp = 16,
	e1000_pch_lnp = 17,
	e1000_pch_ptp = 18,
	e1000_pch_nvp = 19,
};

enum e1000_mac_type___3 {
	e1000_undefined___3 = 0,
	e1000_82575 = 1,
	e1000_82576 = 2,
	e1000_82580 = 3,
	e1000_i350 = 4,
	e1000_i354 = 5,
	e1000_i210 = 6,
	e1000_i211 = 7,
	e1000_num_macs___3 = 8,
};

enum e1000_media_type {
	e1000_media_type_unknown = 0,
	e1000_media_type_copper___2 = 1,
	e1000_media_type_fiber___2 = 2,
	e1000_media_type_internal_serdes___2 = 3,
	e1000_num_media_types___2 = 4,
};

enum e1000_mng_mode {
	e1000_mng_mode_none = 0,
	e1000_mng_mode_asf = 1,
	e1000_mng_mode_pt = 2,
	e1000_mng_mode_ipmi = 3,
	e1000_mng_mode_host_if_only = 4,
};

enum e1000_ms_type {
	e1000_ms_hw_default___2 = 0,
	e1000_ms_force_master___2 = 1,
	e1000_ms_force_slave___2 = 2,
	e1000_ms_auto___2 = 3,
};

enum e1000_nvm_override {
	e1000_nvm_override_none = 0,
	e1000_nvm_override_spi_small = 1,
	e1000_nvm_override_spi_large = 2,
};

enum e1000_nvm_type {
	e1000_nvm_unknown = 0,
	e1000_nvm_none = 1,
	e1000_nvm_eeprom_spi = 2,
	e1000_nvm_flash_hw = 3,
	e1000_nvm_invm = 4,
	e1000_nvm_flash_sw = 5,
};

enum e1000_nvm_type___2 {
	e1000_nvm_unknown___2 = 0,
	e1000_nvm_none___2 = 1,
	e1000_nvm_eeprom_spi___2 = 2,
	e1000_nvm_flash_hw___2 = 3,
	e1000_nvm_flash_sw___2 = 4,
};

enum e1000_phy_type {
	e1000_phy_unknown = 0,
	e1000_phy_none = 1,
	e1000_phy_m88___2 = 2,
	e1000_phy_igp___2 = 3,
	e1000_phy_igp_2 = 4,
	e1000_phy_gg82563 = 5,
	e1000_phy_igp_3 = 6,
	e1000_phy_ife = 7,
	e1000_phy_bm = 8,
	e1000_phy_82578 = 9,
	e1000_phy_82577 = 10,
	e1000_phy_82579 = 11,
	e1000_phy_i217 = 12,
};

enum e1000_phy_type___2 {
	e1000_phy_unknown___2 = 0,
	e1000_phy_none___2 = 1,
	e1000_phy_m88___3 = 2,
	e1000_phy_igp___3 = 3,
	e1000_phy_igp_2___2 = 4,
	e1000_phy_gg82563___2 = 5,
	e1000_phy_igp_3___2 = 6,
	e1000_phy_ife___2 = 7,
	e1000_phy_82580 = 8,
	e1000_phy_i210 = 9,
	e1000_phy_bcm54616 = 10,
};

enum e1000_rev_polarity {
	e1000_rev_polarity_normal___2 = 0,
	e1000_rev_polarity_reversed___2 = 1,
	e1000_rev_polarity_undefined___2 = 255,
};

enum e1000_ring_flags_t {
	IGB_RING_FLAG_RX_3K_BUFFER = 0,
	IGB_RING_FLAG_RX_BUILD_SKB_ENABLED = 1,
	IGB_RING_FLAG_RX_SCTP_CSUM = 2,
	IGB_RING_FLAG_RX_LB_VLAN_BSWAP = 3,
	IGB_RING_FLAG_TX_CTX_IDX = 4,
	IGB_RING_FLAG_TX_DETECT_HANG = 5,
	IGB_RING_FLAG_TX_DISABLED = 6,
	IGB_RING_FLAG_RX_ALLOC_FAILED = 7,
};

enum e1000_serdes_link_state {
	e1000_serdes_link_down = 0,
	e1000_serdes_link_autoneg_progress = 1,
	e1000_serdes_link_autoneg_complete = 2,
	e1000_serdes_link_forced_up = 3,
};

enum e1000_smart_speed {
	e1000_smart_speed_default___2 = 0,
	e1000_smart_speed_on___2 = 1,
	e1000_smart_speed_off___2 = 2,
};

enum e1000_state_t {
	__E1000_TESTING = 0,
	__E1000_RESETTING = 1,
	__E1000_ACCESS_SHARED_RESOURCE = 2,
	__E1000_DOWN = 3,
};

enum e1000_state_t___2 {
	__E1000_TESTING___2 = 0,
	__E1000_RESETTING___2 = 1,
	__E1000_DOWN___2 = 2,
	__E1000_DISABLED = 3,
};

enum e1000_state_t___3 {
	__IGB_TESTING = 0,
	__IGB_RESETTING = 1,
	__IGB_DOWN = 2,
	__IGB_PTP_TX_IN_PROGRESS = 3,
};

enum e1000_ulp_state {
	e1000_ulp_state_unknown = 0,
	e1000_ulp_state_off = 1,
	e1000_ulp_state_on = 2,
};

enum ec_charge_control_cmd {
	EC_CHARGE_CONTROL_CMD_SET = 0,
	EC_CHARGE_CONTROL_CMD_GET = 1,
};

enum ec_charge_control_mode {
	CHARGE_CONTROL_NORMAL = 0,
	CHARGE_CONTROL_IDLE = 1,
	CHARGE_CONTROL_DISCHARGE = 2,
	CHARGE_CONTROL_COUNT = 3,
};

enum ec_comms_status {
	EC_COMMS_STATUS_PROCESSING = 1,
};

enum ec_console_read_subcmd {
	CONSOLE_READ_NEXT = 0,
	CONSOLE_READ_RECENT = 1,
};

enum ec_feature_code {
	EC_FEATURE_LIMITED = 0,
	EC_FEATURE_FLASH = 1,
	EC_FEATURE_PWM_FAN = 2,
	EC_FEATURE_PWM_KEYB = 3,
	EC_FEATURE_LIGHTBAR = 4,
	EC_FEATURE_LED = 5,
	EC_FEATURE_MOTION_SENSE = 6,
	EC_FEATURE_KEYB = 7,
	EC_FEATURE_PSTORE = 8,
	EC_FEATURE_PORT80 = 9,
	EC_FEATURE_THERMAL = 10,
	EC_FEATURE_BKLIGHT_SWITCH = 11,
	EC_FEATURE_WIFI_SWITCH = 12,
	EC_FEATURE_HOST_EVENTS = 13,
	EC_FEATURE_GPIO = 14,
	EC_FEATURE_I2C = 15,
	EC_FEATURE_CHARGER = 16,
	EC_FEATURE_BATTERY = 17,
	EC_FEATURE_SMART_BATTERY = 18,
	EC_FEATURE_HANG_DETECT = 19,
	EC_FEATURE_PMU = 20,
	EC_FEATURE_SUB_MCU = 21,
	EC_FEATURE_USB_PD = 22,
	EC_FEATURE_USB_MUX = 23,
	EC_FEATURE_MOTION_SENSE_FIFO = 24,
	EC_FEATURE_VSTORE = 25,
	EC_FEATURE_USBC_SS_MUX_VIRTUAL = 26,
	EC_FEATURE_RTC = 27,
	EC_FEATURE_FINGERPRINT = 28,
	EC_FEATURE_TOUCHPAD = 29,
	EC_FEATURE_RWSIG = 30,
	EC_FEATURE_DEVICE_EVENT = 31,
	EC_FEATURE_UNIFIED_WAKE_MASKS = 32,
	EC_FEATURE_HOST_EVENT64 = 33,
	EC_FEATURE_EXEC_IN_RAM = 34,
	EC_FEATURE_CEC = 35,
	EC_FEATURE_MOTION_SENSE_TIGHT_TIMESTAMPS = 36,
	EC_FEATURE_REFINED_TABLET_MODE_HYSTERESIS = 37,
	EC_FEATURE_SCP = 39,
	EC_FEATURE_ISH = 40,
	EC_FEATURE_TYPEC_CMD = 41,
	EC_FEATURE_TYPEC_REQUIRE_AP_MODE_ENTRY = 42,
	EC_FEATURE_TYPEC_MUX_REQUIRE_AP_ACK = 43,
	EC_FEATURE_S4_RESIDENCY = 44,
	EC_FEATURE_TYPEC_AP_MUX_SET = 45,
	EC_FEATURE_TYPEC_AP_VDM_SEND = 46,
	EC_FEATURE_SYSTEM_SAFE_MODE = 47,
	EC_FEATURE_ASSERT_REBOOTS = 48,
	EC_FEATURE_TOKENIZED_LOGGING = 49,
	EC_FEATURE_AMD_STB_DUMP = 50,
	EC_FEATURE_MEMORY_DUMP = 51,
	EC_FEATURE_TYPEC_DP2_1 = 52,
	EC_FEATURE_SCP_C1 = 53,
	EC_FEATURE_UCSI_PPM = 54,
};

enum ec_led_colors {
	EC_LED_COLOR_RED = 0,
	EC_LED_COLOR_GREEN = 1,
	EC_LED_COLOR_BLUE = 2,
	EC_LED_COLOR_YELLOW = 3,
	EC_LED_COLOR_WHITE = 4,
	EC_LED_COLOR_AMBER = 5,
	EC_LED_COLOR_COUNT = 6,
};

enum ec_mkbp_event {
	EC_MKBP_EVENT_KEY_MATRIX = 0,
	EC_MKBP_EVENT_HOST_EVENT = 1,
	EC_MKBP_EVENT_SENSOR_FIFO = 2,
	EC_MKBP_EVENT_BUTTON = 3,
	EC_MKBP_EVENT_SWITCH = 4,
	EC_MKBP_EVENT_FINGERPRINT = 5,
	EC_MKBP_EVENT_SYSRQ = 6,
	EC_MKBP_EVENT_HOST_EVENT64 = 7,
	EC_MKBP_EVENT_CEC_EVENT = 8,
	EC_MKBP_EVENT_CEC_MESSAGE = 9,
	EC_MKBP_EVENT_PCHG = 12,
	EC_MKBP_EVENT_COUNT = 13,
};

enum ec_mkbp_info_type {
	EC_MKBP_INFO_KBD = 0,
	EC_MKBP_INFO_SUPPORTED = 1,
	EC_MKBP_INFO_CURRENT = 2,
};

enum ec_reboot_cmd {
	EC_REBOOT_CANCEL = 0,
	EC_REBOOT_JUMP_RO = 1,
	EC_REBOOT_JUMP_RW = 2,
	EC_REBOOT_COLD = 4,
	EC_REBOOT_DISABLE_JUMP = 5,
	EC_REBOOT_HIBERNATE = 6,
	EC_REBOOT_HIBERNATE_CLEAR_AP_OFF = 7,
	EC_REBOOT_COLD_AP_OFF = 8,
};

enum ec_status {
	EC_RES_SUCCESS = 0,
	EC_RES_INVALID_COMMAND = 1,
	EC_RES_ERROR = 2,
	EC_RES_INVALID_PARAM = 3,
	EC_RES_ACCESS_DENIED = 4,
	EC_RES_INVALID_RESPONSE = 5,
	EC_RES_INVALID_VERSION = 6,
	EC_RES_INVALID_CHECKSUM = 7,
	EC_RES_IN_PROGRESS = 8,
	EC_RES_UNAVAILABLE = 9,
	EC_RES_TIMEOUT = 10,
	EC_RES_OVERFLOW = 11,
	EC_RES_INVALID_HEADER = 12,
	EC_RES_REQUEST_TRUNCATED = 13,
	EC_RES_RESPONSE_TOO_BIG = 14,
	EC_RES_BUS_ERROR = 15,
	EC_RES_BUSY = 16,
	EC_RES_INVALID_HEADER_VERSION = 17,
	EC_RES_INVALID_HEADER_CRC = 18,
	EC_RES_INVALID_DATA_CRC = 19,
	EC_RES_DUP_UNAVAILABLE = 20,
};

enum ec_temp_thresholds {
	EC_TEMP_THRESH_WARN = 0,
	EC_TEMP_THRESH_HIGH = 1,
	EC_TEMP_THRESH_HALT = 2,
	EC_TEMP_THRESH_COUNT = 3,
};

enum ec_vbnvcontext_op {
	EC_VBNV_CONTEXT_OP_READ = 0,
	EC_VBNV_CONTEXT_OP_WRITE = 1,
};

enum edac_dev_feat {
	RAS_FEAT_SCRUB = 0,
	RAS_FEAT_ECS = 1,
	RAS_FEAT_MEM_REPAIR = 2,
	RAS_FEAT_MAX = 3,
};

enum edac_mc_layer_type {
	EDAC_MC_LAYER_BRANCH = 0,
	EDAC_MC_LAYER_CHANNEL = 1,
	EDAC_MC_LAYER_SLOT = 2,
	EDAC_MC_LAYER_CHIP_SELECT = 3,
	EDAC_MC_LAYER_ALL_MEM = 4,
};

enum edac_type {
	EDAC_UNKNOWN = 0,
	EDAC_NONE = 1,
	EDAC_RESERVED = 2,
	EDAC_PARITY = 3,
	EDAC_EC = 4,
	EDAC_SECDED = 5,
	EDAC_S2ECD2ED = 6,
	EDAC_S4ECD4ED = 7,
	EDAC_S8ECD8ED = 8,
	EDAC_S16ECD16ED = 9,
};

enum efi_cmdline_option {
	EFI_CMDLINE_NONE = 0,
	EFI_CMDLINE_MODE_NUM = 1,
	EFI_CMDLINE_RES = 2,
	EFI_CMDLINE_AUTO = 3,
	EFI_CMDLINE_LIST = 4,
};

enum efi_rts_ids {
	EFI_NONE = 0,
	EFI_GET_TIME = 1,
	EFI_SET_TIME = 2,
	EFI_GET_WAKEUP_TIME = 3,
	EFI_SET_WAKEUP_TIME = 4,
	EFI_GET_VARIABLE = 5,
	EFI_GET_NEXT_VARIABLE = 6,
	EFI_SET_VARIABLE = 7,
	EFI_QUERY_VARIABLE_INFO = 8,
	EFI_GET_NEXT_HIGH_MONO_COUNT = 9,
	EFI_RESET_SYSTEM = 10,
	EFI_UPDATE_CAPSULE = 11,
	EFI_QUERY_CAPSULE_CAPS = 12,
	EFI_ACPI_PRM_HANDLER = 13,
};

enum efi_secureboot_mode {
	efi_secureboot_mode_unset = 0,
	efi_secureboot_mode_unknown = 1,
	efi_secureboot_mode_disabled = 2,
	efi_secureboot_mode_enabled = 3,
};

enum efistub_event_type {
	EFISTUB_EVT_INITRD = 0,
	EFISTUB_EVT_LOAD_OPTIONS = 1,
	EFISTUB_EVT_COUNT = 2,
};

enum ehci_hrtimer_event {
	EHCI_HRTIMER_POLL_ASS = 0,
	EHCI_HRTIMER_POLL_PSS = 1,
	EHCI_HRTIMER_POLL_DEAD = 2,
	EHCI_HRTIMER_UNLINK_INTR = 3,
	EHCI_HRTIMER_FREE_ITDS = 4,
	EHCI_HRTIMER_ACTIVE_UNLINK = 5,
	EHCI_HRTIMER_START_UNLINK_INTR = 6,
	EHCI_HRTIMER_ASYNC_UNLINKS = 7,
	EHCI_HRTIMER_IAA_WATCHDOG = 8,
	EHCI_HRTIMER_DISABLE_PERIODIC = 9,
	EHCI_HRTIMER_DISABLE_ASYNC = 10,
	EHCI_HRTIMER_IO_WATCHDOG = 11,
	EHCI_HRTIMER_NUM_EVENTS = 12,
};

enum ehci_rh_state {
	EHCI_RH_HALTED = 0,
	EHCI_RH_SUSPENDED = 1,
	EHCI_RH_RUNNING = 2,
	EHCI_RH_STOPPING = 3,
};

enum eint_type {
	EINT_TYPE_NONE = 0,
	EINT_TYPE_GPIO = 1,
	EINT_TYPE_WKUP = 2,
	EINT_TYPE_WKUP_MUX = 3,
};

enum eld_versions {
	ELD_VER_CEA_861D = 2,
	ELD_VER_PARTIAL = 31,
};

enum elv_merge {
	ELEVATOR_NO_MERGE = 0,
	ELEVATOR_FRONT_MERGE = 1,
	ELEVATOR_BACK_MERGE = 2,
	ELEVATOR_DISCARD_MERGE = 3,
};

enum enable_type {
	undefined = -1,
	user_disabled = 0,
	auto_disabled = 1,
	user_enabled = 2,
	auto_enabled = 3,
};

enum enetc_active_offloads {
	ENETC_F_TX_TSTAMP = 1,
	ENETC_F_TX_ONESTEP_SYNC_TSTAMP = 2,
	ENETC_F_RX_TSTAMP = 256,
	ENETC_F_QBV = 512,
	ENETC_F_QCI = 1024,
	ENETC_F_QBU = 2048,
	ENETC_F_TXCSUM = 4096,
	ENETC_F_LSO = 8192,
};

enum enetc_bdr_type {
	TX = 0,
	RX = 1,
};

enum enetc_errata {
	ENETC_ERR_VLAN_ISOL = 1,
	ENETC_ERR_UCMCSWP = 2,
};

enum enetc_flags_bit {
	ENETC_TX_ONESTEP_TSTAMP_IN_PROGRESS = 0,
	ENETC_TX_DOWN = 1,
};

enum enetc_ic_mode {
	ENETC_IC_NONE = 0,
	ENETC_IC_RX_MANUAL = 1,
	ENETC_IC_TX_MANUAL = 2,
	ENETC_IC_RX_ADAPTIVE = 4,
};

enum enetc_mac_addr_type {
	UC = 0,
	MC = 1,
	MADDR_TYPE = 2,
};

enum enetc_msg_cmd_action_type {
	ENETC_MSG_CMD_MNG_ADD = 1,
	ENETC_MSG_CMD_MNG_REMOVE = 2,
};

enum enetc_msg_cmd_status {
	ENETC_MSG_CMD_STATUS_OK = 0,
	ENETC_MSG_CMD_STATUS_FAIL = 1,
};

enum enetc_msg_cmd_type {
	ENETC_MSG_CMD_MNG_MAC = 1,
	ENETC_MSG_CMD_MNG_RX_MAC_FILTER = 2,
	ENETC_MSG_CMD_MNG_RX_VLAN_FILTER = 3,
};

enum enetc_txbd_flags {
	ENETC_TXBD_FLAGS_L4CS = 1,
	ENETC_TXBD_FLAGS_TSE = 2,
	ENETC_TXBD_FLAGS_LSO = 2,
	ENETC_TXBD_FLAGS_W = 4,
	ENETC_TXBD_FLAGS_CSUM_LSO = 8,
	ENETC_TXBD_FLAGS_TXSTART = 16,
	ENETC_TXBD_FLAGS_EX = 64,
	ENETC_TXBD_FLAGS_F = 128,
};

enum enetc_vf_flags {
	ENETC_VF_FLAG_PF_SET_MAC = 1,
};

enum enum_gate_cfg {
	GATE_ADC12 = 0,
	GATE_ADC3 = 1,
	GATE_ADF1 = 2,
	GATE_CCI = 3,
	GATE_CRC = 4,
	GATE_CRYP1 = 5,
	GATE_CRYP2 = 6,
	GATE_CSI = 7,
	GATE_DCMIPP = 8,
	GATE_DSI = 9,
	GATE_DTS = 10,
	GATE_ETH1 = 11,
	GATE_ETH1MAC = 12,
	GATE_ETH1RX = 13,
	GATE_ETH1STP = 14,
	GATE_ETH1TX = 15,
	GATE_ETH2 = 16,
	GATE_ETH2MAC = 17,
	GATE_ETH2RX = 18,
	GATE_ETH2STP = 19,
	GATE_ETH2TX = 20,
	GATE_ETHSW = 21,
	GATE_ETHSWACMCFG = 22,
	GATE_ETHSWACMMSG = 23,
	GATE_ETHSWMAC = 24,
	GATE_ETHSWREF = 25,
	GATE_FDCAN = 26,
	GATE_GPU = 27,
	GATE_HASH = 28,
	GATE_HDP = 29,
	GATE_I2C1 = 30,
	GATE_I2C2 = 31,
	GATE_I2C3 = 32,
	GATE_I2C4 = 33,
	GATE_I2C5 = 34,
	GATE_I2C6 = 35,
	GATE_I2C7 = 36,
	GATE_I2C8 = 37,
	GATE_I3C1 = 38,
	GATE_I3C2 = 39,
	GATE_I3C3 = 40,
	GATE_I3C4 = 41,
	GATE_IS2M = 42,
	GATE_IWDG1 = 43,
	GATE_IWDG2 = 44,
	GATE_IWDG3 = 45,
	GATE_IWDG4 = 46,
	GATE_IWDG5 = 47,
	GATE_LPTIM1 = 48,
	GATE_LPTIM2 = 49,
	GATE_LPTIM3 = 50,
	GATE_LPTIM4 = 51,
	GATE_LPTIM5 = 52,
	GATE_LPUART1 = 53,
	GATE_LTDC = 54,
	GATE_LVDS = 55,
	GATE_MCO1 = 56,
	GATE_MCO2 = 57,
	GATE_MDF1 = 58,
	GATE_OSPIIOM = 59,
	GATE_PCIE = 60,
	GATE_PKA = 61,
	GATE_RNG = 62,
	GATE_SAES = 63,
	GATE_SAI1 = 64,
	GATE_SAI2 = 65,
	GATE_SAI3 = 66,
	GATE_SAI4 = 67,
	GATE_SDMMC1 = 68,
	GATE_SDMMC2 = 69,
	GATE_SDMMC3 = 70,
	GATE_SERC = 71,
	GATE_SPDIFRX = 72,
	GATE_SPI1 = 73,
	GATE_SPI2 = 74,
	GATE_SPI3 = 75,
	GATE_SPI4 = 76,
	GATE_SPI5 = 77,
	GATE_SPI6 = 78,
	GATE_SPI7 = 79,
	GATE_SPI8 = 80,
	GATE_TIM1 = 81,
	GATE_TIM10 = 82,
	GATE_TIM11 = 83,
	GATE_TIM12 = 84,
	GATE_TIM13 = 85,
	GATE_TIM14 = 86,
	GATE_TIM15 = 87,
	GATE_TIM16 = 88,
	GATE_TIM17 = 89,
	GATE_TIM2 = 90,
	GATE_TIM20 = 91,
	GATE_TIM3 = 92,
	GATE_TIM4 = 93,
	GATE_TIM5 = 94,
	GATE_TIM6 = 95,
	GATE_TIM7 = 96,
	GATE_TIM8 = 97,
	GATE_UART4 = 98,
	GATE_UART5 = 99,
	GATE_UART7 = 100,
	GATE_UART8 = 101,
	GATE_UART9 = 102,
	GATE_USART1 = 103,
	GATE_USART2 = 104,
	GATE_USART3 = 105,
	GATE_USART6 = 106,
	GATE_USBH = 107,
	GATE_USB2PHY1 = 108,
	GATE_USB2PHY2 = 109,
	GATE_USB3DR = 110,
	GATE_USB3PCIEPHY = 111,
	GATE_USBTC = 112,
	GATE_VDEC = 113,
	GATE_VENC = 114,
	GATE_VREF = 115,
	GATE_WWDG1 = 116,
	GATE_WWDG2 = 117,
	GATE_NB = 118,
};

enum enum_mux_cfg {
	MUX_ADC12 = 0,
	MUX_ADC3 = 1,
	MUX_DSIBLANE = 2,
	MUX_DSIPHY = 3,
	MUX_DTS = 4,
	MUX_LVDSPHY = 5,
	MUX_MCO1 = 6,
	MUX_MCO2 = 7,
	MUX_USB2PHY1 = 8,
	MUX_USB2PHY2 = 9,
	MUX_USB3PCIEPHY = 10,
	MUX_NB = 11,
};

enum equalization_preset_type {
	EQ_PRESET_TYPE_8GTS = 0,
	EQ_PRESET_TYPE_16GTS = 1,
	EQ_PRESET_TYPE_32GTS = 2,
	EQ_PRESET_TYPE_64GTS = 3,
	EQ_PRESET_TYPE_MAX = 4,
};

enum err_code {
	HIDMA_EVRE_STATUS_COMPLETE = 1,
	HIDMA_EVRE_STATUS_ERROR = 4,
};

enum error_detector {
	ERROR_DETECTOR_KFENCE = 0,
	ERROR_DETECTOR_KASAN = 1,
	ERROR_DETECTOR_WARN = 2,
};

enum ether_type_algorithm {
	ETYPE_ALG_NONE = 0,
	ETYPE_ALG_SKIP = 1,
	ETYPE_ALG_ENDPARSE = 2,
	ETYPE_ALG_VLAN = 3,
	ETYPE_ALG_VLAN_STRIP = 4,
};

enum ethnl_sock_type {
	ETHTOOL_SOCK_TYPE_MODULE_FW_FLASH = 0,
};

enum ethtool_c33_pse_admin_state {
	ETHTOOL_C33_PSE_ADMIN_STATE_UNKNOWN = 1,
	ETHTOOL_C33_PSE_ADMIN_STATE_DISABLED = 2,
	ETHTOOL_C33_PSE_ADMIN_STATE_ENABLED = 3,
};

enum ethtool_c33_pse_ext_state {
	ETHTOOL_C33_PSE_EXT_STATE_ERROR_CONDITION = 1,
	ETHTOOL_C33_PSE_EXT_STATE_MR_MPS_VALID = 2,
	ETHTOOL_C33_PSE_EXT_STATE_MR_PSE_ENABLE = 3,
	ETHTOOL_C33_PSE_EXT_STATE_OPTION_DETECT_TED = 4,
	ETHTOOL_C33_PSE_EXT_STATE_OPTION_VPORT_LIM = 5,
	ETHTOOL_C33_PSE_EXT_STATE_OVLD_DETECTED = 6,
	ETHTOOL_C33_PSE_EXT_STATE_PD_DLL_POWER_TYPE = 7,
	ETHTOOL_C33_PSE_EXT_STATE_POWER_NOT_AVAILABLE = 8,
	ETHTOOL_C33_PSE_EXT_STATE_SHORT_DETECTED = 9,
};

enum ethtool_c33_pse_ext_substate_error_condition {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_NON_EXISTING_PORT = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_UNDEFINED_PORT = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_INTERNAL_HW_FAULT = 3,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_COMM_ERROR_AFTER_FORCE_ON = 4,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_UNKNOWN_PORT_STATUS = 5,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_HOST_CRASH_TURN_OFF = 6,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_HOST_CRASH_FORCE_SHUTDOWN = 7,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_CONFIG_CHANGE = 8,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_DETECTED_OVER_TEMP = 9,
};

enum ethtool_c33_pse_ext_substate_mr_pse_enable {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_MR_PSE_ENABLE_DISABLE_PIN_ACTIVE = 1,
};

enum ethtool_c33_pse_ext_substate_option_detect_ted {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_DETECT_TED_DET_IN_PROCESS = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_DETECT_TED_CONNECTION_CHECK_ERROR = 2,
};

enum ethtool_c33_pse_ext_substate_option_vport_lim {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_HIGH_VOLTAGE = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_LOW_VOLTAGE = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_VOLTAGE_INJECTION = 3,
};

enum ethtool_c33_pse_ext_substate_ovld_detected {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OVLD_DETECTED_OVERLOAD = 1,
};

enum ethtool_c33_pse_ext_substate_power_not_available {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_BUDGET_EXCEEDED = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_PORT_PW_LIMIT_EXCEEDS_CONTROLLER_BUDGET = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_PD_REQUEST_EXCEEDS_PORT_LIMIT = 3,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_HW_PW_LIMIT = 4,
};

enum ethtool_c33_pse_ext_substate_short_detected {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_SHORT_DETECTED_SHORT_CONDITION = 1,
};

enum ethtool_c33_pse_pw_d_status {
	ETHTOOL_C33_PSE_PW_D_STATUS_UNKNOWN = 1,
	ETHTOOL_C33_PSE_PW_D_STATUS_DISABLED = 2,
	ETHTOOL_C33_PSE_PW_D_STATUS_SEARCHING = 3,
	ETHTOOL_C33_PSE_PW_D_STATUS_DELIVERING = 4,
	ETHTOOL_C33_PSE_PW_D_STATUS_TEST = 5,
	ETHTOOL_C33_PSE_PW_D_STATUS_FAULT = 6,
	ETHTOOL_C33_PSE_PW_D_STATUS_OTHERFAULT = 7,
};

enum ethtool_cmis_cdb_cmd_id {
	ETHTOOL_CMIS_CDB_CMD_QUERY_STATUS = 0,
	ETHTOOL_CMIS_CDB_CMD_MODULE_FEATURES = 64,
	ETHTOOL_CMIS_CDB_CMD_FW_MANAGMENT_FEATURES = 65,
	ETHTOOL_CMIS_CDB_CMD_START_FW_DOWNLOAD = 257,
	ETHTOOL_CMIS_CDB_CMD_WRITE_FW_BLOCK_LPL = 259,
	ETHTOOL_CMIS_CDB_CMD_WRITE_FW_BLOCK_EPL = 260,
	ETHTOOL_CMIS_CDB_CMD_COMPLETE_FW_DOWNLOAD = 263,
	ETHTOOL_CMIS_CDB_CMD_RUN_FW_IMAGE = 265,
	ETHTOOL_CMIS_CDB_CMD_COMMIT_FW_IMAGE = 266,
};

enum ethtool_fec_config_bits {
	ETHTOOL_FEC_NONE_BIT = 0,
	ETHTOOL_FEC_AUTO_BIT = 1,
	ETHTOOL_FEC_OFF_BIT = 2,
	ETHTOOL_FEC_RS_BIT = 3,
	ETHTOOL_FEC_BASER_BIT = 4,
	ETHTOOL_FEC_LLRS_BIT = 5,
};

enum ethtool_flags {
	ETH_FLAG_TXVLAN = 128,
	ETH_FLAG_RXVLAN = 256,
	ETH_FLAG_LRO = 32768,
	ETH_FLAG_NTUPLE = 134217728,
	ETH_FLAG_RXHASH = 268435456,
};

enum ethtool_header_flags {
	ETHTOOL_FLAG_COMPACT_BITSETS = 1,
	ETHTOOL_FLAG_OMIT_REPLY = 2,
	ETHTOOL_FLAG_STATS = 4,
};

enum ethtool_link_ext_state {
	ETHTOOL_LINK_EXT_STATE_AUTONEG = 0,
	ETHTOOL_LINK_EXT_STATE_LINK_TRAINING_FAILURE = 1,
	ETHTOOL_LINK_EXT_STATE_LINK_LOGICAL_MISMATCH = 2,
	ETHTOOL_LINK_EXT_STATE_BAD_SIGNAL_INTEGRITY = 3,
	ETHTOOL_LINK_EXT_STATE_NO_CABLE = 4,
	ETHTOOL_LINK_EXT_STATE_CABLE_ISSUE = 5,
	ETHTOOL_LINK_EXT_STATE_EEPROM_ISSUE = 6,
	ETHTOOL_LINK_EXT_STATE_CALIBRATION_FAILURE = 7,
	ETHTOOL_LINK_EXT_STATE_POWER_BUDGET_EXCEEDED = 8,
	ETHTOOL_LINK_EXT_STATE_OVERHEAT = 9,
	ETHTOOL_LINK_EXT_STATE_MODULE = 10,
};

enum ethtool_link_ext_substate_autoneg {
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_ACK_NOT_RECEIVED = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NEXT_PAGE_EXCHANGE_FAILED = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED_FORCE_MODE = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_FEC_MISMATCH_DURING_OVERRIDE = 5,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_HCD = 6,
};

enum ethtool_link_ext_substate_bad_signal_integrity {
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_LARGE_NUMBER_OF_PHYSICAL_ERRORS = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_UNSUPPORTED_RATE = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_REFERENCE_CLOCK_LOST = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_ALOS = 4,
};

enum ethtool_link_ext_substate_cable_issue {
	ETHTOOL_LINK_EXT_SUBSTATE_CI_UNSUPPORTED_CABLE = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_CI_CABLE_TEST_FAILURE = 2,
};

enum ethtool_link_ext_substate_link_logical_mismatch {
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_BLOCK_LOCK = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_AM_LOCK = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_GET_ALIGN_STATUS = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_FC_FEC_IS_NOT_LOCKED = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_RS_FEC_IS_NOT_LOCKED = 5,
};

enum ethtool_link_ext_substate_link_training {
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_FRAME_LOCK_NOT_ACQUIRED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_INHIBIT_TIMEOUT = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_PARTNER_DID_NOT_SET_RECEIVER_READY = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_REMOTE_FAULT = 4,
};

enum ethtool_link_ext_substate_module {
	ETHTOOL_LINK_EXT_SUBSTATE_MODULE_CMIS_NOT_READY = 1,
};

enum ethtool_link_mode_bit_indices {
	ETHTOOL_LINK_MODE_10baseT_Half_BIT = 0,
	ETHTOOL_LINK_MODE_10baseT_Full_BIT = 1,
	ETHTOOL_LINK_MODE_100baseT_Half_BIT = 2,
	ETHTOOL_LINK_MODE_100baseT_Full_BIT = 3,
	ETHTOOL_LINK_MODE_1000baseT_Half_BIT = 4,
	ETHTOOL_LINK_MODE_1000baseT_Full_BIT = 5,
	ETHTOOL_LINK_MODE_Autoneg_BIT = 6,
	ETHTOOL_LINK_MODE_TP_BIT = 7,
	ETHTOOL_LINK_MODE_AUI_BIT = 8,
	ETHTOOL_LINK_MODE_MII_BIT = 9,
	ETHTOOL_LINK_MODE_FIBRE_BIT = 10,
	ETHTOOL_LINK_MODE_BNC_BIT = 11,
	ETHTOOL_LINK_MODE_10000baseT_Full_BIT = 12,
	ETHTOOL_LINK_MODE_Pause_BIT = 13,
	ETHTOOL_LINK_MODE_Asym_Pause_BIT = 14,
	ETHTOOL_LINK_MODE_2500baseX_Full_BIT = 15,
	ETHTOOL_LINK_MODE_Backplane_BIT = 16,
	ETHTOOL_LINK_MODE_1000baseKX_Full_BIT = 17,
	ETHTOOL_LINK_MODE_10000baseKX4_Full_BIT = 18,
	ETHTOOL_LINK_MODE_10000baseKR_Full_BIT = 19,
	ETHTOOL_LINK_MODE_10000baseR_FEC_BIT = 20,
	ETHTOOL_LINK_MODE_20000baseMLD2_Full_BIT = 21,
	ETHTOOL_LINK_MODE_20000baseKR2_Full_BIT = 22,
	ETHTOOL_LINK_MODE_40000baseKR4_Full_BIT = 23,
	ETHTOOL_LINK_MODE_40000baseCR4_Full_BIT = 24,
	ETHTOOL_LINK_MODE_40000baseSR4_Full_BIT = 25,
	ETHTOOL_LINK_MODE_40000baseLR4_Full_BIT = 26,
	ETHTOOL_LINK_MODE_56000baseKR4_Full_BIT = 27,
	ETHTOOL_LINK_MODE_56000baseCR4_Full_BIT = 28,
	ETHTOOL_LINK_MODE_56000baseSR4_Full_BIT = 29,
	ETHTOOL_LINK_MODE_56000baseLR4_Full_BIT = 30,
	ETHTOOL_LINK_MODE_25000baseCR_Full_BIT = 31,
	ETHTOOL_LINK_MODE_25000baseKR_Full_BIT = 32,
	ETHTOOL_LINK_MODE_25000baseSR_Full_BIT = 33,
	ETHTOOL_LINK_MODE_50000baseCR2_Full_BIT = 34,
	ETHTOOL_LINK_MODE_50000baseKR2_Full_BIT = 35,
	ETHTOOL_LINK_MODE_100000baseKR4_Full_BIT = 36,
	ETHTOOL_LINK_MODE_100000baseSR4_Full_BIT = 37,
	ETHTOOL_LINK_MODE_100000baseCR4_Full_BIT = 38,
	ETHTOOL_LINK_MODE_100000baseLR4_ER4_Full_BIT = 39,
	ETHTOOL_LINK_MODE_50000baseSR2_Full_BIT = 40,
	ETHTOOL_LINK_MODE_1000baseX_Full_BIT = 41,
	ETHTOOL_LINK_MODE_10000baseCR_Full_BIT = 42,
	ETHTOOL_LINK_MODE_10000baseSR_Full_BIT = 43,
	ETHTOOL_LINK_MODE_10000baseLR_Full_BIT = 44,
	ETHTOOL_LINK_MODE_10000baseLRM_Full_BIT = 45,
	ETHTOOL_LINK_MODE_10000baseER_Full_BIT = 46,
	ETHTOOL_LINK_MODE_2500baseT_Full_BIT = 47,
	ETHTOOL_LINK_MODE_5000baseT_Full_BIT = 48,
	ETHTOOL_LINK_MODE_FEC_NONE_BIT = 49,
	ETHTOOL_LINK_MODE_FEC_RS_BIT = 50,
	ETHTOOL_LINK_MODE_FEC_BASER_BIT = 51,
	ETHTOOL_LINK_MODE_50000baseKR_Full_BIT = 52,
	ETHTOOL_LINK_MODE_50000baseSR_Full_BIT = 53,
	ETHTOOL_LINK_MODE_50000baseCR_Full_BIT = 54,
	ETHTOOL_LINK_MODE_50000baseLR_ER_FR_Full_BIT = 55,
	ETHTOOL_LINK_MODE_50000baseDR_Full_BIT = 56,
	ETHTOOL_LINK_MODE_100000baseKR2_Full_BIT = 57,
	ETHTOOL_LINK_MODE_100000baseSR2_Full_BIT = 58,
	ETHTOOL_LINK_MODE_100000baseCR2_Full_BIT = 59,
	ETHTOOL_LINK_MODE_100000baseLR2_ER2_FR2_Full_BIT = 60,
	ETHTOOL_LINK_MODE_100000baseDR2_Full_BIT = 61,
	ETHTOOL_LINK_MODE_200000baseKR4_Full_BIT = 62,
	ETHTOOL_LINK_MODE_200000baseSR4_Full_BIT = 63,
	ETHTOOL_LINK_MODE_200000baseLR4_ER4_FR4_Full_BIT = 64,
	ETHTOOL_LINK_MODE_200000baseDR4_Full_BIT = 65,
	ETHTOOL_LINK_MODE_200000baseCR4_Full_BIT = 66,
	ETHTOOL_LINK_MODE_100baseT1_Full_BIT = 67,
	ETHTOOL_LINK_MODE_1000baseT1_Full_BIT = 68,
	ETHTOOL_LINK_MODE_400000baseKR8_Full_BIT = 69,
	ETHTOOL_LINK_MODE_400000baseSR8_Full_BIT = 70,
	ETHTOOL_LINK_MODE_400000baseLR8_ER8_FR8_Full_BIT = 71,
	ETHTOOL_LINK_MODE_400000baseDR8_Full_BIT = 72,
	ETHTOOL_LINK_MODE_400000baseCR8_Full_BIT = 73,
	ETHTOOL_LINK_MODE_FEC_LLRS_BIT = 74,
	ETHTOOL_LINK_MODE_100000baseKR_Full_BIT = 75,
	ETHTOOL_LINK_MODE_100000baseSR_Full_BIT = 76,
	ETHTOOL_LINK_MODE_100000baseLR_ER_FR_Full_BIT = 77,
	ETHTOOL_LINK_MODE_100000baseCR_Full_BIT = 78,
	ETHTOOL_LINK_MODE_100000baseDR_Full_BIT = 79,
	ETHTOOL_LINK_MODE_200000baseKR2_Full_BIT = 80,
	ETHTOOL_LINK_MODE_200000baseSR2_Full_BIT = 81,
	ETHTOOL_LINK_MODE_200000baseLR2_ER2_FR2_Full_BIT = 82,
	ETHTOOL_LINK_MODE_200000baseDR2_Full_BIT = 83,
	ETHTOOL_LINK_MODE_200000baseCR2_Full_BIT = 84,
	ETHTOOL_LINK_MODE_400000baseKR4_Full_BIT = 85,
	ETHTOOL_LINK_MODE_400000baseSR4_Full_BIT = 86,
	ETHTOOL_LINK_MODE_400000baseLR4_ER4_FR4_Full_BIT = 87,
	ETHTOOL_LINK_MODE_400000baseDR4_Full_BIT = 88,
	ETHTOOL_LINK_MODE_400000baseCR4_Full_BIT = 89,
	ETHTOOL_LINK_MODE_100baseFX_Half_BIT = 90,
	ETHTOOL_LINK_MODE_100baseFX_Full_BIT = 91,
	ETHTOOL_LINK_MODE_10baseT1L_Full_BIT = 92,
	ETHTOOL_LINK_MODE_800000baseCR8_Full_BIT = 93,
	ETHTOOL_LINK_MODE_800000baseKR8_Full_BIT = 94,
	ETHTOOL_LINK_MODE_800000baseDR8_Full_BIT = 95,
	ETHTOOL_LINK_MODE_800000baseDR8_2_Full_BIT = 96,
	ETHTOOL_LINK_MODE_800000baseSR8_Full_BIT = 97,
	ETHTOOL_LINK_MODE_800000baseVR8_Full_BIT = 98,
	ETHTOOL_LINK_MODE_10baseT1S_Full_BIT = 99,
	ETHTOOL_LINK_MODE_10baseT1S_Half_BIT = 100,
	ETHTOOL_LINK_MODE_10baseT1S_P2MP_Half_BIT = 101,
	ETHTOOL_LINK_MODE_10baseT1BRR_Full_BIT = 102,
	ETHTOOL_LINK_MODE_200000baseCR_Full_BIT = 103,
	ETHTOOL_LINK_MODE_200000baseKR_Full_BIT = 104,
	ETHTOOL_LINK_MODE_200000baseDR_Full_BIT = 105,
	ETHTOOL_LINK_MODE_200000baseDR_2_Full_BIT = 106,
	ETHTOOL_LINK_MODE_200000baseSR_Full_BIT = 107,
	ETHTOOL_LINK_MODE_200000baseVR_Full_BIT = 108,
	ETHTOOL_LINK_MODE_400000baseCR2_Full_BIT = 109,
	ETHTOOL_LINK_MODE_400000baseKR2_Full_BIT = 110,
	ETHTOOL_LINK_MODE_400000baseDR2_Full_BIT = 111,
	ETHTOOL_LINK_MODE_400000baseDR2_2_Full_BIT = 112,
	ETHTOOL_LINK_MODE_400000baseSR2_Full_BIT = 113,
	ETHTOOL_LINK_MODE_400000baseVR2_Full_BIT = 114,
	ETHTOOL_LINK_MODE_800000baseCR4_Full_BIT = 115,
	ETHTOOL_LINK_MODE_800000baseKR4_Full_BIT = 116,
	ETHTOOL_LINK_MODE_800000baseDR4_Full_BIT = 117,
	ETHTOOL_LINK_MODE_800000baseDR4_2_Full_BIT = 118,
	ETHTOOL_LINK_MODE_800000baseSR4_Full_BIT = 119,
	ETHTOOL_LINK_MODE_800000baseVR4_Full_BIT = 120,
	__ETHTOOL_LINK_MODE_MASK_NBITS = 121,
};

enum ethtool_mac_stats_src {
	ETHTOOL_MAC_STATS_SRC_AGGREGATE = 0,
	ETHTOOL_MAC_STATS_SRC_EMAC = 1,
	ETHTOOL_MAC_STATS_SRC_PMAC = 2,
};

enum ethtool_mm_verify_status {
	ETHTOOL_MM_VERIFY_STATUS_UNKNOWN = 0,
	ETHTOOL_MM_VERIFY_STATUS_INITIAL = 1,
	ETHTOOL_MM_VERIFY_STATUS_VERIFYING = 2,
	ETHTOOL_MM_VERIFY_STATUS_SUCCEEDED = 3,
	ETHTOOL_MM_VERIFY_STATUS_FAILED = 4,
	ETHTOOL_MM_VERIFY_STATUS_DISABLED = 5,
};

enum ethtool_mmsv_event {
	ETHTOOL_MMSV_LP_SENT_VERIFY_MPACKET = 0,
	ETHTOOL_MMSV_LD_SENT_VERIFY_MPACKET = 1,
	ETHTOOL_MMSV_LP_SENT_RESPONSE_MPACKET = 2,
};

enum ethtool_module_fw_flash_status {
	ETHTOOL_MODULE_FW_FLASH_STATUS_STARTED = 1,
	ETHTOOL_MODULE_FW_FLASH_STATUS_IN_PROGRESS = 2,
	ETHTOOL_MODULE_FW_FLASH_STATUS_COMPLETED = 3,
	ETHTOOL_MODULE_FW_FLASH_STATUS_ERROR = 4,
};

enum ethtool_module_power_mode {
	ETHTOOL_MODULE_POWER_MODE_LOW = 1,
	ETHTOOL_MODULE_POWER_MODE_HIGH = 2,
};

enum ethtool_module_power_mode_policy {
	ETHTOOL_MODULE_POWER_MODE_POLICY_HIGH = 1,
	ETHTOOL_MODULE_POWER_MODE_POLICY_AUTO = 2,
};

enum ethtool_mpacket {
	ETHTOOL_MPACKET_VERIFY = 0,
	ETHTOOL_MPACKET_RESPONSE = 1,
};

enum ethtool_multicast_groups {
	ETHNL_MCGRP_MONITOR = 0,
};

enum ethtool_phys_id_state {
	ETHTOOL_ID_INACTIVE = 0,
	ETHTOOL_ID_ACTIVE = 1,
	ETHTOOL_ID_ON = 2,
	ETHTOOL_ID_OFF = 3,
};

enum ethtool_podl_pse_admin_state {
	ETHTOOL_PODL_PSE_ADMIN_STATE_UNKNOWN = 1,
	ETHTOOL_PODL_PSE_ADMIN_STATE_DISABLED = 2,
	ETHTOOL_PODL_PSE_ADMIN_STATE_ENABLED = 3,
};

enum ethtool_podl_pse_pw_d_status {
	ETHTOOL_PODL_PSE_PW_D_STATUS_UNKNOWN = 1,
	ETHTOOL_PODL_PSE_PW_D_STATUS_DISABLED = 2,
	ETHTOOL_PODL_PSE_PW_D_STATUS_SEARCHING = 3,
	ETHTOOL_PODL_PSE_PW_D_STATUS_DELIVERING = 4,
	ETHTOOL_PODL_PSE_PW_D_STATUS_SLEEP = 5,
	ETHTOOL_PODL_PSE_PW_D_STATUS_IDLE = 6,
	ETHTOOL_PODL_PSE_PW_D_STATUS_ERROR = 7,
};

enum ethtool_reset_flags {
	ETH_RESET_MGMT = 1,
	ETH_RESET_IRQ = 2,
	ETH_RESET_DMA = 4,
	ETH_RESET_FILTER = 8,
	ETH_RESET_OFFLOAD = 16,
	ETH_RESET_MAC = 32,
	ETH_RESET_PHY = 64,
	ETH_RESET_RAM = 128,
	ETH_RESET_AP = 256,
	ETH_RESET_DEDICATED = 65535,
	ETH_RESET_ALL = 4294967295,
};

enum ethtool_sfeatures_retval_bits {
	ETHTOOL_F_UNSUPPORTED__BIT = 0,
	ETHTOOL_F_WISH__BIT = 1,
	ETHTOOL_F_COMPAT__BIT = 2,
};

enum ethtool_stringset {
	ETH_SS_TEST = 0,
	ETH_SS_STATS = 1,
	ETH_SS_PRIV_FLAGS = 2,
	ETH_SS_NTUPLE_FILTERS = 3,
	ETH_SS_FEATURES = 4,
	ETH_SS_RSS_HASH_FUNCS = 5,
	ETH_SS_TUNABLES = 6,
	ETH_SS_PHY_STATS = 7,
	ETH_SS_PHY_TUNABLES = 8,
	ETH_SS_LINK_MODES = 9,
	ETH_SS_MSG_CLASSES = 10,
	ETH_SS_WOL_MODES = 11,
	ETH_SS_SOF_TIMESTAMPING = 12,
	ETH_SS_TS_TX_TYPES = 13,
	ETH_SS_TS_RX_FILTERS = 14,
	ETH_SS_UDP_TUNNEL_TYPES = 15,
	ETH_SS_STATS_STD = 16,
	ETH_SS_STATS_ETH_PHY = 17,
	ETH_SS_STATS_ETH_MAC = 18,
	ETH_SS_STATS_ETH_CTRL = 19,
	ETH_SS_STATS_RMON = 20,
	ETH_SS_STATS_PHY = 21,
	ETH_SS_TS_FLAGS = 22,
	ETH_SS_COUNT = 23,
};

enum ethtool_supported_ring_param {
	ETHTOOL_RING_USE_RX_BUF_LEN = 1,
	ETHTOOL_RING_USE_CQE_SIZE = 2,
	ETHTOOL_RING_USE_TX_PUSH = 4,
	ETHTOOL_RING_USE_RX_PUSH = 8,
	ETHTOOL_RING_USE_TX_PUSH_BUF_LEN = 16,
	ETHTOOL_RING_USE_TCP_DATA_SPLIT = 32,
	ETHTOOL_RING_USE_HDS_THRS = 64,
};

enum ethtool_tcp_data_split {
	ETHTOOL_TCP_DATA_SPLIT_UNKNOWN = 0,
	ETHTOOL_TCP_DATA_SPLIT_DISABLED = 1,
	ETHTOOL_TCP_DATA_SPLIT_ENABLED = 2,
};

enum ethtool_test_flags {
	ETH_TEST_FL_OFFLINE = 1,
	ETH_TEST_FL_FAILED = 2,
	ETH_TEST_FL_EXTERNAL_LB = 4,
	ETH_TEST_FL_EXTERNAL_LB_DONE = 8,
};

enum event_command_flags {
	EVENT_CMD_FL_POST_TRIGGER = 1,
	EVENT_CMD_FL_NEEDS_REC = 2,
};

enum event_trigger_type {
	ETT_NONE = 0,
	ETT_TRACE_ONOFF = 1,
	ETT_SNAPSHOT = 2,
	ETT_STACKTRACE = 4,
	ETT_EVENT_ENABLE = 8,
	ETT_EVENT_HIST = 16,
	ETT_HIST_ENABLE = 32,
	ETT_EVENT_EPROBE = 64,
};

enum event_type_t {
	EVENT_FLEXIBLE = 1,
	EVENT_PINNED = 2,
	EVENT_TIME = 4,
	EVENT_FROZEN = 8,
	EVENT_CPU = 16,
	EVENT_CGROUP = 32,
	EVENT_ALL = 3,
	EVENT_TIME_FROZEN = 12,
};

enum ex_phy_state {
	PHY_EMPTY = 0,
	PHY_VACANT = 1,
	PHY_NOT_PRESENT = 2,
	PHY_DEVICE_DISCOVERED = 3,
};

enum exact_level {
	NOT_EXACT = 0,
	EXACT = 1,
	RANGE_WITHIN = 2,
};

enum exception_type {
	except_type_sync = 0,
	except_type_irq = 128,
	except_type_fiq = 256,
	except_type_serror = 384,
};

enum exec_status {
	SAS_SAM_STAT_GOOD = 0,
	SAS_SAM_STAT_BUSY = 8,
	SAS_SAM_STAT_TASK_ABORTED = 64,
	SAS_SAM_STAT_CHECK_CONDITION = 2,
	SAS_DEV_NO_RESPONSE = 128,
	SAS_DATA_UNDERRUN = 129,
	SAS_DATA_OVERRUN = 130,
	SAS_INTERRUPTED = 131,
	SAS_QUEUE_FULL = 132,
	SAS_DEVICE_UNKNOWN = 133,
	SAS_OPEN_REJECT = 134,
	SAS_OPEN_TO = 135,
	SAS_PROTO_RESPONSE = 136,
	SAS_PHY_DOWN = 137,
	SAS_NAK_R_ERR = 138,
	SAS_PENDING = 139,
	SAS_ABORTED_TASK = 140,
};

enum execmem_range_flags {
	EXECMEM_KASAN_SHADOW = 1,
	EXECMEM_ROX_CACHE = 2,
};

enum execmem_type {
	EXECMEM_DEFAULT = 0,
	EXECMEM_MODULE_TEXT = 0,
	EXECMEM_KPROBES = 1,
	EXECMEM_FTRACE = 2,
	EXECMEM_BPF = 3,
	EXECMEM_MODULE_DATA = 4,
	EXECMEM_TYPE_MAX = 5,
};

enum ext4_journal_trigger_type {
	EXT4_JTR_ORPHAN_FILE = 0,
	EXT4_JTR_NONE = 1,
};

enum ext4_li_mode {
	EXT4_LI_MODE_PREFETCH_BBITMAP = 0,
	EXT4_LI_MODE_ITABLE = 1,
};

enum exynos_cpuclk_layout {
	CPUCLK_LAYOUT_E4210 = 0,
	CPUCLK_LAYOUT_E5433 = 1,
	CPUCLK_LAYOUT_E850_CL0 = 2,
	CPUCLK_LAYOUT_E850_CL1 = 3,
};

enum exynos_mipi_phy_id {
	EXYNOS_MIPI_PHY_ID_NONE = -1,
	EXYNOS_MIPI_PHY_ID_CSIS0 = 0,
	EXYNOS_MIPI_PHY_ID_DSIM0 = 1,
	EXYNOS_MIPI_PHY_ID_CSIS1 = 2,
	EXYNOS_MIPI_PHY_ID_DSIM1 = 3,
	EXYNOS_MIPI_PHY_ID_CSIS2 = 4,
	EXYNOS_MIPI_PHYS_NUM = 5,
};

enum exynos_mipi_phy_regmap_id {
	EXYNOS_MIPI_REGMAP_PMU = 0,
	EXYNOS_MIPI_REGMAP_DISP = 1,
	EXYNOS_MIPI_REGMAP_CAM0 = 2,
	EXYNOS_MIPI_REGMAP_CAM1 = 3,
	EXYNOS_MIPI_REGMAPS_NUM = 4,
};

enum exynos_usi_ver {
	USI_VER1 = 0,
	USI_VER2 = 1,
};

enum fail_dup_mod_reason {
	FAIL_DUP_MOD_BECOMING = 0,
	FAIL_DUP_MOD_LOAD = 1,
};

enum fan53555_vendor {
	FAN53526_VENDOR_FAIRCHILD = 0,
	FAN53555_VENDOR_FAIRCHILD = 1,
	FAN53555_VENDOR_ROCKCHIP = 2,
	RK8602_VENDOR_ROCKCHIP = 3,
	FAN53555_VENDOR_SILERGY = 4,
	FAN53526_VENDOR_TCS = 5,
};

enum fanotify_event_type {
	FANOTIFY_EVENT_TYPE_FID = 0,
	FANOTIFY_EVENT_TYPE_FID_NAME = 1,
	FANOTIFY_EVENT_TYPE_PATH = 2,
	FANOTIFY_EVENT_TYPE_PATH_PERM = 3,
	FANOTIFY_EVENT_TYPE_OVERFLOW = 4,
	FANOTIFY_EVENT_TYPE_FS_ERROR = 5,
	FANOTIFY_EVENT_TYPE_MNT = 6,
	__FANOTIFY_EVENT_TYPE_NUM = 7,
};

enum fault_flag {
	FAULT_FLAG_WRITE = 1,
	FAULT_FLAG_MKWRITE = 2,
	FAULT_FLAG_ALLOW_RETRY = 4,
	FAULT_FLAG_RETRY_NOWAIT = 8,
	FAULT_FLAG_KILLABLE = 16,
	FAULT_FLAG_TRIED = 32,
	FAULT_FLAG_USER = 64,
	FAULT_FLAG_REMOTE = 128,
	FAULT_FLAG_INSTRUCTION = 256,
	FAULT_FLAG_INTERRUPTIBLE = 512,
	FAULT_FLAG_UNSHARE = 1024,
	FAULT_FLAG_ORIG_PTE_VALID = 2048,
	FAULT_FLAG_VMA_LOCK = 4096,
};

enum fbq_type {
	regular = 0,
	remote = 1,
	all = 2,
};

enum fec_txbuf_type {
	FEC_TXBUF_T_SKB = 0,
	FEC_TXBUF_T_XDP_NDO = 1,
	FEC_TXBUF_T_XDP_TX = 2,
};

enum fetch_op {
	FETCH_OP_NOP = 0,
	FETCH_OP_REG = 1,
	FETCH_OP_STACK = 2,
	FETCH_OP_STACKP = 3,
	FETCH_OP_RETVAL = 4,
	FETCH_OP_IMM = 5,
	FETCH_OP_COMM = 6,
	FETCH_OP_ARG = 7,
	FETCH_OP_FOFFS = 8,
	FETCH_OP_DATA = 9,
	FETCH_OP_EDATA = 10,
	FETCH_OP_DEREF = 11,
	FETCH_OP_UDEREF = 12,
	FETCH_OP_ST_RAW = 13,
	FETCH_OP_ST_MEM = 14,
	FETCH_OP_ST_UMEM = 15,
	FETCH_OP_ST_STRING = 16,
	FETCH_OP_ST_USTRING = 17,
	FETCH_OP_ST_SYMSTR = 18,
	FETCH_OP_ST_EDATA = 19,
	FETCH_OP_MOD_BF = 20,
	FETCH_OP_LP_ARRAY = 21,
	FETCH_OP_TP_ARG = 22,
	FETCH_OP_END = 23,
	FETCH_NOP_SYMBOL = 24,
};

enum fg_filter_id {
	__NO_FGF__ = 0,
	HCRX_FGTnXS = 1,
	__NR_FG_FILTER_IDS__ = 2,
};

enum fgt_group_id {
	__NO_FGT_GROUP__ = 0,
	HFGRTR_GROUP = 1,
	HFGWTR_GROUP = 1,
	HDFGRTR_GROUP = 2,
	HDFGWTR_GROUP = 2,
	HFGITR_GROUP = 3,
	HAFGRTR_GROUP = 4,
	HFGRTR2_GROUP = 5,
	HFGWTR2_GROUP = 5,
	HDFGRTR2_GROUP = 6,
	HDFGWTR2_GROUP = 6,
	HFGITR2_GROUP = 7,
	__NR_FGT_GROUP_IDS__ = 8,
};

enum fh_pll_id {
	FH_ARMCA7PLL = 0,
	FH_ARMCA15PLL = 1,
	FH_MAINPLL = 2,
	FH_MPLL = 3,
	FH_MSDCPLL = 4,
	FH_MMPLL = 5,
	FH_VENCPLL = 6,
	FH_TVDPLL = 7,
	FH_VCODECPLL = 8,
	FH_LVDSPLL = 9,
	FH_MSDC2PLL = 10,
	FH_NR_FH = 11,
};

enum fh_pll_id___2 {
	FH_CA53PLL_LL = 0,
	FH_CA53PLL_BL = 1,
	FH_MAINPLL___2 = 2,
	FH_MPLL___2 = 3,
	FH_MSDCPLL___2 = 4,
	FH_MMPLL___2 = 5,
	FH_VENCPLL___2 = 6,
	FH_TVDPLL___2 = 7,
	FH_VCODECPLL___2 = 8,
	FH_NR_FH___2 = 9,
};

enum fh_pll_id___3 {
	FH_ARMPLL_LL = 0,
	FH_ARMPLL_BL = 1,
	FH_MEMPLL = 2,
	FH_ADSPPLL = 3,
	FH_NNAPLL = 4,
	FH_CCIPLL = 5,
	FH_MFGPLL = 6,
	FH_TVDPLL2 = 7,
	FH_MPLL___3 = 8,
	FH_MMPLL___3 = 9,
	FH_MAINPLL___3 = 10,
	FH_MSDCPLL___3 = 11,
	FH_IMGPLL = 12,
	FH_VDECPLL = 13,
	FH_TVDPLL1 = 14,
	FH_NR_FH___3 = 15,
};

enum fh_pll_id___4 {
	FH_ARMPLL_LL___2 = 0,
	FH_ARMPLL_BL0 = 1,
	FH_ARMPLL_BL1 = 2,
	FH_ARMPLL_BL2 = 3,
	FH_ARMPLL_BL3 = 4,
	FH_CCIPLL___2 = 5,
	FH_MFGPLL___2 = 6,
	FH_MEMPLL___2 = 7,
	FH_MPLL___4 = 8,
	FH_MMPLL___4 = 9,
	FH_MAINPLL___4 = 10,
	FH_MSDCPLL___4 = 11,
	FH_ADSPPLL___2 = 12,
	FH_APUPLL = 13,
	FH_TVDPLL___3 = 14,
	FH_NR_FH___4 = 15,
};

enum fh_pll_id___5 {
	FH_ARMPLL_LL___3 = 0,
	FH_ARMPLL_BL___2 = 1,
	FH_CCIPLL___3 = 2,
	FH_MAINPLL___5 = 3,
	FH_MMPLL___5 = 4,
	FH_TVDPLL___4 = 5,
	FH_RESERVE6 = 6,
	FH_ADSPPLL___3 = 7,
	FH_MFGPLL___3 = 8,
	FH_NNAPLL___2 = 9,
	FH_NNA2PLL = 10,
	FH_MSDCPLL___5 = 11,
	FH_RESERVE12 = 12,
	FH_NR_FH___5 = 13,
};

enum fhctl_variant {
	FHCTL_PLLFH_V1 = 0,
	FHCTL_PLLFH_V2 = 1,
};

enum fib_event_type {
	FIB_EVENT_ENTRY_REPLACE = 0,
	FIB_EVENT_ENTRY_APPEND = 1,
	FIB_EVENT_ENTRY_ADD = 2,
	FIB_EVENT_ENTRY_DEL = 3,
	FIB_EVENT_RULE_ADD = 4,
	FIB_EVENT_RULE_DEL = 5,
	FIB_EVENT_NH_ADD = 6,
	FIB_EVENT_NH_DEL = 7,
	FIB_EVENT_VIF_ADD = 8,
	FIB_EVENT_VIF_DEL = 9,
};

enum fid_type {
	FILEID_ROOT = 0,
	FILEID_INO32_GEN = 1,
	FILEID_INO32_GEN_PARENT = 2,
	FILEID_BTRFS_WITHOUT_PARENT = 77,
	FILEID_BTRFS_WITH_PARENT = 78,
	FILEID_BTRFS_WITH_PARENT_ROOT = 79,
	FILEID_UDF_WITHOUT_PARENT = 81,
	FILEID_UDF_WITH_PARENT = 82,
	FILEID_NILFS_WITHOUT_PARENT = 97,
	FILEID_NILFS_WITH_PARENT = 98,
	FILEID_FAT_WITHOUT_PARENT = 113,
	FILEID_FAT_WITH_PARENT = 114,
	FILEID_INO64_GEN = 129,
	FILEID_INO64_GEN_PARENT = 130,
	FILEID_LUSTRE = 151,
	FILEID_BCACHEFS_WITHOUT_PARENT = 177,
	FILEID_BCACHEFS_WITH_PARENT = 178,
	FILEID_KERNFS = 254,
	FILEID_INVALID = 255,
};

enum fifo_dump_mode_v3_hw {
	FIFO_DUMP_FORVER = 1,
	FIFO_DUMP_AFTER_TRIGGER = 2,
	FIFO_DUMP_UNTILL_TRIGGER = 4,
};

enum fifo_trigger_mode_v3_hw {
	FIFO_TRIGGER_EDGE = 1,
	FIFO_TRIGGER_SAME_LEVEL = 2,
	FIFO_TRIGGER_DIFF_LEVEL = 4,
};

enum file_time_flags {
	S_ATIME = 1,
	S_MTIME = 2,
	S_CTIME = 4,
	S_VERSION = 8,
};

enum filter_op_ids {
	OP_GLOB = 0,
	OP_NE = 1,
	OP_EQ = 2,
	OP_LE = 3,
	OP_LT = 4,
	OP_GE = 5,
	OP_GT = 6,
	OP_BAND = 7,
	OP_MAX = 8,
};

enum filter_pred_fn {
	FILTER_PRED_FN_NOP = 0,
	FILTER_PRED_FN_64 = 1,
	FILTER_PRED_FN_64_CPUMASK = 2,
	FILTER_PRED_FN_S64 = 3,
	FILTER_PRED_FN_U64 = 4,
	FILTER_PRED_FN_32 = 5,
	FILTER_PRED_FN_32_CPUMASK = 6,
	FILTER_PRED_FN_S32 = 7,
	FILTER_PRED_FN_U32 = 8,
	FILTER_PRED_FN_16 = 9,
	FILTER_PRED_FN_16_CPUMASK = 10,
	FILTER_PRED_FN_S16 = 11,
	FILTER_PRED_FN_U16 = 12,
	FILTER_PRED_FN_8 = 13,
	FILTER_PRED_FN_8_CPUMASK = 14,
	FILTER_PRED_FN_S8 = 15,
	FILTER_PRED_FN_U8 = 16,
	FILTER_PRED_FN_COMM = 17,
	FILTER_PRED_FN_STRING = 18,
	FILTER_PRED_FN_STRLOC = 19,
	FILTER_PRED_FN_STRRELLOC = 20,
	FILTER_PRED_FN_PCHAR_USER = 21,
	FILTER_PRED_FN_PCHAR = 22,
	FILTER_PRED_FN_CPU = 23,
	FILTER_PRED_FN_CPU_CPUMASK = 24,
	FILTER_PRED_FN_CPUMASK = 25,
	FILTER_PRED_FN_CPUMASK_CPU = 26,
	FILTER_PRED_FN_FUNCTION = 27,
	FILTER_PRED_FN_ = 28,
	FILTER_PRED_TEST_VISITED = 29,
};

enum fiq_hwirq {
	AIC_TMR_EL0_PHYS = 0,
	AIC_TMR_EL0_VIRT = 1,
	AIC_TMR_EL02_PHYS = 2,
	AIC_TMR_EL02_VIRT = 3,
	AIC_CPU_PMU_Effi = 4,
	AIC_CPU_PMU_Perf = 5,
	AIC_VGIC_MI = 6,
	AIC_NR_FIQ = 7,
};

enum fit_type {
	NOTHING_FIT = 0,
	FL_FIT_TYPE = 1,
	LE_FIT_TYPE = 2,
	RE_FIT_TYPE = 3,
	NE_FIT_TYPE = 4,
};

enum fixed_addresses {
	FIX_HOLE = 0,
	FIX_FDT_END = 1,
	FIX_FDT = 514,
	FIX_EARLYCON_MEM_BASE = 515,
	FIX_TEXT_POKE0 = 516,
	FIX_VNCR_END = 517,
	FIX_VNCR = 1029,
	FIX_APEI_GHES_IRQ = 1030,
	FIX_APEI_GHES_SEA = 1031,
	FIX_APEI_GHES_SDEI_NORMAL = 1032,
	FIX_APEI_GHES_SDEI_CRITICAL = 1033,
	FIX_ENTRY_TRAMP_TEXT4 = 1034,
	FIX_ENTRY_TRAMP_TEXT3 = 1035,
	FIX_ENTRY_TRAMP_TEXT2 = 1036,
	FIX_ENTRY_TRAMP_TEXT1 = 1037,
	__end_of_permanent_fixed_addresses = 1038,
	FIX_BTMAP_END = 1038,
	FIX_BTMAP_BEGIN = 1485,
	FIX_PTE = 1486,
	FIX_PMD = 1487,
	FIX_PUD = 1488,
	FIX_P4D = 1489,
	FIX_PGD = 1490,
	__end_of_fixed_addresses = 1491,
};

enum flag_idn {
	QUERY_FLAG_IDN_FDEVICEINIT = 1,
	QUERY_FLAG_IDN_PERMANENT_WPE = 2,
	QUERY_FLAG_IDN_PWR_ON_WPE = 3,
	QUERY_FLAG_IDN_BKOPS_EN = 4,
	QUERY_FLAG_IDN_LIFE_SPAN_MODE_ENABLE = 5,
	QUERY_FLAG_IDN_PURGE_ENABLE = 6,
	QUERY_FLAG_IDN_RESERVED2 = 7,
	QUERY_FLAG_IDN_FPHYRESOURCEREMOVAL = 8,
	QUERY_FLAG_IDN_BUSY_RTC = 9,
	QUERY_FLAG_IDN_RESERVED3 = 10,
	QUERY_FLAG_IDN_PERMANENTLY_DISABLE_FW_UPDATE = 11,
	QUERY_FLAG_IDN_WB_EN = 14,
	QUERY_FLAG_IDN_WB_BUFF_FLUSH_EN = 15,
	QUERY_FLAG_IDN_WB_BUFF_FLUSH_DURING_HIBERN8 = 16,
	QUERY_FLAG_IDN_HPB_RESET = 17,
	QUERY_FLAG_IDN_HPB_EN = 18,
};

enum flow_action_hw_stats {
	FLOW_ACTION_HW_STATS_IMMEDIATE = 1,
	FLOW_ACTION_HW_STATS_DELAYED = 2,
	FLOW_ACTION_HW_STATS_ANY = 3,
	FLOW_ACTION_HW_STATS_DISABLED = 4,
	FLOW_ACTION_HW_STATS_DONT_CARE = 7,
};

enum flow_action_hw_stats_bit {
	FLOW_ACTION_HW_STATS_IMMEDIATE_BIT = 0,
	FLOW_ACTION_HW_STATS_DELAYED_BIT = 1,
	FLOW_ACTION_HW_STATS_DISABLED_BIT = 2,
	FLOW_ACTION_HW_STATS_NUM_BITS = 3,
};

enum flow_action_id {
	FLOW_ACTION_ACCEPT = 0,
	FLOW_ACTION_DROP = 1,
	FLOW_ACTION_TRAP = 2,
	FLOW_ACTION_GOTO = 3,
	FLOW_ACTION_REDIRECT = 4,
	FLOW_ACTION_MIRRED = 5,
	FLOW_ACTION_REDIRECT_INGRESS = 6,
	FLOW_ACTION_MIRRED_INGRESS = 7,
	FLOW_ACTION_VLAN_PUSH = 8,
	FLOW_ACTION_VLAN_POP = 9,
	FLOW_ACTION_VLAN_MANGLE = 10,
	FLOW_ACTION_TUNNEL_ENCAP = 11,
	FLOW_ACTION_TUNNEL_DECAP = 12,
	FLOW_ACTION_MANGLE = 13,
	FLOW_ACTION_ADD = 14,
	FLOW_ACTION_CSUM = 15,
	FLOW_ACTION_MARK = 16,
	FLOW_ACTION_PTYPE = 17,
	FLOW_ACTION_PRIORITY = 18,
	FLOW_ACTION_RX_QUEUE_MAPPING = 19,
	FLOW_ACTION_WAKE = 20,
	FLOW_ACTION_QUEUE = 21,
	FLOW_ACTION_SAMPLE = 22,
	FLOW_ACTION_POLICE = 23,
	FLOW_ACTION_CT = 24,
	FLOW_ACTION_CT_METADATA = 25,
	FLOW_ACTION_MPLS_PUSH = 26,
	FLOW_ACTION_MPLS_POP = 27,
	FLOW_ACTION_MPLS_MANGLE = 28,
	FLOW_ACTION_GATE = 29,
	FLOW_ACTION_PPPOE_PUSH = 30,
	FLOW_ACTION_JUMP = 31,
	FLOW_ACTION_PIPE = 32,
	FLOW_ACTION_VLAN_PUSH_ETH = 33,
	FLOW_ACTION_VLAN_POP_ETH = 34,
	FLOW_ACTION_CONTINUE = 35,
	NUM_FLOW_ACTIONS = 36,
};

enum flow_action_mangle_base {
	FLOW_ACT_MANGLE_UNSPEC = 0,
	FLOW_ACT_MANGLE_HDR_TYPE_ETH = 1,
	FLOW_ACT_MANGLE_HDR_TYPE_IP4 = 2,
	FLOW_ACT_MANGLE_HDR_TYPE_IP6 = 3,
	FLOW_ACT_MANGLE_HDR_TYPE_TCP = 4,
	FLOW_ACT_MANGLE_HDR_TYPE_UDP = 5,
};

enum flow_block_binder_type {
	FLOW_BLOCK_BINDER_TYPE_UNSPEC = 0,
	FLOW_BLOCK_BINDER_TYPE_CLSACT_INGRESS = 1,
	FLOW_BLOCK_BINDER_TYPE_CLSACT_EGRESS = 2,
	FLOW_BLOCK_BINDER_TYPE_RED_EARLY_DROP = 3,
	FLOW_BLOCK_BINDER_TYPE_RED_MARK = 4,
};

enum flow_block_command {
	FLOW_BLOCK_BIND = 0,
	FLOW_BLOCK_UNBIND = 1,
};

enum flow_cls_command {
	FLOW_CLS_REPLACE = 0,
	FLOW_CLS_DESTROY = 1,
	FLOW_CLS_STATS = 2,
	FLOW_CLS_TMPLT_CREATE = 3,
	FLOW_CLS_TMPLT_DESTROY = 4,
};

enum flow_control {
	FC_NONE = 0,
	FC_TX = 1,
	FC_RX = 2,
	FC_BOTH = 3,
};

enum flow_dissect_ret {
	FLOW_DISSECT_RET_OUT_GOOD = 0,
	FLOW_DISSECT_RET_OUT_BAD = 1,
	FLOW_DISSECT_RET_PROTO_AGAIN = 2,
	FLOW_DISSECT_RET_IPPROTO_AGAIN = 3,
	FLOW_DISSECT_RET_CONTINUE = 4,
};

enum flow_dissector_ctrl_flags {
	FLOW_DIS_IS_FRAGMENT = 1,
	FLOW_DIS_FIRST_FRAG = 2,
	FLOW_DIS_F_TUNNEL_CSUM = 4,
	FLOW_DIS_F_TUNNEL_DONT_FRAGMENT = 8,
	FLOW_DIS_F_TUNNEL_OAM = 16,
	FLOW_DIS_F_TUNNEL_CRIT_OPT = 32,
	FLOW_DIS_ENCAPSULATION = 64,
};

enum flow_dissector_key_id {
	FLOW_DISSECTOR_KEY_CONTROL = 0,
	FLOW_DISSECTOR_KEY_BASIC = 1,
	FLOW_DISSECTOR_KEY_IPV4_ADDRS = 2,
	FLOW_DISSECTOR_KEY_IPV6_ADDRS = 3,
	FLOW_DISSECTOR_KEY_PORTS = 4,
	FLOW_DISSECTOR_KEY_PORTS_RANGE = 5,
	FLOW_DISSECTOR_KEY_ICMP = 6,
	FLOW_DISSECTOR_KEY_ETH_ADDRS = 7,
	FLOW_DISSECTOR_KEY_TIPC = 8,
	FLOW_DISSECTOR_KEY_ARP = 9,
	FLOW_DISSECTOR_KEY_VLAN = 10,
	FLOW_DISSECTOR_KEY_FLOW_LABEL = 11,
	FLOW_DISSECTOR_KEY_GR