/*
 * Copyright (C) 2014 The Android Open Source Project
 * Copyright (c) 1994, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package java.lang;

/**
 * Thrown if the Java Virtual Machine or a {@code ClassLoader} instance
 * tries to load in the definition of a class (as part of a normal method call
 * or as part of creating a new instance using the {@code new} expression)
 * and no definition of the class could be found.
 * <p>
 * The searched-for class definition existed when the currently
 * executing class was compiled, but the definition can no longer be
 * found.
 *
 * @since   1.0
 */
public class NoClassDefFoundError extends LinkageError {
    @java.io.Serial
    private static final long serialVersionUID = 9095859863287012458L;

    /**
     * Constructs a {@code NoClassDefFoundError} with no detail message.
     */
    public NoClassDefFoundError() {
        super();
    }

    /**
     * Constructs a {@code NoClassDefFoundError} with the specified
     * detail message.
     *
     * @param   s   the detail message.
     */
    public NoClassDefFoundError(String s) {
        super(s);
    }

    // Android-added: A new constructor for use by the Android runtime.
    /**
     * Constructs a new {@code NoClassDefFoundError} with the current stack
     * trace, the specified detail message and the specified cause. Used
     * internally by the Android runtime.
     *
     * @param detailMessage
     *            the detail message for this error.
     * @param throwable
     *            the cause of this error.
     */
    private NoClassDefFoundError(String detailMessage, Throwable throwable) {
        super(detailMessage, throwable);
    }
}
