/* pamac_config_daemon.c generated by valac 0.56.18, the Vala compiler
 * generated from pamac_config_daemon.vala, do not modify */

/*
 *  pamac-vala
 *
 *  Copyright (C) 2014-2023 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PAMAC_TYPE_CONFIG (pamac_config_get_type ())
#define PAMAC_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_CONFIG, PamacConfig))
#define PAMAC_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_CONFIG, PamacConfigClass))
#define PAMAC_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_CONFIG))
#define PAMAC_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_CONFIG))
#define PAMAC_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_CONFIG, PamacConfigClass))

typedef struct _PamacConfig PamacConfig;
typedef struct _PamacConfigClass PamacConfigClass;
typedef struct _PamacConfigPrivate PamacConfigPrivate;

#define PAMAC_TYPE_PLUGIN_LOADER (pamac_plugin_loader_get_type ())
#define PAMAC_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_PLUGIN_LOADER, PamacPluginLoader))
#define PAMAC_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_PLUGIN_LOADER, PamacPluginLoaderClass))
#define PAMAC_IS_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_PLUGIN_LOADER))
#define PAMAC_IS_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_PLUGIN_LOADER))
#define PAMAC_PLUGIN_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_PLUGIN_LOADER, PamacPluginLoaderClass))

typedef struct _PamacPluginLoader PamacPluginLoader;
typedef struct _PamacPluginLoaderClass PamacPluginLoaderClass;

#define PAMAC_TYPE_AUR_PLUGIN (pamac_aur_plugin_get_type ())
#define PAMAC_AUR_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_AUR_PLUGIN, PamacAURPlugin))
#define PAMAC_IS_AUR_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_AUR_PLUGIN))
#define PAMAC_AUR_PLUGIN_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PAMAC_TYPE_AUR_PLUGIN, PamacAURPluginIface))

typedef struct _PamacAURPlugin PamacAURPlugin;
typedef struct _PamacAURPluginIface PamacAURPluginIface;

#define PAMAC_TYPE_AUR_INFOS (pamac_aur_infos_get_type ())
#define PAMAC_AUR_INFOS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_AUR_INFOS, PamacAURInfos))
#define PAMAC_AUR_INFOS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_AUR_INFOS, PamacAURInfosClass))
#define PAMAC_IS_AUR_INFOS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_AUR_INFOS))
#define PAMAC_IS_AUR_INFOS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_AUR_INFOS))
#define PAMAC_AUR_INFOS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_AUR_INFOS, PamacAURInfosClass))

typedef struct _PamacAURInfos PamacAURInfos;
typedef struct _PamacAURInfosClass PamacAURInfosClass;

#define PAMAC_TYPE_APPSTREAM_PLUGIN (pamac_appstream_plugin_get_type ())
#define PAMAC_APPSTREAM_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_APPSTREAM_PLUGIN, PamacAppstreamPlugin))
#define PAMAC_IS_APPSTREAM_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_APPSTREAM_PLUGIN))
#define PAMAC_APPSTREAM_PLUGIN_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PAMAC_TYPE_APPSTREAM_PLUGIN, PamacAppstreamPluginIface))

typedef struct _PamacAppstreamPlugin PamacAppstreamPlugin;
typedef struct _PamacAppstreamPluginIface PamacAppstreamPluginIface;

#define PAMAC_TYPE_APP (pamac_app_get_type ())
#define PAMAC_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_APP, PamacApp))
#define PAMAC_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_APP, PamacAppClass))
#define PAMAC_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_APP))
#define PAMAC_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_APP))
#define PAMAC_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_APP, PamacAppClass))

typedef struct _PamacApp PamacApp;
typedef struct _PamacAppClass PamacAppClass;

#define PAMAC_TYPE_SNAP_PLUGIN (pamac_snap_plugin_get_type ())
#define PAMAC_SNAP_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_SNAP_PLUGIN, PamacSnapPlugin))
#define PAMAC_IS_SNAP_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_SNAP_PLUGIN))
#define PAMAC_SNAP_PLUGIN_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PAMAC_TYPE_SNAP_PLUGIN, PamacSnapPluginIface))

typedef struct _PamacSnapPlugin PamacSnapPlugin;
typedef struct _PamacSnapPluginIface PamacSnapPluginIface;

#define PAMAC_TYPE_PACKAGE (pamac_package_get_type ())
#define PAMAC_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_PACKAGE, PamacPackage))
#define PAMAC_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_PACKAGE, PamacPackageClass))
#define PAMAC_IS_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_PACKAGE))
#define PAMAC_IS_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_PACKAGE))
#define PAMAC_PACKAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_PACKAGE, PamacPackageClass))

typedef struct _PamacPackage PamacPackage;
typedef struct _PamacPackageClass PamacPackageClass;

#define PAMAC_TYPE_SNAP_PACKAGE (pamac_snap_package_get_type ())
#define PAMAC_SNAP_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_SNAP_PACKAGE, PamacSnapPackage))
#define PAMAC_SNAP_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_SNAP_PACKAGE, PamacSnapPackageClass))
#define PAMAC_IS_SNAP_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_SNAP_PACKAGE))
#define PAMAC_IS_SNAP_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_SNAP_PACKAGE))
#define PAMAC_SNAP_PACKAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_SNAP_PACKAGE, PamacSnapPackageClass))

typedef struct _PamacSnapPackage PamacSnapPackage;
typedef struct _PamacSnapPackageClass PamacSnapPackageClass;

#define PAMAC_TYPE_FLATPAK_PLUGIN (pamac_flatpak_plugin_get_type ())
#define PAMAC_FLATPAK_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_FLATPAK_PLUGIN, PamacFlatpakPlugin))
#define PAMAC_IS_FLATPAK_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_FLATPAK_PLUGIN))
#define PAMAC_FLATPAK_PLUGIN_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PAMAC_TYPE_FLATPAK_PLUGIN, PamacFlatpakPluginIface))

typedef struct _PamacFlatpakPlugin PamacFlatpakPlugin;
typedef struct _PamacFlatpakPluginIface PamacFlatpakPluginIface;

#define PAMAC_TYPE_FLATPAK_PACKAGE (pamac_flatpak_package_get_type ())
#define PAMAC_FLATPAK_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_FLATPAK_PACKAGE, PamacFlatpakPackage))
#define PAMAC_FLATPAK_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_FLATPAK_PACKAGE, PamacFlatpakPackageClass))
#define PAMAC_IS_FLATPAK_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_FLATPAK_PACKAGE))
#define PAMAC_IS_FLATPAK_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_FLATPAK_PACKAGE))
#define PAMAC_FLATPAK_PACKAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_FLATPAK_PACKAGE, PamacFlatpakPackageClass))

typedef struct _PamacFlatpakPackage PamacFlatpakPackage;
typedef struct _PamacFlatpakPackageClass PamacFlatpakPackageClass;

#define TYPE_ALPM_CONFIG (alpm_config_get_type ())
#define ALPM_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALPM_CONFIG, AlpmConfig))
#define ALPM_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALPM_CONFIG, AlpmConfigClass))
#define IS_ALPM_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALPM_CONFIG))
#define IS_ALPM_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALPM_CONFIG))
#define ALPM_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALPM_CONFIG, AlpmConfigClass))

typedef struct _AlpmConfig AlpmConfig;
typedef struct _AlpmConfigClass AlpmConfigClass;
enum  {
	PAMAC_CONFIG_0_PROPERTY,
	PAMAC_CONFIG_CONF_PATH_PROPERTY,
	PAMAC_CONFIG_REFRESH_PERIOD_PROPERTY,
	PAMAC_CONFIG_SUPPORT_AUR_PROPERTY,
	PAMAC_CONFIG_ENABLE_AUR_PROPERTY,
	PAMAC_CONFIG_SUPPORT_APPSTREAM_PROPERTY,
	PAMAC_CONFIG_ENABLE_APPSTREAM_PROPERTY,
	PAMAC_CONFIG_SUPPORT_SNAP_PROPERTY,
	PAMAC_CONFIG_ENABLE_SNAP_PROPERTY,
	PAMAC_CONFIG_SUPPORT_FLATPAK_PROPERTY,
	PAMAC_CONFIG_ENABLE_FLATPAK_PROPERTY,
	PAMAC_CONFIG_CHECK_FLATPAK_UPDATES_PROPERTY,
	PAMAC_CONFIG_AUR_BUILD_DIR_PROPERTY,
	PAMAC_CONFIG_CHECK_AUR_UPDATES_PROPERTY,
	PAMAC_CONFIG_CHECK_AUR_VCS_UPDATES_PROPERTY,
	PAMAC_CONFIG_OFFLINE_UPGRADE_PROPERTY,
	PAMAC_CONFIG_MAX_PARALLEL_DOWNLOADS_PROPERTY,
	PAMAC_CONFIG_CLEAN_KEEP_NUM_PKGS_PROPERTY,
	PAMAC_CONFIG_CLEAN_RM_ONLY_UNINSTALLED_PROPERTY,
	PAMAC_CONFIG_IGNOREPKGS_PROPERTY,
	PAMAC_CONFIG_ALPM_CONFIG_PROPERTY,
	PAMAC_CONFIG_NUM_PROPERTIES
};
static GParamSpec* pamac_config_properties[PAMAC_CONFIG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _alpm_config_unref0(var) ((var == NULL) ? NULL : (var = (alpm_config_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _AlpmConfigPrivate AlpmConfigPrivate;

struct _PamacConfig {
	GObject parent_instance;
	PamacConfigPrivate * priv;
};

struct _PamacConfigClass {
	GObjectClass parent_class;
};

struct _PamacAURPluginIface {
	GTypeInterface parent_iface;
	void (*set_real_build_dir) (PamacAURPlugin* self, const gchar* config_aur_build_dir);
	const gchar* (*get_real_build_dir) (PamacAURPlugin* self);
	PamacAURInfos* (*get_infos) (PamacAURPlugin* self, const gchar* pkgname);
	GPtrArray* (*get_multi_infos) (PamacAURPlugin* self, GPtrArray* pkgnames);
	GPtrArray* (*get_providers) (PamacAURPlugin* self, const gchar* depend);
	GPtrArray* (*search) (PamacAURPlugin* self, const gchar* search_string);
};

struct _PamacAppstreamPluginIface {
	GTypeInterface parent_iface;
	void (*load) (PamacAppstreamPlugin* self, GPtrArray* repos_names);
	GPtrArray* (*get_apps) (PamacAppstreamPlugin* self);
	GPtrArray* (*search) (PamacAppstreamPlugin* self, gchar** search_tokens, gint search_tokens_length1);
	GPtrArray* (*get_pkgname_apps) (PamacAppstreamPlugin* self, const gchar* pkgname);
	GHashTable* (*get_category_apps) (PamacAppstreamPlugin* self, const gchar* category);
};

struct _PamacSnapPluginIface {
	GTypeInterface parent_iface;
	void (*search_snaps) (PamacSnapPlugin* self, const gchar* search_string, GPtrArray** pkgs);
	void (*search_uninstalled_snaps_sync) (PamacSnapPlugin* self, const gchar* search_string, GPtrArray** pkgs);
	gboolean (*is_installed_snap) (PamacSnapPlugin* self, const gchar* name);
	PamacSnapPackage* (*get_snap) (PamacSnapPlugin* self, const gchar* name);
	PamacSnapPackage* (*get_snap_by_app_id) (PamacSnapPlugin* self, const gchar* app_id);
	void (*get_installed_snaps) (PamacSnapPlugin* self, GPtrArray** pkgs);
	gchar* (*get_installed_snap_icon) (PamacSnapPlugin* self, const gchar* name, GError** error);
	void (*get_category_snaps) (PamacSnapPlugin* self, const gchar* category, GPtrArray** pkgs);
	gboolean (*trans_run) (PamacSnapPlugin* self, const gchar* sender, gchar** to_install, gint to_install_length1, gchar** to_remove, gint to_remove_length1);
	gboolean (*switch_channel) (PamacSnapPlugin* self, const gchar* sender, const gchar* name, const gchar* channel);
	void (*trans_cancel) (PamacSnapPlugin* self, const gchar* sender);
	void (*refresh) (PamacSnapPlugin* self);
};

struct _PamacFlatpakPluginIface {
	GTypeInterface parent_iface;
	gboolean (*refresh_appstream_data) (PamacFlatpakPlugin* self);
	void (*load_appstream_data) (PamacFlatpakPlugin* self);
	void (*get_remotes_names) (PamacFlatpakPlugin* self, GPtrArray** remotes_names);
	void (*search_flatpaks) (PamacFlatpakPlugin* self, const gchar* search_string, GPtrArray** pkgs);
	void (*search_uninstalled_flatpaks_sync) (PamacFlatpakPlugin* self, gchar** search_terms, gint search_terms_length1, GPtrArray** pkgs);
	gboolean (*is_installed_flatpak) (PamacFlatpakPlugin* self, const gchar* name);
	PamacFlatpakPackage* (*get_flatpak_by_app_id) (PamacFlatpakPlugin* self, const gchar* app_id);
	PamacFlatpakPackage* (*get_flatpak) (PamacFlatpakPlugin* self, const gchar* id);
	void (*get_installed_flatpaks) (PamacFlatpakPlugin* self, GPtrArray** pkgs);
	void (*get_category_flatpaks) (PamacFlatpakPlugin* self, const gchar* category, GPtrArray** pkgs);
	void (*get_flatpak_updates) (PamacFlatpakPlugin* self, GPtrArray** pkgs);
	gboolean (*trans_run) (PamacFlatpakPlugin* self, const gchar* sender, gchar** to_install, gint to_install_length1, gchar** to_remove, gint to_remove_length1, gchar** to_upgrade, gint to_upgrade_length1);
	void (*trans_cancel) (PamacFlatpakPlugin* self, const gchar* sender);
	void (*refresh) (PamacFlatpakPlugin* self);
	guint64 (*get_refresh_period) (PamacFlatpakPlugin* self);
	void (*set_refresh_period) (PamacFlatpakPlugin* self, guint64 value);
};

struct _PamacConfigPrivate {
	gchar* _conf_path;
	guint64 _refresh_period;
	gboolean _support_aur;
	gboolean _enable_aur;
	PamacPluginLoader* aur_plugin_loader;
	gboolean _support_appstream;
	gboolean _enable_appstream;
	PamacPluginLoader* appstream_plugin_loader;
	gboolean _support_snap;
	gboolean _enable_snap;
	PamacPluginLoader* snap_plugin_loader;
	gboolean _support_flatpak;
	gboolean _enable_flatpak;
	gboolean _check_flatpak_updates;
	PamacPluginLoader* flatpak_plugin_loader;
	gchar* _aur_build_dir;
	gboolean _check_aur_updates;
	gboolean _check_aur_vcs_updates;
	gboolean _offline_upgrade;
	guint64 _max_parallel_downloads;
	guint64 _clean_keep_num_pkgs;
	gboolean _clean_rm_only_uninstalled;
	AlpmConfig* _alpm_config;
};

struct _AlpmConfig {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AlpmConfigPrivate * priv;
	gchar* dbpath;
	gboolean checkspace;
	GHashTable* ignorepkgs;
	GHashTable* holdpkgs;
	GHashTable* syncfirsts;
};

struct _AlpmConfigClass {
	GTypeClass parent_class;
	void (*finalize) (AlpmConfig *self);
};

static gint PamacConfig_private_offset;
static gpointer pamac_config_parent_class = NULL;

VALA_EXTERN GType pamac_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacConfig, g_object_unref)
VALA_EXTERN GType pamac_plugin_loader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacPluginLoader, g_object_unref)
VALA_EXTERN GType pamac_aur_infos_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacAURInfos, g_object_unref)
VALA_EXTERN GType pamac_aur_plugin_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacAURPlugin, g_object_unref)
VALA_EXTERN GType pamac_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacApp, g_object_unref)
VALA_EXTERN GType pamac_appstream_plugin_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacAppstreamPlugin, g_object_unref)
VALA_EXTERN GType pamac_package_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacPackage, g_object_unref)
VALA_EXTERN GType pamac_snap_package_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacSnapPackage, g_object_unref)
VALA_EXTERN GType pamac_snap_plugin_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacSnapPlugin, g_object_unref)
VALA_EXTERN GType pamac_flatpak_package_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacFlatpakPackage, g_object_unref)
VALA_EXTERN GType pamac_flatpak_plugin_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacFlatpakPlugin, g_object_unref)
VALA_EXTERN gpointer alpm_config_ref (gpointer instance);
VALA_EXTERN void alpm_config_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alpm_config (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_alpm_config (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_alpm_config (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_alpm_config (const GValue* value);
VALA_EXTERN GType alpm_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AlpmConfig, alpm_config_unref)
VALA_EXTERN PamacConfig* pamac_config_new (const gchar* conf_path);
VALA_EXTERN PamacConfig* pamac_config_construct (GType object_type,
                                     const gchar* conf_path);
VALA_EXTERN void pamac_config_reload (PamacConfig* self);
VALA_EXTERN void pamac_config_set_enable_appstream (PamacConfig* self,
                                        gboolean value);
VALA_EXTERN void pamac_config_set_enable_snap (PamacConfig* self,
                                   gboolean value);
VALA_EXTERN void pamac_config_set_enable_flatpak (PamacConfig* self,
                                      gboolean value);
VALA_EXTERN void pamac_config_set_aur_build_dir (PamacConfig* self,
                                     const gchar* value);
VALA_EXTERN void pamac_config_set_max_parallel_downloads (PamacConfig* self,
                                              guint64 value);
VALA_EXTERN void pamac_config_set_offline_upgrade (PamacConfig* self,
                                       gboolean value);
static void pamac_config_parse_file (PamacConfig* self,
                              const gchar* path);
VALA_EXTERN const gchar* pamac_config_get_conf_path (PamacConfig* self);
VALA_EXTERN guint64 pamac_config_get_max_parallel_downloads (PamacConfig* self);
VALA_EXTERN gboolean pamac_config_get_support_appstream (PamacConfig* self);
VALA_EXTERN gboolean pamac_config_get_support_snap (PamacConfig* self);
VALA_EXTERN gboolean pamac_config_get_support_flatpak (PamacConfig* self);
VALA_EXTERN PamacAURPlugin* pamac_config_get_aur_plugin (PamacConfig* self);
VALA_EXTERN gboolean pamac_config_get_support_aur (PamacConfig* self);
VALA_EXTERN gpointer pamac_plugin_loader_get_plugin (PamacPluginLoader* self);
VALA_EXTERN PamacAppstreamPlugin* pamac_config_get_appstream_plugin (PamacConfig* self);
VALA_EXTERN PamacSnapPlugin* pamac_config_get_snap_plugin (PamacConfig* self);
VALA_EXTERN PamacFlatpakPlugin* pamac_config_get_flatpak_plugin (PamacConfig* self);
VALA_EXTERN void pamac_config_write (PamacConfig* self,
                         GHashTable* new_conf);
static void pamac_config_set_conf_path (PamacConfig* self,
                                 const gchar* value);
VALA_EXTERN guint64 pamac_config_get_refresh_period (PamacConfig* self);
VALA_EXTERN void pamac_config_set_refresh_period (PamacConfig* self,
                                      guint64 value);
static void pamac_config_set_support_aur (PamacConfig* self,
                                   gboolean value);
VALA_EXTERN gboolean pamac_config_get_enable_aur (PamacConfig* self);
VALA_EXTERN void pamac_config_set_enable_aur (PamacConfig* self,
                                  gboolean value);
static void pamac_config_set_support_appstream (PamacConfig* self,
                                         gboolean value);
VALA_EXTERN gboolean pamac_config_get_enable_appstream (PamacConfig* self);
VALA_EXTERN void pamac_config_set_support_snap (PamacConfig* self,
                                    gboolean value);
VALA_EXTERN gboolean pamac_config_get_enable_snap (PamacConfig* self);
VALA_EXTERN void pamac_config_set_support_flatpak (PamacConfig* self,
                                       gboolean value);
VALA_EXTERN gboolean pamac_config_get_enable_flatpak (PamacConfig* self);
VALA_EXTERN gboolean pamac_config_get_check_flatpak_updates (PamacConfig* self);
VALA_EXTERN void pamac_config_set_check_flatpak_updates (PamacConfig* self,
                                             gboolean value);
VALA_EXTERN const gchar* pamac_config_get_aur_build_dir (PamacConfig* self);
VALA_EXTERN gboolean pamac_config_get_check_aur_updates (PamacConfig* self);
VALA_EXTERN void pamac_config_set_check_aur_updates (PamacConfig* self,
                                         gboolean value);
VALA_EXTERN gboolean pamac_config_get_check_aur_vcs_updates (PamacConfig* self);
VALA_EXTERN void pamac_config_set_check_aur_vcs_updates (PamacConfig* self,
                                             gboolean value);
VALA_EXTERN gboolean pamac_config_get_offline_upgrade (PamacConfig* self);
VALA_EXTERN guint64 pamac_config_get_clean_keep_num_pkgs (PamacConfig* self);
VALA_EXTERN void pamac_config_set_clean_keep_num_pkgs (PamacConfig* self,
                                           guint64 value);
VALA_EXTERN gboolean pamac_config_get_clean_rm_only_uninstalled (PamacConfig* self);
VALA_EXTERN void pamac_config_set_clean_rm_only_uninstalled (PamacConfig* self,
                                                 gboolean value);
VALA_EXTERN GHashTable* pamac_config_get_ignorepkgs (PamacConfig* self);
VALA_EXTERN AlpmConfig* pamac_config_get_alpm_config (PamacConfig* self);
static void pamac_config_set_alpm_config (PamacConfig* self,
                                   AlpmConfig* value);
static GObject * pamac_config_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
VALA_EXTERN AlpmConfig* alpm_config_new (const gchar* path);
VALA_EXTERN AlpmConfig* alpm_config_construct (GType object_type,
                                   const gchar* path);
VALA_EXTERN PamacPluginLoader* pamac_plugin_loader_new (GType t_type,
                                            GBoxedCopyFunc t_dup_func,
                                            GDestroyNotify t_destroy_func,
                                            const gchar* name);
VALA_EXTERN PamacPluginLoader* pamac_plugin_loader_construct (GType object_type,
                                                  GType t_type,
                                                  GBoxedCopyFunc t_dup_func,
                                                  GDestroyNotify t_destroy_func,
                                                  const gchar* name);
VALA_EXTERN gboolean pamac_plugin_loader_load (PamacPluginLoader* self);
static void pamac_config_finalize (GObject * obj);
static GType pamac_config_get_type_once (void);
static void _vala_pamac_config_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_pamac_config_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
pamac_config_get_instance_private (PamacConfig* self)
{
	return G_STRUCT_MEMBER_P (self, PamacConfig_private_offset);
}

PamacConfig*
pamac_config_construct (GType object_type,
                        const gchar* conf_path)
{
	PamacConfig * self = NULL;
	g_return_val_if_fail (conf_path != NULL, NULL);
	self = (PamacConfig*) g_object_new (object_type, "conf-path", conf_path, NULL);
	return self;
}

PamacConfig*
pamac_config_new (const gchar* conf_path)
{
	return pamac_config_construct (PAMAC_TYPE_CONFIG, conf_path);
}

void
pamac_config_reload (PamacConfig* self)
{
	const gchar* _tmp0_;
	guint64 _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	pamac_config_set_enable_appstream (self, TRUE);
	pamac_config_set_enable_snap (self, FALSE);
	pamac_config_set_enable_flatpak (self, FALSE);
	pamac_config_set_aur_build_dir (self, "/var/tmp");
	pamac_config_set_max_parallel_downloads (self, (guint64) 1);
	pamac_config_set_offline_upgrade (self, FALSE);
	_tmp0_ = self->priv->_conf_path;
	pamac_config_parse_file (self, _tmp0_);
	_tmp1_ = self->priv->_max_parallel_downloads;
	if (_tmp1_ > ((guint64) 10)) {
		pamac_config_set_max_parallel_downloads (self, (guint64) 10);
	}
	_tmp2_ = self->priv->_support_appstream;
	if (!_tmp2_) {
		pamac_config_set_enable_appstream (self, FALSE);
	}
	_tmp3_ = self->priv->_support_snap;
	if (!_tmp3_) {
		pamac_config_set_enable_snap (self, FALSE);
	}
	_tmp4_ = self->priv->_support_flatpak;
	if (!_tmp4_) {
		pamac_config_set_enable_flatpak (self, FALSE);
	}
}

PamacAURPlugin*
pamac_config_get_aur_plugin (PamacConfig* self)
{
	gboolean _tmp0_;
	PamacAURPlugin* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_support_aur;
	if (_tmp0_) {
		PamacPluginLoader* _tmp1_;
		gpointer _tmp2_;
		_tmp1_ = self->priv->aur_plugin_loader;
		_tmp2_ = pamac_plugin_loader_get_plugin (_tmp1_);
		result = (PamacAURPlugin*) _tmp2_;
		return result;
	}
	result = NULL;
	return result;
}

PamacAppstreamPlugin*
pamac_config_get_appstream_plugin (PamacConfig* self)
{
	gboolean _tmp0_;
	PamacAppstreamPlugin* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_support_appstream;
	if (_tmp0_) {
		PamacPluginLoader* _tmp1_;
		gpointer _tmp2_;
		_tmp1_ = self->priv->appstream_plugin_loader;
		_tmp2_ = pamac_plugin_loader_get_plugin (_tmp1_);
		result = (PamacAppstreamPlugin*) _tmp2_;
		return result;
	}
	result = NULL;
	return result;
}

PamacSnapPlugin*
pamac_config_get_snap_plugin (PamacConfig* self)
{
	gboolean _tmp0_;
	PamacSnapPlugin* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_support_snap;
	if (_tmp0_) {
		PamacPluginLoader* _tmp1_;
		gpointer _tmp2_;
		_tmp1_ = self->priv->snap_plugin_loader;
		_tmp2_ = pamac_plugin_loader_get_plugin (_tmp1_);
		result = (PamacSnapPlugin*) _tmp2_;
		return result;
	}
	result = NULL;
	return result;
}

PamacFlatpakPlugin*
pamac_config_get_flatpak_plugin (PamacConfig* self)
{
	gboolean _tmp0_;
	PamacFlatpakPlugin* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_support_flatpak;
	if (_tmp0_) {
		PamacPluginLoader* _tmp1_;
		gpointer _tmp2_;
		_tmp1_ = self->priv->flatpak_plugin_loader;
		_tmp2_ = pamac_plugin_loader_get_plugin (_tmp1_);
		result = (PamacFlatpakPlugin*) _tmp2_;
		return result;
	}
	result = NULL;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static guint64
uint64_parse (const gchar* str,
              guint _base)
{
	guint64 result;
	g_return_val_if_fail (str != NULL, 0ULL);
	result = g_ascii_strtoull (str, NULL, _base);
	return result;
}

static void
pamac_config_parse_file (PamacConfig* self,
                         const gchar* path)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = g_file_new_for_path (path);
	file = _tmp0_;
	_tmp1_ = file;
	if (g_file_query_exists (_tmp1_, NULL)) {
		{
			GFileInputStream* _tmp2_ = NULL;
			GFile* _tmp3_;
			GFileInputStream* _tmp4_;
			GDataInputStream* dis = NULL;
			GDataInputStream* _tmp5_;
			gchar* line = NULL;
			_tmp3_ = file;
			_tmp4_ = g_file_read (_tmp3_, NULL, &_inner_error0_);
			_tmp2_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = g_data_input_stream_new ((GInputStream*) _tmp2_);
			dis = _tmp5_;
			while (TRUE) {
				gchar* _tmp6_ = NULL;
				GDataInputStream* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gchar** splitted = NULL;
				const gchar* _tmp14_;
				gchar** _tmp15_;
				gchar** _tmp16_;
				gint splitted_length1;
				gint _splitted_size_;
				gchar** _tmp17_;
				gint _tmp17__length1;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				const gchar* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				const gchar* _tmp23_;
				gchar** _tmp24_;
				gchar** _tmp25_;
				const gchar* key = NULL;
				gchar** _tmp26_;
				gint _tmp26__length1;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				_tmp7_ = dis;
				_tmp8_ = g_data_input_stream_read_line (_tmp7_, NULL, NULL, &_inner_error0_);
				_tmp6_ = _tmp8_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (line);
					_g_object_unref0 (dis);
					_g_object_unref0 (_tmp2_);
					goto __catch0_g_error;
				}
				_tmp9_ = _tmp6_;
				_tmp6_ = NULL;
				_g_free0 (line);
				line = _tmp9_;
				_tmp10_ = line;
				if (!(_tmp10_ != NULL)) {
					_g_free0 (_tmp6_);
					break;
				}
				_tmp11_ = line;
				_tmp12_ = strlen (_tmp11_);
				_tmp13_ = _tmp12_;
				if (_tmp13_ == 0) {
					_g_free0 (_tmp6_);
					continue;
				}
				_tmp14_ = line;
				_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, "#", 2);
				splitted = _tmp16_;
				splitted_length1 = _vala_array_length (_tmp15_);
				_splitted_size_ = splitted_length1;
				_tmp17_ = splitted;
				_tmp17__length1 = splitted_length1;
				_tmp18_ = _tmp17_[0];
				_tmp19_ = string_strip (_tmp18_);
				_g_free0 (line);
				line = _tmp19_;
				_tmp20_ = line;
				_tmp21_ = strlen (_tmp20_);
				_tmp22_ = _tmp21_;
				if (_tmp22_ == 0) {
					splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_tmp6_);
					continue;
				}
				_tmp23_ = line;
				_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, "=", 2);
				splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
				splitted = _tmp25_;
				splitted_length1 = _vala_array_length (_tmp24_);
				_splitted_size_ = splitted_length1;
				_tmp26_ = splitted;
				_tmp26__length1 = splitted_length1;
				_tmp27_ = _tmp26_[0];
				_tmp28_ = g_strstrip (_tmp27_);
				key = _tmp28_;
				_tmp29_ = key;
				if (g_strcmp0 (_tmp29_, "BuildDirectory") == 0) {
					gchar** _tmp30_;
					gint _tmp30__length1;
					_tmp30_ = splitted;
					_tmp30__length1 = splitted_length1;
					if (_tmp30__length1 == 2) {
						gchar** _tmp31_;
						gint _tmp31__length1;
						const gchar* _tmp32_;
						const gchar* _tmp33_;
						_tmp31_ = splitted;
						_tmp31__length1 = splitted_length1;
						_tmp32_ = _tmp31_[1];
						_tmp33_ = g_strstrip (_tmp32_);
						pamac_config_set_aur_build_dir (self, _tmp33_);
					}
				} else {
					const gchar* _tmp34_;
					_tmp34_ = key;
					if (g_strcmp0 (_tmp34_, "EnableSnap") == 0) {
						pamac_config_set_enable_snap (self, TRUE);
					} else {
						const gchar* _tmp35_;
						_tmp35_ = key;
						if (g_strcmp0 (_tmp35_, "EnableFlatpak") == 0) {
							pamac_config_set_enable_flatpak (self, TRUE);
						} else {
							const gchar* _tmp36_;
							_tmp36_ = key;
							if (g_strcmp0 (_tmp36_, "OfflineUpgrade") == 0) {
								pamac_config_set_offline_upgrade (self, TRUE);
							} else {
								const gchar* _tmp37_;
								_tmp37_ = key;
								if (g_strcmp0 (_tmp37_, "MaxParallelDownloads") == 0) {
									gchar** _tmp38_;
									gint _tmp38__length1;
									_tmp38_ = splitted;
									_tmp38__length1 = splitted_length1;
									if (_tmp38__length1 == 2) {
										const gchar* val = NULL;
										gchar** _tmp39_;
										gint _tmp39__length1;
										const gchar* _tmp40_;
										const gchar* _tmp41_;
										const gchar* _tmp42_;
										_tmp39_ = splitted;
										_tmp39__length1 = splitted_length1;
										_tmp40_ = _tmp39_[1];
										_tmp41_ = g_strstrip (_tmp40_);
										val = _tmp41_;
										_tmp42_ = val;
										pamac_config_set_max_parallel_downloads (self, uint64_parse (_tmp42_, (guint) 0));
									}
								}
							}
						}
					}
				}
				splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_tmp6_);
			}
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp2_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp43_;
			const gchar* _tmp44_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp43_ = e;
			_tmp44_ = _tmp43_->message;
			g_warning ("pamac_config_daemon.vala:173: parse_file: %s", _tmp44_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		g_warning ("pamac_config_daemon.vala:176: File '%s' doesn't exist.", path);
	}
	_g_object_unref0 (file);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

void
pamac_config_write (PamacConfig* self,
                    GHashTable* new_conf)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GString* data = NULL;
	GString* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_conf != NULL);
	_tmp0_ = self->priv->_conf_path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	_tmp2_ = g_string_new ("");
	data = _tmp2_;
	_tmp3_ = file;
	if (g_file_query_exists (_tmp3_, NULL)) {
		{
			GFileInputStream* _tmp4_ = NULL;
			GFile* _tmp5_;
			GFileInputStream* _tmp6_;
			GDataInputStream* dis = NULL;
			GDataInputStream* _tmp7_;
			gchar* line = NULL;
			GFile* _tmp187_;
			_tmp5_ = file;
			_tmp6_ = g_file_read (_tmp5_, NULL, &_inner_error0_);
			_tmp4_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp7_ = g_data_input_stream_new ((GInputStream*) _tmp4_);
			dis = _tmp7_;
			while (TRUE) {
				gchar* _tmp8_ = NULL;
				GDataInputStream* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				GVariant* variant = NULL;
				const gchar* _tmp17_;
				_tmp9_ = dis;
				_tmp10_ = g_data_input_stream_read_line (_tmp9_, NULL, NULL, &_inner_error0_);
				_tmp8_ = _tmp10_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (line);
					_g_object_unref0 (dis);
					_g_object_unref0 (_tmp4_);
					goto __catch0_g_error;
				}
				_tmp11_ = _tmp8_;
				_tmp8_ = NULL;
				_g_free0 (line);
				line = _tmp11_;
				_tmp12_ = line;
				if (!(_tmp12_ != NULL)) {
					_g_free0 (_tmp8_);
					break;
				}
				_tmp13_ = line;
				_tmp14_ = strlen (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_ == 0) {
					GString* _tmp16_;
					_tmp16_ = data;
					g_string_append (_tmp16_, "\n");
					_g_free0 (_tmp8_);
					continue;
				}
				_tmp17_ = line;
				if (string_contains (_tmp17_, "RemoveUnrequiredDeps")) {
					gconstpointer _tmp18_ = NULL;
					gboolean _tmp19_;
					_tmp19_ = g_hash_table_lookup_extended (new_conf, "RemoveUnrequiredDeps", NULL, &_tmp18_);
					variant = (GVariant*) _tmp18_;
					if (_tmp19_) {
						GVariant* _tmp20_;
						_tmp20_ = variant;
						if (g_variant_get_boolean (_tmp20_)) {
							GString* _tmp21_;
							_tmp21_ = data;
							g_string_append (_tmp21_, "RemoveUnrequiredDeps\n");
						} else {
							GString* _tmp22_;
							_tmp22_ = data;
							g_string_append (_tmp22_, "#RemoveUnrequiredDeps\n");
						}
						g_hash_table_remove (new_conf, "RemoveUnrequiredDeps");
					} else {
						GString* _tmp23_;
						const gchar* _tmp24_;
						GString* _tmp25_;
						_tmp23_ = data;
						_tmp24_ = line;
						g_string_append (_tmp23_, _tmp24_);
						_tmp25_ = data;
						g_string_append (_tmp25_, "\n");
					}
				} else {
					const gchar* _tmp26_;
					_tmp26_ = line;
					if (string_contains (_tmp26_, "EnableDowngrade")) {
						gconstpointer _tmp27_ = NULL;
						gboolean _tmp28_;
						_tmp28_ = g_hash_table_lookup_extended (new_conf, "EnableDowngrade", NULL, &_tmp27_);
						variant = (GVariant*) _tmp27_;
						if (_tmp28_) {
							GVariant* _tmp29_;
							_tmp29_ = variant;
							if (g_variant_get_boolean (_tmp29_)) {
								GString* _tmp30_;
								_tmp30_ = data;
								g_string_append (_tmp30_, "EnableDowngrade\n");
							} else {
								GString* _tmp31_;
								_tmp31_ = data;
								g_string_append (_tmp31_, "#EnableDowngrade\n");
							}
							g_hash_table_remove (new_conf, "EnableDowngrade");
						} else {
							GString* _tmp32_;
							const gchar* _tmp33_;
							GString* _tmp34_;
							_tmp32_ = data;
							_tmp33_ = line;
							g_string_append (_tmp32_, _tmp33_);
							_tmp34_ = data;
							g_string_append (_tmp34_, "\n");
						}
					} else {
						const gchar* _tmp35_;
						_tmp35_ = line;
						if (string_contains (_tmp35_, "SimpleInstall")) {
							gconstpointer _tmp36_ = NULL;
							gboolean _tmp37_;
							_tmp37_ = g_hash_table_lookup_extended (new_conf, "SimpleInstall", NULL, &_tmp36_);
							variant = (GVariant*) _tmp36_;
							if (_tmp37_) {
								GVariant* _tmp38_;
								_tmp38_ = variant;
								if (g_variant_get_boolean (_tmp38_)) {
									GString* _tmp39_;
									_tmp39_ = data;
									g_string_append (_tmp39_, "SimpleInstall\n");
								} else {
									GString* _tmp40_;
									_tmp40_ = data;
									g_string_append (_tmp40_, "#SimpleInstall\n");
								}
								g_hash_table_remove (new_conf, "SimpleInstall");
							} else {
								GString* _tmp41_;
								const gchar* _tmp42_;
								GString* _tmp43_;
								_tmp41_ = data;
								_tmp42_ = line;
								g_string_append (_tmp41_, _tmp42_);
								_tmp43_ = data;
								g_string_append (_tmp43_, "\n");
							}
						} else {
							const gchar* _tmp44_;
							_tmp44_ = line;
							if (string_contains (_tmp44_, "RefreshPeriod")) {
								gconstpointer _tmp45_ = NULL;
								gboolean _tmp46_;
								_tmp46_ = g_hash_table_lookup_extended (new_conf, "RefreshPeriod", NULL, &_tmp45_);
								variant = (GVariant*) _tmp45_;
								if (_tmp46_) {
									GString* _tmp47_;
									GVariant* _tmp48_;
									gchar* _tmp49_;
									gchar* _tmp50_;
									_tmp47_ = data;
									_tmp48_ = variant;
									_tmp49_ = g_strdup_printf ("RefreshPeriod = %llu\n", g_variant_get_uint64 (_tmp48_));
									_tmp50_ = _tmp49_;
									g_string_append (_tmp47_, _tmp50_);
									_g_free0 (_tmp50_);
									g_hash_table_remove (new_conf, "RefreshPeriod");
								} else {
									GString* _tmp51_;
									const gchar* _tmp52_;
									GString* _tmp53_;
									_tmp51_ = data;
									_tmp52_ = line;
									g_string_append (_tmp51_, _tmp52_);
									_tmp53_ = data;
									g_string_append (_tmp53_, "\n");
								}
							} else {
								const gchar* _tmp54_;
								_tmp54_ = line;
								if (string_contains (_tmp54_, "KeepNumPackages")) {
									gconstpointer _tmp55_ = NULL;
									gboolean _tmp56_;
									_tmp56_ = g_hash_table_lookup_extended (new_conf, "KeepNumPackages", NULL, &_tmp55_);
									variant = (GVariant*) _tmp55_;
									if (_tmp56_) {
										GString* _tmp57_;
										GVariant* _tmp58_;
										gchar* _tmp59_;
										gchar* _tmp60_;
										_tmp57_ = data;
										_tmp58_ = variant;
										_tmp59_ = g_strdup_printf ("KeepNumPackages = %llu\n", g_variant_get_uint64 (_tmp58_));
										_tmp60_ = _tmp59_;
										g_string_append (_tmp57_, _tmp60_);
										_g_free0 (_tmp60_);
										g_hash_table_remove (new_conf, "KeepNumPackages");
									} else {
										GString* _tmp61_;
										const gchar* _tmp62_;
										GString* _tmp63_;
										_tmp61_ = data;
										_tmp62_ = line;
										g_string_append (_tmp61_, _tmp62_);
										_tmp63_ = data;
										g_string_append (_tmp63_, "\n");
									}
								} else {
									const gchar* _tmp64_;
									_tmp64_ = line;
									if (string_contains (_tmp64_, "OnlyRmUninstalled")) {
										gconstpointer _tmp65_ = NULL;
										gboolean _tmp66_;
										_tmp66_ = g_hash_table_lookup_extended (new_conf, "OnlyRmUninstalled", NULL, &_tmp65_);
										variant = (GVariant*) _tmp65_;
										if (_tmp66_) {
											GVariant* _tmp67_;
											_tmp67_ = variant;
											if (g_variant_get_boolean (_tmp67_)) {
												GString* _tmp68_;
												_tmp68_ = data;
												g_string_append (_tmp68_, "OnlyRmUninstalled\n");
											} else {
												GString* _tmp69_;
												_tmp69_ = data;
												g_string_append (_tmp69_, "#OnlyRmUninstalled\n");
											}
											g_hash_table_remove (new_conf, "OnlyRmUninstalled");
										} else {
											GString* _tmp70_;
											const gchar* _tmp71_;
											GString* _tmp72_;
											_tmp70_ = data;
											_tmp71_ = line;
											g_string_append (_tmp70_, _tmp71_);
											_tmp72_ = data;
											g_string_append (_tmp72_, "\n");
										}
									} else {
										const gchar* _tmp73_;
										_tmp73_ = line;
										if (string_contains (_tmp73_, "NoUpdateHideIcon")) {
											gconstpointer _tmp74_ = NULL;
											gboolean _tmp75_;
											_tmp75_ = g_hash_table_lookup_extended (new_conf, "NoUpdateHideIcon", NULL, &_tmp74_);
											variant = (GVariant*) _tmp74_;
											if (_tmp75_) {
												GVariant* _tmp76_;
												_tmp76_ = variant;
												if (g_variant_get_boolean (_tmp76_)) {
													GString* _tmp77_;
													_tmp77_ = data;
													g_string_append (_tmp77_, "NoUpdateHideIcon\n");
												} else {
													GString* _tmp78_;
													_tmp78_ = data;
													g_string_append (_tmp78_, "#NoUpdateHideIcon\n");
												}
												g_hash_table_remove (new_conf, "NoUpdateHideIcon");
											} else {
												GString* _tmp79_;
												const gchar* _tmp80_;
												GString* _tmp81_;
												_tmp79_ = data;
												_tmp80_ = line;
												g_string_append (_tmp79_, _tmp80_);
												_tmp81_ = data;
												g_string_append (_tmp81_, "\n");
											}
										} else {
											const gchar* _tmp82_;
											_tmp82_ = line;
											if (string_contains (_tmp82_, "EnableAUR")) {
												gconstpointer _tmp83_ = NULL;
												gboolean _tmp84_;
												_tmp84_ = g_hash_table_lookup_extended (new_conf, "EnableAUR", NULL, &_tmp83_);
												variant = (GVariant*) _tmp83_;
												if (_tmp84_) {
													GVariant* _tmp85_;
													_tmp85_ = variant;
													if (g_variant_get_boolean (_tmp85_)) {
														GString* _tmp86_;
														_tmp86_ = data;
														g_string_append (_tmp86_, "EnableAUR\n");
													} else {
														GString* _tmp87_;
														_tmp87_ = data;
														g_string_append (_tmp87_, "#EnableAUR\n");
													}
													g_hash_table_remove (new_conf, "EnableAUR");
												} else {
													GString* _tmp88_;
													const gchar* _tmp89_;
													GString* _tmp90_;
													_tmp88_ = data;
													_tmp89_ = line;
													g_string_append (_tmp88_, _tmp89_);
													_tmp90_ = data;
													g_string_append (_tmp90_, "\n");
												}
											} else {
												const gchar* _tmp91_;
												_tmp91_ = line;
												if (string_contains (_tmp91_, "KeepBuiltPkgs")) {
													gconstpointer _tmp92_ = NULL;
													gboolean _tmp93_;
													_tmp93_ = g_hash_table_lookup_extended (new_conf, "KeepBuiltPkgs", NULL, &_tmp92_);
													variant = (GVariant*) _tmp92_;
													if (_tmp93_) {
														GVariant* _tmp94_;
														_tmp94_ = variant;
														if (g_variant_get_boolean (_tmp94_)) {
															GString* _tmp95_;
															_tmp95_ = data;
															g_string_append (_tmp95_, "KeepBuiltPkgs\n");
														} else {
															GString* _tmp96_;
															_tmp96_ = data;
															g_string_append (_tmp96_, "#KeepBuiltPkgs\n");
														}
														g_hash_table_remove (new_conf, "KeepBuiltPkgs");
													} else {
														GString* _tmp97_;
														const gchar* _tmp98_;
														GString* _tmp99_;
														_tmp97_ = data;
														_tmp98_ = line;
														g_string_append (_tmp97_, _tmp98_);
														_tmp99_ = data;
														g_string_append (_tmp99_, "\n");
													}
												} else {
													const gchar* _tmp100_;
													_tmp100_ = line;
													if (string_contains (_tmp100_, "EnableSnap")) {
														gconstpointer _tmp101_ = NULL;
														gboolean _tmp102_;
														_tmp102_ = g_hash_table_lookup_extended (new_conf, "EnableSnap", NULL, &_tmp101_);
														variant = (GVariant*) _tmp101_;
														if (_tmp102_) {
															GVariant* _tmp103_;
															_tmp103_ = variant;
															if (g_variant_get_boolean (_tmp103_)) {
																GString* _tmp104_;
																_tmp104_ = data;
																g_string_append (_tmp104_, "EnableSnap\n");
															} else {
																GString* _tmp105_;
																_tmp105_ = data;
																g_string_append (_tmp105_, "#EnableSnap\n");
															}
															g_hash_table_remove (new_conf, "EnableSnap");
														} else {
															GString* _tmp106_;
															const gchar* _tmp107_;
															GString* _tmp108_;
															_tmp106_ = data;
															_tmp107_ = line;
															g_string_append (_tmp106_, _tmp107_);
															_tmp108_ = data;
															g_string_append (_tmp108_, "\n");
														}
													} else {
														const gchar* _tmp109_;
														_tmp109_ = line;
														if (string_contains (_tmp109_, "EnableFlatpak")) {
															gconstpointer _tmp110_ = NULL;
															gboolean _tmp111_;
															_tmp111_ = g_hash_table_lookup_extended (new_conf, "EnableFlatpak", NULL, &_tmp110_);
															variant = (GVariant*) _tmp110_;
															if (_tmp111_) {
																GVariant* _tmp112_;
																_tmp112_ = variant;
																if (g_variant_get_boolean (_tmp112_)) {
																	GString* _tmp113_;
																	_tmp113_ = data;
																	g_string_append (_tmp113_, "EnableFlatpak\n");
																} else {
																	GString* _tmp114_;
																	_tmp114_ = data;
																	g_string_append (_tmp114_, "#EnableFlatpak\n");
																}
																g_hash_table_remove (new_conf, "EnableFlatpak");
															} else {
																GString* _tmp115_;
																const gchar* _tmp116_;
																GString* _tmp117_;
																_tmp115_ = data;
																_tmp116_ = line;
																g_string_append (_tmp115_, _tmp116_);
																_tmp117_ = data;
																g_string_append (_tmp117_, "\n");
															}
														} else {
															const gchar* _tmp118_;
															_tmp118_ = line;
															if (string_contains (_tmp118_, "CheckFlatpakUpdates")) {
																gconstpointer _tmp119_ = NULL;
																gboolean _tmp120_;
																_tmp120_ = g_hash_table_lookup_extended (new_conf, "CheckFlatpakUpdates", NULL, &_tmp119_);
																variant = (GVariant*) _tmp119_;
																if (_tmp120_) {
																	GVariant* _tmp121_;
																	_tmp121_ = variant;
																	if (g_variant_get_boolean (_tmp121_)) {
																		GString* _tmp122_;
																		_tmp122_ = data;
																		g_string_append (_tmp122_, "CheckFlatpakUpdates\n");
																	} else {
																		GString* _tmp123_;
																		_tmp123_ = data;
																		g_string_append (_tmp123_, "#CheckFlatpakUpdates\n");
																	}
																	g_hash_table_remove (new_conf, "CheckFlatpakUpdates");
																} else {
																	GString* _tmp124_;
																	const gchar* _tmp125_;
																	GString* _tmp126_;
																	_tmp124_ = data;
																	_tmp125_ = line;
																	g_string_append (_tmp124_, _tmp125_);
																	_tmp126_ = data;
																	g_string_append (_tmp126_, "\n");
																}
															} else {
																const gchar* _tmp127_;
																_tmp127_ = line;
																if (string_contains (_tmp127_, "BuildDirectory")) {
																	gconstpointer _tmp128_ = NULL;
																	gboolean _tmp129_;
																	_tmp129_ = g_hash_table_lookup_extended (new_conf, "BuildDirectory", NULL, &_tmp128_);
																	variant = (GVariant*) _tmp128_;
																	if (_tmp129_) {
																		GString* _tmp130_;
																		GVariant* _tmp131_;
																		const gchar* _tmp132_;
																		gchar* _tmp133_;
																		gchar* _tmp134_;
																		_tmp130_ = data;
																		_tmp131_ = variant;
																		_tmp132_ = g_variant_get_string (_tmp131_, NULL);
																		_tmp133_ = g_strdup_printf ("BuildDirectory = %s\n", _tmp132_);
																		_tmp134_ = _tmp133_;
																		g_string_append (_tmp130_, _tmp134_);
																		_g_free0 (_tmp134_);
																		g_hash_table_remove (new_conf, "BuildDirectory");
																	} else {
																		GString* _tmp135_;
																		const gchar* _tmp136_;
																		GString* _tmp137_;
																		_tmp135_ = data;
																		_tmp136_ = line;
																		g_string_append (_tmp135_, _tmp136_);
																		_tmp137_ = data;
																		g_string_append (_tmp137_, "\n");
																	}
																} else {
																	const gchar* _tmp138_;
																	_tmp138_ = line;
																	if (string_contains (_tmp138_, "CheckAURUpdates")) {
																		gconstpointer _tmp139_ = NULL;
																		gboolean _tmp140_;
																		_tmp140_ = g_hash_table_lookup_extended (new_conf, "CheckAURUpdates", NULL, &_tmp139_);
																		variant = (GVariant*) _tmp139_;
																		if (_tmp140_) {
																			GVariant* _tmp141_;
																			_tmp141_ = variant;
																			if (g_variant_get_boolean (_tmp141_)) {
																				GString* _tmp142_;
																				_tmp142_ = data;
																				g_string_append (_tmp142_, "CheckAURUpdates\n");
																			} else {
																				GString* _tmp143_;
																				_tmp143_ = data;
																				g_string_append (_tmp143_, "#CheckAURUpdates\n");
																			}
																			g_hash_table_remove (new_conf, "CheckAURUpdates");
																		} else {
																			GString* _tmp144_;
																			const gchar* _tmp145_;
																			GString* _tmp146_;
																			_tmp144_ = data;
																			_tmp145_ = line;
																			g_string_append (_tmp144_, _tmp145_);
																			_tmp146_ = data;
																			g_string_append (_tmp146_, "\n");
																		}
																	} else {
																		const gchar* _tmp147_;
																		_tmp147_ = line;
																		if (string_contains (_tmp147_, "CheckAURVCSUpdates")) {
																			gconstpointer _tmp148_ = NULL;
																			gboolean _tmp149_;
																			_tmp149_ = g_hash_table_lookup_extended (new_conf, "CheckAURVCSUpdates", NULL, &_tmp148_);
																			variant = (GVariant*) _tmp148_;
																			if (_tmp149_) {
																				GVariant* _tmp150_;
																				_tmp150_ = variant;
																				if (g_variant_get_boolean (_tmp150_)) {
																					GString* _tmp151_;
																					_tmp151_ = data;
																					g_string_append (_tmp151_, "CheckAURVCSUpdates\n");
																				} else {
																					GString* _tmp152_;
																					_tmp152_ = data;
																					g_string_append (_tmp152_, "#CheckAURVCSUpdates\n");
																				}
																				g_hash_table_remove (new_conf, "CheckAURVCSUpdates");
																			} else {
																				GString* _tmp153_;
																				const gchar* _tmp154_;
																				GString* _tmp155_;
																				_tmp153_ = data;
																				_tmp154_ = line;
																				g_string_append (_tmp153_, _tmp154_);
																				_tmp155_ = data;
																				g_string_append (_tmp155_, "\n");
																			}
																		} else {
																			const gchar* _tmp156_;
																			_tmp156_ = line;
																			if (string_contains (_tmp156_, "DownloadUpdates")) {
																				gconstpointer _tmp157_ = NULL;
																				gboolean _tmp158_;
																				_tmp158_ = g_hash_table_lookup_extended (new_conf, "DownloadUpdates", NULL, &_tmp157_);
																				variant = (GVariant*) _tmp157_;
																				if (_tmp158_) {
																					GVariant* _tmp159_;
																					_tmp159_ = variant;
																					if (g_variant_get_boolean (_tmp159_)) {
																						GString* _tmp160_;
																						_tmp160_ = data;
																						g_string_append (_tmp160_, "DownloadUpdates\n");
																					} else {
																						GString* _tmp161_;
																						_tmp161_ = data;
																						g_string_append (_tmp161_, "#DownloadUpdates\n");
																					}
																					g_hash_table_remove (new_conf, "DownloadUpdates");
																				} else {
																					GString* _tmp162_;
																					const gchar* _tmp163_;
																					GString* _tmp164_;
																					_tmp162_ = data;
																					_tmp163_ = line;
																					g_string_append (_tmp162_, _tmp163_);
																					_tmp164_ = data;
																					g_string_append (_tmp164_, "\n");
																				}
																			} else {
																				const gchar* _tmp165_;
																				_tmp165_ = line;
																				if (string_contains (_tmp165_, "OfflineUpgrade")) {
																					gconstpointer _tmp166_ = NULL;
																					gboolean _tmp167_;
																					_tmp167_ = g_hash_table_lookup_extended (new_conf, "OfflineUpgrade", NULL, &_tmp166_);
																					variant = (GVariant*) _tmp166_;
																					if (_tmp167_) {
																						GVariant* _tmp168_;
																						_tmp168_ = variant;
																						if (g_variant_get_boolean (_tmp168_)) {
																							GString* _tmp169_;
																							_tmp169_ = data;
																							g_string_append (_tmp169_, "OfflineUpgrade\n");
																						} else {
																							GString* _tmp170_;
																							_tmp170_ = data;
																							g_string_append (_tmp170_, "#OfflineUpgrade\n");
																						}
																						g_hash_table_remove (new_conf, "OfflineUpgrade");
																					} else {
																						GString* _tmp171_;
																						const gchar* _tmp172_;
																						GString* _tmp173_;
																						_tmp171_ = data;
																						_tmp172_ = line;
																						g_string_append (_tmp171_, _tmp172_);
																						_tmp173_ = data;
																						g_string_append (_tmp173_, "\n");
																					}
																				} else {
																					const gchar* _tmp174_;
																					_tmp174_ = line;
																					if (string_contains (_tmp174_, "MaxParallelDownloads")) {
																						gconstpointer _tmp175_ = NULL;
																						gboolean _tmp176_;
																						_tmp176_ = g_hash_table_lookup_extended (new_conf, "MaxParallelDownloads", NULL, &_tmp175_);
																						variant = (GVariant*) _tmp175_;
																						if (_tmp176_) {
																							GString* _tmp177_;
																							GVariant* _tmp178_;
																							gchar* _tmp179_;
																							gchar* _tmp180_;
																							_tmp177_ = data;
																							_tmp178_ = variant;
																							_tmp179_ = g_strdup_printf ("MaxParallelDownloads = %llu\n", g_variant_get_uint64 (_tmp178_));
																							_tmp180_ = _tmp179_;
																							g_string_append (_tmp177_, _tmp180_);
																							_g_free0 (_tmp180_);
																							g_hash_table_remove (new_conf, "MaxParallelDownloads");
																						} else {
																							GString* _tmp181_;
																							const gchar* _tmp182_;
																							GString* _tmp183_;
																							_tmp181_ = data;
																							_tmp182_ = line;
																							g_string_append (_tmp181_, _tmp182_);
																							_tmp183_ = data;
																							g_string_append (_tmp183_, "\n");
																						}
																					} else {
																						GString* _tmp184_;
																						const gchar* _tmp185_;
																						GString* _tmp186_;
																						_tmp184_ = data;
																						_tmp185_ = line;
																						g_string_append (_tmp184_, _tmp185_);
																						_tmp186_ = data;
																						g_string_append (_tmp186_, "\n");
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
				_g_free0 (_tmp8_);
			}
			_tmp187_ = file;
			g_file_delete (_tmp187_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (dis);
				_g_object_unref0 (_tmp4_);
				goto __catch0_g_error;
			}
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp4_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp188_;
			const gchar* _tmp189_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp188_ = e;
			_tmp189_ = _tmp188_->message;
			g_warning ("pamac_config_daemon.vala:404: %s", _tmp189_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_string_free0 (data);
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		const gchar* _tmp190_;
		_tmp190_ = self->priv->_conf_path;
		g_warning ("pamac_config_daemon.vala:407: File '%s' doesn't exist", _tmp190_);
	}
	if (g_hash_table_size (new_conf) != ((guint) 0)) {
		GString* _tmp191_;
		GHashTableIter iter = {0};
		const gchar* key = NULL;
		GVariant* val = NULL;
		_tmp191_ = data;
		g_string_append (_tmp191_, "\n");
		g_hash_table_iter_init (&iter, new_conf);
		while (TRUE) {
			gconstpointer _tmp192_ = NULL;
			gconstpointer _tmp193_ = NULL;
			gboolean _tmp194_;
			const gchar* _tmp195_;
			_tmp194_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp192_), (gpointer*) (&_tmp193_));
			key = (const gchar*) _tmp192_;
			val = (GVariant*) _tmp193_;
			if (!_tmp194_) {
				break;
			}
			_tmp195_ = key;
			if (g_strcmp0 (_tmp195_, "RemoveUnrequiredDeps") == 0) {
				GVariant* _tmp196_;
				_tmp196_ = val;
				if (g_variant_get_boolean (_tmp196_)) {
					GString* _tmp197_;
					_tmp197_ = data;
					g_string_append (_tmp197_, "RemoveUnrequiredDeps\n\n");
				} else {
					GString* _tmp198_;
					_tmp198_ = data;
					g_string_append (_tmp198_, "#RemoveUnrequiredDeps\n\n");
				}
			} else {
				const gchar* _tmp199_;
				_tmp199_ = key;
				if (g_strcmp0 (_tmp199_, "EnableDowngrade") == 0) {
					GVariant* _tmp200_;
					_tmp200_ = val;
					if (g_variant_get_boolean (_tmp200_)) {
						GString* _tmp201_;
						_tmp201_ = data;
						g_string_append (_tmp201_, "EnableDowngrade\n\n");
					} else {
						GString* _tmp202_;
						_tmp202_ = data;
						g_string_append (_tmp202_, "#EnableDowngrade\n\n");
					}
				} else {
					const gchar* _tmp203_;
					_tmp203_ = key;
					if (g_strcmp0 (_tmp203_, "SimpleInstall") == 0) {
						GVariant* _tmp204_;
						_tmp204_ = val;
						if (g_variant_get_boolean (_tmp204_)) {
							GString* _tmp205_;
							_tmp205_ = data;
							g_string_append (_tmp205_, "SimpleInstall\n\n");
						} else {
							GString* _tmp206_;
							_tmp206_ = data;
							g_string_append (_tmp206_, "#SimpleInstall\n\n");
						}
					} else {
						const gchar* _tmp207_;
						_tmp207_ = key;
						if (g_strcmp0 (_tmp207_, "RefreshPeriod") == 0) {
							GString* _tmp208_;
							GVariant* _tmp209_;
							gchar* _tmp210_;
							gchar* _tmp211_;
							_tmp208_ = data;
							_tmp209_ = val;
							_tmp210_ = g_strdup_printf ("RefreshPeriod = %llu\n\n", g_variant_get_uint64 (_tmp209_));
							_tmp211_ = _tmp210_;
							g_string_append (_tmp208_, _tmp211_);
							_g_free0 (_tmp211_);
						} else {
							const gchar* _tmp212_;
							_tmp212_ = key;
							if (g_strcmp0 (_tmp212_, "KeepNumPackages") == 0) {
								GString* _tmp213_;
								GVariant* _tmp214_;
								gchar* _tmp215_;
								gchar* _tmp216_;
								_tmp213_ = data;
								_tmp214_ = val;
								_tmp215_ = g_strdup_printf ("KeepNumPackages = %llu\n\n", g_variant_get_uint64 (_tmp214_));
								_tmp216_ = _tmp215_;
								g_string_append (_tmp213_, _tmp216_);
								_g_free0 (_tmp216_);
							} else {
								const gchar* _tmp217_;
								_tmp217_ = key;
								if (g_strcmp0 (_tmp217_, "OnlyRmUninstalled") == 0) {
									GVariant* _tmp218_;
									_tmp218_ = val;
									if (g_variant_get_boolean (_tmp218_)) {
										GString* _tmp219_;
										_tmp219_ = data;
										g_string_append (_tmp219_, "OnlyRmUninstalled\n\n");
									} else {
										GString* _tmp220_;
										_tmp220_ = data;
										g_string_append (_tmp220_, "#OnlyRmUninstalled\n\n");
									}
								} else {
									const gchar* _tmp221_;
									_tmp221_ = key;
									if (g_strcmp0 (_tmp221_, "NoUpdateHideIcon") == 0) {
										GVariant* _tmp222_;
										_tmp222_ = val;
										if (g_variant_get_boolean (_tmp222_)) {
											GString* _tmp223_;
											_tmp223_ = data;
											g_string_append (_tmp223_, "NoUpdateHideIcon\n\n");
										} else {
											GString* _tmp224_;
											_tmp224_ = data;
											g_string_append (_tmp224_, "#NoUpdateHideIcon\n\n");
										}
									} else {
										const gchar* _tmp225_;
										_tmp225_ = key;
										if (g_strcmp0 (_tmp225_, "EnableAUR") == 0) {
											GVariant* _tmp226_;
											_tmp226_ = val;
											if (g_variant_get_boolean (_tmp226_)) {
												GString* _tmp227_;
												_tmp227_ = data;
												g_string_append (_tmp227_, "EnableAUR\n\n");
											} else {
												GString* _tmp228_;
												_tmp228_ = data;
												g_string_append (_tmp228_, "#EnableAUR\n\n");
											}
										} else {
											const gchar* _tmp229_;
											_tmp229_ = key;
											if (g_strcmp0 (_tmp229_, "KeepBuiltPkgs") == 0) {
												GVariant* _tmp230_;
												_tmp230_ = val;
												if (g_variant_get_boolean (_tmp230_)) {
													GString* _tmp231_;
													_tmp231_ = data;
													g_string_append (_tmp231_, "KeepBuiltPkgs\n\n");
												} else {
													GString* _tmp232_;
													_tmp232_ = data;
													g_string_append (_tmp232_, "#KeepBuiltPkgs\n\n");
												}
											} else {
												const gchar* _tmp233_;
												_tmp233_ = key;
												if (g_strcmp0 (_tmp233_, "EnableSnap") == 0) {
													GVariant* _tmp234_;
													_tmp234_ = val;
													if (g_variant_get_boolean (_tmp234_)) {
														GString* _tmp235_;
														_tmp235_ = data;
														g_string_append (_tmp235_, "EnableSnap\n\n");
													} else {
														GString* _tmp236_;
														_tmp236_ = data;
														g_string_append (_tmp236_, "#EnableSnap\n\n");
													}
												} else {
													const gchar* _tmp237_;
													_tmp237_ = key;
													if (g_strcmp0 (_tmp237_, "EnableFlatpak") == 0) {
														GVariant* _tmp238_;
														_tmp238_ = val;
														if (g_variant_get_boolean (_tmp238_)) {
															GString* _tmp239_;
															_tmp239_ = data;
															g_string_append (_tmp239_, "EnableFlatpak\n\n");
														} else {
															GString* _tmp240_;
															_tmp240_ = data;
															g_string_append (_tmp240_, "#EnableFlatpak\n\n");
														}
													} else {
														const gchar* _tmp241_;
														_tmp241_ = key;
														if (g_strcmp0 (_tmp241_, "CheckFlatpakUpdates") == 0) {
															GVariant* _tmp242_;
															_tmp242_ = val;
															if (g_variant_get_boolean (_tmp242_)) {
																GString* _tmp243_;
																_tmp243_ = data;
																g_string_append (_tmp243_, "CheckFlatpakUpdates\n\n");
															} else {
																GString* _tmp244_;
																_tmp244_ = data;
																g_string_append (_tmp244_, "#CheckFlatpakUpdates\n\n");
															}
														} else {
															const gchar* _tmp245_;
															_tmp245_ = key;
															if (g_strcmp0 (_tmp245_, "BuildDirectory") == 0) {
																GString* _tmp246_;
																GVariant* _tmp247_;
																const gchar* _tmp248_;
																gchar* _tmp249_;
																gchar* _tmp250_;
																_tmp246_ = data;
																_tmp247_ = val;
																_tmp248_ = g_variant_get_string (_tmp247_, NULL);
																_tmp249_ = g_strdup_printf ("BuildDirectory = %s\n\n", _tmp248_);
																_tmp250_ = _tmp249_;
																g_string_append (_tmp246_, _tmp250_);
																_g_free0 (_tmp250_);
															} else {
																const gchar* _tmp251_;
																_tmp251_ = key;
																if (g_strcmp0 (_tmp251_, "CheckAURUpdates") == 0) {
																	GVariant* _tmp252_;
																	_tmp252_ = val;
																	if (g_variant_get_boolean (_tmp252_)) {
																		GString* _tmp253_;
																		_tmp253_ = data;
																		g_string_append (_tmp253_, "CheckAURUpdates\n\n");
																	} else {
																		GString* _tmp254_;
																		_tmp254_ = data;
																		g_string_append (_tmp254_, "#CheckAURUpdates\n\n");
																	}
																} else {
																	const gchar* _tmp255_;
																	_tmp255_ = key;
																	if (g_strcmp0 (_tmp255_, "CheckAURVCSUpdates") == 0) {
																		GVariant* _tmp256_;
																		_tmp256_ = val;
																		if (g_variant_get_boolean (_tmp256_)) {
																			GString* _tmp257_;
																			_tmp257_ = data;
																			g_string_append (_tmp257_, "CheckAURVCSUpdates\n\n");
																		} else {
																			GString* _tmp258_;
																			_tmp258_ = data;
																			g_string_append (_tmp258_, "#CheckAURVCSUpdates\n\n");
																		}
																	} else {
																		const gchar* _tmp259_;
																		_tmp259_ = key;
																		if (g_strcmp0 (_tmp259_, "DownloadUpdates") == 0) {
																			GVariant* _tmp260_;
																			_tmp260_ = val;
																			if (g_variant_get_boolean (_tmp260_)) {
																				GString* _tmp261_;
																				_tmp261_ = data;
																				g_string_append (_tmp261_, "DownloadUpdates\n\n");
																			} else {
																				GString* _tmp262_;
																				_tmp262_ = data;
																				g_string_append (_tmp262_, "#DownloadUpdates\n\n");
																			}
																		} else {
																			const gchar* _tmp263_;
																			_tmp263_ = key;
																			if (g_strcmp0 (_tmp263_, "OfflineUpgrade") == 0) {
																				GVariant* _tmp264_;
																				_tmp264_ = val;
																				if (g_variant_get_boolean (_tmp264_)) {
																					GString* _tmp265_;
																					_tmp265_ = data;
																					g_string_append (_tmp265_, "OfflineUpgrade\n\n");
																				} else {
																					GString* _tmp266_;
																					_tmp266_ = data;
																					g_string_append (_tmp266_, "#OfflineUpgrade\n\n");
																				}
																			} else {
																				const gchar* _tmp267_;
																				_tmp267_ = key;
																				if (g_strcmp0 (_tmp267_, "MaxParallelDownloads") == 0) {
																					GString* _tmp268_;
																					GVariant* _tmp269_;
																					gchar* _tmp270_;
																					gchar* _tmp271_;
																					_tmp268_ = data;
																					_tmp269_ = val;
																					_tmp270_ = g_strdup_printf ("MaxParallelDownloads = %llu\n\n", g_variant_get_uint64 (_tmp269_));
																					_tmp271_ = _tmp270_;
																					g_string_append (_tmp268_, _tmp271_);
																					_g_free0 (_tmp271_);
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	{
		GFileOutputStream* _tmp272_ = NULL;
		GFile* _tmp273_;
		GFileOutputStream* _tmp274_;
		GDataOutputStream* dos = NULL;
		GDataOutputStream* _tmp275_;
		GDataOutputStream* _tmp276_;
		GString* _tmp277_;
		const gchar* _tmp278_;
		_tmp273_ = file;
		_tmp274_ = g_file_create (_tmp273_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
		_tmp272_ = _tmp274_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp275_ = g_data_output_stream_new ((GOutputStream*) _tmp272_);
		dos = _tmp275_;
		_tmp276_ = dos;
		_tmp277_ = data;
		_tmp278_ = _tmp277_->str;
		g_data_output_stream_put_string (_tmp276_, _tmp278_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dos);
			_g_object_unref0 (_tmp272_);
			goto __catch1_g_error;
		}
		_g_object_unref0 (dos);
		_g_object_unref0 (_tmp272_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp279_;
		const gchar* _tmp280_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp279_ = e;
		_tmp280_ = _tmp279_->message;
		g_warning ("pamac_config_daemon.vala:517: %s", _tmp280_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_string_free0 (data);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_string_free0 (data);
	_g_object_unref0 (file);
}

const gchar*
pamac_config_get_conf_path (PamacConfig* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_conf_path;
	result = _tmp0_;
	return result;
}

static void
pamac_config_set_conf_path (PamacConfig* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_conf_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_conf_path);
		self->priv->_conf_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_CONF_PATH_PROPERTY]);
	}
}

guint64
pamac_config_get_refresh_period (PamacConfig* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_refresh_period;
	return result;
}

void
pamac_config_set_refresh_period (PamacConfig* self,
                                 guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_refresh_period (self);
	if (old_value != value) {
		self->priv->_refresh_period = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_REFRESH_PERIOD_PROPERTY]);
	}
}

gboolean
pamac_config_get_support_aur (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_support_aur;
	return result;
}

static void
pamac_config_set_support_aur (PamacConfig* self,
                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_support_aur (self);
	if (old_value != value) {
		self->priv->_support_aur = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_SUPPORT_AUR_PROPERTY]);
	}
}

gboolean
pamac_config_get_enable_aur (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enable_aur;
	return result;
}

void
pamac_config_set_enable_aur (PamacConfig* self,
                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_enable_aur (self);
	if (old_value != value) {
		self->priv->_enable_aur = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_ENABLE_AUR_PROPERTY]);
	}
}

gboolean
pamac_config_get_support_appstream (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_support_appstream;
	return result;
}

static void
pamac_config_set_support_appstream (PamacConfig* self,
                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_support_appstream (self);
	if (old_value != value) {
		self->priv->_support_appstream = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_SUPPORT_APPSTREAM_PROPERTY]);
	}
}

gboolean
pamac_config_get_enable_appstream (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enable_appstream;
	return result;
}

void
pamac_config_set_enable_appstream (PamacConfig* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_enable_appstream (self);
	if (old_value != value) {
		self->priv->_enable_appstream = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_ENABLE_APPSTREAM_PROPERTY]);
	}
}

gboolean
pamac_config_get_support_snap (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_support_snap;
	return result;
}

void
pamac_config_set_support_snap (PamacConfig* self,
                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_support_snap (self);
	if (old_value != value) {
		self->priv->_support_snap = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_SUPPORT_SNAP_PROPERTY]);
	}
}

gboolean
pamac_config_get_enable_snap (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enable_snap;
	return result;
}

void
pamac_config_set_enable_snap (PamacConfig* self,
                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_enable_snap (self);
	if (old_value != value) {
		self->priv->_enable_snap = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_ENABLE_SNAP_PROPERTY]);
	}
}

gboolean
pamac_config_get_support_flatpak (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_support_flatpak;
	return result;
}

void
pamac_config_set_support_flatpak (PamacConfig* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_support_flatpak (self);
	if (old_value != value) {
		self->priv->_support_flatpak = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_SUPPORT_FLATPAK_PROPERTY]);
	}
}

gboolean
pamac_config_get_enable_flatpak (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enable_flatpak;
	return result;
}

void
pamac_config_set_enable_flatpak (PamacConfig* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_enable_flatpak (self);
	if (old_value != value) {
		self->priv->_enable_flatpak = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_ENABLE_FLATPAK_PROPERTY]);
	}
}

gboolean
pamac_config_get_check_flatpak_updates (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_check_flatpak_updates;
	return result;
}

void
pamac_config_set_check_flatpak_updates (PamacConfig* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_check_flatpak_updates (self);
	if (old_value != value) {
		self->priv->_check_flatpak_updates = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_CHECK_FLATPAK_UPDATES_PROPERTY]);
	}
}

const gchar*
pamac_config_get_aur_build_dir (PamacConfig* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_aur_build_dir;
	result = _tmp0_;
	return result;
}

void
pamac_config_set_aur_build_dir (PamacConfig* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_aur_build_dir (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_aur_build_dir);
		self->priv->_aur_build_dir = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_AUR_BUILD_DIR_PROPERTY]);
	}
}

gboolean
pamac_config_get_check_aur_updates (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_check_aur_updates;
	return result;
}

void
pamac_config_set_check_aur_updates (PamacConfig* self,
                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_check_aur_updates (self);
	if (old_value != value) {
		self->priv->_check_aur_updates = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_CHECK_AUR_UPDATES_PROPERTY]);
	}
}

gboolean
pamac_config_get_check_aur_vcs_updates (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_check_aur_vcs_updates;
	return result;
}

void
pamac_config_set_check_aur_vcs_updates (PamacConfig* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_check_aur_vcs_updates (self);
	if (old_value != value) {
		self->priv->_check_aur_vcs_updates = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_CHECK_AUR_VCS_UPDATES_PROPERTY]);
	}
}

gboolean
pamac_config_get_offline_upgrade (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_offline_upgrade;
	return result;
}

void
pamac_config_set_offline_upgrade (PamacConfig* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_offline_upgrade (self);
	if (old_value != value) {
		self->priv->_offline_upgrade = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_OFFLINE_UPGRADE_PROPERTY]);
	}
}

guint64
pamac_config_get_max_parallel_downloads (PamacConfig* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_max_parallel_downloads;
	return result;
}

void
pamac_config_set_max_parallel_downloads (PamacConfig* self,
                                         guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_max_parallel_downloads (self);
	if (old_value != value) {
		self->priv->_max_parallel_downloads = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_MAX_PARALLEL_DOWNLOADS_PROPERTY]);
	}
}

guint64
pamac_config_get_clean_keep_num_pkgs (PamacConfig* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_clean_keep_num_pkgs;
	return result;
}

void
pamac_config_set_clean_keep_num_pkgs (PamacConfig* self,
                                      guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_clean_keep_num_pkgs (self);
	if (old_value != value) {
		self->priv->_clean_keep_num_pkgs = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_CLEAN_KEEP_NUM_PKGS_PROPERTY]);
	}
}

gboolean
pamac_config_get_clean_rm_only_uninstalled (PamacConfig* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_clean_rm_only_uninstalled;
	return result;
}

void
pamac_config_set_clean_rm_only_uninstalled (PamacConfig* self,
                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_clean_rm_only_uninstalled (self);
	if (old_value != value) {
		self->priv->_clean_rm_only_uninstalled = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_CLEAN_RM_ONLY_UNINSTALLED_PROPERTY]);
	}
}

GHashTable*
pamac_config_get_ignorepkgs (PamacConfig* self)
{
	GHashTable* result;
	AlpmConfig* _tmp0_;
	GHashTable* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_alpm_config;
	_tmp1_ = _tmp0_->ignorepkgs;
	result = _tmp1_;
	return result;
}

AlpmConfig*
pamac_config_get_alpm_config (PamacConfig* self)
{
	AlpmConfig* result;
	AlpmConfig* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_alpm_config;
	result = _tmp0_;
	return result;
}

static gpointer
_alpm_config_ref0 (gpointer self)
{
	return self ? alpm_config_ref (self) : NULL;
}

static void
pamac_config_set_alpm_config (PamacConfig* self,
                              AlpmConfig* value)
{
	AlpmConfig* old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_config_get_alpm_config (self);
	if (old_value != value) {
		AlpmConfig* _tmp0_;
		_tmp0_ = _alpm_config_ref0 (value);
		_alpm_config_unref0 (self->priv->_alpm_config);
		self->priv->_alpm_config = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pamac_config_properties[PAMAC_CONFIG_ALPM_CONFIG_PROPERTY]);
	}
}

static GObject *
pamac_config_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PamacConfig * self;
	AlpmConfig* _tmp0_;
	AlpmConfig* _tmp1_;
	PamacPluginLoader* _tmp2_;
	PamacPluginLoader* _tmp3_;
	PamacPluginLoader* _tmp4_;
	PamacPluginLoader* _tmp5_;
	PamacPluginLoader* _tmp6_;
	PamacPluginLoader* _tmp7_;
	PamacPluginLoader* _tmp8_;
	PamacPluginLoader* _tmp9_;
	parent_class = G_OBJECT_CLASS (pamac_config_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_CONFIG, PamacConfig);
	_tmp0_ = alpm_config_new ("/etc/pacman.conf");
	_tmp1_ = _tmp0_;
	pamac_config_set_alpm_config (self, _tmp1_);
	_alpm_config_unref0 (_tmp1_);
	pamac_config_set_support_aur (self, TRUE);
	_tmp2_ = pamac_plugin_loader_new (PAMAC_TYPE_AUR_PLUGIN, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, "pamac-aur");
	_g_object_unref0 (self->priv->aur_plugin_loader);
	self->priv->aur_plugin_loader = _tmp2_;
	_tmp3_ = self->priv->aur_plugin_loader;
	if (pamac_plugin_loader_load (_tmp3_)) {
		pamac_config_set_support_aur (self, TRUE);
	}
	pamac_config_set_support_appstream (self, FALSE);
	_tmp4_ = pamac_plugin_loader_new (PAMAC_TYPE_APPSTREAM_PLUGIN, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, "pamac-appstream");
	_g_object_unref0 (self->priv->appstream_plugin_loader);
	self->priv->appstream_plugin_loader = _tmp4_;
	_tmp5_ = self->priv->appstream_plugin_loader;
	if (pamac_plugin_loader_load (_tmp5_)) {
		pamac_config_set_support_appstream (self, TRUE);
	}
	pamac_config_set_support_snap (self, FALSE);
	_tmp6_ = pamac_plugin_loader_new (PAMAC_TYPE_SNAP_PLUGIN, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, "pamac-snap");
	_g_object_unref0 (self->priv->snap_plugin_loader);
	self->priv->snap_plugin_loader = _tmp6_;
	_tmp7_ = self->priv->snap_plugin_loader;
	if (pamac_plugin_loader_load (_tmp7_)) {
		pamac_config_set_support_snap (self, TRUE);
	}
	pamac_config_set_support_flatpak (self, FALSE);
	_tmp8_ = pamac_plugin_loader_new (PAMAC_TYPE_FLATPAK_PLUGIN, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, "pamac-flatpak");
	_g_object_unref0 (self->priv->flatpak_plugin_loader);
	self->priv->flatpak_plugin_loader = _tmp8_;
	_tmp9_ = self->priv->flatpak_plugin_loader;
	if (pamac_plugin_loader_load (_tmp9_)) {
		pamac_config_set_support_flatpak (self, TRUE);
	}
	pamac_config_reload (self);
	return obj;
}

static void
pamac_config_class_init (PamacConfigClass * klass,
                         gpointer klass_data)
{
	pamac_config_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PamacConfig_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pamac_config_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pamac_config_set_property;
	G_OBJECT_CLASS (klass)->constructor = pamac_config_constructor;
	G_OBJECT_CLASS (klass)->finalize = pamac_config_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_CONF_PATH_PROPERTY, pamac_config_properties[PAMAC_CONFIG_CONF_PATH_PROPERTY] = g_param_spec_string ("conf-path", "conf-path", "conf-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_REFRESH_PERIOD_PROPERTY, pamac_config_properties[PAMAC_CONFIG_REFRESH_PERIOD_PROPERTY] = g_param_spec_uint64 ("refresh-period", "refresh-period", "refresh-period", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_SUPPORT_AUR_PROPERTY, pamac_config_properties[PAMAC_CONFIG_SUPPORT_AUR_PROPERTY] = g_param_spec_boolean ("support-aur", "support-aur", "support-aur", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_ENABLE_AUR_PROPERTY, pamac_config_properties[PAMAC_CONFIG_ENABLE_AUR_PROPERTY] = g_param_spec_boolean ("enable-aur", "enable-aur", "enable-aur", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_SUPPORT_APPSTREAM_PROPERTY, pamac_config_properties[PAMAC_CONFIG_SUPPORT_APPSTREAM_PROPERTY] = g_param_spec_boolean ("support-appstream", "support-appstream", "support-appstream", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_ENABLE_APPSTREAM_PROPERTY, pamac_config_properties[PAMAC_CONFIG_ENABLE_APPSTREAM_PROPERTY] = g_param_spec_boolean ("enable-appstream", "enable-appstream", "enable-appstream", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_SUPPORT_SNAP_PROPERTY, pamac_config_properties[PAMAC_CONFIG_SUPPORT_SNAP_PROPERTY] = g_param_spec_boolean ("support-snap", "support-snap", "support-snap", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_ENABLE_SNAP_PROPERTY, pamac_config_properties[PAMAC_CONFIG_ENABLE_SNAP_PROPERTY] = g_param_spec_boolean ("enable-snap", "enable-snap", "enable-snap", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_SUPPORT_FLATPAK_PROPERTY, pamac_config_properties[PAMAC_CONFIG_SUPPORT_FLATPAK_PROPERTY] = g_param_spec_boolean ("support-flatpak", "support-flatpak", "support-flatpak", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_ENABLE_FLATPAK_PROPERTY, pamac_config_properties[PAMAC_CONFIG_ENABLE_FLATPAK_PROPERTY] = g_param_spec_boolean ("enable-flatpak", "enable-flatpak", "enable-flatpak", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_CHECK_FLATPAK_UPDATES_PROPERTY, pamac_config_properties[PAMAC_CONFIG_CHECK_FLATPAK_UPDATES_PROPERTY] = g_param_spec_boolean ("check-flatpak-updates", "check-flatpak-updates", "check-flatpak-updates", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_AUR_BUILD_DIR_PROPERTY, pamac_config_properties[PAMAC_CONFIG_AUR_BUILD_DIR_PROPERTY] = g_param_spec_string ("aur-build-dir", "aur-build-dir", "aur-build-dir", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_CHECK_AUR_UPDATES_PROPERTY, pamac_config_properties[PAMAC_CONFIG_CHECK_AUR_UPDATES_PROPERTY] = g_param_spec_boolean ("check-aur-updates", "check-aur-updates", "check-aur-updates", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_CHECK_AUR_VCS_UPDATES_PROPERTY, pamac_config_properties[PAMAC_CONFIG_CHECK_AUR_VCS_UPDATES_PROPERTY] = g_param_spec_boolean ("check-aur-vcs-updates", "check-aur-vcs-updates", "check-aur-vcs-updates", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_OFFLINE_UPGRADE_PROPERTY, pamac_config_properties[PAMAC_CONFIG_OFFLINE_UPGRADE_PROPERTY] = g_param_spec_boolean ("offline-upgrade", "offline-upgrade", "offline-upgrade", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_MAX_PARALLEL_DOWNLOADS_PROPERTY, pamac_config_properties[PAMAC_CONFIG_MAX_PARALLEL_DOWNLOADS_PROPERTY] = g_param_spec_uint64 ("max-parallel-downloads", "max-parallel-downloads", "max-parallel-downloads", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_CLEAN_KEEP_NUM_PKGS_PROPERTY, pamac_config_properties[PAMAC_CONFIG_CLEAN_KEEP_NUM_PKGS_PROPERTY] = g_param_spec_uint64 ("clean-keep-num-pkgs", "clean-keep-num-pkgs", "clean-keep-num-pkgs", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_CLEAN_RM_ONLY_UNINSTALLED_PROPERTY, pamac_config_properties[PAMAC_CONFIG_CLEAN_RM_ONLY_UNINSTALLED_PROPERTY] = g_param_spec_boolean ("clean-rm-only-uninstalled", "clean-rm-only-uninstalled", "clean-rm-only-uninstalled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_IGNOREPKGS_PROPERTY, pamac_config_properties[PAMAC_CONFIG_IGNOREPKGS_PROPERTY] = g_param_spec_boxed ("ignorepkgs", "ignorepkgs", "ignorepkgs", G_TYPE_HASH_TABLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_CONFIG_ALPM_CONFIG_PROPERTY, pamac_config_properties[PAMAC_CONFIG_ALPM_CONFIG_PROPERTY] = param_spec_alpm_config ("alpm-config", "alpm-config", "alpm-config", TYPE_ALPM_CONFIG, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
pamac_config_instance_init (PamacConfig * self,
                            gpointer klass)
{
	self->priv = pamac_config_get_instance_private (self);
}

static void
pamac_config_finalize (GObject * obj)
{
	PamacConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_CONFIG, PamacConfig);
	_g_free0 (self->priv->_conf_path);
	_g_object_unref0 (self->priv->aur_plugin_loader);
	_g_object_unref0 (self->priv->appstream_plugin_loader);
	_g_object_unref0 (self->priv->snap_plugin_loader);
	_g_object_unref0 (self->priv->flatpak_plugin_loader);
	_g_free0 (self->priv->_aur_build_dir);
	_alpm_config_unref0 (self->priv->_alpm_config);
	G_OBJECT_CLASS (pamac_config_parent_class)->finalize (obj);
}

static GType
pamac_config_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PamacConfig), 0, (GInstanceInitFunc) pamac_config_instance_init, NULL };
	GType pamac_config_type_id;
	pamac_config_type_id = g_type_register_static (G_TYPE_OBJECT, "PamacConfig", &g_define_type_info, 0);
	PamacConfig_private_offset = g_type_add_instance_private (pamac_config_type_id, sizeof (PamacConfigPrivate));
	return pamac_config_type_id;
}

GType
pamac_config_get_type (void)
{
	static volatile gsize pamac_config_type_id__once = 0;
	if (g_once_init_enter (&pamac_config_type_id__once)) {
		GType pamac_config_type_id;
		pamac_config_type_id = pamac_config_get_type_once ();
		g_once_init_leave (&pamac_config_type_id__once, pamac_config_type_id);
	}
	return pamac_config_type_id__once;
}

static void
_vala_pamac_config_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	PamacConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAMAC_TYPE_CONFIG, PamacConfig);
	switch (property_id) {
		case PAMAC_CONFIG_CONF_PATH_PROPERTY:
		g_value_set_string (value, pamac_config_get_conf_path (self));
		break;
		case PAMAC_CONFIG_REFRESH_PERIOD_PROPERTY:
		g_value_set_uint64 (value, pamac_config_get_refresh_period (self));
		break;
		case PAMAC_CONFIG_SUPPORT_AUR_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_support_aur (self));
		break;
		case PAMAC_CONFIG_ENABLE_AUR_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_enable_aur (self));
		break;
		case PAMAC_CONFIG_SUPPORT_APPSTREAM_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_support_appstream (self));
		break;
		case PAMAC_CONFIG_ENABLE_APPSTREAM_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_enable_appstream (self));
		break;
		case PAMAC_CONFIG_SUPPORT_SNAP_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_support_snap (self));
		break;
		case PAMAC_CONFIG_ENABLE_SNAP_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_enable_snap (self));
		break;
		case PAMAC_CONFIG_SUPPORT_FLATPAK_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_support_flatpak (self));
		break;
		case PAMAC_CONFIG_ENABLE_FLATPAK_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_enable_flatpak (self));
		break;
		case PAMAC_CONFIG_CHECK_FLATPAK_UPDATES_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_check_flatpak_updates (self));
		break;
		case PAMAC_CONFIG_AUR_BUILD_DIR_PROPERTY:
		g_value_set_string (value, pamac_config_get_aur_build_dir (self));
		break;
		case PAMAC_CONFIG_CHECK_AUR_UPDATES_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_check_aur_updates (self));
		break;
		case PAMAC_CONFIG_CHECK_AUR_VCS_UPDATES_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_check_aur_vcs_updates (self));
		break;
		case PAMAC_CONFIG_OFFLINE_UPGRADE_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_offline_upgrade (self));
		break;
		case PAMAC_CONFIG_MAX_PARALLEL_DOWNLOADS_PROPERTY:
		g_value_set_uint64 (value, pamac_config_get_max_parallel_downloads (self));
		break;
		case PAMAC_CONFIG_CLEAN_KEEP_NUM_PKGS_PROPERTY:
		g_value_set_uint64 (value, pamac_config_get_clean_keep_num_pkgs (self));
		break;
		case PAMAC_CONFIG_CLEAN_RM_ONLY_UNINSTALLED_PROPERTY:
		g_value_set_boolean (value, pamac_config_get_clean_rm_only_uninstalled (self));
		break;
		case PAMAC_CONFIG_IGNOREPKGS_PROPERTY:
		g_value_set_boxed (value, pamac_config_get_ignorepkgs (self));
		break;
		case PAMAC_CONFIG_ALPM_CONFIG_PROPERTY:
		value_set_alpm_config (value, pamac_config_get_alpm_config (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pamac_config_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	PamacConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAMAC_TYPE_CONFIG, PamacConfig);
	switch (property_id) {
		case PAMAC_CONFIG_CONF_PATH_PROPERTY:
		pamac_config_set_conf_path (self, g_value_get_string (value));
		break;
		case PAMAC_CONFIG_REFRESH_PERIOD_PROPERTY:
		pamac_config_set_refresh_period (self, g_value_get_uint64 (value));
		break;
		case PAMAC_CONFIG_SUPPORT_AUR_PROPERTY:
		pamac_config_set_support_aur (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_ENABLE_AUR_PROPERTY:
		pamac_config_set_enable_aur (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_SUPPORT_APPSTREAM_PROPERTY:
		pamac_config_set_support_appstream (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_ENABLE_APPSTREAM_PROPERTY:
		pamac_config_set_enable_appstream (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_SUPPORT_SNAP_PROPERTY:
		pamac_config_set_support_snap (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_ENABLE_SNAP_PROPERTY:
		pamac_config_set_enable_snap (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_SUPPORT_FLATPAK_PROPERTY:
		pamac_config_set_support_flatpak (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_ENABLE_FLATPAK_PROPERTY:
		pamac_config_set_enable_flatpak (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_CHECK_FLATPAK_UPDATES_PROPERTY:
		pamac_config_set_check_flatpak_updates (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_AUR_BUILD_DIR_PROPERTY:
		pamac_config_set_aur_build_dir (self, g_value_get_string (value));
		break;
		case PAMAC_CONFIG_CHECK_AUR_UPDATES_PROPERTY:
		pamac_config_set_check_aur_updates (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_CHECK_AUR_VCS_UPDATES_PROPERTY:
		pamac_config_set_check_aur_vcs_updates (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_OFFLINE_UPGRADE_PROPERTY:
		pamac_config_set_offline_upgrade (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_MAX_PARALLEL_DOWNLOADS_PROPERTY:
		pamac_config_set_max_parallel_downloads (self, g_value_get_uint64 (value));
		break;
		case PAMAC_CONFIG_CLEAN_KEEP_NUM_PKGS_PROPERTY:
		pamac_config_set_clean_keep_num_pkgs (self, g_value_get_uint64 (value));
		break;
		case PAMAC_CONFIG_CLEAN_RM_ONLY_UNINSTALLED_PROPERTY:
		pamac_config_set_clean_rm_only_uninstalled (self, g_value_get_boolean (value));
		break;
		case PAMAC_CONFIG_ALPM_CONFIG_PROPERTY:
		pamac_config_set_alpm_config (self, value_get_alpm_config (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

