/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.synth.SynthArrowButton;
import javax.swing.plaf.synth.SynthComboPopup;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLabelUI;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;

public class SynthComboBoxUI
extends BasicComboBoxUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private boolean useListColors;
    Insets popupInsets;
    private boolean buttonWhenNotEditable;
    private boolean pressedWhenPopupVisible;
    private ButtonHandler buttonHandler;
    private EditorFocusHandler editorFocusHandler;
    private boolean forceOpaque = false;

    public static ComponentUI createUI(JComponent c) {
        return new SynthComboBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.buttonHandler = new ButtonHandler();
        super.installUI(c);
    }

    @Override
    protected void installDefaults() {
        this.updateStyle(this.comboBox);
    }

    private void updateStyle(JComboBox comboBox) {
        SynthStyle oldStyle = this.style;
        SynthContext context = this.getContext(comboBox, 1);
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            this.padding = (Insets)this.style.get(context, "ComboBox.padding");
            this.popupInsets = (Insets)this.style.get(context, "ComboBox.popupInsets");
            this.useListColors = this.style.getBoolean(context, "ComboBox.rendererUseListColors", true);
            this.buttonWhenNotEditable = this.style.getBoolean(context, "ComboBox.buttonWhenNotEditable", false);
            this.pressedWhenPopupVisible = this.style.getBoolean(context, "ComboBox.pressedWhenPopupVisible", false);
            this.squareButton = this.style.getBoolean(context, "ComboBox.squareButton", true);
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
            this.forceOpaque = this.style.getBoolean(context, "ComboBox.forceOpaque", false);
        }
        context.dispose();
        if (this.listBox != null) {
            SynthLookAndFeel.updateStyles(this.listBox);
        }
    }

    @Override
    protected void installListeners() {
        this.comboBox.addPropertyChangeListener(this);
        this.comboBox.addMouseListener(this.buttonHandler);
        this.editorFocusHandler = new EditorFocusHandler(this.comboBox);
        super.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (this.popup instanceof SynthComboPopup) {
            ((SynthComboPopup)this.popup).removePopupMenuListener(this.buttonHandler);
        }
        super.uninstallUI(c);
        this.buttonHandler = null;
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext context = this.getContext(this.comboBox, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    @Override
    protected void uninstallListeners() {
        this.editorFocusHandler.unregister();
        this.comboBox.removePropertyChangeListener(this);
        this.comboBox.removeMouseListener(this.buttonHandler);
        this.buttonHandler.pressed = false;
        this.buttonHandler.over = false;
        super.uninstallListeners();
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private int getComponentState(JComponent c) {
        if (!(c instanceof JComboBox)) {
            return SynthLookAndFeel.getComponentState(c);
        }
        JComboBox box = (JComboBox)c;
        if (this.shouldActLikeButton()) {
            int state = 1;
            if (!c.isEnabled()) {
                state = 8;
            }
            if (this.buttonHandler.isPressed()) {
                state |= 4;
            }
            if (this.buttonHandler.isRollover()) {
                state |= 2;
            }
            if (box.isFocusOwner()) {
                state |= 0x100;
            }
            return state;
        }
        int basicState = SynthLookAndFeel.getComponentState(c);
        if (box.isEditable() && box.getEditor().getEditorComponent().isFocusOwner()) {
            basicState |= 0x100;
        }
        return basicState;
    }

    @Override
    protected ComboPopup createPopup() {
        SynthComboPopup p = new SynthComboPopup(this.comboBox);
        p.addPopupMenuListener(this.buttonHandler);
        return p;
    }

    @Override
    protected ListCellRenderer createRenderer() {
        return new SynthComboBoxRenderer();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new SynthComboBoxEditor();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle(this.comboBox);
        }
    }

    @Override
    protected JButton createArrowButton() {
        SynthArrowButton button = new SynthArrowButton(5);
        button.setName("ComboBox.arrowButton");
        button.setModel(this.buttonHandler);
        return button;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintComboBoxBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle r = this.rectangleForCurrentValue();
            this.paintCurrentValue(g, r, this.hasFocus);
        }
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintComboBoxBorder(context, g, x, y, w, h);
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        boolean force;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        Component c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        if (c instanceof UIResource) {
            c.setName("ComboBox.renderer");
        }
        boolean bl = force = this.forceOpaque && c instanceof JComponent;
        if (force) {
            ((JComponent)c).setOpaque(false);
        }
        int x = bounds.x;
        int y = bounds.y;
        int w = bounds.width;
        int h = bounds.height;
        if (this.padding != null) {
            x = bounds.x + this.padding.left;
            y = bounds.y + this.padding.top;
            w = bounds.width - (this.padding.left + this.padding.right);
            h = bounds.height - (this.padding.top + this.padding.bottom);
        }
        this.currentValuePane.paintComponent(g, c, this.comboBox, x, y, w, h, shouldValidate);
        if (force) {
            ((JComponent)c).setOpaque(true);
        }
    }

    private boolean shouldActLikeButton() {
        return this.buttonWhenNotEditable && !this.comboBox.isEditable();
    }

    @Override
    protected Dimension getDefaultSize() {
        SynthComboBoxRenderer r = new SynthComboBoxRenderer();
        Dimension d = this.getSizeForComponent(r.getListCellRendererComponent(this.listBox, " ", -1, false, false));
        return new Dimension(d.width, d.height);
    }

    private static class EditorFocusHandler
    implements FocusListener,
    PropertyChangeListener {
        private JComboBox comboBox;
        private ComboBoxEditor editor = null;
        private Component editorComponent = null;

        private EditorFocusHandler(JComboBox comboBox) {
            this.comboBox = comboBox;
            this.editor = comboBox.getEditor();
            if (this.editor != null) {
                this.editorComponent = this.editor.getEditorComponent();
                if (this.editorComponent != null) {
                    this.editorComponent.addFocusListener(this);
                }
            }
            comboBox.addPropertyChangeListener("editor", this);
        }

        public void unregister() {
            this.comboBox.removePropertyChangeListener(this);
            if (this.editorComponent != null) {
                this.editorComponent.removeFocusListener(this);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.comboBox.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.comboBox.repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ComboBoxEditor newEditor = this.comboBox.getEditor();
            if (this.editor != newEditor) {
                if (this.editorComponent != null) {
                    this.editorComponent.removeFocusListener(this);
                }
                this.editor = newEditor;
                if (this.editor != null) {
                    this.editorComponent = this.editor.getEditorComponent();
                    if (this.editorComponent != null) {
                        this.editorComponent.addFocusListener(this);
                    }
                }
            }
        }
    }

    private final class ButtonHandler
    extends DefaultButtonModel
    implements MouseListener,
    PopupMenuListener {
        private boolean over;
        private boolean pressed;

        private ButtonHandler() {
        }

        private void updatePressed(boolean p) {
            boolean bl = this.pressed = p && this.isEnabled();
            if (SynthComboBoxUI.this.shouldActLikeButton()) {
                SynthComboBoxUI.this.comboBox.repaint();
            }
        }

        private void updateOver(boolean o) {
            boolean old = this.isRollover();
            this.over = o && this.isEnabled();
            boolean newo = this.isRollover();
            if (SynthComboBoxUI.this.shouldActLikeButton() && old != newo) {
                SynthComboBoxUI.this.comboBox.repaint();
            }
        }

        @Override
        public boolean isPressed() {
            boolean b = SynthComboBoxUI.this.shouldActLikeButton() ? this.pressed : super.isPressed();
            return b || SynthComboBoxUI.this.pressedWhenPopupVisible && SynthComboBoxUI.this.comboBox.isPopupVisible();
        }

        @Override
        public boolean isArmed() {
            boolean b = SynthComboBoxUI.this.shouldActLikeButton() || SynthComboBoxUI.this.pressedWhenPopupVisible && SynthComboBoxUI.this.comboBox.isPopupVisible();
            return b ? this.isPressed() : super.isArmed();
        }

        @Override
        public boolean isRollover() {
            return SynthComboBoxUI.this.shouldActLikeButton() ? this.over : super.isRollover();
        }

        @Override
        public void setPressed(boolean b) {
            super.setPressed(b);
            this.updatePressed(b);
        }

        @Override
        public void setRollover(boolean b) {
            super.setRollover(b);
            this.updateOver(b);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.updateOver(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.updateOver(false);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.updatePressed(true);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.updatePressed(false);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            if (SynthComboBoxUI.this.shouldActLikeButton() || SynthComboBoxUI.this.pressedWhenPopupVisible) {
                SynthComboBoxUI.this.comboBox.repaint();
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }
    }

    private static class SynthComboBoxEditor
    extends BasicComboBoxEditor.UIResource {
        private SynthComboBoxEditor() {
        }

        @Override
        public JTextField createEditorComponent() {
            JTextField f = new JTextField("", 9);
            f.setName("ComboBox.textField");
            return f;
        }
    }

    private class SynthComboBoxRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public SynthComboBoxRenderer() {
            this.setText(" ");
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            SynthLookAndFeel.resetSelectedUI();
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (!SynthComboBoxUI.this.useListColors) {
                    SynthLookAndFeel.setSelectedUI((SynthLabelUI)SynthLookAndFeel.getUIOfType(this.getUI(), SynthLabelUI.class), isSelected, cellHasFocus, list.isEnabled(), false);
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
                this.setText("");
            } else {
                String text;
                String string = text = value == null ? " " : value.toString();
                if ("".equals(text)) {
                    text = " ";
                }
                this.setText(text);
            }
            if (SynthComboBoxUI.this.comboBox != null) {
                this.setEnabled(SynthComboBoxUI.this.comboBox.isEnabled());
                this.setComponentOrientation(SynthComboBoxUI.this.comboBox.getComponentOrientation());
            }
            return this;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            SynthLookAndFeel.resetSelectedUI();
        }
    }
}

