/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sun.nio.fs.DynamicFileAttributeView;
import sun.nio.fs.Util;

abstract class AbstractBasicFileAttributeView
implements BasicFileAttributeView,
DynamicFileAttributeView {
    private static final String SIZE_NAME = "size";
    private static final String CREATION_TIME_NAME = "creationTime";
    private static final String LAST_ACCESS_TIME_NAME = "lastAccessTime";
    private static final String LAST_MODIFIED_TIME_NAME = "lastModifiedTime";
    private static final String FILE_KEY_NAME = "fileKey";
    private static final String IS_DIRECTORY_NAME = "isDirectory";
    private static final String IS_REGULAR_FILE_NAME = "isRegularFile";
    private static final String IS_SYMBOLIC_LINK_NAME = "isSymbolicLink";
    private static final String IS_OTHER_NAME = "isOther";
    static final Set<String> basicAttributeNames = Util.newSet("size", "creationTime", "lastAccessTime", "lastModifiedTime", "fileKey", "isDirectory", "isRegularFile", "isSymbolicLink", "isOther");

    protected AbstractBasicFileAttributeView() {
    }

    @Override
    public String name() {
        return "basic";
    }

    @Override
    public void setAttribute(String attribute, Object value) throws IOException {
        if (attribute.equals(LAST_MODIFIED_TIME_NAME)) {
            this.setTimes((FileTime)value, null, null);
            return;
        }
        if (attribute.equals(LAST_ACCESS_TIME_NAME)) {
            this.setTimes(null, (FileTime)value, null);
            return;
        }
        if (attribute.equals(CREATION_TIME_NAME)) {
            this.setTimes(null, null, (FileTime)value);
            return;
        }
        throw new IllegalArgumentException("'" + this.name() + ":" + attribute + "' not recognized");
    }

    final void addRequestedBasicAttributes(BasicFileAttributes attrs, AttributesBuilder builder) {
        if (builder.match(SIZE_NAME)) {
            builder.add(SIZE_NAME, attrs.size());
        }
        if (builder.match(CREATION_TIME_NAME)) {
            builder.add(CREATION_TIME_NAME, attrs.creationTime());
        }
        if (builder.match(LAST_ACCESS_TIME_NAME)) {
            builder.add(LAST_ACCESS_TIME_NAME, attrs.lastAccessTime());
        }
        if (builder.match(LAST_MODIFIED_TIME_NAME)) {
            builder.add(LAST_MODIFIED_TIME_NAME, attrs.lastModifiedTime());
        }
        if (builder.match(FILE_KEY_NAME)) {
            builder.add(FILE_KEY_NAME, attrs.fileKey());
        }
        if (builder.match(IS_DIRECTORY_NAME)) {
            builder.add(IS_DIRECTORY_NAME, attrs.isDirectory());
        }
        if (builder.match(IS_REGULAR_FILE_NAME)) {
            builder.add(IS_REGULAR_FILE_NAME, attrs.isRegularFile());
        }
        if (builder.match(IS_SYMBOLIC_LINK_NAME)) {
            builder.add(IS_SYMBOLIC_LINK_NAME, attrs.isSymbolicLink());
        }
        if (builder.match(IS_OTHER_NAME)) {
            builder.add(IS_OTHER_NAME, attrs.isOther());
        }
    }

    @Override
    public Map<String, Object> readAttributes(String[] requested) throws IOException {
        AttributesBuilder builder = AttributesBuilder.create(basicAttributeNames, requested);
        this.addRequestedBasicAttributes(this.readAttributes(), builder);
        return builder.unmodifiableMap();
    }

    static class AttributesBuilder {
        private Set<String> names = new HashSet<String>();
        private Map<String, Object> map = new HashMap<String, Object>();
        private boolean copyAll;

        private AttributesBuilder(Set<String> allowed, String[] requested) {
            for (String name : requested) {
                if (name.equals("*")) {
                    this.copyAll = true;
                    continue;
                }
                if (!allowed.contains(name)) {
                    throw new IllegalArgumentException("'" + name + "' not recognized");
                }
                this.names.add(name);
            }
        }

        static AttributesBuilder create(Set<String> allowed, String[] requested) {
            return new AttributesBuilder(allowed, requested);
        }

        boolean match(String name) {
            return this.copyAll || this.names.contains(name);
        }

        void add(String name, Object value) {
            this.map.put(name, value);
        }

        Map<String, Object> unmodifiableMap() {
            return Collections.unmodifiableMap(this.map);
        }
    }
}

