// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from esp32c2.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Espressif

//go:build esp && esp32c2

// 32-bit RISC-V MCU & 2.4 GHz Wi-Fi & Bluetooth 5 (LE)
//
//	Copyright 2023 Espressif Systems (Shanghai) PTE LTD Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
package esp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "ESP32-C2"
	CPU          = "RV32IMC"
	FPUPresent   = false
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// Interrupt Controller (Core 0)
	IRQ_WIFI_MAC = 0

	// Interrupt Controller (Core 0)
	IRQ_WIFI_MAC_NMI = 1

	// Interrupt Controller (Core 0)
	IRQ_WIFI_PWR = 2

	// Interrupt Controller (Core 0)
	IRQ_WIFI_BB = 3

	// Interrupt Controller (Core 0)
	IRQ_BT_MAC = 4

	// Interrupt Controller (Core 0)
	IRQ_BT_BB = 5

	// Interrupt Controller (Core 0)
	IRQ_BT_BB_NMI = 6

	// Interrupt Controller (Core 0)
	IRQ_LP_TIMER = 7

	// Interrupt Controller (Core 0)
	IRQ_COEX = 8

	// Interrupt Controller (Core 0)
	IRQ_BLE_TIMER = 9

	// Interrupt Controller (Core 0)
	IRQ_BLE_SEC = 10

	// I2C (Inter-Integrated Circuit) Controller 0
	IRQ_I2C_MST = 11

	// APB (Advanced Peripheral Bus) Controller
	IRQ_APB_CTRL = 12

	// General Purpose Input/Output
	IRQ_GPIO = 13

	// General Purpose Input/Output
	IRQ_GPIO_NMI = 14

	// SPI (Serial Peripheral Interface) Controller 2
	IRQ_SPI_INTR_1 = 15

	// SPI (Serial Peripheral Interface) Controller 2
	IRQ_SPI_INTR_2 = 16

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 0
	IRQ_UART0 = 17

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 1
	IRQ_UART1 = 18

	// LED Control PWM (Pulse Width Modulation)
	IRQ_LEDC = 19

	// eFuse Controller
	IRQ_EFUSE = 20

	// Real-Time Clock Control
	IRQ_RTC_CORE = 21

	// I2C (Inter-Integrated Circuit) Controller 0
	IRQ_I2C_EXT0 = 22

	// Timer Group 0
	IRQ_TG0_T0_LEVEL = 23

	// Timer Group 0
	IRQ_TG0_WDT_LEVEL = 24

	// Interrupt Controller (Core 0)
	IRQ_CACHE_IA = 25

	// System Timer
	IRQ_SYSTIMER_TARGET0 = 26

	// System Timer
	IRQ_SYSTIMER_TARGET1 = 27

	// System Timer
	IRQ_SYSTIMER_TARGET2 = 28

	// SPI (Serial Peripheral Interface) Controller 0
	IRQ_SPI_MEM_REJECT_CACHE = 29

	// Interrupt Controller (Core 0)
	IRQ_ICACHE_PRELOAD0 = 30

	// Interrupt Controller (Core 0)
	IRQ_ICACHE_SYNC0 = 31

	// SAR (Successive Approximation Register) Analog-to-Digital Converter
	IRQ_APB_ADC = 32

	// DMA (Direct Memory Access) Controller
	IRQ_DMA_CH0 = 33

	// SHA (Secure Hash Algorithm) Accelerator
	IRQ_SHA = 34

	// Interrupt Controller (Core 0)
	IRQ_ECC = 35

	// Interrupt Controller (Core 0)
	IRQ_FROM_CPU_INTR0 = 36

	// Interrupt Controller (Core 0)
	IRQ_FROM_CPU_INTR1 = 37

	// Interrupt Controller (Core 0)
	IRQ_FROM_CPU_INTR2 = 38

	// Interrupt Controller (Core 0)
	IRQ_FROM_CPU_INTR3 = 39

	// Debug Assist
	IRQ_ASSIST_DEBUG = 40

	// Interrupt Controller (Core 0)
	IRQ_ETS_CORE0_PIF_PMS_SIZE = 41

	// Highest interrupt number on this device.
	IRQ_max = 41
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)
func HandleInterrupt(num int) {
	switch num {
	case IRQ_WIFI_MAC:
		callHandlers(IRQ_WIFI_MAC)
	case IRQ_WIFI_MAC_NMI:
		callHandlers(IRQ_WIFI_MAC_NMI)
	case IRQ_WIFI_PWR:
		callHandlers(IRQ_WIFI_PWR)
	case IRQ_WIFI_BB:
		callHandlers(IRQ_WIFI_BB)
	case IRQ_BT_MAC:
		callHandlers(IRQ_BT_MAC)
	case IRQ_BT_BB:
		callHandlers(IRQ_BT_BB)
	case IRQ_BT_BB_NMI:
		callHandlers(IRQ_BT_BB_NMI)
	case IRQ_LP_TIMER:
		callHandlers(IRQ_LP_TIMER)
	case IRQ_COEX:
		callHandlers(IRQ_COEX)
	case IRQ_BLE_TIMER:
		callHandlers(IRQ_BLE_TIMER)
	case IRQ_BLE_SEC:
		callHandlers(IRQ_BLE_SEC)
	case IRQ_I2C_MST:
		callHandlers(IRQ_I2C_MST)
	case IRQ_APB_CTRL:
		callHandlers(IRQ_APB_CTRL)
	case IRQ_GPIO:
		callHandlers(IRQ_GPIO)
	case IRQ_GPIO_NMI:
		callHandlers(IRQ_GPIO_NMI)
	case IRQ_SPI_INTR_1:
		callHandlers(IRQ_SPI_INTR_1)
	case IRQ_SPI_INTR_2:
		callHandlers(IRQ_SPI_INTR_2)
	case IRQ_UART0:
		callHandlers(IRQ_UART0)
	case IRQ_UART1:
		callHandlers(IRQ_UART1)
	case IRQ_LEDC:
		callHandlers(IRQ_LEDC)
	case IRQ_EFUSE:
		callHandlers(IRQ_EFUSE)
	case IRQ_RTC_CORE:
		callHandlers(IRQ_RTC_CORE)
	case IRQ_I2C_EXT0:
		callHandlers(IRQ_I2C_EXT0)
	case IRQ_TG0_T0_LEVEL:
		callHandlers(IRQ_TG0_T0_LEVEL)
	case IRQ_TG0_WDT_LEVEL:
		callHandlers(IRQ_TG0_WDT_LEVEL)
	case IRQ_CACHE_IA:
		callHandlers(IRQ_CACHE_IA)
	case IRQ_SYSTIMER_TARGET0:
		callHandlers(IRQ_SYSTIMER_TARGET0)
	case IRQ_SYSTIMER_TARGET1:
		callHandlers(IRQ_SYSTIMER_TARGET1)
	case IRQ_SYSTIMER_TARGET2:
		callHandlers(IRQ_SYSTIMER_TARGET2)
	case IRQ_SPI_MEM_REJECT_CACHE:
		callHandlers(IRQ_SPI_MEM_REJECT_CACHE)
	case IRQ_ICACHE_PRELOAD0:
		callHandlers(IRQ_ICACHE_PRELOAD0)
	case IRQ_ICACHE_SYNC0:
		callHandlers(IRQ_ICACHE_SYNC0)
	case IRQ_APB_ADC:
		callHandlers(IRQ_APB_ADC)
	case IRQ_DMA_CH0:
		callHandlers(IRQ_DMA_CH0)
	case IRQ_SHA:
		callHandlers(IRQ_SHA)
	case IRQ_ECC:
		callHandlers(IRQ_ECC)
	case IRQ_FROM_CPU_INTR0:
		callHandlers(IRQ_FROM_CPU_INTR0)
	case IRQ_FROM_CPU_INTR1:
		callHandlers(IRQ_FROM_CPU_INTR1)
	case IRQ_FROM_CPU_INTR2:
		callHandlers(IRQ_FROM_CPU_INTR2)
	case IRQ_FROM_CPU_INTR3:
		callHandlers(IRQ_FROM_CPU_INTR3)
	case IRQ_ASSIST_DEBUG:
		callHandlers(IRQ_ASSIST_DEBUG)
	case IRQ_ETS_CORE0_PIF_PMS_SIZE:
		callHandlers(IRQ_ETS_CORE0_PIF_PMS_SIZE)
	}
}

// Peripherals.
var (
	// APB (Advanced Peripheral Bus) Controller
	APB_CTRL = (*APB_CTRL_Type)(unsafe.Pointer(uintptr(0x60026000)))

	// SAR (Successive Approximation Register) Analog-to-Digital Converter
	APB_SARADC = (*APB_SARADC_Type)(unsafe.Pointer(uintptr(0x60040000)))

	// Debug Assist
	ASSIST_DEBUG = (*ASSIST_DEBUG_Type)(unsafe.Pointer(uintptr(0x600ce000)))

	// BB Peripheral
	BB = (*BB_Type)(unsafe.Pointer(uintptr(0x6001d000)))

	// DMA (Direct Memory Access) Controller
	DMA = (*DMA_Type)(unsafe.Pointer(uintptr(0x6003f000)))

	// ECC (ECC Hardware Accelerator)
	ECC = (*ECC_Type)(unsafe.Pointer(uintptr(0x6003e000)))

	// eFuse Controller
	EFUSE = (*EFUSE_Type)(unsafe.Pointer(uintptr(0x60008800)))

	// External Memory
	EXTMEM = (*EXTMEM_Type)(unsafe.Pointer(uintptr(0x600c4000)))

	// General Purpose Input/Output
	GPIO = (*GPIO_Type)(unsafe.Pointer(uintptr(0x60004000)))

	// I2C (Inter-Integrated Circuit) Controller 0
	I2C0 = (*I2C_Type)(unsafe.Pointer(uintptr(0x60013000)))

	// Interrupt Controller (Core 0)
	INTERRUPT_CORE0 = (*INTERRUPT_CORE0_Type)(unsafe.Pointer(uintptr(0x600c2000)))

	// Input/Output Multiplexer
	IO_MUX = (*IO_MUX_Type)(unsafe.Pointer(uintptr(0x60009000)))

	// LED Control PWM (Pulse Width Modulation)
	LEDC = (*LEDC_Type)(unsafe.Pointer(uintptr(0x60019000)))

	// MODEM_CLKRST Peripheral
	MODEM_CLKRST = (*MODEM_CLKRST_Type)(unsafe.Pointer(uintptr(0x6004d800)))

	// Hardware Random Number Generator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x60026000)))

	// Real-Time Clock Control
	RTC_CNTL = (*RTC_CNTL_Type)(unsafe.Pointer(uintptr(0x60008000)))

	// SENSITIVE Peripheral
	SENSITIVE = (*SENSITIVE_Type)(unsafe.Pointer(uintptr(0x600c1000)))

	// SHA (Secure Hash Algorithm) Accelerator
	SHA = (*SHA_Type)(unsafe.Pointer(uintptr(0x6003b000)))

	// SPI (Serial Peripheral Interface) Controller 0
	SPI0 = (*SPI0_Type)(unsafe.Pointer(uintptr(0x60003000)))

	// SPI (Serial Peripheral Interface) Controller 1
	SPI1 = (*SPI1_Type)(unsafe.Pointer(uintptr(0x60002000)))

	// SPI (Serial Peripheral Interface) Controller 2
	SPI2 = (*SPI2_Type)(unsafe.Pointer(uintptr(0x60024000)))

	// System Configuration Registers
	SYSTEM = (*SYSTEM_Type)(unsafe.Pointer(uintptr(0x600c0000)))

	// System Timer
	SYSTIMER = (*SYSTIMER_Type)(unsafe.Pointer(uintptr(0x60023000)))

	// Timer Group 0
	TIMG0 = (*TIMG_Type)(unsafe.Pointer(uintptr(0x6001f000)))

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 0
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0x60000000)))

	// XTS-AES-128 Flash Encryption
	XTS_AES = (*XTS_AES_Type)(unsafe.Pointer(uintptr(0x600cc000)))

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 1
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0x60010000)))
)

// APB (Advanced Peripheral Bus) Controller
type APB_CTRL_Type struct {
	SYSCLK_CONF          volatile.Register32 // 0x0
	TICK_CONF            volatile.Register32 // 0x4
	CLK_OUT_EN           volatile.Register32 // 0x8
	WIFI_BB_CFG          volatile.Register32 // 0xC
	WIFI_BB_CFG_2        volatile.Register32 // 0x10
	WIFI_CLK_EN          volatile.Register32 // 0x14
	WIFI_RST_EN          volatile.Register32 // 0x18
	HOST_INF_SEL         volatile.Register32 // 0x1C
	EXT_MEM_PMS_LOCK     volatile.Register32 // 0x20
	_                    [4]byte
	FLASH_ACE0_ATTR      volatile.Register32 // 0x28
	FLASH_ACE1_ATTR      volatile.Register32 // 0x2C
	FLASH_ACE2_ATTR      volatile.Register32 // 0x30
	FLASH_ACE3_ATTR      volatile.Register32 // 0x34
	FLASH_ACE0_ADDR      volatile.Register32 // 0x38
	FLASH_ACE1_ADDR      volatile.Register32 // 0x3C
	FLASH_ACE2_ADDR      volatile.Register32 // 0x40
	FLASH_ACE3_ADDR      volatile.Register32 // 0x44
	FLASH_ACE0_SIZE      volatile.Register32 // 0x48
	FLASH_ACE1_SIZE      volatile.Register32 // 0x4C
	FLASH_ACE2_SIZE      volatile.Register32 // 0x50
	FLASH_ACE3_SIZE      volatile.Register32 // 0x54
	_                    [48]byte
	SPI_MEM_PMS_CTRL     volatile.Register32 // 0x88
	SPI_MEM_REJECT_ADDR  volatile.Register32 // 0x8C
	SDIO_CTRL            volatile.Register32 // 0x90
	REDCY_SIG0           volatile.Register32 // 0x94
	REDCY_SIG1           volatile.Register32 // 0x98
	FRONT_END_MEM_PD     volatile.Register32 // 0x9C
	RETENTION_CTRL       volatile.Register32 // 0xA0
	CLKGATE_FORCE_ON     volatile.Register32 // 0xA4
	MEM_POWER_DOWN       volatile.Register32 // 0xA8
	MEM_POWER_UP         volatile.Register32 // 0xAC
	RND_DATA             volatile.Register32 // 0xB0
	PERI_BACKUP_CONFIG   volatile.Register32 // 0xB4
	PERI_BACKUP_APB_ADDR volatile.Register32 // 0xB8
	PERI_BACKUP_MEM_ADDR volatile.Register32 // 0xBC
	PERI_BACKUP_INT_RAW  volatile.Register32 // 0xC0
	PERI_BACKUP_INT_ST   volatile.Register32 // 0xC4
	PERI_BACKUP_INT_ENA  volatile.Register32 // 0xC8
	_                    [4]byte
	PERI_BACKUP_INT_CLR  volatile.Register32 // 0xD0
	_                    [808]byte
	DATE                 volatile.Register32 // 0x3FC
}

// APB_CTRL.SYSCLK_CONF: APB_CTRL_SYSCLK_CONF_REG
func (o *APB_CTRL_Type) SetSYSCLK_CONF_PRE_DIV_CNT(value uint32) {
	volatile.StoreUint32(&o.SYSCLK_CONF.Reg, volatile.LoadUint32(&o.SYSCLK_CONF.Reg)&^(0x3ff)|value)
}
func (o *APB_CTRL_Type) GetSYSCLK_CONF_PRE_DIV_CNT() uint32 {
	return volatile.LoadUint32(&o.SYSCLK_CONF.Reg) & 0x3ff
}
func (o *APB_CTRL_Type) SetSYSCLK_CONF_CLK_320M_EN(value uint32) {
	volatile.StoreUint32(&o.SYSCLK_CONF.Reg, volatile.LoadUint32(&o.SYSCLK_CONF.Reg)&^(0x400)|value<<10)
}
func (o *APB_CTRL_Type) GetSYSCLK_CONF_CLK_320M_EN() uint32 {
	return (volatile.LoadUint32(&o.SYSCLK_CONF.Reg) & 0x400) >> 10
}
func (o *APB_CTRL_Type) SetSYSCLK_CONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.SYSCLK_CONF.Reg, volatile.LoadUint32(&o.SYSCLK_CONF.Reg)&^(0x800)|value<<11)
}
func (o *APB_CTRL_Type) GetSYSCLK_CONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.SYSCLK_CONF.Reg) & 0x800) >> 11
}
func (o *APB_CTRL_Type) SetSYSCLK_CONF_RST_TICK_CNT(value uint32) {
	volatile.StoreUint32(&o.SYSCLK_CONF.Reg, volatile.LoadUint32(&o.SYSCLK_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *APB_CTRL_Type) GetSYSCLK_CONF_RST_TICK_CNT() uint32 {
	return (volatile.LoadUint32(&o.SYSCLK_CONF.Reg) & 0x1000) >> 12
}

// APB_CTRL.TICK_CONF: APB_CTRL_TICK_CONF_REG
func (o *APB_CTRL_Type) SetTICK_CONF_XTAL_TICK_NUM(value uint32) {
	volatile.StoreUint32(&o.TICK_CONF.Reg, volatile.LoadUint32(&o.TICK_CONF.Reg)&^(0xff)|value)
}
func (o *APB_CTRL_Type) GetTICK_CONF_XTAL_TICK_NUM() uint32 {
	return volatile.LoadUint32(&o.TICK_CONF.Reg) & 0xff
}
func (o *APB_CTRL_Type) SetTICK_CONF_CK8M_TICK_NUM(value uint32) {
	volatile.StoreUint32(&o.TICK_CONF.Reg, volatile.LoadUint32(&o.TICK_CONF.Reg)&^(0xff00)|value<<8)
}
func (o *APB_CTRL_Type) GetTICK_CONF_CK8M_TICK_NUM() uint32 {
	return (volatile.LoadUint32(&o.TICK_CONF.Reg) & 0xff00) >> 8
}
func (o *APB_CTRL_Type) SetTICK_CONF_TICK_ENABLE(value uint32) {
	volatile.StoreUint32(&o.TICK_CONF.Reg, volatile.LoadUint32(&o.TICK_CONF.Reg)&^(0x10000)|value<<16)
}
func (o *APB_CTRL_Type) GetTICK_CONF_TICK_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.TICK_CONF.Reg) & 0x10000) >> 16
}

// APB_CTRL.CLK_OUT_EN: APB_CTRL_CLK_OUT_EN_REG
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK20_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK20_OEN() uint32 {
	return volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x1
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK22_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x2)|value<<1)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK22_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x2) >> 1
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK44_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x4)|value<<2)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK44_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x4) >> 2
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK_BB_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x8)|value<<3)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK_BB_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x8) >> 3
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK80_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x10)|value<<4)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK80_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x10) >> 4
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK160_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x20)|value<<5)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK160_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x20) >> 5
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK_320M_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x40)|value<<6)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK_320M_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x40) >> 6
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK_ADC_INF_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x80)|value<<7)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK_ADC_INF_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x80) >> 7
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK_DAC_CPU_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x100)|value<<8)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK_DAC_CPU_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x100) >> 8
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK40X_BB_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x200)|value<<9)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK40X_BB_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x200) >> 9
}
func (o *APB_CTRL_Type) SetCLK_OUT_EN_CLK_XTAL_OEN(value uint32) {
	volatile.StoreUint32(&o.CLK_OUT_EN.Reg, volatile.LoadUint32(&o.CLK_OUT_EN.Reg)&^(0x400)|value<<10)
}
func (o *APB_CTRL_Type) GetCLK_OUT_EN_CLK_XTAL_OEN() uint32 {
	return (volatile.LoadUint32(&o.CLK_OUT_EN.Reg) & 0x400) >> 10
}

// APB_CTRL.WIFI_BB_CFG: APB_CTRL_WIFI_BB_CFG_REG
func (o *APB_CTRL_Type) SetWIFI_BB_CFG(value uint32) {
	volatile.StoreUint32(&o.WIFI_BB_CFG.Reg, value)
}
func (o *APB_CTRL_Type) GetWIFI_BB_CFG() uint32 {
	return volatile.LoadUint32(&o.WIFI_BB_CFG.Reg)
}

// APB_CTRL.WIFI_BB_CFG_2: APB_CTRL_WIFI_BB_CFG_2_REG
func (o *APB_CTRL_Type) SetWIFI_BB_CFG_2(value uint32) {
	volatile.StoreUint32(&o.WIFI_BB_CFG_2.Reg, value)
}
func (o *APB_CTRL_Type) GetWIFI_BB_CFG_2() uint32 {
	return volatile.LoadUint32(&o.WIFI_BB_CFG_2.Reg)
}

// APB_CTRL.WIFI_CLK_EN: APB_CTRL_WIFI_CLK_EN_REG
func (o *APB_CTRL_Type) SetWIFI_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.WIFI_CLK_EN.Reg, value)
}
func (o *APB_CTRL_Type) GetWIFI_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.WIFI_CLK_EN.Reg)
}

// APB_CTRL.WIFI_RST_EN: APB_CTRL_WIFI_RST_EN_REG
func (o *APB_CTRL_Type) SetWIFI_RST_EN(value uint32) {
	volatile.StoreUint32(&o.WIFI_RST_EN.Reg, value)
}
func (o *APB_CTRL_Type) GetWIFI_RST_EN() uint32 {
	return volatile.LoadUint32(&o.WIFI_RST_EN.Reg)
}

// APB_CTRL.HOST_INF_SEL: APB_CTRL_HOST_INF_SEL_REG
func (o *APB_CTRL_Type) SetHOST_INF_SEL_PERI_IO_SWAP(value uint32) {
	volatile.StoreUint32(&o.HOST_INF_SEL.Reg, volatile.LoadUint32(&o.HOST_INF_SEL.Reg)&^(0xff)|value)
}
func (o *APB_CTRL_Type) GetHOST_INF_SEL_PERI_IO_SWAP() uint32 {
	return volatile.LoadUint32(&o.HOST_INF_SEL.Reg) & 0xff
}

// APB_CTRL.EXT_MEM_PMS_LOCK: APB_CTRL_EXT_MEM_PMS_LOCK_REG
func (o *APB_CTRL_Type) SetEXT_MEM_PMS_LOCK(value uint32) {
	volatile.StoreUint32(&o.EXT_MEM_PMS_LOCK.Reg, volatile.LoadUint32(&o.EXT_MEM_PMS_LOCK.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetEXT_MEM_PMS_LOCK() uint32 {
	return volatile.LoadUint32(&o.EXT_MEM_PMS_LOCK.Reg) & 0x1
}

// APB_CTRL.FLASH_ACE0_ATTR: APB_CTRL_FLASH_ACE0_ATTR_REG
func (o *APB_CTRL_Type) SetFLASH_ACE0_ATTR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE0_ATTR.Reg, volatile.LoadUint32(&o.FLASH_ACE0_ATTR.Reg)&^(0x3)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE0_ATTR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE0_ATTR.Reg) & 0x3
}

// APB_CTRL.FLASH_ACE1_ATTR: APB_CTRL_FLASH_ACE1_ATTR_REG
func (o *APB_CTRL_Type) SetFLASH_ACE1_ATTR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE1_ATTR.Reg, volatile.LoadUint32(&o.FLASH_ACE1_ATTR.Reg)&^(0x3)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE1_ATTR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE1_ATTR.Reg) & 0x3
}

// APB_CTRL.FLASH_ACE2_ATTR: APB_CTRL_FLASH_ACE2_ATTR_REG
func (o *APB_CTRL_Type) SetFLASH_ACE2_ATTR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE2_ATTR.Reg, volatile.LoadUint32(&o.FLASH_ACE2_ATTR.Reg)&^(0x3)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE2_ATTR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE2_ATTR.Reg) & 0x3
}

// APB_CTRL.FLASH_ACE3_ATTR: APB_CTRL_FLASH_ACE3_ATTR_REG
func (o *APB_CTRL_Type) SetFLASH_ACE3_ATTR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE3_ATTR.Reg, volatile.LoadUint32(&o.FLASH_ACE3_ATTR.Reg)&^(0x3)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE3_ATTR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE3_ATTR.Reg) & 0x3
}

// APB_CTRL.FLASH_ACE0_ADDR: APB_CTRL_FLASH_ACE0_ADDR_REG
func (o *APB_CTRL_Type) SetFLASH_ACE0_ADDR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE0_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE0_ADDR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE0_ADDR.Reg)
}

// APB_CTRL.FLASH_ACE1_ADDR: APB_CTRL_FLASH_ACE1_ADDR_REG
func (o *APB_CTRL_Type) SetFLASH_ACE1_ADDR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE1_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE1_ADDR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE1_ADDR.Reg)
}

// APB_CTRL.FLASH_ACE2_ADDR: APB_CTRL_FLASH_ACE2_ADDR_REG
func (o *APB_CTRL_Type) SetFLASH_ACE2_ADDR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE2_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE2_ADDR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE2_ADDR.Reg)
}

// APB_CTRL.FLASH_ACE3_ADDR: APB_CTRL_FLASH_ACE3_ADDR_REG
func (o *APB_CTRL_Type) SetFLASH_ACE3_ADDR(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE3_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE3_ADDR() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE3_ADDR.Reg)
}

// APB_CTRL.FLASH_ACE0_SIZE: APB_CTRL_FLASH_ACE0_SIZE_REG
func (o *APB_CTRL_Type) SetFLASH_ACE0_SIZE(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE0_SIZE.Reg, volatile.LoadUint32(&o.FLASH_ACE0_SIZE.Reg)&^(0x1fff)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE0_SIZE() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE0_SIZE.Reg) & 0x1fff
}

// APB_CTRL.FLASH_ACE1_SIZE: APB_CTRL_FLASH_ACE1_SIZE_REG
func (o *APB_CTRL_Type) SetFLASH_ACE1_SIZE(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE1_SIZE.Reg, volatile.LoadUint32(&o.FLASH_ACE1_SIZE.Reg)&^(0x1fff)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE1_SIZE() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE1_SIZE.Reg) & 0x1fff
}

// APB_CTRL.FLASH_ACE2_SIZE: APB_CTRL_FLASH_ACE2_SIZE_REG
func (o *APB_CTRL_Type) SetFLASH_ACE2_SIZE(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE2_SIZE.Reg, volatile.LoadUint32(&o.FLASH_ACE2_SIZE.Reg)&^(0x1fff)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE2_SIZE() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE2_SIZE.Reg) & 0x1fff
}

// APB_CTRL.FLASH_ACE3_SIZE: APB_CTRL_FLASH_ACE3_SIZE_REG
func (o *APB_CTRL_Type) SetFLASH_ACE3_SIZE(value uint32) {
	volatile.StoreUint32(&o.FLASH_ACE3_SIZE.Reg, volatile.LoadUint32(&o.FLASH_ACE3_SIZE.Reg)&^(0x1fff)|value)
}
func (o *APB_CTRL_Type) GetFLASH_ACE3_SIZE() uint32 {
	return volatile.LoadUint32(&o.FLASH_ACE3_SIZE.Reg) & 0x1fff
}

// APB_CTRL.SPI_MEM_PMS_CTRL: APB_CTRL_SPI_MEM_PMS_CTRL_REG
func (o *APB_CTRL_Type) SetSPI_MEM_PMS_CTRL_SPI_MEM_REJECT_INT(value uint32) {
	volatile.StoreUint32(&o.SPI_MEM_PMS_CTRL.Reg, volatile.LoadUint32(&o.SPI_MEM_PMS_CTRL.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetSPI_MEM_PMS_CTRL_SPI_MEM_REJECT_INT() uint32 {
	return volatile.LoadUint32(&o.SPI_MEM_PMS_CTRL.Reg) & 0x1
}
func (o *APB_CTRL_Type) SetSPI_MEM_PMS_CTRL_SPI_MEM_REJECT_CLR(value uint32) {
	volatile.StoreUint32(&o.SPI_MEM_PMS_CTRL.Reg, volatile.LoadUint32(&o.SPI_MEM_PMS_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *APB_CTRL_Type) GetSPI_MEM_PMS_CTRL_SPI_MEM_REJECT_CLR() uint32 {
	return (volatile.LoadUint32(&o.SPI_MEM_PMS_CTRL.Reg) & 0x2) >> 1
}
func (o *APB_CTRL_Type) SetSPI_MEM_PMS_CTRL_SPI_MEM_REJECT_CDE(value uint32) {
	volatile.StoreUint32(&o.SPI_MEM_PMS_CTRL.Reg, volatile.LoadUint32(&o.SPI_MEM_PMS_CTRL.Reg)&^(0x7c)|value<<2)
}
func (o *APB_CTRL_Type) GetSPI_MEM_PMS_CTRL_SPI_MEM_REJECT_CDE() uint32 {
	return (volatile.LoadUint32(&o.SPI_MEM_PMS_CTRL.Reg) & 0x7c) >> 2
}

// APB_CTRL.SPI_MEM_REJECT_ADDR: APB_CTRL_SPI_MEM_REJECT_ADDR_REG
func (o *APB_CTRL_Type) SetSPI_MEM_REJECT_ADDR(value uint32) {
	volatile.StoreUint32(&o.SPI_MEM_REJECT_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetSPI_MEM_REJECT_ADDR() uint32 {
	return volatile.LoadUint32(&o.SPI_MEM_REJECT_ADDR.Reg)
}

// APB_CTRL.SDIO_CTRL: APB_CTRL_SDIO_CTRL_REG
func (o *APB_CTRL_Type) SetSDIO_CTRL_SDIO_WIN_ACCESS_EN(value uint32) {
	volatile.StoreUint32(&o.SDIO_CTRL.Reg, volatile.LoadUint32(&o.SDIO_CTRL.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetSDIO_CTRL_SDIO_WIN_ACCESS_EN() uint32 {
	return volatile.LoadUint32(&o.SDIO_CTRL.Reg) & 0x1
}

// APB_CTRL.REDCY_SIG0: APB_CTRL_REDCY_SIG0_REG_REG
func (o *APB_CTRL_Type) SetREDCY_SIG0(value uint32) {
	volatile.StoreUint32(&o.REDCY_SIG0.Reg, volatile.LoadUint32(&o.REDCY_SIG0.Reg)&^(0x7fffffff)|value)
}
func (o *APB_CTRL_Type) GetREDCY_SIG0() uint32 {
	return volatile.LoadUint32(&o.REDCY_SIG0.Reg) & 0x7fffffff
}
func (o *APB_CTRL_Type) SetREDCY_SIG0_REDCY_ANDOR(value uint32) {
	volatile.StoreUint32(&o.REDCY_SIG0.Reg, volatile.LoadUint32(&o.REDCY_SIG0.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_CTRL_Type) GetREDCY_SIG0_REDCY_ANDOR() uint32 {
	return (volatile.LoadUint32(&o.REDCY_SIG0.Reg) & 0x80000000) >> 31
}

// APB_CTRL.REDCY_SIG1: APB_CTRL_REDCY_SIG1_REG_REG
func (o *APB_CTRL_Type) SetREDCY_SIG1(value uint32) {
	volatile.StoreUint32(&o.REDCY_SIG1.Reg, volatile.LoadUint32(&o.REDCY_SIG1.Reg)&^(0x7fffffff)|value)
}
func (o *APB_CTRL_Type) GetREDCY_SIG1() uint32 {
	return volatile.LoadUint32(&o.REDCY_SIG1.Reg) & 0x7fffffff
}
func (o *APB_CTRL_Type) SetREDCY_SIG1_REDCY_NANDOR(value uint32) {
	volatile.StoreUint32(&o.REDCY_SIG1.Reg, volatile.LoadUint32(&o.REDCY_SIG1.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_CTRL_Type) GetREDCY_SIG1_REDCY_NANDOR() uint32 {
	return (volatile.LoadUint32(&o.REDCY_SIG1.Reg) & 0x80000000) >> 31
}

// APB_CTRL.FRONT_END_MEM_PD: APB_CTRL_FRONT_END_MEM_PD_REG
func (o *APB_CTRL_Type) SetFRONT_END_MEM_PD_AGC_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetFRONT_END_MEM_PD_AGC_MEM_FORCE_PU() uint32 {
	return volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x1
}
func (o *APB_CTRL_Type) SetFRONT_END_MEM_PD_AGC_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x2)|value<<1)
}
func (o *APB_CTRL_Type) GetFRONT_END_MEM_PD_AGC_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x2) >> 1
}
func (o *APB_CTRL_Type) SetFRONT_END_MEM_PD_PBUS_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x4)|value<<2)
}
func (o *APB_CTRL_Type) GetFRONT_END_MEM_PD_PBUS_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x4) >> 2
}
func (o *APB_CTRL_Type) SetFRONT_END_MEM_PD_PBUS_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x8)|value<<3)
}
func (o *APB_CTRL_Type) GetFRONT_END_MEM_PD_PBUS_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x8) >> 3
}
func (o *APB_CTRL_Type) SetFRONT_END_MEM_PD_DC_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x10)|value<<4)
}
func (o *APB_CTRL_Type) GetFRONT_END_MEM_PD_DC_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x10) >> 4
}
func (o *APB_CTRL_Type) SetFRONT_END_MEM_PD_DC_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x20)|value<<5)
}
func (o *APB_CTRL_Type) GetFRONT_END_MEM_PD_DC_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x20) >> 5
}
func (o *APB_CTRL_Type) SetFRONT_END_MEM_PD_FREQ_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x40)|value<<6)
}
func (o *APB_CTRL_Type) GetFRONT_END_MEM_PD_FREQ_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x40) >> 6
}
func (o *APB_CTRL_Type) SetFRONT_END_MEM_PD_FREQ_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.FRONT_END_MEM_PD.Reg, volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg)&^(0x80)|value<<7)
}
func (o *APB_CTRL_Type) GetFRONT_END_MEM_PD_FREQ_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.FRONT_END_MEM_PD.Reg) & 0x80) >> 7
}

// APB_CTRL.RETENTION_CTRL: APB_CTRL_RETENTION_CTRL_REG
func (o *APB_CTRL_Type) SetRETENTION_CTRL_RETENTION_LINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.RETENTION_CTRL.Reg, volatile.LoadUint32(&o.RETENTION_CTRL.Reg)&^(0x7ffffff)|value)
}
func (o *APB_CTRL_Type) GetRETENTION_CTRL_RETENTION_LINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.RETENTION_CTRL.Reg) & 0x7ffffff
}
func (o *APB_CTRL_Type) SetRETENTION_CTRL_NOBYPASS_CPU_ISO_RST(value uint32) {
	volatile.StoreUint32(&o.RETENTION_CTRL.Reg, volatile.LoadUint32(&o.RETENTION_CTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_CTRL_Type) GetRETENTION_CTRL_NOBYPASS_CPU_ISO_RST() uint32 {
	return (volatile.LoadUint32(&o.RETENTION_CTRL.Reg) & 0x8000000) >> 27
}

// APB_CTRL.CLKGATE_FORCE_ON: Memory power configuration registers
func (o *APB_CTRL_Type) SetCLKGATE_FORCE_ON_ROM_CLKGATE_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.CLKGATE_FORCE_ON.Reg, volatile.LoadUint32(&o.CLKGATE_FORCE_ON.Reg)&^(0x7)|value)
}
func (o *APB_CTRL_Type) GetCLKGATE_FORCE_ON_ROM_CLKGATE_FORCE_ON() uint32 {
	return volatile.LoadUint32(&o.CLKGATE_FORCE_ON.Reg) & 0x7
}
func (o *APB_CTRL_Type) SetCLKGATE_FORCE_ON_SRAM_CLKGATE_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.CLKGATE_FORCE_ON.Reg, volatile.LoadUint32(&o.CLKGATE_FORCE_ON.Reg)&^(0x78)|value<<3)
}
func (o *APB_CTRL_Type) GetCLKGATE_FORCE_ON_SRAM_CLKGATE_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.CLKGATE_FORCE_ON.Reg) & 0x78) >> 3
}

// APB_CTRL.MEM_POWER_DOWN: Memory power configuration registers
func (o *APB_CTRL_Type) SetMEM_POWER_DOWN_ROM_POWER_DOWN(value uint32) {
	volatile.StoreUint32(&o.MEM_POWER_DOWN.Reg, volatile.LoadUint32(&o.MEM_POWER_DOWN.Reg)&^(0x7)|value)
}
func (o *APB_CTRL_Type) GetMEM_POWER_DOWN_ROM_POWER_DOWN() uint32 {
	return volatile.LoadUint32(&o.MEM_POWER_DOWN.Reg) & 0x7
}
func (o *APB_CTRL_Type) SetMEM_POWER_DOWN_SRAM_POWER_DOWN(value uint32) {
	volatile.StoreUint32(&o.MEM_POWER_DOWN.Reg, volatile.LoadUint32(&o.MEM_POWER_DOWN.Reg)&^(0x78)|value<<3)
}
func (o *APB_CTRL_Type) GetMEM_POWER_DOWN_SRAM_POWER_DOWN() uint32 {
	return (volatile.LoadUint32(&o.MEM_POWER_DOWN.Reg) & 0x78) >> 3
}

// APB_CTRL.MEM_POWER_UP: Memory power configuration registers
func (o *APB_CTRL_Type) SetMEM_POWER_UP_ROM_POWER_UP(value uint32) {
	volatile.StoreUint32(&o.MEM_POWER_UP.Reg, volatile.LoadUint32(&o.MEM_POWER_UP.Reg)&^(0x7)|value)
}
func (o *APB_CTRL_Type) GetMEM_POWER_UP_ROM_POWER_UP() uint32 {
	return volatile.LoadUint32(&o.MEM_POWER_UP.Reg) & 0x7
}
func (o *APB_CTRL_Type) SetMEM_POWER_UP_SRAM_POWER_UP(value uint32) {
	volatile.StoreUint32(&o.MEM_POWER_UP.Reg, volatile.LoadUint32(&o.MEM_POWER_UP.Reg)&^(0x78)|value<<3)
}
func (o *APB_CTRL_Type) GetMEM_POWER_UP_SRAM_POWER_UP() uint32 {
	return (volatile.LoadUint32(&o.MEM_POWER_UP.Reg) & 0x78) >> 3
}

// APB_CTRL.RND_DATA: APB_CTRL_RND_DATA_REG
func (o *APB_CTRL_Type) SetRND_DATA(value uint32) {
	volatile.StoreUint32(&o.RND_DATA.Reg, value)
}
func (o *APB_CTRL_Type) GetRND_DATA() uint32 {
	return volatile.LoadUint32(&o.RND_DATA.Reg)
}

// APB_CTRL.PERI_BACKUP_CONFIG: APB_CTRL_PERI_BACKUP_CONFIG_REG_REG
func (o *APB_CTRL_Type) SetPERI_BACKUP_CONFIG_PERI_BACKUP_FLOW_ERR(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_CONFIG.Reg, volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg)&^(0x6)|value<<1)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_CONFIG_PERI_BACKUP_FLOW_ERR() uint32 {
	return (volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg) & 0x6) >> 1
}
func (o *APB_CTRL_Type) SetPERI_BACKUP_CONFIG_PERI_BACKUP_BURST_LIMIT(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_CONFIG.Reg, volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg)&^(0x1f0)|value<<4)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_CONFIG_PERI_BACKUP_BURST_LIMIT() uint32 {
	return (volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg) & 0x1f0) >> 4
}
func (o *APB_CTRL_Type) SetPERI_BACKUP_CONFIG_PERI_BACKUP_TOUT_THRES(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_CONFIG.Reg, volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg)&^(0x7fe00)|value<<9)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_CONFIG_PERI_BACKUP_TOUT_THRES() uint32 {
	return (volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg) & 0x7fe00) >> 9
}
func (o *APB_CTRL_Type) SetPERI_BACKUP_CONFIG_PERI_BACKUP_SIZE(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_CONFIG.Reg, volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg)&^(0x1ff80000)|value<<19)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_CONFIG_PERI_BACKUP_SIZE() uint32 {
	return (volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg) & 0x1ff80000) >> 19
}
func (o *APB_CTRL_Type) SetPERI_BACKUP_CONFIG_PERI_BACKUP_START(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_CONFIG.Reg, volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_CONFIG_PERI_BACKUP_START() uint32 {
	return (volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg) & 0x20000000) >> 29
}
func (o *APB_CTRL_Type) SetPERI_BACKUP_CONFIG_PERI_BACKUP_TO_MEM(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_CONFIG.Reg, volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_CONFIG_PERI_BACKUP_TO_MEM() uint32 {
	return (volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg) & 0x40000000) >> 30
}
func (o *APB_CTRL_Type) SetPERI_BACKUP_CONFIG_PERI_BACKUP_ENA(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_CONFIG.Reg, volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_CONFIG_PERI_BACKUP_ENA() uint32 {
	return (volatile.LoadUint32(&o.PERI_BACKUP_CONFIG.Reg) & 0x80000000) >> 31
}

// APB_CTRL.PERI_BACKUP_APB_ADDR: APB_CTRL_PERI_BACKUP_APB_ADDR_REG_REG
func (o *APB_CTRL_Type) SetPERI_BACKUP_APB_ADDR(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_APB_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_APB_ADDR() uint32 {
	return volatile.LoadUint32(&o.PERI_BACKUP_APB_ADDR.Reg)
}

// APB_CTRL.PERI_BACKUP_MEM_ADDR: APB_CTRL_PERI_BACKUP_MEM_ADDR_REG_REG
func (o *APB_CTRL_Type) SetPERI_BACKUP_MEM_ADDR(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_MEM_ADDR.Reg, value)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_MEM_ADDR() uint32 {
	return volatile.LoadUint32(&o.PERI_BACKUP_MEM_ADDR.Reg)
}

// APB_CTRL.PERI_BACKUP_INT_RAW: APB_CTRL_PERI_BACKUP_INT_RAW_REG
func (o *APB_CTRL_Type) SetPERI_BACKUP_INT_RAW_PERI_BACKUP_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_INT_RAW.Reg, volatile.LoadUint32(&o.PERI_BACKUP_INT_RAW.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_INT_RAW_PERI_BACKUP_DONE_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.PERI_BACKUP_INT_RAW.Reg) & 0x1
}
func (o *APB_CTRL_Type) SetPERI_BACKUP_INT_RAW_PERI_BACKUP_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_INT_RAW.Reg, volatile.LoadUint32(&o.PERI_BACKUP_INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_INT_RAW_PERI_BACKUP_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.PERI_BACKUP_INT_RAW.Reg) & 0x2) >> 1
}

// APB_CTRL.PERI_BACKUP_INT_ST: APB_CTRL_PERI_BACKUP_INT_ST_REG
func (o *APB_CTRL_Type) SetPERI_BACKUP_INT_ST_PERI_BACKUP_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_INT_ST.Reg, volatile.LoadUint32(&o.PERI_BACKUP_INT_ST.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_INT_ST_PERI_BACKUP_DONE_INT_ST() uint32 {
	return volatile.LoadUint32(&o.PERI_BACKUP_INT_ST.Reg) & 0x1
}
func (o *APB_CTRL_Type) SetPERI_BACKUP_INT_ST_PERI_BACKUP_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_INT_ST.Reg, volatile.LoadUint32(&o.PERI_BACKUP_INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_INT_ST_PERI_BACKUP_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.PERI_BACKUP_INT_ST.Reg) & 0x2) >> 1
}

// APB_CTRL.PERI_BACKUP_INT_ENA: APB_CTRL_PERI_BACKUP_INT_ENA_REG
func (o *APB_CTRL_Type) SetPERI_BACKUP_INT_ENA_PERI_BACKUP_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_INT_ENA.Reg, volatile.LoadUint32(&o.PERI_BACKUP_INT_ENA.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_INT_ENA_PERI_BACKUP_DONE_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.PERI_BACKUP_INT_ENA.Reg) & 0x1
}
func (o *APB_CTRL_Type) SetPERI_BACKUP_INT_ENA_PERI_BACKUP_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_INT_ENA.Reg, volatile.LoadUint32(&o.PERI_BACKUP_INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_INT_ENA_PERI_BACKUP_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PERI_BACKUP_INT_ENA.Reg) & 0x2) >> 1
}

// APB_CTRL.PERI_BACKUP_INT_CLR: APB_CTRL_PERI_BACKUP_INT_CLR_REG
func (o *APB_CTRL_Type) SetPERI_BACKUP_INT_CLR_PERI_BACKUP_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_INT_CLR.Reg, volatile.LoadUint32(&o.PERI_BACKUP_INT_CLR.Reg)&^(0x1)|value)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_INT_CLR_PERI_BACKUP_DONE_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.PERI_BACKUP_INT_CLR.Reg) & 0x1
}
func (o *APB_CTRL_Type) SetPERI_BACKUP_INT_CLR_PERI_BACKUP_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.PERI_BACKUP_INT_CLR.Reg, volatile.LoadUint32(&o.PERI_BACKUP_INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *APB_CTRL_Type) GetPERI_BACKUP_INT_CLR_PERI_BACKUP_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.PERI_BACKUP_INT_CLR.Reg) & 0x2) >> 1
}

// APB_CTRL.DATE: APB_CTRL_DATE_REG
func (o *APB_CTRL_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *APB_CTRL_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// SAR (Successive Approximation Register) Analog-to-Digital Converter
type APB_SARADC_Type struct {
	CTRL              volatile.Register32 // 0x0
	CTRL2             volatile.Register32 // 0x4
	FILTER_CTRL1      volatile.Register32 // 0x8
	FSM_WAIT          volatile.Register32 // 0xC
	SAR1_STATUS       volatile.Register32 // 0x10
	SAR2_STATUS       volatile.Register32 // 0x14
	SAR_PATT_TAB1     volatile.Register32 // 0x18
	SAR_PATT_TAB2     volatile.Register32 // 0x1C
	ONETIME_SAMPLE    volatile.Register32 // 0x20
	APB_ADC_ARB_CTRL  volatile.Register32 // 0x24
	FILTER_CTRL0      volatile.Register32 // 0x28
	SAR1DATA_STATUS   volatile.Register32 // 0x2C
	SAR2DATA_STATUS   volatile.Register32 // 0x30
	THRES0_CTRL       volatile.Register32 // 0x34
	THRES1_CTRL       volatile.Register32 // 0x38
	THRES_CTRL        volatile.Register32 // 0x3C
	INT_ENA           volatile.Register32 // 0x40
	INT_RAW           volatile.Register32 // 0x44
	INT_ST            volatile.Register32 // 0x48
	INT_CLR           volatile.Register32 // 0x4C
	DMA_CONF          volatile.Register32 // 0x50
	APB_ADC_CLKM_CONF volatile.Register32 // 0x54
	APB_TSENS_CTRL    volatile.Register32 // 0x58
	APB_TSENS_CTRL2   volatile.Register32 // 0x5C
	CALI              volatile.Register32 // 0x60
	_                 [920]byte
	APB_CTRL_DATE     volatile.Register32 // 0x3FC
}

// APB_SARADC.CTRL: register description
func (o *APB_SARADC_Type) SetCTRL_SARADC_START_FORCE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_START_FORCE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_START(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_START() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_SAR_CLK_GATED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40)|value<<6)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_SAR_CLK_GATED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40) >> 6
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_SAR_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x7f80)|value<<7)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_SAR_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x7f80) >> 7
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_SAR_PATT_LEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x38000)|value<<15)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_SAR_PATT_LEN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x38000) >> 15
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_SAR_PATT_P_CLEAR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x800000)|value<<23)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_SAR_PATT_P_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x800000) >> 23
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_XPD_SAR_FORCE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x18000000)|value<<27)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_XPD_SAR_FORCE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x18000000) >> 27
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_WAIT_ARB_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xc0000000)|value<<30)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_WAIT_ARB_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xc0000000) >> 30
}

// APB_SARADC.CTRL2: register description
func (o *APB_SARADC_Type) SetCTRL2_SARADC_MEAS_NUM_LIMIT(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x1)|value)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_MEAS_NUM_LIMIT() uint32 {
	return volatile.LoadUint32(&o.CTRL2.Reg) & 0x1
}
func (o *APB_SARADC_Type) SetCTRL2_SARADC_MAX_MEAS_NUM(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x1fe)|value<<1)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_MAX_MEAS_NUM() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x1fe) >> 1
}
func (o *APB_SARADC_Type) SetCTRL2_SARADC_SAR1_INV(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x200)|value<<9)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_SAR1_INV() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x200) >> 9
}
func (o *APB_SARADC_Type) SetCTRL2_SARADC_SAR2_INV(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x400)|value<<10)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_SAR2_INV() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x400) >> 10
}
func (o *APB_SARADC_Type) SetCTRL2_SARADC_TIMER_TARGET(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0xfff000)|value<<12)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_TIMER_TARGET() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0xfff000) >> 12
}
func (o *APB_SARADC_Type) SetCTRL2_SARADC_TIMER_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x1000000)|value<<24)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_TIMER_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x1000000) >> 24
}

// APB_SARADC.FILTER_CTRL1: register description
func (o *APB_SARADC_Type) SetFILTER_CTRL1_FILTER_FACTOR1(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL1.Reg, volatile.LoadUint32(&o.FILTER_CTRL1.Reg)&^(0x1c000000)|value<<26)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL1_FILTER_FACTOR1() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL1.Reg) & 0x1c000000) >> 26
}
func (o *APB_SARADC_Type) SetFILTER_CTRL1_FILTER_FACTOR0(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL1.Reg, volatile.LoadUint32(&o.FILTER_CTRL1.Reg)&^(0xe0000000)|value<<29)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL1_FILTER_FACTOR0() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL1.Reg) & 0xe0000000) >> 29
}

// APB_SARADC.FSM_WAIT: register description
func (o *APB_SARADC_Type) SetFSM_WAIT_SARADC_XPD_WAIT(value uint32) {
	volatile.StoreUint32(&o.FSM_WAIT.Reg, volatile.LoadUint32(&o.FSM_WAIT.Reg)&^(0xff)|value)
}
func (o *APB_SARADC_Type) GetFSM_WAIT_SARADC_XPD_WAIT() uint32 {
	return volatile.LoadUint32(&o.FSM_WAIT.Reg) & 0xff
}
func (o *APB_SARADC_Type) SetFSM_WAIT_SARADC_RSTB_WAIT(value uint32) {
	volatile.StoreUint32(&o.FSM_WAIT.Reg, volatile.LoadUint32(&o.FSM_WAIT.Reg)&^(0xff00)|value<<8)
}
func (o *APB_SARADC_Type) GetFSM_WAIT_SARADC_RSTB_WAIT() uint32 {
	return (volatile.LoadUint32(&o.FSM_WAIT.Reg) & 0xff00) >> 8
}
func (o *APB_SARADC_Type) SetFSM_WAIT_SARADC_STANDBY_WAIT(value uint32) {
	volatile.StoreUint32(&o.FSM_WAIT.Reg, volatile.LoadUint32(&o.FSM_WAIT.Reg)&^(0xff0000)|value<<16)
}
func (o *APB_SARADC_Type) GetFSM_WAIT_SARADC_STANDBY_WAIT() uint32 {
	return (volatile.LoadUint32(&o.FSM_WAIT.Reg) & 0xff0000) >> 16
}

// APB_SARADC.SAR1_STATUS: register description
func (o *APB_SARADC_Type) SetSAR1_STATUS(value uint32) {
	volatile.StoreUint32(&o.SAR1_STATUS.Reg, value)
}
func (o *APB_SARADC_Type) GetSAR1_STATUS() uint32 {
	return volatile.LoadUint32(&o.SAR1_STATUS.Reg)
}

// APB_SARADC.SAR2_STATUS: register description
func (o *APB_SARADC_Type) SetSAR2_STATUS(value uint32) {
	volatile.StoreUint32(&o.SAR2_STATUS.Reg, value)
}
func (o *APB_SARADC_Type) GetSAR2_STATUS() uint32 {
	return volatile.LoadUint32(&o.SAR2_STATUS.Reg)
}

// APB_SARADC.SAR_PATT_TAB1: register description
func (o *APB_SARADC_Type) SetSAR_PATT_TAB1_SARADC_SAR_PATT_TAB1(value uint32) {
	volatile.StoreUint32(&o.SAR_PATT_TAB1.Reg, volatile.LoadUint32(&o.SAR_PATT_TAB1.Reg)&^(0xffffff)|value)
}
func (o *APB_SARADC_Type) GetSAR_PATT_TAB1_SARADC_SAR_PATT_TAB1() uint32 {
	return volatile.LoadUint32(&o.SAR_PATT_TAB1.Reg) & 0xffffff
}

// APB_SARADC.SAR_PATT_TAB2: register description
func (o *APB_SARADC_Type) SetSAR_PATT_TAB2_SARADC_SAR_PATT_TAB2(value uint32) {
	volatile.StoreUint32(&o.SAR_PATT_TAB2.Reg, volatile.LoadUint32(&o.SAR_PATT_TAB2.Reg)&^(0xffffff)|value)
}
func (o *APB_SARADC_Type) GetSAR_PATT_TAB2_SARADC_SAR_PATT_TAB2() uint32 {
	return volatile.LoadUint32(&o.SAR_PATT_TAB2.Reg) & 0xffffff
}

// APB_SARADC.ONETIME_SAMPLE: register description
func (o *APB_SARADC_Type) SetONETIME_SAMPLE_SARADC_ONETIME_ATTEN(value uint32) {
	volatile.StoreUint32(&o.ONETIME_SAMPLE.Reg, volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg)&^(0x1800000)|value<<23)
}
func (o *APB_SARADC_Type) GetONETIME_SAMPLE_SARADC_ONETIME_ATTEN() uint32 {
	return (volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg) & 0x1800000) >> 23
}
func (o *APB_SARADC_Type) SetONETIME_SAMPLE_SARADC_ONETIME_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.ONETIME_SAMPLE.Reg, volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg)&^(0x1e000000)|value<<25)
}
func (o *APB_SARADC_Type) GetONETIME_SAMPLE_SARADC_ONETIME_CHANNEL() uint32 {
	return (volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg) & 0x1e000000) >> 25
}
func (o *APB_SARADC_Type) SetONETIME_SAMPLE_SARADC_ONETIME_START(value uint32) {
	volatile.StoreUint32(&o.ONETIME_SAMPLE.Reg, volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetONETIME_SAMPLE_SARADC_ONETIME_START() uint32 {
	return (volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetONETIME_SAMPLE_SARADC2_ONETIME_SAMPLE(value uint32) {
	volatile.StoreUint32(&o.ONETIME_SAMPLE.Reg, volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetONETIME_SAMPLE_SARADC2_ONETIME_SAMPLE() uint32 {
	return (volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetONETIME_SAMPLE_SARADC1_ONETIME_SAMPLE(value uint32) {
	volatile.StoreUint32(&o.ONETIME_SAMPLE.Reg, volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetONETIME_SAMPLE_SARADC1_ONETIME_SAMPLE() uint32 {
	return (volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg) & 0x80000000) >> 31
}

// APB_SARADC.APB_ADC_ARB_CTRL: register description
func (o *APB_SARADC_Type) SetAPB_ADC_ARB_CTRL_ADC_ARB_APB_FORCE(value uint32) {
	volatile.StoreUint32(&o.APB_ADC_ARB_CTRL.Reg, volatile.LoadUint32(&o.APB_ADC_ARB_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *APB_SARADC_Type) GetAPB_ADC_ARB_CTRL_ADC_ARB_APB_FORCE() uint32 {
	return (volatile.LoadUint32(&o.APB_ADC_ARB_CTRL.Reg) & 0x4) >> 2
}
func (o *APB_SARADC_Type) SetAPB_ADC_ARB_CTRL_ADC_ARB_RTC_FORCE(value uint32) {
	volatile.StoreUint32(&o.APB_ADC_ARB_CTRL.Reg, volatile.LoadUint32(&o.APB_ADC_ARB_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *APB_SARADC_Type) GetAPB_ADC_ARB_CTRL_ADC_ARB_RTC_FORCE() uint32 {
	return (volatile.LoadUint32(&o.APB_ADC_ARB_CTRL.Reg) & 0x8) >> 3
}
func (o *APB_SARADC_Type) SetAPB_ADC_ARB_CTRL_ADC_ARB_WIFI_FORCE(value uint32) {
	volatile.StoreUint32(&o.APB_ADC_ARB_CTRL.Reg, volatile.LoadUint32(&o.APB_ADC_ARB_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *APB_SARADC_Type) GetAPB_ADC_ARB_CTRL_ADC_ARB_WIFI_FORCE() uint32 {
	return (volatile.LoadUint32(&o.APB_ADC_ARB_CTRL.Reg) & 0x10) >> 4
}
func (o *APB_SARADC_Type) SetAPB_ADC_ARB_CTRL_ADC_ARB_GRANT_FORCE(value uint32) {
	volatile.StoreUint32(&o.APB_ADC_ARB_CTRL.Reg, volatile.LoadUint32(&o.APB_ADC_ARB_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *APB_SARADC_Type) GetAPB_ADC_ARB_CTRL_ADC_ARB_GRANT_FORCE() uint32 {
	return (volatile.LoadUint32(&o.APB_ADC_ARB_CTRL.Reg) & 0x20) >> 5
}
func (o *APB_SARADC_Type) SetAPB_ADC_ARB_CTRL_ADC_ARB_APB_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.APB_ADC_ARB_CTRL.Reg, volatile.LoadUint32(&o.APB_ADC_ARB_CTRL.Reg)&^(0xc0)|value<<6)
}
func (o *APB_SARADC_Type) GetAPB_ADC_ARB_CTRL_ADC_ARB_APB_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.APB_ADC_ARB_CTRL.Reg) & 0xc0) >> 6
}
func (o *APB_SARADC_Type) SetAPB_ADC_ARB_CTRL_ADC_ARB_RTC_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.APB_ADC_ARB_CTRL.Reg, volatile.LoadUint32(&o.APB_ADC_ARB_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *APB_SARADC_Type) GetAPB_ADC_ARB_CTRL_ADC_ARB_RTC_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.APB_ADC_ARB_CTRL.Reg) & 0x300) >> 8
}
func (o *APB_SARADC_Type) SetAPB_ADC_ARB_CTRL_ADC_ARB_WIFI_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.APB_ADC_ARB_CTRL.Reg, volatile.LoadUint32(&o.APB_ADC_ARB_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *APB_SARADC_Type) GetAPB_ADC_ARB_CTRL_ADC_ARB_WIFI_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.APB_ADC_ARB_CTRL.Reg) & 0xc00) >> 10
}
func (o *APB_SARADC_Type) SetAPB_ADC_ARB_CTRL_ADC_ARB_FIX_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.APB_ADC_ARB_CTRL.Reg, volatile.LoadUint32(&o.APB_ADC_ARB_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *APB_SARADC_Type) GetAPB_ADC_ARB_CTRL_ADC_ARB_FIX_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.APB_ADC_ARB_CTRL.Reg) & 0x1000) >> 12
}

// APB_SARADC.FILTER_CTRL0: register description
func (o *APB_SARADC_Type) SetFILTER_CTRL0_FILTER_CHANNEL1(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL0.Reg, volatile.LoadUint32(&o.FILTER_CTRL0.Reg)&^(0x3c0000)|value<<18)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL0_FILTER_CHANNEL1() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL0.Reg) & 0x3c0000) >> 18
}
func (o *APB_SARADC_Type) SetFILTER_CTRL0_FILTER_CHANNEL0(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL0.Reg, volatile.LoadUint32(&o.FILTER_CTRL0.Reg)&^(0x3c00000)|value<<22)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL0_FILTER_CHANNEL0() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL0.Reg) & 0x3c00000) >> 22
}
func (o *APB_SARADC_Type) SetFILTER_CTRL0_FILTER_RESET(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL0.Reg, volatile.LoadUint32(&o.FILTER_CTRL0.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL0_FILTER_RESET() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL0.Reg) & 0x80000000) >> 31
}

// APB_SARADC.SAR1DATA_STATUS: register description
func (o *APB_SARADC_Type) SetSAR1DATA_STATUS_APB_SARADC1_DATA(value uint32) {
	volatile.StoreUint32(&o.SAR1DATA_STATUS.Reg, volatile.LoadUint32(&o.SAR1DATA_STATUS.Reg)&^(0x1ffff)|value)
}
func (o *APB_SARADC_Type) GetSAR1DATA_STATUS_APB_SARADC1_DATA() uint32 {
	return volatile.LoadUint32(&o.SAR1DATA_STATUS.Reg) & 0x1ffff
}

// APB_SARADC.SAR2DATA_STATUS: register description
func (o *APB_SARADC_Type) SetSAR2DATA_STATUS_APB_SARADC2_DATA(value uint32) {
	volatile.StoreUint32(&o.SAR2DATA_STATUS.Reg, volatile.LoadUint32(&o.SAR2DATA_STATUS.Reg)&^(0x1ffff)|value)
}
func (o *APB_SARADC_Type) GetSAR2DATA_STATUS_APB_SARADC2_DATA() uint32 {
	return volatile.LoadUint32(&o.SAR2DATA_STATUS.Reg) & 0x1ffff
}

// APB_SARADC.THRES0_CTRL: register description
func (o *APB_SARADC_Type) SetTHRES0_CTRL_THRES0_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.THRES0_CTRL.Reg, volatile.LoadUint32(&o.THRES0_CTRL.Reg)&^(0xf)|value)
}
func (o *APB_SARADC_Type) GetTHRES0_CTRL_THRES0_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.THRES0_CTRL.Reg) & 0xf
}
func (o *APB_SARADC_Type) SetTHRES0_CTRL_THRES0_HIGH(value uint32) {
	volatile.StoreUint32(&o.THRES0_CTRL.Reg, volatile.LoadUint32(&o.THRES0_CTRL.Reg)&^(0x3ffe0)|value<<5)
}
func (o *APB_SARADC_Type) GetTHRES0_CTRL_THRES0_HIGH() uint32 {
	return (volatile.LoadUint32(&o.THRES0_CTRL.Reg) & 0x3ffe0) >> 5
}
func (o *APB_SARADC_Type) SetTHRES0_CTRL_THRES0_LOW(value uint32) {
	volatile.StoreUint32(&o.THRES0_CTRL.Reg, volatile.LoadUint32(&o.THRES0_CTRL.Reg)&^(0x7ffc0000)|value<<18)
}
func (o *APB_SARADC_Type) GetTHRES0_CTRL_THRES0_LOW() uint32 {
	return (volatile.LoadUint32(&o.THRES0_CTRL.Reg) & 0x7ffc0000) >> 18
}

// APB_SARADC.THRES1_CTRL: register description
func (o *APB_SARADC_Type) SetTHRES1_CTRL_THRES1_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.THRES1_CTRL.Reg, volatile.LoadUint32(&o.THRES1_CTRL.Reg)&^(0xf)|value)
}
func (o *APB_SARADC_Type) GetTHRES1_CTRL_THRES1_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.THRES1_CTRL.Reg) & 0xf
}
func (o *APB_SARADC_Type) SetTHRES1_CTRL_THRES1_HIGH(value uint32) {
	volatile.StoreUint32(&o.THRES1_CTRL.Reg, volatile.LoadUint32(&o.THRES1_CTRL.Reg)&^(0x3ffe0)|value<<5)
}
func (o *APB_SARADC_Type) GetTHRES1_CTRL_THRES1_HIGH() uint32 {
	return (volatile.LoadUint32(&o.THRES1_CTRL.Reg) & 0x3ffe0) >> 5
}
func (o *APB_SARADC_Type) SetTHRES1_CTRL_THRES1_LOW(value uint32) {
	volatile.StoreUint32(&o.THRES1_CTRL.Reg, volatile.LoadUint32(&o.THRES1_CTRL.Reg)&^(0x7ffc0000)|value<<18)
}
func (o *APB_SARADC_Type) GetTHRES1_CTRL_THRES1_LOW() uint32 {
	return (volatile.LoadUint32(&o.THRES1_CTRL.Reg) & 0x7ffc0000) >> 18
}

// APB_SARADC.THRES_CTRL: register description
func (o *APB_SARADC_Type) SetTHRES_CTRL_THRES_ALL_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_THRES_ALL_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x8000000) >> 27
}
func (o *APB_SARADC_Type) SetTHRES_CTRL_THRES3_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_THRES3_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x10000000) >> 28
}
func (o *APB_SARADC_Type) SetTHRES_CTRL_THRES2_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_THRES2_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetTHRES_CTRL_THRES1_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_THRES1_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetTHRES_CTRL_THRES0_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_THRES0_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x80000000) >> 31
}

// APB_SARADC.INT_ENA: register description
func (o *APB_SARADC_Type) SetINT_ENA_THRES1_LOW_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4000000)|value<<26)
}
func (o *APB_SARADC_Type) GetINT_ENA_THRES1_LOW_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4000000) >> 26
}
func (o *APB_SARADC_Type) SetINT_ENA_THRES0_LOW_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_SARADC_Type) GetINT_ENA_THRES0_LOW_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8000000) >> 27
}
func (o *APB_SARADC_Type) SetINT_ENA_THRES1_HIGH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10000000)|value<<28)
}
func (o *APB_SARADC_Type) GetINT_ENA_THRES1_HIGH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10000000) >> 28
}
func (o *APB_SARADC_Type) SetINT_ENA_THRES0_HIGH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetINT_ENA_THRES0_HIGH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetINT_ENA_APB_SARADC2_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetINT_ENA_APB_SARADC2_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetINT_ENA_APB_SARADC1_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetINT_ENA_APB_SARADC1_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80000000) >> 31
}

// APB_SARADC.INT_RAW: register description
func (o *APB_SARADC_Type) SetINT_RAW_THRES1_LOW_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4000000)|value<<26)
}
func (o *APB_SARADC_Type) GetINT_RAW_THRES1_LOW_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4000000) >> 26
}
func (o *APB_SARADC_Type) SetINT_RAW_THRES0_LOW_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_SARADC_Type) GetINT_RAW_THRES0_LOW_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8000000) >> 27
}
func (o *APB_SARADC_Type) SetINT_RAW_THRES1_HIGH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10000000)|value<<28)
}
func (o *APB_SARADC_Type) GetINT_RAW_THRES1_HIGH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10000000) >> 28
}
func (o *APB_SARADC_Type) SetINT_RAW_THRES0_HIGH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetINT_RAW_THRES0_HIGH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetINT_RAW_APB_SARADC2_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetINT_RAW_APB_SARADC2_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetINT_RAW_APB_SARADC1_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetINT_RAW_APB_SARADC1_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80000000) >> 31
}

// APB_SARADC.INT_ST: register description
func (o *APB_SARADC_Type) SetINT_ST_THRES1_LOW_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4000000)|value<<26)
}
func (o *APB_SARADC_Type) GetINT_ST_THRES1_LOW_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4000000) >> 26
}
func (o *APB_SARADC_Type) SetINT_ST_THRES0_LOW_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_SARADC_Type) GetINT_ST_THRES0_LOW_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x8000000) >> 27
}
func (o *APB_SARADC_Type) SetINT_ST_THRES1_HIGH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x10000000)|value<<28)
}
func (o *APB_SARADC_Type) GetINT_ST_THRES1_HIGH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x10000000) >> 28
}
func (o *APB_SARADC_Type) SetINT_ST_THRES0_HIGH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetINT_ST_THRES0_HIGH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetINT_ST_APB_SARADC2_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetINT_ST_APB_SARADC2_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetINT_ST_APB_SARADC1_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetINT_ST_APB_SARADC1_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x80000000) >> 31
}

// APB_SARADC.INT_CLR: register description
func (o *APB_SARADC_Type) SetINT_CLR_THRES1_LOW_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4000000)|value<<26)
}
func (o *APB_SARADC_Type) GetINT_CLR_THRES1_LOW_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4000000) >> 26
}
func (o *APB_SARADC_Type) SetINT_CLR_THRES0_LOW_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_SARADC_Type) GetINT_CLR_THRES0_LOW_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8000000) >> 27
}
func (o *APB_SARADC_Type) SetINT_CLR_THRES1_HIGH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10000000)|value<<28)
}
func (o *APB_SARADC_Type) GetINT_CLR_THRES1_HIGH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10000000) >> 28
}
func (o *APB_SARADC_Type) SetINT_CLR_THRES0_HIGH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetINT_CLR_THRES0_HIGH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetINT_CLR_APB_SARADC2_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetINT_CLR_APB_SARADC2_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetINT_CLR_APB_SARADC1_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetINT_CLR_APB_SARADC1_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80000000) >> 31
}

// APB_SARADC.DMA_CONF: register description
func (o *APB_SARADC_Type) SetDMA_CONF_APB_ADC_EOF_NUM(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0xffff)|value)
}
func (o *APB_SARADC_Type) GetDMA_CONF_APB_ADC_EOF_NUM() uint32 {
	return volatile.LoadUint32(&o.DMA_CONF.Reg) & 0xffff
}
func (o *APB_SARADC_Type) SetDMA_CONF_APB_ADC_RESET_FSM(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetDMA_CONF_APB_ADC_RESET_FSM() uint32 {
	return (volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetDMA_CONF_APB_ADC_TRANS(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetDMA_CONF_APB_ADC_TRANS() uint32 {
	return (volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x80000000) >> 31
}

// APB_SARADC.APB_ADC_CLKM_CONF: register description
func (o *APB_SARADC_Type) SetAPB_ADC_CLKM_CONF_REG_CLKM_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.APB_ADC_CLKM_CONF.Reg, volatile.LoadUint32(&o.APB_ADC_CLKM_CONF.Reg)&^(0xff)|value)
}
func (o *APB_SARADC_Type) GetAPB_ADC_CLKM_CONF_REG_CLKM_DIV_NUM() uint32 {
	return volatile.LoadUint32(&o.APB_ADC_CLKM_CONF.Reg) & 0xff
}
func (o *APB_SARADC_Type) SetAPB_ADC_CLKM_CONF_REG_CLKM_DIV_B(value uint32) {
	volatile.StoreUint32(&o.APB_ADC_CLKM_CONF.Reg, volatile.LoadUint32(&o.APB_ADC_CLKM_CONF.Reg)&^(0x3f00)|value<<8)
}
func (o *APB_SARADC_Type) GetAPB_ADC_CLKM_CONF_REG_CLKM_DIV_B() uint32 {
	return (volatile.LoadUint32(&o.APB_ADC_CLKM_CONF.Reg) & 0x3f00) >> 8
}
func (o *APB_SARADC_Type) SetAPB_ADC_CLKM_CONF_REG_CLKM_DIV_A(value uint32) {
	volatile.StoreUint32(&o.APB_ADC_CLKM_CONF.Reg, volatile.LoadUint32(&o.APB_ADC_CLKM_CONF.Reg)&^(0xfc000)|value<<14)
}
func (o *APB_SARADC_Type) GetAPB_ADC_CLKM_CONF_REG_CLKM_DIV_A() uint32 {
	return (volatile.LoadUint32(&o.APB_ADC_CLKM_CONF.Reg) & 0xfc000) >> 14
}
func (o *APB_SARADC_Type) SetAPB_ADC_CLKM_CONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.APB_ADC_CLKM_CONF.Reg, volatile.LoadUint32(&o.APB_ADC_CLKM_CONF.Reg)&^(0x100000)|value<<20)
}
func (o *APB_SARADC_Type) GetAPB_ADC_CLKM_CONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.APB_ADC_CLKM_CONF.Reg) & 0x100000) >> 20
}
func (o *APB_SARADC_Type) SetAPB_ADC_CLKM_CONF_REG_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.APB_ADC_CLKM_CONF.Reg, volatile.LoadUint32(&o.APB_ADC_CLKM_CONF.Reg)&^(0x600000)|value<<21)
}
func (o *APB_SARADC_Type) GetAPB_ADC_CLKM_CONF_REG_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.APB_ADC_CLKM_CONF.Reg) & 0x600000) >> 21
}

// APB_SARADC.APB_TSENS_CTRL: register description
func (o *APB_SARADC_Type) SetAPB_TSENS_CTRL_REG_TSENS_OUT(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_CTRL.Reg, volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg)&^(0xff)|value)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_CTRL_REG_TSENS_OUT() uint32 {
	return volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg) & 0xff
}
func (o *APB_SARADC_Type) SetAPB_TSENS_CTRL_REG_TSENS_IN_INV(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_CTRL.Reg, volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_CTRL_REG_TSENS_IN_INV() uint32 {
	return (volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg) & 0x2000) >> 13
}
func (o *APB_SARADC_Type) SetAPB_TSENS_CTRL_REG_TSENS_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_CTRL.Reg, volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg)&^(0x3fc000)|value<<14)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_CTRL_REG_TSENS_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg) & 0x3fc000) >> 14
}
func (o *APB_SARADC_Type) SetAPB_TSENS_CTRL_REG_TSENS_PU(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_CTRL.Reg, volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_CTRL_REG_TSENS_PU() uint32 {
	return (volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg) & 0x400000) >> 22
}

// APB_SARADC.APB_TSENS_CTRL2: register description
func (o *APB_SARADC_Type) SetAPB_TSENS_CTRL2_REG_TSENS_XPD_WAIT(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_CTRL2.Reg, volatile.LoadUint32(&o.APB_TSENS_CTRL2.Reg)&^(0xfff)|value)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_CTRL2_REG_TSENS_XPD_WAIT() uint32 {
	return volatile.LoadUint32(&o.APB_TSENS_CTRL2.Reg) & 0xfff
}
func (o *APB_SARADC_Type) SetAPB_TSENS_CTRL2_REG_TSENS_XPD_FORCE(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_CTRL2.Reg, volatile.LoadUint32(&o.APB_TSENS_CTRL2.Reg)&^(0x3000)|value<<12)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_CTRL2_REG_TSENS_XPD_FORCE() uint32 {
	return (volatile.LoadUint32(&o.APB_TSENS_CTRL2.Reg) & 0x3000) >> 12
}
func (o *APB_SARADC_Type) SetAPB_TSENS_CTRL2_REG_TSENS_CLK_INV(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_CTRL2.Reg, volatile.LoadUint32(&o.APB_TSENS_CTRL2.Reg)&^(0x4000)|value<<14)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_CTRL2_REG_TSENS_CLK_INV() uint32 {
	return (volatile.LoadUint32(&o.APB_TSENS_CTRL2.Reg) & 0x4000) >> 14
}
func (o *APB_SARADC_Type) SetAPB_TSENS_CTRL2_TSENS_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_CTRL2.Reg, volatile.LoadUint32(&o.APB_TSENS_CTRL2.Reg)&^(0x8000)|value<<15)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_CTRL2_TSENS_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.APB_TSENS_CTRL2.Reg) & 0x8000) >> 15
}

// APB_SARADC.CALI: register description
func (o *APB_SARADC_Type) SetCALI_CFG(value uint32) {
	volatile.StoreUint32(&o.CALI.Reg, volatile.LoadUint32(&o.CALI.Reg)&^(0x1ffff)|value)
}
func (o *APB_SARADC_Type) GetCALI_CFG() uint32 {
	return volatile.LoadUint32(&o.CALI.Reg) & 0x1ffff
}

// APB_SARADC.APB_CTRL_DATE: register description
func (o *APB_SARADC_Type) SetAPB_CTRL_DATE(value uint32) {
	volatile.StoreUint32(&o.APB_CTRL_DATE.Reg, value)
}
func (o *APB_SARADC_Type) GetAPB_CTRL_DATE() uint32 {
	return volatile.LoadUint32(&o.APB_CTRL_DATE.Reg)
}

// Debug Assist
type ASSIST_DEBUG_Type struct {
	CORE_0_MONTR_ENA               volatile.Register32 // 0x0
	CORE_0_INTR_RAW                volatile.Register32 // 0x4
	CORE_0_INTR_ENA                volatile.Register32 // 0x8
	CORE_0_INTR_CLR                volatile.Register32 // 0xC
	CORE_0_SP_MIN                  volatile.Register32 // 0x10
	CORE_0_SP_MAX                  volatile.Register32 // 0x14
	CORE_0_SP_PC                   volatile.Register32 // 0x18
	CORE_0_RCD_EN                  volatile.Register32 // 0x1C
	CORE_0_RCD_PDEBUGPC            volatile.Register32 // 0x20
	CORE_0_RCD_PDEBUGSP            volatile.Register32 // 0x24
	CORE_0_LASTPC_BEFORE_EXCEPTION volatile.Register32 // 0x28
	CORE_0_DEBUG_MODE              volatile.Register32 // 0x2C
	CLOCK_GATE                     volatile.Register32 // 0x30
	_                              [456]byte
	DATE                           volatile.Register32 // 0x1FC
}

// ASSIST_DEBUG.CORE_0_MONTR_ENA: core0 monitor enable configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_0_MONTR_ENA_CORE_0_SP_SPILL_MIN_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_MONTR_ENA_CORE_0_SP_SPILL_MIN_ENA() uint32 {
	return volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_MONTR_ENA_CORE_0_SP_SPILL_MAX_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_MONTR_ENA_CORE_0_SP_SPILL_MAX_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x2) >> 1
}

// ASSIST_DEBUG.CORE_0_INTR_RAW: core0 monitor interrupt status register
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_SP_SPILL_MIN_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_SP_SPILL_MIN_RAW() uint32 {
	return volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_SP_SPILL_MAX_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_SP_SPILL_MAX_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x2) >> 1
}

// ASSIST_DEBUG.CORE_0_INTR_ENA: core0 monitor interrupt enable register
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_SP_SPILL_MIN_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_SP_SPILL_MIN_INTR_ENA() uint32 {
	return volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_SP_SPILL_MAX_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_SP_SPILL_MAX_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x2) >> 1
}

// ASSIST_DEBUG.CORE_0_INTR_CLR: core0 monitor interrupt clr register
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_SP_SPILL_MIN_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_SP_SPILL_MIN_CLR() uint32 {
	return volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_SP_SPILL_MAX_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_SP_SPILL_MAX_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x2) >> 1
}

// ASSIST_DEBUG.CORE_0_SP_MIN: stack min value
func (o *ASSIST_DEBUG_Type) SetCORE_0_SP_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_SP_MIN.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_SP_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_SP_MIN.Reg)
}

// ASSIST_DEBUG.CORE_0_SP_MAX: stack max value
func (o *ASSIST_DEBUG_Type) SetCORE_0_SP_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_0_SP_MAX.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_SP_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_0_SP_MAX.Reg)
}

// ASSIST_DEBUG.CORE_0_SP_PC: stack monitor pc status register
func (o *ASSIST_DEBUG_Type) SetCORE_0_SP_PC(value uint32) {
	volatile.StoreUint32(&o.CORE_0_SP_PC.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_SP_PC() uint32 {
	return volatile.LoadUint32(&o.CORE_0_SP_PC.Reg)
}

// ASSIST_DEBUG.CORE_0_RCD_EN: record enable configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_0_RCD_EN_CORE_0_RCD_RECORDEN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_EN.Reg, volatile.LoadUint32(&o.CORE_0_RCD_EN.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_RCD_EN_CORE_0_RCD_RECORDEN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_RCD_EN.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_RCD_EN_CORE_0_RCD_PDEBUGEN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_EN.Reg, volatile.LoadUint32(&o.CORE_0_RCD_EN.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_RCD_EN_CORE_0_RCD_PDEBUGEN() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_RCD_EN.Reg) & 0x2) >> 1
}

// ASSIST_DEBUG.CORE_0_RCD_PDEBUGPC: record status regsiter
func (o *ASSIST_DEBUG_Type) SetCORE_0_RCD_PDEBUGPC(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_PDEBUGPC.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_RCD_PDEBUGPC() uint32 {
	return volatile.LoadUint32(&o.CORE_0_RCD_PDEBUGPC.Reg)
}

// ASSIST_DEBUG.CORE_0_RCD_PDEBUGSP: record status regsiter
func (o *ASSIST_DEBUG_Type) SetCORE_0_RCD_PDEBUGSP(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_PDEBUGSP.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_RCD_PDEBUGSP() uint32 {
	return volatile.LoadUint32(&o.CORE_0_RCD_PDEBUGSP.Reg)
}

// ASSIST_DEBUG.CORE_0_LASTPC_BEFORE_EXCEPTION: cpu status register
func (o *ASSIST_DEBUG_Type) SetCORE_0_LASTPC_BEFORE_EXCEPTION(value uint32) {
	volatile.StoreUint32(&o.CORE_0_LASTPC_BEFORE_EXCEPTION.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_LASTPC_BEFORE_EXCEPTION() uint32 {
	return volatile.LoadUint32(&o.CORE_0_LASTPC_BEFORE_EXCEPTION.Reg)
}

// ASSIST_DEBUG.CORE_0_DEBUG_MODE: cpu status register
func (o *ASSIST_DEBUG_Type) SetCORE_0_DEBUG_MODE(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DEBUG_MODE.Reg, volatile.LoadUint32(&o.CORE_0_DEBUG_MODE.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DEBUG_MODE() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DEBUG_MODE.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_DEBUG_MODE_CORE_0_DEBUG_MODULE_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DEBUG_MODE.Reg, volatile.LoadUint32(&o.CORE_0_DEBUG_MODE.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DEBUG_MODE_CORE_0_DEBUG_MODULE_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_DEBUG_MODE.Reg) & 0x2) >> 1
}

// ASSIST_DEBUG.CLOCK_GATE: clock gate register
func (o *ASSIST_DEBUG_Type) SetCLOCK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCLOCK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// ASSIST_DEBUG.DATE: version register
func (o *ASSIST_DEBUG_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// BB Peripheral
type BB_Type struct {
	_         [84]byte
	BBPD_CTRL volatile.Register32 // 0x54
}

// BB.BBPD_CTRL: Baseband control register
func (o *BB_Type) SetBBPD_CTRL_DC_EST_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.BBPD_CTRL.Reg, volatile.LoadUint32(&o.BBPD_CTRL.Reg)&^(0x1)|value)
}
func (o *BB_Type) GetBBPD_CTRL_DC_EST_FORCE_PD() uint32 {
	return volatile.LoadUint32(&o.BBPD_CTRL.Reg) & 0x1
}
func (o *BB_Type) SetBBPD_CTRL_DC_EST_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.BBPD_CTRL.Reg, volatile.LoadUint32(&o.BBPD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *BB_Type) GetBBPD_CTRL_DC_EST_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.BBPD_CTRL.Reg) & 0x2) >> 1
}
func (o *BB_Type) SetBBPD_CTRL_FFT_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.BBPD_CTRL.Reg, volatile.LoadUint32(&o.BBPD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *BB_Type) GetBBPD_CTRL_FFT_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.BBPD_CTRL.Reg) & 0x4) >> 2
}
func (o *BB_Type) SetBBPD_CTRL_FFT_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.BBPD_CTRL.Reg, volatile.LoadUint32(&o.BBPD_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *BB_Type) GetBBPD_CTRL_FFT_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.BBPD_CTRL.Reg) & 0x8) >> 3
}

// DMA (Direct Memory Access) Controller
type DMA_Type struct {
	INT_RAW_CH0              volatile.Register32 // 0x0
	INT_ST_CH0               volatile.Register32 // 0x4
	INT_ENA_CH0              volatile.Register32 // 0x8
	INT_CLR_CH0              volatile.Register32 // 0xC
	_                        [48]byte
	AHB_TEST                 volatile.Register32 // 0x40
	MISC_CONF                volatile.Register32 // 0x44
	DATE                     volatile.Register32 // 0x48
	_                        [36]byte
	IN_CONF0_CH0             volatile.Register32 // 0x70
	IN_CONF1_CH0             volatile.Register32 // 0x74
	INFIFO_STATUS_CH0        volatile.Register32 // 0x78
	IN_POP_CH0               volatile.Register32 // 0x7C
	IN_LINK_CH0              volatile.Register32 // 0x80
	IN_STATE_CH0             volatile.Register32 // 0x84
	IN_SUC_EOF_DES_ADDR_CH0  volatile.Register32 // 0x88
	IN_ERR_EOF_DES_ADDR_CH0  volatile.Register32 // 0x8C
	IN_DSCR_CH0              volatile.Register32 // 0x90
	IN_DSCR_BF0_CH0          volatile.Register32 // 0x94
	IN_DSCR_BF1_CH0          volatile.Register32 // 0x98
	IN_PRI_CH0               volatile.Register32 // 0x9C
	IN_PERI_SEL_CH0          volatile.Register32 // 0xA0
	_                        [44]byte
	OUT_CONF0_CH0            volatile.Register32 // 0xD0
	OUT_CONF1_CH0            volatile.Register32 // 0xD4
	OUTFIFO_STATUS_CH0       volatile.Register32 // 0xD8
	OUT_PUSH_CH0             volatile.Register32 // 0xDC
	OUT_LINK_CH0             volatile.Register32 // 0xE0
	OUT_STATE_CH0            volatile.Register32 // 0xE4
	OUT_EOF_DES_ADDR_CH0     volatile.Register32 // 0xE8
	OUT_EOF_BFR_DES_ADDR_CH0 volatile.Register32 // 0xEC
	OUT_DSCR_CH0             volatile.Register32 // 0xF0
	OUT_DSCR_BF0_CH0         volatile.Register32 // 0xF4
	OUT_DSCR_BF1_CH0         volatile.Register32 // 0xF8
	OUT_PRI_CH0              volatile.Register32 // 0xFC
	OUT_PERI_SEL_CH0         volatile.Register32 // 0x100
}

// DMA.INT_RAW_CH0: DMA_INT_RAW_CH0_REG.
func (o *DMA_Type) SetINT_RAW_CH0_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINT_RAW_CH0_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetINT_RAW_CH0_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINT_RAW_CH0_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINT_RAW_CH0_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINT_RAW_CH0_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINT_RAW_CH0_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINT_RAW_CH0_OUT_DONE() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINT_RAW_CH0_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINT_RAW_CH0_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINT_RAW_CH0_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINT_RAW_CH0_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINT_RAW_CH0_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetINT_RAW_CH0_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetINT_RAW_CH0_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetINT_RAW_CH0_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetINT_RAW_CH0_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetINT_RAW_CH0_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetINT_RAW_CH0_INFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetINT_RAW_CH0_INFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetINT_RAW_CH0_INFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetINT_RAW_CH0_INFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetINT_RAW_CH0_OUTFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetINT_RAW_CH0_OUTFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetINT_RAW_CH0_OUTFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_CH0.Reg, volatile.LoadUint32(&o.INT_RAW_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetINT_RAW_CH0_OUTFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_CH0.Reg) & 0x1000) >> 12
}

// DMA.INT_ST_CH0: DMA_INT_ST_CH0_REG.
func (o *DMA_Type) SetINT_ST_CH0_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINT_ST_CH0_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetINT_ST_CH0_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINT_ST_CH0_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINT_ST_CH0_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINT_ST_CH0_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINT_ST_CH0_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINT_ST_CH0_OUT_DONE() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINT_ST_CH0_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINT_ST_CH0_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINT_ST_CH0_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINT_ST_CH0_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINT_ST_CH0_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetINT_ST_CH0_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetINT_ST_CH0_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetINT_ST_CH0_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetINT_ST_CH0_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetINT_ST_CH0_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetINT_ST_CH0_INFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetINT_ST_CH0_INFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetINT_ST_CH0_INFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetINT_ST_CH0_INFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetINT_ST_CH0_OUTFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetINT_ST_CH0_OUTFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetINT_ST_CH0_OUTFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CH0.Reg, volatile.LoadUint32(&o.INT_ST_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetINT_ST_CH0_OUTFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CH0.Reg) & 0x1000) >> 12
}

// DMA.INT_ENA_CH0: DMA_INT_ENA_CH0_REG.
func (o *DMA_Type) SetINT_ENA_CH0_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINT_ENA_CH0_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetINT_ENA_CH0_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINT_ENA_CH0_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINT_ENA_CH0_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINT_ENA_CH0_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINT_ENA_CH0_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINT_ENA_CH0_OUT_DONE() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINT_ENA_CH0_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINT_ENA_CH0_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINT_ENA_CH0_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINT_ENA_CH0_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINT_ENA_CH0_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetINT_ENA_CH0_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetINT_ENA_CH0_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetINT_ENA_CH0_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetINT_ENA_CH0_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetINT_ENA_CH0_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetINT_ENA_CH0_INFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetINT_ENA_CH0_INFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetINT_ENA_CH0_INFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetINT_ENA_CH0_INFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetINT_ENA_CH0_OUTFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetINT_ENA_CH0_OUTFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetINT_ENA_CH0_OUTFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_CH0.Reg, volatile.LoadUint32(&o.INT_ENA_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetINT_ENA_CH0_OUTFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_CH0.Reg) & 0x1000) >> 12
}

// DMA.INT_CLR_CH0: DMA_INT_CLR_CH0_REG.
func (o *DMA_Type) SetINT_CLR_CH0_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINT_CLR_CH0_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetINT_CLR_CH0_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINT_CLR_CH0_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINT_CLR_CH0_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINT_CLR_CH0_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINT_CLR_CH0_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINT_CLR_CH0_OUT_DONE() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINT_CLR_CH0_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINT_CLR_CH0_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINT_CLR_CH0_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINT_CLR_CH0_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINT_CLR_CH0_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetINT_CLR_CH0_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetINT_CLR_CH0_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetINT_CLR_CH0_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetINT_CLR_CH0_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetINT_CLR_CH0_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetINT_CLR_CH0_INFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetINT_CLR_CH0_INFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetINT_CLR_CH0_INFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetINT_CLR_CH0_INFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetINT_CLR_CH0_OUTFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetINT_CLR_CH0_OUTFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetINT_CLR_CH0_OUTFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_CH0.Reg, volatile.LoadUint32(&o.INT_CLR_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetINT_CLR_CH0_OUTFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_CH0.Reg) & 0x1000) >> 12
}

// DMA.AHB_TEST: DMA_AHB_TEST_REG.
func (o *DMA_Type) SetAHB_TEST_AHB_TESTMODE(value uint32) {
	volatile.StoreUint32(&o.AHB_TEST.Reg, volatile.LoadUint32(&o.AHB_TEST.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetAHB_TEST_AHB_TESTMODE() uint32 {
	return volatile.LoadUint32(&o.AHB_TEST.Reg) & 0x7
}
func (o *DMA_Type) SetAHB_TEST_AHB_TESTADDR(value uint32) {
	volatile.StoreUint32(&o.AHB_TEST.Reg, volatile.LoadUint32(&o.AHB_TEST.Reg)&^(0x30)|value<<4)
}
func (o *DMA_Type) GetAHB_TEST_AHB_TESTADDR() uint32 {
	return (volatile.LoadUint32(&o.AHB_TEST.Reg) & 0x30) >> 4
}

// DMA.MISC_CONF: DMA_MISC_CONF_REG.
func (o *DMA_Type) SetMISC_CONF_AHBM_RST_INTER(value uint32) {
	volatile.StoreUint32(&o.MISC_CONF.Reg, volatile.LoadUint32(&o.MISC_CONF.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetMISC_CONF_AHBM_RST_INTER() uint32 {
	return volatile.LoadUint32(&o.MISC_CONF.Reg) & 0x1
}
func (o *DMA_Type) SetMISC_CONF_ARB_PRI_DIS(value uint32) {
	volatile.StoreUint32(&o.MISC_CONF.Reg, volatile.LoadUint32(&o.MISC_CONF.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetMISC_CONF_ARB_PRI_DIS() uint32 {
	return (volatile.LoadUint32(&o.MISC_CONF.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetMISC_CONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.MISC_CONF.Reg, volatile.LoadUint32(&o.MISC_CONF.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetMISC_CONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.MISC_CONF.Reg) & 0x8) >> 3
}

// DMA.DATE: DMA_DATE_REG.
func (o *DMA_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *DMA_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// DMA.IN_CONF0_CH0: DMA_IN_CONF0_CH0_REG.
func (o *DMA_Type) SetIN_CONF0_CH0_IN_RST(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_CONF0_CH0_IN_RST() uint32 {
	return volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetIN_CONF0_CH0_IN_LOOP_TEST(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_CONF0_CH0_IN_LOOP_TEST() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_CONF0_CH0_INDSCR_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_CONF0_CH0_INDSCR_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_CONF0_CH0_IN_DATA_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_CONF0_CH0_IN_DATA_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_CONF0_CH0_MEM_TRANS_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_CONF0_CH0_MEM_TRANS_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x10) >> 4
}

// DMA.IN_CONF1_CH0: DMA_IN_CONF1_CH0_REG.
func (o *DMA_Type) SetIN_CONF1_CH0_IN_CHECK_OWNER(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH0.Reg, volatile.LoadUint32(&o.IN_CONF1_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_CONF1_CH0_IN_CHECK_OWNER() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH0.Reg) & 0x1000) >> 12
}

// DMA.INFIFO_STATUS_CH0: DMA_INFIFO_STATUS_CH0_REG.
func (o *DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_FULL(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_FULL() uint32 {
	return volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_EMPTY(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0xfc)|value<<2)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0xfc) >> 2
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_1B(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_1B() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_2B(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_2B() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_3B(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_3B() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_4B(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_4B() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_IN_BUF_HUNGRY(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_IN_BUF_HUNGRY() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x8000000) >> 27
}

// DMA.IN_POP_CH0: DMA_IN_POP_CH0_REG.
func (o *DMA_Type) SetIN_POP_CH0_INFIFO_RDATA(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH0.Reg, volatile.LoadUint32(&o.IN_POP_CH0.Reg)&^(0xfff)|value)
}
func (o *DMA_Type) GetIN_POP_CH0_INFIFO_RDATA() uint32 {
	return volatile.LoadUint32(&o.IN_POP_CH0.Reg) & 0xfff
}
func (o *DMA_Type) SetIN_POP_CH0_INFIFO_POP(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH0.Reg, volatile.LoadUint32(&o.IN_POP_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_POP_CH0_INFIFO_POP() uint32 {
	return (volatile.LoadUint32(&o.IN_POP_CH0.Reg) & 0x1000) >> 12
}

// DMA.IN_LINK_CH0: DMA_IN_LINK_CH0_REG.
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0xfffff
}
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_AUTO_RET(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_AUTO_RET() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_STOP(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_STOP() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_START(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_START() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_RESTART(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_RESTART() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_PARK(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_PARK() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x1000000) >> 24
}

// DMA.IN_STATE_CH0: DMA_IN_STATE_CH0_REG.
func (o *DMA_Type) SetIN_STATE_CH0_INLINK_DSCR_ADDR(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH0.Reg, volatile.LoadUint32(&o.IN_STATE_CH0.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetIN_STATE_CH0_INLINK_DSCR_ADDR() uint32 {
	return volatile.LoadUint32(&o.IN_STATE_CH0.Reg) & 0x3ffff
}
func (o *DMA_Type) SetIN_STATE_CH0_IN_DSCR_STATE(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH0.Reg, volatile.LoadUint32(&o.IN_STATE_CH0.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetIN_STATE_CH0_IN_DSCR_STATE() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH0.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetIN_STATE_CH0_IN_STATE(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH0.Reg, volatile.LoadUint32(&o.IN_STATE_CH0.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetIN_STATE_CH0_IN_STATE() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH0.Reg) & 0x700000) >> 20
}

// DMA.IN_SUC_EOF_DES_ADDR_CH0: DMA_IN_SUC_EOF_DES_ADDR_CH0_REG.
func (o *DMA_Type) SetIN_SUC_EOF_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_SUC_EOF_DES_ADDR_CH0.Reg, value)
}
func (o *DMA_Type) GetIN_SUC_EOF_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_SUC_EOF_DES_ADDR_CH0.Reg)
}

// DMA.IN_ERR_EOF_DES_ADDR_CH0: DMA_IN_ERR_EOF_DES_ADDR_CH0_REG.
func (o *DMA_Type) SetIN_ERR_EOF_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_ERR_EOF_DES_ADDR_CH0.Reg, value)
}
func (o *DMA_Type) GetIN_ERR_EOF_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_ERR_EOF_DES_ADDR_CH0.Reg)
}

// DMA.IN_DSCR_CH0: DMA_IN_DSCR_CH0_REG.
func (o *DMA_Type) SetIN_DSCR_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_CH0.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_CH0.Reg)
}

// DMA.IN_DSCR_BF0_CH0: DMA_IN_DSCR_BF0_CH0_REG.
func (o *DMA_Type) SetIN_DSCR_BF0_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF0_CH0.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF0_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF0_CH0.Reg)
}

// DMA.IN_DSCR_BF1_CH0: DMA_IN_DSCR_BF1_CH0_REG.
func (o *DMA_Type) SetIN_DSCR_BF1_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF1_CH0.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF1_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF1_CH0.Reg)
}

// DMA.IN_PRI_CH0: DMA_IN_PRI_CH0_REG.
func (o *DMA_Type) SetIN_PRI_CH0_RX_PRI(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH0.Reg, volatile.LoadUint32(&o.IN_PRI_CH0.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetIN_PRI_CH0_RX_PRI() uint32 {
	return volatile.LoadUint32(&o.IN_PRI_CH0.Reg) & 0xf
}

// DMA.IN_PERI_SEL_CH0: DMA_IN_PERI_SEL_CH0_REG.
func (o *DMA_Type) SetIN_PERI_SEL_CH0_PERI_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.IN_PERI_SEL_CH0.Reg, volatile.LoadUint32(&o.IN_PERI_SEL_CH0.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetIN_PERI_SEL_CH0_PERI_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.IN_PERI_SEL_CH0.Reg) & 0x3f
}

// DMA.OUT_CONF0_CH0: DMA_OUT_CONF0_CH0_REG.
func (o *DMA_Type) SetOUT_CONF0_CH0_OUT_RST(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUT_RST() uint32 {
	return volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_CONF0_CH0_OUT_LOOP_TEST(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUT_LOOP_TEST() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_CONF0_CH0_OUT_AUTO_WRBACK(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUT_AUTO_WRBACK() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_CONF0_CH0_OUT_EOF_MODE(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUT_EOF_MODE() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_CONF0_CH0_OUTDSCR_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUTDSCR_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_CONF0_CH0_OUT_DATA_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUT_DATA_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x20) >> 5
}

// DMA.OUT_CONF1_CH0: DMA_OUT_CONF1_CH0_REG.
func (o *DMA_Type) SetOUT_CONF1_CH0_OUT_CHECK_OWNER(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetOUT_CONF1_CH0_OUT_CHECK_OWNER() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH0.Reg) & 0x1000) >> 12
}

// DMA.OUTFIFO_STATUS_CH0: DMA_OUTFIFO_STATUS_CH0_REG.
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_FULL(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_FULL() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_EMPTY(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0xfc)|value<<2)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0xfc) >> 2
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_1B(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_1B() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_2B(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_2B() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_3B(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_3B() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_4B(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_4B() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x4000000) >> 26
}

// DMA.OUT_PUSH_CH0: DMA_OUT_PUSH_CH0_REG.
func (o *DMA_Type) SetOUT_PUSH_CH0_OUTFIFO_WDATA(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH0.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg)&^(0x1ff)|value)
}
func (o *DMA_Type) GetOUT_PUSH_CH0_OUTFIFO_WDATA() uint32 {
	return volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg) & 0x1ff
}
func (o *DMA_Type) SetOUT_PUSH_CH0_OUTFIFO_PUSH(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH0.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetOUT_PUSH_CH0_OUTFIFO_PUSH() uint32 {
	return (volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg) & 0x200) >> 9
}

// DMA.OUT_LINK_CH0: DMA_OUT_LINK_CH0_REG.
func (o *DMA_Type) SetOUT_LINK_CH0_OUTLINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetOUT_LINK_CH0_OUTLINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0xfffff
}
func (o *DMA_Type) SetOUT_LINK_CH0_OUTLINK_STOP(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetOUT_LINK_CH0_OUTLINK_STOP() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetOUT_LINK_CH0_OUTLINK_START(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetOUT_LINK_CH0_OUTLINK_START() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetOUT_LINK_CH0_OUTLINK_RESTART(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetOUT_LINK_CH0_OUTLINK_RESTART() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetOUT_LINK_CH0_OUTLINK_PARK(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUT_LINK_CH0_OUTLINK_PARK() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0x800000) >> 23
}

// DMA.OUT_STATE_CH0: DMA_OUT_STATE_CH0_REG.
func (o *DMA_Type) SetOUT_STATE_CH0_OUTLINK_DSCR_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH0.Reg, volatile.LoadUint32(&o.OUT_STATE_CH0.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetOUT_STATE_CH0_OUTLINK_DSCR_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_STATE_CH0.Reg) & 0x3ffff
}
func (o *DMA_Type) SetOUT_STATE_CH0_OUT_DSCR_STATE(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH0.Reg, volatile.LoadUint32(&o.OUT_STATE_CH0.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetOUT_STATE_CH0_OUT_DSCR_STATE() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH0.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetOUT_STATE_CH0_OUT_STATE(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH0.Reg, volatile.LoadUint32(&o.OUT_STATE_CH0.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetOUT_STATE_CH0_OUT_STATE() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH0.Reg) & 0x700000) >> 20
}

// DMA.OUT_EOF_DES_ADDR_CH0: DMA_OUT_EOF_DES_ADDR_CH0_REG.
func (o *DMA_Type) SetOUT_EOF_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_DES_ADDR_CH0.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_DES_ADDR_CH0.Reg)
}

// DMA.OUT_EOF_BFR_DES_ADDR_CH0: DMA_OUT_EOF_BFR_DES_ADDR_CH0_REG.
func (o *DMA_Type) SetOUT_EOF_BFR_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_BFR_DES_ADDR_CH0.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_BFR_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_BFR_DES_ADDR_CH0.Reg)
}

// DMA.OUT_DSCR_CH0: DMA_OUT_DSCR_CH0_REG.
func (o *DMA_Type) SetOUT_DSCR_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_CH0.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_CH0.Reg)
}

// DMA.OUT_DSCR_BF0_CH0: DMA_OUT_DSCR_BF0_CH0_REG.
func (o *DMA_Type) SetOUT_DSCR_BF0_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF0_CH0.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF0_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF0_CH0.Reg)
}

// DMA.OUT_DSCR_BF1_CH0: DMA_OUT_DSCR_BF1_CH0_REG.
func (o *DMA_Type) SetOUT_DSCR_BF1_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF1_CH0.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF1_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF1_CH0.Reg)
}

// DMA.OUT_PRI_CH0: DMA_OUT_PRI_CH0_REG.
func (o *DMA_Type) SetOUT_PRI_CH0_TX_PRI(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH0.Reg, volatile.LoadUint32(&o.OUT_PRI_CH0.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetOUT_PRI_CH0_TX_PRI() uint32 {
	return volatile.LoadUint32(&o.OUT_PRI_CH0.Reg) & 0xf
}

// DMA.OUT_PERI_SEL_CH0: DMA_OUT_PERI_SEL_CH0_REG.
func (o *DMA_Type) SetOUT_PERI_SEL_CH0_PERI_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.OUT_PERI_SEL_CH0.Reg, volatile.LoadUint32(&o.OUT_PERI_SEL_CH0.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetOUT_PERI_SEL_CH0_PERI_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.OUT_PERI_SEL_CH0.Reg) & 0x3f
}

// ECC (ECC Hardware Accelerator)
type ECC_Type struct {
	_            [12]byte
	MULT_INT_RAW volatile.Register32 // 0xC
	MULT_INT_ST  volatile.Register32 // 0x10
	MULT_INT_ENA volatile.Register32 // 0x14
	MULT_INT_CLR volatile.Register32 // 0x18
	MULT_CONF    volatile.Register32 // 0x1C
	_            [220]byte
	MULT_DATE    volatile.Register32    // 0xFC
	K_MEM        [32]volatile.Register8 // 0x100
	PX_MEM       [32]volatile.Register8 // 0x120
	PY_MEM       [32]volatile.Register8 // 0x140
}

// ECC.MULT_INT_RAW: I2S interrupt raw register, valid in level.
func (o *ECC_Type) SetMULT_INT_RAW_CALC_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.MULT_INT_RAW.Reg, volatile.LoadUint32(&o.MULT_INT_RAW.Reg)&^(0x1)|value)
}
func (o *ECC_Type) GetMULT_INT_RAW_CALC_DONE_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.MULT_INT_RAW.Reg) & 0x1
}

// ECC.MULT_INT_ST: I2S interrupt status register.
func (o *ECC_Type) SetMULT_INT_ST_CALC_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.MULT_INT_ST.Reg, volatile.LoadUint32(&o.MULT_INT_ST.Reg)&^(0x1)|value)
}
func (o *ECC_Type) GetMULT_INT_ST_CALC_DONE_INT_ST() uint32 {
	return volatile.LoadUint32(&o.MULT_INT_ST.Reg) & 0x1
}

// ECC.MULT_INT_ENA: I2S interrupt enable register.
func (o *ECC_Type) SetMULT_INT_ENA_CALC_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.MULT_INT_ENA.Reg, volatile.LoadUint32(&o.MULT_INT_ENA.Reg)&^(0x1)|value)
}
func (o *ECC_Type) GetMULT_INT_ENA_CALC_DONE_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.MULT_INT_ENA.Reg) & 0x1
}

// ECC.MULT_INT_CLR: I2S interrupt clear register.
func (o *ECC_Type) SetMULT_INT_CLR_CALC_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.MULT_INT_CLR.Reg, volatile.LoadUint32(&o.MULT_INT_CLR.Reg)&^(0x1)|value)
}
func (o *ECC_Type) GetMULT_INT_CLR_CALC_DONE_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.MULT_INT_CLR.Reg) & 0x1
}

// ECC.MULT_CONF: I2S RX configure register
func (o *ECC_Type) SetMULT_CONF_START(value uint32) {
	volatile.StoreUint32(&o.MULT_CONF.Reg, volatile.LoadUint32(&o.MULT_CONF.Reg)&^(0x1)|value)
}
func (o *ECC_Type) GetMULT_CONF_START() uint32 {
	return volatile.LoadUint32(&o.MULT_CONF.Reg) & 0x1
}
func (o *ECC_Type) SetMULT_CONF_RESET(value uint32) {
	volatile.StoreUint32(&o.MULT_CONF.Reg, volatile.LoadUint32(&o.MULT_CONF.Reg)&^(0x2)|value<<1)
}
func (o *ECC_Type) GetMULT_CONF_RESET() uint32 {
	return (volatile.LoadUint32(&o.MULT_CONF.Reg) & 0x2) >> 1
}
func (o *ECC_Type) SetMULT_CONF_KEY_LENGTH(value uint32) {
	volatile.StoreUint32(&o.MULT_CONF.Reg, volatile.LoadUint32(&o.MULT_CONF.Reg)&^(0x4)|value<<2)
}
func (o *ECC_Type) GetMULT_CONF_KEY_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.MULT_CONF.Reg) & 0x4) >> 2
}
func (o *ECC_Type) SetMULT_CONF_SECURITY_MODE(value uint32) {
	volatile.StoreUint32(&o.MULT_CONF.Reg, volatile.LoadUint32(&o.MULT_CONF.Reg)&^(0x8)|value<<3)
}
func (o *ECC_Type) GetMULT_CONF_SECURITY_MODE() uint32 {
	return (volatile.LoadUint32(&o.MULT_CONF.Reg) & 0x8) >> 3
}
func (o *ECC_Type) SetMULT_CONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.MULT_CONF.Reg, volatile.LoadUint32(&o.MULT_CONF.Reg)&^(0x10)|value<<4)
}
func (o *ECC_Type) GetMULT_CONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.MULT_CONF.Reg) & 0x10) >> 4
}
func (o *ECC_Type) SetMULT_CONF_WORK_MODE(value uint32) {
	volatile.StoreUint32(&o.MULT_CONF.Reg, volatile.LoadUint32(&o.MULT_CONF.Reg)&^(0xe0)|value<<5)
}
func (o *ECC_Type) GetMULT_CONF_WORK_MODE() uint32 {
	return (volatile.LoadUint32(&o.MULT_CONF.Reg) & 0xe0) >> 5
}
func (o *ECC_Type) SetMULT_CONF_VERIFICATION_RESULT(value uint32) {
	volatile.StoreUint32(&o.MULT_CONF.Reg, volatile.LoadUint32(&o.MULT_CONF.Reg)&^(0x100)|value<<8)
}
func (o *ECC_Type) GetMULT_CONF_VERIFICATION_RESULT() uint32 {
	return (volatile.LoadUint32(&o.MULT_CONF.Reg) & 0x100) >> 8
}

// ECC.MULT_DATE: Version control register
func (o *ECC_Type) SetMULT_DATE_DATE(value uint32) {
	volatile.StoreUint32(&o.MULT_DATE.Reg, volatile.LoadUint32(&o.MULT_DATE.Reg)&^(0xfffffff)|value)
}
func (o *ECC_Type) GetMULT_DATE_DATE() uint32 {
	return volatile.LoadUint32(&o.MULT_DATE.Reg) & 0xfffffff
}

// eFuse Controller
type EFUSE_Type struct {
	PGM_DATA0        volatile.Register32 // 0x0
	PGM_DATA1        volatile.Register32 // 0x4
	PGM_DATA2        volatile.Register32 // 0x8
	PGM_DATA3        volatile.Register32 // 0xC
	PGM_DATA4        volatile.Register32 // 0x10
	PGM_DATA5        volatile.Register32 // 0x14
	PGM_DATA6        volatile.Register32 // 0x18
	PGM_DATA7        volatile.Register32 // 0x1C
	PGM_CHECK_VALUE0 volatile.Register32 // 0x20
	PGM_CHECK_VALUE1 volatile.Register32 // 0x24
	PGM_CHECK_VALUE2 volatile.Register32 // 0x28
	RD_WR_DIS        volatile.Register32 // 0x2C
	RD_REPEAT_DATA0  volatile.Register32 // 0x30
	RD_BLK1_DATA0    volatile.Register32 // 0x34
	RD_BLK1_DATA1    volatile.Register32 // 0x38
	RD_BLK1_DATA2    volatile.Register32 // 0x3C
	RD_BLK2_DATA0    volatile.Register32 // 0x40
	RD_BLK2_DATA1    volatile.Register32 // 0x44
	RD_BLK2_DATA2    volatile.Register32 // 0x48
	RD_BLK2_DATA3    volatile.Register32 // 0x4C
	RD_BLK2_DATA4    volatile.Register32 // 0x50
	RD_BLK2_DATA5    volatile.Register32 // 0x54
	RD_BLK2_DATA6    volatile.Register32 // 0x58
	RD_BLK2_DATA7    volatile.Register32 // 0x5C
	RD_BLK3_DATA0    volatile.Register32 // 0x60
	RD_BLK3_DATA1    volatile.Register32 // 0x64
	RD_BLK3_DATA2    volatile.Register32 // 0x68
	RD_BLK3_DATA3    volatile.Register32 // 0x6C
	RD_BLK3_DATA4    volatile.Register32 // 0x70
	RD_BLK3_DATA5    volatile.Register32 // 0x74
	RD_BLK3_DATA6    volatile.Register32 // 0x78
	RD_BLK3_DATA7    volatile.Register32 // 0x7C
	RD_REPEAT_ERR    volatile.Register32 // 0x80
	RD_RS_ERR        volatile.Register32 // 0x84
	CLK              volatile.Register32 // 0x88
	CONF             volatile.Register32 // 0x8C
	STATUS           volatile.Register32 // 0x90
	CMD              volatile.Register32 // 0x94
	INT_RAW          volatile.Register32 // 0x98
	INT_ST           volatile.Register32 // 0x9C
	_                [96]byte
	INT_ENA          volatile.Register32 // 0x100
	INT_CLR          volatile.Register32 // 0x104
	DAC_CONF         volatile.Register32 // 0x108
	RD_TIM_CONF      volatile.Register32 // 0x10C
	WR_TIM_CONF0     volatile.Register32 // 0x110
	WR_TIM_CONF1     volatile.Register32 // 0x114
	WR_TIM_CONF2     volatile.Register32 // 0x118
	_                [224]byte
	DATE             volatile.Register32 // 0x1FC
}

// EFUSE.PGM_DATA0: Register 0 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA0(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA0() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA0.Reg)
}

// EFUSE.PGM_DATA1: Register 1 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA1(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA1() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA1.Reg)
}

// EFUSE.PGM_DATA2: Register 2 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA2(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA2() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA2.Reg)
}

// EFUSE.PGM_DATA3: Register 3 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA3(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA3() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA3.Reg)
}

// EFUSE.PGM_DATA4: Register 4 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA4(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA4() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA4.Reg)
}

// EFUSE.PGM_DATA5: Register 5 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA5(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA5() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA5.Reg)
}

// EFUSE.PGM_DATA6: Register 6 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA6(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA6() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA6.Reg)
}

// EFUSE.PGM_DATA7: Register 7 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA7(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA7() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA7.Reg)
}

// EFUSE.PGM_CHECK_VALUE0: Register 0 that stores the RS code to be programmed.
func (o *EFUSE_Type) SetPGM_CHECK_VALUE0(value uint32) {
	volatile.StoreUint32(&o.PGM_CHECK_VALUE0.Reg, value)
}
func (o *EFUSE_Type) GetPGM_CHECK_VALUE0() uint32 {
	return volatile.LoadUint32(&o.PGM_CHECK_VALUE0.Reg)
}

// EFUSE.PGM_CHECK_VALUE1: Register 1 that stores the RS code to be programmed.
func (o *EFUSE_Type) SetPGM_CHECK_VALUE1(value uint32) {
	volatile.StoreUint32(&o.PGM_CHECK_VALUE1.Reg, value)
}
func (o *EFUSE_Type) GetPGM_CHECK_VALUE1() uint32 {
	return volatile.LoadUint32(&o.PGM_CHECK_VALUE1.Reg)
}

// EFUSE.PGM_CHECK_VALUE2: Register 2 that stores the RS code to be programmed.
func (o *EFUSE_Type) SetPGM_CHECK_VALUE2(value uint32) {
	volatile.StoreUint32(&o.PGM_CHECK_VALUE2.Reg, value)
}
func (o *EFUSE_Type) GetPGM_CHECK_VALUE2() uint32 {
	return volatile.LoadUint32(&o.PGM_CHECK_VALUE2.Reg)
}

// EFUSE.RD_WR_DIS: BLOCK0 data register 0.
func (o *EFUSE_Type) SetRD_WR_DIS_WR_DIS(value uint32) {
	volatile.StoreUint32(&o.RD_WR_DIS.Reg, volatile.LoadUint32(&o.RD_WR_DIS.Reg)&^(0xff)|value)
}
func (o *EFUSE_Type) GetRD_WR_DIS_WR_DIS() uint32 {
	return volatile.LoadUint32(&o.RD_WR_DIS.Reg) & 0xff
}

// EFUSE.RD_REPEAT_DATA0: BLOCK0 data register 1.
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_RD_DIS(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x3)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_RD_DIS() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x3
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_WDT_DELAY_SEL(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0xc)|value<<2)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_WDT_DELAY_SEL() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0xc) >> 2
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_PAD_JTAG(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x10)|value<<4)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_PAD_JTAG() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x10) >> 4
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_DOWNLOAD_ICACHE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x20)|value<<5)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_DOWNLOAD_ICACHE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x20) >> 5
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_DOWNLOAD_MANUAL_ENCRYPT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x40)|value<<6)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_DOWNLOAD_MANUAL_ENCRYPT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x40) >> 6
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_SPI_BOOT_ENCRYPT_DECRYPT_CNT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x380)|value<<7)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_SPI_BOOT_ENCRYPT_DECRYPT_CNT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x380) >> 7
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_XTS_KEY_LENGTH_256(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x400)|value<<10)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_XTS_KEY_LENGTH_256() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x400) >> 10
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_UART_PRINT_CONTROL(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x1800)|value<<11)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_UART_PRINT_CONTROL() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x1800) >> 11
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_FORCE_SEND_RESUME(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x2000)|value<<13)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_FORCE_SEND_RESUME() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x2000) >> 13
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_DOWNLOAD_MODE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x4000)|value<<14)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_DOWNLOAD_MODE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x4000) >> 14
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_DIRECT_BOOT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x8000)|value<<15)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_DIRECT_BOOT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x8000) >> 15
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_ENABLE_SECURITY_DOWNLOAD(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x10000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_ENABLE_SECURITY_DOWNLOAD() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x10000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_FLASH_TPUW(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x1e0000)|value<<17)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_FLASH_TPUW() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x1e0000) >> 17
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_SECURE_BOOT_EN(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x200000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_SECURE_BOOT_EN() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x200000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_RPT4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0xffc00000)|value<<22)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_RPT4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0xffc00000) >> 22
}

// EFUSE.RD_BLK1_DATA0: BLOCK1 data register 0.
func (o *EFUSE_Type) SetRD_BLK1_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_BLK1_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_BLK1_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_BLK1_DATA0.Reg)
}

// EFUSE.RD_BLK1_DATA1: BLOCK1 data register 1.
func (o *EFUSE_Type) SetRD_BLK1_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_BLK1_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_BLK1_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_BLK1_DATA1.Reg)
}

// EFUSE.RD_BLK1_DATA2: BLOCK1 data register 2.
func (o *EFUSE_Type) SetRD_BLK1_DATA2_SYSTEM_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_BLK1_DATA2.Reg, volatile.LoadUint32(&o.RD_BLK1_DATA2.Reg)&^(0xffffff)|value)
}
func (o *EFUSE_Type) GetRD_BLK1_DATA2_SYSTEM_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_BLK1_DATA2.Reg) & 0xffffff
}

// EFUSE.RD_BLK2_DATA0: Register 0 of BLOCK2.
func (o *EFUSE_Type) SetRD_BLK2_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_BLK2_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_BLK2_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_BLK2_DATA0.Reg)
}

// EFUSE.RD_BLK2_DATA1: Register 1 of BLOCK2.
func (o *EFUSE_Type) SetRD_BLK2_DATA1_MAC_ID_HIGH(value uint32) {
	volatile.StoreUint32(&o.RD_BLK2_DATA1.Reg, volatile.LoadUint32(&o.RD_BLK2_DATA1.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetRD_BLK2_DATA1_MAC_ID_HIGH() uint32 {
	return volatile.LoadUint32(&o.RD_BLK2_DATA1.Reg) & 0xffff
}
func (o *EFUSE_Type) SetRD_BLK2_DATA1_WAFER_VERSION(value uint32) {
	volatile.StoreUint32(&o.RD_BLK2_DATA1.Reg, volatile.LoadUint32(&o.RD_BLK2_DATA1.Reg)&^(0x70000)|value<<16)
}
func (o *EFUSE_Type) GetRD_BLK2_DATA1_WAFER_VERSION() uint32 {
	return (volatile.LoadUint32(&o.RD_BLK2_DATA1.Reg) & 0x70000) >> 16
}
func (o *EFUSE_Type) SetRD_BLK2_DATA1_PKG_VERSION(value uint32) {
	volatile.StoreUint32(&o.RD_BLK2_DATA1.Reg, volatile.LoadUint32(&o.RD_BLK2_DATA1.Reg)&^(0x380000)|value<<19)
}
func (o *EFUSE_Type) GetRD_BLK2_DATA1_PKG_VERSION() uint32 {
	return (volatile.LoadUint32(&o.RD_BLK2_DATA1.Reg) & 0x380000) >> 19
}
func (o *EFUSE_Type) SetRD_BLK2_DATA1_BLK2_EFUSE_VERSION(value uint32) {
	volatile.StoreUint32(&o.RD_BLK2_DATA1.Reg, volatile.LoadUint32(&o.RD_BLK2_DATA1.Reg)&^(0x1c00000)|value<<22)
}
func (o *EFUSE_Type) GetRD_BLK2_DATA1_BLK2_EFUSE_VERSION() uint32 {
	return (volatile.LoadUint32(&o.RD_BLK2_DATA1.Reg) & 0x1c00000) >> 22
}
func (o *EFUSE_Type) SetRD_BLK2_DATA1_RF_REF_I_BIAS_CONFIG(value uint32) {
	volatile.StoreUint32(&o.RD_BLK2_DATA1.Reg, volatile.LoadUint32(&o.RD_BLK2_DATA1.Reg)&^(0x1e000000)|value<<25)
}
func (o *EFUSE_Type) GetRD_BLK2_DATA1_RF_REF_I_BIAS_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.RD_BLK2_DATA1.Reg) & 0x1e000000) >> 25
}
func (o *EFUSE_Type) SetRD_BLK2_DATA1_LDO_VOL_BIAS_CONFIG_LOW(value uint32) {
	volatile.StoreUint32(&o.RD_BLK2_DATA1.Reg, volatile.LoadUint32(&o.RD_BLK2_DATA1.Reg)&^(0xe0000000)|value<<29)
}
func (o *EFUSE_Type) GetRD_BLK2_DATA1_LDO_VOL_BIAS_CONFIG_LOW() uint32 {
	return (volatile.LoadUint32(&o.RD_BLK2_DATA1.Reg) & 0xe0000000) >> 29
}

// EFUSE.RD_BLK2_DATA2: Register 2 of BLOCK2.
func (o *EFUSE_Type) SetRD_BLK2_DATA2_LDO_VOL_BIAS_CONFIG_HIGH(value uint32) {
	volatile.StoreUint32(&o.RD_BLK2_DATA2.Reg, volatile.LoadUint32(&o.RD_BLK2_DATA2.Reg)&^(0x7ffffff)|value)
}
func (o *EFUSE_Type) GetRD_BLK2_DATA2_LDO_VOL_BIAS_CONFIG_HIGH() uint32 {
	return volatile.LoadUint32(&o.RD_BLK2_DATA2.Reg) & 0x7ffffff
}
func (o *EFUSE_Type) SetRD_BLK2_DATA2_PVT_LOW(value uint32) {
	volatile.StoreUint32(&o.RD_BLK2_DATA2.Reg, volatile.LoadUint32(&o.RD_BLK2_DATA2.Reg)&^(0xf8000000)|value<<27)
}
func (o *EFUSE_Type) GetRD_BLK2_DATA2_PVT_LOW() uint32 {
	return (volatile.LoadUint32(&o.RD_BLK2_DATA2.Reg) & 0xf8000000) >> 27
}

// EFUSE.RD_BLK2_DATA3: Register 3 of BLOCK2.
func (o *EFUSE_Type) SetRD_BLK2_DATA3_PVT_HIGH(value uint32) {
	volatile.StoreUint32(&o.RD_BLK2_DATA3.Reg, volatile.LoadUint32(&o.RD_BLK2_DATA3.Reg)&^(0x3ff)|value)
}
func (o *EFUSE_Type) GetRD_BLK2_DATA3_PVT_HIGH() uint32 {
	return volatile.LoadUint32(&o.RD_BLK2_DATA3.Reg) & 0x3ff
}
func (o *EFUSE_Type) SetRD_BLK2_DATA3_ADC_CALIBRATION_0(value uint32) {
	volatile.StoreUint32(&o.RD_BLK2_DATA3.Reg, volatile.LoadUint32(&o.RD_BLK2_DATA3.Reg)&^(0xfffffc00)|value<<10)
}
func (o *EFUSE_Type) GetRD_BLK2_DATA3_ADC_CALIBRATION_0() uint32 {
	return (volatile.LoadUint32(&o.RD_BLK2_DATA3.Reg) & 0xfffffc00) >> 10
}

// EFUSE.RD_BLK2_DATA4: Register 4 of BLOCK2.
func (o *EFUSE_Type) SetRD_BLK2_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_BLK2_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_BLK2_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_BLK2_DATA4.Reg)
}

// EFUSE.RD_BLK2_DATA5: Register 5 of BLOCK2.
func (o *EFUSE_Type) SetRD_BLK2_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_BLK2_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_BLK2_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_BLK2_DATA5.Reg)
}

// EFUSE.RD_BLK2_DATA6: Register 6 of BLOCK2.
func (o *EFUSE_Type) SetRD_BLK2_DATA6_ADC_CALIBRATION_3(value uint32) {
	volatile.StoreUint32(&o.RD_BLK2_DATA6.Reg, volatile.LoadUint32(&o.RD_BLK2_DATA6.Reg)&^(0x7ff)|value)
}
func (o *EFUSE_Type) GetRD_BLK2_DATA6_ADC_CALIBRATION_3() uint32 {
	return volatile.LoadUint32(&o.RD_BLK2_DATA6.Reg) & 0x7ff
}
func (o *EFUSE_Type) SetRD_BLK2_DATA6_BLK2_RESERVED_DATA_0(value uint32) {
	volatile.StoreUint32(&o.RD_BLK2_DATA6.Reg, volatile.LoadUint32(&o.RD_BLK2_DATA6.Reg)&^(0xfffff800)|value<<11)
}
func (o *EFUSE_Type) GetRD_BLK2_DATA6_BLK2_RESERVED_DATA_0() uint32 {
	return (volatile.LoadUint32(&o.RD_BLK2_DATA6.Reg) & 0xfffff800) >> 11
}

// EFUSE.RD_BLK2_DATA7: Register 7 of BLOCK2.
func (o *EFUSE_Type) SetRD_BLK2_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_BLK2_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_BLK2_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_BLK2_DATA7.Reg)
}

// EFUSE.RD_BLK3_DATA0: Register 0 of BLOCK3.
func (o *EFUSE_Type) SetRD_BLK3_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_BLK3_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_BLK3_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_BLK3_DATA0.Reg)
}

// EFUSE.RD_BLK3_DATA1: Register 1 of BLOCK3.
func (o *EFUSE_Type) SetRD_BLK3_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_BLK3_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_BLK3_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_BLK3_DATA1.Reg)
}

// EFUSE.RD_BLK3_DATA2: Register 2 of BLOCK3.
func (o *EFUSE_Type) SetRD_BLK3_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_BLK3_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_BLK3_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_BLK3_DATA2.Reg)
}

// EFUSE.RD_BLK3_DATA3: Register 3 of BLOCK3.
func (o *EFUSE_Type) SetRD_BLK3_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_BLK3_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_BLK3_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_BLK3_DATA3.Reg)
}

// EFUSE.RD_BLK3_DATA4: Register 4 of BLOCK3.
func (o *EFUSE_Type) SetRD_BLK3_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_BLK3_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_BLK3_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_BLK3_DATA4.Reg)
}

// EFUSE.RD_BLK3_DATA5: Register 5 of BLOCK3.
func (o *EFUSE_Type) SetRD_BLK3_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_BLK3_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_BLK3_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_BLK3_DATA5.Reg)
}

// EFUSE.RD_BLK3_DATA6: Register 6 of BLOCK3.
func (o *EFUSE_Type) SetRD_BLK3_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_BLK3_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_BLK3_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_BLK3_DATA6.Reg)
}

// EFUSE.RD_BLK3_DATA7: Register 7 of BLOCK3.
func (o *EFUSE_Type) SetRD_BLK3_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_BLK3_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_BLK3_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_BLK3_DATA7.Reg)
}

// EFUSE.RD_REPEAT_ERR: Programming error record register 0 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_ERR_RD_DIS_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg)&^(0x3)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR_RD_DIS_ERR() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg) & 0x3
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR_WDT_DELAY_SEL_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg)&^(0xc)|value<<2)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR_WDT_DELAY_SEL_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg) & 0xc) >> 2
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR_DIS_PAD_JTAG_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg)&^(0x10)|value<<4)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR_DIS_PAD_JTAG_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg) & 0x10) >> 4
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR_DIS_DOWNLOAD_ICACHE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg)&^(0x20)|value<<5)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR_DIS_DOWNLOAD_ICACHE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg) & 0x20) >> 5
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR_DIS_DOWNLOAD_MANUAL_ENCRYPT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg)&^(0x40)|value<<6)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR_DIS_DOWNLOAD_MANUAL_ENCRYPT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg) & 0x40) >> 6
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR_SPI_BOOT_ENCRYPT_DECRYPT_CNT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg)&^(0x380)|value<<7)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR_SPI_BOOT_ENCRYPT_DECRYPT_CNT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg) & 0x380) >> 7
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR_XTS_KEY_LENGTH_256_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg)&^(0x400)|value<<10)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR_XTS_KEY_LENGTH_256_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg) & 0x400) >> 10
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR_UART_PRINT_CONTROL_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg)&^(0x1800)|value<<11)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR_UART_PRINT_CONTROL_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg) & 0x1800) >> 11
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR_FORCE_SEND_RESUME_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg)&^(0x2000)|value<<13)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR_FORCE_SEND_RESUME_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg) & 0x2000) >> 13
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR_DIS_DOWNLOAD_MODE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg)&^(0x4000)|value<<14)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR_DIS_DOWNLOAD_MODE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg) & 0x4000) >> 14
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR_DIS_DIRECT_BOOT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg)&^(0x8000)|value<<15)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR_DIS_DIRECT_BOOT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg) & 0x8000) >> 15
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR_ENABLE_SECURITY_DOWNLOAD_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg)&^(0x10000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR_ENABLE_SECURITY_DOWNLOAD_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg) & 0x10000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR_FLASH_TPUW_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg)&^(0x1e0000)|value<<17)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR_FLASH_TPUW_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg) & 0x1e0000) >> 17
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR_SECURE_BOOT_EN_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg)&^(0x200000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR_SECURE_BOOT_EN_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg) & 0x200000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR_RPT4_RESERVED_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg)&^(0xffc00000)|value<<22)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR_RPT4_RESERVED_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR.Reg) & 0xffc00000) >> 22
}

// EFUSE.RD_RS_ERR: Programming error record register 0 of BLOCK1-10.
func (o *EFUSE_Type) SetRD_RS_ERR_BLK1_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR.Reg, volatile.LoadUint32(&o.RD_RS_ERR.Reg)&^(0x7)|value)
}
func (o *EFUSE_Type) GetRD_RS_ERR_BLK1_ERR_NUM() uint32 {
	return volatile.LoadUint32(&o.RD_RS_ERR.Reg) & 0x7
}
func (o *EFUSE_Type) SetRD_RS_ERR_BLK1_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR.Reg, volatile.LoadUint32(&o.RD_RS_ERR.Reg)&^(0x8)|value<<3)
}
func (o *EFUSE_Type) GetRD_RS_ERR_BLK1_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR.Reg) & 0x8) >> 3
}
func (o *EFUSE_Type) SetRD_RS_ERR_BLK2_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR.Reg, volatile.LoadUint32(&o.RD_RS_ERR.Reg)&^(0x70)|value<<4)
}
func (o *EFUSE_Type) GetRD_RS_ERR_BLK2_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR.Reg) & 0x70) >> 4
}
func (o *EFUSE_Type) SetRD_RS_ERR_BLK2_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR.Reg, volatile.LoadUint32(&o.RD_RS_ERR.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetRD_RS_ERR_BLK2_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetRD_RS_ERR_BLK3_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR.Reg, volatile.LoadUint32(&o.RD_RS_ERR.Reg)&^(0x700)|value<<8)
}
func (o *EFUSE_Type) GetRD_RS_ERR_BLK3_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR.Reg) & 0x700) >> 8
}
func (o *EFUSE_Type) SetRD_RS_ERR_BLK3_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR.Reg, volatile.LoadUint32(&o.RD_RS_ERR.Reg)&^(0x800)|value<<11)
}
func (o *EFUSE_Type) GetRD_RS_ERR_BLK3_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR.Reg) & 0x800) >> 11
}

// EFUSE.CLK: eFuse clcok configuration register.
func (o *EFUSE_Type) SetCLK_EFUSE_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetCLK_EFUSE_MEM_FORCE_PD() uint32 {
	return volatile.LoadUint32(&o.CLK.Reg) & 0x1
}
func (o *EFUSE_Type) SetCLK_MEM_CLK_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetCLK_MEM_CLK_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0x2) >> 1
}
func (o *EFUSE_Type) SetCLK_EFUSE_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x4)|value<<2)
}
func (o *EFUSE_Type) GetCLK_EFUSE_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0x4) >> 2
}
func (o *EFUSE_Type) SetCLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x10000)|value<<16)
}
func (o *EFUSE_Type) GetCLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0x10000) >> 16
}

// EFUSE.CONF: eFuse operation mode configuraiton register
func (o *EFUSE_Type) SetCONF_OP_CODE(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetCONF_OP_CODE() uint32 {
	return volatile.LoadUint32(&o.CONF.Reg) & 0xffff
}

// EFUSE.STATUS: eFuse status register.
func (o *EFUSE_Type) SetSTATUS_STATE(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xf)|value)
}
func (o *EFUSE_Type) GetSTATUS_STATE() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0xf
}
func (o *EFUSE_Type) SetSTATUS_OTP_LOAD_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *EFUSE_Type) GetSTATUS_OTP_LOAD_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *EFUSE_Type) SetSTATUS_OTP_VDDQ_C_SYNC2(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *EFUSE_Type) GetSTATUS_OTP_VDDQ_C_SYNC2() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x20) >> 5
}
func (o *EFUSE_Type) SetSTATUS_OTP_STROBE_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x40)|value<<6)
}
func (o *EFUSE_Type) GetSTATUS_OTP_STROBE_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x40) >> 6
}
func (o *EFUSE_Type) SetSTATUS_OTP_CSB_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetSTATUS_OTP_CSB_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetSTATUS_OTP_PGENB_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetSTATUS_OTP_PGENB_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetSTATUS_OTP_VDDQ_IS_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetSTATUS_OTP_VDDQ_IS_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetSTATUS_BLK0_VALID_BIT_CNT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xfc00)|value<<10)
}
func (o *EFUSE_Type) GetSTATUS_BLK0_VALID_BIT_CNT() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0xfc00) >> 10
}

// EFUSE.CMD: eFuse command register.
func (o *EFUSE_Type) SetCMD_READ_CMD(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetCMD_READ_CMD() uint32 {
	return volatile.LoadUint32(&o.CMD.Reg) & 0x1
}
func (o *EFUSE_Type) SetCMD_PGM_CMD(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetCMD_PGM_CMD() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x2) >> 1
}
func (o *EFUSE_Type) SetCMD_BLK_NUM(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0xc)|value<<2)
}
func (o *EFUSE_Type) GetCMD_BLK_NUM() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0xc) >> 2
}

// EFUSE.INT_RAW: eFuse raw interrupt register.
func (o *EFUSE_Type) SetINT_RAW_READ_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_RAW_READ_DONE_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_RAW_PGM_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_RAW_PGM_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}

// EFUSE.INT_ST: eFuse interrupt status register.
func (o *EFUSE_Type) SetINT_ST_READ_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_ST_READ_DONE_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_ST_PGM_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_ST_PGM_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2) >> 1
}

// EFUSE.INT_ENA: eFuse interrupt enable register.
func (o *EFUSE_Type) SetINT_ENA_READ_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_ENA_READ_DONE_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_ENA_PGM_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_ENA_PGM_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}

// EFUSE.INT_CLR: eFuse interrupt clear register.
func (o *EFUSE_Type) SetINT_CLR_READ_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_CLR_READ_DONE_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_CLR_PGM_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_CLR_PGM_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}

// EFUSE.DAC_CONF: Controls the eFuse programming voltage.
func (o *EFUSE_Type) SetDAC_CONF_DAC_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.DAC_CONF.Reg, volatile.LoadUint32(&o.DAC_CONF.Reg)&^(0xff)|value)
}
func (o *EFUSE_Type) GetDAC_CONF_DAC_CLK_DIV() uint32 {
	return volatile.LoadUint32(&o.DAC_CONF.Reg) & 0xff
}
func (o *EFUSE_Type) SetDAC_CONF_DAC_CLK_PAD_SEL(value uint32) {
	volatile.StoreUint32(&o.DAC_CONF.Reg, volatile.LoadUint32(&o.DAC_CONF.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetDAC_CONF_DAC_CLK_PAD_SEL() uint32 {
	return (volatile.LoadUint32(&o.DAC_CONF.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetDAC_CONF_DAC_NUM(value uint32) {
	volatile.StoreUint32(&o.DAC_CONF.Reg, volatile.LoadUint32(&o.DAC_CONF.Reg)&^(0x1fe00)|value<<9)
}
func (o *EFUSE_Type) GetDAC_CONF_DAC_NUM() uint32 {
	return (volatile.LoadUint32(&o.DAC_CONF.Reg) & 0x1fe00) >> 9
}
func (o *EFUSE_Type) SetDAC_CONF_OE_CLR(value uint32) {
	volatile.StoreUint32(&o.DAC_CONF.Reg, volatile.LoadUint32(&o.DAC_CONF.Reg)&^(0x20000)|value<<17)
}
func (o *EFUSE_Type) GetDAC_CONF_OE_CLR() uint32 {
	return (volatile.LoadUint32(&o.DAC_CONF.Reg) & 0x20000) >> 17
}

// EFUSE.RD_TIM_CONF: Configures read timing parameters.
func (o *EFUSE_Type) SetRD_TIM_CONF_THR_A(value uint32) {
	volatile.StoreUint32(&o.RD_TIM_CONF.Reg, volatile.LoadUint32(&o.RD_TIM_CONF.Reg)&^(0xff)|value)
}
func (o *EFUSE_Type) GetRD_TIM_CONF_THR_A() uint32 {
	return volatile.LoadUint32(&o.RD_TIM_CONF.Reg) & 0xff
}
func (o *EFUSE_Type) SetRD_TIM_CONF_TRD(value uint32) {
	volatile.StoreUint32(&o.RD_TIM_CONF.Reg, volatile.LoadUint32(&o.RD_TIM_CONF.Reg)&^(0xff00)|value<<8)
}
func (o *EFUSE_Type) GetRD_TIM_CONF_TRD() uint32 {
	return (volatile.LoadUint32(&o.RD_TIM_CONF.Reg) & 0xff00) >> 8
}
func (o *EFUSE_Type) SetRD_TIM_CONF_TSUR_A(value uint32) {
	volatile.StoreUint32(&o.RD_TIM_CONF.Reg, volatile.LoadUint32(&o.RD_TIM_CONF.Reg)&^(0xff0000)|value<<16)
}
func (o *EFUSE_Type) GetRD_TIM_CONF_TSUR_A() uint32 {
	return (volatile.LoadUint32(&o.RD_TIM_CONF.Reg) & 0xff0000) >> 16
}
func (o *EFUSE_Type) SetRD_TIM_CONF_READ_INIT_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_TIM_CONF.Reg, volatile.LoadUint32(&o.RD_TIM_CONF.Reg)&^(0xff000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_TIM_CONF_READ_INIT_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_TIM_CONF.Reg) & 0xff000000) >> 24
}

// EFUSE.WR_TIM_CONF0: Configurarion register 0 of eFuse programming timing parameters.
func (o *EFUSE_Type) SetWR_TIM_CONF0_THP_A(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF0.Reg, volatile.LoadUint32(&o.WR_TIM_CONF0.Reg)&^(0xff)|value)
}
func (o *EFUSE_Type) GetWR_TIM_CONF0_THP_A() uint32 {
	return volatile.LoadUint32(&o.WR_TIM_CONF0.Reg) & 0xff
}
func (o *EFUSE_Type) SetWR_TIM_CONF0_TPGM_INACTIVE(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF0.Reg, volatile.LoadUint32(&o.WR_TIM_CONF0.Reg)&^(0xff00)|value<<8)
}
func (o *EFUSE_Type) GetWR_TIM_CONF0_TPGM_INACTIVE() uint32 {
	return (volatile.LoadUint32(&o.WR_TIM_CONF0.Reg) & 0xff00) >> 8
}
func (o *EFUSE_Type) SetWR_TIM_CONF0_TPGM(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF0.Reg, volatile.LoadUint32(&o.WR_TIM_CONF0.Reg)&^(0xffff0000)|value<<16)
}
func (o *EFUSE_Type) GetWR_TIM_CONF0_TPGM() uint32 {
	return (volatile.LoadUint32(&o.WR_TIM_CONF0.Reg) & 0xffff0000) >> 16
}

// EFUSE.WR_TIM_CONF1: Configurarion register 1 of eFuse programming timing parameters.
func (o *EFUSE_Type) SetWR_TIM_CONF1_TSUP_A(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF1.Reg, volatile.LoadUint32(&o.WR_TIM_CONF1.Reg)&^(0xff)|value)
}
func (o *EFUSE_Type) GetWR_TIM_CONF1_TSUP_A() uint32 {
	return volatile.LoadUint32(&o.WR_TIM_CONF1.Reg) & 0xff
}
func (o *EFUSE_Type) SetWR_TIM_CONF1_PWR_ON_NUM(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF1.Reg, volatile.LoadUint32(&o.WR_TIM_CONF1.Reg)&^(0xffff00)|value<<8)
}
func (o *EFUSE_Type) GetWR_TIM_CONF1_PWR_ON_NUM() uint32 {
	return (volatile.LoadUint32(&o.WR_TIM_CONF1.Reg) & 0xffff00) >> 8
}

// EFUSE.WR_TIM_CONF2: Configurarion register 2 of eFuse programming timing parameters.
func (o *EFUSE_Type) SetWR_TIM_CONF2_PWR_OFF_NUM(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF2.Reg, volatile.LoadUint32(&o.WR_TIM_CONF2.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetWR_TIM_CONF2_PWR_OFF_NUM() uint32 {
	return volatile.LoadUint32(&o.WR_TIM_CONF2.Reg) & 0xffff
}

// EFUSE.DATE: eFuse version register.
func (o *EFUSE_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *EFUSE_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// External Memory
type EXTMEM_Type struct {
	ICACHE_CTRL                          volatile.Register32 // 0x0
	ICACHE_CTRL1                         volatile.Register32 // 0x4
	ICACHE_TAG_POWER_CTRL                volatile.Register32 // 0x8
	_                                    [28]byte
	ICACHE_SYNC_CTRL                     volatile.Register32 // 0x28
	ICACHE_SYNC_ADDR                     volatile.Register32 // 0x2C
	ICACHE_SYNC_SIZE                     volatile.Register32 // 0x30
	_                                    [32]byte
	IBUS_TO_FLASH_START_VADDR            volatile.Register32 // 0x54
	IBUS_TO_FLASH_END_VADDR              volatile.Register32 // 0x58
	DBUS_TO_FLASH_START_VADDR            volatile.Register32 // 0x5C
	DBUS_TO_FLASH_END_VADDR              volatile.Register32 // 0x60
	CACHE_ACS_CNT_CLR                    volatile.Register32 // 0x64
	_                                    [16]byte
	CACHE_ILG_INT_ENA                    volatile.Register32 // 0x78
	CACHE_ILG_INT_CLR                    volatile.Register32 // 0x7C
	CACHE_ILG_INT_ST                     volatile.Register32 // 0x80
	CORE0_ACS_CACHE_INT_ENA              volatile.Register32 // 0x84
	CORE0_ACS_CACHE_INT_CLR              volatile.Register32 // 0x88
	CORE0_ACS_CACHE_INT_ST               volatile.Register32 // 0x8C
	CORE0_DBUS_REJECT_ST                 volatile.Register32 // 0x90
	CORE0_DBUS_REJECT_VADDR              volatile.Register32 // 0x94
	CORE0_IBUS_REJECT_ST                 volatile.Register32 // 0x98
	CORE0_IBUS_REJECT_VADDR              volatile.Register32 // 0x9C
	CACHE_MMU_FAULT_CONTENT              volatile.Register32 // 0xA0
	CACHE_MMU_FAULT_VADDR                volatile.Register32 // 0xA4
	CACHE_WRAP_AROUND_CTRL               volatile.Register32 // 0xA8
	CACHE_MMU_POWER_CTRL                 volatile.Register32 // 0xAC
	CACHE_STATE                          volatile.Register32 // 0xB0
	CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE volatile.Register32 // 0xB4
	CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON   volatile.Register32 // 0xB8
	CACHE_PRELOAD_INT_CTRL               volatile.Register32 // 0xBC
	CACHE_SYNC_INT_CTRL                  volatile.Register32 // 0xC0
	CACHE_MMU_OWNER                      volatile.Register32 // 0xC4
	CACHE_CONF_MISC                      volatile.Register32 // 0xC8
	ICACHE_FREEZE                        volatile.Register32 // 0xCC
	ICACHE_ATOMIC_OPERATE_ENA            volatile.Register32 // 0xD0
	CACHE_REQUEST                        volatile.Register32 // 0xD4
	_                                    [40]byte
	CLOCK_GATE                           volatile.Register32 // 0x100
	_                                    [760]byte
	REG_DATE                             volatile.Register32 // 0x3FC
}

// EXTMEM.ICACHE_CTRL: This description will be updated in the near future.
func (o *EXTMEM_Type) SetICACHE_CTRL_ICACHE_ENABLE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetICACHE_CTRL_ICACHE_ENABLE() uint32 {
	return volatile.LoadUint32(&o.ICACHE_CTRL.Reg) & 0x1
}

// EXTMEM.ICACHE_CTRL1: This description will be updated in the near future.
func (o *EXTMEM_Type) SetICACHE_CTRL1_ICACHE_SHUT_IBUS(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CTRL1.Reg, volatile.LoadUint32(&o.ICACHE_CTRL1.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetICACHE_CTRL1_ICACHE_SHUT_IBUS() uint32 {
	return volatile.LoadUint32(&o.ICACHE_CTRL1.Reg) & 0x1
}
func (o *EXTMEM_Type) SetICACHE_CTRL1_ICACHE_SHUT_DBUS(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CTRL1.Reg, volatile.LoadUint32(&o.ICACHE_CTRL1.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetICACHE_CTRL1_ICACHE_SHUT_DBUS() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CTRL1.Reg) & 0x2) >> 1
}

// EXTMEM.ICACHE_TAG_POWER_CTRL: This description will be updated in the near future.
func (o *EXTMEM_Type) SetICACHE_TAG_POWER_CTRL_ICACHE_TAG_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.ICACHE_TAG_POWER_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_TAG_POWER_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetICACHE_TAG_POWER_CTRL_ICACHE_TAG_MEM_FORCE_ON() uint32 {
	return volatile.LoadUint32(&o.ICACHE_TAG_POWER_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetICACHE_TAG_POWER_CTRL_ICACHE_TAG_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.ICACHE_TAG_POWER_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_TAG_POWER_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetICACHE_TAG_POWER_CTRL_ICACHE_TAG_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_TAG_POWER_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetICACHE_TAG_POWER_CTRL_ICACHE_TAG_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.ICACHE_TAG_POWER_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_TAG_POWER_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetICACHE_TAG_POWER_CTRL_ICACHE_TAG_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_TAG_POWER_CTRL.Reg) & 0x4) >> 2
}

// EXTMEM.ICACHE_SYNC_CTRL: This description will be updated in the near future.
func (o *EXTMEM_Type) SetICACHE_SYNC_CTRL_ICACHE_INVALIDATE_ENA(value uint32) {
	volatile.StoreUint32(&o.ICACHE_SYNC_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_SYNC_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetICACHE_SYNC_CTRL_ICACHE_INVALIDATE_ENA() uint32 {
	return volatile.LoadUint32(&o.ICACHE_SYNC_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetICACHE_SYNC_CTRL_ICACHE_SYNC_DONE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_SYNC_CTRL.Reg, volatile.LoadUint32(&o.ICACHE_SYNC_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetICACHE_SYNC_CTRL_ICACHE_SYNC_DONE() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_SYNC_CTRL.Reg) & 0x2) >> 1
}

// EXTMEM.ICACHE_SYNC_ADDR: This description will be updated in the near future.
func (o *EXTMEM_Type) SetICACHE_SYNC_ADDR(value uint32) {
	volatile.StoreUint32(&o.ICACHE_SYNC_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetICACHE_SYNC_ADDR() uint32 {
	return volatile.LoadUint32(&o.ICACHE_SYNC_ADDR.Reg)
}

// EXTMEM.ICACHE_SYNC_SIZE: This description will be updated in the near future.
func (o *EXTMEM_Type) SetICACHE_SYNC_SIZE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_SYNC_SIZE.Reg, volatile.LoadUint32(&o.ICACHE_SYNC_SIZE.Reg)&^(0x7fffff)|value)
}
func (o *EXTMEM_Type) GetICACHE_SYNC_SIZE() uint32 {
	return volatile.LoadUint32(&o.ICACHE_SYNC_SIZE.Reg) & 0x7fffff
}

// EXTMEM.IBUS_TO_FLASH_START_VADDR: This description will be updated in the near future.
func (o *EXTMEM_Type) SetIBUS_TO_FLASH_START_VADDR(value uint32) {
	volatile.StoreUint32(&o.IBUS_TO_FLASH_START_VADDR.Reg, value)
}
func (o *EXTMEM_Type) GetIBUS_TO_FLASH_START_VADDR() uint32 {
	return volatile.LoadUint32(&o.IBUS_TO_FLASH_START_VADDR.Reg)
}

// EXTMEM.IBUS_TO_FLASH_END_VADDR: This description will be updated in the near future.
func (o *EXTMEM_Type) SetIBUS_TO_FLASH_END_VADDR(value uint32) {
	volatile.StoreUint32(&o.IBUS_TO_FLASH_END_VADDR.Reg, value)
}
func (o *EXTMEM_Type) GetIBUS_TO_FLASH_END_VADDR() uint32 {
	return volatile.LoadUint32(&o.IBUS_TO_FLASH_END_VADDR.Reg)
}

// EXTMEM.DBUS_TO_FLASH_START_VADDR: This description will be updated in the near future.
func (o *EXTMEM_Type) SetDBUS_TO_FLASH_START_VADDR(value uint32) {
	volatile.StoreUint32(&o.DBUS_TO_FLASH_START_VADDR.Reg, value)
}
func (o *EXTMEM_Type) GetDBUS_TO_FLASH_START_VADDR() uint32 {
	return volatile.LoadUint32(&o.DBUS_TO_FLASH_START_VADDR.Reg)
}

// EXTMEM.DBUS_TO_FLASH_END_VADDR: This description will be updated in the near future.
func (o *EXTMEM_Type) SetDBUS_TO_FLASH_END_VADDR(value uint32) {
	volatile.StoreUint32(&o.DBUS_TO_FLASH_END_VADDR.Reg, value)
}
func (o *EXTMEM_Type) GetDBUS_TO_FLASH_END_VADDR() uint32 {
	return volatile.LoadUint32(&o.DBUS_TO_FLASH_END_VADDR.Reg)
}

// EXTMEM.CACHE_ACS_CNT_CLR: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCACHE_ACS_CNT_CLR_IBUS_ACS_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_ACS_CNT_CLR.Reg, volatile.LoadUint32(&o.CACHE_ACS_CNT_CLR.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_ACS_CNT_CLR_IBUS_ACS_CNT_CLR() uint32 {
	return volatile.LoadUint32(&o.CACHE_ACS_CNT_CLR.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_ACS_CNT_CLR_DBUS_ACS_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_ACS_CNT_CLR.Reg, volatile.LoadUint32(&o.CACHE_ACS_CNT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_ACS_CNT_CLR_DBUS_ACS_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ACS_CNT_CLR.Reg) & 0x2) >> 1
}

// EXTMEM.CACHE_ILG_INT_ENA: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ENA_ICACHE_SYNC_OP_FAULT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ENA_ICACHE_SYNC_OP_FAULT_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ENA_ICACHE_PRELOAD_OP_FAULT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ENA_ICACHE_PRELOAD_OP_FAULT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ENA_MMU_ENTRY_FAULT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ENA_MMU_ENTRY_FAULT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ENA_IBUS_CNT_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg)&^(0x80)|value<<7)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ENA_IBUS_CNT_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg) & 0x80) >> 7
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ENA_DBUS_CNT_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ENA_DBUS_CNT_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ENA.Reg) & 0x100) >> 8
}

// EXTMEM.CACHE_ILG_INT_CLR: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCACHE_ILG_INT_CLR_ICACHE_SYNC_OP_FAULT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_CLR_ICACHE_SYNC_OP_FAULT_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_CLR_ICACHE_PRELOAD_OP_FAULT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_CLR_ICACHE_PRELOAD_OP_FAULT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_CLR_MMU_ENTRY_FAULT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_CLR_MMU_ENTRY_FAULT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_CLR_IBUS_CNT_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg)&^(0x80)|value<<7)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_CLR_IBUS_CNT_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg) & 0x80) >> 7
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_CLR_DBUS_CNT_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_CLR_DBUS_CNT_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_CLR.Reg) & 0x100) >> 8
}

// EXTMEM.CACHE_ILG_INT_ST: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ST_ICACHE_SYNC_OP_FAULT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ST.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ST_ICACHE_SYNC_OP_FAULT_ST() uint32 {
	return volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ST_ICACHE_PRELOAD_OP_FAULT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ST.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ST_ICACHE_PRELOAD_OP_FAULT_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ST_MMU_ENTRY_FAULT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ST.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ST_MMU_ENTRY_FAULT_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ST_IBUS_ACS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ST.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg)&^(0x80)|value<<7)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ST_IBUS_ACS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg) & 0x80) >> 7
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ST_IBUS_ACS_MISS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ST.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ST_IBUS_ACS_MISS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ST_DBUS_ACS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ST.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ST_DBUS_ACS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetCACHE_ILG_INT_ST_DBUS_ACS_FLASH_MISS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_ILG_INT_ST.Reg, volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetCACHE_ILG_INT_ST_DBUS_ACS_FLASH_MISS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ILG_INT_ST.Reg) & 0x400) >> 10
}

// EXTMEM.CORE0_ACS_CACHE_INT_ENA: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_ENA_CORE0_IBUS_ACS_MSK_IC_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_ENA_CORE0_IBUS_ACS_MSK_IC_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_ENA_CORE0_IBUS_WR_IC_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_ENA_CORE0_IBUS_WR_IC_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_ENA_CORE0_IBUS_REJECT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_ENA_CORE0_IBUS_REJECT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_ENA_CORE0_DBUS_ACS_MSK_IC_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_ENA_CORE0_DBUS_ACS_MSK_IC_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_ENA_CORE0_DBUS_REJECT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_ENA_CORE0_DBUS_REJECT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_ENA_CORE0_DBUS_WR_IC_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_ENA_CORE0_DBUS_WR_IC_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ENA.Reg) & 0x20) >> 5
}

// EXTMEM.CORE0_ACS_CACHE_INT_CLR: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_CLR_CORE0_IBUS_ACS_MSK_IC_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_CLR_CORE0_IBUS_ACS_MSK_IC_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_CLR_CORE0_IBUS_WR_IC_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_CLR_CORE0_IBUS_WR_IC_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_CLR_CORE0_IBUS_REJECT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_CLR_CORE0_IBUS_REJECT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_CLR_CORE0_DBUS_ACS_MSK_IC_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_CLR_CORE0_DBUS_ACS_MSK_IC_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_CLR_CORE0_DBUS_REJECT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_CLR_CORE0_DBUS_REJECT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_CLR_CORE0_DBUS_WR_IC_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_CLR_CORE0_DBUS_WR_IC_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_CLR.Reg) & 0x20) >> 5
}

// EXTMEM.CORE0_ACS_CACHE_INT_ST: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_ST_CORE0_IBUS_ACS_MSK_ICACHE_ST(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_ST_CORE0_IBUS_ACS_MSK_ICACHE_ST() uint32 {
	return volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_ST_CORE0_IBUS_WR_ICACHE_ST(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_ST_CORE0_IBUS_WR_ICACHE_ST() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_ST_CORE0_IBUS_REJECT_ST(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_ST_CORE0_IBUS_REJECT_ST() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_ST_CORE0_DBUS_ACS_MSK_ICACHE_ST(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_ST_CORE0_DBUS_ACS_MSK_ICACHE_ST() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_ST_CORE0_DBUS_REJECT_ST(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_ST_CORE0_DBUS_REJECT_ST() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetCORE0_ACS_CACHE_INT_ST_CORE0_DBUS_WR_ICACHE_ST(value uint32) {
	volatile.StoreUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg, volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetCORE0_ACS_CACHE_INT_ST_CORE0_DBUS_WR_ICACHE_ST() uint32 {
	return (volatile.LoadUint32(&o.CORE0_ACS_CACHE_INT_ST.Reg) & 0x20) >> 5
}

// EXTMEM.CORE0_DBUS_REJECT_ST: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCORE0_DBUS_REJECT_ST_CORE0_DBUS_ATTR(value uint32) {
	volatile.StoreUint32(&o.CORE0_DBUS_REJECT_ST.Reg, volatile.LoadUint32(&o.CORE0_DBUS_REJECT_ST.Reg)&^(0x7)|value)
}
func (o *EXTMEM_Type) GetCORE0_DBUS_REJECT_ST_CORE0_DBUS_ATTR() uint32 {
	return volatile.LoadUint32(&o.CORE0_DBUS_REJECT_ST.Reg) & 0x7
}
func (o *EXTMEM_Type) SetCORE0_DBUS_REJECT_ST_CORE0_DBUS_WORLD(value uint32) {
	volatile.StoreUint32(&o.CORE0_DBUS_REJECT_ST.Reg, volatile.LoadUint32(&o.CORE0_DBUS_REJECT_ST.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetCORE0_DBUS_REJECT_ST_CORE0_DBUS_WORLD() uint32 {
	return (volatile.LoadUint32(&o.CORE0_DBUS_REJECT_ST.Reg) & 0x8) >> 3
}

// EXTMEM.CORE0_DBUS_REJECT_VADDR: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCORE0_DBUS_REJECT_VADDR(value uint32) {
	volatile.StoreUint32(&o.CORE0_DBUS_REJECT_VADDR.Reg, value)
}
func (o *EXTMEM_Type) GetCORE0_DBUS_REJECT_VADDR() uint32 {
	return volatile.LoadUint32(&o.CORE0_DBUS_REJECT_VADDR.Reg)
}

// EXTMEM.CORE0_IBUS_REJECT_ST: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCORE0_IBUS_REJECT_ST_CORE0_IBUS_ATTR(value uint32) {
	volatile.StoreUint32(&o.CORE0_IBUS_REJECT_ST.Reg, volatile.LoadUint32(&o.CORE0_IBUS_REJECT_ST.Reg)&^(0x7)|value)
}
func (o *EXTMEM_Type) GetCORE0_IBUS_REJECT_ST_CORE0_IBUS_ATTR() uint32 {
	return volatile.LoadUint32(&o.CORE0_IBUS_REJECT_ST.Reg) & 0x7
}
func (o *EXTMEM_Type) SetCORE0_IBUS_REJECT_ST_CORE0_IBUS_WORLD(value uint32) {
	volatile.StoreUint32(&o.CORE0_IBUS_REJECT_ST.Reg, volatile.LoadUint32(&o.CORE0_IBUS_REJECT_ST.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetCORE0_IBUS_REJECT_ST_CORE0_IBUS_WORLD() uint32 {
	return (volatile.LoadUint32(&o.CORE0_IBUS_REJECT_ST.Reg) & 0x8) >> 3
}

// EXTMEM.CORE0_IBUS_REJECT_VADDR: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCORE0_IBUS_REJECT_VADDR(value uint32) {
	volatile.StoreUint32(&o.CORE0_IBUS_REJECT_VADDR.Reg, value)
}
func (o *EXTMEM_Type) GetCORE0_IBUS_REJECT_VADDR() uint32 {
	return volatile.LoadUint32(&o.CORE0_IBUS_REJECT_VADDR.Reg)
}

// EXTMEM.CACHE_MMU_FAULT_CONTENT: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCACHE_MMU_FAULT_CONTENT(value uint32) {
	volatile.StoreUint32(&o.CACHE_MMU_FAULT_CONTENT.Reg, volatile.LoadUint32(&o.CACHE_MMU_FAULT_CONTENT.Reg)&^(0xff)|value)
}
func (o *EXTMEM_Type) GetCACHE_MMU_FAULT_CONTENT() uint32 {
	return volatile.LoadUint32(&o.CACHE_MMU_FAULT_CONTENT.Reg) & 0xff
}
func (o *EXTMEM_Type) SetCACHE_MMU_FAULT_CONTENT_CACHE_MMU_FAULT_CODE(value uint32) {
	volatile.StoreUint32(&o.CACHE_MMU_FAULT_CONTENT.Reg, volatile.LoadUint32(&o.CACHE_MMU_FAULT_CONTENT.Reg)&^(0x3c00)|value<<10)
}
func (o *EXTMEM_Type) GetCACHE_MMU_FAULT_CONTENT_CACHE_MMU_FAULT_CODE() uint32 {
	return (volatile.LoadUint32(&o.CACHE_MMU_FAULT_CONTENT.Reg) & 0x3c00) >> 10
}

// EXTMEM.CACHE_MMU_FAULT_VADDR: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCACHE_MMU_FAULT_VADDR(value uint32) {
	volatile.StoreUint32(&o.CACHE_MMU_FAULT_VADDR.Reg, value)
}
func (o *EXTMEM_Type) GetCACHE_MMU_FAULT_VADDR() uint32 {
	return volatile.LoadUint32(&o.CACHE_MMU_FAULT_VADDR.Reg)
}

// EXTMEM.CACHE_WRAP_AROUND_CTRL: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCACHE_WRAP_AROUND_CTRL_CACHE_FLASH_WRAP_AROUND(value uint32) {
	volatile.StoreUint32(&o.CACHE_WRAP_AROUND_CTRL.Reg, volatile.LoadUint32(&o.CACHE_WRAP_AROUND_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_WRAP_AROUND_CTRL_CACHE_FLASH_WRAP_AROUND() uint32 {
	return volatile.LoadUint32(&o.CACHE_WRAP_AROUND_CTRL.Reg) & 0x1
}

// EXTMEM.CACHE_MMU_POWER_CTRL: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCACHE_MMU_POWER_CTRL_CACHE_MMU_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.CACHE_MMU_POWER_CTRL.Reg, volatile.LoadUint32(&o.CACHE_MMU_POWER_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_MMU_POWER_CTRL_CACHE_MMU_MEM_FORCE_ON() uint32 {
	return volatile.LoadUint32(&o.CACHE_MMU_POWER_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_MMU_POWER_CTRL_CACHE_MMU_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.CACHE_MMU_POWER_CTRL.Reg, volatile.LoadUint32(&o.CACHE_MMU_POWER_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_MMU_POWER_CTRL_CACHE_MMU_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.CACHE_MMU_POWER_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_MMU_POWER_CTRL_CACHE_MMU_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.CACHE_MMU_POWER_CTRL.Reg, volatile.LoadUint32(&o.CACHE_MMU_POWER_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCACHE_MMU_POWER_CTRL_CACHE_MMU_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.CACHE_MMU_POWER_CTRL.Reg) & 0x4) >> 2
}

// EXTMEM.CACHE_STATE: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCACHE_STATE_ICACHE_STATE(value uint32) {
	volatile.StoreUint32(&o.CACHE_STATE.Reg, volatile.LoadUint32(&o.CACHE_STATE.Reg)&^(0xfff)|value)
}
func (o *EXTMEM_Type) GetCACHE_STATE_ICACHE_STATE() uint32 {
	return volatile.LoadUint32(&o.CACHE_STATE.Reg) & 0xfff
}

// EXTMEM.CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCACHE_ENCRYPT_DECRYPT_RECORD_DISABLE_RECORD_DISABLE_DB_ENCRYPT(value uint32) {
	volatile.StoreUint32(&o.CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE.Reg, volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_ENCRYPT_DECRYPT_RECORD_DISABLE_RECORD_DISABLE_DB_ENCRYPT() uint32 {
	return volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_ENCRYPT_DECRYPT_RECORD_DISABLE_RECORD_DISABLE_G0CB_DECRYPT(value uint32) {
	volatile.StoreUint32(&o.CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE.Reg, volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_ENCRYPT_DECRYPT_RECORD_DISABLE_RECORD_DISABLE_G0CB_DECRYPT() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE.Reg) & 0x2) >> 1
}

// EXTMEM.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON_CLK_FORCE_ON_MANUAL_CRYPT(value uint32) {
	volatile.StoreUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg, volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON_CLK_FORCE_ON_MANUAL_CRYPT() uint32 {
	return volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON_CLK_FORCE_ON_AUTO_CRYPT(value uint32) {
	volatile.StoreUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg, volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON_CLK_FORCE_ON_AUTO_CRYPT() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON_CLK_FORCE_ON_CRYPT(value uint32) {
	volatile.StoreUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg, volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON_CLK_FORCE_ON_CRYPT() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg) & 0x4) >> 2
}

// EXTMEM.CACHE_PRELOAD_INT_CTRL: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCACHE_PRELOAD_INT_CTRL_ICACHE_PRELOAD_INT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_PRELOAD_INT_CTRL_ICACHE_PRELOAD_INT_ST() uint32 {
	return volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_PRELOAD_INT_CTRL_ICACHE_PRELOAD_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_PRELOAD_INT_CTRL_ICACHE_PRELOAD_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_PRELOAD_INT_CTRL_ICACHE_PRELOAD_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCACHE_PRELOAD_INT_CTRL_ICACHE_PRELOAD_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg) & 0x4) >> 2
}

// EXTMEM.CACHE_SYNC_INT_CTRL: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCACHE_SYNC_INT_CTRL_ICACHE_SYNC_INT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_INT_CTRL_ICACHE_SYNC_INT_ST() uint32 {
	return volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_SYNC_INT_CTRL_ICACHE_SYNC_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_INT_CTRL_ICACHE_SYNC_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_SYNC_INT_CTRL_ICACHE_SYNC_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_INT_CTRL_ICACHE_SYNC_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg) & 0x4) >> 2
}

// EXTMEM.CACHE_MMU_OWNER: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCACHE_MMU_OWNER(value uint32) {
	volatile.StoreUint32(&o.CACHE_MMU_OWNER.Reg, volatile.LoadUint32(&o.CACHE_MMU_OWNER.Reg)&^(0xf)|value)
}
func (o *EXTMEM_Type) GetCACHE_MMU_OWNER() uint32 {
	return volatile.LoadUint32(&o.CACHE_MMU_OWNER.Reg) & 0xf
}

// EXTMEM.CACHE_CONF_MISC: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCACHE_CONF_MISC_CACHE_IGNORE_PRELOAD_MMU_ENTRY_FAULT(value uint32) {
	volatile.StoreUint32(&o.CACHE_CONF_MISC.Reg, volatile.LoadUint32(&o.CACHE_CONF_MISC.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_CONF_MISC_CACHE_IGNORE_PRELOAD_MMU_ENTRY_FAULT() uint32 {
	return volatile.LoadUint32(&o.CACHE_CONF_MISC.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_CONF_MISC_CACHE_IGNORE_SYNC_MMU_ENTRY_FAULT(value uint32) {
	volatile.StoreUint32(&o.CACHE_CONF_MISC.Reg, volatile.LoadUint32(&o.CACHE_CONF_MISC.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_CONF_MISC_CACHE_IGNORE_SYNC_MMU_ENTRY_FAULT() uint32 {
	return (volatile.LoadUint32(&o.CACHE_CONF_MISC.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_CONF_MISC_CACHE_TRACE_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_CONF_MISC.Reg, volatile.LoadUint32(&o.CACHE_CONF_MISC.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCACHE_CONF_MISC_CACHE_TRACE_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_CONF_MISC.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCACHE_CONF_MISC_CACHE_MMU_PAGE_SIZE(value uint32) {
	volatile.StoreUint32(&o.CACHE_CONF_MISC.Reg, volatile.LoadUint32(&o.CACHE_CONF_MISC.Reg)&^(0x18)|value<<3)
}
func (o *EXTMEM_Type) GetCACHE_CONF_MISC_CACHE_MMU_PAGE_SIZE() uint32 {
	return (volatile.LoadUint32(&o.CACHE_CONF_MISC.Reg) & 0x18) >> 3
}

// EXTMEM.ICACHE_FREEZE: This description will be updated in the near future.
func (o *EXTMEM_Type) SetICACHE_FREEZE_ENA(value uint32) {
	volatile.StoreUint32(&o.ICACHE_FREEZE.Reg, volatile.LoadUint32(&o.ICACHE_FREEZE.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetICACHE_FREEZE_ENA() uint32 {
	return volatile.LoadUint32(&o.ICACHE_FREEZE.Reg) & 0x1
}
func (o *EXTMEM_Type) SetICACHE_FREEZE_MODE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_FREEZE.Reg, volatile.LoadUint32(&o.ICACHE_FREEZE.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetICACHE_FREEZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_FREEZE.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetICACHE_FREEZE_DONE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_FREEZE.Reg, volatile.LoadUint32(&o.ICACHE_FREEZE.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetICACHE_FREEZE_DONE() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_FREEZE.Reg) & 0x4) >> 2
}

// EXTMEM.ICACHE_ATOMIC_OPERATE_ENA: This description will be updated in the near future.
func (o *EXTMEM_Type) SetICACHE_ATOMIC_OPERATE_ENA(value uint32) {
	volatile.StoreUint32(&o.ICACHE_ATOMIC_OPERATE_ENA.Reg, volatile.LoadUint32(&o.ICACHE_ATOMIC_OPERATE_ENA.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetICACHE_ATOMIC_OPERATE_ENA() uint32 {
	return volatile.LoadUint32(&o.ICACHE_ATOMIC_OPERATE_ENA.Reg) & 0x1
}

// EXTMEM.CACHE_REQUEST: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCACHE_REQUEST_BYPASS(value uint32) {
	volatile.StoreUint32(&o.CACHE_REQUEST.Reg, volatile.LoadUint32(&o.CACHE_REQUEST.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_REQUEST_BYPASS() uint32 {
	return volatile.LoadUint32(&o.CACHE_REQUEST.Reg) & 0x1
}

// EXTMEM.CLOCK_GATE: This description will be updated in the near future.
func (o *EXTMEM_Type) SetCLOCK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCLOCK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// EXTMEM.REG_DATE: This description will be updated in the near future.
func (o *EXTMEM_Type) SetREG_DATE_DATE(value uint32) {
	volatile.StoreUint32(&o.REG_DATE.Reg, volatile.LoadUint32(&o.REG_DATE.Reg)&^(0xfffffff)|value)
}
func (o *EXTMEM_Type) GetREG_DATE_DATE() uint32 {
	return volatile.LoadUint32(&o.REG_DATE.Reg) & 0xfffffff
}

// General Purpose Input/Output
type GPIO_Type struct {
	BT_SELECT          volatile.Register32 // 0x0
	OUT                volatile.Register32 // 0x4
	OUT_W1TS           volatile.Register32 // 0x8
	OUT_W1TC           volatile.Register32 // 0xC
	_                  [12]byte
	SDIO_SELECT        volatile.Register32 // 0x1C
	ENABLE             volatile.Register32 // 0x20
	ENABLE_W1TS        volatile.Register32 // 0x24
	ENABLE_W1TC        volatile.Register32 // 0x28
	_                  [12]byte
	STRAP              volatile.Register32 // 0x38
	IN                 volatile.Register32 // 0x3C
	_                  [4]byte
	STATUS             volatile.Register32 // 0x44
	STATUS_W1TS        volatile.Register32 // 0x48
	STATUS_W1TC        volatile.Register32 // 0x4C
	_                  [12]byte
	PCPU_INT           volatile.Register32 // 0x5C
	PCPU_NMI_INT       volatile.Register32 // 0x60
	CPUSDIO_INT        volatile.Register32 // 0x64
	_                  [12]byte
	PIN0               volatile.Register32 // 0x74
	PIN1               volatile.Register32 // 0x78
	PIN2               volatile.Register32 // 0x7C
	PIN3               volatile.Register32 // 0x80
	PIN4               volatile.Register32 // 0x84
	PIN5               volatile.Register32 // 0x88
	PIN6               volatile.Register32 // 0x8C
	PIN7               volatile.Register32 // 0x90
	PIN8               volatile.Register32 // 0x94
	PIN9               volatile.Register32 // 0x98
	PIN10              volatile.Register32 // 0x9C
	PIN11              volatile.Register32 // 0xA0
	PIN12              volatile.Register32 // 0xA4
	PIN13              volatile.Register32 // 0xA8
	PIN14              volatile.Register32 // 0xAC
	PIN15              volatile.Register32 // 0xB0
	PIN16              volatile.Register32 // 0xB4
	PIN17              volatile.Register32 // 0xB8
	PIN18              volatile.Register32 // 0xBC
	PIN19              volatile.Register32 // 0xC0
	PIN20              volatile.Register32 // 0xC4
	PIN21              volatile.Register32 // 0xC8
	PIN22              volatile.Register32 // 0xCC
	PIN23              volatile.Register32 // 0xD0
	PIN24              volatile.Register32 // 0xD4
	_                  [116]byte
	STATUS_NEXT        volatile.Register32 // 0x14C
	_                  [4]byte
	FUNC0_IN_SEL_CFG   volatile.Register32 // 0x154
	FUNC1_IN_SEL_CFG   volatile.Register32 // 0x158
	FUNC2_IN_SEL_CFG   volatile.Register32 // 0x15C
	FUNC3_IN_SEL_CFG   volatile.Register32 // 0x160
	FUNC4_IN_SEL_CFG   volatile.Register32 // 0x164
	FUNC5_IN_SEL_CFG   volatile.Register32 // 0x168
	FUNC6_IN_SEL_CFG   volatile.Register32 // 0x16C
	FUNC7_IN_SEL_CFG   volatile.Register32 // 0x170
	FUNC8_IN_SEL_CFG   volatile.Register32 // 0x174
	FUNC9_IN_SEL_CFG   volatile.Register32 // 0x178
	FUNC10_IN_SEL_CFG  volatile.Register32 // 0x17C
	FUNC11_IN_SEL_CFG  volatile.Register32 // 0x180
	FUNC12_IN_SEL_CFG  volatile.Register32 // 0x184
	FUNC13_IN_SEL_CFG  volatile.Register32 // 0x188
	FUNC14_IN_SEL_CFG  volatile.Register32 // 0x18C
	FUNC15_IN_SEL_CFG  volatile.Register32 // 0x190
	FUNC16_IN_SEL_CFG  volatile.Register32 // 0x194
	FUNC17_IN_SEL_CFG  volatile.Register32 // 0x198
	FUNC18_IN_SEL_CFG  volatile.Register32 // 0x19C
	FUNC19_IN_SEL_CFG  volatile.Register32 // 0x1A0
	FUNC20_IN_SEL_CFG  volatile.Register32 // 0x1A4
	FUNC21_IN_SEL_CFG  volatile.Register32 // 0x1A8
	FUNC22_IN_SEL_CFG  volatile.Register32 // 0x1AC
	FUNC23_IN_SEL_CFG  volatile.Register32 // 0x1B0
	FUNC24_IN_SEL_CFG  volatile.Register32 // 0x1B4
	FUNC25_IN_SEL_CFG  volatile.Register32 // 0x1B8
	FUNC26_IN_SEL_CFG  volatile.Register32 // 0x1BC
	FUNC27_IN_SEL_CFG  volatile.Register32 // 0x1C0
	FUNC28_IN_SEL_CFG  volatile.Register32 // 0x1C4
	FUNC29_IN_SEL_CFG  volatile.Register32 // 0x1C8
	FUNC30_IN_SEL_CFG  volatile.Register32 // 0x1CC
	FUNC31_IN_SEL_CFG  volatile.Register32 // 0x1D0
	FUNC32_IN_SEL_CFG  volatile.Register32 // 0x1D4
	FUNC33_IN_SEL_CFG  volatile.Register32 // 0x1D8
	FUNC34_IN_SEL_CFG  volatile.Register32 // 0x1DC
	FUNC35_IN_SEL_CFG  volatile.Register32 // 0x1E0
	FUNC36_IN_SEL_CFG  volatile.Register32 // 0x1E4
	FUNC37_IN_SEL_CFG  volatile.Register32 // 0x1E8
	FUNC38_IN_SEL_CFG  volatile.Register32 // 0x1EC
	FUNC39_IN_SEL_CFG  volatile.Register32 // 0x1F0
	FUNC40_IN_SEL_CFG  volatile.Register32 // 0x1F4
	FUNC41_IN_SEL_CFG  volatile.Register32 // 0x1F8
	FUNC42_IN_SEL_CFG  volatile.Register32 // 0x1FC
	FUNC43_IN_SEL_CFG  volatile.Register32 // 0x200
	FUNC44_IN_SEL_CFG  volatile.Register32 // 0x204
	FUNC45_IN_SEL_CFG  volatile.Register32 // 0x208
	FUNC46_IN_SEL_CFG  volatile.Register32 // 0x20C
	FUNC47_IN_SEL_CFG  volatile.Register32 // 0x210
	FUNC48_IN_SEL_CFG  volatile.Register32 // 0x214
	FUNC49_IN_SEL_CFG  volatile.Register32 // 0x218
	FUNC50_IN_SEL_CFG  volatile.Register32 // 0x21C
	FUNC51_IN_SEL_CFG  volatile.Register32 // 0x220
	FUNC52_IN_SEL_CFG  volatile.Register32 // 0x224
	FUNC53_IN_SEL_CFG  volatile.Register32 // 0x228
	FUNC54_IN_SEL_CFG  volatile.Register32 // 0x22C
	FUNC55_IN_SEL_CFG  volatile.Register32 // 0x230
	FUNC56_IN_SEL_CFG  volatile.Register32 // 0x234
	FUNC57_IN_SEL_CFG  volatile.Register32 // 0x238
	FUNC58_IN_SEL_CFG  volatile.Register32 // 0x23C
	FUNC59_IN_SEL_CFG  volatile.Register32 // 0x240
	FUNC60_IN_SEL_CFG  volatile.Register32 // 0x244
	FUNC61_IN_SEL_CFG  volatile.Register32 // 0x248
	FUNC62_IN_SEL_CFG  volatile.Register32 // 0x24C
	FUNC63_IN_SEL_CFG  volatile.Register32 // 0x250
	FUNC64_IN_SEL_CFG  volatile.Register32 // 0x254
	FUNC65_IN_SEL_CFG  volatile.Register32 // 0x258
	FUNC66_IN_SEL_CFG  volatile.Register32 // 0x25C
	FUNC67_IN_SEL_CFG  volatile.Register32 // 0x260
	FUNC68_IN_SEL_CFG  volatile.Register32 // 0x264
	FUNC69_IN_SEL_CFG  volatile.Register32 // 0x268
	FUNC70_IN_SEL_CFG  volatile.Register32 // 0x26C
	FUNC71_IN_SEL_CFG  volatile.Register32 // 0x270
	FUNC72_IN_SEL_CFG  volatile.Register32 // 0x274
	FUNC73_IN_SEL_CFG  volatile.Register32 // 0x278
	FUNC74_IN_SEL_CFG  volatile.Register32 // 0x27C
	FUNC75_IN_SEL_CFG  volatile.Register32 // 0x280
	FUNC76_IN_SEL_CFG  volatile.Register32 // 0x284
	FUNC77_IN_SEL_CFG  volatile.Register32 // 0x288
	FUNC78_IN_SEL_CFG  volatile.Register32 // 0x28C
	FUNC79_IN_SEL_CFG  volatile.Register32 // 0x290
	FUNC80_IN_SEL_CFG  volatile.Register32 // 0x294
	FUNC81_IN_SEL_CFG  volatile.Register32 // 0x298
	FUNC82_IN_SEL_CFG  volatile.Register32 // 0x29C
	FUNC83_IN_SEL_CFG  volatile.Register32 // 0x2A0
	FUNC84_IN_SEL_CFG  volatile.Register32 // 0x2A4
	FUNC85_IN_SEL_CFG  volatile.Register32 // 0x2A8
	FUNC86_IN_SEL_CFG  volatile.Register32 // 0x2AC
	FUNC87_IN_SEL_CFG  volatile.Register32 // 0x2B0
	FUNC88_IN_SEL_CFG  volatile.Register32 // 0x2B4
	FUNC89_IN_SEL_CFG  volatile.Register32 // 0x2B8
	FUNC90_IN_SEL_CFG  volatile.Register32 // 0x2BC
	FUNC91_IN_SEL_CFG  volatile.Register32 // 0x2C0
	FUNC92_IN_SEL_CFG  volatile.Register32 // 0x2C4
	FUNC93_IN_SEL_CFG  volatile.Register32 // 0x2C8
	FUNC94_IN_SEL_CFG  volatile.Register32 // 0x2CC
	FUNC95_IN_SEL_CFG  volatile.Register32 // 0x2D0
	FUNC96_IN_SEL_CFG  volatile.Register32 // 0x2D4
	FUNC97_IN_SEL_CFG  volatile.Register32 // 0x2D8
	FUNC98_IN_SEL_CFG  volatile.Register32 // 0x2DC
	FUNC99_IN_SEL_CFG  volatile.Register32 // 0x2E0
	FUNC100_IN_SEL_CFG volatile.Register32 // 0x2E4
	FUNC101_IN_SEL_CFG volatile.Register32 // 0x2E8
	FUNC102_IN_SEL_CFG volatile.Register32 // 0x2EC
	FUNC103_IN_SEL_CFG volatile.Register32 // 0x2F0
	FUNC104_IN_SEL_CFG volatile.Register32 // 0x2F4
	FUNC105_IN_SEL_CFG volatile.Register32 // 0x2F8
	FUNC106_IN_SEL_CFG volatile.Register32 // 0x2FC
	FUNC107_IN_SEL_CFG volatile.Register32 // 0x300
	FUNC108_IN_SEL_CFG volatile.Register32 // 0x304
	FUNC109_IN_SEL_CFG volatile.Register32 // 0x308
	FUNC110_IN_SEL_CFG volatile.Register32 // 0x30C
	FUNC111_IN_SEL_CFG volatile.Register32 // 0x310
	FUNC112_IN_SEL_CFG volatile.Register32 // 0x314
	FUNC113_IN_SEL_CFG volatile.Register32 // 0x318
	FUNC114_IN_SEL_CFG volatile.Register32 // 0x31C
	FUNC115_IN_SEL_CFG volatile.Register32 // 0x320
	FUNC116_IN_SEL_CFG volatile.Register32 // 0x324
	FUNC117_IN_SEL_CFG volatile.Register32 // 0x328
	FUNC118_IN_SEL_CFG volatile.Register32 // 0x32C
	FUNC119_IN_SEL_CFG volatile.Register32 // 0x330
	FUNC120_IN_SEL_CFG volatile.Register32 // 0x334
	FUNC121_IN_SEL_CFG volatile.Register32 // 0x338
	FUNC122_IN_SEL_CFG volatile.Register32 // 0x33C
	FUNC123_IN_SEL_CFG volatile.Register32 // 0x340
	FUNC124_IN_SEL_CFG volatile.Register32 // 0x344
	FUNC125_IN_SEL_CFG volatile.Register32 // 0x348
	FUNC126_IN_SEL_CFG volatile.Register32 // 0x34C
	FUNC127_IN_SEL_CFG volatile.Register32 // 0x350
	_                  [512]byte
	FUNC0_OUT_SEL_CFG  volatile.Register32 // 0x554
	FUNC1_OUT_SEL_CFG  volatile.Register32 // 0x558
	FUNC2_OUT_SEL_CFG  volatile.Register32 // 0x55C
	FUNC3_OUT_SEL_CFG  volatile.Register32 // 0x560
	FUNC4_OUT_SEL_CFG  volatile.Register32 // 0x564
	FUNC5_OUT_SEL_CFG  volatile.Register32 // 0x568
	FUNC6_OUT_SEL_CFG  volatile.Register32 // 0x56C
	FUNC7_OUT_SEL_CFG  volatile.Register32 // 0x570
	FUNC8_OUT_SEL_CFG  volatile.Register32 // 0x574
	FUNC9_OUT_SEL_CFG  volatile.Register32 // 0x578
	FUNC10_OUT_SEL_CFG volatile.Register32 // 0x57C
	FUNC11_OUT_SEL_CFG volatile.Register32 // 0x580
	FUNC12_OUT_SEL_CFG volatile.Register32 // 0x584
	FUNC13_OUT_SEL_CFG volatile.Register32 // 0x588
	FUNC14_OUT_SEL_CFG volatile.Register32 // 0x58C
	FUNC15_OUT_SEL_CFG volatile.Register32 // 0x590
	FUNC16_OUT_SEL_CFG volatile.Register32 // 0x594
	FUNC17_OUT_SEL_CFG volatile.Register32 // 0x598
	FUNC18_OUT_SEL_CFG volatile.Register32 // 0x59C
	FUNC19_OUT_SEL_CFG volatile.Register32 // 0x5A0
	FUNC20_OUT_SEL_CFG volatile.Register32 // 0x5A4
	FUNC21_OUT_SEL_CFG volatile.Register32 // 0x5A8
	FUNC22_OUT_SEL_CFG volatile.Register32 // 0x5AC
	FUNC23_OUT_SEL_CFG volatile.Register32 // 0x5B0
	FUNC24_OUT_SEL_CFG volatile.Register32 // 0x5B4
	_                  [116]byte
	CLOCK_GATE         volatile.Register32 // 0x62C
	_                  [204]byte
	REG_DATE           volatile.Register32 // 0x6FC
}

// GPIO.BT_SELECT: GPIO bit select register
func (o *GPIO_Type) SetBT_SELECT(value uint32) {
	volatile.StoreUint32(&o.BT_SELECT.Reg, value)
}
func (o *GPIO_Type) GetBT_SELECT() uint32 {
	return volatile.LoadUint32(&o.BT_SELECT.Reg)
}

// GPIO.OUT: GPIO output register
func (o *GPIO_Type) SetOUT_DATA_ORIG(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x1ffffff)|value)
}
func (o *GPIO_Type) GetOUT_DATA_ORIG() uint32 {
	return volatile.LoadUint32(&o.OUT.Reg) & 0x1ffffff
}

// GPIO.OUT_W1TS: GPIO output set register
func (o *GPIO_Type) SetOUT_W1TS(value uint32) {
	volatile.StoreUint32(&o.OUT_W1TS.Reg, volatile.LoadUint32(&o.OUT_W1TS.Reg)&^(0x1ffffff)|value)
}
func (o *GPIO_Type) GetOUT_W1TS() uint32 {
	return volatile.LoadUint32(&o.OUT_W1TS.Reg) & 0x1ffffff
}

// GPIO.OUT_W1TC: GPIO output clear register
func (o *GPIO_Type) SetOUT_W1TC(value uint32) {
	volatile.StoreUint32(&o.OUT_W1TC.Reg, volatile.LoadUint32(&o.OUT_W1TC.Reg)&^(0x1ffffff)|value)
}
func (o *GPIO_Type) GetOUT_W1TC() uint32 {
	return volatile.LoadUint32(&o.OUT_W1TC.Reg) & 0x1ffffff
}

// GPIO.SDIO_SELECT: GPIO sdio select register
func (o *GPIO_Type) SetSDIO_SELECT_SDIO_SEL(value uint32) {
	volatile.StoreUint32(&o.SDIO_SELECT.Reg, volatile.LoadUint32(&o.SDIO_SELECT.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetSDIO_SELECT_SDIO_SEL() uint32 {
	return volatile.LoadUint32(&o.SDIO_SELECT.Reg) & 0xff
}

// GPIO.ENABLE: GPIO output enable register
func (o *GPIO_Type) SetENABLE_DATA(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1ffffff)|value)
}
func (o *GPIO_Type) GetENABLE_DATA() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1ffffff
}

// GPIO.ENABLE_W1TS: GPIO output enable set register
func (o *GPIO_Type) SetENABLE_W1TS(value uint32) {
	volatile.StoreUint32(&o.ENABLE_W1TS.Reg, volatile.LoadUint32(&o.ENABLE_W1TS.Reg)&^(0x1ffffff)|value)
}
func (o *GPIO_Type) GetENABLE_W1TS() uint32 {
	return volatile.LoadUint32(&o.ENABLE_W1TS.Reg) & 0x1ffffff
}

// GPIO.ENABLE_W1TC: GPIO output enable clear register
func (o *GPIO_Type) SetENABLE_W1TC(value uint32) {
	volatile.StoreUint32(&o.ENABLE_W1TC.Reg, volatile.LoadUint32(&o.ENABLE_W1TC.Reg)&^(0x1ffffff)|value)
}
func (o *GPIO_Type) GetENABLE_W1TC() uint32 {
	return volatile.LoadUint32(&o.ENABLE_W1TC.Reg) & 0x1ffffff
}

// GPIO.STRAP: pad strapping register
func (o *GPIO_Type) SetSTRAP_STRAPPING(value uint32) {
	volatile.StoreUint32(&o.STRAP.Reg, volatile.LoadUint32(&o.STRAP.Reg)&^(0xffff)|value)
}
func (o *GPIO_Type) GetSTRAP_STRAPPING() uint32 {
	return volatile.LoadUint32(&o.STRAP.Reg) & 0xffff
}

// GPIO.IN: GPIO input register
func (o *GPIO_Type) SetIN_DATA_NEXT(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x1ffffff)|value)
}
func (o *GPIO_Type) GetIN_DATA_NEXT() uint32 {
	return volatile.LoadUint32(&o.IN.Reg) & 0x1ffffff
}

// GPIO.STATUS: GPIO interrupt status register
func (o *GPIO_Type) SetSTATUS_INTERRUPT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1ffffff)|value)
}
func (o *GPIO_Type) GetSTATUS_INTERRUPT() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1ffffff
}

// GPIO.STATUS_W1TS: GPIO interrupt status set register
func (o *GPIO_Type) SetSTATUS_W1TS(value uint32) {
	volatile.StoreUint32(&o.STATUS_W1TS.Reg, volatile.LoadUint32(&o.STATUS_W1TS.Reg)&^(0x1ffffff)|value)
}
func (o *GPIO_Type) GetSTATUS_W1TS() uint32 {
	return volatile.LoadUint32(&o.STATUS_W1TS.Reg) & 0x1ffffff
}

// GPIO.STATUS_W1TC: GPIO interrupt status clear register
func (o *GPIO_Type) SetSTATUS_W1TC(value uint32) {
	volatile.StoreUint32(&o.STATUS_W1TC.Reg, volatile.LoadUint32(&o.STATUS_W1TC.Reg)&^(0x1ffffff)|value)
}
func (o *GPIO_Type) GetSTATUS_W1TC() uint32 {
	return volatile.LoadUint32(&o.STATUS_W1TC.Reg) & 0x1ffffff
}

// GPIO.PCPU_INT: GPIO PRO_CPU interrupt status register
func (o *GPIO_Type) SetPCPU_INT_PROCPU_INT(value uint32) {
	volatile.StoreUint32(&o.PCPU_INT.Reg, volatile.LoadUint32(&o.PCPU_INT.Reg)&^(0x1ffffff)|value)
}
func (o *GPIO_Type) GetPCPU_INT_PROCPU_INT() uint32 {
	return volatile.LoadUint32(&o.PCPU_INT.Reg) & 0x1ffffff
}

// GPIO.PCPU_NMI_INT: GPIO PRO_CPU(not shielded) interrupt status register
func (o *GPIO_Type) SetPCPU_NMI_INT_PROCPU_NMI_INT(value uint32) {
	volatile.StoreUint32(&o.PCPU_NMI_INT.Reg, volatile.LoadUint32(&o.PCPU_NMI_INT.Reg)&^(0x1ffffff)|value)
}
func (o *GPIO_Type) GetPCPU_NMI_INT_PROCPU_NMI_INT() uint32 {
	return volatile.LoadUint32(&o.PCPU_NMI_INT.Reg) & 0x1ffffff
}

// GPIO.CPUSDIO_INT: GPIO CPUSDIO interrupt status register
func (o *GPIO_Type) SetCPUSDIO_INT_SDIO_INT(value uint32) {
	volatile.StoreUint32(&o.CPUSDIO_INT.Reg, volatile.LoadUint32(&o.CPUSDIO_INT.Reg)&^(0x1ffffff)|value)
}
func (o *GPIO_Type) GetCPUSDIO_INT_SDIO_INT() uint32 {
	return volatile.LoadUint32(&o.CPUSDIO_INT.Reg) & 0x1ffffff
}

// GPIO.PIN0: GPIO pin configuration register
func (o *GPIO_Type) SetPIN0_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN0_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN0.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN0_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN0_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN0_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN0_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN0_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN0_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN0_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN0_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN0_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN0_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN0_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x3e000) >> 13
}

// GPIO.PIN1: GPIO pin configuration register
func (o *GPIO_Type) SetPIN1_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN1_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN1.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN1_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN1_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN1_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN1_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN1_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN1_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN1_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN1_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN1_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN1_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x3e000) >> 13
}

// GPIO.PIN2: GPIO pin configuration register
func (o *GPIO_Type) SetPIN2_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN2_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN2.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN2_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN2_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN2_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN2_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN2_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN2_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN2_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN2_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN2_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN2_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x3e000) >> 13
}

// GPIO.PIN3: GPIO pin configuration register
func (o *GPIO_Type) SetPIN3_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN3_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN3.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN3_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN3_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN3_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN3_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN3_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN3_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN3_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN3_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN3_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN3_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN3_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN3_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x3e000) >> 13
}

// GPIO.PIN4: GPIO pin configuration register
func (o *GPIO_Type) SetPIN4_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN4_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN4.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN4_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN4_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN4_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN4_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN4_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN4_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN4_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN4_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN4_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN4_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN4_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN4_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x3e000) >> 13
}

// GPIO.PIN5: GPIO pin configuration register
func (o *GPIO_Type) SetPIN5_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN5_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN5.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN5_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN5_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN5_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN5_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN5_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN5_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN5_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN5_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN5_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN5_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN5_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN5_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x3e000) >> 13
}

// GPIO.PIN6: GPIO pin configuration register
func (o *GPIO_Type) SetPIN6_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN6_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN6.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN6_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN6_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN6_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN6_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN6_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN6_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN6_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN6_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN6_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN6_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN6_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN6_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x3e000) >> 13
}

// GPIO.PIN7: GPIO pin configuration register
func (o *GPIO_Type) SetPIN7_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN7_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN7.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN7_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN7_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN7_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN7_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN7_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN7_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN7_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN7_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN7_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN7_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN7_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN7_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x3e000) >> 13
}

// GPIO.PIN8: GPIO pin configuration register
func (o *GPIO_Type) SetPIN8_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN8_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN8.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN8_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN8_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN8_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN8_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN8_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN8_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN8_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN8_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN8_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN8_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN8_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN8_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x3e000) >> 13
}

// GPIO.PIN9: GPIO pin configuration register
func (o *GPIO_Type) SetPIN9_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN9_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN9.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN9_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN9_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN9_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN9_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN9_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN9_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN9_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN9_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN9_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN9_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN9_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN9_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x3e000) >> 13
}

// GPIO.PIN10: GPIO pin configuration register
func (o *GPIO_Type) SetPIN10_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN10_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN10.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN10_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN10_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN10_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN10_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN10_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN10_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN10_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN10_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN10_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN10_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN10_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN10_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x3e000) >> 13
}

// GPIO.PIN11: GPIO pin configuration register
func (o *GPIO_Type) SetPIN11_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN11_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN11.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN11_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN11_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN11_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN11_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN11_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN11_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN11_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN11_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN11_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN11_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN11_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN11_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x3e000) >> 13
}

// GPIO.PIN12: GPIO pin configuration register
func (o *GPIO_Type) SetPIN12_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN12_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN12.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN12_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN12_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN12_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN12_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN12_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN12_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN12_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN12_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN12_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN12_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN12_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN12_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x3e000) >> 13
}

// GPIO.PIN13: GPIO pin configuration register
func (o *GPIO_Type) SetPIN13_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN13_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN13.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN13_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN13_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN13_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN13_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN13_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN13_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN13_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN13_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN13_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN13_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN13_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN13_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x3e000) >> 13
}

// GPIO.PIN14: GPIO pin configuration register
func (o *GPIO_Type) SetPIN14_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN14_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN14.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN14_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN14_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN14_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN14_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN14_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN14_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN14_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN14_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN14_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN14_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN14_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN14_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x3e000) >> 13
}

// GPIO.PIN15: GPIO pin configuration register
func (o *GPIO_Type) SetPIN15_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN15_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN15.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN15_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN15_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN15_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN15_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN15_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN15_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN15_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN15_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN15_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN15_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN15_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN15_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x3e000) >> 13
}

// GPIO.PIN16: GPIO pin configuration register
func (o *GPIO_Type) SetPIN16_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN16_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN16.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN16_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN16_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN16_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN16_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN16_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN16_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN16_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN16_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN16_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN16_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN16_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN16_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x3e000) >> 13
}

// GPIO.PIN17: GPIO pin configuration register
func (o *GPIO_Type) SetPIN17_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN17_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN17.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN17_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN17_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN17_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN17_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN17_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN17_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN17_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN17_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN17_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN17_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN17_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN17_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x3e000) >> 13
}

// GPIO.PIN18: GPIO pin configuration register
func (o *GPIO_Type) SetPIN18_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN18_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN18.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN18_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN18_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN18_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN18_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN18_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN18_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN18_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN18_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN18_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN18_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN18_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN18_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x3e000) >> 13
}

// GPIO.PIN19: GPIO pin configuration register
func (o *GPIO_Type) SetPIN19_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN19_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN19.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN19_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN19_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN19_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN19_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN19_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN19_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN19_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN19_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN19_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN19_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN19_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN19_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x3e000) >> 13
}

// GPIO.PIN20: GPIO pin configuration register
func (o *GPIO_Type) SetPIN20_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN20_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN20.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN20_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN20_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN20_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN20_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN20_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN20_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN20_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN20_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN20_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN20_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN20_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN20_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x3e000) >> 13
}

// GPIO.PIN21: GPIO pin configuration register
func (o *GPIO_Type) SetPIN21_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN21_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN21.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN21_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN21_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN21_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN21_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN21_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN21_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN21_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN21_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN21_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN21_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN21_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN21_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x3e000) >> 13
}

// GPIO.PIN22: GPIO pin configuration register
func (o *GPIO_Type) SetPIN22_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN22_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN22.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN22_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN22_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN22_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN22_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN22_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN22_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN22_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN22_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN22_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN22_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN22_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN22_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x3e000) >> 13
}

// GPIO.PIN23: GPIO pin configuration register
func (o *GPIO_Type) SetPIN23_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN23_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN23.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN23_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN23_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN23_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN23_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN23_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN23_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN23_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN23_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN23_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN23_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN23_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN23_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x3e000) >> 13
}

// GPIO.PIN24: GPIO pin configuration register
func (o *GPIO_Type) SetPIN24_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN24_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN24.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN24_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN24_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN24_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN24_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN24_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN24_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN24_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN24_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN24_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN24_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN24_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN24_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x3e000) >> 13
}

// GPIO.STATUS_NEXT: GPIO interrupt source register
func (o *GPIO_Type) SetSTATUS_NEXT_STATUS_INTERRUPT_NEXT(value uint32) {
	volatile.StoreUint32(&o.STATUS_NEXT.Reg, volatile.LoadUint32(&o.STATUS_NEXT.Reg)&^(0x3ffffff)|value)
}
func (o *GPIO_Type) GetSTATUS_NEXT_STATUS_INTERRUPT_NEXT() uint32 {
	return volatile.LoadUint32(&o.STATUS_NEXT.Reg) & 0x3ffffff
}

// GPIO.FUNC0_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC0_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC0_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC0_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC0_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC0_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC0_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC1_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC1_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC1_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC1_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC1_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC1_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC1_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC2_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC2_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC2_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC2_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC2_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC2_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC2_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC3_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC3_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC3_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC3_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC3_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC3_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC3_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC4_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC4_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC4_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC4_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC4_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC4_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC4_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC5_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC5_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC5_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC5_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC5_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC5_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC5_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC6_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC6_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC6_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC6_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC6_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC6_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC6_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC7_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC7_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC7_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC7_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC7_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC7_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC7_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC8_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC8_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC8_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC8_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC8_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC8_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC8_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC9_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC9_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC9_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC9_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC9_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC9_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC9_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC10_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC10_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC10_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC10_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC10_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC10_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC10_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC11_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC11_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC11_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC11_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC11_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC11_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC11_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC12_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC12_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC12_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC12_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC12_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC12_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC12_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC13_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC13_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC13_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC13_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC13_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC13_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC13_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC14_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC14_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC14_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC14_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC14_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC14_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC14_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC15_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC15_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC15_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC15_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC15_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC15_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC15_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC16_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC16_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC16_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC16_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC16_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC16_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC16_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC17_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC17_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC17_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC17_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC17_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC17_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC17_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC18_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC18_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC18_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC18_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC18_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC18_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC18_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC19_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC19_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC19_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC19_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC19_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC19_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC19_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC20_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC20_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC20_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC20_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC20_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC20_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC20_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC21_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC21_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC21_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC21_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC21_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC21_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC21_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC22_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC22_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC22_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC22_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC22_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC22_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC22_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC23_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC23_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC23_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC23_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC23_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC23_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC23_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC24_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC24_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC24_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC24_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC24_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC24_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC24_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC25_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC25_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC25_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC25_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC25_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC25_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC25_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC26_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC26_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC26_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC26_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC26_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC26_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC26_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC27_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC27_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC27_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC27_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC27_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC27_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC27_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC28_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC28_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC28_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC28_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC28_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC28_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC28_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC29_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC29_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC29_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC29_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC29_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC29_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC29_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC30_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC30_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC30_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC30_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC30_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC30_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC30_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC31_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC31_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC31_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC31_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC31_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC31_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC31_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC32_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC32_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC32_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC32_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC32_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC32_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC32_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC33_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC33_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC33_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC33_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC33_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC33_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC33_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC34_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC34_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC34_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC34_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC34_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC34_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC34_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC35_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC35_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC35_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC35_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC35_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC35_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC35_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC36_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC36_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC36_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC36_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC36_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC36_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC36_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC37_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC37_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC37_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC37_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC37_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC37_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC37_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC38_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC38_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC38_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC38_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC38_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC38_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC38_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC39_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC39_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC39_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC39_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC39_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC39_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC39_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC40_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC40_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC40_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC40_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC40_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC40_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC40_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC40_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC40_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC40_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC41_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC41_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC41_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC41_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC41_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC41_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC41_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC41_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC41_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC41_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC42_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC42_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC42_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC42_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC42_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC42_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC42_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC42_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC42_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC42_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC43_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC43_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC43_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC43_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC43_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC43_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC43_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC43_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC43_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC43_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC44_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC44_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC44_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC44_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC44_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC44_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC44_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC44_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC44_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC44_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC45_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC45_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC45_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC45_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC45_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC45_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC45_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC45_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC45_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC45_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC46_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC46_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC46_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC46_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC46_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC46_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC46_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC46_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC46_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC46_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC47_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC47_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC47_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC47_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC47_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC47_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC47_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC47_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC47_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC47_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC48_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC48_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC48_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC48_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC48_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC48_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC48_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC48_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC48_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC48_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC49_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC49_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC49_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC49_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC49_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC49_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC49_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC49_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC49_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC49_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC50_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC50_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC50_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC50_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC50_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC50_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC50_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC50_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC50_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC50_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC51_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC51_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC51_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC51_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC51_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC51_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC51_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC51_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC51_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC51_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC52_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC52_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC52_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC52_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC52_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC52_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC52_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC52_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC52_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC52_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC53_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC53_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC53_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC53_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC53_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC53_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC53_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC53_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC53_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC53_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC54_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC54_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC54_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC54_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC54_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC54_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC54_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC54_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC54_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC54_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC55_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC55_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC55_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC55_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC55_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC55_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC55_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC55_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC55_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC55_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC56_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC56_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC56_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC56_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC56_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC56_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC56_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC56_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC56_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC56_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC57_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC57_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC57_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC57_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC57_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC57_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC57_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC57_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC57_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC57_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC58_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC58_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC58_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC58_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC58_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC58_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC58_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC58_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC58_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC58_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC59_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC59_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC59_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC59_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC59_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC59_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC59_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC59_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC59_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC59_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC60_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC60_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC60_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC60_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC60_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC60_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC60_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC60_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC60_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC60_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC61_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC61_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC61_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC61_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC61_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC61_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC61_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC61_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC61_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC61_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC62_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC62_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC62_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC62_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC62_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC62_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC62_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC62_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC62_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC62_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC63_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC63_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC63_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC63_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC63_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC63_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC63_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC63_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC63_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC63_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC64_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC64_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC64_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC64_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC64_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC64_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC64_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC64_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC64_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC64_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC65_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC65_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC65_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC65_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC65_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC65_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC65_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC65_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC65_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC65_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC66_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC66_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC66_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC66_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC66_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC66_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC66_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC66_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC66_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC66_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC67_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC67_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC67_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC67_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC67_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC67_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC67_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC67_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC67_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC67_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC68_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC68_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC68_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC68_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC68_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC68_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC68_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC68_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC68_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC68_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC69_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC69_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC69_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC69_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC69_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC69_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC69_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC69_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC69_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC69_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC70_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC70_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC70_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC70_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC70_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC70_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC70_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC70_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC70_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC70_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC71_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC71_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC71_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC71_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC71_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC71_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC71_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC71_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC71_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC71_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC72_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC72_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC72_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC72_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC72_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC72_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC72_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC72_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC72_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC72_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC73_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC73_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC73_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC73_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC73_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC73_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC73_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC73_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC73_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC73_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC74_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC74_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC74_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC74_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC74_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC74_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC74_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC74_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC74_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC74_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC75_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC75_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC75_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC75_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC75_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC75_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC75_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC75_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC75_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC75_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC76_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC76_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC76_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC76_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC76_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC76_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC76_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC76_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC76_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC76_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC77_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC77_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC77_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC77_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC77_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC77_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC77_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC77_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC77_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC77_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC78_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC78_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC78_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC78_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC78_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC78_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC78_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC78_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC78_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC78_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC79_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC79_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC79_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC79_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC79_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC79_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC79_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC79_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC79_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC79_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC80_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC80_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC80_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC80_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC80_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC80_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC80_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC80_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC80_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC80_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC81_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC81_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC81_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC81_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC81_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC81_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC81_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC81_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC81_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC81_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC82_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC82_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC82_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC82_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC82_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC82_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC82_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC82_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC82_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC82_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC83_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC83_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC83_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC83_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC83_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC83_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC83_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC83_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC83_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC83_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC84_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC84_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC84_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC84_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC84_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC84_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC84_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC84_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC84_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC84_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC85_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC85_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC85_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC85_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC85_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC85_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC85_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC85_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC85_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC85_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC86_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC86_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC86_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC86_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC86_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC86_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC86_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC86_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC86_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC86_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC87_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC87_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC87_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC87_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC87_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC87_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC87_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC87_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC87_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC87_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC88_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC88_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC88_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC88_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC88_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC88_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC88_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC88_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC88_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC88_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC89_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC89_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC89_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC89_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC89_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC89_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC89_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC89_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC89_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC89_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC90_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC90_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC90_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC90_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC90_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC90_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC90_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC90_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC90_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC90_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC91_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC91_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC91_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC91_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC91_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC91_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC91_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC91_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC91_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC91_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC92_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC92_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC92_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC92_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC92_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC92_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC92_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC92_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC92_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC92_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC93_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC93_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC93_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC93_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC93_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC93_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC93_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC93_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC93_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC93_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC94_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC94_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC94_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC94_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC94_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC94_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC94_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC94_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC94_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC94_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC95_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC95_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC95_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC95_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC95_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC95_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC95_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC95_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC95_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC95_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC96_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC96_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC96_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC96_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC96_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC96_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC96_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC96_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC96_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC96_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC97_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC97_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC97_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC97_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC97_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC97_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC97_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC97_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC97_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC97_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC98_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC98_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC98_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC98_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC98_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC98_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC98_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC98_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC98_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC98_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC99_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC99_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC99_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC99_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC99_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC99_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC99_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC99_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC99_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC99_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC100_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC100_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC100_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC100_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC100_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC100_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC100_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC100_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC100_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC100_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC101_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC101_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC101_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC101_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC101_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC101_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC101_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC101_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC101_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC101_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC102_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC102_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC102_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC102_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC102_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC102_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC102_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC102_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC102_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC102_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC103_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC103_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC103_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC103_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC103_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC103_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC103_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC103_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC103_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC103_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC104_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC104_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC104_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC104_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC104_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC104_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC104_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC104_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC104_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC104_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC105_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC105_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC105_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC105_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC105_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC105_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC105_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC105_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC105_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC105_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC106_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC106_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC106_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC106_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC106_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC106_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC106_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC106_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC106_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC106_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC107_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC107_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC107_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC107_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC107_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC107_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC107_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC107_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC107_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC107_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC108_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC108_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC108_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC108_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC108_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC108_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC108_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC108_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC108_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC108_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC109_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC109_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC109_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC109_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC109_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC109_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC109_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC109_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC109_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC109_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC110_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC110_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC110_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC110_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC110_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC110_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC110_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC110_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC110_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC110_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC111_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC111_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC111_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC111_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC111_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC111_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC111_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC111_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC111_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC111_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC112_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC112_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC112_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC112_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC112_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC112_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC112_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC112_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC112_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC112_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC113_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC113_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC113_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC113_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC113_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC113_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC113_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC113_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC113_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC113_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC114_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC114_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC114_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC114_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC114_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC114_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC114_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC114_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC114_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC114_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC115_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC115_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC115_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC115_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC115_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC115_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC115_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC115_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC115_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC115_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC116_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC116_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC116_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC116_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC116_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC116_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC116_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC116_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC116_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC116_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC117_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC117_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC117_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC117_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC117_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC117_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC117_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC117_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC117_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC117_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC118_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC118_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC118_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC118_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC118_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC118_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC118_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC118_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC118_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC118_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC119_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC119_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC119_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC119_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC119_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC119_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC119_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC119_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC119_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC119_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC120_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC120_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC120_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC120_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC120_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC120_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC120_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC120_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC120_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC120_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC121_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC121_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC121_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC121_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC121_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC121_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC121_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC121_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC121_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC121_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC122_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC122_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC122_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC122_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC122_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC122_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC122_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC122_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC122_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC122_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC123_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC123_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC123_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC123_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC123_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC123_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC123_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC123_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC123_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC123_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC124_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC124_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC124_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC124_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC124_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC124_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC124_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC124_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC124_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC124_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC125_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC125_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC125_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC125_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC125_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC125_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC125_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC125_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC125_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC125_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC126_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC126_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC126_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC126_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC126_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC126_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC126_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC126_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC126_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC126_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC127_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC127_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC127_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIO_Type) GetFUNC127_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg) & 0x1f
}
func (o *GPIO_Type) SetFUNC127_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC127_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFUNC127_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFUNC127_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC127_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC127_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg) & 0x40) >> 6
}

// GPIO.FUNC0_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC1_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC2_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC3_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC4_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC5_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC6_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC7_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC8_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC9_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC10_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC10_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC10_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC10_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC10_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC10_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC10_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC10_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC10_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC11_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC11_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC11_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC11_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC11_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC11_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC11_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC11_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC11_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC12_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC12_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC12_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC12_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC12_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC12_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC12_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC12_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC12_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC13_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC13_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC13_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC13_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC13_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC13_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC13_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC13_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC13_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC14_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC14_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC14_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC14_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC14_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC14_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC14_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC14_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC14_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC15_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC15_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC15_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC15_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC15_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC15_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC15_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC15_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC15_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC16_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC16_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC16_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC16_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC16_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC16_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC16_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC16_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC16_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC17_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC17_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC17_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC17_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC17_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC17_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC17_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC17_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC17_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC18_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC18_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC18_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC18_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC18_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC18_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC18_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC18_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC18_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC19_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC19_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC19_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC19_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC19_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC19_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC19_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC19_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC19_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC20_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC20_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC20_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC20_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC20_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC20_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC20_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC20_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC20_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC21_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC21_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC21_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC21_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC21_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC21_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC21_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC21_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC21_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC22_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC22_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC22_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC22_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC22_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC22_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC22_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC22_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC22_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC23_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC23_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC23_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC23_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC23_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC23_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC23_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC23_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC23_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC24_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC24_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC24_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC24_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC24_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC24_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC24_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC24_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC24_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.CLOCK_GATE: GPIO clock gate register
func (o *GPIO_Type) SetCLOCK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetCLOCK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// GPIO.REG_DATE: GPIO version register
func (o *GPIO_Type) SetREG_DATE(value uint32) {
	volatile.StoreUint32(&o.REG_DATE.Reg, volatile.LoadUint32(&o.REG_DATE.Reg)&^(0xfffffff)|value)
}
func (o *GPIO_Type) GetREG_DATE() uint32 {
	return volatile.LoadUint32(&o.REG_DATE.Reg) & 0xfffffff
}

// I2C (Inter-Integrated Circuit) Controller 0
type I2C_Type struct {
	SCL_LOW_PERIOD       volatile.Register32 // 0x0
	CTR                  volatile.Register32 // 0x4
	SR                   volatile.Register32 // 0x8
	TO                   volatile.Register32 // 0xC
	_                    [4]byte
	FIFO_ST              volatile.Register32 // 0x14
	FIFO_CONF            volatile.Register32 // 0x18
	DATA                 volatile.Register32 // 0x1C
	INT_RAW              volatile.Register32 // 0x20
	INT_CLR              volatile.Register32 // 0x24
	INT_ENA              volatile.Register32 // 0x28
	INT_STATUS           volatile.Register32 // 0x2C
	SDA_HOLD             volatile.Register32 // 0x30
	SDA_SAMPLE           volatile.Register32 // 0x34
	SCL_HIGH_PERIOD      volatile.Register32 // 0x38
	_                    [4]byte
	SCL_START_HOLD       volatile.Register32 // 0x40
	SCL_RSTART_SETUP     volatile.Register32 // 0x44
	SCL_STOP_HOLD        volatile.Register32 // 0x48
	SCL_STOP_SETUP       volatile.Register32 // 0x4C
	FILTER_CFG           volatile.Register32 // 0x50
	CLK_CONF             volatile.Register32 // 0x54
	COMD0                volatile.Register32 // 0x58
	COMD1                volatile.Register32 // 0x5C
	COMD2                volatile.Register32 // 0x60
	COMD3                volatile.Register32 // 0x64
	COMD4                volatile.Register32 // 0x68
	COMD5                volatile.Register32 // 0x6C
	COMD6                volatile.Register32 // 0x70
	COMD7                volatile.Register32 // 0x74
	SCL_ST_TIME_OUT      volatile.Register32 // 0x78
	SCL_MAIN_ST_TIME_OUT volatile.Register32 // 0x7C
	SCL_SP_CONF          volatile.Register32 // 0x80
	_                    [116]byte
	DATE                 volatile.Register32 // 0xF8
	_                    [4]byte
	TXFIFO_START_ADDR    volatile.Register32 // 0x100
	_                    [124]byte
	RXFIFO_START_ADDR    volatile.Register32 // 0x180
}

// I2C.SCL_LOW_PERIOD: Configures the low level width of the SCL Clock
func (o *I2C_Type) SetSCL_LOW_PERIOD(value uint32) {
	volatile.StoreUint32(&o.SCL_LOW_PERIOD.Reg, volatile.LoadUint32(&o.SCL_LOW_PERIOD.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSCL_LOW_PERIOD() uint32 {
	return volatile.LoadUint32(&o.SCL_LOW_PERIOD.Reg) & 0x1ff
}

// I2C.CTR: Transmission setting
func (o *I2C_Type) SetCTR_SDA_FORCE_OUT(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCTR_SDA_FORCE_OUT() uint32 {
	return volatile.LoadUint32(&o.CTR.Reg) & 0x1
}
func (o *I2C_Type) SetCTR_SCL_FORCE_OUT(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetCTR_SCL_FORCE_OUT() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetCTR_SAMPLE_SCL_LEVEL(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCTR_SAMPLE_SCL_LEVEL() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCTR_RX_FULL_ACK_LEVEL(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCTR_RX_FULL_ACK_LEVEL() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCTR_MS_MODE(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCTR_MS_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCTR_TRANS_START(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCTR_TRANS_START() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCTR_TX_LSB_FIRST(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCTR_TX_LSB_FIRST() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCTR_RX_LSB_FIRST(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCTR_RX_LSB_FIRST() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCTR_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetCTR_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetCTR_ARBITRATION_EN(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetCTR_ARBITRATION_EN() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetCTR_FSM_RST(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCTR_FSM_RST() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCTR_CONF_UPGATE(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCTR_CONF_UPGATE() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetCTR_SLV_TX_AUTO_START_EN(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCTR_SLV_TX_AUTO_START_EN() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x1000) >> 12
}

// I2C.SR: Describe I2C work status.
func (o *I2C_Type) SetSR_RESP_REC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSR_RESP_REC() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *I2C_Type) SetSR_ARB_LOST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetSR_ARB_LOST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetSR_BUS_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetSR_BUS_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetSR_RXFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1f00)|value<<8)
}
func (o *I2C_Type) GetSR_RXFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1f00) >> 8
}
func (o *I2C_Type) SetSR_TXFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x7c0000)|value<<18)
}
func (o *I2C_Type) GetSR_TXFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x7c0000) >> 18
}
func (o *I2C_Type) SetSR_SCL_MAIN_STATE_LAST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x7000000)|value<<24)
}
func (o *I2C_Type) GetSR_SCL_MAIN_STATE_LAST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x7000000) >> 24
}
func (o *I2C_Type) SetSR_SCL_STATE_LAST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x70000000)|value<<28)
}
func (o *I2C_Type) GetSR_SCL_STATE_LAST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x70000000) >> 28
}

// I2C.TO: Setting time out control for receiving data.
func (o *I2C_Type) SetTO_TIME_OUT_VALUE(value uint32) {
	volatile.StoreUint32(&o.TO.Reg, volatile.LoadUint32(&o.TO.Reg)&^(0x1f)|value)
}
func (o *I2C_Type) GetTO_TIME_OUT_VALUE() uint32 {
	return volatile.LoadUint32(&o.TO.Reg) & 0x1f
}
func (o *I2C_Type) SetTO_TIME_OUT_EN(value uint32) {
	volatile.StoreUint32(&o.TO.Reg, volatile.LoadUint32(&o.TO.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetTO_TIME_OUT_EN() uint32 {
	return (volatile.LoadUint32(&o.TO.Reg) & 0x20) >> 5
}

// I2C.FIFO_ST: FIFO status register.
func (o *I2C_Type) SetFIFO_ST_RXFIFO_RADDR(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0xf)|value)
}
func (o *I2C_Type) GetFIFO_ST_RXFIFO_RADDR() uint32 {
	return volatile.LoadUint32(&o.FIFO_ST.Reg) & 0xf
}
func (o *I2C_Type) SetFIFO_ST_RXFIFO_WADDR(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0x1e0)|value<<5)
}
func (o *I2C_Type) GetFIFO_ST_RXFIFO_WADDR() uint32 {
	return (volatile.LoadUint32(&o.FIFO_ST.Reg) & 0x1e0) >> 5
}
func (o *I2C_Type) SetFIFO_ST_TXFIFO_RADDR(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0x3c00)|value<<10)
}
func (o *I2C_Type) GetFIFO_ST_TXFIFO_RADDR() uint32 {
	return (volatile.LoadUint32(&o.FIFO_ST.Reg) & 0x3c00) >> 10
}
func (o *I2C_Type) SetFIFO_ST_TXFIFO_WADDR(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0x78000)|value<<15)
}
func (o *I2C_Type) GetFIFO_ST_TXFIFO_WADDR() uint32 {
	return (volatile.LoadUint32(&o.FIFO_ST.Reg) & 0x78000) >> 15
}

// I2C.FIFO_CONF: FIFO configuration register.
func (o *I2C_Type) SetFIFO_CONF_RXFIFO_WM_THRHD(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0xf)|value)
}
func (o *I2C_Type) GetFIFO_CONF_RXFIFO_WM_THRHD() uint32 {
	return volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0xf
}
func (o *I2C_Type) SetFIFO_CONF_TXFIFO_WM_THRHD(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x1e0)|value<<5)
}
func (o *I2C_Type) GetFIFO_CONF_TXFIFO_WM_THRHD() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x1e0) >> 5
}
func (o *I2C_Type) SetFIFO_CONF_NONFIFO_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetFIFO_CONF_NONFIFO_EN() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetFIFO_CONF_RX_FIFO_RST(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetFIFO_CONF_RX_FIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetFIFO_CONF_TX_FIFO_RST(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetFIFO_CONF_TX_FIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetFIFO_CONF_FIFO_PRT_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetFIFO_CONF_FIFO_PRT_EN() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x4000) >> 14
}

// I2C.DATA: Rx FIFO read data.
func (o *I2C_Type) SetDATA_FIFO_RDATA(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetDATA_FIFO_RDATA() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg) & 0xff
}

// I2C.INT_RAW: Raw interrupt status
func (o *I2C_Type) SetINT_RAW_RXFIFO_WM_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINT_RAW_RXFIFO_WM_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *I2C_Type) SetINT_RAW_TXFIFO_WM_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetINT_RAW_TXFIFO_WM_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetINT_RAW_RXFIFO_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetINT_RAW_RXFIFO_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetINT_RAW_END_DETECT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetINT_RAW_END_DETECT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetINT_RAW_BYTE_TRANS_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINT_RAW_BYTE_TRANS_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINT_RAW_ARBITRATION_LOST_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINT_RAW_ARBITRATION_LOST_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINT_RAW_MST_TXFIFO_UDF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINT_RAW_MST_TXFIFO_UDF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINT_RAW_TRANS_COMPLETE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINT_RAW_TRANS_COMPLETE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINT_RAW_TIME_OUT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINT_RAW_TIME_OUT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINT_RAW_TRANS_START_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetINT_RAW_TRANS_START_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetINT_RAW_NACK_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetINT_RAW_NACK_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetINT_RAW_TXFIFO_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINT_RAW_TXFIFO_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINT_RAW_RXFIFO_UDF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetINT_RAW_RXFIFO_UDF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetINT_RAW_SCL_ST_TO_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetINT_RAW_SCL_ST_TO_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetINT_RAW_SCL_MAIN_ST_TO_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetINT_RAW_SCL_MAIN_ST_TO_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetINT_RAW_DET_START_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetINT_RAW_DET_START_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8000) >> 15
}

// I2C.INT_CLR: Interrupt clear bits
func (o *I2C_Type) SetINT_CLR_RXFIFO_WM_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINT_CLR_RXFIFO_WM_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *I2C_Type) SetINT_CLR_TXFIFO_WM_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetINT_CLR_TXFIFO_WM_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetINT_CLR_RXFIFO_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetINT_CLR_RXFIFO_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetINT_CLR_END_DETECT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetINT_CLR_END_DETECT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetINT_CLR_BYTE_TRANS_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINT_CLR_BYTE_TRANS_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINT_CLR_ARBITRATION_LOST_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINT_CLR_ARBITRATION_LOST_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINT_CLR_MST_TXFIFO_UDF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINT_CLR_MST_TXFIFO_UDF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINT_CLR_TRANS_COMPLETE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINT_CLR_TRANS_COMPLETE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINT_CLR_TIME_OUT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINT_CLR_TIME_OUT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINT_CLR_TRANS_START_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetINT_CLR_TRANS_START_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetINT_CLR_NACK_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetINT_CLR_NACK_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetINT_CLR_TXFIFO_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINT_CLR_TXFIFO_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINT_CLR_RXFIFO_UDF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetINT_CLR_RXFIFO_UDF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetINT_CLR_SCL_ST_TO_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetINT_CLR_SCL_ST_TO_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetINT_CLR_SCL_MAIN_ST_TO_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetINT_CLR_SCL_MAIN_ST_TO_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetINT_CLR_DET_START_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetINT_CLR_DET_START_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8000) >> 15
}

// I2C.INT_ENA: Interrupt enable bits
func (o *I2C_Type) SetINT_ENA_RXFIFO_WM_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINT_ENA_RXFIFO_WM_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *I2C_Type) SetINT_ENA_TXFIFO_WM_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetINT_ENA_TXFIFO_WM_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetINT_ENA_RXFIFO_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetINT_ENA_RXFIFO_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetINT_ENA_END_DETECT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetINT_ENA_END_DETECT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetINT_ENA_BYTE_TRANS_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINT_ENA_BYTE_TRANS_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINT_ENA_ARBITRATION_LOST_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINT_ENA_ARBITRATION_LOST_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINT_ENA_MST_TXFIFO_UDF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINT_ENA_MST_TXFIFO_UDF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINT_ENA_TRANS_COMPLETE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINT_ENA_TRANS_COMPLETE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINT_ENA_TIME_OUT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINT_ENA_TIME_OUT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINT_ENA_TRANS_START_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetINT_ENA_TRANS_START_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetINT_ENA_NACK_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetINT_ENA_NACK_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetINT_ENA_TXFIFO_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINT_ENA_TXFIFO_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINT_ENA_RXFIFO_UDF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetINT_ENA_RXFIFO_UDF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetINT_ENA_SCL_ST_TO_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetINT_ENA_SCL_ST_TO_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetINT_ENA_SCL_MAIN_ST_TO_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetINT_ENA_SCL_MAIN_ST_TO_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetINT_ENA_DET_START_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetINT_ENA_DET_START_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8000) >> 15
}

// I2C.INT_STATUS: Status of captured I2C communication events
func (o *I2C_Type) SetINT_STATUS_RXFIFO_WM_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINT_STATUS_RXFIFO_WM_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x1
}
func (o *I2C_Type) SetINT_STATUS_TXFIFO_WM_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetINT_STATUS_TXFIFO_WM_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetINT_STATUS_RXFIFO_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetINT_STATUS_RXFIFO_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetINT_STATUS_END_DETECT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetINT_STATUS_END_DETECT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetINT_STATUS_BYTE_TRANS_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINT_STATUS_BYTE_TRANS_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINT_STATUS_ARBITRATION_LOST_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINT_STATUS_ARBITRATION_LOST_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINT_STATUS_MST_TXFIFO_UDF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINT_STATUS_MST_TXFIFO_UDF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINT_STATUS_TRANS_COMPLETE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINT_STATUS_TRANS_COMPLETE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINT_STATUS_TIME_OUT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINT_STATUS_TIME_OUT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINT_STATUS_TRANS_START_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetINT_STATUS_TRANS_START_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetINT_STATUS_NACK_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetINT_STATUS_NACK_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetINT_STATUS_TXFIFO_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINT_STATUS_TXFIFO_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINT_STATUS_RXFIFO_UDF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetINT_STATUS_RXFIFO_UDF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetINT_STATUS_SCL_ST_TO_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetINT_STATUS_SCL_ST_TO_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetINT_STATUS_SCL_MAIN_ST_TO_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetINT_STATUS_SCL_MAIN_ST_TO_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetINT_STATUS_DET_START_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetINT_STATUS_DET_START_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x8000) >> 15
}

// I2C.SDA_HOLD: Configures the hold time after a negative SCL edge.
func (o *I2C_Type) SetSDA_HOLD_TIME(value uint32) {
	volatile.StoreUint32(&o.SDA_HOLD.Reg, volatile.LoadUint32(&o.SDA_HOLD.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSDA_HOLD_TIME() uint32 {
	return volatile.LoadUint32(&o.SDA_HOLD.Reg) & 0x1ff
}

// I2C.SDA_SAMPLE: Configures the sample time after a positive SCL edge.
func (o *I2C_Type) SetSDA_SAMPLE_TIME(value uint32) {
	volatile.StoreUint32(&o.SDA_SAMPLE.Reg, volatile.LoadUint32(&o.SDA_SAMPLE.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSDA_SAMPLE_TIME() uint32 {
	return volatile.LoadUint32(&o.SDA_SAMPLE.Reg) & 0x1ff
}

// I2C.SCL_HIGH_PERIOD: Configures the high level width of SCL
func (o *I2C_Type) SetSCL_HIGH_PERIOD(value uint32) {
	volatile.StoreUint32(&o.SCL_HIGH_PERIOD.Reg, volatile.LoadUint32(&o.SCL_HIGH_PERIOD.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSCL_HIGH_PERIOD() uint32 {
	return volatile.LoadUint32(&o.SCL_HIGH_PERIOD.Reg) & 0x1ff
}
func (o *I2C_Type) SetSCL_HIGH_PERIOD_SCL_WAIT_HIGH_PERIOD(value uint32) {
	volatile.StoreUint32(&o.SCL_HIGH_PERIOD.Reg, volatile.LoadUint32(&o.SCL_HIGH_PERIOD.Reg)&^(0xfe00)|value<<9)
}
func (o *I2C_Type) GetSCL_HIGH_PERIOD_SCL_WAIT_HIGH_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.SCL_HIGH_PERIOD.Reg) & 0xfe00) >> 9
}

// I2C.SCL_START_HOLD: Configures the delay between the SDA and SCL negative edge for a start condition
func (o *I2C_Type) SetSCL_START_HOLD_TIME(value uint32) {
	volatile.StoreUint32(&o.SCL_START_HOLD.Reg, volatile.LoadUint32(&o.SCL_START_HOLD.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSCL_START_HOLD_TIME() uint32 {
	return volatile.LoadUint32(&o.SCL_START_HOLD.Reg) & 0x1ff
}

// I2C.SCL_RSTART_SETUP: Configures the delay between the positive edge of SCL and the negative edge of SDA
func (o *I2C_Type) SetSCL_RSTART_SETUP_TIME(value uint32) {
	volatile.StoreUint32(&o.SCL_RSTART_SETUP.Reg, volatile.LoadUint32(&o.SCL_RSTART_SETUP.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSCL_RSTART_SETUP_TIME() uint32 {
	return volatile.LoadUint32(&o.SCL_RSTART_SETUP.Reg) & 0x1ff
}

// I2C.SCL_STOP_HOLD: Configures the delay after the SCL clock edge for a stop condition
func (o *I2C_Type) SetSCL_STOP_HOLD_TIME(value uint32) {
	volatile.StoreUint32(&o.SCL_STOP_HOLD.Reg, volatile.LoadUint32(&o.SCL_STOP_HOLD.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSCL_STOP_HOLD_TIME() uint32 {
	return volatile.LoadUint32(&o.SCL_STOP_HOLD.Reg) & 0x1ff
}

// I2C.SCL_STOP_SETUP: Configures the delay between the SDA and SCL positive edge for a stop condition
func (o *I2C_Type) SetSCL_STOP_SETUP_TIME(value uint32) {
	volatile.StoreUint32(&o.SCL_STOP_SETUP.Reg, volatile.LoadUint32(&o.SCL_STOP_SETUP.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSCL_STOP_SETUP_TIME() uint32 {
	return volatile.LoadUint32(&o.SCL_STOP_SETUP.Reg) & 0x1ff
}

// I2C.FILTER_CFG: SCL and SDA filter configuration register
func (o *I2C_Type) SetFILTER_CFG_SCL_FILTER_THRES(value uint32) {
	volatile.StoreUint32(&o.FILTER_CFG.Reg, volatile.LoadUint32(&o.FILTER_CFG.Reg)&^(0xf)|value)
}
func (o *I2C_Type) GetFILTER_CFG_SCL_FILTER_THRES() uint32 {
	return volatile.LoadUint32(&o.FILTER_CFG.Reg) & 0xf
}
func (o *I2C_Type) SetFILTER_CFG_SDA_FILTER_THRES(value uint32) {
	volatile.StoreUint32(&o.FILTER_CFG.Reg, volatile.LoadUint32(&o.FILTER_CFG.Reg)&^(0xf0)|value<<4)
}
func (o *I2C_Type) GetFILTER_CFG_SDA_FILTER_THRES() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CFG.Reg) & 0xf0) >> 4
}
func (o *I2C_Type) SetFILTER_CFG_SCL_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.FILTER_CFG.Reg, volatile.LoadUint32(&o.FILTER_CFG.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetFILTER_CFG_SCL_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CFG.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetFILTER_CFG_SDA_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.FILTER_CFG.Reg, volatile.LoadUint32(&o.FILTER_CFG.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetFILTER_CFG_SDA_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CFG.Reg) & 0x200) >> 9
}

// I2C.CLK_CONF: I2C CLK configuration register
func (o *I2C_Type) SetCLK_CONF_SCLK_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetCLK_CONF_SCLK_DIV_NUM() uint32 {
	return volatile.LoadUint32(&o.CLK_CONF.Reg) & 0xff
}
func (o *I2C_Type) SetCLK_CONF_SCLK_DIV_A(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x3f00)|value<<8)
}
func (o *I2C_Type) GetCLK_CONF_SCLK_DIV_A() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x3f00) >> 8
}
func (o *I2C_Type) SetCLK_CONF_SCLK_DIV_B(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0xfc000)|value<<14)
}
func (o *I2C_Type) GetCLK_CONF_SCLK_DIV_B() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0xfc000) >> 14
}
func (o *I2C_Type) SetCLK_CONF_SCLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x100000)|value<<20)
}
func (o *I2C_Type) GetCLK_CONF_SCLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x100000) >> 20
}
func (o *I2C_Type) SetCLK_CONF_SCLK_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x200000)|value<<21)
}
func (o *I2C_Type) GetCLK_CONF_SCLK_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x200000) >> 21
}

// I2C.COMD0: I2C command register %s
func (o *I2C_Type) SetCOMD0_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD0.Reg, volatile.LoadUint32(&o.COMD0.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD0_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD0.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD0_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD0.Reg, volatile.LoadUint32(&o.COMD0.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD0_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD0.Reg) & 0x80000000) >> 31
}

// I2C.COMD1: I2C command register %s
func (o *I2C_Type) SetCOMD1_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD1.Reg, volatile.LoadUint32(&o.COMD1.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD1_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD1.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD1_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD1.Reg, volatile.LoadUint32(&o.COMD1.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD1_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD1.Reg) & 0x80000000) >> 31
}

// I2C.COMD2: I2C command register %s
func (o *I2C_Type) SetCOMD2_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD2.Reg, volatile.LoadUint32(&o.COMD2.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD2_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD2.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD2_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD2.Reg, volatile.LoadUint32(&o.COMD2.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD2_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD2.Reg) & 0x80000000) >> 31
}

// I2C.COMD3: I2C command register %s
func (o *I2C_Type) SetCOMD3_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD3.Reg, volatile.LoadUint32(&o.COMD3.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD3_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD3.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD3_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD3.Reg, volatile.LoadUint32(&o.COMD3.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD3_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD3.Reg) & 0x80000000) >> 31
}

// I2C.COMD4: I2C command register %s
func (o *I2C_Type) SetCOMD4_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD4.Reg, volatile.LoadUint32(&o.COMD4.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD4_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD4.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD4_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD4.Reg, volatile.LoadUint32(&o.COMD4.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD4_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD4.Reg) & 0x80000000) >> 31
}

// I2C.COMD5: I2C command register %s
func (o *I2C_Type) SetCOMD5_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD5.Reg, volatile.LoadUint32(&o.COMD5.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD5_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD5.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD5_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD5.Reg, volatile.LoadUint32(&o.COMD5.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD5_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD5.Reg) & 0x80000000) >> 31
}

// I2C.COMD6: I2C command register %s
func (o *I2C_Type) SetCOMD6_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD6.Reg, volatile.LoadUint32(&o.COMD6.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD6_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD6.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD6_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD6.Reg, volatile.LoadUint32(&o.COMD6.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD6_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD6.Reg) & 0x80000000) >> 31
}

// I2C.COMD7: I2C command register %s
func (o *I2C_Type) SetCOMD7_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD7.Reg, volatile.LoadUint32(&o.COMD7.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD7_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD7.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD7_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD7.Reg, volatile.LoadUint32(&o.COMD7.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD7_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD7.Reg) & 0x80000000) >> 31
}

// I2C.SCL_ST_TIME_OUT: SCL status time out register
func (o *I2C_Type) SetSCL_ST_TIME_OUT_SCL_ST_TO_I2C(value uint32) {
	volatile.StoreUint32(&o.SCL_ST_TIME_OUT.Reg, volatile.LoadUint32(&o.SCL_ST_TIME_OUT.Reg)&^(0x1f)|value)
}
func (o *I2C_Type) GetSCL_ST_TIME_OUT_SCL_ST_TO_I2C() uint32 {
	return volatile.LoadUint32(&o.SCL_ST_TIME_OUT.Reg) & 0x1f
}

// I2C.SCL_MAIN_ST_TIME_OUT: SCL main status time out register
func (o *I2C_Type) SetSCL_MAIN_ST_TIME_OUT_SCL_MAIN_ST_TO_I2C(value uint32) {
	volatile.StoreUint32(&o.SCL_MAIN_ST_TIME_OUT.Reg, volatile.LoadUint32(&o.SCL_MAIN_ST_TIME_OUT.Reg)&^(0x1f)|value)
}
func (o *I2C_Type) GetSCL_MAIN_ST_TIME_OUT_SCL_MAIN_ST_TO_I2C() uint32 {
	return volatile.LoadUint32(&o.SCL_MAIN_ST_TIME_OUT.Reg) & 0x1f
}

// I2C.SCL_SP_CONF: Power configuration register
func (o *I2C_Type) SetSCL_SP_CONF_SCL_RST_SLV_EN(value uint32) {
	volatile.StoreUint32(&o.SCL_SP_CONF.Reg, volatile.LoadUint32(&o.SCL_SP_CONF.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSCL_SP_CONF_SCL_RST_SLV_EN() uint32 {
	return volatile.LoadUint32(&o.SCL_SP_CONF.Reg) & 0x1
}
func (o *I2C_Type) SetSCL_SP_CONF_SCL_RST_SLV_NUM(value uint32) {
	volatile.StoreUint32(&o.SCL_SP_CONF.Reg, volatile.LoadUint32(&o.SCL_SP_CONF.Reg)&^(0x3e)|value<<1)
}
func (o *I2C_Type) GetSCL_SP_CONF_SCL_RST_SLV_NUM() uint32 {
	return (volatile.LoadUint32(&o.SCL_SP_CONF.Reg) & 0x3e) >> 1
}
func (o *I2C_Type) SetSCL_SP_CONF_SCL_PD_EN(value uint32) {
	volatile.StoreUint32(&o.SCL_SP_CONF.Reg, volatile.LoadUint32(&o.SCL_SP_CONF.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetSCL_SP_CONF_SCL_PD_EN() uint32 {
	return (volatile.LoadUint32(&o.SCL_SP_CONF.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetSCL_SP_CONF_SDA_PD_EN(value uint32) {
	volatile.StoreUint32(&o.SCL_SP_CONF.Reg, volatile.LoadUint32(&o.SCL_SP_CONF.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetSCL_SP_CONF_SDA_PD_EN() uint32 {
	return (volatile.LoadUint32(&o.SCL_SP_CONF.Reg) & 0x80) >> 7
}

// I2C.DATE: Version register
func (o *I2C_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *I2C_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// I2C.TXFIFO_START_ADDR: I2C TXFIFO base address register
func (o *I2C_Type) SetTXFIFO_START_ADDR(value uint32) {
	volatile.StoreUint32(&o.TXFIFO_START_ADDR.Reg, value)
}
func (o *I2C_Type) GetTXFIFO_START_ADDR() uint32 {
	return volatile.LoadUint32(&o.TXFIFO_START_ADDR.Reg)
}

// I2C.RXFIFO_START_ADDR: I2C RXFIFO base address register
func (o *I2C_Type) SetRXFIFO_START_ADDR(value uint32) {
	volatile.StoreUint32(&o.RXFIFO_START_ADDR.Reg, value)
}
func (o *I2C_Type) GetRXFIFO_START_ADDR() uint32 {
	return volatile.LoadUint32(&o.RXFIFO_START_ADDR.Reg)
}

// Interrupt Controller (Core 0)
type INTERRUPT_CORE0_Type struct {
	MAC_INTR_MAP                                 volatile.Register32 // 0x0
	WIFI_MAC_NMI_MAP                             volatile.Register32 // 0x4
	WIFI_PWR_INT_MAP                             volatile.Register32 // 0x8
	WIFI_BB_INT_MAP                              volatile.Register32 // 0xC
	BT_MAC_INT_MAP                               volatile.Register32 // 0x10
	BT_BB_INT_MAP                                volatile.Register32 // 0x14
	BT_BB_NMI_MAP                                volatile.Register32 // 0x18
	LP_TIMER_INT_MAP                             volatile.Register32 // 0x1C
	COEX_INT_MAP                                 volatile.Register32 // 0x20
	BLE_TIMER_INT_MAP                            volatile.Register32 // 0x24
	BLE_SEC_INT_MAP                              volatile.Register32 // 0x28
	I2C_MST_INT_MAP                              volatile.Register32 // 0x2C
	APB_CTRL_INTR_MAP                            volatile.Register32 // 0x30
	GPIO_INTERRUPT_PRO_MAP                       volatile.Register32 // 0x34
	GPIO_INTERRUPT_PRO_NMI_MAP                   volatile.Register32 // 0x38
	SPI_INTR_1_MAP                               volatile.Register32 // 0x3C
	SPI_INTR_2_MAP                               volatile.Register32 // 0x40
	UART_INTR_MAP                                volatile.Register32 // 0x44
	UART1_INTR_MAP                               volatile.Register32 // 0x48
	LEDC_INT_MAP                                 volatile.Register32 // 0x4C
	EFUSE_INT_MAP                                volatile.Register32 // 0x50
	RTC_CORE_INTR_MAP                            volatile.Register32 // 0x54
	I2C_EXT0_INTR_MAP                            volatile.Register32 // 0x58
	TG_T0_INT_MAP                                volatile.Register32 // 0x5C
	TG_WDT_INT_MAP                               volatile.Register32 // 0x60
	CACHE_IA_INT_MAP                             volatile.Register32 // 0x64
	SYSTIMER_TARGET0_INT_MAP                     volatile.Register32 // 0x68
	SYSTIMER_TARGET1_INT_MAP                     volatile.Register32 // 0x6C
	SYSTIMER_TARGET2_INT_MAP                     volatile.Register32 // 0x70
	SPI_MEM_REJECT_INTR_MAP                      volatile.Register32 // 0x74
	ICACHE_PRELOAD_INT_MAP                       volatile.Register32 // 0x78
	ICACHE_SYNC_INT_MAP                          volatile.Register32 // 0x7C
	APB_ADC_INT_MAP                              volatile.Register32 // 0x80
	DMA_CH0_INT_MAP                              volatile.Register32 // 0x84
	SHA_INT_MAP                                  volatile.Register32 // 0x88
	ECC_INT_MAP                                  volatile.Register32 // 0x8C
	CPU_INTR_FROM_CPU_0_MAP                      volatile.Register32 // 0x90
	CPU_INTR_FROM_CPU_1_MAP                      volatile.Register32 // 0x94
	CPU_INTR_FROM_CPU_2_MAP                      volatile.Register32 // 0x98
	CPU_INTR_FROM_CPU_3_MAP                      volatile.Register32 // 0x9C
	ASSIST_DEBUG_INTR_MAP                        volatile.Register32 // 0xA0
	CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP volatile.Register32 // 0xA4
	CACHE_CORE0_ACS_INT_MAP                      volatile.Register32 // 0xA8
	INTR_STATUS_REG_0                            volatile.Register32 // 0xAC
	INTR_STATUS_REG_1                            volatile.Register32 // 0xB0
	CLOCK_GATE                                   volatile.Register32 // 0xB4
	CPU_INT_ENABLE                               volatile.Register32 // 0xB8
	CPU_INT_TYPE                                 volatile.Register32 // 0xBC
	CPU_INT_CLEAR                                volatile.Register32 // 0xC0
	CPU_INT_EIP_STATUS                           volatile.Register32 // 0xC4
	CPU_INT_PRI_0                                volatile.Register32 // 0xC8
	CPU_INT_PRI_1                                volatile.Register32 // 0xCC
	CPU_INT_PRI_2                                volatile.Register32 // 0xD0
	CPU_INT_PRI_3                                volatile.Register32 // 0xD4
	CPU_INT_PRI_4                                volatile.Register32 // 0xD8
	CPU_INT_PRI_5                                volatile.Register32 // 0xDC
	CPU_INT_PRI_6                                volatile.Register32 // 0xE0
	CPU_INT_PRI_7                                volatile.Register32 // 0xE4
	CPU_INT_PRI_8                                volatile.Register32 // 0xE8
	CPU_INT_PRI_9                                volatile.Register32 // 0xEC
	CPU_INT_PRI_10                               volatile.Register32 // 0xF0
	CPU_INT_PRI_11                               volatile.Register32 // 0xF4
	CPU_INT_PRI_12                               volatile.Register32 // 0xF8
	CPU_INT_PRI_13                               volatile.Register32 // 0xFC
	CPU_INT_PRI_14                               volatile.Register32 // 0x100
	CPU_INT_PRI_15                               volatile.Register32 // 0x104
	CPU_INT_PRI_16                               volatile.Register32 // 0x108
	CPU_INT_PRI_17                               volatile.Register32 // 0x10C
	CPU_INT_PRI_18                               volatile.Register32 // 0x110
	CPU_INT_PRI_19                               volatile.Register32 // 0x114
	CPU_INT_PRI_20                               volatile.Register32 // 0x118
	CPU_INT_PRI_21                               volatile.Register32 // 0x11C
	CPU_INT_PRI_22                               volatile.Register32 // 0x120
	CPU_INT_PRI_23                               volatile.Register32 // 0x124
	CPU_INT_PRI_24                               volatile.Register32 // 0x128
	CPU_INT_PRI_25                               volatile.Register32 // 0x12C
	CPU_INT_PRI_26                               volatile.Register32 // 0x130
	CPU_INT_PRI_27                               volatile.Register32 // 0x134
	CPU_INT_PRI_28                               volatile.Register32 // 0x138
	CPU_INT_PRI_29                               volatile.Register32 // 0x13C
	CPU_INT_PRI_30                               volatile.Register32 // 0x140
	CPU_INT_PRI_31                               volatile.Register32 // 0x144
	CPU_INT_THRESH                               volatile.Register32 // 0x148
	_                                            [1712]byte
	INTERRUPT_REG_DATE                           volatile.Register32 // 0x7FC
}

// INTERRUPT_CORE0.MAC_INTR_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetMAC_INTR_MAP_WIFI_MAC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.MAC_INTR_MAP.Reg, volatile.LoadUint32(&o.MAC_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetMAC_INTR_MAP_WIFI_MAC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.MAC_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.WIFI_MAC_NMI_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetWIFI_MAC_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.WIFI_MAC_NMI_MAP.Reg, volatile.LoadUint32(&o.WIFI_MAC_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetWIFI_MAC_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.WIFI_MAC_NMI_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.WIFI_PWR_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetWIFI_PWR_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.WIFI_PWR_INT_MAP.Reg, volatile.LoadUint32(&o.WIFI_PWR_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetWIFI_PWR_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.WIFI_PWR_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.WIFI_BB_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetWIFI_BB_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.WIFI_BB_INT_MAP.Reg, volatile.LoadUint32(&o.WIFI_BB_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetWIFI_BB_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.WIFI_BB_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.BT_MAC_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetBT_MAC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.BT_MAC_INT_MAP.Reg, volatile.LoadUint32(&o.BT_MAC_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetBT_MAC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.BT_MAC_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.BT_BB_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetBT_BB_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.BT_BB_INT_MAP.Reg, volatile.LoadUint32(&o.BT_BB_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetBT_BB_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.BT_BB_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.BT_BB_NMI_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetBT_BB_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.BT_BB_NMI_MAP.Reg, volatile.LoadUint32(&o.BT_BB_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetBT_BB_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.BT_BB_NMI_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.LP_TIMER_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetLP_TIMER_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_TIMER_INT_MAP.Reg, volatile.LoadUint32(&o.LP_TIMER_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetLP_TIMER_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_TIMER_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.COEX_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetCOEX_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.COEX_INT_MAP.Reg, volatile.LoadUint32(&o.COEX_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCOEX_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.COEX_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.BLE_TIMER_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetBLE_TIMER_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.BLE_TIMER_INT_MAP.Reg, volatile.LoadUint32(&o.BLE_TIMER_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetBLE_TIMER_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.BLE_TIMER_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.BLE_SEC_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetBLE_SEC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.BLE_SEC_INT_MAP.Reg, volatile.LoadUint32(&o.BLE_SEC_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetBLE_SEC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.BLE_SEC_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.I2C_MST_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetI2C_MST_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.I2C_MST_INT_MAP.Reg, volatile.LoadUint32(&o.I2C_MST_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetI2C_MST_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.I2C_MST_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.APB_CTRL_INTR_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetAPB_CTRL_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.APB_CTRL_INTR_MAP.Reg, volatile.LoadUint32(&o.APB_CTRL_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetAPB_CTRL_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.APB_CTRL_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.GPIO_INTERRUPT_PRO_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetGPIO_INTERRUPT_PRO_MAP(value uint32) {
	volatile.StoreUint32(&o.GPIO_INTERRUPT_PRO_MAP.Reg, volatile.LoadUint32(&o.GPIO_INTERRUPT_PRO_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetGPIO_INTERRUPT_PRO_MAP() uint32 {
	return volatile.LoadUint32(&o.GPIO_INTERRUPT_PRO_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.GPIO_INTERRUPT_PRO_NMI_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetGPIO_INTERRUPT_PRO_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.GPIO_INTERRUPT_PRO_NMI_MAP.Reg, volatile.LoadUint32(&o.GPIO_INTERRUPT_PRO_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetGPIO_INTERRUPT_PRO_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.GPIO_INTERRUPT_PRO_NMI_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.SPI_INTR_1_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetSPI_INTR_1_MAP(value uint32) {
	volatile.StoreUint32(&o.SPI_INTR_1_MAP.Reg, volatile.LoadUint32(&o.SPI_INTR_1_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetSPI_INTR_1_MAP() uint32 {
	return volatile.LoadUint32(&o.SPI_INTR_1_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.SPI_INTR_2_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetSPI_INTR_2_MAP(value uint32) {
	volatile.StoreUint32(&o.SPI_INTR_2_MAP.Reg, volatile.LoadUint32(&o.SPI_INTR_2_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetSPI_INTR_2_MAP() uint32 {
	return volatile.LoadUint32(&o.SPI_INTR_2_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.UART_INTR_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetUART_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.UART_INTR_MAP.Reg, volatile.LoadUint32(&o.UART_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetUART_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.UART_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.UART1_INTR_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetUART1_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.UART1_INTR_MAP.Reg, volatile.LoadUint32(&o.UART1_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetUART1_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.UART1_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.LEDC_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetLEDC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LEDC_INT_MAP.Reg, volatile.LoadUint32(&o.LEDC_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetLEDC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LEDC_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.EFUSE_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetEFUSE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.EFUSE_INT_MAP.Reg, volatile.LoadUint32(&o.EFUSE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetEFUSE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.EFUSE_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.RTC_CORE_INTR_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetRTC_CORE_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.RTC_CORE_INTR_MAP.Reg, volatile.LoadUint32(&o.RTC_CORE_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetRTC_CORE_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.RTC_CORE_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.I2C_EXT0_INTR_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetI2C_EXT0_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.I2C_EXT0_INTR_MAP.Reg, volatile.LoadUint32(&o.I2C_EXT0_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetI2C_EXT0_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.I2C_EXT0_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.TG_T0_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetTG_T0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.TG_T0_INT_MAP.Reg, volatile.LoadUint32(&o.TG_T0_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetTG_T0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.TG_T0_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.TG_WDT_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetTG_WDT_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.TG_WDT_INT_MAP.Reg, volatile.LoadUint32(&o.TG_WDT_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetTG_WDT_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.TG_WDT_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.CACHE_IA_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetCACHE_IA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.CACHE_IA_INT_MAP.Reg, volatile.LoadUint32(&o.CACHE_IA_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCACHE_IA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.CACHE_IA_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.SYSTIMER_TARGET0_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetSYSTIMER_TARGET0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SYSTIMER_TARGET0_INT_MAP.Reg, volatile.LoadUint32(&o.SYSTIMER_TARGET0_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetSYSTIMER_TARGET0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SYSTIMER_TARGET0_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.SYSTIMER_TARGET1_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetSYSTIMER_TARGET1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SYSTIMER_TARGET1_INT_MAP.Reg, volatile.LoadUint32(&o.SYSTIMER_TARGET1_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetSYSTIMER_TARGET1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SYSTIMER_TARGET1_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.SYSTIMER_TARGET2_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetSYSTIMER_TARGET2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SYSTIMER_TARGET2_INT_MAP.Reg, volatile.LoadUint32(&o.SYSTIMER_TARGET2_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetSYSTIMER_TARGET2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SYSTIMER_TARGET2_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.SPI_MEM_REJECT_INTR_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetSPI_MEM_REJECT_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.SPI_MEM_REJECT_INTR_MAP.Reg, volatile.LoadUint32(&o.SPI_MEM_REJECT_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetSPI_MEM_REJECT_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.SPI_MEM_REJECT_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.ICACHE_PRELOAD_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetICACHE_PRELOAD_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.ICACHE_PRELOAD_INT_MAP.Reg, volatile.LoadUint32(&o.ICACHE_PRELOAD_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetICACHE_PRELOAD_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.ICACHE_PRELOAD_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.ICACHE_SYNC_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetICACHE_SYNC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.ICACHE_SYNC_INT_MAP.Reg, volatile.LoadUint32(&o.ICACHE_SYNC_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetICACHE_SYNC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.ICACHE_SYNC_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.APB_ADC_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetAPB_ADC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.APB_ADC_INT_MAP.Reg, volatile.LoadUint32(&o.APB_ADC_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetAPB_ADC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.APB_ADC_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.DMA_CH0_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetDMA_CH0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.DMA_CH0_INT_MAP.Reg, volatile.LoadUint32(&o.DMA_CH0_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetDMA_CH0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.DMA_CH0_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.SHA_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetSHA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SHA_INT_MAP.Reg, volatile.LoadUint32(&o.SHA_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetSHA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SHA_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.ECC_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetECC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.ECC_INT_MAP.Reg, volatile.LoadUint32(&o.ECC_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetECC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.ECC_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.CPU_INTR_FROM_CPU_0_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INTR_FROM_CPU_0_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INTR_FROM_CPU_0_MAP.Reg, volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_0_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INTR_FROM_CPU_0_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_0_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.CPU_INTR_FROM_CPU_1_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INTR_FROM_CPU_1_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INTR_FROM_CPU_1_MAP.Reg, volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_1_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INTR_FROM_CPU_1_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_1_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.CPU_INTR_FROM_CPU_2_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INTR_FROM_CPU_2_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INTR_FROM_CPU_2_MAP.Reg, volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_2_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INTR_FROM_CPU_2_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_2_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.CPU_INTR_FROM_CPU_3_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INTR_FROM_CPU_3_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INTR_FROM_CPU_3_MAP.Reg, volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_3_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INTR_FROM_CPU_3_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_3_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.ASSIST_DEBUG_INTR_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetASSIST_DEBUG_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.ASSIST_DEBUG_INTR_MAP.Reg, volatile.LoadUint32(&o.ASSIST_DEBUG_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetASSIST_DEBUG_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.ASSIST_DEBUG_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetCORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP.Reg, volatile.LoadUint32(&o.CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.CACHE_CORE0_ACS_INT_MAP: register description
func (o *INTERRUPT_CORE0_Type) SetCACHE_CORE0_ACS_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.CACHE_CORE0_ACS_INT_MAP.Reg, volatile.LoadUint32(&o.CACHE_CORE0_ACS_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCACHE_CORE0_ACS_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.CACHE_CORE0_ACS_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.INTR_STATUS_REG_0: register description
func (o *INTERRUPT_CORE0_Type) SetINTR_STATUS_REG_0(value uint32) {
	volatile.StoreUint32(&o.INTR_STATUS_REG_0.Reg, value)
}
func (o *INTERRUPT_CORE0_Type) GetINTR_STATUS_REG_0() uint32 {
	return volatile.LoadUint32(&o.INTR_STATUS_REG_0.Reg)
}

// INTERRUPT_CORE0.INTR_STATUS_REG_1: register description
func (o *INTERRUPT_CORE0_Type) SetINTR_STATUS_REG_1(value uint32) {
	volatile.StoreUint32(&o.INTR_STATUS_REG_1.Reg, value)
}
func (o *INTERRUPT_CORE0_Type) GetINTR_STATUS_REG_1() uint32 {
	return volatile.LoadUint32(&o.INTR_STATUS_REG_1.Reg)
}

// INTERRUPT_CORE0.CLOCK_GATE: register description
func (o *INTERRUPT_CORE0_Type) SetCLOCK_GATE_REG_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCLOCK_GATE_REG_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// INTERRUPT_CORE0.CPU_INT_ENABLE: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_ENABLE.Reg, value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_ENABLE.Reg)
}

// INTERRUPT_CORE0.CPU_INT_TYPE: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_TYPE.Reg, value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_TYPE() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_TYPE.Reg)
}

// INTERRUPT_CORE0.CPU_INT_CLEAR: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_CLEAR(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_CLEAR.Reg, value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_CLEAR() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_CLEAR.Reg)
}

// INTERRUPT_CORE0.CPU_INT_EIP_STATUS: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_EIP_STATUS(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_EIP_STATUS.Reg, value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_EIP_STATUS() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_EIP_STATUS.Reg)
}

// INTERRUPT_CORE0.CPU_INT_PRI_0: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_0_CPU_PRI_0_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_0.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_0.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_0_CPU_PRI_0_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_0.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_1: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_1_CPU_PRI_1_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_1.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_1.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_1_CPU_PRI_1_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_1.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_2: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_2_CPU_PRI_2_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_2.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_2.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_2_CPU_PRI_2_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_2.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_3: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_3_CPU_PRI_3_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_3.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_3.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_3_CPU_PRI_3_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_3.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_4: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_4_CPU_PRI_4_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_4.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_4.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_4_CPU_PRI_4_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_4.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_5: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_5_CPU_PRI_5_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_5.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_5.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_5_CPU_PRI_5_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_5.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_6: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_6_CPU_PRI_6_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_6.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_6.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_6_CPU_PRI_6_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_6.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_7: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_7_CPU_PRI_7_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_7.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_7.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_7_CPU_PRI_7_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_7.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_8: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_8_CPU_PRI_8_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_8.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_8.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_8_CPU_PRI_8_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_8.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_9: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_9_CPU_PRI_9_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_9.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_9.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_9_CPU_PRI_9_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_9.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_10: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_10_CPU_PRI_10_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_10.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_10.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_10_CPU_PRI_10_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_10.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_11: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_11_CPU_PRI_11_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_11.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_11.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_11_CPU_PRI_11_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_11.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_12: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_12_CPU_PRI_12_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_12.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_12.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_12_CPU_PRI_12_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_12.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_13: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_13_CPU_PRI_13_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_13.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_13.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_13_CPU_PRI_13_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_13.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_14: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_14_CPU_PRI_14_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_14.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_14.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_14_CPU_PRI_14_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_14.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_15: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_15_CPU_PRI_15_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_15.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_15.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_15_CPU_PRI_15_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_15.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_16: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_16_CPU_PRI_16_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_16.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_16.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_16_CPU_PRI_16_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_16.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_17: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_17_CPU_PRI_17_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_17.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_17.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_17_CPU_PRI_17_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_17.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_18: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_18_CPU_PRI_18_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_18.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_18.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_18_CPU_PRI_18_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_18.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_19: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_19_CPU_PRI_19_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_19.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_19.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_19_CPU_PRI_19_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_19.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_20: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_20_CPU_PRI_20_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_20.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_20.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_20_CPU_PRI_20_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_20.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_21: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_21_CPU_PRI_21_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_21.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_21.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_21_CPU_PRI_21_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_21.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_22: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_22_CPU_PRI_22_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_22.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_22.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_22_CPU_PRI_22_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_22.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_23: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_23_CPU_PRI_23_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_23.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_23.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_23_CPU_PRI_23_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_23.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_24: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_24_CPU_PRI_24_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_24.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_24.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_24_CPU_PRI_24_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_24.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_25: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_25_CPU_PRI_25_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_25.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_25.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_25_CPU_PRI_25_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_25.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_26: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_26_CPU_PRI_26_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_26.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_26.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_26_CPU_PRI_26_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_26.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_27: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_27_CPU_PRI_27_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_27.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_27.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_27_CPU_PRI_27_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_27.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_28: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_28_CPU_PRI_28_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_28.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_28.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_28_CPU_PRI_28_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_28.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_29: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_29_CPU_PRI_29_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_29.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_29.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_29_CPU_PRI_29_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_29.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_30: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_30_CPU_PRI_30_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_30.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_30.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_30_CPU_PRI_30_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_30.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_PRI_31: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_PRI_31_CPU_PRI_31_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_PRI_31.Reg, volatile.LoadUint32(&o.CPU_INT_PRI_31.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_PRI_31_CPU_PRI_31_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_PRI_31.Reg) & 0xf
}

// INTERRUPT_CORE0.CPU_INT_THRESH: register description
func (o *INTERRUPT_CORE0_Type) SetCPU_INT_THRESH(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_THRESH.Reg, volatile.LoadUint32(&o.CPU_INT_THRESH.Reg)&^(0xf)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCPU_INT_THRESH() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_THRESH.Reg) & 0xf
}

// INTERRUPT_CORE0.INTERRUPT_REG_DATE: register description
func (o *INTERRUPT_CORE0_Type) SetINTERRUPT_REG_DATE(value uint32) {
	volatile.StoreUint32(&o.INTERRUPT_REG_DATE.Reg, volatile.LoadUint32(&o.INTERRUPT_REG_DATE.Reg)&^(0xfffffff)|value)
}
func (o *INTERRUPT_CORE0_Type) GetINTERRUPT_REG_DATE() uint32 {
	return volatile.LoadUint32(&o.INTERRUPT_REG_DATE.Reg) & 0xfffffff
}

// Input/Output Multiplexer
type IO_MUX_Type struct {
	PIN_CTRL volatile.Register32 // 0x0
	GPIO0    volatile.Register32 // 0x4
	GPIO1    volatile.Register32 // 0x8
	GPIO2    volatile.Register32 // 0xC
	GPIO3    volatile.Register32 // 0x10
	GPIO4    volatile.Register32 // 0x14
	GPIO5    volatile.Register32 // 0x18
	GPIO6    volatile.Register32 // 0x1C
	GPIO7    volatile.Register32 // 0x20
	GPIO8    volatile.Register32 // 0x24
	GPIO9    volatile.Register32 // 0x28
	GPIO10   volatile.Register32 // 0x2C
	GPIO11   volatile.Register32 // 0x30
	GPIO12   volatile.Register32 // 0x34
	GPIO13   volatile.Register32 // 0x38
	GPIO14   volatile.Register32 // 0x3C
	GPIO15   volatile.Register32 // 0x40
	GPIO16   volatile.Register32 // 0x44
	GPIO17   volatile.Register32 // 0x48
	GPIO18   volatile.Register32 // 0x4C
	GPIO19   volatile.Register32 // 0x50
	GPIO20   volatile.Register32 // 0x54
	_        [164]byte
	DATE     volatile.Register32 // 0xFC
}

// IO_MUX.PIN_CTRL: Clock Output Configuration Register
func (o *IO_MUX_Type) SetPIN_CTRL_CLK_OUT1(value uint32) {
	volatile.StoreUint32(&o.PIN_CTRL.Reg, volatile.LoadUint32(&o.PIN_CTRL.Reg)&^(0xf)|value)
}
func (o *IO_MUX_Type) GetPIN_CTRL_CLK_OUT1() uint32 {
	return volatile.LoadUint32(&o.PIN_CTRL.Reg) & 0xf
}
func (o *IO_MUX_Type) SetPIN_CTRL_CLK_OUT2(value uint32) {
	volatile.StoreUint32(&o.PIN_CTRL.Reg, volatile.LoadUint32(&o.PIN_CTRL.Reg)&^(0xf0)|value<<4)
}
func (o *IO_MUX_Type) GetPIN_CTRL_CLK_OUT2() uint32 {
	return (volatile.LoadUint32(&o.PIN_CTRL.Reg) & 0xf0) >> 4
}
func (o *IO_MUX_Type) SetPIN_CTRL_CLK_OUT3(value uint32) {
	volatile.StoreUint32(&o.PIN_CTRL.Reg, volatile.LoadUint32(&o.PIN_CTRL.Reg)&^(0xf00)|value<<8)
}
func (o *IO_MUX_Type) GetPIN_CTRL_CLK_OUT3() uint32 {
	return (volatile.LoadUint32(&o.PIN_CTRL.Reg) & 0xf00) >> 8
}

// IO_MUX.GPIO0: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO0_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO0_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO0.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO0_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO0_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO0_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO0_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO0_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO0_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO0_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO0_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO0_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO0_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO0_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO0_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO0_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO0_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO0_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO0_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO0_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO0_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO0_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO0_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO1: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO1_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO1_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO1.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO1_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO1_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO1_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO1_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO1_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO1_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO1_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO1_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO1_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO1_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO1_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO1_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO1_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO1_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO1_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO1_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO1_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO1_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO1_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO1_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO2: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO2_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO2_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO2.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO2_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO2_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO2_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO2_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO2_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO2_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO2_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO2_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO2_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO2_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO2_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO2_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO2_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO2_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO2_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO2_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO2_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO2_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO2_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO2_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO3: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO3_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO3_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO3.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO3_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO3_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO3_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO3_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO3_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO3_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO3_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO3_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO3_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO3_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO3_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO3_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO3_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO3_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO3_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO3_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO3_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO3_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO3_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO3_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO4: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO4_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO4_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO4.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO4_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO4_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO4_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO4_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO4_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO4_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO4_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO4_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO4_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO4_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO4_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO4_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO4_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO4_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO4_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO4_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO4_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO4_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO4_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO4_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO5: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO5_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO5_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO5.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO5_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO5_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO5_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO5_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO5_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO5_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO5_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO5_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO5_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO5_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO5_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO5_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO5_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO5_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO5_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO5_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO5_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO5_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO5_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO5_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO6: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO6_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO6_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO6.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO6_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO6_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO6_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO6_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO6_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO6_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO6_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO6_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO6_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO6_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO6_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO6_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO6_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO6_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO6_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO6_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO6_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO6_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO6_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO6_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO7: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO7_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO7_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO7.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO7_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO7_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO7_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO7_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO7_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO7_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO7_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO7_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO7_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO7_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO7_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO7_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO7_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO7_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO7_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO7_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO7_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO7_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO7_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO7_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO8: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO8_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO8_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO8.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO8_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO8_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO8_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO8_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO8_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO8_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO8_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO8_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO8_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO8_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO8_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO8_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO8_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO8_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO8_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO8_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO8_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO8_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO8_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO8_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO9: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO9_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO9_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO9.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO9_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO9_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO9_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO9_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO9_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO9_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO9_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO9_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO9_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO9_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO9_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO9_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO9_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO9_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO9_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO9_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO9_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO9_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO9_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO9_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO10: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO10_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO10_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO10.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO10_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO10_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO10_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO10_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO10_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO10_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO10_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO10_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO10_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO10_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO10_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO10_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO10_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO10_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO10_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO10_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO10_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO10_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO10_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO10_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO11: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO11_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO11_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO11.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO11_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO11_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO11_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO11_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO11_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO11_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO11_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO11_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO11_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO11_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO11_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO11_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO11_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO11_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO11_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO11_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO11_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO11_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO11_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO11_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO12: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO12_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO12_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO12.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO12_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO12_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO12_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO12_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO12_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO12_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO12_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO12_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO12_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO12_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO12_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO12_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO12_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO12_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO12_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO12_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO12_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO12_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO12_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO12_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO13: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO13_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO13_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO13.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO13_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO13_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO13_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO13_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO13_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO13_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO13_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO13_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO13_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO13_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO13_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO13_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO13_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO13_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO13_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO13_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO13_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO13_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO13_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO13_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO14: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO14_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO14_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO14.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO14_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO14_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO14_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO14_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO14_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO14_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO14_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO14_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO14_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO14_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO14_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO14_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO14_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO14_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO14_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO14_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO14_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO14_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO14_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO14_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO15: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO15_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO15_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO15.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO15_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO15_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO15_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO15_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO15_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO15_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO15_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO15_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO15_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO15_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO15_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO15_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO15_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO15_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO15_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO15_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO15_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO15_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO15_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO15_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO16: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO16_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO16_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO16.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO16_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO16_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO16_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO16_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO16_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO16_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO16_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO16_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO16_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO16_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO16_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO16_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO16_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO16_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO16_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO16_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO16_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO16_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO16_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO16_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO17: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO17_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO17_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO17.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO17_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO17_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO17_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO17_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO17_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO17_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO17_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO17_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO17_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO17_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO17_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO17_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO17_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO17_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO17_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO17_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO17_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO17_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO17_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO17_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO18: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO18_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO18_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO18.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO18_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO18_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO18_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO18_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO18_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO18_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO18_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO18_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO18_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO18_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO18_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO18_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO18_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO18_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO18_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO18_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO18_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO18_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO18_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO18_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO19: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO19_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO19_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO19.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO19_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO19_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO19_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO19_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO19_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO19_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO19_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO19_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO19_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO19_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO19_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO19_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO19_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO19_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO19_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO19_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO19_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO19_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO19_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO19_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO20: IO MUX Configure Register for pad XTAL_32K_P
func (o *IO_MUX_Type) SetGPIO20_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO20_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO20.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO20_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO20_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO20_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO20_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO20_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO20_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO20_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO20_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO20_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO20_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO20_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO20_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO20_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO20_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO20_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO20_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO20_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO20_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO20_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO20_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x8000) >> 15
}

// IO_MUX.DATE: IO MUX Version Control Register
func (o *IO_MUX_Type) SetDATE_REG_DATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *IO_MUX_Type) GetDATE_REG_DATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// LED Control PWM (Pulse Width Modulation)
type LEDC_Type struct {
	CH0_CONF0    volatile.Register32 // 0x0
	CH0_HPOINT   volatile.Register32 // 0x4
	CH0_DUTY     volatile.Register32 // 0x8
	CH0_CONF1    volatile.Register32 // 0xC
	CH0_DUTY_R   volatile.Register32 // 0x10
	CH1_CONF0    volatile.Register32 // 0x14
	CH1_HPOINT   volatile.Register32 // 0x18
	CH1_DUTY     volatile.Register32 // 0x1C
	CH1_CONF1    volatile.Register32 // 0x20
	CH1_DUTY_R   volatile.Register32 // 0x24
	CH2_CONF0    volatile.Register32 // 0x28
	CH2_HPOINT   volatile.Register32 // 0x2C
	CH2_DUTY     volatile.Register32 // 0x30
	CH2_CONF1    volatile.Register32 // 0x34
	CH2_DUTY_R   volatile.Register32 // 0x38
	CH3_CONF0    volatile.Register32 // 0x3C
	CH3_HPOINT   volatile.Register32 // 0x40
	CH3_DUTY     volatile.Register32 // 0x44
	CH3_CONF1    volatile.Register32 // 0x48
	CH3_DUTY_R   volatile.Register32 // 0x4C
	CH4_CONF0    volatile.Register32 // 0x50
	CH4_HPOINT   volatile.Register32 // 0x54
	CH4_DUTY     volatile.Register32 // 0x58
	CH4_CONF1    volatile.Register32 // 0x5C
	CH4_DUTY_R   volatile.Register32 // 0x60
	CH5_CONF0    volatile.Register32 // 0x64
	CH5_HPOINT   volatile.Register32 // 0x68
	CH5_DUTY     volatile.Register32 // 0x6C
	CH5_CONF1    volatile.Register32 // 0x70
	CH5_DUTY_R   volatile.Register32 // 0x74
	_            [40]byte
	TIMER0_CONF  volatile.Register32 // 0xA0
	TIMER0_VALUE volatile.Register32 // 0xA4
	TIMER1_CONF  volatile.Register32 // 0xA8
	TIMER1_VALUE volatile.Register32 // 0xAC
	TIMER2_CONF  volatile.Register32 // 0xB0
	TIMER2_VALUE volatile.Register32 // 0xB4
	TIMER3_CONF  volatile.Register32 // 0xB8
	TIMER3_VALUE volatile.Register32 // 0xBC
	INT_RAW      volatile.Register32 // 0xC0
	INT_ST       volatile.Register32 // 0xC4
	INT_ENA      volatile.Register32 // 0xC8
	INT_CLR      volatile.Register32 // 0xCC
	CONF         volatile.Register32 // 0xD0
	_            [40]byte
	DATE         volatile.Register32 // 0xFC
}

// LEDC.CH0_CONF0: Configuration register 0 for channel %s
func (o *LEDC_Type) SetCH0_CONF0_TIMER_SEL(value uint32) {
	volatile.StoreUint32(&o.CH0_CONF0.Reg, volatile.LoadUint32(&o.CH0_CONF0.Reg)&^(0x3)|value)
}
func (o *LEDC_Type) GetCH0_CONF0_TIMER_SEL() uint32 {
	return volatile.LoadUint32(&o.CH0_CONF0.Reg) & 0x3
}
func (o *LEDC_Type) SetCH0_CONF0_SIG_OUT_EN(value uint32) {
	volatile.StoreUint32(&o.CH0_CONF0.Reg, volatile.LoadUint32(&o.CH0_CONF0.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetCH0_CONF0_SIG_OUT_EN() uint32 {
	return (volatile.LoadUint32(&o.CH0_CONF0.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetCH0_CONF0_IDLE_LV(value uint32) {
	volatile.StoreUint32(&o.CH0_CONF0.Reg, volatile.LoadUint32(&o.CH0_CONF0.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetCH0_CONF0_IDLE_LV() uint32 {
	return (volatile.LoadUint32(&o.CH0_CONF0.Reg) & 0x8) >> 3
}
func (o *LEDC_Type) SetCH0_CONF0_PARA_UP(value uint32) {
	volatile.StoreUint32(&o.CH0_CONF0.Reg, volatile.LoadUint32(&o.CH0_CONF0.Reg)&^(0x10)|value<<4)
}
func (o *LEDC_Type) GetCH0_CONF0_PARA_UP() uint32 {
	return (volatile.LoadUint32(&o.CH0_CONF0.Reg) & 0x10) >> 4
}
func (o *LEDC_Type) SetCH0_CONF0_OVF_NUM(value uint32) {
	volatile.StoreUint32(&o.CH0_CONF0.Reg, volatile.LoadUint32(&o.CH0_CONF0.Reg)&^(0x7fe0)|value<<5)
}
func (o *LEDC_Type) GetCH0_CONF0_OVF_NUM() uint32 {
	return (volatile.LoadUint32(&o.CH0_CONF0.Reg) & 0x7fe0) >> 5
}
func (o *LEDC_Type) SetCH0_CONF0_OVF_CNT_EN(value uint32) {
	volatile.StoreUint32(&o.CH0_CONF0.Reg, volatile.LoadUint32(&o.CH0_CONF0.Reg)&^(0x8000)|value<<15)
}
func (o *LEDC_Type) GetCH0_CONF0_OVF_CNT_EN() uint32 {
	return (volatile.LoadUint32(&o.CH0_CONF0.Reg) & 0x8000) >> 15
}
func (o *LEDC_Type) SetCH0_CONF0_OVF_CNT_RESET(value uint32) {
	volatile.StoreUint32(&o.CH0_CONF0.Reg, volatile.LoadUint32(&o.CH0_CONF0.Reg)&^(0x10000)|value<<16)
}
func (o *LEDC_Type) GetCH0_CONF0_OVF_CNT_RESET() uint32 {
	return (volatile.LoadUint32(&o.CH0_CONF0.Reg) & 0x10000) >> 16
}

// LEDC.CH0_HPOINT: High point register for channel %s
func (o *LEDC_Type) SetCH0_HPOINT_HPOINT(value uint32) {
	volatile.StoreUint32(&o.CH0_HPOINT.Reg, volatile.LoadUint32(&o.CH0_HPOINT.Reg)&^(0x3fff)|value)
}
func (o *LEDC_Type) GetCH0_HPOINT_HPOINT() uint32 {
	return volatile.LoadUint32(&o.CH0_HPOINT.Reg) & 0x3fff
}

// LEDC.CH0_DUTY: Initial duty cycle for channel %s
func (o *LEDC_Type) SetCH0_DUTY_DUTY(value uint32) {
	volatile.StoreUint32(&o.CH0_DUTY.Reg, volatile.LoadUint32(&o.CH0_DUTY.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetCH0_DUTY_DUTY() uint32 {
	return volatile.LoadUint32(&o.CH0_DUTY.Reg) & 0x7ffff
}

// LEDC.CH0_CONF1: Configuration register 1 for channel %s
func (o *LEDC_Type) SetCH0_CONF1_DUTY_SCALE(value uint32) {
	volatile.StoreUint32(&o.CH0_CONF1.Reg, volatile.LoadUint32(&o.CH0_CONF1.Reg)&^(0x3ff)|value)
}
func (o *LEDC_Type) GetCH0_CONF1_DUTY_SCALE() uint32 {
	return volatile.LoadUint32(&o.CH0_CONF1.Reg) & 0x3ff
}
func (o *LEDC_Type) SetCH0_CONF1_DUTY_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CH0_CONF1.Reg, volatile.LoadUint32(&o.CH0_CONF1.Reg)&^(0xffc00)|value<<10)
}
func (o *LEDC_Type) GetCH0_CONF1_DUTY_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.CH0_CONF1.Reg) & 0xffc00) >> 10
}
func (o *LEDC_Type) SetCH0_CONF1_DUTY_NUM(value uint32) {
	volatile.StoreUint32(&o.CH0_CONF1.Reg, volatile.LoadUint32(&o.CH0_CONF1.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LEDC_Type) GetCH0_CONF1_DUTY_NUM() uint32 {
	return (volatile.LoadUint32(&o.CH0_CONF1.Reg) & 0x3ff00000) >> 20
}
func (o *LEDC_Type) SetCH0_CONF1_DUTY_INC(value uint32) {
	volatile.StoreUint32(&o.CH0_CONF1.Reg, volatile.LoadUint32(&o.CH0_CONF1.Reg)&^(0x40000000)|value<<30)
}
func (o *LEDC_Type) GetCH0_CONF1_DUTY_INC() uint32 {
	return (volatile.LoadUint32(&o.CH0_CONF1.Reg) & 0x40000000) >> 30
}
func (o *LEDC_Type) SetCH0_CONF1_DUTY_START(value uint32) {
	volatile.StoreUint32(&o.CH0_CONF1.Reg, volatile.LoadUint32(&o.CH0_CONF1.Reg)&^(0x80000000)|value<<31)
}
func (o *LEDC_Type) GetCH0_CONF1_DUTY_START() uint32 {
	return (volatile.LoadUint32(&o.CH0_CONF1.Reg) & 0x80000000) >> 31
}

// LEDC.CH0_DUTY_R: Current duty cycle for channel %s
func (o *LEDC_Type) SetCH0_DUTY_R_DUTY_CH0_R(value uint32) {
	volatile.StoreUint32(&o.CH0_DUTY_R.Reg, volatile.LoadUint32(&o.CH0_DUTY_R.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetCH0_DUTY_R_DUTY_CH0_R() uint32 {
	return volatile.LoadUint32(&o.CH0_DUTY_R.Reg) & 0x7ffff
}

// LEDC.CH1_CONF0: Configuration register 0 for channel %s
func (o *LEDC_Type) SetCH1_CONF0_TIMER_SEL(value uint32) {
	volatile.StoreUint32(&o.CH1_CONF0.Reg, volatile.LoadUint32(&o.CH1_CONF0.Reg)&^(0x3)|value)
}
func (o *LEDC_Type) GetCH1_CONF0_TIMER_SEL() uint32 {
	return volatile.LoadUint32(&o.CH1_CONF0.Reg) & 0x3
}
func (o *LEDC_Type) SetCH1_CONF0_SIG_OUT_EN(value uint32) {
	volatile.StoreUint32(&o.CH1_CONF0.Reg, volatile.LoadUint32(&o.CH1_CONF0.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetCH1_CONF0_SIG_OUT_EN() uint32 {
	return (volatile.LoadUint32(&o.CH1_CONF0.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetCH1_CONF0_IDLE_LV(value uint32) {
	volatile.StoreUint32(&o.CH1_CONF0.Reg, volatile.LoadUint32(&o.CH1_CONF0.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetCH1_CONF0_IDLE_LV() uint32 {
	return (volatile.LoadUint32(&o.CH1_CONF0.Reg) & 0x8) >> 3
}
func (o *LEDC_Type) SetCH1_CONF0_PARA_UP(value uint32) {
	volatile.StoreUint32(&o.CH1_CONF0.Reg, volatile.LoadUint32(&o.CH1_CONF0.Reg)&^(0x10)|value<<4)
}
func (o *LEDC_Type) GetCH1_CONF0_PARA_UP() uint32 {
	return (volatile.LoadUint32(&o.CH1_CONF0.Reg) & 0x10) >> 4
}
func (o *LEDC_Type) SetCH1_CONF0_OVF_NUM(value uint32) {
	volatile.StoreUint32(&o.CH1_CONF0.Reg, volatile.LoadUint32(&o.CH1_CONF0.Reg)&^(0x7fe0)|value<<5)
}
func (o *LEDC_Type) GetCH1_CONF0_OVF_NUM() uint32 {
	return (volatile.LoadUint32(&o.CH1_CONF0.Reg) & 0x7fe0) >> 5
}
func (o *LEDC_Type) SetCH1_CONF0_OVF_CNT_EN(value uint32) {
	volatile.StoreUint32(&o.CH1_CONF0.Reg, volatile.LoadUint32(&o.CH1_CONF0.Reg)&^(0x8000)|value<<15)
}
func (o *LEDC_Type) GetCH1_CONF0_OVF_CNT_EN() uint32 {
	return (volatile.LoadUint32(&o.CH1_CONF0.Reg) & 0x8000) >> 15
}
func (o *LEDC_Type) SetCH1_CONF0_OVF_CNT_RESET(value uint32) {
	volatile.StoreUint32(&o.CH1_CONF0.Reg, volatile.LoadUint32(&o.CH1_CONF0.Reg)&^(0x10000)|value<<16)
}
func (o *LEDC_Type) GetCH1_CONF0_OVF_CNT_RESET() uint32 {
	return (volatile.LoadUint32(&o.CH1_CONF0.Reg) & 0x10000) >> 16
}

// LEDC.CH1_HPOINT: High point register for channel %s
func (o *LEDC_Type) SetCH1_HPOINT_HPOINT(value uint32) {
	volatile.StoreUint32(&o.CH1_HPOINT.Reg, volatile.LoadUint32(&o.CH1_HPOINT.Reg)&^(0x3fff)|value)
}
func (o *LEDC_Type) GetCH1_HPOINT_HPOINT() uint32 {
	return volatile.LoadUint32(&o.CH1_HPOINT.Reg) & 0x3fff
}

// LEDC.CH1_DUTY: Initial duty cycle for channel %s
func (o *LEDC_Type) SetCH1_DUTY_DUTY(value uint32) {
	volatile.StoreUint32(&o.CH1_DUTY.Reg, volatile.LoadUint32(&o.CH1_DUTY.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetCH1_DUTY_DUTY() uint32 {
	return volatile.LoadUint32(&o.CH1_DUTY.Reg) & 0x7ffff
}

// LEDC.CH1_CONF1: Configuration register 1 for channel %s
func (o *LEDC_Type) SetCH1_CONF1_DUTY_SCALE(value uint32) {
	volatile.StoreUint32(&o.CH1_CONF1.Reg, volatile.LoadUint32(&o.CH1_CONF1.Reg)&^(0x3ff)|value)
}
func (o *LEDC_Type) GetCH1_CONF1_DUTY_SCALE() uint32 {
	return volatile.LoadUint32(&o.CH1_CONF1.Reg) & 0x3ff
}
func (o *LEDC_Type) SetCH1_CONF1_DUTY_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CH1_CONF1.Reg, volatile.LoadUint32(&o.CH1_CONF1.Reg)&^(0xffc00)|value<<10)
}
func (o *LEDC_Type) GetCH1_CONF1_DUTY_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.CH1_CONF1.Reg) & 0xffc00) >> 10
}
func (o *LEDC_Type) SetCH1_CONF1_DUTY_NUM(value uint32) {
	volatile.StoreUint32(&o.CH1_CONF1.Reg, volatile.LoadUint32(&o.CH1_CONF1.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LEDC_Type) GetCH1_CONF1_DUTY_NUM() uint32 {
	return (volatile.LoadUint32(&o.CH1_CONF1.Reg) & 0x3ff00000) >> 20
}
func (o *LEDC_Type) SetCH1_CONF1_DUTY_INC(value uint32) {
	volatile.StoreUint32(&o.CH1_CONF1.Reg, volatile.LoadUint32(&o.CH1_CONF1.Reg)&^(0x40000000)|value<<30)
}
func (o *LEDC_Type) GetCH1_CONF1_DUTY_INC() uint32 {
	return (volatile.LoadUint32(&o.CH1_CONF1.Reg) & 0x40000000) >> 30
}
func (o *LEDC_Type) SetCH1_CONF1_DUTY_START(value uint32) {
	volatile.StoreUint32(&o.CH1_CONF1.Reg, volatile.LoadUint32(&o.CH1_CONF1.Reg)&^(0x80000000)|value<<31)
}
func (o *LEDC_Type) GetCH1_CONF1_DUTY_START() uint32 {
	return (volatile.LoadUint32(&o.CH1_CONF1.Reg) & 0x80000000) >> 31
}

// LEDC.CH1_DUTY_R: Current duty cycle for channel %s
func (o *LEDC_Type) SetCH1_DUTY_R_DUTY_CH0_R(value uint32) {
	volatile.StoreUint32(&o.CH1_DUTY_R.Reg, volatile.LoadUint32(&o.CH1_DUTY_R.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetCH1_DUTY_R_DUTY_CH0_R() uint32 {
	return volatile.LoadUint32(&o.CH1_DUTY_R.Reg) & 0x7ffff
}

// LEDC.CH2_CONF0: Configuration register 0 for channel %s
func (o *LEDC_Type) SetCH2_CONF0_TIMER_SEL(value uint32) {
	volatile.StoreUint32(&o.CH2_CONF0.Reg, volatile.LoadUint32(&o.CH2_CONF0.Reg)&^(0x3)|value)
}
func (o *LEDC_Type) GetCH2_CONF0_TIMER_SEL() uint32 {
	return volatile.LoadUint32(&o.CH2_CONF0.Reg) & 0x3
}
func (o *LEDC_Type) SetCH2_CONF0_SIG_OUT_EN(value uint32) {
	volatile.StoreUint32(&o.CH2_CONF0.Reg, volatile.LoadUint32(&o.CH2_CONF0.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetCH2_CONF0_SIG_OUT_EN() uint32 {
	return (volatile.LoadUint32(&o.CH2_CONF0.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetCH2_CONF0_IDLE_LV(value uint32) {
	volatile.StoreUint32(&o.CH2_CONF0.Reg, volatile.LoadUint32(&o.CH2_CONF0.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetCH2_CONF0_IDLE_LV() uint32 {
	return (volatile.LoadUint32(&o.CH2_CONF0.Reg) & 0x8) >> 3
}
func (o *LEDC_Type) SetCH2_CONF0_PARA_UP(value uint32) {
	volatile.StoreUint32(&o.CH2_CONF0.Reg, volatile.LoadUint32(&o.CH2_CONF0.Reg)&^(0x10)|value<<4)
}
func (o *LEDC_Type) GetCH2_CONF0_PARA_UP() uint32 {
	return (volatile.LoadUint32(&o.CH2_CONF0.Reg) & 0x10) >> 4
}
func (o *LEDC_Type) SetCH2_CONF0_OVF_NUM(value uint32) {
	volatile.StoreUint32(&o.CH2_CONF0.Reg, volatile.LoadUint32(&o.CH2_CONF0.Reg)&^(0x7fe0)|value<<5)
}
func (o *LEDC_Type) GetCH2_CONF0_OVF_NUM() uint32 {
	return (volatile.LoadUint32(&o.CH2_CONF0.Reg) & 0x7fe0) >> 5
}
func (o *LEDC_Type) SetCH2_CONF0_OVF_CNT_EN(value uint32) {
	volatile.StoreUint32(&o.CH2_CONF0.Reg, volatile.LoadUint32(&o.CH2_CONF0.Reg)&^(0x8000)|value<<15)
}
func (o *LEDC_Type) GetCH2_CONF0_OVF_CNT_EN() uint32 {
	return (volatile.LoadUint32(&o.CH2_CONF0.Reg) & 0x8000) >> 15
}
func (o *LEDC_Type) SetCH2_CONF0_OVF_CNT_RESET(value uint32) {
	volatile.StoreUint32(&o.CH2_CONF0.Reg, volatile.LoadUint32(&o.CH2_CONF0.Reg)&^(0x10000)|value<<16)
}
func (o *LEDC_Type) GetCH2_CONF0_OVF_CNT_RESET() uint32 {
	return (volatile.LoadUint32(&o.CH2_CONF0.Reg) & 0x10000) >> 16
}

// LEDC.CH2_HPOINT: High point register for channel %s
func (o *LEDC_Type) SetCH2_HPOINT_HPOINT(value uint32) {
	volatile.StoreUint32(&o.CH2_HPOINT.Reg, volatile.LoadUint32(&o.CH2_HPOINT.Reg)&^(0x3fff)|value)
}
func (o *LEDC_Type) GetCH2_HPOINT_HPOINT() uint32 {
	return volatile.LoadUint32(&o.CH2_HPOINT.Reg) & 0x3fff
}

// LEDC.CH2_DUTY: Initial duty cycle for channel %s
func (o *LEDC_Type) SetCH2_DUTY_DUTY(value uint32) {
	volatile.StoreUint32(&o.CH2_DUTY.Reg, volatile.LoadUint32(&o.CH2_DUTY.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetCH2_DUTY_DUTY() uint32 {
	return volatile.LoadUint32(&o.CH2_DUTY.Reg) & 0x7ffff
}

// LEDC.CH2_CONF1: Configuration register 1 for channel %s
func (o *LEDC_Type) SetCH2_CONF1_DUTY_SCALE(value uint32) {
	volatile.StoreUint32(&o.CH2_CONF1.Reg, volatile.LoadUint32(&o.CH2_CONF1.Reg)&^(0x3ff)|value)
}
func (o *LEDC_Type) GetCH2_CONF1_DUTY_SCALE() uint32 {
	return volatile.LoadUint32(&o.CH2_CONF1.Reg) & 0x3ff
}
func (o *LEDC_Type) SetCH2_CONF1_DUTY_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CH2_CONF1.Reg, volatile.LoadUint32(&o.CH2_CONF1.Reg)&^(0xffc00)|value<<10)
}
func (o *LEDC_Type) GetCH2_CONF1_DUTY_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.CH2_CONF1.Reg) & 0xffc00) >> 10
}
func (o *LEDC_Type) SetCH2_CONF1_DUTY_NUM(value uint32) {
	volatile.StoreUint32(&o.CH2_CONF1.Reg, volatile.LoadUint32(&o.CH2_CONF1.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LEDC_Type) GetCH2_CONF1_DUTY_NUM() uint32 {
	return (volatile.LoadUint32(&o.CH2_CONF1.Reg) & 0x3ff00000) >> 20
}
func (o *LEDC_Type) SetCH2_CONF1_DUTY_INC(value uint32) {
	volatile.StoreUint32(&o.CH2_CONF1.Reg, volatile.LoadUint32(&o.CH2_CONF1.Reg)&^(0x40000000)|value<<30)
}
func (o *LEDC_Type) GetCH2_CONF1_DUTY_INC() uint32 {
	return (volatile.LoadUint32(&o.CH2_CONF1.Reg) & 0x40000000) >> 30
}
func (o *LEDC_Type) SetCH2_CONF1_DUTY_START(value uint32) {
	volatile.StoreUint32(&o.CH2_CONF1.Reg, volatile.LoadUint32(&o.CH2_CONF1.Reg)&^(0x80000000)|value<<31)
}
func (o *LEDC_Type) GetCH2_CONF1_DUTY_START() uint32 {
	return (volatile.LoadUint32(&o.CH2_CONF1.Reg) & 0x80000000) >> 31
}

// LEDC.CH2_DUTY_R: Current duty cycle for channel %s
func (o *LEDC_Type) SetCH2_DUTY_R_DUTY_CH0_R(value uint32) {
	volatile.StoreUint32(&o.CH2_DUTY_R.Reg, volatile.LoadUint32(&o.CH2_DUTY_R.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetCH2_DUTY_R_DUTY_CH0_R() uint32 {
	return volatile.LoadUint32(&o.CH2_DUTY_R.Reg) & 0x7ffff
}

// LEDC.CH3_CONF0: Configuration register 0 for channel %s
func (o *LEDC_Type) SetCH3_CONF0_TIMER_SEL(value uint32) {
	volatile.StoreUint32(&o.CH3_CONF0.Reg, volatile.LoadUint32(&o.CH3_CONF0.Reg)&^(0x3)|value)
}
func (o *LEDC_Type) GetCH3_CONF0_TIMER_SEL() uint32 {
	return volatile.LoadUint32(&o.CH3_CONF0.Reg) & 0x3
}
func (o *LEDC_Type) SetCH3_CONF0_SIG_OUT_EN(value uint32) {
	volatile.StoreUint32(&o.CH3_CONF0.Reg, volatile.LoadUint32(&o.CH3_CONF0.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetCH3_CONF0_SIG_OUT_EN() uint32 {
	return (volatile.LoadUint32(&o.CH3_CONF0.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetCH3_CONF0_IDLE_LV(value uint32) {
	volatile.StoreUint32(&o.CH3_CONF0.Reg, volatile.LoadUint32(&o.CH3_CONF0.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetCH3_CONF0_IDLE_LV() uint32 {
	return (volatile.LoadUint32(&o.CH3_CONF0.Reg) & 0x8) >> 3
}
func (o *LEDC_Type) SetCH3_CONF0_PARA_UP(value uint32) {
	volatile.StoreUint32(&o.CH3_CONF0.Reg, volatile.LoadUint32(&o.CH3_CONF0.Reg)&^(0x10)|value<<4)
}
func (o *LEDC_Type) GetCH3_CONF0_PARA_UP() uint32 {
	return (volatile.LoadUint32(&o.CH3_CONF0.Reg) & 0x10) >> 4
}
func (o *LEDC_Type) SetCH3_CONF0_OVF_NUM(value uint32) {
	volatile.StoreUint32(&o.CH3_CONF0.Reg, volatile.LoadUint32(&o.CH3_CONF0.Reg)&^(0x7fe0)|value<<5)
}
func (o *LEDC_Type) GetCH3_CONF0_OVF_NUM() uint32 {
	return (volatile.LoadUint32(&o.CH3_CONF0.Reg) & 0x7fe0) >> 5
}
func (o *LEDC_Type) SetCH3_CONF0_OVF_CNT_EN(value uint32) {
	volatile.StoreUint32(&o.CH3_CONF0.Reg, volatile.LoadUint32(&o.CH3_CONF0.Reg)&^(0x8000)|value<<15)
}
func (o *LEDC_Type) GetCH3_CONF0_OVF_CNT_EN() uint32 {
	return (volatile.LoadUint32(&o.CH3_CONF0.Reg) & 0x8000) >> 15
}
func (o *LEDC_Type) SetCH3_CONF0_OVF_CNT_RESET(value uint32) {
	volatile.StoreUint32(&o.CH3_CONF0.Reg, volatile.LoadUint32(&o.CH3_CONF0.Reg)&^(0x10000)|value<<16)
}
func (o *LEDC_Type) GetCH3_CONF0_OVF_CNT_RESET() uint32 {
	return (volatile.LoadUint32(&o.CH3_CONF0.Reg) & 0x10000) >> 16
}

// LEDC.CH3_HPOINT: High point register for channel %s
func (o *LEDC_Type) SetCH3_HPOINT_HPOINT(value uint32) {
	volatile.StoreUint32(&o.CH3_HPOINT.Reg, volatile.LoadUint32(&o.CH3_HPOINT.Reg)&^(0x3fff)|value)
}
func (o *LEDC_Type) GetCH3_HPOINT_HPOINT() uint32 {
	return volatile.LoadUint32(&o.CH3_HPOINT.Reg) & 0x3fff
}

// LEDC.CH3_DUTY: Initial duty cycle for channel %s
func (o *LEDC_Type) SetCH3_DUTY_DUTY(value uint32) {
	volatile.StoreUint32(&o.CH3_DUTY.Reg, volatile.LoadUint32(&o.CH3_DUTY.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetCH3_DUTY_DUTY() uint32 {
	return volatile.LoadUint32(&o.CH3_DUTY.Reg) & 0x7ffff
}

// LEDC.CH3_CONF1: Configuration register 1 for channel %s
func (o *LEDC_Type) SetCH3_CONF1_DUTY_SCALE(value uint32) {
	volatile.StoreUint32(&o.CH3_CONF1.Reg, volatile.LoadUint32(&o.CH3_CONF1.Reg)&^(0x3ff)|value)
}
func (o *LEDC_Type) GetCH3_CONF1_DUTY_SCALE() uint32 {
	return volatile.LoadUint32(&o.CH3_CONF1.Reg) & 0x3ff
}
func (o *LEDC_Type) SetCH3_CONF1_DUTY_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CH3_CONF1.Reg, volatile.LoadUint32(&o.CH3_CONF1.Reg)&^(0xffc00)|value<<10)
}
func (o *LEDC_Type) GetCH3_CONF1_DUTY_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.CH3_CONF1.Reg) & 0xffc00) >> 10
}
func (o *LEDC_Type) SetCH3_CONF1_DUTY_NUM(value uint32) {
	volatile.StoreUint32(&o.CH3_CONF1.Reg, volatile.LoadUint32(&o.CH3_CONF1.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LEDC_Type) GetCH3_CONF1_DUTY_NUM() uint32 {
	return (volatile.LoadUint32(&o.CH3_CONF1.Reg) & 0x3ff00000) >> 20
}
func (o *LEDC_Type) SetCH3_CONF1_DUTY_INC(value uint32) {
	volatile.StoreUint32(&o.CH3_CONF1.Reg, volatile.LoadUint32(&o.CH3_CONF1.Reg)&^(0x40000000)|value<<30)
}
func (o *LEDC_Type) GetCH3_CONF1_DUTY_INC() uint32 {
	return (volatile.LoadUint32(&o.CH3_CONF1.Reg) & 0x40000000) >> 30
}
func (o *LEDC_Type) SetCH3_CONF1_DUTY_START(value uint32) {
	volatile.StoreUint32(&o.CH3_CONF1.Reg, volatile.LoadUint32(&o.CH3_CONF1.Reg)&^(0x80000000)|value<<31)
}
func (o *LEDC_Type) GetCH3_CONF1_DUTY_START() uint32 {
	return (volatile.LoadUint32(&o.CH3_CONF1.Reg) & 0x80000000) >> 31
}

// LEDC.CH3_DUTY_R: Current duty cycle for channel %s
func (o *LEDC_Type) SetCH3_DUTY_R_DUTY_CH0_R(value uint32) {
	volatile.StoreUint32(&o.CH3_DUTY_R.Reg, volatile.LoadUint32(&o.CH3_DUTY_R.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetCH3_DUTY_R_DUTY_CH0_R() uint32 {
	return volatile.LoadUint32(&o.CH3_DUTY_R.Reg) & 0x7ffff
}

// LEDC.CH4_CONF0: Configuration register 0 for channel %s
func (o *LEDC_Type) SetCH4_CONF0_TIMER_SEL(value uint32) {
	volatile.StoreUint32(&o.CH4_CONF0.Reg, volatile.LoadUint32(&o.CH4_CONF0.Reg)&^(0x3)|value)
}
func (o *LEDC_Type) GetCH4_CONF0_TIMER_SEL() uint32 {
	return volatile.LoadUint32(&o.CH4_CONF0.Reg) & 0x3
}
func (o *LEDC_Type) SetCH4_CONF0_SIG_OUT_EN(value uint32) {
	volatile.StoreUint32(&o.CH4_CONF0.Reg, volatile.LoadUint32(&o.CH4_CONF0.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetCH4_CONF0_SIG_OUT_EN() uint32 {
	return (volatile.LoadUint32(&o.CH4_CONF0.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetCH4_CONF0_IDLE_LV(value uint32) {
	volatile.StoreUint32(&o.CH4_CONF0.Reg, volatile.LoadUint32(&o.CH4_CONF0.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetCH4_CONF0_IDLE_LV() uint32 {
	return (volatile.LoadUint32(&o.CH4_CONF0.Reg) & 0x8) >> 3
}
func (o *LEDC_Type) SetCH4_CONF0_PARA_UP(value uint32) {
	volatile.StoreUint32(&o.CH4_CONF0.Reg, volatile.LoadUint32(&o.CH4_CONF0.Reg)&^(0x10)|value<<4)
}
func (o *LEDC_Type) GetCH4_CONF0_PARA_UP() uint32 {
	return (volatile.LoadUint32(&o.CH4_CONF0.Reg) & 0x10) >> 4
}
func (o *LEDC_Type) SetCH4_CONF0_OVF_NUM(value uint32) {
	volatile.StoreUint32(&o.CH4_CONF0.Reg, volatile.LoadUint32(&o.CH4_CONF0.Reg)&^(0x7fe0)|value<<5)
}
func (o *LEDC_Type) GetCH4_CONF0_OVF_NUM() uint32 {
	return (volatile.LoadUint32(&o.CH4_CONF0.Reg) & 0x7fe0) >> 5
}
func (o *LEDC_Type) SetCH4_CONF0_OVF_CNT_EN(value uint32) {
	volatile.StoreUint32(&o.CH4_CONF0.Reg, volatile.LoadUint32(&o.CH4_CONF0.Reg)&^(0x8000)|value<<15)
}
func (o *LEDC_Type) GetCH4_CONF0_OVF_CNT_EN() uint32 {
	return (volatile.LoadUint32(&o.CH4_CONF0.Reg) & 0x8000) >> 15
}
func (o *LEDC_Type) SetCH4_CONF0_OVF_CNT_RESET(value uint32) {
	volatile.StoreUint32(&o.CH4_CONF0.Reg, volatile.LoadUint32(&o.CH4_CONF0.Reg)&^(0x10000)|value<<16)
}
func (o *LEDC_Type) GetCH4_CONF0_OVF_CNT_RESET() uint32 {
	return (volatile.LoadUint32(&o.CH4_CONF0.Reg) & 0x10000) >> 16
}

// LEDC.CH4_HPOINT: High point register for channel %s
func (o *LEDC_Type) SetCH4_HPOINT_HPOINT(value uint32) {
	volatile.StoreUint32(&o.CH4_HPOINT.Reg, volatile.LoadUint32(&o.CH4_HPOINT.Reg)&^(0x3fff)|value)
}
func (o *LEDC_Type) GetCH4_HPOINT_HPOINT() uint32 {
	return volatile.LoadUint32(&o.CH4_HPOINT.Reg) & 0x3fff
}

// LEDC.CH4_DUTY: Initial duty cycle for channel %s
func (o *LEDC_Type) SetCH4_DUTY_DUTY(value uint32) {
	volatile.StoreUint32(&o.CH4_DUTY.Reg, volatile.LoadUint32(&o.CH4_DUTY.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetCH4_DUTY_DUTY() uint32 {
	return volatile.LoadUint32(&o.CH4_DUTY.Reg) & 0x7ffff
}

// LEDC.CH4_CONF1: Configuration register 1 for channel %s
func (o *LEDC_Type) SetCH4_CONF1_DUTY_SCALE(value uint32) {
	volatile.StoreUint32(&o.CH4_CONF1.Reg, volatile.LoadUint32(&o.CH4_CONF1.Reg)&^(0x3ff)|value)
}
func (o *LEDC_Type) GetCH4_CONF1_DUTY_SCALE() uint32 {
	return volatile.LoadUint32(&o.CH4_CONF1.Reg) & 0x3ff
}
func (o *LEDC_Type) SetCH4_CONF1_DUTY_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CH4_CONF1.Reg, volatile.LoadUint32(&o.CH4_CONF1.Reg)&^(0xffc00)|value<<10)
}
func (o *LEDC_Type) GetCH4_CONF1_DUTY_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.CH4_CONF1.Reg) & 0xffc00) >> 10
}
func (o *LEDC_Type) SetCH4_CONF1_DUTY_NUM(value uint32) {
	volatile.StoreUint32(&o.CH4_CONF1.Reg, volatile.LoadUint32(&o.CH4_CONF1.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LEDC_Type) GetCH4_CONF1_DUTY_NUM() uint32 {
	return (volatile.LoadUint32(&o.CH4_CONF1.Reg) & 0x3ff00000) >> 20
}
func (o *LEDC_Type) SetCH4_CONF1_DUTY_INC(value uint32) {
	volatile.StoreUint32(&o.CH4_CONF1.Reg, volatile.LoadUint32(&o.CH4_CONF1.Reg)&^(0x40000000)|value<<30)
}
func (o *LEDC_Type) GetCH4_CONF1_DUTY_INC() uint32 {
	return (volatile.LoadUint32(&o.CH4_CONF1.Reg) & 0x40000000) >> 30
}
func (o *LEDC_Type) SetCH4_CONF1_DUTY_START(value uint32) {
	volatile.StoreUint32(&o.CH4_CONF1.Reg, volatile.LoadUint32(&o.CH4_CONF1.Reg)&^(0x80000000)|value<<31)
}
func (o *LEDC_Type) GetCH4_CONF1_DUTY_START() uint32 {
	return (volatile.LoadUint32(&o.CH4_CONF1.Reg) & 0x80000000) >> 31
}

// LEDC.CH4_DUTY_R: Current duty cycle for channel %s
func (o *LEDC_Type) SetCH4_DUTY_R_DUTY_CH0_R(value uint32) {
	volatile.StoreUint32(&o.CH4_DUTY_R.Reg, volatile.LoadUint32(&o.CH4_DUTY_R.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetCH4_DUTY_R_DUTY_CH0_R() uint32 {
	return volatile.LoadUint32(&o.CH4_DUTY_R.Reg) & 0x7ffff
}

// LEDC.CH5_CONF0: Configuration register 0 for channel %s
func (o *LEDC_Type) SetCH5_CONF0_TIMER_SEL(value uint32) {
	volatile.StoreUint32(&o.CH5_CONF0.Reg, volatile.LoadUint32(&o.CH5_CONF0.Reg)&^(0x3)|value)
}
func (o *LEDC_Type) GetCH5_CONF0_TIMER_SEL() uint32 {
	return volatile.LoadUint32(&o.CH5_CONF0.Reg) & 0x3
}
func (o *LEDC_Type) SetCH5_CONF0_SIG_OUT_EN(value uint32) {
	volatile.StoreUint32(&o.CH5_CONF0.Reg, volatile.LoadUint32(&o.CH5_CONF0.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetCH5_CONF0_SIG_OUT_EN() uint32 {
	return (volatile.LoadUint32(&o.CH5_CONF0.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetCH5_CONF0_IDLE_LV(value uint32) {
	volatile.StoreUint32(&o.CH5_CONF0.Reg, volatile.LoadUint32(&o.CH5_CONF0.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetCH5_CONF0_IDLE_LV() uint32 {
	return (volatile.LoadUint32(&o.CH5_CONF0.Reg) & 0x8) >> 3
}
func (o *LEDC_Type) SetCH5_CONF0_PARA_UP(value uint32) {
	volatile.StoreUint32(&o.CH5_CONF0.Reg, volatile.LoadUint32(&o.CH5_CONF0.Reg)&^(0x10)|value<<4)
}
func (o *LEDC_Type) GetCH5_CONF0_PARA_UP() uint32 {
	return (volatile.LoadUint32(&o.CH5_CONF0.Reg) & 0x10) >> 4
}
func (o *LEDC_Type) SetCH5_CONF0_OVF_NUM(value uint32) {
	volatile.StoreUint32(&o.CH5_CONF0.Reg, volatile.LoadUint32(&o.CH5_CONF0.Reg)&^(0x7fe0)|value<<5)
}
func (o *LEDC_Type) GetCH5_CONF0_OVF_NUM() uint32 {
	return (volatile.LoadUint32(&o.CH5_CONF0.Reg) & 0x7fe0) >> 5
}
func (o *LEDC_Type) SetCH5_CONF0_OVF_CNT_EN(value uint32) {
	volatile.StoreUint32(&o.CH5_CONF0.Reg, volatile.LoadUint32(&o.CH5_CONF0.Reg)&^(0x8000)|value<<15)
}
func (o *LEDC_Type) GetCH5_CONF0_OVF_CNT_EN() uint32 {
	return (volatile.LoadUint32(&o.CH5_CONF0.Reg) & 0x8000) >> 15
}
func (o *LEDC_Type) SetCH5_CONF0_OVF_CNT_RESET(value uint32) {
	volatile.StoreUint32(&o.CH5_CONF0.Reg, volatile.LoadUint32(&o.CH5_CONF0.Reg)&^(0x10000)|value<<16)
}
func (o *LEDC_Type) GetCH5_CONF0_OVF_CNT_RESET() uint32 {
	return (volatile.LoadUint32(&o.CH5_CONF0.Reg) & 0x10000) >> 16
}

// LEDC.CH5_HPOINT: High point register for channel %s
func (o *LEDC_Type) SetCH5_HPOINT_HPOINT(value uint32) {
	volatile.StoreUint32(&o.CH5_HPOINT.Reg, volatile.LoadUint32(&o.CH5_HPOINT.Reg)&^(0x3fff)|value)
}
func (o *LEDC_Type) GetCH5_HPOINT_HPOINT() uint32 {
	return volatile.LoadUint32(&o.CH5_HPOINT.Reg) & 0x3fff
}

// LEDC.CH5_DUTY: Initial duty cycle for channel %s
func (o *LEDC_Type) SetCH5_DUTY_DUTY(value uint32) {
	volatile.StoreUint32(&o.CH5_DUTY.Reg, volatile.LoadUint32(&o.CH5_DUTY.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetCH5_DUTY_DUTY() uint32 {
	return volatile.LoadUint32(&o.CH5_DUTY.Reg) & 0x7ffff
}

// LEDC.CH5_CONF1: Configuration register 1 for channel %s
func (o *LEDC_Type) SetCH5_CONF1_DUTY_SCALE(value uint32) {
	volatile.StoreUint32(&o.CH5_CONF1.Reg, volatile.LoadUint32(&o.CH5_CONF1.Reg)&^(0x3ff)|value)
}
func (o *LEDC_Type) GetCH5_CONF1_DUTY_SCALE() uint32 {
	return volatile.LoadUint32(&o.CH5_CONF1.Reg) & 0x3ff
}
func (o *LEDC_Type) SetCH5_CONF1_DUTY_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CH5_CONF1.Reg, volatile.LoadUint32(&o.CH5_CONF1.Reg)&^(0xffc00)|value<<10)
}
func (o *LEDC_Type) GetCH5_CONF1_DUTY_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.CH5_CONF1.Reg) & 0xffc00) >> 10
}
func (o *LEDC_Type) SetCH5_CONF1_DUTY_NUM(value uint32) {
	volatile.StoreUint32(&o.CH5_CONF1.Reg, volatile.LoadUint32(&o.CH5_CONF1.Reg)&^(0x3ff00000)|value<<20)
}
func (o *LEDC_Type) GetCH5_CONF1_DUTY_NUM() uint32 {
	return (volatile.LoadUint32(&o.CH5_CONF1.Reg) & 0x3ff00000) >> 20
}
func (o *LEDC_Type) SetCH5_CONF1_DUTY_INC(value uint32) {
	volatile.StoreUint32(&o.CH5_CONF1.Reg, volatile.LoadUint32(&o.CH5_CONF1.Reg)&^(0x40000000)|value<<30)
}
func (o *LEDC_Type) GetCH5_CONF1_DUTY_INC() uint32 {
	return (volatile.LoadUint32(&o.CH5_CONF1.Reg) & 0x40000000) >> 30
}
func (o *LEDC_Type) SetCH5_CONF1_DUTY_START(value uint32) {
	volatile.StoreUint32(&o.CH5_CONF1.Reg, volatile.LoadUint32(&o.CH5_CONF1.Reg)&^(0x80000000)|value<<31)
}
func (o *LEDC_Type) GetCH5_CONF1_DUTY_START() uint32 {
	return (volatile.LoadUint32(&o.CH5_CONF1.Reg) & 0x80000000) >> 31
}

// LEDC.CH5_DUTY_R: Current duty cycle for channel %s
func (o *LEDC_Type) SetCH5_DUTY_R_DUTY_CH0_R(value uint32) {
	volatile.StoreUint32(&o.CH5_DUTY_R.Reg, volatile.LoadUint32(&o.CH5_DUTY_R.Reg)&^(0x7ffff)|value)
}
func (o *LEDC_Type) GetCH5_DUTY_R_DUTY_CH0_R() uint32 {
	return volatile.LoadUint32(&o.CH5_DUTY_R.Reg) & 0x7ffff
}

// LEDC.TIMER0_CONF: Timer %s configuration
func (o *LEDC_Type) SetTIMER0_CONF_DUTY_RES(value uint32) {
	volatile.StoreUint32(&o.TIMER0_CONF.Reg, volatile.LoadUint32(&o.TIMER0_CONF.Reg)&^(0xf)|value)
}
func (o *LEDC_Type) GetTIMER0_CONF_DUTY_RES() uint32 {
	return volatile.LoadUint32(&o.TIMER0_CONF.Reg) & 0xf
}
func (o *LEDC_Type) SetTIMER0_CONF_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.TIMER0_CONF.Reg, volatile.LoadUint32(&o.TIMER0_CONF.Reg)&^(0x3ffff0)|value<<4)
}
func (o *LEDC_Type) GetTIMER0_CONF_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.TIMER0_CONF.Reg) & 0x3ffff0) >> 4
}
func (o *LEDC_Type) SetTIMER0_CONF_PAUSE(value uint32) {
	volatile.StoreUint32(&o.TIMER0_CONF.Reg, volatile.LoadUint32(&o.TIMER0_CONF.Reg)&^(0x400000)|value<<22)
}
func (o *LEDC_Type) GetTIMER0_CONF_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.TIMER0_CONF.Reg) & 0x400000) >> 22
}
func (o *LEDC_Type) SetTIMER0_CONF_RST(value uint32) {
	volatile.StoreUint32(&o.TIMER0_CONF.Reg, volatile.LoadUint32(&o.TIMER0_CONF.Reg)&^(0x800000)|value<<23)
}
func (o *LEDC_Type) GetTIMER0_CONF_RST() uint32 {
	return (volatile.LoadUint32(&o.TIMER0_CONF.Reg) & 0x800000) >> 23
}
func (o *LEDC_Type) SetTIMER0_CONF_TICK_SEL(value uint32) {
	volatile.StoreUint32(&o.TIMER0_CONF.Reg, volatile.LoadUint32(&o.TIMER0_CONF.Reg)&^(0x1000000)|value<<24)
}
func (o *LEDC_Type) GetTIMER0_CONF_TICK_SEL() uint32 {
	return (volatile.LoadUint32(&o.TIMER0_CONF.Reg) & 0x1000000) >> 24
}
func (o *LEDC_Type) SetTIMER0_CONF_PARA_UP(value uint32) {
	volatile.StoreUint32(&o.TIMER0_CONF.Reg, volatile.LoadUint32(&o.TIMER0_CONF.Reg)&^(0x2000000)|value<<25)
}
func (o *LEDC_Type) GetTIMER0_CONF_PARA_UP() uint32 {
	return (volatile.LoadUint32(&o.TIMER0_CONF.Reg) & 0x2000000) >> 25
}

// LEDC.TIMER0_VALUE: Timer %s current counter value
func (o *LEDC_Type) SetTIMER0_VALUE_CNT(value uint32) {
	volatile.StoreUint32(&o.TIMER0_VALUE.Reg, volatile.LoadUint32(&o.TIMER0_VALUE.Reg)&^(0x3fff)|value)
}
func (o *LEDC_Type) GetTIMER0_VALUE_CNT() uint32 {
	return volatile.LoadUint32(&o.TIMER0_VALUE.Reg) & 0x3fff
}

// LEDC.TIMER1_CONF: Timer %s configuration
func (o *LEDC_Type) SetTIMER1_CONF_DUTY_RES(value uint32) {
	volatile.StoreUint32(&o.TIMER1_CONF.Reg, volatile.LoadUint32(&o.TIMER1_CONF.Reg)&^(0xf)|value)
}
func (o *LEDC_Type) GetTIMER1_CONF_DUTY_RES() uint32 {
	return volatile.LoadUint32(&o.TIMER1_CONF.Reg) & 0xf
}
func (o *LEDC_Type) SetTIMER1_CONF_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.TIMER1_CONF.Reg, volatile.LoadUint32(&o.TIMER1_CONF.Reg)&^(0x3ffff0)|value<<4)
}
func (o *LEDC_Type) GetTIMER1_CONF_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.TIMER1_CONF.Reg) & 0x3ffff0) >> 4
}
func (o *LEDC_Type) SetTIMER1_CONF_PAUSE(value uint32) {
	volatile.StoreUint32(&o.TIMER1_CONF.Reg, volatile.LoadUint32(&o.TIMER1_CONF.Reg)&^(0x400000)|value<<22)
}
func (o *LEDC_Type) GetTIMER1_CONF_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.TIMER1_CONF.Reg) & 0x400000) >> 22
}
func (o *LEDC_Type) SetTIMER1_CONF_RST(value uint32) {
	volatile.StoreUint32(&o.TIMER1_CONF.Reg, volatile.LoadUint32(&o.TIMER1_CONF.Reg)&^(0x800000)|value<<23)
}
func (o *LEDC_Type) GetTIMER1_CONF_RST() uint32 {
	return (volatile.LoadUint32(&o.TIMER1_CONF.Reg) & 0x800000) >> 23
}
func (o *LEDC_Type) SetTIMER1_CONF_TICK_SEL(value uint32) {
	volatile.StoreUint32(&o.TIMER1_CONF.Reg, volatile.LoadUint32(&o.TIMER1_CONF.Reg)&^(0x1000000)|value<<24)
}
func (o *LEDC_Type) GetTIMER1_CONF_TICK_SEL() uint32 {
	return (volatile.LoadUint32(&o.TIMER1_CONF.Reg) & 0x1000000) >> 24
}
func (o *LEDC_Type) SetTIMER1_CONF_PARA_UP(value uint32) {
	volatile.StoreUint32(&o.TIMER1_CONF.Reg, volatile.LoadUint32(&o.TIMER1_CONF.Reg)&^(0x2000000)|value<<25)
}
func (o *LEDC_Type) GetTIMER1_CONF_PARA_UP() uint32 {
	return (volatile.LoadUint32(&o.TIMER1_CONF.Reg) & 0x2000000) >> 25
}

// LEDC.TIMER1_VALUE: Timer %s current counter value
func (o *LEDC_Type) SetTIMER1_VALUE_CNT(value uint32) {
	volatile.StoreUint32(&o.TIMER1_VALUE.Reg, volatile.LoadUint32(&o.TIMER1_VALUE.Reg)&^(0x3fff)|value)
}
func (o *LEDC_Type) GetTIMER1_VALUE_CNT() uint32 {
	return volatile.LoadUint32(&o.TIMER1_VALUE.Reg) & 0x3fff
}

// LEDC.TIMER2_CONF: Timer %s configuration
func (o *LEDC_Type) SetTIMER2_CONF_DUTY_RES(value uint32) {
	volatile.StoreUint32(&o.TIMER2_CONF.Reg, volatile.LoadUint32(&o.TIMER2_CONF.Reg)&^(0xf)|value)
}
func (o *LEDC_Type) GetTIMER2_CONF_DUTY_RES() uint32 {
	return volatile.LoadUint32(&o.TIMER2_CONF.Reg) & 0xf
}
func (o *LEDC_Type) SetTIMER2_CONF_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.TIMER2_CONF.Reg, volatile.LoadUint32(&o.TIMER2_CONF.Reg)&^(0x3ffff0)|value<<4)
}
func (o *LEDC_Type) GetTIMER2_CONF_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.TIMER2_CONF.Reg) & 0x3ffff0) >> 4
}
func (o *LEDC_Type) SetTIMER2_CONF_PAUSE(value uint32) {
	volatile.StoreUint32(&o.TIMER2_CONF.Reg, volatile.LoadUint32(&o.TIMER2_CONF.Reg)&^(0x400000)|value<<22)
}
func (o *LEDC_Type) GetTIMER2_CONF_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.TIMER2_CONF.Reg) & 0x400000) >> 22
}
func (o *LEDC_Type) SetTIMER2_CONF_RST(value uint32) {
	volatile.StoreUint32(&o.TIMER2_CONF.Reg, volatile.LoadUint32(&o.TIMER2_CONF.Reg)&^(0x800000)|value<<23)
}
func (o *LEDC_Type) GetTIMER2_CONF_RST() uint32 {
	return (volatile.LoadUint32(&o.TIMER2_CONF.Reg) & 0x800000) >> 23
}
func (o *LEDC_Type) SetTIMER2_CONF_TICK_SEL(value uint32) {
	volatile.StoreUint32(&o.TIMER2_CONF.Reg, volatile.LoadUint32(&o.TIMER2_CONF.Reg)&^(0x1000000)|value<<24)
}
func (o *LEDC_Type) GetTIMER2_CONF_TICK_SEL() uint32 {
	return (volatile.LoadUint32(&o.TIMER2_CONF.Reg) & 0x1000000) >> 24
}
func (o *LEDC_Type) SetTIMER2_CONF_PARA_UP(value uint32) {
	volatile.StoreUint32(&o.TIMER2_CONF.Reg, volatile.LoadUint32(&o.TIMER2_CONF.Reg)&^(0x2000000)|value<<25)
}
func (o *LEDC_Type) GetTIMER2_CONF_PARA_UP() uint32 {
	return (volatile.LoadUint32(&o.TIMER2_CONF.Reg) & 0x2000000) >> 25
}

// LEDC.TIMER2_VALUE: Timer %s current counter value
func (o *LEDC_Type) SetTIMER2_VALUE_CNT(value uint32) {
	volatile.StoreUint32(&o.TIMER2_VALUE.Reg, volatile.LoadUint32(&o.TIMER2_VALUE.Reg)&^(0x3fff)|value)
}
func (o *LEDC_Type) GetTIMER2_VALUE_CNT() uint32 {
	return volatile.LoadUint32(&o.TIMER2_VALUE.Reg) & 0x3fff
}

// LEDC.TIMER3_CONF: Timer %s configuration
func (o *LEDC_Type) SetTIMER3_CONF_DUTY_RES(value uint32) {
	volatile.StoreUint32(&o.TIMER3_CONF.Reg, volatile.LoadUint32(&o.TIMER3_CONF.Reg)&^(0xf)|value)
}
func (o *LEDC_Type) GetTIMER3_CONF_DUTY_RES() uint32 {
	return volatile.LoadUint32(&o.TIMER3_CONF.Reg) & 0xf
}
func (o *LEDC_Type) SetTIMER3_CONF_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.TIMER3_CONF.Reg, volatile.LoadUint32(&o.TIMER3_CONF.Reg)&^(0x3ffff0)|value<<4)
}
func (o *LEDC_Type) GetTIMER3_CONF_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.TIMER3_CONF.Reg) & 0x3ffff0) >> 4
}
func (o *LEDC_Type) SetTIMER3_CONF_PAUSE(value uint32) {
	volatile.StoreUint32(&o.TIMER3_CONF.Reg, volatile.LoadUint32(&o.TIMER3_CONF.Reg)&^(0x400000)|value<<22)
}
func (o *LEDC_Type) GetTIMER3_CONF_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.TIMER3_CONF.Reg) & 0x400000) >> 22
}
func (o *LEDC_Type) SetTIMER3_CONF_RST(value uint32) {
	volatile.StoreUint32(&o.TIMER3_CONF.Reg, volatile.LoadUint32(&o.TIMER3_CONF.Reg)&^(0x800000)|value<<23)
}
func (o *LEDC_Type) GetTIMER3_CONF_RST() uint32 {
	return (volatile.LoadUint32(&o.TIMER3_CONF.Reg) & 0x800000) >> 23
}
func (o *LEDC_Type) SetTIMER3_CONF_TICK_SEL(value uint32) {
	volatile.StoreUint32(&o.TIMER3_CONF.Reg, volatile.LoadUint32(&o.TIMER3_CONF.Reg)&^(0x1000000)|value<<24)
}
func (o *LEDC_Type) GetTIMER3_CONF_TICK_SEL() uint32 {
	return (volatile.LoadUint32(&o.TIMER3_CONF.Reg) & 0x1000000) >> 24
}
func (o *LEDC_Type) SetTIMER3_CONF_PARA_UP(value uint32) {
	volatile.StoreUint32(&o.TIMER3_CONF.Reg, volatile.LoadUint32(&o.TIMER3_CONF.Reg)&^(0x2000000)|value<<25)
}
func (o *LEDC_Type) GetTIMER3_CONF_PARA_UP() uint32 {
	return (volatile.LoadUint32(&o.TIMER3_CONF.Reg) & 0x2000000) >> 25
}

// LEDC.TIMER3_VALUE: Timer %s current counter value
func (o *LEDC_Type) SetTIMER3_VALUE_CNT(value uint32) {
	volatile.StoreUint32(&o.TIMER3_VALUE.Reg, volatile.LoadUint32(&o.TIMER3_VALUE.Reg)&^(0x3fff)|value)
}
func (o *LEDC_Type) GetTIMER3_VALUE_CNT() uint32 {
	return volatile.LoadUint32(&o.TIMER3_VALUE.Reg) & 0x3fff
}

// LEDC.INT_RAW: Raw interrupt status
func (o *LEDC_Type) SetINT_RAW_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *LEDC_Type) GetINT_RAW_OVF_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *LEDC_Type) SetINT_RAW_TIMER1_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *LEDC_Type) GetINT_RAW_TIMER1_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}
func (o *LEDC_Type) SetINT_RAW_TIMER2_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetINT_RAW_TIMER2_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetINT_RAW_TIMER3_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetINT_RAW_TIMER3_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8) >> 3
}
func (o *LEDC_Type) SetINT_RAW_DUTY_CHNG_END_CH0_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *LEDC_Type) GetINT_RAW_DUTY_CHNG_END_CH0_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10) >> 4
}
func (o *LEDC_Type) SetINT_RAW_DUTY_CHNG_END_CH1_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *LEDC_Type) GetINT_RAW_DUTY_CHNG_END_CH1_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20) >> 5
}
func (o *LEDC_Type) SetINT_RAW_DUTY_CHNG_END_CH2_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40)|value<<6)
}
func (o *LEDC_Type) GetINT_RAW_DUTY_CHNG_END_CH2_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40) >> 6
}
func (o *LEDC_Type) SetINT_RAW_DUTY_CHNG_END_CH3_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80)|value<<7)
}
func (o *LEDC_Type) GetINT_RAW_DUTY_CHNG_END_CH3_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80) >> 7
}
func (o *LEDC_Type) SetINT_RAW_DUTY_CHNG_END_CH4_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x100)|value<<8)
}
func (o *LEDC_Type) GetINT_RAW_DUTY_CHNG_END_CH4_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x100) >> 8
}
func (o *LEDC_Type) SetINT_RAW_DUTY_CHNG_END_CH5_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x200)|value<<9)
}
func (o *LEDC_Type) GetINT_RAW_DUTY_CHNG_END_CH5_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x200) >> 9
}
func (o *LEDC_Type) SetINT_RAW_OVF_CNT_CH0_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x400)|value<<10)
}
func (o *LEDC_Type) GetINT_RAW_OVF_CNT_CH0_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x400) >> 10
}
func (o *LEDC_Type) SetINT_RAW_OVF_CNT_CH1_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x800)|value<<11)
}
func (o *LEDC_Type) GetINT_RAW_OVF_CNT_CH1_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x800) >> 11
}
func (o *LEDC_Type) SetINT_RAW_OVF_CNT_CH2_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1000)|value<<12)
}
func (o *LEDC_Type) GetINT_RAW_OVF_CNT_CH2_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1000) >> 12
}
func (o *LEDC_Type) SetINT_RAW_OVF_CNT_CH3_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2000)|value<<13)
}
func (o *LEDC_Type) GetINT_RAW_OVF_CNT_CH3_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2000) >> 13
}
func (o *LEDC_Type) SetINT_RAW_OVF_CNT_CH4_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4000)|value<<14)
}
func (o *LEDC_Type) GetINT_RAW_OVF_CNT_CH4_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4000) >> 14
}
func (o *LEDC_Type) SetINT_RAW_OVF_CNT_CH5_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8000)|value<<15)
}
func (o *LEDC_Type) GetINT_RAW_OVF_CNT_CH5_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8000) >> 15
}

// LEDC.INT_ST: Masked interrupt status
func (o *LEDC_Type) SetINT_ST_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1)|value)
}
func (o *LEDC_Type) GetINT_ST_OVF_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST.Reg) & 0x1
}
func (o *LEDC_Type) SetINT_ST_TIMER1_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *LEDC_Type) GetINT_ST_TIMER1_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2) >> 1
}
func (o *LEDC_Type) SetINT_ST_TIMER2_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetINT_ST_TIMER2_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetINT_ST_TIMER3_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetINT_ST_TIMER3_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x8) >> 3
}
func (o *LEDC_Type) SetINT_ST_DUTY_CHNG_END_CH0_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x10)|value<<4)
}
func (o *LEDC_Type) GetINT_ST_DUTY_CHNG_END_CH0_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x10) >> 4
}
func (o *LEDC_Type) SetINT_ST_DUTY_CHNG_END_CH1_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x20)|value<<5)
}
func (o *LEDC_Type) GetINT_ST_DUTY_CHNG_END_CH1_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x20) >> 5
}
func (o *LEDC_Type) SetINT_ST_DUTY_CHNG_END_CH2_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x40)|value<<6)
}
func (o *LEDC_Type) GetINT_ST_DUTY_CHNG_END_CH2_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x40) >> 6
}
func (o *LEDC_Type) SetINT_ST_DUTY_CHNG_END_CH3_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x80)|value<<7)
}
func (o *LEDC_Type) GetINT_ST_DUTY_CHNG_END_CH3_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x80) >> 7
}
func (o *LEDC_Type) SetINT_ST_DUTY_CHNG_END_CH4_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x100)|value<<8)
}
func (o *LEDC_Type) GetINT_ST_DUTY_CHNG_END_CH4_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x100) >> 8
}
func (o *LEDC_Type) SetINT_ST_DUTY_CHNG_END_CH5_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x200)|value<<9)
}
func (o *LEDC_Type) GetINT_ST_DUTY_CHNG_END_CH5_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x200) >> 9
}
func (o *LEDC_Type) SetINT_ST_OVF_CNT_CH0_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x400)|value<<10)
}
func (o *LEDC_Type) GetINT_ST_OVF_CNT_CH0_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x400) >> 10
}
func (o *LEDC_Type) SetINT_ST_OVF_CNT_CH1_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x800)|value<<11)
}
func (o *LEDC_Type) GetINT_ST_OVF_CNT_CH1_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x800) >> 11
}
func (o *LEDC_Type) SetINT_ST_OVF_CNT_CH2_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1000)|value<<12)
}
func (o *LEDC_Type) GetINT_ST_OVF_CNT_CH2_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x1000) >> 12
}
func (o *LEDC_Type) SetINT_ST_OVF_CNT_CH3_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2000)|value<<13)
}
func (o *LEDC_Type) GetINT_ST_OVF_CNT_CH3_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2000) >> 13
}
func (o *LEDC_Type) SetINT_ST_OVF_CNT_CH4_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4000)|value<<14)
}
func (o *LEDC_Type) GetINT_ST_OVF_CNT_CH4_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4000) >> 14
}
func (o *LEDC_Type) SetINT_ST_OVF_CNT_CH5_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x8000)|value<<15)
}
func (o *LEDC_Type) GetINT_ST_OVF_CNT_CH5_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x8000) >> 15
}

// LEDC.INT_ENA: Interrupt enable bits
func (o *LEDC_Type) SetINT_ENA_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *LEDC_Type) GetINT_ENA_OVF_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *LEDC_Type) SetINT_ENA_TIMER1_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *LEDC_Type) GetINT_ENA_TIMER1_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}
func (o *LEDC_Type) SetINT_ENA_TIMER2_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetINT_ENA_TIMER2_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetINT_ENA_TIMER3_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetINT_ENA_TIMER3_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8) >> 3
}
func (o *LEDC_Type) SetINT_ENA_DUTY_CHNG_END_CH0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *LEDC_Type) GetINT_ENA_DUTY_CHNG_END_CH0_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10) >> 4
}
func (o *LEDC_Type) SetINT_ENA_DUTY_CHNG_END_CH1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *LEDC_Type) GetINT_ENA_DUTY_CHNG_END_CH1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20) >> 5
}
func (o *LEDC_Type) SetINT_ENA_DUTY_CHNG_END_CH2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40)|value<<6)
}
func (o *LEDC_Type) GetINT_ENA_DUTY_CHNG_END_CH2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40) >> 6
}
func (o *LEDC_Type) SetINT_ENA_DUTY_CHNG_END_CH3_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80)|value<<7)
}
func (o *LEDC_Type) GetINT_ENA_DUTY_CHNG_END_CH3_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80) >> 7
}
func (o *LEDC_Type) SetINT_ENA_DUTY_CHNG_END_CH4_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x100)|value<<8)
}
func (o *LEDC_Type) GetINT_ENA_DUTY_CHNG_END_CH4_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x100) >> 8
}
func (o *LEDC_Type) SetINT_ENA_DUTY_CHNG_END_CH5_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x200)|value<<9)
}
func (o *LEDC_Type) GetINT_ENA_DUTY_CHNG_END_CH5_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x200) >> 9
}
func (o *LEDC_Type) SetINT_ENA_OVF_CNT_CH0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x400)|value<<10)
}
func (o *LEDC_Type) GetINT_ENA_OVF_CNT_CH0_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x400) >> 10
}
func (o *LEDC_Type) SetINT_ENA_OVF_CNT_CH1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x800)|value<<11)
}
func (o *LEDC_Type) GetINT_ENA_OVF_CNT_CH1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x800) >> 11
}
func (o *LEDC_Type) SetINT_ENA_OVF_CNT_CH2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1000)|value<<12)
}
func (o *LEDC_Type) GetINT_ENA_OVF_CNT_CH2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1000) >> 12
}
func (o *LEDC_Type) SetINT_ENA_OVF_CNT_CH3_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2000)|value<<13)
}
func (o *LEDC_Type) GetINT_ENA_OVF_CNT_CH3_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2000) >> 13
}
func (o *LEDC_Type) SetINT_ENA_OVF_CNT_CH4_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4000)|value<<14)
}
func (o *LEDC_Type) GetINT_ENA_OVF_CNT_CH4_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4000) >> 14
}
func (o *LEDC_Type) SetINT_ENA_OVF_CNT_CH5_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8000)|value<<15)
}
func (o *LEDC_Type) GetINT_ENA_OVF_CNT_CH5_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8000) >> 15
}

// LEDC.INT_CLR: Interrupt clear bits
func (o *LEDC_Type) SetINT_CLR_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *LEDC_Type) GetINT_CLR_OVF_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *LEDC_Type) SetINT_CLR_TIMER1_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *LEDC_Type) GetINT_CLR_TIMER1_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}
func (o *LEDC_Type) SetINT_CLR_TIMER2_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *LEDC_Type) GetINT_CLR_TIMER2_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4) >> 2
}
func (o *LEDC_Type) SetINT_CLR_TIMER3_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *LEDC_Type) GetINT_CLR_TIMER3_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8) >> 3
}
func (o *LEDC_Type) SetINT_CLR_DUTY_CHNG_END_CH0_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *LEDC_Type) GetINT_CLR_DUTY_CHNG_END_CH0_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10) >> 4
}
func (o *LEDC_Type) SetINT_CLR_DUTY_CHNG_END_CH1_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *LEDC_Type) GetINT_CLR_DUTY_CHNG_END_CH1_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20) >> 5
}
func (o *LEDC_Type) SetINT_CLR_DUTY_CHNG_END_CH2_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40)|value<<6)
}
func (o *LEDC_Type) GetINT_CLR_DUTY_CHNG_END_CH2_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40) >> 6
}
func (o *LEDC_Type) SetINT_CLR_DUTY_CHNG_END_CH3_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80)|value<<7)
}
func (o *LEDC_Type) GetINT_CLR_DUTY_CHNG_END_CH3_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80) >> 7
}
func (o *LEDC_Type) SetINT_CLR_DUTY_CHNG_END_CH4_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x100)|value<<8)
}
func (o *LEDC_Type) GetINT_CLR_DUTY_CHNG_END_CH4_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x100) >> 8
}
func (o *LEDC_Type) SetINT_CLR_DUTY_CHNG_END_CH5_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x200)|value<<9)
}
func (o *LEDC_Type) GetINT_CLR_DUTY_CHNG_END_CH5_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x200) >> 9
}
func (o *LEDC_Type) SetINT_CLR_OVF_CNT_CH0_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x400)|value<<10)
}
func (o *LEDC_Type) GetINT_CLR_OVF_CNT_CH0_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x400) >> 10
}
func (o *LEDC_Type) SetINT_CLR_OVF_CNT_CH1_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x800)|value<<11)
}
func (o *LEDC_Type) GetINT_CLR_OVF_CNT_CH1_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x800) >> 11
}
func (o *LEDC_Type) SetINT_CLR_OVF_CNT_CH2_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *LEDC_Type) GetINT_CLR_OVF_CNT_CH2_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1000) >> 12
}
func (o *LEDC_Type) SetINT_CLR_OVF_CNT_CH3_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *LEDC_Type) GetINT_CLR_OVF_CNT_CH3_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2000) >> 13
}
func (o *LEDC_Type) SetINT_CLR_OVF_CNT_CH4_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *LEDC_Type) GetINT_CLR_OVF_CNT_CH4_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4000) >> 14
}
func (o *LEDC_Type) SetINT_CLR_OVF_CNT_CH5_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *LEDC_Type) GetINT_CLR_OVF_CNT_CH5_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8000) >> 15
}

// LEDC.CONF: Global ledc configuration register
func (o *LEDC_Type) SetCONF_APB_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x3)|value)
}
func (o *LEDC_Type) GetCONF_APB_CLK_SEL() uint32 {
	return volatile.LoadUint32(&o.CONF.Reg) & 0x3
}
func (o *LEDC_Type) SetCONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *LEDC_Type) GetCONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x80000000) >> 31
}

// LEDC.DATE: Version control register
func (o *LEDC_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *LEDC_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// MODEM_CLKRST Peripheral
type MODEM_CLKRST_Type struct {
	CLK_CONF            volatile.Register32 // 0x0
	MODEM_LP_TIMER_CONF volatile.Register32 // 0x4
	COEX_LP_CLK_CONF    volatile.Register32 // 0x8
	BLE_TIMER_CLK_CONF  volatile.Register32 // 0xC
	ETM_CLK_CONF        volatile.Register32 // 0x10
}

// MODEM_CLKRST.CLK_CONF
func (o *MODEM_CLKRST_Type) SetCLK_CONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x1)|value)
}
func (o *MODEM_CLKRST_Type) GetCLK_CONF_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x1
}

// MODEM_CLKRST.MODEM_LP_TIMER_CONF
func (o *MODEM_CLKRST_Type) SetMODEM_LP_TIMER_CONF_LP_TIMER_SEL_RTC_SLOW(value uint32) {
	volatile.StoreUint32(&o.MODEM_LP_TIMER_CONF.Reg, volatile.LoadUint32(&o.MODEM_LP_TIMER_CONF.Reg)&^(0x1)|value)
}
func (o *MODEM_CLKRST_Type) GetMODEM_LP_TIMER_CONF_LP_TIMER_SEL_RTC_SLOW() uint32 {
	return volatile.LoadUint32(&o.MODEM_LP_TIMER_CONF.Reg) & 0x1
}
func (o *MODEM_CLKRST_Type) SetMODEM_LP_TIMER_CONF_LP_TIMER_SEL_8M(value uint32) {
	volatile.StoreUint32(&o.MODEM_LP_TIMER_CONF.Reg, volatile.LoadUint32(&o.MODEM_LP_TIMER_CONF.Reg)&^(0x2)|value<<1)
}
func (o *MODEM_CLKRST_Type) GetMODEM_LP_TIMER_CONF_LP_TIMER_SEL_8M() uint32 {
	return (volatile.LoadUint32(&o.MODEM_LP_TIMER_CONF.Reg) & 0x2) >> 1
}
func (o *MODEM_CLKRST_Type) SetMODEM_LP_TIMER_CONF_LP_TIMER_SEL_XTAL(value uint32) {
	volatile.StoreUint32(&o.MODEM_LP_TIMER_CONF.Reg, volatile.LoadUint32(&o.MODEM_LP_TIMER_CONF.Reg)&^(0x4)|value<<2)
}
func (o *MODEM_CLKRST_Type) GetMODEM_LP_TIMER_CONF_LP_TIMER_SEL_XTAL() uint32 {
	return (volatile.LoadUint32(&o.MODEM_LP_TIMER_CONF.Reg) & 0x4) >> 2
}
func (o *MODEM_CLKRST_Type) SetMODEM_LP_TIMER_CONF_LP_TIMER_SEL_XTAL32K(value uint32) {
	volatile.StoreUint32(&o.MODEM_LP_TIMER_CONF.Reg, volatile.LoadUint32(&o.MODEM_LP_TIMER_CONF.Reg)&^(0x8)|value<<3)
}
func (o *MODEM_CLKRST_Type) GetMODEM_LP_TIMER_CONF_LP_TIMER_SEL_XTAL32K() uint32 {
	return (volatile.LoadUint32(&o.MODEM_LP_TIMER_CONF.Reg) & 0x8) >> 3
}
func (o *MODEM_CLKRST_Type) SetMODEM_LP_TIMER_CONF_LP_TIMER_CLK_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.MODEM_LP_TIMER_CONF.Reg, volatile.LoadUint32(&o.MODEM_LP_TIMER_CONF.Reg)&^(0xff0)|value<<4)
}
func (o *MODEM_CLKRST_Type) GetMODEM_LP_TIMER_CONF_LP_TIMER_CLK_DIV_NUM() uint32 {
	return (volatile.LoadUint32(&o.MODEM_LP_TIMER_CONF.Reg) & 0xff0) >> 4
}

// MODEM_CLKRST.COEX_LP_CLK_CONF
func (o *MODEM_CLKRST_Type) SetCOEX_LP_CLK_CONF_COEX_LPCLK_SEL_RTC_SLOW(value uint32) {
	volatile.StoreUint32(&o.COEX_LP_CLK_CONF.Reg, volatile.LoadUint32(&o.COEX_LP_CLK_CONF.Reg)&^(0x1)|value)
}
func (o *MODEM_CLKRST_Type) GetCOEX_LP_CLK_CONF_COEX_LPCLK_SEL_RTC_SLOW() uint32 {
	return volatile.LoadUint32(&o.COEX_LP_CLK_CONF.Reg) & 0x1
}
func (o *MODEM_CLKRST_Type) SetCOEX_LP_CLK_CONF_COEX_LPCLK_SEL_8M(value uint32) {
	volatile.StoreUint32(&o.COEX_LP_CLK_CONF.Reg, volatile.LoadUint32(&o.COEX_LP_CLK_CONF.Reg)&^(0x2)|value<<1)
}
func (o *MODEM_CLKRST_Type) GetCOEX_LP_CLK_CONF_COEX_LPCLK_SEL_8M() uint32 {
	return (volatile.LoadUint32(&o.COEX_LP_CLK_CONF.Reg) & 0x2) >> 1
}
func (o *MODEM_CLKRST_Type) SetCOEX_LP_CLK_CONF_COEX_LPCLK_SEL_XTAL(value uint32) {
	volatile.StoreUint32(&o.COEX_LP_CLK_CONF.Reg, volatile.LoadUint32(&o.COEX_LP_CLK_CONF.Reg)&^(0x4)|value<<2)
}
func (o *MODEM_CLKRST_Type) GetCOEX_LP_CLK_CONF_COEX_LPCLK_SEL_XTAL() uint32 {
	return (volatile.LoadUint32(&o.COEX_LP_CLK_CONF.Reg) & 0x4) >> 2
}
func (o *MODEM_CLKRST_Type) SetCOEX_LP_CLK_CONF_COEX_LPCLK_SEL_XTAL32K(value uint32) {
	volatile.StoreUint32(&o.COEX_LP_CLK_CONF.Reg, volatile.LoadUint32(&o.COEX_LP_CLK_CONF.Reg)&^(0x8)|value<<3)
}
func (o *MODEM_CLKRST_Type) GetCOEX_LP_CLK_CONF_COEX_LPCLK_SEL_XTAL32K() uint32 {
	return (volatile.LoadUint32(&o.COEX_LP_CLK_CONF.Reg) & 0x8) >> 3
}
func (o *MODEM_CLKRST_Type) SetCOEX_LP_CLK_CONF_COEX_LPCLK_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.COEX_LP_CLK_CONF.Reg, volatile.LoadUint32(&o.COEX_LP_CLK_CONF.Reg)&^(0xff0)|value<<4)
}
func (o *MODEM_CLKRST_Type) GetCOEX_LP_CLK_CONF_COEX_LPCLK_DIV_NUM() uint32 {
	return (volatile.LoadUint32(&o.COEX_LP_CLK_CONF.Reg) & 0xff0) >> 4
}

// MODEM_CLKRST.BLE_TIMER_CLK_CONF
func (o *MODEM_CLKRST_Type) SetBLE_TIMER_CLK_CONF_BLETIMER_USE_XTAL(value uint32) {
	volatile.StoreUint32(&o.BLE_TIMER_CLK_CONF.Reg, volatile.LoadUint32(&o.BLE_TIMER_CLK_CONF.Reg)&^(0x1)|value)
}
func (o *MODEM_CLKRST_Type) GetBLE_TIMER_CLK_CONF_BLETIMER_USE_XTAL() uint32 {
	return volatile.LoadUint32(&o.BLE_TIMER_CLK_CONF.Reg) & 0x1
}
func (o *MODEM_CLKRST_Type) SetBLE_TIMER_CLK_CONF_BLETIMER_CLK_IS_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.BLE_TIMER_CLK_CONF.Reg, volatile.LoadUint32(&o.BLE_TIMER_CLK_CONF.Reg)&^(0x2)|value<<1)
}
func (o *MODEM_CLKRST_Type) GetBLE_TIMER_CLK_CONF_BLETIMER_CLK_IS_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.BLE_TIMER_CLK_CONF.Reg) & 0x2) >> 1
}

// MODEM_CLKRST.ETM_CLK_CONF
func (o *MODEM_CLKRST_Type) SetETM_CLK_CONF_ETM_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_CLK_CONF.Reg, volatile.LoadUint32(&o.ETM_CLK_CONF.Reg)&^(0x1)|value)
}
func (o *MODEM_CLKRST_Type) GetETM_CLK_CONF_ETM_CLK_SEL() uint32 {
	return volatile.LoadUint32(&o.ETM_CLK_CONF.Reg) & 0x1
}
func (o *MODEM_CLKRST_Type) SetETM_CLK_CONF_ETM_CLK_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.ETM_CLK_CONF.Reg, volatile.LoadUint32(&o.ETM_CLK_CONF.Reg)&^(0x2)|value<<1)
}
func (o *MODEM_CLKRST_Type) GetETM_CLK_CONF_ETM_CLK_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.ETM_CLK_CONF.Reg) & 0x2) >> 1
}

// Hardware Random Number Generator
type RNG_Type struct {
	_    [176]byte
	DATA volatile.Register32 // 0xB0
}

// Real-Time Clock Control
type RTC_CNTL_Type struct {
	OPTIONS0            volatile.Register32 // 0x0
	SLP_TIMER0          volatile.Register32 // 0x4
	SLP_TIMER1          volatile.Register32 // 0x8
	TIME_UPDATE         volatile.Register32 // 0xC
	TIME_LOW0           volatile.Register32 // 0x10
	TIME_HIGH0          volatile.Register32 // 0x14
	STATE0              volatile.Register32 // 0x18
	TIMER1              volatile.Register32 // 0x1C
	TIMER2              volatile.Register32 // 0x20
	TIMER4              volatile.Register32 // 0x24
	TIMER5              volatile.Register32 // 0x28
	ANA_CONF            volatile.Register32 // 0x2C
	RESET_STATE         volatile.Register32 // 0x30
	WAKEUP_STATE        volatile.Register32 // 0x34
	INT_ENA_RTC         volatile.Register32 // 0x38
	INT_RAW_RTC         volatile.Register32 // 0x3C
	INT_ST_RTC          volatile.Register32 // 0x40
	INT_CLR_RTC         volatile.Register32 // 0x44
	STORE0              volatile.Register32 // 0x48
	STORE1              volatile.Register32 // 0x4C
	STORE2              volatile.Register32 // 0x50
	STORE3              volatile.Register32 // 0x54
	EXT_XTL_CONF        volatile.Register32 // 0x58
	EXT_WAKEUP_CONF     volatile.Register32 // 0x5C
	SLP_REJECT_CONF     volatile.Register32 // 0x60
	CPU_PERIOD_CONF     volatile.Register32 // 0x64
	CLK_CONF            volatile.Register32 // 0x68
	SLOW_CLK_CONF       volatile.Register32 // 0x6C
	BIAS_CONF           volatile.Register32 // 0x70
	RTC_CNTL            volatile.Register32 // 0x74
	PWC                 volatile.Register32 // 0x78
	DIG_PWC             volatile.Register32 // 0x7C
	DIG_ISO             volatile.Register32 // 0x80
	WDTCONFIG0          volatile.Register32 // 0x84
	WDTCONFIG1          volatile.Register32 // 0x88
	WDTCONFIG2          volatile.Register32 // 0x8C
	WDTCONFIG3          volatile.Register32 // 0x90
	WDTCONFIG4          volatile.Register32 // 0x94
	WDTFEED             volatile.Register32 // 0x98
	WDTWPROTECT         volatile.Register32 // 0x9C
	SWD_CONF            volatile.Register32 // 0xA0
	SWD_WPROTECT        volatile.Register32 // 0xA4
	SW_CPU_STALL        volatile.Register32 // 0xA8
	STORE4              volatile.Register32 // 0xAC
	STORE5              volatile.Register32 // 0xB0
	STORE6              volatile.Register32 // 0xB4
	STORE7              volatile.Register32 // 0xB8
	LOW_POWER_ST        volatile.Register32 // 0xBC
	DIAG0               volatile.Register32 // 0xC0
	PAD_HOLD            volatile.Register32 // 0xC4
	DIG_PAD_HOLD        volatile.Register32 // 0xC8
	BROWN_OUT           volatile.Register32 // 0xCC
	TIME_LOW1           volatile.Register32 // 0xD0
	TIME_HIGH1          volatile.Register32 // 0xD4
	USB_CONF            volatile.Register32 // 0xD8
	SLP_REJECT_CAUSE    volatile.Register32 // 0xDC
	OPTION1             volatile.Register32 // 0xE0
	SLP_WAKEUP_CAUSE    volatile.Register32 // 0xE4
	ULP_CP_TIMER_1      volatile.Register32 // 0xE8
	INT_ENA_RTC_W1TS    volatile.Register32 // 0xEC
	INT_ENA_RTC_W1TC    volatile.Register32 // 0xF0
	CNTL_RETENTION_CTRL volatile.Register32 // 0xF4
	FIB_SEL             volatile.Register32 // 0xF8
	CNTL_GPIO_WAKEUP    volatile.Register32 // 0xFC
	CNTL_DBG_SEL        volatile.Register32 // 0x100
	CNTL_DBG_MAP        volatile.Register32 // 0x104
	CNTL_SENSOR_CTRL    volatile.Register32 // 0x108
	CNTL_DBG_SAR_SEL    volatile.Register32 // 0x10C
	_                   [236]byte
	CNTL_DATE           volatile.Register32 // 0x1FC
}

// RTC_CNTL.OPTIONS0: register description
func (o *RTC_CNTL_Type) SetOPTIONS0_SW_STALL_PROCPU_C0(value uint32) {
	volatile.StoreUint32(&o.OPTIONS0.Reg, volatile.LoadUint32(&o.OPTIONS0.Reg)&^(0xc)|value<<2)
}
func (o *RTC_CNTL_Type) GetOPTIONS0_SW_STALL_PROCPU_C0() uint32 {
	return (volatile.LoadUint32(&o.OPTIONS0.Reg) & 0xc) >> 2
}
func (o *RTC_CNTL_Type) SetOPTIONS0_SW_PROCPU_RST(value uint32) {
	volatile.StoreUint32(&o.OPTIONS0.Reg, volatile.LoadUint32(&o.OPTIONS0.Reg)&^(0x20)|value<<5)
}
func (o *RTC_CNTL_Type) GetOPTIONS0_SW_PROCPU_RST() uint32 {
	return (volatile.LoadUint32(&o.OPTIONS0.Reg) & 0x20) >> 5
}
func (o *RTC_CNTL_Type) SetOPTIONS0_BB_I2C_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.OPTIONS0.Reg, volatile.LoadUint32(&o.OPTIONS0.Reg)&^(0x40)|value<<6)
}
func (o *RTC_CNTL_Type) GetOPTIONS0_BB_I2C_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.OPTIONS0.Reg) & 0x40) >> 6
}
func (o *RTC_CNTL_Type) SetOPTIONS0_BB_I2C_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.OPTIONS0.Reg, volatile.LoadUint32(&o.OPTIONS0.Reg)&^(0x80)|value<<7)
}
func (o *RTC_CNTL_Type) GetOPTIONS0_BB_I2C_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.OPTIONS0.Reg) & 0x80) >> 7
}
func (o *RTC_CNTL_Type) SetOPTIONS0_BBPLL_I2C_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.OPTIONS0.Reg, volatile.LoadUint32(&o.OPTIONS0.Reg)&^(0x100)|value<<8)
}
func (o *RTC_CNTL_Type) GetOPTIONS0_BBPLL_I2C_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.OPTIONS0.Reg) & 0x100) >> 8
}
func (o *RTC_CNTL_Type) SetOPTIONS0_BBPLL_I2C_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.OPTIONS0.Reg, volatile.LoadUint32(&o.OPTIONS0.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetOPTIONS0_BBPLL_I2C_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.OPTIONS0.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetOPTIONS0_BBPLL_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.OPTIONS0.Reg, volatile.LoadUint32(&o.OPTIONS0.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetOPTIONS0_BBPLL_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.OPTIONS0.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetOPTIONS0_BBPLL_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.OPTIONS0.Reg, volatile.LoadUint32(&o.OPTIONS0.Reg)&^(0x800)|value<<11)
}
func (o *RTC_CNTL_Type) GetOPTIONS0_BBPLL_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.OPTIONS0.Reg) & 0x800) >> 11
}
func (o *RTC_CNTL_Type) SetOPTIONS0_XTL_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.OPTIONS0.Reg, volatile.LoadUint32(&o.OPTIONS0.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_CNTL_Type) GetOPTIONS0_XTL_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.OPTIONS0.Reg) & 0x1000) >> 12
}
func (o *RTC_CNTL_Type) SetOPTIONS0_XTL_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.OPTIONS0.Reg, volatile.LoadUint32(&o.OPTIONS0.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_CNTL_Type) GetOPTIONS0_XTL_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.OPTIONS0.Reg) & 0x2000) >> 13
}
func (o *RTC_CNTL_Type) SetOPTIONS0_XTL_EN_WAIT(value uint32) {
	volatile.StoreUint32(&o.OPTIONS0.Reg, volatile.LoadUint32(&o.OPTIONS0.Reg)&^(0x3c000)|value<<14)
}
func (o *RTC_CNTL_Type) GetOPTIONS0_XTL_EN_WAIT() uint32 {
	return (volatile.LoadUint32(&o.OPTIONS0.Reg) & 0x3c000) >> 14
}
func (o *RTC_CNTL_Type) SetOPTIONS0_XTL_EXT_CTR_SEL(value uint32) {
	volatile.StoreUint32(&o.OPTIONS0.Reg, volatile.LoadUint32(&o.OPTIONS0.Reg)&^(0x700000)|value<<20)
}
func (o *RTC_CNTL_Type) GetOPTIONS0_XTL_EXT_CTR_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPTIONS0.Reg) & 0x700000) >> 20
}
func (o *RTC_CNTL_Type) SetOPTIONS0_ANALOG_FORCE_ISO(value uint32) {
	volatile.StoreUint32(&o.OPTIONS0.Reg, volatile.LoadUint32(&o.OPTIONS0.Reg)&^(0x2000000)|value<<25)
}
func (o *RTC_CNTL_Type) GetOPTIONS0_ANALOG_FORCE_ISO() uint32 {
	return (volatile.LoadUint32(&o.OPTIONS0.Reg) & 0x2000000) >> 25
}
func (o *RTC_CNTL_Type) SetOPTIONS0_ANALOG_FORCE_NOISO(value uint32) {
	volatile.StoreUint32(&o.OPTIONS0.Reg, volatile.LoadUint32(&o.OPTIONS0.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetOPTIONS0_ANALOG_FORCE_NOISO() uint32 {
	return (volatile.LoadUint32(&o.OPTIONS0.Reg) & 0x10000000) >> 28
}
func (o *RTC_CNTL_Type) SetOPTIONS0_DG_WRAP_FORCE_RST(value uint32) {
	volatile.StoreUint32(&o.OPTIONS0.Reg, volatile.LoadUint32(&o.OPTIONS0.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_CNTL_Type) GetOPTIONS0_DG_WRAP_FORCE_RST() uint32 {
	return (volatile.LoadUint32(&o.OPTIONS0.Reg) & 0x20000000) >> 29
}
func (o *RTC_CNTL_Type) SetOPTIONS0_DG_WRAP_FORCE_NORST(value uint32) {
	volatile.StoreUint32(&o.OPTIONS0.Reg, volatile.LoadUint32(&o.OPTIONS0.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetOPTIONS0_DG_WRAP_FORCE_NORST() uint32 {
	return (volatile.LoadUint32(&o.OPTIONS0.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetOPTIONS0_SW_SYS_RST(value uint32) {
	volatile.StoreUint32(&o.OPTIONS0.Reg, volatile.LoadUint32(&o.OPTIONS0.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetOPTIONS0_SW_SYS_RST() uint32 {
	return (volatile.LoadUint32(&o.OPTIONS0.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.SLP_TIMER0: register description
func (o *RTC_CNTL_Type) SetSLP_TIMER0(value uint32) {
	volatile.StoreUint32(&o.SLP_TIMER0.Reg, value)
}
func (o *RTC_CNTL_Type) GetSLP_TIMER0() uint32 {
	return volatile.LoadUint32(&o.SLP_TIMER0.Reg)
}

// RTC_CNTL.SLP_TIMER1: register description
func (o *RTC_CNTL_Type) SetSLP_TIMER1_SLP_VAL_HI(value uint32) {
	volatile.StoreUint32(&o.SLP_TIMER1.Reg, volatile.LoadUint32(&o.SLP_TIMER1.Reg)&^(0xffff)|value)
}
func (o *RTC_CNTL_Type) GetSLP_TIMER1_SLP_VAL_HI() uint32 {
	return volatile.LoadUint32(&o.SLP_TIMER1.Reg) & 0xffff
}
func (o *RTC_CNTL_Type) SetSLP_TIMER1_MAIN_TIMER_ALARM_EN(value uint32) {
	volatile.StoreUint32(&o.SLP_TIMER1.Reg, volatile.LoadUint32(&o.SLP_TIMER1.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_CNTL_Type) GetSLP_TIMER1_MAIN_TIMER_ALARM_EN() uint32 {
	return (volatile.LoadUint32(&o.SLP_TIMER1.Reg) & 0x10000) >> 16
}

// RTC_CNTL.TIME_UPDATE: register description
func (o *RTC_CNTL_Type) SetTIME_UPDATE_TIMER_SYS_STALL(value uint32) {
	volatile.StoreUint32(&o.TIME_UPDATE.Reg, volatile.LoadUint32(&o.TIME_UPDATE.Reg)&^(0x8000000)|value<<27)
}
func (o *RTC_CNTL_Type) GetTIME_UPDATE_TIMER_SYS_STALL() uint32 {
	return (volatile.LoadUint32(&o.TIME_UPDATE.Reg) & 0x8000000) >> 27
}
func (o *RTC_CNTL_Type) SetTIME_UPDATE_TIMER_XTL_OFF(value uint32) {
	volatile.StoreUint32(&o.TIME_UPDATE.Reg, volatile.LoadUint32(&o.TIME_UPDATE.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetTIME_UPDATE_TIMER_XTL_OFF() uint32 {
	return (volatile.LoadUint32(&o.TIME_UPDATE.Reg) & 0x10000000) >> 28
}
func (o *RTC_CNTL_Type) SetTIME_UPDATE_TIMER_SYS_RST(value uint32) {
	volatile.StoreUint32(&o.TIME_UPDATE.Reg, volatile.LoadUint32(&o.TIME_UPDATE.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_CNTL_Type) GetTIME_UPDATE_TIMER_SYS_RST() uint32 {
	return (volatile.LoadUint32(&o.TIME_UPDATE.Reg) & 0x20000000) >> 29
}
func (o *RTC_CNTL_Type) SetTIME_UPDATE(value uint32) {
	volatile.StoreUint32(&o.TIME_UPDATE.Reg, volatile.LoadUint32(&o.TIME_UPDATE.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetTIME_UPDATE() uint32 {
	return (volatile.LoadUint32(&o.TIME_UPDATE.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.TIME_LOW0: register description
func (o *RTC_CNTL_Type) SetTIME_LOW0(value uint32) {
	volatile.StoreUint32(&o.TIME_LOW0.Reg, value)
}
func (o *RTC_CNTL_Type) GetTIME_LOW0() uint32 {
	return volatile.LoadUint32(&o.TIME_LOW0.Reg)
}

// RTC_CNTL.TIME_HIGH0: register description
func (o *RTC_CNTL_Type) SetTIME_HIGH0_TIMER_VALUE0_HIGH(value uint32) {
	volatile.StoreUint32(&o.TIME_HIGH0.Reg, volatile.LoadUint32(&o.TIME_HIGH0.Reg)&^(0xffff)|value)
}
func (o *RTC_CNTL_Type) GetTIME_HIGH0_TIMER_VALUE0_HIGH() uint32 {
	return volatile.LoadUint32(&o.TIME_HIGH0.Reg) & 0xffff
}

// RTC_CNTL.STATE0: register description
func (o *RTC_CNTL_Type) SetSTATE0_SW_CPU_INT(value uint32) {
	volatile.StoreUint32(&o.STATE0.Reg, volatile.LoadUint32(&o.STATE0.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetSTATE0_SW_CPU_INT() uint32 {
	return volatile.LoadUint32(&o.STATE0.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetSTATE0_SLP_REJECT_CAUSE_CLR(value uint32) {
	volatile.StoreUint32(&o.STATE0.Reg, volatile.LoadUint32(&o.STATE0.Reg)&^(0x2)|value<<1)
}
func (o *RTC_CNTL_Type) GetSTATE0_SLP_REJECT_CAUSE_CLR() uint32 {
	return (volatile.LoadUint32(&o.STATE0.Reg) & 0x2) >> 1
}
func (o *RTC_CNTL_Type) SetSTATE0_APB2RTC_BRIDGE_SEL(value uint32) {
	volatile.StoreUint32(&o.STATE0.Reg, volatile.LoadUint32(&o.STATE0.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_CNTL_Type) GetSTATE0_APB2RTC_BRIDGE_SEL() uint32 {
	return (volatile.LoadUint32(&o.STATE0.Reg) & 0x400000) >> 22
}
func (o *RTC_CNTL_Type) SetSTATE0_SDIO_ACTIVE_IND(value uint32) {
	volatile.StoreUint32(&o.STATE0.Reg, volatile.LoadUint32(&o.STATE0.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetSTATE0_SDIO_ACTIVE_IND() uint32 {
	return (volatile.LoadUint32(&o.STATE0.Reg) & 0x10000000) >> 28
}
func (o *RTC_CNTL_Type) SetSTATE0_SLP_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.STATE0.Reg, volatile.LoadUint32(&o.STATE0.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_CNTL_Type) GetSTATE0_SLP_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.STATE0.Reg) & 0x20000000) >> 29
}
func (o *RTC_CNTL_Type) SetSTATE0_SLP_REJECT(value uint32) {
	volatile.StoreUint32(&o.STATE0.Reg, volatile.LoadUint32(&o.STATE0.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetSTATE0_SLP_REJECT() uint32 {
	return (volatile.LoadUint32(&o.STATE0.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetSTATE0_SLEEP_EN(value uint32) {
	volatile.StoreUint32(&o.STATE0.Reg, volatile.LoadUint32(&o.STATE0.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetSTATE0_SLEEP_EN() uint32 {
	return (volatile.LoadUint32(&o.STATE0.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.TIMER1: register description
func (o *RTC_CNTL_Type) SetTIMER1_CPU_STALL_EN(value uint32) {
	volatile.StoreUint32(&o.TIMER1.Reg, volatile.LoadUint32(&o.TIMER1.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetTIMER1_CPU_STALL_EN() uint32 {
	return volatile.LoadUint32(&o.TIMER1.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetTIMER1_CPU_STALL_WAIT(value uint32) {
	volatile.StoreUint32(&o.TIMER1.Reg, volatile.LoadUint32(&o.TIMER1.Reg)&^(0x3e)|value<<1)
}
func (o *RTC_CNTL_Type) GetTIMER1_CPU_STALL_WAIT() uint32 {
	return (volatile.LoadUint32(&o.TIMER1.Reg) & 0x3e) >> 1
}
func (o *RTC_CNTL_Type) SetTIMER1_CK8M_WAIT(value uint32) {
	volatile.StoreUint32(&o.TIMER1.Reg, volatile.LoadUint32(&o.TIMER1.Reg)&^(0x3fc0)|value<<6)
}
func (o *RTC_CNTL_Type) GetTIMER1_CK8M_WAIT() uint32 {
	return (volatile.LoadUint32(&o.TIMER1.Reg) & 0x3fc0) >> 6
}
func (o *RTC_CNTL_Type) SetTIMER1_XTL_BUF_WAIT(value uint32) {
	volatile.StoreUint32(&o.TIMER1.Reg, volatile.LoadUint32(&o.TIMER1.Reg)&^(0xffc000)|value<<14)
}
func (o *RTC_CNTL_Type) GetTIMER1_XTL_BUF_WAIT() uint32 {
	return (volatile.LoadUint32(&o.TIMER1.Reg) & 0xffc000) >> 14
}
func (o *RTC_CNTL_Type) SetTIMER1_PLL_BUF_WAIT(value uint32) {
	volatile.StoreUint32(&o.TIMER1.Reg, volatile.LoadUint32(&o.TIMER1.Reg)&^(0xff000000)|value<<24)
}
func (o *RTC_CNTL_Type) GetTIMER1_PLL_BUF_WAIT() uint32 {
	return (volatile.LoadUint32(&o.TIMER1.Reg) & 0xff000000) >> 24
}

// RTC_CNTL.TIMER2: register description
func (o *RTC_CNTL_Type) SetTIMER2_MIN_TIME_CK8M_OFF(value uint32) {
	volatile.StoreUint32(&o.TIMER2.Reg, volatile.LoadUint32(&o.TIMER2.Reg)&^(0xff000000)|value<<24)
}
func (o *RTC_CNTL_Type) GetTIMER2_MIN_TIME_CK8M_OFF() uint32 {
	return (volatile.LoadUint32(&o.TIMER2.Reg) & 0xff000000) >> 24
}

// RTC_CNTL.TIMER4: register description
func (o *RTC_CNTL_Type) SetTIMER4_DG_WRAP_WAIT_TIMER(value uint32) {
	volatile.StoreUint32(&o.TIMER4.Reg, volatile.LoadUint32(&o.TIMER4.Reg)&^(0x1ff0000)|value<<16)
}
func (o *RTC_CNTL_Type) GetTIMER4_DG_WRAP_WAIT_TIMER() uint32 {
	return (volatile.LoadUint32(&o.TIMER4.Reg) & 0x1ff0000) >> 16
}
func (o *RTC_CNTL_Type) SetTIMER4_DG_WRAP_POWERUP_TIMER(value uint32) {
	volatile.StoreUint32(&o.TIMER4.Reg, volatile.LoadUint32(&o.TIMER4.Reg)&^(0xfe000000)|value<<25)
}
func (o *RTC_CNTL_Type) GetTIMER4_DG_WRAP_POWERUP_TIMER() uint32 {
	return (volatile.LoadUint32(&o.TIMER4.Reg) & 0xfe000000) >> 25
}

// RTC_CNTL.TIMER5: register description
func (o *RTC_CNTL_Type) SetTIMER5_MIN_SLP_VAL(value uint32) {
	volatile.StoreUint32(&o.TIMER5.Reg, volatile.LoadUint32(&o.TIMER5.Reg)&^(0xff00)|value<<8)
}
func (o *RTC_CNTL_Type) GetTIMER5_MIN_SLP_VAL() uint32 {
	return (volatile.LoadUint32(&o.TIMER5.Reg) & 0xff00) >> 8
}

// RTC_CNTL.ANA_CONF: register description
func (o *RTC_CNTL_Type) SetANA_CONF_I2C_RESET_POR_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.ANA_CONF.Reg, volatile.LoadUint32(&o.ANA_CONF.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_CNTL_Type) GetANA_CONF_I2C_RESET_POR_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.ANA_CONF.Reg) & 0x40000) >> 18
}
func (o *RTC_CNTL_Type) SetANA_CONF_I2C_RESET_POR_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.ANA_CONF.Reg, volatile.LoadUint32(&o.ANA_CONF.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_CNTL_Type) GetANA_CONF_I2C_RESET_POR_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.ANA_CONF.Reg) & 0x80000) >> 19
}
func (o *RTC_CNTL_Type) SetANA_CONF_SAR_I2C_PU(value uint32) {
	volatile.StoreUint32(&o.ANA_CONF.Reg, volatile.LoadUint32(&o.ANA_CONF.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_CNTL_Type) GetANA_CONF_SAR_I2C_PU() uint32 {
	return (volatile.LoadUint32(&o.ANA_CONF.Reg) & 0x400000) >> 22
}
func (o *RTC_CNTL_Type) SetANA_CONF_BBPLL_CAL_SLP_START(value uint32) {
	volatile.StoreUint32(&o.ANA_CONF.Reg, volatile.LoadUint32(&o.ANA_CONF.Reg)&^(0x2000000)|value<<25)
}
func (o *RTC_CNTL_Type) GetANA_CONF_BBPLL_CAL_SLP_START() uint32 {
	return (volatile.LoadUint32(&o.ANA_CONF.Reg) & 0x2000000) >> 25
}
func (o *RTC_CNTL_Type) SetANA_CONF_TXRF_I2C_PU(value uint32) {
	volatile.StoreUint32(&o.ANA_CONF.Reg, volatile.LoadUint32(&o.ANA_CONF.Reg)&^(0x8000000)|value<<27)
}
func (o *RTC_CNTL_Type) GetANA_CONF_TXRF_I2C_PU() uint32 {
	return (volatile.LoadUint32(&o.ANA_CONF.Reg) & 0x8000000) >> 27
}
func (o *RTC_CNTL_Type) SetANA_CONF_RFRX_PBUS_PU(value uint32) {
	volatile.StoreUint32(&o.ANA_CONF.Reg, volatile.LoadUint32(&o.ANA_CONF.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetANA_CONF_RFRX_PBUS_PU() uint32 {
	return (volatile.LoadUint32(&o.ANA_CONF.Reg) & 0x10000000) >> 28
}
func (o *RTC_CNTL_Type) SetANA_CONF_CKGEN_I2C_PU(value uint32) {
	volatile.StoreUint32(&o.ANA_CONF.Reg, volatile.LoadUint32(&o.ANA_CONF.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetANA_CONF_CKGEN_I2C_PU() uint32 {
	return (volatile.LoadUint32(&o.ANA_CONF.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetANA_CONF_PLL_I2C_PU(value uint32) {
	volatile.StoreUint32(&o.ANA_CONF.Reg, volatile.LoadUint32(&o.ANA_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetANA_CONF_PLL_I2C_PU() uint32 {
	return (volatile.LoadUint32(&o.ANA_CONF.Reg) & 0x80000000) >> 31
}
func (o *RTC_CNTL_Type) SetANA_CONF_PLLA_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.ANA_CONF.Reg, volatile.LoadUint32(&o.ANA_CONF.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_CNTL_Type) GetANA_CONF_PLLA_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.ANA_CONF.Reg) & 0x800000) >> 23
}
func (o *RTC_CNTL_Type) SetANA_CONF_PLLA_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.ANA_CONF.Reg, volatile.LoadUint32(&o.ANA_CONF.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_CNTL_Type) GetANA_CONF_PLLA_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.ANA_CONF.Reg) & 0x1000000) >> 24
}

// RTC_CNTL.RESET_STATE: register description
func (o *RTC_CNTL_Type) SetRESET_STATE_RESET_CAUSE_PROCPU(value uint32) {
	volatile.StoreUint32(&o.RESET_STATE.Reg, volatile.LoadUint32(&o.RESET_STATE.Reg)&^(0x3f)|value)
}
func (o *RTC_CNTL_Type) GetRESET_STATE_RESET_CAUSE_PROCPU() uint32 {
	return volatile.LoadUint32(&o.RESET_STATE.Reg) & 0x3f
}
func (o *RTC_CNTL_Type) SetRESET_STATE_STAT_VECTOR_SEL_PROCPU(value uint32) {
	volatile.StoreUint32(&o.RESET_STATE.Reg, volatile.LoadUint32(&o.RESET_STATE.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_CNTL_Type) GetRESET_STATE_STAT_VECTOR_SEL_PROCPU() uint32 {
	return (volatile.LoadUint32(&o.RESET_STATE.Reg) & 0x2000) >> 13
}
func (o *RTC_CNTL_Type) SetRESET_STATE_OCD_HALT_ON_RESET_PROCPU(value uint32) {
	volatile.StoreUint32(&o.RESET_STATE.Reg, volatile.LoadUint32(&o.RESET_STATE.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_CNTL_Type) GetRESET_STATE_OCD_HALT_ON_RESET_PROCPU() uint32 {
	return (volatile.LoadUint32(&o.RESET_STATE.Reg) & 0x80000) >> 19
}
func (o *RTC_CNTL_Type) SetRESET_STATE_DRESET_MASK_PROCPU(value uint32) {
	volatile.StoreUint32(&o.RESET_STATE.Reg, volatile.LoadUint32(&o.RESET_STATE.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_CNTL_Type) GetRESET_STATE_DRESET_MASK_PROCPU() uint32 {
	return (volatile.LoadUint32(&o.RESET_STATE.Reg) & 0x100000) >> 20
}

// RTC_CNTL.WAKEUP_STATE: register description
func (o *RTC_CNTL_Type) SetWAKEUP_STATE_WAKEUP_ENA(value uint32) {
	volatile.StoreUint32(&o.WAKEUP_STATE.Reg, volatile.LoadUint32(&o.WAKEUP_STATE.Reg)&^(0xffff8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetWAKEUP_STATE_WAKEUP_ENA() uint32 {
	return (volatile.LoadUint32(&o.WAKEUP_STATE.Reg) & 0xffff8000) >> 15
}

// RTC_CNTL.INT_ENA_RTC: register description
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_SLP_WAKEUP_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_SLP_WAKEUP_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA_RTC.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_SLP_REJECT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC.Reg)&^(0x2)|value<<1)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_SLP_REJECT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC.Reg) & 0x2) >> 1
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_WDT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC.Reg)&^(0x8)|value<<3)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_WDT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC.Reg) & 0x8) >> 3
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_BROWN_OUT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_BROWN_OUT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_MAIN_TIMER_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_MAIN_TIMER_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_SWD_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_SWD_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_BBPLL_CAL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_BBPLL_CAL_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC.Reg) & 0x100000) >> 20
}

// RTC_CNTL.INT_RAW_RTC: register description
func (o *RTC_CNTL_Type) SetINT_RAW_RTC_SLP_WAKEUP_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_RTC.Reg, volatile.LoadUint32(&o.INT_RAW_RTC.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetINT_RAW_RTC_SLP_WAKEUP_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW_RTC.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetINT_RAW_RTC_SLP_REJECT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_RTC.Reg, volatile.LoadUint32(&o.INT_RAW_RTC.Reg)&^(0x2)|value<<1)
}
func (o *RTC_CNTL_Type) GetINT_RAW_RTC_SLP_REJECT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_RTC.Reg) & 0x2) >> 1
}
func (o *RTC_CNTL_Type) SetINT_RAW_RTC_WDT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_RTC.Reg, volatile.LoadUint32(&o.INT_RAW_RTC.Reg)&^(0x8)|value<<3)
}
func (o *RTC_CNTL_Type) GetINT_RAW_RTC_WDT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_RTC.Reg) & 0x8) >> 3
}
func (o *RTC_CNTL_Type) SetINT_RAW_RTC_BROWN_OUT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_RTC.Reg, volatile.LoadUint32(&o.INT_RAW_RTC.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetINT_RAW_RTC_BROWN_OUT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_RTC.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetINT_RAW_RTC_MAIN_TIMER_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_RTC.Reg, volatile.LoadUint32(&o.INT_RAW_RTC.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetINT_RAW_RTC_MAIN_TIMER_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_RTC.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetINT_RAW_RTC_SWD_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_RTC.Reg, volatile.LoadUint32(&o.INT_RAW_RTC.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetINT_RAW_RTC_SWD_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_RTC.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetINT_RAW_RTC_BBPLL_CAL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_RTC.Reg, volatile.LoadUint32(&o.INT_RAW_RTC.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_CNTL_Type) GetINT_RAW_RTC_BBPLL_CAL_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_RTC.Reg) & 0x100000) >> 20
}

// RTC_CNTL.INT_ST_RTC: register description
func (o *RTC_CNTL_Type) SetINT_ST_RTC_SLP_WAKEUP_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_RTC.Reg, volatile.LoadUint32(&o.INT_ST_RTC.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetINT_ST_RTC_SLP_WAKEUP_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST_RTC.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetINT_ST_RTC_SLP_REJECT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_RTC.Reg, volatile.LoadUint32(&o.INT_ST_RTC.Reg)&^(0x2)|value<<1)
}
func (o *RTC_CNTL_Type) GetINT_ST_RTC_SLP_REJECT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_RTC.Reg) & 0x2) >> 1
}
func (o *RTC_CNTL_Type) SetINT_ST_RTC_WDT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_RTC.Reg, volatile.LoadUint32(&o.INT_ST_RTC.Reg)&^(0x8)|value<<3)
}
func (o *RTC_CNTL_Type) GetINT_ST_RTC_WDT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_RTC.Reg) & 0x8) >> 3
}
func (o *RTC_CNTL_Type) SetINT_ST_RTC_BROWN_OUT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_RTC.Reg, volatile.LoadUint32(&o.INT_ST_RTC.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetINT_ST_RTC_BROWN_OUT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_RTC.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetINT_ST_RTC_MAIN_TIMER_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_RTC.Reg, volatile.LoadUint32(&o.INT_ST_RTC.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetINT_ST_RTC_MAIN_TIMER_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_RTC.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetINT_ST_RTC_SWD_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_RTC.Reg, volatile.LoadUint32(&o.INT_ST_RTC.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetINT_ST_RTC_SWD_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_RTC.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetINT_ST_RTC_BBPLL_CAL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_RTC.Reg, volatile.LoadUint32(&o.INT_ST_RTC.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_CNTL_Type) GetINT_ST_RTC_BBPLL_CAL_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_RTC.Reg) & 0x100000) >> 20
}

// RTC_CNTL.INT_CLR_RTC: register description
func (o *RTC_CNTL_Type) SetINT_CLR_RTC_SLP_WAKEUP_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_RTC.Reg, volatile.LoadUint32(&o.INT_CLR_RTC.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetINT_CLR_RTC_SLP_WAKEUP_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR_RTC.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetINT_CLR_RTC_SLP_REJECT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_RTC.Reg, volatile.LoadUint32(&o.INT_CLR_RTC.Reg)&^(0x2)|value<<1)
}
func (o *RTC_CNTL_Type) GetINT_CLR_RTC_SLP_REJECT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_RTC.Reg) & 0x2) >> 1
}
func (o *RTC_CNTL_Type) SetINT_CLR_RTC_WDT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_RTC.Reg, volatile.LoadUint32(&o.INT_CLR_RTC.Reg)&^(0x8)|value<<3)
}
func (o *RTC_CNTL_Type) GetINT_CLR_RTC_WDT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_RTC.Reg) & 0x8) >> 3
}
func (o *RTC_CNTL_Type) SetINT_CLR_RTC_BROWN_OUT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_RTC.Reg, volatile.LoadUint32(&o.INT_CLR_RTC.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetINT_CLR_RTC_BROWN_OUT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_RTC.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetINT_CLR_RTC_MAIN_TIMER_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_RTC.Reg, volatile.LoadUint32(&o.INT_CLR_RTC.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetINT_CLR_RTC_MAIN_TIMER_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_RTC.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetINT_CLR_RTC_SWD_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_RTC.Reg, volatile.LoadUint32(&o.INT_CLR_RTC.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetINT_CLR_RTC_SWD_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_RTC.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetINT_CLR_RTC_BBPLL_CAL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_RTC.Reg, volatile.LoadUint32(&o.INT_CLR_RTC.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_CNTL_Type) GetINT_CLR_RTC_BBPLL_CAL_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_RTC.Reg) & 0x100000) >> 20
}

// RTC_CNTL.STORE0: register description
func (o *RTC_CNTL_Type) SetSTORE0(value uint32) {
	volatile.StoreUint32(&o.STORE0.Reg, value)
}
func (o *RTC_CNTL_Type) GetSTORE0() uint32 {
	return volatile.LoadUint32(&o.STORE0.Reg)
}

// RTC_CNTL.STORE1: register description
func (o *RTC_CNTL_Type) SetSTORE1(value uint32) {
	volatile.StoreUint32(&o.STORE1.Reg, value)
}
func (o *RTC_CNTL_Type) GetSTORE1() uint32 {
	return volatile.LoadUint32(&o.STORE1.Reg)
}

// RTC_CNTL.STORE2: register description
func (o *RTC_CNTL_Type) SetSTORE2(value uint32) {
	volatile.StoreUint32(&o.STORE2.Reg, value)
}
func (o *RTC_CNTL_Type) GetSTORE2() uint32 {
	return volatile.LoadUint32(&o.STORE2.Reg)
}

// RTC_CNTL.STORE3: register description
func (o *RTC_CNTL_Type) SetSTORE3(value uint32) {
	volatile.StoreUint32(&o.STORE3.Reg, value)
}
func (o *RTC_CNTL_Type) GetSTORE3() uint32 {
	return volatile.LoadUint32(&o.STORE3.Reg)
}

// RTC_CNTL.EXT_XTL_CONF: register description
func (o *RTC_CNTL_Type) SetEXT_XTL_CONF_XTL_EXT_CTR_LV(value uint32) {
	volatile.StoreUint32(&o.EXT_XTL_CONF.Reg, volatile.LoadUint32(&o.EXT_XTL_CONF.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetEXT_XTL_CONF_XTL_EXT_CTR_LV() uint32 {
	return (volatile.LoadUint32(&o.EXT_XTL_CONF.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetEXT_XTL_CONF_XTL_EXT_CTR_EN(value uint32) {
	volatile.StoreUint32(&o.EXT_XTL_CONF.Reg, volatile.LoadUint32(&o.EXT_XTL_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetEXT_XTL_CONF_XTL_EXT_CTR_EN() uint32 {
	return (volatile.LoadUint32(&o.EXT_XTL_CONF.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.EXT_WAKEUP_CONF: register description
func (o *RTC_CNTL_Type) SetEXT_WAKEUP_CONF_GPIO_WAKEUP_FILTER(value uint32) {
	volatile.StoreUint32(&o.EXT_WAKEUP_CONF.Reg, volatile.LoadUint32(&o.EXT_WAKEUP_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetEXT_WAKEUP_CONF_GPIO_WAKEUP_FILTER() uint32 {
	return (volatile.LoadUint32(&o.EXT_WAKEUP_CONF.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.SLP_REJECT_CONF: register description
func (o *RTC_CNTL_Type) SetSLP_REJECT_CONF_SLEEP_REJECT_ENA(value uint32) {
	volatile.StoreUint32(&o.SLP_REJECT_CONF.Reg, volatile.LoadUint32(&o.SLP_REJECT_CONF.Reg)&^(0x3ffff000)|value<<12)
}
func (o *RTC_CNTL_Type) GetSLP_REJECT_CONF_SLEEP_REJECT_ENA() uint32 {
	return (volatile.LoadUint32(&o.SLP_REJECT_CONF.Reg) & 0x3ffff000) >> 12
}
func (o *RTC_CNTL_Type) SetSLP_REJECT_CONF_LIGHT_SLP_REJECT_EN(value uint32) {
	volatile.StoreUint32(&o.SLP_REJECT_CONF.Reg, volatile.LoadUint32(&o.SLP_REJECT_CONF.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetSLP_REJECT_CONF_LIGHT_SLP_REJECT_EN() uint32 {
	return (volatile.LoadUint32(&o.SLP_REJECT_CONF.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetSLP_REJECT_CONF_DEEP_SLP_REJECT_EN(value uint32) {
	volatile.StoreUint32(&o.SLP_REJECT_CONF.Reg, volatile.LoadUint32(&o.SLP_REJECT_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetSLP_REJECT_CONF_DEEP_SLP_REJECT_EN() uint32 {
	return (volatile.LoadUint32(&o.SLP_REJECT_CONF.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.CPU_PERIOD_CONF: register description
func (o *RTC_CNTL_Type) SetCPU_PERIOD_CONF_CPUSEL_CONF(value uint32) {
	volatile.StoreUint32(&o.CPU_PERIOD_CONF.Reg, volatile.LoadUint32(&o.CPU_PERIOD_CONF.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_CNTL_Type) GetCPU_PERIOD_CONF_CPUSEL_CONF() uint32 {
	return (volatile.LoadUint32(&o.CPU_PERIOD_CONF.Reg) & 0x20000000) >> 29
}
func (o *RTC_CNTL_Type) SetCPU_PERIOD_CONF_CPUPERIOD_SEL(value uint32) {
	volatile.StoreUint32(&o.CPU_PERIOD_CONF.Reg, volatile.LoadUint32(&o.CPU_PERIOD_CONF.Reg)&^(0xc0000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetCPU_PERIOD_CONF_CPUPERIOD_SEL() uint32 {
	return (volatile.LoadUint32(&o.CPU_PERIOD_CONF.Reg) & 0xc0000000) >> 30
}

// RTC_CNTL.CLK_CONF: register description
func (o *RTC_CNTL_Type) SetCLK_CONF_EFUSE_CLK_FORCE_GATING(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x2)|value<<1)
}
func (o *RTC_CNTL_Type) GetCLK_CONF_EFUSE_CLK_FORCE_GATING() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x2) >> 1
}
func (o *RTC_CNTL_Type) SetCLK_CONF_EFUSE_CLK_FORCE_NOGATING(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x4)|value<<2)
}
func (o *RTC_CNTL_Type) GetCLK_CONF_EFUSE_CLK_FORCE_NOGATING() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x4) >> 2
}
func (o *RTC_CNTL_Type) SetCLK_CONF_CK8M_DIV_SEL_VLD(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x8)|value<<3)
}
func (o *RTC_CNTL_Type) GetCLK_CONF_CK8M_DIV_SEL_VLD() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x8) >> 3
}
func (o *RTC_CNTL_Type) SetCLK_CONF_CK8M_DIV(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x30)|value<<4)
}
func (o *RTC_CNTL_Type) GetCLK_CONF_CK8M_DIV() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x30) >> 4
}
func (o *RTC_CNTL_Type) SetCLK_CONF_ENB_CK8M(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x40)|value<<6)
}
func (o *RTC_CNTL_Type) GetCLK_CONF_ENB_CK8M() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x40) >> 6
}
func (o *RTC_CNTL_Type) SetCLK_CONF_ENB_CK8M_DIV(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x80)|value<<7)
}
func (o *RTC_CNTL_Type) GetCLK_CONF_ENB_CK8M_DIV() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x80) >> 7
}
func (o *RTC_CNTL_Type) SetCLK_CONF_DIG_XTAL32K_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x100)|value<<8)
}
func (o *RTC_CNTL_Type) GetCLK_CONF_DIG_XTAL32K_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x100) >> 8
}
func (o *RTC_CNTL_Type) SetCLK_CONF_DIG_CLK8M_D256_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetCLK_CONF_DIG_CLK8M_D256_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetCLK_CONF_DIG_CLK8M_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetCLK_CONF_DIG_CLK8M_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetCLK_CONF_CK8M_DIV_SEL(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_CNTL_Type) GetCLK_CONF_CK8M_DIV_SEL() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x7000) >> 12
}
func (o *RTC_CNTL_Type) SetCLK_CONF_XTAL_FORCE_NOGATING(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetCLK_CONF_XTAL_FORCE_NOGATING() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetCLK_CONF_CK8M_FORCE_NOGATING(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_CNTL_Type) GetCLK_CONF_CK8M_FORCE_NOGATING() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x10000) >> 16
}
func (o *RTC_CNTL_Type) SetCLK_CONF_CK8M_DFREQ(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x1fe0000)|value<<17)
}
func (o *RTC_CNTL_Type) GetCLK_CONF_CK8M_DFREQ() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x1fe0000) >> 17
}
func (o *RTC_CNTL_Type) SetCLK_CONF_CK8M_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x2000000)|value<<25)
}
func (o *RTC_CNTL_Type) GetCLK_CONF_CK8M_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x2000000) >> 25
}
func (o *RTC_CNTL_Type) SetCLK_CONF_CK8M_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_CNTL_Type) GetCLK_CONF_CK8M_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x4000000) >> 26
}
func (o *RTC_CNTL_Type) SetCLK_CONF_XTAL_GLOBAL_FORCE_GATING(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x8000000)|value<<27)
}
func (o *RTC_CNTL_Type) GetCLK_CONF_XTAL_GLOBAL_FORCE_GATING() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x8000000) >> 27
}
func (o *RTC_CNTL_Type) SetCLK_CONF_XTAL_GLOBAL_FORCE_NOGATING(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetCLK_CONF_XTAL_GLOBAL_FORCE_NOGATING() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x10000000) >> 28
}
func (o *RTC_CNTL_Type) SetCLK_CONF_FAST_CLK_RTC_SEL(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_CNTL_Type) GetCLK_CONF_FAST_CLK_RTC_SEL() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x20000000) >> 29
}
func (o *RTC_CNTL_Type) SetCLK_CONF_ANA_CLK_RTC_SEL(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0xc0000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetCLK_CONF_ANA_CLK_RTC_SEL() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0xc0000000) >> 30
}

// RTC_CNTL.SLOW_CLK_CONF: register description
func (o *RTC_CNTL_Type) SetSLOW_CLK_CONF_ANA_CLK_DIV_VLD(value uint32) {
	volatile.StoreUint32(&o.SLOW_CLK_CONF.Reg, volatile.LoadUint32(&o.SLOW_CLK_CONF.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_CNTL_Type) GetSLOW_CLK_CONF_ANA_CLK_DIV_VLD() uint32 {
	return (volatile.LoadUint32(&o.SLOW_CLK_CONF.Reg) & 0x400000) >> 22
}
func (o *RTC_CNTL_Type) SetSLOW_CLK_CONF_ANA_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.SLOW_CLK_CONF.Reg, volatile.LoadUint32(&o.SLOW_CLK_CONF.Reg)&^(0x7f800000)|value<<23)
}
func (o *RTC_CNTL_Type) GetSLOW_CLK_CONF_ANA_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.SLOW_CLK_CONF.Reg) & 0x7f800000) >> 23
}
func (o *RTC_CNTL_Type) SetSLOW_CLK_CONF_SLOW_CLK_NEXT_EDGE(value uint32) {
	volatile.StoreUint32(&o.SLOW_CLK_CONF.Reg, volatile.LoadUint32(&o.SLOW_CLK_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetSLOW_CLK_CONF_SLOW_CLK_NEXT_EDGE() uint32 {
	return (volatile.LoadUint32(&o.SLOW_CLK_CONF.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.BIAS_CONF: register description
func (o *RTC_CNTL_Type) SetBIAS_CONF_DG_VDD_DRV_B_SLP(value uint32) {
	volatile.StoreUint32(&o.BIAS_CONF.Reg, volatile.LoadUint32(&o.BIAS_CONF.Reg)&^(0xff)|value)
}
func (o *RTC_CNTL_Type) GetBIAS_CONF_DG_VDD_DRV_B_SLP() uint32 {
	return volatile.LoadUint32(&o.BIAS_CONF.Reg) & 0xff
}
func (o *RTC_CNTL_Type) SetBIAS_CONF_DG_VDD_DRV_B_SLP_EN(value uint32) {
	volatile.StoreUint32(&o.BIAS_CONF.Reg, volatile.LoadUint32(&o.BIAS_CONF.Reg)&^(0x100)|value<<8)
}
func (o *RTC_CNTL_Type) GetBIAS_CONF_DG_VDD_DRV_B_SLP_EN() uint32 {
	return (volatile.LoadUint32(&o.BIAS_CONF.Reg) & 0x100) >> 8
}
func (o *RTC_CNTL_Type) SetBIAS_CONF_BIAS_BUF_IDLE(value uint32) {
	volatile.StoreUint32(&o.BIAS_CONF.Reg, volatile.LoadUint32(&o.BIAS_CONF.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetBIAS_CONF_BIAS_BUF_IDLE() uint32 {
	return (volatile.LoadUint32(&o.BIAS_CONF.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetBIAS_CONF_BIAS_BUF_WAKE(value uint32) {
	volatile.StoreUint32(&o.BIAS_CONF.Reg, volatile.LoadUint32(&o.BIAS_CONF.Reg)&^(0x800)|value<<11)
}
func (o *RTC_CNTL_Type) GetBIAS_CONF_BIAS_BUF_WAKE() uint32 {
	return (volatile.LoadUint32(&o.BIAS_CONF.Reg) & 0x800) >> 11
}
func (o *RTC_CNTL_Type) SetBIAS_CONF_BIAS_BUF_DEEP_SLP(value uint32) {
	volatile.StoreUint32(&o.BIAS_CONF.Reg, volatile.LoadUint32(&o.BIAS_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_CNTL_Type) GetBIAS_CONF_BIAS_BUF_DEEP_SLP() uint32 {
	return (volatile.LoadUint32(&o.BIAS_CONF.Reg) & 0x1000) >> 12
}
func (o *RTC_CNTL_Type) SetBIAS_CONF_BIAS_BUF_MONITOR(value uint32) {
	volatile.StoreUint32(&o.BIAS_CONF.Reg, volatile.LoadUint32(&o.BIAS_CONF.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_CNTL_Type) GetBIAS_CONF_BIAS_BUF_MONITOR() uint32 {
	return (volatile.LoadUint32(&o.BIAS_CONF.Reg) & 0x2000) >> 13
}
func (o *RTC_CNTL_Type) SetBIAS_CONF_PD_CUR_DEEP_SLP(value uint32) {
	volatile.StoreUint32(&o.BIAS_CONF.Reg, volatile.LoadUint32(&o.BIAS_CONF.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_CNTL_Type) GetBIAS_CONF_PD_CUR_DEEP_SLP() uint32 {
	return (volatile.LoadUint32(&o.BIAS_CONF.Reg) & 0x4000) >> 14
}
func (o *RTC_CNTL_Type) SetBIAS_CONF_PD_CUR_MONITOR(value uint32) {
	volatile.StoreUint32(&o.BIAS_CONF.Reg, volatile.LoadUint32(&o.BIAS_CONF.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetBIAS_CONF_PD_CUR_MONITOR() uint32 {
	return (volatile.LoadUint32(&o.BIAS_CONF.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetBIAS_CONF_BIAS_SLEEP_DEEP_SLP(value uint32) {
	volatile.StoreUint32(&o.BIAS_CONF.Reg, volatile.LoadUint32(&o.BIAS_CONF.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_CNTL_Type) GetBIAS_CONF_BIAS_SLEEP_DEEP_SLP() uint32 {
	return (volatile.LoadUint32(&o.BIAS_CONF.Reg) & 0x10000) >> 16
}
func (o *RTC_CNTL_Type) SetBIAS_CONF_BIAS_SLEEP_MONITOR(value uint32) {
	volatile.StoreUint32(&o.BIAS_CONF.Reg, volatile.LoadUint32(&o.BIAS_CONF.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_CNTL_Type) GetBIAS_CONF_BIAS_SLEEP_MONITOR() uint32 {
	return (volatile.LoadUint32(&o.BIAS_CONF.Reg) & 0x20000) >> 17
}
func (o *RTC_CNTL_Type) SetBIAS_CONF_DBG_ATTEN_DEEP_SLP(value uint32) {
	volatile.StoreUint32(&o.BIAS_CONF.Reg, volatile.LoadUint32(&o.BIAS_CONF.Reg)&^(0x3c0000)|value<<18)
}
func (o *RTC_CNTL_Type) GetBIAS_CONF_DBG_ATTEN_DEEP_SLP() uint32 {
	return (volatile.LoadUint32(&o.BIAS_CONF.Reg) & 0x3c0000) >> 18
}
func (o *RTC_CNTL_Type) SetBIAS_CONF_DBG_ATTEN_MONITOR(value uint32) {
	volatile.StoreUint32(&o.BIAS_CONF.Reg, volatile.LoadUint32(&o.BIAS_CONF.Reg)&^(0x3c00000)|value<<22)
}
func (o *RTC_CNTL_Type) GetBIAS_CONF_DBG_ATTEN_MONITOR() uint32 {
	return (volatile.LoadUint32(&o.BIAS_CONF.Reg) & 0x3c00000) >> 22
}
func (o *RTC_CNTL_Type) SetBIAS_CONF_DBG_ATTEN_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.BIAS_CONF.Reg, volatile.LoadUint32(&o.BIAS_CONF.Reg)&^(0x3c000000)|value<<26)
}
func (o *RTC_CNTL_Type) GetBIAS_CONF_DBG_ATTEN_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.BIAS_CONF.Reg) & 0x3c000000) >> 26
}

// RTC_CNTL.RTC_CNTL: register description
func (o *RTC_CNTL_Type) SetRTC_CNTL_DIG_REG_CAL_EN(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL.Reg, volatile.LoadUint32(&o.RTC_CNTL.Reg)&^(0x80)|value<<7)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_DIG_REG_CAL_EN() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL.Reg) & 0x80) >> 7
}
func (o *RTC_CNTL_Type) SetRTC_CNTL_SCK_DCAP(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL.Reg, volatile.LoadUint32(&o.RTC_CNTL.Reg)&^(0x3fc000)|value<<14)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_SCK_DCAP() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL.Reg) & 0x3fc000) >> 14
}
func (o *RTC_CNTL_Type) SetRTC_CNTL_REGULATOR_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL.Reg, volatile.LoadUint32(&o.RTC_CNTL.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_REGULATOR_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetRTC_CNTL_REGULATOR_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.RTC_CNTL.Reg, volatile.LoadUint32(&o.RTC_CNTL.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetRTC_CNTL_REGULATOR_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.RTC_CNTL.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.PWC: register description
func (o *RTC_CNTL_Type) SetPWC_PAD_FORCE_HOLD(value uint32) {
	volatile.StoreUint32(&o.PWC.Reg, volatile.LoadUint32(&o.PWC.Reg)&^(0x200000)|value<<21)
}
func (o *RTC_CNTL_Type) GetPWC_PAD_FORCE_HOLD() uint32 {
	return (volatile.LoadUint32(&o.PWC.Reg) & 0x200000) >> 21
}

// RTC_CNTL.DIG_PWC: register description
func (o *RTC_CNTL_Type) SetDIG_PWC_VDD_SPI_PWR_DRV(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x3)|value)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_VDD_SPI_PWR_DRV() uint32 {
	return volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x3
}
func (o *RTC_CNTL_Type) SetDIG_PWC_VDD_SPI_PWR_FORCE(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x4)|value<<2)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_VDD_SPI_PWR_FORCE() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x4) >> 2
}
func (o *RTC_CNTL_Type) SetDIG_PWC_VDD_SPI_PD_EN(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x8)|value<<3)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_VDD_SPI_PD_EN() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x8) >> 3
}
func (o *RTC_CNTL_Type) SetDIG_PWC_LSLP_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x10)|value<<4)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_LSLP_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x10) >> 4
}
func (o *RTC_CNTL_Type) SetDIG_PWC_LSLP_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x20)|value<<5)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_LSLP_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x20) >> 5
}
func (o *RTC_CNTL_Type) SetDIG_PWC_DG_WRAP_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_DG_WRAP_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x80000) >> 19
}
func (o *RTC_CNTL_Type) SetDIG_PWC_DG_WRAP_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_DG_WRAP_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x100000) >> 20
}
func (o *RTC_CNTL_Type) SetDIG_PWC_DG_WRAP_PD_EN(value uint32) {
	volatile.StoreUint32(&o.DIG_PWC.Reg, volatile.LoadUint32(&o.DIG_PWC.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetDIG_PWC_DG_WRAP_PD_EN() uint32 {
	return (volatile.LoadUint32(&o.DIG_PWC.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.DIG_ISO: register description
func (o *RTC_CNTL_Type) SetDIG_ISO_FORCE_OFF(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x80)|value<<7)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_FORCE_OFF() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x80) >> 7
}
func (o *RTC_CNTL_Type) SetDIG_ISO_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x100)|value<<8)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x100) >> 8
}
func (o *RTC_CNTL_Type) SetDIG_ISO_DG_PAD_AUTOHOLD(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_DG_PAD_AUTOHOLD() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetDIG_ISO_CLR_DG_PAD_AUTOHOLD(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_CLR_DG_PAD_AUTOHOLD() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetDIG_ISO_DG_PAD_AUTOHOLD_EN(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x800)|value<<11)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_DG_PAD_AUTOHOLD_EN() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x800) >> 11
}
func (o *RTC_CNTL_Type) SetDIG_ISO_DG_PAD_FORCE_NOISO(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_DG_PAD_FORCE_NOISO() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x1000) >> 12
}
func (o *RTC_CNTL_Type) SetDIG_ISO_DG_PAD_FORCE_ISO(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_DG_PAD_FORCE_ISO() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x2000) >> 13
}
func (o *RTC_CNTL_Type) SetDIG_ISO_DG_PAD_FORCE_UNHOLD(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_DG_PAD_FORCE_UNHOLD() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x4000) >> 14
}
func (o *RTC_CNTL_Type) SetDIG_ISO_DG_PAD_FORCE_HOLD(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_DG_PAD_FORCE_HOLD() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetDIG_ISO_DG_WRAP_FORCE_ISO(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_DG_WRAP_FORCE_ISO() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetDIG_ISO_DG_WRAP_FORCE_NOISO(value uint32) {
	volatile.StoreUint32(&o.DIG_ISO.Reg, volatile.LoadUint32(&o.DIG_ISO.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetDIG_ISO_DG_WRAP_FORCE_NOISO() uint32 {
	return (volatile.LoadUint32(&o.DIG_ISO.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.WDTCONFIG0: register description
func (o *RTC_CNTL_Type) SetWDTCONFIG0_WDT_CHIP_RESET_WIDTH(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0xff)|value)
}
func (o *RTC_CNTL_Type) GetWDTCONFIG0_WDT_CHIP_RESET_WIDTH() uint32 {
	return volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0xff
}
func (o *RTC_CNTL_Type) SetWDTCONFIG0_WDT_CHIP_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0x100)|value<<8)
}
func (o *RTC_CNTL_Type) GetWDTCONFIG0_WDT_CHIP_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0x100) >> 8
}
func (o *RTC_CNTL_Type) SetWDTCONFIG0_WDT_PAUSE_IN_SLP(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetWDTCONFIG0_WDT_PAUSE_IN_SLP() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetWDTCONFIG0_WDT_PROCPU_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0x800)|value<<11)
}
func (o *RTC_CNTL_Type) GetWDTCONFIG0_WDT_PROCPU_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0x800) >> 11
}
func (o *RTC_CNTL_Type) SetWDTCONFIG0_WDT_FLASHBOOT_MOD_EN(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_CNTL_Type) GetWDTCONFIG0_WDT_FLASHBOOT_MOD_EN() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0x1000) >> 12
}
func (o *RTC_CNTL_Type) SetWDTCONFIG0_WDT_SYS_RESET_LENGTH(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_CNTL_Type) GetWDTCONFIG0_WDT_SYS_RESET_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0xe000) >> 13
}
func (o *RTC_CNTL_Type) SetWDTCONFIG0_WDT_CPU_RESET_LENGTH(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0x70000)|value<<16)
}
func (o *RTC_CNTL_Type) GetWDTCONFIG0_WDT_CPU_RESET_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0x70000) >> 16
}
func (o *RTC_CNTL_Type) SetWDTCONFIG0_WDT_STG3(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0x380000)|value<<19)
}
func (o *RTC_CNTL_Type) GetWDTCONFIG0_WDT_STG3() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0x380000) >> 19
}
func (o *RTC_CNTL_Type) SetWDTCONFIG0_WDT_STG2(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0x1c00000)|value<<22)
}
func (o *RTC_CNTL_Type) GetWDTCONFIG0_WDT_STG2() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0x1c00000) >> 22
}
func (o *RTC_CNTL_Type) SetWDTCONFIG0_WDT_STG1(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0xe000000)|value<<25)
}
func (o *RTC_CNTL_Type) GetWDTCONFIG0_WDT_STG1() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0xe000000) >> 25
}
func (o *RTC_CNTL_Type) SetWDTCONFIG0_WDT_STG0(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0x70000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetWDTCONFIG0_WDT_STG0() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0x70000000) >> 28
}
func (o *RTC_CNTL_Type) SetWDTCONFIG0_WDT_EN(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetWDTCONFIG0_WDT_EN() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.WDTCONFIG1: register description
func (o *RTC_CNTL_Type) SetWDTCONFIG1(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG1.Reg, value)
}
func (o *RTC_CNTL_Type) GetWDTCONFIG1() uint32 {
	return volatile.LoadUint32(&o.WDTCONFIG1.Reg)
}

// RTC_CNTL.WDTCONFIG2: register description
func (o *RTC_CNTL_Type) SetWDTCONFIG2(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG2.Reg, value)
}
func (o *RTC_CNTL_Type) GetWDTCONFIG2() uint32 {
	return volatile.LoadUint32(&o.WDTCONFIG2.Reg)
}

// RTC_CNTL.WDTCONFIG3: register description
func (o *RTC_CNTL_Type) SetWDTCONFIG3(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG3.Reg, value)
}
func (o *RTC_CNTL_Type) GetWDTCONFIG3() uint32 {
	return volatile.LoadUint32(&o.WDTCONFIG3.Reg)
}

// RTC_CNTL.WDTCONFIG4: register description
func (o *RTC_CNTL_Type) SetWDTCONFIG4(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG4.Reg, value)
}
func (o *RTC_CNTL_Type) GetWDTCONFIG4() uint32 {
	return volatile.LoadUint32(&o.WDTCONFIG4.Reg)
}

// RTC_CNTL.WDTFEED: register description
func (o *RTC_CNTL_Type) SetWDTFEED_WDT_FEED(value uint32) {
	volatile.StoreUint32(&o.WDTFEED.Reg, volatile.LoadUint32(&o.WDTFEED.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetWDTFEED_WDT_FEED() uint32 {
	return (volatile.LoadUint32(&o.WDTFEED.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.WDTWPROTECT: register description
func (o *RTC_CNTL_Type) SetWDTWPROTECT(value uint32) {
	volatile.StoreUint32(&o.WDTWPROTECT.Reg, value)
}
func (o *RTC_CNTL_Type) GetWDTWPROTECT() uint32 {
	return volatile.LoadUint32(&o.WDTWPROTECT.Reg)
}

// RTC_CNTL.SWD_CONF: register description
func (o *RTC_CNTL_Type) SetSWD_CONF_SWD_RESET_FLAG(value uint32) {
	volatile.StoreUint32(&o.SWD_CONF.Reg, volatile.LoadUint32(&o.SWD_CONF.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetSWD_CONF_SWD_RESET_FLAG() uint32 {
	return volatile.LoadUint32(&o.SWD_CONF.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetSWD_CONF_SWD_FEED_INT(value uint32) {
	volatile.StoreUint32(&o.SWD_CONF.Reg, volatile.LoadUint32(&o.SWD_CONF.Reg)&^(0x2)|value<<1)
}
func (o *RTC_CNTL_Type) GetSWD_CONF_SWD_FEED_INT() uint32 {
	return (volatile.LoadUint32(&o.SWD_CONF.Reg) & 0x2) >> 1
}
func (o *RTC_CNTL_Type) SetSWD_CONF_SWD_BYPASS_RST(value uint32) {
	volatile.StoreUint32(&o.SWD_CONF.Reg, volatile.LoadUint32(&o.SWD_CONF.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_CNTL_Type) GetSWD_CONF_SWD_BYPASS_RST() uint32 {
	return (volatile.LoadUint32(&o.SWD_CONF.Reg) & 0x20000) >> 17
}
func (o *RTC_CNTL_Type) SetSWD_CONF_SWD_SIGNAL_WIDTH(value uint32) {
	volatile.StoreUint32(&o.SWD_CONF.Reg, volatile.LoadUint32(&o.SWD_CONF.Reg)&^(0xffc0000)|value<<18)
}
func (o *RTC_CNTL_Type) GetSWD_CONF_SWD_SIGNAL_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.SWD_CONF.Reg) & 0xffc0000) >> 18
}
func (o *RTC_CNTL_Type) SetSWD_CONF_SWD_RST_FLAG_CLR(value uint32) {
	volatile.StoreUint32(&o.SWD_CONF.Reg, volatile.LoadUint32(&o.SWD_CONF.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetSWD_CONF_SWD_RST_FLAG_CLR() uint32 {
	return (volatile.LoadUint32(&o.SWD_CONF.Reg) & 0x10000000) >> 28
}
func (o *RTC_CNTL_Type) SetSWD_CONF_SWD_FEED(value uint32) {
	volatile.StoreUint32(&o.SWD_CONF.Reg, volatile.LoadUint32(&o.SWD_CONF.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_CNTL_Type) GetSWD_CONF_SWD_FEED() uint32 {
	return (volatile.LoadUint32(&o.SWD_CONF.Reg) & 0x20000000) >> 29
}
func (o *RTC_CNTL_Type) SetSWD_CONF_SWD_DISABLE(value uint32) {
	volatile.StoreUint32(&o.SWD_CONF.Reg, volatile.LoadUint32(&o.SWD_CONF.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetSWD_CONF_SWD_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.SWD_CONF.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetSWD_CONF_SWD_AUTO_FEED_EN(value uint32) {
	volatile.StoreUint32(&o.SWD_CONF.Reg, volatile.LoadUint32(&o.SWD_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetSWD_CONF_SWD_AUTO_FEED_EN() uint32 {
	return (volatile.LoadUint32(&o.SWD_CONF.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.SWD_WPROTECT: register description
func (o *RTC_CNTL_Type) SetSWD_WPROTECT(value uint32) {
	volatile.StoreUint32(&o.SWD_WPROTECT.Reg, value)
}
func (o *RTC_CNTL_Type) GetSWD_WPROTECT() uint32 {
	return volatile.LoadUint32(&o.SWD_WPROTECT.Reg)
}

// RTC_CNTL.SW_CPU_STALL: register description
func (o *RTC_CNTL_Type) SetSW_CPU_STALL_SW_STALL_PROCPU_C1(value uint32) {
	volatile.StoreUint32(&o.SW_CPU_STALL.Reg, volatile.LoadUint32(&o.SW_CPU_STALL.Reg)&^(0xfc000000)|value<<26)
}
func (o *RTC_CNTL_Type) GetSW_CPU_STALL_SW_STALL_PROCPU_C1() uint32 {
	return (volatile.LoadUint32(&o.SW_CPU_STALL.Reg) & 0xfc000000) >> 26
}

// RTC_CNTL.STORE4: register description
func (o *RTC_CNTL_Type) SetSTORE4(value uint32) {
	volatile.StoreUint32(&o.STORE4.Reg, value)
}
func (o *RTC_CNTL_Type) GetSTORE4() uint32 {
	return volatile.LoadUint32(&o.STORE4.Reg)
}

// RTC_CNTL.STORE5: register description
func (o *RTC_CNTL_Type) SetSTORE5(value uint32) {
	volatile.StoreUint32(&o.STORE5.Reg, value)
}
func (o *RTC_CNTL_Type) GetSTORE5() uint32 {
	return volatile.LoadUint32(&o.STORE5.Reg)
}

// RTC_CNTL.STORE6: register description
func (o *RTC_CNTL_Type) SetSTORE6(value uint32) {
	volatile.StoreUint32(&o.STORE6.Reg, value)
}
func (o *RTC_CNTL_Type) GetSTORE6() uint32 {
	return volatile.LoadUint32(&o.STORE6.Reg)
}

// RTC_CNTL.STORE7: register description
func (o *RTC_CNTL_Type) SetSTORE7(value uint32) {
	volatile.StoreUint32(&o.STORE7.Reg, value)
}
func (o *RTC_CNTL_Type) GetSTORE7() uint32 {
	return volatile.LoadUint32(&o.STORE7.Reg)
}

// RTC_CNTL.LOW_POWER_ST: register description
func (o *RTC_CNTL_Type) SetLOW_POWER_ST_XPD_DIG(value uint32) {
	volatile.StoreUint32(&o.LOW_POWER_ST.Reg, volatile.LoadUint32(&o.LOW_POWER_ST.Reg)&^(0x100)|value<<8)
}
func (o *RTC_CNTL_Type) GetLOW_POWER_ST_XPD_DIG() uint32 {
	return (volatile.LoadUint32(&o.LOW_POWER_ST.Reg) & 0x100) >> 8
}
func (o *RTC_CNTL_Type) SetLOW_POWER_ST_TOUCH_STATE_START(value uint32) {
	volatile.StoreUint32(&o.LOW_POWER_ST.Reg, volatile.LoadUint32(&o.LOW_POWER_ST.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetLOW_POWER_ST_TOUCH_STATE_START() uint32 {
	return (volatile.LoadUint32(&o.LOW_POWER_ST.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetLOW_POWER_ST_TOUCH_STATE_SWITCH(value uint32) {
	volatile.StoreUint32(&o.LOW_POWER_ST.Reg, volatile.LoadUint32(&o.LOW_POWER_ST.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetLOW_POWER_ST_TOUCH_STATE_SWITCH() uint32 {
	return (volatile.LoadUint32(&o.LOW_POWER_ST.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetLOW_POWER_ST_TOUCH_STATE_SLP(value uint32) {
	volatile.StoreUint32(&o.LOW_POWER_ST.Reg, volatile.LoadUint32(&o.LOW_POWER_ST.Reg)&^(0x800)|value<<11)
}
func (o *RTC_CNTL_Type) GetLOW_POWER_ST_TOUCH_STATE_SLP() uint32 {
	return (volatile.LoadUint32(&o.LOW_POWER_ST.Reg) & 0x800) >> 11
}
func (o *RTC_CNTL_Type) SetLOW_POWER_ST_TOUCH_STATE_DONE(value uint32) {
	volatile.StoreUint32(&o.LOW_POWER_ST.Reg, volatile.LoadUint32(&o.LOW_POWER_ST.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_CNTL_Type) GetLOW_POWER_ST_TOUCH_STATE_DONE() uint32 {
	return (volatile.LoadUint32(&o.LOW_POWER_ST.Reg) & 0x1000) >> 12
}
func (o *RTC_CNTL_Type) SetLOW_POWER_ST_COCPU_STATE_START(value uint32) {
	volatile.StoreUint32(&o.LOW_POWER_ST.Reg, volatile.LoadUint32(&o.LOW_POWER_ST.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_CNTL_Type) GetLOW_POWER_ST_COCPU_STATE_START() uint32 {
	return (volatile.LoadUint32(&o.LOW_POWER_ST.Reg) & 0x2000) >> 13
}
func (o *RTC_CNTL_Type) SetLOW_POWER_ST_COCPU_STATE_SWITCH(value uint32) {
	volatile.StoreUint32(&o.LOW_POWER_ST.Reg, volatile.LoadUint32(&o.LOW_POWER_ST.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_CNTL_Type) GetLOW_POWER_ST_COCPU_STATE_SWITCH() uint32 {
	return (volatile.LoadUint32(&o.LOW_POWER_ST.Reg) & 0x4000) >> 14
}
func (o *RTC_CNTL_Type) SetLOW_POWER_ST_COCPU_STATE_SLP(value uint32) {
	volatile.StoreUint32(&o.LOW_POWER_ST.Reg, volatile.LoadUint32(&o.LOW_POWER_ST.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetLOW_POWER_ST_COCPU_STATE_SLP() uint32 {
	return (volatile.LoadUint32(&o.LOW_POWER_ST.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetLOW_POWER_ST_COCPU_STATE_DONE(value uint32) {
	volatile.StoreUint32(&o.LOW_POWER_ST.Reg, volatile.LoadUint32(&o.LOW_POWER_ST.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_CNTL_Type) GetLOW_POWER_ST_COCPU_STATE_DONE() uint32 {
	return (volatile.LoadUint32(&o.LOW_POWER_ST.Reg) & 0x10000) >> 16
}
func (o *RTC_CNTL_Type) SetLOW_POWER_ST_MAIN_STATE_XTAL_ISO(value uint32) {
	volatile.StoreUint32(&o.LOW_POWER_ST.Reg, volatile.LoadUint32(&o.LOW_POWER_ST.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_CNTL_Type) GetLOW_POWER_ST_MAIN_STATE_XTAL_ISO() uint32 {
	return (volatile.LoadUint32(&o.LOW_POWER_ST.Reg) & 0x20000) >> 17
}
func (o *RTC_CNTL_Type) SetLOW_POWER_ST_MAIN_STATE_PLL_ON(value uint32) {
	volatile.StoreUint32(&o.LOW_POWER_ST.Reg, volatile.LoadUint32(&o.LOW_POWER_ST.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_CNTL_Type) GetLOW_POWER_ST_MAIN_STATE_PLL_ON() uint32 {
	return (volatile.LoadUint32(&o.LOW_POWER_ST.Reg) & 0x40000) >> 18
}
func (o *RTC_CNTL_Type) SetLOW_POWER_ST_RDY_FOR_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.LOW_POWER_ST.Reg, volatile.LoadUint32(&o.LOW_POWER_ST.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_CNTL_Type) GetLOW_POWER_ST_RDY_FOR_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.LOW_POWER_ST.Reg) & 0x80000) >> 19
}
func (o *RTC_CNTL_Type) SetLOW_POWER_ST_MAIN_STATE_WAIT_END(value uint32) {
	volatile.StoreUint32(&o.LOW_POWER_ST.Reg, volatile.LoadUint32(&o.LOW_POWER_ST.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_CNTL_Type) GetLOW_POWER_ST_MAIN_STATE_WAIT_END() uint32 {
	return (volatile.LoadUint32(&o.LOW_POWER_ST.Reg) & 0x100000) >> 20
}
func (o *RTC_CNTL_Type) SetLOW_POWER_ST_IN_WAKEUP_STATE(value uint32) {
	volatile.StoreUint32(&o.LOW_POWER_ST.Reg, volatile.LoadUint32(&o.LOW_POWER_ST.Reg)&^(0x200000)|value<<21)
}
func (o *RTC_CNTL_Type) GetLOW_POWER_ST_IN_WAKEUP_STATE() uint32 {
	return (volatile.LoadUint32(&o.LOW_POWER_ST.Reg) & 0x200000) >> 21
}
func (o *RTC_CNTL_Type) SetLOW_POWER_ST_IN_LOW_POWER_STATE(value uint32) {
	volatile.StoreUint32(&o.LOW_POWER_ST.Reg, volatile.LoadUint32(&o.LOW_POWER_ST.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_CNTL_Type) GetLOW_POWER_ST_IN_LOW_POWER_STATE() uint32 {
	return (volatile.LoadUint32(&o.LOW_POWER_ST.Reg) & 0x400000) >> 22
}
func (o *RTC_CNTL_Type) SetLOW_POWER_ST_MAIN_STATE_IN_WAIT_8M(value uint32) {
	volatile.StoreUint32(&o.LOW_POWER_ST.Reg, volatile.LoadUint32(&o.LOW_POWER_ST.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_CNTL_Type) GetLOW_POWER_ST_MAIN_STATE_IN_WAIT_8M() uint32 {
	return (volatile.LoadUint32(&o.LOW_POWER_ST.Reg) & 0x800000) >> 23
}
func (o *RTC_CNTL_Type) SetLOW_POWER_ST_MAIN_STATE_IN_WAIT_PLL(value uint32) {
	volatile.StoreUint32(&o.LOW_POWER_ST.Reg, volatile.LoadUint32(&o.LOW_POWER_ST.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_CNTL_Type) GetLOW_POWER_ST_MAIN_STATE_IN_WAIT_PLL() uint32 {
	return (volatile.LoadUint32(&o.LOW_POWER_ST.Reg) & 0x1000000) >> 24
}
func (o *RTC_CNTL_Type) SetLOW_POWER_ST_MAIN_STATE_IN_WAIT_XTL(value uint32) {
	volatile.StoreUint32(&o.LOW_POWER_ST.Reg, volatile.LoadUint32(&o.LOW_POWER_ST.Reg)&^(0x2000000)|value<<25)
}
func (o *RTC_CNTL_Type) GetLOW_POWER_ST_MAIN_STATE_IN_WAIT_XTL() uint32 {
	return (volatile.LoadUint32(&o.LOW_POWER_ST.Reg) & 0x2000000) >> 25
}
func (o *RTC_CNTL_Type) SetLOW_POWER_ST_MAIN_STATE_IN_SLP(value uint32) {
	volatile.StoreUint32(&o.LOW_POWER_ST.Reg, volatile.LoadUint32(&o.LOW_POWER_ST.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_CNTL_Type) GetLOW_POWER_ST_MAIN_STATE_IN_SLP() uint32 {
	return (volatile.LoadUint32(&o.LOW_POWER_ST.Reg) & 0x4000000) >> 26
}
func (o *RTC_CNTL_Type) SetLOW_POWER_ST_MAIN_STATE_IN_IDLE(value uint32) {
	volatile.StoreUint32(&o.LOW_POWER_ST.Reg, volatile.LoadUint32(&o.LOW_POWER_ST.Reg)&^(0x8000000)|value<<27)
}
func (o *RTC_CNTL_Type) GetLOW_POWER_ST_MAIN_STATE_IN_IDLE() uint32 {
	return (volatile.LoadUint32(&o.LOW_POWER_ST.Reg) & 0x8000000) >> 27
}
func (o *RTC_CNTL_Type) SetLOW_POWER_ST_MAIN_STATE(value uint32) {
	volatile.StoreUint32(&o.LOW_POWER_ST.Reg, volatile.LoadUint32(&o.LOW_POWER_ST.Reg)&^(0xf0000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetLOW_POWER_ST_MAIN_STATE() uint32 {
	return (volatile.LoadUint32(&o.LOW_POWER_ST.Reg) & 0xf0000000) >> 28
}

// RTC_CNTL.DIAG0: register description
func (o *RTC_CNTL_Type) SetDIAG0(value uint32) {
	volatile.StoreUint32(&o.DIAG0.Reg, value)
}
func (o *RTC_CNTL_Type) GetDIAG0() uint32 {
	return volatile.LoadUint32(&o.DIAG0.Reg)
}

// RTC_CNTL.PAD_HOLD: register description
func (o *RTC_CNTL_Type) SetPAD_HOLD_GPIO_PIN0_HOLD(value uint32) {
	volatile.StoreUint32(&o.PAD_HOLD.Reg, volatile.LoadUint32(&o.PAD_HOLD.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetPAD_HOLD_GPIO_PIN0_HOLD() uint32 {
	return volatile.LoadUint32(&o.PAD_HOLD.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetPAD_HOLD_GPIO_PIN1_HOLD(value uint32) {
	volatile.StoreUint32(&o.PAD_HOLD.Reg, volatile.LoadUint32(&o.PAD_HOLD.Reg)&^(0x2)|value<<1)
}
func (o *RTC_CNTL_Type) GetPAD_HOLD_GPIO_PIN1_HOLD() uint32 {
	return (volatile.LoadUint32(&o.PAD_HOLD.Reg) & 0x2) >> 1
}
func (o *RTC_CNTL_Type) SetPAD_HOLD_GPIO_PIN2_HOLD(value uint32) {
	volatile.StoreUint32(&o.PAD_HOLD.Reg, volatile.LoadUint32(&o.PAD_HOLD.Reg)&^(0x4)|value<<2)
}
func (o *RTC_CNTL_Type) GetPAD_HOLD_GPIO_PIN2_HOLD() uint32 {
	return (volatile.LoadUint32(&o.PAD_HOLD.Reg) & 0x4) >> 2
}
func (o *RTC_CNTL_Type) SetPAD_HOLD_GPIO_PIN3_HOLD(value uint32) {
	volatile.StoreUint32(&o.PAD_HOLD.Reg, volatile.LoadUint32(&o.PAD_HOLD.Reg)&^(0x8)|value<<3)
}
func (o *RTC_CNTL_Type) GetPAD_HOLD_GPIO_PIN3_HOLD() uint32 {
	return (volatile.LoadUint32(&o.PAD_HOLD.Reg) & 0x8) >> 3
}
func (o *RTC_CNTL_Type) SetPAD_HOLD_GPIO_PIN4_HOLD(value uint32) {
	volatile.StoreUint32(&o.PAD_HOLD.Reg, volatile.LoadUint32(&o.PAD_HOLD.Reg)&^(0x10)|value<<4)
}
func (o *RTC_CNTL_Type) GetPAD_HOLD_GPIO_PIN4_HOLD() uint32 {
	return (volatile.LoadUint32(&o.PAD_HOLD.Reg) & 0x10) >> 4
}
func (o *RTC_CNTL_Type) SetPAD_HOLD_GPIO_PIN5_HOLD(value uint32) {
	volatile.StoreUint32(&o.PAD_HOLD.Reg, volatile.LoadUint32(&o.PAD_HOLD.Reg)&^(0x20)|value<<5)
}
func (o *RTC_CNTL_Type) GetPAD_HOLD_GPIO_PIN5_HOLD() uint32 {
	return (volatile.LoadUint32(&o.PAD_HOLD.Reg) & 0x20) >> 5
}

// RTC_CNTL.DIG_PAD_HOLD: register description
func (o *RTC_CNTL_Type) SetDIG_PAD_HOLD(value uint32) {
	volatile.StoreUint32(&o.DIG_PAD_HOLD.Reg, value)
}
func (o *RTC_CNTL_Type) GetDIG_PAD_HOLD() uint32 {
	return volatile.LoadUint32(&o.DIG_PAD_HOLD.Reg)
}

// RTC_CNTL.BROWN_OUT: register description
func (o *RTC_CNTL_Type) SetBROWN_OUT_BROWN_OUT_INT_WAIT(value uint32) {
	volatile.StoreUint32(&o.BROWN_OUT.Reg, volatile.LoadUint32(&o.BROWN_OUT.Reg)&^(0x3ff0)|value<<4)
}
func (o *RTC_CNTL_Type) GetBROWN_OUT_BROWN_OUT_INT_WAIT() uint32 {
	return (volatile.LoadUint32(&o.BROWN_OUT.Reg) & 0x3ff0) >> 4
}
func (o *RTC_CNTL_Type) SetBROWN_OUT_BROWN_OUT_CLOSE_FLASH_ENA(value uint32) {
	volatile.StoreUint32(&o.BROWN_OUT.Reg, volatile.LoadUint32(&o.BROWN_OUT.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_CNTL_Type) GetBROWN_OUT_BROWN_OUT_CLOSE_FLASH_ENA() uint32 {
	return (volatile.LoadUint32(&o.BROWN_OUT.Reg) & 0x4000) >> 14
}
func (o *RTC_CNTL_Type) SetBROWN_OUT_BROWN_OUT_PD_RF_ENA(value uint32) {
	volatile.StoreUint32(&o.BROWN_OUT.Reg, volatile.LoadUint32(&o.BROWN_OUT.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetBROWN_OUT_BROWN_OUT_PD_RF_ENA() uint32 {
	return (volatile.LoadUint32(&o.BROWN_OUT.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetBROWN_OUT_BROWN_OUT_RST_WAIT(value uint32) {
	volatile.StoreUint32(&o.BROWN_OUT.Reg, volatile.LoadUint32(&o.BROWN_OUT.Reg)&^(0x3ff0000)|value<<16)
}
func (o *RTC_CNTL_Type) GetBROWN_OUT_BROWN_OUT_RST_WAIT() uint32 {
	return (volatile.LoadUint32(&o.BROWN_OUT.Reg) & 0x3ff0000) >> 16
}
func (o *RTC_CNTL_Type) SetBROWN_OUT_BROWN_OUT_RST_ENA(value uint32) {
	volatile.StoreUint32(&o.BROWN_OUT.Reg, volatile.LoadUint32(&o.BROWN_OUT.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_CNTL_Type) GetBROWN_OUT_BROWN_OUT_RST_ENA() uint32 {
	return (volatile.LoadUint32(&o.BROWN_OUT.Reg) & 0x4000000) >> 26
}
func (o *RTC_CNTL_Type) SetBROWN_OUT_BROWN_OUT_RST_SEL(value uint32) {
	volatile.StoreUint32(&o.BROWN_OUT.Reg, volatile.LoadUint32(&o.BROWN_OUT.Reg)&^(0x8000000)|value<<27)
}
func (o *RTC_CNTL_Type) GetBROWN_OUT_BROWN_OUT_RST_SEL() uint32 {
	return (volatile.LoadUint32(&o.BROWN_OUT.Reg) & 0x8000000) >> 27
}
func (o *RTC_CNTL_Type) SetBROWN_OUT_BROWN_OUT_ANA_RST_EN(value uint32) {
	volatile.StoreUint32(&o.BROWN_OUT.Reg, volatile.LoadUint32(&o.BROWN_OUT.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetBROWN_OUT_BROWN_OUT_ANA_RST_EN() uint32 {
	return (volatile.LoadUint32(&o.BROWN_OUT.Reg) & 0x10000000) >> 28
}
func (o *RTC_CNTL_Type) SetBROWN_OUT_BROWN_OUT_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.BROWN_OUT.Reg, volatile.LoadUint32(&o.BROWN_OUT.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_CNTL_Type) GetBROWN_OUT_BROWN_OUT_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.BROWN_OUT.Reg) & 0x20000000) >> 29
}
func (o *RTC_CNTL_Type) SetBROWN_OUT_BROWN_OUT_ENA(value uint32) {
	volatile.StoreUint32(&o.BROWN_OUT.Reg, volatile.LoadUint32(&o.BROWN_OUT.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetBROWN_OUT_BROWN_OUT_ENA() uint32 {
	return (volatile.LoadUint32(&o.BROWN_OUT.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetBROWN_OUT_DET(value uint32) {
	volatile.StoreUint32(&o.BROWN_OUT.Reg, volatile.LoadUint32(&o.BROWN_OUT.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetBROWN_OUT_DET() uint32 {
	return (volatile.LoadUint32(&o.BROWN_OUT.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.TIME_LOW1: register description
func (o *RTC_CNTL_Type) SetTIME_LOW1(value uint32) {
	volatile.StoreUint32(&o.TIME_LOW1.Reg, value)
}
func (o *RTC_CNTL_Type) GetTIME_LOW1() uint32 {
	return volatile.LoadUint32(&o.TIME_LOW1.Reg)
}

// RTC_CNTL.TIME_HIGH1: register description
func (o *RTC_CNTL_Type) SetTIME_HIGH1_TIMER_VALUE1_HIGH(value uint32) {
	volatile.StoreUint32(&o.TIME_HIGH1.Reg, volatile.LoadUint32(&o.TIME_HIGH1.Reg)&^(0xffff)|value)
}
func (o *RTC_CNTL_Type) GetTIME_HIGH1_TIMER_VALUE1_HIGH() uint32 {
	return volatile.LoadUint32(&o.TIME_HIGH1.Reg) & 0xffff
}

// RTC_CNTL.USB_CONF: register description
func (o *RTC_CNTL_Type) SetUSB_CONF_IO_MUX_RESET_DISABLE(value uint32) {
	volatile.StoreUint32(&o.USB_CONF.Reg, volatile.LoadUint32(&o.USB_CONF.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_CNTL_Type) GetUSB_CONF_IO_MUX_RESET_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.USB_CONF.Reg) & 0x40000) >> 18
}

// RTC_CNTL.SLP_REJECT_CAUSE: register description
func (o *RTC_CNTL_Type) SetSLP_REJECT_CAUSE_REJECT_CAUSE(value uint32) {
	volatile.StoreUint32(&o.SLP_REJECT_CAUSE.Reg, volatile.LoadUint32(&o.SLP_REJECT_CAUSE.Reg)&^(0x3ffff)|value)
}
func (o *RTC_CNTL_Type) GetSLP_REJECT_CAUSE_REJECT_CAUSE() uint32 {
	return volatile.LoadUint32(&o.SLP_REJECT_CAUSE.Reg) & 0x3ffff
}

// RTC_CNTL.OPTION1: register description
func (o *RTC_CNTL_Type) SetOPTION1_FORCE_DOWNLOAD_BOOT(value uint32) {
	volatile.StoreUint32(&o.OPTION1.Reg, volatile.LoadUint32(&o.OPTION1.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetOPTION1_FORCE_DOWNLOAD_BOOT() uint32 {
	return volatile.LoadUint32(&o.OPTION1.Reg) & 0x1
}

// RTC_CNTL.SLP_WAKEUP_CAUSE: register description
func (o *RTC_CNTL_Type) SetSLP_WAKEUP_CAUSE_WAKEUP_CAUSE(value uint32) {
	volatile.StoreUint32(&o.SLP_WAKEUP_CAUSE.Reg, volatile.LoadUint32(&o.SLP_WAKEUP_CAUSE.Reg)&^(0x1ffff)|value)
}
func (o *RTC_CNTL_Type) GetSLP_WAKEUP_CAUSE_WAKEUP_CAUSE() uint32 {
	return volatile.LoadUint32(&o.SLP_WAKEUP_CAUSE.Reg) & 0x1ffff
}

// RTC_CNTL.ULP_CP_TIMER_1: register description
func (o *RTC_CNTL_Type) SetULP_CP_TIMER_1_ULP_CP_TIMER_SLP_CYCLE(value uint32) {
	volatile.StoreUint32(&o.ULP_CP_TIMER_1.Reg, volatile.LoadUint32(&o.ULP_CP_TIMER_1.Reg)&^(0xffffff00)|value<<8)
}
func (o *RTC_CNTL_Type) GetULP_CP_TIMER_1_ULP_CP_TIMER_SLP_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.ULP_CP_TIMER_1.Reg) & 0xffffff00) >> 8
}

// RTC_CNTL.INT_ENA_RTC_W1TS: register description
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TS_SLP_WAKEUP_INT_ENA_W1TS(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TS.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TS_SLP_WAKEUP_INT_ENA_W1TS() uint32 {
	return volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TS_SLP_REJECT_INT_ENA_W1TS(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TS.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg)&^(0x2)|value<<1)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TS_SLP_REJECT_INT_ENA_W1TS() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg) & 0x2) >> 1
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TS_WDT_INT_ENA_W1TS(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TS.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg)&^(0x8)|value<<3)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TS_WDT_INT_ENA_W1TS() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg) & 0x8) >> 3
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TS_BROWN_OUT_INT_ENA_W1TS(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TS.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TS_BROWN_OUT_INT_ENA_W1TS() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TS_MAIN_TIMER_INT_ENA_W1TS(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TS.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TS_MAIN_TIMER_INT_ENA_W1TS() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TS_SWD_INT_ENA_W1TS(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TS.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TS_SWD_INT_ENA_W1TS() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TS_BBPLL_CAL_INT_ENA_W1TS(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TS.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TS_BBPLL_CAL_INT_ENA_W1TS() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TS.Reg) & 0x100000) >> 20
}

// RTC_CNTL.INT_ENA_RTC_W1TC: register description
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TC_SLP_WAKEUP_INT_ENA_W1TC(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TC_SLP_WAKEUP_INT_ENA_W1TC() uint32 {
	return volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TC_SLP_REJECT_INT_ENA_W1TC(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg)&^(0x2)|value<<1)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TC_SLP_REJECT_INT_ENA_W1TC() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg) & 0x2) >> 1
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TC_WDT_INT_ENA_W1TC(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg)&^(0x8)|value<<3)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TC_WDT_INT_ENA_W1TC() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg) & 0x8) >> 3
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TC_BROWN_OUT_INT_ENA_W1TC(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg)&^(0x200)|value<<9)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TC_BROWN_OUT_INT_ENA_W1TC() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg) & 0x200) >> 9
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TC_MAIN_TIMER_INT_ENA_W1TC(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg)&^(0x400)|value<<10)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TC_MAIN_TIMER_INT_ENA_W1TC() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg) & 0x400) >> 10
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TC_SWD_INT_ENA_W1TC(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TC_SWD_INT_ENA_W1TC() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg) & 0x8000) >> 15
}
func (o *RTC_CNTL_Type) SetINT_ENA_RTC_W1TC_BBPLL_CAL_INT_ENA_W1TC(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_RTC_W1TC.Reg, volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_CNTL_Type) GetINT_ENA_RTC_W1TC_BBPLL_CAL_INT_ENA_W1TC() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_RTC_W1TC.Reg) & 0x100000) >> 20
}

// RTC_CNTL.CNTL_RETENTION_CTRL: register description
func (o *RTC_CNTL_Type) SetCNTL_RETENTION_CTRL_RETENTION_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CNTL_RETENTION_CTRL.Reg, volatile.LoadUint32(&o.CNTL_RETENTION_CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_CNTL_Type) GetCNTL_RETENTION_CTRL_RETENTION_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.CNTL_RETENTION_CTRL.Reg) & 0x40000) >> 18
}
func (o *RTC_CNTL_Type) SetCNTL_RETENTION_CTRL_RETENTION_DONE_WAIT(value uint32) {
	volatile.StoreUint32(&o.CNTL_RETENTION_CTRL.Reg, volatile.LoadUint32(&o.CNTL_RETENTION_CTRL.Reg)&^(0x380000)|value<<19)
}
func (o *RTC_CNTL_Type) GetCNTL_RETENTION_CTRL_RETENTION_DONE_WAIT() uint32 {
	return (volatile.LoadUint32(&o.CNTL_RETENTION_CTRL.Reg) & 0x380000) >> 19
}
func (o *RTC_CNTL_Type) SetCNTL_RETENTION_CTRL_RETENTION_CLKOFF_WAIT(value uint32) {
	volatile.StoreUint32(&o.CNTL_RETENTION_CTRL.Reg, volatile.LoadUint32(&o.CNTL_RETENTION_CTRL.Reg)&^(0x3c00000)|value<<22)
}
func (o *RTC_CNTL_Type) GetCNTL_RETENTION_CTRL_RETENTION_CLKOFF_WAIT() uint32 {
	return (volatile.LoadUint32(&o.CNTL_RETENTION_CTRL.Reg) & 0x3c00000) >> 22
}
func (o *RTC_CNTL_Type) SetCNTL_RETENTION_CTRL_RETENTION_EN(value uint32) {
	volatile.StoreUint32(&o.CNTL_RETENTION_CTRL.Reg, volatile.LoadUint32(&o.CNTL_RETENTION_CTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_CNTL_Type) GetCNTL_RETENTION_CTRL_RETENTION_EN() uint32 {
	return (volatile.LoadUint32(&o.CNTL_RETENTION_CTRL.Reg) & 0x4000000) >> 26
}
func (o *RTC_CNTL_Type) SetCNTL_RETENTION_CTRL_RETENTION_WAIT(value uint32) {
	volatile.StoreUint32(&o.CNTL_RETENTION_CTRL.Reg, volatile.LoadUint32(&o.CNTL_RETENTION_CTRL.Reg)&^(0xf8000000)|value<<27)
}
func (o *RTC_CNTL_Type) GetCNTL_RETENTION_CTRL_RETENTION_WAIT() uint32 {
	return (volatile.LoadUint32(&o.CNTL_RETENTION_CTRL.Reg) & 0xf8000000) >> 27
}

// RTC_CNTL.FIB_SEL: register description
func (o *RTC_CNTL_Type) SetFIB_SEL(value uint32) {
	volatile.StoreUint32(&o.FIB_SEL.Reg, volatile.LoadUint32(&o.FIB_SEL.Reg)&^(0x7)|value)
}
func (o *RTC_CNTL_Type) GetFIB_SEL() uint32 {
	return volatile.LoadUint32(&o.FIB_SEL.Reg) & 0x7
}

// RTC_CNTL.CNTL_GPIO_WAKEUP: register description
func (o *RTC_CNTL_Type) SetCNTL_GPIO_WAKEUP_GPIO_WAKEUP_STATUS(value uint32) {
	volatile.StoreUint32(&o.CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg)&^(0x3f)|value)
}
func (o *RTC_CNTL_Type) GetCNTL_GPIO_WAKEUP_GPIO_WAKEUP_STATUS() uint32 {
	return volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg) & 0x3f
}
func (o *RTC_CNTL_Type) SetCNTL_GPIO_WAKEUP_GPIO_WAKEUP_STATUS_CLR(value uint32) {
	volatile.StoreUint32(&o.CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg)&^(0x40)|value<<6)
}
func (o *RTC_CNTL_Type) GetCNTL_GPIO_WAKEUP_GPIO_WAKEUP_STATUS_CLR() uint32 {
	return (volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg) & 0x40) >> 6
}
func (o *RTC_CNTL_Type) SetCNTL_GPIO_WAKEUP_GPIO_PIN_CLK_GATE(value uint32) {
	volatile.StoreUint32(&o.CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg)&^(0x80)|value<<7)
}
func (o *RTC_CNTL_Type) GetCNTL_GPIO_WAKEUP_GPIO_PIN_CLK_GATE() uint32 {
	return (volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg) & 0x80) >> 7
}
func (o *RTC_CNTL_Type) SetCNTL_GPIO_WAKEUP_GPIO_PIN5_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg)&^(0x700)|value<<8)
}
func (o *RTC_CNTL_Type) GetCNTL_GPIO_WAKEUP_GPIO_PIN5_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg) & 0x700) >> 8
}
func (o *RTC_CNTL_Type) SetCNTL_GPIO_WAKEUP_GPIO_PIN4_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg)&^(0x3800)|value<<11)
}
func (o *RTC_CNTL_Type) GetCNTL_GPIO_WAKEUP_GPIO_PIN4_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg) & 0x3800) >> 11
}
func (o *RTC_CNTL_Type) SetCNTL_GPIO_WAKEUP_GPIO_PIN3_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg)&^(0x1c000)|value<<14)
}
func (o *RTC_CNTL_Type) GetCNTL_GPIO_WAKEUP_GPIO_PIN3_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg) & 0x1c000) >> 14
}
func (o *RTC_CNTL_Type) SetCNTL_GPIO_WAKEUP_GPIO_PIN2_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg)&^(0xe0000)|value<<17)
}
func (o *RTC_CNTL_Type) GetCNTL_GPIO_WAKEUP_GPIO_PIN2_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg) & 0xe0000) >> 17
}
func (o *RTC_CNTL_Type) SetCNTL_GPIO_WAKEUP_GPIO_PIN1_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg)&^(0x700000)|value<<20)
}
func (o *RTC_CNTL_Type) GetCNTL_GPIO_WAKEUP_GPIO_PIN1_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg) & 0x700000) >> 20
}
func (o *RTC_CNTL_Type) SetCNTL_GPIO_WAKEUP_GPIO_PIN0_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg)&^(0x3800000)|value<<23)
}
func (o *RTC_CNTL_Type) GetCNTL_GPIO_WAKEUP_GPIO_PIN0_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg) & 0x3800000) >> 23
}
func (o *RTC_CNTL_Type) SetCNTL_GPIO_WAKEUP_GPIO_PIN5_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_CNTL_Type) GetCNTL_GPIO_WAKEUP_GPIO_PIN5_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg) & 0x4000000) >> 26
}
func (o *RTC_CNTL_Type) SetCNTL_GPIO_WAKEUP_GPIO_PIN4_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg)&^(0x8000000)|value<<27)
}
func (o *RTC_CNTL_Type) GetCNTL_GPIO_WAKEUP_GPIO_PIN4_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg) & 0x8000000) >> 27
}
func (o *RTC_CNTL_Type) SetCNTL_GPIO_WAKEUP_GPIO_PIN3_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetCNTL_GPIO_WAKEUP_GPIO_PIN3_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg) & 0x10000000) >> 28
}
func (o *RTC_CNTL_Type) SetCNTL_GPIO_WAKEUP_GPIO_PIN2_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_CNTL_Type) GetCNTL_GPIO_WAKEUP_GPIO_PIN2_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg) & 0x20000000) >> 29
}
func (o *RTC_CNTL_Type) SetCNTL_GPIO_WAKEUP_GPIO_PIN1_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetCNTL_GPIO_WAKEUP_GPIO_PIN1_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetCNTL_GPIO_WAKEUP_GPIO_PIN0_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CNTL_GPIO_WAKEUP.Reg, volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetCNTL_GPIO_WAKEUP_GPIO_PIN0_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CNTL_GPIO_WAKEUP.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.CNTL_DBG_SEL: register description
func (o *RTC_CNTL_Type) SetCNTL_DBG_SEL_DEBUG_12M_NO_GATING(value uint32) {
	volatile.StoreUint32(&o.CNTL_DBG_SEL.Reg, volatile.LoadUint32(&o.CNTL_DBG_SEL.Reg)&^(0x2)|value<<1)
}
func (o *RTC_CNTL_Type) GetCNTL_DBG_SEL_DEBUG_12M_NO_GATING() uint32 {
	return (volatile.LoadUint32(&o.CNTL_DBG_SEL.Reg) & 0x2) >> 1
}
func (o *RTC_CNTL_Type) SetCNTL_DBG_SEL_DEBUG_BIT_SEL(value uint32) {
	volatile.StoreUint32(&o.CNTL_DBG_SEL.Reg, volatile.LoadUint32(&o.CNTL_DBG_SEL.Reg)&^(0x7c)|value<<2)
}
func (o *RTC_CNTL_Type) GetCNTL_DBG_SEL_DEBUG_BIT_SEL() uint32 {
	return (volatile.LoadUint32(&o.CNTL_DBG_SEL.Reg) & 0x7c) >> 2
}
func (o *RTC_CNTL_Type) SetCNTL_DBG_SEL_DEBUG_SEL0(value uint32) {
	volatile.StoreUint32(&o.CNTL_DBG_SEL.Reg, volatile.LoadUint32(&o.CNTL_DBG_SEL.Reg)&^(0xf80)|value<<7)
}
func (o *RTC_CNTL_Type) GetCNTL_DBG_SEL_DEBUG_SEL0() uint32 {
	return (volatile.LoadUint32(&o.CNTL_DBG_SEL.Reg) & 0xf80) >> 7
}
func (o *RTC_CNTL_Type) SetCNTL_DBG_SEL_DEBUG_SEL1(value uint32) {
	volatile.StoreUint32(&o.CNTL_DBG_SEL.Reg, volatile.LoadUint32(&o.CNTL_DBG_SEL.Reg)&^(0x1f000)|value<<12)
}
func (o *RTC_CNTL_Type) GetCNTL_DBG_SEL_DEBUG_SEL1() uint32 {
	return (volatile.LoadUint32(&o.CNTL_DBG_SEL.Reg) & 0x1f000) >> 12
}
func (o *RTC_CNTL_Type) SetCNTL_DBG_SEL_DEBUG_SEL2(value uint32) {
	volatile.StoreUint32(&o.CNTL_DBG_SEL.Reg, volatile.LoadUint32(&o.CNTL_DBG_SEL.Reg)&^(0x3e0000)|value<<17)
}
func (o *RTC_CNTL_Type) GetCNTL_DBG_SEL_DEBUG_SEL2() uint32 {
	return (volatile.LoadUint32(&o.CNTL_DBG_SEL.Reg) & 0x3e0000) >> 17
}
func (o *RTC_CNTL_Type) SetCNTL_DBG_SEL_DEBUG_SEL3(value uint32) {
	volatile.StoreUint32(&o.CNTL_DBG_SEL.Reg, volatile.LoadUint32(&o.CNTL_DBG_SEL.Reg)&^(0x7c00000)|value<<22)
}
func (o *RTC_CNTL_Type) GetCNTL_DBG_SEL_DEBUG_SEL3() uint32 {
	return (volatile.LoadUint32(&o.CNTL_DBG_SEL.Reg) & 0x7c00000) >> 22
}
func (o *RTC_CNTL_Type) SetCNTL_DBG_SEL_DEBUG_SEL4(value uint32) {
	volatile.StoreUint32(&o.CNTL_DBG_SEL.Reg, volatile.LoadUint32(&o.CNTL_DBG_SEL.Reg)&^(0xf8000000)|value<<27)
}
func (o *RTC_CNTL_Type) GetCNTL_DBG_SEL_DEBUG_SEL4() uint32 {
	return (volatile.LoadUint32(&o.CNTL_DBG_SEL.Reg) & 0xf8000000) >> 27
}

// RTC_CNTL.CNTL_DBG_MAP: register description
func (o *RTC_CNTL_Type) SetCNTL_DBG_MAP_GPIO_PIN5_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.CNTL_DBG_MAP.Reg, volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg)&^(0x4)|value<<2)
}
func (o *RTC_CNTL_Type) GetCNTL_DBG_MAP_GPIO_PIN5_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg) & 0x4) >> 2
}
func (o *RTC_CNTL_Type) SetCNTL_DBG_MAP_GPIO_PIN4_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.CNTL_DBG_MAP.Reg, volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg)&^(0x8)|value<<3)
}
func (o *RTC_CNTL_Type) GetCNTL_DBG_MAP_GPIO_PIN4_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg) & 0x8) >> 3
}
func (o *RTC_CNTL_Type) SetCNTL_DBG_MAP_GPIO_PIN3_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.CNTL_DBG_MAP.Reg, volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg)&^(0x10)|value<<4)
}
func (o *RTC_CNTL_Type) GetCNTL_DBG_MAP_GPIO_PIN3_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg) & 0x10) >> 4
}
func (o *RTC_CNTL_Type) SetCNTL_DBG_MAP_GPIO_PIN2_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.CNTL_DBG_MAP.Reg, volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg)&^(0x20)|value<<5)
}
func (o *RTC_CNTL_Type) GetCNTL_DBG_MAP_GPIO_PIN2_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg) & 0x20) >> 5
}
func (o *RTC_CNTL_Type) SetCNTL_DBG_MAP_GPIO_PIN1_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.CNTL_DBG_MAP.Reg, volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg)&^(0x40)|value<<6)
}
func (o *RTC_CNTL_Type) GetCNTL_DBG_MAP_GPIO_PIN1_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg) & 0x40) >> 6
}
func (o *RTC_CNTL_Type) SetCNTL_DBG_MAP_GPIO_PIN0_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.CNTL_DBG_MAP.Reg, volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg)&^(0x80)|value<<7)
}
func (o *RTC_CNTL_Type) GetCNTL_DBG_MAP_GPIO_PIN0_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg) & 0x80) >> 7
}
func (o *RTC_CNTL_Type) SetCNTL_DBG_MAP_GPIO_PIN5_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.CNTL_DBG_MAP.Reg, volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_CNTL_Type) GetCNTL_DBG_MAP_GPIO_PIN5_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg) & 0xf00) >> 8
}
func (o *RTC_CNTL_Type) SetCNTL_DBG_MAP_GPIO_PIN4_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.CNTL_DBG_MAP.Reg, volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg)&^(0xf000)|value<<12)
}
func (o *RTC_CNTL_Type) GetCNTL_DBG_MAP_GPIO_PIN4_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg) & 0xf000) >> 12
}
func (o *RTC_CNTL_Type) SetCNTL_DBG_MAP_GPIO_PIN3_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.CNTL_DBG_MAP.Reg, volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_CNTL_Type) GetCNTL_DBG_MAP_GPIO_PIN3_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg) & 0xf0000) >> 16
}
func (o *RTC_CNTL_Type) SetCNTL_DBG_MAP_GPIO_PIN2_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.CNTL_DBG_MAP.Reg, volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg)&^(0xf00000)|value<<20)
}
func (o *RTC_CNTL_Type) GetCNTL_DBG_MAP_GPIO_PIN2_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg) & 0xf00000) >> 20
}
func (o *RTC_CNTL_Type) SetCNTL_DBG_MAP_GPIO_PIN1_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.CNTL_DBG_MAP.Reg, volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_CNTL_Type) GetCNTL_DBG_MAP_GPIO_PIN1_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg) & 0xf000000) >> 24
}
func (o *RTC_CNTL_Type) SetCNTL_DBG_MAP_GPIO_PIN0_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.CNTL_DBG_MAP.Reg, volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg)&^(0xf0000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetCNTL_DBG_MAP_GPIO_PIN0_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.CNTL_DBG_MAP.Reg) & 0xf0000000) >> 28
}

// RTC_CNTL.CNTL_SENSOR_CTRL: register description
func (o *RTC_CNTL_Type) SetCNTL_SENSOR_CTRL_SAR2_PWDET_CCT(value uint32) {
	volatile.StoreUint32(&o.CNTL_SENSOR_CTRL.Reg, volatile.LoadUint32(&o.CNTL_SENSOR_CTRL.Reg)&^(0x38000000)|value<<27)
}
func (o *RTC_CNTL_Type) GetCNTL_SENSOR_CTRL_SAR2_PWDET_CCT() uint32 {
	return (volatile.LoadUint32(&o.CNTL_SENSOR_CTRL.Reg) & 0x38000000) >> 27
}
func (o *RTC_CNTL_Type) SetCNTL_SENSOR_CTRL_FORCE_XPD_SAR(value uint32) {
	volatile.StoreUint32(&o.CNTL_SENSOR_CTRL.Reg, volatile.LoadUint32(&o.CNTL_SENSOR_CTRL.Reg)&^(0xc0000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetCNTL_SENSOR_CTRL_FORCE_XPD_SAR() uint32 {
	return (volatile.LoadUint32(&o.CNTL_SENSOR_CTRL.Reg) & 0xc0000000) >> 30
}

// RTC_CNTL.CNTL_DBG_SAR_SEL: register description
func (o *RTC_CNTL_Type) SetCNTL_DBG_SAR_SEL_SAR_DEBUG_SEL(value uint32) {
	volatile.StoreUint32(&o.CNTL_DBG_SAR_SEL.Reg, volatile.LoadUint32(&o.CNTL_DBG_SAR_SEL.Reg)&^(0xf8000000)|value<<27)
}
func (o *RTC_CNTL_Type) GetCNTL_DBG_SAR_SEL_SAR_DEBUG_SEL() uint32 {
	return (volatile.LoadUint32(&o.CNTL_DBG_SAR_SEL.Reg) & 0xf8000000) >> 27
}

// RTC_CNTL.CNTL_DATE: register description
func (o *RTC_CNTL_Type) SetCNTL_DATE(value uint32) {
	volatile.StoreUint32(&o.CNTL_DATE.Reg, volatile.LoadUint32(&o.CNTL_DATE.Reg)&^(0xfffffff)|value)
}
func (o *RTC_CNTL_Type) GetCNTL_DATE() uint32 {
	return volatile.LoadUint32(&o.CNTL_DATE.Reg) & 0xfffffff
}

// SENSITIVE Peripheral
type SENSITIVE_Type struct {
	ROM_TABLE_LOCK          volatile.Register32 // 0x0
	ROM_TABLE               volatile.Register32 // 0x4
	APB_PERIPHERAL_ACCESS_0 volatile.Register32 // 0x8
	APB_PERIPHERAL_ACCESS_1 volatile.Register32 // 0xC
	INTERNAL_SRAM_USAGE_0   volatile.Register32 // 0x10
	INTERNAL_SRAM_USAGE_1   volatile.Register32 // 0x14
	INTERNAL_SRAM_USAGE_3   volatile.Register32 // 0x18
	CACHE_TAG_ACCESS_0      volatile.Register32 // 0x1C
	CACHE_TAG_ACCESS_1      volatile.Register32 // 0x20
	CACHE_MMU_ACCESS_0      volatile.Register32 // 0x24
	CACHE_MMU_ACCESS_1      volatile.Register32 // 0x28
	PIF_ACCESS_MONITOR_0    volatile.Register32 // 0x2C
	PIF_ACCESS_MONITOR_1    volatile.Register32 // 0x30
	PIF_ACCESS_MONITOR_2    volatile.Register32 // 0x34
	PIF_ACCESS_MONITOR_3    volatile.Register32 // 0x38
	XTS_AES_KEY_UPDATE      volatile.Register32 // 0x3C
	CLOCK_GATE              volatile.Register32 // 0x40
	_                       [4024]byte
	SENSITIVE_REG_DATE      volatile.Register32 // 0xFFC
}

// SENSITIVE.ROM_TABLE_LOCK: register description
func (o *SENSITIVE_Type) SetROM_TABLE_LOCK(value uint32) {
	volatile.StoreUint32(&o.ROM_TABLE_LOCK.Reg, volatile.LoadUint32(&o.ROM_TABLE_LOCK.Reg)&^(0x1)|value)
}
func (o *SENSITIVE_Type) GetROM_TABLE_LOCK() uint32 {
	return volatile.LoadUint32(&o.ROM_TABLE_LOCK.Reg) & 0x1
}

// SENSITIVE.ROM_TABLE: register description
func (o *SENSITIVE_Type) SetROM_TABLE(value uint32) {
	volatile.StoreUint32(&o.ROM_TABLE.Reg, value)
}
func (o *SENSITIVE_Type) GetROM_TABLE() uint32 {
	return volatile.LoadUint32(&o.ROM_TABLE.Reg)
}

// SENSITIVE.APB_PERIPHERAL_ACCESS_0: register description
func (o *SENSITIVE_Type) SetAPB_PERIPHERAL_ACCESS_0_APB_PERIPHERAL_ACCESS_LOCK(value uint32) {
	volatile.StoreUint32(&o.APB_PERIPHERAL_ACCESS_0.Reg, volatile.LoadUint32(&o.APB_PERIPHERAL_ACCESS_0.Reg)&^(0x1)|value)
}
func (o *SENSITIVE_Type) GetAPB_PERIPHERAL_ACCESS_0_APB_PERIPHERAL_ACCESS_LOCK() uint32 {
	return volatile.LoadUint32(&o.APB_PERIPHERAL_ACCESS_0.Reg) & 0x1
}

// SENSITIVE.APB_PERIPHERAL_ACCESS_1: register description
func (o *SENSITIVE_Type) SetAPB_PERIPHERAL_ACCESS_1_APB_PERIPHERAL_ACCESS_SPLIT_BURST(value uint32) {
	volatile.StoreUint32(&o.APB_PERIPHERAL_ACCESS_1.Reg, volatile.LoadUint32(&o.APB_PERIPHERAL_ACCESS_1.Reg)&^(0x1)|value)
}
func (o *SENSITIVE_Type) GetAPB_PERIPHERAL_ACCESS_1_APB_PERIPHERAL_ACCESS_SPLIT_BURST() uint32 {
	return volatile.LoadUint32(&o.APB_PERIPHERAL_ACCESS_1.Reg) & 0x1
}

// SENSITIVE.INTERNAL_SRAM_USAGE_0: register description
func (o *SENSITIVE_Type) SetINTERNAL_SRAM_USAGE_0_INTERNAL_SRAM_USAGE_LOCK(value uint32) {
	volatile.StoreUint32(&o.INTERNAL_SRAM_USAGE_0.Reg, volatile.LoadUint32(&o.INTERNAL_SRAM_USAGE_0.Reg)&^(0x1)|value)
}
func (o *SENSITIVE_Type) GetINTERNAL_SRAM_USAGE_0_INTERNAL_SRAM_USAGE_LOCK() uint32 {
	return volatile.LoadUint32(&o.INTERNAL_SRAM_USAGE_0.Reg) & 0x1
}

// SENSITIVE.INTERNAL_SRAM_USAGE_1: register description
func (o *SENSITIVE_Type) SetINTERNAL_SRAM_USAGE_1_INTERNAL_SRAM_USAGE_CPU_CACHE(value uint32) {
	volatile.StoreUint32(&o.INTERNAL_SRAM_USAGE_1.Reg, volatile.LoadUint32(&o.INTERNAL_SRAM_USAGE_1.Reg)&^(0x1)|value)
}
func (o *SENSITIVE_Type) GetINTERNAL_SRAM_USAGE_1_INTERNAL_SRAM_USAGE_CPU_CACHE() uint32 {
	return volatile.LoadUint32(&o.INTERNAL_SRAM_USAGE_1.Reg) & 0x1
}
func (o *SENSITIVE_Type) SetINTERNAL_SRAM_USAGE_1_INTERNAL_SRAM_USAGE_CPU_SRAM(value uint32) {
	volatile.StoreUint32(&o.INTERNAL_SRAM_USAGE_1.Reg, volatile.LoadUint32(&o.INTERNAL_SRAM_USAGE_1.Reg)&^(0xe)|value<<1)
}
func (o *SENSITIVE_Type) GetINTERNAL_SRAM_USAGE_1_INTERNAL_SRAM_USAGE_CPU_SRAM() uint32 {
	return (volatile.LoadUint32(&o.INTERNAL_SRAM_USAGE_1.Reg) & 0xe) >> 1
}

// SENSITIVE.INTERNAL_SRAM_USAGE_3: register description
func (o *SENSITIVE_Type) SetINTERNAL_SRAM_USAGE_3_INTERNAL_SRAM_USAGE_MAC_DUMP_SRAM(value uint32) {
	volatile.StoreUint32(&o.INTERNAL_SRAM_USAGE_3.Reg, volatile.LoadUint32(&o.INTERNAL_SRAM_USAGE_3.Reg)&^(0x7)|value)
}
func (o *SENSITIVE_Type) GetINTERNAL_SRAM_USAGE_3_INTERNAL_SRAM_USAGE_MAC_DUMP_SRAM() uint32 {
	return volatile.LoadUint32(&o.INTERNAL_SRAM_USAGE_3.Reg) & 0x7
}
func (o *SENSITIVE_Type) SetINTERNAL_SRAM_USAGE_3_INTERNAL_SRAM_ALLOC_MAC_DUMP(value uint32) {
	volatile.StoreUint32(&o.INTERNAL_SRAM_USAGE_3.Reg, volatile.LoadUint32(&o.INTERNAL_SRAM_USAGE_3.Reg)&^(0x8)|value<<3)
}
func (o *SENSITIVE_Type) GetINTERNAL_SRAM_USAGE_3_INTERNAL_SRAM_ALLOC_MAC_DUMP() uint32 {
	return (volatile.LoadUint32(&o.INTERNAL_SRAM_USAGE_3.Reg) & 0x8) >> 3
}

// SENSITIVE.CACHE_TAG_ACCESS_0: register description
func (o *SENSITIVE_Type) SetCACHE_TAG_ACCESS_0_CACHE_TAG_ACCESS_LOCK(value uint32) {
	volatile.StoreUint32(&o.CACHE_TAG_ACCESS_0.Reg, volatile.LoadUint32(&o.CACHE_TAG_ACCESS_0.Reg)&^(0x1)|value)
}
func (o *SENSITIVE_Type) GetCACHE_TAG_ACCESS_0_CACHE_TAG_ACCESS_LOCK() uint32 {
	return volatile.LoadUint32(&o.CACHE_TAG_ACCESS_0.Reg) & 0x1
}

// SENSITIVE.CACHE_TAG_ACCESS_1: register description
func (o *SENSITIVE_Type) SetCACHE_TAG_ACCESS_1_PRO_I_TAG_RD_ACS(value uint32) {
	volatile.StoreUint32(&o.CACHE_TAG_ACCESS_1.Reg, volatile.LoadUint32(&o.CACHE_TAG_ACCESS_1.Reg)&^(0x1)|value)
}
func (o *SENSITIVE_Type) GetCACHE_TAG_ACCESS_1_PRO_I_TAG_RD_ACS() uint32 {
	return volatile.LoadUint32(&o.CACHE_TAG_ACCESS_1.Reg) & 0x1
}
func (o *SENSITIVE_Type) SetCACHE_TAG_ACCESS_1_PRO_I_TAG_WR_ACS(value uint32) {
	volatile.StoreUint32(&o.CACHE_TAG_ACCESS_1.Reg, volatile.LoadUint32(&o.CACHE_TAG_ACCESS_1.Reg)&^(0x2)|value<<1)
}
func (o *SENSITIVE_Type) GetCACHE_TAG_ACCESS_1_PRO_I_TAG_WR_ACS() uint32 {
	return (volatile.LoadUint32(&o.CACHE_TAG_ACCESS_1.Reg) & 0x2) >> 1
}
func (o *SENSITIVE_Type) SetCACHE_TAG_ACCESS_1_PRO_D_TAG_RD_ACS(value uint32) {
	volatile.StoreUint32(&o.CACHE_TAG_ACCESS_1.Reg, volatile.LoadUint32(&o.CACHE_TAG_ACCESS_1.Reg)&^(0x4)|value<<2)
}
func (o *SENSITIVE_Type) GetCACHE_TAG_ACCESS_1_PRO_D_TAG_RD_ACS() uint32 {
	return (volatile.LoadUint32(&o.CACHE_TAG_ACCESS_1.Reg) & 0x4) >> 2
}
func (o *SENSITIVE_Type) SetCACHE_TAG_ACCESS_1_PRO_D_TAG_WR_ACS(value uint32) {
	volatile.StoreUint32(&o.CACHE_TAG_ACCESS_1.Reg, volatile.LoadUint32(&o.CACHE_TAG_ACCESS_1.Reg)&^(0x8)|value<<3)
}
func (o *SENSITIVE_Type) GetCACHE_TAG_ACCESS_1_PRO_D_TAG_WR_ACS() uint32 {
	return (volatile.LoadUint32(&o.CACHE_TAG_ACCESS_1.Reg) & 0x8) >> 3
}

// SENSITIVE.CACHE_MMU_ACCESS_0: register description
func (o *SENSITIVE_Type) SetCACHE_MMU_ACCESS_0_CACHE_MMU_ACCESS_LOCK(value uint32) {
	volatile.StoreUint32(&o.CACHE_MMU_ACCESS_0.Reg, volatile.LoadUint32(&o.CACHE_MMU_ACCESS_0.Reg)&^(0x1)|value)
}
func (o *SENSITIVE_Type) GetCACHE_MMU_ACCESS_0_CACHE_MMU_ACCESS_LOCK() uint32 {
	return volatile.LoadUint32(&o.CACHE_MMU_ACCESS_0.Reg) & 0x1
}

// SENSITIVE.CACHE_MMU_ACCESS_1: register description
func (o *SENSITIVE_Type) SetCACHE_MMU_ACCESS_1_PRO_MMU_RD_ACS(value uint32) {
	volatile.StoreUint32(&o.CACHE_MMU_ACCESS_1.Reg, volatile.LoadUint32(&o.CACHE_MMU_ACCESS_1.Reg)&^(0x1)|value)
}
func (o *SENSITIVE_Type) GetCACHE_MMU_ACCESS_1_PRO_MMU_RD_ACS() uint32 {
	return volatile.LoadUint32(&o.CACHE_MMU_ACCESS_1.Reg) & 0x1
}
func (o *SENSITIVE_Type) SetCACHE_MMU_ACCESS_1_PRO_MMU_WR_ACS(value uint32) {
	volatile.StoreUint32(&o.CACHE_MMU_ACCESS_1.Reg, volatile.LoadUint32(&o.CACHE_MMU_ACCESS_1.Reg)&^(0x2)|value<<1)
}
func (o *SENSITIVE_Type) GetCACHE_MMU_ACCESS_1_PRO_MMU_WR_ACS() uint32 {
	return (volatile.LoadUint32(&o.CACHE_MMU_ACCESS_1.Reg) & 0x2) >> 1
}

// SENSITIVE.PIF_ACCESS_MONITOR_0: register description
func (o *SENSITIVE_Type) SetPIF_ACCESS_MONITOR_0_PIF_ACCESS_MONITOR_LOCK(value uint32) {
	volatile.StoreUint32(&o.PIF_ACCESS_MONITOR_0.Reg, volatile.LoadUint32(&o.PIF_ACCESS_MONITOR_0.Reg)&^(0x1)|value)
}
func (o *SENSITIVE_Type) GetPIF_ACCESS_MONITOR_0_PIF_ACCESS_MONITOR_LOCK() uint32 {
	return volatile.LoadUint32(&o.PIF_ACCESS_MONITOR_0.Reg) & 0x1
}

// SENSITIVE.PIF_ACCESS_MONITOR_1: register description
func (o *SENSITIVE_Type) SetPIF_ACCESS_MONITOR_1_PIF_ACCESS_MONITOR_NONWORD_VIOLATE_CLR(value uint32) {
	volatile.StoreUint32(&o.PIF_ACCESS_MONITOR_1.Reg, volatile.LoadUint32(&o.PIF_ACCESS_MONITOR_1.Reg)&^(0x1)|value)
}
func (o *SENSITIVE_Type) GetPIF_ACCESS_MONITOR_1_PIF_ACCESS_MONITOR_NONWORD_VIOLATE_CLR() uint32 {
	return volatile.LoadUint32(&o.PIF_ACCESS_MONITOR_1.Reg) & 0x1
}
func (o *SENSITIVE_Type) SetPIF_ACCESS_MONITOR_1_PIF_ACCESS_MONITOR_NONWORD_VIOLATE_EN(value uint32) {
	volatile.StoreUint32(&o.PIF_ACCESS_MONITOR_1.Reg, volatile.LoadUint32(&o.PIF_ACCESS_MONITOR_1.Reg)&^(0x2)|value<<1)
}
func (o *SENSITIVE_Type) GetPIF_ACCESS_MONITOR_1_PIF_ACCESS_MONITOR_NONWORD_VIOLATE_EN() uint32 {
	return (volatile.LoadUint32(&o.PIF_ACCESS_MONITOR_1.Reg) & 0x2) >> 1
}

// SENSITIVE.PIF_ACCESS_MONITOR_2: register description
func (o *SENSITIVE_Type) SetPIF_ACCESS_MONITOR_2_PIF_ACCESS_MONITOR_NONWORD_VIOLATE_INTR(value uint32) {
	volatile.StoreUint32(&o.PIF_ACCESS_MONITOR_2.Reg, volatile.LoadUint32(&o.PIF_ACCESS_MONITOR_2.Reg)&^(0x1)|value)
}
func (o *SENSITIVE_Type) GetPIF_ACCESS_MONITOR_2_PIF_ACCESS_MONITOR_NONWORD_VIOLATE_INTR() uint32 {
	return volatile.LoadUint32(&o.PIF_ACCESS_MONITOR_2.Reg) & 0x1
}
func (o *SENSITIVE_Type) SetPIF_ACCESS_MONITOR_2_PIF_ACCESS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE(value uint32) {
	volatile.StoreUint32(&o.PIF_ACCESS_MONITOR_2.Reg, volatile.LoadUint32(&o.PIF_ACCESS_MONITOR_2.Reg)&^(0x6)|value<<1)
}
func (o *SENSITIVE_Type) GetPIF_ACCESS_MONITOR_2_PIF_ACCESS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE() uint32 {
	return (volatile.LoadUint32(&o.PIF_ACCESS_MONITOR_2.Reg) & 0x6) >> 1
}

// SENSITIVE.PIF_ACCESS_MONITOR_3: register description
func (o *SENSITIVE_Type) SetPIF_ACCESS_MONITOR_3(value uint32) {
	volatile.StoreUint32(&o.PIF_ACCESS_MONITOR_3.Reg, value)
}
func (o *SENSITIVE_Type) GetPIF_ACCESS_MONITOR_3() uint32 {
	return volatile.LoadUint32(&o.PIF_ACCESS_MONITOR_3.Reg)
}

// SENSITIVE.XTS_AES_KEY_UPDATE: register description
func (o *SENSITIVE_Type) SetXTS_AES_KEY_UPDATE(value uint32) {
	volatile.StoreUint32(&o.XTS_AES_KEY_UPDATE.Reg, volatile.LoadUint32(&o.XTS_AES_KEY_UPDATE.Reg)&^(0x1)|value)
}
func (o *SENSITIVE_Type) GetXTS_AES_KEY_UPDATE() uint32 {
	return volatile.LoadUint32(&o.XTS_AES_KEY_UPDATE.Reg) & 0x1
}

// SENSITIVE.CLOCK_GATE: register description
func (o *SENSITIVE_Type) SetCLOCK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *SENSITIVE_Type) GetCLOCK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// SENSITIVE.SENSITIVE_REG_DATE: register description
func (o *SENSITIVE_Type) SetSENSITIVE_REG_DATE(value uint32) {
	volatile.StoreUint32(&o.SENSITIVE_REG_DATE.Reg, volatile.LoadUint32(&o.SENSITIVE_REG_DATE.Reg)&^(0xfffffff)|value)
}
func (o *SENSITIVE_Type) GetSENSITIVE_REG_DATE() uint32 {
	return volatile.LoadUint32(&o.SENSITIVE_REG_DATE.Reg) & 0xfffffff
}

// SHA (Secure Hash Algorithm) Accelerator
type SHA_Type struct {
	MODE          volatile.Register32 // 0x0
	T_STRING      volatile.Register32 // 0x4
	T_LENGTH      volatile.Register32 // 0x8
	DMA_BLOCK_NUM volatile.Register32 // 0xC
	START         volatile.Register32 // 0x10
	CONTINUE      volatile.Register32 // 0x14
	BUSY          volatile.Register32 // 0x18
	DMA_START     volatile.Register32 // 0x1C
	DMA_CONTINUE  volatile.Register32 // 0x20
	CLEAR_IRQ     volatile.Register32 // 0x24
	IRQ_ENA       volatile.Register32 // 0x28
	DATE          volatile.Register32 // 0x2C
	_             [16]byte
	H_MEM         [64]volatile.Register8 // 0x40
	M_MEM         [64]volatile.Register8 // 0x80
}

// SHA.MODE: Initial configuration register.
func (o *SHA_Type) SetMODE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x7)|value)
}
func (o *SHA_Type) GetMODE() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x7
}

// SHA.T_STRING: SHA 512/t configuration register 0.
func (o *SHA_Type) SetT_STRING(value uint32) {
	volatile.StoreUint32(&o.T_STRING.Reg, value)
}
func (o *SHA_Type) GetT_STRING() uint32 {
	return volatile.LoadUint32(&o.T_STRING.Reg)
}

// SHA.T_LENGTH: SHA 512/t configuration register 1.
func (o *SHA_Type) SetT_LENGTH(value uint32) {
	volatile.StoreUint32(&o.T_LENGTH.Reg, volatile.LoadUint32(&o.T_LENGTH.Reg)&^(0x3f)|value)
}
func (o *SHA_Type) GetT_LENGTH() uint32 {
	return volatile.LoadUint32(&o.T_LENGTH.Reg) & 0x3f
}

// SHA.DMA_BLOCK_NUM: DMA configuration register 0.
func (o *SHA_Type) SetDMA_BLOCK_NUM(value uint32) {
	volatile.StoreUint32(&o.DMA_BLOCK_NUM.Reg, volatile.LoadUint32(&o.DMA_BLOCK_NUM.Reg)&^(0x3f)|value)
}
func (o *SHA_Type) GetDMA_BLOCK_NUM() uint32 {
	return volatile.LoadUint32(&o.DMA_BLOCK_NUM.Reg) & 0x3f
}

// SHA.START: Typical SHA configuration register 0.
func (o *SHA_Type) SetSTART(value uint32) {
	volatile.StoreUint32(&o.START.Reg, volatile.LoadUint32(&o.START.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SHA_Type) GetSTART() uint32 {
	return (volatile.LoadUint32(&o.START.Reg) & 0xfffffffe) >> 1
}

// SHA.CONTINUE: Typical SHA configuration register 1.
func (o *SHA_Type) SetCONTINUE(value uint32) {
	volatile.StoreUint32(&o.CONTINUE.Reg, volatile.LoadUint32(&o.CONTINUE.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SHA_Type) GetCONTINUE() uint32 {
	return (volatile.LoadUint32(&o.CONTINUE.Reg) & 0xfffffffe) >> 1
}

// SHA.BUSY: Busy register.
func (o *SHA_Type) SetBUSY_STATE(value uint32) {
	volatile.StoreUint32(&o.BUSY.Reg, volatile.LoadUint32(&o.BUSY.Reg)&^(0x1)|value)
}
func (o *SHA_Type) GetBUSY_STATE() uint32 {
	return volatile.LoadUint32(&o.BUSY.Reg) & 0x1
}

// SHA.DMA_START: DMA configuration register 1.
func (o *SHA_Type) SetDMA_START(value uint32) {
	volatile.StoreUint32(&o.DMA_START.Reg, volatile.LoadUint32(&o.DMA_START.Reg)&^(0x1)|value)
}
func (o *SHA_Type) GetDMA_START() uint32 {
	return volatile.LoadUint32(&o.DMA_START.Reg) & 0x1
}

// SHA.DMA_CONTINUE: DMA configuration register 2.
func (o *SHA_Type) SetDMA_CONTINUE(value uint32) {
	volatile.StoreUint32(&o.DMA_CONTINUE.Reg, volatile.LoadUint32(&o.DMA_CONTINUE.Reg)&^(0x1)|value)
}
func (o *SHA_Type) GetDMA_CONTINUE() uint32 {
	return volatile.LoadUint32(&o.DMA_CONTINUE.Reg) & 0x1
}

// SHA.CLEAR_IRQ: Interrupt clear register.
func (o *SHA_Type) SetCLEAR_IRQ_CLEAR_INTERRUPT(value uint32) {
	volatile.StoreUint32(&o.CLEAR_IRQ.Reg, volatile.LoadUint32(&o.CLEAR_IRQ.Reg)&^(0x1)|value)
}
func (o *SHA_Type) GetCLEAR_IRQ_CLEAR_INTERRUPT() uint32 {
	return volatile.LoadUint32(&o.CLEAR_IRQ.Reg) & 0x1
}

// SHA.IRQ_ENA: Interrupt enable register.
func (o *SHA_Type) SetIRQ_ENA_INTERRUPT_ENA(value uint32) {
	volatile.StoreUint32(&o.IRQ_ENA.Reg, volatile.LoadUint32(&o.IRQ_ENA.Reg)&^(0x1)|value)
}
func (o *SHA_Type) GetIRQ_ENA_INTERRUPT_ENA() uint32 {
	return volatile.LoadUint32(&o.IRQ_ENA.Reg) & 0x1
}

// SHA.DATE: Date register.
func (o *SHA_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x3fffffff)|value)
}
func (o *SHA_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0x3fffffff
}

// SPI (Serial Peripheral Interface) Controller 0
type SPI0_Type struct {
	_            [8]byte
	CTRL         volatile.Register32 // 0x8
	CTRL1        volatile.Register32 // 0xC
	CTRL2        volatile.Register32 // 0x10
	CLOCK        volatile.Register32 // 0x14
	USER         volatile.Register32 // 0x18
	USER1        volatile.Register32 // 0x1C
	USER2        volatile.Register32 // 0x20
	_            [8]byte
	RD_STATUS    volatile.Register32 // 0x2C
	_            [4]byte
	MISC         volatile.Register32 // 0x34
	_            [4]byte
	CACHE_FCTRL  volatile.Register32 // 0x3C
	_            [20]byte
	FSM          volatile.Register32 // 0x54
	_            [80]byte
	TIMING_CALI  volatile.Register32 // 0xA8
	DIN_MODE     volatile.Register32 // 0xAC
	DIN_NUM      volatile.Register32 // 0xB0
	DOUT_MODE    volatile.Register32 // 0xB4
	_            [36]byte
	CLOCK_GATE   volatile.Register32 // 0xDC
	CORE_CLK_SEL volatile.Register32 // 0xE0
	_            [792]byte
	DATE         volatile.Register32 // 0x3FC
}

// SPI0.CTRL: SPI0 control register.
func (o *SPI0_Type) SetCTRL_FDUMMY_OUT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *SPI0_Type) GetCTRL_FDUMMY_OUT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *SPI0_Type) SetCTRL_FCMD_DUAL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *SPI0_Type) GetCTRL_FCMD_DUAL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80) >> 7
}
func (o *SPI0_Type) SetCTRL_FCMD_QUAD(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100)|value<<8)
}
func (o *SPI0_Type) GetCTRL_FCMD_QUAD() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100) >> 8
}
func (o *SPI0_Type) SetCTRL_FASTRD_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *SPI0_Type) GetCTRL_FASTRD_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2000) >> 13
}
func (o *SPI0_Type) SetCTRL_FREAD_DUAL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SPI0_Type) GetCTRL_FREAD_DUAL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4000) >> 14
}
func (o *SPI0_Type) SetCTRL_Q_POL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *SPI0_Type) GetCTRL_Q_POL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40000) >> 18
}
func (o *SPI0_Type) SetCTRL_D_POL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80000)|value<<19)
}
func (o *SPI0_Type) GetCTRL_D_POL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80000) >> 19
}
func (o *SPI0_Type) SetCTRL_FREAD_QUAD(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SPI0_Type) GetCTRL_FREAD_QUAD() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100000) >> 20
}
func (o *SPI0_Type) SetCTRL_WP(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x200000)|value<<21)
}
func (o *SPI0_Type) GetCTRL_WP() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x200000) >> 21
}
func (o *SPI0_Type) SetCTRL_FREAD_DIO(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x800000)|value<<23)
}
func (o *SPI0_Type) GetCTRL_FREAD_DIO() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x800000) >> 23
}
func (o *SPI0_Type) SetCTRL_FREAD_QIO(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI0_Type) GetCTRL_FREAD_QIO() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1000000) >> 24
}

// SPI0.CTRL1: SPI0 control1 register.
func (o *SPI0_Type) SetCTRL1_CLK_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x3)|value)
}
func (o *SPI0_Type) GetCTRL1_CLK_MODE() uint32 {
	return volatile.LoadUint32(&o.CTRL1.Reg) & 0x3
}
func (o *SPI0_Type) SetCTRL1_RXFIFO_RST(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x40000000)|value<<30)
}
func (o *SPI0_Type) GetCTRL1_RXFIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x40000000) >> 30
}

// SPI0.CTRL2: SPI0 control2 register.
func (o *SPI0_Type) SetCTRL2_CS_SETUP_TIME(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x1f)|value)
}
func (o *SPI0_Type) GetCTRL2_CS_SETUP_TIME() uint32 {
	return volatile.LoadUint32(&o.CTRL2.Reg) & 0x1f
}
func (o *SPI0_Type) SetCTRL2_CS_HOLD_TIME(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x3e0)|value<<5)
}
func (o *SPI0_Type) GetCTRL2_CS_HOLD_TIME() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x3e0) >> 5
}
func (o *SPI0_Type) SetCTRL2_CS_HOLD_DELAY(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x7e000000)|value<<25)
}
func (o *SPI0_Type) GetCTRL2_CS_HOLD_DELAY() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x7e000000) >> 25
}
func (o *SPI0_Type) SetCTRL2_SYNC_RESET(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI0_Type) GetCTRL2_SYNC_RESET() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x80000000) >> 31
}

// SPI0.CLOCK: SPI clock division control register.
func (o *SPI0_Type) SetCLOCK_CLKCNT_L(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0xff)|value)
}
func (o *SPI0_Type) GetCLOCK_CLKCNT_L() uint32 {
	return volatile.LoadUint32(&o.CLOCK.Reg) & 0xff
}
func (o *SPI0_Type) SetCLOCK_CLKCNT_H(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0xff00)|value<<8)
}
func (o *SPI0_Type) GetCLOCK_CLKCNT_H() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0xff00) >> 8
}
func (o *SPI0_Type) SetCLOCK_CLKCNT_N(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0xff0000)|value<<16)
}
func (o *SPI0_Type) GetCLOCK_CLKCNT_N() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0xff0000) >> 16
}
func (o *SPI0_Type) SetCLOCK_CLK_EQU_SYSCLK(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI0_Type) GetCLOCK_CLK_EQU_SYSCLK() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0x80000000) >> 31
}

// SPI0.USER: SPI0 user register.
func (o *SPI0_Type) SetUSER_CS_HOLD(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x40)|value<<6)
}
func (o *SPI0_Type) GetUSER_CS_HOLD() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x40) >> 6
}
func (o *SPI0_Type) SetUSER_CS_SETUP(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x80)|value<<7)
}
func (o *SPI0_Type) GetUSER_CS_SETUP() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x80) >> 7
}
func (o *SPI0_Type) SetUSER_CK_OUT_EDGE(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x200)|value<<9)
}
func (o *SPI0_Type) GetUSER_CK_OUT_EDGE() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x200) >> 9
}
func (o *SPI0_Type) SetUSER_USR_DUMMY_IDLE(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x4000000)|value<<26)
}
func (o *SPI0_Type) GetUSER_USR_DUMMY_IDLE() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x4000000) >> 26
}
func (o *SPI0_Type) SetUSER_USR_DUMMY(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x20000000)|value<<29)
}
func (o *SPI0_Type) GetUSER_USR_DUMMY() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x20000000) >> 29
}

// SPI0.USER1: SPI0 user1 register.
func (o *SPI0_Type) SetUSER1_USR_DUMMY_CYCLELEN(value uint32) {
	volatile.StoreUint32(&o.USER1.Reg, volatile.LoadUint32(&o.USER1.Reg)&^(0x3f)|value)
}
func (o *SPI0_Type) GetUSER1_USR_DUMMY_CYCLELEN() uint32 {
	return volatile.LoadUint32(&o.USER1.Reg) & 0x3f
}
func (o *SPI0_Type) SetUSER1_USR_ADDR_BITLEN(value uint32) {
	volatile.StoreUint32(&o.USER1.Reg, volatile.LoadUint32(&o.USER1.Reg)&^(0xfc000000)|value<<26)
}
func (o *SPI0_Type) GetUSER1_USR_ADDR_BITLEN() uint32 {
	return (volatile.LoadUint32(&o.USER1.Reg) & 0xfc000000) >> 26
}

// SPI0.USER2: SPI0 user2 register.
func (o *SPI0_Type) SetUSER2_USR_COMMAND_VALUE(value uint32) {
	volatile.StoreUint32(&o.USER2.Reg, volatile.LoadUint32(&o.USER2.Reg)&^(0xffff)|value)
}
func (o *SPI0_Type) GetUSER2_USR_COMMAND_VALUE() uint32 {
	return volatile.LoadUint32(&o.USER2.Reg) & 0xffff
}
func (o *SPI0_Type) SetUSER2_USR_COMMAND_BITLEN(value uint32) {
	volatile.StoreUint32(&o.USER2.Reg, volatile.LoadUint32(&o.USER2.Reg)&^(0xf0000000)|value<<28)
}
func (o *SPI0_Type) GetUSER2_USR_COMMAND_BITLEN() uint32 {
	return (volatile.LoadUint32(&o.USER2.Reg) & 0xf0000000) >> 28
}

// SPI0.RD_STATUS: SPI0 read control register.
func (o *SPI0_Type) SetRD_STATUS_WB_MODE(value uint32) {
	volatile.StoreUint32(&o.RD_STATUS.Reg, volatile.LoadUint32(&o.RD_STATUS.Reg)&^(0xff0000)|value<<16)
}
func (o *SPI0_Type) GetRD_STATUS_WB_MODE() uint32 {
	return (volatile.LoadUint32(&o.RD_STATUS.Reg) & 0xff0000) >> 16
}

// SPI0.MISC: SPI0 misc register
func (o *SPI0_Type) SetMISC_TRANS_END(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x8)|value<<3)
}
func (o *SPI0_Type) GetMISC_TRANS_END() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x8) >> 3
}
func (o *SPI0_Type) SetMISC_TRANS_END_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x10)|value<<4)
}
func (o *SPI0_Type) GetMISC_TRANS_END_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x10) >> 4
}
func (o *SPI0_Type) SetMISC_CSPI_ST_TRANS_END(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x20)|value<<5)
}
func (o *SPI0_Type) GetMISC_CSPI_ST_TRANS_END() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x20) >> 5
}
func (o *SPI0_Type) SetMISC_CSPI_ST_TRANS_END_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x40)|value<<6)
}
func (o *SPI0_Type) GetMISC_CSPI_ST_TRANS_END_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x40) >> 6
}
func (o *SPI0_Type) SetMISC_CK_IDLE_EDGE(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x200)|value<<9)
}
func (o *SPI0_Type) GetMISC_CK_IDLE_EDGE() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x200) >> 9
}
func (o *SPI0_Type) SetMISC_CS_KEEP_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x400)|value<<10)
}
func (o *SPI0_Type) GetMISC_CS_KEEP_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x400) >> 10
}

// SPI0.CACHE_FCTRL: SPI0 bit mode control register.
func (o *SPI0_Type) SetCACHE_FCTRL_CACHE_REQ_EN(value uint32) {
	volatile.StoreUint32(&o.CACHE_FCTRL.Reg, volatile.LoadUint32(&o.CACHE_FCTRL.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetCACHE_FCTRL_CACHE_REQ_EN() uint32 {
	return volatile.LoadUint32(&o.CACHE_FCTRL.Reg) & 0x1
}
func (o *SPI0_Type) SetCACHE_FCTRL_CACHE_USR_ADDR_4BYTE(value uint32) {
	volatile.StoreUint32(&o.CACHE_FCTRL.Reg, volatile.LoadUint32(&o.CACHE_FCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetCACHE_FCTRL_CACHE_USR_ADDR_4BYTE() uint32 {
	return (volatile.LoadUint32(&o.CACHE_FCTRL.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetCACHE_FCTRL_CACHE_FLASH_USR_CMD(value uint32) {
	volatile.StoreUint32(&o.CACHE_FCTRL.Reg, volatile.LoadUint32(&o.CACHE_FCTRL.Reg)&^(0x4)|value<<2)
}
func (o *SPI0_Type) GetCACHE_FCTRL_CACHE_FLASH_USR_CMD() uint32 {
	return (volatile.LoadUint32(&o.CACHE_FCTRL.Reg) & 0x4) >> 2
}
func (o *SPI0_Type) SetCACHE_FCTRL_FDIN_DUAL(value uint32) {
	volatile.StoreUint32(&o.CACHE_FCTRL.Reg, volatile.LoadUint32(&o.CACHE_FCTRL.Reg)&^(0x8)|value<<3)
}
func (o *SPI0_Type) GetCACHE_FCTRL_FDIN_DUAL() uint32 {
	return (volatile.LoadUint32(&o.CACHE_FCTRL.Reg) & 0x8) >> 3
}
func (o *SPI0_Type) SetCACHE_FCTRL_FDOUT_DUAL(value uint32) {
	volatile.StoreUint32(&o.CACHE_FCTRL.Reg, volatile.LoadUint32(&o.CACHE_FCTRL.Reg)&^(0x10)|value<<4)
}
func (o *SPI0_Type) GetCACHE_FCTRL_FDOUT_DUAL() uint32 {
	return (volatile.LoadUint32(&o.CACHE_FCTRL.Reg) & 0x10) >> 4
}
func (o *SPI0_Type) SetCACHE_FCTRL_FADDR_DUAL(value uint32) {
	volatile.StoreUint32(&o.CACHE_FCTRL.Reg, volatile.LoadUint32(&o.CACHE_FCTRL.Reg)&^(0x20)|value<<5)
}
func (o *SPI0_Type) GetCACHE_FCTRL_FADDR_DUAL() uint32 {
	return (volatile.LoadUint32(&o.CACHE_FCTRL.Reg) & 0x20) >> 5
}
func (o *SPI0_Type) SetCACHE_FCTRL_FDIN_QUAD(value uint32) {
	volatile.StoreUint32(&o.CACHE_FCTRL.Reg, volatile.LoadUint32(&o.CACHE_FCTRL.Reg)&^(0x40)|value<<6)
}
func (o *SPI0_Type) GetCACHE_FCTRL_FDIN_QUAD() uint32 {
	return (volatile.LoadUint32(&o.CACHE_FCTRL.Reg) & 0x40) >> 6
}
func (o *SPI0_Type) SetCACHE_FCTRL_FDOUT_QUAD(value uint32) {
	volatile.StoreUint32(&o.CACHE_FCTRL.Reg, volatile.LoadUint32(&o.CACHE_FCTRL.Reg)&^(0x80)|value<<7)
}
func (o *SPI0_Type) GetCACHE_FCTRL_FDOUT_QUAD() uint32 {
	return (volatile.LoadUint32(&o.CACHE_FCTRL.Reg) & 0x80) >> 7
}
func (o *SPI0_Type) SetCACHE_FCTRL_FADDR_QUAD(value uint32) {
	volatile.StoreUint32(&o.CACHE_FCTRL.Reg, volatile.LoadUint32(&o.CACHE_FCTRL.Reg)&^(0x100)|value<<8)
}
func (o *SPI0_Type) GetCACHE_FCTRL_FADDR_QUAD() uint32 {
	return (volatile.LoadUint32(&o.CACHE_FCTRL.Reg) & 0x100) >> 8
}

// SPI0.FSM: SPI0 FSM status register
func (o *SPI0_Type) SetFSM_CSPI_ST(value uint32) {
	volatile.StoreUint32(&o.FSM.Reg, volatile.LoadUint32(&o.FSM.Reg)&^(0xf)|value)
}
func (o *SPI0_Type) GetFSM_CSPI_ST() uint32 {
	return volatile.LoadUint32(&o.FSM.Reg) & 0xf
}
func (o *SPI0_Type) SetFSM_EM_ST(value uint32) {
	volatile.StoreUint32(&o.FSM.Reg, volatile.LoadUint32(&o.FSM.Reg)&^(0x70)|value<<4)
}
func (o *SPI0_Type) GetFSM_EM_ST() uint32 {
	return (volatile.LoadUint32(&o.FSM.Reg) & 0x70) >> 4
}
func (o *SPI0_Type) SetFSM_CSPI_LOCK_DELAY_TIME(value uint32) {
	volatile.StoreUint32(&o.FSM.Reg, volatile.LoadUint32(&o.FSM.Reg)&^(0xf80)|value<<7)
}
func (o *SPI0_Type) GetFSM_CSPI_LOCK_DELAY_TIME() uint32 {
	return (volatile.LoadUint32(&o.FSM.Reg) & 0xf80) >> 7
}

// SPI0.TIMING_CALI: SPI0 timing calibration register
func (o *SPI0_Type) SetTIMING_CALI_TIMING_CLK_ENA(value uint32) {
	volatile.StoreUint32(&o.TIMING_CALI.Reg, volatile.LoadUint32(&o.TIMING_CALI.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetTIMING_CALI_TIMING_CLK_ENA() uint32 {
	return volatile.LoadUint32(&o.TIMING_CALI.Reg) & 0x1
}
func (o *SPI0_Type) SetTIMING_CALI(value uint32) {
	volatile.StoreUint32(&o.TIMING_CALI.Reg, volatile.LoadUint32(&o.TIMING_CALI.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetTIMING_CALI() uint32 {
	return (volatile.LoadUint32(&o.TIMING_CALI.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetTIMING_CALI_EXTRA_DUMMY_CYCLELEN(value uint32) {
	volatile.StoreUint32(&o.TIMING_CALI.Reg, volatile.LoadUint32(&o.TIMING_CALI.Reg)&^(0x1c)|value<<2)
}
func (o *SPI0_Type) GetTIMING_CALI_EXTRA_DUMMY_CYCLELEN() uint32 {
	return (volatile.LoadUint32(&o.TIMING_CALI.Reg) & 0x1c) >> 2
}

// SPI0.DIN_MODE: SPI0 input delay mode control register
func (o *SPI0_Type) SetDIN_MODE_DIN0_MODE(value uint32) {
	volatile.StoreUint32(&o.DIN_MODE.Reg, volatile.LoadUint32(&o.DIN_MODE.Reg)&^(0x3)|value)
}
func (o *SPI0_Type) GetDIN_MODE_DIN0_MODE() uint32 {
	return volatile.LoadUint32(&o.DIN_MODE.Reg) & 0x3
}
func (o *SPI0_Type) SetDIN_MODE_DIN1_MODE(value uint32) {
	volatile.StoreUint32(&o.DIN_MODE.Reg, volatile.LoadUint32(&o.DIN_MODE.Reg)&^(0xc)|value<<2)
}
func (o *SPI0_Type) GetDIN_MODE_DIN1_MODE() uint32 {
	return (volatile.LoadUint32(&o.DIN_MODE.Reg) & 0xc) >> 2
}
func (o *SPI0_Type) SetDIN_MODE_DIN2_MODE(value uint32) {
	volatile.StoreUint32(&o.DIN_MODE.Reg, volatile.LoadUint32(&o.DIN_MODE.Reg)&^(0x30)|value<<4)
}
func (o *SPI0_Type) GetDIN_MODE_DIN2_MODE() uint32 {
	return (volatile.LoadUint32(&o.DIN_MODE.Reg) & 0x30) >> 4
}
func (o *SPI0_Type) SetDIN_MODE_DIN3_MODE(value uint32) {
	volatile.StoreUint32(&o.DIN_MODE.Reg, volatile.LoadUint32(&o.DIN_MODE.Reg)&^(0xc0)|value<<6)
}
func (o *SPI0_Type) GetDIN_MODE_DIN3_MODE() uint32 {
	return (volatile.LoadUint32(&o.DIN_MODE.Reg) & 0xc0) >> 6
}

// SPI0.DIN_NUM: SPI0 input delay number control register
func (o *SPI0_Type) SetDIN_NUM_DIN0_NUM(value uint32) {
	volatile.StoreUint32(&o.DIN_NUM.Reg, volatile.LoadUint32(&o.DIN_NUM.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetDIN_NUM_DIN0_NUM() uint32 {
	return volatile.LoadUint32(&o.DIN_NUM.Reg) & 0x1
}
func (o *SPI0_Type) SetDIN_NUM_DIN1_NUM(value uint32) {
	volatile.StoreUint32(&o.DIN_NUM.Reg, volatile.LoadUint32(&o.DIN_NUM.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetDIN_NUM_DIN1_NUM() uint32 {
	return (volatile.LoadUint32(&o.DIN_NUM.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetDIN_NUM_DIN2_NUM(value uint32) {
	volatile.StoreUint32(&o.DIN_NUM.Reg, volatile.LoadUint32(&o.DIN_NUM.Reg)&^(0x4)|value<<2)
}
func (o *SPI0_Type) GetDIN_NUM_DIN2_NUM() uint32 {
	return (volatile.LoadUint32(&o.DIN_NUM.Reg) & 0x4) >> 2
}
func (o *SPI0_Type) SetDIN_NUM_DIN3_NUM(value uint32) {
	volatile.StoreUint32(&o.DIN_NUM.Reg, volatile.LoadUint32(&o.DIN_NUM.Reg)&^(0x8)|value<<3)
}
func (o *SPI0_Type) GetDIN_NUM_DIN3_NUM() uint32 {
	return (volatile.LoadUint32(&o.DIN_NUM.Reg) & 0x8) >> 3
}

// SPI0.DOUT_MODE: SPI0 output delay mode control register
func (o *SPI0_Type) SetDOUT_MODE_DOUT0_MODE(value uint32) {
	volatile.StoreUint32(&o.DOUT_MODE.Reg, volatile.LoadUint32(&o.DOUT_MODE.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetDOUT_MODE_DOUT0_MODE() uint32 {
	return volatile.LoadUint32(&o.DOUT_MODE.Reg) & 0x1
}
func (o *SPI0_Type) SetDOUT_MODE_DOUT1_MODE(value uint32) {
	volatile.StoreUint32(&o.DOUT_MODE.Reg, volatile.LoadUint32(&o.DOUT_MODE.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetDOUT_MODE_DOUT1_MODE() uint32 {
	return (volatile.LoadUint32(&o.DOUT_MODE.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetDOUT_MODE_DOUT2_MODE(value uint32) {
	volatile.StoreUint32(&o.DOUT_MODE.Reg, volatile.LoadUint32(&o.DOUT_MODE.Reg)&^(0x4)|value<<2)
}
func (o *SPI0_Type) GetDOUT_MODE_DOUT2_MODE() uint32 {
	return (volatile.LoadUint32(&o.DOUT_MODE.Reg) & 0x4) >> 2
}
func (o *SPI0_Type) SetDOUT_MODE_DOUT3_MODE(value uint32) {
	volatile.StoreUint32(&o.DOUT_MODE.Reg, volatile.LoadUint32(&o.DOUT_MODE.Reg)&^(0x8)|value<<3)
}
func (o *SPI0_Type) GetDOUT_MODE_DOUT3_MODE() uint32 {
	return (volatile.LoadUint32(&o.DOUT_MODE.Reg) & 0x8) >> 3
}

// SPI0.CLOCK_GATE: SPI0 clk_gate register
func (o *SPI0_Type) SetCLOCK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetCLOCK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// SPI0.CORE_CLK_SEL: SPI0 module clock select register
func (o *SPI0_Type) SetCORE_CLK_SEL_SPI01_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CORE_CLK_SEL.Reg, volatile.LoadUint32(&o.CORE_CLK_SEL.Reg)&^(0x3)|value)
}
func (o *SPI0_Type) GetCORE_CLK_SEL_SPI01_CLK_SEL() uint32 {
	return volatile.LoadUint32(&o.CORE_CLK_SEL.Reg) & 0x3
}

// SPI0.DATE: Version control register
func (o *SPI0_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *SPI0_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// SPI (Serial Peripheral Interface) Controller 1
type SPI1_Type struct {
	CMD              volatile.Register32 // 0x0
	ADDR             volatile.Register32 // 0x4
	CTRL             volatile.Register32 // 0x8
	CTRL1            volatile.Register32 // 0xC
	CTRL2            volatile.Register32 // 0x10
	CLOCK            volatile.Register32 // 0x14
	USER             volatile.Register32 // 0x18
	USER1            volatile.Register32 // 0x1C
	USER2            volatile.Register32 // 0x20
	MOSI_DLEN        volatile.Register32 // 0x24
	MISO_DLEN        volatile.Register32 // 0x28
	RD_STATUS        volatile.Register32 // 0x2C
	_                [4]byte
	MISC             volatile.Register32 // 0x34
	TX_CRC           volatile.Register32 // 0x38
	CACHE_FCTRL      volatile.Register32 // 0x3C
	_                [24]byte
	W0               volatile.Register32 // 0x58
	W1               volatile.Register32 // 0x5C
	W2               volatile.Register32 // 0x60
	W3               volatile.Register32 // 0x64
	W4               volatile.Register32 // 0x68
	W5               volatile.Register32 // 0x6C
	W6               volatile.Register32 // 0x70
	W7               volatile.Register32 // 0x74
	W8               volatile.Register32 // 0x78
	W9               volatile.Register32 // 0x7C
	W10              volatile.Register32 // 0x80
	W11              volatile.Register32 // 0x84
	W12              volatile.Register32 // 0x88
	W13              volatile.Register32 // 0x8C
	W14              volatile.Register32 // 0x90
	W15              volatile.Register32 // 0x94
	FLASH_WAITI_CTRL volatile.Register32 // 0x98
	FLASH_SUS_CTRL   volatile.Register32 // 0x9C
	FLASH_SUS_CMD    volatile.Register32 // 0xA0
	SUS_STATUS       volatile.Register32 // 0xA4
	TIMING_CALI      volatile.Register32 // 0xA8
	_                [20]byte
	INT_ENA          volatile.Register32 // 0xC0
	INT_CLR          volatile.Register32 // 0xC4
	INT_RAW          volatile.Register32 // 0xC8
	INT_ST           volatile.Register32 // 0xCC
	_                [12]byte
	CLOCK_GATE       volatile.Register32 // 0xDC
	_                [796]byte
	DATE             volatile.Register32 // 0x3FC
}

// SPI1.CMD: SPI1 memory command register
func (o *SPI1_Type) SetCMD_SPI1_MST_ST(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0xf)|value)
}
func (o *SPI1_Type) GetCMD_SPI1_MST_ST() uint32 {
	return volatile.LoadUint32(&o.CMD.Reg) & 0xf
}
func (o *SPI1_Type) SetCMD_MSPI_ST(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0xf0)|value<<4)
}
func (o *SPI1_Type) GetCMD_MSPI_ST() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0xf0) >> 4
}
func (o *SPI1_Type) SetCMD_FLASH_PE(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x20000)|value<<17)
}
func (o *SPI1_Type) GetCMD_FLASH_PE() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x20000) >> 17
}
func (o *SPI1_Type) SetCMD_USR(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x40000)|value<<18)
}
func (o *SPI1_Type) GetCMD_USR() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x40000) >> 18
}
func (o *SPI1_Type) SetCMD_FLASH_HPM(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x80000)|value<<19)
}
func (o *SPI1_Type) GetCMD_FLASH_HPM() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x80000) >> 19
}
func (o *SPI1_Type) SetCMD_FLASH_RES(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x100000)|value<<20)
}
func (o *SPI1_Type) GetCMD_FLASH_RES() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x100000) >> 20
}
func (o *SPI1_Type) SetCMD_FLASH_DP(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x200000)|value<<21)
}
func (o *SPI1_Type) GetCMD_FLASH_DP() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x200000) >> 21
}
func (o *SPI1_Type) SetCMD_FLASH_CE(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x400000)|value<<22)
}
func (o *SPI1_Type) GetCMD_FLASH_CE() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x400000) >> 22
}
func (o *SPI1_Type) SetCMD_FLASH_BE(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x800000)|value<<23)
}
func (o *SPI1_Type) GetCMD_FLASH_BE() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x800000) >> 23
}
func (o *SPI1_Type) SetCMD_FLASH_SE(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI1_Type) GetCMD_FLASH_SE() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x1000000) >> 24
}
func (o *SPI1_Type) SetCMD_FLASH_PP(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x2000000)|value<<25)
}
func (o *SPI1_Type) GetCMD_FLASH_PP() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x2000000) >> 25
}
func (o *SPI1_Type) SetCMD_FLASH_WRSR(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x4000000)|value<<26)
}
func (o *SPI1_Type) GetCMD_FLASH_WRSR() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x4000000) >> 26
}
func (o *SPI1_Type) SetCMD_FLASH_RDSR(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x8000000)|value<<27)
}
func (o *SPI1_Type) GetCMD_FLASH_RDSR() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x8000000) >> 27
}
func (o *SPI1_Type) SetCMD_FLASH_RDID(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x10000000)|value<<28)
}
func (o *SPI1_Type) GetCMD_FLASH_RDID() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x10000000) >> 28
}
func (o *SPI1_Type) SetCMD_FLASH_WRDI(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x20000000)|value<<29)
}
func (o *SPI1_Type) GetCMD_FLASH_WRDI() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x20000000) >> 29
}
func (o *SPI1_Type) SetCMD_FLASH_WREN(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x40000000)|value<<30)
}
func (o *SPI1_Type) GetCMD_FLASH_WREN() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x40000000) >> 30
}
func (o *SPI1_Type) SetCMD_FLASH_READ(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI1_Type) GetCMD_FLASH_READ() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x80000000) >> 31
}

// SPI1.ADDR: SPI1 address register
func (o *SPI1_Type) SetADDR(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, value)
}
func (o *SPI1_Type) GetADDR() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg)
}

// SPI1.CTRL: SPI1 control register.
func (o *SPI1_Type) SetCTRL_FDUMMY_OUT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *SPI1_Type) GetCTRL_FDUMMY_OUT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *SPI1_Type) SetCTRL_FCMD_DUAL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *SPI1_Type) GetCTRL_FCMD_DUAL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80) >> 7
}
func (o *SPI1_Type) SetCTRL_FCMD_QUAD(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100)|value<<8)
}
func (o *SPI1_Type) GetCTRL_FCMD_QUAD() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100) >> 8
}
func (o *SPI1_Type) SetCTRL_FCS_CRC_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x400)|value<<10)
}
func (o *SPI1_Type) GetCTRL_FCS_CRC_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x400) >> 10
}
func (o *SPI1_Type) SetCTRL_TX_CRC_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x800)|value<<11)
}
func (o *SPI1_Type) GetCTRL_TX_CRC_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x800) >> 11
}
func (o *SPI1_Type) SetCTRL_FASTRD_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *SPI1_Type) GetCTRL_FASTRD_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2000) >> 13
}
func (o *SPI1_Type) SetCTRL_FREAD_DUAL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SPI1_Type) GetCTRL_FREAD_DUAL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4000) >> 14
}
func (o *SPI1_Type) SetCTRL_RESANDRES(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *SPI1_Type) GetCTRL_RESANDRES() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8000) >> 15
}
func (o *SPI1_Type) SetCTRL_Q_POL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *SPI1_Type) GetCTRL_Q_POL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40000) >> 18
}
func (o *SPI1_Type) SetCTRL_D_POL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80000)|value<<19)
}
func (o *SPI1_Type) GetCTRL_D_POL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80000) >> 19
}
func (o *SPI1_Type) SetCTRL_FREAD_QUAD(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SPI1_Type) GetCTRL_FREAD_QUAD() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100000) >> 20
}
func (o *SPI1_Type) SetCTRL_WP(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x200000)|value<<21)
}
func (o *SPI1_Type) GetCTRL_WP() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x200000) >> 21
}
func (o *SPI1_Type) SetCTRL_WRSR_2B(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *SPI1_Type) GetCTRL_WRSR_2B() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x400000) >> 22
}
func (o *SPI1_Type) SetCTRL_FREAD_DIO(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x800000)|value<<23)
}
func (o *SPI1_Type) GetCTRL_FREAD_DIO() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x800000) >> 23
}
func (o *SPI1_Type) SetCTRL_FREAD_QIO(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI1_Type) GetCTRL_FREAD_QIO() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1000000) >> 24
}

// SPI1.CTRL1: SPI1 control1 register.
func (o *SPI1_Type) SetCTRL1_CLK_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x3)|value)
}
func (o *SPI1_Type) GetCTRL1_CLK_MODE() uint32 {
	return volatile.LoadUint32(&o.CTRL1.Reg) & 0x3
}
func (o *SPI1_Type) SetCTRL1_CS_HOLD_DLY_RES(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0xffc)|value<<2)
}
func (o *SPI1_Type) GetCTRL1_CS_HOLD_DLY_RES() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0xffc) >> 2
}

// SPI1.CTRL2: SPI1 control2 register.
func (o *SPI1_Type) SetCTRL2_SYNC_RESET(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI1_Type) GetCTRL2_SYNC_RESET() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x80000000) >> 31
}

// SPI1.CLOCK: SPI1 clock division control register.
func (o *SPI1_Type) SetCLOCK_CLKCNT_L(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0xff)|value)
}
func (o *SPI1_Type) GetCLOCK_CLKCNT_L() uint32 {
	return volatile.LoadUint32(&o.CLOCK.Reg) & 0xff
}
func (o *SPI1_Type) SetCLOCK_CLKCNT_H(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0xff00)|value<<8)
}
func (o *SPI1_Type) GetCLOCK_CLKCNT_H() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0xff00) >> 8
}
func (o *SPI1_Type) SetCLOCK_CLKCNT_N(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0xff0000)|value<<16)
}
func (o *SPI1_Type) GetCLOCK_CLKCNT_N() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0xff0000) >> 16
}
func (o *SPI1_Type) SetCLOCK_CLK_EQU_SYSCLK(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI1_Type) GetCLOCK_CLK_EQU_SYSCLK() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0x80000000) >> 31
}

// SPI1.USER: SPI1 user register.
func (o *SPI1_Type) SetUSER_CK_OUT_EDGE(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x200)|value<<9)
}
func (o *SPI1_Type) GetUSER_CK_OUT_EDGE() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x200) >> 9
}
func (o *SPI1_Type) SetUSER_FWRITE_DUAL(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x1000)|value<<12)
}
func (o *SPI1_Type) GetUSER_FWRITE_DUAL() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x1000) >> 12
}
func (o *SPI1_Type) SetUSER_FWRITE_QUAD(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x2000)|value<<13)
}
func (o *SPI1_Type) GetUSER_FWRITE_QUAD() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x2000) >> 13
}
func (o *SPI1_Type) SetUSER_FWRITE_DIO(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x4000)|value<<14)
}
func (o *SPI1_Type) GetUSER_FWRITE_DIO() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x4000) >> 14
}
func (o *SPI1_Type) SetUSER_FWRITE_QIO(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x8000)|value<<15)
}
func (o *SPI1_Type) GetUSER_FWRITE_QIO() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x8000) >> 15
}
func (o *SPI1_Type) SetUSER_USR_MISO_HIGHPART(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI1_Type) GetUSER_USR_MISO_HIGHPART() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x1000000) >> 24
}
func (o *SPI1_Type) SetUSER_USR_MOSI_HIGHPART(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x2000000)|value<<25)
}
func (o *SPI1_Type) GetUSER_USR_MOSI_HIGHPART() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x2000000) >> 25
}
func (o *SPI1_Type) SetUSER_USR_DUMMY_IDLE(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x4000000)|value<<26)
}
func (o *SPI1_Type) GetUSER_USR_DUMMY_IDLE() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x4000000) >> 26
}
func (o *SPI1_Type) SetUSER_USR_MOSI(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x8000000)|value<<27)
}
func (o *SPI1_Type) GetUSER_USR_MOSI() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x8000000) >> 27
}
func (o *SPI1_Type) SetUSER_USR_MISO(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x10000000)|value<<28)
}
func (o *SPI1_Type) GetUSER_USR_MISO() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x10000000) >> 28
}
func (o *SPI1_Type) SetUSER_USR_DUMMY(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x20000000)|value<<29)
}
func (o *SPI1_Type) GetUSER_USR_DUMMY() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x20000000) >> 29
}
func (o *SPI1_Type) SetUSER_USR_ADDR(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x40000000)|value<<30)
}
func (o *SPI1_Type) GetUSER_USR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x40000000) >> 30
}
func (o *SPI1_Type) SetUSER_USR_COMMAND(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI1_Type) GetUSER_USR_COMMAND() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x80000000) >> 31
}

// SPI1.USER1: SPI1 user1 register.
func (o *SPI1_Type) SetUSER1_USR_DUMMY_CYCLELEN(value uint32) {
	volatile.StoreUint32(&o.USER1.Reg, volatile.LoadUint32(&o.USER1.Reg)&^(0x3f)|value)
}
func (o *SPI1_Type) GetUSER1_USR_DUMMY_CYCLELEN() uint32 {
	return volatile.LoadUint32(&o.USER1.Reg) & 0x3f
}
func (o *SPI1_Type) SetUSER1_USR_ADDR_BITLEN(value uint32) {
	volatile.StoreUint32(&o.USER1.Reg, volatile.LoadUint32(&o.USER1.Reg)&^(0xfc000000)|value<<26)
}
func (o *SPI1_Type) GetUSER1_USR_ADDR_BITLEN() uint32 {
	return (volatile.LoadUint32(&o.USER1.Reg) & 0xfc000000) >> 26
}

// SPI1.USER2: SPI1 user2 register.
func (o *SPI1_Type) SetUSER2_USR_COMMAND_VALUE(value uint32) {
	volatile.StoreUint32(&o.USER2.Reg, volatile.LoadUint32(&o.USER2.Reg)&^(0xffff)|value)
}
func (o *SPI1_Type) GetUSER2_USR_COMMAND_VALUE() uint32 {
	return volatile.LoadUint32(&o.USER2.Reg) & 0xffff
}
func (o *SPI1_Type) SetUSER2_USR_COMMAND_BITLEN(value uint32) {
	volatile.StoreUint32(&o.USER2.Reg, volatile.LoadUint32(&o.USER2.Reg)&^(0xf0000000)|value<<28)
}
func (o *SPI1_Type) GetUSER2_USR_COMMAND_BITLEN() uint32 {
	return (volatile.LoadUint32(&o.USER2.Reg) & 0xf0000000) >> 28
}

// SPI1.MOSI_DLEN: SPI1 send data bit length control register.
func (o *SPI1_Type) SetMOSI_DLEN_USR_MOSI_DBITLEN(value uint32) {
	volatile.StoreUint32(&o.MOSI_DLEN.Reg, volatile.LoadUint32(&o.MOSI_DLEN.Reg)&^(0x3ff)|value)
}
func (o *SPI1_Type) GetMOSI_DLEN_USR_MOSI_DBITLEN() uint32 {
	return volatile.LoadUint32(&o.MOSI_DLEN.Reg) & 0x3ff
}

// SPI1.MISO_DLEN: SPI1 receive data bit length control register.
func (o *SPI1_Type) SetMISO_DLEN_USR_MISO_DBITLEN(value uint32) {
	volatile.StoreUint32(&o.MISO_DLEN.Reg, volatile.LoadUint32(&o.MISO_DLEN.Reg)&^(0x3ff)|value)
}
func (o *SPI1_Type) GetMISO_DLEN_USR_MISO_DBITLEN() uint32 {
	return volatile.LoadUint32(&o.MISO_DLEN.Reg) & 0x3ff
}

// SPI1.RD_STATUS: SPI1 status register.
func (o *SPI1_Type) SetRD_STATUS_STATUS(value uint32) {
	volatile.StoreUint32(&o.RD_STATUS.Reg, volatile.LoadUint32(&o.RD_STATUS.Reg)&^(0xffff)|value)
}
func (o *SPI1_Type) GetRD_STATUS_STATUS() uint32 {
	return volatile.LoadUint32(&o.RD_STATUS.Reg) & 0xffff
}
func (o *SPI1_Type) SetRD_STATUS_WB_MODE(value uint32) {
	volatile.StoreUint32(&o.RD_STATUS.Reg, volatile.LoadUint32(&o.RD_STATUS.Reg)&^(0xff0000)|value<<16)
}
func (o *SPI1_Type) GetRD_STATUS_WB_MODE() uint32 {
	return (volatile.LoadUint32(&o.RD_STATUS.Reg) & 0xff0000) >> 16
}

// SPI1.MISC: SPI1 misc register
func (o *SPI1_Type) SetMISC_CS0_DIS(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x1)|value)
}
func (o *SPI1_Type) GetMISC_CS0_DIS() uint32 {
	return volatile.LoadUint32(&o.MISC.Reg) & 0x1
}
func (o *SPI1_Type) SetMISC_CS1_DIS(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x2)|value<<1)
}
func (o *SPI1_Type) GetMISC_CS1_DIS() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x2) >> 1
}
func (o *SPI1_Type) SetMISC_CK_IDLE_EDGE(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x200)|value<<9)
}
func (o *SPI1_Type) GetMISC_CK_IDLE_EDGE() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x200) >> 9
}
func (o *SPI1_Type) SetMISC_CS_KEEP_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x400)|value<<10)
}
func (o *SPI1_Type) GetMISC_CS_KEEP_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x400) >> 10
}

// SPI1.TX_CRC: SPI1 TX CRC data register.
func (o *SPI1_Type) SetTX_CRC(value uint32) {
	volatile.StoreUint32(&o.TX_CRC.Reg, value)
}
func (o *SPI1_Type) GetTX_CRC() uint32 {
	return volatile.LoadUint32(&o.TX_CRC.Reg)
}

// SPI1.CACHE_FCTRL: SPI1 bit mode control register.
func (o *SPI1_Type) SetCACHE_FCTRL_CACHE_USR_ADDR_4BYTE(value uint32) {
	volatile.StoreUint32(&o.CACHE_FCTRL.Reg, volatile.LoadUint32(&o.CACHE_FCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SPI1_Type) GetCACHE_FCTRL_CACHE_USR_ADDR_4BYTE() uint32 {
	return (volatile.LoadUint32(&o.CACHE_FCTRL.Reg) & 0x2) >> 1
}
func (o *SPI1_Type) SetCACHE_FCTRL_FDIN_DUAL(value uint32) {
	volatile.StoreUint32(&o.CACHE_FCTRL.Reg, volatile.LoadUint32(&o.CACHE_FCTRL.Reg)&^(0x8)|value<<3)
}
func (o *SPI1_Type) GetCACHE_FCTRL_FDIN_DUAL() uint32 {
	return (volatile.LoadUint32(&o.CACHE_FCTRL.Reg) & 0x8) >> 3
}
func (o *SPI1_Type) SetCACHE_FCTRL_FDOUT_DUAL(value uint32) {
	volatile.StoreUint32(&o.CACHE_FCTRL.Reg, volatile.LoadUint32(&o.CACHE_FCTRL.Reg)&^(0x10)|value<<4)
}
func (o *SPI1_Type) GetCACHE_FCTRL_FDOUT_DUAL() uint32 {
	return (volatile.LoadUint32(&o.CACHE_FCTRL.Reg) & 0x10) >> 4
}
func (o *SPI1_Type) SetCACHE_FCTRL_FADDR_DUAL(value uint32) {
	volatile.StoreUint32(&o.CACHE_FCTRL.Reg, volatile.LoadUint32(&o.CACHE_FCTRL.Reg)&^(0x20)|value<<5)
}
func (o *SPI1_Type) GetCACHE_FCTRL_FADDR_DUAL() uint32 {
	return (volatile.LoadUint32(&o.CACHE_FCTRL.Reg) & 0x20) >> 5
}
func (o *SPI1_Type) SetCACHE_FCTRL_FDIN_QUAD(value uint32) {
	volatile.StoreUint32(&o.CACHE_FCTRL.Reg, volatile.LoadUint32(&o.CACHE_FCTRL.Reg)&^(0x40)|value<<6)
}
func (o *SPI1_Type) GetCACHE_FCTRL_FDIN_QUAD() uint32 {
	return (volatile.LoadUint32(&o.CACHE_FCTRL.Reg) & 0x40) >> 6
}
func (o *SPI1_Type) SetCACHE_FCTRL_FDOUT_QUAD(value uint32) {
	volatile.StoreUint32(&o.CACHE_FCTRL.Reg, volatile.LoadUint32(&o.CACHE_FCTRL.Reg)&^(0x80)|value<<7)
}
func (o *SPI1_Type) GetCACHE_FCTRL_FDOUT_QUAD() uint32 {
	return (volatile.LoadUint32(&o.CACHE_FCTRL.Reg) & 0x80) >> 7
}
func (o *SPI1_Type) SetCACHE_FCTRL_FADDR_QUAD(value uint32) {
	volatile.StoreUint32(&o.CACHE_FCTRL.Reg, volatile.LoadUint32(&o.CACHE_FCTRL.Reg)&^(0x100)|value<<8)
}
func (o *SPI1_Type) GetCACHE_FCTRL_FADDR_QUAD() uint32 {
	return (volatile.LoadUint32(&o.CACHE_FCTRL.Reg) & 0x100) >> 8
}

// SPI1.W0: SPI1 memory data buffer0
func (o *SPI1_Type) SetW0(value uint32) {
	volatile.StoreUint32(&o.W0.Reg, value)
}
func (o *SPI1_Type) GetW0() uint32 {
	return volatile.LoadUint32(&o.W0.Reg)
}

// SPI1.W1: SPI1 memory data buffer1
func (o *SPI1_Type) SetW1(value uint32) {
	volatile.StoreUint32(&o.W1.Reg, value)
}
func (o *SPI1_Type) GetW1() uint32 {
	return volatile.LoadUint32(&o.W1.Reg)
}

// SPI1.W2: SPI1 memory data buffer2
func (o *SPI1_Type) SetW2(value uint32) {
	volatile.StoreUint32(&o.W2.Reg, value)
}
func (o *SPI1_Type) GetW2() uint32 {
	return volatile.LoadUint32(&o.W2.Reg)
}

// SPI1.W3: SPI1 memory data buffer3
func (o *SPI1_Type) SetW3(value uint32) {
	volatile.StoreUint32(&o.W3.Reg, value)
}
func (o *SPI1_Type) GetW3() uint32 {
	return volatile.LoadUint32(&o.W3.Reg)
}

// SPI1.W4: SPI1 memory data buffer4
func (o *SPI1_Type) SetW4(value uint32) {
	volatile.StoreUint32(&o.W4.Reg, value)
}
func (o *SPI1_Type) GetW4() uint32 {
	return volatile.LoadUint32(&o.W4.Reg)
}

// SPI1.W5: SPI1 memory data buffer5
func (o *SPI1_Type) SetW5(value uint32) {
	volatile.StoreUint32(&o.W5.Reg, value)
}
func (o *SPI1_Type) GetW5() uint32 {
	return volatile.LoadUint32(&o.W5.Reg)
}

// SPI1.W6: SPI1 memory data buffer6
func (o *SPI1_Type) SetW6(value uint32) {
	volatile.StoreUint32(&o.W6.Reg, value)
}
func (o *SPI1_Type) GetW6() uint32 {
	return volatile.LoadUint32(&o.W6.Reg)
}

// SPI1.W7: SPI1 memory data buffer7
func (o *SPI1_Type) SetW7(value uint32) {
	volatile.StoreUint32(&o.W7.Reg, value)
}
func (o *SPI1_Type) GetW7() uint32 {
	return volatile.LoadUint32(&o.W7.Reg)
}

// SPI1.W8: SPI1 memory data buffer8
func (o *SPI1_Type) SetW8(value uint32) {
	volatile.StoreUint32(&o.W8.Reg, value)
}
func (o *SPI1_Type) GetW8() uint32 {
	return volatile.LoadUint32(&o.W8.Reg)
}

// SPI1.W9: SPI1 memory data buffer9
func (o *SPI1_Type) SetW9(value uint32) {
	volatile.StoreUint32(&o.W9.Reg, value)
}
func (o *SPI1_Type) GetW9() uint32 {
	return volatile.LoadUint32(&o.W9.Reg)
}

// SPI1.W10: SPI1 memory data buffer10
func (o *SPI1_Type) SetW10(value uint32) {
	volatile.StoreUint32(&o.W10.Reg, value)
}
func (o *SPI1_Type) GetW10() uint32 {
	return volatile.LoadUint32(&o.W10.Reg)
}

// SPI1.W11: SPI1 memory data buffer11
func (o *SPI1_Type) SetW11(value uint32) {
	volatile.StoreUint32(&o.W11.Reg, value)
}
func (o *SPI1_Type) GetW11() uint32 {
	return volatile.LoadUint32(&o.W11.Reg)
}

// SPI1.W12: SPI1 memory data buffer12
func (o *SPI1_Type) SetW12(value uint32) {
	volatile.StoreUint32(&o.W12.Reg, value)
}
func (o *SPI1_Type) GetW12() uint32 {
	return volatile.LoadUint32(&o.W12.Reg)
}

// SPI1.W13: SPI1 memory data buffer13
func (o *SPI1_Type) SetW13(value uint32) {
	volatile.StoreUint32(&o.W13.Reg, value)
}
func (o *SPI1_Type) GetW13() uint32 {
	return volatile.LoadUint32(&o.W13.Reg)
}

// SPI1.W14: SPI1 memory data buffer14
func (o *SPI1_Type) SetW14(value uint32) {
	volatile.StoreUint32(&o.W14.Reg, value)
}
func (o *SPI1_Type) GetW14() uint32 {
	return volatile.LoadUint32(&o.W14.Reg)
}

// SPI1.W15: SPI1 memory data buffer15
func (o *SPI1_Type) SetW15(value uint32) {
	volatile.StoreUint32(&o.W15.Reg, value)
}
func (o *SPI1_Type) GetW15() uint32 {
	return volatile.LoadUint32(&o.W15.Reg)
}

// SPI1.FLASH_WAITI_CTRL: SPI1 wait idle control register
func (o *SPI1_Type) SetFLASH_WAITI_CTRL_WAITI_DUMMY(value uint32) {
	volatile.StoreUint32(&o.FLASH_WAITI_CTRL.Reg, volatile.LoadUint32(&o.FLASH_WAITI_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *SPI1_Type) GetFLASH_WAITI_CTRL_WAITI_DUMMY() uint32 {
	return (volatile.LoadUint32(&o.FLASH_WAITI_CTRL.Reg) & 0x2) >> 1
}
func (o *SPI1_Type) SetFLASH_WAITI_CTRL_WAITI_CMD(value uint32) {
	volatile.StoreUint32(&o.FLASH_WAITI_CTRL.Reg, volatile.LoadUint32(&o.FLASH_WAITI_CTRL.Reg)&^(0x3fc)|value<<2)
}
func (o *SPI1_Type) GetFLASH_WAITI_CTRL_WAITI_CMD() uint32 {
	return (volatile.LoadUint32(&o.FLASH_WAITI_CTRL.Reg) & 0x3fc) >> 2
}
func (o *SPI1_Type) SetFLASH_WAITI_CTRL_WAITI_DUMMY_CYCLELEN(value uint32) {
	volatile.StoreUint32(&o.FLASH_WAITI_CTRL.Reg, volatile.LoadUint32(&o.FLASH_WAITI_CTRL.Reg)&^(0xfc00)|value<<10)
}
func (o *SPI1_Type) GetFLASH_WAITI_CTRL_WAITI_DUMMY_CYCLELEN() uint32 {
	return (volatile.LoadUint32(&o.FLASH_WAITI_CTRL.Reg) & 0xfc00) >> 10
}

// SPI1.FLASH_SUS_CTRL: SPI1 flash suspend control register
func (o *SPI1_Type) SetFLASH_SUS_CTRL_FLASH_PER(value uint32) {
	volatile.StoreUint32(&o.FLASH_SUS_CTRL.Reg, volatile.LoadUint32(&o.FLASH_SUS_CTRL.Reg)&^(0x1)|value)
}
func (o *SPI1_Type) GetFLASH_SUS_CTRL_FLASH_PER() uint32 {
	return volatile.LoadUint32(&o.FLASH_SUS_CTRL.Reg) & 0x1
}
func (o *SPI1_Type) SetFLASH_SUS_CTRL_FLASH_PES(value uint32) {
	volatile.StoreUint32(&o.FLASH_SUS_CTRL.Reg, volatile.LoadUint32(&o.FLASH_SUS_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *SPI1_Type) GetFLASH_SUS_CTRL_FLASH_PES() uint32 {
	return (volatile.LoadUint32(&o.FLASH_SUS_CTRL.Reg) & 0x2) >> 1
}
func (o *SPI1_Type) SetFLASH_SUS_CTRL_FLASH_PER_WAIT_EN(value uint32) {
	volatile.StoreUint32(&o.FLASH_SUS_CTRL.Reg, volatile.LoadUint32(&o.FLASH_SUS_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *SPI1_Type) GetFLASH_SUS_CTRL_FLASH_PER_WAIT_EN() uint32 {
	return (volatile.LoadUint32(&o.FLASH_SUS_CTRL.Reg) & 0x4) >> 2
}
func (o *SPI1_Type) SetFLASH_SUS_CTRL_FLASH_PES_WAIT_EN(value uint32) {
	volatile.StoreUint32(&o.FLASH_SUS_CTRL.Reg, volatile.LoadUint32(&o.FLASH_SUS_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *SPI1_Type) GetFLASH_SUS_CTRL_FLASH_PES_WAIT_EN() uint32 {
	return (volatile.LoadUint32(&o.FLASH_SUS_CTRL.Reg) & 0x8) >> 3
}
func (o *SPI1_Type) SetFLASH_SUS_CTRL_PES_PER_EN(value uint32) {
	volatile.StoreUint32(&o.FLASH_SUS_CTRL.Reg, volatile.LoadUint32(&o.FLASH_SUS_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SPI1_Type) GetFLASH_SUS_CTRL_PES_PER_EN() uint32 {
	return (volatile.LoadUint32(&o.FLASH_SUS_CTRL.Reg) & 0x10) >> 4
}
func (o *SPI1_Type) SetFLASH_SUS_CTRL_FLASH_PES_EN(value uint32) {
	volatile.StoreUint32(&o.FLASH_SUS_CTRL.Reg, volatile.LoadUint32(&o.FLASH_SUS_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SPI1_Type) GetFLASH_SUS_CTRL_FLASH_PES_EN() uint32 {
	return (volatile.LoadUint32(&o.FLASH_SUS_CTRL.Reg) & 0x20) >> 5
}
func (o *SPI1_Type) SetFLASH_SUS_CTRL_PESR_END_MSK(value uint32) {
	volatile.StoreUint32(&o.FLASH_SUS_CTRL.Reg, volatile.LoadUint32(&o.FLASH_SUS_CTRL.Reg)&^(0x3fffc0)|value<<6)
}
func (o *SPI1_Type) GetFLASH_SUS_CTRL_PESR_END_MSK() uint32 {
	return (volatile.LoadUint32(&o.FLASH_SUS_CTRL.Reg) & 0x3fffc0) >> 6
}
func (o *SPI1_Type) SetFLASH_SUS_CTRL_SPI_FMEM_RD_SUS_2B(value uint32) {
	volatile.StoreUint32(&o.FLASH_SUS_CTRL.Reg, volatile.LoadUint32(&o.FLASH_SUS_CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *SPI1_Type) GetFLASH_SUS_CTRL_SPI_FMEM_RD_SUS_2B() uint32 {
	return (volatile.LoadUint32(&o.FLASH_SUS_CTRL.Reg) & 0x400000) >> 22
}
func (o *SPI1_Type) SetFLASH_SUS_CTRL_PER_END_EN(value uint32) {
	volatile.StoreUint32(&o.FLASH_SUS_CTRL.Reg, volatile.LoadUint32(&o.FLASH_SUS_CTRL.Reg)&^(0x800000)|value<<23)
}
func (o *SPI1_Type) GetFLASH_SUS_CTRL_PER_END_EN() uint32 {
	return (volatile.LoadUint32(&o.FLASH_SUS_CTRL.Reg) & 0x800000) >> 23
}
func (o *SPI1_Type) SetFLASH_SUS_CTRL_PES_END_EN(value uint32) {
	volatile.StoreUint32(&o.FLASH_SUS_CTRL.Reg, volatile.LoadUint32(&o.FLASH_SUS_CTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI1_Type) GetFLASH_SUS_CTRL_PES_END_EN() uint32 {
	return (volatile.LoadUint32(&o.FLASH_SUS_CTRL.Reg) & 0x1000000) >> 24
}
func (o *SPI1_Type) SetFLASH_SUS_CTRL_SUS_TIMEOUT_CNT(value uint32) {
	volatile.StoreUint32(&o.FLASH_SUS_CTRL.Reg, volatile.LoadUint32(&o.FLASH_SUS_CTRL.Reg)&^(0xfe000000)|value<<25)
}
func (o *SPI1_Type) GetFLASH_SUS_CTRL_SUS_TIMEOUT_CNT() uint32 {
	return (volatile.LoadUint32(&o.FLASH_SUS_CTRL.Reg) & 0xfe000000) >> 25
}

// SPI1.FLASH_SUS_CMD: SPI1 flash suspend command register
func (o *SPI1_Type) SetFLASH_SUS_CMD_FLASH_PER_COMMAND(value uint32) {
	volatile.StoreUint32(&o.FLASH_SUS_CMD.Reg, volatile.LoadUint32(&o.FLASH_SUS_CMD.Reg)&^(0xff)|value)
}
func (o *SPI1_Type) GetFLASH_SUS_CMD_FLASH_PER_COMMAND() uint32 {
	return volatile.LoadUint32(&o.FLASH_SUS_CMD.Reg) & 0xff
}
func (o *SPI1_Type) SetFLASH_SUS_CMD_FLASH_PES_COMMAND(value uint32) {
	volatile.StoreUint32(&o.FLASH_SUS_CMD.Reg, volatile.LoadUint32(&o.FLASH_SUS_CMD.Reg)&^(0xff00)|value<<8)
}
func (o *SPI1_Type) GetFLASH_SUS_CMD_FLASH_PES_COMMAND() uint32 {
	return (volatile.LoadUint32(&o.FLASH_SUS_CMD.Reg) & 0xff00) >> 8
}
func (o *SPI1_Type) SetFLASH_SUS_CMD_WAIT_PESR_COMMAND(value uint32) {
	volatile.StoreUint32(&o.FLASH_SUS_CMD.Reg, volatile.LoadUint32(&o.FLASH_SUS_CMD.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI1_Type) GetFLASH_SUS_CMD_WAIT_PESR_COMMAND() uint32 {
	return (volatile.LoadUint32(&o.FLASH_SUS_CMD.Reg) & 0xffff0000) >> 16
}

// SPI1.SUS_STATUS: SPI1 flash suspend status register
func (o *SPI1_Type) SetSUS_STATUS_FLASH_SUS(value uint32) {
	volatile.StoreUint32(&o.SUS_STATUS.Reg, volatile.LoadUint32(&o.SUS_STATUS.Reg)&^(0x1)|value)
}
func (o *SPI1_Type) GetSUS_STATUS_FLASH_SUS() uint32 {
	return volatile.LoadUint32(&o.SUS_STATUS.Reg) & 0x1
}
func (o *SPI1_Type) SetSUS_STATUS_WAIT_PESR_CMD_2B(value uint32) {
	volatile.StoreUint32(&o.SUS_STATUS.Reg, volatile.LoadUint32(&o.SUS_STATUS.Reg)&^(0x2)|value<<1)
}
func (o *SPI1_Type) GetSUS_STATUS_WAIT_PESR_CMD_2B() uint32 {
	return (volatile.LoadUint32(&o.SUS_STATUS.Reg) & 0x2) >> 1
}
func (o *SPI1_Type) SetSUS_STATUS_FLASH_HPM_DLY_128(value uint32) {
	volatile.StoreUint32(&o.SUS_STATUS.Reg, volatile.LoadUint32(&o.SUS_STATUS.Reg)&^(0x4)|value<<2)
}
func (o *SPI1_Type) GetSUS_STATUS_FLASH_HPM_DLY_128() uint32 {
	return (volatile.LoadUint32(&o.SUS_STATUS.Reg) & 0x4) >> 2
}
func (o *SPI1_Type) SetSUS_STATUS_FLASH_RES_DLY_128(value uint32) {
	volatile.StoreUint32(&o.SUS_STATUS.Reg, volatile.LoadUint32(&o.SUS_STATUS.Reg)&^(0x8)|value<<3)
}
func (o *SPI1_Type) GetSUS_STATUS_FLASH_RES_DLY_128() uint32 {
	return (volatile.LoadUint32(&o.SUS_STATUS.Reg) & 0x8) >> 3
}
func (o *SPI1_Type) SetSUS_STATUS_FLASH_DP_DLY_128(value uint32) {
	volatile.StoreUint32(&o.SUS_STATUS.Reg, volatile.LoadUint32(&o.SUS_STATUS.Reg)&^(0x10)|value<<4)
}
func (o *SPI1_Type) GetSUS_STATUS_FLASH_DP_DLY_128() uint32 {
	return (volatile.LoadUint32(&o.SUS_STATUS.Reg) & 0x10) >> 4
}
func (o *SPI1_Type) SetSUS_STATUS_FLASH_PER_DLY_128(value uint32) {
	volatile.StoreUint32(&o.SUS_STATUS.Reg, volatile.LoadUint32(&o.SUS_STATUS.Reg)&^(0x20)|value<<5)
}
func (o *SPI1_Type) GetSUS_STATUS_FLASH_PER_DLY_128() uint32 {
	return (volatile.LoadUint32(&o.SUS_STATUS.Reg) & 0x20) >> 5
}
func (o *SPI1_Type) SetSUS_STATUS_FLASH_PES_DLY_128(value uint32) {
	volatile.StoreUint32(&o.SUS_STATUS.Reg, volatile.LoadUint32(&o.SUS_STATUS.Reg)&^(0x40)|value<<6)
}
func (o *SPI1_Type) GetSUS_STATUS_FLASH_PES_DLY_128() uint32 {
	return (volatile.LoadUint32(&o.SUS_STATUS.Reg) & 0x40) >> 6
}
func (o *SPI1_Type) SetSUS_STATUS_SPI0_LOCK_EN(value uint32) {
	volatile.StoreUint32(&o.SUS_STATUS.Reg, volatile.LoadUint32(&o.SUS_STATUS.Reg)&^(0x80)|value<<7)
}
func (o *SPI1_Type) GetSUS_STATUS_SPI0_LOCK_EN() uint32 {
	return (volatile.LoadUint32(&o.SUS_STATUS.Reg) & 0x80) >> 7
}

// SPI1.TIMING_CALI: SPI1 timing control register
func (o *SPI1_Type) SetTIMING_CALI(value uint32) {
	volatile.StoreUint32(&o.TIMING_CALI.Reg, volatile.LoadUint32(&o.TIMING_CALI.Reg)&^(0x2)|value<<1)
}
func (o *SPI1_Type) GetTIMING_CALI() uint32 {
	return (volatile.LoadUint32(&o.TIMING_CALI.Reg) & 0x2) >> 1
}
func (o *SPI1_Type) SetTIMING_CALI_EXTRA_DUMMY_CYCLELEN(value uint32) {
	volatile.StoreUint32(&o.TIMING_CALI.Reg, volatile.LoadUint32(&o.TIMING_CALI.Reg)&^(0x1c)|value<<2)
}
func (o *SPI1_Type) GetTIMING_CALI_EXTRA_DUMMY_CYCLELEN() uint32 {
	return (volatile.LoadUint32(&o.TIMING_CALI.Reg) & 0x1c) >> 2
}

// SPI1.INT_ENA: SPI1 interrupt enable register
func (o *SPI1_Type) SetINT_ENA_PER_END_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *SPI1_Type) GetINT_ENA_PER_END_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *SPI1_Type) SetINT_ENA_PES_END_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *SPI1_Type) GetINT_ENA_PES_END_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}
func (o *SPI1_Type) SetINT_ENA_WPE_END_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *SPI1_Type) GetINT_ENA_WPE_END_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4) >> 2
}
func (o *SPI1_Type) SetINT_ENA_SLV_ST_END_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *SPI1_Type) GetINT_ENA_SLV_ST_END_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8) >> 3
}
func (o *SPI1_Type) SetINT_ENA_MST_ST_END_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *SPI1_Type) GetINT_ENA_MST_ST_END_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10) >> 4
}
func (o *SPI1_Type) SetINT_ENA_BROWN_OUT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *SPI1_Type) GetINT_ENA_BROWN_OUT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20) >> 5
}

// SPI1.INT_CLR: SPI1 interrupt clear register
func (o *SPI1_Type) SetINT_CLR_PER_END_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *SPI1_Type) GetINT_CLR_PER_END_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *SPI1_Type) SetINT_CLR_PES_END_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *SPI1_Type) GetINT_CLR_PES_END_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}
func (o *SPI1_Type) SetINT_CLR_WPE_END_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *SPI1_Type) GetINT_CLR_WPE_END_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4) >> 2
}
func (o *SPI1_Type) SetINT_CLR_SLV_ST_END_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *SPI1_Type) GetINT_CLR_SLV_ST_END_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8) >> 3
}
func (o *SPI1_Type) SetINT_CLR_MST_ST_END_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *SPI1_Type) GetINT_CLR_MST_ST_END_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10) >> 4
}
func (o *SPI1_Type) SetINT_CLR_BROWN_OUT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *SPI1_Type) GetINT_CLR_BROWN_OUT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20) >> 5
}

// SPI1.INT_RAW: SPI1 interrupt raw register
func (o *SPI1_Type) SetINT_RAW_PER_END_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *SPI1_Type) GetINT_RAW_PER_END_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *SPI1_Type) SetINT_RAW_PES_END_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *SPI1_Type) GetINT_RAW_PES_END_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}
func (o *SPI1_Type) SetINT_RAW_WPE_END_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *SPI1_Type) GetINT_RAW_WPE_END_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4) >> 2
}
func (o *SPI1_Type) SetINT_RAW_SLV_ST_END_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *SPI1_Type) GetINT_RAW_SLV_ST_END_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8) >> 3
}
func (o *SPI1_Type) SetINT_RAW_MST_ST_END_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *SPI1_Type) GetINT_RAW_MST_ST_END_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10) >> 4
}
func (o *SPI1_Type) SetINT_RAW_BROWN_OUT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *SPI1_Type) GetINT_RAW_BROWN_OUT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20) >> 5
}

// SPI1.INT_ST: SPI1 interrupt status register
func (o *SPI1_Type) SetINT_ST_PER_END_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1)|value)
}
func (o *SPI1_Type) GetINT_ST_PER_END_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST.Reg) & 0x1
}
func (o *SPI1_Type) SetINT_ST_PES_END_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *SPI1_Type) GetINT_ST_PES_END_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2) >> 1
}
func (o *SPI1_Type) SetINT_ST_WPE_END_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *SPI1_Type) GetINT_ST_WPE_END_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4) >> 2
}
func (o *SPI1_Type) SetINT_ST_SLV_ST_END_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *SPI1_Type) GetINT_ST_SLV_ST_END_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x8) >> 3
}
func (o *SPI1_Type) SetINT_ST_MST_ST_END_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x10)|value<<4)
}
func (o *SPI1_Type) GetINT_ST_MST_ST_END_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x10) >> 4
}
func (o *SPI1_Type) SetINT_ST_BROWN_OUT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x20)|value<<5)
}
func (o *SPI1_Type) GetINT_ST_BROWN_OUT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x20) >> 5
}

// SPI1.CLOCK_GATE: SPI1 clk_gate register
func (o *SPI1_Type) SetCLOCK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *SPI1_Type) GetCLOCK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// SPI1.DATE: Version control register
func (o *SPI1_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *SPI1_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// SPI (Serial Peripheral Interface) Controller 2
type SPI2_Type struct {
	CMD         volatile.Register32 // 0x0
	ADDR        volatile.Register32 // 0x4
	CTRL        volatile.Register32 // 0x8
	CLOCK       volatile.Register32 // 0xC
	USER        volatile.Register32 // 0x10
	USER1       volatile.Register32 // 0x14
	USER2       volatile.Register32 // 0x18
	MS_DLEN     volatile.Register32 // 0x1C
	MISC        volatile.Register32 // 0x20
	DIN_MODE    volatile.Register32 // 0x24
	DIN_NUM     volatile.Register32 // 0x28
	DOUT_MODE   volatile.Register32 // 0x2C
	DMA_CONF    volatile.Register32 // 0x30
	DMA_INT_ENA volatile.Register32 // 0x34
	DMA_INT_CLR volatile.Register32 // 0x38
	DMA_INT_RAW volatile.Register32 // 0x3C
	DMA_INT_ST  volatile.Register32 // 0x40
	DMA_INT_SET volatile.Register32 // 0x44
	_           [80]byte
	W0          volatile.Register32 // 0x98
	W1          volatile.Register32 // 0x9C
	W2          volatile.Register32 // 0xA0
	W3          volatile.Register32 // 0xA4
	W4          volatile.Register32 // 0xA8
	W5          volatile.Register32 // 0xAC
	W6          volatile.Register32 // 0xB0
	W7          volatile.Register32 // 0xB4
	W8          volatile.Register32 // 0xB8
	W9          volatile.Register32 // 0xBC
	W10         volatile.Register32 // 0xC0
	W11         volatile.Register32 // 0xC4
	W12         volatile.Register32 // 0xC8
	W13         volatile.Register32 // 0xCC
	W14         volatile.Register32 // 0xD0
	W15         volatile.Register32 // 0xD4
	_           [8]byte
	SLAVE       volatile.Register32 // 0xE0
	SLAVE1      volatile.Register32 // 0xE4
	CLK_GATE    volatile.Register32 // 0xE8
	_           [4]byte
	DATE        volatile.Register32 // 0xF0
}

// SPI2.CMD: Command control register
func (o *SPI2_Type) SetCMD_CONF_BITLEN(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x3ffff)|value)
}
func (o *SPI2_Type) GetCMD_CONF_BITLEN() uint32 {
	return volatile.LoadUint32(&o.CMD.Reg) & 0x3ffff
}
func (o *SPI2_Type) SetCMD_UPDATE(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x800000)|value<<23)
}
func (o *SPI2_Type) GetCMD_UPDATE() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x800000) >> 23
}
func (o *SPI2_Type) SetCMD_USR(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI2_Type) GetCMD_USR() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x1000000) >> 24
}

// SPI2.ADDR: Address value register
func (o *SPI2_Type) SetADDR(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, value)
}
func (o *SPI2_Type) GetADDR() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg)
}

// SPI2.CTRL: SPI control register
func (o *SPI2_Type) SetCTRL_DUMMY_OUT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *SPI2_Type) GetCTRL_DUMMY_OUT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *SPI2_Type) SetCTRL_FADDR_DUAL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SPI2_Type) GetCTRL_FADDR_DUAL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20) >> 5
}
func (o *SPI2_Type) SetCTRL_FADDR_QUAD(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40)|value<<6)
}
func (o *SPI2_Type) GetCTRL_FADDR_QUAD() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40) >> 6
}
func (o *SPI2_Type) SetCTRL_FADDR_OCT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *SPI2_Type) GetCTRL_FADDR_OCT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80) >> 7
}
func (o *SPI2_Type) SetCTRL_FCMD_DUAL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100)|value<<8)
}
func (o *SPI2_Type) GetCTRL_FCMD_DUAL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100) >> 8
}
func (o *SPI2_Type) SetCTRL_FCMD_QUAD(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x200)|value<<9)
}
func (o *SPI2_Type) GetCTRL_FCMD_QUAD() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x200) >> 9
}
func (o *SPI2_Type) SetCTRL_FCMD_OCT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x400)|value<<10)
}
func (o *SPI2_Type) GetCTRL_FCMD_OCT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x400) >> 10
}
func (o *SPI2_Type) SetCTRL_FREAD_DUAL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SPI2_Type) GetCTRL_FREAD_DUAL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4000) >> 14
}
func (o *SPI2_Type) SetCTRL_FREAD_QUAD(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *SPI2_Type) GetCTRL_FREAD_QUAD() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8000) >> 15
}
func (o *SPI2_Type) SetCTRL_FREAD_OCT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *SPI2_Type) GetCTRL_FREAD_OCT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000) >> 16
}
func (o *SPI2_Type) SetCTRL_Q_POL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *SPI2_Type) GetCTRL_Q_POL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40000) >> 18
}
func (o *SPI2_Type) SetCTRL_D_POL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80000)|value<<19)
}
func (o *SPI2_Type) GetCTRL_D_POL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80000) >> 19
}
func (o *SPI2_Type) SetCTRL_HOLD_POL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SPI2_Type) GetCTRL_HOLD_POL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100000) >> 20
}
func (o *SPI2_Type) SetCTRL_WP_POL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x200000)|value<<21)
}
func (o *SPI2_Type) GetCTRL_WP_POL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x200000) >> 21
}
func (o *SPI2_Type) SetCTRL_RD_BIT_ORDER(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1800000)|value<<23)
}
func (o *SPI2_Type) GetCTRL_RD_BIT_ORDER() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1800000) >> 23
}
func (o *SPI2_Type) SetCTRL_WR_BIT_ORDER(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x6000000)|value<<25)
}
func (o *SPI2_Type) GetCTRL_WR_BIT_ORDER() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x6000000) >> 25
}

// SPI2.CLOCK: SPI clock control register
func (o *SPI2_Type) SetCLOCK_CLKCNT_L(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0x3f)|value)
}
func (o *SPI2_Type) GetCLOCK_CLKCNT_L() uint32 {
	return volatile.LoadUint32(&o.CLOCK.Reg) & 0x3f
}
func (o *SPI2_Type) SetCLOCK_CLKCNT_H(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0xfc0)|value<<6)
}
func (o *SPI2_Type) GetCLOCK_CLKCNT_H() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0xfc0) >> 6
}
func (o *SPI2_Type) SetCLOCK_CLKCNT_N(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0x3f000)|value<<12)
}
func (o *SPI2_Type) GetCLOCK_CLKCNT_N() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0x3f000) >> 12
}
func (o *SPI2_Type) SetCLOCK_CLKDIV_PRE(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0x3c0000)|value<<18)
}
func (o *SPI2_Type) GetCLOCK_CLKDIV_PRE() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0x3c0000) >> 18
}
func (o *SPI2_Type) SetCLOCK_CLK_EQU_SYSCLK(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI2_Type) GetCLOCK_CLK_EQU_SYSCLK() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0x80000000) >> 31
}

// SPI2.USER: SPI USER control register
func (o *SPI2_Type) SetUSER_DOUTDIN(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x1)|value)
}
func (o *SPI2_Type) GetUSER_DOUTDIN() uint32 {
	return volatile.LoadUint32(&o.USER.Reg) & 0x1
}
func (o *SPI2_Type) SetUSER_QPI_MODE(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x8)|value<<3)
}
func (o *SPI2_Type) GetUSER_QPI_MODE() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x8) >> 3
}
func (o *SPI2_Type) SetUSER_OPI_MODE(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x10)|value<<4)
}
func (o *SPI2_Type) GetUSER_OPI_MODE() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x10) >> 4
}
func (o *SPI2_Type) SetUSER_TSCK_I_EDGE(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x20)|value<<5)
}
func (o *SPI2_Type) GetUSER_TSCK_I_EDGE() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x20) >> 5
}
func (o *SPI2_Type) SetUSER_CS_HOLD(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x40)|value<<6)
}
func (o *SPI2_Type) GetUSER_CS_HOLD() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x40) >> 6
}
func (o *SPI2_Type) SetUSER_CS_SETUP(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x80)|value<<7)
}
func (o *SPI2_Type) GetUSER_CS_SETUP() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x80) >> 7
}
func (o *SPI2_Type) SetUSER_RSCK_I_EDGE(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x100)|value<<8)
}
func (o *SPI2_Type) GetUSER_RSCK_I_EDGE() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x100) >> 8
}
func (o *SPI2_Type) SetUSER_CK_OUT_EDGE(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x200)|value<<9)
}
func (o *SPI2_Type) GetUSER_CK_OUT_EDGE() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x200) >> 9
}
func (o *SPI2_Type) SetUSER_FWRITE_DUAL(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x1000)|value<<12)
}
func (o *SPI2_Type) GetUSER_FWRITE_DUAL() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x1000) >> 12
}
func (o *SPI2_Type) SetUSER_FWRITE_QUAD(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x2000)|value<<13)
}
func (o *SPI2_Type) GetUSER_FWRITE_QUAD() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x2000) >> 13
}
func (o *SPI2_Type) SetUSER_FWRITE_OCT(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x4000)|value<<14)
}
func (o *SPI2_Type) GetUSER_FWRITE_OCT() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x4000) >> 14
}
func (o *SPI2_Type) SetUSER_USR_CONF_NXT(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x8000)|value<<15)
}
func (o *SPI2_Type) GetUSER_USR_CONF_NXT() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x8000) >> 15
}
func (o *SPI2_Type) SetUSER_SIO(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x20000)|value<<17)
}
func (o *SPI2_Type) GetUSER_SIO() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x20000) >> 17
}
func (o *SPI2_Type) SetUSER_USR_MISO_HIGHPART(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI2_Type) GetUSER_USR_MISO_HIGHPART() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x1000000) >> 24
}
func (o *SPI2_Type) SetUSER_USR_MOSI_HIGHPART(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x2000000)|value<<25)
}
func (o *SPI2_Type) GetUSER_USR_MOSI_HIGHPART() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x2000000) >> 25
}
func (o *SPI2_Type) SetUSER_USR_DUMMY_IDLE(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x4000000)|value<<26)
}
func (o *SPI2_Type) GetUSER_USR_DUMMY_IDLE() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x4000000) >> 26
}
func (o *SPI2_Type) SetUSER_USR_MOSI(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x8000000)|value<<27)
}
func (o *SPI2_Type) GetUSER_USR_MOSI() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x8000000) >> 27
}
func (o *SPI2_Type) SetUSER_USR_MISO(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x10000000)|value<<28)
}
func (o *SPI2_Type) GetUSER_USR_MISO() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x10000000) >> 28
}
func (o *SPI2_Type) SetUSER_USR_DUMMY(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x20000000)|value<<29)
}
func (o *SPI2_Type) GetUSER_USR_DUMMY() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x20000000) >> 29
}
func (o *SPI2_Type) SetUSER_USR_ADDR(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x40000000)|value<<30)
}
func (o *SPI2_Type) GetUSER_USR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x40000000) >> 30
}
func (o *SPI2_Type) SetUSER_USR_COMMAND(value uint32) {
	volatile.StoreUint32(&o.USER.Reg, volatile.LoadUint32(&o.USER.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI2_Type) GetUSER_USR_COMMAND() uint32 {
	return (volatile.LoadUint32(&o.USER.Reg) & 0x80000000) >> 31
}

// SPI2.USER1: SPI USER control register 1
func (o *SPI2_Type) SetUSER1_USR_DUMMY_CYCLELEN(value uint32) {
	volatile.StoreUint32(&o.USER1.Reg, volatile.LoadUint32(&o.USER1.Reg)&^(0xff)|value)
}
func (o *SPI2_Type) GetUSER1_USR_DUMMY_CYCLELEN() uint32 {
	return volatile.LoadUint32(&o.USER1.Reg) & 0xff
}
func (o *SPI2_Type) SetUSER1_MST_WFULL_ERR_END_EN(value uint32) {
	volatile.StoreUint32(&o.USER1.Reg, volatile.LoadUint32(&o.USER1.Reg)&^(0x10000)|value<<16)
}
func (o *SPI2_Type) GetUSER1_MST_WFULL_ERR_END_EN() uint32 {
	return (volatile.LoadUint32(&o.USER1.Reg) & 0x10000) >> 16
}
func (o *SPI2_Type) SetUSER1_CS_SETUP_TIME(value uint32) {
	volatile.StoreUint32(&o.USER1.Reg, volatile.LoadUint32(&o.USER1.Reg)&^(0x3e0000)|value<<17)
}
func (o *SPI2_Type) GetUSER1_CS_SETUP_TIME() uint32 {
	return (volatile.LoadUint32(&o.USER1.Reg) & 0x3e0000) >> 17
}
func (o *SPI2_Type) SetUSER1_CS_HOLD_TIME(value uint32) {
	volatile.StoreUint32(&o.USER1.Reg, volatile.LoadUint32(&o.USER1.Reg)&^(0x7c00000)|value<<22)
}
func (o *SPI2_Type) GetUSER1_CS_HOLD_TIME() uint32 {
	return (volatile.LoadUint32(&o.USER1.Reg) & 0x7c00000) >> 22
}
func (o *SPI2_Type) SetUSER1_USR_ADDR_BITLEN(value uint32) {
	volatile.StoreUint32(&o.USER1.Reg, volatile.LoadUint32(&o.USER1.Reg)&^(0xf8000000)|value<<27)
}
func (o *SPI2_Type) GetUSER1_USR_ADDR_BITLEN() uint32 {
	return (volatile.LoadUint32(&o.USER1.Reg) & 0xf8000000) >> 27
}

// SPI2.USER2: SPI USER control register 2
func (o *SPI2_Type) SetUSER2_USR_COMMAND_VALUE(value uint32) {
	volatile.StoreUint32(&o.USER2.Reg, volatile.LoadUint32(&o.USER2.Reg)&^(0xffff)|value)
}
func (o *SPI2_Type) GetUSER2_USR_COMMAND_VALUE() uint32 {
	return volatile.LoadUint32(&o.USER2.Reg) & 0xffff
}
func (o *SPI2_Type) SetUSER2_MST_REMPTY_ERR_END_EN(value uint32) {
	volatile.StoreUint32(&o.USER2.Reg, volatile.LoadUint32(&o.USER2.Reg)&^(0x8000000)|value<<27)
}
func (o *SPI2_Type) GetUSER2_MST_REMPTY_ERR_END_EN() uint32 {
	return (volatile.LoadUint32(&o.USER2.Reg) & 0x8000000) >> 27
}
func (o *SPI2_Type) SetUSER2_USR_COMMAND_BITLEN(value uint32) {
	volatile.StoreUint32(&o.USER2.Reg, volatile.LoadUint32(&o.USER2.Reg)&^(0xf0000000)|value<<28)
}
func (o *SPI2_Type) GetUSER2_USR_COMMAND_BITLEN() uint32 {
	return (volatile.LoadUint32(&o.USER2.Reg) & 0xf0000000) >> 28
}

// SPI2.MS_DLEN: SPI data bit length control register
func (o *SPI2_Type) SetMS_DLEN_MS_DATA_BITLEN(value uint32) {
	volatile.StoreUint32(&o.MS_DLEN.Reg, volatile.LoadUint32(&o.MS_DLEN.Reg)&^(0x3ffff)|value)
}
func (o *SPI2_Type) GetMS_DLEN_MS_DATA_BITLEN() uint32 {
	return volatile.LoadUint32(&o.MS_DLEN.Reg) & 0x3ffff
}

// SPI2.MISC: SPI misc register
func (o *SPI2_Type) SetMISC_CS0_DIS(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x1)|value)
}
func (o *SPI2_Type) GetMISC_CS0_DIS() uint32 {
	return volatile.LoadUint32(&o.MISC.Reg) & 0x1
}
func (o *SPI2_Type) SetMISC_CS1_DIS(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x2)|value<<1)
}
func (o *SPI2_Type) GetMISC_CS1_DIS() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x2) >> 1
}
func (o *SPI2_Type) SetMISC_CS2_DIS(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x4)|value<<2)
}
func (o *SPI2_Type) GetMISC_CS2_DIS() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x4) >> 2
}
func (o *SPI2_Type) SetMISC_CS3_DIS(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x8)|value<<3)
}
func (o *SPI2_Type) GetMISC_CS3_DIS() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x8) >> 3
}
func (o *SPI2_Type) SetMISC_CS4_DIS(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x10)|value<<4)
}
func (o *SPI2_Type) GetMISC_CS4_DIS() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x10) >> 4
}
func (o *SPI2_Type) SetMISC_CS5_DIS(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x20)|value<<5)
}
func (o *SPI2_Type) GetMISC_CS5_DIS() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x20) >> 5
}
func (o *SPI2_Type) SetMISC_CK_DIS(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x40)|value<<6)
}
func (o *SPI2_Type) GetMISC_CK_DIS() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x40) >> 6
}
func (o *SPI2_Type) SetMISC_MASTER_CS_POL(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x1f80)|value<<7)
}
func (o *SPI2_Type) GetMISC_MASTER_CS_POL() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x1f80) >> 7
}
func (o *SPI2_Type) SetMISC_CLK_DATA_DTR_EN(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x10000)|value<<16)
}
func (o *SPI2_Type) GetMISC_CLK_DATA_DTR_EN() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x10000) >> 16
}
func (o *SPI2_Type) SetMISC_DATA_DTR_EN(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x20000)|value<<17)
}
func (o *SPI2_Type) GetMISC_DATA_DTR_EN() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x20000) >> 17
}
func (o *SPI2_Type) SetMISC_ADDR_DTR_EN(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x40000)|value<<18)
}
func (o *SPI2_Type) GetMISC_ADDR_DTR_EN() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x40000) >> 18
}
func (o *SPI2_Type) SetMISC_CMD_DTR_EN(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x80000)|value<<19)
}
func (o *SPI2_Type) GetMISC_CMD_DTR_EN() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x80000) >> 19
}
func (o *SPI2_Type) SetMISC_SLAVE_CS_POL(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x800000)|value<<23)
}
func (o *SPI2_Type) GetMISC_SLAVE_CS_POL() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x800000) >> 23
}
func (o *SPI2_Type) SetMISC_DQS_IDLE_EDGE(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI2_Type) GetMISC_DQS_IDLE_EDGE() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x1000000) >> 24
}
func (o *SPI2_Type) SetMISC_CK_IDLE_EDGE(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x20000000)|value<<29)
}
func (o *SPI2_Type) GetMISC_CK_IDLE_EDGE() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x20000000) >> 29
}
func (o *SPI2_Type) SetMISC_CS_KEEP_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x40000000)|value<<30)
}
func (o *SPI2_Type) GetMISC_CS_KEEP_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x40000000) >> 30
}
func (o *SPI2_Type) SetMISC_QUAD_DIN_PIN_SWAP(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI2_Type) GetMISC_QUAD_DIN_PIN_SWAP() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0x80000000) >> 31
}

// SPI2.DIN_MODE: SPI input delay mode configuration
func (o *SPI2_Type) SetDIN_MODE_DIN0_MODE(value uint32) {
	volatile.StoreUint32(&o.DIN_MODE.Reg, volatile.LoadUint32(&o.DIN_MODE.Reg)&^(0x3)|value)
}
func (o *SPI2_Type) GetDIN_MODE_DIN0_MODE() uint32 {
	return volatile.LoadUint32(&o.DIN_MODE.Reg) & 0x3
}
func (o *SPI2_Type) SetDIN_MODE_DIN1_MODE(value uint32) {
	volatile.StoreUint32(&o.DIN_MODE.Reg, volatile.LoadUint32(&o.DIN_MODE.Reg)&^(0xc)|value<<2)
}
func (o *SPI2_Type) GetDIN_MODE_DIN1_MODE() uint32 {
	return (volatile.LoadUint32(&o.DIN_MODE.Reg) & 0xc) >> 2
}
func (o *SPI2_Type) SetDIN_MODE_DIN2_MODE(value uint32) {
	volatile.StoreUint32(&o.DIN_MODE.Reg, volatile.LoadUint32(&o.DIN_MODE.Reg)&^(0x30)|value<<4)
}
func (o *SPI2_Type) GetDIN_MODE_DIN2_MODE() uint32 {
	return (volatile.LoadUint32(&o.DIN_MODE.Reg) & 0x30) >> 4
}
func (o *SPI2_Type) SetDIN_MODE_DIN3_MODE(value uint32) {
	volatile.StoreUint32(&o.DIN_MODE.Reg, volatile.LoadUint32(&o.DIN_MODE.Reg)&^(0xc0)|value<<6)
}
func (o *SPI2_Type) GetDIN_MODE_DIN3_MODE() uint32 {
	return (volatile.LoadUint32(&o.DIN_MODE.Reg) & 0xc0) >> 6
}
func (o *SPI2_Type) SetDIN_MODE_DIN4_MODE(value uint32) {
	volatile.StoreUint32(&o.DIN_MODE.Reg, volatile.LoadUint32(&o.DIN_MODE.Reg)&^(0x300)|value<<8)
}
func (o *SPI2_Type) GetDIN_MODE_DIN4_MODE() uint32 {
	return (volatile.LoadUint32(&o.DIN_MODE.Reg) & 0x300) >> 8
}
func (o *SPI2_Type) SetDIN_MODE_DIN5_MODE(value uint32) {
	volatile.StoreUint32(&o.DIN_MODE.Reg, volatile.LoadUint32(&o.DIN_MODE.Reg)&^(0xc00)|value<<10)
}
func (o *SPI2_Type) GetDIN_MODE_DIN5_MODE() uint32 {
	return (volatile.LoadUint32(&o.DIN_MODE.Reg) & 0xc00) >> 10
}
func (o *SPI2_Type) SetDIN_MODE_DIN6_MODE(value uint32) {
	volatile.StoreUint32(&o.DIN_MODE.Reg, volatile.LoadUint32(&o.DIN_MODE.Reg)&^(0x3000)|value<<12)
}
func (o *SPI2_Type) GetDIN_MODE_DIN6_MODE() uint32 {
	return (volatile.LoadUint32(&o.DIN_MODE.Reg) & 0x3000) >> 12
}
func (o *SPI2_Type) SetDIN_MODE_DIN7_MODE(value uint32) {
	volatile.StoreUint32(&o.DIN_MODE.Reg, volatile.LoadUint32(&o.DIN_MODE.Reg)&^(0xc000)|value<<14)
}
func (o *SPI2_Type) GetDIN_MODE_DIN7_MODE() uint32 {
	return (volatile.LoadUint32(&o.DIN_MODE.Reg) & 0xc000) >> 14
}
func (o *SPI2_Type) SetDIN_MODE_TIMING_HCLK_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.DIN_MODE.Reg, volatile.LoadUint32(&o.DIN_MODE.Reg)&^(0x10000)|value<<16)
}
func (o *SPI2_Type) GetDIN_MODE_TIMING_HCLK_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.DIN_MODE.Reg) & 0x10000) >> 16
}

// SPI2.DIN_NUM: SPI input delay number configuration
func (o *SPI2_Type) SetDIN_NUM_DIN0_NUM(value uint32) {
	volatile.StoreUint32(&o.DIN_NUM.Reg, volatile.LoadUint32(&o.DIN_NUM.Reg)&^(0x3)|value)
}
func (o *SPI2_Type) GetDIN_NUM_DIN0_NUM() uint32 {
	return volatile.LoadUint32(&o.DIN_NUM.Reg) & 0x3
}
func (o *SPI2_Type) SetDIN_NUM_DIN1_NUM(value uint32) {
	volatile.StoreUint32(&o.DIN_NUM.Reg, volatile.LoadUint32(&o.DIN_NUM.Reg)&^(0xc)|value<<2)
}
func (o *SPI2_Type) GetDIN_NUM_DIN1_NUM() uint32 {
	return (volatile.LoadUint32(&o.DIN_NUM.Reg) & 0xc) >> 2
}
func (o *SPI2_Type) SetDIN_NUM_DIN2_NUM(value uint32) {
	volatile.StoreUint32(&o.DIN_NUM.Reg, volatile.LoadUint32(&o.DIN_NUM.Reg)&^(0x30)|value<<4)
}
func (o *SPI2_Type) GetDIN_NUM_DIN2_NUM() uint32 {
	return (volatile.LoadUint32(&o.DIN_NUM.Reg) & 0x30) >> 4
}
func (o *SPI2_Type) SetDIN_NUM_DIN3_NUM(value uint32) {
	volatile.StoreUint32(&o.DIN_NUM.Reg, volatile.LoadUint32(&o.DIN_NUM.Reg)&^(0xc0)|value<<6)
}
func (o *SPI2_Type) GetDIN_NUM_DIN3_NUM() uint32 {
	return (volatile.LoadUint32(&o.DIN_NUM.Reg) & 0xc0) >> 6
}
func (o *SPI2_Type) SetDIN_NUM_DIN4_NUM(value uint32) {
	volatile.StoreUint32(&o.DIN_NUM.Reg, volatile.LoadUint32(&o.DIN_NUM.Reg)&^(0x300)|value<<8)
}
func (o *SPI2_Type) GetDIN_NUM_DIN4_NUM() uint32 {
	return (volatile.LoadUint32(&o.DIN_NUM.Reg) & 0x300) >> 8
}
func (o *SPI2_Type) SetDIN_NUM_DIN5_NUM(value uint32) {
	volatile.StoreUint32(&o.DIN_NUM.Reg, volatile.LoadUint32(&o.DIN_NUM.Reg)&^(0xc00)|value<<10)
}
func (o *SPI2_Type) GetDIN_NUM_DIN5_NUM() uint32 {
	return (volatile.LoadUint32(&o.DIN_NUM.Reg) & 0xc00) >> 10
}
func (o *SPI2_Type) SetDIN_NUM_DIN6_NUM(value uint32) {
	volatile.StoreUint32(&o.DIN_NUM.Reg, volatile.LoadUint32(&o.DIN_NUM.Reg)&^(0x3000)|value<<12)
}
func (o *SPI2_Type) GetDIN_NUM_DIN6_NUM() uint32 {
	return (volatile.LoadUint32(&o.DIN_NUM.Reg) & 0x3000) >> 12
}
func (o *SPI2_Type) SetDIN_NUM_DIN7_NUM(value uint32) {
	volatile.StoreUint32(&o.DIN_NUM.Reg, volatile.LoadUint32(&o.DIN_NUM.Reg)&^(0xc000)|value<<14)
}
func (o *SPI2_Type) GetDIN_NUM_DIN7_NUM() uint32 {
	return (volatile.LoadUint32(&o.DIN_NUM.Reg) & 0xc000) >> 14
}

// SPI2.DOUT_MODE: SPI output delay mode configuration
func (o *SPI2_Type) SetDOUT_MODE_DOUT0_MODE(value uint32) {
	volatile.StoreUint32(&o.DOUT_MODE.Reg, volatile.LoadUint32(&o.DOUT_MODE.Reg)&^(0x1)|value)
}
func (o *SPI2_Type) GetDOUT_MODE_DOUT0_MODE() uint32 {
	return volatile.LoadUint32(&o.DOUT_MODE.Reg) & 0x1
}
func (o *SPI2_Type) SetDOUT_MODE_DOUT1_MODE(value uint32) {
	volatile.StoreUint32(&o.DOUT_MODE.Reg, volatile.LoadUint32(&o.DOUT_MODE.Reg)&^(0x2)|value<<1)
}
func (o *SPI2_Type) GetDOUT_MODE_DOUT1_MODE() uint32 {
	return (volatile.LoadUint32(&o.DOUT_MODE.Reg) & 0x2) >> 1
}
func (o *SPI2_Type) SetDOUT_MODE_DOUT2_MODE(value uint32) {
	volatile.StoreUint32(&o.DOUT_MODE.Reg, volatile.LoadUint32(&o.DOUT_MODE.Reg)&^(0x4)|value<<2)
}
func (o *SPI2_Type) GetDOUT_MODE_DOUT2_MODE() uint32 {
	return (volatile.LoadUint32(&o.DOUT_MODE.Reg) & 0x4) >> 2
}
func (o *SPI2_Type) SetDOUT_MODE_DOUT3_MODE(value uint32) {
	volatile.StoreUint32(&o.DOUT_MODE.Reg, volatile.LoadUint32(&o.DOUT_MODE.Reg)&^(0x8)|value<<3)
}
func (o *SPI2_Type) GetDOUT_MODE_DOUT3_MODE() uint32 {
	return (volatile.LoadUint32(&o.DOUT_MODE.Reg) & 0x8) >> 3
}
func (o *SPI2_Type) SetDOUT_MODE_DOUT4_MODE(value uint32) {
	volatile.StoreUint32(&o.DOUT_MODE.Reg, volatile.LoadUint32(&o.DOUT_MODE.Reg)&^(0x10)|value<<4)
}
func (o *SPI2_Type) GetDOUT_MODE_DOUT4_MODE() uint32 {
	return (volatile.LoadUint32(&o.DOUT_MODE.Reg) & 0x10) >> 4
}
func (o *SPI2_Type) SetDOUT_MODE_DOUT5_MODE(value uint32) {
	volatile.StoreUint32(&o.DOUT_MODE.Reg, volatile.LoadUint32(&o.DOUT_MODE.Reg)&^(0x20)|value<<5)
}
func (o *SPI2_Type) GetDOUT_MODE_DOUT5_MODE() uint32 {
	return (volatile.LoadUint32(&o.DOUT_MODE.Reg) & 0x20) >> 5
}
func (o *SPI2_Type) SetDOUT_MODE_DOUT6_MODE(value uint32) {
	volatile.StoreUint32(&o.DOUT_MODE.Reg, volatile.LoadUint32(&o.DOUT_MODE.Reg)&^(0x40)|value<<6)
}
func (o *SPI2_Type) GetDOUT_MODE_DOUT6_MODE() uint32 {
	return (volatile.LoadUint32(&o.DOUT_MODE.Reg) & 0x40) >> 6
}
func (o *SPI2_Type) SetDOUT_MODE_DOUT7_MODE(value uint32) {
	volatile.StoreUint32(&o.DOUT_MODE.Reg, volatile.LoadUint32(&o.DOUT_MODE.Reg)&^(0x80)|value<<7)
}
func (o *SPI2_Type) GetDOUT_MODE_DOUT7_MODE() uint32 {
	return (volatile.LoadUint32(&o.DOUT_MODE.Reg) & 0x80) >> 7
}
func (o *SPI2_Type) SetDOUT_MODE_D_DQS_MODE(value uint32) {
	volatile.StoreUint32(&o.DOUT_MODE.Reg, volatile.LoadUint32(&o.DOUT_MODE.Reg)&^(0x100)|value<<8)
}
func (o *SPI2_Type) GetDOUT_MODE_D_DQS_MODE() uint32 {
	return (volatile.LoadUint32(&o.DOUT_MODE.Reg) & 0x100) >> 8
}

// SPI2.DMA_CONF: SPI DMA control register
func (o *SPI2_Type) SetDMA_CONF_DMA_OUTFIFO_EMPTY(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x1)|value)
}
func (o *SPI2_Type) GetDMA_CONF_DMA_OUTFIFO_EMPTY() uint32 {
	return volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x1
}
func (o *SPI2_Type) SetDMA_CONF_DMA_INFIFO_FULL(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x2)|value<<1)
}
func (o *SPI2_Type) GetDMA_CONF_DMA_INFIFO_FULL() uint32 {
	return (volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x2) >> 1
}
func (o *SPI2_Type) SetDMA_CONF_DMA_SLV_SEG_TRANS_EN(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x40000)|value<<18)
}
func (o *SPI2_Type) GetDMA_CONF_DMA_SLV_SEG_TRANS_EN() uint32 {
	return (volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x40000) >> 18
}
func (o *SPI2_Type) SetDMA_CONF_SLV_RX_SEG_TRANS_CLR_EN(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x80000)|value<<19)
}
func (o *SPI2_Type) GetDMA_CONF_SLV_RX_SEG_TRANS_CLR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x80000) >> 19
}
func (o *SPI2_Type) SetDMA_CONF_SLV_TX_SEG_TRANS_CLR_EN(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x100000)|value<<20)
}
func (o *SPI2_Type) GetDMA_CONF_SLV_TX_SEG_TRANS_CLR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x100000) >> 20
}
func (o *SPI2_Type) SetDMA_CONF_RX_EOF_EN(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x200000)|value<<21)
}
func (o *SPI2_Type) GetDMA_CONF_RX_EOF_EN() uint32 {
	return (volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x200000) >> 21
}
func (o *SPI2_Type) SetDMA_CONF_DMA_RX_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x8000000)|value<<27)
}
func (o *SPI2_Type) GetDMA_CONF_DMA_RX_ENA() uint32 {
	return (volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x8000000) >> 27
}
func (o *SPI2_Type) SetDMA_CONF_DMA_TX_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x10000000)|value<<28)
}
func (o *SPI2_Type) GetDMA_CONF_DMA_TX_ENA() uint32 {
	return (volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x10000000) >> 28
}
func (o *SPI2_Type) SetDMA_CONF_RX_AFIFO_RST(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x20000000)|value<<29)
}
func (o *SPI2_Type) GetDMA_CONF_RX_AFIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x20000000) >> 29
}
func (o *SPI2_Type) SetDMA_CONF_BUF_AFIFO_RST(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x40000000)|value<<30)
}
func (o *SPI2_Type) GetDMA_CONF_BUF_AFIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x40000000) >> 30
}
func (o *SPI2_Type) SetDMA_CONF_DMA_AFIFO_RST(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI2_Type) GetDMA_CONF_DMA_AFIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x80000000) >> 31
}

// SPI2.DMA_INT_ENA: SPI interrupt enable register
func (o *SPI2_Type) SetDMA_INT_ENA_DMA_INFIFO_FULL_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ENA.Reg, volatile.LoadUint32(&o.DMA_INT_ENA.Reg)&^(0x1)|value)
}
func (o *SPI2_Type) GetDMA_INT_ENA_DMA_INFIFO_FULL_ERR_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.DMA_INT_ENA.Reg) & 0x1
}
func (o *SPI2_Type) SetDMA_INT_ENA_DMA_OUTFIFO_EMPTY_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ENA.Reg, volatile.LoadUint32(&o.DMA_INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *SPI2_Type) GetDMA_INT_ENA_DMA_OUTFIFO_EMPTY_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ENA.Reg) & 0x2) >> 1
}
func (o *SPI2_Type) SetDMA_INT_ENA_SLV_EX_QPI_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ENA.Reg, volatile.LoadUint32(&o.DMA_INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *SPI2_Type) GetDMA_INT_ENA_SLV_EX_QPI_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ENA.Reg) & 0x4) >> 2
}
func (o *SPI2_Type) SetDMA_INT_ENA_SLV_EN_QPI_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ENA.Reg, volatile.LoadUint32(&o.DMA_INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *SPI2_Type) GetDMA_INT_ENA_SLV_EN_QPI_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ENA.Reg) & 0x8) >> 3
}
func (o *SPI2_Type) SetDMA_INT_ENA_SLV_CMD7_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ENA.Reg, volatile.LoadUint32(&o.DMA_INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *SPI2_Type) GetDMA_INT_ENA_SLV_CMD7_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ENA.Reg) & 0x10) >> 4
}
func (o *SPI2_Type) SetDMA_INT_ENA_SLV_CMD8_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ENA.Reg, volatile.LoadUint32(&o.DMA_INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *SPI2_Type) GetDMA_INT_ENA_SLV_CMD8_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ENA.Reg) & 0x20) >> 5
}
func (o *SPI2_Type) SetDMA_INT_ENA_SLV_CMD9_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ENA.Reg, volatile.LoadUint32(&o.DMA_INT_ENA.Reg)&^(0x40)|value<<6)
}
func (o *SPI2_Type) GetDMA_INT_ENA_SLV_CMD9_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ENA.Reg) & 0x40) >> 6
}
func (o *SPI2_Type) SetDMA_INT_ENA_SLV_CMDA_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ENA.Reg, volatile.LoadUint32(&o.DMA_INT_ENA.Reg)&^(0x80)|value<<7)
}
func (o *SPI2_Type) GetDMA_INT_ENA_SLV_CMDA_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ENA.Reg) & 0x80) >> 7
}
func (o *SPI2_Type) SetDMA_INT_ENA_SLV_RD_DMA_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ENA.Reg, volatile.LoadUint32(&o.DMA_INT_ENA.Reg)&^(0x100)|value<<8)
}
func (o *SPI2_Type) GetDMA_INT_ENA_SLV_RD_DMA_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ENA.Reg) & 0x100) >> 8
}
func (o *SPI2_Type) SetDMA_INT_ENA_SLV_WR_DMA_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ENA.Reg, volatile.LoadUint32(&o.DMA_INT_ENA.Reg)&^(0x200)|value<<9)
}
func (o *SPI2_Type) GetDMA_INT_ENA_SLV_WR_DMA_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ENA.Reg) & 0x200) >> 9
}
func (o *SPI2_Type) SetDMA_INT_ENA_SLV_RD_BUF_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ENA.Reg, volatile.LoadUint32(&o.DMA_INT_ENA.Reg)&^(0x400)|value<<10)
}
func (o *SPI2_Type) GetDMA_INT_ENA_SLV_RD_BUF_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ENA.Reg) & 0x400) >> 10
}
func (o *SPI2_Type) SetDMA_INT_ENA_SLV_WR_BUF_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ENA.Reg, volatile.LoadUint32(&o.DMA_INT_ENA.Reg)&^(0x800)|value<<11)
}
func (o *SPI2_Type) GetDMA_INT_ENA_SLV_WR_BUF_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ENA.Reg) & 0x800) >> 11
}
func (o *SPI2_Type) SetDMA_INT_ENA_TRANS_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ENA.Reg, volatile.LoadUint32(&o.DMA_INT_ENA.Reg)&^(0x1000)|value<<12)
}
func (o *SPI2_Type) GetDMA_INT_ENA_TRANS_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ENA.Reg) & 0x1000) >> 12
}
func (o *SPI2_Type) SetDMA_INT_ENA_DMA_SEG_TRANS_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ENA.Reg, volatile.LoadUint32(&o.DMA_INT_ENA.Reg)&^(0x2000)|value<<13)
}
func (o *SPI2_Type) GetDMA_INT_ENA_DMA_SEG_TRANS_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ENA.Reg) & 0x2000) >> 13
}
func (o *SPI2_Type) SetDMA_INT_ENA_SEG_MAGIC_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ENA.Reg, volatile.LoadUint32(&o.DMA_INT_ENA.Reg)&^(0x4000)|value<<14)
}
func (o *SPI2_Type) GetDMA_INT_ENA_SEG_MAGIC_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ENA.Reg) & 0x4000) >> 14
}
func (o *SPI2_Type) SetDMA_INT_ENA_SLV_BUF_ADDR_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ENA.Reg, volatile.LoadUint32(&o.DMA_INT_ENA.Reg)&^(0x8000)|value<<15)
}
func (o *SPI2_Type) GetDMA_INT_ENA_SLV_BUF_ADDR_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ENA.Reg) & 0x8000) >> 15
}
func (o *SPI2_Type) SetDMA_INT_ENA_SLV_CMD_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ENA.Reg, volatile.LoadUint32(&o.DMA_INT_ENA.Reg)&^(0x10000)|value<<16)
}
func (o *SPI2_Type) GetDMA_INT_ENA_SLV_CMD_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ENA.Reg) & 0x10000) >> 16
}
func (o *SPI2_Type) SetDMA_INT_ENA_MST_RX_AFIFO_WFULL_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ENA.Reg, volatile.LoadUint32(&o.DMA_INT_ENA.Reg)&^(0x20000)|value<<17)
}
func (o *SPI2_Type) GetDMA_INT_ENA_MST_RX_AFIFO_WFULL_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ENA.Reg) & 0x20000) >> 17
}
func (o *SPI2_Type) SetDMA_INT_ENA_MST_TX_AFIFO_REMPTY_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ENA.Reg, volatile.LoadUint32(&o.DMA_INT_ENA.Reg)&^(0x40000)|value<<18)
}
func (o *SPI2_Type) GetDMA_INT_ENA_MST_TX_AFIFO_REMPTY_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ENA.Reg) & 0x40000) >> 18
}
func (o *SPI2_Type) SetDMA_INT_ENA_APP2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ENA.Reg, volatile.LoadUint32(&o.DMA_INT_ENA.Reg)&^(0x80000)|value<<19)
}
func (o *SPI2_Type) GetDMA_INT_ENA_APP2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ENA.Reg) & 0x80000) >> 19
}
func (o *SPI2_Type) SetDMA_INT_ENA_APP1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ENA.Reg, volatile.LoadUint32(&o.DMA_INT_ENA.Reg)&^(0x100000)|value<<20)
}
func (o *SPI2_Type) GetDMA_INT_ENA_APP1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ENA.Reg) & 0x100000) >> 20
}

// SPI2.DMA_INT_CLR: SPI interrupt clear register
func (o *SPI2_Type) SetDMA_INT_CLR_DMA_INFIFO_FULL_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_CLR.Reg, volatile.LoadUint32(&o.DMA_INT_CLR.Reg)&^(0x1)|value)
}
func (o *SPI2_Type) GetDMA_INT_CLR_DMA_INFIFO_FULL_ERR_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.DMA_INT_CLR.Reg) & 0x1
}
func (o *SPI2_Type) SetDMA_INT_CLR_DMA_OUTFIFO_EMPTY_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_CLR.Reg, volatile.LoadUint32(&o.DMA_INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *SPI2_Type) GetDMA_INT_CLR_DMA_OUTFIFO_EMPTY_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_CLR.Reg) & 0x2) >> 1
}
func (o *SPI2_Type) SetDMA_INT_CLR_SLV_EX_QPI_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_CLR.Reg, volatile.LoadUint32(&o.DMA_INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *SPI2_Type) GetDMA_INT_CLR_SLV_EX_QPI_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_CLR.Reg) & 0x4) >> 2
}
func (o *SPI2_Type) SetDMA_INT_CLR_SLV_EN_QPI_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_CLR.Reg, volatile.LoadUint32(&o.DMA_INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *SPI2_Type) GetDMA_INT_CLR_SLV_EN_QPI_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_CLR.Reg) & 0x8) >> 3
}
func (o *SPI2_Type) SetDMA_INT_CLR_SLV_CMD7_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_CLR.Reg, volatile.LoadUint32(&o.DMA_INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *SPI2_Type) GetDMA_INT_CLR_SLV_CMD7_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_CLR.Reg) & 0x10) >> 4
}
func (o *SPI2_Type) SetDMA_INT_CLR_SLV_CMD8_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_CLR.Reg, volatile.LoadUint32(&o.DMA_INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *SPI2_Type) GetDMA_INT_CLR_SLV_CMD8_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_CLR.Reg) & 0x20) >> 5
}
func (o *SPI2_Type) SetDMA_INT_CLR_SLV_CMD9_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_CLR.Reg, volatile.LoadUint32(&o.DMA_INT_CLR.Reg)&^(0x40)|value<<6)
}
func (o *SPI2_Type) GetDMA_INT_CLR_SLV_CMD9_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_CLR.Reg) & 0x40) >> 6
}
func (o *SPI2_Type) SetDMA_INT_CLR_SLV_CMDA_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_CLR.Reg, volatile.LoadUint32(&o.DMA_INT_CLR.Reg)&^(0x80)|value<<7)
}
func (o *SPI2_Type) GetDMA_INT_CLR_SLV_CMDA_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_CLR.Reg) & 0x80) >> 7
}
func (o *SPI2_Type) SetDMA_INT_CLR_SLV_RD_DMA_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_CLR.Reg, volatile.LoadUint32(&o.DMA_INT_CLR.Reg)&^(0x100)|value<<8)
}
func (o *SPI2_Type) GetDMA_INT_CLR_SLV_RD_DMA_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_CLR.Reg) & 0x100) >> 8
}
func (o *SPI2_Type) SetDMA_INT_CLR_SLV_WR_DMA_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_CLR.Reg, volatile.LoadUint32(&o.DMA_INT_CLR.Reg)&^(0x200)|value<<9)
}
func (o *SPI2_Type) GetDMA_INT_CLR_SLV_WR_DMA_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_CLR.Reg) & 0x200) >> 9
}
func (o *SPI2_Type) SetDMA_INT_CLR_SLV_RD_BUF_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_CLR.Reg, volatile.LoadUint32(&o.DMA_INT_CLR.Reg)&^(0x400)|value<<10)
}
func (o *SPI2_Type) GetDMA_INT_CLR_SLV_RD_BUF_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_CLR.Reg) & 0x400) >> 10
}
func (o *SPI2_Type) SetDMA_INT_CLR_SLV_WR_BUF_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_CLR.Reg, volatile.LoadUint32(&o.DMA_INT_CLR.Reg)&^(0x800)|value<<11)
}
func (o *SPI2_Type) GetDMA_INT_CLR_SLV_WR_BUF_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_CLR.Reg) & 0x800) >> 11
}
func (o *SPI2_Type) SetDMA_INT_CLR_TRANS_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_CLR.Reg, volatile.LoadUint32(&o.DMA_INT_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *SPI2_Type) GetDMA_INT_CLR_TRANS_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_CLR.Reg) & 0x1000) >> 12
}
func (o *SPI2_Type) SetDMA_INT_CLR_DMA_SEG_TRANS_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_CLR.Reg, volatile.LoadUint32(&o.DMA_INT_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *SPI2_Type) GetDMA_INT_CLR_DMA_SEG_TRANS_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_CLR.Reg) & 0x2000) >> 13
}
func (o *SPI2_Type) SetDMA_INT_CLR_SEG_MAGIC_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_CLR.Reg, volatile.LoadUint32(&o.DMA_INT_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *SPI2_Type) GetDMA_INT_CLR_SEG_MAGIC_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_CLR.Reg) & 0x4000) >> 14
}
func (o *SPI2_Type) SetDMA_INT_CLR_SLV_BUF_ADDR_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_CLR.Reg, volatile.LoadUint32(&o.DMA_INT_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *SPI2_Type) GetDMA_INT_CLR_SLV_BUF_ADDR_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_CLR.Reg) & 0x8000) >> 15
}
func (o *SPI2_Type) SetDMA_INT_CLR_SLV_CMD_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_CLR.Reg, volatile.LoadUint32(&o.DMA_INT_CLR.Reg)&^(0x10000)|value<<16)
}
func (o *SPI2_Type) GetDMA_INT_CLR_SLV_CMD_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_CLR.Reg) & 0x10000) >> 16
}
func (o *SPI2_Type) SetDMA_INT_CLR_MST_RX_AFIFO_WFULL_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_CLR.Reg, volatile.LoadUint32(&o.DMA_INT_CLR.Reg)&^(0x20000)|value<<17)
}
func (o *SPI2_Type) GetDMA_INT_CLR_MST_RX_AFIFO_WFULL_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_CLR.Reg) & 0x20000) >> 17
}
func (o *SPI2_Type) SetDMA_INT_CLR_MST_TX_AFIFO_REMPTY_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_CLR.Reg, volatile.LoadUint32(&o.DMA_INT_CLR.Reg)&^(0x40000)|value<<18)
}
func (o *SPI2_Type) GetDMA_INT_CLR_MST_TX_AFIFO_REMPTY_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_CLR.Reg) & 0x40000) >> 18
}
func (o *SPI2_Type) SetDMA_INT_CLR_APP2_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_CLR.Reg, volatile.LoadUint32(&o.DMA_INT_CLR.Reg)&^(0x80000)|value<<19)
}
func (o *SPI2_Type) GetDMA_INT_CLR_APP2_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_CLR.Reg) & 0x80000) >> 19
}
func (o *SPI2_Type) SetDMA_INT_CLR_APP1_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_CLR.Reg, volatile.LoadUint32(&o.DMA_INT_CLR.Reg)&^(0x100000)|value<<20)
}
func (o *SPI2_Type) GetDMA_INT_CLR_APP1_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_CLR.Reg) & 0x100000) >> 20
}

// SPI2.DMA_INT_RAW: SPI interrupt raw register
func (o *SPI2_Type) SetDMA_INT_RAW_DMA_INFIFO_FULL_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_RAW.Reg, volatile.LoadUint32(&o.DMA_INT_RAW.Reg)&^(0x1)|value)
}
func (o *SPI2_Type) GetDMA_INT_RAW_DMA_INFIFO_FULL_ERR_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.DMA_INT_RAW.Reg) & 0x1
}
func (o *SPI2_Type) SetDMA_INT_RAW_DMA_OUTFIFO_EMPTY_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_RAW.Reg, volatile.LoadUint32(&o.DMA_INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *SPI2_Type) GetDMA_INT_RAW_DMA_OUTFIFO_EMPTY_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_RAW.Reg) & 0x2) >> 1
}
func (o *SPI2_Type) SetDMA_INT_RAW_SLV_EX_QPI_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_RAW.Reg, volatile.LoadUint32(&o.DMA_INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *SPI2_Type) GetDMA_INT_RAW_SLV_EX_QPI_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_RAW.Reg) & 0x4) >> 2
}
func (o *SPI2_Type) SetDMA_INT_RAW_SLV_EN_QPI_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_RAW.Reg, volatile.LoadUint32(&o.DMA_INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *SPI2_Type) GetDMA_INT_RAW_SLV_EN_QPI_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_RAW.Reg) & 0x8) >> 3
}
func (o *SPI2_Type) SetDMA_INT_RAW_SLV_CMD7_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_RAW.Reg, volatile.LoadUint32(&o.DMA_INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *SPI2_Type) GetDMA_INT_RAW_SLV_CMD7_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_RAW.Reg) & 0x10) >> 4
}
func (o *SPI2_Type) SetDMA_INT_RAW_SLV_CMD8_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_RAW.Reg, volatile.LoadUint32(&o.DMA_INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *SPI2_Type) GetDMA_INT_RAW_SLV_CMD8_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_RAW.Reg) & 0x20) >> 5
}
func (o *SPI2_Type) SetDMA_INT_RAW_SLV_CMD9_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_RAW.Reg, volatile.LoadUint32(&o.DMA_INT_RAW.Reg)&^(0x40)|value<<6)
}
func (o *SPI2_Type) GetDMA_INT_RAW_SLV_CMD9_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_RAW.Reg) & 0x40) >> 6
}
func (o *SPI2_Type) SetDMA_INT_RAW_SLV_CMDA_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_RAW.Reg, volatile.LoadUint32(&o.DMA_INT_RAW.Reg)&^(0x80)|value<<7)
}
func (o *SPI2_Type) GetDMA_INT_RAW_SLV_CMDA_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_RAW.Reg) & 0x80) >> 7
}
func (o *SPI2_Type) SetDMA_INT_RAW_SLV_RD_DMA_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_RAW.Reg, volatile.LoadUint32(&o.DMA_INT_RAW.Reg)&^(0x100)|value<<8)
}
func (o *SPI2_Type) GetDMA_INT_RAW_SLV_RD_DMA_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_RAW.Reg) & 0x100) >> 8
}
func (o *SPI2_Type) SetDMA_INT_RAW_SLV_WR_DMA_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_RAW.Reg, volatile.LoadUint32(&o.DMA_INT_RAW.Reg)&^(0x200)|value<<9)
}
func (o *SPI2_Type) GetDMA_INT_RAW_SLV_WR_DMA_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_RAW.Reg) & 0x200) >> 9
}
func (o *SPI2_Type) SetDMA_INT_RAW_SLV_RD_BUF_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_RAW.Reg, volatile.LoadUint32(&o.DMA_INT_RAW.Reg)&^(0x400)|value<<10)
}
func (o *SPI2_Type) GetDMA_INT_RAW_SLV_RD_BUF_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_RAW.Reg) & 0x400) >> 10
}
func (o *SPI2_Type) SetDMA_INT_RAW_SLV_WR_BUF_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_RAW.Reg, volatile.LoadUint32(&o.DMA_INT_RAW.Reg)&^(0x800)|value<<11)
}
func (o *SPI2_Type) GetDMA_INT_RAW_SLV_WR_BUF_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_RAW.Reg) & 0x800) >> 11
}
func (o *SPI2_Type) SetDMA_INT_RAW_TRANS_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_RAW.Reg, volatile.LoadUint32(&o.DMA_INT_RAW.Reg)&^(0x1000)|value<<12)
}
func (o *SPI2_Type) GetDMA_INT_RAW_TRANS_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_RAW.Reg) & 0x1000) >> 12
}
func (o *SPI2_Type) SetDMA_INT_RAW_DMA_SEG_TRANS_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_RAW.Reg, volatile.LoadUint32(&o.DMA_INT_RAW.Reg)&^(0x2000)|value<<13)
}
func (o *SPI2_Type) GetDMA_INT_RAW_DMA_SEG_TRANS_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_RAW.Reg) & 0x2000) >> 13
}
func (o *SPI2_Type) SetDMA_INT_RAW_SEG_MAGIC_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_RAW.Reg, volatile.LoadUint32(&o.DMA_INT_RAW.Reg)&^(0x4000)|value<<14)
}
func (o *SPI2_Type) GetDMA_INT_RAW_SEG_MAGIC_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_RAW.Reg) & 0x4000) >> 14
}
func (o *SPI2_Type) SetDMA_INT_RAW_SLV_BUF_ADDR_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_RAW.Reg, volatile.LoadUint32(&o.DMA_INT_RAW.Reg)&^(0x8000)|value<<15)
}
func (o *SPI2_Type) GetDMA_INT_RAW_SLV_BUF_ADDR_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_RAW.Reg) & 0x8000) >> 15
}
func (o *SPI2_Type) SetDMA_INT_RAW_SLV_CMD_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_RAW.Reg, volatile.LoadUint32(&o.DMA_INT_RAW.Reg)&^(0x10000)|value<<16)
}
func (o *SPI2_Type) GetDMA_INT_RAW_SLV_CMD_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_RAW.Reg) & 0x10000) >> 16
}
func (o *SPI2_Type) SetDMA_INT_RAW_MST_RX_AFIFO_WFULL_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_RAW.Reg, volatile.LoadUint32(&o.DMA_INT_RAW.Reg)&^(0x20000)|value<<17)
}
func (o *SPI2_Type) GetDMA_INT_RAW_MST_RX_AFIFO_WFULL_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_RAW.Reg) & 0x20000) >> 17
}
func (o *SPI2_Type) SetDMA_INT_RAW_MST_TX_AFIFO_REMPTY_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_RAW.Reg, volatile.LoadUint32(&o.DMA_INT_RAW.Reg)&^(0x40000)|value<<18)
}
func (o *SPI2_Type) GetDMA_INT_RAW_MST_TX_AFIFO_REMPTY_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_RAW.Reg) & 0x40000) >> 18
}
func (o *SPI2_Type) SetDMA_INT_RAW_APP2_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_RAW.Reg, volatile.LoadUint32(&o.DMA_INT_RAW.Reg)&^(0x80000)|value<<19)
}
func (o *SPI2_Type) GetDMA_INT_RAW_APP2_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_RAW.Reg) & 0x80000) >> 19
}
func (o *SPI2_Type) SetDMA_INT_RAW_APP1_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_RAW.Reg, volatile.LoadUint32(&o.DMA_INT_RAW.Reg)&^(0x100000)|value<<20)
}
func (o *SPI2_Type) GetDMA_INT_RAW_APP1_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_RAW.Reg) & 0x100000) >> 20
}

// SPI2.DMA_INT_ST: SPI interrupt status register
func (o *SPI2_Type) SetDMA_INT_ST_DMA_INFIFO_FULL_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ST.Reg, volatile.LoadUint32(&o.DMA_INT_ST.Reg)&^(0x1)|value)
}
func (o *SPI2_Type) GetDMA_INT_ST_DMA_INFIFO_FULL_ERR_INT_ST() uint32 {
	return volatile.LoadUint32(&o.DMA_INT_ST.Reg) & 0x1
}
func (o *SPI2_Type) SetDMA_INT_ST_DMA_OUTFIFO_EMPTY_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ST.Reg, volatile.LoadUint32(&o.DMA_INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *SPI2_Type) GetDMA_INT_ST_DMA_OUTFIFO_EMPTY_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ST.Reg) & 0x2) >> 1
}
func (o *SPI2_Type) SetDMA_INT_ST_SLV_EX_QPI_INT_ST(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ST.Reg, volatile.LoadUint32(&o.DMA_INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *SPI2_Type) GetDMA_INT_ST_SLV_EX_QPI_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ST.Reg) & 0x4) >> 2
}
func (o *SPI2_Type) SetDMA_INT_ST_SLV_EN_QPI_INT_ST(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ST.Reg, volatile.LoadUint32(&o.DMA_INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *SPI2_Type) GetDMA_INT_ST_SLV_EN_QPI_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ST.Reg) & 0x8) >> 3
}
func (o *SPI2_Type) SetDMA_INT_ST_SLV_CMD7_INT_ST(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ST.Reg, volatile.LoadUint32(&o.DMA_INT_ST.Reg)&^(0x10)|value<<4)
}
func (o *SPI2_Type) GetDMA_INT_ST_SLV_CMD7_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ST.Reg) & 0x10) >> 4
}
func (o *SPI2_Type) SetDMA_INT_ST_SLV_CMD8_INT_ST(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ST.Reg, volatile.LoadUint32(&o.DMA_INT_ST.Reg)&^(0x20)|value<<5)
}
func (o *SPI2_Type) GetDMA_INT_ST_SLV_CMD8_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ST.Reg) & 0x20) >> 5
}
func (o *SPI2_Type) SetDMA_INT_ST_SLV_CMD9_INT_ST(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ST.Reg, volatile.LoadUint32(&o.DMA_INT_ST.Reg)&^(0x40)|value<<6)
}
func (o *SPI2_Type) GetDMA_INT_ST_SLV_CMD9_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ST.Reg) & 0x40) >> 6
}
func (o *SPI2_Type) SetDMA_INT_ST_SLV_CMDA_INT_ST(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ST.Reg, volatile.LoadUint32(&o.DMA_INT_ST.Reg)&^(0x80)|value<<7)
}
func (o *SPI2_Type) GetDMA_INT_ST_SLV_CMDA_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ST.Reg) & 0x80) >> 7
}
func (o *SPI2_Type) SetDMA_INT_ST_SLV_RD_DMA_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ST.Reg, volatile.LoadUint32(&o.DMA_INT_ST.Reg)&^(0x100)|value<<8)
}
func (o *SPI2_Type) GetDMA_INT_ST_SLV_RD_DMA_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ST.Reg) & 0x100) >> 8
}
func (o *SPI2_Type) SetDMA_INT_ST_SLV_WR_DMA_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ST.Reg, volatile.LoadUint32(&o.DMA_INT_ST.Reg)&^(0x200)|value<<9)
}
func (o *SPI2_Type) GetDMA_INT_ST_SLV_WR_DMA_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ST.Reg) & 0x200) >> 9
}
func (o *SPI2_Type) SetDMA_INT_ST_SLV_RD_BUF_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ST.Reg, volatile.LoadUint32(&o.DMA_INT_ST.Reg)&^(0x400)|value<<10)
}
func (o *SPI2_Type) GetDMA_INT_ST_SLV_RD_BUF_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ST.Reg) & 0x400) >> 10
}
func (o *SPI2_Type) SetDMA_INT_ST_SLV_WR_BUF_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ST.Reg, volatile.LoadUint32(&o.DMA_INT_ST.Reg)&^(0x800)|value<<11)
}
func (o *SPI2_Type) GetDMA_INT_ST_SLV_WR_BUF_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ST.Reg) & 0x800) >> 11
}
func (o *SPI2_Type) SetDMA_INT_ST_TRANS_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ST.Reg, volatile.LoadUint32(&o.DMA_INT_ST.Reg)&^(0x1000)|value<<12)
}
func (o *SPI2_Type) GetDMA_INT_ST_TRANS_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ST.Reg) & 0x1000) >> 12
}
func (o *SPI2_Type) SetDMA_INT_ST_DMA_SEG_TRANS_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ST.Reg, volatile.LoadUint32(&o.DMA_INT_ST.Reg)&^(0x2000)|value<<13)
}
func (o *SPI2_Type) GetDMA_INT_ST_DMA_SEG_TRANS_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ST.Reg) & 0x2000) >> 13
}
func (o *SPI2_Type) SetDMA_INT_ST_SEG_MAGIC_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ST.Reg, volatile.LoadUint32(&o.DMA_INT_ST.Reg)&^(0x4000)|value<<14)
}
func (o *SPI2_Type) GetDMA_INT_ST_SEG_MAGIC_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ST.Reg) & 0x4000) >> 14
}
func (o *SPI2_Type) SetDMA_INT_ST_SLV_BUF_ADDR_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ST.Reg, volatile.LoadUint32(&o.DMA_INT_ST.Reg)&^(0x8000)|value<<15)
}
func (o *SPI2_Type) GetDMA_INT_ST_SLV_BUF_ADDR_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ST.Reg) & 0x8000) >> 15
}
func (o *SPI2_Type) SetDMA_INT_ST_SLV_CMD_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ST.Reg, volatile.LoadUint32(&o.DMA_INT_ST.Reg)&^(0x10000)|value<<16)
}
func (o *SPI2_Type) GetDMA_INT_ST_SLV_CMD_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ST.Reg) & 0x10000) >> 16
}
func (o *SPI2_Type) SetDMA_INT_ST_MST_RX_AFIFO_WFULL_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ST.Reg, volatile.LoadUint32(&o.DMA_INT_ST.Reg)&^(0x20000)|value<<17)
}
func (o *SPI2_Type) GetDMA_INT_ST_MST_RX_AFIFO_WFULL_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ST.Reg) & 0x20000) >> 17
}
func (o *SPI2_Type) SetDMA_INT_ST_MST_TX_AFIFO_REMPTY_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ST.Reg, volatile.LoadUint32(&o.DMA_INT_ST.Reg)&^(0x40000)|value<<18)
}
func (o *SPI2_Type) GetDMA_INT_ST_MST_TX_AFIFO_REMPTY_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ST.Reg) & 0x40000) >> 18
}
func (o *SPI2_Type) SetDMA_INT_ST_APP2_INT_ST(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ST.Reg, volatile.LoadUint32(&o.DMA_INT_ST.Reg)&^(0x80000)|value<<19)
}
func (o *SPI2_Type) GetDMA_INT_ST_APP2_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ST.Reg) & 0x80000) >> 19
}
func (o *SPI2_Type) SetDMA_INT_ST_APP1_INT_ST(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_ST.Reg, volatile.LoadUint32(&o.DMA_INT_ST.Reg)&^(0x100000)|value<<20)
}
func (o *SPI2_Type) GetDMA_INT_ST_APP1_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_ST.Reg) & 0x100000) >> 20
}

// SPI2.DMA_INT_SET: SPI interrupt software set register
func (o *SPI2_Type) SetDMA_INT_SET_DMA_INFIFO_FULL_ERR_INT_SET(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_SET.Reg, volatile.LoadUint32(&o.DMA_INT_SET.Reg)&^(0x1)|value)
}
func (o *SPI2_Type) GetDMA_INT_SET_DMA_INFIFO_FULL_ERR_INT_SET() uint32 {
	return volatile.LoadUint32(&o.DMA_INT_SET.Reg) & 0x1
}
func (o *SPI2_Type) SetDMA_INT_SET_DMA_OUTFIFO_EMPTY_ERR_INT_SET(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_SET.Reg, volatile.LoadUint32(&o.DMA_INT_SET.Reg)&^(0x2)|value<<1)
}
func (o *SPI2_Type) GetDMA_INT_SET_DMA_OUTFIFO_EMPTY_ERR_INT_SET() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_SET.Reg) & 0x2) >> 1
}
func (o *SPI2_Type) SetDMA_INT_SET_SLV_EX_QPI_INT_SET(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_SET.Reg, volatile.LoadUint32(&o.DMA_INT_SET.Reg)&^(0x4)|value<<2)
}
func (o *SPI2_Type) GetDMA_INT_SET_SLV_EX_QPI_INT_SET() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_SET.Reg) & 0x4) >> 2
}
func (o *SPI2_Type) SetDMA_INT_SET_SLV_EN_QPI_INT_SET(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_SET.Reg, volatile.LoadUint32(&o.DMA_INT_SET.Reg)&^(0x8)|value<<3)
}
func (o *SPI2_Type) GetDMA_INT_SET_SLV_EN_QPI_INT_SET() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_SET.Reg) & 0x8) >> 3
}
func (o *SPI2_Type) SetDMA_INT_SET_SLV_CMD7_INT_SET(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_SET.Reg, volatile.LoadUint32(&o.DMA_INT_SET.Reg)&^(0x10)|value<<4)
}
func (o *SPI2_Type) GetDMA_INT_SET_SLV_CMD7_INT_SET() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_SET.Reg) & 0x10) >> 4
}
func (o *SPI2_Type) SetDMA_INT_SET_SLV_CMD8_INT_SET(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_SET.Reg, volatile.LoadUint32(&o.DMA_INT_SET.Reg)&^(0x20)|value<<5)
}
func (o *SPI2_Type) GetDMA_INT_SET_SLV_CMD8_INT_SET() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_SET.Reg) & 0x20) >> 5
}
func (o *SPI2_Type) SetDMA_INT_SET_SLV_CMD9_INT_SET(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_SET.Reg, volatile.LoadUint32(&o.DMA_INT_SET.Reg)&^(0x40)|value<<6)
}
func (o *SPI2_Type) GetDMA_INT_SET_SLV_CMD9_INT_SET() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_SET.Reg) & 0x40) >> 6
}
func (o *SPI2_Type) SetDMA_INT_SET_SLV_CMDA_INT_SET(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_SET.Reg, volatile.LoadUint32(&o.DMA_INT_SET.Reg)&^(0x80)|value<<7)
}
func (o *SPI2_Type) GetDMA_INT_SET_SLV_CMDA_INT_SET() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_SET.Reg) & 0x80) >> 7
}
func (o *SPI2_Type) SetDMA_INT_SET_SLV_RD_DMA_DONE_INT_SET(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_SET.Reg, volatile.LoadUint32(&o.DMA_INT_SET.Reg)&^(0x100)|value<<8)
}
func (o *SPI2_Type) GetDMA_INT_SET_SLV_RD_DMA_DONE_INT_SET() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_SET.Reg) & 0x100) >> 8
}
func (o *SPI2_Type) SetDMA_INT_SET_SLV_WR_DMA_DONE_INT_SET(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_SET.Reg, volatile.LoadUint32(&o.DMA_INT_SET.Reg)&^(0x200)|value<<9)
}
func (o *SPI2_Type) GetDMA_INT_SET_SLV_WR_DMA_DONE_INT_SET() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_SET.Reg) & 0x200) >> 9
}
func (o *SPI2_Type) SetDMA_INT_SET_SLV_RD_BUF_DONE_INT_SET(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_SET.Reg, volatile.LoadUint32(&o.DMA_INT_SET.Reg)&^(0x400)|value<<10)
}
func (o *SPI2_Type) GetDMA_INT_SET_SLV_RD_BUF_DONE_INT_SET() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_SET.Reg) & 0x400) >> 10
}
func (o *SPI2_Type) SetDMA_INT_SET_SLV_WR_BUF_DONE_INT_SET(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_SET.Reg, volatile.LoadUint32(&o.DMA_INT_SET.Reg)&^(0x800)|value<<11)
}
func (o *SPI2_Type) GetDMA_INT_SET_SLV_WR_BUF_DONE_INT_SET() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_SET.Reg) & 0x800) >> 11
}
func (o *SPI2_Type) SetDMA_INT_SET_TRANS_DONE_INT_SET(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_SET.Reg, volatile.LoadUint32(&o.DMA_INT_SET.Reg)&^(0x1000)|value<<12)
}
func (o *SPI2_Type) GetDMA_INT_SET_TRANS_DONE_INT_SET() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_SET.Reg) & 0x1000) >> 12
}
func (o *SPI2_Type) SetDMA_INT_SET_DMA_SEG_TRANS_DONE_INT_SET(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_SET.Reg, volatile.LoadUint32(&o.DMA_INT_SET.Reg)&^(0x2000)|value<<13)
}
func (o *SPI2_Type) GetDMA_INT_SET_DMA_SEG_TRANS_DONE_INT_SET() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_SET.Reg) & 0x2000) >> 13
}
func (o *SPI2_Type) SetDMA_INT_SET_SEG_MAGIC_ERR_INT_SET(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_SET.Reg, volatile.LoadUint32(&o.DMA_INT_SET.Reg)&^(0x4000)|value<<14)
}
func (o *SPI2_Type) GetDMA_INT_SET_SEG_MAGIC_ERR_INT_SET() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_SET.Reg) & 0x4000) >> 14
}
func (o *SPI2_Type) SetDMA_INT_SET_SLV_BUF_ADDR_ERR_INT_SET(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_SET.Reg, volatile.LoadUint32(&o.DMA_INT_SET.Reg)&^(0x8000)|value<<15)
}
func (o *SPI2_Type) GetDMA_INT_SET_SLV_BUF_ADDR_ERR_INT_SET() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_SET.Reg) & 0x8000) >> 15
}
func (o *SPI2_Type) SetDMA_INT_SET_SLV_CMD_ERR_INT_SET(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_SET.Reg, volatile.LoadUint32(&o.DMA_INT_SET.Reg)&^(0x10000)|value<<16)
}
func (o *SPI2_Type) GetDMA_INT_SET_SLV_CMD_ERR_INT_SET() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_SET.Reg) & 0x10000) >> 16
}
func (o *SPI2_Type) SetDMA_INT_SET_MST_RX_AFIFO_WFULL_ERR_INT_SET(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_SET.Reg, volatile.LoadUint32(&o.DMA_INT_SET.Reg)&^(0x20000)|value<<17)
}
func (o *SPI2_Type) GetDMA_INT_SET_MST_RX_AFIFO_WFULL_ERR_INT_SET() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_SET.Reg) & 0x20000) >> 17
}
func (o *SPI2_Type) SetDMA_INT_SET_MST_TX_AFIFO_REMPTY_ERR_INT_SET(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_SET.Reg, volatile.LoadUint32(&o.DMA_INT_SET.Reg)&^(0x40000)|value<<18)
}
func (o *SPI2_Type) GetDMA_INT_SET_MST_TX_AFIFO_REMPTY_ERR_INT_SET() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_SET.Reg) & 0x40000) >> 18
}
func (o *SPI2_Type) SetDMA_INT_SET_APP2_INT_SET(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_SET.Reg, volatile.LoadUint32(&o.DMA_INT_SET.Reg)&^(0x80000)|value<<19)
}
func (o *SPI2_Type) GetDMA_INT_SET_APP2_INT_SET() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_SET.Reg) & 0x80000) >> 19
}
func (o *SPI2_Type) SetDMA_INT_SET_APP1_INT_SET(value uint32) {
	volatile.StoreUint32(&o.DMA_INT_SET.Reg, volatile.LoadUint32(&o.DMA_INT_SET.Reg)&^(0x100000)|value<<20)
}
func (o *SPI2_Type) GetDMA_INT_SET_APP1_INT_SET() uint32 {
	return (volatile.LoadUint32(&o.DMA_INT_SET.Reg) & 0x100000) >> 20
}

// SPI2.W0: SPI CPU-controlled buffer0
func (o *SPI2_Type) SetW0(value uint32) {
	volatile.StoreUint32(&o.W0.Reg, value)
}
func (o *SPI2_Type) GetW0() uint32 {
	return volatile.LoadUint32(&o.W0.Reg)
}

// SPI2.W1: SPI CPU-controlled buffer1
func (o *SPI2_Type) SetW1(value uint32) {
	volatile.StoreUint32(&o.W1.Reg, value)
}
func (o *SPI2_Type) GetW1() uint32 {
	return volatile.LoadUint32(&o.W1.Reg)
}

// SPI2.W2: SPI CPU-controlled buffer2
func (o *SPI2_Type) SetW2(value uint32) {
	volatile.StoreUint32(&o.W2.Reg, value)
}
func (o *SPI2_Type) GetW2() uint32 {
	return volatile.LoadUint32(&o.W2.Reg)
}

// SPI2.W3: SPI CPU-controlled buffer3
func (o *SPI2_Type) SetW3(value uint32) {
	volatile.StoreUint32(&o.W3.Reg, value)
}
func (o *SPI2_Type) GetW3() uint32 {
	return volatile.LoadUint32(&o.W3.Reg)
}

// SPI2.W4: SPI CPU-controlled buffer4
func (o *SPI2_Type) SetW4(value uint32) {
	volatile.StoreUint32(&o.W4.Reg, value)
}
func (o *SPI2_Type) GetW4() uint32 {
	return volatile.LoadUint32(&o.W4.Reg)
}

// SPI2.W5: SPI CPU-controlled buffer5
func (o *SPI2_Type) SetW5(value uint32) {
	volatile.StoreUint32(&o.W5.Reg, value)
}
func (o *SPI2_Type) GetW5() uint32 {
	return volatile.LoadUint32(&o.W5.Reg)
}

// SPI2.W6: SPI CPU-controlled buffer6
func (o *SPI2_Type) SetW6(value uint32) {
	volatile.StoreUint32(&o.W6.Reg, value)
}
func (o *SPI2_Type) GetW6() uint32 {
	return volatile.LoadUint32(&o.W6.Reg)
}

// SPI2.W7: SPI CPU-controlled buffer7
func (o *SPI2_Type) SetW7(value uint32) {
	volatile.StoreUint32(&o.W7.Reg, value)
}
func (o *SPI2_Type) GetW7() uint32 {
	return volatile.LoadUint32(&o.W7.Reg)
}

// SPI2.W8: SPI CPU-controlled buffer8
func (o *SPI2_Type) SetW8(value uint32) {
	volatile.StoreUint32(&o.W8.Reg, value)
}
func (o *SPI2_Type) GetW8() uint32 {
	return volatile.LoadUint32(&o.W8.Reg)
}

// SPI2.W9: SPI CPU-controlled buffer9
func (o *SPI2_Type) SetW9(value uint32) {
	volatile.StoreUint32(&o.W9.Reg, value)
}
func (o *SPI2_Type) GetW9() uint32 {
	return volatile.LoadUint32(&o.W9.Reg)
}

// SPI2.W10: SPI CPU-controlled buffer10
func (o *SPI2_Type) SetW10(value uint32) {
	volatile.StoreUint32(&o.W10.Reg, value)
}
func (o *SPI2_Type) GetW10() uint32 {
	return volatile.LoadUint32(&o.W10.Reg)
}

// SPI2.W11: SPI CPU-controlled buffer11
func (o *SPI2_Type) SetW11(value uint32) {
	volatile.StoreUint32(&o.W11.Reg, value)
}
func (o *SPI2_Type) GetW11() uint32 {
	return volatile.LoadUint32(&o.W11.Reg)
}

// SPI2.W12: SPI CPU-controlled buffer12
func (o *SPI2_Type) SetW12(value uint32) {
	volatile.StoreUint32(&o.W12.Reg, value)
}
func (o *SPI2_Type) GetW12() uint32 {
	return volatile.LoadUint32(&o.W12.Reg)
}

// SPI2.W13: SPI CPU-controlled buffer13
func (o *SPI2_Type) SetW13(value uint32) {
	volatile.StoreUint32(&o.W13.Reg, value)
}
func (o *SPI2_Type) GetW13() uint32 {
	return volatile.LoadUint32(&o.W13.Reg)
}

// SPI2.W14: SPI CPU-controlled buffer14
func (o *SPI2_Type) SetW14(value uint32) {
	volatile.StoreUint32(&o.W14.Reg, value)
}
func (o *SPI2_Type) GetW14() uint32 {
	return volatile.LoadUint32(&o.W14.Reg)
}

// SPI2.W15: SPI CPU-controlled buffer15
func (o *SPI2_Type) SetW15(value uint32) {
	volatile.StoreUint32(&o.W15.Reg, value)
}
func (o *SPI2_Type) GetW15() uint32 {
	return volatile.LoadUint32(&o.W15.Reg)
}

// SPI2.SLAVE: SPI slave control register
func (o *SPI2_Type) SetSLAVE_CLK_MODE(value uint32) {
	volatile.StoreUint32(&o.SLAVE.Reg, volatile.LoadUint32(&o.SLAVE.Reg)&^(0x3)|value)
}
func (o *SPI2_Type) GetSLAVE_CLK_MODE() uint32 {
	return volatile.LoadUint32(&o.SLAVE.Reg) & 0x3
}
func (o *SPI2_Type) SetSLAVE_CLK_MODE_13(value uint32) {
	volatile.StoreUint32(&o.SLAVE.Reg, volatile.LoadUint32(&o.SLAVE.Reg)&^(0x4)|value<<2)
}
func (o *SPI2_Type) GetSLAVE_CLK_MODE_13() uint32 {
	return (volatile.LoadUint32(&o.SLAVE.Reg) & 0x4) >> 2
}
func (o *SPI2_Type) SetSLAVE_RSCK_DATA_OUT(value uint32) {
	volatile.StoreUint32(&o.SLAVE.Reg, volatile.LoadUint32(&o.SLAVE.Reg)&^(0x8)|value<<3)
}
func (o *SPI2_Type) GetSLAVE_RSCK_DATA_OUT() uint32 {
	return (volatile.LoadUint32(&o.SLAVE.Reg) & 0x8) >> 3
}
func (o *SPI2_Type) SetSLAVE_SLV_RDDMA_BITLEN_EN(value uint32) {
	volatile.StoreUint32(&o.SLAVE.Reg, volatile.LoadUint32(&o.SLAVE.Reg)&^(0x100)|value<<8)
}
func (o *SPI2_Type) GetSLAVE_SLV_RDDMA_BITLEN_EN() uint32 {
	return (volatile.LoadUint32(&o.SLAVE.Reg) & 0x100) >> 8
}
func (o *SPI2_Type) SetSLAVE_SLV_WRDMA_BITLEN_EN(value uint32) {
	volatile.StoreUint32(&o.SLAVE.Reg, volatile.LoadUint32(&o.SLAVE.Reg)&^(0x200)|value<<9)
}
func (o *SPI2_Type) GetSLAVE_SLV_WRDMA_BITLEN_EN() uint32 {
	return (volatile.LoadUint32(&o.SLAVE.Reg) & 0x200) >> 9
}
func (o *SPI2_Type) SetSLAVE_SLV_RDBUF_BITLEN_EN(value uint32) {
	volatile.StoreUint32(&o.SLAVE.Reg, volatile.LoadUint32(&o.SLAVE.Reg)&^(0x400)|value<<10)
}
func (o *SPI2_Type) GetSLAVE_SLV_RDBUF_BITLEN_EN() uint32 {
	return (volatile.LoadUint32(&o.SLAVE.Reg) & 0x400) >> 10
}
func (o *SPI2_Type) SetSLAVE_SLV_WRBUF_BITLEN_EN(value uint32) {
	volatile.StoreUint32(&o.SLAVE.Reg, volatile.LoadUint32(&o.SLAVE.Reg)&^(0x800)|value<<11)
}
func (o *SPI2_Type) GetSLAVE_SLV_WRBUF_BITLEN_EN() uint32 {
	return (volatile.LoadUint32(&o.SLAVE.Reg) & 0x800) >> 11
}
func (o *SPI2_Type) SetSLAVE_DMA_SEG_MAGIC_VALUE(value uint32) {
	volatile.StoreUint32(&o.SLAVE.Reg, volatile.LoadUint32(&o.SLAVE.Reg)&^(0x3c00000)|value<<22)
}
func (o *SPI2_Type) GetSLAVE_DMA_SEG_MAGIC_VALUE() uint32 {
	return (volatile.LoadUint32(&o.SLAVE.Reg) & 0x3c00000) >> 22
}
func (o *SPI2_Type) SetSLAVE_MODE(value uint32) {
	volatile.StoreUint32(&o.SLAVE.Reg, volatile.LoadUint32(&o.SLAVE.Reg)&^(0x4000000)|value<<26)
}
func (o *SPI2_Type) GetSLAVE_MODE() uint32 {
	return (volatile.LoadUint32(&o.SLAVE.Reg) & 0x4000000) >> 26
}
func (o *SPI2_Type) SetSLAVE_SOFT_RESET(value uint32) {
	volatile.StoreUint32(&o.SLAVE.Reg, volatile.LoadUint32(&o.SLAVE.Reg)&^(0x8000000)|value<<27)
}
func (o *SPI2_Type) GetSLAVE_SOFT_RESET() uint32 {
	return (volatile.LoadUint32(&o.SLAVE.Reg) & 0x8000000) >> 27
}
func (o *SPI2_Type) SetSLAVE_USR_CONF(value uint32) {
	volatile.StoreUint32(&o.SLAVE.Reg, volatile.LoadUint32(&o.SLAVE.Reg)&^(0x10000000)|value<<28)
}
func (o *SPI2_Type) GetSLAVE_USR_CONF() uint32 {
	return (volatile.LoadUint32(&o.SLAVE.Reg) & 0x10000000) >> 28
}

// SPI2.SLAVE1: SPI slave control register 1
func (o *SPI2_Type) SetSLAVE1_SLV_DATA_BITLEN(value uint32) {
	volatile.StoreUint32(&o.SLAVE1.Reg, volatile.LoadUint32(&o.SLAVE1.Reg)&^(0x3ffff)|value)
}
func (o *SPI2_Type) GetSLAVE1_SLV_DATA_BITLEN() uint32 {
	return volatile.LoadUint32(&o.SLAVE1.Reg) & 0x3ffff
}
func (o *SPI2_Type) SetSLAVE1_SLV_LAST_COMMAND(value uint32) {
	volatile.StoreUint32(&o.SLAVE1.Reg, volatile.LoadUint32(&o.SLAVE1.Reg)&^(0x3fc0000)|value<<18)
}
func (o *SPI2_Type) GetSLAVE1_SLV_LAST_COMMAND() uint32 {
	return (volatile.LoadUint32(&o.SLAVE1.Reg) & 0x3fc0000) >> 18
}
func (o *SPI2_Type) SetSLAVE1_SLV_LAST_ADDR(value uint32) {
	volatile.StoreUint32(&o.SLAVE1.Reg, volatile.LoadUint32(&o.SLAVE1.Reg)&^(0xfc000000)|value<<26)
}
func (o *SPI2_Type) GetSLAVE1_SLV_LAST_ADDR() uint32 {
	return (volatile.LoadUint32(&o.SLAVE1.Reg) & 0xfc000000) >> 26
}

// SPI2.CLK_GATE: SPI module clock and register clock control
func (o *SPI2_Type) SetCLK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_GATE.Reg, volatile.LoadUint32(&o.CLK_GATE.Reg)&^(0x1)|value)
}
func (o *SPI2_Type) GetCLK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLK_GATE.Reg) & 0x1
}
func (o *SPI2_Type) SetCLK_GATE_MST_CLK_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.CLK_GATE.Reg, volatile.LoadUint32(&o.CLK_GATE.Reg)&^(0x2)|value<<1)
}
func (o *SPI2_Type) GetCLK_GATE_MST_CLK_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GATE.Reg) & 0x2) >> 1
}
func (o *SPI2_Type) SetCLK_GATE_MST_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CLK_GATE.Reg, volatile.LoadUint32(&o.CLK_GATE.Reg)&^(0x4)|value<<2)
}
func (o *SPI2_Type) GetCLK_GATE_MST_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.CLK_GATE.Reg) & 0x4) >> 2
}

// SPI2.DATE: Version control
func (o *SPI2_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *SPI2_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// System Configuration Registers
type SYSTEM_Type struct {
	CPU_PERI_CLK_EN                         volatile.Register32 // 0x0
	CPU_PERI_RST_EN                         volatile.Register32 // 0x4
	CPU_PER_CONF                            volatile.Register32 // 0x8
	MEM_PD_MASK                             volatile.Register32 // 0xC
	PERIP_CLK_EN0                           volatile.Register32 // 0x10
	PERIP_CLK_EN1                           volatile.Register32 // 0x14
	PERIP_RST_EN0                           volatile.Register32 // 0x18
	PERIP_RST_EN1                           volatile.Register32 // 0x1C
	BT_LPCK_DIV_INT                         volatile.Register32 // 0x20
	BT_LPCK_DIV_FRAC                        volatile.Register32 // 0x24
	CPU_INTR_FROM_CPU_0                     volatile.Register32 // 0x28
	CPU_INTR_FROM_CPU_1                     volatile.Register32 // 0x2C
	CPU_INTR_FROM_CPU_2                     volatile.Register32 // 0x30
	CPU_INTR_FROM_CPU_3                     volatile.Register32 // 0x34
	RSA_PD_CTRL                             volatile.Register32 // 0x38
	EDMA_CTRL                               volatile.Register32 // 0x3C
	CACHE_CONTROL                           volatile.Register32 // 0x40
	EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL volatile.Register32 // 0x44
	RTC_FASTMEM_CONFIG                      volatile.Register32 // 0x48
	RTC_FASTMEM_CRC                         volatile.Register32 // 0x4C
	REDUNDANT_ECO_CTRL                      volatile.Register32 // 0x50
	CLOCK_GATE                              volatile.Register32 // 0x54
	SYSCLK_CONF                             volatile.Register32 // 0x58
	MEM_PVT                                 volatile.Register32 // 0x5C
	COMB_PVT_LVT_CONF                       volatile.Register32 // 0x60
	COMB_PVT_NVT_CONF                       volatile.Register32 // 0x64
	COMB_PVT_HVT_CONF                       volatile.Register32 // 0x68
	COMB_PVT_ERR_LVT_SITE0                  volatile.Register32 // 0x6C
	COMB_PVT_ERR_NVT_SITE0                  volatile.Register32 // 0x70
	COMB_PVT_ERR_HVT_SITE0                  volatile.Register32 // 0x74
	COMB_PVT_ERR_LVT_SITE1                  volatile.Register32 // 0x78
	COMB_PVT_ERR_NVT_SITE1                  volatile.Register32 // 0x7C
	COMB_PVT_ERR_HVT_SITE1                  volatile.Register32 // 0x80
	COMB_PVT_ERR_LVT_SITE2                  volatile.Register32 // 0x84
	COMB_PVT_ERR_NVT_SITE2                  volatile.Register32 // 0x88
	COMB_PVT_ERR_HVT_SITE2                  volatile.Register32 // 0x8C
	COMB_PVT_ERR_LVT_SITE3                  volatile.Register32 // 0x90
	COMB_PVT_ERR_NVT_SITE3                  volatile.Register32 // 0x94
	COMB_PVT_ERR_HVT_SITE3                  volatile.Register32 // 0x98
	_                                       [3936]byte
	REG_DATE                                volatile.Register32 // 0xFFC
}

// SYSTEM.CPU_PERI_CLK_EN: cpu_peripheral clock gating register
func (o *SYSTEM_Type) SetCPU_PERI_CLK_EN_CLK_EN_ASSIST_DEBUG(value uint32) {
	volatile.StoreUint32(&o.CPU_PERI_CLK_EN.Reg, volatile.LoadUint32(&o.CPU_PERI_CLK_EN.Reg)&^(0x40)|value<<6)
}
func (o *SYSTEM_Type) GetCPU_PERI_CLK_EN_CLK_EN_ASSIST_DEBUG() uint32 {
	return (volatile.LoadUint32(&o.CPU_PERI_CLK_EN.Reg) & 0x40) >> 6
}
func (o *SYSTEM_Type) SetCPU_PERI_CLK_EN_CLK_EN_DEDICATED_GPIO(value uint32) {
	volatile.StoreUint32(&o.CPU_PERI_CLK_EN.Reg, volatile.LoadUint32(&o.CPU_PERI_CLK_EN.Reg)&^(0x80)|value<<7)
}
func (o *SYSTEM_Type) GetCPU_PERI_CLK_EN_CLK_EN_DEDICATED_GPIO() uint32 {
	return (volatile.LoadUint32(&o.CPU_PERI_CLK_EN.Reg) & 0x80) >> 7
}

// SYSTEM.CPU_PERI_RST_EN: cpu_peripheral reset register
func (o *SYSTEM_Type) SetCPU_PERI_RST_EN_RST_EN_ASSIST_DEBUG(value uint32) {
	volatile.StoreUint32(&o.CPU_PERI_RST_EN.Reg, volatile.LoadUint32(&o.CPU_PERI_RST_EN.Reg)&^(0x40)|value<<6)
}
func (o *SYSTEM_Type) GetCPU_PERI_RST_EN_RST_EN_ASSIST_DEBUG() uint32 {
	return (volatile.LoadUint32(&o.CPU_PERI_RST_EN.Reg) & 0x40) >> 6
}
func (o *SYSTEM_Type) SetCPU_PERI_RST_EN_RST_EN_DEDICATED_GPIO(value uint32) {
	volatile.StoreUint32(&o.CPU_PERI_RST_EN.Reg, volatile.LoadUint32(&o.CPU_PERI_RST_EN.Reg)&^(0x80)|value<<7)
}
func (o *SYSTEM_Type) GetCPU_PERI_RST_EN_RST_EN_DEDICATED_GPIO() uint32 {
	return (volatile.LoadUint32(&o.CPU_PERI_RST_EN.Reg) & 0x80) >> 7
}

// SYSTEM.CPU_PER_CONF: cpu clock config register
func (o *SYSTEM_Type) SetCPU_PER_CONF_CPUPERIOD_SEL(value uint32) {
	volatile.StoreUint32(&o.CPU_PER_CONF.Reg, volatile.LoadUint32(&o.CPU_PER_CONF.Reg)&^(0x3)|value)
}
func (o *SYSTEM_Type) GetCPU_PER_CONF_CPUPERIOD_SEL() uint32 {
	return volatile.LoadUint32(&o.CPU_PER_CONF.Reg) & 0x3
}
func (o *SYSTEM_Type) SetCPU_PER_CONF_PLL_FREQ_SEL(value uint32) {
	volatile.StoreUint32(&o.CPU_PER_CONF.Reg, volatile.LoadUint32(&o.CPU_PER_CONF.Reg)&^(0x4)|value<<2)
}
func (o *SYSTEM_Type) GetCPU_PER_CONF_PLL_FREQ_SEL() uint32 {
	return (volatile.LoadUint32(&o.CPU_PER_CONF.Reg) & 0x4) >> 2
}
func (o *SYSTEM_Type) SetCPU_PER_CONF_CPU_WAIT_MODE_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.CPU_PER_CONF.Reg, volatile.LoadUint32(&o.CPU_PER_CONF.Reg)&^(0x8)|value<<3)
}
func (o *SYSTEM_Type) GetCPU_PER_CONF_CPU_WAIT_MODE_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.CPU_PER_CONF.Reg) & 0x8) >> 3
}
func (o *SYSTEM_Type) SetCPU_PER_CONF_CPU_WAITI_DELAY_NUM(value uint32) {
	volatile.StoreUint32(&o.CPU_PER_CONF.Reg, volatile.LoadUint32(&o.CPU_PER_CONF.Reg)&^(0xf0)|value<<4)
}
func (o *SYSTEM_Type) GetCPU_PER_CONF_CPU_WAITI_DELAY_NUM() uint32 {
	return (volatile.LoadUint32(&o.CPU_PER_CONF.Reg) & 0xf0) >> 4
}

// SYSTEM.MEM_PD_MASK: memory power down mask register
func (o *SYSTEM_Type) SetMEM_PD_MASK_LSLP_MEM_PD_MASK(value uint32) {
	volatile.StoreUint32(&o.MEM_PD_MASK.Reg, volatile.LoadUint32(&o.MEM_PD_MASK.Reg)&^(0x1)|value)
}
func (o *SYSTEM_Type) GetMEM_PD_MASK_LSLP_MEM_PD_MASK() uint32 {
	return volatile.LoadUint32(&o.MEM_PD_MASK.Reg) & 0x1
}

// SYSTEM.PERIP_CLK_EN0: peripheral clock gating register
func (o *SYSTEM_Type) SetPERIP_CLK_EN0_SPI01_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN0.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN0.Reg)&^(0x2)|value<<1)
}
func (o *SYSTEM_Type) GetPERIP_CLK_EN0_SPI01_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN0.Reg) & 0x2) >> 1
}
func (o *SYSTEM_Type) SetPERIP_CLK_EN0_UART_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN0.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN0.Reg)&^(0x4)|value<<2)
}
func (o *SYSTEM_Type) GetPERIP_CLK_EN0_UART_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN0.Reg) & 0x4) >> 2
}
func (o *SYSTEM_Type) SetPERIP_CLK_EN0_UART1_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN0.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN0.Reg)&^(0x20)|value<<5)
}
func (o *SYSTEM_Type) GetPERIP_CLK_EN0_UART1_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN0.Reg) & 0x20) >> 5
}
func (o *SYSTEM_Type) SetPERIP_CLK_EN0_SPI2_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN0.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN0.Reg)&^(0x40)|value<<6)
}
func (o *SYSTEM_Type) GetPERIP_CLK_EN0_SPI2_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN0.Reg) & 0x40) >> 6
}
func (o *SYSTEM_Type) SetPERIP_CLK_EN0_I2C_EXT0_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN0.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN0.Reg)&^(0x80)|value<<7)
}
func (o *SYSTEM_Type) GetPERIP_CLK_EN0_I2C_EXT0_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN0.Reg) & 0x80) >> 7
}
func (o *SYSTEM_Type) SetPERIP_CLK_EN0_LEDC_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN0.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN0.Reg)&^(0x800)|value<<11)
}
func (o *SYSTEM_Type) GetPERIP_CLK_EN0_LEDC_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN0.Reg) & 0x800) >> 11
}
func (o *SYSTEM_Type) SetPERIP_CLK_EN0_TIMERGROUP_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN0.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN0.Reg)&^(0x2000)|value<<13)
}
func (o *SYSTEM_Type) GetPERIP_CLK_EN0_TIMERGROUP_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN0.Reg) & 0x2000) >> 13
}
func (o *SYSTEM_Type) SetPERIP_CLK_EN0_UART_MEM_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN0.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN0.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSTEM_Type) GetPERIP_CLK_EN0_UART_MEM_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN0.Reg) & 0x1000000) >> 24
}
func (o *SYSTEM_Type) SetPERIP_CLK_EN0_APB_SARADC_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN0.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN0.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSTEM_Type) GetPERIP_CLK_EN0_APB_SARADC_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN0.Reg) & 0x10000000) >> 28
}
func (o *SYSTEM_Type) SetPERIP_CLK_EN0_SYSTIMER_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN0.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN0.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSTEM_Type) GetPERIP_CLK_EN0_SYSTIMER_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN0.Reg) & 0x20000000) >> 29
}
func (o *SYSTEM_Type) SetPERIP_CLK_EN0_ADC2_ARB_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN0.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN0.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSTEM_Type) GetPERIP_CLK_EN0_ADC2_ARB_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN0.Reg) & 0x40000000) >> 30
}

// SYSTEM.PERIP_CLK_EN1: peripheral clock gating register
func (o *SYSTEM_Type) SetPERIP_CLK_EN1_CRYPTO_ECC_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN1.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN1.Reg)&^(0x2)|value<<1)
}
func (o *SYSTEM_Type) GetPERIP_CLK_EN1_CRYPTO_ECC_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN1.Reg) & 0x2) >> 1
}
func (o *SYSTEM_Type) SetPERIP_CLK_EN1_CRYPTO_SHA_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN1.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN1.Reg)&^(0x4)|value<<2)
}
func (o *SYSTEM_Type) GetPERIP_CLK_EN1_CRYPTO_SHA_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN1.Reg) & 0x4) >> 2
}
func (o *SYSTEM_Type) SetPERIP_CLK_EN1_DMA_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN1.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN1.Reg)&^(0x40)|value<<6)
}
func (o *SYSTEM_Type) GetPERIP_CLK_EN1_DMA_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN1.Reg) & 0x40) >> 6
}
func (o *SYSTEM_Type) SetPERIP_CLK_EN1_TSENS_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.PERIP_CLK_EN1.Reg, volatile.LoadUint32(&o.PERIP_CLK_EN1.Reg)&^(0x400)|value<<10)
}
func (o *SYSTEM_Type) GetPERIP_CLK_EN1_TSENS_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PERIP_CLK_EN1.Reg) & 0x400) >> 10
}

// SYSTEM.PERIP_RST_EN0: reserved
func (o *SYSTEM_Type) SetPERIP_RST_EN0_SPI01_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN0.Reg, volatile.LoadUint32(&o.PERIP_RST_EN0.Reg)&^(0x2)|value<<1)
}
func (o *SYSTEM_Type) GetPERIP_RST_EN0_SPI01_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN0.Reg) & 0x2) >> 1
}
func (o *SYSTEM_Type) SetPERIP_RST_EN0_UART_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN0.Reg, volatile.LoadUint32(&o.PERIP_RST_EN0.Reg)&^(0x4)|value<<2)
}
func (o *SYSTEM_Type) GetPERIP_RST_EN0_UART_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN0.Reg) & 0x4) >> 2
}
func (o *SYSTEM_Type) SetPERIP_RST_EN0_UART1_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN0.Reg, volatile.LoadUint32(&o.PERIP_RST_EN0.Reg)&^(0x20)|value<<5)
}
func (o *SYSTEM_Type) GetPERIP_RST_EN0_UART1_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN0.Reg) & 0x20) >> 5
}
func (o *SYSTEM_Type) SetPERIP_RST_EN0_SPI2_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN0.Reg, volatile.LoadUint32(&o.PERIP_RST_EN0.Reg)&^(0x40)|value<<6)
}
func (o *SYSTEM_Type) GetPERIP_RST_EN0_SPI2_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN0.Reg) & 0x40) >> 6
}
func (o *SYSTEM_Type) SetPERIP_RST_EN0_I2C_EXT0_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN0.Reg, volatile.LoadUint32(&o.PERIP_RST_EN0.Reg)&^(0x80)|value<<7)
}
func (o *SYSTEM_Type) GetPERIP_RST_EN0_I2C_EXT0_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN0.Reg) & 0x80) >> 7
}
func (o *SYSTEM_Type) SetPERIP_RST_EN0_LEDC_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN0.Reg, volatile.LoadUint32(&o.PERIP_RST_EN0.Reg)&^(0x800)|value<<11)
}
func (o *SYSTEM_Type) GetPERIP_RST_EN0_LEDC_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN0.Reg) & 0x800) >> 11
}
func (o *SYSTEM_Type) SetPERIP_RST_EN0_TIMERGROUP_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN0.Reg, volatile.LoadUint32(&o.PERIP_RST_EN0.Reg)&^(0x2000)|value<<13)
}
func (o *SYSTEM_Type) GetPERIP_RST_EN0_TIMERGROUP_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN0.Reg) & 0x2000) >> 13
}
func (o *SYSTEM_Type) SetPERIP_RST_EN0_UART_MEM_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN0.Reg, volatile.LoadUint32(&o.PERIP_RST_EN0.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSTEM_Type) GetPERIP_RST_EN0_UART_MEM_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN0.Reg) & 0x1000000) >> 24
}
func (o *SYSTEM_Type) SetPERIP_RST_EN0_APB_SARADC_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN0.Reg, volatile.LoadUint32(&o.PERIP_RST_EN0.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSTEM_Type) GetPERIP_RST_EN0_APB_SARADC_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN0.Reg) & 0x10000000) >> 28
}
func (o *SYSTEM_Type) SetPERIP_RST_EN0_SYSTIMER_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN0.Reg, volatile.LoadUint32(&o.PERIP_RST_EN0.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSTEM_Type) GetPERIP_RST_EN0_SYSTIMER_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN0.Reg) & 0x20000000) >> 29
}
func (o *SYSTEM_Type) SetPERIP_RST_EN0_ADC2_ARB_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN0.Reg, volatile.LoadUint32(&o.PERIP_RST_EN0.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSTEM_Type) GetPERIP_RST_EN0_ADC2_ARB_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN0.Reg) & 0x40000000) >> 30
}

// SYSTEM.PERIP_RST_EN1: peripheral reset register
func (o *SYSTEM_Type) SetPERIP_RST_EN1_CRYPTO_ECC_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN1.Reg, volatile.LoadUint32(&o.PERIP_RST_EN1.Reg)&^(0x2)|value<<1)
}
func (o *SYSTEM_Type) GetPERIP_RST_EN1_CRYPTO_ECC_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN1.Reg) & 0x2) >> 1
}
func (o *SYSTEM_Type) SetPERIP_RST_EN1_CRYPTO_SHA_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN1.Reg, volatile.LoadUint32(&o.PERIP_RST_EN1.Reg)&^(0x4)|value<<2)
}
func (o *SYSTEM_Type) GetPERIP_RST_EN1_CRYPTO_SHA_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN1.Reg) & 0x4) >> 2
}
func (o *SYSTEM_Type) SetPERIP_RST_EN1_DMA_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN1.Reg, volatile.LoadUint32(&o.PERIP_RST_EN1.Reg)&^(0x40)|value<<6)
}
func (o *SYSTEM_Type) GetPERIP_RST_EN1_DMA_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN1.Reg) & 0x40) >> 6
}
func (o *SYSTEM_Type) SetPERIP_RST_EN1_TSENS_RST(value uint32) {
	volatile.StoreUint32(&o.PERIP_RST_EN1.Reg, volatile.LoadUint32(&o.PERIP_RST_EN1.Reg)&^(0x400)|value<<10)
}
func (o *SYSTEM_Type) GetPERIP_RST_EN1_TSENS_RST() uint32 {
	return (volatile.LoadUint32(&o.PERIP_RST_EN1.Reg) & 0x400) >> 10
}

// SYSTEM.BT_LPCK_DIV_INT: clock config register
func (o *SYSTEM_Type) SetBT_LPCK_DIV_INT_BT_LPCK_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.BT_LPCK_DIV_INT.Reg, volatile.LoadUint32(&o.BT_LPCK_DIV_INT.Reg)&^(0xfff)|value)
}
func (o *SYSTEM_Type) GetBT_LPCK_DIV_INT_BT_LPCK_DIV_NUM() uint32 {
	return volatile.LoadUint32(&o.BT_LPCK_DIV_INT.Reg) & 0xfff
}

// SYSTEM.BT_LPCK_DIV_FRAC: low power clock configuration register
func (o *SYSTEM_Type) SetBT_LPCK_DIV_FRAC_BT_LPCK_DIV_B(value uint32) {
	volatile.StoreUint32(&o.BT_LPCK_DIV_FRAC.Reg, volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg)&^(0xfff)|value)
}
func (o *SYSTEM_Type) GetBT_LPCK_DIV_FRAC_BT_LPCK_DIV_B() uint32 {
	return volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg) & 0xfff
}
func (o *SYSTEM_Type) SetBT_LPCK_DIV_FRAC_BT_LPCK_DIV_A(value uint32) {
	volatile.StoreUint32(&o.BT_LPCK_DIV_FRAC.Reg, volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg)&^(0xfff000)|value<<12)
}
func (o *SYSTEM_Type) GetBT_LPCK_DIV_FRAC_BT_LPCK_DIV_A() uint32 {
	return (volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg) & 0xfff000) >> 12
}
func (o *SYSTEM_Type) SetBT_LPCK_DIV_FRAC_LPCLK_SEL_RTC_SLOW(value uint32) {
	volatile.StoreUint32(&o.BT_LPCK_DIV_FRAC.Reg, volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSTEM_Type) GetBT_LPCK_DIV_FRAC_LPCLK_SEL_RTC_SLOW() uint32 {
	return (volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg) & 0x1000000) >> 24
}
func (o *SYSTEM_Type) SetBT_LPCK_DIV_FRAC_LPCLK_SEL_8M(value uint32) {
	volatile.StoreUint32(&o.BT_LPCK_DIV_FRAC.Reg, volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSTEM_Type) GetBT_LPCK_DIV_FRAC_LPCLK_SEL_8M() uint32 {
	return (volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg) & 0x2000000) >> 25
}
func (o *SYSTEM_Type) SetBT_LPCK_DIV_FRAC_LPCLK_SEL_XTAL(value uint32) {
	volatile.StoreUint32(&o.BT_LPCK_DIV_FRAC.Reg, volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSTEM_Type) GetBT_LPCK_DIV_FRAC_LPCLK_SEL_XTAL() uint32 {
	return (volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg) & 0x4000000) >> 26
}
func (o *SYSTEM_Type) SetBT_LPCK_DIV_FRAC_LPCLK_SEL_XTAL32K(value uint32) {
	volatile.StoreUint32(&o.BT_LPCK_DIV_FRAC.Reg, volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSTEM_Type) GetBT_LPCK_DIV_FRAC_LPCLK_SEL_XTAL32K() uint32 {
	return (volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg) & 0x8000000) >> 27
}
func (o *SYSTEM_Type) SetBT_LPCK_DIV_FRAC_LPCLK_RTC_EN(value uint32) {
	volatile.StoreUint32(&o.BT_LPCK_DIV_FRAC.Reg, volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSTEM_Type) GetBT_LPCK_DIV_FRAC_LPCLK_RTC_EN() uint32 {
	return (volatile.LoadUint32(&o.BT_LPCK_DIV_FRAC.Reg) & 0x10000000) >> 28
}

// SYSTEM.CPU_INTR_FROM_CPU_0: interrupt generate register
func (o *SYSTEM_Type) SetCPU_INTR_FROM_CPU_0(value uint32) {
	volatile.StoreUint32(&o.CPU_INTR_FROM_CPU_0.Reg, volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_0.Reg)&^(0x1)|value)
}
func (o *SYSTEM_Type) GetCPU_INTR_FROM_CPU_0() uint32 {
	return volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_0.Reg) & 0x1
}

// SYSTEM.CPU_INTR_FROM_CPU_1: interrupt generate register
func (o *SYSTEM_Type) SetCPU_INTR_FROM_CPU_1(value uint32) {
	volatile.StoreUint32(&o.CPU_INTR_FROM_CPU_1.Reg, volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_1.Reg)&^(0x1)|value)
}
func (o *SYSTEM_Type) GetCPU_INTR_FROM_CPU_1() uint32 {
	return volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_1.Reg) & 0x1
}

// SYSTEM.CPU_INTR_FROM_CPU_2: interrupt generate register
func (o *SYSTEM_Type) SetCPU_INTR_FROM_CPU_2(value uint32) {
	volatile.StoreUint32(&o.CPU_INTR_FROM_CPU_2.Reg, volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_2.Reg)&^(0x1)|value)
}
func (o *SYSTEM_Type) GetCPU_INTR_FROM_CPU_2() uint32 {
	return volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_2.Reg) & 0x1
}

// SYSTEM.CPU_INTR_FROM_CPU_3: interrupt generate register
func (o *SYSTEM_Type) SetCPU_INTR_FROM_CPU_3(value uint32) {
	volatile.StoreUint32(&o.CPU_INTR_FROM_CPU_3.Reg, volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_3.Reg)&^(0x1)|value)
}
func (o *SYSTEM_Type) GetCPU_INTR_FROM_CPU_3() uint32 {
	return volatile.LoadUint32(&o.CPU_INTR_FROM_CPU_3.Reg) & 0x1
}

// SYSTEM.RSA_PD_CTRL: rsa memory power control register
func (o *SYSTEM_Type) SetRSA_PD_CTRL_RSA_MEM_PD(value uint32) {
	volatile.StoreUint32(&o.RSA_PD_CTRL.Reg, volatile.LoadUint32(&o.RSA_PD_CTRL.Reg)&^(0x1)|value)
}
func (o *SYSTEM_Type) GetRSA_PD_CTRL_RSA_MEM_PD() uint32 {
	return volatile.LoadUint32(&o.RSA_PD_CTRL.Reg) & 0x1
}
func (o *SYSTEM_Type) SetRSA_PD_CTRL_RSA_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.RSA_PD_CTRL.Reg, volatile.LoadUint32(&o.RSA_PD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *SYSTEM_Type) GetRSA_PD_CTRL_RSA_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.RSA_PD_CTRL.Reg) & 0x2) >> 1
}
func (o *SYSTEM_Type) SetRSA_PD_CTRL_RSA_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.RSA_PD_CTRL.Reg, volatile.LoadUint32(&o.RSA_PD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *SYSTEM_Type) GetRSA_PD_CTRL_RSA_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.RSA_PD_CTRL.Reg) & 0x4) >> 2
}

// SYSTEM.EDMA_CTRL: edma clcok and reset register
func (o *SYSTEM_Type) SetEDMA_CTRL_EDMA_CLK_ON(value uint32) {
	volatile.StoreUint32(&o.EDMA_CTRL.Reg, volatile.LoadUint32(&o.EDMA_CTRL.Reg)&^(0x1)|value)
}
func (o *SYSTEM_Type) GetEDMA_CTRL_EDMA_CLK_ON() uint32 {
	return volatile.LoadUint32(&o.EDMA_CTRL.Reg) & 0x1
}
func (o *SYSTEM_Type) SetEDMA_CTRL_EDMA_RESET(value uint32) {
	volatile.StoreUint32(&o.EDMA_CTRL.Reg, volatile.LoadUint32(&o.EDMA_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *SYSTEM_Type) GetEDMA_CTRL_EDMA_RESET() uint32 {
	return (volatile.LoadUint32(&o.EDMA_CTRL.Reg) & 0x2) >> 1
}

// SYSTEM.CACHE_CONTROL: cache control register
func (o *SYSTEM_Type) SetCACHE_CONTROL_ICACHE_CLK_ON(value uint32) {
	volatile.StoreUint32(&o.CACHE_CONTROL.Reg, volatile.LoadUint32(&o.CACHE_CONTROL.Reg)&^(0x1)|value)
}
func (o *SYSTEM_Type) GetCACHE_CONTROL_ICACHE_CLK_ON() uint32 {
	return volatile.LoadUint32(&o.CACHE_CONTROL.Reg) & 0x1
}
func (o *SYSTEM_Type) SetCACHE_CONTROL_ICACHE_RESET(value uint32) {
	volatile.StoreUint32(&o.CACHE_CONTROL.Reg, volatile.LoadUint32(&o.CACHE_CONTROL.Reg)&^(0x2)|value<<1)
}
func (o *SYSTEM_Type) GetCACHE_CONTROL_ICACHE_RESET() uint32 {
	return (volatile.LoadUint32(&o.CACHE_CONTROL.Reg) & 0x2) >> 1
}
func (o *SYSTEM_Type) SetCACHE_CONTROL_DCACHE_CLK_ON(value uint32) {
	volatile.StoreUint32(&o.CACHE_CONTROL.Reg, volatile.LoadUint32(&o.CACHE_CONTROL.Reg)&^(0x4)|value<<2)
}
func (o *SYSTEM_Type) GetCACHE_CONTROL_DCACHE_CLK_ON() uint32 {
	return (volatile.LoadUint32(&o.CACHE_CONTROL.Reg) & 0x4) >> 2
}
func (o *SYSTEM_Type) SetCACHE_CONTROL_DCACHE_RESET(value uint32) {
	volatile.StoreUint32(&o.CACHE_CONTROL.Reg, volatile.LoadUint32(&o.CACHE_CONTROL.Reg)&^(0x8)|value<<3)
}
func (o *SYSTEM_Type) GetCACHE_CONTROL_DCACHE_RESET() uint32 {
	return (volatile.LoadUint32(&o.CACHE_CONTROL.Reg) & 0x8) >> 3
}

// SYSTEM.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL: SYSTEM_EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL_REG
func (o *SYSTEM_Type) SetEXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL_ENABLE_SPI_MANUAL_ENCRYPT(value uint32) {
	volatile.StoreUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg, volatile.LoadUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg)&^(0x1)|value)
}
func (o *SYSTEM_Type) GetEXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL_ENABLE_SPI_MANUAL_ENCRYPT() uint32 {
	return volatile.LoadUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg) & 0x1
}
func (o *SYSTEM_Type) SetEXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL_ENABLE_DOWNLOAD_DB_ENCRYPT(value uint32) {
	volatile.StoreUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg, volatile.LoadUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg)&^(0x2)|value<<1)
}
func (o *SYSTEM_Type) GetEXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL_ENABLE_DOWNLOAD_DB_ENCRYPT() uint32 {
	return (volatile.LoadUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg) & 0x2) >> 1
}
func (o *SYSTEM_Type) SetEXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL_ENABLE_DOWNLOAD_G0CB_DECRYPT(value uint32) {
	volatile.StoreUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg, volatile.LoadUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg)&^(0x4)|value<<2)
}
func (o *SYSTEM_Type) GetEXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL_ENABLE_DOWNLOAD_G0CB_DECRYPT() uint32 {
	return (volatile.LoadUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg) & 0x4) >> 2
}
func (o *SYSTEM_Type) SetEXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL_ENABLE_DOWNLOAD_MANUAL_ENCRYPT(value uint32) {
	volatile.StoreUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg, volatile.LoadUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg)&^(0x8)|value<<3)
}
func (o *SYSTEM_Type) GetEXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL_ENABLE_DOWNLOAD_MANUAL_ENCRYPT() uint32 {
	return (volatile.LoadUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg) & 0x8) >> 3
}

// SYSTEM.RTC_FASTMEM_CONFIG: fast memory config register
func (o *SYSTEM_Type) SetRTC_FASTMEM_CONFIG_RTC_MEM_CRC_START(value uint32) {
	volatile.StoreUint32(&o.RTC_FASTMEM_CONFIG.Reg, volatile.LoadUint32(&o.RTC_FASTMEM_CONFIG.Reg)&^(0x100)|value<<8)
}
func (o *SYSTEM_Type) GetRTC_FASTMEM_CONFIG_RTC_MEM_CRC_START() uint32 {
	return (volatile.LoadUint32(&o.RTC_FASTMEM_CONFIG.Reg) & 0x100) >> 8
}
func (o *SYSTEM_Type) SetRTC_FASTMEM_CONFIG_RTC_MEM_CRC_ADDR(value uint32) {
	volatile.StoreUint32(&o.RTC_FASTMEM_CONFIG.Reg, volatile.LoadUint32(&o.RTC_FASTMEM_CONFIG.Reg)&^(0xffe00)|value<<9)
}
func (o *SYSTEM_Type) GetRTC_FASTMEM_CONFIG_RTC_MEM_CRC_ADDR() uint32 {
	return (volatile.LoadUint32(&o.RTC_FASTMEM_CONFIG.Reg) & 0xffe00) >> 9
}
func (o *SYSTEM_Type) SetRTC_FASTMEM_CONFIG_RTC_MEM_CRC_LEN(value uint32) {
	volatile.StoreUint32(&o.RTC_FASTMEM_CONFIG.Reg, volatile.LoadUint32(&o.RTC_FASTMEM_CONFIG.Reg)&^(0x7ff00000)|value<<20)
}
func (o *SYSTEM_Type) GetRTC_FASTMEM_CONFIG_RTC_MEM_CRC_LEN() uint32 {
	return (volatile.LoadUint32(&o.RTC_FASTMEM_CONFIG.Reg) & 0x7ff00000) >> 20
}
func (o *SYSTEM_Type) SetRTC_FASTMEM_CONFIG_RTC_MEM_CRC_FINISH(value uint32) {
	volatile.StoreUint32(&o.RTC_FASTMEM_CONFIG.Reg, volatile.LoadUint32(&o.RTC_FASTMEM_CONFIG.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSTEM_Type) GetRTC_FASTMEM_CONFIG_RTC_MEM_CRC_FINISH() uint32 {
	return (volatile.LoadUint32(&o.RTC_FASTMEM_CONFIG.Reg) & 0x80000000) >> 31
}

// SYSTEM.RTC_FASTMEM_CRC: reserved
func (o *SYSTEM_Type) SetRTC_FASTMEM_CRC(value uint32) {
	volatile.StoreUint32(&o.RTC_FASTMEM_CRC.Reg, value)
}
func (o *SYSTEM_Type) GetRTC_FASTMEM_CRC() uint32 {
	return volatile.LoadUint32(&o.RTC_FASTMEM_CRC.Reg)
}

// SYSTEM.REDUNDANT_ECO_CTRL: eco register
func (o *SYSTEM_Type) SetREDUNDANT_ECO_CTRL_REDUNDANT_ECO_DRIVE(value uint32) {
	volatile.StoreUint32(&o.REDUNDANT_ECO_CTRL.Reg, volatile.LoadUint32(&o.REDUNDANT_ECO_CTRL.Reg)&^(0x1)|value)
}
func (o *SYSTEM_Type) GetREDUNDANT_ECO_CTRL_REDUNDANT_ECO_DRIVE() uint32 {
	return volatile.LoadUint32(&o.REDUNDANT_ECO_CTRL.Reg) & 0x1
}
func (o *SYSTEM_Type) SetREDUNDANT_ECO_CTRL_REDUNDANT_ECO_RESULT(value uint32) {
	volatile.StoreUint32(&o.REDUNDANT_ECO_CTRL.Reg, volatile.LoadUint32(&o.REDUNDANT_ECO_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *SYSTEM_Type) GetREDUNDANT_ECO_CTRL_REDUNDANT_ECO_RESULT() uint32 {
	return (volatile.LoadUint32(&o.REDUNDANT_ECO_CTRL.Reg) & 0x2) >> 1
}

// SYSTEM.CLOCK_GATE: clock gating register
func (o *SYSTEM_Type) SetCLOCK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *SYSTEM_Type) GetCLOCK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// SYSTEM.SYSCLK_CONF: system clock config register
func (o *SYSTEM_Type) SetSYSCLK_CONF_PRE_DIV_CNT(value uint32) {
	volatile.StoreUint32(&o.SYSCLK_CONF.Reg, volatile.LoadUint32(&o.SYSCLK_CONF.Reg)&^(0x3ff)|value)
}
func (o *SYSTEM_Type) GetSYSCLK_CONF_PRE_DIV_CNT() uint32 {
	return volatile.LoadUint32(&o.SYSCLK_CONF.Reg) & 0x3ff
}
func (o *SYSTEM_Type) SetSYSCLK_CONF_SOC_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.SYSCLK_CONF.Reg, volatile.LoadUint32(&o.SYSCLK_CONF.Reg)&^(0xc00)|value<<10)
}
func (o *SYSTEM_Type) GetSYSCLK_CONF_SOC_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.SYSCLK_CONF.Reg) & 0xc00) >> 10
}
func (o *SYSTEM_Type) SetSYSCLK_CONF_CLK_XTAL_FREQ(value uint32) {
	volatile.StoreUint32(&o.SYSCLK_CONF.Reg, volatile.LoadUint32(&o.SYSCLK_CONF.Reg)&^(0x7f000)|value<<12)
}
func (o *SYSTEM_Type) GetSYSCLK_CONF_CLK_XTAL_FREQ() uint32 {
	return (volatile.LoadUint32(&o.SYSCLK_CONF.Reg) & 0x7f000) >> 12
}
func (o *SYSTEM_Type) SetSYSCLK_CONF_CLK_DIV_EN(value uint32) {
	volatile.StoreUint32(&o.SYSCLK_CONF.Reg, volatile.LoadUint32(&o.SYSCLK_CONF.Reg)&^(0x80000)|value<<19)
}
func (o *SYSTEM_Type) GetSYSCLK_CONF_CLK_DIV_EN() uint32 {
	return (volatile.LoadUint32(&o.SYSCLK_CONF.Reg) & 0x80000) >> 19
}

// SYSTEM.MEM_PVT: mem pvt register
func (o *SYSTEM_Type) SetMEM_PVT_MEM_PATH_LEN(value uint32) {
	volatile.StoreUint32(&o.MEM_PVT.Reg, volatile.LoadUint32(&o.MEM_PVT.Reg)&^(0xf)|value)
}
func (o *SYSTEM_Type) GetMEM_PVT_MEM_PATH_LEN() uint32 {
	return volatile.LoadUint32(&o.MEM_PVT.Reg) & 0xf
}
func (o *SYSTEM_Type) SetMEM_PVT_MEM_ERR_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.MEM_PVT.Reg, volatile.LoadUint32(&o.MEM_PVT.Reg)&^(0x10)|value<<4)
}
func (o *SYSTEM_Type) GetMEM_PVT_MEM_ERR_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.MEM_PVT.Reg) & 0x10) >> 4
}
func (o *SYSTEM_Type) SetMEM_PVT_MONITOR_EN(value uint32) {
	volatile.StoreUint32(&o.MEM_PVT.Reg, volatile.LoadUint32(&o.MEM_PVT.Reg)&^(0x20)|value<<5)
}
func (o *SYSTEM_Type) GetMEM_PVT_MONITOR_EN() uint32 {
	return (volatile.LoadUint32(&o.MEM_PVT.Reg) & 0x20) >> 5
}
func (o *SYSTEM_Type) SetMEM_PVT_MEM_TIMING_ERR_CNT(value uint32) {
	volatile.StoreUint32(&o.MEM_PVT.Reg, volatile.LoadUint32(&o.MEM_PVT.Reg)&^(0x3fffc0)|value<<6)
}
func (o *SYSTEM_Type) GetMEM_PVT_MEM_TIMING_ERR_CNT() uint32 {
	return (volatile.LoadUint32(&o.MEM_PVT.Reg) & 0x3fffc0) >> 6
}
func (o *SYSTEM_Type) SetMEM_PVT_MEM_VT_SEL(value uint32) {
	volatile.StoreUint32(&o.MEM_PVT.Reg, volatile.LoadUint32(&o.MEM_PVT.Reg)&^(0xc00000)|value<<22)
}
func (o *SYSTEM_Type) GetMEM_PVT_MEM_VT_SEL() uint32 {
	return (volatile.LoadUint32(&o.MEM_PVT.Reg) & 0xc00000) >> 22
}

// SYSTEM.COMB_PVT_LVT_CONF: mem pvt register
func (o *SYSTEM_Type) SetCOMB_PVT_LVT_CONF_COMB_PATH_LEN_LVT(value uint32) {
	volatile.StoreUint32(&o.COMB_PVT_LVT_CONF.Reg, volatile.LoadUint32(&o.COMB_PVT_LVT_CONF.Reg)&^(0x3f)|value)
}
func (o *SYSTEM_Type) GetCOMB_PVT_LVT_CONF_COMB_PATH_LEN_LVT() uint32 {
	return volatile.LoadUint32(&o.COMB_PVT_LVT_CONF.Reg) & 0x3f
}
func (o *SYSTEM_Type) SetCOMB_PVT_LVT_CONF_COMB_ERR_CNT_CLR_LVT(value uint32) {
	volatile.StoreUint32(&o.COMB_PVT_LVT_CONF.Reg, volatile.LoadUint32(&o.COMB_PVT_LVT_CONF.Reg)&^(0x40)|value<<6)
}
func (o *SYSTEM_Type) GetCOMB_PVT_LVT_CONF_COMB_ERR_CNT_CLR_LVT() uint32 {
	return (volatile.LoadUint32(&o.COMB_PVT_LVT_CONF.Reg) & 0x40) >> 6
}
func (o *SYSTEM_Type) SetCOMB_PVT_LVT_CONF_COMB_PVT_MONITOR_EN_LVT(value uint32) {
	volatile.StoreUint32(&o.COMB_PVT_LVT_CONF.Reg, volatile.LoadUint32(&o.COMB_PVT_LVT_CONF.Reg)&^(0x80)|value<<7)
}
func (o *SYSTEM_Type) GetCOMB_PVT_LVT_CONF_COMB_PVT_MONITOR_EN_LVT() uint32 {
	return (volatile.LoadUint32(&o.COMB_PVT_LVT_CONF.Reg) & 0x80) >> 7
}

// SYSTEM.COMB_PVT_NVT_CONF: mem pvt register
func (o *SYSTEM_Type) SetCOMB_PVT_NVT_CONF_COMB_PATH_LEN_NVT(value uint32) {
	volatile.StoreUint32(&o.COMB_PVT_NVT_CONF.Reg, volatile.LoadUint32(&o.COMB_PVT_NVT_CONF.Reg)&^(0x3f)|value)
}
func (o *SYSTEM_Type) GetCOMB_PVT_NVT_CONF_COMB_PATH_LEN_NVT() uint32 {
	return volatile.LoadUint32(&o.COMB_PVT_NVT_CONF.Reg) & 0x3f
}
func (o *SYSTEM_Type) SetCOMB_PVT_NVT_CONF_COMB_ERR_CNT_CLR_NVT(value uint32) {
	volatile.StoreUint32(&o.COMB_PVT_NVT_CONF.Reg, volatile.LoadUint32(&o.COMB_PVT_NVT_CONF.Reg)&^(0x40)|value<<6)
}
func (o *SYSTEM_Type) GetCOMB_PVT_NVT_CONF_COMB_ERR_CNT_CLR_NVT() uint32 {
	return (volatile.LoadUint32(&o.COMB_PVT_NVT_CONF.Reg) & 0x40) >> 6
}
func (o *SYSTEM_Type) SetCOMB_PVT_NVT_CONF_COMB_PVT_MONITOR_EN_NVT(value uint32) {
	volatile.StoreUint32(&o.COMB_PVT_NVT_CONF.Reg, volatile.LoadUint32(&o.COMB_PVT_NVT_CONF.Reg)&^(0x80)|value<<7)
}
func (o *SYSTEM_Type) GetCOMB_PVT_NVT_CONF_COMB_PVT_MONITOR_EN_NVT() uint32 {
	return (volatile.LoadUint32(&o.COMB_PVT_NVT_CONF.Reg) & 0x80) >> 7
}

// SYSTEM.COMB_PVT_HVT_CONF: mem pvt register
func (o *SYSTEM_Type) SetCOMB_PVT_HVT_CONF_COMB_PATH_LEN_HVT(value uint32) {
	volatile.StoreUint32(&o.COMB_PVT_HVT_CONF.Reg, volatile.LoadUint32(&o.COMB_PVT_HVT_CONF.Reg)&^(0x3f)|value)
}
func (o *SYSTEM_Type) GetCOMB_PVT_HVT_CONF_COMB_PATH_LEN_HVT() uint32 {
	return volatile.LoadUint32(&o.COMB_PVT_HVT_CONF.Reg) & 0x3f
}
func (o *SYSTEM_Type) SetCOMB_PVT_HVT_CONF_COMB_ERR_CNT_CLR_HVT(value uint32) {
	volatile.StoreUint32(&o.COMB_PVT_HVT_CONF.Reg, volatile.LoadUint32(&o.COMB_PVT_HVT_CONF.Reg)&^(0x40)|value<<6)
}
func (o *SYSTEM_Type) GetCOMB_PVT_HVT_CONF_COMB_ERR_CNT_CLR_HVT() uint32 {
	return (volatile.LoadUint32(&o.COMB_PVT_HVT_CONF.Reg) & 0x40) >> 6
}
func (o *SYSTEM_Type) SetCOMB_PVT_HVT_CONF_COMB_PVT_MONITOR_EN_HVT(value uint32) {
	volatile.StoreUint32(&o.COMB_PVT_HVT_CONF.Reg, volatile.LoadUint32(&o.COMB_PVT_HVT_CONF.Reg)&^(0x80)|value<<7)
}
func (o *SYSTEM_Type) GetCOMB_PVT_HVT_CONF_COMB_PVT_MONITOR_EN_HVT() uint32 {
	return (volatile.LoadUint32(&o.COMB_PVT_HVT_CONF.Reg) & 0x80) >> 7
}

// SYSTEM.COMB_PVT_ERR_LVT_SITE0: mem pvt register
func (o *SYSTEM_Type) SetCOMB_PVT_ERR_LVT_SITE0_COMB_TIMING_ERR_CNT_LVT_SITE0(value uint32) {
	volatile.StoreUint32(&o.COMB_PVT_ERR_LVT_SITE0.Reg, volatile.LoadUint32(&o.COMB_PVT_ERR_LVT_SITE0.Reg)&^(0xffff)|value)
}
func (o *SYSTEM_Type) GetCOMB_PVT_ERR_LVT_SITE0_COMB_TIMING_ERR_CNT_LVT_SITE0() uint32 {
	return volatile.LoadUint32(&o.COMB_PVT_ERR_LVT_SITE0.Reg) & 0xffff
}

// SYSTEM.COMB_PVT_ERR_NVT_SITE0: mem pvt register
func (o *SYSTEM_Type) SetCOMB_PVT_ERR_NVT_SITE0_COMB_TIMING_ERR_CNT_NVT_SITE0(value uint32) {
	volatile.StoreUint32(&o.COMB_PVT_ERR_NVT_SITE0.Reg, volatile.LoadUint32(&o.COMB_PVT_ERR_NVT_SITE0.Reg)&^(0xffff)|value)
}
func (o *SYSTEM_Type) GetCOMB_PVT_ERR_NVT_SITE0_COMB_TIMING_ERR_CNT_NVT_SITE0() uint32 {
	return volatile.LoadUint32(&o.COMB_PVT_ERR_NVT_SITE0.Reg) & 0xffff
}

// SYSTEM.COMB_PVT_ERR_HVT_SITE0: mem pvt register
func (o *SYSTEM_Type) SetCOMB_PVT_ERR_HVT_SITE0_COMB_TIMING_ERR_CNT_HVT_SITE0(value uint32) {
	volatile.StoreUint32(&o.COMB_PVT_ERR_HVT_SITE0.Reg, volatile.LoadUint32(&o.COMB_PVT_ERR_HVT_SITE0.Reg)&^(0xffff)|value)
}
func (o *SYSTEM_Type) GetCOMB_PVT_ERR_HVT_SITE0_COMB_TIMING_ERR_CNT_HVT_SITE0() uint32 {
	return volatile.LoadUint32(&o.COMB_PVT_ERR_HVT_SITE0.Reg) & 0xffff
}

// SYSTEM.COMB_PVT_ERR_LVT_SITE1: mem pvt register
func (o *SYSTEM_Type) SetCOMB_PVT_ERR_LVT_SITE1_COMB_TIMING_ERR_CNT_LVT_SITE1(value uint32) {
	volatile.StoreUint32(&o.COMB_PVT_ERR_LVT_SITE1.Reg, volatile.LoadUint32(&o.COMB_PVT_ERR_LVT_SITE1.Reg)&^(0xffff)|value)
}
func (o *SYSTEM_Type) GetCOMB_PVT_ERR_LVT_SITE1_COMB_TIMING_ERR_CNT_LVT_SITE1() uint32 {
	return volatile.LoadUint32(&o.COMB_PVT_ERR_LVT_SITE1.Reg) & 0xffff
}

// SYSTEM.COMB_PVT_ERR_NVT_SITE1: mem pvt register
func (o *SYSTEM_Type) SetCOMB_PVT_ERR_NVT_SITE1_COMB_TIMING_ERR_CNT_NVT_SITE1(value uint32) {
	volatile.StoreUint32(&o.COMB_PVT_ERR_NVT_SITE1.Reg, volatile.LoadUint32(&o.COMB_PVT_ERR_NVT_SITE1.Reg)&^(0xffff)|value)
}
func (o *SYSTEM_Type) GetCOMB_PVT_ERR_NVT_SITE1_COMB_TIMING_ERR_CNT_NVT_SITE1() uint32 {
	return volatile.LoadUint32(&o.COMB_PVT_ERR_NVT_SITE1.Reg) & 0xffff
}

// SYSTEM.COMB_PVT_ERR_HVT_SITE1: mem pvt register
func (o *SYSTEM_Type) SetCOMB_PVT_ERR_HVT_SITE1_COMB_TIMING_ERR_CNT_HVT_SITE1(value uint32) {
	volatile.StoreUint32(&o.COMB_PVT_ERR_HVT_SITE1.Reg, volatile.LoadUint32(&o.COMB_PVT_ERR_HVT_SITE1.Reg)&^(0xffff)|value)
}
func (o *SYSTEM_Type) GetCOMB_PVT_ERR_HVT_SITE1_COMB_TIMING_ERR_CNT_HVT_SITE1() uint32 {
	return volatile.LoadUint32(&o.COMB_PVT_ERR_HVT_SITE1.Reg) & 0xffff
}

// SYSTEM.COMB_PVT_ERR_LVT_SITE2: mem pvt register
func (o *SYSTEM_Type) SetCOMB_PVT_ERR_LVT_SITE2_COMB_TIMING_ERR_CNT_LVT_SITE2(value uint32) {
	volatile.StoreUint32(&o.COMB_PVT_ERR_LVT_SITE2.Reg, volatile.LoadUint32(&o.COMB_PVT_ERR_LVT_SITE2.Reg)&^(0xffff)|value)
}
func (o *SYSTEM_Type) GetCOMB_PVT_ERR_LVT_SITE2_COMB_TIMING_ERR_CNT_LVT_SITE2() uint32 {
	return volatile.LoadUint32(&o.COMB_PVT_ERR_LVT_SITE2.Reg) & 0xffff
}

// SYSTEM.COMB_PVT_ERR_NVT_SITE2: mem pvt register
func (o *SYSTEM_Type) SetCOMB_PVT_ERR_NVT_SITE2_COMB_TIMING_ERR_CNT_NVT_SITE2(value uint32) {
	volatile.StoreUint32(&o.COMB_PVT_ERR_NVT_SITE2.Reg, volatile.LoadUint32(&o.COMB_PVT_ERR_NVT_SITE2.Reg)&^(0xffff)|value)
}
func (o *SYSTEM_Type) GetCOMB_PVT_ERR_NVT_SITE2_COMB_TIMING_ERR_CNT_NVT_SITE2() uint32 {
	return volatile.LoadUint32(&o.COMB_PVT_ERR_NVT_SITE2.Reg) & 0xffff
}

// SYSTEM.COMB_PVT_ERR_HVT_SITE2: mem pvt register
func (o *SYSTEM_Type) SetCOMB_PVT_ERR_HVT_SITE2_COMB_TIMING_ERR_CNT_HVT_SITE2(value uint32) {
	volatile.StoreUint32(&o.COMB_PVT_ERR_HVT_SITE2.Reg, volatile.LoadUint32(&o.COMB_PVT_ERR_HVT_SITE2.Reg)&^(0xffff)|value)
}
func (o *SYSTEM_Type) GetCOMB_PVT_ERR_HVT_SITE2_COMB_TIMING_ERR_CNT_HVT_SITE2() uint32 {
	return volatile.LoadUint32(&o.COMB_PVT_ERR_HVT_SITE2.Reg) & 0xffff
}

// SYSTEM.COMB_PVT_ERR_LVT_SITE3: mem pvt register
func (o *SYSTEM_Type) SetCOMB_PVT_ERR_LVT_SITE3_COMB_TIMING_ERR_CNT_LVT_SITE3(value uint32) {
	volatile.StoreUint32(&o.COMB_PVT_ERR_LVT_SITE3.Reg, volatile.LoadUint32(&o.COMB_PVT_ERR_LVT_SITE3.Reg)&^(0xffff)|value)
}
func (o *SYSTEM_Type) GetCOMB_PVT_ERR_LVT_SITE3_COMB_TIMING_ERR_CNT_LVT_SITE3() uint32 {
	return volatile.LoadUint32(&o.COMB_PVT_ERR_LVT_SITE3.Reg) & 0xffff
}

// SYSTEM.COMB_PVT_ERR_NVT_SITE3: mem pvt register
func (o *SYSTEM_Type) SetCOMB_PVT_ERR_NVT_SITE3_COMB_TIMING_ERR_CNT_NVT_SITE3(value uint32) {
	volatile.StoreUint32(&o.COMB_PVT_ERR_NVT_SITE3.Reg, volatile.LoadUint32(&o.COMB_PVT_ERR_NVT_SITE3.Reg)&^(0xffff)|value)
}
func (o *SYSTEM_Type) GetCOMB_PVT_ERR_NVT_SITE3_COMB_TIMING_ERR_CNT_NVT_SITE3() uint32 {
	return volatile.LoadUint32(&o.COMB_PVT_ERR_NVT_SITE3.Reg) & 0xffff
}

// SYSTEM.COMB_PVT_ERR_HVT_SITE3: mem pvt register
func (o *SYSTEM_Type) SetCOMB_PVT_ERR_HVT_SITE3_COMB_TIMING_ERR_CNT_HVT_SITE3(value uint32) {
	volatile.StoreUint32(&o.COMB_PVT_ERR_HVT_SITE3.Reg, volatile.LoadUint32(&o.COMB_PVT_ERR_HVT_SITE3.Reg)&^(0xffff)|value)
}
func (o *SYSTEM_Type) GetCOMB_PVT_ERR_HVT_SITE3_COMB_TIMING_ERR_CNT_HVT_SITE3() uint32 {
	return volatile.LoadUint32(&o.COMB_PVT_ERR_HVT_SITE3.Reg) & 0xffff
}

// SYSTEM.REG_DATE: Version register
func (o *SYSTEM_Type) SetREG_DATE_SYSTEM_REG_DATE(value uint32) {
	volatile.StoreUint32(&o.REG_DATE.Reg, volatile.LoadUint32(&o.REG_DATE.Reg)&^(0xfffffff)|value)
}
func (o *SYSTEM_Type) GetREG_DATE_SYSTEM_REG_DATE() uint32 {
	return volatile.LoadUint32(&o.REG_DATE.Reg) & 0xfffffff
}

// System Timer
type SYSTIMER_Type struct {
	CONF           volatile.Register32 // 0x0
	UNIT0_OP       volatile.Register32 // 0x4
	UNIT1_OP       volatile.Register32 // 0x8
	UNIT0_LOAD_HI  volatile.Register32 // 0xC
	UNIT0_LOAD_LO  volatile.Register32 // 0x10
	UNIT1_LOAD_HI  volatile.Register32 // 0x14
	UNIT1_LOAD_LO  volatile.Register32 // 0x18
	TARGET0_HI     volatile.Register32 // 0x1C
	TARGET0_LO     volatile.Register32 // 0x20
	TARGET1_HI     volatile.Register32 // 0x24
	TARGET1_LO     volatile.Register32 // 0x28
	TARGET2_HI     volatile.Register32 // 0x2C
	TARGET2_LO     volatile.Register32 // 0x30
	TARGET0_CONF   volatile.Register32 // 0x34
	TARGET1_CONF   volatile.Register32 // 0x38
	TARGET2_CONF   volatile.Register32 // 0x3C
	UNIT0_VALUE_HI volatile.Register32 // 0x40
	UNIT0_VALUE_LO volatile.Register32 // 0x44
	UNIT1_VALUE_HI volatile.Register32 // 0x48
	UNIT1_VALUE_LO volatile.Register32 // 0x4C
	COMP0_LOAD     volatile.Register32 // 0x50
	COMP1_LOAD     volatile.Register32 // 0x54
	COMP2_LOAD     volatile.Register32 // 0x58
	UNIT0_LOAD     volatile.Register32 // 0x5C
	UNIT1_LOAD     volatile.Register32 // 0x60
	INT_ENA        volatile.Register32 // 0x64
	INT_RAW        volatile.Register32 // 0x68
	INT_CLR        volatile.Register32 // 0x6C
	INT_ST         volatile.Register32 // 0x70
	_              [136]byte
	DATE           volatile.Register32 // 0xFC
}

// SYSTIMER.CONF: Configure system timer clock
func (o *SYSTIMER_Type) SetCONF_SYSTIMER_CLK_FO(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x1)|value)
}
func (o *SYSTIMER_Type) GetCONF_SYSTIMER_CLK_FO() uint32 {
	return volatile.LoadUint32(&o.CONF.Reg) & 0x1
}
func (o *SYSTIMER_Type) SetCONF_TARGET2_WORK_EN(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x400000)|value<<22)
}
func (o *SYSTIMER_Type) GetCONF_TARGET2_WORK_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x400000) >> 22
}
func (o *SYSTIMER_Type) SetCONF_TARGET1_WORK_EN(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x800000)|value<<23)
}
func (o *SYSTIMER_Type) GetCONF_TARGET1_WORK_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x800000) >> 23
}
func (o *SYSTIMER_Type) SetCONF_TARGET0_WORK_EN(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSTIMER_Type) GetCONF_TARGET0_WORK_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x1000000) >> 24
}
func (o *SYSTIMER_Type) SetCONF_TIMER_UNIT1_CORE1_STALL_EN(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSTIMER_Type) GetCONF_TIMER_UNIT1_CORE1_STALL_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x2000000) >> 25
}
func (o *SYSTIMER_Type) SetCONF_TIMER_UNIT1_CORE0_STALL_EN(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSTIMER_Type) GetCONF_TIMER_UNIT1_CORE0_STALL_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x4000000) >> 26
}
func (o *SYSTIMER_Type) SetCONF_TIMER_UNIT0_CORE1_STALL_EN(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSTIMER_Type) GetCONF_TIMER_UNIT0_CORE1_STALL_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x8000000) >> 27
}
func (o *SYSTIMER_Type) SetCONF_TIMER_UNIT0_CORE0_STALL_EN(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSTIMER_Type) GetCONF_TIMER_UNIT0_CORE0_STALL_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x10000000) >> 28
}
func (o *SYSTIMER_Type) SetCONF_TIMER_UNIT1_WORK_EN(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSTIMER_Type) GetCONF_TIMER_UNIT1_WORK_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x20000000) >> 29
}
func (o *SYSTIMER_Type) SetCONF_TIMER_UNIT0_WORK_EN(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSTIMER_Type) GetCONF_TIMER_UNIT0_WORK_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x40000000) >> 30
}
func (o *SYSTIMER_Type) SetCONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSTIMER_Type) GetCONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x80000000) >> 31
}

// SYSTIMER.UNIT0_OP: system timer unit0 value update register
func (o *SYSTIMER_Type) SetUNIT0_OP_TIMER_UNIT0_VALUE_VALID(value uint32) {
	volatile.StoreUint32(&o.UNIT0_OP.Reg, volatile.LoadUint32(&o.UNIT0_OP.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSTIMER_Type) GetUNIT0_OP_TIMER_UNIT0_VALUE_VALID() uint32 {
	return (volatile.LoadUint32(&o.UNIT0_OP.Reg) & 0x20000000) >> 29
}
func (o *SYSTIMER_Type) SetUNIT0_OP_TIMER_UNIT0_UPDATE(value uint32) {
	volatile.StoreUint32(&o.UNIT0_OP.Reg, volatile.LoadUint32(&o.UNIT0_OP.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSTIMER_Type) GetUNIT0_OP_TIMER_UNIT0_UPDATE() uint32 {
	return (volatile.LoadUint32(&o.UNIT0_OP.Reg) & 0x40000000) >> 30
}

// SYSTIMER.UNIT1_OP: system timer unit1 value update register
func (o *SYSTIMER_Type) SetUNIT1_OP_TIMER_UNIT1_VALUE_VALID(value uint32) {
	volatile.StoreUint32(&o.UNIT1_OP.Reg, volatile.LoadUint32(&o.UNIT1_OP.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSTIMER_Type) GetUNIT1_OP_TIMER_UNIT1_VALUE_VALID() uint32 {
	return (volatile.LoadUint32(&o.UNIT1_OP.Reg) & 0x20000000) >> 29
}
func (o *SYSTIMER_Type) SetUNIT1_OP_TIMER_UNIT1_UPDATE(value uint32) {
	volatile.StoreUint32(&o.UNIT1_OP.Reg, volatile.LoadUint32(&o.UNIT1_OP.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSTIMER_Type) GetUNIT1_OP_TIMER_UNIT1_UPDATE() uint32 {
	return (volatile.LoadUint32(&o.UNIT1_OP.Reg) & 0x40000000) >> 30
}

// SYSTIMER.UNIT0_LOAD_HI: system timer unit0 value high load register
func (o *SYSTIMER_Type) SetUNIT0_LOAD_HI_TIMER_UNIT0_LOAD_HI(value uint32) {
	volatile.StoreUint32(&o.UNIT0_LOAD_HI.Reg, volatile.LoadUint32(&o.UNIT0_LOAD_HI.Reg)&^(0xfffff)|value)
}
func (o *SYSTIMER_Type) GetUNIT0_LOAD_HI_TIMER_UNIT0_LOAD_HI() uint32 {
	return volatile.LoadUint32(&o.UNIT0_LOAD_HI.Reg) & 0xfffff
}

// SYSTIMER.UNIT0_LOAD_LO: system timer unit0 value low load register
func (o *SYSTIMER_Type) SetUNIT0_LOAD_LO(value uint32) {
	volatile.StoreUint32(&o.UNIT0_LOAD_LO.Reg, value)
}
func (o *SYSTIMER_Type) GetUNIT0_LOAD_LO() uint32 {
	return volatile.LoadUint32(&o.UNIT0_LOAD_LO.Reg)
}

// SYSTIMER.UNIT1_LOAD_HI: system timer unit1 value high load register
func (o *SYSTIMER_Type) SetUNIT1_LOAD_HI_TIMER_UNIT1_LOAD_HI(value uint32) {
	volatile.StoreUint32(&o.UNIT1_LOAD_HI.Reg, volatile.LoadUint32(&o.UNIT1_LOAD_HI.Reg)&^(0xfffff)|value)
}
func (o *SYSTIMER_Type) GetUNIT1_LOAD_HI_TIMER_UNIT1_LOAD_HI() uint32 {
	return volatile.LoadUint32(&o.UNIT1_LOAD_HI.Reg) & 0xfffff
}

// SYSTIMER.UNIT1_LOAD_LO: system timer unit1 value low load register
func (o *SYSTIMER_Type) SetUNIT1_LOAD_LO(value uint32) {
	volatile.StoreUint32(&o.UNIT1_LOAD_LO.Reg, value)
}
func (o *SYSTIMER_Type) GetUNIT1_LOAD_LO() uint32 {
	return volatile.LoadUint32(&o.UNIT1_LOAD_LO.Reg)
}

// SYSTIMER.TARGET0_HI: system timer comp0 value high register
func (o *SYSTIMER_Type) SetTARGET0_HI_TIMER_TARGET0_HI(value uint32) {
	volatile.StoreUint32(&o.TARGET0_HI.Reg, volatile.LoadUint32(&o.TARGET0_HI.Reg)&^(0xfffff)|value)
}
func (o *SYSTIMER_Type) GetTARGET0_HI_TIMER_TARGET0_HI() uint32 {
	return volatile.LoadUint32(&o.TARGET0_HI.Reg) & 0xfffff
}

// SYSTIMER.TARGET0_LO: system timer comp0 value low register
func (o *SYSTIMER_Type) SetTARGET0_LO(value uint32) {
	volatile.StoreUint32(&o.TARGET0_LO.Reg, value)
}
func (o *SYSTIMER_Type) GetTARGET0_LO() uint32 {
	return volatile.LoadUint32(&o.TARGET0_LO.Reg)
}

// SYSTIMER.TARGET1_HI: system timer comp1 value high register
func (o *SYSTIMER_Type) SetTARGET1_HI_TIMER_TARGET1_HI(value uint32) {
	volatile.StoreUint32(&o.TARGET1_HI.Reg, volatile.LoadUint32(&o.TARGET1_HI.Reg)&^(0xfffff)|value)
}
func (o *SYSTIMER_Type) GetTARGET1_HI_TIMER_TARGET1_HI() uint32 {
	return volatile.LoadUint32(&o.TARGET1_HI.Reg) & 0xfffff
}

// SYSTIMER.TARGET1_LO: system timer comp1 value low register
func (o *SYSTIMER_Type) SetTARGET1_LO(value uint32) {
	volatile.StoreUint32(&o.TARGET1_LO.Reg, value)
}
func (o *SYSTIMER_Type) GetTARGET1_LO() uint32 {
	return volatile.LoadUint32(&o.TARGET1_LO.Reg)
}

// SYSTIMER.TARGET2_HI: system timer comp2 value high register
func (o *SYSTIMER_Type) SetTARGET2_HI_TIMER_TARGET2_HI(value uint32) {
	volatile.StoreUint32(&o.TARGET2_HI.Reg, volatile.LoadUint32(&o.TARGET2_HI.Reg)&^(0xfffff)|value)
}
func (o *SYSTIMER_Type) GetTARGET2_HI_TIMER_TARGET2_HI() uint32 {
	return volatile.LoadUint32(&o.TARGET2_HI.Reg) & 0xfffff
}

// SYSTIMER.TARGET2_LO: system timer comp2 value low register
func (o *SYSTIMER_Type) SetTARGET2_LO(value uint32) {
	volatile.StoreUint32(&o.TARGET2_LO.Reg, value)
}
func (o *SYSTIMER_Type) GetTARGET2_LO() uint32 {
	return volatile.LoadUint32(&o.TARGET2_LO.Reg)
}

// SYSTIMER.TARGET0_CONF: system timer comp0 target mode register
func (o *SYSTIMER_Type) SetTARGET0_CONF_TARGET0_PERIOD(value uint32) {
	volatile.StoreUint32(&o.TARGET0_CONF.Reg, volatile.LoadUint32(&o.TARGET0_CONF.Reg)&^(0x3ffffff)|value)
}
func (o *SYSTIMER_Type) GetTARGET0_CONF_TARGET0_PERIOD() uint32 {
	return volatile.LoadUint32(&o.TARGET0_CONF.Reg) & 0x3ffffff
}
func (o *SYSTIMER_Type) SetTARGET0_CONF_TARGET0_PERIOD_MODE(value uint32) {
	volatile.StoreUint32(&o.TARGET0_CONF.Reg, volatile.LoadUint32(&o.TARGET0_CONF.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSTIMER_Type) GetTARGET0_CONF_TARGET0_PERIOD_MODE() uint32 {
	return (volatile.LoadUint32(&o.TARGET0_CONF.Reg) & 0x40000000) >> 30
}
func (o *SYSTIMER_Type) SetTARGET0_CONF_TARGET0_TIMER_UNIT_SEL(value uint32) {
	volatile.StoreUint32(&o.TARGET0_CONF.Reg, volatile.LoadUint32(&o.TARGET0_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSTIMER_Type) GetTARGET0_CONF_TARGET0_TIMER_UNIT_SEL() uint32 {
	return (volatile.LoadUint32(&o.TARGET0_CONF.Reg) & 0x80000000) >> 31
}

// SYSTIMER.TARGET1_CONF: system timer comp1 target mode register
func (o *SYSTIMER_Type) SetTARGET1_CONF_TARGET1_PERIOD(value uint32) {
	volatile.StoreUint32(&o.TARGET1_CONF.Reg, volatile.LoadUint32(&o.TARGET1_CONF.Reg)&^(0x3ffffff)|value)
}
func (o *SYSTIMER_Type) GetTARGET1_CONF_TARGET1_PERIOD() uint32 {
	return volatile.LoadUint32(&o.TARGET1_CONF.Reg) & 0x3ffffff
}
func (o *SYSTIMER_Type) SetTARGET1_CONF_TARGET1_PERIOD_MODE(value uint32) {
	volatile.StoreUint32(&o.TARGET1_CONF.Reg, volatile.LoadUint32(&o.TARGET1_CONF.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSTIMER_Type) GetTARGET1_CONF_TARGET1_PERIOD_MODE() uint32 {
	return (volatile.LoadUint32(&o.TARGET1_CONF.Reg) & 0x40000000) >> 30
}
func (o *SYSTIMER_Type) SetTARGET1_CONF_TARGET1_TIMER_UNIT_SEL(value uint32) {
	volatile.StoreUint32(&o.TARGET1_CONF.Reg, volatile.LoadUint32(&o.TARGET1_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSTIMER_Type) GetTARGET1_CONF_TARGET1_TIMER_UNIT_SEL() uint32 {
	return (volatile.LoadUint32(&o.TARGET1_CONF.Reg) & 0x80000000) >> 31
}

// SYSTIMER.TARGET2_CONF: system timer comp2 target mode register
func (o *SYSTIMER_Type) SetTARGET2_CONF_TARGET2_PERIOD(value uint32) {
	volatile.StoreUint32(&o.TARGET2_CONF.Reg, volatile.LoadUint32(&o.TARGET2_CONF.Reg)&^(0x3ffffff)|value)
}
func (o *SYSTIMER_Type) GetTARGET2_CONF_TARGET2_PERIOD() uint32 {
	return volatile.LoadUint32(&o.TARGET2_CONF.Reg) & 0x3ffffff
}
func (o *SYSTIMER_Type) SetTARGET2_CONF_TARGET2_PERIOD_MODE(value uint32) {
	volatile.StoreUint32(&o.TARGET2_CONF.Reg, volatile.LoadUint32(&o.TARGET2_CONF.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSTIMER_Type) GetTARGET2_CONF_TARGET2_PERIOD_MODE() uint32 {
	return (volatile.LoadUint32(&o.TARGET2_CONF.Reg) & 0x40000000) >> 30
}
func (o *SYSTIMER_Type) SetTARGET2_CONF_TARGET2_TIMER_UNIT_SEL(value uint32) {
	volatile.StoreUint32(&o.TARGET2_CONF.Reg, volatile.LoadUint32(&o.TARGET2_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSTIMER_Type) GetTARGET2_CONF_TARGET2_TIMER_UNIT_SEL() uint32 {
	return (volatile.LoadUint32(&o.TARGET2_CONF.Reg) & 0x80000000) >> 31
}

// SYSTIMER.UNIT0_VALUE_HI: system timer unit0 value high register
func (o *SYSTIMER_Type) SetUNIT0_VALUE_HI_TIMER_UNIT0_VALUE_HI(value uint32) {
	volatile.StoreUint32(&o.UNIT0_VALUE_HI.Reg, volatile.LoadUint32(&o.UNIT0_VALUE_HI.Reg)&^(0xfffff)|value)
}
func (o *SYSTIMER_Type) GetUNIT0_VALUE_HI_TIMER_UNIT0_VALUE_HI() uint32 {
	return volatile.LoadUint32(&o.UNIT0_VALUE_HI.Reg) & 0xfffff
}

// SYSTIMER.UNIT0_VALUE_LO: system timer unit0 value low register
func (o *SYSTIMER_Type) SetUNIT0_VALUE_LO(value uint32) {
	volatile.StoreUint32(&o.UNIT0_VALUE_LO.Reg, value)
}
func (o *SYSTIMER_Type) GetUNIT0_VALUE_LO() uint32 {
	return volatile.LoadUint32(&o.UNIT0_VALUE_LO.Reg)
}

// SYSTIMER.UNIT1_VALUE_HI: system timer unit1 value high register
func (o *SYSTIMER_Type) SetUNIT1_VALUE_HI_TIMER_UNIT1_VALUE_HI(value uint32) {
	volatile.StoreUint32(&o.UNIT1_VALUE_HI.Reg, volatile.LoadUint32(&o.UNIT1_VALUE_HI.Reg)&^(0xfffff)|value)
}
func (o *SYSTIMER_Type) GetUNIT1_VALUE_HI_TIMER_UNIT1_VALUE_HI() uint32 {
	return volatile.LoadUint32(&o.UNIT1_VALUE_HI.Reg) & 0xfffff
}

// SYSTIMER.UNIT1_VALUE_LO: system timer unit1 value low register
func (o *SYSTIMER_Type) SetUNIT1_VALUE_LO(value uint32) {
	volatile.StoreUint32(&o.UNIT1_VALUE_LO.Reg, value)
}
func (o *SYSTIMER_Type) GetUNIT1_VALUE_LO() uint32 {
	return volatile.LoadUint32(&o.UNIT1_VALUE_LO.Reg)
}

// SYSTIMER.COMP0_LOAD: system timer comp0 conf sync register
func (o *SYSTIMER_Type) SetCOMP0_LOAD_TIMER_COMP0_LOAD(value uint32) {
	volatile.StoreUint32(&o.COMP0_LOAD.Reg, volatile.LoadUint32(&o.COMP0_LOAD.Reg)&^(0x1)|value)
}
func (o *SYSTIMER_Type) GetCOMP0_LOAD_TIMER_COMP0_LOAD() uint32 {
	return volatile.LoadUint32(&o.COMP0_LOAD.Reg) & 0x1
}

// SYSTIMER.COMP1_LOAD: system timer comp1 conf sync register
func (o *SYSTIMER_Type) SetCOMP1_LOAD_TIMER_COMP1_LOAD(value uint32) {
	volatile.StoreUint32(&o.COMP1_LOAD.Reg, volatile.LoadUint32(&o.COMP1_LOAD.Reg)&^(0x1)|value)
}
func (o *SYSTIMER_Type) GetCOMP1_LOAD_TIMER_COMP1_LOAD() uint32 {
	return volatile.LoadUint32(&o.COMP1_LOAD.Reg) & 0x1
}

// SYSTIMER.COMP2_LOAD: system timer comp2 conf sync register
func (o *SYSTIMER_Type) SetCOMP2_LOAD_TIMER_COMP2_LOAD(value uint32) {
	volatile.StoreUint32(&o.COMP2_LOAD.Reg, volatile.LoadUint32(&o.COMP2_LOAD.Reg)&^(0x1)|value)
}
func (o *SYSTIMER_Type) GetCOMP2_LOAD_TIMER_COMP2_LOAD() uint32 {
	return volatile.LoadUint32(&o.COMP2_LOAD.Reg) & 0x1
}

// SYSTIMER.UNIT0_LOAD: system timer unit0 conf sync register
func (o *SYSTIMER_Type) SetUNIT0_LOAD_TIMER_UNIT0_LOAD(value uint32) {
	volatile.StoreUint32(&o.UNIT0_LOAD.Reg, volatile.LoadUint32(&o.UNIT0_LOAD.Reg)&^(0x1)|value)
}
func (o *SYSTIMER_Type) GetUNIT0_LOAD_TIMER_UNIT0_LOAD() uint32 {
	return volatile.LoadUint32(&o.UNIT0_LOAD.Reg) & 0x1
}

// SYSTIMER.UNIT1_LOAD: system timer unit1 conf sync register
func (o *SYSTIMER_Type) SetUNIT1_LOAD_TIMER_UNIT1_LOAD(value uint32) {
	volatile.StoreUint32(&o.UNIT1_LOAD.Reg, volatile.LoadUint32(&o.UNIT1_LOAD.Reg)&^(0x1)|value)
}
func (o *SYSTIMER_Type) GetUNIT1_LOAD_TIMER_UNIT1_LOAD() uint32 {
	return volatile.LoadUint32(&o.UNIT1_LOAD.Reg) & 0x1
}

// SYSTIMER.INT_ENA: systimer interrupt enable register
func (o *SYSTIMER_Type) SetINT_ENA_TARGET0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *SYSTIMER_Type) GetINT_ENA_TARGET0_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *SYSTIMER_Type) SetINT_ENA_TARGET1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *SYSTIMER_Type) GetINT_ENA_TARGET1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}
func (o *SYSTIMER_Type) SetINT_ENA_TARGET2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *SYSTIMER_Type) GetINT_ENA_TARGET2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4) >> 2
}

// SYSTIMER.INT_RAW: systimer interrupt raw register
func (o *SYSTIMER_Type) SetINT_RAW_TARGET0_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *SYSTIMER_Type) GetINT_RAW_TARGET0_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *SYSTIMER_Type) SetINT_RAW_TARGET1_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *SYSTIMER_Type) GetINT_RAW_TARGET1_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}
func (o *SYSTIMER_Type) SetINT_RAW_TARGET2_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *SYSTIMER_Type) GetINT_RAW_TARGET2_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4) >> 2
}

// SYSTIMER.INT_CLR: systimer interrupt clear register
func (o *SYSTIMER_Type) SetINT_CLR_TARGET0_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *SYSTIMER_Type) GetINT_CLR_TARGET0_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *SYSTIMER_Type) SetINT_CLR_TARGET1_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *SYSTIMER_Type) GetINT_CLR_TARGET1_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}
func (o *SYSTIMER_Type) SetINT_CLR_TARGET2_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *SYSTIMER_Type) GetINT_CLR_TARGET2_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4) >> 2
}

// SYSTIMER.INT_ST: systimer interrupt status register
func (o *SYSTIMER_Type) SetINT_ST_TARGET0_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1)|value)
}
func (o *SYSTIMER_Type) GetINT_ST_TARGET0_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST.Reg) & 0x1
}
func (o *SYSTIMER_Type) SetINT_ST_TARGET1_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *SYSTIMER_Type) GetINT_ST_TARGET1_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2) >> 1
}
func (o *SYSTIMER_Type) SetINT_ST_TARGET2_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *SYSTIMER_Type) GetINT_ST_TARGET2_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4) >> 2
}

// SYSTIMER.DATE: system timer version control register
func (o *SYSTIMER_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *SYSTIMER_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// Timer Group 0
type TIMG_Type struct {
	T0CONFIG       volatile.Register32 // 0x0
	T0LO           volatile.Register32 // 0x4
	T0HI           volatile.Register32 // 0x8
	T0UPDATE       volatile.Register32 // 0xC
	T0ALARMLO      volatile.Register32 // 0x10
	T0ALARMHI      volatile.Register32 // 0x14
	T0LOADLO       volatile.Register32 // 0x18
	T0LOADHI       volatile.Register32 // 0x1C
	T0LOAD         volatile.Register32 // 0x20
	_              [36]byte
	WDTCONFIG0     volatile.Register32 // 0x48
	WDTCONFIG1     volatile.Register32 // 0x4C
	WDTCONFIG2     volatile.Register32 // 0x50
	WDTCONFIG3     volatile.Register32 // 0x54
	WDTCONFIG4     volatile.Register32 // 0x58
	WDTCONFIG5     volatile.Register32 // 0x5C
	WDTFEED        volatile.Register32 // 0x60
	WDTWPROTECT    volatile.Register32 // 0x64
	RTCCALICFG     volatile.Register32 // 0x68
	RTCCALICFG1    volatile.Register32 // 0x6C
	INT_ENA_TIMERS volatile.Register32 // 0x70
	INT_RAW_TIMERS volatile.Register32 // 0x74
	INT_ST_TIMERS  volatile.Register32 // 0x78
	INT_CLR_TIMERS volatile.Register32 // 0x7C
	RTCCALICFG2    volatile.Register32 // 0x80
	_              [116]byte
	NTIMERS_DATE   volatile.Register32 // 0xF8
	REGCLK         volatile.Register32 // 0xFC
}

// TIMG.T0CONFIG: Timer %s configuration register
func (o *TIMG_Type) SetT0CONFIG_USE_XTAL(value uint32) {
	volatile.StoreUint32(&o.T0CONFIG.Reg, volatile.LoadUint32(&o.T0CONFIG.Reg)&^(0x200)|value<<9)
}
func (o *TIMG_Type) GetT0CONFIG_USE_XTAL() uint32 {
	return (volatile.LoadUint32(&o.T0CONFIG.Reg) & 0x200) >> 9
}
func (o *TIMG_Type) SetT0CONFIG_ALARM_EN(value uint32) {
	volatile.StoreUint32(&o.T0CONFIG.Reg, volatile.LoadUint32(&o.T0CONFIG.Reg)&^(0x400)|value<<10)
}
func (o *TIMG_Type) GetT0CONFIG_ALARM_EN() uint32 {
	return (volatile.LoadUint32(&o.T0CONFIG.Reg) & 0x400) >> 10
}
func (o *TIMG_Type) SetT0CONFIG_DIVCNT_RST(value uint32) {
	volatile.StoreUint32(&o.T0CONFIG.Reg, volatile.LoadUint32(&o.T0CONFIG.Reg)&^(0x1000)|value<<12)
}
func (o *TIMG_Type) GetT0CONFIG_DIVCNT_RST() uint32 {
	return (volatile.LoadUint32(&o.T0CONFIG.Reg) & 0x1000) >> 12
}
func (o *TIMG_Type) SetT0CONFIG_DIVIDER(value uint32) {
	volatile.StoreUint32(&o.T0CONFIG.Reg, volatile.LoadUint32(&o.T0CONFIG.Reg)&^(0x1fffe000)|value<<13)
}
func (o *TIMG_Type) GetT0CONFIG_DIVIDER() uint32 {
	return (volatile.LoadUint32(&o.T0CONFIG.Reg) & 0x1fffe000) >> 13
}
func (o *TIMG_Type) SetT0CONFIG_AUTORELOAD(value uint32) {
	volatile.StoreUint32(&o.T0CONFIG.Reg, volatile.LoadUint32(&o.T0CONFIG.Reg)&^(0x20000000)|value<<29)
}
func (o *TIMG_Type) GetT0CONFIG_AUTORELOAD() uint32 {
	return (volatile.LoadUint32(&o.T0CONFIG.Reg) & 0x20000000) >> 29
}
func (o *TIMG_Type) SetT0CONFIG_INCREASE(value uint32) {
	volatile.StoreUint32(&o.T0CONFIG.Reg, volatile.LoadUint32(&o.T0CONFIG.Reg)&^(0x40000000)|value<<30)
}
func (o *TIMG_Type) GetT0CONFIG_INCREASE() uint32 {
	return (volatile.LoadUint32(&o.T0CONFIG.Reg) & 0x40000000) >> 30
}
func (o *TIMG_Type) SetT0CONFIG_EN(value uint32) {
	volatile.StoreUint32(&o.T0CONFIG.Reg, volatile.LoadUint32(&o.T0CONFIG.Reg)&^(0x80000000)|value<<31)
}
func (o *TIMG_Type) GetT0CONFIG_EN() uint32 {
	return (volatile.LoadUint32(&o.T0CONFIG.Reg) & 0x80000000) >> 31
}

// TIMG.T0LO: Timer %s current value, low 32 bits
func (o *TIMG_Type) SetT0LO(value uint32) {
	volatile.StoreUint32(&o.T0LO.Reg, value)
}
func (o *TIMG_Type) GetT0LO() uint32 {
	return volatile.LoadUint32(&o.T0LO.Reg)
}

// TIMG.T0HI: Timer %s current value, high 22 bits
func (o *TIMG_Type) SetT0HI_T0_HI(value uint32) {
	volatile.StoreUint32(&o.T0HI.Reg, volatile.LoadUint32(&o.T0HI.Reg)&^(0x3fffff)|value)
}
func (o *TIMG_Type) GetT0HI_T0_HI() uint32 {
	return volatile.LoadUint32(&o.T0HI.Reg) & 0x3fffff
}

// TIMG.T0UPDATE: Write to copy current timer value to TIMGn_T%s_(LO/HI)_REG
func (o *TIMG_Type) SetT0UPDATE_T0_UPDATE(value uint32) {
	volatile.StoreUint32(&o.T0UPDATE.Reg, volatile.LoadUint32(&o.T0UPDATE.Reg)&^(0x80000000)|value<<31)
}
func (o *TIMG_Type) GetT0UPDATE_T0_UPDATE() uint32 {
	return (volatile.LoadUint32(&o.T0UPDATE.Reg) & 0x80000000) >> 31
}

// TIMG.T0ALARMLO: Timer %s alarm value, low 32 bits
func (o *TIMG_Type) SetT0ALARMLO(value uint32) {
	volatile.StoreUint32(&o.T0ALARMLO.Reg, value)
}
func (o *TIMG_Type) GetT0ALARMLO() uint32 {
	return volatile.LoadUint32(&o.T0ALARMLO.Reg)
}

// TIMG.T0ALARMHI: Timer %s alarm value, high bits
func (o *TIMG_Type) SetT0ALARMHI_ALARM_HI(value uint32) {
	volatile.StoreUint32(&o.T0ALARMHI.Reg, volatile.LoadUint32(&o.T0ALARMHI.Reg)&^(0x3fffff)|value)
}
func (o *TIMG_Type) GetT0ALARMHI_ALARM_HI() uint32 {
	return volatile.LoadUint32(&o.T0ALARMHI.Reg) & 0x3fffff
}

// TIMG.T0LOADLO: Timer %s reload value, low 32 bits
func (o *TIMG_Type) SetT0LOADLO(value uint32) {
	volatile.StoreUint32(&o.T0LOADLO.Reg, value)
}
func (o *TIMG_Type) GetT0LOADLO() uint32 {
	return volatile.LoadUint32(&o.T0LOADLO.Reg)
}

// TIMG.T0LOADHI: Timer %s reload value, high 22 bits
func (o *TIMG_Type) SetT0LOADHI_LOAD_HI(value uint32) {
	volatile.StoreUint32(&o.T0LOADHI.Reg, volatile.LoadUint32(&o.T0LOADHI.Reg)&^(0x3fffff)|value)
}
func (o *TIMG_Type) GetT0LOADHI_LOAD_HI() uint32 {
	return volatile.LoadUint32(&o.T0LOADHI.Reg) & 0x3fffff
}

// TIMG.T0LOAD: Write to reload timer from TIMG_T%s_(LOADLOLOADHI)_REG
func (o *TIMG_Type) SetT0LOAD(value uint32) {
	volatile.StoreUint32(&o.T0LOAD.Reg, value)
}
func (o *TIMG_Type) GetT0LOAD() uint32 {
	return volatile.LoadUint32(&o.T0LOAD.Reg)
}

// TIMG.WDTCONFIG0: Watchdog timer configuration register
func (o *TIMG_Type) SetWDTCONFIG0_WDT_APPCPU_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0x1000)|value<<12)
}
func (o *TIMG_Type) GetWDTCONFIG0_WDT_APPCPU_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0x1000) >> 12
}
func (o *TIMG_Type) SetWDTCONFIG0_WDT_PROCPU_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0x2000)|value<<13)
}
func (o *TIMG_Type) GetWDTCONFIG0_WDT_PROCPU_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0x2000) >> 13
}
func (o *TIMG_Type) SetWDTCONFIG0_WDT_FLASHBOOT_MOD_EN(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0x4000)|value<<14)
}
func (o *TIMG_Type) GetWDTCONFIG0_WDT_FLASHBOOT_MOD_EN() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0x4000) >> 14
}
func (o *TIMG_Type) SetWDTCONFIG0_WDT_SYS_RESET_LENGTH(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0x38000)|value<<15)
}
func (o *TIMG_Type) GetWDTCONFIG0_WDT_SYS_RESET_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0x38000) >> 15
}
func (o *TIMG_Type) SetWDTCONFIG0_WDT_CPU_RESET_LENGTH(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0x1c0000)|value<<18)
}
func (o *TIMG_Type) GetWDTCONFIG0_WDT_CPU_RESET_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0x1c0000) >> 18
}
func (o *TIMG_Type) SetWDTCONFIG0_WDT_USE_XTAL(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0x200000)|value<<21)
}
func (o *TIMG_Type) GetWDTCONFIG0_WDT_USE_XTAL() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0x200000) >> 21
}
func (o *TIMG_Type) SetWDTCONFIG0_WDT_CONF_UPDATE_EN(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0x400000)|value<<22)
}
func (o *TIMG_Type) GetWDTCONFIG0_WDT_CONF_UPDATE_EN() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0x400000) >> 22
}
func (o *TIMG_Type) SetWDTCONFIG0_WDT_STG3(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0x1800000)|value<<23)
}
func (o *TIMG_Type) GetWDTCONFIG0_WDT_STG3() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0x1800000) >> 23
}
func (o *TIMG_Type) SetWDTCONFIG0_WDT_STG2(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0x6000000)|value<<25)
}
func (o *TIMG_Type) GetWDTCONFIG0_WDT_STG2() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0x6000000) >> 25
}
func (o *TIMG_Type) SetWDTCONFIG0_WDT_STG1(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0x18000000)|value<<27)
}
func (o *TIMG_Type) GetWDTCONFIG0_WDT_STG1() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0x18000000) >> 27
}
func (o *TIMG_Type) SetWDTCONFIG0_WDT_STG0(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0x60000000)|value<<29)
}
func (o *TIMG_Type) GetWDTCONFIG0_WDT_STG0() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0x60000000) >> 29
}
func (o *TIMG_Type) SetWDTCONFIG0_WDT_EN(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG0.Reg, volatile.LoadUint32(&o.WDTCONFIG0.Reg)&^(0x80000000)|value<<31)
}
func (o *TIMG_Type) GetWDTCONFIG0_WDT_EN() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG0.Reg) & 0x80000000) >> 31
}

// TIMG.WDTCONFIG1: Watchdog timer prescaler register
func (o *TIMG_Type) SetWDTCONFIG1_WDT_DIVCNT_RST(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG1.Reg, volatile.LoadUint32(&o.WDTCONFIG1.Reg)&^(0x1)|value)
}
func (o *TIMG_Type) GetWDTCONFIG1_WDT_DIVCNT_RST() uint32 {
	return volatile.LoadUint32(&o.WDTCONFIG1.Reg) & 0x1
}
func (o *TIMG_Type) SetWDTCONFIG1_WDT_CLK_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG1.Reg, volatile.LoadUint32(&o.WDTCONFIG1.Reg)&^(0xffff0000)|value<<16)
}
func (o *TIMG_Type) GetWDTCONFIG1_WDT_CLK_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.WDTCONFIG1.Reg) & 0xffff0000) >> 16
}

// TIMG.WDTCONFIG2: Watchdog timer stage 0 timeout value
func (o *TIMG_Type) SetWDTCONFIG2(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG2.Reg, value)
}
func (o *TIMG_Type) GetWDTCONFIG2() uint32 {
	return volatile.LoadUint32(&o.WDTCONFIG2.Reg)
}

// TIMG.WDTCONFIG3: Watchdog timer stage 1 timeout value
func (o *TIMG_Type) SetWDTCONFIG3(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG3.Reg, value)
}
func (o *TIMG_Type) GetWDTCONFIG3() uint32 {
	return volatile.LoadUint32(&o.WDTCONFIG3.Reg)
}

// TIMG.WDTCONFIG4: Watchdog timer stage 2 timeout value
func (o *TIMG_Type) SetWDTCONFIG4(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG4.Reg, value)
}
func (o *TIMG_Type) GetWDTCONFIG4() uint32 {
	return volatile.LoadUint32(&o.WDTCONFIG4.Reg)
}

// TIMG.WDTCONFIG5: Watchdog timer stage 3 timeout value
func (o *TIMG_Type) SetWDTCONFIG5(value uint32) {
	volatile.StoreUint32(&o.WDTCONFIG5.Reg, value)
}
func (o *TIMG_Type) GetWDTCONFIG5() uint32 {
	return volatile.LoadUint32(&o.WDTCONFIG5.Reg)
}

// TIMG.WDTFEED: Write to feed the watchdog timer
func (o *TIMG_Type) SetWDTFEED(value uint32) {
	volatile.StoreUint32(&o.WDTFEED.Reg, value)
}
func (o *TIMG_Type) GetWDTFEED() uint32 {
	return volatile.LoadUint32(&o.WDTFEED.Reg)
}

// TIMG.WDTWPROTECT: Watchdog write protect register
func (o *TIMG_Type) SetWDTWPROTECT(value uint32) {
	volatile.StoreUint32(&o.WDTWPROTECT.Reg, value)
}
func (o *TIMG_Type) GetWDTWPROTECT() uint32 {
	return volatile.LoadUint32(&o.WDTWPROTECT.Reg)
}

// TIMG.RTCCALICFG: RTC calibration configure register
func (o *TIMG_Type) SetRTCCALICFG_RTC_CALI_START_CYCLING(value uint32) {
	volatile.StoreUint32(&o.RTCCALICFG.Reg, volatile.LoadUint32(&o.RTCCALICFG.Reg)&^(0x1000)|value<<12)
}
func (o *TIMG_Type) GetRTCCALICFG_RTC_CALI_START_CYCLING() uint32 {
	return (volatile.LoadUint32(&o.RTCCALICFG.Reg) & 0x1000) >> 12
}
func (o *TIMG_Type) SetRTCCALICFG_RTC_CALI_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.RTCCALICFG.Reg, volatile.LoadUint32(&o.RTCCALICFG.Reg)&^(0x6000)|value<<13)
}
func (o *TIMG_Type) GetRTCCALICFG_RTC_CALI_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.RTCCALICFG.Reg) & 0x6000) >> 13
}
func (o *TIMG_Type) SetRTCCALICFG_RTC_CALI_RDY(value uint32) {
	volatile.StoreUint32(&o.RTCCALICFG.Reg, volatile.LoadUint32(&o.RTCCALICFG.Reg)&^(0x8000)|value<<15)
}
func (o *TIMG_Type) GetRTCCALICFG_RTC_CALI_RDY() uint32 {
	return (volatile.LoadUint32(&o.RTCCALICFG.Reg) & 0x8000) >> 15
}
func (o *TIMG_Type) SetRTCCALICFG_RTC_CALI_MAX(value uint32) {
	volatile.StoreUint32(&o.RTCCALICFG.Reg, volatile.LoadUint32(&o.RTCCALICFG.Reg)&^(0x7fff0000)|value<<16)
}
func (o *TIMG_Type) GetRTCCALICFG_RTC_CALI_MAX() uint32 {
	return (volatile.LoadUint32(&o.RTCCALICFG.Reg) & 0x7fff0000) >> 16
}
func (o *TIMG_Type) SetRTCCALICFG_RTC_CALI_START(value uint32) {
	volatile.StoreUint32(&o.RTCCALICFG.Reg, volatile.LoadUint32(&o.RTCCALICFG.Reg)&^(0x80000000)|value<<31)
}
func (o *TIMG_Type) GetRTCCALICFG_RTC_CALI_START() uint32 {
	return (volatile.LoadUint32(&o.RTCCALICFG.Reg) & 0x80000000) >> 31
}

// TIMG.RTCCALICFG1: RTC calibration configure1 register
func (o *TIMG_Type) SetRTCCALICFG1_RTC_CALI_CYCLING_DATA_VLD(value uint32) {
	volatile.StoreUint32(&o.RTCCALICFG1.Reg, volatile.LoadUint32(&o.RTCCALICFG1.Reg)&^(0x1)|value)
}
func (o *TIMG_Type) GetRTCCALICFG1_RTC_CALI_CYCLING_DATA_VLD() uint32 {
	return volatile.LoadUint32(&o.RTCCALICFG1.Reg) & 0x1
}
func (o *TIMG_Type) SetRTCCALICFG1_RTC_CALI_VALUE(value uint32) {
	volatile.StoreUint32(&o.RTCCALICFG1.Reg, volatile.LoadUint32(&o.RTCCALICFG1.Reg)&^(0xffffff80)|value<<7)
}
func (o *TIMG_Type) GetRTCCALICFG1_RTC_CALI_VALUE() uint32 {
	return (volatile.LoadUint32(&o.RTCCALICFG1.Reg) & 0xffffff80) >> 7
}

// TIMG.INT_ENA_TIMERS: Interrupt enable bits
func (o *TIMG_Type) SetINT_ENA_TIMERS_T0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_TIMERS.Reg, volatile.LoadUint32(&o.INT_ENA_TIMERS.Reg)&^(0x1)|value)
}
func (o *TIMG_Type) GetINT_ENA_TIMERS_T0_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA_TIMERS.Reg) & 0x1
}
func (o *TIMG_Type) SetINT_ENA_TIMERS_WDT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA_TIMERS.Reg, volatile.LoadUint32(&o.INT_ENA_TIMERS.Reg)&^(0x2)|value<<1)
}
func (o *TIMG_Type) GetINT_ENA_TIMERS_WDT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA_TIMERS.Reg) & 0x2) >> 1
}

// TIMG.INT_RAW_TIMERS: Raw interrupt status
func (o *TIMG_Type) SetINT_RAW_TIMERS_T0_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_TIMERS.Reg, volatile.LoadUint32(&o.INT_RAW_TIMERS.Reg)&^(0x1)|value)
}
func (o *TIMG_Type) GetINT_RAW_TIMERS_T0_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW_TIMERS.Reg) & 0x1
}
func (o *TIMG_Type) SetINT_RAW_TIMERS_WDT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW_TIMERS.Reg, volatile.LoadUint32(&o.INT_RAW_TIMERS.Reg)&^(0x2)|value<<1)
}
func (o *TIMG_Type) GetINT_RAW_TIMERS_WDT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW_TIMERS.Reg) & 0x2) >> 1
}

// TIMG.INT_ST_TIMERS: Masked interrupt status
func (o *TIMG_Type) SetINT_ST_TIMERS_T0_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_TIMERS.Reg, volatile.LoadUint32(&o.INT_ST_TIMERS.Reg)&^(0x1)|value)
}
func (o *TIMG_Type) GetINT_ST_TIMERS_T0_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST_TIMERS.Reg) & 0x1
}
func (o *TIMG_Type) SetINT_ST_TIMERS_WDT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST_TIMERS.Reg, volatile.LoadUint32(&o.INT_ST_TIMERS.Reg)&^(0x2)|value<<1)
}
func (o *TIMG_Type) GetINT_ST_TIMERS_WDT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_TIMERS.Reg) & 0x2) >> 1
}

// TIMG.INT_CLR_TIMERS: Interrupt clear bits
func (o *TIMG_Type) SetINT_CLR_TIMERS_T0_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_TIMERS.Reg, volatile.LoadUint32(&o.INT_CLR_TIMERS.Reg)&^(0x1)|value)
}
func (o *TIMG_Type) GetINT_CLR_TIMERS_T0_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR_TIMERS.Reg) & 0x1
}
func (o *TIMG_Type) SetINT_CLR_TIMERS_WDT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR_TIMERS.Reg, volatile.LoadUint32(&o.INT_CLR_TIMERS.Reg)&^(0x2)|value<<1)
}
func (o *TIMG_Type) GetINT_CLR_TIMERS_WDT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR_TIMERS.Reg) & 0x2) >> 1
}

// TIMG.RTCCALICFG2: Timer group calibration register
func (o *TIMG_Type) SetRTCCALICFG2_RTC_CALI_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.RTCCALICFG2.Reg, volatile.LoadUint32(&o.RTCCALICFG2.Reg)&^(0x1)|value)
}
func (o *TIMG_Type) GetRTCCALICFG2_RTC_CALI_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.RTCCALICFG2.Reg) & 0x1
}
func (o *TIMG_Type) SetRTCCALICFG2_RTC_CALI_TIMEOUT_RST_CNT(value uint32) {
	volatile.StoreUint32(&o.RTCCALICFG2.Reg, volatile.LoadUint32(&o.RTCCALICFG2.Reg)&^(0x78)|value<<3)
}
func (o *TIMG_Type) GetRTCCALICFG2_RTC_CALI_TIMEOUT_RST_CNT() uint32 {
	return (volatile.LoadUint32(&o.RTCCALICFG2.Reg) & 0x78) >> 3
}
func (o *TIMG_Type) SetRTCCALICFG2_RTC_CALI_TIMEOUT_THRES(value uint32) {
	volatile.StoreUint32(&o.RTCCALICFG2.Reg, volatile.LoadUint32(&o.RTCCALICFG2.Reg)&^(0xffffff80)|value<<7)
}
func (o *TIMG_Type) GetRTCCALICFG2_RTC_CALI_TIMEOUT_THRES() uint32 {
	return (volatile.LoadUint32(&o.RTCCALICFG2.Reg) & 0xffffff80) >> 7
}

// TIMG.NTIMERS_DATE: Timer version control register
func (o *TIMG_Type) SetNTIMERS_DATE_NTIMGS_DATE(value uint32) {
	volatile.StoreUint32(&o.NTIMERS_DATE.Reg, volatile.LoadUint32(&o.NTIMERS_DATE.Reg)&^(0xfffffff)|value)
}
func (o *TIMG_Type) GetNTIMERS_DATE_NTIMGS_DATE() uint32 {
	return volatile.LoadUint32(&o.NTIMERS_DATE.Reg) & 0xfffffff
}

// TIMG.REGCLK: Timer group clock gate register
func (o *TIMG_Type) SetREGCLK_WDT_CLK_IS_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.REGCLK.Reg, volatile.LoadUint32(&o.REGCLK.Reg)&^(0x20000000)|value<<29)
}
func (o *TIMG_Type) GetREGCLK_WDT_CLK_IS_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.REGCLK.Reg) & 0x20000000) >> 29
}
func (o *TIMG_Type) SetREGCLK_TIMER_CLK_IS_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.REGCLK.Reg, volatile.LoadUint32(&o.REGCLK.Reg)&^(0x40000000)|value<<30)
}
func (o *TIMG_Type) GetREGCLK_TIMER_CLK_IS_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.REGCLK.Reg) & 0x40000000) >> 30
}
func (o *TIMG_Type) SetREGCLK_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.REGCLK.Reg, volatile.LoadUint32(&o.REGCLK.Reg)&^(0x80000000)|value<<31)
}
func (o *TIMG_Type) GetREGCLK_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.REGCLK.Reg) & 0x80000000) >> 31
}

// UART (Universal Asynchronous Receiver-Transmitter) Controller 0
type UART_Type struct {
	FIFO           volatile.Register32 // 0x0
	INT_RAW        volatile.Register32 // 0x4
	INT_ST         volatile.Register32 // 0x8
	INT_ENA        volatile.Register32 // 0xC
	INT_CLR        volatile.Register32 // 0x10
	CLKDIV         volatile.Register32 // 0x14
	RX_FILT        volatile.Register32 // 0x18
	STATUS         volatile.Register32 // 0x1C
	CONF0          volatile.Register32 // 0x20
	CONF1          volatile.Register32 // 0x24
	LOWPULSE       volatile.Register32 // 0x28
	HIGHPULSE      volatile.Register32 // 0x2C
	RXD_CNT        volatile.Register32 // 0x30
	FLOW_CONF      volatile.Register32 // 0x34
	SLEEP_CONF     volatile.Register32 // 0x38
	SWFC_CONF0     volatile.Register32 // 0x3C
	SWFC_CONF1     volatile.Register32 // 0x40
	TXBRK_CONF     volatile.Register32 // 0x44
	IDLE_CONF      volatile.Register32 // 0x48
	RS485_CONF     volatile.Register32 // 0x4C
	AT_CMD_PRECNT  volatile.Register32 // 0x50
	AT_CMD_POSTCNT volatile.Register32 // 0x54
	AT_CMD_GAPTOUT volatile.Register32 // 0x58
	AT_CMD_CHAR    volatile.Register32 // 0x5C
	MEM_CONF       volatile.Register32 // 0x60
	MEM_TX_STATUS  volatile.Register32 // 0x64
	MEM_RX_STATUS  volatile.Register32 // 0x68
	FSM_STATUS     volatile.Register32 // 0x6C
	POSPULSE       volatile.Register32 // 0x70
	NEGPULSE       volatile.Register32 // 0x74
	CLK_CONF       volatile.Register32 // 0x78
	DATE           volatile.Register32 // 0x7C
	ID             volatile.Register32 // 0x80
}

// UART.FIFO: FIFO data register
func (o *UART_Type) SetFIFO_RXFIFO_RD_BYTE(value uint32) {
	volatile.StoreUint32(&o.FIFO.Reg, volatile.LoadUint32(&o.FIFO.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetFIFO_RXFIFO_RD_BYTE() uint32 {
	return volatile.LoadUint32(&o.FIFO.Reg) & 0xff
}

// UART.INT_RAW: Raw interrupt status
func (o *UART_Type) SetINT_RAW_RXFIFO_FULL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetINT_RAW_RXFIFO_FULL_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *UART_Type) SetINT_RAW_TXFIFO_EMPTY_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetINT_RAW_TXFIFO_EMPTY_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetINT_RAW_PARITY_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetINT_RAW_PARITY_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetINT_RAW_FRM_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetINT_RAW_FRM_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetINT_RAW_RXFIFO_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetINT_RAW_RXFIFO_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetINT_RAW_DSR_CHG_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetINT_RAW_DSR_CHG_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetINT_RAW_CTS_CHG_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetINT_RAW_CTS_CHG_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetINT_RAW_BRK_DET_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetINT_RAW_BRK_DET_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetINT_RAW_RXFIFO_TOUT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetINT_RAW_RXFIFO_TOUT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x100) >> 8
}
func (o *UART_Type) SetINT_RAW_SW_XON_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetINT_RAW_SW_XON_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetINT_RAW_SW_XOFF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x400)|value<<10)
}
func (o *UART_Type) GetINT_RAW_SW_XOFF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x400) >> 10
}
func (o *UART_Type) SetINT_RAW_GLITCH_DET_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x800)|value<<11)
}
func (o *UART_Type) GetINT_RAW_GLITCH_DET_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x800) >> 11
}
func (o *UART_Type) SetINT_RAW_TX_BRK_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetINT_RAW_TX_BRK_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1000) >> 12
}
func (o *UART_Type) SetINT_RAW_TX_BRK_IDLE_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2000)|value<<13)
}
func (o *UART_Type) GetINT_RAW_TX_BRK_IDLE_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2000) >> 13
}
func (o *UART_Type) SetINT_RAW_TX_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4000)|value<<14)
}
func (o *UART_Type) GetINT_RAW_TX_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4000) >> 14
}
func (o *UART_Type) SetINT_RAW_RS485_PARITY_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8000)|value<<15)
}
func (o *UART_Type) GetINT_RAW_RS485_PARITY_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8000) >> 15
}
func (o *UART_Type) SetINT_RAW_RS485_FRM_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10000)|value<<16)
}
func (o *UART_Type) GetINT_RAW_RS485_FRM_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10000) >> 16
}
func (o *UART_Type) SetINT_RAW_RS485_CLASH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20000)|value<<17)
}
func (o *UART_Type) GetINT_RAW_RS485_CLASH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20000) >> 17
}
func (o *UART_Type) SetINT_RAW_AT_CMD_CHAR_DET_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40000)|value<<18)
}
func (o *UART_Type) GetINT_RAW_AT_CMD_CHAR_DET_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40000) >> 18
}
func (o *UART_Type) SetINT_RAW_WAKEUP_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80000)|value<<19)
}
func (o *UART_Type) GetINT_RAW_WAKEUP_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80000) >> 19
}

// UART.INT_ST: Masked interrupt status
func (o *UART_Type) SetINT_ST_RXFIFO_FULL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetINT_ST_RXFIFO_FULL_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST.Reg) & 0x1
}
func (o *UART_Type) SetINT_ST_TXFIFO_EMPTY_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetINT_ST_TXFIFO_EMPTY_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetINT_ST_PARITY_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetINT_ST_PARITY_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetINT_ST_FRM_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetINT_ST_FRM_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetINT_ST_RXFIFO_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetINT_ST_RXFIFO_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetINT_ST_DSR_CHG_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetINT_ST_DSR_CHG_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetINT_ST_CTS_CHG_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetINT_ST_CTS_CHG_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetINT_ST_BRK_DET_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetINT_ST_BRK_DET_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetINT_ST_RXFIFO_TOUT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetINT_ST_RXFIFO_TOUT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x100) >> 8
}
func (o *UART_Type) SetINT_ST_SW_XON_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetINT_ST_SW_XON_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetINT_ST_SW_XOFF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x400)|value<<10)
}
func (o *UART_Type) GetINT_ST_SW_XOFF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x400) >> 10
}
func (o *UART_Type) SetINT_ST_GLITCH_DET_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x800)|value<<11)
}
func (o *UART_Type) GetINT_ST_GLITCH_DET_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x800) >> 11
}
func (o *UART_Type) SetINT_ST_TX_BRK_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetINT_ST_TX_BRK_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x1000) >> 12
}
func (o *UART_Type) SetINT_ST_TX_BRK_IDLE_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2000)|value<<13)
}
func (o *UART_Type) GetINT_ST_TX_BRK_IDLE_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2000) >> 13
}
func (o *UART_Type) SetINT_ST_TX_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4000)|value<<14)
}
func (o *UART_Type) GetINT_ST_TX_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4000) >> 14
}
func (o *UART_Type) SetINT_ST_RS485_PARITY_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x8000)|value<<15)
}
func (o *UART_Type) GetINT_ST_RS485_PARITY_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x8000) >> 15
}
func (o *UART_Type) SetINT_ST_RS485_FRM_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x10000)|value<<16)
}
func (o *UART_Type) GetINT_ST_RS485_FRM_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x10000) >> 16
}
func (o *UART_Type) SetINT_ST_RS485_CLASH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x20000)|value<<17)
}
func (o *UART_Type) GetINT_ST_RS485_CLASH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x20000) >> 17
}
func (o *UART_Type) SetINT_ST_AT_CMD_CHAR_DET_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x40000)|value<<18)
}
func (o *UART_Type) GetINT_ST_AT_CMD_CHAR_DET_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x40000) >> 18
}
func (o *UART_Type) SetINT_ST_WAKEUP_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x80000)|value<<19)
}
func (o *UART_Type) GetINT_ST_WAKEUP_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x80000) >> 19
}

// UART.INT_ENA: Interrupt enable bits
func (o *UART_Type) SetINT_ENA_RXFIFO_FULL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetINT_ENA_RXFIFO_FULL_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *UART_Type) SetINT_ENA_TXFIFO_EMPTY_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetINT_ENA_TXFIFO_EMPTY_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetINT_ENA_PARITY_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetINT_ENA_PARITY_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetINT_ENA_FRM_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetINT_ENA_FRM_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetINT_ENA_RXFIFO_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetINT_ENA_RXFIFO_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetINT_ENA_DSR_CHG_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetINT_ENA_DSR_CHG_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetINT_ENA_CTS_CHG_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetINT_ENA_CTS_CHG_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetINT_ENA_BRK_DET_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetINT_ENA_BRK_DET_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetINT_ENA_RXFIFO_TOUT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetINT_ENA_RXFIFO_TOUT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x100) >> 8
}
func (o *UART_Type) SetINT_ENA_SW_XON_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetINT_ENA_SW_XON_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetINT_ENA_SW_XOFF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x400)|value<<10)
}
func (o *UART_Type) GetINT_ENA_SW_XOFF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x400) >> 10
}
func (o *UART_Type) SetINT_ENA_GLITCH_DET_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x800)|value<<11)
}
func (o *UART_Type) GetINT_ENA_GLITCH_DET_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x800) >> 11
}
func (o *UART_Type) SetINT_ENA_TX_BRK_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetINT_ENA_TX_BRK_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1000) >> 12
}
func (o *UART_Type) SetINT_ENA_TX_BRK_IDLE_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2000)|value<<13)
}
func (o *UART_Type) GetINT_ENA_TX_BRK_IDLE_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2000) >> 13
}
func (o *UART_Type) SetINT_ENA_TX_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4000)|value<<14)
}
func (o *UART_Type) GetINT_ENA_TX_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4000) >> 14
}
func (o *UART_Type) SetINT_ENA_RS485_PARITY_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8000)|value<<15)
}
func (o *UART_Type) GetINT_ENA_RS485_PARITY_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8000) >> 15
}
func (o *UART_Type) SetINT_ENA_RS485_FRM_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10000)|value<<16)
}
func (o *UART_Type) GetINT_ENA_RS485_FRM_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10000) >> 16
}
func (o *UART_Type) SetINT_ENA_RS485_CLASH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20000)|value<<17)
}
func (o *UART_Type) GetINT_ENA_RS485_CLASH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20000) >> 17
}
func (o *UART_Type) SetINT_ENA_AT_CMD_CHAR_DET_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40000)|value<<18)
}
func (o *UART_Type) GetINT_ENA_AT_CMD_CHAR_DET_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40000) >> 18
}
func (o *UART_Type) SetINT_ENA_WAKEUP_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80000)|value<<19)
}
func (o *UART_Type) GetINT_ENA_WAKEUP_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80000) >> 19
}

// UART.INT_CLR: Interrupt clear bits
func (o *UART_Type) SetINT_CLR_RXFIFO_FULL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetINT_CLR_RXFIFO_FULL_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *UART_Type) SetINT_CLR_TXFIFO_EMPTY_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetINT_CLR_TXFIFO_EMPTY_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetINT_CLR_PARITY_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetINT_CLR_PARITY_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetINT_CLR_FRM_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetINT_CLR_FRM_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetINT_CLR_RXFIFO_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetINT_CLR_RXFIFO_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetINT_CLR_DSR_CHG_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetINT_CLR_DSR_CHG_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetINT_CLR_CTS_CHG_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetINT_CLR_CTS_CHG_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetINT_CLR_BRK_DET_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetINT_CLR_BRK_DET_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetINT_CLR_RXFIFO_TOUT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetINT_CLR_RXFIFO_TOUT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x100) >> 8
}
func (o *UART_Type) SetINT_CLR_SW_XON_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetINT_CLR_SW_XON_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetINT_CLR_SW_XOFF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x400)|value<<10)
}
func (o *UART_Type) GetINT_CLR_SW_XOFF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x400) >> 10
}
func (o *UART_Type) SetINT_CLR_GLITCH_DET_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x800)|value<<11)
}
func (o *UART_Type) GetINT_CLR_GLITCH_DET_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x800) >> 11
}
func (o *UART_Type) SetINT_CLR_TX_BRK_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetINT_CLR_TX_BRK_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1000) >> 12
}
func (o *UART_Type) SetINT_CLR_TX_BRK_IDLE_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *UART_Type) GetINT_CLR_TX_BRK_IDLE_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2000) >> 13
}
func (o *UART_Type) SetINT_CLR_TX_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *UART_Type) GetINT_CLR_TX_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4000) >> 14
}
func (o *UART_Type) SetINT_CLR_RS485_PARITY_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *UART_Type) GetINT_CLR_RS485_PARITY_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8000) >> 15
}
func (o *UART_Type) SetINT_CLR_RS485_FRM_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10000)|value<<16)
}
func (o *UART_Type) GetINT_CLR_RS485_FRM_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10000) >> 16
}
func (o *UART_Type) SetINT_CLR_RS485_CLASH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20000)|value<<17)
}
func (o *UART_Type) GetINT_CLR_RS485_CLASH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20000) >> 17
}
func (o *UART_Type) SetINT_CLR_AT_CMD_CHAR_DET_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40000)|value<<18)
}
func (o *UART_Type) GetINT_CLR_AT_CMD_CHAR_DET_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40000) >> 18
}
func (o *UART_Type) SetINT_CLR_WAKEUP_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80000)|value<<19)
}
func (o *UART_Type) GetINT_CLR_WAKEUP_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80000) >> 19
}

// UART.CLKDIV: Clock divider configuration
func (o *UART_Type) SetCLKDIV(value uint32) {
	volatile.StoreUint32(&o.CLKDIV.Reg, volatile.LoadUint32(&o.CLKDIV.Reg)&^(0xfff)|value)
}
func (o *UART_Type) GetCLKDIV() uint32 {
	return volatile.LoadUint32(&o.CLKDIV.Reg) & 0xfff
}
func (o *UART_Type) SetCLKDIV_FRAG(value uint32) {
	volatile.StoreUint32(&o.CLKDIV.Reg, volatile.LoadUint32(&o.CLKDIV.Reg)&^(0xf00000)|value<<20)
}
func (o *UART_Type) GetCLKDIV_FRAG() uint32 {
	return (volatile.LoadUint32(&o.CLKDIV.Reg) & 0xf00000) >> 20
}

// UART.RX_FILT: Rx Filter configuration
func (o *UART_Type) SetRX_FILT_GLITCH_FILT(value uint32) {
	volatile.StoreUint32(&o.RX_FILT.Reg, volatile.LoadUint32(&o.RX_FILT.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetRX_FILT_GLITCH_FILT() uint32 {
	return volatile.LoadUint32(&o.RX_FILT.Reg) & 0xff
}
func (o *UART_Type) SetRX_FILT_GLITCH_FILT_EN(value uint32) {
	volatile.StoreUint32(&o.RX_FILT.Reg, volatile.LoadUint32(&o.RX_FILT.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetRX_FILT_GLITCH_FILT_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_FILT.Reg) & 0x100) >> 8
}

// UART.STATUS: UART status register
func (o *UART_Type) SetSTATUS_RXFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x3ff)|value)
}
func (o *UART_Type) GetSTATUS_RXFIFO_CNT() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x3ff
}
func (o *UART_Type) SetSTATUS_DSRN(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *UART_Type) GetSTATUS_DSRN() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2000) >> 13
}
func (o *UART_Type) SetSTATUS_CTSN(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4000)|value<<14)
}
func (o *UART_Type) GetSTATUS_CTSN() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4000) >> 14
}
func (o *UART_Type) SetSTATUS_RXD(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8000)|value<<15)
}
func (o *UART_Type) GetSTATUS_RXD() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8000) >> 15
}
func (o *UART_Type) SetSTATUS_TXFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x3ff0000)|value<<16)
}
func (o *UART_Type) GetSTATUS_TXFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x3ff0000) >> 16
}
func (o *UART_Type) SetSTATUS_DTRN(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x20000000)|value<<29)
}
func (o *UART_Type) GetSTATUS_DTRN() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x20000000) >> 29
}
func (o *UART_Type) SetSTATUS_RTSN(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x40000000)|value<<30)
}
func (o *UART_Type) GetSTATUS_RTSN() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x40000000) >> 30
}
func (o *UART_Type) SetSTATUS_TXD(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x80000000)|value<<31)
}
func (o *UART_Type) GetSTATUS_TXD() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x80000000) >> 31
}

// UART.CONF0: a
func (o *UART_Type) SetCONF0_PARITY(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetCONF0_PARITY() uint32 {
	return volatile.LoadUint32(&o.CONF0.Reg) & 0x1
}
func (o *UART_Type) SetCONF0_PARITY_EN(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetCONF0_PARITY_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetCONF0_BIT_NUM(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0xc)|value<<2)
}
func (o *UART_Type) GetCONF0_BIT_NUM() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0xc) >> 2
}
func (o *UART_Type) SetCONF0_STOP_BIT_NUM(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x30)|value<<4)
}
func (o *UART_Type) GetCONF0_STOP_BIT_NUM() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x30) >> 4
}
func (o *UART_Type) SetCONF0_SW_RTS(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetCONF0_SW_RTS() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetCONF0_SW_DTR(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetCONF0_SW_DTR() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetCONF0_TXD_BRK(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetCONF0_TXD_BRK() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x100) >> 8
}
func (o *UART_Type) SetCONF0_IRDA_DPLX(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetCONF0_IRDA_DPLX() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetCONF0_IRDA_TX_EN(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x400)|value<<10)
}
func (o *UART_Type) GetCONF0_IRDA_TX_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x400) >> 10
}
func (o *UART_Type) SetCONF0_IRDA_WCTL(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x800)|value<<11)
}
func (o *UART_Type) GetCONF0_IRDA_WCTL() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x800) >> 11
}
func (o *UART_Type) SetCONF0_IRDA_TX_INV(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetCONF0_IRDA_TX_INV() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x1000) >> 12
}
func (o *UART_Type) SetCONF0_IRDA_RX_INV(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x2000)|value<<13)
}
func (o *UART_Type) GetCONF0_IRDA_RX_INV() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x2000) >> 13
}
func (o *UART_Type) SetCONF0_LOOPBACK(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x4000)|value<<14)
}
func (o *UART_Type) GetCONF0_LOOPBACK() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x4000) >> 14
}
func (o *UART_Type) SetCONF0_TX_FLOW_EN(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x8000)|value<<15)
}
func (o *UART_Type) GetCONF0_TX_FLOW_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x8000) >> 15
}
func (o *UART_Type) SetCONF0_IRDA_EN(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x10000)|value<<16)
}
func (o *UART_Type) GetCONF0_IRDA_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x10000) >> 16
}
func (o *UART_Type) SetCONF0_RXFIFO_RST(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x20000)|value<<17)
}
func (o *UART_Type) GetCONF0_RXFIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x20000) >> 17
}
func (o *UART_Type) SetCONF0_TXFIFO_RST(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x40000)|value<<18)
}
func (o *UART_Type) GetCONF0_TXFIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x40000) >> 18
}
func (o *UART_Type) SetCONF0_RXD_INV(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x80000)|value<<19)
}
func (o *UART_Type) GetCONF0_RXD_INV() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x80000) >> 19
}
func (o *UART_Type) SetCONF0_CTS_INV(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x100000)|value<<20)
}
func (o *UART_Type) GetCONF0_CTS_INV() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x100000) >> 20
}
func (o *UART_Type) SetCONF0_DSR_INV(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x200000)|value<<21)
}
func (o *UART_Type) GetCONF0_DSR_INV() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x200000) >> 21
}
func (o *UART_Type) SetCONF0_TXD_INV(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x400000)|value<<22)
}
func (o *UART_Type) GetCONF0_TXD_INV() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x400000) >> 22
}
func (o *UART_Type) SetCONF0_RTS_INV(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x800000)|value<<23)
}
func (o *UART_Type) GetCONF0_RTS_INV() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x800000) >> 23
}
func (o *UART_Type) SetCONF0_DTR_INV(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x1000000)|value<<24)
}
func (o *UART_Type) GetCONF0_DTR_INV() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x1000000) >> 24
}
func (o *UART_Type) SetCONF0_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x2000000)|value<<25)
}
func (o *UART_Type) GetCONF0_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x2000000) >> 25
}
func (o *UART_Type) SetCONF0_ERR_WR_MASK(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x4000000)|value<<26)
}
func (o *UART_Type) GetCONF0_ERR_WR_MASK() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x4000000) >> 26
}
func (o *UART_Type) SetCONF0_AUTOBAUD_EN(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x8000000)|value<<27)
}
func (o *UART_Type) GetCONF0_AUTOBAUD_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x8000000) >> 27
}
func (o *UART_Type) SetCONF0_MEM_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CONF0.Reg, volatile.LoadUint32(&o.CONF0.Reg)&^(0x10000000)|value<<28)
}
func (o *UART_Type) GetCONF0_MEM_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF0.Reg) & 0x10000000) >> 28
}

// UART.CONF1: Configuration register 1
func (o *UART_Type) SetCONF1_RXFIFO_FULL_THRHD(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x1ff)|value)
}
func (o *UART_Type) GetCONF1_RXFIFO_FULL_THRHD() uint32 {
	return volatile.LoadUint32(&o.CONF1.Reg) & 0x1ff
}
func (o *UART_Type) SetCONF1_TXFIFO_EMPTY_THRHD(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x3fe00)|value<<9)
}
func (o *UART_Type) GetCONF1_TXFIFO_EMPTY_THRHD() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0x3fe00) >> 9
}
func (o *UART_Type) SetCONF1_DIS_RX_DAT_OVF(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x40000)|value<<18)
}
func (o *UART_Type) GetCONF1_DIS_RX_DAT_OVF() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0x40000) >> 18
}
func (o *UART_Type) SetCONF1_RX_TOUT_FLOW_DIS(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x80000)|value<<19)
}
func (o *UART_Type) GetCONF1_RX_TOUT_FLOW_DIS() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0x80000) >> 19
}
func (o *UART_Type) SetCONF1_RX_FLOW_EN(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x100000)|value<<20)
}
func (o *UART_Type) GetCONF1_RX_FLOW_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0x100000) >> 20
}
func (o *UART_Type) SetCONF1_RX_TOUT_EN(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x200000)|value<<21)
}
func (o *UART_Type) GetCONF1_RX_TOUT_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0x200000) >> 21
}

// UART.LOWPULSE: Autobaud minimum low pulse duration register
func (o *UART_Type) SetLOWPULSE_MIN_CNT(value uint32) {
	volatile.StoreUint32(&o.LOWPULSE.Reg, volatile.LoadUint32(&o.LOWPULSE.Reg)&^(0xfff)|value)
}
func (o *UART_Type) GetLOWPULSE_MIN_CNT() uint32 {
	return volatile.LoadUint32(&o.LOWPULSE.Reg) & 0xfff
}

// UART.HIGHPULSE: Autobaud minimum high pulse duration register
func (o *UART_Type) SetHIGHPULSE_MIN_CNT(value uint32) {
	volatile.StoreUint32(&o.HIGHPULSE.Reg, volatile.LoadUint32(&o.HIGHPULSE.Reg)&^(0xfff)|value)
}
func (o *UART_Type) GetHIGHPULSE_MIN_CNT() uint32 {
	return volatile.LoadUint32(&o.HIGHPULSE.Reg) & 0xfff
}

// UART.RXD_CNT: Autobaud edge change count register
func (o *UART_Type) SetRXD_CNT_RXD_EDGE_CNT(value uint32) {
	volatile.StoreUint32(&o.RXD_CNT.Reg, volatile.LoadUint32(&o.RXD_CNT.Reg)&^(0x3ff)|value)
}
func (o *UART_Type) GetRXD_CNT_RXD_EDGE_CNT() uint32 {
	return volatile.LoadUint32(&o.RXD_CNT.Reg) & 0x3ff
}

// UART.FLOW_CONF: Software flow-control configuration
func (o *UART_Type) SetFLOW_CONF_SW_FLOW_CON_EN(value uint32) {
	volatile.StoreUint32(&o.FLOW_CONF.Reg, volatile.LoadUint32(&o.FLOW_CONF.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetFLOW_CONF_SW_FLOW_CON_EN() uint32 {
	return volatile.LoadUint32(&o.FLOW_CONF.Reg) & 0x1
}
func (o *UART_Type) SetFLOW_CONF_XONOFF_DEL(value uint32) {
	volatile.StoreUint32(&o.FLOW_CONF.Reg, volatile.LoadUint32(&o.FLOW_CONF.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetFLOW_CONF_XONOFF_DEL() uint32 {
	return (volatile.LoadUint32(&o.FLOW_CONF.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetFLOW_CONF_FORCE_XON(value uint32) {
	volatile.StoreUint32(&o.FLOW_CONF.Reg, volatile.LoadUint32(&o.FLOW_CONF.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetFLOW_CONF_FORCE_XON() uint32 {
	return (volatile.LoadUint32(&o.FLOW_CONF.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetFLOW_CONF_FORCE_XOFF(value uint32) {
	volatile.StoreUint32(&o.FLOW_CONF.Reg, volatile.LoadUint32(&o.FLOW_CONF.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetFLOW_CONF_FORCE_XOFF() uint32 {
	return (volatile.LoadUint32(&o.FLOW_CONF.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetFLOW_CONF_SEND_XON(value uint32) {
	volatile.StoreUint32(&o.FLOW_CONF.Reg, volatile.LoadUint32(&o.FLOW_CONF.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetFLOW_CONF_SEND_XON() uint32 {
	return (volatile.LoadUint32(&o.FLOW_CONF.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetFLOW_CONF_SEND_XOFF(value uint32) {
	volatile.StoreUint32(&o.FLOW_CONF.Reg, volatile.LoadUint32(&o.FLOW_CONF.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetFLOW_CONF_SEND_XOFF() uint32 {
	return (volatile.LoadUint32(&o.FLOW_CONF.Reg) & 0x20) >> 5
}

// UART.SLEEP_CONF: Sleep-mode configuration
func (o *UART_Type) SetSLEEP_CONF_ACTIVE_THRESHOLD(value uint32) {
	volatile.StoreUint32(&o.SLEEP_CONF.Reg, volatile.LoadUint32(&o.SLEEP_CONF.Reg)&^(0x3ff)|value)
}
func (o *UART_Type) GetSLEEP_CONF_ACTIVE_THRESHOLD() uint32 {
	return volatile.LoadUint32(&o.SLEEP_CONF.Reg) & 0x3ff
}

// UART.SWFC_CONF0: Software flow-control character configuration
func (o *UART_Type) SetSWFC_CONF0_XOFF_THRESHOLD(value uint32) {
	volatile.StoreUint32(&o.SWFC_CONF0.Reg, volatile.LoadUint32(&o.SWFC_CONF0.Reg)&^(0x1ff)|value)
}
func (o *UART_Type) GetSWFC_CONF0_XOFF_THRESHOLD() uint32 {
	return volatile.LoadUint32(&o.SWFC_CONF0.Reg) & 0x1ff
}
func (o *UART_Type) SetSWFC_CONF0_XOFF_CHAR(value uint32) {
	volatile.StoreUint32(&o.SWFC_CONF0.Reg, volatile.LoadUint32(&o.SWFC_CONF0.Reg)&^(0x1fe00)|value<<9)
}
func (o *UART_Type) GetSWFC_CONF0_XOFF_CHAR() uint32 {
	return (volatile.LoadUint32(&o.SWFC_CONF0.Reg) & 0x1fe00) >> 9
}

// UART.SWFC_CONF1: Software flow-control character configuration
func (o *UART_Type) SetSWFC_CONF1_XON_THRESHOLD(value uint32) {
	volatile.StoreUint32(&o.SWFC_CONF1.Reg, volatile.LoadUint32(&o.SWFC_CONF1.Reg)&^(0x1ff)|value)
}
func (o *UART_Type) GetSWFC_CONF1_XON_THRESHOLD() uint32 {
	return volatile.LoadUint32(&o.SWFC_CONF1.Reg) & 0x1ff
}
func (o *UART_Type) SetSWFC_CONF1_XON_CHAR(value uint32) {
	volatile.StoreUint32(&o.SWFC_CONF1.Reg, volatile.LoadUint32(&o.SWFC_CONF1.Reg)&^(0x1fe00)|value<<9)
}
func (o *UART_Type) GetSWFC_CONF1_XON_CHAR() uint32 {
	return (volatile.LoadUint32(&o.SWFC_CONF1.Reg) & 0x1fe00) >> 9
}

// UART.TXBRK_CONF: Tx Break character configuration
func (o *UART_Type) SetTXBRK_CONF_TX_BRK_NUM(value uint32) {
	volatile.StoreUint32(&o.TXBRK_CONF.Reg, volatile.LoadUint32(&o.TXBRK_CONF.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetTXBRK_CONF_TX_BRK_NUM() uint32 {
	return volatile.LoadUint32(&o.TXBRK_CONF.Reg) & 0xff
}

// UART.IDLE_CONF: Frame-end idle configuration
func (o *UART_Type) SetIDLE_CONF_RX_IDLE_THRHD(value uint32) {
	volatile.StoreUint32(&o.IDLE_CONF.Reg, volatile.LoadUint32(&o.IDLE_CONF.Reg)&^(0x3ff)|value)
}
func (o *UART_Type) GetIDLE_CONF_RX_IDLE_THRHD() uint32 {
	return volatile.LoadUint32(&o.IDLE_CONF.Reg) & 0x3ff
}
func (o *UART_Type) SetIDLE_CONF_TX_IDLE_NUM(value uint32) {
	volatile.StoreUint32(&o.IDLE_CONF.Reg, volatile.LoadUint32(&o.IDLE_CONF.Reg)&^(0xffc00)|value<<10)
}
func (o *UART_Type) GetIDLE_CONF_TX_IDLE_NUM() uint32 {
	return (volatile.LoadUint32(&o.IDLE_CONF.Reg) & 0xffc00) >> 10
}

// UART.RS485_CONF: RS485 mode configuration
func (o *UART_Type) SetRS485_CONF_RS485_EN(value uint32) {
	volatile.StoreUint32(&o.RS485_CONF.Reg, volatile.LoadUint32(&o.RS485_CONF.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetRS485_CONF_RS485_EN() uint32 {
	return volatile.LoadUint32(&o.RS485_CONF.Reg) & 0x1
}
func (o *UART_Type) SetRS485_CONF_DL0_EN(value uint32) {
	volatile.StoreUint32(&o.RS485_CONF.Reg, volatile.LoadUint32(&o.RS485_CONF.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetRS485_CONF_DL0_EN() uint32 {
	return (volatile.LoadUint32(&o.RS485_CONF.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetRS485_CONF_DL1_EN(value uint32) {
	volatile.StoreUint32(&o.RS485_CONF.Reg, volatile.LoadUint32(&o.RS485_CONF.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetRS485_CONF_DL1_EN() uint32 {
	return (volatile.LoadUint32(&o.RS485_CONF.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetRS485_CONF_RS485TX_RX_EN(value uint32) {
	volatile.StoreUint32(&o.RS485_CONF.Reg, volatile.LoadUint32(&o.RS485_CONF.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetRS485_CONF_RS485TX_RX_EN() uint32 {
	return (volatile.LoadUint32(&o.RS485_CONF.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetRS485_CONF_RS485RXBY_TX_EN(value uint32) {
	volatile.StoreUint32(&o.RS485_CONF.Reg, volatile.LoadUint32(&o.RS485_CONF.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetRS485_CONF_RS485RXBY_TX_EN() uint32 {
	return (volatile.LoadUint32(&o.RS485_CONF.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetRS485_CONF_RS485_RX_DLY_NUM(value uint32) {
	volatile.StoreUint32(&o.RS485_CONF.Reg, volatile.LoadUint32(&o.RS485_CONF.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetRS485_CONF_RS485_RX_DLY_NUM() uint32 {
	return (volatile.LoadUint32(&o.RS485_CONF.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetRS485_CONF_RS485_TX_DLY_NUM(value uint32) {
	volatile.StoreUint32(&o.RS485_CONF.Reg, volatile.LoadUint32(&o.RS485_CONF.Reg)&^(0x3c0)|value<<6)
}
func (o *UART_Type) GetRS485_CONF_RS485_TX_DLY_NUM() uint32 {
	return (volatile.LoadUint32(&o.RS485_CONF.Reg) & 0x3c0) >> 6
}

// UART.AT_CMD_PRECNT: Pre-sequence timing configuration
func (o *UART_Type) SetAT_CMD_PRECNT_PRE_IDLE_NUM(value uint32) {
	volatile.StoreUint32(&o.AT_CMD_PRECNT.Reg, volatile.LoadUint32(&o.AT_CMD_PRECNT.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetAT_CMD_PRECNT_PRE_IDLE_NUM() uint32 {
	return volatile.LoadUint32(&o.AT_CMD_PRECNT.Reg) & 0xffff
}

// UART.AT_CMD_POSTCNT: Post-sequence timing configuration
func (o *UART_Type) SetAT_CMD_POSTCNT_POST_IDLE_NUM(value uint32) {
	volatile.StoreUint32(&o.AT_CMD_POSTCNT.Reg, volatile.LoadUint32(&o.AT_CMD_POSTCNT.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetAT_CMD_POSTCNT_POST_IDLE_NUM() uint32 {
	return volatile.LoadUint32(&o.AT_CMD_POSTCNT.Reg) & 0xffff
}

// UART.AT_CMD_GAPTOUT: Timeout configuration
func (o *UART_Type) SetAT_CMD_GAPTOUT_RX_GAP_TOUT(value uint32) {
	volatile.StoreUint32(&o.AT_CMD_GAPTOUT.Reg, volatile.LoadUint32(&o.AT_CMD_GAPTOUT.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetAT_CMD_GAPTOUT_RX_GAP_TOUT() uint32 {
	return volatile.LoadUint32(&o.AT_CMD_GAPTOUT.Reg) & 0xffff
}

// UART.AT_CMD_CHAR: AT escape sequence detection configuration
func (o *UART_Type) SetAT_CMD_CHAR(value uint32) {
	volatile.StoreUint32(&o.AT_CMD_CHAR.Reg, volatile.LoadUint32(&o.AT_CMD_CHAR.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetAT_CMD_CHAR() uint32 {
	return volatile.LoadUint32(&o.AT_CMD_CHAR.Reg) & 0xff
}
func (o *UART_Type) SetAT_CMD_CHAR_CHAR_NUM(value uint32) {
	volatile.StoreUint32(&o.AT_CMD_CHAR.Reg, volatile.LoadUint32(&o.AT_CMD_CHAR.Reg)&^(0xff00)|value<<8)
}
func (o *UART_Type) GetAT_CMD_CHAR_CHAR_NUM() uint32 {
	return (volatile.LoadUint32(&o.AT_CMD_CHAR.Reg) & 0xff00) >> 8
}

// UART.MEM_CONF: UART threshold and allocation configuration
func (o *UART_Type) SetMEM_CONF_RX_SIZE(value uint32) {
	volatile.StoreUint32(&o.MEM_CONF.Reg, volatile.LoadUint32(&o.MEM_CONF.Reg)&^(0xe)|value<<1)
}
func (o *UART_Type) GetMEM_CONF_RX_SIZE() uint32 {
	return (volatile.LoadUint32(&o.MEM_CONF.Reg) & 0xe) >> 1
}
func (o *UART_Type) SetMEM_CONF_TX_SIZE(value uint32) {
	volatile.StoreUint32(&o.MEM_CONF.Reg, volatile.LoadUint32(&o.MEM_CONF.Reg)&^(0x70)|value<<4)
}
func (o *UART_Type) GetMEM_CONF_TX_SIZE() uint32 {
	return (volatile.LoadUint32(&o.MEM_CONF.Reg) & 0x70) >> 4
}
func (o *UART_Type) SetMEM_CONF_RX_FLOW_THRHD(value uint32) {
	volatile.StoreUint32(&o.MEM_CONF.Reg, volatile.LoadUint32(&o.MEM_CONF.Reg)&^(0xff80)|value<<7)
}
func (o *UART_Type) GetMEM_CONF_RX_FLOW_THRHD() uint32 {
	return (volatile.LoadUint32(&o.MEM_CONF.Reg) & 0xff80) >> 7
}
func (o *UART_Type) SetMEM_CONF_RX_TOUT_THRHD(value uint32) {
	volatile.StoreUint32(&o.MEM_CONF.Reg, volatile.LoadUint32(&o.MEM_CONF.Reg)&^(0x3ff0000)|value<<16)
}
func (o *UART_Type) GetMEM_CONF_RX_TOUT_THRHD() uint32 {
	return (volatile.LoadUint32(&o.MEM_CONF.Reg) & 0x3ff0000) >> 16
}
func (o *UART_Type) SetMEM_CONF_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.MEM_CONF.Reg, volatile.LoadUint32(&o.MEM_CONF.Reg)&^(0x4000000)|value<<26)
}
func (o *UART_Type) GetMEM_CONF_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.MEM_CONF.Reg) & 0x4000000) >> 26
}
func (o *UART_Type) SetMEM_CONF_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.MEM_CONF.Reg, volatile.LoadUint32(&o.MEM_CONF.Reg)&^(0x8000000)|value<<27)
}
func (o *UART_Type) GetMEM_CONF_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.MEM_CONF.Reg) & 0x8000000) >> 27
}

// UART.MEM_TX_STATUS: Tx-FIFO write and read offset address.
func (o *UART_Type) SetMEM_TX_STATUS_APB_TX_WADDR(value uint32) {
	volatile.StoreUint32(&o.MEM_TX_STATUS.Reg, volatile.LoadUint32(&o.MEM_TX_STATUS.Reg)&^(0x3ff)|value)
}
func (o *UART_Type) GetMEM_TX_STATUS_APB_TX_WADDR() uint32 {
	return volatile.LoadUint32(&o.MEM_TX_STATUS.Reg) & 0x3ff
}
func (o *UART_Type) SetMEM_TX_STATUS_TX_RADDR(value uint32) {
	volatile.StoreUint32(&o.MEM_TX_STATUS.Reg, volatile.LoadUint32(&o.MEM_TX_STATUS.Reg)&^(0x1ff800)|value<<11)
}
func (o *UART_Type) GetMEM_TX_STATUS_TX_RADDR() uint32 {
	return (volatile.LoadUint32(&o.MEM_TX_STATUS.Reg) & 0x1ff800) >> 11
}

// UART.MEM_RX_STATUS: Rx-FIFO write and read offset address.
func (o *UART_Type) SetMEM_RX_STATUS_APB_RX_RADDR(value uint32) {
	volatile.StoreUint32(&o.MEM_RX_STATUS.Reg, volatile.LoadUint32(&o.MEM_RX_STATUS.Reg)&^(0x3ff)|value)
}
func (o *UART_Type) GetMEM_RX_STATUS_APB_RX_RADDR() uint32 {
	return volatile.LoadUint32(&o.MEM_RX_STATUS.Reg) & 0x3ff
}
func (o *UART_Type) SetMEM_RX_STATUS_RX_WADDR(value uint32) {
	volatile.StoreUint32(&o.MEM_RX_STATUS.Reg, volatile.LoadUint32(&o.MEM_RX_STATUS.Reg)&^(0x1ff800)|value<<11)
}
func (o *UART_Type) GetMEM_RX_STATUS_RX_WADDR() uint32 {
	return (volatile.LoadUint32(&o.MEM_RX_STATUS.Reg) & 0x1ff800) >> 11
}

// UART.FSM_STATUS: UART transmit and receive status.
func (o *UART_Type) SetFSM_STATUS_ST_URX_OUT(value uint32) {
	volatile.StoreUint32(&o.FSM_STATUS.Reg, volatile.LoadUint32(&o.FSM_STATUS.Reg)&^(0xf)|value)
}
func (o *UART_Type) GetFSM_STATUS_ST_URX_OUT() uint32 {
	return volatile.LoadUint32(&o.FSM_STATUS.Reg) & 0xf
}
func (o *UART_Type) SetFSM_STATUS_ST_UTX_OUT(value uint32) {
	volatile.StoreUint32(&o.FSM_STATUS.Reg, volatile.LoadUint32(&o.FSM_STATUS.Reg)&^(0xf0)|value<<4)
}
func (o *UART_Type) GetFSM_STATUS_ST_UTX_OUT() uint32 {
	return (volatile.LoadUint32(&o.FSM_STATUS.Reg) & 0xf0) >> 4
}

// UART.POSPULSE: Autobaud high pulse register
func (o *UART_Type) SetPOSPULSE_POSEDGE_MIN_CNT(value uint32) {
	volatile.StoreUint32(&o.POSPULSE.Reg, volatile.LoadUint32(&o.POSPULSE.Reg)&^(0xfff)|value)
}
func (o *UART_Type) GetPOSPULSE_POSEDGE_MIN_CNT() uint32 {
	return volatile.LoadUint32(&o.POSPULSE.Reg) & 0xfff
}

// UART.NEGPULSE: Autobaud low pulse register
func (o *UART_Type) SetNEGPULSE_NEGEDGE_MIN_CNT(value uint32) {
	volatile.StoreUint32(&o.NEGPULSE.Reg, volatile.LoadUint32(&o.NEGPULSE.Reg)&^(0xfff)|value)
}
func (o *UART_Type) GetNEGPULSE_NEGEDGE_MIN_CNT() uint32 {
	return volatile.LoadUint32(&o.NEGPULSE.Reg) & 0xfff
}

// UART.CLK_CONF: UART core clock configuration
func (o *UART_Type) SetCLK_CONF_SCLK_DIV_B(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x3f)|value)
}
func (o *UART_Type) GetCLK_CONF_SCLK_DIV_B() uint32 {
	return volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x3f
}
func (o *UART_Type) SetCLK_CONF_SCLK_DIV_A(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0xfc0)|value<<6)
}
func (o *UART_Type) GetCLK_CONF_SCLK_DIV_A() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0xfc0) >> 6
}
func (o *UART_Type) SetCLK_CONF_SCLK_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0xff000)|value<<12)
}
func (o *UART_Type) GetCLK_CONF_SCLK_DIV_NUM() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0xff000) >> 12
}
func (o *UART_Type) SetCLK_CONF_SCLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x300000)|value<<20)
}
func (o *UART_Type) GetCLK_CONF_SCLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x300000) >> 20
}
func (o *UART_Type) SetCLK_CONF_SCLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x400000)|value<<22)
}
func (o *UART_Type) GetCLK_CONF_SCLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x400000) >> 22
}
func (o *UART_Type) SetCLK_CONF_RST_CORE(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x800000)|value<<23)
}
func (o *UART_Type) GetCLK_CONF_RST_CORE() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x800000) >> 23
}
func (o *UART_Type) SetCLK_CONF_TX_SCLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x1000000)|value<<24)
}
func (o *UART_Type) GetCLK_CONF_TX_SCLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x1000000) >> 24
}
func (o *UART_Type) SetCLK_CONF_RX_SCLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x2000000)|value<<25)
}
func (o *UART_Type) GetCLK_CONF_RX_SCLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x2000000) >> 25
}
func (o *UART_Type) SetCLK_CONF_TX_RST_CORE(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x4000000)|value<<26)
}
func (o *UART_Type) GetCLK_CONF_TX_RST_CORE() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x4000000) >> 26
}
func (o *UART_Type) SetCLK_CONF_RX_RST_CORE(value uint32) {
	volatile.StoreUint32(&o.CLK_CONF.Reg, volatile.LoadUint32(&o.CLK_CONF.Reg)&^(0x8000000)|value<<27)
}
func (o *UART_Type) GetCLK_CONF_RX_RST_CORE() uint32 {
	return (volatile.LoadUint32(&o.CLK_CONF.Reg) & 0x8000000) >> 27
}

// UART.DATE: UART Version register
func (o *UART_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *UART_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// UART.ID: UART ID register
func (o *UART_Type) SetID(value uint32) {
	volatile.StoreUint32(&o.ID.Reg, volatile.LoadUint32(&o.ID.Reg)&^(0x3fffffff)|value)
}
func (o *UART_Type) GetID() uint32 {
	return volatile.LoadUint32(&o.ID.Reg) & 0x3fffffff
}
func (o *UART_Type) SetID_HIGH_SPEED(value uint32) {
	volatile.StoreUint32(&o.ID.Reg, volatile.LoadUint32(&o.ID.Reg)&^(0x40000000)|value<<30)
}
func (o *UART_Type) GetID_HIGH_SPEED() uint32 {
	return (volatile.LoadUint32(&o.ID.Reg) & 0x40000000) >> 30
}
func (o *UART_Type) SetID_REG_UPDATE(value uint32) {
	volatile.StoreUint32(&o.ID.Reg, volatile.LoadUint32(&o.ID.Reg)&^(0x80000000)|value<<31)
}
func (o *UART_Type) GetID_REG_UPDATE() uint32 {
	return (volatile.LoadUint32(&o.ID.Reg) & 0x80000000) >> 31
}

// XTS-AES-128 Flash Encryption
type XTS_AES_Type struct {
	PLAIN_MEM        [16]volatile.Register8 // 0x0
	_                [48]byte
	LINESIZE         volatile.Register32 // 0x40
	DESTINATION      volatile.Register32 // 0x44
	PHYSICAL_ADDRESS volatile.Register32 // 0x48
	TRIGGER          volatile.Register32 // 0x4C
	RELEASE          volatile.Register32 // 0x50
	DESTROY          volatile.Register32 // 0x54
	STATE            volatile.Register32 // 0x58
	DATE             volatile.Register32 // 0x5C
}

// XTS_AES.LINESIZE: XTS-AES line-size register
func (o *XTS_AES_Type) SetLINESIZE(value uint32) {
	volatile.StoreUint32(&o.LINESIZE.Reg, volatile.LoadUint32(&o.LINESIZE.Reg)&^(0x1)|value)
}
func (o *XTS_AES_Type) GetLINESIZE() uint32 {
	return volatile.LoadUint32(&o.LINESIZE.Reg) & 0x1
}

// XTS_AES.DESTINATION: XTS-AES destination register
func (o *XTS_AES_Type) SetDESTINATION(value uint32) {
	volatile.StoreUint32(&o.DESTINATION.Reg, volatile.LoadUint32(&o.DESTINATION.Reg)&^(0x1)|value)
}
func (o *XTS_AES_Type) GetDESTINATION() uint32 {
	return volatile.LoadUint32(&o.DESTINATION.Reg) & 0x1
}

// XTS_AES.PHYSICAL_ADDRESS: XTS-AES physical address register
func (o *XTS_AES_Type) SetPHYSICAL_ADDRESS(value uint32) {
	volatile.StoreUint32(&o.PHYSICAL_ADDRESS.Reg, volatile.LoadUint32(&o.PHYSICAL_ADDRESS.Reg)&^(0x3fffffff)|value)
}
func (o *XTS_AES_Type) GetPHYSICAL_ADDRESS() uint32 {
	return volatile.LoadUint32(&o.PHYSICAL_ADDRESS.Reg) & 0x3fffffff
}

// XTS_AES.TRIGGER: XTS-AES trigger register
func (o *XTS_AES_Type) SetTRIGGER(value uint32) {
	volatile.StoreUint32(&o.TRIGGER.Reg, volatile.LoadUint32(&o.TRIGGER.Reg)&^(0x1)|value)
}
func (o *XTS_AES_Type) GetTRIGGER() uint32 {
	return volatile.LoadUint32(&o.TRIGGER.Reg) & 0x1
}

// XTS_AES.RELEASE: XTS-AES release register
func (o *XTS_AES_Type) SetRELEASE(value uint32) {
	volatile.StoreUint32(&o.RELEASE.Reg, volatile.LoadUint32(&o.RELEASE.Reg)&^(0x1)|value)
}
func (o *XTS_AES_Type) GetRELEASE() uint32 {
	return volatile.LoadUint32(&o.RELEASE.Reg) & 0x1
}

// XTS_AES.DESTROY: XTS-AES destroy register
func (o *XTS_AES_Type) SetDESTROY(value uint32) {
	volatile.StoreUint32(&o.DESTROY.Reg, volatile.LoadUint32(&o.DESTROY.Reg)&^(0x1)|value)
}
func (o *XTS_AES_Type) GetDESTROY() uint32 {
	return volatile.LoadUint32(&o.DESTROY.Reg) & 0x1
}

// XTS_AES.STATE: XTS-AES status register
func (o *XTS_AES_Type) SetSTATE(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x3)|value)
}
func (o *XTS_AES_Type) GetSTATE() uint32 {
	return volatile.LoadUint32(&o.STATE.Reg) & 0x3
}

// XTS_AES.DATE: XTS-AES version control register
func (o *XTS_AES_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x3fffffff)|value)
}
func (o *XTS_AES_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0x3fffffff
}

// Constants for APB_CTRL: APB (Advanced Peripheral Bus) Controller
const (
	// SYSCLK_CONF: APB_CTRL_SYSCLK_CONF_REG
	// Position of PRE_DIV_CNT field.
	APB_CTRL_SYSCLK_CONF_PRE_DIV_CNT_Pos = 0x0
	// Bit mask of PRE_DIV_CNT field.
	APB_CTRL_SYSCLK_CONF_PRE_DIV_CNT_Msk = 0x3ff
	// Position of CLK_320M_EN field.
	APB_CTRL_SYSCLK_CONF_CLK_320M_EN_Pos = 0xa
	// Bit mask of CLK_320M_EN field.
	APB_CTRL_SYSCLK_CONF_CLK_320M_EN_Msk = 0x400
	// Bit CLK_320M_EN.
	APB_CTRL_SYSCLK_CONF_CLK_320M_EN = 0x400
	// Position of CLK_EN field.
	APB_CTRL_SYSCLK_CONF_CLK_EN_Pos = 0xb
	// Bit mask of CLK_EN field.
	APB_CTRL_SYSCLK_CONF_CLK_EN_Msk = 0x800
	// Bit CLK_EN.
	APB_CTRL_SYSCLK_CONF_CLK_EN = 0x800
	// Position of RST_TICK_CNT field.
	APB_CTRL_SYSCLK_CONF_RST_TICK_CNT_Pos = 0xc
	// Bit mask of RST_TICK_CNT field.
	APB_CTRL_SYSCLK_CONF_RST_TICK_CNT_Msk = 0x1000
	// Bit RST_TICK_CNT.
	APB_CTRL_SYSCLK_CONF_RST_TICK_CNT = 0x1000

	// TICK_CONF: APB_CTRL_TICK_CONF_REG
	// Position of XTAL_TICK_NUM field.
	APB_CTRL_TICK_CONF_XTAL_TICK_NUM_Pos = 0x0
	// Bit mask of XTAL_TICK_NUM field.
	APB_CTRL_TICK_CONF_XTAL_TICK_NUM_Msk = 0xff
	// Position of CK8M_TICK_NUM field.
	APB_CTRL_TICK_CONF_CK8M_TICK_NUM_Pos = 0x8
	// Bit mask of CK8M_TICK_NUM field.
	APB_CTRL_TICK_CONF_CK8M_TICK_NUM_Msk = 0xff00
	// Position of TICK_ENABLE field.
	APB_CTRL_TICK_CONF_TICK_ENABLE_Pos = 0x10
	// Bit mask of TICK_ENABLE field.
	APB_CTRL_TICK_CONF_TICK_ENABLE_Msk = 0x10000
	// Bit TICK_ENABLE.
	APB_CTRL_TICK_CONF_TICK_ENABLE = 0x10000

	// CLK_OUT_EN: APB_CTRL_CLK_OUT_EN_REG
	// Position of CLK20_OEN field.
	APB_CTRL_CLK_OUT_EN_CLK20_OEN_Pos = 0x0
	// Bit mask of CLK20_OEN field.
	APB_CTRL_CLK_OUT_EN_CLK20_OEN_Msk = 0x1
	// Bit CLK20_OEN.
	APB_CTRL_CLK_OUT_EN_CLK20_OEN = 0x1
	// Position of CLK22_OEN field.
	APB_CTRL_CLK_OUT_EN_CLK22_OEN_Pos = 0x1
	// Bit mask of CLK22_OEN field.
	APB_CTRL_CLK_OUT_EN_CLK22_OEN_Msk = 0x2
	// Bit CLK22_OEN.
	APB_CTRL_CLK_OUT_EN_CLK22_OEN = 0x2
	// Position of CLK44_OEN field.
	APB_CTRL_CLK_OUT_EN_CLK44_OEN_Pos = 0x2
	// Bit mask of CLK44_OEN field.
	APB_CTRL_CLK_OUT_EN_CLK44_OEN_Msk = 0x4
	// Bit CLK44_OEN.
	APB_CTRL_CLK_OUT_EN_CLK44_OEN = 0x4
	// Position of CLK_BB_OEN field.
	APB_CTRL_CLK_OUT_EN_CLK_BB_OEN_Pos = 0x3
	// Bit mask of CLK_BB_OEN field.
	APB_CTRL_CLK_OUT_EN_CLK_BB_OEN_Msk = 0x8
	// Bit CLK_BB_OEN.
	APB_CTRL_CLK_OUT_EN_CLK_BB_OEN = 0x8
	// Position of CLK80_OEN field.
	APB_CTRL_CLK_OUT_EN_CLK80_OEN_Pos = 0x4
	// Bit mask of CLK80_OEN field.
	APB_CTRL_CLK_OUT_EN_CLK80_OEN_Msk = 0x10
	// Bit CLK80_OEN.
	APB_CTRL_CLK_OUT_EN_CLK80_OEN = 0x10
	// Position of CLK160_OEN field.
	APB_CTRL_CLK_OUT_EN_CLK160_OEN_Pos = 0x5
	// Bit mask of CLK160_OEN field.
	APB_CTRL_CLK_OUT_EN_CLK160_OEN_Msk = 0x20
	// Bit CLK160_OEN.
	APB_CTRL_CLK_OUT_EN_CLK160_OEN = 0x20
	// Position of CLK_320M_OEN field.
	APB_CTRL_CLK_OUT_EN_CLK_320M_OEN_Pos = 0x6
	// Bit mask of CLK_320M_OEN field.
	APB_CTRL_CLK_OUT_EN_CLK_320M_OEN_Msk = 0x40
	// Bit CLK_320M_OEN.
	APB_CTRL_CLK_OUT_EN_CLK_320M_OEN = 0x40
	// Position of CLK_ADC_INF_OEN field.
	APB_CTRL_CLK_OUT_EN_CLK_ADC_INF_OEN_Pos = 0x7
	// Bit mask of CLK_ADC_INF_OEN field.
	APB_CTRL_CLK_OUT_EN_CLK_ADC_INF_OEN_Msk = 0x80
	// Bit CLK_ADC_INF_OEN.
	APB_CTRL_CLK_OUT_EN_CLK_ADC_INF_OEN = 0x80
	// Position of CLK_DAC_CPU_OEN field.
	APB_CTRL_CLK_OUT_EN_CLK_DAC_CPU_OEN_Pos = 0x8
	// Bit mask of CLK_DAC_CPU_OEN field.
	APB_CTRL_CLK_OUT_EN_CLK_DAC_CPU_OEN_Msk = 0x100
	// Bit CLK_DAC_CPU_OEN.
	APB_CTRL_CLK_OUT_EN_CLK_DAC_CPU_OEN = 0x100
	// Position of CLK40X_BB_OEN field.
	APB_CTRL_CLK_OUT_EN_CLK40X_BB_OEN_Pos = 0x9
	// Bit mask of CLK40X_BB_OEN field.
	APB_CTRL_CLK_OUT_EN_CLK40X_BB_OEN_Msk = 0x200
	// Bit CLK40X_BB_OEN.
	APB_CTRL_CLK_OUT_EN_CLK40X_BB_OEN = 0x200
	// Position of CLK_XTAL_OEN field.
	APB_CTRL_CLK_OUT_EN_CLK_XTAL_OEN_Pos = 0xa
	// Bit mask of CLK_XTAL_OEN field.
	APB_CTRL_CLK_OUT_EN_CLK_XTAL_OEN_Msk = 0x400
	// Bit CLK_XTAL_OEN.
	APB_CTRL_CLK_OUT_EN_CLK_XTAL_OEN = 0x400

	// WIFI_BB_CFG: APB_CTRL_WIFI_BB_CFG_REG
	// Position of WIFI_BB_CFG field.
	APB_CTRL_WIFI_BB_CFG_WIFI_BB_CFG_Pos = 0x0
	// Bit mask of WIFI_BB_CFG field.
	APB_CTRL_WIFI_BB_CFG_WIFI_BB_CFG_Msk = 0xffffffff

	// WIFI_BB_CFG_2: APB_CTRL_WIFI_BB_CFG_2_REG
	// Position of WIFI_BB_CFG_2 field.
	APB_CTRL_WIFI_BB_CFG_2_WIFI_BB_CFG_2_Pos = 0x0
	// Bit mask of WIFI_BB_CFG_2 field.
	APB_CTRL_WIFI_BB_CFG_2_WIFI_BB_CFG_2_Msk = 0xffffffff

	// WIFI_CLK_EN: APB_CTRL_WIFI_CLK_EN_REG
	// Position of WIFI_CLK_EN field.
	APB_CTRL_WIFI_CLK_EN_WIFI_CLK_EN_Pos = 0x0
	// Bit mask of WIFI_CLK_EN field.
	APB_CTRL_WIFI_CLK_EN_WIFI_CLK_EN_Msk = 0xffffffff

	// WIFI_RST_EN: APB_CTRL_WIFI_RST_EN_REG
	// Position of WIFI_RST field.
	APB_CTRL_WIFI_RST_EN_WIFI_RST_Pos = 0x0
	// Bit mask of WIFI_RST field.
	APB_CTRL_WIFI_RST_EN_WIFI_RST_Msk = 0xffffffff

	// HOST_INF_SEL: APB_CTRL_HOST_INF_SEL_REG
	// Position of PERI_IO_SWAP field.
	APB_CTRL_HOST_INF_SEL_PERI_IO_SWAP_Pos = 0x0
	// Bit mask of PERI_IO_SWAP field.
	APB_CTRL_HOST_INF_SEL_PERI_IO_SWAP_Msk = 0xff

	// EXT_MEM_PMS_LOCK: APB_CTRL_EXT_MEM_PMS_LOCK_REG
	// Position of EXT_MEM_PMS_LOCK field.
	APB_CTRL_EXT_MEM_PMS_LOCK_EXT_MEM_PMS_LOCK_Pos = 0x0
	// Bit mask of EXT_MEM_PMS_LOCK field.
	APB_CTRL_EXT_MEM_PMS_LOCK_EXT_MEM_PMS_LOCK_Msk = 0x1
	// Bit EXT_MEM_PMS_LOCK.
	APB_CTRL_EXT_MEM_PMS_LOCK_EXT_MEM_PMS_LOCK = 0x1

	// FLASH_ACE0_ATTR: APB_CTRL_FLASH_ACE0_ATTR_REG
	// Position of FLASH_ACE0_ATTR field.
	APB_CTRL_FLASH_ACE0_ATTR_FLASH_ACE0_ATTR_Pos = 0x0
	// Bit mask of FLASH_ACE0_ATTR field.
	APB_CTRL_FLASH_ACE0_ATTR_FLASH_ACE0_ATTR_Msk = 0x3

	// FLASH_ACE1_ATTR: APB_CTRL_FLASH_ACE1_ATTR_REG
	// Position of FLASH_ACE1_ATTR field.
	APB_CTRL_FLASH_ACE1_ATTR_FLASH_ACE1_ATTR_Pos = 0x0
	// Bit mask of FLASH_ACE1_ATTR field.
	APB_CTRL_FLASH_ACE1_ATTR_FLASH_ACE1_ATTR_Msk = 0x3

	// FLASH_ACE2_ATTR: APB_CTRL_FLASH_ACE2_ATTR_REG
	// Position of FLASH_ACE2_ATTR field.
	APB_CTRL_FLASH_ACE2_ATTR_FLASH_ACE2_ATTR_Pos = 0x0
	// Bit mask of FLASH_ACE2_ATTR field.
	APB_CTRL_FLASH_ACE2_ATTR_FLASH_ACE2_ATTR_Msk = 0x3

	// FLASH_ACE3_ATTR: APB_CTRL_FLASH_ACE3_ATTR_REG
	// Position of FLASH_ACE3_ATTR field.
	APB_CTRL_FLASH_ACE3_ATTR_FLASH_ACE3_ATTR_Pos = 0x0
	// Bit mask of FLASH_ACE3_ATTR field.
	APB_CTRL_FLASH_ACE3_ATTR_FLASH_ACE3_ATTR_Msk = 0x3

	// FLASH_ACE0_ADDR: APB_CTRL_FLASH_ACE0_ADDR_REG
	// Position of S field.
	APB_CTRL_FLASH_ACE0_ADDR_S_Pos = 0x0
	// Bit mask of S field.
	APB_CTRL_FLASH_ACE0_ADDR_S_Msk = 0xffffffff

	// FLASH_ACE1_ADDR: APB_CTRL_FLASH_ACE1_ADDR_REG
	// Position of S field.
	APB_CTRL_FLASH_ACE1_ADDR_S_Pos = 0x0
	// Bit mask of S field.
	APB_CTRL_FLASH_ACE1_ADDR_S_Msk = 0xffffffff

	// FLASH_ACE2_ADDR: APB_CTRL_FLASH_ACE2_ADDR_REG
	// Position of S field.
	APB_CTRL_FLASH_ACE2_ADDR_S_Pos = 0x0
	// Bit mask of S field.
	APB_CTRL_FLASH_ACE2_ADDR_S_Msk = 0xffffffff

	// FLASH_ACE3_ADDR: APB_CTRL_FLASH_ACE3_ADDR_REG
	// Position of S field.
	APB_CTRL_FLASH_ACE3_ADDR_S_Pos = 0x0
	// Bit mask of S field.
	APB_CTRL_FLASH_ACE3_ADDR_S_Msk = 0xffffffff

	// FLASH_ACE0_SIZE: APB_CTRL_FLASH_ACE0_SIZE_REG
	// Position of FLASH_ACE0_SIZE field.
	APB_CTRL_FLASH_ACE0_SIZE_FLASH_ACE0_SIZE_Pos = 0x0
	// Bit mask of FLASH_ACE0_SIZE field.
	APB_CTRL_FLASH_ACE0_SIZE_FLASH_ACE0_SIZE_Msk = 0x1fff

	// FLASH_ACE1_SIZE: APB_CTRL_FLASH_ACE1_SIZE_REG
	// Position of FLASH_ACE1_SIZE field.
	APB_CTRL_FLASH_ACE1_SIZE_FLASH_ACE1_SIZE_Pos = 0x0
	// Bit mask of FLASH_ACE1_SIZE field.
	APB_CTRL_FLASH_ACE1_SIZE_FLASH_ACE1_SIZE_Msk = 0x1fff

	// FLASH_ACE2_SIZE: APB_CTRL_FLASH_ACE2_SIZE_REG
	// Position of FLASH_ACE2_SIZE field.
	APB_CTRL_FLASH_ACE2_SIZE_FLASH_ACE2_SIZE_Pos = 0x0
	// Bit mask of FLASH_ACE2_SIZE field.
	APB_CTRL_FLASH_ACE2_SIZE_FLASH_ACE2_SIZE_Msk = 0x1fff

	// FLASH_ACE3_SIZE: APB_CTRL_FLASH_ACE3_SIZE_REG
	// Position of FLASH_ACE3_SIZE field.
	APB_CTRL_FLASH_ACE3_SIZE_FLASH_ACE3_SIZE_Pos = 0x0
	// Bit mask of FLASH_ACE3_SIZE field.
	APB_CTRL_FLASH_ACE3_SIZE_FLASH_ACE3_SIZE_Msk = 0x1fff

	// SPI_MEM_PMS_CTRL: APB_CTRL_SPI_MEM_PMS_CTRL_REG
	// Position of SPI_MEM_REJECT_INT field.
	APB_CTRL_SPI_MEM_PMS_CTRL_SPI_MEM_REJECT_INT_Pos = 0x0
	// Bit mask of SPI_MEM_REJECT_INT field.
	APB_CTRL_SPI_MEM_PMS_CTRL_SPI_MEM_REJECT_INT_Msk = 0x1
	// Bit SPI_MEM_REJECT_INT.
	APB_CTRL_SPI_MEM_PMS_CTRL_SPI_MEM_REJECT_INT = 0x1
	// Position of SPI_MEM_REJECT_CLR field.
	APB_CTRL_SPI_MEM_PMS_CTRL_SPI_MEM_REJECT_CLR_Pos = 0x1
	// Bit mask of SPI_MEM_REJECT_CLR field.
	APB_CTRL_SPI_MEM_PMS_CTRL_SPI_MEM_REJECT_CLR_Msk = 0x2
	// Bit SPI_MEM_REJECT_CLR.
	APB_CTRL_SPI_MEM_PMS_CTRL_SPI_MEM_REJECT_CLR = 0x2
	// Position of SPI_MEM_REJECT_CDE field.
	APB_CTRL_SPI_MEM_PMS_CTRL_SPI_MEM_REJECT_CDE_Pos = 0x2
	// Bit mask of SPI_MEM_REJECT_CDE field.
	APB_CTRL_SPI_MEM_PMS_CTRL_SPI_MEM_REJECT_CDE_Msk = 0x7c

	// SPI_MEM_REJECT_ADDR: APB_CTRL_SPI_MEM_REJECT_ADDR_REG
	// Position of SPI_MEM_REJECT_ADDR field.
	APB_CTRL_SPI_MEM_REJECT_ADDR_SPI_MEM_REJECT_ADDR_Pos = 0x0
	// Bit mask of SPI_MEM_REJECT_ADDR field.
	APB_CTRL_SPI_MEM_REJECT_ADDR_SPI_MEM_REJECT_ADDR_Msk = 0xffffffff

	// SDIO_CTRL: APB_CTRL_SDIO_CTRL_REG
	// Position of SDIO_WIN_ACCESS_EN field.
	APB_CTRL_SDIO_CTRL_SDIO_WIN_ACCESS_EN_Pos = 0x0
	// Bit mask of SDIO_WIN_ACCESS_EN field.
	APB_CTRL_SDIO_CTRL_SDIO_WIN_ACCESS_EN_Msk = 0x1
	// Bit SDIO_WIN_ACCESS_EN.
	APB_CTRL_SDIO_CTRL_SDIO_WIN_ACCESS_EN = 0x1

	// REDCY_SIG0: APB_CTRL_REDCY_SIG0_REG_REG
	// Position of REDCY_SIG0 field.
	APB_CTRL_REDCY_SIG0_REDCY_SIG0_Pos = 0x0
	// Bit mask of REDCY_SIG0 field.
	APB_CTRL_REDCY_SIG0_REDCY_SIG0_Msk = 0x7fffffff
	// Position of REDCY_ANDOR field.
	APB_CTRL_REDCY_SIG0_REDCY_ANDOR_Pos = 0x1f
	// Bit mask of REDCY_ANDOR field.
	APB_CTRL_REDCY_SIG0_REDCY_ANDOR_Msk = 0x80000000
	// Bit REDCY_ANDOR.
	APB_CTRL_REDCY_SIG0_REDCY_ANDOR = 0x80000000

	// REDCY_SIG1: APB_CTRL_REDCY_SIG1_REG_REG
	// Position of REDCY_SIG1 field.
	APB_CTRL_REDCY_SIG1_REDCY_SIG1_Pos = 0x0
	// Bit mask of REDCY_SIG1 field.
	APB_CTRL_REDCY_SIG1_REDCY_SIG1_Msk = 0x7fffffff
	// Position of REDCY_NANDOR field.
	APB_CTRL_REDCY_SIG1_REDCY_NANDOR_Pos = 0x1f
	// Bit mask of REDCY_NANDOR field.
	APB_CTRL_REDCY_SIG1_REDCY_NANDOR_Msk = 0x80000000
	// Bit REDCY_NANDOR.
	APB_CTRL_REDCY_SIG1_REDCY_NANDOR = 0x80000000

	// FRONT_END_MEM_PD: APB_CTRL_FRONT_END_MEM_PD_REG
	// Position of AGC_MEM_FORCE_PU field.
	APB_CTRL_FRONT_END_MEM_PD_AGC_MEM_FORCE_PU_Pos = 0x0
	// Bit mask of AGC_MEM_FORCE_PU field.
	APB_CTRL_FRONT_END_MEM_PD_AGC_MEM_FORCE_PU_Msk = 0x1
	// Bit AGC_MEM_FORCE_PU.
	APB_CTRL_FRONT_END_MEM_PD_AGC_MEM_FORCE_PU = 0x1
	// Position of AGC_MEM_FORCE_PD field.
	APB_CTRL_FRONT_END_MEM_PD_AGC_MEM_FORCE_PD_Pos = 0x1
	// Bit mask of AGC_MEM_FORCE_PD field.
	APB_CTRL_FRONT_END_MEM_PD_AGC_MEM_FORCE_PD_Msk = 0x2
	// Bit AGC_MEM_FORCE_PD.
	APB_CTRL_FRONT_END_MEM_PD_AGC_MEM_FORCE_PD = 0x2
	// Position of PBUS_MEM_FORCE_PU field.
	APB_CTRL_FRONT_END_MEM_PD_PBUS_MEM_FORCE_PU_Pos = 0x2
	// Bit mask of PBUS_MEM_FORCE_PU field.
	APB_CTRL_FRONT_END_MEM_PD_PBUS_MEM_FORCE_PU_Msk = 0x4
	// Bit PBUS_MEM_FORCE_PU.
	APB_CTRL_FRONT_END_MEM_PD_PBUS_MEM_FORCE_PU = 0x4
	// Position of PBUS_MEM_FORCE_PD field.
	APB_CTRL_FRONT_END_MEM_PD_PBUS_MEM_FORCE_PD_Pos = 0x3
	// Bit mask of PBUS_MEM_FORCE_PD field.
	APB_CTRL_FRONT_END_MEM_PD_PBUS_MEM_FORCE_PD_Msk = 0x8
	// Bit PBUS_MEM_FORCE_PD.
	APB_CTRL_FRONT_END_MEM_PD_PBUS_MEM_FORCE_PD = 0x8
	// Position of DC_MEM_FORCE_PU field.
	APB_CTRL_FRONT_END_MEM_PD_DC_MEM_FORCE_PU_Pos = 0x4
	// Bit mask of DC_MEM_FORCE_PU field.
	APB_CTRL_FRONT_END_MEM_PD_DC_MEM_FORCE_PU_Msk = 0x10
	// Bit DC_MEM_FORCE_PU.
	APB_CTRL_FRONT_END_MEM_PD_DC_MEM_FORCE_PU = 0x10
	// Position of DC_MEM_FORCE_PD field.
	APB_CTRL_FRONT_END_MEM_PD_DC_MEM_FORCE_PD_Pos = 0x5
	// Bit mask of DC_MEM_FORCE_PD field.
	APB_CTRL_FRONT_END_MEM_PD_DC_MEM_FORCE_PD_Msk = 0x20
	// Bit DC_