/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.internal.xml;

import java.io.IOException;
import java.io.OutputStream;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.data.SessionInfo;
import org.jacoco.report.internal.xml.XMLElement;

public class ReportElement
extends XMLElement {
    private static final String PUBID = "-//JACOCO//DTD Report 1.1//EN";
    private static final String SYSTEM = "report.dtd";

    public ReportElement(String name, OutputStream output, String encoding) throws IOException {
        super("report", PUBID, SYSTEM, true, encoding, output);
        this.attr("name", name);
    }

    private ReportElement(String name, ReportElement parent) throws IOException {
        super(name, parent);
    }

    public ReportElement element(String name) throws IOException {
        return new ReportElement(name, this);
    }

    private ReportElement namedElement(String elementName, String name) throws IOException {
        ReportElement element = this.element(elementName);
        element.attr("name", name);
        return element;
    }

    public void sessioninfo(SessionInfo info) throws IOException {
        ReportElement sessioninfo = this.element("sessioninfo");
        sessioninfo.attr("id", info.getId());
        sessioninfo.attr("start", info.getStartTimeStamp());
        sessioninfo.attr("dump", info.getDumpTimeStamp());
    }

    public ReportElement group(String name) throws IOException {
        return this.namedElement("group", name);
    }

    public ReportElement packageElement(String name) throws IOException {
        return this.namedElement("package", name);
    }

    public ReportElement classElement(IClassCoverage coverage) throws IOException {
        ReportElement element = this.namedElement("class", coverage.getName());
        element.attr("sourcefilename", coverage.getSourceFileName());
        return element;
    }

    public ReportElement method(IMethodCoverage coverage) throws IOException {
        ReportElement element = this.namedElement("method", coverage.getName());
        element.attr("desc", coverage.getDesc());
        int line = coverage.getFirstLine();
        if (line != -1) {
            element.attr("line", line);
        }
        return element;
    }

    public ReportElement sourcefile(String name) throws IOException {
        return this.namedElement("sourcefile", name);
    }

    public void line(int nr, ILine line) throws IOException {
        ReportElement element = this.element("line");
        element.attr("nr", nr);
        ReportElement.counterAttributes(element, "mi", "ci", line.getInstructionCounter());
        ReportElement.counterAttributes(element, "mb", "cb", line.getBranchCounter());
    }

    public void counter(ICoverageNode.CounterEntity counterEntity, ICounter counter) throws IOException {
        ReportElement counterNode = this.element("counter");
        counterNode.attr("type", counterEntity.name());
        ReportElement.counterAttributes(counterNode, "missed", "covered", counter);
    }

    private static void counterAttributes(XMLElement element, String missedattr, String coveredattr, ICounter counter) throws IOException {
        element.attr(missedattr, counter.getMissedCount());
        element.attr(coveredattr, counter.getCoveredCount());
    }
}

