/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.dict;

import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.db2.editors.DB2ObjectType;
import org.jkiss.dbeaver.model.DBPNamedObject;

public enum DB2TableType implements DBPNamedObject
{
    A("Alias", DB2ObjectType.ALIAS),
    G("Created temporary table", DB2ObjectType.TABLE),
    H("Hierarchy table", DB2ObjectType.TABLE),
    L("Detached table", DB2ObjectType.TABLE),
    N("Nickname", DB2ObjectType.NICKNAME),
    S("Materialized Query Table", DB2ObjectType.MQT),
    T("Table (untyped)", DB2ObjectType.TABLE),
    U("Inoperative", DB2ObjectType.TABLE),
    V("View (untyped)", DB2ObjectType.VIEW),
    W("Typed view", DB2ObjectType.VIEW);

    private String description;
    private DB2ObjectType db2ObjectType;
    private static final Map<DB2ObjectType, String> IN_CLAUSE_CACHE;

    static {
        IN_CLAUSE_CACHE = new HashMap<DB2ObjectType, String>();
    }

    private DB2TableType(String description, DB2ObjectType db2ObjectType) {
        this.description = description;
        this.db2ObjectType = db2ObjectType;
    }

    public String toString() {
        return this.description;
    }

    public static String getInClause(DB2ObjectType objectType) {
        String inClause = IN_CLAUSE_CACHE.get((Object)objectType);
        if (inClause == null) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("(");
            DB2TableType[] dB2TableTypeArray = DB2TableType.values();
            int n = dB2TableTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DB2TableType db2TableType = dB2TableTypeArray[n2];
                if (db2TableType.getDb2ObjectType() == objectType) {
                    sb.append("'").append(db2TableType.name()).append("'");
                    sb.append(",");
                }
                ++n2;
            }
            inClause = "()";
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
                sb.append(")");
                inClause = sb.toString();
            }
            IN_CLAUSE_CACHE.put(objectType, inClause);
        }
        return inClause;
    }

    @NotNull
    public String getName() {
        return this.description;
    }

    public DB2ObjectType getDb2ObjectType() {
        return this.db2ObjectType;
    }
}

