/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.composite;

import com.google.common.base.Preconditions;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.initialization.ConfigurableIncludedBuild;
import org.gradle.api.tasks.TaskReference;
import org.gradle.internal.ImmutableActionSet;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class DefaultConfigurableIncludedBuild
implements ConfigurableIncludedBuild {
    private final File projectDir;
    private String name;
    private ImmutableActionSet<DependencySubstitutions> dependencySubstitutionActions = ImmutableActionSet.empty();

    public DefaultConfigurableIncludedBuild(File projectDir) {
        this.projectDir = projectDir;
        this.name = projectDir.getName();
    }

    public @NonNull String getName() {
        return this.name;
    }

    public void setName(@NonNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name must not be null");
        this.name = name;
    }

    public @NonNull File getProjectDir() {
        return this.projectDir;
    }

    public void dependencySubstitution(@NonNull Action<? super DependencySubstitutions> action) {
        Preconditions.checkNotNull(action, (Object)"action must not be null");
        this.dependencySubstitutionActions = this.dependencySubstitutionActions.add(action);
    }

    public @NonNull TaskReference task(@Nullable String path) {
        throw new IllegalStateException("IncludedBuild.task() cannot be used while configuring the included build");
    }

    public Action<DependencySubstitutions> getDependencySubstitutionAction() {
        return this.dependencySubstitutionActions;
    }
}

