/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.bc;

import com.jcraft.jsch.JSchException;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;

public class Argon2
implements com.jcraft.jsch.Argon2 {
    private Argon2BytesGenerator generator;

    @Override
    public void init(byte[] salt, int iteration, int type, byte[] additional, byte[] secret, int memory, int parallelism, int version) throws Exception {
        switch (type) {
            case 0: {
                type = 0;
                break;
            }
            case 1: {
                type = 1;
                break;
            }
            case 2: {
                type = 2;
                break;
            }
            default: {
                throw new JSchException("Invalid argon2 type.");
            }
        }
        switch (version) {
            case 16: {
                version = 16;
                break;
            }
            case 19: {
                version = 19;
                break;
            }
            default: {
                throw new JSchException("Invalid argon2 version.");
            }
        }
        try {
            Argon2Parameters params = new Argon2Parameters.Builder(type).withSalt(salt).withAdditional(additional).withSecret(secret).withIterations(iteration).withMemoryAsKB(memory).withParallelism(parallelism).withVersion(version).build();
            this.generator = new Argon2BytesGenerator();
            this.generator.init(params);
        }
        catch (NoClassDefFoundError e) {
            throw new JSchException("argon2 unavailable", e);
        }
    }

    @Override
    public byte[] getKey(byte[] pass, int size) {
        byte[] key = new byte[size];
        this.generator.generateBytes(pass, key);
        return key;
    }
}

