/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.vector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.MVTTile;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.DownloadPolicy;
import org.openstreetmap.josm.data.osm.HighlightUpdateListener;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.data.osm.UploadPolicy;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.event.IDataSelectionEventSource;
import org.openstreetmap.josm.data.osm.event.IDataSelectionListener;
import org.openstreetmap.josm.data.vector.DataStore;
import org.openstreetmap.josm.data.vector.VectorDataStore;
import org.openstreetmap.josm.data.vector.VectorNode;
import org.openstreetmap.josm.data.vector.VectorPrimitive;
import org.openstreetmap.josm.data.vector.VectorRelation;
import org.openstreetmap.josm.data.vector.VectorWay;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public class VectorDataSet
implements OsmData<VectorPrimitive, VectorNode, VectorWay, VectorRelation>,
IDataSelectionEventSource<VectorPrimitive, VectorNode, VectorWay, VectorRelation, VectorDataSet> {
    private final Map<Integer, Storage<MVTTile>> dataStoreMap = new ConcurrentHashMap<Integer, Storage<MVTTile>>();
    private final VectorDataStore customDataStore = new VectorDataStore();
    private final ListenerList<HighlightUpdateListener> highlightUpdateListenerListenerList = ListenerList.create();
    private final ListenerList<DataSelectionListener> dataSelectionListenerListenerList = ListenerList.create();
    private boolean lock = true;
    private String name;
    private short mappaintCacheIdx = 1;
    private final Object selectionLock = new Object();
    private Set<PrimitiveId> currentSelectedPrimitives = Collections.emptySet();
    private final ListenerList<IDataSelectionListener<VectorPrimitive, VectorNode, VectorWay, VectorRelation, VectorDataSet>> listeners = ListenerList.create();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected static final float DUPE_NODE_DISTANCE = 1.0E-7f;
    private int zoom;
    private DownloadPolicy downloadPolicy = DownloadPolicy.NORMAL;
    private UploadPolicy uploadPolicy = UploadPolicy.BLOCKED;
    private ElemStyles styles;
    private final Collection<PrimitiveId> highlighted = new HashSet<PrimitiveId>();

    @Override
    public Collection<DataSource> getDataSources() {
        return Collections.emptyList();
    }

    @Override
    public void lock() {
        this.lock = true;
    }

    @Override
    public void unlock() {
        this.lock = false;
    }

    @Override
    public boolean isLocked() {
        return this.lock;
    }

    @Override
    public String getVersion() {
        return "8";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void addPrimitive(VectorPrimitive primitive) {
        VectorDataSet.tryWrite(this.readWriteLock, () -> {
            this.customDataStore.addPrimitive(primitive);
            primitive.setDataSet(this);
        });
    }

    public void removePrimitive(VectorPrimitive primitive) {
        this.customDataStore.removePrimitive(primitive);
        primitive.setDataSet(null);
    }

    @Override
    public void clear() {
        this.dataStoreMap.clear();
    }

    @Override
    public List<VectorNode> searchNodes(BBox bbox) {
        return VectorDataSet.tryRead(this.readWriteLock, () -> {
            Storage dataStore = this.getBestZoomDataStore().orElse(null);
            Stream dataStoreStream = dataStore != null ? dataStore.stream().map(MVTTile::getData) : Stream.empty();
            return Stream.concat(dataStoreStream, Stream.of(this.customDataStore)).map(DataStore::getStore).flatMap(store -> store.searchNodes(bbox).stream()).collect(Collectors.toList());
        }).orElseGet(Collections::emptyList);
    }

    @Override
    public boolean containsNode(VectorNode vectorNode) {
        return VectorDataSet.tryRead(this.readWriteLock, () -> {
            Storage dataStore = this.getBestZoomDataStore().orElse(null);
            Stream dataStoreStream = dataStore != null ? dataStore.stream().map(MVTTile::getData) : Stream.empty();
            return Stream.concat(dataStoreStream, Stream.of(this.customDataStore)).map(DataStore::getStore).anyMatch(store -> store.containsNode(vectorNode));
        }).orElse(Boolean.FALSE);
    }

    @Override
    public List<VectorWay> searchWays(BBox bbox) {
        return VectorDataSet.tryRead(this.readWriteLock, () -> {
            Storage dataStore = this.getBestZoomDataStore().orElse(null);
            Stream dataStoreStream = dataStore != null ? dataStore.stream().map(MVTTile::getData) : Stream.empty();
            return Stream.concat(dataStoreStream, Stream.of(this.customDataStore)).map(DataStore::getStore).flatMap(store -> store.searchWays(bbox).stream()).collect(Collectors.toList());
        }).orElseGet(Collections::emptyList);
    }

    @Override
    public boolean containsWay(VectorWay vectorWay) {
        return VectorDataSet.tryRead(this.readWriteLock, () -> {
            Storage dataStore = this.getBestZoomDataStore().orElse(null);
            Stream dataStoreStream = dataStore != null ? dataStore.stream().map(MVTTile::getData) : Stream.empty();
            return Stream.concat(dataStoreStream, Stream.of(this.customDataStore)).map(DataStore::getStore).anyMatch(store -> store.containsWay(vectorWay));
        }).orElse(Boolean.FALSE);
    }

    @Override
    public List<VectorRelation> searchRelations(BBox bbox) {
        return VectorDataSet.tryRead(this.readWriteLock, () -> {
            Storage dataStore = this.getBestZoomDataStore().orElse(null);
            Stream dataStoreStream = dataStore != null ? dataStore.stream().map(MVTTile::getData) : Stream.empty();
            return Stream.concat(dataStoreStream, Stream.of(this.customDataStore)).map(DataStore::getStore).flatMap(store -> store.searchRelations(bbox).stream()).collect(Collectors.toList());
        }).orElseGet(Collections::emptyList);
    }

    @Override
    public boolean containsRelation(VectorRelation vectorRelation) {
        return VectorDataSet.tryRead(this.readWriteLock, () -> {
            Storage dataStore = this.getBestZoomDataStore().orElse(null);
            Stream dataStoreStream = dataStore != null ? dataStore.stream().map(MVTTile::getData) : Stream.empty();
            return Stream.concat(dataStoreStream, Stream.of(this.customDataStore)).map(DataStore::getStore).anyMatch(store -> store.containsRelation(vectorRelation));
        }).orElse(Boolean.FALSE);
    }

    @Override
    public VectorPrimitive getPrimitiveById(PrimitiveId primitiveId) {
        return this.getPrimitivesById(primitiveId).findFirst().orElse(null);
    }

    public Stream<VectorPrimitive> getPrimitivesById(PrimitiveId ... primitiveIds) {
        Storage dataStore = this.getBestZoomDataStore().orElse(null);
        return Stream.concat(dataStore != null ? dataStore.stream().map(MVTTile::getData) : Stream.empty(), Stream.of(this.customDataStore)).map(DataStore::getPrimitivesMap).flatMap(m -> Stream.of(primitiveIds).map(m::get)).filter(Objects::nonNull);
    }

    @Override
    public <T extends VectorPrimitive> Collection<T> getPrimitives(Predicate<? super VectorPrimitive> predicate) {
        Collection primitives = VectorDataSet.tryRead(this.readWriteLock, () -> {
            Storage dataStore = this.getBestZoomDataStore().orElse(null);
            Stream dataStoreStream = dataStore != null ? dataStore.stream().map(MVTTile::getData) : Stream.empty();
            return Stream.concat(dataStoreStream, Stream.of(this.customDataStore)).map(DataStore::getAllPrimitives).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        }).orElseGet(Collections::emptyList);
        return new SubclassFilteredCollection(primitives, predicate);
    }

    @Override
    public Collection<VectorNode> getNodes() {
        return this.getPrimitives((Predicate<? super VectorPrimitive>)((Predicate<VectorPrimitive>)VectorNode.class::isInstance));
    }

    @Override
    public Collection<VectorWay> getWays() {
        return this.getPrimitives((Predicate<? super VectorPrimitive>)((Predicate<VectorPrimitive>)VectorWay.class::isInstance));
    }

    @Override
    public Collection<VectorRelation> getRelations() {
        return this.getPrimitives((Predicate<? super VectorPrimitive>)((Predicate<VectorPrimitive>)VectorRelation.class::isInstance));
    }

    @Override
    public DownloadPolicy getDownloadPolicy() {
        return this.downloadPolicy;
    }

    @Override
    public void setDownloadPolicy(DownloadPolicy downloadPolicy) {
        this.downloadPolicy = downloadPolicy;
    }

    @Override
    public UploadPolicy getUploadPolicy() {
        return this.uploadPolicy;
    }

    @Override
    public void setUploadPolicy(UploadPolicy uploadPolicy) {
        this.uploadPolicy = uploadPolicy;
    }

    @Override
    public Lock getReadLock() {
        return this.readWriteLock.readLock();
    }

    @Override
    public Collection<WaySegment> getHighlightedVirtualNodes() {
        return Collections.emptyList();
    }

    @Override
    public void setHighlightedVirtualNodes(Collection<WaySegment> waySegments) {
    }

    @Override
    public Collection<WaySegment> getHighlightedWaySegments() {
        return Collections.emptyList();
    }

    @Override
    public void setHighlightedWaySegments(Collection<WaySegment> waySegments) {
    }

    public void setHighlighted(Collection<PrimitiveId> primitives) {
        this.highlighted.clear();
        this.highlighted.addAll(primitives);
        this.highlightUpdateListenerListenerList.fireEvent(event -> event.highlightUpdated(null));
    }

    public Collection<PrimitiveId> getHighlighted() {
        return Collections.unmodifiableCollection(this.highlighted);
    }

    @Override
    public void addHighlightUpdateListener(HighlightUpdateListener listener) {
        this.highlightUpdateListenerListenerList.addListener(listener);
    }

    @Override
    public void removeHighlightUpdateListener(HighlightUpdateListener listener) {
        this.highlightUpdateListenerListenerList.removeListener(listener);
    }

    @Override
    public Collection<VectorPrimitive> getAllSelected() {
        return VectorDataSet.tryRead(this.readWriteLock, () -> {
            Storage dataStore = this.getBestZoomDataStore().orElse(null);
            Stream dataStoreStream = dataStore != null ? dataStore.stream().map(MVTTile::getData) : Stream.empty();
            return Stream.concat(dataStoreStream, Stream.of(this.customDataStore)).map(DataStore::getPrimitivesMap).flatMap(dataMap -> {
                Map map = dataMap;
                synchronized (map) {
                    return this.currentSelectedPrimitives.stream().map(dataMap::get).filter(Objects::nonNull);
                }
            }).collect(Collectors.toList());
        }).orElseGet(Collections::emptyList);
    }

    private Optional<Storage<MVTTile>> getBestZoomDataStore() {
        int tZoom;
        int currentZoom = this.zoom;
        if (this.dataStoreMap.containsKey(currentZoom)) {
            return Optional.of(this.dataStoreMap.get(currentZoom));
        }
        for (tZoom = currentZoom + 1; tZoom < currentZoom + 3; ++tZoom) {
            if (!this.dataStoreMap.containsKey(tZoom)) continue;
            return Optional.of(this.dataStoreMap.get(tZoom));
        }
        for (tZoom = currentZoom - 1; tZoom >= 0; --tZoom) {
            if (!this.dataStoreMap.containsKey(tZoom)) continue;
            return Optional.of(this.dataStoreMap.get(tZoom));
        }
        for (tZoom = currentZoom + 3; tZoom < 34; ++tZoom) {
            if (!this.dataStoreMap.containsKey(tZoom)) continue;
            return Optional.of(this.dataStoreMap.get(tZoom));
        }
        return Optional.empty();
    }

    @Override
    public boolean selectionEmpty() {
        return this.currentSelectedPrimitives.isEmpty();
    }

    @Override
    public boolean isSelected(VectorPrimitive osm) {
        return this.currentSelectedPrimitives.contains(osm.getPrimitiveId());
    }

    @Override
    public void toggleSelected(Collection<? extends PrimitiveId> osm) {
        this.toggleSelectedImpl(osm.stream());
    }

    @Override
    public void toggleSelected(PrimitiveId ... osm) {
        this.toggleSelectedImpl(Stream.of(osm));
    }

    private void toggleSelectedImpl(Stream<? extends PrimitiveId> osm) {
        this.doSelectionChange(old -> new IDataSelectionListener.SelectionToggleEvent(this, (Set<VectorPrimitive>)old, osm.flatMap(xva$0 -> this.getPrimitivesById((PrimitiveId)xva$0)).filter(Objects::nonNull)));
    }

    @Override
    public void setSelected(Collection<? extends PrimitiveId> selection) {
        this.setSelectedImpl(selection.stream());
    }

    @Override
    public void setSelected(PrimitiveId ... osm) {
        this.setSelectedImpl(Stream.of(osm));
    }

    private void setSelectedImpl(Stream<? extends PrimitiveId> osm) {
        this.doSelectionChange(old -> new IDataSelectionListener.SelectionReplaceEvent(this, (Set<VectorPrimitive>)old, osm.filter(Objects::nonNull).flatMap(xva$0 -> this.getPrimitivesById((PrimitiveId)xva$0)).filter(Objects::nonNull)));
    }

    @Override
    public void addSelected(Collection<? extends PrimitiveId> selection) {
        this.addSelectedImpl(selection.stream());
    }

    @Override
    public void addSelected(PrimitiveId ... osm) {
        this.addSelectedImpl(Stream.of(osm));
    }

    private void addSelectedImpl(Stream<? extends PrimitiveId> osm) {
        this.doSelectionChange(old -> new IDataSelectionListener.SelectionAddEvent(this, (Set<VectorPrimitive>)old, osm.flatMap(xva$0 -> this.getPrimitivesById((PrimitiveId)xva$0)).filter(Objects::nonNull)));
    }

    @Override
    public void clearSelection(PrimitiveId ... osm) {
        this.clearSelectionImpl(Stream.of(osm));
    }

    @Override
    public void clearSelection(Collection<? extends PrimitiveId> list) {
        this.clearSelectionImpl(list.stream());
    }

    @Override
    public void clearSelection() {
        this.clearSelectionImpl(new ArrayList<PrimitiveId>(this.currentSelectedPrimitives).stream());
    }

    private void clearSelectionImpl(Stream<? extends PrimitiveId> osm) {
        this.doSelectionChange(old -> new IDataSelectionListener.SelectionRemoveEvent(this, (Set<VectorPrimitive>)old, osm.flatMap(xva$0 -> this.getPrimitivesById((PrimitiveId)xva$0)).filter(Objects::nonNull)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSelectionChange(Function<Set<VectorPrimitive>, IDataSelectionListener.SelectionChangeEvent<VectorPrimitive, VectorNode, VectorWay, VectorRelation, VectorDataSet>> command) {
        Object object = this.selectionLock;
        synchronized (object) {
            IDataSelectionListener.SelectionChangeEvent<VectorPrimitive, VectorNode, VectorWay, VectorRelation, VectorDataSet> event = command.apply(this.currentSelectedPrimitives.stream().map(this::getPrimitiveById).collect(Collectors.toSet()));
            if (event.isNop()) {
                return false;
            }
            this.currentSelectedPrimitives = event.getSelection().stream().map(IPrimitive::getPrimitiveId).collect(Collectors.toCollection(LinkedHashSet::new));
            this.listeners.fireEvent(l -> l.selectionChanged(event));
            return true;
        }
    }

    @Override
    public void addSelectionListener(DataSelectionListener listener) {
        this.dataSelectionListenerListenerList.addListener(listener);
    }

    @Override
    public void removeSelectionListener(DataSelectionListener listener) {
        this.dataSelectionListenerListenerList.removeListener(listener);
    }

    public short getMappaintCacheIndex() {
        return this.mappaintCacheIdx;
    }

    @Override
    public void clearMappaintCache() {
        this.mappaintCacheIdx = (short)(this.mappaintCacheIdx + 1);
    }

    public void setZoom(int zoom) {
        if (zoom == this.zoom) {
            return;
        }
        this.zoom = zoom;
        this.clearMappaintCache();
        int[] nearestZoom = new int[]{-1, -1, -1, -1};
        nearestZoom[0] = zoom;
        int[] keys = new ArrayList<Integer>(this.dataStoreMap.keySet()).stream().filter(Objects::nonNull).mapToInt(Integer::intValue).sorted().toArray();
        int index = this.dataStoreMap.containsKey(zoom) ? Arrays.binarySearch(keys, zoom) : -(Arrays.binarySearch(keys, zoom) + 1);
        if (index > 0) {
            nearestZoom[1] = keys[index - 1];
        }
        if (index < keys.length - 2) {
            nearestZoom[2] = keys[index + 1];
        }
    }

    public int getZoom() {
        return this.zoom;
    }

    public void addTileData(MVTTile tile) {
        VectorDataSet.tryWrite(this.readWriteLock, () -> {
            int currentZoom = tile.getZoom();
            Storage dataStore = this.dataStoreMap.computeIfAbsent(currentZoom, tZoom -> new Storage());
            tile.getData().getAllPrimitives().forEach(primitive -> primitive.setDataSet(this));
            dataStore.add(tile);
        });
    }

    private static <T> Optional<T> tryRead(ReentrantReadWriteLock lock, Supplier<T> supplier) {
        try {
            lock.readLock().lockInterruptibly();
            Optional<T> optional = Optional.ofNullable(supplier.get());
            return optional;
        }
        catch (InterruptedException e) {
            Logging.error(e);
            Thread.currentThread().interrupt();
        }
        finally {
            lock.readLock().unlock();
        }
        return Optional.empty();
    }

    private static void tryWrite(ReentrantReadWriteLock lock, Runnable runnable) {
        try {
            lock.writeLock().lockInterruptibly();
            runnable.run();
        }
        catch (InterruptedException e) {
            Logging.error(e);
            Thread.currentThread().interrupt();
        }
        finally {
            if (lock.isWriteLockedByCurrentThread()) {
                lock.writeLock().unlock();
            }
        }
    }

    public ElemStyles getStyles() {
        return this.styles;
    }

    public void setStyles(Collection<ElemStyles> styles) {
        this.styles = styles.size() == 1 ? styles.iterator().next() : (!styles.isEmpty() ? new ElemStyles(styles.stream().flatMap(style -> style.getStyleSources().stream()).collect(Collectors.toList())) : null);
    }

    public void setInvisibleLayers(Collection<String> invisibleLayers) {
        String[] currentInvisibleLayers = (String[])invisibleLayers.stream().filter(Objects::nonNull).toArray(String[]::new);
        List<String> temporaryList = Arrays.asList(currentInvisibleLayers);
        this.dataStoreMap.values().stream().flatMap(Collection::stream).map(MVTTile::getData).forEach(dataStore -> dataStore.getAllPrimitives().parallelStream().forEach(primitive -> primitive.setVisible(!temporaryList.contains(primitive.getLayer()))));
    }

    @Override
    public boolean addSelectionListener(IDataSelectionListener<VectorPrimitive, VectorNode, VectorWay, VectorRelation, VectorDataSet> listener) {
        if (!this.listeners.containsListener(listener)) {
            this.listeners.addListener(listener);
        }
        return this.listeners.containsListener(listener);
    }

    @Override
    public boolean removeSelectionListener(IDataSelectionListener<VectorPrimitive, VectorNode, VectorWay, VectorRelation, VectorDataSet> listener) {
        if (this.listeners.containsListener(listener)) {
            this.listeners.removeListener(listener);
        }
        return this.listeners.containsListener(listener);
    }
}

