/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;
import org.jsampler.AudioDeviceModel;
import org.jsampler.CC;
import org.jsampler.DOMUtils;
import org.jsampler.HF;
import org.jsampler.JSI18n;
import org.jsampler.MidiDeviceModel;
import org.jsampler.MidiInstrument;
import org.jsampler.MidiInstrumentMap;
import org.jsampler.SamplerChannelModel;
import org.jsampler.SamplerModel;
import org.jsampler.view.JSChannel;
import org.jsampler.view.JSChannelsPane;
import org.linuxsampler.lscp.AudioOutputChannel;
import org.linuxsampler.lscp.AudioOutputDevice;
import org.linuxsampler.lscp.Client;
import org.linuxsampler.lscp.FxSend;
import org.linuxsampler.lscp.MidiInputDevice;
import org.linuxsampler.lscp.MidiPort;
import org.linuxsampler.lscp.Parameter;
import org.linuxsampler.lscp.SamplerChannel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JSUtils {
    private JSUtils() {
    }

    public static void checkJSamplerHome() {
        File file;
        if (CC.getJSamplerHome() != null && (file = new File(CC.getJSamplerHome())).exists() && file.isDirectory()) {
            return;
        }
        CC.getMainFrame().installJSamplerHome();
    }

    public static void changeJSamplerHome(String string) {
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            HF.showErrorMessage(JSI18n.i18n.getError("CC.JSamplerHomeIsNotDir!"));
            return;
        }
        if (!file.exists() && !file.mkdir()) {
            String string2 = file.getAbsolutePath();
            HF.showErrorMessage(JSI18n.i18n.getError("CC.mkdirFailed", string2));
            return;
        }
        if (CC.getJSamplerHome() == null || string.equals(CC.getJSamplerHome())) {
            CC.setJSamplerHome(file.getAbsolutePath());
            return;
        }
        File file2 = new File(CC.getJSamplerHome());
        if (!file2.exists() || !file2.isDirectory()) {
            CC.setJSamplerHome(file.getAbsolutePath());
            return;
        }
        File[] fileArray = file2.listFiles();
        boolean bl = true;
        if (fileArray != null) {
            String string3 = file.getAbsolutePath() + File.separator;
            for (File file3 : fileArray) {
                if (file3.renameTo(new File(string3 + file3.getName()))) continue;
                bl = false;
            }
        }
        if (bl) {
            file2.delete();
        }
        CC.setJSamplerHome(file.getAbsolutePath());
    }

    public static String exportInstrMapsToLscpScript() {
        StringBuffer stringBuffer = new StringBuffer("# Exported by: ");
        stringBuffer.append("JSampler - a java front-end for LinuxSampler\r\n# Version: ");
        stringBuffer.append("0.9").append("\r\n");
        stringBuffer.append("# Date: ").append(new Date().toString()).append("\r\n\r\n");
        Client client = new Client(true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        client.setPrintOnlyModeOutputStream(byteArrayOutputStream);
        JSUtils.exportInstrMapsToLscpScript(client);
        stringBuffer.append(byteArrayOutputStream.toString());
        byteArrayOutputStream.reset();
        return stringBuffer.toString();
    }

    private static void exportInstrMapsToLscpScript(Client client) {
        try {
            client.removeAllMidiInstrumentMaps();
            MidiInstrumentMap[] midiInstrumentMapArray = CC.getSamplerModel().getMidiInstrumentMaps();
            for (int i = 0; i < midiInstrumentMapArray.length; ++i) {
                client.addMidiInstrumentMap(midiInstrumentMapArray[i].getName());
                JSUtils.exportInstrumentsToLscpScript(i, midiInstrumentMapArray[i], client);
            }
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.FINE, HF.getErrorMessage(exception), exception);
            HF.showErrorMessage(exception);
        }
    }

    private static void exportInstrumentsToLscpScript(int n, MidiInstrumentMap midiInstrumentMap, Client client) throws Exception {
        boolean bl = CC.preferences().getBoolProperty("loadMidiInstrumentsInBackground");
        for (MidiInstrument midiInstrument : midiInstrumentMap.getAllMidiInstruments()) {
            client.mapMidiInstrument(n, midiInstrument.getInfo().getEntry(), midiInstrument.getInfo(), bl);
        }
    }

    public static String exportInstrMapsToText() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        MidiInstrumentMap[] midiInstrumentMapArray = CC.getSamplerModel().getMidiInstrumentMaps();
        for (int i = 0; i < midiInstrumentMapArray.length; ++i) {
            stringBuffer.append("MIDI Instrument Map: ");
            stringBuffer.append(midiInstrumentMapArray[i].getName()).append(string);
            JSUtils.exportInstrumentsToText(midiInstrumentMapArray[i], stringBuffer);
        }
        String string2 = DateFormat.getDateInstance().format(new Date());
        stringBuffer.append("Date: ").append(string2).append(string);
        stringBuffer.append("Exported by: JSampler - a java front-end for LinuxSampler, Version ");
        stringBuffer.append("0.9").append(string);
        return stringBuffer.toString();
    }

    private static void exportInstrumentsToText(MidiInstrumentMap midiInstrumentMap, StringBuffer stringBuffer) {
        int n = -1;
        String string = System.getProperty("line.separator");
        int n2 = CC.preferences().getIntProperty("firstMidiBankNumber");
        int n3 = CC.preferences().getIntProperty("firstMidiProgramNumber");
        for (MidiInstrument midiInstrument : midiInstrumentMap.getAllMidiInstruments()) {
            int n4 = midiInstrument.getInfo().getMidiBank();
            if (n4 != n) {
                n = n4;
                stringBuffer.append(string).append("\tMIDI Bank ");
                stringBuffer.append(n + n2).append(string);
            }
            stringBuffer.append("\t[").append(n + n2).append("] ");
            stringBuffer.append(midiInstrument.getInfo().getMidiProgram() + n3);
            stringBuffer.append(" - ").append(midiInstrument.getName()).append(string);
        }
        stringBuffer.append(string);
    }

    public static String exportInstrMapsToHtml() {
        String string;
        int n;
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("<html>").append(string2);
        stringBuffer.append("<head><title>MIDI Instrument Maps</title></head>");
        stringBuffer.append("<body>").append(string2);
        stringBuffer.append("<h1>MIDI Instrument Maps</h1>").append(string2);
        String string3 = DateFormat.getDateInstance().format(new Date());
        stringBuffer.append("Date: ").append(string3).append("<br>").append(string2);
        stringBuffer.append("Exported by <a href=http://linuxsampler.org/jsampler/manual/html/jsampler.html>");
        stringBuffer.append("JSampler</a> version ");
        stringBuffer.append("0.9").append("<br>").append(string2);
        MidiInstrumentMap[] midiInstrumentMapArray = CC.getSamplerModel().getMidiInstrumentMaps();
        stringBuffer.append("<ol>").append(string2);
        for (n = 0; n < midiInstrumentMapArray.length; ++n) {
            string = JSUtils.toHtmlEscapedText(midiInstrumentMapArray[n].getName());
            stringBuffer.append("<li><a href=#map-").append(n + 1).append(">");
            stringBuffer.append(string).append("</a></li>").append(string2);
        }
        stringBuffer.append("</ol>").append(string2);
        for (n = 0; n < midiInstrumentMapArray.length; ++n) {
            string = JSUtils.toHtmlEscapedText(midiInstrumentMapArray[n].getName());
            stringBuffer.append("<h2><a name=map-").append(n + 1).append(">");
            stringBuffer.append(string).append("</a></h2>").append(string2);
            JSUtils.exportInstrumentsToHtml(n, midiInstrumentMapArray[n], stringBuffer);
        }
        stringBuffer.append(string2).append("</body>").append(string2).append("</html>");
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static void exportInstrumentsToHtml(int n, MidiInstrumentMap midiInstrumentMap, StringBuffer stringBuffer) {
        int n2 = -1;
        String string = System.getProperty("line.separator");
        int n3 = CC.preferences().getIntProperty("firstMidiBankNumber");
        int n4 = CC.preferences().getIntProperty("firstMidiProgramNumber");
        stringBuffer.append("<ol>").append(string);
        for (MidiInstrument midiInstrument : midiInstrumentMap.getAllMidiInstruments()) {
            int n5 = midiInstrument.getInfo().getMidiBank();
            if (n5 == n2) continue;
            n2 = n5;
            String string2 = "map-" + (n + 1) + "-bank-" + (n2 + n3);
            stringBuffer.append(string).append("<li><a href=#").append(string2);
            stringBuffer.append(">MIDI Bank ");
            stringBuffer.append(n2 + n3).append("</a></li>").append(string);
        }
        stringBuffer.append("</ol>").append(string);
        n2 = -1;
        String string3 = "";
        stringBuffer.append("<table border=0>").append(string);
        for (MidiInstrument midiInstrument : midiInstrumentMap.getAllMidiInstruments()) {
            void var7_9;
            int n6 = midiInstrument.getInfo().getMidiBank();
            if (n6 != n2) {
                n2 = n6;
                stringBuffer.append("</table>").append(string);
                String string4 = "map-" + (n + 1) + "-bank-" + (n2 + n3);
                stringBuffer.append(string).append("<h4><a name=").append(string4);
                stringBuffer.append(">MIDI Bank ");
                stringBuffer.append(n2 + n3).append("</a></h4>").append(string);
                stringBuffer.append("<table border=0>").append(string);
            }
            stringBuffer.append("<tr><td align='right'>");
            stringBuffer.append(midiInstrument.getInfo().getMidiProgram() + n4).append(" - </td>");
            String string5 = midiInstrument.getInfo().getFilePath();
            String string6 = "File: " + string5 + ", Index: " + midiInstrument.getInfo().getInstrumentIndex();
            stringBuffer.append("<td><a title='").append(string6).append("'>");
            String string7 = JSUtils.toHtmlEscapedText(midiInstrument.getName());
            stringBuffer.append(string7).append("</a></td>");
            stringBuffer.append("<td>&nbsp;&nbsp;<a href=#").append((String)var7_9).append(">");
            stringBuffer.append("[").append(n2 + n3).append("]</a></td>").append(string);
            stringBuffer.append("</tr>");
        }
        stringBuffer.append("</table>").append(string);
        stringBuffer.append(string);
    }

    private static String toHtmlEscapedText(String string) {
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        return string;
    }

    public static byte[] exportInstrMapsToRGD() {
        Object object;
        Object object2;
        Document document = DOMUtils.createEmptyDocument();
        Element element = document.createElement("rosegarden-data");
        element.setAttribute("version", "1.7.2");
        document.appendChild(element);
        Element element2 = document.createElement("studio");
        element2.setAttribute("thrufilter", "0");
        element2.setAttribute("recordfilter", "0");
        element.appendChild(element2);
        MidiInstrumentMap[] midiInstrumentMapArray = CC.getSamplerModel().getMidiInstrumentMaps();
        for (int i = 0; i < midiInstrumentMapArray.length; ++i) {
            object2 = document.createElement("device");
            object2.setAttribute("id", String.valueOf(i));
            object2.setAttribute("name", "LinuxSampler: " + midiInstrumentMapArray[i].getName());
            object2.setAttribute("type", "midi");
            element2.appendChild((Node)object2);
            object = document.createElement("librarian");
            object.setAttribute("name", "Grigor Iliev");
            object.setAttribute("email", "grigor@grigoriliev.com");
            object2.appendChild((Node)object);
            JSUtils.exportInstrumentsToRGD(midiInstrumentMapArray[i], (Element)object2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DOMUtils.writeObject(document, byteArrayOutputStream);
        object2 = null;
        try {
            int n;
            object = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream((OutputStream)object);
            gZIPOutputStream.write(byteArrayOutputStream.toByteArray());
            gZIPOutputStream.finish();
            byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
            byArray[3] = 8;
            byte[] byArray2 = "x-rosegarden-device".getBytes("US-ASCII");
            int n2 = byArray2.length;
            object2 = new byte[byArray.length + n2 + 1];
            for (n = 0; n < 10; ++n) {
                object2[n] = byArray[n];
            }
            for (n = 0; n < n2; ++n) {
                object2[n + 10] = byArray2[n];
            }
            object2[10 + n2] = false;
            for (n = 10; n < byArray.length; ++n) {
                object2[n + n2 + 1] = byArray[n];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object2;
    }

    private static void exportInstrumentsToRGD(MidiInstrumentMap midiInstrumentMap, Element element) {
        int n = -1;
        int n2 = CC.preferences().getIntProperty("firstMidiBankNumber");
        Element element2 = null;
        for (MidiInstrument midiInstrument : midiInstrumentMap.getAllMidiInstruments()) {
            int n3 = midiInstrument.getInfo().getMidiBank();
            if (n3 != n) {
                n = n3;
                element2 = element.getOwnerDocument().createElement("bank");
                element2.setAttribute("name", "Bank " + (n + n2));
                element2.setAttribute("msb", String.valueOf(n >> 7 & 0x7F));
                element2.setAttribute("lsb", String.valueOf(n & 0x7F));
                element.appendChild(element2);
            }
            Element element3 = element.getOwnerDocument().createElement("program");
            element3.setAttribute("id", String.valueOf(midiInstrument.getInfo().getMidiProgram()));
            element3.setAttribute("name", midiInstrument.getName());
            element2.appendChild(element3);
        }
    }

    public static String exportSessionToLscpScript() {
        int n;
        CC.getSamplerModel().setModified(false);
        StringBuffer stringBuffer = new StringBuffer("# Exported by: ");
        stringBuffer.append("JSampler - a java front-end for LinuxSampler\r\n# Version: ");
        stringBuffer.append("0.9").append("\r\n");
        stringBuffer.append("# Date: ").append(new Date().toString()).append("\r\n\r\n");
        Client client = new Client(true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        client.setPrintOnlyModeOutputStream(byteArrayOutputStream);
        try {
            client.resetSampler();
            stringBuffer.append(byteArrayOutputStream.toString());
            byteArrayOutputStream.reset();
            stringBuffer.append("\r\n");
            client.setVolume(CC.getSamplerModel().getVolume());
            stringBuffer.append(byteArrayOutputStream.toString());
            byteArrayOutputStream.reset();
            stringBuffer.append("\r\n");
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.FINE, HF.getErrorMessage(exception), exception);
        }
        MidiDeviceModel[] midiDeviceModelArray = CC.getSamplerModel().getMidiDevices();
        for (int i = 0; i < midiDeviceModelArray.length; ++i) {
            JSUtils.exportMidiDeviceToLscpScript(midiDeviceModelArray[i].getDeviceInfo(), i, client);
            stringBuffer.append(byteArrayOutputStream.toString());
            byteArrayOutputStream.reset();
            stringBuffer.append("\r\n");
        }
        AudioDeviceModel[] audioDeviceModelArray = CC.getSamplerModel().getAudioDevices();
        for (n = 0; n < audioDeviceModelArray.length; ++n) {
            JSUtils.exportAudioDeviceToLscpScript(audioDeviceModelArray[n].getDeviceInfo(), n, client);
            stringBuffer.append(byteArrayOutputStream.toString());
            byteArrayOutputStream.reset();
            stringBuffer.append("\r\n");
        }
        n = CC.preferences().getBoolProperty("exportMidiMapsToSessionScript") ? 1 : 0;
        if (n != 0) {
            JSUtils.exportInstrMapsToLscpScript(client);
            stringBuffer.append(byteArrayOutputStream.toString());
            byteArrayOutputStream.reset();
            stringBuffer.append("\r\n");
        }
        int n2 = 0;
        for (JSChannelsPane jSChannelsPane : CC.getMainFrame().getChannelsPaneList()) {
            for (JSChannel jSChannel : jSChannelsPane.getChannels()) {
                SamplerChannelModel samplerChannelModel = CC.getSamplerModel().getChannelById(jSChannel.getChannelId());
                JSUtils.exportChannelToLscpScript(samplerChannelModel.getChannelInfo(), n2, client);
                stringBuffer.append(byteArrayOutputStream.toString());
                byteArrayOutputStream.reset();
                stringBuffer.append("\r\n");
                JSUtils.exportFxSendsToLscpScript(samplerChannelModel, n2, client);
                stringBuffer.append(byteArrayOutputStream.toString());
                byteArrayOutputStream.reset();
                stringBuffer.append("\r\n");
                ++n2;
            }
        }
        stringBuffer.append(CC.getViewConfig().exportSessionViewConfig());
        return stringBuffer.toString();
    }

    private static void exportMidiDeviceToLscpScript(MidiInputDevice midiInputDevice, int n, Client client) {
        try {
            String string = midiInputDevice.getDriverName();
            client.createMidiInputDevice(string, midiInputDevice.getAdditionalParameters());
            MidiPort[] midiPortArray = midiInputDevice.getMidiPorts();
            int n2 = midiPortArray.length;
            if (n2 != 1) {
                client.setMidiInputPortCount(n, n2);
            }
            for (int i = 0; i < n2; ++i) {
                Parameter[] parameterArray;
                for (Parameter parameter : parameterArray = midiPortArray[i].getAllParameters()) {
                    if (parameter.isFixed() || parameter.getStringValue().length() <= 0) continue;
                    client.setMidiInputPortParameter(n, i, parameter);
                }
            }
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.FINE, HF.getErrorMessage(exception), exception);
        }
    }

    private static void exportAudioDeviceToLscpScript(AudioOutputDevice audioOutputDevice, int n, Client client) {
        try {
            String string = audioOutputDevice.getDriverName();
            client.createAudioOutputDevice(string, audioOutputDevice.getAllParameters());
            AudioOutputChannel[] audioOutputChannelArray = audioOutputDevice.getAudioChannels();
            for (int i = 0; i < audioOutputChannelArray.length; ++i) {
                Parameter[] parameterArray;
                for (Parameter parameter : parameterArray = audioOutputChannelArray[i].getAllParameters()) {
                    if (parameter.isFixed() || parameter.getStringValue().length() == 0) continue;
                    client.setAudioOutputChannelParameter(n, i, parameter);
                }
            }
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.FINE, HF.getErrorMessage(exception), exception);
        }
    }

    private static void exportChannelToLscpScript(SamplerChannel samplerChannel, int n, Client client) {
        try {
            int n2;
            int n3;
            client.addSamplerChannel();
            SamplerModel samplerModel = CC.getSamplerModel();
            int n4 = samplerChannel.getMidiInputDevice();
            if (n4 != -1) {
                for (n3 = 0; n3 < samplerModel.getMidiDeviceCount(); ++n3) {
                    if (samplerModel.getMidiDevice(n3).getDeviceId() != n4) continue;
                    client.setChannelMidiInputDevice(n, n3);
                    break;
                }
                client.setChannelMidiInputPort(n, samplerChannel.getMidiInputPort());
                client.setChannelMidiInputChannel(n, samplerChannel.getMidiInputChannel());
            }
            if (samplerChannel.getEngine() != null) {
                client.loadSamplerEngine(samplerChannel.getEngine().getName(), n);
                client.setChannelVolume(n, samplerChannel.getVolume());
                n3 = samplerChannel.getMidiInstrumentMapId();
                client.setChannelMidiInstrumentMap(n, n3);
            }
            if ((n4 = samplerChannel.getAudioOutputDevice()) != -1) {
                for (n3 = 0; n3 < samplerModel.getAudioDeviceCount(); ++n3) {
                    if (samplerModel.getAudioDevice(n3).getDeviceId() != n4) continue;
                    client.setChannelAudioOutputDevice(n, n3);
                    break;
                }
                Integer[] integerArray = samplerChannel.getAudioOutputRouting();
                for (n2 = 0; n2 < integerArray.length; ++n2) {
                    int n5 = integerArray[n2];
                    if (n5 == n2) continue;
                    client.setChannelAudioOutputChannel(n, n2, n5);
                }
            }
            String string = samplerChannel.getInstrumentFile();
            n2 = samplerChannel.getInstrumentIndex();
            if (string != null) {
                client.loadInstrument(string, n2, n, true);
            }
            if (samplerChannel.isMuted() && !samplerChannel.isMutedBySolo()) {
                client.setChannelMute(n, true);
            }
            if (samplerChannel.isSoloChannel()) {
                client.setChannelSolo(n, true);
            }
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.FINE, HF.getErrorMessage(exception), exception);
        }
    }

    private static void exportFxSendsToLscpScript(SamplerChannelModel samplerChannelModel, int n, Client client) {
        try {
            FxSend[] fxSendArray = samplerChannelModel.getFxSends();
            for (int i = 0; i < fxSendArray.length; ++i) {
                FxSend fxSend = fxSendArray[i];
                client.createFxSend(n, fxSend.getMidiController(), fxSend.getName());
                client.setFxSendLevel(n, i, fxSend.getLevel());
                Integer[] integerArray = fxSend.getAudioOutputRouting();
                for (int j = 0; j < integerArray.length; ++j) {
                    client.setFxSendAudioOutputChannel(n, i, j, integerArray[j]);
                }
            }
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.FINE, HF.getErrorMessage(exception), exception);
        }
    }
}

