/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.stork;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.smallrye.stork.api.observability.ObservationCollector;
import io.smallrye.stork.api.observability.StorkEventHandler;
import io.smallrye.stork.api.observability.StorkObservation;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Typed;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

@ApplicationScoped
@Typed(value={ObservationCollector.class})
public class StorkObservationCollectorBean
implements ObservationCollector,
StorkEventHandler {
    public static final String METRICS_SUFFIX = "-metrics";
    public static final Map<String, StorkObservation> STORK_METRICS = new ConcurrentHashMap<String, StorkObservation>();
    private final Meter.MeterProvider<Counter> instanceCounter;
    private final Meter.MeterProvider<Timer> serviceDiscoveryTimer;
    private final Meter.MeterProvider<Timer> serviceSelectionTimer;
    private final Meter.MeterProvider<Counter> serviceDiscoveryFailures;
    private final Meter.MeterProvider<Counter> serviceSelectionFailures;

    public StorkObservationCollectorBean(MeterRegistry registry) {
        this.instanceCounter = Counter.builder((String)"stork.service-discovery.instances.count").description("The number of service instances discovered").withRegistry(registry);
        this.serviceDiscoveryTimer = Timer.builder((String)"stork.service-discovery.duration").description("The duration of the discovery operation").withRegistry(registry);
        this.serviceSelectionTimer = Timer.builder((String)"stork.service-selection.duration").description("The duration of the selection operation").withRegistry(registry);
        this.serviceDiscoveryFailures = Counter.builder((String)"stork.service-discovery.failures").description("The number of failures during service discovery").withRegistry(registry);
        this.serviceSelectionFailures = Counter.builder((String)"stork.service-selection.failures").description("The number of failures during service selection").withRegistry(registry);
    }

    public StorkObservation create(String serviceName, String serviceDiscoveryType, String serviceSelectionType) {
        return STORK_METRICS.computeIfAbsent(serviceName + METRICS_SUFFIX, key -> new StorkObservation(serviceName, serviceDiscoveryType, serviceSelectionType, (StorkEventHandler)this));
    }

    public void complete(StorkObservation observation) {
        Tags tags = Tags.of((Tag[])new Tag[]{Tag.of((String)"service-name", (String)observation.getServiceName())});
        int count = observation.getDiscoveredInstancesCount();
        ((Counter)this.instanceCounter.withTags((Iterable)tags)).increment((double)Math.max(count, 0));
        ((Timer)this.serviceDiscoveryTimer.withTags((Iterable)tags)).record((long)observation.getServiceDiscoveryDuration().getNano(), TimeUnit.NANOSECONDS);
        ((Timer)this.serviceSelectionTimer.withTags((Iterable)tags)).record((long)observation.getServiceSelectionDuration().getNano(), TimeUnit.NANOSECONDS);
        Counter ssf = (Counter)this.serviceSelectionFailures.withTags((Iterable)tags);
        Counter sdf = (Counter)this.serviceDiscoveryFailures.withTags((Iterable)tags);
        if (observation.failure() != null) {
            if (observation.isServiceDiscoverySuccessful()) {
                ssf.increment();
            } else {
                sdf.increment();
                ssf.increment(0.0);
            }
        } else {
            ssf.increment(0.0);
            sdf.increment(0.0);
        }
    }
}

