/*
 * Decompiled with CFR 0.152.
 */
package mediathek.filmlisten.reader;

import java.time.LocalDate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeFilme;
import mediathek.filmlisten.reader.IDateFilter;
import mediathek.tool.datum.DateUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lmediathek/filmlisten/reader/DateFilter;", "Lmediathek/filmlisten/reader/IDateFilter;", "listeFilme", "Lmediathek/daten/ListeFilme;", "days", "", "<init>", "(Lmediathek/daten/ListeFilme;J)V", "cutoffDate", "Ljava/time/LocalDate;", "isBeforeOrEqual", "", "date", "compareToDate", "filter", "", "film", "Lmediathek/daten/DatenFilm;", "MediathekView"})
public final class DateFilter
implements IDateFilter {
    @NotNull
    private final ListeFilme listeFilme;
    @NotNull
    private final LocalDate cutoffDate;

    public DateFilter(@NotNull ListeFilme listeFilme, long days) {
        Intrinsics.checkNotNullParameter((Object)listeFilme, (String)"listeFilme");
        this.listeFilme = listeFilme;
        LocalDate localDate = LocalDate.now().minusDays(days);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"minusDays(...)");
        this.cutoffDate = localDate;
    }

    private final boolean isBeforeOrEqual(LocalDate date, LocalDate compareToDate) {
        return !compareToDate.isAfter(date);
    }

    @Override
    public void filter(@NotNull DatenFilm film) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)film, (String)"film");
                LocalDate localDate = DateUtil.convertToLocalDate(film.getDatumFilm());
                if (film.isLivestream()) break block2;
                Intrinsics.checkNotNull((Object)localDate);
                if (!this.isBeforeOrEqual(localDate, this.cutoffDate)) break block3;
            }
            this.listeFilme.add(film);
        }
    }
}

