/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.expiration;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mediathek.gui.expiration.ExpiryInfo;
import mediathek.tool.http.MVHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class ThreeSatExpiryHelper {
    private static final Pattern TEXT_DATE_PATTERN = Pattern.compile("(Verf\u00fcgbar bis:?)\\s*(?:bis\\s*)?(\\d{2}\\.\\d{2}\\.\\d{4})");
    private static final Logger LOG = LogManager.getLogger();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<ExpiryInfo> getExpiryInfo(String url) {
        Request request = new Request.Builder().url(url).get().header("User-Agent", "Mozilla/5.0").build();
        try (Response response = MVHttpClient.getInstance().getHttpClient().newCall(request).execute();){
            if (response.isSuccessful()) {
                Document doc = Jsoup.parse(response.body().string());
                String body = doc.body().text();
                Matcher m = TEXT_DATE_PATTERN.matcher(body);
                if (!m.find()) return Optional.empty();
                LocalDate date = LocalDate.parse(m.group(2), DateTimeFormatter.ofPattern("dd.MM.yyyy"));
                Optional<ExpiryInfo> optional = Optional.of(new ExpiryInfo(date));
                return optional;
            }
            LOG.error("Could not fetch expiry data from {}", (Object)url);
            return Optional.empty();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }
}

