/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.parsing;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;

public class TwigParserResult
extends ParserResult {
    private final List<Error> errorList = new ArrayList<Error>();
    private final List<Block> blockList = new ArrayList<Block>();

    TwigParserResult(Snapshot snapshot) {
        super(snapshot);
    }

    public void addError(String description, int offset, int length) {
        this.errorList.add(new Error(description, offset, length, this.getSnapshot()));
    }

    public List<Block> getBlocks() {
        return new ArrayList<Block>(this.blockList);
    }

    public void addBlock(CharSequence function, int offset, int length, CharSequence extra) {
        this.blockList.add(new Block(function, offset, length, extra));
    }

    protected void invalidate() {
    }

    public List<? extends org.netbeans.modules.csl.api.Error> getDiagnostics() {
        return new ArrayList<Error>(this.errorList);
    }

    public static class Error
    implements org.netbeans.modules.csl.api.Error {
        private final String description;
        private final int offset;
        private final int length;
        private final Snapshot snapshot;

        public Error(String description, int offset, int length, Snapshot snapshot) {
            this.description = description;
            this.offset = offset;
            this.length = length;
            this.snapshot = snapshot;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDisplayName() {
            return this.description;
        }

        public String getKey() {
            return this.description;
        }

        public FileObject getFile() {
            return this.snapshot.getSource().getFileObject();
        }

        public int getStartPosition() {
            return this.offset;
        }

        public int getEndPosition() {
            return this.offset + this.length;
        }

        public boolean isLineError() {
            return false;
        }

        public Severity getSeverity() {
            return Severity.ERROR;
        }

        public Object[] getParameters() {
            return null;
        }
    }

    public static class Block {
        private final CharSequence function;
        private final int offset;
        private final int length;
        private final CharSequence extra;

        public Block(CharSequence function, int offset, int length, CharSequence extra) {
            this.function = function;
            this.offset = offset;
            this.length = length;
            this.extra = extra;
        }

        public CharSequence getExtra() {
            return this.extra;
        }

        public CharSequence getDescription() {
            return this.function;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }
    }
}

