/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gototest;

import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.gototest.TestOppositesLocator;
import org.netbeans.modules.gototest.Bundle;
import org.netbeans.modules.gototest.OppositeCandidateChooser;
import org.netbeans.modules.gototest.PopupUtil;
import org.netbeans.modules.gsf.testrunner.ui.api.TestCreatorPanelDisplayer;
import org.netbeans.modules.gsf.testrunner.ui.api.UICommonUtils;
import org.netbeans.modules.parsing.api.Source;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;

public class GotoOppositeAction
extends CallableSystemAction {
    public GotoOppositeAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
        String trimmedName = NbBundle.getMessage(GotoOppositeAction.class, (String)"LBL_Action_GoToTest_trimmed");
        this.putValue("trimmed-text", trimmedName);
    }

    public String getName() {
        return Bundle.LBL_Action_GoToTestOrTestedClass();
    }

    public boolean isEnabled() {
        assert (EventQueue.isDispatchThread());
        EditorCookie ec = (EditorCookie)Utilities.actionsGlobalContext().lookup(EditorCookie.class);
        return ec != null && ec.getDocument() != null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void initialize() {
        super.initialize();
        this.putProperty("ShortDescription", NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"HINT_Action_GoToTest"));
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction() {
        int[] caretOffsetHolder = new int[]{-1};
        final FileObject fo = this.getApplicableFileObject(caretOffsetHolder);
        final int caretOffset = caretOffsetHolder[0];
        if (fo != null) {
            RequestProcessor RP = new RequestProcessor(GotoOppositeAction.class.getName());
            RP.post(new Runnable(){
                final /* synthetic */ GotoOppositeAction this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    TestOppositesLocator.LocatorResult opposites;
                    try {
                        opposites = TestOppositesLocator.getDefault().findOpposites(fo, caretOffset).get();
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        return;
                    }
                    if (opposites.getErrorMessage() != null) {
                        StatusDisplayer.getDefault().setStatusText(opposites.getErrorMessage());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TestCreatorPanelDisplayer.getDefault().displayPanel(UICommonUtils.getFileObjectsFromNodes((Node[])TopComponent.getRegistry().getActivatedNodes()), null, null);
                            }
                        });
                    } else {
                        opposites.getProviderErrors().stream().forEach(msg -> DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message(msg, 1)));
                        final Collection<? extends TestOppositesLocator.Location> locations = opposites.getLocations();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                if (locations.size() == 1) {
                                    this.this$1.this$0.handleResult((TestOppositesLocator.Location)locations.iterator().next());
                                } else if (locations.size() > 1) {
                                    this.this$1.this$0.showPopup(fo, locations);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private void showPopup(FileObject fo, Collection<? extends TestOppositesLocator.Location> locations) {
        Point l = new Point(-1, -1);
        try {
            EditorCookie ec = (EditorCookie)fo.getLookup().lookup(EditorCookie.class);
            if (ec != null) {
                JEditorPane pane = NbDocument.findRecentEditorPane((EditorCookie)ec);
                Rectangle pos = pane.modelToView(pane.getCaretPosition());
                l = new Point(pos.x + pos.width, pos.y + pos.height);
                SwingUtilities.convertPointToScreen(l, pane);
                String label = Bundle.LBL_PickExpression();
                PopupUtil.showPopup(new OppositeCandidateChooser(this, label, locations), label, l.x, l.y, true, -1);
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(GotoOppositeAction.class.getName()).log(Level.WARNING, null, ex);
        }
    }

    public void handleResult(TestOppositesLocator.Location opposite) {
        FileObject fileObject = opposite.getFileObject();
        if (fileObject != null) {
            NbDocument.openDocument((Lookup.Provider)fileObject, (int)opposite.getOffset(), (Line.ShowOpenType)Line.ShowOpenType.OPEN, (Line.ShowVisibilityType)Line.ShowVisibilityType.FOCUS);
        }
    }

    private FileObject getApplicableFileObject(int[] caretPosHolder) {
        if (!EventQueue.isDispatchThread()) {
            Collection dobs = Utilities.actionsGlobalContext().lookupAll(FileObject.class);
            return dobs.size() == 1 ? (FileObject)dobs.iterator().next() : null;
        }
        TopComponent comp = TopComponent.getRegistry().getActivated();
        if (comp == null) {
            return null;
        }
        Node[] nodes = comp.getActivatedNodes();
        if (nodes != null && nodes.length == 1) {
            if (comp instanceof CloneableEditorSupport.Pane) {
                JEditorPane editorPane;
                EditorCookie ec = (EditorCookie)nodes[0].getLookup().lookup(EditorCookie.class);
                if (ec != null && (editorPane = NbDocument.findRecentEditorPane((EditorCookie)ec)) != null) {
                    if (editorPane.getCaret() != null) {
                        caretPosHolder[0] = editorPane.getCaret().getDot();
                    }
                    Document document = editorPane.getDocument();
                    return Source.create((Document)document).getFileObject();
                }
            } else {
                return UICommonUtils.getFileObjectFromNode((Node)nodes[0]);
            }
        }
        return null;
    }
}

