/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.CreateInstanceConfigurationBase;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateInstanceConfigurationRequest
extends BmcRequest<CreateInstanceConfigurationBase> {
    private CreateInstanceConfigurationBase createInstanceConfiguration;
    private String opcRetryToken;

    public CreateInstanceConfigurationBase getCreateInstanceConfiguration() {
        return this.createInstanceConfiguration;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateInstanceConfigurationBase getBody$() {
        return this.createInstanceConfiguration;
    }

    public Builder toBuilder() {
        return new Builder().createInstanceConfiguration(this.createInstanceConfiguration).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createInstanceConfiguration=").append(String.valueOf((Object)this.createInstanceConfiguration));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateInstanceConfigurationRequest)) {
            return false;
        }
        CreateInstanceConfigurationRequest other = (CreateInstanceConfigurationRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createInstanceConfiguration, (Object)other.createInstanceConfiguration) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createInstanceConfiguration == null ? 43 : this.createInstanceConfiguration.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateInstanceConfigurationRequest, CreateInstanceConfigurationBase> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateInstanceConfigurationBase createInstanceConfiguration = null;
        private String opcRetryToken = null;

        public Builder createInstanceConfiguration(CreateInstanceConfigurationBase createInstanceConfiguration) {
            this.createInstanceConfiguration = createInstanceConfiguration;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateInstanceConfigurationRequest o) {
            this.createInstanceConfiguration(o.getCreateInstanceConfiguration());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateInstanceConfigurationRequest build() {
            CreateInstanceConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateInstanceConfigurationBase body) {
            this.createInstanceConfiguration(body);
            return this;
        }

        public CreateInstanceConfigurationRequest buildWithoutInvocationCallback() {
            CreateInstanceConfigurationRequest request = new CreateInstanceConfigurationRequest();
            request.createInstanceConfiguration = this.createInstanceConfiguration;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

