/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.modules.debugger.jpda.actions.StepActionProvider;
import org.openide.util.WeakListeners;

public class SmartSteppingFilterImpl
implements SmartSteppingFilter {
    private final HashSet<String> filter = new HashSet();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Properties options = Properties.getDefault().getProperties("debugger.options.JPDA");
    private final Properties classFiltersProperties = Properties.getDefault().getProperties("debugger").getProperties("sources").getProperties("class_filters");
    private final PropertyChangeListener exclusionPatternsListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SmartSteppingFilterImpl.this.setExclusionPatterns();
        }
    };

    public SmartSteppingFilterImpl() {
        this.options.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.exclusionPatternsListener, (Object)this.options));
        this.classFiltersProperties.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.exclusionPatternsListener, (Object)this.classFiltersProperties));
        this.setExclusionPatterns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExclusionPatterns() {
        Set patterns = this.options.getBoolean("UseStepFilters", true) ? (Set)this.classFiltersProperties.getCollection("enabled", Collections.emptySet()) : Collections.emptySet();
        HashSet<String> hashSet = this.filter;
        synchronized (hashSet) {
            this.filter.clear();
            this.filter.addAll(patterns);
        }
        this.pcs.firePropertyChange("exclusionPatterns", null, patterns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExclusionPatterns(Set<String> patterns) {
        HashSet<String> reallyNew = new HashSet<String>(patterns);
        reallyNew.removeAll(this.filter);
        if (reallyNew.size() < 1) {
            return;
        }
        HashSet<String> hashSet = this.filter;
        synchronized (hashSet) {
            this.filter.addAll(reallyNew);
        }
        this.pcs.firePropertyChange("exclusionPatterns", null, reallyNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExclusionPatterns(Set<String> patterns) {
        HashSet<String> hashSet = this.filter;
        synchronized (hashSet) {
            this.filter.removeAll(patterns);
        }
        this.pcs.firePropertyChange("exclusionPatterns", patterns, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getExclusionPatterns() {
        HashSet<String> hashSet = this.filter;
        synchronized (hashSet) {
            String[] ef = new String[this.filter.size()];
            return this.filter.toArray(ef);
        }
    }

    public boolean stopHere(String className) {
        return StepActionProvider.stopInClass(className, this);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }
}

