/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.amazon.ui;

import com.amazonaws.AmazonClientException;
import java.awt.Component;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cloud.amazon.AmazonInstance;
import org.netbeans.modules.cloud.amazon.serverplugin.AmazonJ2EEInstance;
import org.netbeans.modules.cloud.amazon.ui.AmazonJ2EEInstanceNode;
import org.netbeans.modules.cloud.amazon.ui.AmazonWizardComponent;
import org.netbeans.modules.cloud.common.spi.support.ui.ServerResourceDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class AmazonWizardPanel
implements WizardDescriptor.AsynchronousValidatingPanel<WizardDescriptor> {
    public static final String KEY_ID = "access-key-id";
    public static final String KEY = "secret-access-key";
    public static final String REGION = "region";
    public static final String CODE = "code";
    private ChangeSupport listeners = new ChangeSupport((Object)this);
    private AmazonWizardComponent component;
    private List<ServerResourceDescriptor> servers;
    private WizardDescriptor wd = null;

    public Component getComponent() {
        if (this.component == null) {
            this.component = new AmazonWizardComponent(this, null);
            this.component.putClientProperty("WizardPanel_contentData", AmazonWizardPanel.getPanelContentData());
            this.component.putClientProperty("WizardPanel_contentSelectedIndex", 0);
        }
        return this.component;
    }

    static String[] getPanelContentData() {
        return new String[]{NbBundle.getMessage(AmazonWizardPanel.class, (String)"LBL_ACIW_Amazon"), NbBundle.getMessage(AmazonWizardPanel.class, (String)"LBL_ACIW_Resources")};
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(WizardDescriptor settings) {
        this.wd = settings;
    }

    public void storeSettings(WizardDescriptor settings) {
        if (this.component != null) {
            settings.putProperty(KEY_ID, (Object)this.component.getKeyId());
            settings.putProperty(KEY, (Object)this.component.getKey());
            settings.putProperty("server-resources", this.servers);
            settings.putProperty(REGION, (Object)this.component.getRegionUrl());
            settings.putProperty(CODE, (Object)this.component.getRegionCode());
        }
    }

    public void setErrorMessage(String message) {
        this.wd.putProperty("WizardPanel_errorMessage", (Object)message);
    }

    public boolean isValid() {
        if (this.component != null && this.wd != null) {
            if (this.component.getKeyId().trim().length() == 0) {
                this.setErrorMessage(NbBundle.getMessage(AmazonWizardPanel.class, (String)"AmazonWizardPanel.missingKeyID"));
                return false;
            }
            if (this.component.getKey().trim().length() == 0) {
                this.setErrorMessage(NbBundle.getMessage(AmazonWizardPanel.class, (String)"AmazonWizardPanel.missingKey"));
                return false;
            }
        }
        this.setErrorMessage("");
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.removeChangeListener(l);
    }

    void fireChange() {
        this.listeners.fireChange();
    }

    public void prepareValidation() {
        this.getComponent().setCursor(Utilities.createProgressCursor((Component)this.getComponent()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws WizardValidationException {
        try {
            this.servers = new ArrayList<ServerResourceDescriptor>();
            AmazonInstance ai = new AmazonInstance("temporary", this.component.getKeyId(), this.component.getKey(), this.component.getRegionUrl(), this.component.getRegionCode());
            try {
                ai.testConnection();
            }
            catch (AmazonClientException ex) {
                throw new WizardValidationException((JComponent)this.getComponent(), "connection failed", NbBundle.getMessage(AmazonWizardPanel.class, (String)"AmazonWizardPanel.wrong.credentials"));
            }
            List<AmazonJ2EEInstance> list = ai.readJ2EEServerInstances();
            for (AmazonJ2EEInstance inst : list) {
                AmazonJ2EEInstanceNode n = new AmazonJ2EEInstanceNode(inst);
                n.showServerType();
                this.servers.add(new ServerResourceDescriptor("Server", n.getDisplayName(), "", ImageUtilities.image2Icon((Image)n.getIcon(1))));
            }
        }
        finally {
            this.getComponent().setCursor(null);
        }
    }
}

