/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class MainProjectManager
implements ProjectActionPerformer,
PropertyChangeListener {
    public static final String PROP_MAIN_PROJECT = "mainProject";
    public static final String PROP_SELECTED_PROJECT = "selectedProject";
    private static final RequestProcessor RP = new RequestProcessor(MainProjectManager.class);
    private static MainProjectManager mainProjectManager = new MainProjectManager();
    private Action a;
    private Reference<Project> currentProject = new WeakReference<Object>(null);
    private Reference<Project> lastSelectedProjectRef = new WeakReference<Object>(null);
    private boolean isMainProject;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public static MainProjectManager getDefault() {
        return mainProjectManager;
    }

    private MainProjectManager() {
        this.a = ProjectSensitiveActions.projectSensitiveAction((ProjectActionPerformer)this, (String)"x", null);
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        this.currentProject = new WeakReference<Project>(OpenProjects.getDefault().getMainProject());
        this.isMainProject = this.currentProject.get() != null;
        this.a.addPropertyChangeListener(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainProjectManager.this.a.isEnabled();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project getMainProject() {
        boolean isMain;
        Project current;
        Project lastSelectedProject;
        MainProjectManager mainProjectManager = this;
        synchronized (mainProjectManager) {
            lastSelectedProject = this.lastSelectedProjectRef.get();
            current = this.currentProject.get();
            isMain = this.isMainProject;
        }
        if (isMain && lastSelectedProject != null && lastSelectedProject != current && !MainProjectManager.isDependent(lastSelectedProject, current)) {
            return lastSelectedProject;
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Future<Project> getMainProjectLazy() {
        boolean isMain;
        Project current;
        Project lastSelectedProject;
        MainProjectManager mainProjectManager = this;
        synchronized (mainProjectManager) {
            lastSelectedProject = this.lastSelectedProjectRef.get();
            current = this.currentProject.get();
            isMain = this.isMainProject;
        }
        if (isMain && lastSelectedProject != null && lastSelectedProject != current) {
            return RP.submit((Callable)new Callable<Project>(){
                final /* synthetic */ MainProjectManager this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Project call() throws Exception {
                    if (!MainProjectManager.isDependent(lastSelectedProject, current)) {
                        return lastSelectedProject;
                    }
                    return current;
                }
            });
        }
        return new Future(){
            final /* synthetic */ MainProjectManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            public Object get() throws InterruptedException, ExecutionException {
                return current;
            }

            public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return current;
            }
        };
    }

    public void perform(Project p) {
        assert (false) : "Fake action should never really be called";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enable(Project p) {
        Project old = p;
        Project oldSelected = p;
        MainProjectManager mainProjectManager = this;
        synchronized (mainProjectManager) {
            if (this.isMainProject) {
                oldSelected = this.lastSelectedProjectRef.get();
            }
            this.lastSelectedProjectRef = new WeakReference<Project>(p);
            if (!this.isMainProject && this.currentProject.get() != p) {
                old = this.currentProject.get();
                this.currentProject = new WeakReference<Project>(p);
            }
        }
        if (old != p) {
            this.pcs.firePropertyChange(PROP_MAIN_PROJECT, old, p);
        }
        if (oldSelected != p) {
            this.pcs.firePropertyChange(PROP_SELECTED_PROJECT, oldSelected, p);
        }
        return true;
    }

    private static boolean isDependent(Project p1, Project p2) {
        Set<URL> p1Roots = MainProjectManager.getProjectRoots(p1);
        Set<URL> p2Roots = MainProjectManager.getProjectRoots(p2);
        for (URL root : p2Roots) {
            Set dependentRoots = SourceUtils.getDependentRoots((URL)root);
            for (URL sr : p1Roots) {
                if (!dependentRoots.contains(sr)) continue;
                return true;
            }
        }
        return false;
    }

    private static Set<URL> getProjectRoots(Project p) {
        SourceGroup[] sgs;
        HashSet<URL> projectRoots = new HashSet<URL>();
        Sources sources = ProjectUtils.getSources((Project)p);
        for (SourceGroup sg : sgs = sources.getSourceGroups("java")) {
            try {
                URL root = sg.getRootFolder().toURL();
                projectRoots.add(root);
            }
            catch (NullPointerException npe) {
                if (sg == null) {
                    npe = (NullPointerException)Exceptions.attachMessage((Throwable)npe, (String)("Null source group returned from " + sources + " of class " + sources.getClass()));
                } else if (sg.getRootFolder() == null) {
                    npe = (NullPointerException)Exceptions.attachMessage((Throwable)npe, (String)("Null root folder returned from " + sg + " of class " + sg.getClass()));
                }
                Exceptions.printStackTrace((Throwable)npe);
            }
        }
        return projectRoots;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("MainProject".equals(evt.getPropertyName())) {
            Project old;
            Project theMainProject = OpenProjects.getDefault().getMainProject();
            MainProjectManager mainProjectManager = this;
            synchronized (mainProjectManager) {
                this.isMainProject = theMainProject != null;
                old = this.currentProject.get();
                this.currentProject = this.isMainProject ? new WeakReference<Project>(theMainProject) : this.lastSelectedProjectRef;
            }
            if (old != theMainProject) {
                this.pcs.firePropertyChange(PROP_MAIN_PROJECT, old, theMainProject);
            }
        } else if (evt.getSource() == this.a && "enabled".equals(evt.getPropertyName()) && !this.a.isEnabled() || "openProjects".equals(evt.getPropertyName())) {
            Project theMainProject = OpenProjects.getDefault().getMainProject();
            Project currentGone = null;
            Project currentNew = null;
            Project lastGone = null;
            MainProjectManager mainProjectManager = this;
            synchronized (mainProjectManager) {
                boolean isCurrent = OpenProjects.getDefault().isProjectOpen(this.currentProject.get());
                Project last = this.lastSelectedProjectRef.get();
                boolean isLast = OpenProjects.getDefault().isProjectOpen(last);
                if (!isCurrent && this.currentProject.get() != null) {
                    currentGone = this.currentProject.get();
                    this.currentProject = new WeakReference<Object>(null);
                }
                if (!isLast && last != null) {
                    if (this.isMainProject) {
                        lastGone = last;
                    }
                    this.lastSelectedProjectRef = new WeakReference<Object>(null);
                }
                boolean bl = this.isMainProject = theMainProject != null;
                if (this.isMainProject && this.currentProject.get() == null) {
                    this.currentProject = new WeakReference<Project>(theMainProject);
                    currentNew = this.currentProject.get();
                }
            }
            if (currentGone != currentNew) {
                this.pcs.firePropertyChange(PROP_MAIN_PROJECT, currentGone, currentNew);
            }
            if (lastGone != null) {
                this.pcs.firePropertyChange(PROP_SELECTED_PROJECT, lastGone, null);
            }
        }
    }
}

