/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import org.netbeans.modules.debugger.ui.views.debugging.KeyboardPopupSwitcher;
import org.netbeans.modules.debugger.ui.views.debugging.ThreadsHistoryAction;
import org.netbeans.modules.debugger.ui.views.debugging.ThreadsListener;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class SetCurrentThreadFromHistoryAction
extends AbstractAction
implements Presenter.Menu,
Presenter.Popup {
    private static final Logger logger = Logger.getLogger(SetCurrentThreadFromHistoryAction.class.getName());

    public SetCurrentThreadFromHistoryAction() {
        this.putValue("Name", NbBundle.getMessage(ThreadsHistoryAction.class, (String)"CTL_ThreadsHistoryAction"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new ThreadsHistoryAction().actionPerformed(e);
    }

    public JMenuItem getMenuPresenter() {
        final JMenuItem item = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)item, (String)NbBundle.getMessage(SetCurrentThreadFromHistoryAction.class, (String)"CTL_SetCurrentThreadFromHistoryAction"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetCurrentThreadFromHistoryAction.this.showWindow();
            }
        });
        item.addHierarchyListener(new HierarchyListener(){
            final /* synthetic */ SetCurrentThreadFromHistoryAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("hierarchy changed: " + e + "\n  item.getParent() = " + item.getParent() + ", item.isDisplayable() = " + item.isDisplayable());
                }
                if (item.getParent() == null || !item.isDisplayable()) {
                    return;
                }
                item.setEnabled(ThreadsHistoryAction.getThreads().size() > 0);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("  threads size = " + ThreadsHistoryAction.getThreads().size() + " => item.isEnabled() = " + item.isEnabled());
                }
            }
        });
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getMenuPresenter(): item = " + item);
        }
        ThreadsChangeListener pchl = new ThreadsChangeListener(item);
        item.putClientProperty(ThreadsChangeListener.class.getName(), pchl);
        ThreadsListener.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)pchl, ThreadsListener.class));
        return item;
    }

    public JMenuItem getPopupPresenter() {
        return this.getMenuPresenter();
    }

    private void showWindow() {
        List<DebuggingView.DVThread> threads = ThreadsHistoryAction.getThreads();
        int threadsCount = threads.size();
        if (threadsCount < 1) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        int triggerKey = 40;
        int releaseKey = 10;
        KeyboardPopupSwitcher.selectItem(ThreadsHistoryAction.createSwitcherItems(threads), releaseKey, triggerKey, true, true);
    }

    private static final class ThreadsChangeListener
    implements PropertyChangeListener {
        private final WeakReference<JMenuItem> itemRef;

        ThreadsChangeListener(JMenuItem item) {
            this.itemRef = new WeakReference<JMenuItem>(item);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JMenuItem item = (JMenuItem)this.itemRef.get();
            if (item == null) {
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Threads have changed: " + evt.getPropertyName() + ": " + evt.getNewValue());
                logger.fine("item is showing: " + item.isShowing());
            }
            if (item.isShowing()) {
                item.setEnabled(ThreadsHistoryAction.getThreads().size() > 0);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("  threads size = " + ThreadsHistoryAction.getThreads().size() + " => item.isEnabled() = " + item.isEnabled());
                }
            }
        }
    }
}

