/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.refactoring;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.css.refactoring.api.CssRefactoringInfo;
import org.netbeans.modules.html.editor.api.Utils;
import org.netbeans.modules.html.editor.refactoring.CssRenameRefactoringUI;
import org.netbeans.modules.html.editor.refactoring.WhereUsedUI;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.ui.refactoring.RenameRefactoringUI;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.windows.TopComponent;

public class HtmlActionsImplementationProvider
extends ActionsImplementationProvider {
    private static final Collection<String> REFACTORABLE_TYPES = Arrays.asList("text/html", "text/xhtml", "text/css", "text/javascript", "text/x-json", "image/gif", "image/jpeg", "image/png", "image/bmp");

    public boolean canFindUsages(Lookup lookup) {
        Collection nodes = lookup.lookupAll(Node.class);
        if (nodes.size() != 1) {
            return false;
        }
        Node node = (Node)nodes.iterator().next();
        return HtmlActionsImplementationProvider.isRefactorableEditorElement(node);
    }

    public boolean canRename(Lookup lookup) {
        Collection nodes = lookup.lookupAll(Node.class);
        if (nodes.size() != 1) {
            return false;
        }
        Node node = (Node)nodes.iterator().next();
        EditorCookie ec = HtmlActionsImplementationProvider.getEditorCookie(node);
        if (ec == null || !HtmlActionsImplementationProvider.isFromEditor(ec)) {
            FileObject fo = HtmlActionsImplementationProvider.getFileObjectFromNode(node);
            return fo != null && REFACTORABLE_TYPES.contains(fo.getMIMEType());
        }
        return HtmlActionsImplementationProvider.isRefactorableEditorElement(node);
    }

    public void doRename(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (HtmlActionsImplementationProvider.isFromEditor(ec)) {
            this.openCssRefactoringUI(ec, lookup, (entryName, refactoringInfo) -> new CssRenameRefactoringUI((String)entryName, refactoringInfo));
        } else {
            Collection nodes = lookup.lookupAll(Node.class);
            assert (nodes.size() == 1);
            Node node = (Node)nodes.iterator().next();
            FileObject file = HtmlActionsImplementationProvider.getFileObjectFromNode(node);
            UI.openRefactoringUI((RefactoringUI)new RenameRefactoringUI(file));
        }
    }

    private void openCssRefactoringUI(EditorCookie ec, Lookup lookup, BiFunction<String, CssRefactoringInfo, RefactoringUI> uiConstructor) {
        JEditorPane textC = ec.getOpenedPanes()[0];
        StyledDocument document = (StyledDocument)textC.getDocument();
        FileObject fileObject = HtmlActionsImplementationProvider.getFileObjectFromNode((Node)lookup.lookupAll(Node.class).iterator().next());
        document.render(() -> {
            Token t;
            int caretOffset = textC.getCaretPosition();
            TokenHierarchy th = TokenHierarchy.get((Document)document);
            TokenSequence<HTMLTokenId> htmlTokens = Utils.getJoinedHtmlSequence(th, caretOffset);
            htmlTokens.move(caretOffset);
            if (htmlTokens.moveNext() && (t = htmlTokens.token()).id() == HTMLTokenId.VALUE_CSS) {
                int start;
                CssRefactoringInfo.Type type;
                String valueType = (String)t.getProperty((Object)"valueCssType");
                if ("id".equals(valueType)) {
                    type = CssRefactoringInfo.Type.ID;
                } else if ("class".equals(valueType)) {
                    type = CssRefactoringInfo.Type.CLASS;
                } else {
                    return;
                }
                CharSequence text = t.text();
                int tokenOffset = t.offset(th);
                int valueOffset = caretOffset - tokenOffset;
                int minStart = 0;
                int maxEnd = t.length();
                if (text.charAt(0) == '\"' && text.charAt(maxEnd - 1) == '\"' || text.charAt(0) == '\'' && text.charAt(maxEnd - 1) == '\'') {
                    minStart = 1;
                    maxEnd = t.length() - 1;
                }
                int end = valueOffset;
                for (start = valueOffset; start > minStart && !Character.isWhitespace(text.charAt(start - 1)); --start) {
                }
                while (end < maxEnd && !Character.isWhitespace(text.charAt(end))) {
                    ++end;
                }
                String className = text.subSequence(start, end).toString();
                UI.openRefactoringUI((RefactoringUI)((RefactoringUI)uiConstructor.apply(className, new CssRefactoringInfo(fileObject, className, type))));
            }
        });
    }

    public void doFindUsages(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (HtmlActionsImplementationProvider.isFromEditor(ec)) {
            this.openCssRefactoringUI(ec, lookup, (entryName, refactoringInfo) -> new WhereUsedUI(refactoringInfo));
        }
    }

    private static FileObject getFileObjectFromNode(Node node) {
        DataObject dobj = (DataObject)node.getLookup().lookup(DataObject.class);
        return dobj != null ? dobj.getPrimaryFile() : null;
    }

    private static boolean isFromEditor(EditorCookie ec) {
        return (Boolean)Mutex.EVENT.readAccess(() -> {
            TopComponent activetc;
            if (ec != null && ec.getOpenedPanes() != null && (activetc = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane) {
                return true;
            }
            return false;
        });
    }

    private static EditorCookie getEditorCookie(Node node) {
        return (EditorCookie)node.getLookup().lookup(EditorCookie.class);
    }

    private static boolean isRefactorableEditorElement(Node node) {
        AtomicBoolean result = new AtomicBoolean(false);
        Mutex.EVENT.readAccess(() -> {
            EditorCookie ec = HtmlActionsImplementationProvider.getEditorCookie(node);
            if (HtmlActionsImplementationProvider.isFromEditor(ec)) {
                StyledDocument document = ec.getDocument();
                JEditorPane pane = ec.getOpenedPanes()[0];
                int caret = pane.getCaretPosition();
                document.render(() -> {
                    TokenSequence ts = LexerUtils.getTokenSequence((Document)document, (int)caret, (Language)HTMLTokenId.language(), (boolean)false);
                    result.set(ts != null);
                });
            }
        });
        return result.get();
    }
}

