/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.findUsages;

import com.intellij.find.findUsages.FindUsagesHandlerBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.findUsages.PyClassFindUsagesHandler;
import com.jetbrains.python.findUsages.PyFunctionFindUsagesHandler;
import com.jetbrains.python.findUsages.PyModuleFindUsagesHandler;
import com.jetbrains.python.findUsages.PyTargetExpressionFindUsagesHandler;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PyPsiFindUsagesHandlerFactory {
    default public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            PyPsiFindUsagesHandlerFactory.$$$reportNull$$$0(0);
        }
        return element instanceof PyClass || element instanceof PyFile && PyUtil.isPackage((PsiFile)((PyFile)element)) || element instanceof PyImportedModule || element instanceof PyFunction || element instanceof PyTargetExpression;
    }

    @Nullable
    default public FindUsagesHandlerBase createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        PsiElement resolved;
        if (element == null) {
            PyPsiFindUsagesHandlerFactory.$$$reportNull$$$0(1);
        }
        if (element instanceof PyImportedModule && (resolved = ((PyImportedModule)element).resolve()) != null) {
            element = resolved;
        }
        if (element instanceof PsiFileSystemItem) {
            return this.createModuleFindUsagesHandler((PsiFileSystemItem)element);
        }
        if (element instanceof PyFunction) {
            PsiElement next;
            TypeEvalContext context;
            Collection superMethods;
            if (!forHighlightUsages && !(superMethods = PySuperMethodsSearch.search((PyFunction)element, true, context = TypeEvalContext.userInitiated((Project)element.getProject(), null)).findAll()).isEmpty() && (next = (PsiElement)superMethods.iterator().next()) instanceof PyFunction && !PyPsiFindUsagesHandlerFactory.isInObject((PyFunction)next)) {
                if (PythonUiService.getInstance().showYesDialog(element.getProject(), PyPsiBundle.message("python.find.usages.base.method.question", ((PyFunction)element).getName(), ((PyFunction)next).getContainingClass().getName()), PyPsiBundle.message("python.find.usages", new Object[0]))) {
                    ArrayList<PsiElement> allMethods = new ArrayList<PsiElement>();
                    allMethods.add(element);
                    allMethods.addAll(superMethods);
                    return new PyFunctionFindUsagesHandler(element, allMethods);
                }
                return new PyFunctionFindUsagesHandler(element);
            }
            return new PyFunctionFindUsagesHandler(element);
        }
        if (element instanceof PyClass) {
            return new PyClassFindUsagesHandler((PyClass)element);
        }
        if (element instanceof PyTargetExpression) {
            return new PyTargetExpressionFindUsagesHandler((PyTargetExpression)element);
        }
        return null;
    }

    @NotNull
    default public PyModuleFindUsagesHandler createModuleFindUsagesHandler(@NotNull PsiFileSystemItem element) {
        if (element == null) {
            PyPsiFindUsagesHandlerFactory.$$$reportNull$$$0(2);
        }
        return new PyModuleFindUsagesHandler(element);
    }

    public static boolean isInObject(PyFunction fun) {
        PyClass containingClass = fun.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        return PyUtil.isObjectClass(containingClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/jetbrains/python/findUsages/PyPsiFindUsagesHandlerFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canFindUsages";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createFindUsagesHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createModuleFindUsagesHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

