/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.system;

import com.intellij.jna.JnaLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.WinBuildNumber;
import com.sun.jna.Native;
import com.sun.jna.platform.mac.SystemB;
import com.sun.jna.platform.unix.LibCAPI;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum CpuArch {
    X86(32),
    X86_64(64),
    ARM32(32),
    ARM64(64),
    OTHER(0),
    UNKNOWN(0);

    public final int width;
    public static final CpuArch CURRENT;
    @Nullable
    private static Boolean ourEmulated;

    private CpuArch(int width) {
        if (width == 0) {
            try {
                width = Integer.parseInt(System.getProperty("sun.arch.data.model", "32"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.width = width;
    }

    @NotNull
    public static CpuArch fromString(@Nullable String arch) {
        if ("x86_64".equals(arch) || "amd64".equals(arch)) {
            CpuArch cpuArch = X86_64;
            if (cpuArch == null) {
                CpuArch.$$$reportNull$$$0(0);
            }
            return cpuArch;
        }
        if ("i386".equals(arch) || "x86".equals(arch)) {
            CpuArch cpuArch = X86;
            if (cpuArch == null) {
                CpuArch.$$$reportNull$$$0(1);
            }
            return cpuArch;
        }
        if ("aarch64".equals(arch) || "arm64".equals(arch)) {
            CpuArch cpuArch = ARM64;
            if (cpuArch == null) {
                CpuArch.$$$reportNull$$$0(2);
            }
            return cpuArch;
        }
        CpuArch cpuArch = arch == null || arch.trim().isEmpty() ? UNKNOWN : OTHER;
        if (cpuArch == null) {
            CpuArch.$$$reportNull$$$0(3);
        }
        return cpuArch;
    }

    public static boolean isIntel32() {
        return CURRENT == X86;
    }

    public static boolean isIntel64() {
        return CURRENT == X86_64;
    }

    public static boolean isArm32() {
        return CURRENT == ARM32;
    }

    public static boolean isArm64() {
        return CURRENT == ARM64;
    }

    public static boolean is32Bit() {
        return CpuArch.CURRENT.width == 32;
    }

    public static boolean isEmulated() {
        if (ourEmulated == null) {
            ourEmulated = CURRENT == X86_64 ? Boolean.valueOf(SystemInfoRt.isMac && CpuArch.isUnderRosetta() || SystemInfoRt.isWindows && !CpuArch.matchesWindowsNativeArch()) : (CURRENT == X86 ? Boolean.valueOf(SystemInfoRt.isWindows && !CpuArch.matchesWindowsNativeArch()) : Boolean.FALSE);
        }
        return ourEmulated;
    }

    private static boolean isUnderRosetta() {
        try {
            if (JnaLoader.isLoaded()) {
                IntByReference p = new IntByReference();
                LibCAPI.size_t.ByReference size = new LibCAPI.size_t.ByReference((long)SystemB.INT_SIZE);
                if (SystemB.INSTANCE.sysctlbyname("sysctl.proc_translated", p.getPointer(), size, null, LibCAPI.size_t.ZERO) != -1) {
                    return p.getValue() == 1;
                }
            }
        }
        catch (Throwable t) {
            Logger.getInstance(CpuArch.class).error(t);
        }
        return false;
    }

    private static boolean matchesWindowsNativeArch() {
        try {
            IntByReference nativeMachine;
            IntByReference processMachine;
            WinNT.HANDLE hProcess;
            Kernel32Ext kernel32Ext;
            Long buildNumber;
            if (JnaLoader.isLoaded() && (buildNumber = WinBuildNumber.getWinBuildNumber()) != null && buildNumber >= 16299L && (kernel32Ext = Native.load("kernel32", Kernel32Ext.class, W32APIOptions.DEFAULT_OPTIONS)).IsWow64Process2(hProcess = Kernel32.INSTANCE.GetCurrentProcess(), processMachine = new IntByReference(0), nativeMachine = new IntByReference(0))) {
                int arch = nativeMachine.getValue();
                if (arch == 332) {
                    return CURRENT == X86;
                }
                if (arch == 34404) {
                    return CURRENT == X86_64;
                }
                if (arch == 43620) {
                    return CURRENT == ARM64;
                }
            }
        }
        catch (Throwable t) {
            Logger.getInstance(CpuArch.class).error(t);
        }
        return true;
    }

    static {
        CURRENT = CpuArch.fromString(System.getProperty("os.arch"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/system/CpuArch", "fromString"));
    }

    private static interface Kernel32Ext
    extends StdCallLibrary,
    WinNT {
        public boolean IsWow64Process2(WinNT.HANDLE var1, IntByReference var2, IntByReference var3);
    }
}

