r"""A list of all SQL key words.

https://docs.microsoft.com/en-us/sql/t-sql/language-elements/reserved-keywords-transact-sql?view=sql-server-ver16

Run the script in a browser console to extract all reserved keywords:

```js
(function () {
    const xpathResult = document.evaluate(
        '//div[@class=\'column\']/p[not(descendant::strong)]',
        document,
        null,
        XPathResult.ORDERED_NODE_SNAPSHOT_TYPE,
        null
    );
    const list = new Set();

    for (let index = 0; index < xpathResult.snapshotLength; ++index) {
        const node = xpathResult.snapshotItem(index);
        list.add(node.textContent.trim());
    }
    console.log([...list].sort().map(value => `    "${value}"`).join(',\n'));
})();
```

Be careful, some keywords are present in `UNRESERVED_KEYWORDS`.
"""

RESERVED_KEYWORDS = [
    "ADD",
    "ALL",
    "ALTER",
    "AND",
    "ANY",
    "AS",
    "ASC",
    "AUTHORIZATION",
    "BACKUP",
    "BEGIN",
    "BETWEEN",
    "BREAK",
    "BROWSE",
    "BULK",
    "BY",
    "CASCADE",
    "CASE",
    "CHECK",
    "CHECKPOINT",
    "CLOSE",
    "CLUSTERED",
    "COALESCE",
    "COLLATE",
    "COLUMN",
    "COMMIT",
    "COMPUTE",
    "CONSTRAINT",
    "CONTAINS",
    "CONTAINSTABLE",
    "CONTINUE",
    "CONVERT",
    "CREATE",
    "CROSS",
    "CURRENT",
    "CURRENT_DATE",
    "CURRENT_TIME",
    "CURRENT_TIMESTAMP",
    "CURRENT_USER",
    "CURSOR",
    "DATABASE",
    "DBCC",
    "DEALLOCATE",
    "DECLARE",
    "DEFAULT",
    "DELETE",
    "DENY",
    "DESC",
    "DISK",
    "DISTINCT",
    "DISTRIBUTED",
    "DOUBLE",
    "DROP",
    "DUMP",
    "ELSE",
    "END",
    "ERRLVL",
    "ESCAPE",
    "EXCEPT",
    "EXEC",
    "EXECUTE",
    "EXISTS",
    "EXIT",
    "EXTERNAL",
    "FETCH",
    "FILE",
    "FILLFACTOR",
    "FOR",
    "FOREIGN",
    "FREETEXT",
    "FREETEXTTABLE",
    "FROM",
    "FULL",
    "FUNCTION",
    "GO",
    "GOTO",
    "GRANT",
    "GROUP",
    "HAVING",
    "HOLDLOCK",
    "IDENTITY",
    "IDENTITY_INSERT",
    "IDENTITYCOL",
    "IF",
    "IN",
    "INDEX",
    "INNER",
    "INSERT",
    "INTERSECT",
    "INTO",
    "IS",
    "JOIN",
    "KEY",
    "KILL",
    "LEFT",
    "LIKE",
    "LINENO",
    "LOAD",
    "MERGE",
    "NATIONAL",
    "NOCHECK",
    "NONCLUSTERED",
    "NOT",
    "NULL",
    "NULLIF",
    "OF",
    "OFF",
    "OFFSETS",
    "ON",
    "OPEN",
    "OPENDATASOURCE",
    "OPENQUERY",
    "OPENROWSET",
    "OPENXML",
    "OPTION",
    "OR",
    "ORDER",
    "OUTER",
    "OVER",
    "PERCENT",
    "PIVOT",
    "PLAN",
    "PRECISION",
    "PRIMARY",
    "PRINT",
    "PROC",
    "PROCEDURE",
    "PUBLIC",
    "RAISERROR",
    "READ",
    "READTEXT",
    "RECONFIGURE",
    "REFERENCES",
    "REPLICATION",
    "RESTORE",
    "RESTRICT",
    "RETURN",
    "REVERT",
    "REVOKE",
    "RIGHT",
    "ROLLBACK",
    "ROWCOUNT",
    "ROWGUIDCOL",
    "RULE",
    "SAVE",
    "SCHEMA",
    "SECURITYAUDIT",
    "SELECT",
    "SEMANTICKEYPHRASETABLE",
    "SEMANTICSIMILARITYDETAILSTABLE",
    "SEMANTICSIMILARITYTABLE",
    "SESSION_USER",
    "SET",
    "SETUSER",
    "SHUTDOWN",
    "SOME",
    "STATISTICS",
    "SYSTEM_USER",
    "TABLE",
    "TABLESAMPLE",
    "TEXTSIZE",
    "THEN",
    "TO",
    "TOP",
    "TRAN",
    "TRANSACTION",
    "TRIGGER",
    "TRUNCATE",
    "TRY_CONVERT",
    "TSEQUAL",
    "UNION",
    "UNIQUE",
    "UNPIVOT",
    "UPDATE",
    "UPDATETEXT",
    "USE",
    "USER",
    "VALUES",
    "VARYING",
    "VIEW",
    "WAITFOR",
    "WHEN",
    "WHERE",
    "WHILE",
    "WITH",
    "WITHIN GROUP",
    "WRITETEXT",
]

# Future reserved keywords extracted from the documentation
# NOTE: These are marked as "future reserved" by Microsoft but are NOT currently
# reserved in T-SQL. They can be used as identifiers without quoting.
# The dialect implementation only blocks RESERVED_KEYWORDS in NakedIdentifierSegment,
# allowing these future reserved keywords to be used freely as identifiers.
# https://docs.microsoft.com/en-us/sql/t-sql/language-elements/reserved-keywords-transact-sql
FUTURE_RESERVED_KEYWORDS = [
    "ABSOLUTE",
    "ACTION",
    "ADMIN",
    "AFTER",
    "AGGREGATE",
    "ALIAS",
    "ALLOCATE",
    "ARE",
    "ARRAY",
    "ASENSITIVE",
    "ASSERTION",
    "ASYMMETRIC",
    "AT",
    "ATOMIC",
    "BEFORE",
    "BINARY",
    "BIT",
    "BLOB",
    "BOOLEAN",
    "BOTH",
    "BREADTH",
    "CALL",
    "CALLED",
    "CARDINALITY",
    "CASCADED",
    "CAST",
    "CATALOG",
    "CHAR",
    "CHARACTER",
    "CLASS",
    "CLOB",
    "COLLATION",
    "COLLECT",
    "COMPLETION",
    "CONDITION",
    "CONNECT",
    "CONNECTION",
    "CONSTRAINTS",
    "CONSTRUCTOR",
    "CORR",
    "CORRESPONDING",
    "COVAR_POP",
    "COVAR_SAMP",
    "CUBE",
    "CUME_DIST",
    "CURRENT_CATALOG",
    "CURRENT_DEFAULT_TRANSFORM_GROUP",
    "CURRENT_PATH",
    "CURRENT_ROLE",
    "CURRENT_SCHEMA",
    "CURRENT_TRANSFORM_GROUP_FOR_TYPE",
    "CYCLE",
    "DATA",
    "DATE",
    "DAY",
    "DEC",
    "DECIMAL",
    "DEFERRABLE",
    "DEFERRED",
    "DEPTH",
    "DEREF",
    "DESCRIBE",
    "DESCRIPTOR",
    "DESTROY",
    "DESTRUCTOR",
    "DETERMINISTIC",
    "DIAGNOSTICS",
    "DICTIONARY",
    "DISCONNECT",
    "DOMAIN",
    "DYNAMIC",
    "EACH",
    "ELEMENT",
    "END-EXEC",
    "EQUALS",
    "EVERY",
    "EXCEPTION",
    "FALSE",
    "FILTER",
    "FIRST",
    "FLOAT",
    "FOUND",
    "FREE",
    "FULLTEXTTABLE",
    "FUSION",
    "GENERAL",
    "GET",
    "GLOBAL",
    "GROUPING",
    "HOLD",
    "HOST",
    "HOUR",
    "IGNORE",
    "IMMEDIATE",
    "INDICATOR",
    "INITIALIZE",
    "INITIALLY",
    "INOUT",
    "INPUT",
    "INT",
    "INTEGER",
    "INTERSECTION",
    "INTERVAL",
    "ISOLATION",
    "ITERATE",
    "LANGUAGE",
    "LARGE",
    "LAST",
    "LATERAL",
    "LEADING",
    "LESS",
    "LEVEL",
    "LIKE_REGEX",
    "LIMIT",
    "LN",
    "LOCAL",
    "LOCALTIME",
    "LOCALTIMESTAMP",
    "LOCATOR",
    "MAP",
    "MATCH",
    "MEMBER",
    "METHOD",
    "MINUTE",
    "MOD",
    "MODIFIES",
    "MODIFY",
    "MODULE",
    "MONTH",
    "MULTISET",
    "NAMES",
    "NATURAL",
    "NCHAR",
    "NCLOB",
    "NEW",
    "NEXT",
    "NO",
    "NONE",
    "NORMALIZE",
    "NUMERIC",
    "OBJECT",
    "OCCURRENCES_REGEX",
    "OLD",
    "ONLY",
    "OPERATION",
    "ORDINALITY",
    "OUT",
    "OUTPUT",
    "OVERLAY",
    "PAD",
    "PARAMETER",
    "PARAMETERS",
    "PARTIAL",
    "PARTITION",
    "PATH",
    "PERCENT_RANK",
    "PERCENTILE_CONT",
    "PERCENTILE_DISC",
    "POSITION_REGEX",
    "POSTFIX",
    "PREFIX",
    "PREORDER",
    "PREPARE",
    "PRESERVE",
    "PRIOR",
    "PRIVILEGES",
    "RANGE",
    "READS",
    "REAL",
    "RECURSIVE",
    "REF",
    "REFERENCING",
    "REGR_AVGX",
    "REGR_AVGY",
    "REGR_COUNT",
    "REGR_INTERCEPT",
    "REGR_R2",
    "REGR_SLOPE",
    "REGR_SXX",
    "REGR_SXY",
    "REGR_SYY",
    "RELATIVE",
    "RELEASE",
    "RESULT",
    "RETURNS",
    "ROLE",
    "ROLLUP",
    "ROUTINE",
    "ROW",
    "ROWS",
    "SAVEPOINT",
    "SCOPE",
    "SCROLL",
    "SEARCH",
    "SECOND",
    "SECTION",
    "SENSITIVE",
    "SEQUENCE",
    "SESSION",
    "SETS",
    "SIMILAR",
    "SIZE",
    "SMALLINT",
    "SPACE",
    "SPECIFIC",
    "SPECIFICTYPE",
    "SQL",
    "SQLEXCEPTION",
    "SQLSTATE",
    "SQLWARNING",
    "START",
    "STATE",
    "STATEMENT",
    "STATIC",
    "STDDEV_POP",
    "STDDEV_SAMP",
    "STRUCTURE",
    "SUBMULTISET",
    "SUBSTRING_REGEX",
    "SYMMETRIC",
    "SYSTEM",
    "TEMPORARY",
    "TERMINATE",
    "THAN",
    "TIME",
    "TIMESTAMP",
    "TIMEZONE_HOUR",
    "TIMEZONE_MINUTE",
    "TRAILING",
    "TRANSLATE_REGEX",
    "TRANSLATION",
    "TREAT",
    "TRUE",
    "UESCAPE",
    "UNDER",
    "UNKNOWN",
    "UNNEST",
    "USAGE",
    "USING",
    "VALUE",
    "VAR_POP",
    "VAR_SAMP",
    "VARCHAR",
    "VARIABLE",
    "WHENEVER",
    "WIDTH_BUCKET",
    "WINDOW",
    "WITHIN",
    "WITHOUT",
    "WORK",
    "WRITE",
    "XMLAGG",
    "XMLATTRIBUTES",
    "XMLBINARY",
    "XMLCAST",
    "XMLCOMMENT",
    "XMLCONCAT",
    "XMLDOCUMENT",
    "XMLELEMENT",
    "XMLEXISTS",
    "XMLFOREST",
    "XMLITERATE",
    "XMLNAMESPACES",
    "XMLPARSE",
    "XMLPI",
    "XMLQUERY",
    "XMLSERIALIZE",
    "XMLTABLE",
    "XMLTEXT",
    "XMLVALIDATE",
    "YEAR",
    "ZONE",
]

UNRESERVED_KEYWORDS = [
    "ABORT_AFTER_WAIT",
    "ABORT",
    "ABSENT",
    "ACCELERATED_DATABASE_RECOVERY",
    "ACCENT_SENSITIVITY",
    "ALGORITHM",
    "ALLOW_CONNECTIONS",
    "ALLOW_ENCRYPTED_VALUE_MODIFICATIONS",
    "ALLOW_PAGE_LOCKS",
    "ALLOW_ROW_LOCKS",
    "ALLOW_SNAPSHOT_ISOLATION",
    "ALLOWED",
    "ALWAYS",
    "ANSI_DEFAULTS",
    "ANSI_NULL_DEFAULT",
    "ANSI_NULL_DFLT_OFF",
    "ANSI_NULL_DFLT_ON",
    "ANSI_NULLS",
    "ANSI_PADDING",
    "ANSI_WARNINGS",
    "APPEND_ONLY",
    "APPLY",
    "ARITHABORT",
    "ARITHIGNORE",
    "ATTACH",
    "ATTACH_REBUILD_LOG",
    "AUTO_CLOSE",
    "AUTO_CREATE_STATISTICS",
    "AUTO_CREATE_TABLE",
    "AUTO_SHRINK",
    "AUTO_UPDATE_STATISTICS",
    "AUTO_UPDATE_STATISTICS_ASYNC",
    "AUTO",
    "BACKUP_STORAGE_REDUNDANCY",
    "BATCHSIZE",
    "BERNOULLI",
    "BLOCK",
    "BLOCKERS",
    "BULK_LOGGED",
    "CACHE",
    "CALLER",
    "CATALOG_COLLATION",
    "CATCH",
    "CERTIFICATE",
    "CHANGE_TRACKING",
    "CHECK_CONSTRAINTS",
    "CHECK_EXPIRATION",
    "CHECK_POLICY",
    "CODEPAGE",
    "COLUMN_ENCRYPTION_KEY",
    "COLUMNSTORE_ARCHIVE",
    "COLUMNSTORE",
    "COMMITTED",
    "COMPATIBILITY_LEVEL",
    "COMPRESS_ALL_ROW_GROUPS",
    "COMPRESSION_DELAY",
    "COMPRESSION",
    "CONCAT_NULL_YIELDS_NULL",
    "CONCAT",
    "CONNECTION_OPTIONS",
    "CONTAINED",
    "CONTAINMENT",
    "CONTEXT_INFO",
    "CONTROL",
    "COPY",
    "CREDENTIAL",
    "CURSOR_CLOSE_ON_COMMIT",
    "CURSOR_DEFAULT",
    "DATA_COMPRESSION",
    "DATA_CONSISTENCY_CHECK",
    "DATA_DELETION",
    "DATA_SOURCE",
    "DATABASE_DEFAULT",
    "DATAFILETYPE",
    "DATASOURCE",
    "DATE_CORRELATION_OPTIMIZATION",
    "DATE_FORMAT",
    "DATEFIRST",
    "DATEFORMAT",
    "DAYS",
    "DB_CHAINING",
    "DEADLOCK_PRIORITY",
    "DECRYPTION",
    "DEFAULT_DATABASE",
    "DEFAULT_FULLTEXT_LANGUAGE",
    "DEFAULT_LANGUAGE",
    "DEFAULT_SCHEMA",
    "DELAY",
    "DELAYED_DURABILITY",
    "DELETED",
    "DELIMITEDTEXT",
    "DELTA",
    "DENSE_RANK",
    "DIRECTORY_NAME",
    "DISABLE",
    "DISABLED",
    "DISTRIBUTION",
    "DISABLE_BROKER",
    "DROP_EXISTING",
    "DURABILITY",
    "EDGE",
    "EDITION",
    "ELASTIC_POOL",
    "ELEMENTS",
    "ENABLE_BROKER",
    "ENCODING",
    "ENCRYPTED",
    "ENCRYPTION_TYPE",
    "ENCRYPTION",
    "ERROR_BROKER_CONVERSATIONS",
    "ERRORFILE_CREDENTIAL",
    "ERRORFILE_DATA_SOURCE",
    "ERRORFILE",
    "EXPAND",
    "EXPLAIN",
    "EXPLICIT",
    "EXTERNALPUSHDOWN",
    "FAILOVER",
    "FAST",
    "FAST_FORWARD",
    "FIELD_TERMINATOR",
    "FIELDQUOTE",
    "FIELDTERMINATOR",
    "FILE_FORMAT",
    "FILE_TYPE",
    "FILEGROUP",
    "FILEGROWTH",
    "FILENAME",
    "FILESTREAM_ON",
    "FILESTREAM",
    "FILETABLE_COLLATE_FILENAME",
    "FILETABLE_DIRECTORY",
    "FILETABLE_FULLPATH_UNIQUE_CONSTRAINT_NAME",
    "FILETABLE_PRIMARY_KEY_CONSTRAINT_NAME",
    "FILETABLE_STREAMID_UNIQUE_CONSTRAINT_NAME",
    "FILTER_COLUMN",
    "FILTER_PREDICATE",
    "FIPS_FLAGGER",
    "FIRE_TRIGGERS",
    "FIRST_ROW",
    "FIRSTROW",
    "FMTONLY",
    "FOLLOWING",
    "FORCE",
    "FORCED",
    "FORCE_FAILOVER_ALLOW_DATA_LOSS",
    "FORCEPLAN",
    "FORCESCAN",
    "FORCESEEK",
    "FORMAT_OPTIONS",
    "FORMAT_TYPE",
    "FORMAT",
    "FORMATFILE_DATA_SOURCE",
    "FORMATFILE",
    "FORWARD_ONLY",
    "FULLSCAN",
    "FULLTEXT",
    "GB",
    "GENERATED",
    "GEO",
    "GEOZONE",
    "HASH",
    "HEAP",
    "HIDDEN",
    "HIGH",
    "HINT",
    "HISTORY_RETENTION_PERIOD",
    "HISTORY_TABLE",
    "HONOR_BROKER_PRIORITY",
    "IGNORE_CONSTRAINTS",
    "IGNORE_DUP_KEY",
    "IGNORE_NONCLUSTERED_COLUMNSTORE_INDEX",
    "IGNORE_TRIGGERS",
    "IMPLICIT_TRANSACTIONS",
    "INBOUND",
    "INCLUDE_NULL_VALUES",
    "INCLUDE",
    "INCREMENT",
    "INCREMENTAL",
    "INFINITE",
    "INLINE",
    "INSENSITIVE",
    "INSERTED",
    "INSTEAD",
    "IO",
    "JSON",
    "JSON_ARRAY",
    "JSON_OBJECT",
    "KB",
    "KEEP",
    "KEEPDEFAULTS",
    "KEEPFIXED",
    "KEEPIDENTITY",
    "KEEPNULLS",
    "KEYSET",
    "KILOBYTES_PER_BATCH",
    "LABEL",
    "LASTROW",
    "LEDGER_VIEW",
    "LEDGER",
    "LEGACY_CARDINALITY_ESTIMATION",
    "LIST",
    "LOB_COMPACTION",
    "LOCATION",
    "LOCK_TIMEOUT",
    "LOG",
    "LOGIN",
    "LOOP",
    "LOW",
    "MANUAL",
    "MANUAL_CUTOVER",
    "MASKED",
    "MASTER",
    "MATCHED",
    "MAX_DURATION",
    "MAX_GRANT_PERCENT",
    "MAX",
    "MAXDOP",
    "MAXERRORS",
    "MAXRECURSION",
    "MAXSIZE",
    "MAXVALUE",
    "MB",
    "MEMORY_OPTIMIZED",
    "MEMORY_OPTIMIZED_DATA",
    "MIGRATION_STATE",
    "MIN_GRANT_PERCENT",
    "MINUTES",
    "MINVALUE",
    "MONTHS",
    "MULTI_USER",
    "MUST_CHANGE",
    "NAME",
    "NATIVE_COMPILATION",
    "NESTED_TRIGGERS",
    "NEWNAME",
    "NEW_BROKER",
    "NO_PERFORMANCE_SPOOL",
    "NOCOUNT",
    "NODE",
    "NOEXEC",
    "NOEXPAND",
    "NOLOCK",
    "NON_TRANSACTED_ACCESS",
    "NORMAL",
    "NOWAIT",
    "NTILE",
    "NULLS",
    "NUMERIC_ROUNDABORT",
    "OFFSET",
    "ONLINE",
    "OPENJSON",
    "OPERATION_TYPE_COLUMN_NAME",
    "OPERATION_TYPE_DESC_COLUMN_NAME",
    "OPTIMISTIC",
    "OPTIMIZE_FOR_SEQUENTIAL_KEY",
    "OPTIMIZE",
    "ORC",
    "OUTBOUND",
    "OVERRIDE",
    "OWNER",
    "PAD_INDEX",
    "PAGE",
    "PAGE_VERIFY",
    "PAGLOCK",
    "PARAMETERIZATION",
    "PARQUET",
    "PARSEONLY",
    "PARSER_VERSION",
    "PARTITIONS",
    "PASSWORD",
    "PAUSE",
    "PAUSED",
    "PERCENTAGE",
    "PERFORM_CUTOVER",
    "PERIOD",
    "PERSISTED",
    "PERSISTENT_LOG_BUFFER",
    "PERSISTENT_VERSION_STORE_FILEGROUP",
    "POLICY",
    "POPULATION",
    "PRECEDING",
    "PREDICATE",
    "PROFILE",
    "PROPERTY",
    "PROVIDER",
    "PUSHDOWN",
    "QUERY_GOVERNOR_COST_LIMIT",
    "QUERY_STORE",
    "QUERYTRACEON",
    "QUOTED_IDENTIFIER",
    "R",
    "RANDOMIZED",
    "RANK",
    "RAW",
    "RCFILE",
    "READCOMMITTED",
    "READCOMMITTEDLOCK",
    "READONLY",
    "READPAST",
    "READ_COMMITTED_SNAPSHOT",
    "READ_ONLY",
    "READ_WRITE",
    "READUNCOMMITTED",
    "REBUILD",
    "RECEIVE",
    "RECOMPILE",
    "RECOVERY",
    "RECURSIVE_TRIGGERS",
    "REGENERATE",
    "REJECT_SAMPLE_VALUE",
    "REJECT_TYPE",
    "REJECT_VALUE",
    "REJECTED_ROW_LOCATION",
    "REMOTE_DATA_ARCHIVE",
    "REMOTE_PROC_TRANSACTIONS",
    "REMOVE",
    "RENAME",
    "REORGANIZE",
    "REPEATABLE",
    "REPEATABLEREAD",
    "REPLACE",
    "REPLICATE",
    "RESAMPLE",
    "RESPECT",
    "RESULT_SET_CACHING",
    "RESUMABLE",
    "RESTRICTED_USER",
    "RESUME",
    "RETENTION_PERIOD",
    "ROBUST",
    "ROOT",
    "ROUND_ROBIN",
    "ROW_NUMBER",
    "ROWLOCK",
    "ROWS_PER_BATCH",
    "ROWTERMINATOR",
    "S",
    "SCALEOUTEXECUTION",
    "SCHEMA_AND_DATA",
    "SCHEMA_ONLY",
    "SCHEMABINDING",
    "SCHEME",
    "SCOPED",
    "SCROLL_LOCKS",
    "SECONDARY",
    "SECRET",
    "SECURITY",
    "SELF",
    "SEQUENCE_NUMBER_COLUMN_NAME",
    "SEQUENCE_NUMBER",
    "SERDE_METHOD",
    "SERIALIZABLE",
    "SERVER",
    "SERVICE",
    "SERVICE_OBJECTIVE",
    "SETERROR",
    "SETVAR",
    "SHOWPLAN_ALL",
    "SHOWPLAN_TEXT",
    "SHOWPLAN_XML",
    "SID",
    "SIMPLE",
    "SINGLE_BLOB",
    "SINGLE_CLOB",
    "SINGLE_NCLOB",
    "SNAPSHOT",
    "SORT_IN_TEMPDB",
    "SOURCE",
    "SPARSE",
    "SPATIAL_WINDOW_MAX_CELLS",
    "SPLIT",
    "STATISTICAL_SEMANTICS",
    "STATISTICS_INCREMENTAL",
    "STATISTICS_NORECOMPUTE",
    "STOPLIST",
    "STRING_AGG",
    "STRING_DELIMITER",
    "SWITCH",
    "SYNONYM",
    "SYSTEM_TIME",
    "SYSTEM_VERSIONING",
    "TB",
    "TABLOCK",
    "TABLOCKX",
    "TAKE",
    "TARGET",
    "TARGET_RECOVERY_TIME",
    "TEXTIMAGE_ON",
    "THROW",
    "TIES",
    "TIMEOUT",
    "TRANSACTION_ID_COLUMN_NAME",
    "TRANSACTION_ID",
    "TRANSFORM_NOISE_WORDS",
    "TRUNCATE_TARGET",
    "TRUSTWORTHY",
    "TRY",
    "TYPE",
    "TYPE_WARNING",
    "TWO_DIGIT_YEAR_CUTOFF",
    "UNBOUNDED",
    "UNCOMMITTED",
    "UNDEFINED",
    "UNLIMITED",
    "UPDLOCK",
    "USE_TYPE_DEFAULT",
    "USED",
    "USER_DB",
    "VIEW_METADATA",
    "WAIT_AT_LOW_PRIORITY",
    "WEEK",
    "WEEKS",
    "WINDOWS",
    "WITHOUT_ARRAY_WRAPPER",
    "XACT_ABORT",
    "XLOCK",
    "XML_COMPRESSION",
    "XML",
    "XMLDATA",
    "XMLSCHEMA",
    "XSINIL",
    "YEARS",
    # Data type keywords
    # https://learn.microsoft.com/en-us/sql/t-sql/data-types/data-types-transact-sql
    # Exact numeric types
    "TINYINT",
    "BIGINT",
    "MONEY",
    "SMALLMONEY",
    # Approximate numeric types
    # Date and time types
    "SMALLDATETIME",
    "DATETIME",
    "DATETIME2",
    "DATETIMEOFFSET",
    # Character string types
    "TEXT",
    # Unicode character string types
    "NVARCHAR",
    "NTEXT",
    # Binary string types
    "VARBINARY",
    "IMAGE",
    # Other data types
    "SQL_VARIANT",
    "ROWVERSION",
    "UNIQUEIDENTIFIER",
    "GEOGRAPHY",
    "GEOMETRY",
    "HIERARCHYID",
    "VECTOR",
]
