package nl

// All the following constants are coming from:
// https://github.com/torvalds/linux/blob/master/include/uapi/linux/devlink.h

const (
	GENL_DEVLINK_VERSION = 1
	GENL_DEVLINK_NAME    = "devlink"
)

const (
	DEVLINK_CMD_GET         = 1
	DEVLINK_CMD_PORT_GET    = 5
	DEVLINK_CMD_ESWITCH_GET = 29
	DEVLINK_CMD_ESWITCH_SET = 30
)

const (
	DEVLINK_ATTR_BUS_NAME            = 1
	DEVLINK_ATTR_DEV_NAME            = 2
	DEVLINK_ATTR_PORT_INDEX          = 3
	DEVLINK_ATTR_PORT_TYPE           = 4
	DEVLINK_ATTR_PORT_NETDEV_IFINDEX = 6
	DEVLINK_ATTR_PORT_NETDEV_NAME    = 7
	DEVLINK_ATTR_PORT_IBDEV_NAME     = 8
	DEVLINK_ATTR_ESWITCH_MODE        = 25
	DEVLINK_ATTR_ESWITCH_INLINE_MODE = 26
	DEVLINK_ATTR_ESWITCH_ENCAP_MODE  = 62
	DEVLINK_ATTR_PORT_FLAVOUR        = 77
)

const (
	DEVLINK_ESWITCH_MODE_LEGACY    = 0
	DEVLINK_ESWITCH_MODE_SWITCHDEV = 1
)

const (
	DEVLINK_ESWITCH_INLINE_MODE_NONE      = 0
	DEVLINK_ESWITCH_INLINE_MODE_LINK      = 1
	DEVLINK_ESWITCH_INLINE_MODE_NETWORK   = 2
	DEVLINK_ESWITCH_INLINE_MODE_TRANSPORT = 3
)

const (
	DEVLINK_ESWITCH_ENCAP_MODE_NONE  = 0
	DEVLINK_ESWITCH_ENCAP_MODE_BASIC = 1
)

const (
	DEVLINK_PORT_FLAVOUR_PHYSICAL = 0
	DEVLINK_PORT_FLAVOUR_CPU      = 1
	DEVLINK_PORT_FLAVOUR_DSA      = 2
	DEVLINK_PORT_FLAVOUR_PCI_PF   = 3
	DEVLINK_PORT_FLAVOUR_PCI_VF   = 4
	DEVLINK_PORT_FLAVOUR_VIRTUAL  = 5
)

const (
	DEVLINK_PORT_TYPE_NOTSET = 0
	DEVLINK_PORT_TYPE_AUTO   = 1
	DEVLINK_PORT_TYPE_ETH    = 2
	DEVLINK_PORT_TYPE_IB     = 3
)
