/* Generated by make_unicode.py DO NOT MODIFY */
/* Unicode version: 13.0.0 */

/*
 * Any copyright is dedicated to the Public Domain.
 * http://creativecommons.org/licenses/publicdomain/
 */
#include "util/Unicode.h"

using namespace js;
using namespace js::unicode;

/*
 * So how does indexing work?
 * First let's have a look at a char16_t, 16-bits:
 *              [................]
 * Step 1:
 *  Extracting the upper 11 bits from the char16_t.
 *   upper = char >>  5 ([***********.....])
 * Step 2:
 *  Using these bits to get an reduced index from index1.
 *   index = index1[upper]
 * Step 3:
 *  Combining the index and the bottom 5 bits of the original char16_t.
 *   real_index = index2[(index << 5) + (char & ((1 << 5) - 1))] ([...********+++++])
 *
 * The advantage here is that the biggest number in index1 doesn't need 10 bits,
 * but 7 and we save some memory.
 *
 * Step 4:
 *  Get the character informations by looking up real_index in js_charinfo.
 *
 * Pseudocode of generation:
 *
 * let table be the mapping of char16_t => js_charinfo_index
 * let index1 be an empty array
 * let index2 be an empty array
 * let cache be a hash map
 *
 * while shift is less then maximal amount you can shift 0xffff before it's 0
 *  let chunks be table split in chunks of size 2**shift
 *
 *  for every chunk in chunks
 *   if chunk is in cache
 *    let index be cache[chunk]
 *   else
 *    let index be the max key of index2 + 1
 *    for element in chunk
 *     push element to index2
 *    put index as chunk in cache
 *
 *   push index >> shift to index1
 *
 *  increase shift
 *  stop if you found the best shift
 */
const CharacterInfo unicode::js_charinfo[] = {
    { 0, 0, 0 },
    { 0, 0, 1 },
    { 0, 0, 4 },
    { 0, 32, 2 },
    { 65504, 0, 2 },
    { 0, 0, 2 },
    { 743, 0, 2 },
    { 121, 0, 2 },
    { 0, 1, 2 },
    { 65535, 0, 2 },
    { 0, 65337, 2 },
    { 65304, 0, 2 },
    { 0, 65415, 2 },
    { 65236, 0, 2 },
    { 195, 0, 2 },
    { 0, 210, 2 },
    { 0, 206, 2 },
    { 0, 205, 2 },
    { 0, 79, 2 },
    { 0, 202, 2 },
    { 0, 203, 2 },
    { 0, 207, 2 },
    { 97, 0, 2 },
    { 0, 211, 2 },
    { 0, 209, 2 },
    { 163, 0, 2 },
    { 0, 213, 2 },
    { 130, 0, 2 },
    { 0, 214, 2 },
    { 0, 218, 2 },
    { 0, 217, 2 },
    { 0, 219, 2 },
    { 56, 0, 2 },
    { 0, 2, 2 },
    { 65535, 1, 2 },
    { 65534, 0, 2 },
    { 65457, 0, 2 },
    { 0, 65439, 2 },
    { 0, 65480, 2 },
    { 0, 65406, 2 },
    { 0, 10795, 2 },
    { 0, 65373, 2 },
    { 0, 10792, 2 },
    { 10815, 0, 2 },
    { 0, 65341, 2 },
    { 0, 69, 2 },
    { 0, 71, 2 },
    { 10783, 0, 2 },
    { 10780, 0, 2 },
    { 10782, 0, 2 },
    { 65326, 0, 2 },
    { 65330, 0, 2 },
    { 65331, 0, 2 },
    { 65334, 0, 2 },
    { 65333, 0, 2 },
    { 42319, 0, 2 },
    { 42315, 0, 2 },
    { 65329, 0, 2 },
    { 42280, 0, 2 },
    { 42308, 0, 2 },
    { 65327, 0, 2 },
    { 65325, 0, 2 },
    { 10743, 0, 2 },
    { 42305, 0, 2 },
    { 10749, 0, 2 },
    { 65323, 0, 2 },
    { 65322, 0, 2 },
    { 10727, 0, 2 },
    { 65318, 0, 2 },
    { 42307, 0, 2 },
    { 42282, 0, 2 },
    { 65467, 0, 2 },
    { 65319, 0, 2 },
    { 65465, 0, 2 },
    { 65317, 0, 2 },
    { 42261, 0, 2 },
    { 42258, 0, 2 },
    { 84, 0, 4 },
    { 0, 116, 2 },
    { 0, 38, 2 },
    { 0, 37, 2 },
    { 0, 64, 2 },
    { 0, 63, 2 },
    { 65498, 0, 2 },
    { 65499, 0, 2 },
    { 65505, 0, 2 },
    { 65472, 0, 2 },
    { 65473, 0, 2 },
    { 0, 8, 2 },
    { 65474, 0, 2 },
    { 65479, 0, 2 },
    { 65489, 0, 2 },
    { 65482, 0, 2 },
    { 65528, 0, 2 },
    { 65450, 0, 2 },
    { 65456, 0, 2 },
    { 7, 0, 2 },
    { 65420, 0, 2 },
    { 0, 65476, 2 },
    { 65440, 0, 2 },
    { 0, 65529, 2 },
    { 0, 80, 2 },
    { 0, 15, 2 },
    { 65521, 0, 2 },
    { 0, 48, 2 },
    { 65488, 0, 2 },
    { 0, 7264, 2 },
    { 3008, 0, 2 },
    { 0, 38864, 2 },
    { 59282, 0, 2 },
    { 59283, 0, 2 },
    { 59292, 0, 2 },
    { 59294, 0, 2 },
    { 59293, 0, 2 },
    { 59300, 0, 2 },
    { 59355, 0, 2 },
    { 35266, 0, 2 },
    { 0, 62528, 2 },
    { 35332, 0, 2 },
    { 3814, 0, 2 },
    { 35384, 0, 2 },
    { 65477, 0, 2 },
    { 0, 57921, 2 },
    { 8, 0, 2 },
    { 0, 65528, 2 },
    { 74, 0, 2 },
    { 86, 0, 2 },
    { 100, 0, 2 },
    { 128, 0, 2 },
    { 112, 0, 2 },
    { 126, 0, 2 },
    { 9, 0, 2 },
    { 0, 65462, 2 },
    { 0, 65527, 2 },
    { 58331, 0, 2 },
    { 0, 65450, 2 },
    { 0, 65436, 2 },
    { 0, 65424, 2 },
    { 0, 65408, 2 },
    { 0, 65410, 2 },
    { 0, 58019, 2 },
    { 0, 57153, 2 },
    { 0, 57274, 2 },
    { 0, 28, 2 },
    { 65508, 0, 2 },
    { 0, 16, 2 },
    { 65520, 0, 2 },
    { 0, 26, 0 },
    { 65510, 0, 0 },
    { 0, 54793, 2 },
    { 0, 61722, 2 },
    { 0, 54809, 2 },
    { 54741, 0, 2 },
    { 54744, 0, 2 },
    { 0, 54756, 2 },
    { 0, 54787, 2 },
    { 0, 54753, 2 },
    { 0, 54754, 2 },
    { 0, 54721, 2 },
    { 58272, 0, 2 },
    { 0, 30204, 2 },
    { 0, 23256, 2 },
    { 48, 0, 2 },
    { 0, 23228, 2 },
    { 0, 23217, 2 },
    { 0, 23221, 2 },
    { 0, 23231, 2 },
    { 0, 23278, 2 },
    { 0, 23254, 2 },
    { 0, 23275, 2 },
    { 0, 928, 2 },
    { 0, 65488, 2 },
    { 0, 23229, 2 },
    { 0, 30152, 2 },
    { 64608, 0, 2 },
    { 26672, 0, 2 },
};

const uint8_t unicode::index1[] = {
      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,  16,  17,
     18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,  32,  33,  34,  35,
     36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,  48,  49,  50,  51,  52,  53,
     54,  55,  56,  57,  58,  59,  60,  61,  62,  63,  64,  65,  66,  67,  26,  26,  26,  26,
     26,  68,  69,  70,  71,  72,  73,  74,  75,  26,  26,  26,  26,  26,  26,  26,  26,  76,
     77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,
     95,  96,  97,  98,  99, 100, 101, 102,  26, 103, 104, 105, 106, 106, 107, 106, 108, 109,
    110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 119, 119, 119, 119, 119, 119, 119, 119,
    119, 119, 120, 121, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119,
    119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 122, 123, 106, 124,
    125, 126, 127, 128, 119, 119, 119, 119, 119, 119, 119, 119, 129,  75, 130, 131, 132,  26,
    133, 134, 119, 119, 119, 119, 119, 119, 119, 119,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26, 119,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26, 135,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26, 136, 137,  26,  26,  26,  26, 138, 139,
    140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157,
    158, 159, 160, 161,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
     26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26, 162, 163,
    119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119,
    119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119,
    119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119,
    119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119,
    119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119,
    119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119,
    119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119,
    119, 119, 119, 119, 119, 119,  26,  26,  26,  26,  26, 164,  26, 165, 166, 167, 168, 169,
     26,  26,  26,  26, 170, 171, 172, 173, 174, 175,  26, 176, 177, 178, 179, 180,
};

const uint8_t unicode::index2[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   1,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   0,   0,   0,   0,   2,   0,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   6,   0,   2,   0,   0,   5,   0,   0,   0,   0,   0,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   0,
      3,   3,   3,   3,   3,   3,   3,   5,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   0,   4,   4,   4,   4,
      4,   4,   4,   7,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,  10,  11,
      8,   9,   8,   9,   8,   9,   5,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,
      9,   8,   9,   8,   9,   5,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,  12,   8,
      9,   8,   9,   8,   9,  13,  14,  15,   8,   9,   8,   9,  16,   8,   9,  17,  17,   8,
      9,   5,  18,  19,  20,   8,   9,  17,  21,  22,  23,  24,   8,   9,  25,   5,  23,  26,
     27,  28,   8,   9,   8,   9,   8,   9,  29,   8,   9,  29,   5,   5,   8,   9,  29,   8,
      9,  30,  30,   8,   9,   8,   9,  31,   8,   9,   5,   5,   8,   9,   5,  32,   5,   5,
      5,   5,  33,  34,  35,  33,  34,  35,  33,  34,  35,   8,   9,   8,   9,   8,   9,   8,
      9,   8,   9,   8,   9,   8,   9,   8,   9,  36,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   5,  33,  34,  35,   8,   9,  37,  38,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,  39,   5,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   5,   5,   5,   5,   5,   5,  40,   8,   9,  41,  42,  43,
     43,   8,   9,  44,  45,  46,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,  47,  48,
     49,  50,  51,   5,  52,  52,   5,  53,   5,  54,  55,   5,   5,   5,  52,  56,   5,  57,
      5,  58,  59,   5,  60,  61,  59,  62,  63,   5,   5,  61,   5,  64,  65,   5,   5,  66,
      5,   5,   5,   5,   5,   5,   5,  67,   5,   5,  68,   5,  69,  68,   5,   5,   5,  70,
     68,  71,  72,  72,  73,   5,   5,   5,   5,   5,  74,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,  75,  76,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,
      5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   5,   0,   5,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,  77,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   8,   9,
      8,   9,   5,   0,   8,   9,   0,   0,   5,  27,  27,  27,   0,  78,   0,   0,   0,   0,
      0,   0,  79,   2,  80,  80,  80,   0,  81,   0,  82,  82,   5,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   0,   3,   3,   3,   3,   3,
      3,   3,   3,   3,  83,  84,  84,  84,   5,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,  85,   4,   4,   4,   4,   4,   4,   4,   4,   4,
     86,  87,  87,  88,  89,  90,   5,   5,   5,  91,  92,  93,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
     94,  95,  96,  97,  98,  99,   0,   8,   9, 100,   8,   9,   5,  39,  39,  39, 101, 101,
    101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,
     95,  95,  95,  95,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   0,   2,   2,   2,   2,   2,   0,   0,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9, 102,   8,   9,   8,   9,   8,   9,   8,
      9,   8,   9,   8,   9,   8,   9, 103,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   0, 104, 104, 104,
    104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
    104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,   0,
      0,   5,   0,   0,   0,   0,   0,   0,   5, 105, 105, 105, 105, 105, 105, 105, 105, 105,
    105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105,
    105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105,   5,   5,   0,   0,   0,   0,   0,
      0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   2,   0,   2,   2,   0,
      2,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   0,   0,   0,   0,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,
      0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   0,   0,   0,   0,   5,   5,   2,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   0,   5,   2,   2,   2,   2,   2,   2,   2,   0,   0,   2,   2,   2,   2,   2,
      2,   5,   5,   2,   2,   0,   2,   2,   2,   2,   5,   5,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   5,   5,   5,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   5,   2,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   5,   5,   0,   0,   0,   0,   5,   0,   0,   2,   0,   0,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      2,   2,   2,   2,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5,   2,   2,   2,
      5,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   0,   0,
      0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   2,   2,   2,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   5,   2,   2,   2,   2,   2,   2,   2,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   0,   0,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   2,   2,   2,   0,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   5,
      5,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   0,   5,   0,
      0,   0,   5,   5,   5,   5,   0,   0,   2,   5,   2,   2,   2,   2,   2,   2,   2,   0,
      0,   2,   2,   0,   0,   2,   2,   2,   5,   0,   0,   0,   0,   0,   0,   0,   0,   2,
      0,   0,   0,   0,   5,   5,   0,   5,   5,   5,   2,   2,   0,   0,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      5,   0,   2,   0,   0,   2,   2,   2,   0,   5,   5,   5,   5,   5,   5,   0,   0,   0,
      0,   5,   5,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   0,
      5,   5,   0,   5,   5,   0,   5,   5,   0,   0,   2,   0,   2,   2,   2,   2,   2,   0,
      0,   0,   0,   2,   2,   0,   0,   2,   2,   2,   0,   0,   0,   2,   0,   0,   0,   0,
      0,   0,   0,   5,   5,   5,   5,   0,   5,   0,   0,   0,   0,   0,   0,   0,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5,   5,   5,   2,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   0,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   0,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,
      5,   0,   5,   5,   0,   5,   5,   5,   5,   5,   0,   0,   2,   5,   2,   2,   2,   2,
      2,   2,   2,   2,   0,   2,   2,   2,   0,   2,   2,   2,   0,   0,   5,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   2,   2,   0,   0,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   5,   2,   2,   2,   2,   2,   2,   0,   2,   2,   2,   0,   5,   5,   5,   5,   5,
      5,   5,   5,   0,   0,   5,   5,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,
      5,   5,   5,   0,   5,   5,   0,   5,   5,   5,   5,   5,   0,   0,   2,   5,   2,   2,
      2,   2,   2,   2,   2,   0,   0,   2,   2,   0,   0,   2,   2,   2,   0,   0,   0,   0,
      0,   0,   0,   2,   2,   2,   0,   0,   0,   0,   5,   5,   0,   5,   5,   5,   2,   2,
      0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   5,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   5,   0,   5,   5,   5,
      5,   5,   5,   0,   0,   0,   5,   5,   5,   0,   5,   5,   5,   5,   0,   0,   0,   5,
      5,   0,   5,   0,   5,   5,   0,   0,   0,   5,   5,   0,   0,   0,   5,   5,   5,   0,
      0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,
      2,   2,   2,   2,   2,   0,   0,   0,   2,   2,   2,   0,   2,   2,   2,   2,   0,   0,
      5,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   5,
      5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,
      0,   5,   2,   2,   2,   2,   2,   2,   2,   0,   2,   2,   2,   0,   2,   2,   2,   2,
      0,   0,   0,   0,   0,   0,   0,   2,   2,   0,   5,   5,   5,   0,   0,   0,   0,   0,
      5,   5,   2,   2,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   2,   2,   2,
      0,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   0,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,
      0,   0,   2,   5,   2,   2,   2,   2,   2,   2,   2,   0,   2,   2,   2,   0,   2,   2,
      2,   2,   0,   0,   0,   0,   0,   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,
      5,   0,   5,   5,   2,   2,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      0,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,
      2,   2,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   0,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   2,   2,   5,   2,   2,   2,   2,   2,   2,   2,   0,   2,   2,   2,   0,
      2,   2,   2,   2,   5,   0,   0,   0,   0,   0,   5,   5,   5,   2,   0,   0,   0,   0,
      0,   0,   0,   5,   5,   5,   2,   2,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,
      0,   2,   2,   2,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   0,   5,   0,   0,   5,   5,   5,   5,   5,   5,   5,   0,
      0,   0,   2,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   0,   2,   0,   2,   2,
      2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   5,   5,
      2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,
      5,   2,   2,   2,   2,   2,   2,   2,   2,   0,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   5,   5,   0,   5,   0,   5,   5,   5,   5,   5,   0,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   0,   5,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,
      5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5,   0,   0,   5,   5,   5,   5,
      5,   0,   5,   0,   2,   2,   2,   2,   2,   2,   0,   0,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   0,   0,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   0,   0,   0,   0,
      0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   2,   0,   2,   0,   2,   0,   0,   0,   0,   2,   2,   5,   5,
      5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   2,   2,   5,   5,
      5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,
      5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   5,   5,   5,   5,   2,   2,   2,   5,
      2,   2,   2,   5,   5,   2,   2,   2,   2,   2,   2,   2,   5,   5,   5,   2,   2,   2,
      2,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   0,   0, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106,
    106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106,
    106, 106, 106, 106, 106, 106, 106, 106, 106, 106,   0, 106,   0,   0,   0,   0,   0, 106,
      0,   0, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107,
    107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107,
    107, 107, 107, 107, 107, 107, 107, 107, 107,   0,   5, 107, 107, 107,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,   5,   5,
      5,   0,   5,   0,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,
      5,   5,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   0,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,   5,   5,   5,   0,   5,   0,
      5,   5,   5,   5,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   2,   2,   2,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108,
    108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108,
    108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108,
    108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108,
    108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108,  88,  88,  88,  88,
     88,  88,   0,   0,  93,  93,  93,  93,  93,  93,   0,   0,   0,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   1,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   2,   2,
      2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,
      5,   5,   5,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   5,   0,   0,
      0,   0,   5,   2,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   0,   0,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,
      0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   5,   0,   0,   0,   0,   0,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,   5,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,
      0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,
      2,   2,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,
      0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,
      2,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5,   5,   5,   5,   5,   5,   5,
      0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,
      2,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   0,   0,   0,   5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      0,   0, 109, 110, 111, 112, 112, 113, 114, 115, 116,   0,   0,   0,   0,   0,   0,   0,
    117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117,
    117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 117,
    117, 117, 117, 117, 117, 117, 117,   0,   0, 117, 117, 117,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   0,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5,
      5,   5,   5,   2,   5,   5,   5,   5,   5,   5,   2,   5,   5,   2,   2,   2,   5,   0,
      0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5, 118,   5,   5,   5, 119,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5, 120,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   2,   2,   2,   2,   2,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   5,   5,   5,   5,   5, 121,
      5,   5, 122,   5,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
    123, 123, 123, 123, 123, 123, 123, 123, 124, 124, 124, 124, 124, 124, 124, 124, 123, 123,
    123, 123, 123, 123,   0,   0, 124, 124, 124, 124, 124, 124,   0,   0, 123, 123, 123, 123,
    123, 123, 123, 123, 124, 124, 124, 124, 124, 124, 124, 124, 123, 123, 123, 123, 123, 123,
    123, 123, 124, 124, 124, 124, 124, 124, 124, 124, 123, 123, 123, 123, 123, 123,   0,   0,
    124, 124, 124, 124, 124, 124,   0,   0,   5, 123,   5, 123,   5, 123,   5, 123,   0, 124,
      0, 124,   0, 124,   0, 124, 123, 123, 123, 123, 123, 123, 123, 123, 124, 124, 124, 124,
    124, 124, 124, 124, 125, 125, 126, 126, 126, 126, 127, 127, 128, 128, 129, 129, 130, 130,
      0,   0, 123, 123, 123, 123, 123, 123, 123, 123, 124, 124, 124, 124, 124, 124, 124, 124,
    123, 123, 123, 123, 123, 123, 123, 123, 124, 124, 124, 124, 124, 124, 124, 124, 123, 123,
    123, 123, 123, 123, 123, 123, 124, 124, 124, 124, 124, 124, 124, 124, 123, 123,   5, 131,
      5,   0,   5,   5, 124, 124, 132, 132, 133,   0, 134,   0,   0,   0,   5, 131,   5,   0,
      5,   5, 135, 135, 135, 135, 133,   0,   0,   0, 123, 123,   5,   5,   0,   0,   5,   5,
    124, 124, 136, 136,   0,   0,   0,   0, 123, 123,   5,   5,   5,  96,   5,   5, 124, 124,
    137, 137, 100,   0,   0,   0,   0,   0,   5, 131,   5,   0,   5,   5, 138, 138, 139, 139,
    133,   0,   0,   0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   0,   2,   2,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   0,   0,   0,   0,   0,   1,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   2,   0,   0,   0,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   5,   0,   0,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,   0,   0,   5,   5,   5,   5,
      5,   5,   0,   0,   0,   0,   0,   0,   5,   0, 140,   0,   5,   0, 141, 142,   5,   5,
      5,   5,   5,   5, 143,   5,   5,   5,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,
      0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   0,   0,   0,   0, 144,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 145, 145, 145, 145,
    145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 146, 146, 146, 146, 146, 146,
    146, 146, 146, 146, 146, 146, 146, 146, 146, 146,   5,   5,   5,   8,   9,   5,   5,   5,
      5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 147, 147, 147, 147, 147, 147,
    147, 147, 147, 147, 147, 147, 147, 147, 147, 147, 147, 147, 147, 147, 147, 147, 147, 147,
    147, 147, 148, 148, 148, 148, 148, 148, 148, 148, 148, 148, 148, 148, 148, 148, 148, 148,
    148, 148, 148, 148, 148, 148, 148, 148, 148, 148,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 104, 104, 104, 104,
    104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
    104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
    104, 104, 104, 104, 104, 104, 104,   0, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105,
    105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105,
    105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105,
    105,   0,   8,   9, 149, 150, 151, 152, 153,   8,   9,   8,   9,   8,   9, 154, 155, 156,
    157,   5,   8,   9,   5,   8,   9,   5,   5,   5,   5,   5,   5,   5, 158, 158,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   5,   0,
      0,   0,   0,   0,   0,   8,   9,   8,   9,   2,   2,   2,   8,   9,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159,
    159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159,
    159, 159, 159, 159, 159, 159, 159, 159, 159, 159,   0, 159,   0,   0,   0,   0,   0, 159,
      0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,
      5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,
      5,   0,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   0,
      5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   0,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   1,   0,   0,   0,   0,   5,
      5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      2,   2,   2,   2,   2,   2,   0,   5,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,
      5,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   2,   2,   5,   5,   5,   5,   5,
      0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   0,   5,   5,   5,   5,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   5,   2,   0,   0,
      0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   5,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   5,   5,   2,   2,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   5,   5,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   5,   5,   5,   5,   5,   5,   5,   5,   5,   8,   9,   8,   9, 160,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   5,   0,   0,   8,   9, 161,   5,   5,   8,   9,
      8,   9, 162,   5,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   8,   9,
      8,   9,   8,   9,   8,   9, 163, 164, 165, 166, 163,   5, 167, 168, 169, 170,   8,   9,
      8,   9,   8,   9,   8,   9,   8,   9,   8,   9,   0,   0,   8,   9, 171, 172, 173,   8,
      9,   8,   9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   9,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   2,   5,   5,   5,   2,   5,   5,   5,   5,   2,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   2,   2,   2,   2,   2,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   2,   2,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5,   5,   5,   5,   5,   5,   0,   0,
      0,   5,   0,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   0,   0,   0,   2,   2,   2,   2,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,
      5,   2,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   5,   5,   5,   2,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   0,   0,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   0,   0,   0,   5,   2,   2,   2,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   2,   5,   2,   2,   2,   5,   5,   2,   2,   5,   5,   5,
      5,   5,   2,   2,   5,   2,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   0,   0,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   0,   0,
      5,   5,   5,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,
      5,   5,   5,   0,   0,   5,   5,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,   5,
      5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   0,
      5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5, 174,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,
    175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175,
    175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175,
    175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175,
    175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 175,
    175, 175, 175, 175, 175, 175, 175, 175,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   2,   2,   2,   2,   2,   2,   2,   2,   0,   2,   2,
      0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,
      0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,
      0,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   5,   2,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   0,   5,   5,   5,   5,   5,   0,   5,   0,   5,   5,   0,   5,
      5,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   0,   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,
      2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   5,
      5,   5,   5,   0,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   0,   0,   0,   0,
      0,   0,   0,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   0,   0,   0,   0,   2,   0,   4,
      4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
      4,   4,   4,   4,   4,   4,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   0,
      0,   0,   5,   5,   5,   5,   5,   5,   0,   0,   5,   5,   5,   5,   5,   5,   0,   0,
      5,   5,   5,   5,   5,   5,   0,   0,   5,   5,   5,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
};

const FoldingInfo unicode::js_foldinfo[] = {
    { 0 },
    { 32 },
    { 775 },
    { 1 },
    { 65415 },
    { 65268 },
    { 210 },
    { 206 },
    { 205 },
    { 79 },
    { 202 },
    { 203 },
    { 207 },
    { 211 },
    { 209 },
    { 213 },
    { 214 },
    { 218 },
    { 217 },
    { 219 },
    { 2 },
    { 65439 },
    { 65480 },
    { 65406 },
    { 10795 },
    { 65373 },
    { 10792 },
    { 65341 },
    { 69 },
    { 71 },
    { 116 },
    { 38 },
    { 37 },
    { 64 },
    { 63 },
    { 8 },
    { 65506 },
    { 65511 },
    { 65521 },
    { 65514 },
    { 65482 },
    { 65488 },
    { 65476 },
    { 65472 },
    { 65529 },
    { 80 },
    { 15 },
    { 48 },
    { 7264 },
    { 65528 },
    { 59314 },
    { 59315 },
    { 59324 },
    { 59326 },
    { 59325 },
    { 59332 },
    { 59356 },
    { 35267 },
    { 62528 },
    { 65478 },
    { 57921 },
    { 65462 },
    { 65527 },
    { 58363 },
    { 65450 },
    { 65436 },
    { 65424 },
    { 65408 },
    { 65410 },
    { 58019 },
    { 57153 },
    { 57274 },
    { 28 },
    { 16 },
    { 26 },
    { 54793 },
    { 61722 },
    { 54809 },
    { 54756 },
    { 54787 },
    { 54753 },
    { 54754 },
    { 54721 },
    { 30204 },
    { 23256 },
    { 23228 },
    { 23217 },
    { 23221 },
    { 23231 },
    { 23278 },
    { 23254 },
    { 23275 },
    { 928 },
    { 23229 },
    { 30152 },
    { 26672 },
};

const uint8_t unicode::folding_index1[] = {
      0,   0,   1,   0,   0,   2,   3,   0,   4,   5,   6,   7,   8,   9,  10,  11,   4,  12,
     13,   0,   0,   0,   0,   0,   0,   0,  14,  15,  16,  17,  18,  19,  20,  21,   0,   4,
     22,   4,  23,   4,   4,  24,  25,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,  26,  27,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  28,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  29,  30,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   4,   4,   4,   4,  31,   4,   4,   4,  32,  33,  34,  35,
     33,  36,  37,  38,   0,   0,   0,   0,   0,   0,   0,   0,   0,  39,   0,  40,  41,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,  42,  43,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  44,  45,   0,  46,   4,   4,   4,  47,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,  48,
     49,   0,   0,   0,   0,  50,   4,  51,  52,  53,  54,  55,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,  56,  57,  57,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,
};

const uint8_t unicode::folding_index2[] = {
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   0,   1,   1,   1,   1,   1,   1,
      1,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,
      3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,
      3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   0,   0,   3,   0,
      3,   0,   3,   0,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,
      0,   3,   0,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,
      3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,
      3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   4,   3,   0,   3,
      0,   3,   0,   5,   0,   6,   3,   0,   3,   0,   7,   3,   0,   8,   8,   3,   0,   0,
      9,  10,  11,   3,   0,   8,  12,   0,  13,  14,   3,   0,   0,   0,  13,  15,   0,  16,
      3,   0,   3,   0,   3,   0,  17,   3,   0,  17,   0,   0,   3,   0,  17,   3,   0,  18,
     18,   3,   0,   3,   0,  19,   3,   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,
     20,   3,   0,  20,   3,   0,  20,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,
      0,   3,   0,   3,   0,   3,   0,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,
      3,   0,   3,   0,   3,   0,   3,   0,   0,  20,   3,   0,   3,   0,  21,  22,   3,   0,
      3,   0,   3,   0,   3,   0,  23,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,
      3,   0,   3,   0,   3,   0,   3,   0,   0,   0,   0,   0,   0,   0,  24,   3,   0,  25,
     26,   0,   0,   3,   0,  27,  28,  29,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,  30,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   3,   0,   0,   0,   3,   0,
      0,   0,   0,   0,   0,   0,   0,  30,   0,   0,   0,   0,   0,   0,  31,   0,  32,  32,
     32,   0,  33,   0,  34,  34,   0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  35,  36,  37,
      0,   0,   0,  38,  39,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,
      3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,  40,  41,   0,   0,  42,  43,
      0,   3,   0,  44,   3,   0,   0,  23,  23,  23,  45,  45,  45,  45,  45,  45,  45,  45,
     45,  45,  45,  45,  45,  45,  45,  45,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
      1,   1,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   3,   0,   3,   0,
      3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,  46,   3,
      0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   0,   3,   0,   3,   0,
      3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,
      3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   0,  47,  47,  47,  47,  47,  47,  47,
     47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,
     47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,  48,
     48,  48,  48,  48,  48,  48,   0,  48,   0,   0,   0,   0,   0,  48,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,  49,  49,  49,  49,  49,  49,   0,   0,  50,  51,  52,  53,  53,  54,  55,  56,
     57,   0,   0,   0,   0,   0,   0,   0,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,
     58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,
     58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,  58,   0,   0,  58,
     58,  58,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,
      3,   0,   3,   0,   3,   0,   0,   0,   0,   0,   0,  59,   0,   0,  60,   0,   0,   0,
      0,   0,   0,   0,   0,   0,  49,  49,  49,  49,  49,  49,  49,  49,   0,   0,   0,   0,
      0,   0,   0,   0,  49,  49,  49,  49,  49,  49,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,  49,  49,  49,  49,  49,  49,  49,  49,   0,   0,   0,   0,   0,   0,   0,   0,
     49,  49,  49,  49,  49,  49,  49,  49,   0,   0,   0,   0,   0,   0,   0,   0,  49,  49,
     49,  49,  49,  49,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  49,   0,  49,
      0,  49,   0,  49,   0,   0,   0,   0,   0,   0,   0,   0,  49,  49,  49,  49,  49,  49,
     49,  49,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  49,  49,  49,  49,  49,  49,  49,  49,   0,   0,
      0,   0,   0,   0,   0,   0,  49,  49,  61,  61,  62,   0,  63,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  64,  64,  64,  64,  62,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,  49,  49,  65,  65,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     49,  49,  66,  66,  44,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  67,  67,
     68,  68,  62,   0,   0,   0,   0,   0,   0,   0,   0,   0,  69,   0,   0,   0,  70,  71,
      0,   0,   0,   0,   0,   0,  72,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,  73,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  74,  74,
     74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,  74,
     74,  74,  74,  74,  74,  74,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,
     47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,
     47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,  75,  76,
     77,   0,   0,   3,   0,   3,   0,   3,   0,  78,  79,  80,  81,   0,   3,   0,   0,   3,
      0,   0,   0,   0,   0,   0,   0,   0,  82,  82,   3,   0,   3,   0,   0,   0,   0,   0,
      0,   0,   0,   3,   0,   3,   0,   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,
      3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,
      3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   0,   0,   0,   0,   0,   0,
      3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   0,   0,   3,   0,
      3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,
      3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   3,   0,   3,   0,  83,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   0,   0,
      0,   3,   0,  84,   0,   0,   3,   0,   3,   0,   0,   0,   3,   0,   3,   0,   3,   0,
      3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,  85,  86,  87,  88,
     85,   0,  89,  90,  91,  92,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,   3,   0,
      0,   0,   3,   0,  41,  93,  94,   3,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,
     95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,
     95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,  95,
     95,  95,
};

bool
js::unicode::IsIdentifierStartNonBMP(uint32_t codePoint)
{
    if (codePoint >= 0x10000 && codePoint <= 0x1000B) { // LINEAR B SYLLABLE B008 A .. LINEAR B SYLLABLE B046 JE
        return true;
    }
    if (codePoint >= 0x1000D && codePoint <= 0x10026) { // LINEAR B SYLLABLE B036 JO .. LINEAR B SYLLABLE B032 QO
        return true;
    }
    if (codePoint >= 0x10028 && codePoint <= 0x1003A) { // LINEAR B SYLLABLE B060 RA .. LINEAR B SYLLABLE B042 WO
        return true;
    }
    if (codePoint >= 0x1003C && codePoint <= 0x1003D) { // LINEAR B SYLLABLE B017 ZA .. LINEAR B SYLLABLE B074 ZE
        return true;
    }
    if (codePoint >= 0x1003F && codePoint <= 0x1004D) { // LINEAR B SYLLABLE B020 ZO .. LINEAR B SYLLABLE B091 TWO
        return true;
    }
    if (codePoint >= 0x10050 && codePoint <= 0x1005D) { // LINEAR B SYMBOL B018 .. LINEAR B SYMBOL B089
        return true;
    }
    if (codePoint >= 0x10080 && codePoint <= 0x100FA) { // LINEAR B IDEOGRAM B100 MAN .. LINEAR B IDEOGRAM VESSEL B305
        return true;
    }
    if (codePoint >= 0x10140 && codePoint <= 0x10174) { // GREEK ACROPHONIC ATTIC ONE QUARTER .. GREEK ACROPHONIC STRATIAN FIFTY MNAS
        return true;
    }
    if (codePoint >= 0x10280 && codePoint <= 0x1029C) { // LYCIAN LETTER A .. LYCIAN LETTER X
        return true;
    }
    if (codePoint >= 0x102A0 && codePoint <= 0x102D0) { // CARIAN LETTER A .. CARIAN LETTER UUU3
        return true;
    }
    if (codePoint >= 0x10300 && codePoint <= 0x1031F) { // OLD ITALIC LETTER A .. OLD ITALIC LETTER ESS
        return true;
    }
    if (codePoint >= 0x1032D && codePoint <= 0x1034A) { // OLD ITALIC LETTER YE .. GOTHIC LETTER NINE HUNDRED
        return true;
    }
    if (codePoint >= 0x10350 && codePoint <= 0x10375) { // OLD PERMIC LETTER AN .. OLD PERMIC LETTER IA
        return true;
    }
    if (codePoint >= 0x10380 && codePoint <= 0x1039D) { // UGARITIC LETTER ALPA .. UGARITIC LETTER SSU
        return true;
    }
    if (codePoint >= 0x103A0 && codePoint <= 0x103C3) { // OLD PERSIAN SIGN A .. OLD PERSIAN SIGN HA
        return true;
    }
    if (codePoint >= 0x103C8 && codePoint <= 0x103CF) { // OLD PERSIAN SIGN AURAMAZDAA .. OLD PERSIAN SIGN BUUMISH
        return true;
    }
    if (codePoint >= 0x103D1 && codePoint <= 0x103D5) { // OLD PERSIAN NUMBER ONE .. OLD PERSIAN NUMBER HUNDRED
        return true;
    }
    if (codePoint >= 0x10400 && codePoint <= 0x1049D) { // DESERET CAPITAL LETTER LONG I .. OSMANYA LETTER OO
        return true;
    }
    if (codePoint >= 0x104B0 && codePoint <= 0x104D3) { // OSAGE CAPITAL LETTER A .. OSAGE CAPITAL LETTER ZHA
        return true;
    }
    if (codePoint >= 0x104D8 && codePoint <= 0x104FB) { // OSAGE SMALL LETTER A .. OSAGE SMALL LETTER ZHA
        return true;
    }
    if (codePoint >= 0x10500 && codePoint <= 0x10527) { // ELBASAN LETTER A .. ELBASAN LETTER KHE
        return true;
    }
    if (codePoint >= 0x10530 && codePoint <= 0x10563) { // CAUCASIAN ALBANIAN LETTER ALT .. CAUCASIAN ALBANIAN LETTER KIW
        return true;
    }
    if (codePoint >= 0x10600 && codePoint <= 0x10736) { // LINEAR A SIGN AB001 .. LINEAR A SIGN A664
        return true;
    }
    if (codePoint >= 0x10740 && codePoint <= 0x10755) { // LINEAR A SIGN A701 A .. LINEAR A SIGN A732 JE
        return true;
    }
    if (codePoint >= 0x10760 && codePoint <= 0x10767) { // LINEAR A SIGN A800 .. LINEAR A SIGN A807
        return true;
    }
    if (codePoint >= 0x10800 && codePoint <= 0x10805) { // CYPRIOT SYLLABLE A .. CYPRIOT SYLLABLE JA
        return true;
    }
    if (codePoint >= 0x10808 && codePoint <= 0x10808) { // CYPRIOT SYLLABLE JO .. CYPRIOT SYLLABLE JO
        return true;
    }
    if (codePoint >= 0x1080A && codePoint <= 0x10835) { // CYPRIOT SYLLABLE KA .. CYPRIOT SYLLABLE WO
        return true;
    }
    if (codePoint >= 0x10837 && codePoint <= 0x10838) { // CYPRIOT SYLLABLE XA .. CYPRIOT SYLLABLE XE
        return true;
    }
    if (codePoint >= 0x1083C && codePoint <= 0x1083C) { // CYPRIOT SYLLABLE ZA .. CYPRIOT SYLLABLE ZA
        return true;
    }
    if (codePoint >= 0x1083F && codePoint <= 0x10855) { // CYPRIOT SYLLABLE ZO .. IMPERIAL ARAMAIC LETTER TAW
        return true;
    }
    if (codePoint >= 0x10860 && codePoint <= 0x10876) { // PALMYRENE LETTER ALEPH .. PALMYRENE LETTER TAW
        return true;
    }
    if (codePoint >= 0x10880 && codePoint <= 0x1089E) { // NABATAEAN LETTER FINAL ALEPH .. NABATAEAN LETTER TAW
        return true;
    }
    if (codePoint >= 0x108E0 && codePoint <= 0x108F2) { // HATRAN LETTER ALEPH .. HATRAN LETTER QOPH
        return true;
    }
    if (codePoint >= 0x108F4 && codePoint <= 0x108F5) { // HATRAN LETTER SHIN .. HATRAN LETTER TAW
        return true;
    }
    if (codePoint >= 0x10900 && codePoint <= 0x10915) { // PHOENICIAN LETTER ALF .. PHOENICIAN LETTER TAU
        return true;
    }
    if (codePoint >= 0x10920 && codePoint <= 0x10939) { // LYDIAN LETTER A .. LYDIAN LETTER C
        return true;
    }
    if (codePoint >= 0x10980 && codePoint <= 0x109B7) { // MEROITIC HIEROGLYPHIC LETTER A .. MEROITIC CURSIVE LETTER DA
        return true;
    }
    if (codePoint >= 0x109BE && codePoint <= 0x109BF) { // MEROITIC CURSIVE LOGOGRAM RMT .. MEROITIC CURSIVE LOGOGRAM IMN
        return true;
    }
    if (codePoint >= 0x10A00 && codePoint <= 0x10A00) { // KHAROSHTHI LETTER A .. KHAROSHTHI LETTER A
        return true;
    }
    if (codePoint >= 0x10A10 && codePoint <= 0x10A13) { // KHAROSHTHI LETTER KA .. KHAROSHTHI LETTER GHA
        return true;
    }
    if (codePoint >= 0x10A15 && codePoint <= 0x10A17) { // KHAROSHTHI LETTER CA .. KHAROSHTHI LETTER JA
        return true;
    }
    if (codePoint >= 0x10A19 && codePoint <= 0x10A35) { // KHAROSHTHI LETTER NYA .. KHAROSHTHI LETTER VHA
        return true;
    }
    if (codePoint >= 0x10A60 && codePoint <= 0x10A7C) { // OLD SOUTH ARABIAN LETTER HE .. OLD SOUTH ARABIAN LETTER THETH
        return true;
    }
    if (codePoint >= 0x10A80 && codePoint <= 0x10A9C) { // OLD NORTH ARABIAN LETTER HEH .. OLD NORTH ARABIAN LETTER ZAH
        return true;
    }
    if (codePoint >= 0x10AC0 && codePoint <= 0x10AC7) { // MANICHAEAN LETTER ALEPH .. MANICHAEAN LETTER WAW
        return true;
    }
    if (codePoint >= 0x10AC9 && codePoint <= 0x10AE4) { // MANICHAEAN LETTER ZAYIN .. MANICHAEAN LETTER TAW
        return true;
    }
    if (codePoint >= 0x10B00 && codePoint <= 0x10B35) { // AVESTAN LETTER A .. AVESTAN LETTER HE
        return true;
    }
    if (codePoint >= 0x10B40 && codePoint <= 0x10B55) { // INSCRIPTIONAL PARTHIAN LETTER ALEPH .. INSCRIPTIONAL PARTHIAN LETTER TAW
        return true;
    }
    if (codePoint >= 0x10B60 && codePoint <= 0x10B72) { // INSCRIPTIONAL PAHLAVI LETTER ALEPH .. INSCRIPTIONAL PAHLAVI LETTER TAW
        return true;
    }
    if (codePoint >= 0x10B80 && codePoint <= 0x10B91) { // PSALTER PAHLAVI LETTER ALEPH .. PSALTER PAHLAVI LETTER TAW
        return true;
    }
    if (codePoint >= 0x10C00 && codePoint <= 0x10C48) { // OLD TURKIC LETTER ORKHON A .. OLD TURKIC LETTER ORKHON BASH
        return true;
    }
    if (codePoint >= 0x10C80 && codePoint <= 0x10CB2) { // OLD HUNGARIAN CAPITAL LETTER A .. OLD HUNGARIAN CAPITAL LETTER US
        return true;
    }
    if (codePoint >= 0x10CC0 && codePoint <= 0x10CF2) { // OLD HUNGARIAN SMALL LETTER A .. OLD HUNGARIAN SMALL LETTER US
        return true;
    }
    if (codePoint >= 0x10D00 && codePoint <= 0x10D23) { // HANIFI ROHINGYA LETTER A .. HANIFI ROHINGYA MARK NA KHONNA
        return true;
    }
    if (codePoint >= 0x10E80 && codePoint <= 0x10EA9) { // YEZIDI LETTER ELIF .. YEZIDI LETTER ET
        return true;
    }
    if (codePoint >= 0x10EB0 && codePoint <= 0x10EB1) { // YEZIDI LETTER LAM WITH DOT ABOVE .. YEZIDI LETTER YOT WITH CIRCUMFLEX ABOVE
        return true;
    }
    if (codePoint >= 0x10F00 && codePoint <= 0x10F1C) { // OLD SOGDIAN LETTER ALEPH .. OLD SOGDIAN LETTER FINAL TAW WITH VERTICAL TAIL
        return true;
    }
    if (codePoint >= 0x10F27 && codePoint <= 0x10F27) { // OLD SOGDIAN LIGATURE AYIN-DALETH .. OLD SOGDIAN LIGATURE AYIN-DALETH
        return true;
    }
    if (codePoint >= 0x10F30 && codePoint <= 0x10F45) { // SOGDIAN LETTER ALEPH .. SOGDIAN INDEPENDENT SHIN
        return true;
    }
    if (codePoint >= 0x10FB0 && codePoint <= 0x10FC4) { // CHORASMIAN LETTER ALEPH .. CHORASMIAN LETTER TAW
        return true;
    }
    if (codePoint >= 0x10FE0 && codePoint <= 0x10FF6) { // ELYMAIC LETTER ALEPH .. ELYMAIC LIGATURE ZAYIN-YODH
        return true;
    }
    if (codePoint >= 0x11003 && codePoint <= 0x11037) { // BRAHMI SIGN JIHVAMULIYA .. BRAHMI LETTER OLD TAMIL NNNA
        return true;
    }
    if (codePoint >= 0x11083 && codePoint <= 0x110AF) { // KAITHI LETTER A .. KAITHI LETTER HA
        return true;
    }
    if (codePoint >= 0x110D0 && codePoint <= 0x110E8) { // SORA SOMPENG LETTER SAH .. SORA SOMPENG LETTER MAE
        return true;
    }
    if (codePoint >= 0x11103 && codePoint <= 0x11126) { // CHAKMA LETTER AA .. CHAKMA LETTER HAA
        return true;
    }
    if (codePoint >= 0x11144 && codePoint <= 0x11144) { // CHAKMA LETTER LHAA .. CHAKMA LETTER LHAA
        return true;
    }
    if (codePoint >= 0x11147 && codePoint <= 0x11147) { // CHAKMA LETTER VAA .. CHAKMA LETTER VAA
        return true;
    }
    if (codePoint >= 0x11150 && codePoint <= 0x11172) { // MAHAJANI LETTER A .. MAHAJANI LETTER RRA
        return true;
    }
    if (codePoint >= 0x11176 && codePoint <= 0x11176) { // MAHAJANI LIGATURE SHRI .. MAHAJANI LIGATURE SHRI
        return true;
    }
    if (codePoint >= 0x11183 && codePoint <= 0x111B2) { // SHARADA LETTER A .. SHARADA LETTER HA
        return true;
    }
    if (codePoint >= 0x111C1 && codePoint <= 0x111C4) { // SHARADA SIGN AVAGRAHA .. SHARADA OM
        return true;
    }
    if (codePoint >= 0x111DA && codePoint <= 0x111DA) { // SHARADA EKAM .. SHARADA EKAM
        return true;
    }
    if (codePoint >= 0x111DC && codePoint <= 0x111DC) { // SHARADA HEADSTROKE .. SHARADA HEADSTROKE
        return true;
    }
    if (codePoint >= 0x11200 && codePoint <= 0x11211) { // KHOJKI LETTER A .. KHOJKI LETTER JJA
        return true;
    }
    if (codePoint >= 0x11213 && codePoint <= 0x1122B) { // KHOJKI LETTER NYA .. KHOJKI LETTER LLA
        return true;
    }
    if (codePoint >= 0x11280 && codePoint <= 0x11286) { // MULTANI LETTER A .. MULTANI LETTER GA
        return true;
    }
    if (codePoint >= 0x11288 && codePoint <= 0x11288) { // MULTANI LETTER GHA .. MULTANI LETTER GHA
        return true;
    }
    if (codePoint >= 0x1128A && codePoint <= 0x1128D) { // MULTANI LETTER CA .. MULTANI LETTER JJA
        return true;
    }
    if (codePoint >= 0x1128F && codePoint <= 0x1129D) { // MULTANI LETTER NYA .. MULTANI LETTER BA
        return true;
    }
    if (codePoint >= 0x1129F && codePoint <= 0x112A8) { // MULTANI LETTER BHA .. MULTANI LETTER RHA
        return true;
    }
    if (codePoint >= 0x112B0 && codePoint <= 0x112DE) { // KHUDAWADI LETTER A .. KHUDAWADI LETTER HA
        return true;
    }
    if (codePoint >= 0x11305 && codePoint <= 0x1130C) { // GRANTHA LETTER A .. GRANTHA LETTER VOCALIC L
        return true;
    }
    if (codePoint >= 0x1130F && codePoint <= 0x11310) { // GRANTHA LETTER EE .. GRANTHA LETTER AI
        return true;
    }
    if (codePoint >= 0x11313 && codePoint <= 0x11328) { // GRANTHA LETTER OO .. GRANTHA LETTER NA
        return true;
    }
    if (codePoint >= 0x1132A && codePoint <= 0x11330) { // GRANTHA LETTER PA .. GRANTHA LETTER RA
        return true;
    }
    if (codePoint >= 0x11332 && codePoint <= 0x11333) { // GRANTHA LETTER LA .. GRANTHA LETTER LLA
        return true;
    }
    if (codePoint >= 0x11335 && codePoint <= 0x11339) { // GRANTHA LETTER VA .. GRANTHA LETTER HA
        return true;
    }
    if (codePoint >= 0x1133D && codePoint <= 0x1133D) { // GRANTHA SIGN AVAGRAHA .. GRANTHA SIGN AVAGRAHA
        return true;
    }
    if (codePoint >= 0x11350 && codePoint <= 0x11350) { // GRANTHA OM .. GRANTHA OM
        return true;
    }
    if (codePoint >= 0x1135D && codePoint <= 0x11361) { // GRANTHA SIGN PLUTA .. GRANTHA LETTER VOCALIC LL
        return true;
    }
    if (codePoint >= 0x11400 && codePoint <= 0x11434) { // NEWA LETTER A .. NEWA LETTER HA
        return true;
    }
    if (codePoint >= 0x11447 && codePoint <= 0x1144A) { // NEWA SIGN AVAGRAHA .. NEWA SIDDHI
        return true;
    }
    if (codePoint >= 0x1145F && codePoint <= 0x11461) { // NEWA LETTER VEDIC ANUSVARA .. NEWA SIGN UPADHMANIYA
        return true;
    }
    if (codePoint >= 0x11480 && codePoint <= 0x114AF) { // TIRHUTA ANJI .. TIRHUTA LETTER HA
        return true;
    }
    if (codePoint >= 0x114C4 && codePoint <= 0x114C5) { // TIRHUTA SIGN AVAGRAHA .. TIRHUTA GVANG
        return true;
    }
    if (codePoint >= 0x114C7 && codePoint <= 0x114C7) { // TIRHUTA OM .. TIRHUTA OM
        return true;
    }
    if (codePoint >= 0x11580 && codePoint <= 0x115AE) { // SIDDHAM LETTER A .. SIDDHAM LETTER HA
        return true;
    }
    if (codePoint >= 0x115D8 && codePoint <= 0x115DB) { // SIDDHAM LETTER THREE-CIRCLE ALTERNATE I .. SIDDHAM LETTER ALTERNATE U
        return true;
    }
    if (codePoint >= 0x11600 && codePoint <= 0x1162F) { // MODI LETTER A .. MODI LETTER LLA
        return true;
    }
    if (codePoint >= 0x11644 && codePoint <= 0x11644) { // MODI SIGN HUVA .. MODI SIGN HUVA
        return true;
    }
    if (codePoint >= 0x11680 && codePoint <= 0x116AA) { // TAKRI LETTER A .. TAKRI LETTER RRA
        return true;
    }
    if (codePoint >= 0x116B8 && codePoint <= 0x116B8) { // TAKRI LETTER ARCHAIC KHA .. TAKRI LETTER ARCHAIC KHA
        return true;
    }
    if (codePoint >= 0x11700 && codePoint <= 0x1171A) { // AHOM LETTER KA .. AHOM LETTER ALTERNATE BA
        return true;
    }
    if (codePoint >= 0x11800 && codePoint <= 0x1182B) { // DOGRA LETTER A .. DOGRA LETTER RRA
        return true;
    }
    if (codePoint >= 0x118A0 && codePoint <= 0x118DF) { // WARANG CITI CAPITAL LETTER NGAA .. WARANG CITI SMALL LETTER VIYO
        return true;
    }
    if (codePoint >= 0x118FF && codePoint <= 0x11906) { // WARANG CITI OM .. DIVES AKURU LETTER E
        return true;
    }
    if (codePoint >= 0x11909 && codePoint <= 0x11909) { // DIVES AKURU LETTER O .. DIVES AKURU LETTER O
        return true;
    }
    if (codePoint >= 0x1190C && codePoint <= 0x11913) { // DIVES AKURU LETTER KA .. DIVES AKURU LETTER JA
        return true;
    }
    if (codePoint >= 0x11915 && codePoint <= 0x11916) { // DIVES AKURU LETTER NYA .. DIVES AKURU LETTER TTA
        return true;
    }
    if (codePoint >= 0x11918 && codePoint <= 0x1192F) { // DIVES AKURU LETTER DDA .. DIVES AKURU LETTER ZA
        return true;
    }
    if (codePoint >= 0x1193F && codePoint <= 0x1193F) { // DIVES AKURU PREFIXED NASAL SIGN .. DIVES AKURU PREFIXED NASAL SIGN
        return true;
    }
    if (codePoint >= 0x11941 && codePoint <= 0x11941) { // DIVES AKURU INITIAL RA .. DIVES AKURU INITIAL RA
        return true;
    }
    if (codePoint >= 0x119A0 && codePoint <= 0x119A7) { // NANDINAGARI LETTER A .. NANDINAGARI LETTER VOCALIC RR
        return true;
    }
    if (codePoint >= 0x119AA && codePoint <= 0x119D0) { // NANDINAGARI LETTER E .. NANDINAGARI LETTER RRA
        return true;
    }
    if (codePoint >= 0x119E1 && codePoint <= 0x119E1) { // NANDINAGARI SIGN AVAGRAHA .. NANDINAGARI SIGN AVAGRAHA
        return true;
    }
    if (codePoint >= 0x119E3 && codePoint <= 0x119E3) { // NANDINAGARI HEADSTROKE .. NANDINAGARI HEADSTROKE
        return true;
    }
    if (codePoint >= 0x11A00 && codePoint <= 0x11A00) { // ZANABAZAR SQUARE LETTER A .. ZANABAZAR SQUARE LETTER A
        return true;
    }
    if (codePoint >= 0x11A0B && codePoint <= 0x11A32) { // ZANABAZAR SQUARE LETTER KA .. ZANABAZAR SQUARE LETTER KSSA
        return true;
    }
    if (codePoint >= 0x11A3A && codePoint <= 0x11A3A) { // ZANABAZAR SQUARE CLUSTER-INITIAL LETTER RA .. ZANABAZAR SQUARE CLUSTER-INITIAL LETTER RA
        return true;
    }
    if (codePoint >= 0x11A50 && codePoint <= 0x11A50) { // SOYOMBO LETTER A .. SOYOMBO LETTER A
        return true;
    }
    if (codePoint >= 0x11A5C && codePoint <= 0x11A89) { // SOYOMBO LETTER KA .. SOYOMBO CLUSTER-INITIAL LETTER SA
        return true;
    }
    if (codePoint >= 0x11A9D && codePoint <= 0x11A9D) { // SOYOMBO MARK PLUTA .. SOYOMBO MARK PLUTA
        return true;
    }
    if (codePoint >= 0x11AC0 && codePoint <= 0x11AF8) { // PAU CIN HAU LETTER PA .. PAU CIN HAU GLOTTAL STOP FINAL
        return true;
    }
    if (codePoint >= 0x11C00 && codePoint <= 0x11C08) { // BHAIKSUKI LETTER A .. BHAIKSUKI LETTER VOCALIC L
        return true;
    }
    if (codePoint >= 0x11C0A && codePoint <= 0x11C2E) { // BHAIKSUKI LETTER E .. BHAIKSUKI LETTER HA
        return true;
    }
    if (codePoint >= 0x11C40 && codePoint <= 0x11C40) { // BHAIKSUKI SIGN AVAGRAHA .. BHAIKSUKI SIGN AVAGRAHA
        return true;
    }
    if (codePoint >= 0x11C72 && codePoint <= 0x11C8F) { // MARCHEN LETTER KA .. MARCHEN LETTER A
        return true;
    }
    if (codePoint >= 0x11D00 && codePoint <= 0x11D06) { // MASARAM GONDI LETTER A .. MASARAM GONDI LETTER E
        return true;
    }
    if (codePoint >= 0x11D08 && codePoint <= 0x11D09) { // MASARAM GONDI LETTER AI .. MASARAM GONDI LETTER O
        return true;
    }
    if (codePoint >= 0x11D0B && codePoint <= 0x11D30) { // MASARAM GONDI LETTER AU .. MASARAM GONDI LETTER TRA
        return true;
    }
    if (codePoint >= 0x11D46 && codePoint <= 0x11D46) { // MASARAM GONDI REPHA .. MASARAM GONDI REPHA
        return true;
    }
    if (codePoint >= 0x11D60 && codePoint <= 0x11D65) { // GUNJALA GONDI LETTER A .. GUNJALA GONDI LETTER UU
        return true;
    }
    if (codePoint >= 0x11D67 && codePoint <= 0x11D68) { // GUNJALA GONDI LETTER EE .. GUNJALA GONDI LETTER AI
        return true;
    }
    if (codePoint >= 0x11D6A && codePoint <= 0x11D89) { // GUNJALA GONDI LETTER OO .. GUNJALA GONDI LETTER SA
        return true;
    }
    if (codePoint >= 0x11D98 && codePoint <= 0x11D98) { // GUNJALA GONDI OM .. GUNJALA GONDI OM
        return true;
    }
    if (codePoint >= 0x11EE0 && codePoint <= 0x11EF2) { // MAKASAR LETTER KA .. MAKASAR ANGKA
        return true;
    }
    if (codePoint >= 0x11FB0 && codePoint <= 0x11FB0) { // LISU LETTER YHA .. LISU LETTER YHA
        return true;
    }
    if (codePoint >= 0x12000 && codePoint <= 0x12399) { // CUNEIFORM SIGN A .. CUNEIFORM SIGN U U
        return true;
    }
    if (codePoint >= 0x12400 && codePoint <= 0x1246E) { // CUNEIFORM NUMERIC SIGN TWO ASH .. CUNEIFORM NUMERIC SIGN NINE U VARIANT FORM
        return true;
    }
    if (codePoint >= 0x12480 && codePoint <= 0x12543) { // CUNEIFORM SIGN AB TIMES NUN TENU .. CUNEIFORM SIGN ZU5 TIMES THREE DISH TENU
        return true;
    }
    if (codePoint >= 0x13000 && codePoint <= 0x1342E) { // EGYPTIAN HIEROGLYPH A001 .. EGYPTIAN HIEROGLYPH AA032
        return true;
    }
    if (codePoint >= 0x14400 && codePoint <= 0x14646) { // ANATOLIAN HIEROGLYPH A001 .. ANATOLIAN HIEROGLYPH A530
        return true;
    }
    if (codePoint >= 0x16800 && codePoint <= 0x16A38) { // BAMUM LETTER PHASE-A NGKUE MFON .. BAMUM LETTER PHASE-F VUEQ
        return true;
    }
    if (codePoint >= 0x16A40 && codePoint <= 0x16A5E) { // MRO LETTER TA .. MRO LETTER TEK
        return true;
    }
    if (codePoint >= 0x16AD0 && codePoint <= 0x16AED) { // BASSA VAH LETTER ENNI .. BASSA VAH LETTER I
        return true;
    }
    if (codePoint >= 0x16B00 && codePoint <= 0x16B2F) { // PAHAWH HMONG VOWEL KEEB .. PAHAWH HMONG CONSONANT CAU
        return true;
    }
    if (codePoint >= 0x16B40 && codePoint <= 0x16B43) { // PAHAWH HMONG SIGN VOS SEEV .. PAHAWH HMONG SIGN IB YAM
        return true;
    }
    if (codePoint >= 0x16B63 && codePoint <= 0x16B77) { // PAHAWH HMONG SIGN VOS LUB .. PAHAWH HMONG SIGN CIM NRES TOS
        return true;
    }
    if (codePoint >= 0x16B7D && codePoint <= 0x16B8F) { // PAHAWH HMONG CLAN SIGN TSHEEJ .. PAHAWH HMONG CLAN SIGN VWJ
        return true;
    }
    if (codePoint >= 0x16E40 && codePoint <= 0x16E7F) { // MEDEFAIDRIN CAPITAL LETTER M .. MEDEFAIDRIN SMALL LETTER Y
        return true;
    }
    if (codePoint >= 0x16F00 && codePoint <= 0x16F4A) { // MIAO LETTER PA .. MIAO LETTER RTE
        return true;
    }
    if (codePoint >= 0x16F50 && codePoint <= 0x16F50) { // MIAO LETTER NASALIZATION .. MIAO LETTER NASALIZATION
        return true;
    }
    if (codePoint >= 0x16F93 && codePoint <= 0x16F9F) { // MIAO LETTER TONE-2 .. MIAO LETTER REFORMED TONE-8
        return true;
    }
    if (codePoint >= 0x16FE0 && codePoint <= 0x16FE1) { // TANGUT ITERATION MARK .. NUSHU ITERATION MARK
        return true;
    }
    if (codePoint >= 0x16FE3 && codePoint <= 0x16FE3) { // OLD CHINESE ITERATION MARK .. OLD CHINESE ITERATION MARK
        return true;
    }
    if (codePoint >= 0x17000 && codePoint <= 0x187F7) { // Tangut Ideograph .. Tangut Ideograph
        return true;
    }
    if (codePoint >= 0x18800 && codePoint <= 0x18CD5) { // TANGUT COMPONENT-001 .. KHITAN SMALL SCRIPT CHARACTER-18CD5
        return true;
    }
    if (codePoint >= 0x18D00 && codePoint <= 0x18D08) { // Tangut Ideograph Supplement .. Tangut Ideograph Supplement
        return true;
    }
    if (codePoint >= 0x1B000 && codePoint <= 0x1B11E) { // KATAKANA LETTER ARCHAIC E .. HENTAIGANA LETTER N-MU-MO-2
        return true;
    }
    if (codePoint >= 0x1B150 && codePoint <= 0x1B152) { // HIRAGANA LETTER SMALL WI .. HIRAGANA LETTER SMALL WO
        return true;
    }
    if (codePoint >= 0x1B164 && codePoint <= 0x1B167) { // KATAKANA LETTER SMALL WI .. KATAKANA LETTER SMALL N
        return true;
    }
    if (codePoint >= 0x1B170 && codePoint <= 0x1B2FB) { // NUSHU CHARACTER-1B170 .. NUSHU CHARACTER-1B2FB
        return true;
    }
    if (codePoint >= 0x1BC00 && codePoint <= 0x1BC6A) { // DUPLOYAN LETTER H .. DUPLOYAN LETTER VOCALIC M
        return true;
    }
    if (codePoint >= 0x1BC70 && codePoint <= 0x1BC7C) { // DUPLOYAN AFFIX LEFT HORIZONTAL SECANT .. DUPLOYAN AFFIX ATTACHED TANGENT HOOK
        return true;
    }
    if (codePoint >= 0x1BC80 && codePoint <= 0x1BC88) { // DUPLOYAN AFFIX HIGH ACUTE .. DUPLOYAN AFFIX HIGH VERTICAL
        return true;
    }
    if (codePoint >= 0x1BC90 && codePoint <= 0x1BC99) { // DUPLOYAN AFFIX LOW ACUTE .. DUPLOYAN AFFIX LOW ARROW
        return true;
    }
    if (codePoint >= 0x1D400 && codePoint <= 0x1D454) { // MATHEMATICAL BOLD CAPITAL A .. MATHEMATICAL ITALIC SMALL G
        return true;
    }
    if (codePoint >= 0x1D456 && codePoint <= 0x1D49C) { // MATHEMATICAL ITALIC SMALL I .. MATHEMATICAL SCRIPT CAPITAL A
        return true;
    }
    if (codePoint >= 0x1D49E && codePoint <= 0x1D49F) { // MATHEMATICAL SCRIPT CAPITAL C .. MATHEMATICAL SCRIPT CAPITAL D
        return true;
    }
    if (codePoint >= 0x1D4A2 && codePoint <= 0x1D4A2) { // MATHEMATICAL SCRIPT CAPITAL G .. MATHEMATICAL SCRIPT CAPITAL G
        return true;
    }
    if (codePoint >= 0x1D4A5 && codePoint <= 0x1D4A6) { // MATHEMATICAL SCRIPT CAPITAL J .. MATHEMATICAL SCRIPT CAPITAL K
        return true;
    }
    if (codePoint >= 0x1D4A9 && codePoint <= 0x1D4AC) { // MATHEMATICAL SCRIPT CAPITAL N .. MATHEMATICAL SCRIPT CAPITAL Q
        return true;
    }
    if (codePoint >= 0x1D4AE && codePoint <= 0x1D4B9) { // MATHEMATICAL SCRIPT CAPITAL S .. MATHEMATICAL SCRIPT SMALL D
        return true;
    }
    if (codePoint >= 0x1D4BB && codePoint <= 0x1D4BB) { // MATHEMATICAL SCRIPT SMALL F .. MATHEMATICAL SCRIPT SMALL F
        return true;
    }
    if (codePoint >= 0x1D4BD && codePoint <= 0x1D4C3) { // MATHEMATICAL SCRIPT SMALL H .. MATHEMATICAL SCRIPT SMALL N
        return true;
    }
    if (codePoint >= 0x1D4C5 && codePoint <= 0x1D505) { // MATHEMATICAL SCRIPT SMALL P .. MATHEMATICAL FRAKTUR CAPITAL B
        return true;
    }
    if (codePoint >= 0x1D507 && codePoint <= 0x1D50A) { // MATHEMATICAL FRAKTUR CAPITAL D .. MATHEMATICAL FRAKTUR CAPITAL G
        return true;
    }
    if (codePoint >= 0x1D50D && codePoint <= 0x1D514) { // MATHEMATICAL FRAKTUR CAPITAL J .. MATHEMATICAL FRAKTUR CAPITAL Q
        return true;
    }
    if (codePoint >= 0x1D516 && codePoint <= 0x1D51C) { // MATHEMATICAL FRAKTUR CAPITAL S .. MATHEMATICAL FRAKTUR CAPITAL Y
        return true;
    }
    if (codePoint >= 0x1D51E && codePoint <= 0x1D539) { // MATHEMATICAL FRAKTUR SMALL A .. MATHEMATICAL DOUBLE-STRUCK CAPITAL B
        return true;
    }
    if (codePoint >= 0x1D53B && codePoint <= 0x1D53E) { // MATHEMATICAL DOUBLE-STRUCK CAPITAL D .. MATHEMATICAL DOUBLE-STRUCK CAPITAL G
        return true;
    }
    if (codePoint >= 0x1D540 && codePoint <= 0x1D544) { // MATHEMATICAL DOUBLE-STRUCK CAPITAL I .. MATHEMATICAL DOUBLE-STRUCK CAPITAL M
        return true;
    }
    if (codePoint >= 0x1D546 && codePoint <= 0x1D546) { // MATHEMATICAL DOUBLE-STRUCK CAPITAL O .. MATHEMATICAL DOUBLE-STRUCK CAPITAL O
        return true;
    }
    if (codePoint >= 0x1D54A && codePoint <= 0x1D550) { // MATHEMATICAL DOUBLE-STRUCK CAPITAL S .. MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
        return true;
    }
    if (codePoint >= 0x1D552 && codePoint <= 0x1D6A5) { // MATHEMATICAL DOUBLE-STRUCK SMALL A .. MATHEMATICAL ITALIC SMALL DOTLESS J
        return true;
    }
    if (codePoint >= 0x1D6A8 && codePoint <= 0x1D6C0) { // MATHEMATICAL BOLD CAPITAL ALPHA .. MATHEMATICAL BOLD CAPITAL OMEGA
        return true;
    }
    if (codePoint >= 0x1D6C2 && codePoint <= 0x1D6DA) { // MATHEMATICAL BOLD SMALL ALPHA .. MATHEMATICAL BOLD SMALL OMEGA
        return true;
    }
    if (codePoint >= 0x1D6DC && codePoint <= 0x1D6FA) { // MATHEMATICAL BOLD EPSILON SYMBOL .. MATHEMATICAL ITALIC CAPITAL OMEGA
        return true;
    }
    if (codePoint >= 0x1D6FC && codePoint <= 0x1D714) { // MATHEMATICAL ITALIC SMALL ALPHA .. MATHEMATICAL ITALIC SMALL OMEGA
        return true;
    }
    if (codePoint >= 0x1D716 && codePoint <= 0x1D734) { // MATHEMATICAL ITALIC EPSILON SYMBOL .. MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
        return true;
    }
    if (codePoint >= 0x1D736 && codePoint <= 0x1D74E) { // MATHEMATICAL BOLD ITALIC SMALL ALPHA .. MATHEMATICAL BOLD ITALIC SMALL OMEGA
        return true;
    }
    if (codePoint >= 0x1D750 && codePoint <= 0x1D76E) { // MATHEMATICAL BOLD ITALIC EPSILON SYMBOL .. MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
        return true;
    }
    if (codePoint >= 0x1D770 && codePoint <= 0x1D788) { // MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA .. MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
        return true;
    }
    if (codePoint >= 0x1D78A && codePoint <= 0x1D7A8) { // MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL .. MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
        return true;
    }
    if (codePoint >= 0x1D7AA && codePoint <= 0x1D7C2) { // MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA .. MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
        return true;
    }
    if (codePoint >= 0x1D7C4 && codePoint <= 0x1D7CB) { // MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL .. MATHEMATICAL BOLD SMALL DIGAMMA
        return true;
    }
    if (codePoint >= 0x1E100 && codePoint <= 0x1E12C) { // NYIAKENG PUACHUE HMONG LETTER MA .. NYIAKENG PUACHUE HMONG LETTER W
        return true;
    }
    if (codePoint >= 0x1E137 && codePoint <= 0x1E13D) { // NYIAKENG PUACHUE HMONG SIGN FOR PERSON .. NYIAKENG PUACHUE HMONG SYLLABLE LENGTHENER
        return true;
    }
    if (codePoint >= 0x1E14E && codePoint <= 0x1E14E) { // NYIAKENG PUACHUE HMONG LOGOGRAM NYAJ .. NYIAKENG PUACHUE HMONG LOGOGRAM NYAJ
        return true;
    }
    if (codePoint >= 0x1E2C0 && codePoint <= 0x1E2EB) { // WANCHO LETTER AA .. WANCHO LETTER YIH
        return true;
    }
    if (codePoint >= 0x1E800 && codePoint <= 0x1E8C4) { // MENDE KIKAKUI SYLLABLE M001 KI .. MENDE KIKAKUI SYLLABLE M060 NYON
        return true;
    }
    if (codePoint >= 0x1E900 && codePoint <= 0x1E943) { // ADLAM CAPITAL LETTER ALIF .. ADLAM SMALL LETTER SHA
        return true;
    }
    if (codePoint >= 0x1E94B && codePoint <= 0x1E94B) { // ADLAM NASALIZATION MARK .. ADLAM NASALIZATION MARK
        return true;
    }
    if (codePoint >= 0x1EE00 && codePoint <= 0x1EE03) { // ARABIC MATHEMATICAL ALEF .. ARABIC MATHEMATICAL DAL
        return true;
    }
    if (codePoint >= 0x1EE05 && codePoint <= 0x1EE1F) { // ARABIC MATHEMATICAL WAW .. ARABIC MATHEMATICAL DOTLESS QAF
        return true;
    }
    if (codePoint >= 0x1EE21 && codePoint <= 0x1EE22) { // ARABIC MATHEMATICAL INITIAL BEH .. ARABIC MATHEMATICAL INITIAL JEEM
        return true;
    }
    if (codePoint >= 0x1EE24 && codePoint <= 0x1EE24) { // ARABIC MATHEMATICAL INITIAL HEH .. ARABIC MATHEMATICAL INITIAL HEH
        return true;
    }
    if (codePoint >= 0x1EE27 && codePoint <= 0x1EE27) { // ARABIC MATHEMATICAL INITIAL HAH .. ARABIC MATHEMATICAL INITIAL HAH
        return true;
    }
    if (codePoint >= 0x1EE29 && codePoint <= 0x1EE32) { // ARABIC MATHEMATICAL INITIAL YEH .. ARABIC MATHEMATICAL INITIAL QAF
        return true;
    }
    if (codePoint >= 0x1EE34 && codePoint <= 0x1EE37) { // ARABIC MATHEMATICAL INITIAL SHEEN .. ARABIC MATHEMATICAL INITIAL KHAH
        return true;
    }
    if (codePoint >= 0x1EE39 && codePoint <= 0x1EE39) { // ARABIC MATHEMATICAL INITIAL DAD .. ARABIC MATHEMATICAL INITIAL DAD
        return true;
    }
    if (codePoint >= 0x1EE3B && codePoint <= 0x1EE3B) { // ARABIC MATHEMATICAL INITIAL GHAIN .. ARABIC MATHEMATICAL INITIAL GHAIN
        return true;
    }
    if (codePoint >= 0x1EE42 && codePoint <= 0x1EE42) { // ARABIC MATHEMATICAL TAILED JEEM .. ARABIC MATHEMATICAL TAILED JEEM
        return true;
    }
    if (codePoint >= 0x1EE47 && codePoint <= 0x1EE47) { // ARABIC MATHEMATICAL TAILED HAH .. ARABIC MATHEMATICAL TAILED HAH
        return true;
    }
    if (codePoint >= 0x1EE49 && codePoint <= 0x1EE49) { // ARABIC MATHEMATICAL TAILED YEH .. ARABIC MATHEMATICAL TAILED YEH
        return true;
    }
    if (codePoint >= 0x1EE4B && codePoint <= 0x1EE4B) { // ARABIC MATHEMATICAL TAILED LAM .. ARABIC MATHEMATICAL TAILED LAM
        return true;
    }
    if (codePoint >= 0x1EE4D && codePoint <= 0x1EE4F) { // ARABIC MATHEMATICAL TAILED NOON .. ARABIC MATHEMATICAL TAILED AIN
        return true;
    }
    if (codePoint >= 0x1EE51 && codePoint <= 0x1EE52) { // ARABIC MATHEMATICAL TAILED SAD .. ARABIC MATHEMATICAL TAILED QAF
        return true;
    }
    if (codePoint >= 0x1EE54 && codePoint <= 0x1EE54) { // ARABIC MATHEMATICAL TAILED SHEEN .. ARABIC MATHEMATICAL TAILED SHEEN
        return true;
    }
    if (codePoint >= 0x1EE57 && codePoint <= 0x1EE57) { // ARABIC MATHEMATICAL TAILED KHAH .. ARABIC MATHEMATICAL TAILED KHAH
        return true;
    }
    if (codePoint >= 0x1EE59 && codePoint <= 0x1EE59) { // ARABIC MATHEMATICAL TAILED DAD .. ARABIC MATHEMATICAL TAILED DAD
        return true;
    }
    if (codePoint >= 0x1EE5B && codePoint <= 0x1EE5B) { // ARABIC MATHEMATICAL TAILED GHAIN .. ARABIC MATHEMATICAL TAILED GHAIN
        return true;
    }
    if (codePoint >= 0x1EE5D && codePoint <= 0x1EE5D) { // ARABIC MATHEMATICAL TAILED DOTLESS NOON .. ARABIC MATHEMATICAL TAILED DOTLESS NOON
        return true;
    }
    if (codePoint >= 0x1EE5F && codePoint <= 0x1EE5F) { // ARABIC MATHEMATICAL TAILED DOTLESS QAF .. ARABIC MATHEMATICAL TAILED DOTLESS QAF
        return true;
    }
    if (codePoint >= 0x1EE61 && codePoint <= 0x1EE62) { // ARABIC MATHEMATICAL STRETCHED BEH .. ARABIC MATHEMATICAL STRETCHED JEEM
        return true;
    }
    if (codePoint >= 0x1EE64 && codePoint <= 0x1EE64) { // ARABIC MATHEMATICAL STRETCHED HEH .. ARABIC MATHEMATICAL STRETCHED HEH
        return true;
    }
    if (codePoint >= 0x1EE67 && codePoint <= 0x1EE6A) { // ARABIC MATHEMATICAL STRETCHED HAH .. ARABIC MATHEMATICAL STRETCHED KAF
        return true;
    }
    if (codePoint >= 0x1EE6C && codePoint <= 0x1EE72) { // ARABIC MATHEMATICAL STRETCHED MEEM .. ARABIC MATHEMATICAL STRETCHED QAF
        return true;
    }
    if (codePoint >= 0x1EE74 && codePoint <= 0x1EE77) { // ARABIC MATHEMATICAL STRETCHED SHEEN .. ARABIC MATHEMATICAL STRETCHED KHAH
        return true;
    }
    if (codePoint >= 0x1EE79 && codePoint <= 0x1EE7C) { // ARABIC MATHEMATICAL STRETCHED DAD .. ARABIC MATHEMATICAL STRETCHED DOTLESS BEH
        return true;
    }
    if (codePoint >= 0x1EE7E && codePoint <= 0x1EE7E) { // ARABIC MATHEMATICAL STRETCHED DOTLESS FEH .. ARABIC MATHEMATICAL STRETCHED DOTLESS FEH
        return true;
    }
    if (codePoint >= 0x1EE80 && codePoint <= 0x1EE89) { // ARABIC MATHEMATICAL LOOPED ALEF .. ARABIC MATHEMATICAL LOOPED YEH
        return true;
    }
    if (codePoint >= 0x1EE8B && codePoint <= 0x1EE9B) { // ARABIC MATHEMATICAL LOOPED LAM .. ARABIC MATHEMATICAL LOOPED GHAIN
        return true;
    }
    if (codePoint >= 0x1EEA1 && codePoint <= 0x1EEA3) { // ARABIC MATHEMATICAL DOUBLE-STRUCK BEH .. ARABIC MATHEMATICAL DOUBLE-STRUCK DAL
        return true;
    }
    if (codePoint >= 0x1EEA5 && codePoint <= 0x1EEA9) { // ARABIC MATHEMATICAL DOUBLE-STRUCK WAW .. ARABIC MATHEMATICAL DOUBLE-STRUCK YEH
        return true;
    }
    if (codePoint >= 0x1EEAB && codePoint <= 0x1EEBB) { // ARABIC MATHEMATICAL DOUBLE-STRUCK LAM .. ARABIC MATHEMATICAL DOUBLE-STRUCK GHAIN
        return true;
    }
    if (codePoint >= 0x20000 && codePoint <= 0x2A6DD) { // CJK Ideograph Extension B .. CJK Ideograph Extension B
        return true;
    }
    if (codePoint >= 0x2A700 && codePoint <= 0x2B734) { // CJK Ideograph Extension C .. CJK Ideograph Extension C
        return true;
    }
    if (codePoint >= 0x2B740 && codePoint <= 0x2B81D) { // CJK Ideograph Extension D .. CJK Ideograph Extension D
        return true;
    }
    if (codePoint >= 0x2B820 && codePoint <= 0x2CEA1) { // CJK Ideograph Extension E .. CJK Ideograph Extension E
        return true;
    }
    if (codePoint >= 0x2CEB0 && codePoint <= 0x2EBE0) { // CJK Ideograph Extension F .. CJK Ideograph Extension F
        return true;
    }
    if (codePoint >= 0x2F800 && codePoint <= 0x2FA1D) { // CJK COMPATIBILITY IDEOGRAPH-2F800 .. CJK COMPATIBILITY IDEOGRAPH-2FA1D
        return true;
    }
    if (codePoint >= 0x30000 && codePoint <= 0x3134A) { // CJK Ideograph Extension G .. CJK Ideograph Extension G
        return true;
    }
    return false;
}

bool
js::unicode::IsIdentifierPartNonBMP(uint32_t codePoint)
{
    if (codePoint >= 0x10000 && codePoint <= 0x1000B) { // LINEAR B SYLLABLE B008 A .. LINEAR B SYLLABLE B046 JE
        return true;
    }
    if (codePoint >= 0x1000D && codePoint <= 0x10026) { // LINEAR B SYLLABLE B036 JO .. LINEAR B SYLLABLE B032 QO
        return true;
    }
    if (codePoint >= 0x10028 && codePoint <= 0x1003A) { // LINEAR B SYLLABLE B060 RA .. LINEAR B SYLLABLE B042 WO
        return true;
    }
    if (codePoint >= 0x1003C && codePoint <= 0x1003D) { // LINEAR B SYLLABLE B017 ZA .. LINEAR B SYLLABLE B074 ZE
        return true;
    }
    if (codePoint >= 0x1003F && codePoint <= 0x1004D) { // LINEAR B SYLLABLE B020 ZO .. LINEAR B SYLLABLE B091 TWO
        return true;
    }
    if (codePoint >= 0x10050 && codePoint <= 0x1005D) { // LINEAR B SYMBOL B018 .. LINEAR B SYMBOL B089
        return true;
    }
    if (codePoint >= 0x10080 && codePoint <= 0x100FA) { // LINEAR B IDEOGRAM B100 MAN .. LINEAR B IDEOGRAM VESSEL B305
        return true;
    }
    if (codePoint >= 0x10140 && codePoint <= 0x10174) { // GREEK ACROPHONIC ATTIC ONE QUARTER .. GREEK ACROPHONIC STRATIAN FIFTY MNAS
        return true;
    }
    if (codePoint >= 0x101FD && codePoint <= 0x101FD) { // PHAISTOS DISC SIGN COMBINING OBLIQUE STROKE .. PHAISTOS DISC SIGN COMBINING OBLIQUE STROKE
        return true;
    }
    if (codePoint >= 0x10280 && codePoint <= 0x1029C) { // LYCIAN LETTER A .. LYCIAN LETTER X
        return true;
    }
    if (codePoint >= 0x102A0 && codePoint <= 0x102D0) { // CARIAN LETTER A .. CARIAN LETTER UUU3
        return true;
    }
    if (codePoint >= 0x102E0 && codePoint <= 0x102E0) { // COPTIC EPACT THOUSANDS MARK .. COPTIC EPACT THOUSANDS MARK
        return true;
    }
    if (codePoint >= 0x10300 && codePoint <= 0x1031F) { // OLD ITALIC LETTER A .. OLD ITALIC LETTER ESS
        return true;
    }
    if (codePoint >= 0x1032D && codePoint <= 0x1034A) { // OLD ITALIC LETTER YE .. GOTHIC LETTER NINE HUNDRED
        return true;
    }
    if (codePoint >= 0x10350 && codePoint <= 0x1037A) { // OLD PERMIC LETTER AN .. COMBINING OLD PERMIC LETTER SII
        return true;
    }
    if (codePoint >= 0x10380 && codePoint <= 0x1039D) { // UGARITIC LETTER ALPA .. UGARITIC LETTER SSU
        return true;
    }
    if (codePoint >= 0x103A0 && codePoint <= 0x103C3) { // OLD PERSIAN SIGN A .. OLD PERSIAN SIGN HA
        return true;
    }
    if (codePoint >= 0x103C8 && codePoint <= 0x103CF) { // OLD PERSIAN SIGN AURAMAZDAA .. OLD PERSIAN SIGN BUUMISH
        return true;
    }
    if (codePoint >= 0x103D1 && codePoint <= 0x103D5) { // OLD PERSIAN NUMBER ONE .. OLD PERSIAN NUMBER HUNDRED
        return true;
    }
    if (codePoint >= 0x10400 && codePoint <= 0x1049D) { // DESERET CAPITAL LETTER LONG I .. OSMANYA LETTER OO
        return true;
    }
    if (codePoint >= 0x104A0 && codePoint <= 0x104A9) { // OSMANYA DIGIT ZERO .. OSMANYA DIGIT NINE
        return true;
    }
    if (codePoint >= 0x104B0 && codePoint <= 0x104D3) { // OSAGE CAPITAL LETTER A .. OSAGE CAPITAL LETTER ZHA
        return true;
    }
    if (codePoint >= 0x104D8 && codePoint <= 0x104FB) { // OSAGE SMALL LETTER A .. OSAGE SMALL LETTER ZHA
        return true;
    }
    if (codePoint >= 0x10500 && codePoint <= 0x10527) { // ELBASAN LETTER A .. ELBASAN LETTER KHE
        return true;
    }
    if (codePoint >= 0x10530 && codePoint <= 0x10563) { // CAUCASIAN ALBANIAN LETTER ALT .. CAUCASIAN ALBANIAN LETTER KIW
        return true;
    }
    if (codePoint >= 0x10600 && codePoint <= 0x10736) { // LINEAR A SIGN AB001 .. LINEAR A SIGN A664
        return true;
    }
    if (codePoint >= 0x10740 && codePoint <= 0x10755) { // LINEAR A SIGN A701 A .. LINEAR A SIGN A732 JE
        return true;
    }
    if (codePoint >= 0x10760 && codePoint <= 0x10767) { // LINEAR A SIGN A800 .. LINEAR A SIGN A807
        return true;
    }
    if (codePoint >= 0x10800 && codePoint <= 0x10805) { // CYPRIOT SYLLABLE A .. CYPRIOT SYLLABLE JA
        return true;
    }
    if (codePoint >= 0x10808 && codePoint <= 0x10808) { // CYPRIOT SYLLABLE JO .. CYPRIOT SYLLABLE JO
        return true;
    }
    if (codePoint >= 0x1080A && codePoint <= 0x10835) { // CYPRIOT SYLLABLE KA .. CYPRIOT SYLLABLE WO
        return true;
    }
    if (codePoint >= 0x10837 && codePoint <= 0x10838) { // CYPRIOT SYLLABLE XA .. CYPRIOT SYLLABLE XE
        return true;
    }
    if (codePoint >= 0x1083C && codePoint <= 0x1083C) { // CYPRIOT SYLLABLE ZA .. CYPRIOT SYLLABLE ZA
        return true;
    }
    if (codePoint >= 0x1083F && codePoint <= 0x10855) { // CYPRIOT SYLLABLE ZO .. IMPERIAL ARAMAIC LETTER TAW
        return true;
    }
    if (codePoint >= 0x10860 && codePoint <= 0x10876) { // PALMYRENE LETTER ALEPH .. PALMYRENE LETTER TAW
        return true;
    }
    if (codePoint >= 0x10880 && codePoint <= 0x1089E) { // NABATAEAN LETTER FINAL ALEPH .. NABATAEAN LETTER TAW
        return true;
    }
    if (codePoint >= 0x108E0 && codePoint <= 0x108F2) { // HATRAN LETTER ALEPH .. HATRAN LETTER QOPH
        return true;
    }
    if (codePoint >= 0x108F4 && codePoint <= 0x108F5) { // HATRAN LETTER SHIN .. HATRAN LETTER TAW
        return true;
    }
    if (codePoint >= 0x10900 && codePoint <= 0x10915) { // PHOENICIAN LETTER ALF .. PHOENICIAN LETTER TAU
        return true;
    }
    if (codePoint >= 0x10920 && codePoint <= 0x10939) { // LYDIAN LETTER A .. LYDIAN LETTER C
        return true;
    }
    if (codePoint >= 0x10980 && codePoint <= 0x109B7) { // MEROITIC HIEROGLYPHIC LETTER A .. MEROITIC CURSIVE LETTER DA
        return true;
    }
    if (codePoint >= 0x109BE && codePoint <= 0x109BF) { // MEROITIC CURSIVE LOGOGRAM RMT .. MEROITIC CURSIVE LOGOGRAM IMN
        return true;
    }
    if (codePoint >= 0x10A00 && codePoint <= 0x10A03) { // KHAROSHTHI LETTER A .. KHAROSHTHI VOWEL SIGN VOCALIC R
        return true;
    }
    if (codePoint >= 0x10A05 && codePoint <= 0x10A06) { // KHAROSHTHI VOWEL SIGN E .. KHAROSHTHI VOWEL SIGN O
        return true;
    }
    if (codePoint >= 0x10A0C && codePoint <= 0x10A13) { // KHAROSHTHI VOWEL LENGTH MARK .. KHAROSHTHI LETTER GHA
        return true;
    }
    if (codePoint >= 0x10A15 && codePoint <= 0x10A17) { // KHAROSHTHI LETTER CA .. KHAROSHTHI LETTER JA
        return true;
    }
    if (codePoint >= 0x10A19 && codePoint <= 0x10A35) { // KHAROSHTHI LETTER NYA .. KHAROSHTHI LETTER VHA
        return true;
    }
    if (codePoint >= 0x10A38 && codePoint <= 0x10A3A) { // KHAROSHTHI SIGN BAR ABOVE .. KHAROSHTHI SIGN DOT BELOW
        return true;
    }
    if (codePoint >= 0x10A3F && codePoint <= 0x10A3F) { // KHAROSHTHI VIRAMA .. KHAROSHTHI VIRAMA
        return true;
    }
    if (codePoint >= 0x10A60 && codePoint <= 0x10A7C) { // OLD SOUTH ARABIAN LETTER HE .. OLD SOUTH ARABIAN LETTER THETH
        return true;
    }
    if (codePoint >= 0x10A80 && codePoint <= 0x10A9C) { // OLD NORTH ARABIAN LETTER HEH .. OLD NORTH ARABIAN LETTER ZAH
        return true;
    }
    if (codePoint >= 0x10AC0 && codePoint <= 0x10AC7) { // MANICHAEAN LETTER ALEPH .. MANICHAEAN LETTER WAW
        return true;
    }
    if (codePoint >= 0x10AC9 && codePoint <= 0x10AE6) { // MANICHAEAN LETTER ZAYIN .. MANICHAEAN ABBREVIATION MARK BELOW
        return true;
    }
    if (codePoint >= 0x10B00 && codePoint <= 0x10B35) { // AVESTAN LETTER A .. AVESTAN LETTER HE
        return true;
    }
    if (codePoint >= 0x10B40 && codePoint <= 0x10B55) { // INSCRIPTIONAL PARTHIAN LETTER ALEPH .. INSCRIPTIONAL PARTHIAN LETTER TAW
        return true;
    }
    if (codePoint >= 0x10B60 && codePoint <= 0x10B72) { // INSCRIPTIONAL PAHLAVI LETTER ALEPH .. INSCRIPTIONAL PAHLAVI LETTER TAW
        return true;
    }
    if (codePoint >= 0x10B80 && codePoint <= 0x10B91) { // PSALTER PAHLAVI LETTER ALEPH .. PSALTER PAHLAVI LETTER TAW
        return true;
    }
    if (codePoint >= 0x10C00 && codePoint <= 0x10C48) { // OLD TURKIC LETTER ORKHON A .. OLD TURKIC LETTER ORKHON BASH
        return true;
    }
    if (codePoint >= 0x10C80 && codePoint <= 0x10CB2) { // OLD HUNGARIAN CAPITAL LETTER A .. OLD HUNGARIAN CAPITAL LETTER US
        return true;
    }
    if (codePoint >= 0x10CC0 && codePoint <= 0x10CF2) { // OLD HUNGARIAN SMALL LETTER A .. OLD HUNGARIAN SMALL LETTER US
        return true;
    }
    if (codePoint >= 0x10D00 && codePoint <= 0x10D27) { // HANIFI ROHINGYA LETTER A .. HANIFI ROHINGYA SIGN TASSI
        return true;
    }
    if (codePoint >= 0x10D30 && codePoint <= 0x10D39) { // HANIFI ROHINGYA DIGIT ZERO .. HANIFI ROHINGYA DIGIT NINE
        return true;
    }
    if (codePoint >= 0x10E80 && codePoint <= 0x10EA9) { // YEZIDI LETTER ELIF .. YEZIDI LETTER ET
        return true;
    }
    if (codePoint >= 0x10EAB && codePoint <= 0x10EAC) { // YEZIDI COMBINING HAMZA MARK .. YEZIDI COMBINING MADDA MARK
        return true;
    }
    if (codePoint >= 0x10EB0 && codePoint <= 0x10EB1) { // YEZIDI LETTER LAM WITH DOT ABOVE .. YEZIDI LETTER YOT WITH CIRCUMFLEX ABOVE
        return true;
    }
    if (codePoint >= 0x10F00 && codePoint <= 0x10F1C) { // OLD SOGDIAN LETTER ALEPH .. OLD SOGDIAN LETTER FINAL TAW WITH VERTICAL TAIL
        return true;
    }
    if (codePoint >= 0x10F27 && codePoint <= 0x10F27) { // OLD SOGDIAN LIGATURE AYIN-DALETH .. OLD SOGDIAN LIGATURE AYIN-DALETH
        return true;
    }
    if (codePoint >= 0x10F30 && codePoint <= 0x10F50) { // SOGDIAN LETTER ALEPH .. SOGDIAN COMBINING STROKE BELOW
        return true;
    }
    if (codePoint >= 0x10FB0 && codePoint <= 0x10FC4) { // CHORASMIAN LETTER ALEPH .. CHORASMIAN LETTER TAW
        return true;
    }
    if (codePoint >= 0x10FE0 && codePoint <= 0x10FF6) { // ELYMAIC LETTER ALEPH .. ELYMAIC LIGATURE ZAYIN-YODH
        return true;
    }
    if (codePoint >= 0x11000 && codePoint <= 0x11046) { // BRAHMI SIGN CANDRABINDU .. BRAHMI VIRAMA
        return true;
    }
    if (codePoint >= 0x11066 && codePoint <= 0x1106F) { // BRAHMI DIGIT ZERO .. BRAHMI DIGIT NINE
        return true;
    }
    if (codePoint >= 0x1107F && codePoint <= 0x110BA) { // BRAHMI NUMBER JOINER .. KAITHI SIGN NUKTA
        return true;
    }
    if (codePoint >= 0x110D0 && codePoint <= 0x110E8) { // SORA SOMPENG LETTER SAH .. SORA SOMPENG LETTER MAE
        return true;
    }
    if (codePoint >= 0x110F0 && codePoint <= 0x110F9) { // SORA SOMPENG DIGIT ZERO .. SORA SOMPENG DIGIT NINE
        return true;
    }
    if (codePoint >= 0x11100 && codePoint <= 0x11134) { // CHAKMA SIGN CANDRABINDU .. CHAKMA MAAYYAA
        return true;
    }
    if (codePoint >= 0x11136 && codePoint <= 0x1113F) { // CHAKMA DIGIT ZERO .. CHAKMA DIGIT NINE
        return true;
    }
    if (codePoint >= 0x11144 && codePoint <= 0x11147) { // CHAKMA LETTER LHAA .. CHAKMA LETTER VAA
        return true;
    }
    if (codePoint >= 0x11150 && codePoint <= 0x11173) { // MAHAJANI LETTER A .. MAHAJANI SIGN NUKTA
        return true;
    }
    if (codePoint >= 0x11176 && codePoint <= 0x11176) { // MAHAJANI LIGATURE SHRI .. MAHAJANI LIGATURE SHRI
        return true;
    }
    if (codePoint >= 0x11180 && codePoint <= 0x111C4) { // SHARADA SIGN CANDRABINDU .. SHARADA OM
        return true;
    }
    if (codePoint >= 0x111C9 && codePoint <= 0x111CC) { // SHARADA SANDHI MARK .. SHARADA EXTRA SHORT VOWEL MARK
        return true;
    }
    if (codePoint >= 0x111CE && codePoint <= 0x111DA) { // SHARADA VOWEL SIGN PRISHTHAMATRA E .. SHARADA EKAM
        return true;
    }
    if (codePoint >= 0x111DC && codePoint <= 0x111DC) { // SHARADA HEADSTROKE .. SHARADA HEADSTROKE
        return true;
    }
    if (codePoint >= 0x11200 && codePoint <= 0x11211) { // KHOJKI LETTER A .. KHOJKI LETTER JJA
        return true;
    }
    if (codePoint >= 0x11213 && codePoint <= 0x11237) { // KHOJKI LETTER NYA .. KHOJKI SIGN SHADDA
        return true;
    }
    if (codePoint >= 0x1123E && codePoint <= 0x1123E) { // KHOJKI SIGN SUKUN .. KHOJKI SIGN SUKUN
        return true;
    }
    if (codePoint >= 0x11280 && codePoint <= 0x11286) { // MULTANI LETTER A .. MULTANI LETTER GA
        return true;
    }
    if (codePoint >= 0x11288 && codePoint <= 0x11288) { // MULTANI LETTER GHA .. MULTANI LETTER GHA
        return true;
    }
    if (codePoint >= 0x1128A && codePoint <= 0x1128D) { // MULTANI LETTER CA .. MULTANI LETTER JJA
        return true;
    }
    if (codePoint >= 0x1128F && codePoint <= 0x1129D) { // MULTANI LETTER NYA .. MULTANI LETTER BA
        return true;
    }
    if (codePoint >= 0x1129F && codePoint <= 0x112A8) { // MULTANI LETTER BHA .. MULTANI LETTER RHA
        return true;
    }
    if (codePoint >= 0x112B0 && codePoint <= 0x112EA) { // KHUDAWADI LETTER A .. KHUDAWADI SIGN VIRAMA
        return true;
    }
    if (codePoint >= 0x112F0 && codePoint <= 0x112F9) { // KHUDAWADI DIGIT ZERO .. KHUDAWADI DIGIT NINE
        return true;
    }
    if (codePoint >= 0x11300 && codePoint <= 0x11303) { // GRANTHA SIGN COMBINING ANUSVARA ABOVE .. GRANTHA SIGN VISARGA
        return true;
    }
    if (codePoint >= 0x11305 && codePoint <= 0x1130C) { // GRANTHA LETTER A .. GRANTHA LETTER VOCALIC L
        return true;
    }
    if (codePoint >= 0x1130F && codePoint <= 0x11310) { // GRANTHA LETTER EE .. GRANTHA LETTER AI
        return true;
    }
    if (codePoint >= 0x11313 && codePoint <= 0x11328) { // GRANTHA LETTER OO .. GRANTHA LETTER NA
        return true;
    }
    if (codePoint >= 0x1132A && codePoint <= 0x11330) { // GRANTHA LETTER PA .. GRANTHA LETTER RA
        return true;
    }
    if (codePoint >= 0x11332 && codePoint <= 0x11333) { // GRANTHA LETTER LA .. GRANTHA LETTER LLA
        return true;
    }
    if (codePoint >= 0x11335 && codePoint <= 0x11339) { // GRANTHA LETTER VA .. GRANTHA LETTER HA
        return true;
    }
    if (codePoint >= 0x1133B && codePoint <= 0x11344) { // COMBINING BINDU BELOW .. GRANTHA VOWEL SIGN VOCALIC RR
        return true;
    }
    if (codePoint >= 0x11347 && codePoint <= 0x11348) { // GRANTHA VOWEL SIGN EE .. GRANTHA VOWEL SIGN AI
        return true;
    }
    if (codePoint >= 0x1134B && codePoint <= 0x1134D) { // GRANTHA VOWEL SIGN OO .. GRANTHA SIGN VIRAMA
        return true;
    }
    if (codePoint >= 0x11350 && codePoint <= 0x11350) { // GRANTHA OM .. GRANTHA OM
        return true;
    }
    if (codePoint >= 0x11357 && codePoint <= 0x11357) { // GRANTHA AU LENGTH MARK .. GRANTHA AU LENGTH MARK
        return true;
    }
    if (codePoint >= 0x1135D && codePoint <= 0x11363) { // GRANTHA SIGN PLUTA .. GRANTHA VOWEL SIGN VOCALIC LL
        return true;
    }
    if (codePoint >= 0x11366 && codePoint <= 0x1136C) { // COMBINING GRANTHA DIGIT ZERO .. COMBINING GRANTHA DIGIT SIX
        return true;
    }
    if (codePoint >= 0x11370 && codePoint <= 0x11374) { // COMBINING GRANTHA LETTER A .. COMBINING GRANTHA LETTER PA
        return true;
    }
    if (codePoint >= 0x11400 && codePoint <= 0x1144A) { // NEWA LETTER A .. NEWA SIDDHI
        return true;
    }
    if (codePoint >= 0x11450 && codePoint <= 0x11459) { // NEWA DIGIT ZERO .. NEWA DIGIT NINE
        return true;
    }
    if (codePoint >= 0x1145E && codePoint <= 0x11461) { // NEWA SANDHI MARK .. NEWA SIGN UPADHMANIYA
        return true;
    }
    if (codePoint >= 0x11480 && codePoint <= 0x114C5) { // TIRHUTA ANJI .. TIRHUTA GVANG
        return true;
    }
    if (codePoint >= 0x114C7 && codePoint <= 0x114C7) { // TIRHUTA OM .. TIRHUTA OM
        return true;
    }
    if (codePoint >= 0x114D0 && codePoint <= 0x114D9) { // TIRHUTA DIGIT ZERO .. TIRHUTA DIGIT NINE
        return true;
    }
    if (codePoint >= 0x11580 && codePoint <= 0x115B5) { // SIDDHAM LETTER A .. SIDDHAM VOWEL SIGN VOCALIC RR
        return true;
    }
    if (codePoint >= 0x115B8 && codePoint <= 0x115C0) { // SIDDHAM VOWEL SIGN E .. SIDDHAM SIGN NUKTA
        return true;
    }
    if (codePoint >= 0x115D8 && codePoint <= 0x115DD) { // SIDDHAM LETTER THREE-CIRCLE ALTERNATE I .. SIDDHAM VOWEL SIGN ALTERNATE UU
        return true;
    }
    if (codePoint >= 0x11600 && codePoint <= 0x11640) { // MODI LETTER A .. MODI SIGN ARDHACANDRA
        return true;
    }
    if (codePoint >= 0x11644 && codePoint <= 0x11644) { // MODI SIGN HUVA .. MODI SIGN HUVA
        return true;
    }
    if (codePoint >= 0x11650 && codePoint <= 0x11659) { // MODI DIGIT ZERO .. MODI DIGIT NINE
        return true;
    }
    if (codePoint >= 0x11680 && codePoint <= 0x116B8) { // TAKRI LETTER A .. TAKRI LETTER ARCHAIC KHA
        return true;
    }
    if (codePoint >= 0x116C0 && codePoint <= 0x116C9) { // TAKRI DIGIT ZERO .. TAKRI DIGIT NINE
        return true;
    }
    if (codePoint >= 0x11700 && codePoint <= 0x1171A) { // AHOM LETTER KA .. AHOM LETTER ALTERNATE BA
        return true;
    }
    if (codePoint >= 0x1171D && codePoint <= 0x1172B) { // AHOM CONSONANT SIGN MEDIAL LA .. AHOM SIGN KILLER
        return true;
    }
    if (codePoint >= 0x11730 && codePoint <= 0x11739) { // AHOM DIGIT ZERO .. AHOM DIGIT NINE
        return true;
    }
    if (codePoint >= 0x11800 && codePoint <= 0x1183A) { // DOGRA LETTER A .. DOGRA SIGN NUKTA
        return true;
    }
    if (codePoint >= 0x118A0 && codePoint <= 0x118E9) { // WARANG CITI CAPITAL LETTER NGAA .. WARANG CITI DIGIT NINE
        return true;
    }
    if (codePoint >= 0x118FF && codePoint <= 0x11906) { // WARANG CITI OM .. DIVES AKURU LETTER E
        return true;
    }
    if (codePoint >= 0x11909 && codePoint <= 0x11909) { // DIVES AKURU LETTER O .. DIVES AKURU LETTER O
        return true;
    }
    if (codePoint >= 0x1190C && codePoint <= 0x11913) { // DIVES AKURU LETTER KA .. DIVES AKURU LETTER JA
        return true;
    }
    if (codePoint >= 0x11915 && codePoint <= 0x11916) { // DIVES AKURU LETTER NYA .. DIVES AKURU LETTER TTA
        return true;
    }
    if (codePoint >= 0x11918 && codePoint <= 0x11935) { // DIVES AKURU LETTER DDA .. DIVES AKURU VOWEL SIGN E
        return true;
    }
    if (codePoint >= 0x11937 && codePoint <= 0x11938) { // DIVES AKURU VOWEL SIGN AI .. DIVES AKURU VOWEL SIGN O
        return true;
    }
    if (codePoint >= 0x1193B && codePoint <= 0x11943) { // DIVES AKURU SIGN ANUSVARA .. DIVES AKURU SIGN NUKTA
        return true;
    }
    if (codePoint >= 0x11950 && codePoint <= 0x11959) { // DIVES AKURU DIGIT ZERO .. DIVES AKURU DIGIT NINE
        return true;
    }
    if (codePoint >= 0x119A0 && codePoint <= 0x119A7) { // NANDINAGARI LETTER A .. NANDINAGARI LETTER VOCALIC RR
        return true;
    }
    if (codePoint >= 0x119AA && codePoint <= 0x119D7) { // NANDINAGARI LETTER E .. NANDINAGARI VOWEL SIGN VOCALIC RR
        return true;
    }
    if (codePoint >= 0x119DA && codePoint <= 0x119E1) { // NANDINAGARI VOWEL SIGN E .. NANDINAGARI SIGN AVAGRAHA
        return true;
    }
    if (codePoint >= 0x119E3 && codePoint <= 0x119E4) { // NANDINAGARI HEADSTROKE .. NANDINAGARI VOWEL SIGN PRISHTHAMATRA E
        return true;
    }
    if (codePoint >= 0x11A00 && codePoint <= 0x11A3E) { // ZANABAZAR SQUARE LETTER A .. ZANABAZAR SQUARE CLUSTER-FINAL LETTER VA
        return true;
    }
    if (codePoint >= 0x11A47 && codePoint <= 0x11A47) { // ZANABAZAR SQUARE SUBJOINER .. ZANABAZAR SQUARE SUBJOINER
        return true;
    }
    if (codePoint >= 0x11A50 && codePoint <= 0x11A99) { // SOYOMBO LETTER A .. SOYOMBO SUBJOINER
        return true;
    }
    if (codePoint >= 0x11A9D && codePoint <= 0x11A9D) { // SOYOMBO MARK PLUTA .. SOYOMBO MARK PLUTA
        return true;
    }
    if (codePoint >= 0x11AC0 && codePoint <= 0x11AF8) { // PAU CIN HAU LETTER PA .. PAU CIN HAU GLOTTAL STOP FINAL
        return true;
    }
    if (codePoint >= 0x11C00 && codePoint <= 0x11C08) { // BHAIKSUKI LETTER A .. BHAIKSUKI LETTER VOCALIC L
        return true;
    }
    if (codePoint >= 0x11C0A && codePoint <= 0x11C36) { // BHAIKSUKI LETTER E .. BHAIKSUKI VOWEL SIGN VOCALIC L
        return true;
    }
    if (codePoint >= 0x11C38 && codePoint <= 0x11C40) { // BHAIKSUKI VOWEL SIGN E .. BHAIKSUKI SIGN AVAGRAHA
        return true;
    }
    if (codePoint >= 0x11C50 && codePoint <= 0x11C59) { // BHAIKSUKI DIGIT ZERO .. BHAIKSUKI DIGIT NINE
        return true;
    }
    if (codePoint >= 0x11C72 && codePoint <= 0x11C8F) { // MARCHEN LETTER KA .. MARCHEN LETTER A
        return true;
    }
    if (codePoint >= 0x11C92 && codePoint <= 0x11CA7) { // MARCHEN SUBJOINED LETTER KA .. MARCHEN SUBJOINED LETTER ZA
        return true;
    }
    if (codePoint >= 0x11CA9 && codePoint <= 0x11CB6) { // MARCHEN SUBJOINED LETTER YA .. MARCHEN SIGN CANDRABINDU
        return true;
    }
    if (codePoint >= 0x11D00 && codePoint <= 0x11D06) { // MASARAM GONDI LETTER A .. MASARAM GONDI LETTER E
        return true;
    }
    if (codePoint >= 0x11D08 && codePoint <= 0x11D09) { // MASARAM GONDI LETTER AI .. MASARAM GONDI LETTER O
        return true;
    }
    if (codePoint >= 0x11D0B && codePoint <= 0x11D36) { // MASARAM GONDI LETTER AU .. MASARAM GONDI VOWEL SIGN VOCALIC R
        return true;
    }
    if (codePoint >= 0x11D3A && codePoint <= 0x11D3A) { // MASARAM GONDI VOWEL SIGN E .. MASARAM GONDI VOWEL SIGN E
        return true;
    }
    if (codePoint >= 0x11D3C && codePoint <= 0x11D3D) { // MASARAM GONDI VOWEL SIGN AI .. MASARAM GONDI VOWEL SIGN O
        return true;
    }
    if (codePoint >= 0x11D3F && codePoint <= 0x11D47) { // MASARAM GONDI VOWEL SIGN AU .. MASARAM GONDI RA-KARA
        return true;
    }
    if (codePoint >= 0x11D50 && codePoint <= 0x11D59) { // MASARAM GONDI DIGIT ZERO .. MASARAM GONDI DIGIT NINE
        return true;
    }
    if (codePoint >= 0x11D60 && codePoint <= 0x11D65) { // GUNJALA GONDI LETTER A .. GUNJALA GONDI LETTER UU
        return true;
    }
    if (codePoint >= 0x11D67 && codePoint <= 0x11D68) { // GUNJALA GONDI LETTER EE .. GUNJALA GONDI LETTER AI
        return true;
    }
    if (codePoint >= 0x11D6A && codePoint <= 0x11D8E) { // GUNJALA GONDI LETTER OO .. GUNJALA GONDI VOWEL SIGN UU
        return true;
    }
    if (codePoint >= 0x11D90 && codePoint <= 0x11D91) { // GUNJALA GONDI VOWEL SIGN EE .. GUNJALA GONDI VOWEL SIGN AI
        return true;
    }
    if (codePoint >= 0x11D93 && codePoint <= 0x11D98) { // GUNJALA GONDI VOWEL SIGN OO .. GUNJALA GONDI OM
        return true;
    }
    if (codePoint >= 0x11DA0 && codePoint <= 0x11DA9) { // GUNJALA GONDI DIGIT ZERO .. GUNJALA GONDI DIGIT NINE
        return true;
    }
    if (codePoint >= 0x11EE0 && codePoint <= 0x11EF6) { // MAKASAR LETTER KA .. MAKASAR VOWEL SIGN O
        return true;
    }
    if (codePoint >= 0x11FB0 && codePoint <= 0x11FB0) { // LISU LETTER YHA .. LISU LETTER YHA
        return true;
    }
    if (codePoint >= 0x12000 && codePoint <= 0x12399) { // CUNEIFORM SIGN A .. CUNEIFORM SIGN U U
        return true;
    }
    if (codePoint >= 0x12400 && codePoint <= 0x1246E) { // CUNEIFORM NUMERIC SIGN TWO ASH .. CUNEIFORM NUMERIC SIGN NINE U VARIANT FORM
        return true;
    }
    if (codePoint >= 0x12480 && codePoint <= 0x12543) { // CUNEIFORM SIGN AB TIMES NUN TENU .. CUNEIFORM SIGN ZU5 TIMES THREE DISH TENU
        return true;
    }
    if (codePoint >= 0x13000 && codePoint <= 0x1342E) { // EGYPTIAN HIEROGLYPH A001 .. EGYPTIAN HIEROGLYPH AA032
        return true;
    }
    if (codePoint >= 0x14400 && codePoint <= 0x14646) { // ANATOLIAN HIEROGLYPH A001 .. ANATOLIAN HIEROGLYPH A530
        return true;
    }
    if (codePoint >= 0x16800 && codePoint <= 0x16A38) { // BAMUM LETTER PHASE-A NGKUE MFON .. BAMUM LETTER PHASE-F VUEQ
        return true;
    }
    if (codePoint >= 0x16A40 && codePoint <= 0x16A5E) { // MRO LETTER TA .. MRO LETTER TEK
        return true;
    }
    if (codePoint >= 0x16A60 && codePoint <= 0x16A69) { // MRO DIGIT ZERO .. MRO DIGIT NINE
        return true;
    }
    if (codePoint >= 0x16AD0 && codePoint <= 0x16AED) { // BASSA VAH LETTER ENNI .. BASSA VAH LETTER I
        return true;
    }
    if (codePoint >= 0x16AF0 && codePoint <= 0x16AF4) { // BASSA VAH COMBINING HIGH TONE .. BASSA VAH COMBINING HIGH-LOW TONE
        return true;
    }
    if (codePoint >= 0x16B00 && codePoint <= 0x16B36) { // PAHAWH HMONG VOWEL KEEB .. PAHAWH HMONG MARK CIM TAUM
        return true;
    }
    if (codePoint >= 0x16B40 && codePoint <= 0x16B43) { // PAHAWH HMONG SIGN VOS SEEV .. PAHAWH HMONG SIGN IB YAM
        return true;
    }
    if (codePoint >= 0x16B50 && codePoint <= 0x16B59) { // PAHAWH HMONG DIGIT ZERO .. PAHAWH HMONG DIGIT NINE
        return true;
    }
    if (codePoint >= 0x16B63 && codePoint <= 0x16B77) { // PAHAWH HMONG SIGN VOS LUB .. PAHAWH HMONG SIGN CIM NRES TOS
        return true;
    }
    if (codePoint >= 0x16B7D && codePoint <= 0x16B8F) { // PAHAWH HMONG CLAN SIGN TSHEEJ .. PAHAWH HMONG CLAN SIGN VWJ
        return true;
    }
    if (codePoint >= 0x16E40 && codePoint <= 0x16E7F) { // MEDEFAIDRIN CAPITAL LETTER M .. MEDEFAIDRIN SMALL LETTER Y
        return true;
    }
    if (codePoint >= 0x16F00 && codePoint <= 0x16F4A) { // MIAO LETTER PA .. MIAO LETTER RTE
        return true;
    }
    if (codePoint >= 0x16F4F && codePoint <= 0x16F87) { // MIAO SIGN CONSONANT MODIFIER BAR .. MIAO VOWEL SIGN UI
        return true;
    }
    if (codePoint >= 0x16F8F && codePoint <= 0x16F9F) { // MIAO TONE RIGHT .. MIAO LETTER REFORMED TONE-8
        return true;
    }
    if (codePoint >= 0x16FE0 && codePoint <= 0x16FE1) { // TANGUT ITERATION MARK .. NUSHU ITERATION MARK
        return true;
    }
    if (codePoint >= 0x16FE3 && codePoint <= 0x16FE4) { // OLD CHINESE ITERATION MARK .. KHITAN SMALL SCRIPT FILLER
        return true;
    }
    if (codePoint >= 0x16FF0 && codePoint <= 0x16FF1) { // VIETNAMESE ALTERNATE READING MARK CA .. VIETNAMESE ALTERNATE READING MARK NHAY
        return true;
    }
    if (codePoint >= 0x17000 && codePoint <= 0x187F7) { // Tangut Ideograph .. Tangut Ideograph
        return true;
    }
    if (codePoint >= 0x18800 && codePoint <= 0x18CD5) { // TANGUT COMPONENT-001 .. KHITAN SMALL SCRIPT CHARACTER-18CD5
        return true;
    }
    if (codePoint >= 0x18D00 && codePoint <= 0x18D08) { // Tangut Ideograph Supplement .. Tangut Ideograph Supplement
        return true;
    }
    if (codePoint >= 0x1B000 && codePoint <= 0x1B11E) { // KATAKANA LETTER ARCHAIC E .. HENTAIGANA LETTER N-MU-MO-2
        return true;
    }
    if (codePoint >= 0x1B150 && codePoint <= 0x1B152) { // HIRAGANA LETTER SMALL WI .. HIRAGANA LETTER SMALL WO
        return true;
    }
    if (codePoint >= 0x1B164 && codePoint <= 0x1B167) { // KATAKANA LETTER SMALL WI .. KATAKANA LETTER SMALL N
        return true;
    }
    if (codePoint >= 0x1B170 && codePoint <= 0x1B2FB) { // NUSHU CHARACTER-1B170 .. NUSHU CHARACTER-1B2FB
        return true;
    }
    if (codePoint >= 0x1BC00 && codePoint <= 0x1BC6A) { // DUPLOYAN LETTER H .. DUPLOYAN LETTER VOCALIC M
        return true;
    }
    if (codePoint >= 0x1BC70 && codePoint <= 0x1BC7C) { // DUPLOYAN AFFIX LEFT HORIZONTAL SECANT .. DUPLOYAN AFFIX ATTACHED TANGENT HOOK
        return true;
    }
    if (codePoint >= 0x1BC80 && codePoint <= 0x1BC88) { // DUPLOYAN AFFIX HIGH ACUTE .. DUPLOYAN AFFIX HIGH VERTICAL
        return true;
    }
    if (codePoint >= 0x1BC90 && codePoint <= 0x1BC99) { // DUPLOYAN AFFIX LOW ACUTE .. DUPLOYAN AFFIX LOW ARROW
        return true;
    }
    if (codePoint >= 0x1BC9D && codePoint <= 0x1BC9E) { // DUPLOYAN THICK LETTER SELECTOR .. DUPLOYAN DOUBLE MARK
        return true;
    }
    if (codePoint >= 0x1D165 && codePoint <= 0x1D169) { // MUSICAL SYMBOL COMBINING STEM .. MUSICAL SYMBOL COMBINING TREMOLO-3
        return true;
    }
    if (codePoint >= 0x1D16D && codePoint <= 0x1D172) { // MUSICAL SYMBOL COMBINING AUGMENTATION DOT .. MUSICAL SYMBOL COMBINING FLAG-5
        return true;
    }
    if (codePoint >= 0x1D17B && codePoint <= 0x1D182) { // MUSICAL SYMBOL COMBINING ACCENT .. MUSICAL SYMBOL COMBINING LOURE
        return true;
    }
    if (codePoint >= 0x1D185 && codePoint <= 0x1D18B) { // MUSICAL SYMBOL COMBINING DOIT .. MUSICAL SYMBOL COMBINING TRIPLE TONGUE
        return true;
    }
    if (codePoint >= 0x1D1AA && codePoint <= 0x1D1AD) { // MUSICAL SYMBOL COMBINING DOWN BOW .. MUSICAL SYMBOL COMBINING SNAP PIZZICATO
        return true;
    }
    if (codePoint >= 0x1D242 && codePoint <= 0x1D244) { // COMBINING GREEK MUSICAL TRISEME .. COMBINING GREEK MUSICAL PENTASEME
        return true;
    }
    if (codePoint >= 0x1D400 && codePoint <= 0x1D454) { // MATHEMATICAL BOLD CAPITAL A .. MATHEMATICAL ITALIC SMALL G
        return true;
    }
    if (codePoint >= 0x1D456 && codePoint <= 0x1D49C) { // MATHEMATICAL ITALIC SMALL I .. MATHEMATICAL SCRIPT CAPITAL A
        return true;
    }
    if (codePoint >= 0x1D49E && codePoint <= 0x1D49F) { // MATHEMATICAL SCRIPT CAPITAL C .. MATHEMATICAL SCRIPT CAPITAL D
        return true;
    }
    if (codePoint >= 0x1D4A2 && codePoint <= 0x1D4A2) { // MATHEMATICAL SCRIPT CAPITAL G .. MATHEMATICAL SCRIPT CAPITAL G
        return true;
    }
    if (codePoint >= 0x1D4A5 && codePoint <= 0x1D4A6) { // MATHEMATICAL SCRIPT CAPITAL J .. MATHEMATICAL SCRIPT CAPITAL K
        return true;
    }
    if (codePoint >= 0x1D4A9 && codePoint <= 0x1D4AC) { // MATHEMATICAL SCRIPT CAPITAL N .. MATHEMATICAL SCRIPT CAPITAL Q
        return true;
    }
    if (codePoint >= 0x1D4AE && codePoint <= 0x1D4B9) { // MATHEMATICAL SCRIPT CAPITAL S .. MATHEMATICAL SCRIPT SMALL D
        return true;
    }
    if (codePoint >= 0x1D4BB && codePoint <= 0x1D4BB) { // MATHEMATICAL SCRIPT SMALL F .. MATHEMATICAL SCRIPT SMALL F
        return true;
    }
    if (codePoint >= 0x1D4BD && codePoint <= 0x1D4C3) { // MATHEMATICAL SCRIPT SMALL H .. MATHEMATICAL SCRIPT SMALL N
        return true;
    }
    if (codePoint >= 0x1D4C5 && codePoint <= 0x1D505) { // MATHEMATICAL SCRIPT SMALL P .. MATHEMATICAL FRAKTUR CAPITAL B
        return true;
    }
    if (codePoint >= 0x1D507 && codePoint <= 0x1D50A) { // MATHEMATICAL FRAKTUR CAPITAL D .. MATHEMATICAL FRAKTUR CAPITAL G
        return true;
    }
    if (codePoint >= 0x1D50D && codePoint <= 0x1D514) { // MATHEMATICAL FRAKTUR CAPITAL J .. MATHEMATICAL FRAKTUR CAPITAL Q
        return true;
    }
    if (codePoint >= 0x1D516 && codePoint <= 0x1D51C) { // MATHEMATICAL FRAKTUR CAPITAL S .. MATHEMATICAL FRAKTUR CAPITAL Y
        return true;
    }
    if (codePoint >= 0x1D51E && codePoint <= 0x1D539) { // MATHEMATICAL FRAKTUR SMALL A .. MATHEMATICAL DOUBLE-STRUCK CAPITAL B
        return true;
    }
    if (codePoint >= 0x1D53B && codePoint <= 0x1D53E) { // MATHEMATICAL DOUBLE-STRUCK CAPITAL D .. MATHEMATICAL DOUBLE-STRUCK CAPITAL G
        return true;
    }
    if (codePoint >= 0x1D540 && codePoint <= 0x1D544) { // MATHEMATICAL DOUBLE-STRUCK CAPITAL I .. MATHEMATICAL DOUBLE-STRUCK CAPITAL M
        return true;
    }
    if (codePoint >= 0x1D546 && codePoint <= 0x1D546) { // MATHEMATICAL DOUBLE-STRUCK CAPITAL O .. MATHEMATICAL DOUBLE-STRUCK CAPITAL O
        return true;
    }
    if (codePoint >= 0x1D54A && codePoint <= 0x1D550) { // MATHEMATICAL DOUBLE-STRUCK CAPITAL S .. MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
        return true;
    }
    if (codePoint >= 0x1D552 && codePoint <= 0x1D6A5) { // MATHEMATICAL DOUBLE-STRUCK SMALL A .. MATHEMATICAL ITALIC SMALL DOTLESS J
        return true;
    }
    if (codePoint >= 0x1D6A8 && codePoint <= 0x1D6C0) { // MATHEMATICAL BOLD CAPITAL ALPHA .. MATHEMATICAL BOLD CAPITAL OMEGA
        return true;
    }
    if (codePoint >= 0x1D6C2 && codePoint <= 0x1D6DA) { // MATHEMATICAL BOLD SMALL ALPHA .. MATHEMATICAL BOLD SMALL OMEGA
        return true;
    }
    if (codePoint >= 0x1D6DC && codePoint <= 0x1D6FA) { // MATHEMATICAL BOLD EPSILON SYMBOL .. MATHEMATICAL ITALIC CAPITAL OMEGA
        return true;
    }
    if (codePoint >= 0x1D6FC && codePoint <= 0x1D714) { // MATHEMATICAL ITALIC SMALL ALPHA .. MATHEMATICAL ITALIC SMALL OMEGA
        return true;
    }
    if (codePoint >= 0x1D716 && codePoint <= 0x1D734) { // MATHEMATICAL ITALIC EPSILON SYMBOL .. MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
        return true;
    }
    if (codePoint >= 0x1D736 && codePoint <= 0x1D74E) { // MATHEMATICAL BOLD ITALIC SMALL ALPHA .. MATHEMATICAL BOLD ITALIC SMALL OMEGA
        return true;
    }
    if (codePoint >= 0x1D750 && codePoint <= 0x1D76E) { // MATHEMATICAL BOLD ITALIC EPSILON SYMBOL .. MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
        return true;
    }
    if (codePoint >= 0x1D770 && codePoint <= 0x1D788) { // MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA .. MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
        return true;
    }
    if (codePoint >= 0x1D78A && codePoint <= 0x1D7A8) { // MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL .. MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
        return true;
    }
    if (codePoint >= 0x1D7AA && codePoint <= 0x1D7C2) { // MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA .. MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
        return true;
    }
    if (codePoint >= 0x1D7C4 && codePoint <= 0x1D7CB) { // MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL .. MATHEMATICAL BOLD SMALL DIGAMMA
        return true;
    }
    if (codePoint >= 0x1D7CE && codePoint <= 0x1D7FF) { // MATHEMATICAL BOLD DIGIT ZERO .. MATHEMATICAL MONOSPACE DIGIT NINE
        return true;
    }
    if (codePoint >= 0x1DA00 && codePoint <= 0x1DA36) { // SIGNWRITING HEAD RIM .. SIGNWRITING AIR SUCKING IN
        return true;
    }
    if (codePoint >= 0x1DA3B && codePoint <= 0x1DA6C) { // SIGNWRITING MOUTH CLOSED NEUTRAL .. SIGNWRITING EXCITEMENT
        return true;
    }
    if (codePoint >= 0x1DA75 && codePoint <= 0x1DA75) { // SIGNWRITING UPPER BODY TILTING FROM HIP JOINTS .. SIGNWRITING UPPER BODY TILTING FROM HIP JOINTS
        return true;
    }
    if (codePoint >= 0x1DA84 && codePoint <= 0x1DA84) { // SIGNWRITING LOCATION HEAD NECK .. SIGNWRITING LOCATION HEAD NECK
        return true;
    }
    if (codePoint >= 0x1DA9B && codePoint <= 0x1DA9F) { // SIGNWRITING FILL MODIFIER-2 .. SIGNWRITING FILL MODIFIER-6
        return true;
    }
    if (codePoint >= 0x1DAA1 && codePoint <= 0x1DAAF) { // SIGNWRITING ROTATION MODIFIER-2 .. SIGNWRITING ROTATION MODIFIER-16
        return true;
    }
    if (codePoint >= 0x1E000 && codePoint <= 0x1E006) { // COMBINING GLAGOLITIC LETTER AZU .. COMBINING GLAGOLITIC LETTER ZHIVETE
        return true;
    }
    if (codePoint >= 0x1E008 && codePoint <= 0x1E018) { // COMBINING GLAGOLITIC LETTER ZEMLJA .. COMBINING GLAGOLITIC LETTER HERU
        return true;
    }
    if (codePoint >= 0x1E01B && codePoint <= 0x1E021) { // COMBINING GLAGOLITIC LETTER SHTA .. COMBINING GLAGOLITIC LETTER YATI
        return true;
    }
    if (codePoint >= 0x1E023 && codePoint <= 0x1E024) { // COMBINING GLAGOLITIC LETTER YU .. COMBINING GLAGOLITIC LETTER SMALL YUS
        return true;
    }
    if (codePoint >= 0x1E026 && codePoint <= 0x1E02A) { // COMBINING GLAGOLITIC LETTER YO .. COMBINING GLAGOLITIC LETTER FITA
        return true;
    }
    if (codePoint >= 0x1E100 && codePoint <= 0x1E12C) { // NYIAKENG PUACHUE HMONG LETTER MA .. NYIAKENG PUACHUE HMONG LETTER W
        return true;
    }
    if (codePoint >= 0x1E130 && codePoint <= 0x1E13D) { // NYIAKENG PUACHUE HMONG TONE-B .. NYIAKENG PUACHUE HMONG SYLLABLE LENGTHENER
        return true;
    }
    if (codePoint >= 0x1E140 && codePoint <= 0x1E149) { // NYIAKENG PUACHUE HMONG DIGIT ZERO .. NYIAKENG PUACHUE HMONG DIGIT NINE
        return true;
    }
    if (codePoint >= 0x1E14E && codePoint <= 0x1E14E) { // NYIAKENG PUACHUE HMONG LOGOGRAM NYAJ .. NYIAKENG PUACHUE HMONG LOGOGRAM NYAJ
        return true;
    }
    if (codePoint >= 0x1E2C0 && codePoint <= 0x1E2F9) { // WANCHO LETTER AA .. WANCHO DIGIT NINE
        return true;
    }
    if (codePoint >= 0x1E800 && codePoint <= 0x1E8C4) { // MENDE KIKAKUI SYLLABLE M001 KI .. MENDE KIKAKUI SYLLABLE M060 NYON
        return true;
    }
    if (codePoint >= 0x1E8D0 && codePoint <= 0x1E8D6) { // MENDE KIKAKUI COMBINING NUMBER TEENS .. MENDE KIKAKUI COMBINING NUMBER MILLIONS
        return true;
    }
    if (codePoint >= 0x1E900 && codePoint <= 0x1E94B) { // ADLAM CAPITAL LETTER ALIF .. ADLAM NASALIZATION MARK
        return true;
    }
    if (codePoint >= 0x1E950 && codePoint <= 0x1E959) { // ADLAM DIGIT ZERO .. ADLAM DIGIT NINE
        return true;
    }
    if (codePoint >= 0x1EE00 && codePoint <= 0x1EE03) { // ARABIC MATHEMATICAL ALEF .. ARABIC MATHEMATICAL DAL
        return true;
    }
    if (codePoint >= 0x1EE05 && codePoint <= 0x1EE1F) { // ARABIC MATHEMATICAL WAW .. ARABIC MATHEMATICAL DOTLESS QAF
        return true;
    }
    if (codePoint >= 0x1EE21 && codePoint <= 0x1EE22) { // ARABIC MATHEMATICAL INITIAL BEH .. ARABIC MATHEMATICAL INITIAL JEEM
        return true;
    }
    if (codePoint >= 0x1EE24 && codePoint <= 0x1EE24) { // ARABIC MATHEMATICAL INITIAL HEH .. ARABIC MATHEMATICAL INITIAL HEH
        return true;
    }
    if (codePoint >= 0x1EE27 && codePoint <= 0x1EE27) { // ARABIC MATHEMATICAL INITIAL HAH .. ARABIC MATHEMATICAL INITIAL HAH
        return true;
    }
    if (codePoint >= 0x1EE29 && codePoint <= 0x1EE32) { // ARABIC MATHEMATICAL INITIAL YEH .. ARABIC MATHEMATICAL INITIAL QAF
        return true;
    }
    if (codePoint >= 0x1EE34 && codePoint <= 0x1EE37) { // ARABIC MATHEMATICAL INITIAL SHEEN .. ARABIC MATHEMATICAL INITIAL KHAH
        return true;
    }
    if (codePoint >= 0x1EE39 && codePoint <= 0x1EE39) { // ARABIC MATHEMATICAL INITIAL DAD .. ARABIC MATHEMATICAL INITIAL DAD
        return true;
    }
    if (codePoint >= 0x1EE3B && codePoint <= 0x1EE3B) { // ARABIC MATHEMATICAL INITIAL GHAIN .. ARABIC MATHEMATICAL INITIAL GHAIN
        return true;
    }
    if (codePoint >= 0x1EE42 && codePoint <= 0x1EE42) { // ARABIC MATHEMATICAL TAILED JEEM .. ARABIC MATHEMATICAL TAILED JEEM
        return true;
    }
    if (codePoint >= 0x1EE47 && codePoint <= 0x1EE47) { // ARABIC MATHEMATICAL TAILED HAH .. ARABIC MATHEMATICAL TAILED HAH
        return true;
    }
    if (codePoint >= 0x1EE49 && codePoint <= 0x1EE49) { // ARABIC MATHEMATICAL TAILED YEH .. ARABIC MATHEMATICAL TAILED YEH
        return true;
    }
    if (codePoint >= 0x1EE4B && codePoint <= 0x1EE4B) { // ARABIC MATHEMATICAL TAILED LAM .. ARABIC MATHEMATICAL TAILED LAM
        return true;
    }
    if (codePoint >= 0x1EE4D && codePoint <= 0x1EE4F) { // ARABIC MATHEMATICAL TAILED NOON .. ARABIC MATHEMATICAL TAILED AIN
        return true;
    }
    if (codePoint >= 0x1EE51 && codePoint <= 0x1EE52) { // ARABIC MATHEMATICAL TAILED SAD .. ARABIC MATHEMATICAL TAILED QAF
        return true;
    }
    if (codePoint >= 0x1EE54 && codePoint <= 0x1EE54) { // ARABIC MATHEMATICAL TAILED SHEEN .. ARABIC MATHEMATICAL TAILED SHEEN
        return true;
    }
    if (codePoint >= 0x1EE57 && codePoint <= 0x1EE57) { // ARABIC MATHEMATICAL TAILED KHAH .. ARABIC MATHEMATICAL TAILED KHAH
        return true;
    }
    if (codePoint >= 0x1EE59 && codePoint <= 0x1EE59) { // ARABIC MATHEMATICAL TAILED DAD .. ARABIC MATHEMATICAL TAILED DAD
        return true;
    }
    if (codePoint >= 0x1EE5B && codePoint <= 0x1EE5B) { // ARABIC MATHEMATICAL TAILED GHAIN .. ARABIC MATHEMATICAL TAILED GHAIN
        return true;
    }
    if (codePoint >= 0x1EE5D && codePoint <= 0x1EE5D) { // ARABIC MATHEMATICAL TAILED DOTLESS NOON .. ARABIC MATHEMATICAL TAILED DOTLESS NOON
        return true;
    }
    if (codePoint >= 0x1EE5F && codePoint <= 0x1EE5F) { // ARABIC MATHEMATICAL TAILED DOTLESS QAF .. ARABIC MATHEMATICAL TAILED DOTLESS QAF
        return true;
    }
    if (codePoint >= 0x1EE61 && codePoint <= 0x1EE62) { // ARABIC MATHEMATICAL STRETCHED BEH .. ARABIC MATHEMATICAL STRETCHED JEEM
        return true;
    }
    if (codePoint >= 0x1EE64 && codePoint <= 0x1EE64) { // ARABIC MATHEMATICAL STRETCHED HEH .. ARABIC MATHEMATICAL STRETCHED HEH
        return true;
    }
    if (codePoint >= 0x1EE67 && codePoint <= 0x1EE6A) { // ARABIC MATHEMATICAL STRETCHED HAH .. ARABIC MATHEMATICAL STRETCHED KAF
        return true;
    }
    if (codePoint >= 0x1EE6C && codePoint <= 0x1EE72) { // ARABIC MATHEMATICAL STRETCHED MEEM .. ARABIC MATHEMATICAL STRETCHED QAF
        return true;
    }
    if (codePoint >= 0x1EE74 && codePoint <= 0x1EE77) { // ARABIC MATHEMATICAL STRETCHED SHEEN .. ARABIC MATHEMATICAL STRETCHED KHAH
        return true;
    }
    if (codePoint >= 0x1EE79 && codePoint <= 0x1EE7C) { // ARABIC MATHEMATICAL STRETCHED DAD .. ARABIC MATHEMATICAL STRETCHED DOTLESS BEH
        return true;
    }
    if (codePoint >= 0x1EE7E && codePoint <= 0x1EE7E) { // ARABIC MATHEMATICAL STRETCHED DOTLESS FEH .. ARABIC MATHEMATICAL STRETCHED DOTLESS FEH
        return true;
    }
    if (codePoint >= 0x1EE80 && codePoint <= 0x1EE89) { // ARABIC MATHEMATICAL LOOPED ALEF .. ARABIC MATHEMATICAL LOOPED YEH
        return true;
    }
    if (codePoint >= 0x1EE8B && codePoint <= 0x1EE9B) { // ARABIC MATHEMATICAL LOOPED LAM .. ARABIC MATHEMATICAL LOOPED GHAIN
        return true;
    }
    if (codePoint >= 0x1EEA1 && codePoint <= 0x1EEA3) { // ARABIC MATHEMATICAL DOUBLE-STRUCK BEH .. ARABIC MATHEMATICAL DOUBLE-STRUCK DAL
        return true;
    }
    if (codePoint >= 0x1EEA5 && codePoint <= 0x1EEA9) { // ARABIC MATHEMATICAL DOUBLE-STRUCK WAW .. ARABIC MATHEMATICAL DOUBLE-STRUCK YEH
        return true;
    }
    if (codePoint >= 0x1EEAB && codePoint <= 0x1EEBB) { // ARABIC MATHEMATICAL DOUBLE-STRUCK LAM .. ARABIC MATHEMATICAL DOUBLE-STRUCK GHAIN
        return true;
    }
    if (codePoint >= 0x1FBF0 && codePoint <= 0x1FBF9) { // SEGMENTED DIGIT ZERO .. SEGMENTED DIGIT NINE
        return true;
    }
    if (codePoint >= 0x20000 && codePoint <= 0x2A6DD) { // CJK Ideograph Extension B .. CJK Ideograph Extension B
        return true;
    }
    if (codePoint >= 0x2A700 && codePoint <= 0x2B734) { // CJK Ideograph Extension C .. CJK Ideograph Extension C
        return true;
    }
    if (codePoint >= 0x2B740 && codePoint <= 0x2B81D) { // CJK Ideograph Extension D .. CJK Ideograph Extension D
        return true;
    }
    if (codePoint >= 0x2B820 && codePoint <= 0x2CEA1) { // CJK Ideograph Extension E .. CJK Ideograph Extension E
        return true;
    }
    if (codePoint >= 0x2CEB0 && codePoint <= 0x2EBE0) { // CJK Ideograph Extension F .. CJK Ideograph Extension F
        return true;
    }
    if (codePoint >= 0x2F800 && codePoint <= 0x2FA1D) { // CJK COMPATIBILITY IDEOGRAPH-2F800 .. CJK COMPATIBILITY IDEOGRAPH-2FA1D
        return true;
    }
    if (codePoint >= 0x30000 && codePoint <= 0x3134A) { // CJK Ideograph Extension G .. CJK Ideograph Extension G
        return true;
    }
    if (codePoint >= 0xE0100 && codePoint <= 0xE01EF) { // VARIATION SELECTOR-17 .. VARIATION SELECTOR-256
        return true;
    }
    return false;
}

bool
js::unicode::ChangesWhenUpperCasedSpecialCasing(char16_t ch)
{
    if (ch < 0x00DF || ch > 0xFB17) {
        return false;
    }
    if (ch <= 0x0587) {
        // U+00DF LATIN SMALL LETTER SHARP S
        // U+0149 LATIN SMALL LETTER N PRECEDED BY APOSTROPHE (LATIN SMALL LETTER APOSTROPHE N)
        // U+01F0 LATIN SMALL LETTER J WITH CARON (LATIN SMALL LETTER J HACEK)
        // U+0390 GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS (GREEK SMALL LETTER IOTA DIAERESIS TONOS)
        // U+03B0 GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS (GREEK SMALL LETTER UPSILON DIAERESIS TONOS)
        // U+0587 ARMENIAN SMALL LIGATURE ECH YIWN
        return ch == 0x00DF || ch == 0x0149 || ch == 0x01F0 || ch == 0x0390 || ch == 0x03B0 ||
               ch == 0x0587;
    }
    if (ch <= 0x1FFC) {
        // U+1E96 LATIN SMALL LETTER H WITH LINE BELOW .. U+1E9A LATIN SMALL LETTER A WITH RIGHT HALF RING
        if (ch <= 0x1E9A) {
            return ch >= 0x1E96;
        }
        if (ch < 0x1F50) {
            return false;
        }
        // U+1F50 GREEK SMALL LETTER UPSILON WITH PSILI
        // U+1F52 GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA
        // U+1F54 GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA
        // U+1F56 GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI
        // U+1F80 GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI .. U+1FAF GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
        // U+1FB2 GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI .. U+1FB4 GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
        // U+1FB6 GREEK SMALL LETTER ALPHA WITH PERISPOMENI .. U+1FB7 GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI
        // U+1FBC GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
        // U+1FC2 GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI .. U+1FC4 GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
        // U+1FC6 GREEK SMALL LETTER ETA WITH PERISPOMENI .. U+1FC7 GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI
        // U+1FCC GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
        // U+1FD2 GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA .. U+1FD3 GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
        // U+1FD6 GREEK SMALL LETTER IOTA WITH PERISPOMENI .. U+1FD7 GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI
        // U+1FE2 GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA .. U+1FE4 GREEK SMALL LETTER RHO WITH PSILI
        // U+1FE6 GREEK SMALL LETTER UPSILON WITH PERISPOMENI .. U+1FE7 GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI
        // U+1FF2 GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI .. U+1FF4 GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
        // U+1FF6 GREEK SMALL LETTER OMEGA WITH PERISPOMENI .. U+1FF7 GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI
        // U+1FFC GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
        return ch == 0x1F50 || ch == 0x1F52 || ch == 0x1F54 || ch == 0x1F56 ||
               (ch >= 0x1F80 && ch <= 0x1FAF) || (ch >= 0x1FB2 && ch <= 0x1FB4) ||
               (ch >= 0x1FB6 && ch <= 0x1FB7) || ch == 0x1FBC || (ch >= 0x1FC2 && ch <= 0x1FC4) ||
               (ch >= 0x1FC6 && ch <= 0x1FC7) || ch == 0x1FCC || (ch >= 0x1FD2 && ch <= 0x1FD3) ||
               (ch >= 0x1FD6 && ch <= 0x1FD7) || (ch >= 0x1FE2 && ch <= 0x1FE4) ||
               (ch >= 0x1FE6 && ch <= 0x1FE7) || (ch >= 0x1FF2 && ch <= 0x1FF4) ||
               (ch >= 0x1FF6 && ch <= 0x1FF7) || ch == 0x1FFC;
    }
    if (ch < 0xFB00) {
        return false;
    }
    // U+FB00 LATIN SMALL LIGATURE FF .. U+FB06 LATIN SMALL LIGATURE ST
    // U+FB13 ARMENIAN SMALL LIGATURE MEN NOW .. U+FB17 ARMENIAN SMALL LIGATURE MEN XEH
    return (ch >= 0xFB00 && ch <= 0xFB06) || (ch >= 0xFB13 && ch <= 0xFB17);
}

size_t
js::unicode::LengthUpperCaseSpecialCasing(char16_t ch)
{
    switch(ch) {
      case 0x00DF: return 2; // LATIN SMALL LETTER SHARP S
      case 0x0149: return 2; // LATIN SMALL LETTER N PRECEDED BY APOSTROPHE (LATIN SMALL LETTER APOSTROPHE N)
      case 0x01F0: return 2; // LATIN SMALL LETTER J WITH CARON (LATIN SMALL LETTER J HACEK)
      case 0x0390: return 3; // GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS (GREEK SMALL LETTER IOTA DIAERESIS TONOS)
      case 0x03B0: return 3; // GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS (GREEK SMALL LETTER UPSILON DIAERESIS TONOS)
      case 0x0587: return 2; // ARMENIAN SMALL LIGATURE ECH YIWN
      case 0x1E96: return 2; // LATIN SMALL LETTER H WITH LINE BELOW
      case 0x1E97: return 2; // LATIN SMALL LETTER T WITH DIAERESIS
      case 0x1E98: return 2; // LATIN SMALL LETTER W WITH RING ABOVE
      case 0x1E99: return 2; // LATIN SMALL LETTER Y WITH RING ABOVE
      case 0x1E9A: return 2; // LATIN SMALL LETTER A WITH RIGHT HALF RING
      case 0x1F50: return 2; // GREEK SMALL LETTER UPSILON WITH PSILI
      case 0x1F52: return 3; // GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA
      case 0x1F54: return 3; // GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA
      case 0x1F56: return 3; // GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI
      case 0x1F80: return 2; // GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI
      case 0x1F81: return 2; // GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI
      case 0x1F82: return 2; // GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI
      case 0x1F83: return 2; // GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI
      case 0x1F84: return 2; // GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI
      case 0x1F85: return 2; // GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI
      case 0x1F86: return 2; // GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
      case 0x1F87: return 2; // GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
      case 0x1F88: return 2; // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI
      case 0x1F89: return 2; // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI
      case 0x1F8A: return 2; // GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI
      case 0x1F8B: return 2; // GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI
      case 0x1F8C: return 2; // GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI
      case 0x1F8D: return 2; // GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI
      case 0x1F8E: return 2; // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
      case 0x1F8F: return 2; // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
      case 0x1F90: return 2; // GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI
      case 0x1F91: return 2; // GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI
      case 0x1F92: return 2; // GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI
      case 0x1F93: return 2; // GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI
      case 0x1F94: return 2; // GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI
      case 0x1F95: return 2; // GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI
      case 0x1F96: return 2; // GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
      case 0x1F97: return 2; // GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
      case 0x1F98: return 2; // GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI
      case 0x1F99: return 2; // GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI
      case 0x1F9A: return 2; // GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI
      case 0x1F9B: return 2; // GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI
      case 0x1F9C: return 2; // GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI
      case 0x1F9D: return 2; // GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI
      case 0x1F9E: return 2; // GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
      case 0x1F9F: return 2; // GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
      case 0x1FA0: return 2; // GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI
      case 0x1FA1: return 2; // GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI
      case 0x1FA2: return 2; // GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI
      case 0x1FA3: return 2; // GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI
      case 0x1FA4: return 2; // GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI
      case 0x1FA5: return 2; // GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI
      case 0x1FA6: return 2; // GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
      case 0x1FA7: return 2; // GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
      case 0x1FA8: return 2; // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI
      case 0x1FA9: return 2; // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI
      case 0x1FAA: return 2; // GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI
      case 0x1FAB: return 2; // GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI
      case 0x1FAC: return 2; // GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI
      case 0x1FAD: return 2; // GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI
      case 0x1FAE: return 2; // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
      case 0x1FAF: return 2; // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
      case 0x1FB2: return 2; // GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI
      case 0x1FB3: return 2; // GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI
      case 0x1FB4: return 2; // GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
      case 0x1FB6: return 2; // GREEK SMALL LETTER ALPHA WITH PERISPOMENI
      case 0x1FB7: return 3; // GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI
      case 0x1FBC: return 2; // GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
      case 0x1FC2: return 2; // GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI
      case 0x1FC3: return 2; // GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI
      case 0x1FC4: return 2; // GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
      case 0x1FC6: return 2; // GREEK SMALL LETTER ETA WITH PERISPOMENI
      case 0x1FC7: return 3; // GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI
      case 0x1FCC: return 2; // GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
      case 0x1FD2: return 3; // GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA
      case 0x1FD3: return 3; // GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
      case 0x1FD6: return 2; // GREEK SMALL LETTER IOTA WITH PERISPOMENI
      case 0x1FD7: return 3; // GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI
      case 0x1FE2: return 3; // GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA
      case 0x1FE3: return 3; // GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA
      case 0x1FE4: return 2; // GREEK SMALL LETTER RHO WITH PSILI
      case 0x1FE6: return 2; // GREEK SMALL LETTER UPSILON WITH PERISPOMENI
      case 0x1FE7: return 3; // GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI
      case 0x1FF2: return 2; // GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI
      case 0x1FF3: return 2; // GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI
      case 0x1FF4: return 2; // GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
      case 0x1FF6: return 2; // GREEK SMALL LETTER OMEGA WITH PERISPOMENI
      case 0x1FF7: return 3; // GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI
      case 0x1FFC: return 2; // GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
      case 0xFB00: return 2; // LATIN SMALL LIGATURE FF
      case 0xFB01: return 2; // LATIN SMALL LIGATURE FI
      case 0xFB02: return 2; // LATIN SMALL LIGATURE FL
      case 0xFB03: return 3; // LATIN SMALL LIGATURE FFI
      case 0xFB04: return 3; // LATIN SMALL LIGATURE FFL
      case 0xFB05: return 2; // LATIN SMALL LIGATURE LONG S T
      case 0xFB06: return 2; // LATIN SMALL LIGATURE ST
      case 0xFB13: return 2; // ARMENIAN SMALL LIGATURE MEN NOW
      case 0xFB14: return 2; // ARMENIAN SMALL LIGATURE MEN ECH
      case 0xFB15: return 2; // ARMENIAN SMALL LIGATURE MEN INI
      case 0xFB16: return 2; // ARMENIAN SMALL LIGATURE VEW NOW
      case 0xFB17: return 2; // ARMENIAN SMALL LIGATURE MEN XEH
    }

    MOZ_ASSERT_UNREACHABLE("Bad character input.");
    return 0;
}

void
js::unicode::AppendUpperCaseSpecialCasing(char16_t ch, char16_t* elements, size_t* index)
{
    switch(ch) {
      case 0x00DF: // LATIN SMALL LETTER SHARP S
        elements[(*index)++] = 0x0053; // LATIN CAPITAL LETTER S
        elements[(*index)++] = 0x0053; // LATIN CAPITAL LETTER S
        return;
      case 0x0149: // LATIN SMALL LETTER N PRECEDED BY APOSTROPHE (LATIN SMALL LETTER APOSTROPHE N)
        elements[(*index)++] = 0x02BC; // MODIFIER LETTER APOSTROPHE
        elements[(*index)++] = 0x004E; // LATIN CAPITAL LETTER N
        return;
      case 0x01F0: // LATIN SMALL LETTER J WITH CARON (LATIN SMALL LETTER J HACEK)
        elements[(*index)++] = 0x004A; // LATIN CAPITAL LETTER J
        elements[(*index)++] = 0x030C; // COMBINING CARON (NON-SPACING HACEK)
        return;
      case 0x0390: // GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS (GREEK SMALL LETTER IOTA DIAERESIS TONOS)
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        elements[(*index)++] = 0x0308; // COMBINING DIAERESIS (NON-SPACING DIAERESIS)
        elements[(*index)++] = 0x0301; // COMBINING ACUTE ACCENT (NON-SPACING ACUTE)
        return;
      case 0x03B0: // GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS (GREEK SMALL LETTER UPSILON DIAERESIS TONOS)
        elements[(*index)++] = 0x03A5; // GREEK CAPITAL LETTER UPSILON
        elements[(*index)++] = 0x0308; // COMBINING DIAERESIS (NON-SPACING DIAERESIS)
        elements[(*index)++] = 0x0301; // COMBINING ACUTE ACCENT (NON-SPACING ACUTE)
        return;
      case 0x0587: // ARMENIAN SMALL LIGATURE ECH YIWN
        elements[(*index)++] = 0x0535; // ARMENIAN CAPITAL LETTER ECH
        elements[(*index)++] = 0x0552; // ARMENIAN CAPITAL LETTER YIWN
        return;
      case 0x1E96: // LATIN SMALL LETTER H WITH LINE BELOW
        elements[(*index)++] = 0x0048; // LATIN CAPITAL LETTER H
        elements[(*index)++] = 0x0331; // COMBINING MACRON BELOW (NON-SPACING MACRON BELOW)
        return;
      case 0x1E97: // LATIN SMALL LETTER T WITH DIAERESIS
        elements[(*index)++] = 0x0054; // LATIN CAPITAL LETTER T
        elements[(*index)++] = 0x0308; // COMBINING DIAERESIS (NON-SPACING DIAERESIS)
        return;
      case 0x1E98: // LATIN SMALL LETTER W WITH RING ABOVE
        elements[(*index)++] = 0x0057; // LATIN CAPITAL LETTER W
        elements[(*index)++] = 0x030A; // COMBINING RING ABOVE (NON-SPACING RING ABOVE)
        return;
      case 0x1E99: // LATIN SMALL LETTER Y WITH RING ABOVE
        elements[(*index)++] = 0x0059; // LATIN CAPITAL LETTER Y
        elements[(*index)++] = 0x030A; // COMBINING RING ABOVE (NON-SPACING RING ABOVE)
        return;
      case 0x1E9A: // LATIN SMALL LETTER A WITH RIGHT HALF RING
        elements[(*index)++] = 0x0041; // LATIN CAPITAL LETTER A
        elements[(*index)++] = 0x02BE; // MODIFIER LETTER RIGHT HALF RING
        return;
      case 0x1F50: // GREEK SMALL LETTER UPSILON WITH PSILI
        elements[(*index)++] = 0x03A5; // GREEK CAPITAL LETTER UPSILON
        elements[(*index)++] = 0x0313; // COMBINING COMMA ABOVE (NON-SPACING COMMA ABOVE)
        return;
      case 0x1F52: // GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA
        elements[(*index)++] = 0x03A5; // GREEK CAPITAL LETTER UPSILON
        elements[(*index)++] = 0x0313; // COMBINING COMMA ABOVE (NON-SPACING COMMA ABOVE)
        elements[(*index)++] = 0x0300; // COMBINING GRAVE ACCENT (NON-SPACING GRAVE)
        return;
      case 0x1F54: // GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA
        elements[(*index)++] = 0x03A5; // GREEK CAPITAL LETTER UPSILON
        elements[(*index)++] = 0x0313; // COMBINING COMMA ABOVE (NON-SPACING COMMA ABOVE)
        elements[(*index)++] = 0x0301; // COMBINING ACUTE ACCENT (NON-SPACING ACUTE)
        return;
      case 0x1F56: // GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI
        elements[(*index)++] = 0x03A5; // GREEK CAPITAL LETTER UPSILON
        elements[(*index)++] = 0x0313; // COMBINING COMMA ABOVE (NON-SPACING COMMA ABOVE)
        elements[(*index)++] = 0x0342; // COMBINING GREEK PERISPOMENI
        return;
      case 0x1F80: // GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F08; // GREEK CAPITAL LETTER ALPHA WITH PSILI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F81: // GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F09; // GREEK CAPITAL LETTER ALPHA WITH DASIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F82: // GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F0A; // GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F83: // GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F0B; // GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F84: // GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F0C; // GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F85: // GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F0D; // GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F86: // GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F0E; // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F87: // GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F0F; // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F88: // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F08; // GREEK CAPITAL LETTER ALPHA WITH PSILI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F89: // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F09; // GREEK CAPITAL LETTER ALPHA WITH DASIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F8A: // GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F0A; // GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F8B: // GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F0B; // GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F8C: // GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F0C; // GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F8D: // GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F0D; // GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F8E: // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F0E; // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F8F: // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F0F; // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F90: // GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F28; // GREEK CAPITAL LETTER ETA WITH PSILI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F91: // GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F29; // GREEK CAPITAL LETTER ETA WITH DASIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F92: // GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F2A; // GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F93: // GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F2B; // GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F94: // GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F2C; // GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F95: // GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F2D; // GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F96: // GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F2E; // GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F97: // GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F2F; // GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F98: // GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F28; // GREEK CAPITAL LETTER ETA WITH PSILI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F99: // GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F29; // GREEK CAPITAL LETTER ETA WITH DASIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F9A: // GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F2A; // GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F9B: // GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F2B; // GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F9C: // GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F2C; // GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F9D: // GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F2D; // GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F9E: // GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F2E; // GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1F9F: // GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F2F; // GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FA0: // GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F68; // GREEK CAPITAL LETTER OMEGA WITH PSILI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FA1: // GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F69; // GREEK CAPITAL LETTER OMEGA WITH DASIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FA2: // GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F6A; // GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FA3: // GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F6B; // GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FA4: // GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F6C; // GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FA5: // GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F6D; // GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FA6: // GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F6E; // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FA7: // GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1F6F; // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FA8: // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F68; // GREEK CAPITAL LETTER OMEGA WITH PSILI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FA9: // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F69; // GREEK CAPITAL LETTER OMEGA WITH DASIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FAA: // GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F6A; // GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FAB: // GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F6B; // GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FAC: // GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F6C; // GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FAD: // GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F6D; // GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FAE: // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F6E; // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FAF: // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
        elements[(*index)++] = 0x1F6F; // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FB2: // GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1FBA; // GREEK CAPITAL LETTER ALPHA WITH VARIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FB3: // GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI
        elements[(*index)++] = 0x0391; // GREEK CAPITAL LETTER ALPHA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FB4: // GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
        elements[(*index)++] = 0x0386; // GREEK CAPITAL LETTER ALPHA WITH TONOS (GREEK CAPITAL LETTER ALPHA TONOS)
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FB6: // GREEK SMALL LETTER ALPHA WITH PERISPOMENI
        elements[(*index)++] = 0x0391; // GREEK CAPITAL LETTER ALPHA
        elements[(*index)++] = 0x0342; // COMBINING GREEK PERISPOMENI
        return;
      case 0x1FB7: // GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI
        elements[(*index)++] = 0x0391; // GREEK CAPITAL LETTER ALPHA
        elements[(*index)++] = 0x0342; // COMBINING GREEK PERISPOMENI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FBC: // GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
        elements[(*index)++] = 0x0391; // GREEK CAPITAL LETTER ALPHA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FC2: // GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1FCA; // GREEK CAPITAL LETTER ETA WITH VARIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FC3: // GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI
        elements[(*index)++] = 0x0397; // GREEK CAPITAL LETTER ETA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FC4: // GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
        elements[(*index)++] = 0x0389; // GREEK CAPITAL LETTER ETA WITH TONOS (GREEK CAPITAL LETTER ETA TONOS)
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FC6: // GREEK SMALL LETTER ETA WITH PERISPOMENI
        elements[(*index)++] = 0x0397; // GREEK CAPITAL LETTER ETA
        elements[(*index)++] = 0x0342; // COMBINING GREEK PERISPOMENI
        return;
      case 0x1FC7: // GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI
        elements[(*index)++] = 0x0397; // GREEK CAPITAL LETTER ETA
        elements[(*index)++] = 0x0342; // COMBINING GREEK PERISPOMENI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FCC: // GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
        elements[(*index)++] = 0x0397; // GREEK CAPITAL LETTER ETA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FD2: // GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        elements[(*index)++] = 0x0308; // COMBINING DIAERESIS (NON-SPACING DIAERESIS)
        elements[(*index)++] = 0x0300; // COMBINING GRAVE ACCENT (NON-SPACING GRAVE)
        return;
      case 0x1FD3: // GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        elements[(*index)++] = 0x0308; // COMBINING DIAERESIS (NON-SPACING DIAERESIS)
        elements[(*index)++] = 0x0301; // COMBINING ACUTE ACCENT (NON-SPACING ACUTE)
        return;
      case 0x1FD6: // GREEK SMALL LETTER IOTA WITH PERISPOMENI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        elements[(*index)++] = 0x0342; // COMBINING GREEK PERISPOMENI
        return;
      case 0x1FD7: // GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        elements[(*index)++] = 0x0308; // COMBINING DIAERESIS (NON-SPACING DIAERESIS)
        elements[(*index)++] = 0x0342; // COMBINING GREEK PERISPOMENI
        return;
      case 0x1FE2: // GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA
        elements[(*index)++] = 0x03A5; // GREEK CAPITAL LETTER UPSILON
        elements[(*index)++] = 0x0308; // COMBINING DIAERESIS (NON-SPACING DIAERESIS)
        elements[(*index)++] = 0x0300; // COMBINING GRAVE ACCENT (NON-SPACING GRAVE)
        return;
      case 0x1FE3: // GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA
        elements[(*index)++] = 0x03A5; // GREEK CAPITAL LETTER UPSILON
        elements[(*index)++] = 0x0308; // COMBINING DIAERESIS (NON-SPACING DIAERESIS)
        elements[(*index)++] = 0x0301; // COMBINING ACUTE ACCENT (NON-SPACING ACUTE)
        return;
      case 0x1FE4: // GREEK SMALL LETTER RHO WITH PSILI
        elements[(*index)++] = 0x03A1; // GREEK CAPITAL LETTER RHO
        elements[(*index)++] = 0x0313; // COMBINING COMMA ABOVE (NON-SPACING COMMA ABOVE)
        return;
      case 0x1FE6: // GREEK SMALL LETTER UPSILON WITH PERISPOMENI
        elements[(*index)++] = 0x03A5; // GREEK CAPITAL LETTER UPSILON
        elements[(*index)++] = 0x0342; // COMBINING GREEK PERISPOMENI
        return;
      case 0x1FE7: // GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI
        elements[(*index)++] = 0x03A5; // GREEK CAPITAL LETTER UPSILON
        elements[(*index)++] = 0x0308; // COMBINING DIAERESIS (NON-SPACING DIAERESIS)
        elements[(*index)++] = 0x0342; // COMBINING GREEK PERISPOMENI
        return;
      case 0x1FF2: // GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI
        elements[(*index)++] = 0x1FFA; // GREEK CAPITAL LETTER OMEGA WITH VARIA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FF3: // GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI
        elements[(*index)++] = 0x03A9; // GREEK CAPITAL LETTER OMEGA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FF4: // GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
        elements[(*index)++] = 0x038F; // GREEK CAPITAL LETTER OMEGA WITH TONOS (GREEK CAPITAL LETTER OMEGA TONOS)
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FF6: // GREEK SMALL LETTER OMEGA WITH PERISPOMENI
        elements[(*index)++] = 0x03A9; // GREEK CAPITAL LETTER OMEGA
        elements[(*index)++] = 0x0342; // COMBINING GREEK PERISPOMENI
        return;
      case 0x1FF7: // GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI
        elements[(*index)++] = 0x03A9; // GREEK CAPITAL LETTER OMEGA
        elements[(*index)++] = 0x0342; // COMBINING GREEK PERISPOMENI
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0x1FFC: // GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
        elements[(*index)++] = 0x03A9; // GREEK CAPITAL LETTER OMEGA
        elements[(*index)++] = 0x0399; // GREEK CAPITAL LETTER IOTA
        return;
      case 0xFB00: // LATIN SMALL LIGATURE FF
        elements[(*index)++] = 0x0046; // LATIN CAPITAL LETTER F
        elements[(*index)++] = 0x0046; // LATIN CAPITAL LETTER F
        return;
      case 0xFB01: // LATIN SMALL LIGATURE FI
        elements[(*index)++] = 0x0046; // LATIN CAPITAL LETTER F
        elements[(*index)++] = 0x0049; // LATIN CAPITAL LETTER I
        return;
      case 0xFB02: // LATIN SMALL LIGATURE FL
        elements[(*index)++] = 0x0046; // LATIN CAPITAL LETTER F
        elements[(*index)++] = 0x004C; // LATIN CAPITAL LETTER L
        return;
      case 0xFB03: // LATIN SMALL LIGATURE FFI
        elements[(*index)++] = 0x0046; // LATIN CAPITAL LETTER F
        elements[(*index)++] = 0x0046; // LATIN CAPITAL LETTER F
        elements[(*index)++] = 0x0049; // LATIN CAPITAL LETTER I
        return;
      case 0xFB04: // LATIN SMALL LIGATURE FFL
        elements[(*index)++] = 0x0046; // LATIN CAPITAL LETTER F
        elements[(*index)++] = 0x0046; // LATIN CAPITAL LETTER F
        elements[(*index)++] = 0x004C; // LATIN CAPITAL LETTER L
        return;
      case 0xFB05: // LATIN SMALL LIGATURE LONG S T
        elements[(*index)++] = 0x0053; // LATIN CAPITAL LETTER S
        elements[(*index)++] = 0x0054; // LATIN CAPITAL LETTER T
        return;
      case 0xFB06: // LATIN SMALL LIGATURE ST
        elements[(*index)++] = 0x0053; // LATIN CAPITAL LETTER S
        elements[(*index)++] = 0x0054; // LATIN CAPITAL LETTER T
        return;
      case 0xFB13: // ARMENIAN SMALL LIGATURE MEN NOW
        elements[(*index)++] = 0x0544; // ARMENIAN CAPITAL LETTER MEN
        elements[(*index)++] = 0x0546; // ARMENIAN CAPITAL LETTER NOW
        return;
      case 0xFB14: // ARMENIAN SMALL LIGATURE MEN ECH
        elements[(*index)++] = 0x0544; // ARMENIAN CAPITAL LETTER MEN
        elements[(*index)++] = 0x0535; // ARMENIAN CAPITAL LETTER ECH
        return;
      case 0xFB15: // ARMENIAN SMALL LIGATURE MEN INI
        elements[(*index)++] = 0x0544; // ARMENIAN CAPITAL LETTER MEN
        elements[(*index)++] = 0x053B; // ARMENIAN CAPITAL LETTER INI
        return;
      case 0xFB16: // ARMENIAN SMALL LIGATURE VEW NOW
        elements[(*index)++] = 0x054E; // ARMENIAN CAPITAL LETTER VEW
        elements[(*index)++] = 0x0546; // ARMENIAN CAPITAL LETTER NOW
        return;
      case 0xFB17: // ARMENIAN SMALL LIGATURE MEN XEH
        elements[(*index)++] = 0x0544; // ARMENIAN CAPITAL LETTER MEN
        elements[(*index)++] = 0x053D; // ARMENIAN CAPITAL LETTER XEH
        return;
    }

    MOZ_ASSERT_UNREACHABLE("Bad character input.");
}

#define ____ false

/*
 * Identifier start chars:
 * -      36:    $
 * -  65..90: A..Z
 * -      95:    _
 * - 97..122: a..z
 */
const bool unicode::js_isidstart[] = {
/*       0     1     2     3     4     5     6     7     8     9  */
/*  0 */ ____, ____, ____, ____, ____, ____, ____, ____, ____, ____,
/*  1 */ ____, ____, ____, ____, ____, ____, ____, ____, ____, ____,
/*  2 */ ____, ____, ____, ____, ____, ____, ____, ____, ____, ____,
/*  3 */ ____, ____, ____, ____, ____, ____, true, ____, ____, ____,
/*  4 */ ____, ____, ____, ____, ____, ____, ____, ____, ____, ____,
/*  5 */ ____, ____, ____, ____, ____, ____, ____, ____, ____, ____,
/*  6 */ ____, ____, ____, ____, ____, true, true, true, true, true,
/*  7 */ true, true, true, true, true, true, true, true, true, true,
/*  8 */ true, true, true, true, true, true, true, true, true, true,
/*  9 */ true, ____, ____, ____, ____, true, ____, true, true, true,
/* 10 */ true, true, true, true, true, true, true, true, true, true,
/* 11 */ true, true, true, true, true, true, true, true, true, true,
/* 12 */ true, true, true, ____, ____, ____, ____, ____,
};

/*
 * Identifier chars:
 * -      36:    $
 * -  48..57: 0..9
 * -  65..90: A..Z
 * -      95:    _
 * - 97..122: a..z
 */
const bool unicode::js_isident[] = {
/*       0     1     2     3     4     5     6     7     8     9  */
/*  0 */ ____, ____, ____, ____, ____, ____, ____, ____, ____, ____,
/*  1 */ ____, ____, ____, ____, ____, ____, ____, ____, ____, ____,
/*  2 */ ____, ____, ____, ____, ____, ____, ____, ____, ____, ____,
/*  3 */ ____, ____, ____, ____, ____, ____, true, ____, ____, ____,
/*  4 */ ____, ____, ____, ____, ____, ____, ____, ____, true, true,
/*  5 */ true, true, true, true, true, true, true, true, ____, ____,
/*  6 */ ____, ____, ____, ____, ____, true, true, true, true, true,
/*  7 */ true, true, true, true, true, true, true, true, true, true,
/*  8 */ true, true, true, true, true, true, true, true, true, true,
/*  9 */ true, ____, ____, ____, ____, true, ____, true, true, true,
/* 10 */ true, true, true, true, true, true, true, true, true, true,
/* 11 */ true, true, true, true, true, true, true, true, true, true,
/* 12 */ true, true, true, ____, ____, ____, ____, ____,
};

/* Whitespace chars: '\t', '\n', '\v', '\f', '\r', ' '. */
const bool unicode::js_isspace[] = {
/*       0     1     2     3     4     5     6     7     8     9  */
/*  0 */ ____, ____, ____, ____, ____, ____, ____, ____, ____, true,
/*  1 */ true, true, true, true, ____, ____, ____, ____, ____, ____,
/*  2 */ ____, ____, ____, ____, ____, ____, ____, ____, ____, ____,
/*  3 */ ____, ____, true, ____, ____, ____, ____, ____, ____, ____,
/*  4 */ ____, ____, ____, ____, ____, ____, ____, ____, ____, ____,
/*  5 */ ____, ____, ____, ____, ____, ____, ____, ____, ____, ____,
/*  6 */ ____, ____, ____, ____, ____, ____, ____, ____, ____, ____,
/*  7 */ ____, ____, ____, ____, ____, ____, ____, ____, ____, ____,
/*  8 */ ____, ____, ____, ____, ____, ____, ____, ____, ____, ____,
/*  9 */ ____, ____, ____, ____, ____, ____, ____, ____, ____, ____,
/* 10 */ ____, ____, ____, ____, ____, ____, ____, ____, ____, ____,
/* 11 */ ____, ____, ____, ____, ____, ____, ____, ____, ____, ____,
/* 12 */ ____, ____, ____, ____, ____, ____, ____, ____,
};

#undef ____

const JS::Latin1Char unicode::latin1ToLowerCaseTable[] = {
/*       0     1     2     3     4     5     6     7     8     9     10    11    12    13    14    15  */
/*  0 */ 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
/*  1 */ 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
/*  2 */ 0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
/*  3 */ 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
/*  4 */ 0x40, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
/*  5 */ 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
/*  6 */ 0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
/*  7 */ 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F,
/*  8 */ 0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F,
/*  9 */ 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F,
/* 10 */ 0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF,
/* 11 */ 0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF,
/* 12 */ 0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
/* 13 */ 0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xD7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xDF,
/* 14 */ 0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
/* 15 */ 0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF,
};
