/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_a11y_RootAccessibleWrap_h__
#define mozilla_a11y_RootAccessibleWrap_h__

#include "RootAccessible.h"

namespace mozilla {

class PresShell;

namespace a11y {

/**
 * Android specific functionality for the node at a root of the accessibility
 * tree: see the RootAccessible superclass for further details.
 */
class RootAccessibleWrap : public RootAccessible {
 public:
  RootAccessibleWrap(dom::Document* aDocument, PresShell* aPresShell);
  virtual ~RootAccessibleWrap();

  // nsIDOMEventListener
  NS_DECL_NSIDOMEVENTLISTENER

 protected:
  virtual nsresult AddEventListeners() override;
  virtual nsresult RemoveEventListeners() override;
};

}  // namespace a11y
}  // namespace mozilla

#endif
